/* Dialogs.c generated by valac 0.56.17, the Vala compiler
 * generated from Dialogs.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* namespace for future migration of AppWindow alert and other question dialogs into single*/
/* place: https://bugzilla.gnome.org/show_bug.cgi?id=717659*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <config.h>

#define RESOURCES_DELETE_TAG_TITLE _ ("Delete Tag")
#define RESOURCES_DELETE_SAVED_SEARCH_DIALOG_TITLE _ ("Delete Search")
#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#define RESOURCES_DELETE_FACE_TITLE _ ("Delete Face")
#define RESOURCES_SAVE_LABEL _ ("_Save")
#define RESOURCES_OK_LABEL _ ("_OK")
#define IMPORT_UI_REPORT_FAILURE_COUNT 4
#define IMPORT_UI_SAVE_RESULTS_BUTTON_NAME _ ("Save Details…")
#define IMPORT_UI_SAVE_RESULTS_FILE_CHOOSER_TITLE _ ("Save Details")
#define IMPORT_UI_SAVE_RESULTS_RESPONSE_ID 1024
#define RESOURCES_APP_VERSION _VERSION
#define RESOURCES_SAVE_AS_LABEL _ ("Save _As")
#define MAX_OBJECTS_DISPLAYED 3
#define RESOURCES_ADD_TAGS_TITLE NC_ ("Dialog Title", "Add Tags")
#define TAG_PATH_SEPARATOR_STRING "/"
#define RESOURCES_MODIFY_TAGS_LABEL _ ("Modify Tags")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SAVED_SEARCH (saved_search_get_type ())
#define SAVED_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH, SavedSearch))
#define SAVED_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH, SavedSearchClass))
#define IS_SAVED_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH))
#define IS_SAVED_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH))
#define SAVED_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH, SavedSearchClass))

typedef struct _SavedSearch SavedSearch;
typedef struct _SavedSearchClass SavedSearchClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FACE (face_get_type ())
#define FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE, Face))
#define FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE, FaceClass))
#define IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE))
#define IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE))
#define FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE, FaceClass))

typedef struct _Face Face;
typedef struct _FaceClass FaceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_BATCH_IMPORT_RESULT (batch_import_result_get_type ())
#define BATCH_IMPORT_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BATCH_IMPORT_RESULT, BatchImportResult))
#define BATCH_IMPORT_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BATCH_IMPORT_RESULT, BatchImportResultClass))
#define IS_BATCH_IMPORT_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BATCH_IMPORT_RESULT))
#define IS_BATCH_IMPORT_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BATCH_IMPORT_RESULT))
#define BATCH_IMPORT_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BATCH_IMPORT_RESULT, BatchImportResultClass))

typedef struct _BatchImportResult BatchImportResult;
typedef struct _BatchImportResultClass BatchImportResultClass;
typedef struct _BatchImportResultPrivate BatchImportResultPrivate;

#define TYPE_BATCH_IMPORT_JOB (batch_import_job_get_type ())
#define BATCH_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BATCH_IMPORT_JOB, BatchImportJob))
#define BATCH_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BATCH_IMPORT_JOB, BatchImportJobClass))
#define IS_BATCH_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BATCH_IMPORT_JOB))
#define IS_BATCH_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BATCH_IMPORT_JOB))
#define BATCH_IMPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BATCH_IMPORT_JOB, BatchImportJobClass))

typedef struct _BatchImportJob BatchImportJob;
typedef struct _BatchImportJobClass BatchImportJobClass;
typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

#define TYPE_IMPORT_RESULT (import_result_get_type ())

#define TYPE_DUPLICATED_FILE (duplicated_file_get_type ())
#define DUPLICATED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICATED_FILE, DuplicatedFile))
#define DUPLICATED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICATED_FILE, DuplicatedFileClass))
#define IS_DUPLICATED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICATED_FILE))
#define IS_DUPLICATED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICATED_FILE))
#define DUPLICATED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICATED_FILE, DuplicatedFileClass))

typedef struct _DuplicatedFile DuplicatedFile;
typedef struct _DuplicatedFileClass DuplicatedFileClass;
#define _batch_import_result_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_result_unref (var), NULL)))

#define IMPORT_UI_TYPE_QUESTION_PARAMS (import_ui_question_params_get_type ())
#define IMPORT_UI_QUESTION_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IMPORT_UI_TYPE_QUESTION_PARAMS, ImportUIQuestionParams))
#define IMPORT_UI_QUESTION_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IMPORT_UI_TYPE_QUESTION_PARAMS, ImportUIQuestionParamsClass))
#define IMPORT_UI_IS_QUESTION_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IMPORT_UI_TYPE_QUESTION_PARAMS))
#define IMPORT_UI_IS_QUESTION_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IMPORT_UI_TYPE_QUESTION_PARAMS))
#define IMPORT_UI_QUESTION_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IMPORT_UI_TYPE_QUESTION_PARAMS, ImportUIQuestionParamsClass))

typedef struct _ImportUIQuestionParams ImportUIQuestionParams;
typedef struct _ImportUIQuestionParamsClass ImportUIQuestionParamsClass;
typedef struct _ImportUIQuestionParamsPrivate ImportUIQuestionParamsPrivate;
typedef struct _ImportUIParamSpecQuestionParams ImportUIParamSpecQuestionParams;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_IMPORT_MANIFEST (import_manifest_get_type ())
#define IMPORT_MANIFEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_MANIFEST, ImportManifest))
#define IMPORT_MANIFEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_MANIFEST, ImportManifestClass))
#define IS_IMPORT_MANIFEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_MANIFEST))
#define IS_IMPORT_MANIFEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_MANIFEST))
#define IMPORT_MANIFEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_MANIFEST, ImportManifestClass))

typedef struct _ImportManifest ImportManifest;
typedef struct _ImportManifestClass ImportManifestClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _ImportManifestPrivate ImportManifestPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TEXT_ENTRY_DIALOG_MEDIATOR (text_entry_dialog_mediator_get_type ())
#define TEXT_ENTRY_DIALOG_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediator))
#define TEXT_ENTRY_DIALOG_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediatorClass))
#define IS_TEXT_ENTRY_DIALOG_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_ENTRY_DIALOG_MEDIATOR))
#define IS_TEXT_ENTRY_DIALOG_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_ENTRY_DIALOG_MEDIATOR))
#define TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediatorClass))

typedef struct _TextEntryDialogMediator TextEntryDialogMediator;
typedef struct _TextEntryDialogMediatorClass TextEntryDialogMediatorClass;
typedef struct _TextEntryDialogMediatorPrivate TextEntryDialogMediatorPrivate;

#define TYPE_TEXT_ENTRY_DIALOG (text_entry_dialog_get_type ())
#define TEXT_ENTRY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_ENTRY_DIALOG, TextEntryDialog))
#define TEXT_ENTRY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_ENTRY_DIALOG, TextEntryDialogClass))
#define IS_TEXT_ENTRY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_ENTRY_DIALOG))
#define IS_TEXT_ENTRY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_ENTRY_DIALOG))
#define TEXT_ENTRY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_ENTRY_DIALOG, TextEntryDialogClass))

typedef struct _TextEntryDialog TextEntryDialog;
typedef struct _TextEntryDialogClass TextEntryDialogClass;
typedef gboolean (*TextEntryDialogOnModifyValidateType) (const gchar* text, gpointer user_data);
typedef struct _ParamSpecTextEntryDialogMediator ParamSpecTextEntryDialogMediator;

#define TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR (multi_text_entry_dialog_mediator_get_type ())
#define MULTI_TEXT_ENTRY_DIALOG_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR, MultiTextEntryDialogMediator))
#define MULTI_TEXT_ENTRY_DIALOG_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR, MultiTextEntryDialogMediatorClass))
#define IS_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR))
#define IS_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR))
#define MULTI_TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR, MultiTextEntryDialogMediatorClass))

typedef struct _MultiTextEntryDialogMediator MultiTextEntryDialogMediator;
typedef struct _MultiTextEntryDialogMediatorClass MultiTextEntryDialogMediatorClass;
typedef struct _MultiTextEntryDialogMediatorPrivate MultiTextEntryDialogMediatorPrivate;

#define TYPE_MULTI_TEXT_ENTRY_DIALOG (multi_text_entry_dialog_get_type ())
#define MULTI_TEXT_ENTRY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_TEXT_ENTRY_DIALOG, MultiTextEntryDialog))
#define MULTI_TEXT_ENTRY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_TEXT_ENTRY_DIALOG, MultiTextEntryDialogClass))
#define IS_MULTI_TEXT_ENTRY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_TEXT_ENTRY_DIALOG))
#define IS_MULTI_TEXT_ENTRY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_TEXT_ENTRY_DIALOG))
#define MULTI_TEXT_ENTRY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_TEXT_ENTRY_DIALOG, MultiTextEntryDialogClass))

typedef struct _MultiTextEntryDialog MultiTextEntryDialog;
typedef struct _MultiTextEntryDialogClass MultiTextEntryDialogClass;
typedef gboolean (*MultiTextEntryDialogOnModifyValidateType) (const gchar* text, gpointer user_data);
typedef struct _ParamSpecMultiTextEntryDialogMediator ParamSpecMultiTextEntryDialogMediator;

#define TYPE_EVENT_RENAME_DIALOG (event_rename_dialog_get_type ())
#define EVENT_RENAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_RENAME_DIALOG, EventRenameDialog))
#define EVENT_RENAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_RENAME_DIALOG, EventRenameDialogClass))
#define IS_EVENT_RENAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_RENAME_DIALOG))
#define IS_EVENT_RENAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_RENAME_DIALOG))
#define EVENT_RENAME_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_RENAME_DIALOG, EventRenameDialogClass))

typedef struct _EventRenameDialog EventRenameDialog;
typedef struct _EventRenameDialogClass EventRenameDialogClass;
typedef struct _EventRenameDialogPrivate EventRenameDialogPrivate;

#define TYPE_EDIT_TITLE_DIALOG (edit_title_dialog_get_type ())
#define EDIT_TITLE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDIT_TITLE_DIALOG, EditTitleDialog))
#define EDIT_TITLE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDIT_TITLE_DIALOG, EditTitleDialogClass))
#define IS_EDIT_TITLE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDIT_TITLE_DIALOG))
#define IS_EDIT_TITLE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDIT_TITLE_DIALOG))
#define EDIT_TITLE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDIT_TITLE_DIALOG, EditTitleDialogClass))

typedef struct _EditTitleDialog EditTitleDialog;
typedef struct _EditTitleDialogClass EditTitleDialogClass;
typedef struct _EditTitleDialogPrivate EditTitleDialogPrivate;

#define TYPE_EDIT_COMMENT_DIALOG (edit_comment_dialog_get_type ())
#define EDIT_COMMENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDIT_COMMENT_DIALOG, EditCommentDialog))
#define EDIT_COMMENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDIT_COMMENT_DIALOG, EditCommentDialogClass))
#define IS_EDIT_COMMENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDIT_COMMENT_DIALOG))
#define IS_EDIT_COMMENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDIT_COMMENT_DIALOG))
#define EDIT_COMMENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDIT_COMMENT_DIALOG, EditCommentDialogClass))

typedef struct _EditCommentDialog EditCommentDialog;
typedef struct _EditCommentDialogClass EditCommentDialogClass;
typedef struct _EditCommentDialogPrivate EditCommentDialogPrivate;

#define TYPE_TAGS_DIALOG (tags_dialog_get_type ())
#define TAGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAGS_DIALOG, TagsDialog))
#define TAGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAGS_DIALOG, TagsDialogClass))
#define IS_TAGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAGS_DIALOG))
#define IS_TAGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAGS_DIALOG))
#define TAGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAGS_DIALOG, TagsDialogClass))

typedef struct _TagsDialog TagsDialog;
typedef struct _TagsDialogClass TagsDialogClass;
typedef struct _TagsDialogPrivate TagsDialogPrivate;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_ADD_TAGS_DIALOG (add_tags_dialog_get_type ())
#define ADD_TAGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_TAGS_DIALOG, AddTagsDialog))
#define ADD_TAGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_TAGS_DIALOG, AddTagsDialogClass))
#define IS_ADD_TAGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_TAGS_DIALOG))
#define IS_ADD_TAGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_TAGS_DIALOG))
#define ADD_TAGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_TAGS_DIALOG, AddTagsDialogClass))

typedef struct _AddTagsDialog AddTagsDialog;
typedef struct _AddTagsDialogClass AddTagsDialogClass;
typedef struct _AddTagsDialogPrivate AddTagsDialogPrivate;

#define TYPE_MODIFY_TAGS_DIALOG (modify_tags_dialog_get_type ())
#define MODIFY_TAGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFY_TAGS_DIALOG, ModifyTagsDialog))
#define MODIFY_TAGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFY_TAGS_DIALOG, ModifyTagsDialogClass))
#define IS_MODIFY_TAGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFY_TAGS_DIALOG))
#define IS_MODIFY_TAGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFY_TAGS_DIALOG))
#define MODIFY_TAGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFY_TAGS_DIALOG, ModifyTagsDialogClass))

typedef struct _ModifyTagsDialog ModifyTagsDialog;
typedef struct _ModifyTagsDialogClass ModifyTagsDialogClass;
typedef struct _ModifyTagsDialogPrivate ModifyTagsDialogPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BatchImportResult {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BatchImportResultPrivate * priv;
	BatchImportJob* job;
	GFile* file;
	gchar* src_identifier;
	gchar* dest_identifier;
	ImportResult result;
	gchar* errmsg;
	DuplicatedFile* duplicate_of;
};

struct _BatchImportResultClass {
	GTypeClass parent_class;
	void (*finalize) (BatchImportResult *self);
};

struct _ImportUIQuestionParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ImportUIQuestionParamsPrivate * priv;
	gchar* question;
	gchar* yes_button;
	gchar* no_button;
};

struct _ImportUIQuestionParamsClass {
	GTypeClass parent_class;
	void (*finalize) (ImportUIQuestionParams *self);
};

struct _ImportUIParamSpecQuestionParams {
	GParamSpec parent_instance;
};

struct _ImportManifest {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ImportManifestPrivate * priv;
	GeeList* imported;
	GeeList* success;
	GeeList* camera_failed;
	GeeList* failed;
	GeeList* write_failed;
	GeeList* skipped_photos;
	GeeList* skipped_files;
	GeeList* aborted;
	GeeList* already_imported;
	GeeList* corrupt_files;
	GeeList* all;
	GTimer* timer;
};

struct _ImportManifestClass {
	GTypeClass parent_class;
	void (*finalize) (ImportManifest *self);
};

struct _TextEntryDialogMediator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextEntryDialogMediatorPrivate * priv;
};

struct _TextEntryDialogMediatorClass {
	GTypeClass parent_class;
	void (*finalize) (TextEntryDialogMediator *self);
	gboolean (*on_modify_validate) (TextEntryDialogMediator* self, const gchar* text);
};

struct _TextEntryDialogMediatorPrivate {
	TextEntryDialog* dialog;
};

struct _ParamSpecTextEntryDialogMediator {
	GParamSpec parent_instance;
};

struct _MultiTextEntryDialogMediator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MultiTextEntryDialogMediatorPrivate * priv;
};

struct _MultiTextEntryDialogMediatorClass {
	GTypeClass parent_class;
	void (*finalize) (MultiTextEntryDialogMediator *self);
	gboolean (*on_modify_validate) (MultiTextEntryDialogMediator* self, const gchar* text);
};

struct _MultiTextEntryDialogMediatorPrivate {
	MultiTextEntryDialog* dialog;
};

struct _ParamSpecMultiTextEntryDialogMediator {
	GParamSpec parent_instance;
};

struct _EventRenameDialog {
	TextEntryDialogMediator parent_instance;
	EventRenameDialogPrivate * priv;
};

struct _EventRenameDialogClass {
	TextEntryDialogMediatorClass parent_class;
	gchar* (*execute) (EventRenameDialog* self);
};

struct _EditTitleDialog {
	TextEntryDialogMediator parent_instance;
	EditTitleDialogPrivate * priv;
};

struct _EditTitleDialogClass {
	TextEntryDialogMediatorClass parent_class;
	gchar* (*execute) (EditTitleDialog* self);
};

struct _EditCommentDialog {
	MultiTextEntryDialogMediator parent_instance;
	EditCommentDialogPrivate * priv;
};

struct _EditCommentDialogClass {
	MultiTextEntryDialogMediatorClass parent_class;
	gchar* (*execute) (EditCommentDialog* self);
};

struct _TagsDialog {
	TextEntryDialogMediator parent_instance;
	TagsDialogPrivate * priv;
};

struct _TagsDialogClass {
	TextEntryDialogMediatorClass parent_class;
};

struct _AddTagsDialog {
	TagsDialog parent_instance;
	AddTagsDialogPrivate * priv;
};

struct _AddTagsDialogClass {
	TagsDialogClass parent_class;
};

struct _ModifyTagsDialog {
	TagsDialog parent_instance;
	ModifyTagsDialogPrivate * priv;
};

struct _ModifyTagsDialogClass {
	TagsDialogClass parent_class;
};

VALA_EXTERN GFile* export_ui_current_export_dir;
GFile* export_ui_current_export_dir = NULL;
static gpointer import_ui_question_params_parent_class = NULL;
static gint TextEntryDialogMediator_private_offset;
static gpointer text_entry_dialog_mediator_parent_class = NULL;
static gint MultiTextEntryDialogMediator_private_offset;
static gpointer multi_text_entry_dialog_mediator_parent_class = NULL;
static gpointer event_rename_dialog_parent_class = NULL;
static gpointer edit_title_dialog_parent_class = NULL;
static gpointer edit_comment_dialog_parent_class = NULL;
static gpointer tags_dialog_parent_class = NULL;
static gpointer add_tags_dialog_parent_class = NULL;
static gpointer modify_tags_dialog_parent_class = NULL;
VALA_EXTERN TagSourceCollection* tag_global;
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_global;
VALA_EXTERN VideoSourceCollection* video_global;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN gboolean dialogs_confirm_delete_tag (Tag* tag);
VALA_EXTERN gint tag_get_sources_count (Tag* self);
VALA_EXTERN gchar* tag_get_user_visible_name (Tag* self);
VALA_EXTERN gboolean app_window_negate_affirm_question (const gchar* message,
                                            const gchar* negative,
                                            const gchar* affirmative,
                                            const gchar* title,
                                            GtkWindow* parent);
VALA_EXTERN GType saved_search_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SavedSearch, g_object_unref)
VALA_EXTERN gboolean dialogs_confirm_delete_saved_search (SavedSearch* search);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gboolean dialogs_confirm_warn_developer_changed (gint number);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN GType face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Face, g_object_unref)
VALA_EXTERN gboolean dialogs_confirm_delete_face (Face* face);
VALA_EXTERN gint face_get_sources_count (Face* self);
VALA_EXTERN GFile* export_ui_choose_file (const gchar* current_file_basename);
VALA_EXTERN gboolean video_reader_is_supported_video_filename (const gchar* filename);
VALA_EXTERN GFile* export_ui_choose_dir (const gchar* user_title);
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN void open_external_editor_error_dialog (GError* err,
                                        Photo* photo);
VALA_EXTERN void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN gchar* resources_launch_editor_failed (GError* err);
VALA_EXTERN GtkResponseType export_error_dialog (GFile* dest,
                                     gboolean photos_remaining);
VALA_EXTERN GtkResponseType app_window_affirm_cancel_question (const gchar* message,
                                                   const gchar* affirmative,
                                                   const gchar* title,
                                                   GtkWindow* parent);
VALA_EXTERN gpointer batch_import_result_ref (gpointer instance);
VALA_EXTERN void batch_import_result_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_batch_import_result (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_batch_import_result (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_batch_import_result (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_batch_import_result (const GValue* value);
VALA_EXTERN GType batch_import_result_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BatchImportResult, batch_import_result_unref)
VALA_EXTERN gchar* import_ui_generate_import_failure_list (GeeList* failed,
                                               gboolean show_dest_id);
VALA_EXTERN gpointer batch_import_job_ref (gpointer instance);
VALA_EXTERN void batch_import_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_batch_import_job (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_batch_import_job (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_batch_import_job (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_batch_import_job (const GValue* value);
VALA_EXTERN GType batch_import_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BatchImportJob, batch_import_job_unref)
VALA_EXTERN GType import_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType duplicated_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DuplicatedFile, g_object_unref)
VALA_EXTERN gpointer import_ui_question_params_ref (gpointer instance);
VALA_EXTERN void import_ui_question_params_unref (gpointer instance);
VALA_EXTERN GParamSpec* import_ui_param_spec_question_params (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void import_ui_value_set_question_params (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void import_ui_value_take_question_params (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer import_ui_value_get_question_params (const GValue* value);
VALA_EXTERN GType import_ui_question_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImportUIQuestionParams, import_ui_question_params_unref)
VALA_EXTERN ImportUIQuestionParams* import_ui_question_params_new (const gchar* question,
                                                       const gchar* yes_button,
                                                       const gchar* no_button);
VALA_EXTERN ImportUIQuestionParams* import_ui_question_params_construct (GType object_type,
                                                             const gchar* question,
                                                             const gchar* yes_button,
                                                             const gchar* no_button);
static void import_ui_question_params_finalize (ImportUIQuestionParams * obj);
static GType import_ui_question_params_get_type_once (void);
VALA_EXTERN gboolean import_ui_import_has_photos (GeeCollection* import_collection);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat photo_file_format_get_by_file_extension (GFile* file);
VALA_EXTERN gboolean import_ui_import_has_videos (GeeCollection* import_collection);
VALA_EXTERN gboolean video_reader_is_supported_video_file (GFile* file);
VALA_EXTERN gchar* import_ui_get_media_specific_string (GeeCollection* import_collection,
                                            const gchar* photos_msg,
                                            const gchar* videos_msg,
                                            const gchar* both_msg,
                                            const gchar* neither_msg);
VALA_EXTERN gpointer import_manifest_ref (gpointer instance);
VALA_EXTERN void import_manifest_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_import_manifest (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_import_manifest (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_import_manifest (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_import_manifest (const GValue* value);
VALA_EXTERN GType import_manifest_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImportManifest, import_manifest_unref)
VALA_EXTERN gchar* import_ui_create_result_report_from_manifest (ImportManifest* manifest);
VALA_EXTERN GFile* duplicated_file_get_file (DuplicatedFile* self);
VALA_EXTERN gboolean import_ui_report_manifest (ImportManifest* manifest,
                                    gboolean show_dest_id,
                                    ImportUIQuestionParams* question);
VALA_EXTERN void import_ui_save_import_results (GtkWindow* chooser_dialog_parent,
                                    const gchar* results_log);
VALA_EXTERN gpointer text_entry_dialog_mediator_ref (gpointer instance);
VALA_EXTERN void text_entry_dialog_mediator_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_entry_dialog_mediator (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_text_entry_dialog_mediator (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_text_entry_dialog_mediator (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_text_entry_dialog_mediator (const GValue* value);
VALA_EXTERN GType text_entry_dialog_mediator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextEntryDialogMediator, text_entry_dialog_mediator_unref)
VALA_EXTERN GType text_entry_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextEntryDialog, g_object_unref)
VALA_EXTERN gboolean text_entry_dialog_mediator_on_modify_validate (TextEntryDialogMediator* self,
                                                        const gchar* text);
VALA_EXTERN TextEntryDialogMediator* text_entry_dialog_mediator_construct (GType object_type,
                                                               const gchar* title,
                                                               const gchar* label,
                                                               const gchar* initial_text,
                                                               GeeCollection* completion_list,
                                                               const gchar* completion_delimiter);
VALA_EXTERN TextEntryDialog* text_entry_dialog_new (void);
VALA_EXTERN TextEntryDialog* text_entry_dialog_construct (GType object_type);
VALA_EXTERN void text_entry_dialog_setup (TextEntryDialog* self,
                              TextEntryDialogOnModifyValidateType modify_validate,
                              gpointer modify_validate_target,
                              const gchar* title,
                              const gchar* label,
                              const gchar* initial_text,
                              GeeCollection* completion_list,
                              const gchar* completion_delimiter);
static gboolean _text_entry_dialog_mediator_on_modify_validate_text_entry_dialog_on_modify_validate_type (const gchar* text,
                                                                                                   gpointer self);
static gboolean text_entry_dialog_mediator_real_on_modify_validate (TextEntryDialogMediator* self,
                                                             const gchar* text);
VALA_EXTERN gchar* _text_entry_dialog_mediator_execute (TextEntryDialogMediator* self);
VALA_EXTERN gchar* text_entry_dialog_execute (TextEntryDialog* self);
static void text_entry_dialog_mediator_finalize (TextEntryDialogMediator * obj);
static GType text_entry_dialog_mediator_get_type_once (void);
VALA_EXTERN gpointer multi_text_entry_dialog_mediator_ref (gpointer instance);
VALA_EXTERN void multi_text_entry_dialog_mediator_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_multi_text_entry_dialog_mediator (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags);
VALA_EXTERN void value_set_multi_text_entry_dialog_mediator (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN void value_take_multi_text_entry_dialog_mediator (GValue* value,
                                                  gpointer v_object);
VALA_EXTERN gpointer value_get_multi_text_entry_dialog_mediator (const GValue* value);
VALA_EXTERN GType multi_text_entry_dialog_mediator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MultiTextEntryDialogMediator, multi_text_entry_dialog_mediator_unref)
VALA_EXTERN GType multi_text_entry_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MultiTextEntryDialog, g_object_unref)
VALA_EXTERN gboolean multi_text_entry_dialog_mediator_on_modify_validate (MultiTextEntryDialogMediator* self,
                                                              const gchar* text);
VALA_EXTERN MultiTextEntryDialogMediator* multi_text_entry_dialog_mediator_construct (GType object_type,
                                                                          const gchar* title,
                                                                          const gchar* label,
                                                                          const gchar* initial_text);
VALA_EXTERN MultiTextEntryDialog* multi_text_entry_dialog_new (void);
VALA_EXTERN MultiTextEntryDialog* multi_text_entry_dialog_construct (GType object_type);
VALA_EXTERN void multi_text_entry_dialog_setup (MultiTextEntryDialog* self,
                                    MultiTextEntryDialogOnModifyValidateType modify_validate,
                                    gpointer modify_validate_target,
                                    const gchar* title,
                                    const gchar* label,
                                    const gchar* initial_text);
static gboolean _multi_text_entry_dialog_mediator_on_modify_validate_multi_text_entry_dialog_on_modify_validate_type (const gchar* text,
                                                                                                               gpointer self);
static gboolean multi_text_entry_dialog_mediator_real_on_modify_validate (MultiTextEntryDialogMediator* self,
                                                                   const gchar* text);
VALA_EXTERN gchar* _multi_text_entry_dialog_mediator_execute (MultiTextEntryDialogMediator* self);
VALA_EXTERN gchar* multi_text_entry_dialog_execute (MultiTextEntryDialog* self);
static void multi_text_entry_dialog_mediator_finalize (MultiTextEntryDialogMediator * obj);
static GType multi_text_entry_dialog_mediator_get_type_once (void);
VALA_EXTERN gchar* build_alert_body_text (const gchar* primary_text,
                              const gchar* secondary_text,
                              gboolean should_escape);
VALA_EXTERN gchar* guarded_markup_escape_text (const gchar* plain);
VALA_EXTERN GType event_rename_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventRenameDialog, text_entry_dialog_mediator_unref)
VALA_EXTERN gchar* event_rename_dialog_execute (EventRenameDialog* self);
VALA_EXTERN EventRenameDialog* event_rename_dialog_new (const gchar* event_name);
VALA_EXTERN EventRenameDialog* event_rename_dialog_construct (GType object_type,
                                                  const gchar* event_name);
static gchar* event_rename_dialog_real_execute (EventRenameDialog* self);
VALA_EXTERN gchar* event_prep_event_name (const gchar* name);
static GType event_rename_dialog_get_type_once (void);
VALA_EXTERN GType edit_title_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EditTitleDialog, text_entry_dialog_mediator_unref)
VALA_EXTERN gchar* edit_title_dialog_execute (EditTitleDialog* self);
VALA_EXTERN EditTitleDialog* edit_title_dialog_new (const gchar* photo_title);
VALA_EXTERN EditTitleDialog* edit_title_dialog_construct (GType object_type,
                                              const gchar* photo_title);
static gchar* edit_title_dialog_real_execute (EditTitleDialog* self);
VALA_EXTERN gchar* media_source_prep_title (const gchar* title);
static gboolean edit_title_dialog_real_on_modify_validate (TextEntryDialogMediator* base,
                                                    const gchar* text);
static GType edit_title_dialog_get_type_once (void);
VALA_EXTERN GType edit_comment_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EditCommentDialog, multi_text_entry_dialog_mediator_unref)
VALA_EXTERN gchar* edit_comment_dialog_execute (EditCommentDialog* self);
VALA_EXTERN EditCommentDialog* edit_comment_dialog_new (const gchar* comment,
                                            gboolean is_event);
VALA_EXTERN EditCommentDialog* edit_comment_dialog_construct (GType object_type,
                                                  const gchar* comment,
                                                  gboolean is_event);
static gchar* edit_comment_dialog_real_execute (EditCommentDialog* self);
VALA_EXTERN gchar* media_source_prep_comment (const gchar* comment);
static gboolean edit_comment_dialog_real_on_modify_validate (MultiTextEntryDialogMediator* base,
                                                      const gchar* text);
static GType edit_comment_dialog_get_type_once (void);
VALA_EXTERN GtkResponseType remove_from_library_dialog (GtkWindow* owner,
                                            const gchar* title,
                                            const gchar* user_message,
                                            gint count);
VALA_EXTERN GtkResponseType remove_from_filesystem_dialog (GtkWindow* owner,
                                               const gchar* title,
                                               const gchar* user_message);
VALA_EXTERN gboolean revert_editable_dialog (GtkWindow* owner,
                                 GeeCollection* photos);
VALA_EXTERN gboolean photo_has_editable (Photo* self);
VALA_EXTERN gboolean remove_offline_dialog (GtkWindow* owner,
                                gint count);
VALA_EXTERN void multiple_object_error_dialog (GeeArrayList* objects,
                                   const gchar* message,
                                   const gchar* title);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN GType tags_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagsDialog, text_entry_dialog_mediator_unref)
VALA_EXTERN TagsDialog* tags_dialog_construct (GType object_type,
                                   const gchar* title,
                                   const gchar* label,
                                   const gchar* initial_text);
VALA_EXTERN gpointer hierarchical_tag_index_ref (gpointer instance);
VALA_EXTERN void hierarchical_tag_index_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_hierarchical_tag_index (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_hierarchical_tag_index (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_hierarchical_tag_index (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_hierarchical_tag_index (const GValue* value);
VALA_EXTERN GType hierarchical_tag_index_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HierarchicalTagIndex, hierarchical_tag_index_unref)
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_index_get_global_index (void);
VALA_EXTERN GeeCollection* hierarchical_tag_index_get_all_tags (HierarchicalTagIndex* self);
VALA_EXTERN GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
static GType tags_dialog_get_type_once (void);
VALA_EXTERN GType add_tags_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AddTagsDialog, text_entry_dialog_mediator_unref)
VALA_EXTERN AddTagsDialog* add_tags_dialog_new (void);
VALA_EXTERN AddTagsDialog* add_tags_dialog_construct (GType object_type);
VALA_EXTERN gchar** add_tags_dialog_execute (AddTagsDialog* self,
                                 gint* result_length1);
VALA_EXTERN gchar** tag_prep_tag_names (gchar** names,
                            gint names_length1,
                            gint* result_length1);
static gboolean add_tags_dialog_real_on_modify_validate (TextEntryDialogMediator* base,
                                                  const gchar* text);
static GType add_tags_dialog_get_type_once (void);
VALA_EXTERN GType modify_tags_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModifyTagsDialog, text_entry_dialog_mediator_unref)
VALA_EXTERN ModifyTagsDialog* modify_tags_dialog_new (MediaSource* source);
VALA_EXTERN ModifyTagsDialog* modify_tags_dialog_construct (GType object_type,
                                                MediaSource* source);
static gchar* modify_tags_dialog_get_initial_text (MediaSource* source);
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType tag_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagSourceCollection, data_collection_unref)
VALA_EXTERN GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                                 MediaSource* source);
VALA_EXTERN GeeCollection* tag_get_terminal_tags (GeeCollection* tags);
VALA_EXTERN gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
VALA_EXTERN gchar* tag_get_path (Tag* self);
VALA_EXTERN GeeArrayList* modify_tags_dialog_execute (ModifyTagsDialog* self);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
VALA_EXTERN gchar** hierarchical_tag_index_get_paths_for_names_array (HierarchicalTagIndex* self,
                                                          gchar** names,
                                                          gint names_length1,
                                                          gint* result_length1);
VALA_EXTERN Tag* tag_for_path (const gchar* name);
static gboolean modify_tags_dialog_real_on_modify_validate (TextEntryDialogMediator* base,
                                                     const gchar* text);
static GType modify_tags_dialog_get_type_once (void);
VALA_EXTERN GtkResponseType copy_files_dialog (void);
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN void remove_photos_from_library (GeeCollection* photos);
VALA_EXTERN void remove_from_app (GeeCollection* sources,
                      const gchar* dialog_title,
                      const gchar* progress_dialog_text);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN void media_source_collection_filter_media (GeeCollection* media,
                                           GeeCollection* photos,
                                           GeeCollection* videos);
VALA_EXTERN void page_window_set_busy_cursor (PageWindow* self);
VALA_EXTERN GType progress_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ProgressDialog, g_object_unref)
VALA_EXTERN ProgressDialog* progress_dialog_new (GtkWindow* owner,
                                     const gchar* text,
                                     GCancellable* cancellable);
VALA_EXTERN ProgressDialog* progress_dialog_construct (GType object_type,
                                           GtkWindow* owner,
                                           const gchar* text,
                                           GCancellable* cancellable);
VALA_EXTERN gboolean progress_dialog_monitor (ProgressDialog* self,
                                  guint64 count,
                                  guint64 total,
                                  gboolean do_event_loop);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current,
                                                    guint64 total,
                                                    gboolean do_event_loop,
                                                    gpointer self);
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType library_photo_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhotoSourceCollection, data_collection_unref)
VALA_EXTERN void media_source_collection_remove_from_app (MediaSourceCollection* self,
                                              GeeCollection* sources,
                                              gboolean delete_backing,
                                              ProgressMonitor monitor,
                                              gpointer monitor_target,
                                              GeeList* not_removed);
VALA_EXTERN GType video_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSourceCollection, data_collection_unref)
VALA_EXTERN void media_source_collection_delete_backing_files (MediaSourceCollection* self,
                                                   GeeCollection* sources,
                                                   ProgressMonitor monitor,
                                                   gpointer monitor_target,
                                                   GeeList* not_deleted);
VALA_EXTERN void app_window_error_message_with_title (const gchar* title,
                                          const gchar* message,
                                          GtkWindow* parent,
                                          gboolean should_escape);
VALA_EXTERN void progress_dialog_close (ProgressDialog* self);
VALA_EXTERN void page_window_set_normal_cursor (PageWindow* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gboolean
dialogs_confirm_delete_tag (Tag* tag)
{
	gint count = 0;
	gchar* msg = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (IS_TAG (tag), FALSE);
	count = tag_get_sources_count (tag);
	if (count == 0) {
		result = TRUE;
		return result;
	}
	_tmp0_ = tag_get_user_visible_name (tag);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (ngettext ("This will remove the tag “%s” from one photo. Continue?", "This will remove the tag “%s” from %d photos. Continue?", (gulong) count), _tmp1_, count);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	msg = _tmp3_;
	_tmp4_ = msg;
	result = app_window_negate_affirm_question (_tmp4_, _ ("_Cancel"), _ ("_Delete"), RESOURCES_DELETE_TAG_TITLE, NULL);
	_g_free0 (msg);
	return result;
}

gboolean
dialogs_confirm_delete_saved_search (SavedSearch* search)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_SAVED_SEARCH (search), FALSE);
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (search, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("This will remove the saved search “%s”. Continue?"), _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	msg = _tmp3_;
	result = app_window_negate_affirm_question (msg, _ ("_Cancel"), _ ("_Delete"), RESOURCES_DELETE_SAVED_SEARCH_DIALOG_TITLE, NULL);
	_g_free0 (msg);
	return result;
}

gboolean
dialogs_confirm_warn_developer_changed (gint number)
{
	GtkMessageDialog* dialog = NULL;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	gint response = 0;
	gboolean result;
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "<span weight=\"bold\" size=\"larger\">%s</span>", ngettext ("Switching developers will undo all changes you have made to this photo" \
" in Shotwell", "Switching developers will undo all changes you have made to these phot" \
"os in Shotwell", (gulong) number));
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	dialog = _tmp3_;
	gtk_dialog_add_buttons (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), RESOURCES_CANCEL_LABEL, GTK_RESPONSE_CANCEL, NULL);
	gtk_dialog_add_buttons (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), _ ("_Switch Developer"), GTK_RESPONSE_YES, NULL);
	response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	result = response == ((gint) GTK_RESPONSE_YES);
	_g_object_unref0 (dialog);
	return result;
}

gboolean
dialogs_confirm_delete_face (Face* face)
{
	gint count = 0;
	gchar* msg = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_FACE (face), FALSE);
	count = face_get_sources_count (face);
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (face, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (ngettext ("This will remove the face “%s” from one photo. Continue?", "This will remove the face “%s” from %d photos. Continue?", (gulong) count), _tmp1_, count);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	msg = _tmp3_;
	result = app_window_negate_affirm_question (msg, _ ("_Cancel"), _ ("_Delete"), RESOURCES_DELETE_FACE_TITLE, NULL);
	_g_free0 (msg);
	return result;
}

GFile*
export_ui_choose_file (const gchar* current_file_basename)
{
	GFile* _tmp0_;
	const gchar* _tmp3_ = NULL;
	gchar* file_chooser_title = NULL;
	gchar* _tmp4_;
	GtkFileChooserNative* chooser = NULL;
	const gchar* _tmp5_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	GtkFileChooserNative* _tmp8_;
	GtkFileChooserNative* _tmp9_;
	GtkFileChooserNative* _tmp10_;
	GtkFileChooserNative* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkFileChooserNative* _tmp15_;
	GtkFileChooserNative* _tmp16_;
	GFile* file = NULL;
	GtkFileChooserNative* _tmp17_;
	GtkFileChooserNative* _tmp24_;
	GFile* result;
	g_return_val_if_fail (current_file_basename != NULL, NULL);
	_tmp0_ = export_ui_current_export_dir;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp2_;
	}
	if (video_reader_is_supported_video_filename (current_file_basename)) {
		_tmp3_ = _ ("Export Video");
	} else {
		_tmp3_ = g_dpgettext2 (NULL, "Dialog Title", "Export Photo");
	}
	_tmp4_ = g_strdup (_tmp3_);
	file_chooser_title = _tmp4_;
	_tmp5_ = file_chooser_title;
	_tmp6_ = app_window_get_instance ();
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_file_chooser_native_new (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_SAVE, RESOURCES_SAVE_LABEL, RESOURCES_CANCEL_LABEL);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	chooser = _tmp9_;
	_tmp10_ = chooser;
	gtk_file_chooser_set_do_overwrite_confirmation (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_file_chooser_get_type (), GtkFileChooser), TRUE);
	_tmp11_ = chooser;
	_tmp12_ = export_ui_current_export_dir;
	_tmp13_ = g_file_get_path (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_file_chooser_set_current_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_file_chooser_get_type (), GtkFileChooser), _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = chooser;
	gtk_file_chooser_set_current_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_file_chooser_get_type (), GtkFileChooser), current_file_basename);
	_tmp16_ = chooser;
	gtk_file_chooser_set_local_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
	file = NULL;
	_tmp17_ = chooser;
	if (gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_native_dialog_get_type (), GtkNativeDialog)) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		_tmp18_ = chooser;
		_tmp19_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_file_chooser_get_type (), GtkFileChooser));
		_tmp20_ = _tmp19_;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		_g_object_unref0 (file);
		file = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp22_ = file;
		_tmp23_ = g_file_get_parent (_tmp22_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp23_;
	}
	_tmp24_ = chooser;
	gtk_native_dialog_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_native_dialog_get_type (), GtkNativeDialog));
	result = file;
	_g_object_unref0 (chooser);
	_g_free0 (file_chooser_title);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFile*
export_ui_choose_dir (const gchar* user_title)
{
	GFile* _tmp0_;
	GtkFileChooserNative* chooser = NULL;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkFileChooserNative* _tmp11_;
	GFile* dir = NULL;
	GtkFileChooserNative* _tmp12_;
	GtkFileChooserNative* _tmp19_;
	GFile* result;
	_tmp0_ = export_ui_current_export_dir;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp2_;
	}
	if (user_title == NULL) {
		user_title = _ ("Export Photos");
	}
	_tmp3_ = app_window_get_instance ();
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_file_chooser_native_new (user_title, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, RESOURCES_OK_LABEL, RESOURCES_CANCEL_LABEL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	chooser = _tmp6_;
	_tmp7_ = chooser;
	_tmp8_ = export_ui_current_export_dir;
	_tmp9_ = g_file_get_path (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_file_chooser_set_current_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_file_chooser_get_type (), GtkFileChooser), _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = chooser;
	gtk_file_chooser_set_local_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
	dir = NULL;
	_tmp12_ = chooser;
	if (gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_native_dialog_get_type (), GtkNativeDialog)) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		_tmp13_ = chooser;
		_tmp14_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_file_chooser_get_type (), GtkFileChooser));
		_tmp15_ = _tmp14_;
		_tmp16_ = g_file_new_for_path (_tmp15_);
		_g_object_unref0 (dir);
		dir = _tmp16_;
		_g_free0 (_tmp15_);
		_tmp17_ = dir;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp18_;
	}
	_tmp19_ = chooser;
	gtk_native_dialog_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_native_dialog_get_type (), GtkNativeDialog));
	result = dir;
	_g_object_unref0 (chooser);
	return result;
}

void
open_external_editor_error_dialog (GError* err,
                                   Photo* photo)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (err != NULL);
	g_return_if_fail (IS_PHOTO (photo));
	if (g_error_matches (err, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_error_matches (err, G_FILE_ERROR, G_FILE_ERROR_PERM);
	}
	if (_tmp0_) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_get_parent (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf (_ ("Shotwell couldn’t create a file for editing this photo because you do " \
"not have permission to write to %s."), _tmp6_);
		_tmp8_ = _tmp7_;
		app_window_error_message (_tmp8_, NULL);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = resources_launch_editor_failed (err);
		_tmp10_ = _tmp9_;
		app_window_error_message (_tmp10_, NULL);
		_g_free0 (_tmp10_);
	}
}

GtkResponseType
export_error_dialog (GFile* dest,
                     gboolean photos_remaining)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkResponseType response = 0;
	GtkResponseType result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest, g_file_get_type ()), 0);
	_tmp0_ = g_file_get_path (dest);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_ ("Unable to export the following photo due to a file error.\n\n"), _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message = _tmp3_;
	response = GTK_RESPONSE_NONE;
	if (photos_remaining) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = message;
		_tmp5_ = g_strconcat (_tmp4_, _ ("\n\nWould you like to continue exporting?"), NULL);
		_g_free0 (message);
		message = _tmp5_;
		_tmp6_ = message;
		response = app_window_affirm_cancel_question (_tmp6_, _ ("Con_tinue"), NULL, NULL);
	} else {
		const gchar* _tmp7_;
		_tmp7_ = message;
		app_window_error_message (_tmp7_, NULL);
	}
	result = response;
	_g_free0 (message);
	return result;
}

gchar*
import_ui_generate_import_failure_list (GeeList* failed,
                                        gboolean show_dest_id)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* list = NULL;
	gchar* _tmp2_;
	gint remaining = 0;
	gint _tmp19_;
	gint _tmp20_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (failed, GEE_TYPE_LIST), NULL);
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (failed, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	}
	_tmp2_ = g_strdup ("");
	list = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (ctr < IMPORT_UI_REPORT_FAILURE_COUNT) {
					gint _tmp6_;
					gint _tmp7_;
					_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (failed, GEE_TYPE_COLLECTION, GeeCollection));
					_tmp7_ = _tmp6_;
					_tmp5_ = ctr < _tmp7_;
				} else {
					_tmp5_ = FALSE;
				}
				if (!_tmp5_) {
					break;
				}
				if (show_dest_id) {
					gpointer _tmp9_;
					BatchImportResult* _tmp10_;
					const gchar* _tmp11_;
					_tmp9_ = gee_list_get (failed, ctr);
					_tmp10_ = (BatchImportResult*) _tmp9_;
					_tmp11_ = _tmp10_->dest_identifier;
					_tmp8_ = _tmp11_;
					_batch_import_result_unref0 (_tmp10_);
				} else {
					gpointer _tmp12_;
					BatchImportResult* _tmp13_;
					const gchar* _tmp14_;
					_tmp12_ = gee_list_get (failed, ctr);
					_tmp13_ = (BatchImportResult*) _tmp12_;
					_tmp14_ = _tmp13_->src_identifier;
					_tmp8_ = _tmp14_;
					_batch_import_result_unref0 (_tmp13_);
				}
				_tmp15_ = list;
				_tmp16_ = g_strdup_printf ("%s\n", _tmp8_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
				_g_free0 (list);
				list = _tmp18_;
				_g_free0 (_tmp17_);
			}
		}
	}
	_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (failed, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp20_ = _tmp19_;
	remaining = _tmp20_ - IMPORT_UI_REPORT_FAILURE_COUNT;
	if (remaining > 0) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = list;
		_tmp22_ = g_strdup_printf (_ ("(and %d more)\n"), remaining);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_g_free0 (list);
		list = _tmp24_;
		_g_free0 (_tmp23_);
	}
	result = list;
	return result;
}

ImportUIQuestionParams*
import_ui_question_params_construct (GType object_type,
                                     const gchar* question,
                                     const gchar* yes_button,
                                     const gchar* no_button)
{
	ImportUIQuestionParams* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (question != NULL, NULL);
	g_return_val_if_fail (yes_button != NULL, NULL);
	g_return_val_if_fail (no_button != NULL, NULL);
	self = (ImportUIQuestionParams*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (question);
	_g_free0 (self->question);
	self->question = _tmp0_;
	_tmp1_ = g_strdup (yes_button);
	_g_free0 (self->yes_button);
	self->yes_button = _tmp1_;
	_tmp2_ = g_strdup (no_button);
	_g_free0 (self->no_button);
	self->no_button = _tmp2_;
	return self;
}

ImportUIQuestionParams*
import_ui_question_params_new (const gchar* question,
                               const gchar* yes_button,
                               const gchar* no_button)
{
	return import_ui_question_params_construct (IMPORT_UI_TYPE_QUESTION_PARAMS, question, yes_button, no_button);
}

static void
import_ui_value_question_params_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
import_ui_value_question_params_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		import_ui_question_params_unref (value->data[0].v_pointer);
	}
}

static void
import_ui_value_question_params_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = import_ui_question_params_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
import_ui_value_question_params_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
import_ui_value_question_params_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ImportUIQuestionParams * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = import_ui_question_params_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
import_ui_value_question_params_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	ImportUIQuestionParams ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = import_ui_question_params_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
import_ui_param_spec_question_params (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	ImportUIParamSpecQuestionParams* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IMPORT_UI_TYPE_QUESTION_PARAMS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
import_ui_value_get_question_params (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMPORT_UI_TYPE_QUESTION_PARAMS), NULL);
	return value->data[0].v_pointer;
}

void
import_ui_value_set_question_params (GValue* value,
                                     gpointer v_object)
{
	ImportUIQuestionParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMPORT_UI_TYPE_QUESTION_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IMPORT_UI_TYPE_QUESTION_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		import_ui_question_params_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		import_ui_question_params_unref (old);
	}
}

void
import_ui_value_take_question_params (GValue* value,
                                      gpointer v_object)
{
	ImportUIQuestionParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMPORT_UI_TYPE_QUESTION_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IMPORT_UI_TYPE_QUESTION_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		import_ui_question_params_unref (old);
	}
}

static void
import_ui_question_params_class_init (ImportUIQuestionParamsClass * klass,
                                      gpointer klass_data)
{
	import_ui_question_params_parent_class = g_type_class_peek_parent (klass);
	((ImportUIQuestionParamsClass *) klass)->finalize = import_ui_question_params_finalize;
}

static void
import_ui_question_params_instance_init (ImportUIQuestionParams * self,
                                         gpointer klass)
{
	self->ref_count = 1;
}

static void
import_ui_question_params_finalize (ImportUIQuestionParams * obj)
{
	ImportUIQuestionParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IMPORT_UI_TYPE_QUESTION_PARAMS, ImportUIQuestionParams);
	g_signal_handlers_destroy (self);
	_g_free0 (self->question);
	_g_free0 (self->yes_button);
	_g_free0 (self->no_button);
}

static GType
import_ui_question_params_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { import_ui_value_question_params_init, import_ui_value_question_params_free_value, import_ui_value_question_params_copy_value, import_ui_value_question_params_peek_pointer, "p", import_ui_value_question_params_collect_value, "p", import_ui_value_question_params_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ImportUIQuestionParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_ui_question_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportUIQuestionParams), 0, (GInstanceInitFunc) import_ui_question_params_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType import_ui_question_params_type_id;
	import_ui_question_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ImportUIQuestionParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return import_ui_question_params_type_id;
}

GType
import_ui_question_params_get_type (void)
{
	static volatile gsize import_ui_question_params_type_id__once = 0;
	if (g_once_init_enter (&import_ui_question_params_type_id__once)) {
		GType import_ui_question_params_type_id;
		import_ui_question_params_type_id = import_ui_question_params_get_type_once ();
		g_once_init_leave (&import_ui_question_params_type_id__once, import_ui_question_params_type_id);
	}
	return import_ui_question_params_type_id__once;
}

gpointer
import_ui_question_params_ref (gpointer instance)
{
	ImportUIQuestionParams * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
import_ui_question_params_unref (gpointer instance)
{
	ImportUIQuestionParams * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IMPORT_UI_QUESTION_PARAMS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gboolean
import_ui_import_has_photos (GeeCollection* import_collection)
{
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (import_collection, GEE_TYPE_COLLECTION), FALSE);
	{
		GeeIterator* _current_result_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (import_collection, GEE_TYPE_ITERABLE, GeeIterable));
		_current_result_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			BatchImportResult* current_result = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			BatchImportResult* _tmp5_;
			GFile* _tmp6_;
			_tmp1_ = _current_result_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _current_result_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			current_result = (BatchImportResult*) _tmp3_;
			_tmp5_ = current_result;
			_tmp6_ = _tmp5_->file;
			if (_tmp6_ != NULL) {
				BatchImportResult* _tmp7_;
				GFile* _tmp8_;
				_tmp7_ = current_result;
				_tmp8_ = _tmp7_->file;
				_tmp4_ = photo_file_format_get_by_file_extension (_tmp8_) != PHOTO_FILE_FORMAT_UNKNOWN;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				result = TRUE;
				_batch_import_result_unref0 (current_result);
				_g_object_unref0 (_current_result_it);
				return result;
			}
			_batch_import_result_unref0 (current_result);
		}
		_g_object_unref0 (_current_result_it);
	}
	result = FALSE;
	return result;
}

gboolean
import_ui_import_has_videos (GeeCollection* import_collection)
{
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (import_collection, GEE_TYPE_COLLECTION), FALSE);
	{
		GeeIterator* _current_result_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (import_collection, GEE_TYPE_ITERABLE, GeeIterable));
		_current_result_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			BatchImportResult* current_result = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			BatchImportResult* _tmp5_;
			GFile* _tmp6_;
			_tmp1_ = _current_result_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _current_result_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			current_result = (BatchImportResult*) _tmp3_;
			_tmp5_ = current_result;
			_tmp6_ = _tmp5_->file;
			if (_tmp6_ != NULL) {
				BatchImportResult* _tmp7_;
				GFile* _tmp8_;
				_tmp7_ = current_result;
				_tmp8_ = _tmp7_->file;
				_tmp4_ = video_reader_is_supported_video_file (_tmp8_);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				result = TRUE;
				_batch_import_result_unref0 (current_result);
				_g_object_unref0 (_current_result_it);
				return result;
			}
			_batch_import_result_unref0 (current_result);
		}
		_g_object_unref0 (_current_result_it);
	}
	result = FALSE;
	return result;
}

gchar*
import_ui_get_media_specific_string (GeeCollection* import_collection,
                                     const gchar* photos_msg,
                                     const gchar* videos_msg,
                                     const gchar* both_msg,
                                     const gchar* neither_msg)
{
	gboolean has_photos = FALSE;
	gboolean has_videos = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (import_collection, GEE_TYPE_COLLECTION), NULL);
	g_return_val_if_fail (photos_msg != NULL, NULL);
	g_return_val_if_fail (videos_msg != NULL, NULL);
	g_return_val_if_fail (both_msg != NULL, NULL);
	g_return_val_if_fail (neither_msg != NULL, NULL);
	has_photos = import_ui_import_has_photos (import_collection);
	has_videos = import_ui_import_has_videos (import_collection);
	if (has_photos) {
		_tmp0_ = has_videos;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (both_msg);
		result = _tmp1_;
		return result;
	} else {
		if (has_photos) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (photos_msg);
			result = _tmp2_;
			return result;
		} else {
			if (has_videos) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup (videos_msg);
				result = _tmp3_;
				return result;
			} else {
				gchar* _tmp4_;
				_tmp4_ = g_strdup (neither_msg);
				result = _tmp4_;
				return result;
			}
		}
	}
}

gchar*
import_ui_create_result_report_from_manifest (ImportManifest* manifest)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* header = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* subhead = NULL;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	GeeList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GString* _tmp38_;
	const gchar* _tmp39_;
	gchar* current_file_summary = NULL;
	gchar* _tmp40_;
	GeeList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GeeList* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	GeeList* _tmp103_;
	gint _tmp104_;
	gint _tmp105_;
	GeeList* _tmp132_;
	gint _tmp133_;
	gint _tmp134_;
	GeeList* _tmp161_;
	gint _tmp162_;
	gint _tmp163_;
	GeeList* _tmp194_;
	gint _tmp195_;
	gint _tmp196_;
	GeeList* _tmp223_;
	gint _tmp224_;
	gint _tmp225_;
	GString* _tmp252_;
	const gchar* _tmp253_;
	gchar* _tmp254_;
	gchar* result;
	g_return_val_if_fail (IS_IMPORT_MANIFEST (manifest), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = g_strconcat (_ ("Import Results Report"), " (Shotwell ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, RESOURCES_APP_VERSION, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, " @ ", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_date_time_new_now_utc ();
	_tmp8_ = _tmp7_;
	_tmp9_ = g_date_time_format_iso8601 (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, ")\n\n", NULL);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_date_time_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	header = _tmp14_;
	_tmp15_ = builder;
	_tmp16_ = header;
	g_string_append (_tmp15_, _tmp16_);
	_tmp17_ = manifest->all;
	_tmp18_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp19_ = _tmp18_;
	_tmp20_ = manifest->all;
	_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf (ngettext ("Attempted to import %d file.", "Attempted to import %d files.", (gulong) _tmp19_), _tmp22_);
	subhead = _tmp23_;
	_tmp24_ = subhead;
	_tmp25_ = g_strconcat (_tmp24_, " ", NULL);
	_g_free0 (subhead);
	subhead = _tmp25_;
	_tmp26_ = subhead;
	_tmp27_ = manifest->success;
	_tmp28_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp29_ = _tmp28_;
	_tmp30_ = manifest->success;
	_tmp31_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strdup_printf (ngettext ("Of these, %d file was successfully imported.", "Of these, %d files were successfully imported.", (gulong) _tmp29_), _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp26_, _tmp34_, NULL);
	_g_free0 (subhead);
	subhead = _tmp35_;
	_g_free0 (_tmp34_);
	_tmp36_ = subhead;
	_tmp37_ = g_strconcat (_tmp36_, "\n\n", NULL);
	_g_free0 (subhead);
	subhead = _tmp37_;
	_tmp38_ = builder;
	_tmp39_ = subhead;
	g_string_append (_tmp38_, _tmp39_);
	_tmp40_ = g_strdup ("");
	current_file_summary = _tmp40_;
	_tmp41_ = manifest->already_imported;
	_tmp42_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp43_ = _tmp42_;
	if (_tmp43_ > 0) {
		GString* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp44_ = builder;
		_tmp45_ = g_strconcat (_ ("Duplicate Photos/Videos Not Imported:"), "\n\n", NULL);
		_tmp46_ = _tmp45_;
		g_string_append (_tmp44_, _tmp46_);
		_g_free0 (_tmp46_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp47_;
			gint _result_size = 0;
			GeeList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _result_index = 0;
			_tmp47_ = manifest->already_imported;
			_result_list = _tmp47_;
			_tmp48_ = _result_list;
			_tmp49_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp50_ = _tmp49_;
			_result_size = _tmp50_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp51_;
				gint _tmp52_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp53_;
				gpointer _tmp54_;
				BatchImportResult* _tmp55_;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				BatchImportResult* _tmp63_;
				DuplicatedFile* _tmp64_;
				GFile* _tmp65_;
				GFile* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				GString* _tmp72_;
				const gchar* _tmp73_;
				_result_index = _result_index + 1;
				_tmp51_ = _result_index;
				_tmp52_ = _result_size;
				if (!(_tmp51_ < _tmp52_)) {
					break;
				}
				_tmp53_ = _result_list;
				_tmp54_ = gee_list_get (_tmp53_, _result_index);
				_result_ = (BatchImportResult*) _tmp54_;
				_tmp55_ = _result_;
				_tmp56_ = _tmp55_->src_identifier;
				_tmp57_ = g_strconcat (_tmp56_, " ", NULL);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strconcat (_tmp58_, _ ("duplicates existing media item"), NULL);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strconcat (_tmp60_, "\n\t", NULL);
				_tmp62_ = _tmp61_;
				_tmp63_ = _result_;
				_tmp64_ = _tmp63_->duplicate_of;
				_tmp65_ = duplicated_file_get_file (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_file_get_path (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = g_strconcat (_tmp62_, _tmp68_, NULL);
				_tmp70_ = _tmp69_;
				_tmp71_ = g_strconcat (_tmp70_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp71_;
				_g_free0 (_tmp70_);
				_g_free0 (_tmp68_);
				_g_object_unref0 (_tmp66_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_g_free0 (_tmp58_);
				_tmp72_ = builder;
				_tmp73_ = current_file_summary;
				g_string_append (_tmp72_, _tmp73_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp74_ = manifest->camera_failed;
	_tmp75_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp76_ = _tmp75_;
	if (_tmp76_ > 0) {
		GString* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp77_ = builder;
		_tmp78_ = g_strconcat (_ ("Photos/Videos Not Imported Due to Camera Errors:"), "\n\n", NULL);
		_tmp79_ = _tmp78_;
		g_string_append (_tmp77_, _tmp79_);
		_g_free0 (_tmp79_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp80_;
			gint _result_size = 0;
			GeeList* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			gint _result_index = 0;
			_tmp80_ = manifest->camera_failed;
			_result_list = _tmp80_;
			_tmp81_ = _result_list;
			_tmp82_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp83_ = _tmp82_;
			_result_size = _tmp83_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp84_;
				gint _tmp85_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp86_;
				gpointer _tmp87_;
				BatchImportResult* _tmp88_;
				const gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				BatchImportResult* _tmp96_;
				const gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				GString* _tmp101_;
				const gchar* _tmp102_;
				_result_index = _result_index + 1;
				_tmp84_ = _result_index;
				_tmp85_ = _result_size;
				if (!(_tmp84_ < _tmp85_)) {
					break;
				}
				_tmp86_ = _result_list;
				_tmp87_ = gee_list_get (_tmp86_, _result_index);
				_result_ = (BatchImportResult*) _tmp87_;
				_tmp88_ = _result_;
				_tmp89_ = _tmp88_->src_identifier;
				_tmp90_ = g_strconcat (_tmp89_, "\n\t", NULL);
				_tmp91_ = _tmp90_;
				_tmp92_ = g_strconcat (_tmp91_, _ ("error message:"), NULL);
				_tmp93_ = _tmp92_;
				_tmp94_ = g_strconcat (_tmp93_, " ", NULL);
				_tmp95_ = _tmp94_;
				_tmp96_ = _result_;
				_tmp97_ = _tmp96_->errmsg;
				_tmp98_ = g_strconcat (_tmp95_, _tmp97_, NULL);
				_tmp99_ = _tmp98_;
				_tmp100_ = g_strconcat (_tmp99_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp100_;
				_g_free0 (_tmp99_);
				_g_free0 (_tmp95_);
				_g_free0 (_tmp93_);
				_g_free0 (_tmp91_);
				_tmp101_ = builder;
				_tmp102_ = current_file_summary;
				g_string_append (_tmp101_, _tmp102_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp103_ = manifest->skipped_files;
	_tmp104_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp105_ = _tmp104_;
	if (_tmp105_ > 0) {
		GString* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		_tmp106_ = builder;
		_tmp107_ = g_strconcat (_ ("Files Not Imported Because They Weren’t Recognized as Photos or Videos" \
":"), "\n\n", NULL);
		_tmp108_ = _tmp107_;
		g_string_append (_tmp106_, _tmp108_);
		_g_free0 (_tmp108_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp109_;
			gint _result_size = 0;
			GeeList* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			gint _result_index = 0;
			_tmp109_ = manifest->skipped_files;
			_result_list = _tmp109_;
			_tmp110_ = _result_list;
			_tmp111_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp112_ = _tmp111_;
			_result_size = _tmp112_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp113_;
				gint _tmp114_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp115_;
				gpointer _tmp116_;
				BatchImportResult* _tmp117_;
				const gchar* _tmp118_;
				gchar* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				BatchImportResult* _tmp125_;
				const gchar* _tmp126_;
				gchar* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				GString* _tmp130_;
				const gchar* _tmp131_;
				_result_index = _result_index + 1;
				_tmp113_ = _result_index;
				_tmp114_ = _result_size;
				if (!(_tmp113_ < _tmp114_)) {
					break;
				}
				_tmp115_ = _result_list;
				_tmp116_ = gee_list_get (_tmp115_, _result_index);
				_result_ = (BatchImportResult*) _tmp116_;
				_tmp117_ = _result_;
				_tmp118_ = _tmp117_->src_identifier;
				_tmp119_ = g_strconcat (_tmp118_, "\n\t", NULL);
				_tmp120_ = _tmp119_;
				_tmp121_ = g_strconcat (_tmp120_, _ ("error message:"), NULL);
				_tmp122_ = _tmp121_;
				_tmp123_ = g_strconcat (_tmp122_, " ", NULL);
				_tmp124_ = _tmp123_;
				_tmp125_ = _result_;
				_tmp126_ = _tmp125_->errmsg;
				_tmp127_ = g_strconcat (_tmp124_, _tmp126_, NULL);
				_tmp128_ = _tmp127_;
				_tmp129_ = g_strconcat (_tmp128_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp129_;
				_g_free0 (_tmp128_);
				_g_free0 (_tmp124_);
				_g_free0 (_tmp122_);
				_g_free0 (_tmp120_);
				_tmp130_ = builder;
				_tmp131_ = current_file_summary;
				g_string_append (_tmp130_, _tmp131_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp132_ = manifest->skipped_photos;
	_tmp133_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp134_ = _tmp133_;
	if (_tmp134_ > 0) {
		GString* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		_tmp135_ = builder;
		_tmp136_ = g_strconcat (_ ("Photos/Videos Not Imported Because They Weren’t in a Format Shotwell U" \
"nderstands:"), "\n\n", NULL);
		_tmp137_ = _tmp136_;
		g_string_append (_tmp135_, _tmp137_);
		_g_free0 (_tmp137_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp138_;
			gint _result_size = 0;
			GeeList* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			gint _result_index = 0;
			_tmp138_ = manifest->skipped_photos;
			_result_list = _tmp138_;
			_tmp139_ = _result_list;
			_tmp140_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp141_ = _tmp140_;
			_result_size = _tmp141_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp142_;
				gint _tmp143_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp144_;
				gpointer _tmp145_;
				BatchImportResult* _tmp146_;
				const gchar* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				BatchImportResult* _tmp154_;
				const gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				gchar* _tmp158_;
				GString* _tmp159_;
				const gchar* _tmp160_;
				_result_index = _result_index + 1;
				_tmp142_ = _result_index;
				_tmp143_ = _result_size;
				if (!(_tmp142_ < _tmp143_)) {
					break;
				}
				_tmp144_ = _result_list;
				_tmp145_ = gee_list_get (_tmp144_, _result_index);
				_result_ = (BatchImportResult*) _tmp145_;
				_tmp146_ = _result_;
				_tmp147_ = _tmp146_->src_identifier;
				_tmp148_ = g_strconcat (_tmp147_, "\n\t", NULL);
				_tmp149_ = _tmp148_;
				_tmp150_ = g_strconcat (_tmp149_, _ ("error message:"), NULL);
				_tmp151_ = _tmp150_;
				_tmp152_ = g_strconcat (_tmp151_, " ", NULL);
				_tmp153_ = _tmp152_;
				_tmp154_ = _result_;
				_tmp155_ = _tmp154_->errmsg;
				_tmp156_ = g_strconcat (_tmp153_, _tmp155_, NULL);
				_tmp157_ = _tmp156_;
				_tmp158_ = g_strconcat (_tmp157_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp158_;
				_g_free0 (_tmp157_);
				_g_free0 (_tmp153_);
				_g_free0 (_tmp151_);
				_g_free0 (_tmp149_);
				_tmp159_ = builder;
				_tmp160_ = current_file_summary;
				g_string_append (_tmp159_, _tmp160_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp161_ = manifest->write_failed;
	_tmp162_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp163_ = _tmp162_;
	if (_tmp163_ > 0) {
		GString* _tmp164_;
		gchar* _tmp165_;
		gchar* _tmp166_;
		_tmp164_ = builder;
		_tmp165_ = g_strconcat (_ ("Photos/Videos Not Imported Because Shotwell Couldn’t Copy Them into it" \
"s Library:"), "\n\n", NULL);
		_tmp166_ = _tmp165_;
		g_string_append (_tmp164_, _tmp166_);
		_g_free0 (_tmp166_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp167_;
			gint _result_size = 0;
			GeeList* _tmp168_;
			gint _tmp169_;
			gint _tmp170_;
			gint _result_index = 0;
			_tmp167_ = manifest->write_failed;
			_result_list = _tmp167_;
			_tmp168_ = _result_list;
			_tmp169_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp170_ = _tmp169_;
			_result_size = _tmp170_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp171_;
				gint _tmp172_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp173_;
				gpointer _tmp174_;
				BatchImportResult* _tmp175_;
				const gchar* _tmp176_;
				BatchImportResult* _tmp177_;
				const gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				gchar* _tmp182_;
				gchar* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				BatchImportResult* _tmp187_;
				const gchar* _tmp188_;
				gchar* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				GString* _tmp192_;
				const gchar* _tmp193_;
				_result_index = _result_index + 1;
				_tmp171_ = _result_index;
				_tmp172_ = _result_size;
				if (!(_tmp171_ < _tmp172_)) {
					break;
				}
				_tmp173_ = _result_list;
				_tmp174_ = gee_list_get (_tmp173_, _result_index);
				_result_ = (BatchImportResult*) _tmp174_;
				_tmp175_ = _result_;
				_tmp176_ = _tmp175_->src_identifier;
				_tmp177_ = _result_;
				_tmp178_ = _tmp177_->dest_identifier;
				_tmp179_ = g_strdup_printf (_ ("couldn’t copy %s\n\tto %s"), _tmp176_, _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = g_strconcat (_tmp180_, "\n\t", NULL);
				_tmp182_ = _tmp181_;
				_tmp183_ = g_strconcat (_tmp182_, _ ("error message:"), NULL);
				_tmp184_ = _tmp183_;
				_tmp185_ = g_strconcat (_tmp184_, " ", NULL);
				_tmp186_ = _tmp185_;
				_tmp187_ = _result_;
				_tmp188_ = _tmp187_->errmsg;
				_tmp189_ = g_strconcat (_tmp186_, _tmp188_, NULL);
				_tmp190_ = _tmp189_;
				_tmp191_ = g_strconcat (_tmp190_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp191_;
				_g_free0 (_tmp190_);
				_g_free0 (_tmp186_);
				_g_free0 (_tmp184_);
				_g_free0 (_tmp182_);
				_g_free0 (_tmp180_);
				_tmp192_ = builder;
				_tmp193_ = current_file_summary;
				g_string_append (_tmp192_, _tmp193_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp194_ = manifest->corrupt_files;
	_tmp195_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp194_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp196_ = _tmp195_;
	if (_tmp196_ > 0) {
		GString* _tmp197_;
		gchar* _tmp198_;
		gchar* _tmp199_;
		_tmp197_ = builder;
		_tmp198_ = g_strconcat (_ ("Photos/Videos Not Imported Because Files Are Corrupt:"), "\n\n", NULL);
		_tmp199_ = _tmp198_;
		g_string_append (_tmp197_, _tmp199_);
		_g_free0 (_tmp199_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp200_;
			gint _result_size = 0;
			GeeList* _tmp201_;
			gint _tmp202_;
			gint _tmp203_;
			gint _result_index = 0;
			_tmp200_ = manifest->corrupt_files;
			_result_list = _tmp200_;
			_tmp201_ = _result_list;
			_tmp202_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp201_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp203_ = _tmp202_;
			_result_size = _tmp203_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp204_;
				gint _tmp205_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp206_;
				gpointer _tmp207_;
				BatchImportResult* _tmp208_;
				const gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				gchar* _tmp215_;
				BatchImportResult* _tmp216_;
				const gchar* _tmp217_;
				gchar* _tmp218_;
				gchar* _tmp219_;
				gchar* _tmp220_;
				GString* _tmp221_;
				const gchar* _tmp222_;
				_result_index = _result_index + 1;
				_tmp204_ = _result_index;
				_tmp205_ = _result_size;
				if (!(_tmp204_ < _tmp205_)) {
					break;
				}
				_tmp206_ = _result_list;
				_tmp207_ = gee_list_get (_tmp206_, _result_index);
				_result_ = (BatchImportResult*) _tmp207_;
				_tmp208_ = _result_;
				_tmp209_ = _tmp208_->src_identifier;
				_tmp210_ = g_strconcat (_tmp209_, "\n\t", NULL);
				_tmp211_ = _tmp210_;
				_tmp212_ = g_strconcat (_tmp211_, _ ("error message:"), NULL);
				_tmp213_ = _tmp212_;
				_tmp214_ = g_strconcat (_tmp213_, " |", NULL);
				_tmp215_ = _tmp214_;
				_tmp216_ = _result_;
				_tmp217_ = _tmp216_->errmsg;
				_tmp218_ = g_strconcat (_tmp215_, _tmp217_, NULL);
				_tmp219_ = _tmp218_;
				_tmp220_ = g_strconcat (_tmp219_, "|\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp220_;
				_g_free0 (_tmp219_);
				_g_free0 (_tmp215_);
				_g_free0 (_tmp213_);
				_g_free0 (_tmp211_);
				_tmp221_ = builder;
				_tmp222_ = current_file_summary;
				g_string_append (_tmp221_, _tmp222_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp223_ = manifest->failed;
	_tmp224_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp225_ = _tmp224_;
	if (_tmp225_ > 0) {
		GString* _tmp226_;
		gchar* _tmp227_;
		gchar* _tmp228_;
		_tmp226_ = builder;
		_tmp227_ = g_strconcat (_ ("Photos/Videos Not Imported for Other Reasons:"), "\n\n", NULL);
		_tmp228_ = _tmp227_;
		g_string_append (_tmp226_, _tmp228_);
		_g_free0 (_tmp228_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp229_;
			gint _result_size = 0;
			GeeList* _tmp230_;
			gint _tmp231_;
			gint _tmp232_;
			gint _result_index = 0;
			_tmp229_ = manifest->failed;
			_result_list = _tmp229_;
			_tmp230_ = _result_list;
			_tmp231_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp230_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp232_ = _tmp231_;
			_result_size = _tmp232_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp233_;
				gint _tmp234_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp235_;
				gpointer _tmp236_;
				BatchImportResult* _tmp237_;
				const gchar* _tmp238_;
				gchar* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				gchar* _tmp244_;
				BatchImportResult* _tmp245_;
				const gchar* _tmp246_;
				gchar* _tmp247_;
				gchar* _tmp248_;
				gchar* _tmp249_;
				GString* _tmp250_;
				const gchar* _tmp251_;
				_result_index = _result_index + 1;
				_tmp233_ = _result_index;
				_tmp234_ = _result_size;
				if (!(_tmp233_ < _tmp234_)) {
					break;
				}
				_tmp235_ = _result_list;
				_tmp236_ = gee_list_get (_tmp235_, _result_index);
				_result_ = (BatchImportResult*) _tmp236_;
				_tmp237_ = _result_;
				_tmp238_ = _tmp237_->src_identifier;
				_tmp239_ = g_strconcat (_tmp238_, "\n\t", NULL);
				_tmp240_ = _tmp239_;
				_tmp241_ = g_strconcat (_tmp240_, _ ("error message:"), NULL);
				_tmp242_ = _tmp241_;
				_tmp243_ = g_strconcat (_tmp242_, " ", NULL);
				_tmp244_ = _tmp243_;
				_tmp245_ = _result_;
				_tmp246_ = _tmp245_->errmsg;
				_tmp247_ = g_strconcat (_tmp244_, _tmp246_, NULL);
				_tmp248_ = _tmp247_;
				_tmp249_ = g_strconcat (_tmp248_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp249_;
				_g_free0 (_tmp248_);
				_g_free0 (_tmp244_);
				_g_free0 (_tmp242_);
				_g_free0 (_tmp240_);
				_tmp250_ = builder;
				_tmp251_ = current_file_summary;
				g_string_append (_tmp250_, _tmp251_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp252_ = builder;
	_tmp253_ = _tmp252_->str;
	_tmp254_ = g_strdup (_tmp253_);
	result = _tmp254_;
	_g_free0 (current_file_summary);
	_g_free0 (subhead);
	_g_free0 (header);
	_g_string_free0 (builder);
	return result;
}

gboolean
import_ui_report_manifest (ImportManifest* manifest,
                           gboolean show_dest_id,
                           ImportUIQuestionParams* question)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GeeList* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	GeeList* _tmp139_;
	gint _tmp140_;
	gint _tmp141_;
	GeeList* _tmp189_;
	gint _tmp190_;
	gint _tmp191_;
	GeeList* _tmp239_;
	gint _tmp240_;
	gint _tmp241_;
	GeeList* _tmp262_;
	gint _tmp263_;
	gint _tmp264_;
	GeeList* _tmp280_;
	gint _tmp281_;
	gint _tmp282_;
	GeeList* _tmp330_;
	gint _tmp331_;
	gint _tmp332_;
	gint total = 0;
	GeeList* _tmp367_;
	gint _tmp368_;
	gint _tmp369_;
	GeeList* _tmp370_;
	gint _tmp371_;
	gint _tmp372_;
	GeeList* _tmp373_;
	gint _tmp374_;
	gint _tmp375_;
	GeeList* _tmp376_;
	gint _tmp377_;
	gint _tmp378_;
	GeeList* _tmp379_;
	gint _tmp380_;
	gint _tmp381_;
	GeeList* _tmp382_;
	gint _tmp383_;
	gint _tmp384_;
	GeeList* _tmp385_;
	gint _tmp386_;
	gint _tmp387_;
	GeeList* _tmp388_;
	gint _tmp389_;
	gint _tmp390_;
	GeeList* _tmp391_;
	gint _tmp392_;
	gint _tmp393_;
	GeeList* _tmp394_;
	gint _tmp395_;
	gint _tmp396_;
	GtkMessageDialog* dialog = NULL;
	gint dialog_response = 0;
	gboolean result;
	g_return_val_if_fail (IS_IMPORT_MANIFEST (manifest), FALSE);
	g_return_val_if_fail ((question == NULL) || IMPORT_UI_IS_QUESTION_PARAMS (question), FALSE);
	_tmp0_ = g_strdup ("");
	message = _tmp0_;
	_tmp1_ = manifest->already_imported;
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gchar* photos_message = NULL;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GeeList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		gchar* videos_message = NULL;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gchar* both_message = NULL;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		GeeList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		GeeList* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		GeeList* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp4_ = manifest->already_imported;
		_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = _tmp5_;
		_tmp7_ = manifest->already_imported;
		_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (ngettext ("1 duplicate photo was not imported:\n", "%d duplicate photos were not imported:\n", (gulong) _tmp6_), _tmp9_);
		photos_message = _tmp10_;
		_tmp11_ = manifest->already_imported;
		_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp13_ = _tmp12_;
		_tmp14_ = manifest->already_imported;
		_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf (ngettext ("1 duplicate video was not imported:\n", "%d duplicate videos were not imported:\n", (gulong) _tmp13_), _tmp16_);
		videos_message = _tmp17_;
		_tmp18_ = manifest->already_imported;
		_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp20_ = _tmp19_;
		_tmp21_ = manifest->already_imported;
		_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf (ngettext ("1 duplicate photo/video was not imported:\n", "%d duplicate photos/videos were not imported:\n", (gulong) _tmp20_), _tmp23_);
		both_message = _tmp24_;
		_tmp25_ = message;
		_tmp26_ = manifest->already_imported;
		_tmp27_ = photos_message;
		_tmp28_ = videos_message;
		_tmp29_ = both_message;
		_tmp30_ = both_message;
		_tmp31_ = import_ui_get_media_specific_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_, _tmp28_, _tmp29_, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp25_, _tmp32_, NULL);
		_g_free0 (message);
		message = _tmp33_;
		_g_free0 (_tmp32_);
		_tmp34_ = message;
		_tmp35_ = manifest->already_imported;
		_tmp36_ = import_ui_generate_import_failure_list (_tmp35_, show_dest_id);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
		_g_free0 (message);
		message = _tmp38_;
		_g_free0 (_tmp37_);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp39_ = manifest->failed;
	_tmp40_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp41_ = _tmp40_;
	if (_tmp41_ > 0) {
		const gchar* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gchar* photos_message = NULL;
		GeeList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		GeeList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gchar* _tmp53_;
		gchar* videos_message = NULL;
		GeeList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		GeeList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gchar* _tmp60_;
		gchar* both_message = NULL;
		GeeList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		GeeList* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gchar* _tmp67_;
		gchar* neither_message = NULL;
		GeeList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		GeeList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gchar* _tmp74_;
		const gchar* _tmp75_;
		GeeList* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		const gchar* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		const gchar* _tmp84_;
		GeeList* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		_tmp42_ = message;
		_tmp43_ = strlen (_tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp44_ > 0) {
			const gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp45_ = message;
			_tmp46_ = g_strconcat (_tmp45_, "\n", NULL);
			_g_free0 (message);
			message = _tmp46_;
		}
		_tmp47_ = manifest->failed;
		_tmp48_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp49_ = _tmp48_;
		_tmp50_ = manifest->failed;
		_tmp51_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf (ngettext ("1 photo failed to import due to a file or hardware error:\n", "%d photos failed to import due to a file or hardware error:\n", (gulong) _tmp49_), _tmp52_);
		photos_message = _tmp53_;
		_tmp54_ = manifest->failed;
		_tmp55_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp56_ = _tmp55_;
		_tmp57_ = manifest->failed;
		_tmp58_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strdup_printf (ngettext ("1 video failed to import due to a file or hardware error:\n", "%d videos failed to import due to a file or hardware error:\n", (gulong) _tmp56_), _tmp59_);
		videos_message = _tmp60_;
		_tmp61_ = manifest->failed;
		_tmp62_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp63_ = _tmp62_;
		_tmp64_ = manifest->failed;
		_tmp65_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strdup_printf (ngettext ("1 photo/video failed to import due to a file or hardware error:\n", "%d photos/videos failed to import due to a file or hardware error:\n", (gulong) _tmp63_), _tmp66_);
		both_message = _tmp67_;
		_tmp68_ = manifest->failed;
		_tmp69_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp70_ = _tmp69_;
		_tmp71_ = manifest->failed;
		_tmp72_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strdup_printf (ngettext ("1 file failed to import due to a file or hardware error:\n", "%d files failed to import due to a file or hardware error:\n", (gulong) _tmp70_), _tmp73_);
		neither_message = _tmp74_;
		_tmp75_ = message;
		_tmp76_ = manifest->failed;
		_tmp77_ = photos_message;
		_tmp78_ = videos_message;
		_tmp79_ = both_message;
		_tmp80_ = neither_message;
		_tmp81_ = import_ui_get_media_specific_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_COLLECTION, GeeCollection), _tmp77_, _tmp78_, _tmp79_, _tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strconcat (_tmp75_, _tmp82_, NULL);
		_g_free0 (message);
		message = _tmp83_;
		_g_free0 (_tmp82_);
		_tmp84_ = message;
		_tmp85_ = manifest->failed;
		_tmp86_ = import_ui_generate_import_failure_list (_tmp85_, show_dest_id);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat (_tmp84_, _tmp87_, NULL);
		_g_free0 (message);
		message = _tmp88_;
		_g_free0 (_tmp87_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp89_ = manifest->write_failed;
	_tmp90_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp91_ = _tmp90_;
	if (_tmp91_ > 0) {
		const gchar* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gchar* photos_message = NULL;
		GeeList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		GeeList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gchar* _tmp103_;
		gchar* videos_message = NULL;
		GeeList* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		GeeList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gchar* _tmp110_;
		gchar* both_message = NULL;
		GeeList* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		GeeList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gchar* _tmp117_;
		gchar* neither_message = NULL;
		GeeList* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		GeeList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gchar* _tmp124_;
		const gchar* _tmp125_;
		GeeList* _tmp126_;
		const gchar* _tmp127_;
		const gchar* _tmp128_;
		const gchar* _tmp129_;
		const gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		const gchar* _tmp134_;
		GeeList* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		_tmp92_ = message;
		_tmp93_ = strlen (_tmp92_);
		_tmp94_ = _tmp93_;
		if (_tmp94_ > 0) {
			const gchar* _tmp95_;
			gchar* _tmp96_;
			_tmp95_ = message;
			_tmp96_ = g_strconcat (_tmp95_, "\n", NULL);
			_g_free0 (message);
			message = _tmp96_;
		}
		_tmp97_ = manifest->write_failed;
		_tmp98_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp99_ = _tmp98_;
		_tmp100_ = manifest->write_failed;
		_tmp101_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp102_ = _tmp101_;
		_tmp103_ = g_strdup_printf (ngettext ("1 photo failed to import because the photo library folder was not writ" \
"able:\n", "%d photos failed to import because the photo library folder was not wr" \
"itable:\n", (gulong) _tmp99_), _tmp102_);
		photos_message = _tmp103_;
		_tmp104_ = manifest->write_failed;
		_tmp105_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp106_ = _tmp105_;
		_tmp107_ = manifest->write_failed;
		_tmp108_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp109_ = _tmp108_;
		_tmp110_ = g_strdup_printf (ngettext ("1 video failed to import because the photo library folder was not writ" \
"able:\n", "%d videos failed to import because the photo library folder was not wr" \
"itable:\n", (gulong) _tmp106_), _tmp109_);
		videos_message = _tmp110_;
		_tmp111_ = manifest->write_failed;
		_tmp112_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp113_ = _tmp112_;
		_tmp114_ = manifest->write_failed;
		_tmp115_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp116_ = _tmp115_;
		_tmp117_ = g_strdup_printf (ngettext ("1 photo/video failed to import because the photo library folder was no" \
"t writable:\n", "%d photos/videos failed to import because the photo library folder was" \
" not writable:\n", (gulong) _tmp113_), _tmp116_);
		both_message = _tmp117_;
		_tmp118_ = manifest->write_failed;
		_tmp119_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp120_ = _tmp119_;
		_tmp121_ = manifest->write_failed;
		_tmp122_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp123_ = _tmp122_;
		_tmp124_ = g_strdup_printf (ngettext ("1 file failed to import because the photo library folder was not writa" \
"ble:\n", "%d files failed to import because the photo library folder was not wri" \
"table:\n", (gulong) _tmp120_), _tmp123_);
		neither_message = _tmp124_;
		_tmp125_ = message;
		_tmp126_ = manifest->write_failed;
		_tmp127_ = photos_message;
		_tmp128_ = videos_message;
		_tmp129_ = both_message;
		_tmp130_ = neither_message;
		_tmp131_ = import_ui_get_media_specific_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, GEE_TYPE_COLLECTION, GeeCollection), _tmp127_, _tmp128_, _tmp129_, _tmp130_);
		_tmp132_ = _tmp131_;
		_tmp133_ = g_strconcat (_tmp125_, _tmp132_, NULL);
		_g_free0 (message);
		message = _tmp133_;
		_g_free0 (_tmp132_);
		_tmp134_ = message;
		_tmp135_ = manifest->write_failed;
		_tmp136_ = import_ui_generate_import_failure_list (_tmp135_, show_dest_id);
		_tmp137_ = _tmp136_;
		_tmp138_ = g_strconcat (_tmp134_, _tmp137_, NULL);
		_g_free0 (message);
		message = _tmp138_;
		_g_free0 (_tmp137_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp139_ = manifest->camera_failed;
	_tmp140_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp141_ = _tmp140_;
	if (_tmp141_ > 0) {
		const gchar* _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
		gchar* photos_message = NULL;
		GeeList* _tmp147_;
		gint _tmp148_;
		gint _tmp149_;
		GeeList* _tmp150_;
		gint _tmp151_;
		gint _tmp152_;
		gchar* _tmp153_;
		gchar* videos_message = NULL;
		GeeList* _tmp154_;
		gint _tmp155_;
		gint _tmp156_;
		GeeList* _tmp157_;
		gint _tmp158_;
		gint _tmp159_;
		gchar* _tmp160_;
		gchar* both_message = NULL;
		GeeList* _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
		GeeList* _tmp164_;
		gint _tmp165_;
		gint _tmp166_;
		gchar* _tmp167_;
		gchar* neither_message = NULL;
		GeeList* _tmp168_;
		gint _tmp169_;
		gint _tmp170_;
		GeeList* _tmp171_;
		gint _tmp172_;
		gint _tmp173_;
		gchar* _tmp174_;
		const gchar* _tmp175_;
		GeeList* _tmp176_;
		const gchar* _tmp177_;
		const gchar* _tmp178_;
		const gchar* _tmp179_;
		const gchar* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		const gchar* _tmp184_;
		GeeList* _tmp185_;
		gchar* _tmp186_;
		gchar* _tmp187_;
		gchar* _tmp188_;
		_tmp142_ = message;
		_tmp143_ = strlen (_tmp142_);
		_tmp144_ = _tmp143_;
		if (_tmp144_ > 0) {
			const gchar* _tmp145_;
			gchar* _tmp146_;
			_tmp145_ = message;
			_tmp146_ = g_strconcat (_tmp145_, "\n", NULL);
			_g_free0 (message);
			message = _tmp146_;
		}
		_tmp147_ = manifest->camera_failed;
		_tmp148_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp149_ = _tmp148_;
		_tmp150_ = manifest->camera_failed;
		_tmp151_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp152_ = _tmp151_;
		_tmp153_ = g_strdup_printf (ngettext ("1 photo failed to import due to a camera error:\n", "%d photos failed to import due to a camera error:\n", (gulong) _tmp149_), _tmp152_);
		photos_message = _tmp153_;
		_tmp154_ = manifest->camera_failed;
		_tmp155_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp154_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp156_ = _tmp155_;
		_tmp157_ = manifest->camera_failed;
		_tmp158_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp159_ = _tmp158_;
		_tmp160_ = g_strdup_printf (ngettext ("1 video failed to import due to a camera error:\n", "%d videos failed to import due to a camera error:\n", (gulong) _tmp156_), _tmp159_);
		videos_message = _tmp160_;
		_tmp161_ = manifest->camera_failed;
		_tmp162_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp163_ = _tmp162_;
		_tmp164_ = manifest->camera_failed;
		_tmp165_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp166_ = _tmp165_;
		_tmp167_ = g_strdup_printf (ngettext ("1 photo/video failed to import due to a camera error:\n", "%d photos/videos failed to import due to a camera error:\n", (gulong) _tmp163_), _tmp166_);
		both_message = _tmp167_;
		_tmp168_ = manifest->camera_failed;
		_tmp169_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp170_ = _tmp169_;
		_tmp171_ = manifest->camera_failed;
		_tmp172_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp171_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp173_ = _tmp172_;
		_tmp174_ = g_strdup_printf (ngettext ("1 file failed to import due to a camera error:\n", "%d files failed to import due to a camera error:\n", (gulong) _tmp170_), _tmp173_);
		neither_message = _tmp174_;
		_tmp175_ = message;
		_tmp176_ = manifest->camera_failed;
		_tmp177_ = photos_message;
		_tmp178_ = videos_message;
		_tmp179_ = both_message;
		_tmp180_ = neither_message;
		_tmp181_ = import_ui_get_media_specific_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp176_, GEE_TYPE_COLLECTION, GeeCollection), _tmp177_, _tmp178_, _tmp179_, _tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = g_strconcat (_tmp175_, _tmp182_, NULL);
		_g_free0 (message);
		message = _tmp183_;
		_g_free0 (_tmp182_);
		_tmp184_ = message;
		_tmp185_ = manifest->camera_failed;
		_tmp186_ = import_ui_generate_import_failure_list (_tmp185_, show_dest_id);
		_tmp187_ = _tmp186_;
		_tmp188_ = g_strconcat (_tmp184_, _tmp187_, NULL);
		_g_free0 (message);
		message = _tmp188_;
		_g_free0 (_tmp187_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp189_ = manifest->corrupt_files;
	_tmp190_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp191_ = _tmp190_;
	if (_tmp191_ > 0) {
		const gchar* _tmp192_;
		gint _tmp193_;
		gint _tmp194_;
		gchar* photos_message = NULL;
		GeeList* _tmp197_;
		gint _tmp198_;
		gint _tmp199_;
		GeeList* _tmp200_;
		gint _tmp201_;
		gint _tmp202_;
		gchar* _tmp203_;
		gchar* videos_message = NULL;
		GeeList* _tmp204_;
		gint _tmp205_;
		gint _tmp206_;
		GeeList* _tmp207_;
		gint _tmp208_;
		gint _tmp209_;
		gchar* _tmp210_;
		gchar* both_message = NULL;
		GeeList* _tmp211_;
		gint _tmp212_;
		gint _tmp213_;
		GeeList* _tmp214_;
		gint _tmp215_;
		gint _tmp216_;
		gchar* _tmp217_;
		gchar* neither_message = NULL;
		GeeList* _tmp218_;
		gint _tmp219_;
		gint _tmp220_;
		GeeList* _tmp221_;
		gint _tmp222_;
		gint _tmp223_;
		gchar* _tmp224_;
		const gchar* _tmp225_;
		GeeList* _tmp226_;
		const gchar* _tmp227_;
		const gchar* _tmp228_;
		const gchar* _tmp229_;
		const gchar* _tmp230_;
		gchar* _tmp231_;
		gchar* _tmp232_;
		gchar* _tmp233_;
		const gchar* _tmp234_;
		GeeList* _tmp235_;
		gchar* _tmp236_;
		gchar* _tmp237_;
		gchar* _tmp238_;
		_tmp192_ = message;
		_tmp193_ = strlen (_tmp192_);
		_tmp194_ = _tmp193_;
		if (_tmp194_ > 0) {
			const gchar* _tmp195_;
			gchar* _tmp196_;
			_tmp195_ = message;
			_tmp196_ = g_strconcat (_tmp195_, "\n", NULL);
			_g_free0 (message);
			message = _tmp196_;
		}
		_tmp197_ = manifest->corrupt_files;
		_tmp198_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp199_ = _tmp198_;
		_tmp200_ = manifest->corrupt_files;
		_tmp201_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp202_ = _tmp201_;
		_tmp203_ = g_strdup_printf (ngettext ("1 photo failed to import because it was corrupt:\n", "%d photos failed to import because they were corrupt:\n", (gulong) _tmp199_), _tmp202_);
		photos_message = _tmp203_;
		_tmp204_ = manifest->corrupt_files;
		_tmp205_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp206_ = _tmp205_;
		_tmp207_ = manifest->corrupt_files;
		_tmp208_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp207_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp209_ = _tmp208_;
		_tmp210_ = g_strdup_printf (ngettext ("1 video failed to import because it was corrupt:\n", "%d videos failed to import because they were corrupt:\n", (gulong) _tmp206_), _tmp209_);
		videos_message = _tmp210_;
		_tmp211_ = manifest->corrupt_files;
		_tmp212_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp211_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp213_ = _tmp212_;
		_tmp214_ = manifest->corrupt_files;
		_tmp215_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp214_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp216_ = _tmp215_;
		_tmp217_ = g_strdup_printf (ngettext ("1 photo/video failed to import because it was corrupt:\n", "%d photos/videos failed to import because they were corrupt:\n", (gulong) _tmp213_), _tmp216_);
		both_message = _tmp217_;
		_tmp218_ = manifest->corrupt_files;
		_tmp219_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp218_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp220_ = _tmp219_;
		_tmp221_ = manifest->corrupt_files;
		_tmp222_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp221_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp223_ = _tmp222_;
		_tmp224_ = g_strdup_printf (ngettext ("1 file failed to import because it was corrupt:\n", "%d files failed to import because it was corrupt:\n", (gulong) _tmp220_), _tmp223_);
		neither_message = _tmp224_;
		_tmp225_ = message;
		_tmp226_ = manifest->corrupt_files;
		_tmp227_ = photos_message;
		_tmp228_ = videos_message;
		_tmp229_ = both_message;
		_tmp230_ = neither_message;
		_tmp231_ = import_ui_get_media_specific_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp226_, GEE_TYPE_COLLECTION, GeeCollection), _tmp227_, _tmp228_, _tmp229_, _tmp230_);
		_tmp232_ = _tmp231_;
		_tmp233_ = g_strconcat (_tmp225_, _tmp232_, NULL);
		_g_free0 (message);
		message = _tmp233_;
		_g_free0 (_tmp232_);
		_tmp234_ = message;
		_tmp235_ = manifest->corrupt_files;
		_tmp236_ = import_ui_generate_import_failure_list (_tmp235_, show_dest_id);
		_tmp237_ = _tmp236_;
		_tmp238_ = g_strconcat (_tmp234_, _tmp237_, NULL);
		_g_free0 (message);
		message = _tmp238_;
		_g_free0 (_tmp237_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp239_ = manifest->skipped_photos;
	_tmp240_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp239_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp241_ = _tmp240_;
	if (_tmp241_ > 0) {
		const gchar* _tmp242_;
		gint _tmp243_;
		gint _tmp244_;
		gchar* skipped_photos_message = NULL;
		GeeList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		GeeList* _tmp250_;
		gint _tmp251_;
		gint _tmp252_;
		gchar* _tmp253_;
		const gchar* _tmp254_;
		const gchar* _tmp255_;
		gchar* _tmp256_;
		const gchar* _tmp257_;
		GeeList* _tmp258_;
		gchar* _tmp259_;
		gchar* _tmp260_;
		gchar* _tmp261_;
		_tmp242_ = message;
		_tmp243_ = strlen (_tmp242_);
		_tmp244_ = _tmp243_;
		if (_tmp244_ > 0) {
			const gchar* _tmp245_;
			gchar* _tmp246_;
			_tmp245_ = message;
			_tmp246_ = g_strconcat (_tmp245_, "\n", NULL);
			_g_free0 (message);
			message = _tmp246_;
		}
		_tmp247_ = manifest->skipped_photos;
		_tmp248_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp247_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp249_ = _tmp248_;
		_tmp250_ = manifest->skipped_photos;
		_tmp251_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp250_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp252_ = _tmp251_;
		_tmp253_ = g_strdup_printf (ngettext ("1 unsupported photo skipped:\n", "%d unsupported photos skipped:\n", (gulong) _tmp249_), _tmp252_);
		skipped_photos_message = _tmp253_;
		_tmp254_ = message;
		_tmp255_ = skipped_photos_message;
		_tmp256_ = g_strconcat (_tmp254_, _tmp255_, NULL);
		_g_free0 (message);
		message = _tmp256_;
		_tmp257_ = message;
		_tmp258_ = manifest->skipped_photos;
		_tmp259_ = import_ui_generate_import_failure_list (_tmp258_, show_dest_id);
		_tmp260_ = _tmp259_;
		_tmp261_ = g_strconcat (_tmp257_, _tmp260_, NULL);
		_g_free0 (message);
		message = _tmp261_;
		_g_free0 (_tmp260_);
		_g_free0 (skipped_photos_message);
	}
	_tmp262_ = manifest->skipped_files;
	_tmp263_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp262_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp264_ = _tmp263_;
	if (_tmp264_ > 0) {
		const gchar* _tmp265_;
		gint _tmp266_;
		gint _tmp267_;
		gchar* skipped_files_message = NULL;
		GeeList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		GeeList* _tmp273_;
		gint _tmp274_;
		gint _tmp275_;
		gchar* _tmp276_;
		const gchar* _tmp277_;
		const gchar* _tmp278_;
		gchar* _tmp279_;
		_tmp265_ = message;
		_tmp266_ = strlen (_tmp265_);
		_tmp267_ = _tmp266_;
		if (_tmp267_ > 0) {
			const gchar* _tmp268_;
			gchar* _tmp269_;
			_tmp268_ = message;
			_tmp269_ = g_strconcat (_tmp268_, "\n", NULL);
			_g_free0 (message);
			message = _tmp269_;
		}
		_tmp270_ = manifest->skipped_files;
		_tmp271_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp272_ = _tmp271_;
		_tmp273_ = manifest->skipped_files;
		_tmp274_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp275_ = _tmp274_;
		_tmp276_ = g_strdup_printf (ngettext ("1 non-image file skipped.\n", "%d non-image files skipped.\n", (gulong) _tmp272_), _tmp275_);
		skipped_files_message = _tmp276_;
		_tmp277_ = message;
		_tmp278_ = skipped_files_message;
		_tmp279_ = g_strconcat (_tmp277_, _tmp278_, NULL);
		_g_free0 (message);
		message = _tmp279_;
		_g_free0 (skipped_files_message);
	}
	_tmp280_ = manifest->aborted;
	_tmp281_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp280_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp282_ = _tmp281_;
	if (_tmp282_ > 0) {
		const gchar* _tmp283_;
		gint _tmp284_;
		gint _tmp285_;
		gchar* photos_message = NULL;
		GeeList* _tmp288_;
		gint _tmp289_;
		gint _tmp290_;
		GeeList* _tmp291_;
		gint _tmp292_;
		gint _tmp293_;
		gchar* _tmp294_;
		gchar* videos_message = NULL;
		GeeList* _tmp295_;
		gint _tmp296_;
		gint _tmp297_;
		GeeList* _tmp298_;
		gint _tmp299_;
		gint _tmp300_;
		gchar* _tmp301_;
		gchar* both_message = NULL;
		GeeList* _tmp302_;
		gint _tmp303_;
		gint _tmp304_;
		GeeList* _tmp305_;
		gint _tmp306_;
		gint _tmp307_;
		gchar* _tmp308_;
		gchar* neither_message = NULL;
		GeeList* _tmp309_;
		gint _tmp310_;
		gint _tmp311_;
		GeeList* _tmp312_;
		gint _tmp313_;
		gint _tmp314_;
		gchar* _tmp315_;
		const gchar* _tmp316_;
		GeeList* _tmp317_;
		const gchar* _tmp318_;
		const gchar* _tmp319_;
		const gchar* _tmp320_;
		const gchar* _tmp321_;
		gchar* _tmp322_;
		gchar* _tmp323_;
		gchar* _tmp324_;
		const gchar* _tmp325_;
		GeeList* _tmp326_;
		gchar* _tmp327_;
		gchar* _tmp328_;
		gchar* _tmp329_;
		_tmp283_ = message;
		_tmp284_ = strlen (_tmp283_);
		_tmp285_ = _tmp284_;
		if (_tmp285_ > 0) {
			const gchar* _tmp286_;
			gchar* _tmp287_;
			_tmp286_ = message;
			_tmp287_ = g_strconcat (_tmp286_, "\n", NULL);
			_g_free0 (message);
			message = _tmp287_;
		}
		_tmp288_ = manifest->aborted;
		_tmp289_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp288_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp290_ = _tmp289_;
		_tmp291_ = manifest->aborted;
		_tmp292_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp291_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp293_ = _tmp292_;
		_tmp294_ = g_strdup_printf (ngettext ("1 photo skipped due to user cancel:\n", "%d photos skipped due to user cancel:\n", (gulong) _tmp290_), _tmp293_);
		photos_message = _tmp294_;
		_tmp295_ = manifest->aborted;
		_tmp296_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp295_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp297_ = _tmp296_;
		_tmp298_ = manifest->aborted;
		_tmp299_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp298_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp300_ = _tmp299_;
		_tmp301_ = g_strdup_printf (ngettext ("1 video skipped due to user cancel:\n", "%d videos skipped due to user cancel:\n", (gulong) _tmp297_), _tmp300_);
		videos_message = _tmp301_;
		_tmp302_ = manifest->aborted;
		_tmp303_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp304_ = _tmp303_;
		_tmp305_ = manifest->aborted;
		_tmp306_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp305_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp307_ = _tmp306_;
		_tmp308_ = g_strdup_printf (ngettext ("1 photo/video skipped due to user cancel:\n", "%d photos/videos skipped due to user cancel:\n", (gulong) _tmp304_), _tmp307_);
		both_message = _tmp308_;
		_tmp309_ = manifest->aborted;
		_tmp310_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp309_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp311_ = _tmp310_;
		_tmp312_ = manifest->aborted;
		_tmp313_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp312_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp314_ = _tmp313_;
		_tmp315_ = g_strdup_printf (ngettext ("1 file skipped due to user cancel:\n", "%d file skipped due to user cancel:\n", (gulong) _tmp311_), _tmp314_);
		neither_message = _tmp315_;
		_tmp316_ = message;
		_tmp317_ = manifest->aborted;
		_tmp318_ = photos_message;
		_tmp319_ = videos_message;
		_tmp320_ = both_message;
		_tmp321_ = neither_message;
		_tmp322_ = import_ui_get_media_specific_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, GEE_TYPE_COLLECTION, GeeCollection), _tmp318_, _tmp319_, _tmp320_, _tmp321_);
		_tmp323_ = _tmp322_;
		_tmp324_ = g_strconcat (_tmp316_, _tmp323_, NULL);
		_g_free0 (message);
		message = _tmp324_;
		_g_free0 (_tmp323_);
		_tmp325_ = message;
		_tmp326_ = manifest->aborted;
		_tmp327_ = import_ui_generate_import_failure_list (_tmp326_, show_dest_id);
		_tmp328_ = _tmp327_;
		_tmp329_ = g_strconcat (_tmp325_, _tmp328_, NULL);
		_g_free0 (message);
		message = _tmp329_;
		_g_free0 (_tmp328_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp330_ = manifest->success;
	_tmp331_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp332_ = _tmp331_;
	if (_tmp332_ > 0) {
		const gchar* _tmp333_;
		gint _tmp334_;
		gint _tmp335_;
		gchar* photos_message = NULL;
		GeeList* _tmp338_;
		gint _tmp339_;
		gint _tmp340_;
		GeeList* _tmp341_;
		gint _tmp342_;
		gint _tmp343_;
		gchar* _tmp344_;
		gchar* videos_message = NULL;
		GeeList* _tmp345_;
		gint _tmp346_;
		gint _tmp347_;
		GeeList* _tmp348_;
		gint _tmp349_;
		gint _tmp350_;
		gchar* _tmp351_;
		gchar* both_message = NULL;
		GeeList* _tmp352_;
		gint _tmp353_;
		gint _tmp354_;
		GeeList* _tmp355_;
		gint _tmp356_;
		gint _tmp357_;
		gchar* _tmp358_;
		const gchar* _tmp359_;
		GeeList* _tmp360_;
		const gchar* _tmp361_;
		const gchar* _tmp362_;
		const gchar* _tmp363_;
		gchar* _tmp364_;
		gchar* _tmp365_;
		gchar* _tmp366_;
		_tmp333_ = message;
		_tmp334_ = strlen (_tmp333_);
		_tmp335_ = _tmp334_;
		if (_tmp335_ > 0) {
			const gchar* _tmp336_;
			gchar* _tmp337_;
			_tmp336_ = message;
			_tmp337_ = g_strconcat (_tmp336_, "\n", NULL);
			_g_free0 (message);
			message = _tmp337_;
		}
		_tmp338_ = manifest->success;
		_tmp339_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp338_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp340_ = _tmp339_;
		_tmp341_ = manifest->success;
		_tmp342_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp341_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp343_ = _tmp342_;
		_tmp344_ = g_strdup_printf (ngettext ("1 photo successfully imported.\n", "%d photos successfully imported.\n", (gulong) _tmp340_), _tmp343_);
		photos_message = _tmp344_;
		_tmp345_ = manifest->success;
		_tmp346_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp345_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp347_ = _tmp346_;
		_tmp348_ = manifest->success;
		_tmp349_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp348_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp350_ = _tmp349_;
		_tmp351_ = g_strdup_printf (ngettext ("1 video successfully imported.\n", "%d videos successfully imported.\n", (gulong) _tmp347_), _tmp350_);
		videos_message = _tmp351_;
		_tmp352_ = manifest->success;
		_tmp353_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp352_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp354_ = _tmp353_;
		_tmp355_ = manifest->success;
		_tmp356_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp355_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp357_ = _tmp356_;
		_tmp358_ = g_strdup_printf (ngettext ("1 photo/video successfully imported.\n", "%d photos/videos successfully imported.\n", (gulong) _tmp354_), _tmp357_);
		both_message = _tmp358_;
		_tmp359_ = message;
		_tmp360_ = manifest->success;
		_tmp361_ = photos_message;
		_tmp362_ = videos_message;
		_tmp363_ = both_message;
		_tmp364_ = import_ui_get_media_specific_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, GEE_TYPE_COLLECTION, GeeCollection), _tmp361_, _tmp362_, _tmp363_, "");
		_tmp365_ = _tmp364_;
		_tmp366_ = g_strconcat (_tmp359_, _tmp365_, NULL);
		_g_free0 (message);
		message = _tmp366_;
		_g_free0 (_tmp365_);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp367_ = manifest->success;
	_tmp368_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp367_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp369_ = _tmp368_;
	_tmp370_ = manifest->failed;
	_tmp371_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp370_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp372_ = _tmp371_;
	_tmp373_ = manifest->camera_failed;
	_tmp374_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp373_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp375_ = _tmp374_;
	_tmp376_ = manifest->skipped_photos;
	_tmp377_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp376_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp378_ = _tmp377_;
	_tmp379_ = manifest->skipped_files;
	_tmp380_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp379_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp381_ = _tmp380_;
	_tmp382_ = manifest->corrupt_files;
	_tmp383_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp382_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp384_ = _tmp383_;
	_tmp385_ = manifest->already_imported;
	_tmp386_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp385_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp387_ = _tmp386_;
	_tmp388_ = manifest->aborted;
	_tmp389_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp388_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp390_ = _tmp389_;
	_tmp391_ = manifest->write_failed;
	_tmp392_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp391_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp393_ = _tmp392_;
	total = (((((((_tmp369_ + _tmp372_) + _tmp375_) + _tmp378_) + _tmp381_) + _tmp384_) + _tmp387_) + _tmp390_) + _tmp393_;
	_tmp394_ = manifest->all;
	_tmp395_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp394_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp396_ = _tmp395_;
	_vala_assert (total == _tmp396_, "total == manifest.all.size");
	if (total == 0) {
		const gchar* _tmp397_;
		gchar* _tmp398_;
		_tmp397_ = message;
		_tmp398_ = g_strconcat (_tmp397_, _ ("No photos or videos imported.\n"), NULL);
		_g_free0 (message);
		message = _tmp398_;
	}
	dialog = NULL;
	dialog_response = (gint) GTK_RESPONSE_NONE;
	if (question == NULL) {
		AppWindow* _tmp399_;
		AppWindow* _tmp400_;
		const gchar* _tmp401_;
		GtkMessageDialog* _tmp402_;
		GtkMessageDialog* _tmp403_;
		GtkWidget* save_results_button = NULL;
		GtkMessageDialog* _tmp404_;
		GtkWidget* _tmp405_;
		GtkWidget* _tmp406_;
		GtkWidget* _tmp407_;
		GeeList* _tmp408_;
		gint _tmp409_;
		gint _tmp410_;
		GeeList* _tmp411_;
		gint _tmp412_;
		gint _tmp413_;
		GtkWidget* ok_button = NULL;
		GtkMessageDialog* _tmp414_;
		GtkWidget* _tmp415_;
		GtkWidget* _tmp416_;
		GtkMessageDialog* _tmp417_;
		GtkWidget* _tmp418_;
		GtkWindow* dialog_parent = NULL;
		GtkMessageDialog* _tmp419_;
		GtkContainer* _tmp420_;
		GtkWindow* _tmp421_;
		GtkMessageDialog* _tmp422_;
		GtkMessageDialog* _tmp423_;
		_tmp399_ = app_window_get_instance ();
		_tmp400_ = _tmp399_;
		_tmp401_ = message;
		_tmp402_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp400_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", _tmp401_);
		g_object_ref_sink (_tmp402_);
		_g_object_unref0 (dialog);
		dialog = _tmp402_;
		_g_object_unref0 (_tmp400_);
		_tmp403_ = dialog;
		gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp403_, gtk_window_get_type (), GtkWindow), _ ("Import Complete"));
		_tmp404_ = dialog;
		_tmp405_ = gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp404_, gtk_dialog_get_type (), GtkDialog), IMPORT_UI_SAVE_RESULTS_BUTTON_NAME, IMPORT_UI_SAVE_RESULTS_RESPONSE_ID);
		_tmp406_ = _g_object_ref0 (_tmp405_);
		save_results_button = _tmp406_;
		_tmp407_ = save_results_button;
		_tmp408_ = manifest->success;
		_tmp409_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp408_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp410_ = _tmp409_;
		_tmp411_ = manifest->all;
		_tmp412_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp413_ = _tmp412_;
		gtk_widget_set_visible (_tmp407_, _tmp410_ < _tmp413_);
		_tmp414_ = dialog;
		_tmp415_ = gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, gtk_dialog_get_type (), GtkDialog), RESOURCES_OK_LABEL, (gint) GTK_RESPONSE_OK);
		_tmp416_ = _g_object_ref0 (_tmp415_);
		ok_button = _tmp416_;
		_tmp417_ = dialog;
		_tmp418_ = ok_button;
		gtk_window_set_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp417_, gtk_window_get_type (), GtkWindow), _tmp418_);
		_tmp419_ = dialog;
		_tmp420_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp419_, gtk_widget_get_type (), GtkWidget));
		_tmp421_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, gtk_window_get_type (), GtkWindow));
		dialog_parent = _tmp421_;
		_tmp422_ = dialog;
		dialog_response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp422_, gtk_dialog_get_type (), GtkDialog));
		_tmp423_ = dialog;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp423_, gtk_widget_get_type (), GtkWidget));
		if (dialog_response == IMPORT_UI_SAVE_RESULTS_RESPONSE_ID) {
			GtkWindow* _tmp424_;
			gchar* _tmp425_;
			gchar* _tmp426_;
			_tmp424_ = dialog_parent;
			_tmp425_ = import_ui_create_result_report_from_manifest (manifest);
			_tmp426_ = _tmp425_;
			import_ui_save_import_results (_tmp424_, _tmp426_);
			_g_free0 (_tmp426_);
		}
		_g_object_unref0 (dialog_parent);
		_g_object_unref0 (ok_button);
		_g_object_unref0 (save_results_button);
	} else {
		const gchar* _tmp427_;
		const gchar* _tmp428_;
		gchar* _tmp429_;
		gchar* _tmp430_;
		gchar* _tmp431_;
		AppWindow* _tmp432_;
		AppWindow* _tmp433_;
		const gchar* _tmp434_;
		GtkMessageDialog* _tmp435_;
		GtkMessageDialog* _tmp436_;
		GtkWidget* save_results_button = NULL;
		GtkMessageDialog* _tmp437_;
		GtkWidget* _tmp438_;
		GtkWidget* _tmp439_;
		GtkWidget* _tmp440_;
		GeeList* _tmp441_;
		gint _tmp442_;
		gint _tmp443_;
		GeeList* _tmp444_;
		gint _tmp445_;
		gint _tmp446_;
		GtkWidget* no_button = NULL;
		GtkMessageDialog* _tmp447_;
		const gchar* _tmp448_;
		GtkWidget* _tmp449_;
		GtkWidget* _tmp450_;
		GtkMessageDialog* _tmp451_;
		const gchar* _tmp452_;
		GtkMessageDialog* _tmp453_;
		GtkWidget* _tmp454_;
		GtkMessageDialog* _tmp455_;
		GtkMessageDialog* _tmp460_;
		GtkMessageDialog* _tmp461_;
		_tmp427_ = message;
		_tmp428_ = question->question;
		_tmp429_ = g_strconcat ("\n", _tmp428_, NULL);
		_tmp430_ = _tmp429_;
		_tmp431_ = g_strconcat (_tmp427_, _tmp430_, NULL);
		_g_free0 (message);
		message = _tmp431_;
		_g_free0 (_tmp430_);
		_tmp432_ = app_window_get_instance ();
		_tmp433_ = _tmp432_;
		_tmp434_ = message;
		_tmp435_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp433_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp434_);
		g_object_ref_sink (_tmp435_);
		_g_object_unref0 (dialog);
		dialog = _tmp435_;
		_g_object_unref0 (_tmp433_);
		_tmp436_ = dialog;
		gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp436_, gtk_window_get_type (), GtkWindow), _ ("Import Complete"));
		_tmp437_ = dialog;
		_tmp438_ = gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp437_, gtk_dialog_get_type (), GtkDialog), IMPORT_UI_SAVE_RESULTS_BUTTON_NAME, IMPORT_UI_SAVE_RESULTS_RESPONSE_ID);
		_tmp439_ = _g_object_ref0 (_tmp438_);
		save_results_button = _tmp439_;
		_tmp440_ = save_results_button;
		_tmp441_ = manifest->success;
		_tmp442_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp441_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp443_ = _tmp442_;
		_tmp444_ = manifest->all;
		_tmp445_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp444_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp446_ = _tmp445_;
		gtk_widget_set_visible (_tmp440_, _tmp443_ < _tmp446_);
		_tmp447_ = dialog;
		_tmp448_ = question->no_button;
		_tmp449_ = gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp447_, gtk_dialog_get_type (), GtkDialog), _tmp448_, (gint) GTK_RESPONSE_NO);
		_tmp450_ = _g_object_ref0 (_tmp449_);
		no_button = _tmp450_;
		_tmp451_ = dialog;
		_tmp452_ = question->yes_button;
		gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp451_, gtk_dialog_get_type (), GtkDialog), _tmp452_, (gint) GTK_RESPONSE_YES);
		_tmp453_ = dialog;
		_tmp454_ = no_button;
		gtk_window_set_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp453_, gtk_window_get_type (), GtkWindow), _tmp454_);
		_tmp455_ = dialog;
		dialog_response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp455_, gtk_dialog_get_type (), GtkDialog));
		while (TRUE) {
			GtkMessageDialog* _tmp456_;
			gchar* _tmp457_;
			gchar* _tmp458_;
			GtkMessageDialog* _tmp459_;
			if (!(dialog_response == IMPORT_UI_SAVE_RESULTS_RESPONSE_ID)) {
				break;
			}
			_tmp456_ = dialog;
			_tmp457_ = import_ui_create_result_report_from_manifest (manifest);
			_tmp458_ = _tmp457_;
			import_ui_save_import_results (G_TYPE_CHECK_INSTANCE_CAST (_tmp456_, gtk_window_get_type (), GtkWindow), _tmp458_);
			_g_free0 (_tmp458_);
			_tmp459_ = dialog;
			dialog_response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, gtk_dialog_get_type (), GtkDialog));
		}
		_tmp460_ = dialog;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp460_, gtk_widget_get_type (), GtkWidget));
		_tmp461_ = dialog;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp461_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (no_button);
		_g_object_unref0 (save_results_button);
	}
	result = dialog_response == ((gint) GTK_RESPONSE_YES);
	_g_object_unref0 (dialog);
	_g_free0 (message);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
import_ui_save_import_results (GtkWindow* chooser_dialog_parent,
                               const gchar* results_log)
{
	GtkFileChooserNative* chooser_dialog = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	const gchar* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	gint dialog_result = 0;
	GtkFileChooserNative* _tmp6_;
	GFile* chosen_file = NULL;
	GtkFileChooserNative* _tmp7_;
	GFile* _tmp8_;
	GtkFileChooserNative* _tmp9_;
	GtkFileChooserNative* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail ((chooser_dialog_parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (chooser_dialog_parent, gtk_window_get_type ()));
	g_return_if_fail (results_log != NULL);
	_tmp0_ = gtk_file_chooser_native_new (IMPORT_UI_SAVE_RESULTS_FILE_CHOOSER_TITLE, chooser_dialog_parent, GTK_FILE_CHOOSER_ACTION_SAVE, RESOURCES_SAVE_AS_LABEL, RESOURCES_CANCEL_LABEL);
	chooser_dialog = _tmp0_;
	_tmp1_ = chooser_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_file_chooser_get_type (), GtkFileChooser), TRUE);
	_tmp2_ = chooser_dialog;
	_tmp3_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_file_chooser_get_type (), GtkFileChooser), _tmp3_);
	_tmp4_ = chooser_dialog;
	gtk_file_chooser_set_current_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_file_chooser_get_type (), GtkFileChooser), "Shotwell Import Log.txt");
	_tmp5_ = chooser_dialog;
	gtk_file_chooser_set_local_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
	_tmp6_ = chooser_dialog;
	dialog_result = gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_native_dialog_get_type (), GtkNativeDialog));
	_tmp7_ = chooser_dialog;
	_tmp8_ = gtk_file_chooser_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_file_chooser_get_type (), GtkFileChooser));
	chosen_file = _tmp8_;
	_tmp9_ = chooser_dialog;
	gtk_native_dialog_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_native_dialog_get_type (), GtkNativeDialog));
	_tmp10_ = chooser_dialog;
	gtk_native_dialog_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_native_dialog_get_type (), GtkNativeDialog));
	if (dialog_result == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile* _tmp12_;
		_tmp12_ = chosen_file;
		_tmp11_ = _tmp12_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		{
			GFileOutputStream* outstream = NULL;
			GFile* _tmp13_;
			GFileOutputStream* _tmp14_;
			GFileOutputStream* _tmp15_;
			guint8* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_ = 0;
			guint8* _tmp18_;
			gint _tmp18__length1;
			GFileOutputStream* _tmp19_;
			_tmp13_ = chosen_file;
			_tmp14_ = g_file_replace (_tmp13_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			outstream = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp15_ = outstream;
			_tmp16_ = string_get_data (results_log, &_tmp17_);
			_tmp16__length1 = _tmp17_;
			_tmp18_ = _tmp16_;
			_tmp18__length1 = _tmp16__length1;
			g_output_stream_write (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_output_stream_get_type (), GOutputStream), _tmp18_, (gsize) _tmp18__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (outstream);
				goto __catch0_g_error;
			}
			_tmp19_ = outstream;
			g_output_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_output_stream_get_type (), GOutputStream), NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (outstream);
				goto __catch0_g_error;
			}
			_g_object_unref0 (outstream);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = chosen_file;
			_tmp21_ = g_file_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = err;
			_tmp24_ = _tmp23_->message;
			g_critical ("Dialogs.vala:598: couldn't save import results to log file %s: %s", _tmp22_, _tmp24_);
			_g_free0 (_tmp22_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (chosen_file);
			_g_object_unref0 (chooser_dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (chosen_file);
	_g_object_unref0 (chooser_dialog);
}

static inline gpointer
text_entry_dialog_mediator_get_instance_private (TextEntryDialogMediator* self)
{
	return G_STRUCT_MEMBER_P (self, TextEntryDialogMediator_private_offset);
}

static gboolean
_text_entry_dialog_mediator_on_modify_validate_text_entry_dialog_on_modify_validate_type (const gchar* text,
                                                                                          gpointer self)
{
	gboolean result;
	result = text_entry_dialog_mediator_on_modify_validate ((TextEntryDialogMediator*) self, text);
	return result;
}

TextEntryDialogMediator*
text_entry_dialog_mediator_construct (GType object_type,
                                      const gchar* title,
                                      const gchar* label,
                                      const gchar* initial_text,
                                      GeeCollection* completion_list,
                                      const gchar* completion_delimiter)
{
	TextEntryDialogMediator* self = NULL;
	TextEntryDialog* _tmp0_;
	TextEntryDialog* _tmp1_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail ((completion_list == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (completion_list, GEE_TYPE_COLLECTION), NULL);
	self = (TextEntryDialogMediator*) g_type_create_instance (object_type);
	_tmp0_ = text_entry_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp0_;
	_tmp1_ = self->priv->dialog;
	text_entry_dialog_setup (_tmp1_, _text_entry_dialog_mediator_on_modify_validate_text_entry_dialog_on_modify_validate_type, self, title, label, initial_text, completion_list, completion_delimiter);
	return self;
}

static gboolean
text_entry_dialog_mediator_real_on_modify_validate (TextEntryDialogMediator* self,
                                                    const gchar* text)
{
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
text_entry_dialog_mediator_on_modify_validate (TextEntryDialogMediator* self,
                                               const gchar* text)
{
	TextEntryDialogMediatorClass* _klass_;
	g_return_val_if_fail (IS_TEXT_ENTRY_DIALOG_MEDIATOR (self), FALSE);
	_klass_ = TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS (self);
	if (_klass_->on_modify_validate) {
		return _klass_->on_modify_validate (self, text);
	}
	return FALSE;
}

gchar*
_text_entry_dialog_mediator_execute (TextEntryDialogMediator* self)
{
	TextEntryDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_TEXT_ENTRY_DIALOG_MEDIATOR (self), NULL);
	_tmp0_ = self->priv->dialog;
	_tmp1_ = text_entry_dialog_execute (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
value_text_entry_dialog_mediator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_text_entry_dialog_mediator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		text_entry_dialog_mediator_unref (value->data[0].v_pointer);
	}
}

static void
value_text_entry_dialog_mediator_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = text_entry_dialog_mediator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_text_entry_dialog_mediator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_text_entry_dialog_mediator_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TextEntryDialogMediator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = text_entry_dialog_mediator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_text_entry_dialog_mediator_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	TextEntryDialogMediator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = text_entry_dialog_mediator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_text_entry_dialog_mediator (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecTextEntryDialogMediator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_text_entry_dialog_mediator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_text_entry_dialog_mediator (GValue* value,
                                      gpointer v_object)
{
	TextEntryDialogMediator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		text_entry_dialog_mediator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_entry_dialog_mediator_unref (old);
	}
}

void
value_take_text_entry_dialog_mediator (GValue* value,
                                       gpointer v_object)
{
	TextEntryDialogMediator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_entry_dialog_mediator_unref (old);
	}
}

static void
text_entry_dialog_mediator_class_init (TextEntryDialogMediatorClass * klass,
                                       gpointer klass_data)
{
	text_entry_dialog_mediator_parent_class = g_type_class_peek_parent (klass);
	((TextEntryDialogMediatorClass *) klass)->finalize = text_entry_dialog_mediator_finalize;
	g_type_class_adjust_private_offset (klass, &TextEntryDialogMediator_private_offset);
	((TextEntryDialogMediatorClass *) klass)->on_modify_validate = (gboolean (*) (TextEntryDialogMediator*, const gchar*)) text_entry_dialog_mediator_real_on_modify_validate;
}

static void
text_entry_dialog_mediator_instance_init (TextEntryDialogMediator * self,
                                          gpointer klass)
{
	self->priv = text_entry_dialog_mediator_get_instance_private (self);
	self->ref_count = 1;
}

static void
text_entry_dialog_mediator_finalize (TextEntryDialogMediator * obj)
{
	TextEntryDialogMediator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dialog);
}

static GType
text_entry_dialog_mediator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_text_entry_dialog_mediator_init, value_text_entry_dialog_mediator_free_value, value_text_entry_dialog_mediator_copy_value, value_text_entry_dialog_mediator_peek_pointer, "p", value_text_entry_dialog_mediator_collect_value, "p", value_text_entry_dialog_mediator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TextEntryDialogMediatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_entry_dialog_mediator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextEntryDialogMediator), 0, (GInstanceInitFunc) text_entry_dialog_mediator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType text_entry_dialog_mediator_type_id;
	text_entry_dialog_mediator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextEntryDialogMediator", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	TextEntryDialogMediator_private_offset = g_type_add_instance_private (text_entry_dialog_mediator_type_id, sizeof (TextEntryDialogMediatorPrivate));
	return text_entry_dialog_mediator_type_id;
}

GType
text_entry_dialog_mediator_get_type (void)
{
	static volatile gsize text_entry_dialog_mediator_type_id__once = 0;
	if (g_once_init_enter (&text_entry_dialog_mediator_type_id__once)) {
		GType text_entry_dialog_mediator_type_id;
		text_entry_dialog_mediator_type_id = text_entry_dialog_mediator_get_type_once ();
		g_once_init_leave (&text_entry_dialog_mediator_type_id__once, text_entry_dialog_mediator_type_id);
	}
	return text_entry_dialog_mediator_type_id__once;
}

gpointer
text_entry_dialog_mediator_ref (gpointer instance)
{
	TextEntryDialogMediator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
text_entry_dialog_mediator_unref (gpointer instance)
{
	TextEntryDialogMediator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
multi_text_entry_dialog_mediator_get_instance_private (MultiTextEntryDialogMediator* self)
{
	return G_STRUCT_MEMBER_P (self, MultiTextEntryDialogMediator_private_offset);
}

static gboolean
_multi_text_entry_dialog_mediator_on_modify_validate_multi_text_entry_dialog_on_modify_validate_type (const gchar* text,
                                                                                                      gpointer self)
{
	gboolean result;
	result = multi_text_entry_dialog_mediator_on_modify_validate ((MultiTextEntryDialogMediator*) self, text);
	return result;
}

MultiTextEntryDialogMediator*
multi_text_entry_dialog_mediator_construct (GType object_type,
                                            const gchar* title,
                                            const gchar* label,
                                            const gchar* initial_text)
{
	MultiTextEntryDialogMediator* self = NULL;
	MultiTextEntryDialog* _tmp0_;
	MultiTextEntryDialog* _tmp1_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (MultiTextEntryDialogMediator*) g_type_create_instance (object_type);
	_tmp0_ = multi_text_entry_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp0_;
	_tmp1_ = self->priv->dialog;
	multi_text_entry_dialog_setup (_tmp1_, _multi_text_entry_dialog_mediator_on_modify_validate_multi_text_entry_dialog_on_modify_validate_type, self, title, label, initial_text);
	return self;
}

static gboolean
multi_text_entry_dialog_mediator_real_on_modify_validate (MultiTextEntryDialogMediator* self,
                                                          const gchar* text)
{
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
multi_text_entry_dialog_mediator_on_modify_validate (MultiTextEntryDialogMediator* self,
                                                     const gchar* text)
{
	MultiTextEntryDialogMediatorClass* _klass_;
	g_return_val_if_fail (IS_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR (self), FALSE);
	_klass_ = MULTI_TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS (self);
	if (_klass_->on_modify_validate) {
		return _klass_->on_modify_validate (self, text);
	}
	return FALSE;
}

gchar*
_multi_text_entry_dialog_mediator_execute (MultiTextEntryDialogMediator* self)
{
	MultiTextEntryDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR (self), NULL);
	_tmp0_ = self->priv->dialog;
	_tmp1_ = multi_text_entry_dialog_execute (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
value_multi_text_entry_dialog_mediator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_multi_text_entry_dialog_mediator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		multi_text_entry_dialog_mediator_unref (value->data[0].v_pointer);
	}
}

static void
value_multi_text_entry_dialog_mediator_copy_value (const GValue* src_value,
                                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = multi_text_entry_dialog_mediator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_multi_text_entry_dialog_mediator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_multi_text_entry_dialog_mediator_collect_value (GValue* value,
                                                      guint n_collect_values,
                                                      GTypeCValue* collect_values,
                                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MultiTextEntryDialogMediator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = multi_text_entry_dialog_mediator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_multi_text_entry_dialog_mediator_lcopy_value (const GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	MultiTextEntryDialogMediator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = multi_text_entry_dialog_mediator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_multi_text_entry_dialog_mediator (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags)
{
	ParamSpecMultiTextEntryDialogMediator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_multi_text_entry_dialog_mediator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_multi_text_entry_dialog_mediator (GValue* value,
                                            gpointer v_object)
{
	MultiTextEntryDialogMediator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		multi_text_entry_dialog_mediator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		multi_text_entry_dialog_mediator_unref (old);
	}
}

void
value_take_multi_text_entry_dialog_mediator (GValue* value,
                                             gpointer v_object)
{
	MultiTextEntryDialogMediator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		multi_text_entry_dialog_mediator_unref (old);
	}
}

static void
multi_text_entry_dialog_mediator_class_init (MultiTextEntryDialogMediatorClass * klass,
                                             gpointer klass_data)
{
	multi_text_entry_dialog_mediator_parent_class = g_type_class_peek_parent (klass);
	((MultiTextEntryDialogMediatorClass *) klass)->finalize = multi_text_entry_dialog_mediator_finalize;
	g_type_class_adjust_private_offset (klass, &MultiTextEntryDialogMediator_private_offset);
	((MultiTextEntryDialogMediatorClass *) klass)->on_modify_validate = (gboolean (*) (MultiTextEntryDialogMediator*, const gchar*)) multi_text_entry_dialog_mediator_real_on_modify_validate;
}

static void
multi_text_entry_dialog_mediator_instance_init (MultiTextEntryDialogMediator * self,
                                                gpointer klass)
{
	self->priv = multi_text_entry_dialog_mediator_get_instance_private (self);
	self->ref_count = 1;
}

static void
multi_text_entry_dialog_mediator_finalize (MultiTextEntryDialogMediator * obj)
{
	MultiTextEntryDialogMediator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR, MultiTextEntryDialogMediator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dialog);
}

static GType
multi_text_entry_dialog_mediator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_multi_text_entry_dialog_mediator_init, value_multi_text_entry_dialog_mediator_free_value, value_multi_text_entry_dialog_mediator_copy_value, value_multi_text_entry_dialog_mediator_peek_pointer, "p", value_multi_text_entry_dialog_mediator_collect_value, "p", value_multi_text_entry_dialog_mediator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MultiTextEntryDialogMediatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multi_text_entry_dialog_mediator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiTextEntryDialogMediator), 0, (GInstanceInitFunc) multi_text_entry_dialog_mediator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType multi_text_entry_dialog_mediator_type_id;
	multi_text_entry_dialog_mediator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MultiTextEntryDialogMediator", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	MultiTextEntryDialogMediator_private_offset = g_type_add_instance_private (multi_text_entry_dialog_mediator_type_id, sizeof (MultiTextEntryDialogMediatorPrivate));
	return multi_text_entry_dialog_mediator_type_id;
}

GType
multi_text_entry_dialog_mediator_get_type (void)
{
	static volatile gsize multi_text_entry_dialog_mediator_type_id__once = 0;
	if (g_once_init_enter (&multi_text_entry_dialog_mediator_type_id__once)) {
		GType multi_text_entry_dialog_mediator_type_id;
		multi_text_entry_dialog_mediator_type_id = multi_text_entry_dialog_mediator_get_type_once ();
		g_once_init_leave (&multi_text_entry_dialog_mediator_type_id__once, multi_text_entry_dialog_mediator_type_id);
	}
	return multi_text_entry_dialog_mediator_type_id__once;
}

gpointer
multi_text_entry_dialog_mediator_ref (gpointer instance)
{
	MultiTextEntryDialogMediator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
multi_text_entry_dialog_mediator_unref (gpointer instance)
{
	MultiTextEntryDialogMediator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MULTI_TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gchar*
build_alert_body_text (const gchar* primary_text,
                       const gchar* secondary_text,
                       gboolean should_escape)
{
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	if (should_escape) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = guarded_markup_escape_text (primary_text);
		_tmp1_ = _tmp0_;
		_tmp2_ = guarded_markup_escape_text (secondary_text);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("<span weight=\"Bold\" size=\"larger\">%s</span>\n%s", _tmp1_, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = guarded_markup_escape_text (primary_text);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("<span weight=\"Bold\" size=\"larger\">%s</span>\n%s", _tmp7_, secondary_text);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	result = _tmp9_;
	return result;
}

EventRenameDialog*
event_rename_dialog_construct (GType object_type,
                               const gchar* event_name)
{
	EventRenameDialog* self = NULL;
	self = (EventRenameDialog*) text_entry_dialog_mediator_construct (object_type, _ ("Rename Event"), _ ("Name:"), event_name, NULL, NULL);
	return self;
}

EventRenameDialog*
event_rename_dialog_new (const gchar* event_name)
{
	return event_rename_dialog_construct (TYPE_EVENT_RENAME_DIALOG, event_name);
}

static gchar*
event_rename_dialog_real_execute (EventRenameDialog* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = _text_entry_dialog_mediator_execute (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediator));
	_tmp1_ = _tmp0_;
	_tmp2_ = event_prep_event_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
event_rename_dialog_execute (EventRenameDialog* self)
{
	EventRenameDialogClass* _klass_;
	g_return_val_if_fail (IS_EVENT_RENAME_DIALOG (self), NULL);
	_klass_ = EVENT_RENAME_DIALOG_GET_CLASS (self);
	if (_klass_->execute) {
		return _klass_->execute (self);
	}
	return NULL;
}

static void
event_rename_dialog_class_init (EventRenameDialogClass * klass,
                                gpointer klass_data)
{
	event_rename_dialog_parent_class = g_type_class_peek_parent (klass);
	((EventRenameDialogClass *) klass)->execute = (gchar* (*) (EventRenameDialog*)) event_rename_dialog_real_execute;
}

static void
event_rename_dialog_instance_init (EventRenameDialog * self,
                                   gpointer klass)
{
}

static GType
event_rename_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventRenameDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_rename_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventRenameDialog), 0, (GInstanceInitFunc) event_rename_dialog_instance_init, NULL };
	GType event_rename_dialog_type_id;
	event_rename_dialog_type_id = g_type_register_static (TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, "EventRenameDialog", &g_define_type_info, 0);
	return event_rename_dialog_type_id;
}

GType
event_rename_dialog_get_type (void)
{
	static volatile gsize event_rename_dialog_type_id__once = 0;
	if (g_once_init_enter (&event_rename_dialog_type_id__once)) {
		GType event_rename_dialog_type_id;
		event_rename_dialog_type_id = event_rename_dialog_get_type_once ();
		g_once_init_leave (&event_rename_dialog_type_id__once, event_rename_dialog_type_id);
	}
	return event_rename_dialog_type_id__once;
}

EditTitleDialog*
edit_title_dialog_construct (GType object_type,
                             const gchar* photo_title)
{
	EditTitleDialog* self = NULL;
	self = (EditTitleDialog*) text_entry_dialog_mediator_construct (object_type, C_ ("Dialog Title", "Edit Title"), _ ("Title:"), photo_title, NULL, NULL);
	return self;
}

EditTitleDialog*
edit_title_dialog_new (const gchar* photo_title)
{
	return edit_title_dialog_construct (TYPE_EDIT_TITLE_DIALOG, photo_title);
}

static gchar*
edit_title_dialog_real_execute (EditTitleDialog* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = _text_entry_dialog_mediator_execute (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediator));
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_prep_title (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
edit_title_dialog_execute (EditTitleDialog* self)
{
	EditTitleDialogClass* _klass_;
	g_return_val_if_fail (IS_EDIT_TITLE_DIALOG (self), NULL);
	_klass_ = EDIT_TITLE_DIALOG_GET_CLASS (self);
	if (_klass_->execute) {
		return _klass_->execute (self);
	}
	return NULL;
}

static gboolean
edit_title_dialog_real_on_modify_validate (TextEntryDialogMediator* base,
                                           const gchar* text)
{
	EditTitleDialog * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EDIT_TITLE_DIALOG, EditTitleDialog);
	g_return_val_if_fail (text != NULL, FALSE);
	result = TRUE;
	return result;
}

static void
edit_title_dialog_class_init (EditTitleDialogClass * klass,
                              gpointer klass_data)
{
	edit_title_dialog_parent_class = g_type_class_peek_parent (klass);
	((EditTitleDialogClass *) klass)->execute = (gchar* (*) (EditTitleDialog*)) edit_title_dialog_real_execute;
	((TextEntryDialogMediatorClass *) klass)->on_modify_validate = (gboolean (*) (TextEntryDialogMediator*, const gchar*)) edit_title_dialog_real_on_modify_validate;
}

static void
edit_title_dialog_instance_init (EditTitleDialog * self,
                                 gpointer klass)
{
}

static GType
edit_title_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditTitleDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_title_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditTitleDialog), 0, (GInstanceInitFunc) edit_title_dialog_instance_init, NULL };
	GType edit_title_dialog_type_id;
	edit_title_dialog_type_id = g_type_register_static (TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, "EditTitleDialog", &g_define_type_info, 0);
	return edit_title_dialog_type_id;
}

GType
edit_title_dialog_get_type (void)
{
	static volatile gsize edit_title_dialog_type_id__once = 0;
	if (g_once_init_enter (&edit_title_dialog_type_id__once)) {
		GType edit_title_dialog_type_id;
		edit_title_dialog_type_id = edit_title_dialog_get_type_once ();
		g_once_init_leave (&edit_title_dialog_type_id__once, edit_title_dialog_type_id);
	}
	return edit_title_dialog_type_id__once;
}

EditCommentDialog*
edit_comment_dialog_construct (GType object_type,
                               const gchar* comment,
                               gboolean is_event)
{
	EditCommentDialog* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* title_tmp = NULL;
	gchar* _tmp1_;
	if (is_event) {
		_tmp0_ = _ ("Edit Event Comment");
	} else {
		_tmp0_ = _ ("Edit Photo/Video Comment");
	}
	_tmp1_ = g_strdup (_tmp0_);
	title_tmp = _tmp1_;
	self = (EditCommentDialog*) multi_text_entry_dialog_mediator_construct (object_type, title_tmp, _ ("Comment:"), comment);
	_g_free0 (title_tmp);
	return self;
}

EditCommentDialog*
edit_comment_dialog_new (const gchar* comment,
                         gboolean is_event)
{
	return edit_comment_dialog_construct (TYPE_EDIT_COMMENT_DIALOG, comment, is_event);
}

static gchar*
edit_comment_dialog_real_execute (EditCommentDialog* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = _multi_text_entry_dialog_mediator_execute (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR, MultiTextEntryDialogMediator));
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_prep_comment (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
edit_comment_dialog_execute (EditCommentDialog* self)
{
	EditCommentDialogClass* _klass_;
	g_return_val_if_fail (IS_EDIT_COMMENT_DIALOG (self), NULL);
	_klass_ = EDIT_COMMENT_DIALOG_GET_CLASS (self);
	if (_klass_->execute) {
		return _klass_->execute (self);
	}
	return NULL;
}

static gboolean
edit_comment_dialog_real_on_modify_validate (MultiTextEntryDialogMediator* base,
                                             const gchar* text)
{
	EditCommentDialog * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EDIT_COMMENT_DIALOG, EditCommentDialog);
	g_return_val_if_fail (text != NULL, FALSE);
	result = TRUE;
	return result;
}

static void
edit_comment_dialog_class_init (EditCommentDialogClass * klass,
                                gpointer klass_data)
{
	edit_comment_dialog_parent_class = g_type_class_peek_parent (klass);
	((EditCommentDialogClass *) klass)->execute = (gchar* (*) (EditCommentDialog*)) edit_comment_dialog_real_execute;
	((MultiTextEntryDialogMediatorClass *) klass)->on_modify_validate = (gboolean (*) (MultiTextEntryDialogMediator*, const gchar*)) edit_comment_dialog_real_on_modify_validate;
}

static void
edit_comment_dialog_instance_init (EditCommentDialog * self,
                                   gpointer klass)
{
}

static GType
edit_comment_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditCommentDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_comment_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditCommentDialog), 0, (GInstanceInitFunc) edit_comment_dialog_instance_init, NULL };
	GType edit_comment_dialog_type_id;
	edit_comment_dialog_type_id = g_type_register_static (TYPE_MULTI_TEXT_ENTRY_DIALOG_MEDIATOR, "EditCommentDialog", &g_define_type_info, 0);
	return edit_comment_dialog_type_id;
}

GType
edit_comment_dialog_get_type (void)
{
	static volatile gsize edit_comment_dialog_type_id__once = 0;
	if (g_once_init_enter (&edit_comment_dialog_type_id__once)) {
		GType edit_comment_dialog_type_id;
		edit_comment_dialog_type_id = edit_comment_dialog_get_type_once ();
		g_once_init_leave (&edit_comment_dialog_type_id__once, edit_comment_dialog_type_id);
	}
	return edit_comment_dialog_type_id__once;
}

GtkResponseType
remove_from_library_dialog (GtkWindow* owner,
                            const gchar* title,
                            const gchar* user_message,
                            gint count)
{
	gchar* trash_action = NULL;
	gchar* _tmp0_;
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkResponseType _result_ = 0;
	GtkResponseType result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (owner, gtk_window_get_type ()), 0);
	g_return_val_if_fail (title != NULL, 0);
	g_return_val_if_fail (user_message != NULL, 0);
	_tmp0_ = g_strdup (ngettext ("Remove and _Trash File", "Remove and _Trash Files", (gulong) count));
	trash_action = _tmp0_;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (owner, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_CANCEL, "%s", user_message);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), _ ("_Remove From Library"), (gint) GTK_RESPONSE_NO);
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), trash_action, (gint) GTK_RESPONSE_YES);
	_tmp2_ = build_alert_body_text (title, user_message, TRUE);
	_tmp3_ = _tmp2_;
	gtk_message_dialog_set_markup (dialog, _tmp3_);
	_g_free0 (_tmp3_);
	_result_ = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	result = _result_;
	_g_object_unref0 (dialog);
	_g_free0 (trash_action);
	return result;
}

GtkResponseType
remove_from_filesystem_dialog (GtkWindow* owner,
                               const gchar* title,
                               const gchar* user_message)
{
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkResponseType _result_ = 0;
	GtkResponseType result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (owner, gtk_window_get_type ()), 0);
	g_return_val_if_fail (title != NULL, 0);
	g_return_val_if_fail (user_message != NULL, 0);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (owner, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", user_message);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), _ ("_Keep"), (gint) GTK_RESPONSE_NO);
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), _ ("_Delete"), (gint) GTK_RESPONSE_YES);
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_NO);
	_tmp1_ = build_alert_body_text (title, user_message, TRUE);
	_tmp2_ = _tmp1_;
	gtk_message_dialog_set_markup (dialog, _tmp2_);
	_g_free0 (_tmp2_);
	_result_ = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}

gboolean
revert_editable_dialog (GtkWindow* owner,
                        GeeCollection* photos)
{
	gint count = 0;
	const gchar* _tmp6_ = NULL;
	gchar* headline = NULL;
	gchar* _tmp7_;
	gchar* msg = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* action = NULL;
	gchar* _tmp10_;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
	GtkMessageDialog* _tmp14_;
	const gchar* _tmp15_;
	GtkMessageDialog* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkResponseType _result_ = 0;
	GtkMessageDialog* _tmp21_;
	GtkMessageDialog* _tmp22_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (owner, gtk_window_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (photos, GEE_TYPE_COLLECTION), FALSE);
	count = 0;
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
		_photo_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			Photo* photo = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Photo* _tmp4_;
			_tmp1_ = _photo_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _photo_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			photo = (Photo*) _tmp3_;
			_tmp4_ = photo;
			if (photo_has_editable (_tmp4_)) {
				gint _tmp5_;
				_tmp5_ = count;
				count = _tmp5_ + 1;
			}
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	if (count == 0) {
		result = FALSE;
		return result;
	}
	if (count == 1) {
		_tmp6_ = _ ("Revert External Edit?");
	} else {
		_tmp6_ = _ ("Revert External Edits?");
	}
	_tmp7_ = g_strdup (_tmp6_);
	headline = _tmp7_;
	_tmp8_ = g_strdup_printf (ngettext ("This will destroy all changes made to the external file. Continue?", "This will destroy all changes made to %d external files. Continue?", (gulong) count), count);
	msg = _tmp8_;
	if (count == 1) {
		_tmp9_ = _ ("Re_vert External Edit");
	} else {
		_tmp9_ = _ ("Re_vert External Edits");
	}
	_tmp10_ = g_strdup (_tmp9_);
	action = _tmp10_;
	_tmp11_ = msg;
	_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new (owner, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp11_);
	g_object_ref_sink (_tmp12_);
	dialog = _tmp12_;
	_tmp13_ = dialog;
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_dialog_get_type (), GtkDialog), _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp14_ = dialog;
	_tmp15_ = action;
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_dialog_get_type (), GtkDialog), _tmp15_, (gint) GTK_RESPONSE_YES);
	_tmp16_ = dialog;
	_tmp17_ = headline;
	_tmp18_ = msg;
	_tmp19_ = build_alert_body_text (_tmp17_, _tmp18_, TRUE);
	_tmp20_ = _tmp19_;
	gtk_message_dialog_set_markup (_tmp16_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = dialog;
	_result_ = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_dialog_get_type (), GtkDialog));
	_tmp22_ = dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
	result = _result_ == GTK_RESPONSE_YES;
	_g_object_unref0 (dialog);
	_g_free0 (action);
	_g_free0 (msg);
	_g_free0 (headline);
	return result;
}

gboolean
remove_offline_dialog (GtkWindow* owner,
                       gint count)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_;
	GtkResponseType _result_ = 0;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* _tmp8_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (owner, gtk_window_get_type ()), FALSE);
	if (count == 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_strdup_printf (ngettext ("This will remove the photo from the library. Continue?", "This will remove %d photos from the library. Continue?", (gulong) count), count);
	msg = _tmp0_;
	_tmp1_ = msg;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (owner, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_dialog_get_type (), GtkDialog), _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp4_ = dialog;
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_dialog_get_type (), GtkDialog), _ ("_Remove"), (gint) GTK_RESPONSE_OK);
	if (count == 1) {
		_tmp5_ = _ ("Remove Photo From Library");
	} else {
		_tmp5_ = _ ("Remove Photos From Library");
	}
	_tmp6_ = dialog;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow), _tmp5_);
	_tmp7_ = dialog;
	_result_ = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_dialog_get_type (), GtkDialog));
	_tmp8_ = dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	result = _result_ == GTK_RESPONSE_OK;
	_g_object_unref0 (dialog);
	_g_free0 (msg);
	return result;
}

void
multiple_object_error_dialog (GeeArrayList* objects,
                              const gchar* message,
                              const gchar* title)
{
	gchar* dialog_message = NULL;
	gchar* _tmp0_;
	gint remainder = 0;
	gint _tmp14_;
	gint _tmp15_;
	GtkMessageDialog* dialog = NULL;
	AppWindow* _tmp20_;
	AppWindow* _tmp21_;
	const gchar* _tmp22_;
	GtkMessageDialog* _tmp23_;
	GtkMessageDialog* _tmp24_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_ARRAY_LIST));
	g_return_if_fail (message != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strconcat (message, "\n", NULL);
	dialog_message = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp6_;
				gpointer _tmp7_;
				DataObject* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (i < MAX_OBJECTS_DISPLAYED) {
					gint _tmp4_;
					gint _tmp5_;
					_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
					_tmp5_ = _tmp4_;
					_tmp3_ = _tmp5_ > i;
				} else {
					_tmp3_ = FALSE;
				}
				if (!_tmp3_) {
					break;
				}
				_tmp6_ = dialog_message;
				_tmp7_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), i);
				_tmp8_ = (DataObject*) _tmp7_;
				_tmp9_ = data_object_to_string (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat ("\n", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp6_, _tmp12_, NULL);
				_g_free0 (dialog_message);
				dialog_message = _tmp13_;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_g_object_unref0 (_tmp8_);
			}
		}
	}
	_tmp14_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp15_ = _tmp14_;
	remainder = _tmp15_ - MAX_OBJECTS_DISPLAYED;
	if (remainder > 0) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = dialog_message;
		_tmp17_ = g_strdup_printf (ngettext ("\n\nAnd %d other.", "\n\nAnd %d others.", (gulong) remainder), remainder);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
		_g_free0 (dialog_message);
		dialog_message = _tmp19_;
		_g_free0 (_tmp18_);
	}
	_tmp20_ = app_window_get_instance ();
	_tmp21_ = _tmp20_;
	_tmp22_ = dialog_message;
	_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp22_);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp21_);
	dialog = _tmp24_;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), title);
	gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
	_g_free0 (dialog_message);
}

TagsDialog*
tags_dialog_construct (GType object_type,
                       const gchar* title,
                       const gchar* label,
                       const gchar* initial_text)
{
	TagsDialog* self = NULL;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	HierarchicalTagIndex* _tmp2_;
	HierarchicalTagIndex* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* paths = NULL;
	HierarchicalTagIndex* _tmp6_;
	HierarchicalTagIndex* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeArrayList* _tmp18_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	all = _tmp0_;
	_tmp1_ = all;
	_tmp2_ = hierarchical_tag_index_get_global_index ();
	_tmp3_ = _tmp2_;
	_tmp4_ = hierarchical_tag_index_get_all_tags (_tmp3_);
	_tmp5_ = _tmp4_;
	gee_array_list_add_all (_tmp1_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_hierarchical_tag_index_unref0 (_tmp3_);
	_tmp6_ = hierarchical_tag_index_get_global_index ();
	_tmp7_ = _tmp6_;
	_tmp8_ = hierarchical_tag_index_get_all_paths (_tmp7_);
	_tmp9_ = _tmp8_;
	_hierarchical_tag_index_unref0 (_tmp7_);
	paths = _tmp9_;
	{
		GeeIterator* _p_it = NULL;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp10_ = paths;
		_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
		_p_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* p = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			_tmp12_ = _p_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _p_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			p = (gchar*) _tmp14_;
			_tmp15_ = p;
			if (g_str_has_prefix (_tmp15_, "/")) {
				GeeArrayList* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = all;
				_tmp17_ = p;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
			}
			_g_free0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp18_ = all;
	self = (TagsDialog*) text_entry_dialog_mediator_construct (object_type, title, label, initial_text, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), ",");
	_g_object_unref0 (paths);
	_g_object_unref0 (all);
	return self;
}

static void
tags_dialog_class_init (TagsDialogClass * klass,
                        gpointer klass_data)
{
	tags_dialog_parent_class = g_type_class_peek_parent (klass);
}

static void
tags_dialog_instance_init (TagsDialog * self,
                           gpointer klass)
{
}

static GType
tags_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TagsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tags_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagsDialog), 0, (GInstanceInitFunc) tags_dialog_instance_init, NULL };
	GType tags_dialog_type_id;
	tags_dialog_type_id = g_type_register_static (TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, "TagsDialog", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return tags_dialog_type_id;
}

GType
tags_dialog_get_type (void)
{
	static volatile gsize tags_dialog_type_id__once = 0;
	if (g_once_init_enter (&tags_dialog_type_id__once)) {
		GType tags_dialog_type_id;
		tags_dialog_type_id = tags_dialog_get_type_once ();
		g_once_init_leave (&tags_dialog_type_id__once, tags_dialog_type_id);
	}
	return tags_dialog_type_id__once;
}

AddTagsDialog*
add_tags_dialog_construct (GType object_type)
{
	AddTagsDialog* self = NULL;
	gchar* title = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup (g_dpgettext2 (NULL, "Dialog Title", RESOURCES_ADD_TAGS_TITLE));
	title = _tmp0_;
	self = (AddTagsDialog*) tags_dialog_construct (object_type, title, _ ("Tags (separated by commas):"), NULL);
	_g_free0 (title);
	return self;
}

AddTagsDialog*
add_tags_dialog_new (void)
{
	return add_tags_dialog_construct (TYPE_ADD_TAGS_DIALOG);
}

gchar**
add_tags_dialog_execute (AddTagsDialog* self,
                         gint* result_length1)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** result;
	g_return_val_if_fail (IS_ADD_TAGS_DIALOG (self), NULL);
	_tmp0_ = _text_entry_dialog_mediator_execute (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediator));
	text = _tmp0_;
	_tmp1_ = text;
	if (_tmp1_ == NULL) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = NULL;
		_tmp2__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		_g_free0 (text);
		return result;
	}
	_tmp3_ = text;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ",", 0);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _vala_array_length (_tmp4_);
	_tmp8_ = tag_prep_tag_names (_tmp6_, (gint) _vala_array_length (_tmp4_), &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_free0 (text);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
add_tags_dialog_real_on_modify_validate (TextEntryDialogMediator* base,
                                         const gchar* text)
{
	AddTagsDialog * self;
	gchar** names = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_TAGS_DIALOG, AddTagsDialog);
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp1_ = _tmp0_ = g_strsplit (text, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp4_ = tag_prep_tag_names (_tmp2_, (gint) _vala_array_length (_tmp0_), &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	names = _tmp5_;
	names_length1 = _tmp5__length1;
	_names_size_ = names_length1;
	_tmp6_ = names;
	_tmp6__length1 = names_length1;
	if (_tmp6__length1 == 0) {
		result = FALSE;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gchar** _tmp9_;
				gint _tmp9__length1;
				gboolean _tmp10_ = FALSE;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gboolean _tmp17_ = FALSE;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gboolean _tmp22_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gboolean _tmp33_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = names;
				_tmp9__length1 = names_length1;
				if (!(i < _tmp9__length1)) {
					break;
				}
				_tmp11_ = names;
				_tmp11__length1 = names_length1;
				_tmp12_ = _tmp11_[i];
				if (string_contains (_tmp12_, TAG_PATH_SEPARATOR_STRING)) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = names;
					_tmp13__length1 = names_length1;
					_tmp14_ = _tmp13_[i];
					_tmp15_ = string_strip (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp10_ = !g_str_has_prefix (_tmp16_, TAG_PATH_SEPARATOR_STRING);
					_g_free0 (_tmp16_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					result = FALSE;
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp18_ = names;
				_tmp18__length1 = names_length1;
				_tmp19_ = _tmp18_[i];
				_tmp20_ = string_strip (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_str_has_prefix (_tmp21_, TAG_PATH_SEPARATOR_STRING);
				_g_free0 (_tmp21_);
				if (_tmp22_) {
					gchar** _tmp23_;
					gint _tmp23__length1;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					_tmp23_ = names;
					_tmp23__length1 = names_length1;
					_tmp24_ = _tmp23_[i];
					_tmp25_ = string_strip (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = strlen (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp17_ = _tmp28_ == 1;
					_g_free0 (_tmp26_);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					result = FALSE;
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp29_ = names;
				_tmp29__length1 = names_length1;
				_tmp30_ = _tmp29_[i];
				_tmp31_ = string_strip (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = string_contains (_tmp32_, TAG_PATH_SEPARATOR_STRING TAG_PATH_SEPARATOR_STRING);
				_g_free0 (_tmp32_);
				if (_tmp33_) {
					result = FALSE;
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = TRUE;
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
add_tags_dialog_class_init (AddTagsDialogClass * klass,
                            gpointer klass_data)
{
	add_tags_dialog_parent_class = g_type_class_peek_parent (klass);
	((TextEntryDialogMediatorClass *) klass)->on_modify_validate = (gboolean (*) (TextEntryDialogMediator*, const gchar*)) add_tags_dialog_real_on_modify_validate;
}

static void
add_tags_dialog_instance_init (AddTagsDialog * self,
                               gpointer klass)
{
}

static GType
add_tags_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AddTagsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_tags_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddTagsDialog), 0, (GInstanceInitFunc) add_tags_dialog_instance_init, NULL };
	GType add_tags_dialog_type_id;
	add_tags_dialog_type_id = g_type_register_static (TYPE_TAGS_DIALOG, "AddTagsDialog", &g_define_type_info, 0);
	return add_tags_dialog_type_id;
}

GType
add_tags_dialog_get_type (void)
{
	static volatile gsize add_tags_dialog_type_id__once = 0;
	if (g_once_init_enter (&add_tags_dialog_type_id__once)) {
		GType add_tags_dialog_type_id;
		add_tags_dialog_type_id = add_tags_dialog_get_type_once ();
		g_once_init_leave (&add_tags_dialog_type_id__once, add_tags_dialog_type_id);
	}
	return add_tags_dialog_type_id__once;
}

ModifyTagsDialog*
modify_tags_dialog_construct (GType object_type,
                              MediaSource* source)
{
	ModifyTagsDialog* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), NULL);
	_tmp0_ = modify_tags_dialog_get_initial_text (source);
	_tmp1_ = _tmp0_;
	self = (ModifyTagsDialog*) tags_dialog_construct (object_type, RESOURCES_MODIFY_TAGS_LABEL, _ ("Tags (separated by commas):"), _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

ModifyTagsDialog*
modify_tags_dialog_new (MediaSource* source)
{
	return modify_tags_dialog_construct (TYPE_MODIFY_TAGS_DIALOG, source);
}

static gchar*
modify_tags_dialog_get_initial_text (MediaSource* source)
{
	GeeCollection* source_tags = NULL;
	TagSourceCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* terminal_tags = NULL;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeSortedSet* tag_basenames = NULL;
	GeeTreeSet* _tmp5_;
	gchar* text = NULL;
	gchar* result;
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), NULL);
	_tmp0_ = tag_global;
	_tmp1_ = tag_source_collection_fetch_for_source (_tmp0_, source);
	source_tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp2_ = source_tags;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (source_tags);
		return result;
	}
	_tmp3_ = source_tags;
	_tmp4_ = tag_get_terminal_tags (_tmp3_);
	terminal_tags = _tmp4_;
	_tmp5_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	tag_basenames = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_SORTED_SET, GeeSortedSet);
	{
		GeeIterator* _tag_it = NULL;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp6_ = terminal_tags;
		_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
		_tag_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			Tag* tag = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GeeSortedSet* _tmp11_;
			Tag* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp8_ = _tag_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _tag_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			tag = (Tag*) _tmp10_;
			_tmp11_ = tag_basenames;
			_tmp12_ = tag;
			_tmp13_ = tag_get_path (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = hierarchical_tag_utilities_get_basename (_tmp14_);
			_tmp16_ = _tmp15_;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection), _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_g_object_unref0 (tag);
		}
		_g_object_unref0 (_tag_it);
	}
	text = NULL;
	{
		GeeIterator* _name_it = NULL;
		GeeSortedSet* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp17_ = tag_basenames;
		_tmp18_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ITERABLE, GeeIterable));
		_name_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			gchar* name = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp19_ = _name_it;
			if (!gee_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _name_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			name = (gchar*) _tmp21_;
			_tmp22_ = text;
			if (_tmp22_ == NULL) {
				gchar* _tmp23_;
				_tmp23_ = g_strdup ("");
				_g_free0 (text);
				text = _tmp23_;
			} else {
				const gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = text;
				_tmp25_ = g_strconcat (_tmp24_, ", ", NULL);
				_g_free0 (text);
				text = _tmp25_;
			}
			_tmp26_ = text;
			_tmp27_ = name;
			_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
			_g_free0 (text);
			text = _tmp28_;
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
	result = text;
	_g_object_unref0 (tag_basenames);
	_g_object_unref0 (terminal_tags);
	_g_object_unref0 (source_tags);
	return result;
}

GeeArrayList*
modify_tags_dialog_execute (ModifyTagsDialog* self)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeArrayList* new_tags = NULL;
	GeeArrayList* _tmp2_;
	const gchar* _tmp3_;
	gchar** tag_names = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_ = 0;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint tag_names_length1;
	gint _tag_names_size_;
	HierarchicalTagIndex* _tmp11_;
	HierarchicalTagIndex* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_ = 0;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GeeArrayList* result;
	g_return_val_if_fail (IS_MODIFY_TAGS_DIALOG (self), NULL);
	_tmp0_ = _text_entry_dialog_mediator_execute (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediator));
	text = _tmp0_;
	_tmp1_ = text;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (text);
		return result;
	}
	_tmp2_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	new_tags = _tmp2_;
	_tmp3_ = text;
	if (is_string_empty (_tmp3_)) {
		result = new_tags;
		_g_free0 (text);
		return result;
	}
	_tmp4_ = text;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_tmp9_ = tag_prep_tag_names (_tmp7_, (gint) _vala_array_length (_tmp5_), &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	tag_names = _tmp10_;
	tag_names_length1 = _tmp10__length1;
	_tag_names_size_ = tag_names_length1;
	_tmp11_ = hierarchical_tag_index_get_global_index ();
	_tmp12_ = _tmp11_;
	_tmp13_ = tag_names;
	_tmp13__length1 = tag_names_length1;
	_tmp15_ = hierarchical_tag_index_get_paths_for_names_array (_tmp12_, _tmp13_, (gint) _tmp13__length1, &_tmp14_);
	tag_names = (_vala_array_free (tag_names, tag_names_length1, (GDestroyNotify) g_free), NULL);
	tag_names = _tmp15_;
	tag_names_length1 = _tmp14_;
	_tag_names_size_ = tag_names_length1;
	_hierarchical_tag_index_unref0 (_tmp12_);
	_tmp16_ = tag_names;
	_tmp16__length1 = tag_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp16_;
		name_collection_length1 = _tmp16__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp17_;
			gchar* name = NULL;
			_tmp17_ = g_strdup (name_collection[name_it]);
			name = _tmp17_;
			{
				GeeArrayList* _tmp18_;
				const gchar* _tmp19_;
				Tag* _tmp20_;
				Tag* _tmp21_;
				_tmp18_ = new_tags;
				_tmp19_ = name;
				_tmp20_ = tag_for_path (_tmp19_);
				_tmp21_ = _tmp20_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
				_g_object_unref0 (_tmp21_);
				_g_free0 (name);
			}
		}
	}
	result = new_tags;
	tag_names = (_vala_array_free (tag_names, tag_names_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (text);
	return result;
}

static gboolean
modify_tags_dialog_real_on_modify_validate (TextEntryDialogMediator* base,
                                            const gchar* text)
{
	ModifyTagsDialog * self;
	gchar** names = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MODIFY_TAGS_DIALOG, ModifyTagsDialog);
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp1_ = _tmp0_ = g_strsplit (text, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp4_ = tag_prep_tag_names (_tmp2_, (gint) _vala_array_length (_tmp0_), &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	names = _tmp5_;
	names_length1 = _tmp5__length1;
	_names_size_ = names_length1;
	_tmp6_ = names;
	_tmp6__length1 = names_length1;
	if (_tmp6__length1 == 0) {
		result = FALSE;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gchar** _tmp9_;
				gint _tmp9__length1;
				gboolean _tmp10_ = FALSE;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gboolean _tmp17_ = FALSE;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gboolean _tmp22_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gboolean _tmp33_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = names;
				_tmp9__length1 = names_length1;
				if (!(i < _tmp9__length1)) {
					break;
				}
				_tmp11_ = names;
				_tmp11__length1 = names_length1;
				_tmp12_ = _tmp11_[i];
				if (string_contains (_tmp12_, TAG_PATH_SEPARATOR_STRING)) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = names;
					_tmp13__length1 = names_length1;
					_tmp14_ = _tmp13_[i];
					_tmp15_ = string_strip (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp10_ = !g_str_has_prefix (_tmp16_, TAG_PATH_SEPARATOR_STRING);
					_g_free0 (_tmp16_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					result = FALSE;
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp18_ = names;
				_tmp18__length1 = names_length1;
				_tmp19_ = _tmp18_[i];
				_tmp20_ = string_strip (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_str_has_prefix (_tmp21_, TAG_PATH_SEPARATOR_STRING);
				_g_free0 (_tmp21_);
				if (_tmp22_) {
					gchar** _tmp23_;
					gint _tmp23__length1;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					_tmp23_ = names;
					_tmp23__length1 = names_length1;
					_tmp24_ = _tmp23_[i];
					_tmp25_ = string_strip (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = strlen (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp17_ = _tmp28_ == 1;
					_g_free0 (_tmp26_);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					result = FALSE;
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp29_ = names;
				_tmp29__length1 = names_length1;
				_tmp30_ = _tmp29_[i];
				_tmp31_ = string_strip (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = string_contains (_tmp32_, TAG_PATH_SEPARATOR_STRING TAG_PATH_SEPARATOR_STRING);
				_g_free0 (_tmp32_);
				if (_tmp33_) {
					result = FALSE;
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = TRUE;
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
modify_tags_dialog_class_init (ModifyTagsDialogClass * klass,
                               gpointer klass_data)
{
	modify_tags_dialog_parent_class = g_type_class_peek_parent (klass);
	((TextEntryDialogMediatorClass *) klass)->on_modify_validate = (gboolean (*) (TextEntryDialogMediator*, const gchar*)) modify_tags_dialog_real_on_modify_validate;
}

static void
modify_tags_dialog_instance_init (ModifyTagsDialog * self,
                                  gpointer klass)
{
}

static GType
modify_tags_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ModifyTagsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modify_tags_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModifyTagsDialog), 0, (GInstanceInitFunc) modify_tags_dialog_instance_init, NULL };
	GType modify_tags_dialog_type_id;
	modify_tags_dialog_type_id = g_type_register_static (TYPE_TAGS_DIALOG, "ModifyTagsDialog", &g_define_type_info, 0);
	return modify_tags_dialog_type_id;
}

GType
modify_tags_dialog_get_type (void)
{
	static volatile gsize modify_tags_dialog_type_id__once = 0;
	if (g_once_init_enter (&modify_tags_dialog_type_id__once)) {
		GType modify_tags_dialog_type_id;
		modify_tags_dialog_type_id = modify_tags_dialog_get_type_once ();
		g_once_init_leave (&modify_tags_dialog_type_id__once, modify_tags_dialog_type_id);
	}
	return modify_tags_dialog_type_id__once;
}

GtkResponseType
copy_files_dialog (void)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	GtkMessageDialog* dialog = NULL;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkResponseType _result_ = 0;
	GtkResponseType result;
	_tmp0_ = g_strdup (_ ("Shotwell can copy the photos into your library folder or it can import" \
" them without copying."));
	msg = _tmp0_;
	_tmp1_ = app_window_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_CANCEL, "%s", msg);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	dialog = _tmp4_;
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), _ ("Co_py Photos"), (gint) GTK_RESPONSE_ACCEPT);
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), _ ("_Import in Place"), (gint) GTK_RESPONSE_REJECT);
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), _ ("Import to Library"));
	_result_ = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	result = _result_;
	_g_object_unref0 (dialog);
	_g_free0 (msg);
	return result;
}

void
remove_photos_from_library (GeeCollection* photos)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (photos, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_collection_get_size (photos);
	_tmp1_ = _tmp0_;
	remove_from_app (photos, _ ("Remove From Library"), ngettext ("Removing Photo From Library", "Removing Photos From Library", (gulong) _tmp1_));
}

static gboolean
_progress_dialog_monitor_progress_monitor (guint64 current,
                                           guint64 total,
                                           gboolean do_event_loop,
                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
	return result;
}

void
remove_from_app (GeeCollection* sources,
                 const gchar* dialog_title,
                 const gchar* progress_dialog_text)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* videos = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gchar* user_message = NULL;
	gboolean _tmp6_ = FALSE;
	GeeArrayList* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkResponseType _result_ = 0;
	AppWindow* _tmp31_;
	AppWindow* _tmp32_;
	const gchar* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GtkResponseType _tmp36_;
	gboolean _tmp37_ = FALSE;
	gboolean delete_backing = FALSE;
	AppWindow* _tmp38_;
	AppWindow* _tmp39_;
	ProgressDialog* progress = NULL;
	ProgressMonitor monitor = NULL;
	gpointer monitor_target;
	GDestroyNotify monitor_target_destroy_notify;
	gint _tmp40_;
	gint _tmp41_;
	GeeArrayList* not_removed_photos = NULL;
	GeeArrayList* _tmp46_;
	GeeArrayList* not_removed_videos = NULL;
	GeeArrayList* _tmp47_;
	LibraryPhotoSourceCollection* _tmp48_;
	GeeArrayList* _tmp49_;
	ProgressMonitor _tmp50_;
	gpointer _tmp50__target;
	GeeArrayList* _tmp51_;
	VideoSourceCollection* _tmp52_;
	GeeArrayList* _tmp53_;
	ProgressMonitor _tmp54_;
	gpointer _tmp54__target;
	GeeArrayList* _tmp55_;
	gint num_not_removed = 0;
	GeeArrayList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	GeeArrayList* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gboolean _tmp62_ = FALSE;
	ProgressDialog* _tmp88_;
	AppWindow* _tmp90_;
	AppWindow* _tmp91_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	g_return_if_fail (dialog_title != NULL);
	g_return_if_fail (progress_dialog_text != NULL);
	_tmp0_ = gee_collection_get_size (sources);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photos = _tmp2_;
	_tmp3_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	videos = _tmp3_;
	_tmp4_ = photos;
	_tmp5_ = videos;
	media_source_collection_filter_media (sources, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
	user_message = NULL;
	_tmp7_ = photos;
	_tmp8_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp9_ = _tmp8_;
	if (!_tmp9_) {
		GeeArrayList* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = videos;
		_tmp11_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp12_ = _tmp11_;
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		_tmp13_ = gee_collection_get_size (sources);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_collection_get_size (sources);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf (ngettext ("This will remove the photo/video from your Shotwell library. Would you" \
" also like to move the file to your desktop trash?\n" \
"\n" \
"This action cannot be undone.", "This will remove %d photos/videos from your Shotwell library. Would yo" \
"u also like to move the files to your desktop trash?\n" \
"\n" \
"This action cannot be undone.", (gulong) _tmp14_), _tmp16_);
		_g_free0 (user_message);
		user_message = _tmp17_;
	} else {
		GeeArrayList* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = videos;
		_tmp19_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp20_ = _tmp19_;
		if (!_tmp20_) {
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gchar* _tmp25_;
			_tmp21_ = gee_collection_get_size (sources);
			_tmp22_ = _tmp21_;
			_tmp23_ = gee_collection_get_size (sources);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup_printf (ngettext ("This will remove the video from your Shotwell library. Would you also " \
"like to move the file to your desktop trash?\n" \
"\n" \
"This action cannot be undone.", "This will remove %d videos from your Shotwell library. Would you also " \
"like to move the files to your desktop trash?\n" \
"\n" \
"This action cannot be undone.", (gulong) _tmp22_), _tmp24_);
			_g_free0 (user_message);
			user_message = _tmp25_;
		} else {
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_;
			_tmp26_ = gee_collection_get_size (sources);
			_tmp27_ = _tmp26_;
			_tmp28_ = gee_collection_get_size (sources);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf (ngettext ("This will remove the photo from your Shotwell library. Would you also " \
"like to move the file to your desktop trash?\n" \
"\n" \
"This action cannot be undone.", "This will remove %d photos from your Shotwell library. Would you also " \
"like to move the files to your desktop trash?\n" \
"\n" \
"This action cannot be undone.", (gulong) _tmp27_), _tmp29_);
			_g_free0 (user_message);
			user_message = _tmp30_;
		}
	}
	_tmp31_ = app_window_get_instance ();
	_tmp32_ = _tmp31_;
	_tmp33_ = user_message;
	_tmp34_ = gee_collection_get_size (sources);
	_tmp35_ = _tmp34_;
	_tmp36_ = remove_from_library_dialog (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_window_get_type (), GtkWindow), dialog_title, _tmp33_, _tmp35_);
	_g_object_unref0 (_tmp32_);
	_result_ = _tmp36_;
	if (_result_ != GTK_RESPONSE_YES) {
		_tmp37_ = _result_ != GTK_RESPONSE_NO;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_g_free0 (user_message);
		_g_object_unref0 (videos);
		_g_object_unref0 (photos);
		return;
	}
	delete_backing = _result_ == GTK_RESPONSE_YES;
	_tmp38_ = app_window_get_instance ();
	_tmp39_ = _tmp38_;
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_tmp39_);
	progress = NULL;
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_tmp40_ = gee_collection_get_size (sources);
	_tmp41_ = _tmp40_;
	if (_tmp41_ >= 20) {
		AppWindow* _tmp42_;
		AppWindow* _tmp43_;
		ProgressDialog* _tmp44_;
		ProgressDialog* _tmp45_;
		_tmp42_ = app_window_get_instance ();
		_tmp43_ = _tmp42_;
		_tmp44_ = progress_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_window_get_type (), GtkWindow), progress_dialog_text, NULL);
		g_object_ref_sink (_tmp44_);
		_g_object_unref0 (progress);
		progress = _tmp44_;
		_g_object_unref0 (_tmp43_);
		_tmp45_ = progress;
		(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
		monitor = NULL;
		monitor_target = NULL;
		monitor_target_destroy_notify = NULL;
		monitor = _progress_dialog_monitor_progress_monitor;
		monitor_target = g_object_ref (_tmp45_);
		monitor_target_destroy_notify = g_object_unref;
	}
	_tmp46_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	not_removed_photos = _tmp46_;
	_tmp47_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	not_removed_videos = _tmp47_;
	_tmp48_ = library_photo_global;
	_tmp49_ = photos;
	_tmp50_ = monitor;
	_tmp50__target = monitor_target;
	_tmp51_ = not_removed_photos;
	media_source_collection_remove_from_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), delete_backing, _tmp50_, _tmp50__target, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_LIST, GeeList));
	_tmp52_ = video_global;
	_tmp53_ = videos;
	_tmp54_ = monitor;
	_tmp54__target = monitor_target;
	_tmp55_ = not_removed_videos;
	media_source_collection_remove_from_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_COLLECTION, GeeCollection), delete_backing, _tmp54_, _tmp54__target, G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_LIST, GeeList));
	_tmp56_ = not_removed_photos;
	_tmp57_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp58_ = _tmp57_;
	_tmp59_ = not_removed_videos;
	_tmp60_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp61_ = _tmp60_;
	num_not_removed = _tmp58_ + _tmp61_;
	if (delete_backing) {
		_tmp62_ = num_not_removed > 0;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		gchar* not_deleted_message = NULL;
		gchar* _tmp63_;
		GtkResponseType result_delete = 0;
		AppWindow* _tmp64_;
		AppWindow* _tmp65_;
		const gchar* _tmp66_;
		GtkResponseType _tmp67_;
		_tmp63_ = g_strdup_printf (ngettext ("The photo or video cannot be moved to your desktop trash. Delete this " \
"file?", "%d photos/videos cannot be moved to your desktop trash. Delete these f" \
"iles?", (gulong) num_not_removed), num_not_removed);
		not_deleted_message = _tmp63_;
		_tmp64_ = app_window_get_instance ();
		_tmp65_ = _tmp64_;
		_tmp66_ = not_deleted_message;
		_tmp67_ = remove_from_filesystem_dialog (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_window_get_type (), GtkWindow), dialog_title, _tmp66_);
		_g_object_unref0 (_tmp65_);
		result_delete = _tmp67_;
		if (GTK_RESPONSE_YES == result_delete) {
			GeeArrayList* not_deleted_photos = NULL;
			GeeArrayList* _tmp68_;
			GeeArrayList* not_deleted_videos = NULL;
			GeeArrayList* _tmp69_;
			LibraryPhotoSourceCollection* _tmp70_;
			GeeArrayList* _tmp71_;
			ProgressMonitor _tmp72_;
			gpointer _tmp72__target;
			GeeArrayList* _tmp73_;
			VideoSourceCollection* _tmp74_;
			GeeArrayList* _tmp75_;
			ProgressMonitor _tmp76_;
			gpointer _tmp76__target;
			GeeArrayList* _tmp77_;
			gint num_not_deleted = 0;
			GeeArrayList* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			GeeArrayList* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			_tmp68_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			not_deleted_photos = _tmp68_;
			_tmp69_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			not_deleted_videos = _tmp69_;
			_tmp70_ = library_photo_global;
			_tmp71_ = not_removed_photos;
			_tmp72_ = monitor;
			_tmp72__target = monitor_target;
			_tmp73_ = not_deleted_photos;
			media_source_collection_delete_backing_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GEE_TYPE_COLLECTION, GeeCollection), _tmp72_, _tmp72__target, G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GEE_TYPE_LIST, GeeList));
			_tmp74_ = video_global;
			_tmp75_ = not_removed_videos;
			_tmp76_ = monitor;
			_tmp76__target = monitor_target;
			_tmp77_ = not_deleted_videos;
			media_source_collection_delete_backing_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, GEE_TYPE_COLLECTION, GeeCollection), _tmp76_, _tmp76__target, G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, GEE_TYPE_LIST, GeeList));
			_tmp78_ = not_deleted_photos;
			_tmp79_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp80_ = _tmp79_;
			_tmp81_ = not_deleted_videos;
			_tmp82_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp83_ = _tmp82_;
			num_not_deleted = _tmp80_ + _tmp83_;
			if (num_not_deleted > 0) {
				gchar* delete_failed_message = NULL;
				gchar* _tmp84_;
				const gchar* _tmp85_;
				AppWindow* _tmp86_;
				AppWindow* _tmp87_;
				_tmp84_ = g_strdup_printf (ngettext ("The photo or video cannot be deleted.", "%d photos/videos cannot be deleted.", (gulong) num_not_deleted), num_not_deleted);
				delete_failed_message = _tmp84_;
				_tmp85_ = delete_failed_message;
				_tmp86_ = app_window_get_instance ();
				_tmp87_ = _tmp86_;
				app_window_error_message_with_title (dialog_title, _tmp85_, G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, gtk_window_get_type (), GtkWindow), TRUE);
				_g_object_unref0 (_tmp87_);
				_g_free0 (delete_failed_message);
			}
			_g_object_unref0 (not_deleted_videos);
			_g_object_unref0 (not_deleted_photos);
		}
		_g_free0 (not_deleted_message);
	}
	_tmp88_ = progress;
	if (_tmp88_ != NULL) {
		ProgressDialog* _tmp89_;
		_tmp89_ = progress;
		progress_dialog_close (_tmp89_);
	}
	_tmp90_ = app_window_get_instance ();
	_tmp91_ = _tmp90_;
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_tmp91_);
	_g_object_unref0 (not_removed_videos);
	_g_object_unref0 (not_removed_photos);
	(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_g_object_unref0 (progress);
	_g_free0 (user_message);
	_g_object_unref0 (videos);
	_g_object_unref0 (photos);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

