/* DesktopIntegration.c generated by valac 0.56.17, the Vala compiler
 * generated from DesktopIntegration.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <libportal/portal.h>
#include <libportal-gtk3/portal-gtk3.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME "wallpaper.xml"
#define RESOURCES_APP_TITLE "Shotwell"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_XdpParent_free0(var) ((var == NULL) ? NULL : (var = (_vala_XdpParent_free (var), NULL)))
typedef struct _DesktopIntegrationFilesSendToData DesktopIntegrationFilesSendToData;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_EXPORT_DIALOG (export_dialog_get_type ())
#define EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_DIALOG, ExportDialog))
#define EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_DIALOG, ExportDialogClass))
#define IS_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_DIALOG))
#define IS_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_DIALOG))
#define EXPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_DIALOG, ExportDialogClass))

typedef struct _ExportDialog ExportDialog;
typedef struct _ExportDialogClass ExportDialogClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, gpointer user_data);
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER (desktop_integration_background_slideshow_xml_builder_get_type ())
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilder))
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderClass))
#define DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER))
#define DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER))
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderClass))

typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilder DesktopIntegrationBackgroundSlideshowXMLBuilder;
typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilderClass DesktopIntegrationBackgroundSlideshowXMLBuilderClass;
typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate;
typedef struct _DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder;
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);
#define _desktop_integration_background_slideshow_xml_builder_unref0(var) ((var == NULL) ? NULL : (var = (desktop_integration_background_slideshow_xml_builder_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DesktopIntegrationFilesSendToData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile** files;
	gint files_length1;
	XdpParent* parent;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	XdpParent* _tmp2_;
	XdpParent* _tmp3_;
	GString* file_names;
	GString* _tmp4_;
	gchar** file_paths;
	gchar** _tmp5_;
	gint file_paths_length1;
	gint _file_paths_size_;
	gint i;
	gboolean _tmp6_;
	gint _tmp7_;
	GString* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GString* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GFile* _tmp14_;
	gchar* _tmp15_;
	AppWindow* _tmp16_;
	AppWindow* _tmp17_;
	XdpPortal* portal;
	XdpPortal* _tmp18_;
	XdpPortal* _tmp19_;
	XdpParent* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	GError* e;
	GString* _tmp28_;
	const gchar* _tmp29_;
	GError* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	AppWindow* _tmp34_;
	AppWindow* _tmp35_;
	GError* _inner_error0_;
};

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate * priv;
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilderClass {
	GTypeClass parent_class;
	void (*finalize) (DesktopIntegrationBackgroundSlideshowXMLBuilder *self);
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate {
	GFile* destination;
	gdouble duration;
	gdouble transition;
	GFile* tmp_file;
	GDataOutputStream* outs;
	GFile* first_file;
	GFile* last_file;
};

struct _DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder {
	GParamSpec parent_instance;
};

VALA_EXTERN gint desktop_integration_init_count;
gint desktop_integration_init_count = 0;
VALA_EXTERN ExporterUI* desktop_integration_send_to_exporter;
ExporterUI* desktop_integration_send_to_exporter = NULL;
VALA_EXTERN ExporterUI* desktop_integration_desktop_slideshow_exporter;
ExporterUI* desktop_integration_desktop_slideshow_exporter = NULL;
VALA_EXTERN gdouble desktop_integration_desktop_slideshow_transition;
gdouble desktop_integration_desktop_slideshow_transition = 0.0;
VALA_EXTERN gdouble desktop_integration_desktop_slideshow_duration;
gdouble desktop_integration_desktop_slideshow_duration = 0.0;
VALA_EXTERN gboolean desktop_integration_set_desktop_background;
gboolean desktop_integration_set_desktop_background = FALSE;
VALA_EXTERN gboolean desktop_integration_set_screensaver;
gboolean desktop_integration_set_screensaver = FALSE;
static gint DesktopIntegrationBackgroundSlideshowXMLBuilder_private_offset;
static gpointer desktop_integration_background_slideshow_xml_builder_parent_class = NULL;

VALA_EXTERN gpointer exporter_ui_ref (gpointer instance);
VALA_EXTERN void exporter_ui_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_exporter_ui (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_exporter_ui (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_exporter_ui (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_exporter_ui (const GValue* value);
VALA_EXTERN GType exporter_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExporterUI, exporter_ui_unref)
VALA_EXTERN void desktop_integration_init (void);
VALA_EXTERN void desktop_integration_terminate (void);
VALA_EXTERN GAppInfo* desktop_integration_get_default_app_for_mime_types (gchar** mime_types,
                                                              gint mime_types_length1,
                                                              GeeArrayList* preferred_apps);
VALA_EXTERN GType sorted_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedList, g_object_unref)
VALA_EXTERN SortedList* desktop_integration_get_apps_for_mime_types (gchar** mime_types,
                                                         gint mime_types_length1);
VALA_EXTERN gint64 desktop_integration_app_info_comparator (void* a,
                                                void* b);
static gint64 _desktop_integration_app_info_comparator_comparator (void* a,
                                                            void* b,
                                                            gpointer self);
VALA_EXTERN SortedList* sorted_list_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             Comparator cmp,
                             gpointer cmp_target);
VALA_EXTERN SortedList* sorted_list_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   Comparator cmp,
                                   gpointer cmp_target);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN gchar* desktop_integration_get_app_open_command (GAppInfo* app_info);
VALA_EXTERN gboolean desktop_integration_is_send_to_installed (void);
static void desktop_integration_files_send_to_data_free (gpointer _data);
VALA_EXTERN void desktop_integration_files_send_to (GFile** files,
                                        gint files_length1,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void desktop_integration_files_send_to_finish (GAsyncResult* _res_);
static gboolean desktop_integration_files_send_to_co (DesktopIntegrationFilesSendToData* _data_);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void page_window_set_busy_cursor (PageWindow* self);
static void desktop_integration_files_send_to_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
static void _vala_XdpParent_free (XdpParent* self);
VALA_EXTERN void page_window_set_normal_cursor (PageWindow* self);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN void desktop_integration_send_to (GeeCollection* media);
VALA_EXTERN GType export_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportDialog, g_object_unref)
VALA_EXTERN ExportDialog* export_dialog_new (const gchar* title);
VALA_EXTERN ExportDialog* export_dialog_construct (GType object_type,
                                       const gchar* title);
VALA_EXTERN gboolean media_source_collection_has_video (GeeCollection* media);
VALA_EXTERN gboolean media_source_collection_has_photo (GeeCollection* media);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN GType exporter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exporter, g_object_unref)
VALA_EXTERN ExporterUI* video_export_many (GeeCollection* videos,
                               ExporterCompletionCallback done,
                               gpointer done_target,
                               gboolean export_in_place);
VALA_EXTERN void desktop_integration_on_send_to_export_completed (Exporter* exporter,
                                                      gboolean is_cancelled);
static void _desktop_integration_on_send_to_export_completed_exporter_completion_callback (Exporter* exporter,
                                                                                    gboolean is_cancelled,
                                                                                    gpointer self);
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_parameters_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_free (ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_current (ExportFormatParameters* result);
VALA_EXTERN gboolean export_dialog_execute (ExportDialog* self,
                                gint* scale,
                                ScaleConstraint* constraint,
                                ExportFormatParameters* parameters);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN void scaling_for_constraint (ScaleConstraint constraint,
                             gint scale,
                             gboolean scale_up,
                             Scaling* result);
VALA_EXTERN Exporter* exporter_new_for_temp_file (GeeCollection* to_export,
                                      Scaling* scaling,
                                      ExportFormatParameters* export_params);
VALA_EXTERN Exporter* exporter_construct_for_temp_file (GType object_type,
                                            GeeCollection* to_export,
                                            Scaling* scaling,
                                            ExportFormatParameters* export_params);
VALA_EXTERN ExporterUI* exporter_ui_new (Exporter* exporter);
VALA_EXTERN ExporterUI* exporter_ui_construct (GType object_type,
                                   Exporter* exporter);
VALA_EXTERN void exporter_ui_export (ExporterUI* self,
                         ExporterCompletionCallback completion_callback,
                         gpointer completion_callback_target);
VALA_EXTERN GFile** exporter_get_exported_files (Exporter* self,
                                     gint* result_length1);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN void desktop_integration_set_background (Photo* photo,
                                         gboolean desktop,
                                         gboolean screensaver);
VALA_EXTERN PhotoFileFormat photo_get_best_export_file_format (Photo* self);
VALA_EXTERN GFile* app_dirs_get_data_subdir (const gchar* name,
                                 const gchar* subname);
VALA_EXTERN gchar* photo_file_format_get_default_basename (PhotoFileFormat self,
                                               const gchar* name);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
VALA_EXTERN void photo_export (Photo* self,
                   GFile* dest_file,
                   Scaling* scaling,
                   JpegQuality quality,
                   PhotoFileFormat export_format,
                   gboolean direct_copy_unmodified,
                   gboolean export_metadata,
                   GError** error);
VALA_EXTERN void scaling_for_original (Scaling* result);
VALA_EXTERN gpointer desktop_integration_background_slideshow_xml_builder_ref (gpointer instance);
VALA_EXTERN void desktop_integration_background_slideshow_xml_builder_unref (gpointer instance);
VALA_EXTERN GParamSpec* desktop_integration_param_spec_background_slideshow_xml_builder (const gchar* name,
                                                                             const gchar* nick,
                                                                             const gchar* blurb,
                                                                             GType object_type,
                                                                             GParamFlags flags);
VALA_EXTERN void desktop_integration_value_set_background_slideshow_xml_builder (GValue* value,
                                                                     gpointer v_object);
VALA_EXTERN void desktop_integration_value_take_background_slideshow_xml_builder (GValue* value,
                                                                      gpointer v_object);
VALA_EXTERN gpointer desktop_integration_value_get_background_slideshow_xml_builder (const GValue* value);
VALA_EXTERN GType desktop_integration_background_slideshow_xml_builder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopIntegrationBackgroundSlideshowXMLBuilder, desktop_integration_background_slideshow_xml_builder_unref)
VALA_EXTERN DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_new (GFile* destination,
                                                                                                           gdouble duration,
                                                                                                           gdouble transition);
VALA_EXTERN DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_construct (GType object_type,
                                                                                                                 GFile* destination,
                                                                                                                 gdouble duration,
                                                                                                                 gdouble transition);
VALA_EXTERN void desktop_integration_background_slideshow_xml_builder_open (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                GError** error);
static void desktop_integration_background_slideshow_xml_builder_write_transition (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                            GFile* from,
                                                                            GFile* to,
                                                                            GError** error);
static void desktop_integration_background_slideshow_xml_builder_write_static (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                        GFile* file,
                                                                        GError** error);
VALA_EXTERN void desktop_integration_background_slideshow_xml_builder_add_photo (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                     GFile* file,
                                                                     GError** error);
VALA_EXTERN GFile* desktop_integration_background_slideshow_xml_builder_close (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                   GError** error);
static void desktop_integration_background_slideshow_xml_builder_finalize (DesktopIntegrationBackgroundSlideshowXMLBuilder * obj);
static GType desktop_integration_background_slideshow_xml_builder_get_type_once (void);
VALA_EXTERN void desktop_integration_set_background_slideshow (GeeCollection* photos,
                                                   gdouble duration,
                                                   gdouble transition,
                                                   gboolean desktop_background,
                                                   gboolean screensaver);
VALA_EXTERN void delete_all_files (GFile* dir,
                       GeeSet* exceptions,
                       ProgressMonitor monitor,
                       gpointer monitor_target,
                       guint64 file_count,
                       GCancellable* cancellable,
                       GError** error);
VALA_EXTERN void scaling_to_fill_screen (GtkWindow* window,
                             Scaling* result);
VALA_EXTERN Exporter* exporter_new (GeeCollection* to_export,
                        GFile* dir,
                        Scaling* scaling,
                        ExportFormatParameters* export_params,
                        gboolean auto_replace_all);
VALA_EXTERN Exporter* exporter_construct (GType object_type,
                              GeeCollection* to_export,
                              GFile* dir,
                              Scaling* scaling,
                              ExportFormatParameters* export_params,
                              gboolean auto_replace_all);
VALA_EXTERN void desktop_integration_on_desktop_slideshow_exported (Exporter* exporter,
                                                        gboolean is_cancelled);
static void _desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback (Exporter* exporter,
                                                                                      gboolean is_cancelled,
                                                                                      gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
desktop_integration_init (void)
{
	gint _tmp0_;
	_tmp0_ = desktop_integration_init_count;
	desktop_integration_init_count = _tmp0_ + 1;
	if (_tmp0_ != 0) {
		return;
	}
}

void
desktop_integration_terminate (void)
{
	gint _tmp0_;
	desktop_integration_init_count = desktop_integration_init_count - 1;
	_tmp0_ = desktop_integration_init_count;
	if (_tmp0_ == 0) {
		return;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

GAppInfo*
desktop_integration_get_default_app_for_mime_types (gchar** mime_types,
                                                    gint mime_types_length1,
                                                    GeeArrayList* preferred_apps)
{
	SortedList* external_apps = NULL;
	SortedList* _tmp0_;
	GAppInfo* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (preferred_apps, GEE_TYPE_ARRAY_LIST), NULL);
	_tmp0_ = desktop_integration_get_apps_for_mime_types (mime_types, (gint) mime_types_length1);
	external_apps = _tmp0_;
	{
		GeeArrayList* _preferred_app_list = NULL;
		gint _preferred_app_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _preferred_app_index = 0;
		_preferred_app_list = preferred_apps;
		_tmp1_ = _preferred_app_list;
		_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp3_ = _tmp2_;
		_preferred_app_size = _tmp3_;
		_preferred_app_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* preferred_app = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_preferred_app_index = _preferred_app_index + 1;
			_tmp4_ = _preferred_app_index;
			_tmp5_ = _preferred_app_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _preferred_app_list;
			_tmp7_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _preferred_app_index);
			preferred_app = (gchar*) _tmp7_;
			{
				GeeIterator* _external_app_it = NULL;
				SortedList* _tmp8_;
				GeeIterator* _tmp9_;
				_tmp8_ = external_apps;
				_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
				_external_app_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_;
					GAppInfo* external_app = NULL;
					GeeIterator* _tmp11_;
					gpointer _tmp12_;
					GAppInfo* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp10_ = _external_app_it;
					if (!gee_iterator_next (_tmp10_)) {
						break;
					}
					_tmp11_ = _external_app_it;
					_tmp12_ = gee_iterator_get (_tmp11_);
					external_app = (GAppInfo*) _tmp12_;
					_tmp13_ = external_app;
					_tmp14_ = g_app_info_get_name (_tmp13_);
					_tmp15_ = preferred_app;
					if (string_contains (_tmp14_, _tmp15_)) {
						result = external_app;
						_g_object_unref0 (_external_app_it);
						_g_free0 (preferred_app);
						_g_object_unref0 (external_apps);
						return result;
					}
					_g_object_unref0 (external_app);
				}
				_g_object_unref0 (_external_app_it);
			}
			_g_free0 (preferred_app);
		}
	}
	result = NULL;
	_g_object_unref0 (external_apps);
	return result;
}

gint64
desktop_integration_app_info_comparator (void* a,
                                         void* b)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint64 _tmp6_;
	gint64 result;
	_tmp0_ = g_app_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (a, g_app_info_get_type (), GAppInfo));
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_app_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (b, g_app_info_get_type (), GAppInfo));
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = (gint64) g_utf8_collate (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gint64
_desktop_integration_app_info_comparator_comparator (void* a,
                                                     void* b,
                                                     gpointer self)
{
	gint64 result;
	result = desktop_integration_app_info_comparator (a, b);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

SortedList*
desktop_integration_get_apps_for_mime_types (gchar** mime_types,
                                             gint mime_types_length1)
{
	SortedList* external_apps = NULL;
	SortedList* _tmp0_;
	SortedList* result;
	_tmp0_ = sorted_list_new (g_app_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _desktop_integration_app_info_comparator_comparator, NULL);
	external_apps = _tmp0_;
	if (mime_types_length1 == 0) {
		result = external_apps;
		return result;
	}
	{
		gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
		mime_type_collection = mime_types;
		mime_type_collection_length1 = mime_types_length1;
		for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
			gchar* _tmp1_;
			gchar* mime_type = NULL;
			_tmp1_ = g_strdup (mime_type_collection[mime_type_it]);
			mime_type = _tmp1_;
			{
				gchar* content_type = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				GList* _tmp6_;
				_tmp2_ = mime_type;
				_tmp3_ = g_content_type_from_mime_type (_tmp2_);
				content_type = _tmp3_;
				_tmp4_ = content_type;
				if (_tmp4_ == NULL) {
					_g_free0 (content_type);
					_g_free0 (mime_type);
					break;
				}
				_tmp5_ = content_type;
				_tmp6_ = g_app_info_get_all_for_type (_tmp5_);
				{
					GList* external_app_collection = NULL;
					GList* external_app_it = NULL;
					external_app_collection = _tmp6_;
					for (external_app_it = external_app_collection; external_app_it != NULL; external_app_it = external_app_it->next) {
						GAppInfo* _tmp7_;
						GAppInfo* external_app = NULL;
						_tmp7_ = _g_object_ref0 ((GAppInfo*) external_app_it->data);
						external_app = _tmp7_;
						{
							gboolean already_contains = FALSE;
							gboolean _tmp17_ = FALSE;
							already_contains = FALSE;
							{
								GeeIterator* _app_it = NULL;
								SortedList* _tmp8_;
								GeeIterator* _tmp9_;
								_tmp8_ = external_apps;
								_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
								_app_it = _tmp9_;
								while (TRUE) {
									GeeIterator* _tmp10_;
									GAppInfo* app = NULL;
									GeeIterator* _tmp11_;
									gpointer _tmp12_;
									GAppInfo* _tmp13_;
									const gchar* _tmp14_;
									GAppInfo* _tmp15_;
									const gchar* _tmp16_;
									_tmp10_ = _app_it;
									if (!gee_iterator_next (_tmp10_)) {
										break;
									}
									_tmp11_ = _app_it;
									_tmp12_ = gee_iterator_get (_tmp11_);
									app = (GAppInfo*) _tmp12_;
									_tmp13_ = app;
									_tmp14_ = g_app_info_get_name (_tmp13_);
									_tmp15_ = external_app;
									_tmp16_ = g_app_info_get_name (_tmp15_);
									if (g_strcmp0 (_tmp14_, _tmp16_) == 0) {
										already_contains = TRUE;
										_g_object_unref0 (app);
										break;
									}
									_g_object_unref0 (app);
								}
								_g_object_unref0 (_app_it);
							}
							if (!already_contains) {
								GAppInfo* _tmp18_;
								const gchar* _tmp19_;
								_tmp18_ = external_app;
								_tmp19_ = g_app_info_get_name (_tmp18_);
								_tmp17_ = !string_contains (_tmp19_, RESOURCES_APP_TITLE);
							} else {
								_tmp17_ = FALSE;
							}
							if (_tmp17_) {
								SortedList* _tmp20_;
								GAppInfo* _tmp21_;
								_tmp20_ = external_apps;
								_tmp21_ = external_app;
								gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), _tmp21_);
							}
							_g_object_unref0 (external_app);
						}
					}
					(external_app_collection == NULL) ? NULL : (external_app_collection = (_g_list_free__g_object_unref0_ (external_app_collection), NULL));
				}
				_g_free0 (content_type);
				_g_free0 (mime_type);
			}
		}
	}
	result = external_apps;
	return result;
}

gchar*
desktop_integration_get_app_open_command (GAppInfo* app_info)
{
	gchar* str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (app_info, g_app_info_get_type ()), NULL);
	_tmp0_ = g_app_info_get_commandline (app_info);
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp3_ = str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = str;
		_tmp2_ = _tmp4_;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = g_app_info_get_executable (app_info);
		_tmp2_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp2_);
	result = _tmp6_;
	_g_free0 (str);
	return result;
}

gboolean
desktop_integration_is_send_to_installed (void)
{
	gboolean result;
	result = TRUE;
	return result;
}

static void
desktop_integration_files_send_to_data_free (gpointer _data)
{
	DesktopIntegrationFilesSendToData* _data_;
	_data_ = _data;
	g_slice_free (DesktopIntegrationFilesSendToData, _data_);
}

void
desktop_integration_files_send_to (GFile** files,
                                   gint files_length1,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	DesktopIntegrationFilesSendToData* _data_;
	_data_ = g_slice_new0 (DesktopIntegrationFilesSendToData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, desktop_integration_files_send_to_data_free);
	_data_->files = files;
	_data_->files_length1 = files_length1;
	desktop_integration_files_send_to_co (_data_);
}

void
desktop_integration_files_send_to_finish (GAsyncResult* _res_)
{
	DesktopIntegrationFilesSendToData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
desktop_integration_files_send_to_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	DesktopIntegrationFilesSendToData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	desktop_integration_files_send_to_co (_data_);
}

static void
_vala_XdpParent_free (XdpParent* self)
{
	g_boxed_free (xdp_parent_get_type (), self);
}

static gboolean
desktop_integration_files_send_to_co (DesktopIntegrationFilesSendToData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->files_length1 == 0) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = app_window_get_instance ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = xdp_parent_new_gtk (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, gtk_window_get_type (), GtkWindow));
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->parent = _data_->_tmp3_;
	_data_->_tmp4_ = g_string_new ("");
	_data_->file_names = _data_->_tmp4_;
	_data_->_tmp5_ = g_new0 (gchar*, _data_->files_length1 + 1);
	_data_->file_paths = _data_->_tmp5_;
	_data_->file_paths_length1 = _data_->files_length1;
	_data_->_file_paths_size_ = _data_->file_paths_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp6_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp6_) {
					_data_->_tmp7_ = _data_->i;
					_data_->i = _data_->_tmp7_ + 1;
				}
				_data_->_tmp6_ = FALSE;
				if (!(_data_->i < _data_->files_length1)) {
					break;
				}
				_data_->_tmp8_ = _data_->file_names;
				_data_->_tmp9_ = _data_->files[_data_->i];
				_data_->_tmp10_ = g_file_get_basename (_data_->_tmp9_);
				_data_->_tmp11_ = _data_->_tmp10_;
				g_string_append (_data_->_tmp8_, _data_->_tmp11_);
				_g_free0 (_data_->_tmp11_);
				if (_data_->i < (_data_->files_length1 - 1)) {
					_data_->_tmp12_ = _data_->file_names;
					g_string_append (_data_->_tmp12_, ", ");
				}
				_data_->_tmp13_ = _data_->file_paths;
				_data_->_tmp13__length1 = _data_->file_paths_length1;
				_data_->_tmp14_ = _data_->files[_data_->i];
				_data_->_tmp15_ = g_file_get_path (_data_->_tmp14_);
				_g_free0 (_data_->_tmp13_[_data_->i]);
				_data_->_tmp13_[_data_->i] = _data_->_tmp15_;
			}
		}
	}
	_data_->_tmp16_ = app_window_get_instance ();
	_data_->_tmp17_ = _data_->_tmp16_;
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_data_->_tmp17_);
	{
		_data_->_tmp18_ = xdp_portal_new ();
		_data_->portal = _data_->_tmp18_;
		_data_->_tmp19_ = _data_->portal;
		_data_->_tmp20_ = _data_->parent;
		_data_->_tmp21_ = g_new0 (gchar*, 1 + 1);
		_data_->_tmp21_[0] = NULL;
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp22__length1 = 1;
		_data_->_tmp23_ = _data_->file_names;
		_data_->_tmp24_ = _data_->_tmp23_->str;
		_data_->_tmp25_ = g_strconcat (_ ("Send files per Mail: "), _data_->_tmp24_, NULL);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->file_paths;
		_data_->_tmp27__length1 = _data_->file_paths_length1;
		_data_->_state_ = 1;
		xdp_portal_compose_email (_data_->_tmp19_, _data_->_tmp20_, _data_->_tmp22_, NULL, NULL, _data_->_tmp26_, NULL, _data_->_tmp27_, XDP_EMAIL_FLAG_NONE, NULL, desktop_integration_files_send_to_ready, _data_);
		return FALSE;
		_state_1:
		xdp_portal_compose_email_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp26_);
		_data_->_tmp22_ = (_vala_array_free (_data_->_tmp22_, _data_->_tmp22__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->portal);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->portal);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp28_ = _data_->file_names;
		_data_->_tmp29_ = _data_->_tmp28_->str;
		_data_->_tmp30_ = _data_->e;
		_data_->_tmp31_ = _data_->_tmp30_->message;
		_data_->_tmp32_ = g_strdup_printf (_ ("Unable to send file %s, %s"), _data_->_tmp29_, _data_->_tmp31_);
		_data_->_tmp33_ = _data_->_tmp32_;
		app_window_error_message (_data_->_tmp33_, NULL);
		_g_free0 (_data_->_tmp33_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_data_->file_paths = (_vala_array_free (_data_->file_paths, _data_->file_paths_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (_data_->file_names);
		__vala_XdpParent_free0 (_data_->parent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = app_window_get_instance ();
	_data_->_tmp35_ = _data_->_tmp34_;
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (_data_->_tmp35_);
	_data_->file_paths = (_vala_array_free (_data_->file_paths, _data_->file_paths_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (_data_->file_names);
	__vala_XdpParent_free0 (_data_->parent);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_desktop_integration_on_send_to_export_completed_exporter_completion_callback (Exporter* exporter,
                                                                               gboolean is_cancelled,
                                                                               gpointer self)
{
	desktop_integration_on_send_to_export_completed (exporter, is_cancelled);
}

void
desktop_integration_send_to (GeeCollection* media)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	ExportDialog* dialog = NULL;
	ExportDialog* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint scale = 0;
	ScaleConstraint constraint = 0;
	ExportFormatParameters export_params = {0};
	ExportFormatParameters _tmp7_ = {0};
	ExportDialog* _tmp8_;
	gint _tmp9_ = 0;
	ScaleConstraint _tmp10_ = 0;
	gboolean _tmp11_;
	Scaling _tmp12_ = {0};
	ExportFormatParameters _tmp13_;
	Exporter* _tmp14_;
	Exporter* _tmp15_;
	ExporterUI* _tmp16_;
	ExporterUI* _tmp17_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media, GEE_TYPE_COLLECTION));
	_tmp1_ = gee_collection_get_size (media);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		_tmp0_ = TRUE;
	} else {
		ExporterUI* _tmp3_;
		_tmp3_ = desktop_integration_send_to_exporter;
		_tmp0_ = _tmp3_ != NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = export_dialog_new (_ ("Send To"));
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	if (media_source_collection_has_video (media)) {
		_tmp5_ = !media_source_collection_has_photo (media);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ExporterUI* _tmp6_;
		_tmp6_ = video_export_many (G_TYPE_CHECK_INSTANCE_CAST (media, GEE_TYPE_COLLECTION, GeeCollection), _desktop_integration_on_send_to_export_completed_exporter_completion_callback, NULL, TRUE);
		_exporter_ui_unref0 (desktop_integration_send_to_exporter);
		desktop_integration_send_to_exporter = _tmp6_;
		_g_object_unref0 (dialog);
		return;
	}
	export_format_parameters_current (&_tmp7_);
	export_params = _tmp7_;
	_tmp8_ = dialog;
	_tmp11_ = export_dialog_execute (_tmp8_, &_tmp9_, &_tmp10_, &export_params);
	scale = _tmp9_;
	constraint = _tmp10_;
	if (!_tmp11_) {
		_g_object_unref0 (dialog);
		return;
	}
	scaling_for_constraint (constraint, scale, FALSE, &_tmp12_);
	_tmp13_ = export_params;
	_tmp14_ = exporter_new_for_temp_file (media, &_tmp12_, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = exporter_ui_new (_tmp15_);
	_exporter_ui_unref0 (desktop_integration_send_to_exporter);
	desktop_integration_send_to_exporter = _tmp16_;
	_g_object_unref0 (_tmp15_);
	_tmp17_ = desktop_integration_send_to_exporter;
	exporter_ui_export (_tmp17_, _desktop_integration_on_send_to_export_completed_exporter_completion_callback, NULL);
	_g_object_unref0 (dialog);
}

void
desktop_integration_on_send_to_export_completed (Exporter* exporter,
                                                 gboolean is_cancelled)
{
	g_return_if_fail (IS_EXPORTER (exporter));
	if (!is_cancelled) {
		gint _tmp0_ = 0;
		GFile** _tmp1_;
		GFile** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = exporter_get_exported_files (exporter, &_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp2__length1 = _tmp0_;
		desktop_integration_files_send_to (_tmp2_, (gint) _tmp0_, NULL, NULL);
		_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_exporter_ui_unref0 (desktop_integration_send_to_exporter);
	desktop_integration_send_to_exporter = NULL;
}

void
desktop_integration_set_background (Photo* photo,
                                    gboolean desktop,
                                    gboolean screensaver)
{
	PhotoFileFormat file_format = 0;
	GFile* save_as = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	ConfigFacade* _tmp6_;
	ConfigFacade* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_;
	XdpParent* parent = NULL;
	AppWindow* _tmp28_;
	AppWindow* _tmp29_;
	XdpParent* _tmp30_;
	XdpParent* _tmp31_;
	XdpPortal* portal = NULL;
	XdpPortal* _tmp32_;
	XdpWallpaperFlags flags = 0U;
	XdpPortal* _tmp33_;
	XdpParent* _tmp34_;
	GFile* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GFile* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (photo));
	file_format = photo_get_best_export_file_format (photo);
	_tmp0_ = app_dirs_get_data_subdir ("wallpaper", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_get_default_basename (file_format, "wallpaper");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_child (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	save_as = _tmp5_;
	_tmp6_ = config_facade_get_instance ();
	_tmp7_ = _tmp6_;
	_tmp8_ = configuration_facade_get_desktop_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp9_ = _tmp8_;
	_tmp10_ = save_as;
	_tmp11_ = g_file_get_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strcmp0 (_tmp9_, _tmp12_) == 0;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	if (_tmp13_) {
		GFile* _tmp14_;
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GFile* _tmp18_;
		_tmp14_ = app_dirs_get_data_subdir ("wallpaper", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = photo_file_format_get_default_basename (file_format, "wallpaper_alt");
		_tmp17_ = _tmp16_;
		_tmp18_ = g_file_get_child (_tmp15_, _tmp17_);
		_g_object_unref0 (save_as);
		save_as = _tmp18_;
		_g_free0 (_tmp17_);
		_g_object_unref0 (_tmp15_);
	}
	{
		GFile* _tmp19_;
		Scaling _tmp20_ = {0};
		_tmp19_ = save_as;
		scaling_for_original (&_tmp20_);
		photo_export (photo, _tmp19_, &_tmp20_, JPEG_QUALITY_HIGH, file_format, FALSE, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = save_as;
		_tmp22_ = g_file_get_path (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = err;
		_tmp25_ = _tmp24_->message;
		_tmp26_ = g_strdup_printf (_ ("Unable to export background to %s: %s"), _tmp23_, _tmp25_);
		_tmp27_ = _tmp26_;
		app_window_error_message (_tmp27_, NULL);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp23_);
		_g_error_free0 (err);
		_g_object_unref0 (save_as);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (save_as);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp28_ = app_window_get_instance ();
	_tmp29_ = _tmp28_;
	_tmp30_ = xdp_parent_new_gtk (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_window_get_type (), GtkWindow));
	_tmp31_ = _tmp30_;
	_g_object_unref0 (_tmp29_);
	parent = _tmp31_;
	_tmp32_ = xdp_portal_new ();
	portal = _tmp32_;
	flags = XDP_WALLPAPER_FLAG_PREVIEW;
	if (desktop) {
		flags |= XDP_WALLPAPER_FLAG_BACKGROUND;
	}
	if (screensaver) {
		flags |= XDP_WALLPAPER_FLAG_LOCKSCREEN;
	}
	_tmp33_ = portal;
	_tmp34_ = parent;
	_tmp35_ = save_as;
	_tmp36_ = g_file_get_uri (_tmp35_);
	_tmp37_ = _tmp36_;
	xdp_portal_set_wallpaper (_tmp33_, _tmp34_, _tmp37_, flags, NULL, NULL, NULL);
	_g_free0 (_tmp37_);
	_tmp38_ = save_as;
	_tmp39_ = g_file_get_parse_name (_tmp38_);
	_tmp40_ = _tmp39_;
	g_chmod (_tmp40_, 0644);
	_g_free0 (_tmp40_);
	_g_object_unref0 (portal);
	__vala_XdpParent_free0 (parent);
	_g_object_unref0 (save_as);
}

static inline gpointer
desktop_integration_background_slideshow_xml_builder_get_instance_private (DesktopIntegrationBackgroundSlideshowXMLBuilder* self)
{
	return G_STRUCT_MEMBER_P (self, DesktopIntegrationBackgroundSlideshowXMLBuilder_private_offset);
}

DesktopIntegrationBackgroundSlideshowXMLBuilder*
desktop_integration_background_slideshow_xml_builder_construct (GType object_type,
                                                                GFile* destination,
                                                                gdouble duration,
                                                                gdouble transition)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destination, g_file_get_type ()), NULL);
	self = (DesktopIntegrationBackgroundSlideshowXMLBuilder*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (destination);
	_g_object_unref0 (self->priv->destination);
	self->priv->destination = _tmp0_;
	self->priv->duration = duration;
	self->priv->transition = transition;
	_tmp1_ = g_file_get_parent (destination);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_basename (destination);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, ".tmp", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_get_child (_tmp2_, _tmp6_);
	_g_object_unref0 (self->priv->tmp_file);
	self->priv->tmp_file = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	return self;
}

DesktopIntegrationBackgroundSlideshowXMLBuilder*
desktop_integration_background_slideshow_xml_builder_new (GFile* destination,
                                                          gdouble duration,
                                                          gdouble transition)
{
	return desktop_integration_background_slideshow_xml_builder_construct (DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, destination, duration, transition);
}

void
desktop_integration_background_slideshow_xml_builder_open (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                           GError** error)
{
	GFileOutputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileOutputStream* _tmp2_;
	GDataOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
	_tmp1_ = self->priv->tmp_file;
	_tmp2_ = g_file_replace (_tmp1_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = g_data_output_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_output_stream_get_type (), GOutputStream));
	_g_object_unref0 (self->priv->outs);
	self->priv->outs = _tmp3_;
	_tmp4_ = self->priv->outs;
	g_data_output_stream_put_string (_tmp4_, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<background>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_g_object_unref0 (_tmp0_);
}

static void
desktop_integration_background_slideshow_xml_builder_write_transition (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                       GFile* from,
                                                                       GFile* to,
                                                                       GError** error)
{
	GDataOutputStream* _tmp0_;
	GDataOutputStream* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GDataOutputStream* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GDataOutputStream* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GDataOutputStream* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (from, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to, g_file_get_type ()));
	_tmp0_ = self->priv->outs;
	g_data_output_stream_put_string (_tmp0_, "  <transition>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->outs;
	_tmp2_ = g_strdup_printf ("    <duration>%2.2f</duration>\n", self->priv->transition);
	_tmp3_ = _tmp2_;
	g_data_output_stream_put_string (_tmp1_, _tmp3_, NULL, &_inner_error0_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp4_ = self->priv->outs;
	_tmp5_ = g_file_get_path (from);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("    <from>%s</from>\n", _tmp8_);
	_tmp10_ = _tmp9_;
	g_data_output_stream_put_string (_tmp4_, _tmp10_, NULL, &_inner_error0_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp11_ = self->priv->outs;
	_tmp12_ = g_file_get_path (to);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_markup_escape_text (_tmp13_, (gssize) -1);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("    <to>%s</to>\n", _tmp15_);
	_tmp17_ = _tmp16_;
	g_data_output_stream_put_string (_tmp11_, _tmp17_, NULL, &_inner_error0_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp18_ = self->priv->outs;
	g_data_output_stream_put_string (_tmp18_, "  </transition>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
desktop_integration_background_slideshow_xml_builder_write_static (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                   GFile* file,
                                                                   GError** error)
{
	GDataOutputStream* _tmp0_;
	GDataOutputStream* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GDataOutputStream* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GDataOutputStream* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = self->priv->outs;
	g_data_output_stream_put_string (_tmp0_, "  <static>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->outs;
	_tmp2_ = g_strdup_printf ("    <duration>%2.2f</duration>\n", self->priv->duration);
	_tmp3_ = _tmp2_;
	g_data_output_stream_put_string (_tmp1_, _tmp3_, NULL, &_inner_error0_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp4_ = self->priv->outs;
	_tmp5_ = g_file_get_path (file);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("    <file>%s</file>\n", _tmp8_);
	_tmp10_ = _tmp9_;
	g_data_output_stream_put_string (_tmp4_, _tmp10_, NULL, &_inner_error0_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp11_ = self->priv->outs;
	g_data_output_stream_put_string (_tmp11_, "  </static>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
desktop_integration_background_slideshow_xml_builder_add_photo (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                GFile* file,
                                                                GError** error)
{
	GDataOutputStream* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp3_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = self->priv->outs;
	_vala_assert (_tmp0_ != NULL, "outs != null");
	_tmp1_ = self->priv->first_file;
	if (_tmp1_ == NULL) {
		GFile* _tmp2_;
		_tmp2_ = _g_object_ref0 (file);
		_g_object_unref0 (self->priv->first_file);
		self->priv->first_file = _tmp2_;
	}
	_tmp3_ = self->priv->last_file;
	if (_tmp3_ != NULL) {
		GFile* _tmp4_;
		_tmp4_ = self->priv->last_file;
		desktop_integration_background_slideshow_xml_builder_write_transition (self, _tmp4_, file, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	desktop_integration_background_slideshow_xml_builder_write_static (self, file, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp5_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->last_file);
	self->priv->last_file = _tmp5_;
}

GFile*
desktop_integration_background_slideshow_xml_builder_close (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                            GError** error)
{
	GDataOutputStream* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	GDataOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self), NULL);
	_tmp0_ = self->priv->outs;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->first_file;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		_tmp3_ = self->priv->last_file;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = self->priv->last_file;
		_tmp5_ = self->priv->first_file;
		desktop_integration_background_slideshow_xml_builder_write_transition (self, _tmp4_, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = self->priv->outs;
	g_data_output_stream_put_string (_tmp6_, "</background>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp7_ = self->priv->outs;
	g_output_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_output_stream_get_type (), GOutputStream), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_g_object_unref0 (self->priv->outs);
	self->priv->outs = NULL;
	_tmp8_ = self->priv->tmp_file;
	_tmp9_ = self->priv->destination;
	g_file_move (_tmp8_, _tmp9_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp10_ = self->priv->destination;
	_tmp11_ = g_file_get_parse_name (_tmp10_);
	_tmp12_ = _tmp11_;
	g_chmod (_tmp12_, 0644);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->destination;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	result = _tmp14_;
	return result;
}

static void
desktop_integration_value_background_slideshow_xml_builder_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
desktop_integration_value_background_slideshow_xml_builder_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		desktop_integration_background_slideshow_xml_builder_unref (value->data[0].v_pointer);
	}
}

static void
desktop_integration_value_background_slideshow_xml_builder_copy_value (const GValue* src_value,
                                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = desktop_integration_background_slideshow_xml_builder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
desktop_integration_value_background_slideshow_xml_builder_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
desktop_integration_value_background_slideshow_xml_builder_collect_value (GValue* value,
                                                                          guint n_collect_values,
                                                                          GTypeCValue* collect_values,
                                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DesktopIntegrationBackgroundSlideshowXMLBuilder * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = desktop_integration_background_slideshow_xml_builder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
desktop_integration_value_background_slideshow_xml_builder_lcopy_value (const GValue* value,
                                                                        guint n_collect_values,
                                                                        GTypeCValue* collect_values,
                                                                        guint collect_flags)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = desktop_integration_background_slideshow_xml_builder_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
desktop_integration_param_spec_background_slideshow_xml_builder (const gchar* name,
                                                                 const gchar* nick,
                                                                 const gchar* blurb,
                                                                 GType object_type,
                                                                 GParamFlags flags)
{
	DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
desktop_integration_value_get_background_slideshow_xml_builder (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER), NULL);
	return value->data[0].v_pointer;
}

void
desktop_integration_value_set_background_slideshow_xml_builder (GValue* value,
                                                                gpointer v_object)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		desktop_integration_background_slideshow_xml_builder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		desktop_integration_background_slideshow_xml_builder_unref (old);
	}
}

void
desktop_integration_value_take_background_slideshow_xml_builder (GValue* value,
                                                                 gpointer v_object)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		desktop_integration_background_slideshow_xml_builder_unref (old);
	}
}

static void
desktop_integration_background_slideshow_xml_builder_class_init (DesktopIntegrationBackgroundSlideshowXMLBuilderClass * klass,
                                                                 gpointer klass_data)
{
	desktop_integration_background_slideshow_xml_builder_parent_class = g_type_class_peek_parent (klass);
	((DesktopIntegrationBackgroundSlideshowXMLBuilderClass *) klass)->finalize = desktop_integration_background_slideshow_xml_builder_finalize;
	g_type_class_adjust_private_offset (klass, &DesktopIntegrationBackgroundSlideshowXMLBuilder_private_offset);
}

static void
desktop_integration_background_slideshow_xml_builder_instance_init (DesktopIntegrationBackgroundSlideshowXMLBuilder * self,
                                                                    gpointer klass)
{
	self->priv = desktop_integration_background_slideshow_xml_builder_get_instance_private (self);
	self->priv->outs = NULL;
	self->priv->first_file = NULL;
	self->priv->last_file = NULL;
	self->ref_count = 1;
}

static void
desktop_integration_background_slideshow_xml_builder_finalize (DesktopIntegrationBackgroundSlideshowXMLBuilder * obj)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilder);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->destination);
	_g_object_unref0 (self->priv->tmp_file);
	_g_object_unref0 (self->priv->outs);
	_g_object_unref0 (self->priv->first_file);
	_g_object_unref0 (self->priv->last_file);
}

static GType
desktop_integration_background_slideshow_xml_builder_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { desktop_integration_value_background_slideshow_xml_builder_init, desktop_integration_value_background_slideshow_xml_builder_free_value, desktop_integration_value_background_slideshow_xml_builder_copy_value, desktop_integration_value_background_slideshow_xml_builder_peek_pointer, "p", desktop_integration_value_background_slideshow_xml_builder_collect_value, "p", desktop_integration_value_background_slideshow_xml_builder_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_integration_background_slideshow_xml_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilder), 0, (GInstanceInitFunc) desktop_integration_background_slideshow_xml_builder_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType desktop_integration_background_slideshow_xml_builder_type_id;
	desktop_integration_background_slideshow_xml_builder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DesktopIntegrationBackgroundSlideshowXMLBuilder", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DesktopIntegrationBackgroundSlideshowXMLBuilder_private_offset = g_type_add_instance_private (desktop_integration_background_slideshow_xml_builder_type_id, sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate));
	return desktop_integration_background_slideshow_xml_builder_type_id;
}

GType
desktop_integration_background_slideshow_xml_builder_get_type (void)
{
	static volatile gsize desktop_integration_background_slideshow_xml_builder_type_id__once = 0;
	if (g_once_init_enter (&desktop_integration_background_slideshow_xml_builder_type_id__once)) {
		GType desktop_integration_background_slideshow_xml_builder_type_id;
		desktop_integration_background_slideshow_xml_builder_type_id = desktop_integration_background_slideshow_xml_builder_get_type_once ();
		g_once_init_leave (&desktop_integration_background_slideshow_xml_builder_type_id__once, desktop_integration_background_slideshow_xml_builder_type_id);
	}
	return desktop_integration_background_slideshow_xml_builder_type_id__once;
}

gpointer
desktop_integration_background_slideshow_xml_builder_ref (gpointer instance)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
desktop_integration_background_slideshow_xml_builder_unref (gpointer instance)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback (Exporter* exporter,
                                                                                 gboolean is_cancelled,
                                                                                 gpointer self)
{
	desktop_integration_on_desktop_slideshow_exported (exporter, is_cancelled);
}

void
desktop_integration_set_background_slideshow (GeeCollection* photos,
                                              gdouble duration,
                                              gdouble transition,
                                              gboolean desktop_background,
                                              gboolean screensaver)
{
	ExporterUI* _tmp0_;
	GFile* wallpaper_dir = NULL;
	GFile* _tmp1_;
	GeeSet* exceptions = NULL;
	GeeHashSet* _tmp2_;
	GeeSet* _tmp3_;
	Exporter* exporter = NULL;
	GFile* _tmp8_;
	AppWindow* _tmp9_;
	AppWindow* _tmp10_;
	Scaling _tmp11_ = {0};
	ExportFormatParameters _tmp12_ = {0};
	Exporter* _tmp13_;
	Exporter* _tmp14_;
	Exporter* _tmp15_;
	ExporterUI* _tmp16_;
	ExporterUI* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (photos, GEE_TYPE_COLLECTION));
	_tmp0_ = desktop_integration_desktop_slideshow_exporter;
	if (_tmp0_ != NULL) {
		return;
	}
	desktop_integration_set_desktop_background = desktop_background;
	desktop_integration_set_screensaver = screensaver;
	_tmp1_ = app_dirs_get_data_subdir ("wallpaper", NULL);
	wallpaper_dir = _tmp1_;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	exceptions = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_SET, GeeSet);
	_tmp3_ = exceptions;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME);
	{
		GFile* _tmp4_;
		GeeSet* _tmp5_;
		_tmp4_ = wallpaper_dir;
		_tmp5_ = exceptions;
		delete_all_files (_tmp4_, _tmp5_, NULL, NULL, (guint64) 0, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("DesktopIntegration.vala:278: Error attempting to clear wallpaper direc" \
"tory: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (exceptions);
		_g_object_unref0 (wallpaper_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	desktop_integration_desktop_slideshow_duration = duration;
	desktop_integration_desktop_slideshow_transition = transition;
	_tmp8_ = wallpaper_dir;
	_tmp9_ = app_window_get_instance ();
	_tmp10_ = _tmp9_;
	scaling_to_fill_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow), &_tmp11_);
	export_format_parameters_current (&_tmp12_);
	_tmp13_ = exporter_new (photos, _tmp8_, &_tmp11_, &_tmp12_, TRUE);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp10_);
	exporter = _tmp14_;
	_tmp15_ = exporter;
	_tmp16_ = exporter_ui_new (_tmp15_);
	_exporter_ui_unref0 (desktop_integration_desktop_slideshow_exporter);
	desktop_integration_desktop_slideshow_exporter = _tmp16_;
	_tmp17_ = desktop_integration_desktop_slideshow_exporter;
	exporter_ui_export (_tmp17_, _desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback, NULL);
	_g_object_unref0 (exporter);
	_g_object_unref0 (exceptions);
	_g_object_unref0 (wallpaper_dir);
}

void
desktop_integration_on_desktop_slideshow_exported (Exporter* exporter,
                                                   gboolean is_cancelled)
{
	GFile* xml_file = NULL;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* xml_builder = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp4_;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp5_;
	XdpParent* parent = NULL;
	AppWindow* _tmp20_;
	AppWindow* _tmp21_;
	XdpParent* _tmp22_;
	XdpParent* _tmp23_;
	XdpPortal* portal = NULL;
	XdpPortal* _tmp24_;
	XdpWallpaperFlags flags = 0U;
	XdpPortal* _tmp25_;
	XdpParent* _tmp26_;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_EXPORTER (exporter));
	_exporter_ui_unref0 (desktop_integration_desktop_slideshow_exporter);
	desktop_integration_desktop_slideshow_exporter = NULL;
	if (is_cancelled) {
		return;
	}
	xml_file = NULL;
	_tmp0_ = app_dirs_get_data_subdir ("wallpaper", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME);
	_tmp3_ = _tmp2_;
	_tmp4_ = desktop_integration_background_slideshow_xml_builder_new (_tmp3_, desktop_integration_desktop_slideshow_duration, desktop_integration_desktop_slideshow_transition);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	xml_builder = _tmp5_;
	{
		DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp6_;
		gint _tmp7_ = 0;
		GFile** _tmp8_;
		GFile* _tmp12_ = NULL;
		DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		_tmp6_ = xml_builder;
		desktop_integration_background_slideshow_xml_builder_open (_tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = exporter_get_exported_files (exporter, &_tmp7_);
		{
			GFile** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
			file_collection = _tmp8_;
			file_collection_length1 = _tmp7_;
			for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
				GFile* _tmp9_;
				GFile* file = NULL;
				_tmp9_ = _g_object_ref0 (file_collection[file_it]);
				file = _tmp9_;
				{
					DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp10_;
					GFile* _tmp11_;
					_tmp10_ = xml_builder;
					_tmp11_ = file;
					desktop_integration_background_slideshow_xml_builder_add_photo (_tmp10_, _tmp11_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (file);
						file_collection = (_vala_array_free (file_collection, file_collection_length1, (GDestroyNotify) g_object_unref), NULL);
						goto __catch0_g_error;
					}
					_g_object_unref0 (file);
				}
			}
			file_collection = (_vala_array_free (file_collection, file_collection_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		_tmp13_ = xml_builder;
		_tmp14_ = desktop_integration_background_slideshow_xml_builder_close (_tmp13_, &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp15_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (xml_file);
		xml_file = _tmp15_;
		_g_object_unref0 (_tmp12_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = err;
		_tmp17_ = _tmp16_->message;
		_tmp18_ = g_strdup_printf (_ ("Unable to prepare desktop slideshow: %s"), _tmp17_);
		_tmp19_ = _tmp18_;
		app_window_error_message (_tmp19_, NULL);
		_g_free0 (_tmp19_);
		_g_error_free0 (err);
		_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
		_g_object_unref0 (xml_file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
		_g_object_unref0 (xml_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = app_window_get_instance ();
	_tmp21_ = _tmp20_;
	_tmp22_ = xdp_parent_new_gtk (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_window_get_type (), GtkWindow));
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp21_);
	parent = _tmp23_;
	_tmp24_ = xdp_portal_new ();
	portal = _tmp24_;
	flags = XDP_WALLPAPER_FLAG_PREVIEW;
	if (desktop_integration_set_desktop_background) {
		flags |= XDP_WALLPAPER_FLAG_BACKGROUND;
	}
	if (desktop_integration_set_screensaver) {
		flags |= XDP_WALLPAPER_FLAG_LOCKSCREEN;
	}
	_tmp25_ = portal;
	_tmp26_ = parent;
	_tmp27_ = xml_file;
	_tmp28_ = g_file_get_uri (_tmp27_);
	_tmp29_ = _tmp28_;
	xdp_portal_set_wallpaper (_tmp25_, _tmp26_, _tmp29_, flags, NULL, NULL, NULL);
	_g_free0 (_tmp29_);
	_g_object_unref0 (portal);
	__vala_XdpParent_free0 (parent);
	_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
	_g_object_unref0 (xml_file);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

