/* CheckerboardLayout.c generated by valac 0.56.17, the Vala compiler
 * generated from CheckerboardLayout.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>

#define CHECKERBOARD_LAYOUT_TOP_PADDING 16
#define CHECKERBOARD_LAYOUT_BOTTOM_PADDING 16
#define CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_SELECTION_ALPHA 0.40
#define CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH 1
#define TAG_TAG_LIST_SEPARATOR_STRING ", "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CHECKERBOARD_LAYOUT (checkerboard_layout_get_type ())
#define CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout))
#define CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))
#define IS_CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_LAYOUT))
#define IS_CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_LAYOUT))
#define CHECKERBOARD_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))

typedef struct _CheckerboardLayout CheckerboardLayout;
typedef struct _CheckerboardLayoutClass CheckerboardLayoutClass;
typedef struct _CheckerboardLayoutPrivate CheckerboardLayoutPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW (checkerboard_layout_layout_row_get_type ())
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))

typedef struct _CheckerboardLayoutLayoutRow CheckerboardLayoutLayoutRow;
typedef struct _CheckerboardLayoutLayoutRowClass CheckerboardLayoutLayoutRowClass;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
enum  {
	CHECKERBOARD_LAYOUT_0_PROPERTY,
	CHECKERBOARD_LAYOUT_NUM_PROPERTIES
};
static GParamSpec* checkerboard_layout_properties[CHECKERBOARD_LAYOUT_NUM_PROPERTIES];

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DataObjectPrivate DataObjectPrivate;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _CheckerboardLayoutLayoutRowPrivate CheckerboardLayoutLayoutRowPrivate;
#define _checkerboard_layout_layout_row_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_layout_layout_row_unref (var), NULL)))

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;
typedef enum  {
	COMPASS_POINT_NORTH,
	COMPASS_POINT_SOUTH,
	COMPASS_POINT_EAST,
	COMPASS_POINT_WEST
} CompassPoint;

#define TYPE_COMPASS_POINT (compass_point_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
typedef struct _CheckerboardLayoutParamSpecLayoutRow CheckerboardLayoutParamSpecLayoutRow;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CheckerboardLayout {
	GtkDrawingArea parent_instance;
	CheckerboardLayoutPrivate * priv;
};

struct _CheckerboardLayoutClass {
	GtkDrawingAreaClass parent_class;
};

struct _CheckerboardLayoutPrivate {
	ViewCollection* view;
	gchar* page_name;
	CheckerboardLayoutLayoutRow** item_rows;
	gint item_rows_length1;
	gint _item_rows_size_;
	GeeHashSet* exposed_items;
	GtkAdjustment* hadjustment;
	GtkAdjustment* vadjustment;
	GdkRGBA selected_color;
	GdkRGBA unselected_color;
	GdkRGBA focus_color;
	GdkRGBA border_color;
	GdkRGBA bg_color;
	GdkRectangle visible_page;
	gint last_width;
	gint columns;
	gint rows;
	GdkPoint drag_origin;
	GdkPoint drag_endpoint;
	GdkRectangle selection_band;
	gint scale;
	gboolean flow_scheduled;
	gboolean exposure_dirty;
	CheckerboardItem* anchor;
	CheckerboardItem* cursor;
	gboolean in_center_on_anchor;
	gboolean size_allocate_due_to_reflow;
	gboolean is_in_view;
	gboolean reflow_needed;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*handle_mouse_motion) (CheckerboardItem* self, gint x, gint y, gint height, gint width);
	void (*handle_mouse_leave) (CheckerboardItem* self);
	void (*handle_mouse_enter) (CheckerboardItem* self);
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _CheckerboardLayoutLayoutRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardLayoutLayoutRowPrivate * priv;
	gint y;
	gint height;
	CheckerboardItem** items;
	gint items_length1;
	gint _items_size_;
};

struct _CheckerboardLayoutLayoutRowClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardLayoutLayoutRow *self);
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _CheckerboardLayoutParamSpecLayoutRow {
	GParamSpec parent_instance;
};

static gint CheckerboardLayout_private_offset;
static gpointer checkerboard_layout_parent_class = NULL;
static gpointer checkerboard_layout_layout_row_parent_class = NULL;

VALA_EXTERN GType checkerboard_layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardLayout, g_object_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
static gpointer checkerboard_layout_layout_row_ref (gpointer instance);
static void checkerboard_layout_layout_row_unref (gpointer instance);
static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void checkerboard_layout_value_set_layout_row (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void checkerboard_layout_value_take_layout_row (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) G_GNUC_UNUSED ;
static GType checkerboard_layout_layout_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardLayoutLayoutRow, checkerboard_layout_layout_row_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN GType thumbnail_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailView, g_object_unref)
VALA_EXTERN GType checkerboard_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardItem, g_object_unref)
static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                                GeeIterable* added,
                                                                                GeeIterable* removed,
                                                                                gpointer self);
static void checkerboard_layout_on_items_altered (CheckerboardLayout* self);
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                                          GeeMap* items,
                                                                          gpointer self);
static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self,
                                                 GeeIterable* changed);
static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                                      GeeIterable* changed,
                                                                                      gpointer self);
static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self,
                                                      GeeIterable* changed);
static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                                GeeCollection* changed,
                                                                                                gpointer self);
static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender,
                                                                                gpointer self);
static void checkerboard_layout_on_views_altered (CheckerboardLayout* self,
                                           GeeCollection* altered);
static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender,
                                                                          GeeCollection* views,
                                                                          gpointer self);
static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender,
                                                                                    GeeCollection* views,
                                                                                    gpointer self);
static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender,
                                                                                     GeeIterable* selected,
                                                                                     gpointer self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender,
                                                                                       GeeIterable* unselected,
                                                                                       gpointer self);
static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                            gpointer self);
static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                        GtkAllocation* allocation,
                                                                        gpointer self);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender,
                                                                          gpointer self);
VALA_EXTERN CheckerboardLayout* checkerboard_layout_new (ViewCollection* view);
VALA_EXTERN CheckerboardLayout* checkerboard_layout_construct (GType object_type,
                                                   ViewCollection* view);
VALA_EXTERN void checkerboard_layout_clear_drag_select (CheckerboardLayout* self);
VALA_EXTERN void checkerboard_layout_set_adjustments (CheckerboardLayout* self,
                                          GtkAdjustment* hadjustment,
                                          GtkAdjustment* vadjustment);
VALA_EXTERN void checkerboard_layout_set_scale (CheckerboardLayout* self,
                                    gint scale);
VALA_EXTERN gint checkerboard_layout_get_scale (CheckerboardLayout* self);
VALA_EXTERN void checkerboard_layout_set_name (CheckerboardLayout* self,
                                   const gchar* name);
static void checkerboard_layout_viewport_resized (CheckerboardLayout* self);
static void checkerboard_layout_clear_anchor (CheckerboardLayout* self);
static void checkerboard_layout_update_visible_page (CheckerboardLayout* self);
static void checkerboard_layout_need_exposure (CheckerboardLayout* self,
                                        const gchar* caller);
static void checkerboard_layout_update_anchor (CheckerboardLayout* self);
VALA_EXTERN GeeList* checkerboard_layout_intersection (CheckerboardLayout* self,
                                           GdkRectangle* area);
VALA_EXTERN gboolean data_view_is_selected (DataView* self);
static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self,
                                           gdouble upper);
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN void checkerboard_layout_set_cursor (CheckerboardLayout* self,
                                     CheckerboardItem* item);
VALA_EXTERN void checkerboard_item_set_is_cursor (CheckerboardItem* self,
                                      gboolean is_cursor);
VALA_EXTERN gboolean data_collection_contains (DataCollection* self,
                                   DataObject* object);
VALA_EXTERN CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self);
static void checkerboard_layout_need_reflow (CheckerboardLayout* self,
                                      const gchar* caller);
static void checkerboard_layout_items_dirty (CheckerboardLayout* self,
                                      const gchar* reason,
                                      GeeIterable* items);
static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self);
static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self);
static void checkerboard_layout_reflow (CheckerboardLayout* self,
                                 const gchar* caller);
VALA_EXTERN void get_adjustment_page (GtkAdjustment* hadj,
                          GtkAdjustment* vadj,
                          GdkRectangle* result);
VALA_EXTERN void checkerboard_layout_set_in_view (CheckerboardLayout* self,
                                      gboolean in_view);
static void checkerboard_layout_unexpose_items (CheckerboardLayout* self,
                                         const gchar* caller);
VALA_EXTERN CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self,
                                                         gdouble xd,
                                                         gdouble yd);
VALA_EXTERN gint checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list,
                                               gint pos);
static gint checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self,
                                                          CheckerboardItem* item,
                                                          gint x,
                                                          gint y);
VALA_EXTERN PangoLayout* checkerboard_item_get_tag_list_layout (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_translate_coordinates (CheckerboardItem* self,
                                              gint* x,
                                              gint* y);
VALA_EXTERN void checkerboard_item_get_subtitle_allocation (CheckerboardItem* self,
                                                GdkRectangle* result);
VALA_EXTERN gboolean checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self,
                                                  CheckerboardItem* item,
                                                  gint x,
                                                  gint y,
                                                  GdkModifierType mask);
VALA_EXTERN void checkerboard_item_handle_mouse_motion (CheckerboardItem* self,
                                            gint x,
                                            gint y,
                                            gint height,
                                            gint width);
VALA_EXTERN gboolean checkerboard_item_get_has_tags (CheckerboardItem* self);
VALA_EXTERN gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self);
VALA_EXTERN void checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self,
                                                   gint index);
VALA_EXTERN gboolean checkerboard_layout_handle_left_click (CheckerboardLayout* self,
                                                CheckerboardItem* item,
                                                gdouble xd,
                                                gdouble yd,
                                                GdkModifierType mask);
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN Tag* checkerboard_item_get_user_visible_tag (CheckerboardItem* self,
                                             gint index);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN GType library_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryWindow, g_object_unref)
VALA_EXTERN LibraryWindow* library_window_get_app (void);
VALA_EXTERN void library_window_switch_to_tag (LibraryWindow* self,
                                   Tag* tag);
VALA_EXTERN GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self);
VALA_EXTERN GType compass_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self,
                                                            CheckerboardItem* item,
                                                            CompassPoint point);
VALA_EXTERN gint data_collection_get_count (DataCollection* self);
VALA_EXTERN gint checkerboard_item_get_column (CheckerboardItem* self);
VALA_EXTERN gint checkerboard_item_get_row (CheckerboardItem* self);
VALA_EXTERN gchar* checkerboard_item_get_title (CheckerboardItem* self);
VALA_EXTERN CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self,
                                                              gint col,
                                                              gint row);
VALA_EXTERN DataView* view_collection_get_last (ViewCollection* self);
VALA_EXTERN void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self,
                                                 gint x,
                                                 gint y);
VALA_EXTERN void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self,
                                                   gint x,
                                                   gint y);
VALA_EXTERN GType box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Box* box_dup (const Box* self);
VALA_EXTERN void box_free (Box* self);
VALA_EXTERN void box_from_points (GdkPoint* corner1,
                      GdkPoint* corner2,
                      Box* result);
VALA_EXTERN void box_get_rectangle (Box *self,
                        GdkRectangle* result);
VALA_EXTERN GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self);
VALA_EXTERN void dimensions_for_rectangle (GdkRectangle* rect,
                               Dimensions* result);
VALA_EXTERN gboolean dimensions_has_area (Dimensions *self);
static void checkerboard_layout_expose_items (CheckerboardLayout* self,
                                       const gchar* caller);
VALA_EXTERN void data_collection_freeze_notifications (DataCollection* self);
VALA_EXTERN void checkerboard_item_exposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_unexposed (CheckerboardItem* self);
VALA_EXTERN void data_collection_thaw_notifications (DataCollection* self);
VALA_EXTERN gboolean data_view_is_visible (DataView* self);
VALA_EXTERN gint checkerboard_item_get_max_width (gint scale);
VALA_EXTERN DataObject* data_collection_get_at (DataCollection* self,
                                    gint index);
VALA_EXTERN gint checkerboard_item_get_alignment_point (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_grid_coordinates (CheckerboardItem* self,
                                             gint col,
                                             gint row);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y,
                                                                 gint height,
                                                                 gint num_in_row);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type,
                                                                       gint y,
                                                                       gint height,
                                                                       gint num_in_row);
static void checkerboard_layout_real_map (GtkWidget* base);
static void checkerboard_layout_set_colors (CheckerboardLayout* self,
                                     gboolean in_focus);
static void checkerboard_layout_real_size_allocate (GtkWidget* base,
                                             GtkAllocation* allocation);
static gboolean checkerboard_layout_real_draw (GtkWidget* base,
                                        cairo_t* ctx);
VALA_EXTERN void checkerboard_item_paint (CheckerboardItem* self,
                              GtkStyleContext* style_context,
                              cairo_t* ctx,
                              GdkRGBA* bg_color,
                              GdkRGBA* selected_color,
                              GdkRGBA* border_color,
                              GdkRGBA* focus_color);
static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self,
                                              cairo_t* ctx);
static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base,
                                                 gint x,
                                                 gint y,
                                                 gboolean keyboard_mode,
                                                 GtkTooltip* tooltip);
VALA_EXTERN gboolean checkerboard_item_query_tooltip (CheckerboardItem* self,
                                          gint x,
                                          gint y,
                                          GtkTooltip* tooltip);
VALA_EXTERN void invalidate_transparent_background (void);
static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base,
                                                  GdkEventFocus* event);
VALA_EXTERN GeeList* view_collection_get_selected (ViewCollection* self);
static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base,
                                                   GdkEventFocus* event);
static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj);
static GType checkerboard_layout_layout_row_get_type_once (void);
static void checkerboard_layout_finalize (GObject * obj);
static GType checkerboard_layout_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
checkerboard_layout_get_instance_private (CheckerboardLayout* self)
{
	return G_STRUCT_MEMBER_P (self, CheckerboardLayout_private_offset);
}

static void
_checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                           GeeIterable* added,
                                                                           GeeIterable* removed,
                                                                           gpointer self)
{
	checkerboard_layout_on_contents_altered ((CheckerboardLayout*) self, added, removed);
}

static void
_checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self)
{
	checkerboard_layout_on_items_altered ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                                 GeeIterable* changed,
                                                                                 gpointer self)
{
	checkerboard_layout_on_items_state_changed ((CheckerboardLayout*) self, changed);
}

static void
_checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                           GeeCollection* changed,
                                                                                           gpointer self)
{
	checkerboard_layout_on_items_visibility_changed ((CheckerboardLayout*) self, changed);
}

static void
_checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender,
                                                                           gpointer self)
{
	checkerboard_layout_on_ordering_changed ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender,
                                                                     GeeCollection* views,
                                                                     gpointer self)
{
	checkerboard_layout_on_views_altered ((CheckerboardLayout*) self, views);
}

static void
_checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender,
                                                                               GeeCollection* views,
                                                                               gpointer self)
{
	checkerboard_layout_on_geometries_altered ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender,
                                                                                GeeIterable* selected,
                                                                                gpointer self)
{
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender,
                                                                                  GeeIterable* unselected,
                                                                                  gpointer self)
{
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                       gpointer self)
{
	checkerboard_layout_on_viewport_shifted ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                   GtkAllocation* allocation,
                                                                   gpointer self)
{
	checkerboard_layout_on_viewport_resized ((CheckerboardLayout*) self);
}

static void
_checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender,
                                                                     gpointer self)
{
	checkerboard_layout_on_colors_changed ((CheckerboardLayout*) self);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

CheckerboardLayout*
checkerboard_layout_construct (GType object_type,
                               ViewCollection* view)
{
	CheckerboardLayout * self = NULL;
	GtkStyleContext* _tmp0_;
	ViewCollection* _tmp1_;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (view), NULL);
	self = (CheckerboardLayout*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "content-view");
	_tmp1_ = _data_collection_ref0 (view);
	_data_collection_unref0 (self->priv->view);
	self->priv->view = _tmp1_;
	checkerboard_layout_clear_drag_select (self);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self, 0);
	g_signal_connect_object (view, "items-state-changed", (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self, 0);
	g_signal_connect_object (view, "items-visibility-changed", (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_COLLECTION, DataCollection), "ordering-changed", (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self, 0);
	g_signal_connect_object (view, "views-altered", (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self, 0);
	g_signal_connect_object (view, "geometries-altered", (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self, 0);
	g_signal_connect_object (view, "items-selected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self, 0);
	g_signal_connect_object (view, "items-unselected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self, 0);
	_tmp2_ = config_facade_get_instance ();
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "colors-changed", (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self, 0);
	_g_object_unref0 (_tmp3_);
	gtk_widget_set_has_tooltip (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	return self;
}

CheckerboardLayout*
checkerboard_layout_new (ViewCollection* view)
{
	return checkerboard_layout_construct (TYPE_CHECKERBOARD_LAYOUT, view);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
checkerboard_layout_set_adjustments (CheckerboardLayout* self,
                                     GtkAdjustment* hadjustment,
                                     GtkAdjustment* vadjustment)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (hadjustment, gtk_adjustment_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (vadjustment, gtk_adjustment_get_type ()));
	_tmp0_ = _g_object_ref0 (hadjustment);
	_g_object_unref0 (self->priv->hadjustment);
	self->priv->hadjustment = _tmp0_;
	_tmp1_ = _g_object_ref0 (vadjustment);
	_g_object_unref0 (self->priv->vadjustment);
	self->priv->vadjustment = _tmp1_;
	g_signal_connect_object (hadjustment, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
	g_signal_connect_object (vadjustment, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
	_tmp2_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = _tmp2_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self, 0);
}

void
checkerboard_layout_set_scale (CheckerboardLayout* self,
                               gint scale)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	self->priv->scale = scale;
}

gint
checkerboard_layout_get_scale (CheckerboardLayout* self)
{
	gint result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
	result = self->priv->scale;
	return result;
}

void
checkerboard_layout_set_name (CheckerboardLayout* self,
                              const gchar* name)
{
	gchar* _tmp0_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->page_name);
	self->priv->page_name = _tmp0_;
}

static void
checkerboard_layout_on_viewport_resized (CheckerboardLayout* self)
{
	GtkRequisition req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkAllocation parent_allocation = {0};
	GtkContainer* _tmp1_;
	GtkContainer* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	GtkRequisition _tmp4_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL, &_tmp0_);
	req = _tmp0_;
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), &_tmp3_);
	parent_allocation = _tmp3_;
	_tmp4_ = req;
	if (_tmp4_.height != 0) {
		GtkAllocation _tmp5_;
		GtkRequisition _tmp6_;
		_tmp5_ = parent_allocation;
		_tmp6_ = req;
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp5_.width - CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH, _tmp6_.height);
	}
	checkerboard_layout_viewport_resized (self);
	if (!self->priv->size_allocate_due_to_reflow) {
		checkerboard_layout_clear_anchor (self);
	} else {
		self->priv->size_allocate_due_to_reflow = FALSE;
	}
}

static void
checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	checkerboard_layout_update_visible_page (self);
	checkerboard_layout_need_exposure (self, "on_viewport_shift");
	checkerboard_layout_clear_anchor (self);
}

static void
checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	checkerboard_layout_clear_anchor (self);
}

static void
checkerboard_layout_clear_anchor (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	if (self->priv->in_center_on_anchor) {
		return;
	}
	_g_object_unref0 (self->priv->anchor);
	self->priv->anchor = NULL;
}

static void
checkerboard_layout_update_anchor (CheckerboardLayout* self)
{
	GeeList* items_on_page = NULL;
	GdkRectangle _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkAdjustment* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	_vala_assert (!self->priv->in_center_on_anchor, "!in_center_on_anchor");
	_tmp0_ = self->priv->visible_page;
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
	items_on_page = _tmp1_;
	_tmp2_ = items_on_page;
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_g_object_unref0 (self->priv->anchor);
		self->priv->anchor = NULL;
		_g_object_unref0 (items_on_page);
		return;
	}
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp5_;
		gint _item_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = items_on_page;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			CheckerboardItem* _tmp13_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_list_get (_tmp11_, _item_index);
			item = (CheckerboardItem*) _tmp12_;
			_tmp13_ = item;
			if (data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_VIEW, DataView))) {
				CheckerboardItem* _tmp14_;
				CheckerboardItem* _tmp15_;
				_tmp14_ = item;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_g_object_unref0 (self->priv->anchor);
				self->priv->anchor = _tmp15_;
				_g_object_unref0 (item);
				_g_object_unref0 (items_on_page);
				return;
			}
			_g_object_unref0 (item);
		}
	}
	_tmp16_ = self->priv->vadjustment;
	if (gtk_adjustment_get_value (_tmp16_) == ((gdouble) 0)) {
		_g_object_unref0 (self->priv->anchor);
		self->priv->anchor = NULL;
		_g_object_unref0 (items_on_page);
		return;
	}
	_tmp17_ = items_on_page;
	_tmp18_ = items_on_page;
	_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_list_get (_tmp17_, ((gint) _tmp20_) / 2);
	_g_object_unref0 (self->priv->anchor);
	self->priv->anchor = (CheckerboardItem*) _tmp21_;
	_g_object_unref0 (items_on_page);
}

static void
checkerboard_layout_center_on_anchor (CheckerboardLayout* self,
                                      gdouble upper)
{
	CheckerboardItem* _tmp0_;
	gdouble anchor_pos = 0.0;
	CheckerboardItem* _tmp1_;
	GdkRectangle _tmp2_;
	CheckerboardItem* _tmp3_;
	GdkRectangle _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	_tmp0_ = self->priv->anchor;
	if (_tmp0_ == NULL) {
		return;
	}
	self->priv->in_center_on_anchor = TRUE;
	_tmp1_ = self->priv->anchor;
	_tmp2_ = _tmp1_->allocation;
	_tmp3_ = self->priv->anchor;
	_tmp4_ = _tmp3_->allocation;
	_tmp5_ = self->priv->vadjustment;
	anchor_pos = (_tmp2_.y + (_tmp4_.height / 2)) - (gtk_adjustment_get_page_size (_tmp5_) / 2);
	_tmp6_ = self->priv->vadjustment;
	_tmp7_ = self->priv->vadjustment;
	_tmp8_ = self->priv->vadjustment;
	_tmp9_ = self->priv->vadjustment;
	gtk_adjustment_set_value (_tmp6_, CLAMP (anchor_pos, gtk_adjustment_get_lower (_tmp7_), gtk_adjustment_get_upper (_tmp8_) - gtk_adjustment_get_page_size (_tmp9_)));
	self->priv->in_center_on_anchor = FALSE;
}

void
checkerboard_layout_set_cursor (CheckerboardLayout* self,
                                CheckerboardItem* item)
{
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp0_;
	CheckerboardItem* _tmp1_;
	CheckerboardItem* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (IS_CHECKERBOARD_ITEM (item));
	_tmp0_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	collection = _tmp0_;
	_tmp1_ = self->priv->cursor;
	if (_tmp1_ != NULL) {
		CheckerboardItem* _tmp2_;
		ViewCollection* _tmp3_;
		CheckerboardItem* _tmp4_;
		_tmp2_ = self->priv->cursor;
		checkerboard_item_set_is_cursor (_tmp2_, FALSE);
		_tmp3_ = self->priv->view;
		_tmp4_ = self->priv->cursor;
		if (data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject))) {
			GeeHashSet* _tmp5_;
			CheckerboardItem* _tmp6_;
			_tmp5_ = collection;
			_tmp6_ = self->priv->cursor;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView));
		}
	}
	checkerboard_item_set_is_cursor (item, TRUE);
	_tmp7_ = _g_object_ref0 (item);
	_g_object_unref0 (self->priv->cursor);
	self->priv->cursor = _tmp7_;
	_tmp8_ = collection;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (item, TYPE_DATA_VIEW, DataView));
	_tmp9_ = collection;
	checkerboard_layout_on_items_state_changed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
	_g_object_unref0 (collection);
}

CheckerboardItem*
checkerboard_layout_get_cursor (CheckerboardLayout* self)
{
	CheckerboardItem* _tmp0_;
	CheckerboardItem* _tmp1_;
	CheckerboardItem* result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
	_tmp0_ = self->priv->cursor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
checkerboard_layout_on_contents_altered (CheckerboardLayout* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (removed);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				GeeHashSet* _tmp4_;
				DataObject* _tmp5_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = self->priv->exposed_items;
				_tmp5_ = object;
				gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	self->priv->item_rows = NULL;
	self->priv->item_rows_length1 = 0;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	checkerboard_layout_need_reflow (self, "on_contents_altered");
}

static void
checkerboard_layout_on_items_altered (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	checkerboard_layout_need_reflow (self, "on_items_altered");
}

static void
checkerboard_layout_on_items_state_changed (CheckerboardLayout* self,
                                            GeeIterable* changed)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changed, GEE_TYPE_ITERABLE));
	checkerboard_layout_items_dirty (self, "on_items_state_changed", changed);
}

static void
checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self,
                                                 GeeIterable* changed)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changed, GEE_TYPE_ITERABLE));
	checkerboard_layout_need_reflow (self, "on_items_visibility_changed");
}

static void
checkerboard_layout_on_ordering_changed (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	checkerboard_layout_need_reflow (self, "on_ordering_changed");
}

static void
checkerboard_layout_on_views_altered (CheckerboardLayout* self,
                                      GeeCollection* altered)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (altered, GEE_TYPE_COLLECTION));
	checkerboard_layout_items_dirty (self, "on_views_altered", G_TYPE_CHECK_INSTANCE_CAST (altered, GEE_TYPE_ITERABLE, GeeIterable));
}

static void
checkerboard_layout_on_geometries_altered (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	checkerboard_layout_need_reflow (self, "on_geometries_altered");
}

static gboolean
_checkerboard_layout_do_reflow_gsource_func (gpointer self)
{
	gboolean result;
	result = checkerboard_layout_do_reflow ((CheckerboardLayout*) self);
	return result;
}

static void
checkerboard_layout_need_reflow (CheckerboardLayout* self,
                                 const gchar* caller)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (caller != NULL);
	if (self->priv->flow_scheduled) {
		return;
	}
	if (!self->priv->is_in_view) {
		self->priv->reflow_needed = TRUE;
		return;
	}
	self->priv->flow_scheduled = TRUE;
	g_idle_add_full (G_PRIORITY_HIGH, _checkerboard_layout_do_reflow_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
checkerboard_layout_do_reflow (CheckerboardLayout* self)
{
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
	checkerboard_layout_reflow (self, "do_reflow");
	checkerboard_layout_need_exposure (self, "do_reflow");
	self->priv->flow_scheduled = FALSE;
	result = FALSE;
	return result;
}

static void
checkerboard_layout_need_exposure (CheckerboardLayout* self,
                                   const gchar* caller)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (caller != NULL);
	self->priv->exposure_dirty = TRUE;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
checkerboard_layout_update_visible_page (CheckerboardLayout* self)
{
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	_tmp1_ = self->priv->hadjustment;
	if (_tmp1_ != NULL) {
		GtkAdjustment* _tmp2_;
		_tmp2_ = self->priv->vadjustment;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		GdkRectangle _tmp5_ = {0};
		_tmp3_ = self->priv->hadjustment;
		_tmp4_ = self->priv->vadjustment;
		get_adjustment_page (_tmp3_, _tmp4_, &_tmp5_);
		self->priv->visible_page = _tmp5_;
	}
}

void
checkerboard_layout_set_in_view (CheckerboardLayout* self,
                                 gboolean in_view)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	self->priv->is_in_view = in_view;
	if (in_view) {
		if (self->priv->reflow_needed) {
			checkerboard_layout_need_reflow (self, "set_in_view (true)");
		} else {
			checkerboard_layout_need_exposure (self, "set_in_view (true)");
		}
	} else {
		checkerboard_layout_unexpose_items (self, "set_in_view (false)");
	}
}

static gpointer
_checkerboard_layout_layout_row_ref0 (gpointer self)
{
	return self ? checkerboard_layout_layout_row_ref (self) : NULL;
}

CheckerboardItem*
checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self,
                                       gdouble xd,
                                       gdouble yd)
{
	CheckerboardLayoutLayoutRow** _tmp0_;
	gint _tmp0__length1;
	gint x = 0;
	gint y = 0;
	CheckerboardLayoutLayoutRow* in_range = NULL;
	gint min = 0;
	gint max = 0;
	CheckerboardLayoutLayoutRow** _tmp1_;
	gint _tmp1__length1;
	CheckerboardLayoutLayoutRow* _tmp13_;
	CheckerboardLayoutLayoutRow* _tmp14_;
	CheckerboardItem** _tmp15_;
	gint _tmp15__length1;
	CheckerboardItem* result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
	_tmp0_ = self->priv->item_rows;
	_tmp0__length1 = self->priv->item_rows_length1;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	x = (gint) xd;
	y = (gint) yd;
	in_range = NULL;
	min = 0;
	_tmp1_ = self->priv->item_rows;
	_tmp1__length1 = self->priv->item_rows_length1;
	max = _tmp1__length1;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint mid = 0;
			CheckerboardLayoutLayoutRow* row = NULL;
			CheckerboardLayoutLayoutRow** _tmp3_;
			gint _tmp3__length1;
			CheckerboardLayoutLayoutRow* _tmp4_;
			CheckerboardLayoutLayoutRow* _tmp5_;
			gboolean _tmp6_ = FALSE;
			CheckerboardLayoutLayoutRow* _tmp7_;
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			mid = min + ((max - min) / 2);
			_tmp3_ = self->priv->item_rows;
			_tmp3__length1 = self->priv->item_rows_length1;
			_tmp4_ = _tmp3_[mid];
			_tmp5_ = _checkerboard_layout_layout_row_ref0 (_tmp4_);
			row = _tmp5_;
			_tmp7_ = row;
			if (_tmp7_ == NULL) {
				_tmp6_ = TRUE;
			} else {
				CheckerboardLayoutLayoutRow* _tmp8_;
				_tmp8_ = row;
				_tmp6_ = y < _tmp8_->y;
			}
			if (_tmp6_) {
				max = mid - 1;
			} else {
				CheckerboardLayoutLayoutRow* _tmp9_;
				CheckerboardLayoutLayoutRow* _tmp10_;
				_tmp9_ = row;
				_tmp10_ = row;
				if (y > (_tmp9_->y + _tmp10_->height)) {
					min = mid + 1;
				} else {
					CheckerboardLayoutLayoutRow* _tmp11_;
					CheckerboardLayoutLayoutRow* _tmp12_;
					_tmp11_ = row;
					_tmp12_ = _checkerboard_layout_layout_row_ref0 (_tmp11_);
					_checkerboard_layout_layout_row_unref0 (in_range);
					in_range = _tmp12_;
					_checkerboard_layout_layout_row_unref0 (row);
					break;
				}
			}
			if (min > max) {
				_checkerboard_layout_layout_row_unref0 (row);
				break;
			}
			_checkerboard_layout_layout_row_unref0 (row);
		}
	}
	_tmp13_ = in_range;
	if (_tmp13_ == NULL) {
		result = NULL;
		_checkerboard_layout_layout_row_unref0 (in_range);
		return result;
	}
	_tmp14_ = in_range;
	_tmp15_ = _tmp14_->items;
	_tmp15__length1 = _tmp14_->items_length1;
	{
		CheckerboardItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp15_;
		item_collection_length1 = _tmp15__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			CheckerboardItem* _tmp16_;
			CheckerboardItem* item = NULL;
			_tmp16_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp16_;
			{
				CheckerboardItem* _tmp17_;
				CheckerboardItem* _tmp18_;
				GdkRectangle _tmp19_;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				CheckerboardItem* _tmp22_;
				GdkRectangle _tmp23_;
				CheckerboardItem* _tmp24_;
				GdkRectangle _tmp25_;
				_tmp17_ = item;
				if (_tmp17_ == NULL) {
					_g_object_unref0 (item);
					continue;
				}
				_tmp18_ = item;
				_tmp19_ = _tmp18_->allocation;
				if (x < _tmp19_.x) {
					_g_object_unref0 (item);
					break;
				}
				_tmp22_ = item;
				_tmp23_ = _tmp22_->allocation;
				_tmp24_ = item;
				_tmp25_ = _tmp24_->allocation;
				if (x <= (_tmp23_.x + _tmp25_.width)) {
					CheckerboardItem* _tmp26_;
					GdkRectangle _tmp27_;
					_tmp26_ = item;
					_tmp27_ = _tmp26_->allocation;
					_tmp21_ = y >= _tmp27_.y;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					CheckerboardItem* _tmp28_;
					GdkRectangle _tmp29_;
					CheckerboardItem* _tmp30_;
					GdkRectangle _tmp31_;
					_tmp28_ = item;
					_tmp29_ = _tmp28_->allocation;
					_tmp30_ = item;
					_tmp31_ = _tmp30_->allocation;
					_tmp20_ = y <= (_tmp29_.y + _tmp31_.height);
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					result = item;
					_checkerboard_layout_layout_row_unref0 (in_range);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	_checkerboard_layout_layout_row_unref0 (in_range);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gint
checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list,
                                          gint pos)
{
	gint sep_len = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint len = 0;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	gint index = 0;
	gint result;
	g_return_val_if_fail (tag_list != NULL, 0);
	_tmp0_ = strlen (TAG_TAG_LIST_SEPARATOR_STRING);
	_tmp1_ = _tmp0_;
	sep_len = _tmp1_;
	_vala_assert (sep_len > 0, "sep_len > 0");
	_tmp2_ = strlen (tag_list);
	_tmp3_ = _tmp2_;
	len = _tmp3_;
	if (pos < 0) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = pos >= len;
	}
	if (_tmp4_) {
		result = -1;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				if (!_tmp5_) {
					gint _tmp6_;
					i = i + 1;
					_tmp6_ = i;
				}
				_tmp5_ = FALSE;
				if (!(i < sep_len)) {
					break;
				}
				if (string_get (tag_list, (glong) pos) == string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) i)) {
					_tmp7_ = pos >= i;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar* _tmp8_;
					gchar* _tmp9_;
					gboolean _tmp10_;
					_tmp8_ = string_substring (tag_list, (glong) (pos - i), (glong) sep_len);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strcmp0 (_tmp9_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
					_g_free0 (_tmp9_);
					if (_tmp10_) {
						result = -1;
						return result;
					}
				}
			}
		}
	}
	index = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				if (!_tmp11_) {
					gint _tmp12_;
					i = i + 1;
					_tmp12_ = i;
				}
				_tmp11_ = FALSE;
				if (!(i < pos)) {
					break;
				}
				if (string_get (tag_list, (glong) i) == string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) 0)) {
					_tmp14_ = (i + sep_len) <= len;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp15_ = string_substring (tag_list, (glong) i, (glong) sep_len);
					_tmp16_ = _tmp15_;
					_tmp13_ = g_strcmp0 (_tmp16_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
					_g_free0 (_tmp16_);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gint _tmp17_;
					index = index + 1;
					_tmp17_ = index;
					i += sep_len - 1;
				}
			}
		}
	}
	result = index;
	return result;
}

static gint
checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self,
                                                     CheckerboardItem* item,
                                                     gint x,
                                                     gint y)
{
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoLayout* _tmp1_;
	GdkRectangle rect = {0};
	GdkRectangle _tmp2_ = {0};
	gint index = 0;
	gint trailing = 0;
	gint px = 0;
	GdkRectangle _tmp3_;
	gint py = 0;
	GdkRectangle _tmp4_;
	PangoLayout* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_;
	gint result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), 0);
	_tmp0_ = checkerboard_item_get_tag_list_layout (item);
	layout = _tmp0_;
	_tmp1_ = layout;
	if (_tmp1_ == NULL) {
		result = -1;
		_g_object_unref0 (layout);
		return result;
	}
	checkerboard_item_translate_coordinates (item, &x, &y);
	checkerboard_item_get_subtitle_allocation (item, &_tmp2_);
	rect = _tmp2_;
	_tmp3_ = rect;
	px = (x - _tmp3_.x) * PANGO_SCALE;
	_tmp4_ = rect;
	py = (y - _tmp4_.y) * PANGO_SCALE;
	_tmp5_ = layout;
	_tmp8_ = pango_layout_xy_to_index (_tmp5_, px, py, &_tmp6_, &_tmp7_);
	index = _tmp6_;
	trailing = _tmp7_;
	if (_tmp8_) {
		PangoLayout* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = layout;
		_tmp10_ = pango_layout_get_text (_tmp9_);
		result = checkerboard_layout_get_tag_index_at_pos (_tmp10_, index);
		_g_object_unref0 (layout);
		return result;
	}
	result = -1;
	_g_object_unref0 (layout);
	return result;
}

gboolean
checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self,
                                         CheckerboardItem* item,
                                         gint x,
                                         gint y,
                                         GdkModifierType mask)
{
	gint dx = 0;
	GdkRectangle _tmp0_;
	gint dy = 0;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint tag_index = 0;
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
	_tmp0_ = item->allocation;
	dx = x - _tmp0_.x;
	_tmp1_ = item->allocation;
	dy = y - _tmp1_.y;
	_tmp2_ = item->allocation;
	_tmp3_ = item->allocation;
	checkerboard_item_handle_mouse_motion (item, dx, dy, _tmp2_.height, _tmp3_.width);
	_tmp5_ = checkerboard_item_get_has_tags (item);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = checkerboard_layout_is_drag_select_active (self);
	}
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	tag_index = checkerboard_layout_internal_handle_tag_mouse_event (self, item, x, y);
	checkerboard_item_highlight_user_visible_tag (item, tag_index);
	result = tag_index >= 0;
	return result;
}

gboolean
checkerboard_layout_handle_left_click (CheckerboardLayout* self,
                                       CheckerboardItem* item,
                                       gdouble xd,
                                       gdouble yd,
                                       GdkModifierType mask)
{
	gint tag_index = 0;
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
	tag_index = checkerboard_layout_internal_handle_tag_mouse_event (self, item, (gint) round (xd), (gint) round (yd));
	if (tag_index >= 0) {
		Tag* tag = NULL;
		Tag* _tmp0_;
		LibraryWindow* _tmp1_;
		LibraryWindow* _tmp2_;
		Tag* _tmp3_;
		_tmp0_ = checkerboard_item_get_user_visible_tag (item, tag_index);
		tag = _tmp0_;
		_tmp1_ = library_window_get_app ();
		_tmp2_ = _tmp1_;
		_tmp3_ = tag;
		library_window_switch_to_tag (_tmp2_, _tmp3_);
		_g_object_unref0 (_tmp2_);
		result = TRUE;
		_g_object_unref0 (tag);
		return result;
	}
	result = FALSE;
	return result;
}

GeeList*
checkerboard_layout_get_visible_items (CheckerboardLayout* self)
{
	GdkRectangle _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
	_tmp0_ = self->priv->visible_page;
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
	result = _tmp1_;
	return result;
}

GeeList*
checkerboard_layout_intersection (CheckerboardLayout* self,
                                  GdkRectangle* area)
{
	GeeArrayList* intersects = NULL;
	GeeArrayList* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRectangle bitbucket = {0};
	CheckerboardLayoutLayoutRow** _tmp2_;
	gint _tmp2__length1;
	GeeList* result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
	g_return_val_if_fail (area != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	intersects = _tmp0_;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
	allocation = _tmp1_;
	memset (&bitbucket, 0, sizeof (GdkRectangle));
	_tmp2_ = self->priv->item_rows;
	_tmp2__length1 = self->priv->item_rows_length1;
	{
		CheckerboardLayoutLayoutRow** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
		row_collection = _tmp2_;
		row_collection_length1 = _tmp2__length1;
		for (row_it = 0; row_it < row_collection_length1; row_it = row_it + 1) {
			CheckerboardLayoutLayoutRow* _tmp3_;
			CheckerboardLayoutLayoutRow* row = NULL;
			_tmp3_ = _checkerboard_layout_layout_row_ref0 (row_collection[row_it]);
			row = _tmp3_;
			{
				CheckerboardLayoutLayoutRow* _tmp4_;
				GdkRectangle _tmp5_;
				GdkRectangle _tmp6_;
				CheckerboardLayoutLayoutRow* _tmp7_;
				CheckerboardLayoutLayoutRow* _tmp8_;
				CheckerboardLayoutLayoutRow* _tmp9_;
				GdkRectangle _tmp10_;
				GdkRectangle row_rect = {0};
				CheckerboardLayoutLayoutRow* _tmp11_;
				GtkAllocation _tmp12_;
				CheckerboardLayoutLayoutRow* _tmp13_;
				GdkRectangle _tmp14_;
				GdkRectangle _tmp15_ = {0};
				gboolean _tmp16_;
				_tmp4_ = row;
				if (_tmp4_ == NULL) {
					_checkerboard_layout_layout_row_unref0 (row);
					continue;
				}
				_tmp5_ = *area;
				_tmp6_ = *area;
				_tmp7_ = row;
				if ((_tmp5_.y + _tmp6_.height) < _tmp7_->y) {
					_checkerboard_layout_layout_row_unref0 (row);
					break;
				}
				_tmp8_ = row;
				_tmp9_ = row;
				_tmp10_ = *area;
				if ((_tmp8_->y + _tmp9_->height) < _tmp10_.y) {
					_checkerboard_layout_layout_row_unref0 (row);
					continue;
				}
				memset (&row_rect, 0, sizeof (GdkRectangle));
				row_rect.x = 0;
				_tmp11_ = row;
				row_rect.y = _tmp11_->y;
				_tmp12_ = allocation;
				row_rect.width = _tmp12_.width;
				_tmp13_ = row;
				row_rect.height = _tmp13_->height;
				_tmp14_ = row_rect;
				_tmp16_ = gdk_rectangle_intersect (area, &_tmp14_, &_tmp15_);
				bitbucket = _tmp15_;
				if (_tmp16_) {
					CheckerboardLayoutLayoutRow* _tmp17_;
					CheckerboardItem** _tmp18_;
					gint _tmp18__length1;
					_tmp17_ = row;
					_tmp18_ = _tmp17_->items;
					_tmp18__length1 = _tmp17_->items_length1;
					{
						CheckerboardItem** item_collection = NULL;
						gint item_collection_length1 = 0;
						gint _item_collection_size_ = 0;
						gint item_it = 0;
						item_collection = _tmp18_;
						item_collection_length1 = _tmp18__length1;
						for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
							CheckerboardItem* _tmp19_;
							CheckerboardItem* item = NULL;
							_tmp19_ = _g_object_ref0 (item_collection[item_it]);
							item = _tmp19_;
							{
								CheckerboardItem* _tmp20_;
								CheckerboardItem* _tmp21_;
								GdkRectangle _tmp22_;
								GdkRectangle _tmp23_ = {0};
								gboolean _tmp24_;
								_tmp20_ = item;
								if (_tmp20_ == NULL) {
									_g_object_unref0 (item);
									continue;
								}
								_tmp21_ = item;
								_tmp22_ = _tmp21_->allocation;
								_tmp24_ = gdk_rectangle_intersect (area, &_tmp22_, &_tmp23_);
								bitbucket = _tmp23_;
								if (_tmp24_) {
									GeeArrayList* _tmp25_;
									CheckerboardItem* _tmp26_;
									_tmp25_ = intersects;
									_tmp26_ = item;
									gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp26_);
								}
								_g_object_unref0 (item);
							}
						}
					}
				}
				_checkerboard_layout_layout_row_unref0 (row);
			}
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (intersects, GEE_TYPE_LIST, GeeList);
	return result;
}

CheckerboardItem*
checkerboard_layout_get_item_relative_to (CheckerboardLayout* self,
                                          CheckerboardItem* item,
                                          CompassPoint point)
{
	ViewCollection* _tmp0_;
	gint col = 0;
	gint row = 0;
	gboolean _tmp1_ = FALSE;
	CheckerboardItem* new_item = NULL;
	CheckerboardItem* _tmp13_;
	gboolean _tmp14_ = FALSE;
	CheckerboardItem* _tmp15_;
	CheckerboardItem* _tmp19_ = NULL;
	CheckerboardItem* _tmp20_;
	CheckerboardItem* _tmp22_;
	CheckerboardItem* result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), NULL);
	_tmp0_ = self->priv->view;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection)) == 0) {
		result = NULL;
		return result;
	}
	_vala_assert (self->priv->columns > 0, "columns > 0");
	_vala_assert (self->priv->rows > 0, "rows > 0");
	col = checkerboard_item_get_column (item);
	row = checkerboard_item_get_row (item);
	if (col < 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = row < 0;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = checkerboard_item_get_title (item);
		_tmp3_ = _tmp2_;
		g_critical ("CheckerboardLayout.vala:521: Attempting to locate item not placed in l" \
"ayout: %s", _tmp3_);
		_g_free0 (_tmp3_);
		result = NULL;
		return result;
	}
	switch (point) {
		case COMPASS_POINT_NORTH:
		{
			gint _tmp4_;
			row = row - 1;
			_tmp4_ = row;
			if (_tmp4_ < 0) {
				row = 0;
			}
			break;
		}
		case COMPASS_POINT_SOUTH:
		{
			gint _tmp5_;
			gint _tmp6_;
			row = row + 1;
			_tmp5_ = row;
			_tmp6_ = self->priv->rows;
			if (_tmp5_ >= _tmp6_) {
				row = self->priv->rows - 1;
			}
			break;
		}
		case COMPASS_POINT_EAST:
		{
			gint _tmp7_;
			gint _tmp8_;
			col = col + 1;
			_tmp7_ = col;
			_tmp8_ = self->priv->columns;
			if (_tmp7_ >= _tmp8_) {
				gint _tmp9_;
				gint _tmp10_;
				row = row + 1;
				_tmp9_ = row;
				_tmp10_ = self->priv->rows;
				if (_tmp9_ >= _tmp10_) {
					row = self->priv->rows - 1;
					col = self->priv->columns - 1;
				} else {
					col = 0;
				}
			}
			break;
		}
		case COMPASS_POINT_WEST:
		{
			gint _tmp11_;
			col = col - 1;
			_tmp11_ = col;
			if (_tmp11_ < 0) {
				gint _tmp12_;
				row = row - 1;
				_tmp12_ = row;
				if (_tmp12_ < 0) {
					row = 0;
					col = 0;
				} else {
					col = self->priv->columns - 1;
				}
			}
			break;
		}
		default:
		{
			g_error ("CheckerboardLayout.vala:560: Bad compass point %d", (gint) point);
		}
	}
	_tmp13_ = checkerboard_layout_get_item_at_coordinate (self, col, row);
	new_item = _tmp13_;
	_tmp15_ = new_item;
	if (_tmp15_ == NULL) {
		_tmp14_ = point == COMPASS_POINT_SOUTH;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ViewCollection* _tmp16_;
		DataView* _tmp17_;
		CheckerboardItem* _tmp18_;
		_tmp16_ = self->priv->view;
		_tmp17_ = view_collection_get_last (_tmp16_);
		_g_object_unref0 (new_item);
		new_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
		_tmp18_ = new_item;
		if (checkerboard_item_get_row (_tmp18_) <= checkerboard_item_get_row (item)) {
			_g_object_unref0 (new_item);
			new_item = NULL;
		}
	}
	_tmp20_ = new_item;
	if (_tmp20_ != NULL) {
		CheckerboardItem* _tmp21_;
		_tmp21_ = new_item;
		_tmp19_ = _tmp21_;
	} else {
		_tmp19_ = item;
	}
	_tmp22_ = _g_object_ref0 (_tmp19_);
	result = _tmp22_;
	_g_object_unref0 (new_item);
	return result;
}

CheckerboardItem*
checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self,
                                            gint col,
                                            gint row)
{
	CheckerboardLayoutLayoutRow** _tmp0_;
	gint _tmp0__length1;
	CheckerboardLayoutLayoutRow* item_row = NULL;
	CheckerboardLayoutLayoutRow** _tmp1_;
	gint _tmp1__length1;
	CheckerboardLayoutLayoutRow* _tmp2_;
	CheckerboardLayoutLayoutRow* _tmp3_;
	CheckerboardLayoutLayoutRow* _tmp4_;
	CheckerboardLayoutLayoutRow* _tmp5_;
	CheckerboardItem** _tmp6_;
	gint _tmp6__length1;
	CheckerboardLayoutLayoutRow* _tmp7_;
	CheckerboardItem** _tmp8_;
	gint _tmp8__length1;
	CheckerboardItem* _tmp9_;
	CheckerboardItem* _tmp10_;
	CheckerboardItem* result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
	_tmp0_ = self->priv->item_rows;
	_tmp0__length1 = self->priv->item_rows_length1;
	if (row >= _tmp0__length1) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->item_rows;
	_tmp1__length1 = self->priv->item_rows_length1;
	_tmp2_ = _tmp1_[row];
	_tmp3_ = _checkerboard_layout_layout_row_ref0 (_tmp2_);
	item_row = _tmp3_;
	_tmp4_ = item_row;
	if (_tmp4_ == NULL) {
		result = NULL;
		_checkerboard_layout_layout_row_unref0 (item_row);
		return result;
	}
	_tmp5_ = item_row;
	_tmp6_ = _tmp5_->items;
	_tmp6__length1 = _tmp5_->items_length1;
	if (col >= _tmp6__length1) {
		result = NULL;
		_checkerboard_layout_layout_row_unref0 (item_row);
		return result;
	}
	_tmp7_ = item_row;
	_tmp8_ = _tmp7_->items;
	_tmp8__length1 = _tmp7_->items_length1;
	_tmp9_ = _tmp8_[col];
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_checkerboard_layout_layout_row_unref0 (item_row);
	return result;
}

void
checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self,
                                            gint x,
                                            gint y)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	checkerboard_layout_clear_drag_select (self);
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = allocation;
	self->priv->drag_origin.x = CLAMP (x, 0, _tmp1_.width);
	_tmp2_ = allocation;
	self->priv->drag_origin.y = CLAMP (y, 0, _tmp2_.height);
}

void
checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self,
                                              gint x,
                                              gint y)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	GdkRectangle old_selection_band = {0};
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_;
	GdkPoint _tmp5_;
	Box _tmp6_ = {0};
	GdkRectangle _tmp7_ = {0};
	GdkWindow* _tmp8_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = allocation;
	self->priv->drag_endpoint.x = CLAMP (x, 0, _tmp1_.width);
	_tmp2_ = allocation;
	self->priv->drag_endpoint.y = CLAMP (y, 0, _tmp2_.height);
	_tmp3_ = self->priv->selection_band;
	old_selection_band = _tmp3_;
	_tmp4_ = self->priv->drag_origin;
	_tmp5_ = self->priv->drag_endpoint;
	box_from_points (&_tmp4_, &_tmp5_, &_tmp6_);
	box_get_rectangle (&_tmp6_, &_tmp7_);
	self->priv->selection_band = _tmp7_;
	_tmp8_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp8_ != NULL) {
		GdkRectangle _union_ = {0};
		GdkRectangle _tmp9_;
		GdkRectangle _tmp10_ = {0};
		GdkRectangle _tmp11_;
		GdkRectangle _tmp12_;
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_;
		_tmp9_ = old_selection_band;
		gdk_rectangle_union (&self->priv->selection_band, &_tmp9_, &_tmp10_);
		_union_ = _tmp10_;
		_tmp11_ = _union_;
		_tmp12_ = _union_;
		_tmp13_ = _union_;
		_tmp14_ = _union_;
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp11_.x, _tmp12_.y, _tmp13_.width, _tmp14_.height);
	}
}

GeeList*
checkerboard_layout_items_in_selection_band (CheckerboardLayout* self)
{
	GdkRectangle _tmp0_;
	Dimensions _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GeeList* _tmp3_;
	GeeList* result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
	_tmp0_ = self->priv->selection_band;
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
	if (!dimensions_has_area (&_tmp1_)) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->selection_band;
	_tmp3_ = checkerboard_layout_intersection (self, &_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
checkerboard_layout_is_drag_select_active (CheckerboardLayout* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPoint _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
	_tmp1_ = self->priv->drag_origin;
	if (_tmp1_.x >= 0) {
		GdkPoint _tmp2_;
		_tmp2_ = self->priv->drag_origin;
		_tmp0_ = _tmp2_.y >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
checkerboard_layout_clear_drag_select (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
	self->priv->drag_origin.x = -1;
	self->priv->drag_origin.y = -1;
	self->priv->drag_endpoint.x = -1;
	self->priv->drag_endpoint.y = -1;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
checkerboard_layout_viewport_resized (CheckerboardLayout* self)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	checkerboard_layout_update_visible_page (self);
	_tmp0_ = self->priv->visible_page;
	if (_tmp0_.width != self->priv->last_width) {
		gint old_width = 0;
		GdkRectangle _tmp1_;
		GdkRectangle _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		old_width = self->priv->last_width;
		_tmp1_ = self->priv->visible_page;
		self->priv->last_width = _tmp1_.width;
		_tmp2_ = self->priv->visible_page;
		_tmp3_ = g_strdup_printf ("viewport_resized (%d -> %d)", old_width, _tmp2_.width);
		_tmp4_ = _tmp3_;
		checkerboard_layout_need_reflow (self, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("viewport_resized (same width=%d)", self->priv->last_width);
		_tmp6_ = _tmp5_;
		checkerboard_layout_need_exposure (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
}

static void
checkerboard_layout_expose_items (CheckerboardLayout* self,
                                  const gchar* caller)
{
	GeeHashSet* new_exposed_items = NULL;
	GeeHashSet* _tmp0_;
	ViewCollection* _tmp1_;
	GeeList* items = NULL;
	GeeList* _tmp2_;
	GeeHashSet* _tmp22_;
	GeeHashSet* _tmp23_;
	ViewCollection* _tmp24_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (caller != NULL);
	_tmp0_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	new_exposed_items = _tmp0_;
	_tmp1_ = self->priv->view;
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
	_tmp2_ = checkerboard_layout_get_visible_items (self);
	items = _tmp2_;
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp3_;
		gint _item_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _item_index = 0;
		_tmp3_ = items;
		_item_list = _tmp3_;
		_tmp4_ = _item_list;
		_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = _tmp5_;
		_item_size = _tmp6_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			GeeHashSet* _tmp11_;
			CheckerboardItem* _tmp12_;
			GeeHashSet* _tmp13_;
			CheckerboardItem* _tmp14_;
			_item_index = _item_index + 1;
			_tmp7_ = _item_index;
			_tmp8_ = _item_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _item_list;
			_tmp10_ = gee_list_get (_tmp9_, _item_index);
			item = (CheckerboardItem*) _tmp10_;
			_tmp11_ = new_exposed_items;
			_tmp12_ = item;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
			_tmp13_ = self->priv->exposed_items;
			_tmp14_ = item;
			if (!gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_)) {
				CheckerboardItem* _tmp15_;
				_tmp15_ = item;
				checkerboard_item_exposed (_tmp15_);
			}
			_g_object_unref0 (item);
		}
	}
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp16_;
		GeeIterator* _tmp17_;
		_tmp16_ = self->priv->exposed_items;
		_tmp17_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_item_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp19_;
			gpointer _tmp20_;
			CheckerboardItem* _tmp21_;
			_tmp18_ = _item_it;
			if (!gee_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _item_it;
			_tmp20_ = gee_iterator_get (_tmp19_);
			item = (CheckerboardItem*) _tmp20_;
			_tmp21_ = item;
			checkerboard_item_unexposed (_tmp21_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	_tmp22_ = new_exposed_items;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->exposed_items);
	self->priv->exposed_items = _tmp23_;
	self->priv->exposure_dirty = FALSE;
	_tmp24_ = self->priv->view;
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_DATA_COLLECTION, DataCollection));
	_g_object_unref0 (items);
	_g_object_unref0 (new_exposed_items);
}

static void
checkerboard_layout_unexpose_items (CheckerboardLayout* self,
                                    const gchar* caller)
{
	ViewCollection* _tmp0_;
	GeeHashSet* _tmp7_;
	ViewCollection* _tmp8_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (caller != NULL);
	_tmp0_ = self->priv->view;
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->exposed_items;
		_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_item_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			CheckerboardItem* _tmp6_;
			_tmp3_ = _item_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _item_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			item = (CheckerboardItem*) _tmp5_;
			_tmp6_ = item;
			checkerboard_item_unexposed (_tmp6_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	_tmp7_ = self->priv->exposed_items;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	self->priv->exposure_dirty = FALSE;
	_tmp8_ = self->priv->view;
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection));
}

static void
checkerboard_layout_reflow (CheckerboardLayout* self,
                            const gchar* caller)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_;
	gint visible_width = 0;
	gint total_items = 0;
	ViewCollection* _tmp5_;
	gboolean _tmp7_ = FALSE;
	CheckerboardItem* _tmp8_;
	gint max_cols = 0;
	gint max_rows = 0;
	gint row = 0;
	gint tallest = 0;
	gint widest = 0;
	gint row_alignment_point = 0;
	gint total_width = 0;
	gint col = 0;
	gint* column_widths = NULL;
	gint* _tmp22_;
	gint column_widths_length1;
	gint _column_widths_size_;
	gint* row_heights = NULL;
	gint* _tmp23_;
	gint row_heights_length1;
	gint _row_heights_size_;
	gint* alignment_points = NULL;
	gint* _tmp24_;
	gint alignment_points_length1;
	gint _alignment_points_size_;
	gint gutter = 0;
	CheckerboardLayoutLayoutRow** _tmp75_;
	gint x = 0;
	gint y = 0;
	CheckerboardLayoutLayoutRow* current_row = NULL;
	CheckerboardLayoutLayoutRow* _tmp114_;
	gint total_height = 0;
	gint* _tmp118_;
	gint _tmp118__length1;
	gint _tmp119_;
	gboolean _tmp120_ = FALSE;
	GtkAllocation _tmp121_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (caller != NULL);
	self->priv->reflow_needed = FALSE;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
	allocation = _tmp0_;
	_tmp2_ = self->priv->visible_page;
	if (_tmp2_.width > 0) {
		GdkRectangle _tmp3_;
		_tmp3_ = self->priv->visible_page;
		_tmp1_ = _tmp3_.width;
	} else {
		GtkAllocation _tmp4_;
		_tmp4_ = allocation;
		_tmp1_ = _tmp4_.width;
	}
	visible_width = _tmp1_;
	if (visible_width <= 1) {
		return;
	}
	_tmp5_ = self->priv->view;
	total_items = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_COLLECTION, DataCollection));
	if (total_items == 0) {
		CheckerboardLayoutLayoutRow** _tmp6_;
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), visible_width, 0);
		_tmp6_ = g_new0 (CheckerboardLayoutLayoutRow*, 0 + 1);
		self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
		self->priv->item_rows = _tmp6_;
		self->priv->item_rows_length1 = 0;
		self->priv->_item_rows_size_ = self->priv->item_rows_length1;
		return;
	}
	_tmp8_ = self->priv->anchor;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		CheckerboardItem* _tmp9_;
		_tmp9_ = self->priv->anchor;
		_tmp7_ = !data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_VIEW, DataView));
	}
	if (_tmp7_) {
		checkerboard_layout_update_anchor (self);
	}
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	self->priv->item_rows = NULL;
	self->priv->item_rows_length1 = 0;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	max_cols = 0;
	if (self->priv->scale > 0) {
		gint remaining_width = 0;
		gint max_item_width = 0;
		remaining_width = visible_width - (CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING * 2);
		max_item_width = checkerboard_item_get_max_width (self->priv->scale);
		max_cols = remaining_width / max_item_width;
		if (max_cols <= 0) {
			max_cols = 1;
		}
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gint _tmp11_;
			if (max_cols > 1) {
				_tmp10_ = ((max_cols * max_item_width) + ((max_cols - 1) * CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING)) > remaining_width;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = max_cols;
			max_cols = _tmp11_ - 1;
		}
		if (total_items < max_cols) {
			max_cols = total_items;
		}
	} else {
		gint x = 0;
		gint col = 0;
		gint row_width = 0;
		gint widest_row = 0;
		x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
		col = 0;
		row_width = 0;
		widest_row = 0;
		{
			gint ctr = 0;
			ctr = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					CheckerboardItem* item = NULL;
					ViewCollection* _tmp14_;
					DataObject* _tmp15_;
					Dimensions req = {0};
					CheckerboardItem* _tmp16_;
					Dimensions _tmp17_;
					Dimensions _tmp18_;
					Dimensions _tmp19_;
					Dimensions _tmp20_;
					gint _tmp21_;
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = ctr;
						ctr = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					if (!(ctr < total_items)) {
						break;
					}
					_tmp14_ = self->priv->view;
					_tmp15_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_COLLECTION, DataCollection), ctr);
					item = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
					_tmp16_ = item;
					_tmp17_ = _tmp16_->requisition;
					req = _tmp17_;
					_vala_assert (dimensions_has_area (&req), "req.has_area()");
					_tmp18_ = req;
					if (((x + _tmp18_.width) + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) > visible_width) {
						if (row_width > widest_row) {
							widest_row = row_width;
							max_cols = col;
						}
						col = 0;
						x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
						row_width = 0;
					}
					_tmp19_ = req;
					x += _tmp19_.width + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
					_tmp20_ = req;
					row_width += _tmp20_.width;
					_tmp21_ = col;
					col = _tmp21_ + 1;
					_g_object_unref0 (item);
				}
			}
		}
		if (row_width > widest_row) {
			max_cols = col;
		}
	}
	_vala_assert (max_cols > 0, "max_cols > 0");
	max_rows = (total_items / max_cols) + 1;
	row = 0;
	tallest = 0;
	widest = 0;
	row_alignment_point = 0;
	total_width = 0;
	col = 0;
	_tmp22_ = g_new0 (gint, max_cols);
	column_widths = _tmp22_;
	column_widths_length1 = max_cols;
	_column_widths_size_ = column_widths_length1;
	_tmp23_ = g_new0 (gint, max_rows);
	row_heights = _tmp23_;
	row_heights_length1 = max_rows;
	_row_heights_size_ = row_heights_length1;
	_tmp24_ = g_new0 (gint, max_rows);
	alignment_points = _tmp24_;
	alignment_points_length1 = max_rows;
	_alignment_points_size_ = alignment_points_length1;
	gutter = 0;
	{
		gboolean _tmp25_ = FALSE;
		_tmp25_ = TRUE;
		while (TRUE) {
			if (!_tmp25_) {
			}
			_tmp25_ = FALSE;
			{
				gint ctr = 0;
				ctr = 0;
				{
					gboolean _tmp26_ = FALSE;
					_tmp26_ = TRUE;
					while (TRUE) {
						CheckerboardItem* item = NULL;
						ViewCollection* _tmp28_;
						DataObject* _tmp29_;
						Dimensions req = {0};
						CheckerboardItem* _tmp30_;
						Dimensions _tmp31_;
						gint alignment_point = 0;
						CheckerboardItem* _tmp32_;
						Dimensions _tmp33_;
						Dimensions _tmp34_;
						Dimensions _tmp36_;
						gint* _tmp38_;
						gint _tmp38__length1;
						gint _tmp39_;
						Dimensions _tmp40_;
						gint _tmp46_;
						gint _tmp47_;
						if (!_tmp26_) {
							gint _tmp27_;
							_tmp27_ = ctr;
							ctr = _tmp27_ + 1;
						}
						_tmp26_ = FALSE;
						if (!(ctr < total_items)) {
							break;
						}
						_tmp28_ = self->priv->view;
						_tmp29_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_DATA_COLLECTION, DataCollection), ctr);
						item = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
						_tmp30_ = item;
						_tmp31_ = _tmp30_->requisition;
						req = _tmp31_;
						_tmp32_ = item;
						alignment_point = checkerboard_item_get_alignment_point (_tmp32_);
						_tmp33_ = req;
						_vala_assert (alignment_point < _tmp33_.height, "alignment_point < req.height");
						_tmp34_ = req;
						if (_tmp34_.height > tallest) {
							Dimensions _tmp35_;
							_tmp35_ = req;
							tallest = _tmp35_.height;
						}
						_tmp36_ = req;
						if (_tmp36_.width > widest) {
							Dimensions _tmp37_;
							_tmp37_ = req;
							widest = _tmp37_.width;
						}
						if (alignment_point > row_alignment_point) {
							row_alignment_point = alignment_point;
						}
						_tmp38_ = column_widths;
						_tmp38__length1 = column_widths_length1;
						_tmp39_ = _tmp38_[col];
						_tmp40_ = req;
						if (_tmp39_ < _tmp40_.width) {
							gint* _tmp41_;
							gint _tmp41__length1;
							gint _tmp42_;
							gint* _tmp43_;
							gint _tmp43__length1;
							Dimensions _tmp44_;
							Dimensions _tmp45_;
							_tmp41_ = column_widths;
							_tmp41__length1 = column_widths_length1;
							_tmp42_ = _tmp41_[col];
							total_width -= _tmp42_;
							_tmp43_ = column_widths;
							_tmp43__length1 = column_widths_length1;
							_tmp44_ = req;
							_tmp43_[col] = _tmp44_.width;
							_tmp45_ = req;
							total_width += _tmp45_.width;
						}
						col = col + 1;
						_tmp46_ = col;
						_tmp47_ = max_cols;
						if (_tmp46_ >= _tmp47_) {
							gint* _tmp48_;
							gint _tmp48__length1;
							gint* _tmp49_;
							gint _tmp49__length1;
							gint _tmp50_;
							gint _tmp51_;
							_tmp48_ = alignment_points;
							_tmp48__length1 = alignment_points_length1;
							_tmp48_[row] = row_alignment_point;
							_tmp49_ = row_heights;
							_tmp49__length1 = row_heights_length1;
							_tmp50_ = row;
							row = _tmp50_ + 1;
							_tmp51_ = tallest;
							_tmp49_[_tmp50_] = _tmp51_;
							col = 0;
							row_alignment_point = 0;
							tallest = 0;
						}
						_g_object_unref0 (item);
					}
				}
			}
			if (col != 0) {
				gint* _tmp52_;
				gint _tmp52__length1;
				gint* _tmp53_;
				gint _tmp53__length1;
				_tmp52_ = alignment_points;
				_tmp52__length1 = alignment_points_length1;
				_tmp52_[row] = row_alignment_point;
				_tmp53_ = row_heights;
				_tmp53__length1 = row_heights_length1;
				_tmp53_[row] = tallest;
			}
			gutter = (visible_width - total_width) / (max_cols + 1);
			if (max_cols == 1) {
				break;
			}
			if (gutter < CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) {
				gint _tmp54_;
				gint* _tmp55_;
				gint* _tmp56_;
				gint* _tmp57_;
				_tmp54_ = max_cols;
				max_cols = _tmp54_ - 1;
				max_rows = (total_items / max_cols) + 1;
				col = 0;
				row = 0;
				tallest = 0;
				widest = 0;
				total_width = 0;
				row_alignment_point = 0;
				_tmp55_ = g_new0 (gint, max_cols);
				column_widths = (g_free (column_widths), NULL);
				column_widths = _tmp55_;
				column_widths_length1 = max_cols;
				_column_widths_size_ = column_widths_length1;
				_tmp56_ = g_new0 (gint, max_rows);
				row_heights = (g_free (row_heights), NULL);
				row_heights = _tmp56_;
				row_heights_length1 = max_rows;
				_row_heights_size_ = row_heights_length1;
				_tmp57_ = g_new0 (gint, max_rows);
				alignment_points = (g_free (alignment_points), NULL);
				alignment_points = _tmp57_;
				alignment_points_length1 = max_rows;
				_alignment_points_size_ = alignment_points_length1;
			} else {
				break;
			}
		}
	}
	col = 0;
	row = 0;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp60_;
				DataObject* _tmp61_;
				Dimensions req = {0};
				CheckerboardItem* _tmp62_;
				Dimensions _tmp63_;
				gint true_height = 0;
				Dimensions _tmp64_;
				gint* _tmp65_;
				gint _tmp65__length1;
				gint _tmp66_;
				CheckerboardItem* _tmp67_;
				Dimensions _tmp68_;
				gint* _tmp69_;
				gint _tmp69__length1;
				gint _tmp70_;
				gint _tmp72_;
				gint _tmp73_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = ctr;
					ctr = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				if (!(ctr < total_items)) {
					break;
				}
				_tmp60_ = self->priv->view;
				_tmp61_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_DATA_COLLECTION, DataCollection), ctr);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
				_tmp62_ = item;
				_tmp63_ = _tmp62_->requisition;
				req = _tmp63_;
				_tmp64_ = req;
				_tmp65_ = alignment_points;
				_tmp65__length1 = alignment_points_length1;
				_tmp66_ = _tmp65_[row];
				_tmp67_ = item;
				true_height = _tmp64_.height + (_tmp66_ - checkerboard_item_get_alignment_point (_tmp67_));
				_tmp68_ = req;
				_vala_assert (true_height >= _tmp68_.height, "true_height >= req.height");
				_tmp69_ = row_heights;
				_tmp69__length1 = row_heights_length1;
				_tmp70_ = _tmp69_[row];
				if (true_height > _tmp70_) {
					gint* _tmp71_;
					gint _tmp71__length1;
					_tmp71_ = row_heights;
					_tmp71__length1 = row_heights_length1;
					_tmp71_[row] = true_height;
				}
				col = col + 1;
				_tmp72_ = col;
				_tmp73_ = max_cols;
				if (_tmp72_ >= _tmp73_) {
					gint _tmp74_;
					col = 0;
					_tmp74_ = row;
					row = _tmp74_ + 1;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp75_ = g_new0 (CheckerboardLayoutLayoutRow*, max_rows + 1);
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	self->priv->item_rows = _tmp75_;
	self->priv->item_rows_length1 = max_rows;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	x = gutter;
	y = CHECKERBOARD_LAYOUT_TOP_PADDING;
	col = 0;
	row = 0;
	current_row = NULL;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp76_ = FALSE;
			_tmp76_ = TRUE;
			while (TRUE) {
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp78_;
				DataObject* _tmp79_;
				Dimensions req = {0};
				CheckerboardItem* _tmp80_;
				Dimensions _tmp81_;
				gint xpadding = 0;
				gint* _tmp82_;
				gint _tmp82__length1;
				gint _tmp83_;
				Dimensions _tmp84_;
				gint ypadding = 0;
				gint* _tmp85_;
				gint _tmp85__length1;
				gint _tmp86_;
				CheckerboardItem* _tmp87_;
				CheckerboardItem* _tmp88_;
				CheckerboardItem* _tmp89_;
				CheckerboardItem* _tmp90_;
				Dimensions _tmp91_;
				CheckerboardItem* _tmp92_;
				Dimensions _tmp93_;
				CheckerboardItem* _tmp94_;
				CheckerboardLayoutLayoutRow* _tmp95_;
				CheckerboardLayoutLayoutRow* _tmp99_;
				CheckerboardItem** _tmp100_;
				gint _tmp100__length1;
				CheckerboardItem* _tmp101_;
				CheckerboardItem* _tmp102_;
				gint* _tmp103_;
				gint _tmp103__length1;
				gint _tmp104_;
				gint _tmp105_;
				gint _tmp106_;
				if (!_tmp76_) {
					gint _tmp77_;
					_tmp77_ = ctr;
					ctr = _tmp77_ + 1;
				}
				_tmp76_ = FALSE;
				if (!(ctr < total_items)) {
					break;
				}
				_tmp78_ = self->priv->view;
				_tmp79_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_DATA_COLLECTION, DataCollection), ctr);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
				_tmp80_ = item;
				_tmp81_ = _tmp80_->requisition;
				req = _tmp81_;
				_tmp82_ = column_widths;
				_tmp82__length1 = column_widths_length1;
				_tmp83_ = _tmp82_[col];
				_tmp84_ = req;
				xpadding = (_tmp83_ - _tmp84_.width) / 2;
				_vala_assert (xpadding >= 0, "xpadding >= 0");
				_tmp85_ = alignment_points;
				_tmp85__length1 = alignment_points_length1;
				_tmp86_ = _tmp85_[row];
				_tmp87_ = item;
				ypadding = _tmp86_ - checkerboard_item_get_alignment_point (_tmp87_);
				_vala_assert (ypadding >= 0, "ypadding >= 0");
				_tmp88_ = item;
				_tmp88_->allocation.x = x + xpadding;
				_tmp89_ = item;
				_tmp89_->allocation.y = y + ypadding;
				_tmp90_ = item;
				_tmp91_ = req;
				_tmp90_->allocation.width = _tmp91_.width;
				_tmp92_ = item;
				_tmp93_ = req;
				_tmp92_->allocation.height = _tmp93_.height;
				_tmp94_ = item;
				checkerboard_item_set_grid_coordinates (_tmp94_, col, row);
				_tmp95_ = current_row;
				if (_tmp95_ == NULL) {
					gint* _tmp96_;
					gint _tmp96__length1;
					gint _tmp97_;
					CheckerboardLayoutLayoutRow* _tmp98_;
					_tmp96_ = row_heights;
					_tmp96__length1 = row_heights_length1;
					_tmp97_ = _tmp96_[row];
					_tmp98_ = checkerboard_layout_layout_row_new (y, _tmp97_, max_cols);
					_checkerboard_layout_layout_row_unref0 (current_row);
					current_row = _tmp98_;
				}
				_tmp99_ = current_row;
				_tmp100_ = _tmp99_->items;
				_tmp100__length1 = _tmp99_->items_length1;
				_tmp101_ = item;
				_tmp102_ = _g_object_ref0 (_tmp101_);
				_g_object_unref0 (_tmp100_[col]);
				_tmp100_[col] = _tmp102_;
				_tmp103_ = column_widths;
				_tmp103__length1 = column_widths_length1;
				_tmp104_ = _tmp103_[col];
				x += _tmp104_ + gutter;
				col = col + 1;
				_tmp105_ = col;
				_tmp106_ = max_cols;
				if (_tmp105_ >= _tmp106_) {
					CheckerboardLayoutLayoutRow* _tmp107_;
					CheckerboardLayoutLayoutRow** _tmp108_;
					gint _tmp108__length1;
					CheckerboardLayoutLayoutRow* _tmp109_;
					CheckerboardLayoutLayoutRow* _tmp110_;
					gint* _tmp111_;
					gint _tmp111__length1;
					gint _tmp112_;
					gint _tmp113_;
					_tmp107_ = current_row;
					_vala_assert (_tmp107_ != NULL, "current_row != null");
					_tmp108_ = self->priv->item_rows;
					_tmp108__length1 = self->priv->item_rows_length1;
					_tmp109_ = current_row;
					_tmp110_ = _checkerboard_layout_layout_row_ref0 (_tmp109_);
					_checkerboard_layout_layout_row_unref0 (_tmp108_[row]);
					_tmp108_[row] = _tmp110_;
					_checkerboard_layout_layout_row_unref0 (current_row);
					current_row = NULL;
					x = gutter;
					_tmp111_ = row_heights;
					_tmp111__length1 = row_heights_length1;
					_tmp112_ = _tmp111_[row];
					y += _tmp112_ + CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING;
					col = 0;
					_tmp113_ = row;
					row = _tmp113_ + 1;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp114_ = current_row;
	if (_tmp114_ != NULL) {
		CheckerboardLayoutLayoutRow** _tmp115_;
		gint _tmp115__length1;
		CheckerboardLayoutLayoutRow* _tmp116_;
		CheckerboardLayoutLayoutRow* _tmp117_;
		_tmp115_ = self->priv->item_rows;
		_tmp115__length1 = self->priv->item_rows_length1;
		_tmp116_ = current_row;
		_tmp117_ = _checkerboard_layout_layout_row_ref0 (_tmp116_);
		_checkerboard_layout_layout_row_unref0 (_tmp115_[row]);
		_tmp115_[row] = _tmp117_;
	}
	self->priv->columns = max_cols;
	self->priv->rows = row + 1;
	_vala_assert (self->priv->rows == max_rows, "rows == max_rows");
	_tmp118_ = row_heights;
	_tmp118__length1 = row_heights_length1;
	_tmp119_ = _tmp118_[row];
	total_height = (y + _tmp119_) + CHECKERBOARD_LAYOUT_BOTTOM_PADDING;
	_tmp121_ = allocation;
	if (visible_width != _tmp121_.width) {
		_tmp120_ = TRUE;
	} else {
		GtkAllocation _tmp122_;
		_tmp122_ = allocation;
		_tmp120_ = total_height != _tmp122_.height;
	}
	if (_tmp120_) {
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), visible_width, total_height);
		self->priv->size_allocate_due_to_reflow = TRUE;
		checkerboard_layout_center_on_anchor (self, (gdouble) total_height);
	}
	_checkerboard_layout_layout_row_unref0 (current_row);
	alignment_points = (g_free (alignment_points), NULL);
	row_heights = (g_free (row_heights), NULL);
	column_widths = (g_free (column_widths), NULL);
}

static void
checkerboard_layout_items_dirty (CheckerboardLayout* self,
                                 const gchar* reason,
                                 GeeIterable* items)
{
	GdkRectangle dirty = {0};
	gboolean _tmp26_ = FALSE;
	GdkRectangle _tmp27_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (reason != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_ITERABLE));
	memset (&dirty, 0, sizeof (GdkRectangle));
	{
		GeeIterator* _data_view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (items);
		_data_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* data_view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			CheckerboardItem* item = NULL;
			DataView* _tmp4_;
			CheckerboardItem* _tmp5_;
			CheckerboardItem* _tmp6_;
			ViewCollection* _tmp7_;
			CheckerboardItem* _tmp8_;
			gboolean _tmp9_ = FALSE;
			CheckerboardItem* _tmp10_;
			GdkRectangle _tmp11_;
			GdkRectangle intersection = {0};
			CheckerboardItem* _tmp16_;
			GdkRectangle _tmp17_;
			GdkRectangle _tmp18_ = {0};
			gboolean _tmp19_;
			gboolean _tmp20_ = FALSE;
			GdkRectangle _tmp21_;
			_tmp1_ = _data_view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _data_view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			data_view = (DataView*) _tmp3_;
			_tmp4_ = data_view;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
			item = _tmp5_;
			_tmp6_ = item;
			if (!data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView))) {
				_g_object_unref0 (item);
				_g_object_unref0 (data_view);
				continue;
			}
			_tmp7_ = self->priv->view;
			_tmp8_ = item;
			_vala_assert (data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_OBJECT, DataObject)), "view.contains(item)");
			_tmp10_ = item;
			_tmp11_ = _tmp10_->allocation;
			if (_tmp11_.width <= 0) {
				_tmp9_ = TRUE;
			} else {
				CheckerboardItem* _tmp12_;
				GdkRectangle _tmp13_;
				_tmp12_ = item;
				_tmp13_ = _tmp12_->allocation;
				_tmp9_ = _tmp13_.height <= 0;
			}
			if (_tmp9_) {
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = g_strdup_printf ("items_dirty: %s", reason);
				_tmp15_ = _tmp14_;
				checkerboard_layout_need_reflow (self, _tmp15_);
				_g_free0 (_tmp15_);
				_g_object_unref0 (item);
				_g_object_unref0 (data_view);
				_g_object_unref0 (_data_view_it);
				return;
			}
			memset (&intersection, 0, sizeof (GdkRectangle));
			_tmp16_ = item;
			_tmp17_ = _tmp16_->allocation;
			_tmp19_ = gdk_rectangle_intersect (&self->priv->visible_page, &_tmp17_, &_tmp18_);
			intersection = _tmp18_;
			if (!_tmp19_) {
				_g_object_unref0 (item);
				_g_object_unref0 (data_view);
				continue;
			}
			_tmp21_ = dirty;
			if (_tmp21_.width == 0) {
				_tmp20_ = TRUE;
			} else {
				GdkRectangle _tmp22_;
				_tmp22_ = dirty;
				_tmp20_ = _tmp22_.height == 0;
			}
			if (_tmp20_) {
				GdkRectangle _tmp23_;
				_tmp23_ = intersection;
				dirty = _tmp23_;
			} else {
				GdkRectangle _tmp24_;
				GdkRectangle _tmp25_ = {0};
				_tmp24_ = intersection;
				gdk_rectangle_union (&dirty, &_tmp24_, &_tmp25_);
				dirty = _tmp25_;
			}
			_g_object_unref0 (item);
			_g_object_unref0 (data_view);
		}
		_g_object_unref0 (_data_view_it);
	}
	_tmp27_ = dirty;
	if (_tmp27_.width > 0) {
		GdkRectangle _tmp28_;
		_tmp28_ = dirty;
		_tmp26_ = _tmp28_.height > 0;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		GdkRectangle _tmp29_;
		GdkRectangle _tmp30_;
		GdkRectangle _tmp31_;
		GdkRectangle _tmp32_;
		_tmp29_ = dirty;
		_tmp30_ = dirty;
		_tmp31_ = dirty;
		_tmp32_ = dirty;
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp29_.x, _tmp30_.y, _tmp31_.width, _tmp32_.height);
	}
}

static void
checkerboard_layout_real_map (GtkWidget* base)
{
	CheckerboardLayout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->map (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget));
	checkerboard_layout_set_colors (self, TRUE);
}

static void
checkerboard_layout_set_colors (CheckerboardLayout* self,
                                gboolean in_focus)
{
	GtkStyleContext* ctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GValue val = {0};
	GValue _tmp2_ = {0};
	void* _tmp3_;
	GValue _tmp4_ = {0};
	void* _tmp5_;
	GValue _tmp6_ = {0};
	void* _tmp7_;
	GValue _tmp8_ = {0};
	void* _tmp9_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	gtk_style_context_save (ctx);
	gtk_style_context_add_class (ctx, "view");
	gtk_style_context_get_property (ctx, "border-color", GTK_STATE_FLAG_NORMAL, &_tmp2_);
	val = _tmp2_;
	_tmp3_ = g_value_get_boxed (&val);
	self->priv->focus_color = *((GdkRGBA*) _tmp3_);
	gtk_style_context_get_property (ctx, "border-color", GTK_STATE_FLAG_FOCUSED, &_tmp4_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp4_;
	_tmp5_ = g_value_get_boxed (&val);
	self->priv->border_color = *((GdkRGBA*) _tmp5_);
	gtk_style_context_get_property (ctx, "background-color", GTK_STATE_FLAG_FOCUSED | GTK_STATE_FLAG_SELECTED, &_tmp6_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp6_;
	_tmp7_ = g_value_get_boxed (&val);
	self->priv->selected_color = *((GdkRGBA*) _tmp7_);
	gtk_style_context_get_property (ctx, "color", GTK_STATE_FLAG_NORMAL, &_tmp8_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp8_;
	_tmp9_ = g_value_get_boxed (&val);
	self->priv->unselected_color = *((GdkRGBA*) _tmp9_);
	gtk_style_context_restore (ctx);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	_g_object_unref0 (ctx);
}

static void
checkerboard_layout_real_size_allocate (GtkWidget* base,
                                        GtkAllocation* allocation)
{
	CheckerboardLayout * self;
	GtkAllocation _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), &_tmp0_);
	checkerboard_layout_viewport_resized (self);
}

static gboolean
checkerboard_layout_real_draw (GtkWidget* base,
                               cairo_t* ctx)
{
	CheckerboardLayout * self;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkStyleContext* _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	gboolean _tmp22_ = FALSE;
	gboolean _result_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	g_return_val_if_fail (ctx != NULL, FALSE);
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = allocation;
	_tmp3_ = allocation;
	gtk_render_background (_tmp1_, ctx, (gdouble) 0, (gdouble) 0, (gdouble) _tmp2_.width, (gdouble) _tmp3_.height);
	if (self->priv->exposure_dirty) {
		checkerboard_layout_expose_items (self, "draw");
	}
	{
		GeeList* _item_list = NULL;
		GdkRectangle _tmp4_;
		GeeList* _tmp5_;
		gint _item_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp4_ = self->priv->visible_page;
		_tmp5_ = checkerboard_layout_intersection (self, &_tmp4_);
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			GdkRGBA _tmp13_ = {0};
			CheckerboardItem* _tmp14_;
			CheckerboardItem* _tmp17_;
			GtkStyleContext* _tmp18_;
			GdkRGBA _tmp19_;
			GdkRGBA _tmp20_;
			GdkRGBA _tmp21_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_list_get (_tmp11_, _item_index);
			item = (CheckerboardItem*) _tmp12_;
			_tmp14_ = item;
			if (data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_VIEW, DataView))) {
				GdkRGBA _tmp15_;
				_tmp15_ = self->priv->selected_color;
				_tmp13_ = _tmp15_;
			} else {
				GdkRGBA _tmp16_;
				_tmp16_ = self->priv->unselected_color;
				_tmp13_ = _tmp16_;
			}
			_tmp17_ = item;
			_tmp18_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			_tmp19_ = self->priv->bg_color;
			_tmp20_ = self->priv->border_color;
			_tmp21_ = self->priv->focus_color;
			checkerboard_item_paint (_tmp17_, _tmp18_, ctx, &_tmp19_, &_tmp13_, &_tmp20_, &_tmp21_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_list);
	}
	if (GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw != NULL) {
		_tmp22_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), ctx);
	} else {
		_tmp22_ = TRUE;
	}
	_result_ = _tmp22_;
	checkerboard_layout_draw_selection_band (self, ctx);
	result = _result_;
	return result;
}

static void
checkerboard_layout_draw_selection_band (CheckerboardLayout* self,
                                         cairo_t* ctx)
{
	gboolean _tmp0_ = FALSE;
	GdkRectangle _tmp1_;
	gboolean _tmp3_ = FALSE;
	GtkAdjustment* _tmp4_;
	GdkRectangle visible_page = {0};
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GdkRectangle _tmp8_ = {0};
	GdkRectangle visible_band = {0};
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_ = {0};
	GtkStyleContext* _tmp11_;
	GtkStyleContext* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GdkRectangle _tmp14_;
	GtkStyleContext* _tmp21_;
	GdkRectangle _tmp22_;
	GdkRectangle _tmp23_;
	GdkRectangle _tmp24_;
	GdkRectangle _tmp25_;
	GtkStyleContext* _tmp26_;
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	g_return_if_fail (ctx != NULL);
	_tmp1_ = self->priv->selection_band;
	if (_tmp1_.width <= 1) {
		_tmp0_ = TRUE;
	} else {
		GdkRectangle _tmp2_;
		_tmp2_ = self->priv->selection_band;
		_tmp0_ = _tmp2_.height <= 1;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->hadjustment;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GtkAdjustment* _tmp5_;
		_tmp5_ = self->priv->vadjustment;
		_tmp3_ = _tmp5_ == NULL;
	}
	if (_tmp3_) {
		return;
	}
	_tmp6_ = self->priv->hadjustment;
	_tmp7_ = self->priv->vadjustment;
	get_adjustment_page (_tmp6_, _tmp7_, &_tmp8_);
	visible_page = _tmp8_;
	memset (&visible_band, 0, sizeof (GdkRectangle));
	_tmp9_ = self->priv->selection_band;
	gdk_rectangle_intersect (&visible_page, &_tmp9_, &_tmp10_);
	visible_band = _tmp10_;
	_tmp11_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_save (_tmp11_);
	_tmp12_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp12_, GTK_STYLE_CLASS_RUBBERBAND);
	_tmp14_ = visible_band;
	if (_tmp14_.width > 1) {
		GdkRectangle _tmp15_;
		_tmp15_ = visible_band;
		_tmp13_ = _tmp15_.height > 1;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GtkStyleContext* _tmp16_;
		GdkRectangle _tmp17_;
		GdkRectangle _tmp18_;
		GdkRectangle _tmp19_;
		GdkRectangle _tmp20_;
		_tmp16_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp17_ = visible_band;
		_tmp18_ = visible_band;
		_tmp19_ = visible_band;
		_tmp20_ = visible_band;
		gtk_render_background (_tmp16_, ctx, (gdouble) _tmp17_.x, (gdouble) _tmp18_.y, (gdouble) _tmp19_.width, (gdouble) _tmp20_.height);
	}
	_tmp21_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp22_ = visible_band;
	_tmp23_ = visible_band;
	_tmp24_ = visible_band;
	_tmp25_ = visible_band;
	gtk_render_frame (_tmp21_, ctx, (gdouble) _tmp22_.x, (gdouble) _tmp23_.y, (gdouble) _tmp24_.width, (gdouble) _tmp25_.height);
	_tmp26_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_restore (_tmp26_);
}

static gboolean
checkerboard_layout_real_query_tooltip (GtkWidget* base,
                                        gint x,
                                        gint y,
                                        gboolean keyboard_mode,
                                        GtkTooltip* tooltip)
{
	CheckerboardLayout * self;
	CheckerboardItem* item = NULL;
	CheckerboardItem* _tmp0_;
	CheckerboardItem* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (tooltip, gtk_tooltip_get_type ()), FALSE);
	_tmp0_ = checkerboard_layout_get_item_at_pixel (self, (gdouble) x, (gdouble) y);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		CheckerboardItem* _tmp2_;
		CheckerboardItem* _tmp3_;
		_tmp2_ = item;
		checkerboard_item_translate_coordinates (_tmp2_, &x, &y);
		_tmp3_ = item;
		result = checkerboard_item_query_tooltip (_tmp3_, x, y, tooltip);
		_g_object_unref0 (item);
		return result;
	} else {
		result = FALSE;
		_g_object_unref0 (item);
		return result;
	}
}

static void
checkerboard_layout_on_colors_changed (CheckerboardLayout* self)
{
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
	invalidate_transparent_background ();
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static gboolean
checkerboard_layout_real_focus_in_event (GtkWidget* base,
                                         GdkEventFocus* event)
{
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	g_return_val_if_fail (event != NULL, FALSE);
	checkerboard_layout_set_colors (self, TRUE);
	_tmp0_ = self->priv->view;
	_tmp1_ = view_collection_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	checkerboard_layout_items_dirty (self, "focus_in_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
	_g_object_unref0 (_tmp2_);
	result = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_in_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), event);
	return result;
}

static gboolean
checkerboard_layout_real_focus_out_event (GtkWidget* base,
                                          GdkEventFocus* event)
{
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	g_return_val_if_fail (event != NULL, FALSE);
	checkerboard_layout_set_colors (self, FALSE);
	_tmp0_ = self->priv->view;
	_tmp1_ = view_collection_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	checkerboard_layout_items_dirty (self, "focus_out_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
	_g_object_unref0 (_tmp2_);
	result = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), event);
	return result;
}

static CheckerboardLayoutLayoutRow*
checkerboard_layout_layout_row_construct (GType object_type,
                                          gint y,
                                          gint height,
                                          gint num_in_row)
{
	CheckerboardLayoutLayoutRow* self = NULL;
	CheckerboardItem** _tmp0_;
	self = (CheckerboardLayoutLayoutRow*) g_type_create_instance (object_type);
	self->y = y;
	self->height = height;
	_tmp0_ = g_new0 (CheckerboardItem*, num_in_row + 1);
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->items = _tmp0_;
	self->items_length1 = num_in_row;
	self->_items_size_ = self->items_length1;
	return self;
}

static CheckerboardLayoutLayoutRow*
checkerboard_layout_layout_row_new (gint y,
                                    gint height,
                                    gint num_in_row)
{
	return checkerboard_layout_layout_row_construct (CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, y, height, num_in_row);
}

static void
checkerboard_layout_value_layout_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
checkerboard_layout_value_layout_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		checkerboard_layout_layout_row_unref (value->data[0].v_pointer);
	}
}

static void
checkerboard_layout_value_layout_row_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = checkerboard_layout_layout_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
checkerboard_layout_value_layout_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
checkerboard_layout_value_layout_row_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CheckerboardLayoutLayoutRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = checkerboard_layout_layout_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
checkerboard_layout_value_layout_row_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	CheckerboardLayoutLayoutRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
checkerboard_layout_param_spec_layout_row (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	CheckerboardLayoutParamSpecLayoutRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
checkerboard_layout_value_get_layout_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
	return value->data[0].v_pointer;
}

static void
checkerboard_layout_value_set_layout_row (GValue* value,
                                          gpointer v_object)
{
	CheckerboardLayoutLayoutRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		checkerboard_layout_layout_row_unref (old);
	}
}

static void
checkerboard_layout_value_take_layout_row (GValue* value,
                                           gpointer v_object)
{
	CheckerboardLayoutLayoutRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		checkerboard_layout_layout_row_unref (old);
	}
}

static void
checkerboard_layout_layout_row_class_init (CheckerboardLayoutLayoutRowClass * klass,
                                           gpointer klass_data)
{
	checkerboard_layout_layout_row_parent_class = g_type_class_peek_parent (klass);
	((CheckerboardLayoutLayoutRowClass *) klass)->finalize = checkerboard_layout_layout_row_finalize;
}

static void
checkerboard_layout_layout_row_instance_init (CheckerboardLayoutLayoutRow * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj)
{
	CheckerboardLayoutLayoutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow);
	g_signal_handlers_destroy (self);
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
}

static GType
checkerboard_layout_layout_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { checkerboard_layout_value_layout_row_init, checkerboard_layout_value_layout_row_free_value, checkerboard_layout_value_layout_row_copy_value, checkerboard_layout_value_layout_row_peek_pointer, "p", checkerboard_layout_value_layout_row_collect_value, "p", checkerboard_layout_value_layout_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutLayoutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_layout_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayoutLayoutRow), 0, (GInstanceInitFunc) checkerboard_layout_layout_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType checkerboard_layout_layout_row_type_id;
	checkerboard_layout_layout_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardLayoutLayoutRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return checkerboard_layout_layout_row_type_id;
}

static GType
checkerboard_layout_layout_row_get_type (void)
{
	static volatile gsize checkerboard_layout_layout_row_type_id__once = 0;
	if (g_once_init_enter (&checkerboard_layout_layout_row_type_id__once)) {
		GType checkerboard_layout_layout_row_type_id;
		checkerboard_layout_layout_row_type_id = checkerboard_layout_layout_row_get_type_once ();
		g_once_init_leave (&checkerboard_layout_layout_row_type_id__once, checkerboard_layout_layout_row_type_id);
	}
	return checkerboard_layout_layout_row_type_id__once;
}

static gpointer
checkerboard_layout_layout_row_ref (gpointer instance)
{
	CheckerboardLayoutLayoutRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
checkerboard_layout_layout_row_unref (gpointer instance)
{
	CheckerboardLayoutLayoutRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
checkerboard_layout_class_init (CheckerboardLayoutClass * klass,
                                gpointer klass_data)
{
	checkerboard_layout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheckerboardLayout_private_offset);
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget*)) checkerboard_layout_real_map;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) checkerboard_layout_real_size_allocate;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) checkerboard_layout_real_draw;
	((GtkWidgetClass *) klass)->query_tooltip = (gboolean (*) (GtkWidget*, gint, gint, gboolean, GtkTooltip*)) checkerboard_layout_real_query_tooltip;
	((GtkWidgetClass *) klass)->focus_in_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) checkerboard_layout_real_focus_in_event;
	((GtkWidgetClass *) klass)->focus_out_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) checkerboard_layout_real_focus_out_event;
	G_OBJECT_CLASS (klass)->finalize = checkerboard_layout_finalize;
}

static void
checkerboard_layout_instance_init (CheckerboardLayout * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = checkerboard_layout_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->page_name = _tmp0_;
	self->priv->item_rows = NULL;
	self->priv->item_rows_length1 = 0;
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
	_tmp1_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->exposed_items = _tmp1_;
	self->priv->hadjustment = NULL;
	self->priv->vadjustment = NULL;
	memset (&self->priv->visible_page, 0, sizeof (GdkRectangle));
	self->priv->last_width = 0;
	self->priv->columns = 0;
	self->priv->rows = 0;
	memset (&self->priv->drag_origin, 0, sizeof (GdkPoint));
	memset (&self->priv->drag_endpoint, 0, sizeof (GdkPoint));
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
	self->priv->scale = 0;
	self->priv->flow_scheduled = FALSE;
	self->priv->exposure_dirty = TRUE;
	self->priv->anchor = NULL;
	self->priv->cursor = NULL;
	self->priv->in_center_on_anchor = FALSE;
	self->priv->size_allocate_due_to_reflow = FALSE;
	self->priv->is_in_view = FALSE;
	self->priv->reflow_needed = FALSE;
}

static void
checkerboard_layout_finalize (GObject * obj)
{
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	guint _tmp1_;
	ViewCollection* _tmp2_;
	guint _tmp3_;
	ViewCollection* _tmp4_;
	guint _tmp5_;
	ViewCollection* _tmp6_;
	guint _tmp7_;
	ViewCollection* _tmp8_;
	guint _tmp9_;
	ViewCollection* _tmp10_;
	guint _tmp11_;
	ViewCollection* _tmp12_;
	guint _tmp13_;
	ViewCollection* _tmp14_;
	guint _tmp15_;
	ViewCollection* _tmp16_;
	guint _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkAdjustment* _tmp21_;
	GtkContainer* _tmp24_;
	GtkContainer* _tmp25_;
	ConfigFacade* _tmp29_;
	ConfigFacade* _tmp30_;
	guint _tmp31_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
	_tmp0_ = self->priv->view;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self);
	_tmp2_ = self->priv->view;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self);
	_tmp4_ = self->priv->view;
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self);
	_tmp6_ = self->priv->view;
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self);
	_tmp8_ = self->priv->view;
	g_signal_parse_name ("ordering-changed", TYPE_DATA_COLLECTION, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self);
	_tmp10_ = self->priv->view;
	g_signal_parse_name ("views-altered", TYPE_VIEW_COLLECTION, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self);
	_tmp12_ = self->priv->view;
	g_signal_parse_name ("geometries-altered", TYPE_VIEW_COLLECTION, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self);
	_tmp14_ = self->priv->view;
	g_signal_parse_name ("items-selected", TYPE_VIEW_COLLECTION, &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self);
	_tmp16_ = self->priv->view;
	g_signal_parse_name ("items-unselected", TYPE_VIEW_COLLECTION, &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self);
	_tmp18_ = self->priv->hadjustment;
	if (_tmp18_ != NULL) {
		GtkAdjustment* _tmp19_;
		guint _tmp20_;
		_tmp19_ = self->priv->hadjustment;
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp20_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
	}
	_tmp21_ = self->priv->vadjustment;
	if (_tmp21_ != NULL) {
		GtkAdjustment* _tmp22_;
		guint _tmp23_;
		_tmp22_ = self->priv->vadjustment;
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp23_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
	}
	_tmp24_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		GtkContainer* _tmp26_;
		GtkContainer* _tmp27_;
		guint _tmp28_;
		_tmp26_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp27_ = _tmp26_;
		g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp28_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp28_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self);
	}
	_tmp29_ = config_facade_get_instance ();
	_tmp30_ = _tmp29_;
	g_signal_parse_name ("colors-changed", CONFIG_TYPE_FACADE, &_tmp31_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp30_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp31_, 0, NULL, (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self);
	_g_object_unref0 (_tmp30_);
	_data_collection_unref0 (self->priv->view);
	_g_free0 (self->priv->page_name);
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
	_g_object_unref0 (self->priv->exposed_items);
	_g_object_unref0 (self->priv->hadjustment);
	_g_object_unref0 (self->priv->vadjustment);
	_g_object_unref0 (self->priv->anchor);
	_g_object_unref0 (self->priv->cursor);
	G_OBJECT_CLASS (checkerboard_layout_parent_class)->finalize (obj);
}

static GType
checkerboard_layout_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayout), 0, (GInstanceInitFunc) checkerboard_layout_instance_init, NULL };
	GType checkerboard_layout_type_id;
	checkerboard_layout_type_id = g_type_register_static (gtk_drawing_area_get_type (), "CheckerboardLayout", &g_define_type_info, 0);
	CheckerboardLayout_private_offset = g_type_add_instance_private (checkerboard_layout_type_id, sizeof (CheckerboardLayoutPrivate));
	return checkerboard_layout_type_id;
}

GType
checkerboard_layout_get_type (void)
{
	static volatile gsize checkerboard_layout_type_id__once = 0;
	if (g_once_init_enter (&checkerboard_layout_type_id__once)) {
		GType checkerboard_layout_type_id;
		checkerboard_layout_type_id = checkerboard_layout_get_type_once ();
		g_once_init_leave (&checkerboard_layout_type_id__once, checkerboard_layout_type_id);
	}
	return checkerboard_layout_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

