/* Application.c generated by valac 0.56.17, the Vala compiler
 * generated from Application.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include "shotwell-plugin-dev-1.0.h"
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_AUTHENTICATION_RECEIVER (authentication_receiver_get_type ())
#define AUTHENTICATION_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTHENTICATION_RECEIVER, AuthenticationReceiver))
#define IS_AUTHENTICATION_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTHENTICATION_RECEIVER))
#define AUTHENTICATION_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_AUTHENTICATION_RECEIVER, AuthenticationReceiverIface))

typedef struct _AuthenticationReceiver AuthenticationReceiver;
typedef struct _AuthenticationReceiverIface AuthenticationReceiverIface;

#define TYPE_AUTHENTICATION_RECEIVER_PROXY (authentication_receiver_proxy_get_type ())
typedef GDBusProxy AuthenticationReceiverProxy;
typedef GDBusProxyClass AuthenticationReceiverProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_AUTHENTICATOR_RECEIVER_APP (authenticator_receiver_app_get_type ())
#define AUTHENTICATOR_RECEIVER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverApp))
#define AUTHENTICATOR_RECEIVER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverAppClass))
#define IS_AUTHENTICATOR_RECEIVER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTHENTICATOR_RECEIVER_APP))
#define IS_AUTHENTICATOR_RECEIVER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTHENTICATOR_RECEIVER_APP))
#define AUTHENTICATOR_RECEIVER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverAppClass))

typedef struct _AuthenticatorReceiverApp AuthenticatorReceiverApp;
typedef struct _AuthenticatorReceiverAppClass AuthenticatorReceiverAppClass;
typedef struct _AuthenticatorReceiverAppPrivate AuthenticatorReceiverAppPrivate;
enum  {
	AUTHENTICATOR_RECEIVER_APP_0_PROPERTY,
	AUTHENTICATOR_RECEIVER_APP_NUM_PROPERTIES
};
static GParamSpec* authenticator_receiver_app_properties[AUTHENTICATOR_RECEIVER_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define APPLICATION_TYPE_AUTH_CALLBACK (application_auth_callback_get_type ())
#define APPLICATION_AUTH_CALLBACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_AUTH_CALLBACK, ApplicationAuthCallback))
#define APPLICATION_IS_AUTH_CALLBACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_AUTH_CALLBACK))
#define APPLICATION_AUTH_CALLBACK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLICATION_TYPE_AUTH_CALLBACK, ApplicationAuthCallbackIface))

typedef struct _ApplicationAuthCallback ApplicationAuthCallback;
typedef struct _ApplicationAuthCallbackIface ApplicationAuthCallbackIface;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
typedef struct _ParamSpecApplication ParamSpecApplication;
enum  {
	APPLICATION_STARTING_SIGNAL,
	APPLICATION_EXITING_SIGNAL,
	APPLICATION_INIT_DONE_SIGNAL,
	APPLICATION_NUM_SIGNALS
};
static guint application_signals[APPLICATION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AuthenticationReceiverIface {
	GTypeInterface parent_iface;
	void (*callback) (AuthenticationReceiver* self, const gchar* url, GError** error);
};

struct _AuthenticatorReceiverApp {
	GtkApplication parent_instance;
	AuthenticatorReceiverAppPrivate * priv;
};

struct _AuthenticatorReceiverAppClass {
	GtkApplicationClass parent_class;
};

struct _AuthenticatorReceiverAppPrivate {
	GeeHashMap* pending_auth_requests;
};

struct _Application {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GTypeClass parent_class;
	void (*finalize) (Application *self);
	void (*starting) (Application* self);
	void (*exiting) (Application* self, gboolean panicked);
	void (*init_done) (Application* self);
};

struct _ApplicationAuthCallbackIface {
	GTypeInterface parent_iface;
	void (*authenticated) (ApplicationAuthCallback* self, GHashTable* params);
};

struct _ApplicationPrivate {
	GtkApplication* system_app;
	gint system_app_run_retval;
	gboolean direct;
	gboolean fixup_raw_thumbs;
	gboolean running;
	gboolean exiting_fired;
	GeeHashMap* pending_auth_requests;
};

struct _ParamSpecApplication {
	GParamSpec parent_instance;
};

static gint AuthenticatorReceiverApp_private_offset;
static gpointer authenticator_receiver_app_parent_class = NULL;
static AuthenticationReceiverIface * authenticator_receiver_app_authentication_receiver_parent_iface = NULL;
static gint Application_private_offset;
static gpointer application_parent_class = NULL;
static Application* application_instance;
static Application* application_instance = NULL;

VALA_EXTERN GType authentication_receiver_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint authentication_receiver_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType authentication_receiver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AuthenticationReceiver, g_object_unref)
VALA_EXTERN void authentication_receiver_callback (AuthenticationReceiver* self,
                                       const gchar* url,
                                       GError** error);
static GType authentication_receiver_get_type_once (void);
static void authentication_receiver_proxy_g_signal (GDBusProxy* proxy,
                                             const gchar* sender_name,
                                             const gchar* signal_name,
                                             GVariant* parameters);
static void authentication_receiver_proxy_callback (AuthenticationReceiver* self,
                                             const gchar* url,
                                             GError** error);
static void authentication_receiver_proxy_authentication_receiver_interface_init (AuthenticationReceiverIface* iface);
static void _dbus_authentication_receiver_callback (AuthenticationReceiver* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void authentication_receiver_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data);
static GVariant* authentication_receiver_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data);
static gboolean authentication_receiver_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data);
static void _authentication_receiver_unregister_object (gpointer user_data);
VALA_EXTERN GType authenticator_receiver_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AuthenticatorReceiverApp, g_object_unref)
VALA_EXTERN guint authenticator_receiver_app_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN AuthenticatorReceiverApp* authenticator_receiver_app_new (void);
VALA_EXTERN AuthenticatorReceiverApp* authenticator_receiver_app_construct (GType object_type);
static gboolean authenticator_receiver_app_real_dbus_register (GApplication* base,
                                                        GDBusConnection* connection,
                                                        const gchar* object_path,
                                                        GError** error);
VALA_EXTERN void authenticator_receiver_app_register_auth_callback (AuthenticatorReceiverApp* self,
                                                        const gchar* cookie,
                                                        SpitPublishingAuthenticatedCallback* cb);
VALA_EXTERN void authenticator_receiver_app_unregister_auth_callback (AuthenticatorReceiverApp* self,
                                                          const gchar* cookie);
static void authenticator_receiver_app_real_callback (AuthenticationReceiver* base,
                                               const gchar* callback_url,
                                               GError** error);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN GType library_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryWindow, g_object_unref)
VALA_EXTERN LibraryWindow* library_window_get_app (void);
static void authenticator_receiver_app_finalize (GObject * obj);
static GType authenticator_receiver_app_get_type_once (void);
static void _dbus_authenticator_receiver_app_callback (AuthenticatorReceiverApp* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void authenticator_receiver_app_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* authenticator_receiver_app_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static gboolean authenticator_receiver_app_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _authenticator_receiver_app_unregister_object (gpointer user_data);
VALA_EXTERN gpointer application_ref (gpointer instance);
VALA_EXTERN void application_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_application (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_application (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_application (const GValue* value);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, application_unref)
VALA_EXTERN GType application_auth_callback_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ApplicationAuthCallback, g_object_unref)
VALA_EXTERN void application_set_raw_thumbs_fix_required (Application* self,
                                              gboolean should_fixup);
VALA_EXTERN gboolean application_get_raw_thumbs_fix_required (Application* self);
VALA_EXTERN GtkApplication* application_get_system_app (Application* self);
static Application* application_new (gboolean is_direct);
static Application* application_construct (GType object_type,
                                    gboolean is_direct);
VALA_EXTERN void application_panic (Application* self);
VALA_EXTERN gint application_on_command_line (GApplicationCommandLine* acl);
static gint _application_on_command_line_g_application_command_line (GApplication* _sender,
                                                              GApplicationCommandLine* command_line,
                                                              gpointer self);
static void ___lambda38_ (Application* self,
                   GSimpleAction* a,
                   GVariant* p);
VALA_EXTERN void application_auth_callback_authenticated (ApplicationAuthCallback* self,
                                              GHashTable* params);
static void ____lambda38__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
VALA_EXTERN void application_on_activated (void);
static void _application_on_activated_g_application_activate (GApplication* _sender,
                                                       gpointer self);
static void _application_on_activated_g_application_startup (GApplication* _sender,
                                                      gpointer self);
VALA_EXTERN void application_register_auth_callback (const gchar* cookie,
                                         SpitPublishingAuthenticatedCallback* cb);
VALA_EXTERN Application* application_get_instance (void);
VALA_EXTERN void application_unregister_auth_callback (const gchar* cookie);
VALA_EXTERN gdouble application_get_scale (void);
VALA_EXTERN void application_send_to_primary_instance (gchar** argv,
                                           gint argv_length1);
VALA_EXTERN void application_present_primary_instance (void);
VALA_EXTERN gboolean application_get_is_remote (void);
VALA_EXTERN gboolean application_get_is_direct (void);
VALA_EXTERN void application_set_accels_for_action (const gchar* action,
                                        gchar** accel,
                                        gint accel_length1);
VALA_EXTERN void application_set_menubar (GMenuModel* model);
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void library_window_mounted_camera_shell_notification (LibraryWindow* self,
                                                       const gchar* uri,
                                                       gboolean at_startup);
VALA_EXTERN void application_init (gboolean is_direct);
VALA_EXTERN void application_terminate (void);
VALA_EXTERN void application_exit (Application* self);
VALA_EXTERN void application_start (Application* self,
                        gchar** argv,
                        gint argv_length1);
VALA_EXTERN guint application_inhibit (Application* self,
                           GtkApplicationInhibitFlags what,
                           const gchar* reason);
VALA_EXTERN void application_uninhibit (Application* self,
                            guint cookie);
VALA_EXTERN gint application_get_run_return_value (Application* self);
static void application_real_starting (Application* self);
static void application_real_exiting (Application* self,
                               gboolean panicked);
static void application_real_init_done (Application* self);
static GType application_auth_callback_get_type_once (void);
static void application_finalize (Application * obj);
static GType application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _authentication_receiver_dbus_arg_info_callback_url = {-1, "url", "s", NULL};
static const GDBusArgInfo * const _authentication_receiver_dbus_arg_info_callback_in[] = {&_authentication_receiver_dbus_arg_info_callback_url, NULL};
static const GDBusArgInfo * const _authentication_receiver_dbus_arg_info_callback_out[] = {NULL};
static const GDBusMethodInfo _authentication_receiver_dbus_method_info_callback = {-1, "Callback", (GDBusArgInfo **) (&_authentication_receiver_dbus_arg_info_callback_in), (GDBusArgInfo **) (&_authentication_receiver_dbus_arg_info_callback_out), NULL};
static const GDBusMethodInfo * const _authentication_receiver_dbus_method_info[] = {&_authentication_receiver_dbus_method_info_callback, NULL};
static const GDBusSignalInfo * const _authentication_receiver_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _authentication_receiver_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _authentication_receiver_dbus_interface_info = {-1, "org.gnome.Shotwell.Authenticate", (GDBusMethodInfo **) (&_authentication_receiver_dbus_method_info), (GDBusSignalInfo **) (&_authentication_receiver_dbus_signal_info), (GDBusPropertyInfo **) (&_authentication_receiver_dbus_property_info), NULL};
static const GDBusInterfaceVTable _authentication_receiver_dbus_interface_vtable = {authentication_receiver_dbus_interface_method_call, authentication_receiver_dbus_interface_get_property, authentication_receiver_dbus_interface_set_property};
static const GDBusArgInfo _authenticator_receiver_app_dbus_arg_info_callback_callback_url = {-1, "callback_url", "s", NULL};
static const GDBusArgInfo * const _authenticator_receiver_app_dbus_arg_info_callback_in[] = {&_authenticator_receiver_app_dbus_arg_info_callback_callback_url, NULL};
static const GDBusArgInfo * const _authenticator_receiver_app_dbus_arg_info_callback_out[] = {NULL};
static const GDBusMethodInfo _authenticator_receiver_app_dbus_method_info_callback = {-1, "Callback", (GDBusArgInfo **) (&_authenticator_receiver_app_dbus_arg_info_callback_in), (GDBusArgInfo **) (&_authenticator_receiver_app_dbus_arg_info_callback_out), NULL};
static const GDBusMethodInfo * const _authenticator_receiver_app_dbus_method_info[] = {&_authenticator_receiver_app_dbus_method_info_callback, NULL};
static const GDBusSignalInfo * const _authenticator_receiver_app_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _authenticator_receiver_app_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _authenticator_receiver_app_dbus_interface_info = {-1, "org.gnome.Shotwell.Authenticate", (GDBusMethodInfo **) (&_authenticator_receiver_app_dbus_method_info), (GDBusSignalInfo **) (&_authenticator_receiver_app_dbus_signal_info), (GDBusPropertyInfo **) (&_authenticator_receiver_app_dbus_property_info), NULL};
static const GDBusInterfaceVTable _authenticator_receiver_app_dbus_interface_vtable = {authenticator_receiver_app_dbus_interface_method_call, authenticator_receiver_app_dbus_interface_get_property, authenticator_receiver_app_dbus_interface_set_property};

void
authentication_receiver_callback (AuthenticationReceiver* self,
                                  const gchar* url,
                                  GError** error)
{
	AuthenticationReceiverIface* _iface_;
	g_return_if_fail (IS_AUTHENTICATION_RECEIVER (self));
	_iface_ = AUTHENTICATION_RECEIVER_GET_INTERFACE (self);
	if (_iface_->callback) {
		_iface_->callback (self, url, error);
	}
}

static void
authentication_receiver_default_init (AuthenticationReceiverIface * iface,
                                      gpointer iface_data)
{
}

static GType
authentication_receiver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AuthenticationReceiverIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) authentication_receiver_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType authentication_receiver_type_id;
	authentication_receiver_type_id = g_type_register_static (G_TYPE_INTERFACE, "AuthenticationReceiver", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (authentication_receiver_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) authentication_receiver_proxy_get_type);
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Shotwell.Authenticate");
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_authentication_receiver_dbus_interface_info));
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) authentication_receiver_register_object);
	return authentication_receiver_type_id;
}

GType
authentication_receiver_get_type (void)
{
	static volatile gsize authentication_receiver_type_id__once = 0;
	if (g_once_init_enter (&authentication_receiver_type_id__once)) {
		GType authentication_receiver_type_id;
		authentication_receiver_type_id = authentication_receiver_get_type_once ();
		g_once_init_leave (&authentication_receiver_type_id__once, authentication_receiver_type_id);
	}
	return authentication_receiver_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AuthenticationReceiverProxy, authentication_receiver_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_AUTHENTICATION_RECEIVER, authentication_receiver_proxy_authentication_receiver_interface_init) )
static void
authentication_receiver_proxy_class_init (AuthenticationReceiverProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = authentication_receiver_proxy_g_signal;
}

static void
authentication_receiver_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters)
{
}

static void
authentication_receiver_proxy_init (AuthenticationReceiverProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_authentication_receiver_dbus_interface_info));
}

static void
authentication_receiver_proxy_callback (AuthenticationReceiver* self,
                                        const gchar* url,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Shotwell.Authenticate", "Callback");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
authentication_receiver_proxy_authentication_receiver_interface_init (AuthenticationReceiverIface* iface)
{
	iface->callback = authentication_receiver_proxy_callback;
}

static void
_dbus_authentication_receiver_callback (AuthenticationReceiver* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp24_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp24_, NULL);
	g_variant_unref (_tmp24_);
	authentication_receiver_callback (self, url, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (url);
	;
}

static void
authentication_receiver_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Callback") == 0) {
		_dbus_authentication_receiver_callback (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
authentication_receiver_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
authentication_receiver_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
authentication_receiver_register_object (gpointer object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_authentication_receiver_dbus_interface_info), &_authentication_receiver_dbus_interface_vtable, data, _authentication_receiver_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_authentication_receiver_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
authenticator_receiver_app_get_instance_private (AuthenticatorReceiverApp* self)
{
	return G_STRUCT_MEMBER_P (self, AuthenticatorReceiverApp_private_offset);
}

AuthenticatorReceiverApp*
authenticator_receiver_app_construct (GType object_type)
{
	AuthenticatorReceiverApp * self = NULL;
	self = (AuthenticatorReceiverApp*) g_object_new (object_type, "application-id", "org.gnome.Shotwell", "flags", G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	return self;
}

AuthenticatorReceiverApp*
authenticator_receiver_app_new (void)
{
	return authenticator_receiver_app_construct (TYPE_AUTHENTICATOR_RECEIVER_APP);
}

static gboolean
authenticator_receiver_app_real_dbus_register (GApplication* base,
                                               GDBusConnection* connection,
                                               const gchar* object_path,
                                               GError** error)
{
	AuthenticatorReceiverApp * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverApp);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (connection, g_dbus_connection_get_type ()), FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		authenticator_receiver_app_register_object (self, connection, object_path, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp0_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp0_;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("Application.vala:25: Failed to register authentication helper on sessi" \
"on connection: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	result = TRUE;
	return result;
}

void
authenticator_receiver_app_register_auth_callback (AuthenticatorReceiverApp* self,
                                                   const gchar* cookie,
                                                   SpitPublishingAuthenticatedCallback* cb)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (IS_AUTHENTICATOR_RECEIVER_APP (self));
	g_return_if_fail (cookie != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cb, SPIT_PUBLISHING_TYPE_AUTHENTICATED_CALLBACK));
	_tmp0_ = self->priv->pending_auth_requests;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), cookie, cb);
}

void
authenticator_receiver_app_unregister_auth_callback (AuthenticatorReceiverApp* self,
                                                     const gchar* cookie)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (IS_AUTHENTICATOR_RECEIVER_APP (self));
	g_return_if_fail (cookie != NULL);
	_tmp0_ = self->priv->pending_auth_requests;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), cookie, NULL);
}

static void
authenticator_receiver_app_real_callback (AuthenticationReceiver* base,
                                          const gchar* callback_url,
                                          GError** error)
{
	AuthenticatorReceiverApp * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverApp);
	g_return_if_fail (callback_url != NULL);
	{
		GUri* uri = NULL;
		GUri* _tmp0_;
		gchar* query = NULL;
		GUri* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		GHashTable* uri_params = NULL;
		GUri* _tmp7_;
		const gchar* _tmp8_;
		GHashTable* _tmp9_;
		GHashTable* _tmp10_;
		_tmp0_ = g_uri_parse (callback_url, G_URI_FLAGS_NONE, &_inner_error0_);
		uri = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_debug ("Application.vala:42: Got authentication callback uri: %s", callback_url);
		_tmp1_ = uri;
		_tmp2_ = g_uri_get_query (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		query = _tmp3_;
		_tmp5_ = query;
		if (_tmp5_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = query;
			_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
		}
		if (_tmp4_) {
			g_debug ("Application.vala:46: Callback does not have parameters. Not accepting");
			_g_free0 (query);
			_g_uri_unref0 (uri);
			return;
		}
		_tmp7_ = uri;
		_tmp8_ = g_uri_get_query (_tmp7_);
		_tmp9_ = g_uri_parse_params (_tmp8_, (gsize) -1, "&;", 0, &_inner_error0_);
		uri_params = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (query);
			_g_uri_unref0 (uri);
			goto __catch0_g_error;
		}
		_tmp10_ = uri_params;
		if (g_hash_table_contains (_tmp10_, "sw_auth_cookie")) {
			gchar* cookie = NULL;
			GHashTable* _tmp11_;
			gconstpointer _tmp12_;
			gchar* _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			_tmp11_ = uri_params;
			_tmp12_ = g_hash_table_lookup (_tmp11_, "sw_auth_cookie");
			_tmp13_ = g_strdup ((const gchar*) _tmp12_);
			cookie = _tmp13_;
			_tmp14_ = self->priv->pending_auth_requests;
			_tmp15_ = cookie;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_)) {
				GeeHashMap* _tmp16_;
				const gchar* _tmp17_;
				gpointer _tmp18_;
				SpitPublishingAuthenticatedCallback* _tmp19_;
				GHashTable* _tmp20_;
				LibraryWindow* _tmp21_;
				LibraryWindow* _tmp22_;
				_tmp16_ = self->priv->pending_auth_requests;
				_tmp17_ = cookie;
				_tmp18_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp17_);
				_tmp19_ = (SpitPublishingAuthenticatedCallback*) _tmp18_;
				_tmp20_ = uri_params;
				spit_publishing_authenticated_callback_authenticated (_tmp19_, _tmp20_);
				_g_object_unref0 (_tmp19_);
				_tmp21_ = library_window_get_app ();
				_tmp22_ = _tmp21_;
				gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_window_get_type (), GtkWindow));
				_g_object_unref0 (_tmp22_);
			} else {
				const gchar* _tmp23_;
				_tmp23_ = cookie;
				g_debug ("Application.vala:57: No call-back registered for cookie %s, probably u" \
"ser cancelled", _tmp23_);
			}
			_g_free0 (cookie);
		} else {
			GUri* _tmp24_;
			const gchar* _tmp25_;
			_tmp24_ = uri;
			_tmp25_ = g_uri_get_scheme (_tmp24_);
			if (g_str_has_prefix (_tmp25_, "com.googleusercontent.apps")) {
				GeeHashMap* _tmp26_;
				GUri* _tmp27_;
				const gchar* _tmp28_;
				_tmp26_ = self->priv->pending_auth_requests;
				_tmp27_ = uri;
				_tmp28_ = g_uri_get_scheme (_tmp27_);
				if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp28_)) {
					GeeHashMap* _tmp29_;
					GUri* _tmp30_;
					const gchar* _tmp31_;
					gpointer _tmp32_;
					SpitPublishingAuthenticatedCallback* _tmp33_;
					GHashTable* _tmp34_;
					_tmp29_ = self->priv->pending_auth_requests;
					_tmp30_ = uri;
					_tmp31_ = g_uri_get_scheme (_tmp30_);
					_tmp32_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp31_);
					_tmp33_ = (SpitPublishingAuthenticatedCallback*) _tmp32_;
					_tmp34_ = uri_params;
					spit_publishing_authenticated_callback_authenticated (_tmp33_, _tmp34_);
					_g_object_unref0 (_tmp33_);
				} else {
					GUri* _tmp35_;
					const gchar* _tmp36_;
					_tmp35_ = uri;
					_tmp36_ = g_uri_get_scheme (_tmp35_);
					g_debug ("Application.vala:63: No call-back registered for cookie %s, probably u" \
"ser cancelled", _tmp36_);
				}
			}
		}
		_g_hash_table_unref0 (uri_params);
		_g_free0 (query);
		_g_uri_unref0 (uri);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("Application.vala:67: Got invalid authentication call-back: %s", callback_url);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
authenticator_receiver_app_class_init (AuthenticatorReceiverAppClass * klass,
                                       gpointer klass_data)
{
	authenticator_receiver_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AuthenticatorReceiverApp_private_offset);
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) authenticator_receiver_app_real_dbus_register;
	G_OBJECT_CLASS (klass)->finalize = authenticator_receiver_app_finalize;
}

static void
authenticator_receiver_app_authentication_receiver_interface_init (AuthenticationReceiverIface * iface,
                                                                   gpointer iface_data)
{
	authenticator_receiver_app_authentication_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->callback = (void (*) (AuthenticationReceiver*, const gchar*, GError**)) authenticator_receiver_app_real_callback;
}

static void
authenticator_receiver_app_instance_init (AuthenticatorReceiverApp * self,
                                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = authenticator_receiver_app_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SPIT_PUBLISHING_TYPE_AUTHENTICATED_CALLBACK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->pending_auth_requests = _tmp0_;
}

static void
authenticator_receiver_app_finalize (GObject * obj)
{
	AuthenticatorReceiverApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverApp);
	_g_object_unref0 (self->priv->pending_auth_requests);
	G_OBJECT_CLASS (authenticator_receiver_app_parent_class)->finalize (obj);
}

static GType
authenticator_receiver_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AuthenticatorReceiverAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) authenticator_receiver_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AuthenticatorReceiverApp), 0, (GInstanceInitFunc) authenticator_receiver_app_instance_init, NULL };
	static const GInterfaceInfo authentication_receiver_info = { (GInterfaceInitFunc) authenticator_receiver_app_authentication_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType authenticator_receiver_app_type_id;
	authenticator_receiver_app_type_id = g_type_register_static (gtk_application_get_type (), "AuthenticatorReceiverApp", &g_define_type_info, 0);
	g_type_add_interface_static (authenticator_receiver_app_type_id, TYPE_AUTHENTICATION_RECEIVER, &authentication_receiver_info);
	g_type_set_qdata (authenticator_receiver_app_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) authenticator_receiver_app_register_object);
	AuthenticatorReceiverApp_private_offset = g_type_add_instance_private (authenticator_receiver_app_type_id, sizeof (AuthenticatorReceiverAppPrivate));
	return authenticator_receiver_app_type_id;
}

GType
authenticator_receiver_app_get_type (void)
{
	static volatile gsize authenticator_receiver_app_type_id__once = 0;
	if (g_once_init_enter (&authenticator_receiver_app_type_id__once)) {
		GType authenticator_receiver_app_type_id;
		authenticator_receiver_app_type_id = authenticator_receiver_app_get_type_once ();
		g_once_init_leave (&authenticator_receiver_app_type_id__once, authenticator_receiver_app_type_id);
	}
	return authenticator_receiver_app_type_id__once;
}

static void
_dbus_authenticator_receiver_app_callback (AuthenticatorReceiverApp* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp25_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	authentication_receiver_callback (self, url, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (url);
	;
}

static void
authenticator_receiver_app_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Callback") == 0) {
		_dbus_authenticator_receiver_app_callback (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
authenticator_receiver_app_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
authenticator_receiver_app_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
authenticator_receiver_app_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_authenticator_receiver_app_dbus_interface_info), &_authenticator_receiver_app_dbus_interface_vtable, data, _authenticator_receiver_app_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_authenticator_receiver_app_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
application_get_instance_private (Application* self)
{
	return G_STRUCT_MEMBER_P (self, Application_private_offset);
}

void
application_set_raw_thumbs_fix_required (Application* self,
                                         gboolean should_fixup)
{
	g_return_if_fail (IS_APPLICATION (self));
	self->priv->fixup_raw_thumbs = should_fixup;
}

gboolean
application_get_raw_thumbs_fix_required (Application* self)
{
	gboolean result;
	g_return_val_if_fail (IS_APPLICATION (self), FALSE);
	result = self->priv->fixup_raw_thumbs;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkApplication*
application_get_system_app (Application* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GtkApplication* result;
	g_return_val_if_fail (IS_APPLICATION (self), NULL);
	_tmp0_ = self->priv->system_app;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint
_application_on_command_line_g_application_command_line (GApplication* _sender,
                                                         GApplicationCommandLine* command_line,
                                                         gpointer self)
{
	gint result;
	result = application_on_command_line (command_line);
	return result;
}

static void
___lambda38_ (Application* self,
              GSimpleAction* a,
              GVariant* p)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (a, g_simple_action_get_type ()));
	{
		GUri* uri = NULL;
		const gchar* _tmp0_;
		GUri* _tmp1_;
		const gchar* _tmp2_;
		GHashTable* uri_params = NULL;
		GUri* _tmp3_;
		const gchar* _tmp4_;
		GHashTable* _tmp5_;
		GHashTable* _tmp6_;
		_tmp0_ = g_variant_get_string (p, NULL);
		_tmp1_ = g_uri_parse (_tmp0_, G_URI_FLAGS_NONE, &_inner_error0_);
		uri = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_variant_get_string (p, NULL);
		g_debug ("Application.vala:140: Got authentication callback uri: %s", _tmp2_);
		_tmp3_ = uri;
		_tmp4_ = g_uri_get_query (_tmp3_);
		_tmp5_ = g_uri_parse_params (_tmp4_, (gsize) -1, "&;", 0, &_inner_error0_);
		uri_params = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_uri_unref0 (uri);
			goto __catch0_g_error;
		}
		_tmp6_ = uri_params;
		if (g_hash_table_contains (_tmp6_, "sw_auth_cookie")) {
			gchar* cookie = NULL;
			GHashTable* _tmp7_;
			gconstpointer _tmp8_;
			gchar* _tmp9_;
			GeeHashMap* _tmp10_;
			const gchar* _tmp11_;
			_tmp7_ = uri_params;
			_tmp8_ = g_hash_table_lookup (_tmp7_, "sw_auth_cookie");
			_tmp9_ = g_strdup ((const gchar*) _tmp8_);
			cookie = _tmp9_;
			_tmp10_ = self->priv->pending_auth_requests;
			_tmp11_ = cookie;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_)) {
				GeeHashMap* _tmp12_;
				const gchar* _tmp13_;
				gpointer _tmp14_;
				ApplicationAuthCallback* _tmp15_;
				GHashTable* _tmp16_;
				_tmp12_ = self->priv->pending_auth_requests;
				_tmp13_ = cookie;
				_tmp14_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_);
				_tmp15_ = (ApplicationAuthCallback*) _tmp14_;
				_tmp16_ = uri_params;
				application_auth_callback_authenticated (_tmp15_, _tmp16_);
				_g_object_unref0 (_tmp15_);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = cookie;
				g_debug ("Application.vala:148: No call-back registered for cookie %s, probably " \
"user cancelled", _tmp17_);
			}
			_g_free0 (cookie);
		}
		_g_hash_table_unref0 (uri_params);
		_g_uri_unref0 (uri);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp18_;
		g_clear_error (&_inner_error0_);
		_tmp18_ = g_variant_get_string (p, NULL);
		g_warning ("Application.vala:152: Got invalid authentication call-back: %s", _tmp18_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda38__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	___lambda38_ ((Application*) self, _sender, parameter);
}

static void
_application_on_activated_g_application_activate (GApplication* _sender,
                                                  gpointer self)
{
	application_on_activated ();
}

static void
_application_on_activated_g_application_startup (GApplication* _sender,
                                                 gpointer self)
{
	application_on_activated ();
}

static Application*
application_construct (GType object_type,
                       gboolean is_direct)
{
	Application* self = NULL;
	GtkApplication* _tmp9_;
	GtkApplication* _tmp10_;
	GError* _inner_error0_ = NULL;
	self = (Application*) g_type_create_instance (object_type);
	if (is_direct) {
		GtkApplication* _tmp0_;
		_tmp0_ = gtk_application_new ("org.gnome.Shotwell-Viewer", G_APPLICATION_HANDLES_OPEN | G_APPLICATION_NON_UNIQUE);
		_g_object_unref0 (self->priv->system_app);
		self->priv->system_app = _tmp0_;
	} else {
		AuthenticatorReceiverApp* _tmp1_;
		_tmp1_ = authenticator_receiver_app_new ();
		_g_object_unref0 (self->priv->system_app);
		self->priv->system_app = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_application_get_type (), GtkApplication);
	}
	{
		GtkApplication* _tmp2_;
		_tmp2_ = self->priv->system_app;
		g_application_register (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_application_get_type (), GApplication), NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		application_panic (self);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	self->priv->direct = is_direct;
	if (!self->priv->direct) {
		GtkApplication* _tmp3_;
		GSimpleAction* action = NULL;
		const GVariantType* _tmp4_;
		GSimpleAction* _tmp5_;
		GtkApplication* _tmp6_;
		GSimpleAction* _tmp7_;
		GSimpleAction* _tmp8_;
		_tmp3_ = self->priv->system_app;
		g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_application_get_type (), GApplication), "command-line", (GCallback) _application_on_command_line_g_application_command_line, NULL);
		_tmp4_ = G_VARIANT_TYPE_STRING;
		_tmp5_ = g_simple_action_new ("authenticated", _tmp4_);
		action = _tmp5_;
		_tmp6_ = self->priv->system_app;
		_tmp7_ = action;
		g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_action_get_type (), GAction));
		_tmp8_ = action;
		g_signal_connect (_tmp8_, "activate", (GCallback) ____lambda38__g_simple_action_activate, self);
		_g_object_unref0 (action);
	}
	_tmp9_ = self->priv->system_app;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_application_get_type (), GApplication), "activate", (GCallback) _application_on_activated_g_application_activate, NULL);
	_tmp10_ = self->priv->system_app;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_application_get_type (), GApplication), "startup", (GCallback) _application_on_activated_g_application_startup, NULL);
	return self;
}

static Application*
application_new (gboolean is_direct)
{
	return application_construct (TYPE_APPLICATION, is_direct);
}

void
application_register_auth_callback (const gchar* cookie,
                                    SpitPublishingAuthenticatedCallback* cb)
{
	Application* instance = NULL;
	Application* _tmp0_;
	Application* _tmp1_;
	g_return_if_fail (cookie != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cb, SPIT_PUBLISHING_TYPE_AUTHENTICATED_CALLBACK));
	_tmp0_ = application_get_instance ();
	instance = _tmp0_;
	_tmp1_ = instance;
	if (!_tmp1_->priv->direct) {
		Application* _tmp2_;
		GtkApplication* _tmp3_;
		_tmp2_ = instance;
		_tmp3_ = _tmp2_->priv->system_app;
		authenticator_receiver_app_register_auth_callback (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverApp), cookie, cb);
	}
	_application_unref0 (instance);
}

void
application_unregister_auth_callback (const gchar* cookie)
{
	Application* instance = NULL;
	Application* _tmp0_;
	Application* _tmp1_;
	g_return_if_fail (cookie != NULL);
	_tmp0_ = application_get_instance ();
	instance = _tmp0_;
	_tmp1_ = instance;
	if (!_tmp1_->priv->direct) {
		Application* _tmp2_;
		GtkApplication* _tmp3_;
		_tmp2_ = instance;
		_tmp3_ = _tmp2_->priv->system_app;
		authenticator_receiver_app_unregister_auth_callback (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_AUTHENTICATOR_RECEIVER_APP, AuthenticatorReceiverApp), cookie);
	}
	_application_unref0 (instance);
}

gdouble
application_get_scale (void)
{
	GtkApplication* instance = NULL;
	Application* _tmp0_;
	Application* _tmp1_;
	GtkApplication* _tmp2_;
	GtkApplication* _tmp3_;
	GtkApplication* _tmp4_;
	GList* windows = NULL;
	GtkApplication* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	gdouble result;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->system_app;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	_application_unref0 (_tmp1_);
	instance = _tmp4_;
	_tmp5_ = instance;
	_tmp6_ = gtk_application_get_windows (_tmp5_);
	windows = _tmp6_;
	_tmp7_ = windows;
	if (_tmp7_ == NULL) {
		result = 1.0;
		_g_object_unref0 (instance);
		return result;
	}
	_tmp8_ = windows;
	_tmp9_ = _tmp8_->data;
	result = (gdouble) gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp9_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (instance);
	return result;
}

/**
     * @brief This is a helper for library mode that should only be
     * called if we've gotten a camera mount and are _not_ the primary
     * instance.
     */
void
application_send_to_primary_instance (gchar** argv,
                                      gint argv_length1)
{
	Application* _tmp0_;
	Application* _tmp1_;
	GtkApplication* _tmp2_;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->system_app;
	g_application_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_application_get_type (), GApplication), (gint) argv_length1, argv);
	_application_unref0 (_tmp1_);
}

/**
     * @brief A helper for library mode that tells the primary
     * instance to bring its window to the foreground.  This
     * should only be called if we are _not_ the primary instance.
     */
void
application_present_primary_instance (void)
{
	Application* _tmp0_;
	Application* _tmp1_;
	GtkApplication* _tmp2_;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->system_app;
	g_application_activate (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_application_get_type (), GApplication));
	_application_unref0 (_tmp1_);
}

gboolean
application_get_is_remote (void)
{
	Application* _tmp0_;
	Application* _tmp1_;
	GtkApplication* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->system_app;
	_tmp3_ = g_application_get_is_remote (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_application_get_type (), GApplication));
	_application_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gboolean
application_get_is_direct (void)
{
	Application* _tmp0_;
	Application* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->direct;
	_application_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
application_set_accels_for_action (const gchar* action,
                                   gchar** accel,
                                   gint accel_length1)
{
	Application* _tmp0_;
	Application* _tmp1_;
	GtkApplication* _tmp2_;
	g_return_if_fail (action != NULL);
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->system_app;
	gtk_application_set_accels_for_action (_tmp2_, action, accel);
	_application_unref0 (_tmp1_);
}

void
application_set_menubar (GMenuModel* model)
{
	Application* _tmp0_;
	Application* _tmp1_;
	GtkApplication* _tmp2_;
	g_return_if_fail ((model == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (model, g_menu_model_get_type ()));
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->system_app;
	gtk_application_set_menubar (_tmp2_, model);
	_application_unref0 (_tmp1_);
}

/**
     * @brief Signal handler for GApplication's 'activate' signal.
     *
     * The most likely scenario for this to be fired is if the user
     * either tried to run us twice in library mode, or we've just gotten
     * a camera/removable-storage mount; in either case, the remote instance
     * will trigger this and exit, and we'll need to bring the window back up...
     */
void
application_on_activated (void)
{
	Application* _tmp0_;
	Application* _tmp1_;
	LibraryWindow* lw = NULL;
	AppWindow* _tmp2_;
	LibraryWindow* _tmp3_;
	gboolean _tmp4_ = FALSE;
	LibraryWindow* _tmp5_;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_application_unref0 (_tmp1_);
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = IS_LIBRARY_WINDOW (_tmp2_) ? ((LibraryWindow*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	lw = _tmp3_;
	_tmp5_ = lw;
	if (_tmp5_ != NULL) {
		_tmp4_ = !application_get_is_direct ();
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		LibraryWindow* _tmp6_;
		LibraryWindow* _tmp7_;
		_tmp6_ = library_window_get_app ();
		_tmp7_ = _tmp6_;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (_tmp7_);
	}
	_g_object_unref0 (lw);
}

/**
     * @brief Signal handler for GApplication's 'command-line' signal.
     *
     * Gets fired whenever a remote instance tries to run, usually
     * with an incoming camera connection.
     *
     * @note This does _not_ get called in direct-edit mode.
     */
gint
application_on_command_line (GApplicationCommandLine* acl)
{
	gchar** argv = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (acl, g_application_command_line_get_type ()), 0);
	_tmp1_ = g_application_command_line_get_arguments (acl, &_tmp0_);
	argv = _tmp1_;
	argv_length1 = _tmp0_;
	_argv_size_ = argv_length1;
	_tmp2_ = argv;
	_tmp2__length1 = argv_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = argv;
		_tmp3__length1 = argv_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp3_;
			s_collection_length1 = _tmp3__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				gchar* _tmp4_;
				gchar* s = NULL;
				_tmp4_ = g_strdup (s_collection[s_it]);
				s = _tmp4_;
				{
					LibraryWindow* lw = NULL;
					AppWindow* _tmp5_;
					LibraryWindow* _tmp6_;
					LibraryWindow* _tmp7_;
					_tmp5_ = app_window_get_instance ();
					_tmp6_ = IS_LIBRARY_WINDOW (_tmp5_) ? ((LibraryWindow*) _tmp5_) : NULL;
					if (_tmp6_ == NULL) {
						_g_object_unref0 (_tmp5_);
					}
					lw = _tmp6_;
					_tmp7_ = lw;
					if (_tmp7_ != NULL) {
						LibraryWindow* _tmp8_;
						const gchar* _tmp9_;
						_tmp8_ = lw;
						_tmp9_ = s;
						library_window_mounted_camera_shell_notification (_tmp8_, _tmp9_, FALSE);
					}
					_g_object_unref0 (lw);
					_g_free0 (s);
				}
			}
		}
	}
	application_on_activated ();
	result = 0;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * @brief Initializes the Shotwell application object and prepares
     * it for use.
     *
     * @param is_direct Whether the application was invoked in direct
     * or in library mode; defaults to FALSE, that is, library mode.
     *
     * @note This MUST be called prior to calling get_instance(), as the
     * application needs to know what mode it was brought up in; failure to
     * call this first will lead to an assertion.
     */
void
application_init (gboolean is_direct)
{
	Application* _tmp0_;
	_tmp0_ = application_instance;
	if (_tmp0_ == NULL) {
		Application* _tmp1_;
		_tmp1_ = application_new (is_direct);
		_application_unref0 (application_instance);
		application_instance = _tmp1_;
	}
}

void
application_terminate (void)
{
	Application* _tmp0_;
	Application* _tmp1_;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	application_exit (_tmp1_);
	_application_unref0 (_tmp1_);
}

static gpointer
_application_ref0 (gpointer self)
{
	return self ? application_ref (self) : NULL;
}

Application*
application_get_instance (void)
{
	Application* _tmp0_;
	Application* _tmp1_;
	Application* _tmp2_;
	Application* result;
	_tmp0_ = application_instance;
	_vala_assert (_tmp0_ != NULL, "instance != null");
	_tmp1_ = application_instance;
	_tmp2_ = _application_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
application_start (Application* self,
                   gchar** argv,
                   gint argv_length1)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	GtkApplication* _tmp2_;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	GtkApplication* _tmp5_;
	GtkApplication* _tmp8_;
	guint _tmp9_;
	GtkApplication* _tmp10_;
	guint _tmp11_;
	g_return_if_fail (IS_APPLICATION (self));
	if (self->priv->running) {
		return;
	}
	self->priv->running = TRUE;
	g_signal_emit (self, application_signals[APPLICATION_STARTING_SIGNAL], 0);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "AppWindow.get_instance() != null");
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->system_app;
	_tmp3_ = app_window_get_instance ();
	_tmp4_ = _tmp3_;
	gtk_application_add_window (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->system_app;
	self->priv->system_app_run_retval = g_application_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_application_get_type (), GApplication), (gint) argv_length1, argv);
	if (!self->priv->direct) {
		GtkApplication* _tmp6_;
		guint _tmp7_;
		_tmp6_ = self->priv->system_app;
		g_signal_parse_name ("command-line", g_application_get_type (), &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_application_get_type (), GApplication), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _application_on_command_line_g_application_command_line, NULL);
	}
	_tmp8_ = self->priv->system_app;
	g_signal_parse_name ("activate", g_application_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_application_get_type (), GApplication), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _application_on_activated_g_application_activate, NULL);
	_tmp10_ = self->priv->system_app;
	g_signal_parse_name ("startup", g_application_get_type (), &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_application_get_type (), GApplication), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _application_on_activated_g_application_startup, NULL);
	self->priv->running = FALSE;
}

void
application_exit (Application* self)
{
	gboolean _tmp0_ = FALSE;
	GtkApplication* _tmp1_;
	g_return_if_fail (IS_APPLICATION (self));
	if (self->priv->exiting_fired) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->running;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->exiting_fired = TRUE;
	g_signal_emit (self, application_signals[APPLICATION_EXITING_SIGNAL], 0, FALSE);
	_tmp1_ = self->priv->system_app;
	g_application_release (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_application_get_type (), GApplication));
}

void
application_panic (Application* self)
{
	g_return_if_fail (IS_APPLICATION (self));
	if (!self->priv->exiting_fired) {
		self->priv->exiting_fired = TRUE;
		g_signal_emit (self, application_signals[APPLICATION_EXITING_SIGNAL], 0, TRUE);
	}
	exit (1);
}

/**
     * @brief Allows the caller to ask for some part of the desktop session's functionality to
     * be prevented from running; wrapper for Gtk.Application.inhibit().
     *
     * @note The return value is a 'cookie' that needs to be passed to 'uninhibit' to turn
     * off a requested inhibition and should be saved by the caller.
     */
guint
application_inhibit (Application* self,
                     GtkApplicationInhibitFlags what,
                     const gchar* reason)
{
	GtkApplication* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	guint _tmp3_;
	guint result;
	g_return_val_if_fail (IS_APPLICATION (self), 0U);
	_tmp0_ = self->priv->system_app;
	_tmp1_ = app_window_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_application_inhibit (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow), what, reason);
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * @brief Turns off a previously-requested inhibition. Wrapper for
     * Gtk.Application.uninhibit().
     */
void
application_uninhibit (Application* self,
                       guint cookie)
{
	GtkApplication* _tmp0_;
	g_return_if_fail (IS_APPLICATION (self));
	_tmp0_ = self->priv->system_app;
	gtk_application_uninhibit (_tmp0_, cookie);
}

gint
application_get_run_return_value (Application* self)
{
	gint result;
	g_return_val_if_fail (IS_APPLICATION (self), 0);
	result = self->priv->system_app_run_retval;
	return result;
}

static void
application_real_starting (Application* self)
{
}

static void
application_real_exiting (Application* self,
                          gboolean panicked)
{
}

static void
application_real_init_done (Application* self)
{
}

void
application_auth_callback_authenticated (ApplicationAuthCallback* self,
                                         GHashTable* params)
{
	ApplicationAuthCallbackIface* _iface_;
	g_return_if_fail (APPLICATION_IS_AUTH_CALLBACK (self));
	_iface_ = APPLICATION_AUTH_CALLBACK_GET_INTERFACE (self);
	if (_iface_->authenticated) {
		_iface_->authenticated (self, params);
	}
}

static void
application_auth_callback_default_init (ApplicationAuthCallbackIface * iface,
                                        gpointer iface_data)
{
}

static GType
application_auth_callback_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationAuthCallbackIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_auth_callback_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType application_auth_callback_type_id;
	application_auth_callback_type_id = g_type_register_static (G_TYPE_INTERFACE, "ApplicationAuthCallback", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (application_auth_callback_type_id, G_TYPE_OBJECT);
	return application_auth_callback_type_id;
}

GType
application_auth_callback_get_type (void)
{
	static volatile gsize application_auth_callback_type_id__once = 0;
	if (g_once_init_enter (&application_auth_callback_type_id__once)) {
		GType application_auth_callback_type_id;
		application_auth_callback_type_id = application_auth_callback_get_type_once ();
		g_once_init_leave (&application_auth_callback_type_id__once, application_auth_callback_type_id);
	}
	return application_auth_callback_type_id__once;
}

static void
value_application_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_application_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		application_unref (value->data[0].v_pointer);
	}
}

static void
value_application_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = application_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_application_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_application_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Application * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = application_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_application_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	Application ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = application_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_application (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecApplication* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APPLICATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_application (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_application (GValue* value,
                       gpointer v_object)
{
	Application * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		application_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}

void
value_take_application (GValue* value,
                        gpointer v_object)
{
	Application * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}

static void
application_class_init (ApplicationClass * klass,
                        gpointer klass_data)
{
	application_parent_class = g_type_class_peek_parent (klass);
	((ApplicationClass *) klass)->finalize = application_finalize;
	g_type_class_adjust_private_offset (klass, &Application_private_offset);
	((ApplicationClass *) klass)->starting = application_real_starting;
	((ApplicationClass *) klass)->exiting = application_real_exiting;
	((ApplicationClass *) klass)->init_done = application_real_init_done;
	application_signals[APPLICATION_STARTING_SIGNAL] = g_signal_new ("starting", TYPE_APPLICATION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ApplicationClass, starting), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	application_signals[APPLICATION_EXITING_SIGNAL] = g_signal_new ("exiting", TYPE_APPLICATION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ApplicationClass, exiting), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	application_signals[APPLICATION_INIT_DONE_SIGNAL] = g_signal_new ("init-done", TYPE_APPLICATION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ApplicationClass, init_done), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
application_instance_init (Application * self,
                           gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = application_get_instance_private (self);
	self->priv->system_app = NULL;
	self->priv->system_app_run_retval = 0;
	self->priv->fixup_raw_thumbs = FALSE;
	self->priv->running = FALSE;
	self->priv->exiting_fired = FALSE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, APPLICATION_TYPE_AUTH_CALLBACK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->pending_auth_requests = _tmp0_;
	self->ref_count = 1;
}

static void
application_finalize (Application * obj)
{
	Application * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->system_app);
	_g_object_unref0 (self->priv->pending_auth_requests);
}

static GType
application_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_application_init, value_application_free_value, value_application_copy_value, value_application_peek_pointer, "p", value_application_collect_value, "p", value_application_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType application_type_id;
	application_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Application", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Application_private_offset = g_type_add_instance_private (application_type_id, sizeof (ApplicationPrivate));
	return application_type_id;
}

GType
application_get_type (void)
{
	static volatile gsize application_type_id__once = 0;
	if (g_once_init_enter (&application_type_id__once)) {
		GType application_type_id;
		application_type_id = application_get_type_once ();
		g_once_init_leave (&application_type_id__once, application_type_id);
	}
	return application_type_id__once;
}

gpointer
application_ref (gpointer instance)
{
	Application * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
application_unref (gpointer instance)
{
	Application * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APPLICATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

