/* AppWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from AppWindow.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <version.h>
#include <config.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>

#define FULLSCREEN_WINDOW_TOOLBAR_INVOCATION_MSEC 250
#define FULLSCREEN_WINDOW_TOOLBAR_DISMISSAL_SEC (2 * 1000000)
#define FULLSCREEN_WINDOW_TOOLBAR_CHECK_DISMISSAL_MSEC 500
#define RESOURCES_TRANSIENT_WINDOW_OPACITY 0.90
#define APP_WINDOW_DND_ICON_SCALE 128
#define RESOURCES_APP_TITLE "Shotwell"
#define COMMAND_MANAGER_DEFAULT_DEPTH 20
#define RESOURCES_GIT_VERSION _GIT_VERSION
#define RESOURCES_APP_VERSION _VERSION
#define RESOURCES_COPYRIGHT _ ("Copyright 2016 Software Freedom Conservancy Inc.")
#define RESOURCES_HOME_URL "https://wiki.gnome.org/Apps/Shotwell"
#define RESOURCES_LICENSE "\n" \
"Shotwell is free software; you can redistribute it and/or modify it un" \
"der the \n" \
"terms of the GNU Lesser General Public License as published by the Fre" \
"e \n" \
"Software Foundation; either version 2.1 of the License, or (at your op" \
"tion) \n" \
"any later version.\n" \
"\n" \
"Shotwell is distributed in the hope that it will be useful, but WITHOU" \
"T \n" \
"ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or " \
"FITNESS\n" \
"FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License f" \
"or \n" \
"more details.\n" \
"\n" \
"You should have received a copy of the GNU Lesser General Public Licen" \
"se \n" \
"along with Shotwell; if not, write to the Free Software Foundation, In" \
"c., \n" \
"51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA\n"
#define RESOURCES_ICON_ABOUT_LOGO "Delmenhorst_Rathaus.jpg"
#define RESOURCES_BUG_DB_URL "https://wiki.gnome.org/Apps/Shotwell/ReportingABug"
#define RESOURCES_FAQ_URL "https://wiki.gnome.org/Apps/Shotwell/FAQ"
#define RESOURCES_UNDO_MENU _ ("_Undo")
#define RESOURCES_REDO_MENU _ ("_Redo")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;
typedef struct _PageWindowPrivate PageWindowPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_FULLSCREEN_WINDOW (fullscreen_window_get_type ())
#define FULLSCREEN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FULLSCREEN_WINDOW, FullscreenWindow))
#define FULLSCREEN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FULLSCREEN_WINDOW, FullscreenWindowClass))
#define IS_FULLSCREEN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FULLSCREEN_WINDOW))
#define IS_FULLSCREEN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FULLSCREEN_WINDOW))
#define FULLSCREEN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FULLSCREEN_WINDOW, FullscreenWindowClass))

typedef struct _FullscreenWindow FullscreenWindow;
typedef struct _FullscreenWindowClass FullscreenWindowClass;
typedef struct _FullscreenWindowPrivate FullscreenWindowPrivate;
enum  {
	FULLSCREEN_WINDOW_0_PROPERTY,
	FULLSCREEN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* fullscreen_window_properties[FULLSCREEN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FULLSCREEN_WINDOW_TYPE_MONITOR (fullscreen_window_monitor_get_type ())
typedef struct _FullscreenWindowMonitor FullscreenWindowMonitor;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define TYPE_SINGLE_PHOTO_PAGE (single_photo_page_get_type ())
#define SINGLE_PHOTO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage))
#define SINGLE_PHOTO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPageClass))
#define IS_SINGLE_PHOTO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLE_PHOTO_PAGE))
#define IS_SINGLE_PHOTO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLE_PHOTO_PAGE))
#define SINGLE_PHOTO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPageClass))

typedef struct _SinglePhotoPage SinglePhotoPage;
typedef struct _SinglePhotoPageClass SinglePhotoPageClass;

#define TYPE_SLIDESHOW_PAGE (slideshow_page_get_type ())
#define SLIDESHOW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLIDESHOW_PAGE, SlideshowPage))
#define SLIDESHOW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLIDESHOW_PAGE, SlideshowPageClass))
#define IS_SLIDESHOW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLIDESHOW_PAGE))
#define IS_SLIDESHOW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLIDESHOW_PAGE))
#define SLIDESHOW_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLIDESHOW_PAGE, SlideshowPageClass))

typedef struct _SlideshowPage SlideshowPage;
typedef struct _SlideshowPageClass SlideshowPageClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
enum  {
	PAGE_WINDOW_0_PROPERTY,
	PAGE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* page_window_properties[PAGE_WINDOW_NUM_PROPERTIES];

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
typedef struct _AppWindowPrivate AppWindowPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
enum  {
	APP_WINDOW_0_PROPERTY,
	APP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* app_window_properties[APP_WINDOW_NUM_PROPERTIES];

#define TYPE_COMMAND_MANAGER (command_manager_get_type ())
#define COMMAND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMMAND_MANAGER, CommandManager))
#define COMMAND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMMAND_MANAGER, CommandManagerClass))
#define IS_COMMAND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMMAND_MANAGER))
#define IS_COMMAND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMMAND_MANAGER))
#define COMMAND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMMAND_MANAGER, CommandManagerClass))

typedef struct _CommandManager CommandManager;
typedef struct _CommandManagerClass CommandManagerClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;

#define TYPE_DIRECT_WINDOW (direct_window_get_type ())
#define DIRECT_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECT_WINDOW, DirectWindow))
#define DIRECT_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECT_WINDOW, DirectWindowClass))
#define IS_DIRECT_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECT_WINDOW))
#define IS_DIRECT_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECT_WINDOW))
#define DIRECT_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECT_WINDOW, DirectWindowClass))

typedef struct _DirectWindow DirectWindow;
typedef struct _DirectWindowClass DirectWindowClass;
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_CHECKERBOARD_PAGE (checkerboard_page_get_type ())
#define CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPage))
#define CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))
#define IS_CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_PAGE))
#define IS_CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_PAGE))
#define CHECKERBOARD_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))

typedef struct _CheckerboardPage CheckerboardPage;
typedef struct _CheckerboardPageClass CheckerboardPageClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_COMMAND_DESCRIPTION (command_description_get_type ())
#define COMMAND_DESCRIPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMMAND_DESCRIPTION, CommandDescription))
#define IS_COMMAND_DESCRIPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMMAND_DESCRIPTION))
#define COMMAND_DESCRIPTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_COMMAND_DESCRIPTION, CommandDescriptionIface))

typedef struct _CommandDescription CommandDescription;
typedef struct _CommandDescriptionIface CommandDescriptionIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PageWindow {
	GtkApplicationWindow parent_instance;
	PageWindowPrivate * priv;
};

struct _PageWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*switched_pages) (PageWindow* self, Page* old_page, Page* new_page);
	void (*set_current_page) (PageWindow* self, Page* page);
	void (*clear_current_page) (PageWindow* self);
};

struct _FullscreenWindow {
	PageWindow parent_instance;
	FullscreenWindowPrivate * priv;
};

struct _FullscreenWindowClass {
	PageWindowClass parent_class;
};

struct _FullscreenWindowPrivate {
	GtkOverlay* overlay;
	GtkToolbar* toolbar;
	GtkToolButton* close_button;
	GtkToggleToolButton* pin_button;
	gboolean is_toolbar_shown;
	gboolean waiting_for_invoke;
	gint64 left_toolbar_time;
	gboolean switched_to;
	gboolean is_toolbar_dismissal_enabled;
};

struct _FullscreenWindowMonitor {
	GdkScreen* screen;
	GdkMonitor* monitor;
	gint monitor_nr;
};

struct _PageWindowPrivate {
	Page* current_page;
	gint busy_counter;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _AppWindow {
	PageWindow parent_instance;
	AppWindowPrivate * priv;
	gboolean maximized;
	Dimensions dimensions;
};

struct _AppWindowClass {
	PageWindowClass parent_class;
	void (*on_fullscreen) (AppWindow* self);
	gchar* (*get_app_role) (AppWindow* self);
	void (*on_quit) (AppWindow* self);
	void (*add_actions) (AppWindow* self);
	void (*update_common_action_availability) (AppWindow* self, Page* old_page, Page* new_page);
	void (*update_common_actions) (AppWindow* self, Page* page, gint selected_count, gint count);
};

struct _CommandDescriptionIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (CommandDescription* self);
	gchar* (*get_explanation) (CommandDescription* self);
};

static gint FullscreenWindow_private_offset;
static gpointer fullscreen_window_parent_class = NULL;
static gint PageWindow_private_offset;
static gpointer page_window_parent_class = NULL;
static gpointer app_window_parent_class = NULL;
VALA_EXTERN AppWindow* app_window_instance;
AppWindow* app_window_instance = NULL;
static FullscreenWindow* app_window_fullscreen_window;
static FullscreenWindow* app_window_fullscreen_window = NULL;
static CommandManager* app_window_command_manager;
static CommandManager* app_window_command_manager = NULL;

VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType fullscreen_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FullscreenWindow, g_object_unref)
static void fullscreen_window_on_close (FullscreenWindow* self);
static void _fullscreen_window_on_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
VALA_EXTERN GType fullscreen_window_monitor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FullscreenWindowMonitor* fullscreen_window_monitor_dup (const FullscreenWindowMonitor* self);
VALA_EXTERN void fullscreen_window_monitor_free (FullscreenWindowMonitor* self);
VALA_EXTERN void fullscreen_window_monitor_copy (const FullscreenWindowMonitor* self,
                                     FullscreenWindowMonitor* dest);
VALA_EXTERN void fullscreen_window_monitor_destroy (FullscreenWindowMonitor* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FullscreenWindowMonitor, fullscreen_window_monitor_destroy)
VALA_EXTERN FullscreenWindow* fullscreen_window_new (Page* page,
                                         FullscreenWindowMonitor* monitor);
VALA_EXTERN FullscreenWindow* fullscreen_window_construct (GType object_type,
                                               Page* page,
                                               FullscreenWindowMonitor* monitor);
VALA_EXTERN PageWindow* page_window_construct (GType object_type);
VALA_EXTERN void page_window_set_current_page (PageWindow* self,
                                   Page* page);
VALA_EXTERN void application_set_accels_for_action (const gchar* action,
                                        gchar** accel,
                                        gint accel_length1);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self);
VALA_EXTERN void fullscreen_window_update_toolbar_dismissal (FullscreenWindow* self);
static void _fullscreen_window_update_toolbar_dismissal_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                                          gpointer self);
VALA_EXTERN GtkToolbar* page_get_toolbar (Page* self);
VALA_EXTERN GType single_photo_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SinglePhotoPage, g_object_unref)
VALA_EXTERN GType slideshow_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SlideshowPage, g_object_unref)
static void fullscreen_window_hide_toolbar (FullscreenWindow* self);
static void _fullscreen_window_hide_toolbar_slideshow_page_hide_toolbar (SlideshowPage* _sender,
                                                                  gpointer self);
VALA_EXTERN void page_set_cursor_hide_time (Page* self,
                                gint hide_time);
VALA_EXTERN void page_start_cursor_hiding (Page* self);
VALA_EXTERN void fullscreen_window_monitor_get_geometry (FullscreenWindowMonitor *self,
                                             GdkRectangle* result);
VALA_EXTERN gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self);
static void fullscreen_window_invoke_toolbar (FullscreenWindow* self);
VALA_EXTERN void fullscreen_window_disable_toolbar_dismissal (FullscreenWindow* self);
static gboolean fullscreen_window_real_configure_event (GtkWidget* base,
                                                 GdkEventConfigure* event);
VALA_EXTERN Page* page_window_get_current_page (PageWindow* self);
VALA_EXTERN void page_switched_to (Page* self);
static gboolean fullscreen_window_real_key_press_event (GtkWidget* base,
                                                 GdkEventKey* event);
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self,
                                                 gboolean state);
VALA_EXTERN void app_window_end_fullscreen (AppWindow* self);
VALA_EXTERN void fullscreen_window_close (FullscreenWindow* self);
static void fullscreen_window_real_destroy (GtkWidget* base);
VALA_EXTERN void page_window_clear_current_page (PageWindow* self);
VALA_EXTERN void page_stop_cursor_hiding (Page* self);
VALA_EXTERN void page_switching_from (Page* self);
static gboolean fullscreen_window_real_delete_event (GtkWidget* base,
                                              GdkEventAny* event);
static gboolean fullscreen_window_real_motion_notify_event (GtkWidget* base,
                                                     GdkEventMotion* event);
static gboolean fullscreen_window_is_pointer_in_toolbar (FullscreenWindow* self);
static gboolean fullscreen_window_on_check_toolbar_invocation (FullscreenWindow* self);
static gboolean _fullscreen_window_on_check_toolbar_invocation_gsource_func (gpointer self);
static gboolean fullscreen_window_on_check_toolbar_dismissal (FullscreenWindow* self);
static gboolean _fullscreen_window_on_check_toolbar_dismissal_gsource_func (gpointer self);
static void fullscreen_window_finalize (GObject * obj);
static GType fullscreen_window_get_type_once (void);
VALA_EXTERN void page_window_switched_pages (PageWindow* self,
                                 Page* old_page,
                                 Page* new_page);
static void page_window_real_switched_pages (PageWindow* self,
                                      Page* old_page,
                                      Page* new_page);
VALA_EXTERN gpointer application_ref (gpointer instance);
VALA_EXTERN void application_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_application (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_application (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_application (const GValue* value);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, application_unref)
VALA_EXTERN Application* application_get_instance (void);
VALA_EXTERN GtkApplication* application_get_system_app (Application* self);
static void page_window_real_set_current_page (PageWindow* self,
                                        Page* page);
VALA_EXTERN void page_clear_container (Page* self);
VALA_EXTERN void page_set_container (Page* self,
                         GtkWindow* container);
static void page_window_real_clear_current_page (PageWindow* self);
static gboolean page_window_real_key_press_event (GtkWidget* base,
                                           GdkEventKey* event);
VALA_EXTERN gboolean page_notify_app_key_pressed (Page* self,
                                      GdkEventKey* event);
static gboolean page_window_real_key_release_event (GtkWidget* base,
                                             GdkEventKey* event);
VALA_EXTERN gboolean page_notify_app_key_released (Page* self,
                                       GdkEventKey* event);
static gboolean page_window_real_focus_in_event (GtkWidget* base,
                                          GdkEventFocus* event);
VALA_EXTERN gboolean page_notify_app_focus_in (Page* self,
                                   GdkEventFocus* event);
static gboolean page_window_real_focus_out_event (GtkWidget* base,
                                           GdkEventFocus* event);
VALA_EXTERN gboolean page_notify_app_focus_out (Page* self,
                                    GdkEventFocus* event);
static gboolean page_window_real_configure_event (GtkWidget* base,
                                           GdkEventConfigure* event);
VALA_EXTERN gboolean page_notify_configure_event (Page* self,
                                      GdkEventConfigure* event);
VALA_EXTERN void page_window_set_busy_cursor (PageWindow* self);
VALA_EXTERN void page_window_set_normal_cursor (PageWindow* self);
static void page_window_finalize (GObject * obj);
static GType page_window_get_type_once (void);
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN void app_window_on_fullscreen (AppWindow* self);
VALA_EXTERN gchar* app_window_get_app_role (AppWindow* self);
VALA_EXTERN void app_window_on_quit (AppWindow* self);
VALA_EXTERN void app_window_add_actions (AppWindow* self);
VALA_EXTERN void app_window_update_common_action_availability (AppWindow* self,
                                                   Page* old_page,
                                                   Page* new_page);
VALA_EXTERN void app_window_update_common_actions (AppWindow* self,
                                       Page* page,
                                       gint selected_count,
                                       gint count);
VALA_EXTERN void app_window_on_about (AppWindow* self);
static void _app_window_on_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void _app_window_on_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void _app_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_on_help_contents (AppWindow* self);
static void _app_window_on_help_contents_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void app_window_on_help_faq (AppWindow* self);
static void _app_window_on_help_faq_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void app_window_on_help_report_problem (AppWindow* self);
static void _app_window_on_help_report_problem_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void app_window_on_undo (AppWindow* self);
static void _app_window_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void app_window_on_redo (AppWindow* self);
static void _app_window_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN void app_window_on_jump_to_file (AppWindow* self);
static void _app_window_on_jump_to_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void app_window_on_select_all (AppWindow* self);
static void _app_window_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_on_select_none (AppWindow* self);
static void _app_window_on_select_none_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
VALA_EXTERN gpointer command_manager_ref (gpointer instance);
VALA_EXTERN void command_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_command_manager (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_command_manager (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_command_manager (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_command_manager (const GValue* value);
VALA_EXTERN GType command_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CommandManager, command_manager_unref)
VALA_EXTERN AppWindow* app_window_construct (GType object_type);
VALA_EXTERN GType library_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryWindow, g_object_unref)
VALA_EXTERN void configuration_facade_get_library_window_state (ConfigurationFacade* self,
                                                    gboolean* maximize,
                                                    Dimensions* dimensions);
VALA_EXTERN GType direct_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectWindow, g_object_unref)
VALA_EXTERN void configuration_facade_get_direct_window_state (ConfigurationFacade* self,
                                                   gboolean* maximize,
                                                   Dimensions* dimensions);
VALA_EXTERN CommandManager* command_manager_new (gint depth);
VALA_EXTERN CommandManager* command_manager_construct (GType object_type,
                                           gint depth);
static void app_window_on_command_manager_altered (AppWindow* self);
static void _app_window_on_command_manager_altered_command_manager_altered (CommandManager* _sender,
                                                                     gboolean can_undo,
                                                                     gboolean can_redo,
                                                                     gpointer self);
static void app_window_real_on_fullscreen (AppWindow* self);
VALA_EXTERN gboolean app_window_has_instance (void);
VALA_EXTERN FullscreenWindow* app_window_get_fullscreen (void);
VALA_EXTERN void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
VALA_EXTERN void app_window_error_message_with_title (const gchar* title,
                                          const gchar* message,
                                          GtkWindow* parent,
                                          gboolean should_escape);
VALA_EXTERN gchar* build_alert_body_text (const gchar* primary_text,
                              const gchar* secondary_text,
                              gboolean should_escape);
VALA_EXTERN gboolean app_window_negate_affirm_question (const gchar* message,
                                            const gchar* negative,
                                            const gchar* affirmative,
                                            const gchar* title,
                                            GtkWindow* parent);
VALA_EXTERN GtkResponseType app_window_negate_affirm_cancel_question (const gchar* message,
                                                          const gchar* negative,
                                                          const gchar* affirmative,
                                                          const gchar* title,
                                                          GtkWindow* parent);
VALA_EXTERN GtkResponseType app_window_affirm_cancel_question (const gchar* message,
                                                   const gchar* affirmative,
                                                   const gchar* title,
                                                   GtkWindow* parent);
VALA_EXTERN gint app_window_export_overwrite_or_replace_question (const gchar* message,
                                                      const gchar* alt1,
                                                      const gchar* alt2,
                                                      const gchar* alt4,
                                                      const gchar* alt6,
                                                      const gchar* title,
                                                      GtkWindow* parent);
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN void app_window_panic (const gchar* msg);
VALA_EXTERN void application_panic (Application* self);
static gchar* app_window_real_get_app_role (AppWindow* self);
VALA_EXTERN GdkPixbuf* resources_get_icon (const gchar* name,
                               gint scale);
VALA_EXTERN void resources_launch_help (GtkWindow* window,
                            const gchar* anchor,
                            GError** error);
VALA_EXTERN void app_window_show_uri (AppWindow* self,
                          const gchar* url,
                          GError** error);
static void app_window_real_on_quit (AppWindow* self);
VALA_EXTERN void application_exit (Application* self);
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
VALA_EXTERN ViewCollection* page_get_view (Page* self);
VALA_EXTERN gint view_collection_get_selected_count (ViewCollection* self);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN DataView* view_collection_get_selected_at (ViewCollection* self,
                                           gint index);
VALA_EXTERN DataSource* data_view_get_source (DataView* self);
VALA_EXTERN void app_window_show_file_uri (AppWindow* self,
                               GFile* file,
                               GError** error);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN gchar* resources_jump_to_file_failed (GError* err);
static void app_window_real_destroy (GtkWidget* base);
VALA_EXTERN void show_file_in_filemanager (GFile* file,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void show_file_in_filemanager_finish (GAsyncResult* _res_,
                                      GError** error);
static void app_window_real_add_actions (AppWindow* self);
VALA_EXTERN void app_window_go_fullscreen (AppWindow* self,
                               Page* page);
VALA_EXTERN void page_switching_to_fullscreen (Page* self,
                                   FullscreenWindow* fsw);
VALA_EXTERN void page_returning_from_fullscreen (Page* self,
                                     FullscreenWindow* fsw);
VALA_EXTERN GAction* app_window_get_common_action (AppWindow* self,
                                       const gchar* name);
VALA_EXTERN void app_window_set_common_action_sensitive (AppWindow* self,
                                             const gchar* name,
                                             gboolean sensitive);
VALA_EXTERN void app_window_set_common_action_important (AppWindow* self,
                                             const gchar* name,
                                             gboolean important);
VALA_EXTERN void app_window_set_common_action_visible (AppWindow* self,
                                           const gchar* name,
                                           gboolean visible);
static void app_window_real_switched_pages (PageWindow* base,
                                     Page* old_page,
                                     Page* new_page);
static void app_window_on_update_common_actions (AppWindow* self);
static void _app_window_on_update_common_actions_data_collection_contents_altered (DataCollection* _sender,
                                                                            GeeIterable* added,
                                                                            GeeIterable* removed,
                                                                            gpointer self);
static void _app_window_on_update_common_actions_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                                   gpointer self);
static void _app_window_on_update_common_actions_view_collection_items_state_changed (ViewCollection* _sender,
                                                                               GeeIterable* changed,
                                                                               gpointer self);
VALA_EXTERN gint data_collection_get_count (DataCollection* self);
static void app_window_real_update_common_action_availability (AppWindow* self,
                                                        Page* old_page,
                                                        Page* new_page);
VALA_EXTERN GType checkerboard_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardPage, g_object_unref)
static void app_window_real_update_common_actions (AppWindow* self,
                                            Page* page,
                                            gint selected_count,
                                            gint count);
VALA_EXTERN void app_window_decorate_undo_action (AppWindow* self);
VALA_EXTERN void app_window_decorate_redo_action (AppWindow* self);
VALA_EXTERN void app_window_update_menu_item_label (AppWindow* self,
                                        const gchar* id,
                                        const gchar* new_label);
VALA_EXTERN GMenuModel* page_get_menubar (Page* self);
VALA_EXTERN CommandManager* app_window_get_command_manager (void);
VALA_EXTERN GType command_description_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CommandDescription, g_object_unref)
static void app_window_decorate_command_manager_action (AppWindow* self,
                                                 const gchar* name,
                                                 const gchar* prefix,
                                                 const gchar* default_explanation,
                                                 CommandDescription* desc);
VALA_EXTERN gchar* command_description_get_name (CommandDescription* self);
VALA_EXTERN CommandDescription* command_manager_get_undo_description (CommandManager* self);
VALA_EXTERN CommandDescription* command_manager_get_redo_description (CommandManager* self);
VALA_EXTERN gboolean command_manager_undo (CommandManager* self);
VALA_EXTERN gboolean command_manager_redo (CommandManager* self);
VALA_EXTERN void view_collection_select_all (ViewCollection* self);
VALA_EXTERN void view_collection_unselect_all (ViewCollection* self);
static gboolean app_window_real_configure_event (GtkWidget* base,
                                          GdkEventConfigure* event);
static void app_window_finalize (GObject * obj);
static GType app_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry FULLSCREEN_WINDOW_entries[1] = {{"LeaveFullscreen", _fullscreen_window_on_close_gsimple_action_activate_callback}};
static const GActionEntry APP_WINDOW_common_actions[11] = {{"CommonAbout", _app_window_on_about_gsimple_action_activate_callback}, {"CommonQuit", _app_window_on_quit_gsimple_action_activate_callback}, {"CommonFullscreen", _app_window_on_fullscreen_gsimple_action_activate_callback}, {"CommonHelpContents", _app_window_on_help_contents_gsimple_action_activate_callback}, {"CommonHelpFAQ", _app_window_on_help_faq_gsimple_action_activate_callback}, {"CommonHelpReportProblem", _app_window_on_help_report_problem_gsimple_action_activate_callback}, {"CommonUndo", _app_window_on_undo_gsimple_action_activate_callback}, {"CommonRedo", _app_window_on_redo_gsimple_action_activate_callback}, {"CommonJumpToFile", _app_window_on_jump_to_file_gsimple_action_activate_callback}, {"CommonSelectAll", _app_window_on_select_all_gsimple_action_activate_callback}, {"CommonSelectNone", _app_window_on_select_none_gsimple_action_activate_callback}};
VALA_EXTERN const gchar* RESOURCES_AUTHORS[6];

static inline gpointer
fullscreen_window_get_instance_private (FullscreenWindow* self)
{
	return G_STRUCT_MEMBER_P (self, FullscreenWindow_private_offset);
}

static void
_fullscreen_window_on_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	fullscreen_window_on_close ((FullscreenWindow*) self);
}

static void
_fullscreen_window_update_toolbar_dismissal_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                                     gpointer self)
{
	fullscreen_window_update_toolbar_dismissal ((FullscreenWindow*) self);
}

static void
_fullscreen_window_hide_toolbar_slideshow_page_hide_toolbar (SlideshowPage* _sender,
                                                             gpointer self)
{
	fullscreen_window_hide_toolbar ((FullscreenWindow*) self);
}

FullscreenWindow*
fullscreen_window_construct (GType object_type,
                             Page* page,
                             FullscreenWindowMonitor* monitor)
{
	FullscreenWindow * self = NULL;
	static const gchar* accels[2] = {"F11", NULL};
	FullscreenWindowMonitor _tmp0_;
	GdkScreen* _tmp1_;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	GtkToggleToolButton* _tmp4_;
	GtkToggleToolButton* _tmp5_;
	GtkToggleToolButton* _tmp6_;
	GtkToggleToolButton* _tmp7_;
	GtkToggleToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* _tmp10_;
	GtkToolButton* _tmp11_;
	GtkToolbar* _tmp12_;
	GtkToolbar* _tmp13_;
	GtkToolbar* _tmp14_;
	GtkToolbar* _tmp15_;
	GtkToolbar* _tmp16_;
	GtkToolbar* _tmp17_;
	GtkToolbar* _tmp20_;
	GtkToolButton* _tmp21_;
	GtkOverlay* _tmp22_;
	GtkOverlay* _tmp23_;
	GtkOverlay* _tmp24_;
	GtkToolbar* _tmp25_;
	GdkRectangle monitor_geometry = {0};
	GdkRectangle _tmp26_ = {0};
	GdkRectangle _tmp27_;
	GdkRectangle _tmp28_;
	FullscreenWindowMonitor _tmp29_;
	GdkScreen* _tmp30_;
	FullscreenWindowMonitor _tmp31_;
	gboolean _tmp32_ = FALSE;
	ConfigFacade* _tmp33_;
	ConfigFacade* _tmp34_;
	gboolean _tmp35_;
	g_return_val_if_fail (IS_PAGE (page), NULL);
	g_return_val_if_fail (monitor != NULL, NULL);
	self = (FullscreenWindow*) page_window_construct (object_type);
	page_window_set_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), page);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), FULLSCREEN_WINDOW_entries, (gint) G_N_ELEMENTS (FULLSCREEN_WINDOW_entries), self);
	application_set_accels_for_action ("win.LeaveFullscreen", accels, (gint) G_N_ELEMENTS (accels));
	_tmp0_ = *monitor;
	_tmp1_ = _tmp0_.screen;
	gtk_window_set_screen (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp1_);
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), (guint) 0);
	_tmp2_ = config_facade_get_instance ();
	_tmp3_ = _tmp2_;
	self->priv->is_toolbar_dismissal_enabled = configuration_facade_get_pin_toolbar_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->pin_button;
	gtk_tool_button_set_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_tool_button_get_type (), GtkToolButton), "view-pin-symbolic");
	_tmp5_ = self->priv->pin_button;
	gtk_tool_button_set_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_tool_button_get_type (), GtkToolButton), _ ("Pin Toolbar"));
	_tmp6_ = self->priv->pin_button;
	gtk_tool_item_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tool_item_get_type (), GtkToolItem), _ ("Pin the toolbar open"));
	_tmp7_ = self->priv->pin_button;
	gtk_toggle_tool_button_set_active (_tmp7_, !self->priv->is_toolbar_dismissal_enabled);
	_tmp8_ = self->priv->pin_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_tool_button_get_type (), GtkToolButton), "clicked", (GCallback) _fullscreen_window_update_toolbar_dismissal_gtk_tool_button_clicked, self, 0);
	_tmp9_ = self->priv->close_button;
	gtk_tool_button_set_icon_name (_tmp9_, "view-restore-symbolic");
	_tmp10_ = self->priv->close_button;
	gtk_tool_item_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_tool_item_get_type (), GtkToolItem), _ ("Leave fullscreen"));
	_tmp11_ = self->priv->close_button;
	gtk_actionable_set_action_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_actionable_get_type (), GtkActionable), "win.LeaveFullscreen");
	_tmp12_ = page_get_toolbar (page);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp12_;
	_tmp13_ = self->priv->toolbar;
	gtk_toolbar_set_show_arrow (_tmp13_, FALSE);
	_tmp14_ = self->priv->toolbar;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
	_tmp15_ = self->priv->toolbar;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp16_ = self->priv->toolbar;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), "expand", FALSE, NULL);
	_tmp17_ = self->priv->toolbar;
	gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), RESOURCES_TRANSIENT_WINDOW_OPACITY);
	if (IS_SLIDESHOW_PAGE (page)) {
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (page, TYPE_SLIDESHOW_PAGE, SlideshowPage), "hide-toolbar", (GCallback) _fullscreen_window_hide_toolbar_slideshow_page_hide_toolbar, self, 0);
	} else {
		GtkToolbar* _tmp18_;
		GtkToggleToolButton* _tmp19_;
		_tmp18_ = self->priv->toolbar;
		_tmp19_ = self->priv->pin_button;
		gtk_toolbar_insert (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_tool_item_get_type (), GtkToolItem), -1);
	}
	page_set_cursor_hide_time (page, FULLSCREEN_WINDOW_TOOLBAR_DISMISSAL_SEC * 1000);
	page_start_cursor_hiding (page);
	_tmp20_ = self->priv->toolbar;
	_tmp21_ = self->priv->close_button;
	gtk_toolbar_insert (_tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_tool_item_get_type (), GtkToolItem), -1);
	_tmp22_ = self->priv->overlay;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
	_tmp23_ = self->priv->overlay;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (page, gtk_widget_get_type (), GtkWidget));
	_tmp24_ = self->priv->overlay;
	_tmp25_ = self->priv->toolbar;
	gtk_overlay_add_overlay (_tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
	fullscreen_window_monitor_get_geometry (monitor, &_tmp26_);
	monitor_geometry = _tmp26_;
	_tmp27_ = monitor_geometry;
	_tmp28_ = monitor_geometry;
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp27_.width, _tmp28_.height);
	_tmp29_ = *monitor;
	_tmp30_ = _tmp29_.screen;
	_tmp31_ = *monitor;
	gtk_window_fullscreen_on_monitor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp30_, _tmp31_.monitor_nr);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_POINTER_MOTION_MASK);
	_tmp33_ = config_facade_get_instance ();
	_tmp34_ = _tmp33_;
	_tmp35_ = configuration_facade_get_display_toolbar (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp34_);
	if (_tmp35_) {
		_tmp32_ = TRUE;
	} else {
		_tmp32_ = !self->priv->is_toolbar_dismissal_enabled;
	}
	if (_tmp32_) {
		fullscreen_window_invoke_toolbar (self);
	} else {
		fullscreen_window_hide_toolbar (self);
	}
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (page, gtk_widget_get_type (), GtkWidget));
	gtk_application_window_set_show_menubar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), FALSE);
	return self;
}

FullscreenWindow*
fullscreen_window_new (Page* page,
                       FullscreenWindowMonitor* monitor)
{
	return fullscreen_window_construct (TYPE_FULLSCREEN_WINDOW, page, monitor);
}

void
fullscreen_window_disable_toolbar_dismissal (FullscreenWindow* self)
{
	g_return_if_fail (IS_FULLSCREEN_WINDOW (self));
	self->priv->is_toolbar_dismissal_enabled = FALSE;
}

void
fullscreen_window_update_toolbar_dismissal (FullscreenWindow* self)
{
	GtkToggleToolButton* _tmp0_;
	g_return_if_fail (IS_FULLSCREEN_WINDOW (self));
	_tmp0_ = self->priv->pin_button;
	self->priv->is_toolbar_dismissal_enabled = !gtk_toggle_tool_button_get_active (_tmp0_);
}

static gboolean
fullscreen_window_real_configure_event (GtkWidget* base,
                                        GdkEventConfigure* event)
{
	FullscreenWindow * self;
	gboolean _result_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_result_ = GTK_WIDGET_CLASS (fullscreen_window_parent_class)->configure_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), gtk_widget_get_type (), GtkWidget), event);
	if (!self->priv->switched_to) {
		Page* _tmp0_;
		Page* _tmp1_;
		_tmp0_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
		_tmp1_ = _tmp0_;
		page_switched_to (_tmp1_);
		_g_object_unref0 (_tmp1_);
		self->priv->switched_to = TRUE;
	}
	result = _result_;
	return result;
}

static gboolean
fullscreen_window_real_key_press_event (GtkWidget* base,
                                        GdkEventKey* event)
{
	FullscreenWindow * self;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (event->keyval);
	if (g_strcmp0 (_tmp0_, "Escape") == 0) {
		fullscreen_window_on_close (self);
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (fullscreen_window_parent_class)->key_press_event != NULL) {
		_tmp1_ = GTK_WIDGET_CLASS (fullscreen_window_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), "key-press-event", event, &_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static void
fullscreen_window_on_close (FullscreenWindow* self)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	g_return_if_fail (IS_FULLSCREEN_WINDOW (self));
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	configuration_facade_set_pin_toolbar_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), self->priv->is_toolbar_dismissal_enabled);
	_g_object_unref0 (_tmp1_);
	fullscreen_window_hide_toolbar (self);
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	app_window_end_fullscreen (_tmp3_);
	_g_object_unref0 (_tmp3_);
}

void
fullscreen_window_close (FullscreenWindow* self)
{
	g_return_if_fail (IS_FULLSCREEN_WINDOW (self));
	fullscreen_window_on_close (self);
}

static void
fullscreen_window_real_destroy (GtkWidget* base)
{
	FullscreenWindow * self;
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	_tmp0_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	page = _tmp0_;
	page_window_clear_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp1_ = page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		Page* _tmp3_;
		_tmp2_ = page;
		page_stop_cursor_hiding (_tmp2_);
		_tmp3_ = page;
		page_switching_from (_tmp3_);
	}
	GTK_WIDGET_CLASS (fullscreen_window_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (page);
}

static gboolean
fullscreen_window_real_delete_event (GtkWidget* base,
                                     GdkEventAny* event)
{
	FullscreenWindow * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	fullscreen_window_on_close (self);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
_fullscreen_window_on_check_toolbar_invocation_gsource_func (gpointer self)
{
	gboolean result;
	result = fullscreen_window_on_check_toolbar_invocation ((FullscreenWindow*) self);
	return result;
}

static gboolean
fullscreen_window_real_motion_notify_event (GtkWidget* base,
                                            GdkEventMotion* event)
{
	FullscreenWindow * self;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->is_toolbar_shown) {
		gboolean _tmp0_ = FALSE;
		if (!self->priv->waiting_for_invoke) {
			_tmp0_ = fullscreen_window_is_pointer_in_toolbar (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) FULLSCREEN_WINDOW_TOOLBAR_INVOCATION_MSEC, _fullscreen_window_on_check_toolbar_invocation_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->waiting_for_invoke = TRUE;
		}
	}
	if (GTK_WIDGET_CLASS (fullscreen_window_parent_class)->motion_notify_event != NULL) {
		_tmp1_ = GTK_WIDGET_CLASS (fullscreen_window_parent_class)->motion_notify_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
fullscreen_window_is_pointer_in_toolbar (FullscreenWindow* self)
{
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	GdkSeat* _tmp3_;
	gint py = 0;
	GdkSeat* _tmp4_;
	GdkDevice* _tmp5_;
	gint _tmp6_ = 0;
	GdkSeat* _tmp7_;
	GdkDisplay* _tmp8_;
	GtkToolbar* _tmp9_;
	GdkDisplay* _tmp10_;
	gint wy = 0;
	GtkToolbar* _tmp11_;
	GdkWindow* _tmp12_;
	gint _tmp13_ = 0;
	gboolean result;
	g_return_val_if_fail (IS_FULLSCREEN_WINDOW (self), FALSE);
	_tmp0_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	seat = _tmp2_;
	_tmp3_ = seat;
	if (_tmp3_ == NULL) {
		g_debug ("AppWindow.vala:197: No seat for display");
		result = FALSE;
		_g_object_unref0 (seat);
		return result;
	}
	_tmp4_ = seat;
	_tmp5_ = gdk_seat_get_pointer (_tmp4_);
	gdk_device_get_position (_tmp5_, NULL, NULL, &_tmp6_);
	py = _tmp6_;
	_tmp7_ = seat;
	_tmp8_ = gdk_seat_get_display (_tmp7_);
	_tmp9_ = self->priv->toolbar;
	_tmp10_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	if (_tmp8_ != _tmp10_) {
		result = FALSE;
		_g_object_unref0 (seat);
		return result;
	}
	_tmp11_ = self->priv->toolbar;
	_tmp12_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	gdk_window_get_geometry (_tmp12_, NULL, &_tmp13_, NULL, NULL);
	wy = _tmp13_;
	result = py >= wy;
	_g_object_unref0 (seat);
	return result;
}

static gboolean
fullscreen_window_on_check_toolbar_invocation (FullscreenWindow* self)
{
	gboolean result;
	g_return_val_if_fail (IS_FULLSCREEN_WINDOW (self), FALSE);
	self->priv->waiting_for_invoke = FALSE;
	if (self->priv->is_toolbar_shown) {
		result = FALSE;
		return result;
	}
	if (!fullscreen_window_is_pointer_in_toolbar (self)) {
		result = FALSE;
		return result;
	}
	fullscreen_window_invoke_toolbar (self);
	result = FALSE;
	return result;
}

static gboolean
_fullscreen_window_on_check_toolbar_dismissal_gsource_func (gpointer self)
{
	gboolean result;
	result = fullscreen_window_on_check_toolbar_dismissal ((FullscreenWindow*) self);
	return result;
}

static void
fullscreen_window_invoke_toolbar (FullscreenWindow* self)
{
	GtkToolbar* _tmp0_;
	g_return_if_fail (IS_FULLSCREEN_WINDOW (self));
	_tmp0_ = self->priv->toolbar;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	self->priv->is_toolbar_shown = TRUE;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) FULLSCREEN_WINDOW_TOOLBAR_CHECK_DISMISSAL_MSEC, _fullscreen_window_on_check_toolbar_dismissal_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
fullscreen_window_on_check_toolbar_dismissal (FullscreenWindow* self)
{
	gint64 now = 0LL;
	gboolean result;
	g_return_val_if_fail (IS_FULLSCREEN_WINDOW (self), FALSE);
	if (!self->priv->is_toolbar_shown) {
		result = FALSE;
		return result;
	}
	if (!self->priv->is_toolbar_dismissal_enabled) {
		result = TRUE;
		return result;
	}
	if (fullscreen_window_is_pointer_in_toolbar (self)) {
		self->priv->left_toolbar_time = (gint64) 0;
		result = TRUE;
		return result;
	}
	if (self->priv->left_toolbar_time == ((gint64) 0)) {
		self->priv->left_toolbar_time = g_get_monotonic_time ();
		result = TRUE;
		return result;
	}
	now = g_get_monotonic_time ();
	_vala_assert (now >= self->priv->left_toolbar_time, "now >= left_toolbar_time");
	if ((now - self->priv->left_toolbar_time) < ((gint64) FULLSCREEN_WINDOW_TOOLBAR_DISMISSAL_SEC)) {
		result = TRUE;
		return result;
	}
	fullscreen_window_hide_toolbar (self);
	result = FALSE;
	return result;
}

static void
fullscreen_window_hide_toolbar (FullscreenWindow* self)
{
	GtkToolbar* _tmp0_;
	g_return_if_fail (IS_FULLSCREEN_WINDOW (self));
	_tmp0_ = self->priv->toolbar;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	self->priv->is_toolbar_shown = FALSE;
}

void
fullscreen_window_monitor_get_geometry (FullscreenWindowMonitor *self,
                                        GdkRectangle* result)
{
	GdkMonitor* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	_tmp0_ = (*self).monitor;
	gdk_monitor_get_geometry (_tmp0_, &_tmp1_);
	*result = _tmp1_;
	return;
}

void
fullscreen_window_monitor_copy (const FullscreenWindowMonitor* self,
                                FullscreenWindowMonitor* dest)
{
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkMonitor* _tmp2_;
	GdkMonitor* _tmp3_;
	_tmp0_ = (*self).screen;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).screen);
	(*dest).screen = _tmp1_;
	_tmp2_ = (*self).monitor;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).monitor);
	(*dest).monitor = _tmp3_;
	(*dest).monitor_nr = (*self).monitor_nr;
}

void
fullscreen_window_monitor_destroy (FullscreenWindowMonitor* self)
{
	_g_object_unref0 ((*self).screen);
	_g_object_unref0 ((*self).monitor);
}

FullscreenWindowMonitor*
fullscreen_window_monitor_dup (const FullscreenWindowMonitor* self)
{
	FullscreenWindowMonitor* dup;
	dup = g_new0 (FullscreenWindowMonitor, 1);
	fullscreen_window_monitor_copy (self, dup);
	return dup;
}

void
fullscreen_window_monitor_free (FullscreenWindowMonitor* self)
{
	fullscreen_window_monitor_destroy (self);
	g_free (self);
}

static GType
fullscreen_window_monitor_get_type_once (void)
{
	GType fullscreen_window_monitor_type_id;
	fullscreen_window_monitor_type_id = g_boxed_type_register_static ("FullscreenWindowMonitor", (GBoxedCopyFunc) fullscreen_window_monitor_dup, (GBoxedFreeFunc) fullscreen_window_monitor_free);
	return fullscreen_window_monitor_type_id;
}

GType
fullscreen_window_monitor_get_type (void)
{
	static volatile gsize fullscreen_window_monitor_type_id__once = 0;
	if (g_once_init_enter (&fullscreen_window_monitor_type_id__once)) {
		GType fullscreen_window_monitor_type_id;
		fullscreen_window_monitor_type_id = fullscreen_window_monitor_get_type_once ();
		g_once_init_leave (&fullscreen_window_monitor_type_id__once, fullscreen_window_monitor_type_id);
	}
	return fullscreen_window_monitor_type_id__once;
}

static void
fullscreen_window_class_init (FullscreenWindowClass * klass,
                              gpointer klass_data)
{
	fullscreen_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FullscreenWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) fullscreen_window_real_configure_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) fullscreen_window_real_key_press_event;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) fullscreen_window_real_destroy;
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) fullscreen_window_real_delete_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) fullscreen_window_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->finalize = fullscreen_window_finalize;
}

static void
fullscreen_window_instance_init (FullscreenWindow * self,
                                 gpointer klass)
{
	GtkOverlay* _tmp0_;
	GtkToolButton* _tmp1_;
	GtkToggleToolButton* _tmp2_;
	self->priv = fullscreen_window_get_instance_private (self);
	_tmp0_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->overlay = _tmp0_;
	self->priv->toolbar = NULL;
	_tmp1_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp1_);
	self->priv->close_button = _tmp1_;
	_tmp2_ = (GtkToggleToolButton*) gtk_toggle_tool_button_new ();
	g_object_ref_sink (_tmp2_);
	self->priv->pin_button = _tmp2_;
	self->priv->is_toolbar_shown = FALSE;
	self->priv->waiting_for_invoke = FALSE;
	self->priv->left_toolbar_time = (gint64) 0;
	self->priv->switched_to = FALSE;
}

static void
fullscreen_window_finalize (GObject * obj)
{
	FullscreenWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->pin_button);
	G_OBJECT_CLASS (fullscreen_window_parent_class)->finalize (obj);
}

static GType
fullscreen_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FullscreenWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fullscreen_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FullscreenWindow), 0, (GInstanceInitFunc) fullscreen_window_instance_init, NULL };
	GType fullscreen_window_type_id;
	fullscreen_window_type_id = g_type_register_static (TYPE_PAGE_WINDOW, "FullscreenWindow", &g_define_type_info, 0);
	FullscreenWindow_private_offset = g_type_add_instance_private (fullscreen_window_type_id, sizeof (FullscreenWindowPrivate));
	return fullscreen_window_type_id;
}

GType
fullscreen_window_get_type (void)
{
	static volatile gsize fullscreen_window_type_id__once = 0;
	if (g_once_init_enter (&fullscreen_window_type_id__once)) {
		GType fullscreen_window_type_id;
		fullscreen_window_type_id = fullscreen_window_get_type_once ();
		g_once_init_leave (&fullscreen_window_type_id__once, fullscreen_window_type_id);
	}
	return fullscreen_window_type_id__once;
}

static inline gpointer
page_window_get_instance_private (PageWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PageWindow_private_offset);
}

static void
page_window_real_switched_pages (PageWindow* self,
                                 Page* old_page,
                                 Page* new_page)
{
	g_return_if_fail ((old_page == NULL) || IS_PAGE (old_page));
	g_return_if_fail ((new_page == NULL) || IS_PAGE (new_page));
}

void
page_window_switched_pages (PageWindow* self,
                            Page* old_page,
                            Page* new_page)
{
	PageWindowClass* _klass_;
	g_return_if_fail (IS_PAGE_WINDOW (self));
	_klass_ = PAGE_WINDOW_GET_CLASS (self);
	if (_klass_->switched_pages) {
		_klass_->switched_pages (self, old_page, new_page);
	}
}

PageWindow*
page_window_construct (GType object_type)
{
	PageWindow * self = NULL;
	Application* _tmp0_;
	Application* _tmp1_;
	GtkApplication* _tmp2_;
	GtkApplication* _tmp3_;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_get_system_app (_tmp1_);
	_tmp3_ = _tmp2_;
	self = (PageWindow*) g_object_new (object_type, "application", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_application_unref0 (_tmp1_);
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) ((GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK) | GDK_STRUCTURE_MASK));
	gtk_application_window_set_show_menubar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), TRUE);
	return self;
}

Page*
page_window_get_current_page (PageWindow* self)
{
	Page* _tmp0_;
	Page* _tmp1_;
	Page* result;
	g_return_val_if_fail (IS_PAGE_WINDOW (self), NULL);
	_tmp0_ = self->priv->current_page;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
page_window_real_set_current_page (PageWindow* self,
                                   Page* page)
{
	Page* _tmp0_;
	Page* old_page = NULL;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (IS_PAGE (page));
	_tmp0_ = self->priv->current_page;
	if (_tmp0_ != NULL) {
		Page* _tmp1_;
		_tmp1_ = self->priv->current_page;
		page_clear_container (_tmp1_);
	}
	_tmp2_ = self->priv->current_page;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_page = _tmp3_;
	_tmp4_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->current_page);
	self->priv->current_page = _tmp4_;
	_tmp5_ = self->priv->current_page;
	page_set_container (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	page_window_switched_pages (self, old_page, page);
	_g_object_unref0 (old_page);
}

void
page_window_set_current_page (PageWindow* self,
                              Page* page)
{
	PageWindowClass* _klass_;
	g_return_if_fail (IS_PAGE_WINDOW (self));
	_klass_ = PAGE_WINDOW_GET_CLASS (self);
	if (_klass_->set_current_page) {
		_klass_->set_current_page (self, page);
	}
}

static void
page_window_real_clear_current_page (PageWindow* self)
{
	Page* _tmp0_;
	Page* old_page = NULL;
	Page* _tmp2_;
	Page* _tmp3_;
	_tmp0_ = self->priv->current_page;
	if (_tmp0_ != NULL) {
		Page* _tmp1_;
		_tmp1_ = self->priv->current_page;
		page_clear_container (_tmp1_);
	}
	_tmp2_ = self->priv->current_page;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_page = _tmp3_;
	_g_object_unref0 (self->priv->current_page);
	self->priv->current_page = NULL;
	page_window_switched_pages (self, old_page, NULL);
	_g_object_unref0 (old_page);
}

void
page_window_clear_current_page (PageWindow* self)
{
	PageWindowClass* _klass_;
	g_return_if_fail (IS_PAGE_WINDOW (self));
	_klass_ = PAGE_WINDOW_GET_CLASS (self);
	if (_klass_->clear_current_page) {
		_klass_->clear_current_page (self);
	}
}

static gboolean
page_window_real_key_press_event (GtkWidget* base,
                                  GdkEventKey* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	gboolean _tmp4_ = FALSE;
	Page* _tmp5_;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PAGE_WINDOW, PageWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_entry_get_type ())) {
		GtkWidget* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		g_signal_emit_by_name (_tmp2_, "key-press-event", event, &_tmp3_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->current_page;
	if (_tmp5_ != NULL) {
		Page* _tmp6_;
		_tmp6_ = self->priv->current_page;
		_tmp4_ = page_notify_app_key_pressed (_tmp6_, event);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->key_press_event != NULL) {
		_tmp7_ = GTK_WIDGET_CLASS (page_window_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	return result;
}

static gboolean
page_window_real_key_release_event (GtkWidget* base,
                                    GdkEventKey* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	gboolean _tmp4_ = FALSE;
	Page* _tmp5_;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PAGE_WINDOW, PageWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_entry_get_type ())) {
		GtkWidget* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		g_signal_emit_by_name (_tmp2_, "key-release-event", event, &_tmp3_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->current_page;
	if (_tmp5_ != NULL) {
		Page* _tmp6_;
		_tmp6_ = self->priv->current_page;
		_tmp4_ = page_notify_app_key_released (_tmp6_, event);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->key_release_event != NULL) {
		_tmp7_ = GTK_WIDGET_CLASS (page_window_parent_class)->key_release_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	return result;
}

static gboolean
page_window_real_focus_in_event (GtkWidget* base,
                                 GdkEventFocus* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PAGE_WINDOW, PageWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->current_page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		_tmp2_ = self->priv->current_page;
		_tmp0_ = page_notify_app_focus_in (_tmp2_, event);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->focus_in_event != NULL) {
		_tmp3_ = GTK_WIDGET_CLASS (page_window_parent_class)->focus_in_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gboolean
page_window_real_focus_out_event (GtkWidget* base,
                                  GdkEventFocus* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PAGE_WINDOW, PageWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->current_page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		_tmp2_ = self->priv->current_page;
		_tmp0_ = page_notify_app_focus_out (_tmp2_, event);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->focus_out_event != NULL) {
		_tmp3_ = GTK_WIDGET_CLASS (page_window_parent_class)->focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gboolean
page_window_real_configure_event (GtkWidget* base,
                                  GdkEventConfigure* event)
{
	PageWindow * self;
	Page* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PAGE_WINDOW, PageWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->current_page;
	if (_tmp0_ != NULL) {
		Page* _tmp1_;
		_tmp1_ = self->priv->current_page;
		if (page_notify_configure_event (_tmp1_, event)) {
			result = TRUE;
			return result;
		}
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->configure_event != NULL) {
		_tmp2_ = GTK_WIDGET_CLASS (page_window_parent_class)->configure_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}

void
page_window_set_busy_cursor (PageWindow* self)
{
	gint _tmp0_;
	GdkDisplay* display = NULL;
	GdkWindow* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	GdkCursor* cursor = NULL;
	GdkDisplay* _tmp4_;
	GdkCursor* _tmp5_;
	GdkWindow* _tmp6_;
	GdkCursor* _tmp7_;
	g_return_if_fail (IS_PAGE_WINDOW (self));
	_tmp0_ = self->priv->busy_counter;
	self->priv->busy_counter = _tmp0_ + 1;
	if (_tmp0_ > 0) {
		return;
	}
	_tmp1_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_window_get_display (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	display = _tmp3_;
	_tmp4_ = display;
	_tmp5_ = gdk_cursor_new_for_display (_tmp4_, GDK_WATCH);
	cursor = _tmp5_;
	_tmp6_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = cursor;
	gdk_window_set_cursor (_tmp6_, _tmp7_);
	_g_object_unref0 (cursor);
	_g_object_unref0 (display);
}

void
page_window_set_normal_cursor (PageWindow* self)
{
	GdkDisplay* display = NULL;
	GdkWindow* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	GdkCursor* cursor = NULL;
	GdkDisplay* _tmp4_;
	GdkCursor* _tmp5_;
	GdkWindow* _tmp6_;
	GdkCursor* _tmp7_;
	g_return_if_fail (IS_PAGE_WINDOW (self));
	if (self->priv->busy_counter <= 0) {
		self->priv->busy_counter = 0;
		return;
	} else {
		gint _tmp0_;
		self->priv->busy_counter = self->priv->busy_counter - 1;
		_tmp0_ = self->priv->busy_counter;
		if (_tmp0_ > 0) {
			return;
		}
	}
	_tmp1_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_window_get_display (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	display = _tmp3_;
	_tmp4_ = display;
	_tmp5_ = gdk_cursor_new_for_display (_tmp4_, GDK_LEFT_PTR);
	cursor = _tmp5_;
	_tmp6_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = cursor;
	gdk_window_set_cursor (_tmp6_, _tmp7_);
	_g_object_unref0 (cursor);
	_g_object_unref0 (display);
}

static void
page_window_class_init (PageWindowClass * klass,
                        gpointer klass_data)
{
	page_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageWindow_private_offset);
	((PageWindowClass *) klass)->switched_pages = (void (*) (PageWindow*, Page*, Page*)) page_window_real_switched_pages;
	((PageWindowClass *) klass)->set_current_page = (void (*) (PageWindow*, Page*)) page_window_real_set_current_page;
	((PageWindowClass *) klass)->clear_current_page = (void (*) (PageWindow*)) page_window_real_clear_current_page;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) page_window_real_key_press_event;
	((GtkWidgetClass *) klass)->key_release_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) page_window_real_key_release_event;
	((GtkWidgetClass *) klass)->focus_in_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) page_window_real_focus_in_event;
	((GtkWidgetClass *) klass)->focus_out_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) page_window_real_focus_out_event;
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) page_window_real_configure_event;
	G_OBJECT_CLASS (klass)->finalize = page_window_finalize;
}

static void
page_window_instance_init (PageWindow * self,
                           gpointer klass)
{
	self->priv = page_window_get_instance_private (self);
	self->priv->current_page = NULL;
	self->priv->busy_counter = 0;
}

static void
page_window_finalize (GObject * obj)
{
	PageWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_WINDOW, PageWindow);
	_g_object_unref0 (self->priv->current_page);
	G_OBJECT_CLASS (page_window_parent_class)->finalize (obj);
}

static GType
page_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageWindow), 0, (GInstanceInitFunc) page_window_instance_init, NULL };
	GType page_window_type_id;
	page_window_type_id = g_type_register_static (gtk_application_window_get_type (), "PageWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PageWindow_private_offset = g_type_add_instance_private (page_window_type_id, sizeof (PageWindowPrivate));
	return page_window_type_id;
}

GType
page_window_get_type (void)
{
	static volatile gsize page_window_type_id__once = 0;
	if (g_once_init_enter (&page_window_type_id__once)) {
		GType page_window_type_id;
		page_window_type_id = page_window_get_type_once ();
		g_once_init_leave (&page_window_type_id__once, page_window_type_id);
	}
	return page_window_type_id__once;
}

static void
_app_window_on_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	app_window_on_about ((AppWindow*) self);
}

static void
_app_window_on_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_on_quit ((AppWindow*) self);
}

static void
_app_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_on_fullscreen ((AppWindow*) self);
}

static void
_app_window_on_help_contents_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	app_window_on_help_contents ((AppWindow*) self);
}

static void
_app_window_on_help_faq_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	app_window_on_help_faq ((AppWindow*) self);
}

static void
_app_window_on_help_report_problem_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	app_window_on_help_report_problem ((AppWindow*) self);
}

static void
_app_window_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_on_undo ((AppWindow*) self);
}

static void
_app_window_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_on_redo ((AppWindow*) self);
}

static void
_app_window_on_jump_to_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	app_window_on_jump_to_file ((AppWindow*) self);
}

static void
_app_window_on_select_all_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_on_select_all ((AppWindow*) self);
}

static void
_app_window_on_select_none_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_on_select_none ((AppWindow*) self);
}

static void
_app_window_on_command_manager_altered_command_manager_altered (CommandManager* _sender,
                                                                gboolean can_undo,
                                                                gboolean can_redo,
                                                                gpointer self)
{
	app_window_on_command_manager_altered ((AppWindow*) self);
}

AppWindow*
app_window_construct (GType object_type)
{
	AppWindow * self = NULL;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	Dimensions _tmp10_;
	Dimensions _tmp11_;
	CommandManager* _tmp12_;
	CommandManager* _tmp13_;
	CommandManager* _tmp14_;
	self = (AppWindow*) page_window_construct (object_type);
	_tmp0_ = app_window_instance;
	_vala_assert (_tmp0_ == NULL, "instance == null");
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (app_window_instance);
	app_window_instance = _tmp1_;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), RESOURCES_APP_TITLE);
	gtk_window_set_default_icon_name ("org.gnome.Shotwell");
	if (IS_LIBRARY_WINDOW (self)) {
		ConfigFacade* _tmp2_;
		ConfigFacade* _tmp3_;
		gboolean _tmp4_ = FALSE;
		Dimensions _tmp5_ = {0};
		_tmp2_ = config_facade_get_instance ();
		_tmp3_ = _tmp2_;
		configuration_facade_get_library_window_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), &_tmp4_, &_tmp5_);
		self->maximized = _tmp4_;
		self->dimensions = _tmp5_;
		_g_object_unref0 (_tmp3_);
	} else {
		ConfigFacade* _tmp6_;
		ConfigFacade* _tmp7_;
		gboolean _tmp8_ = FALSE;
		Dimensions _tmp9_ = {0};
		_vala_assert (IS_DIRECT_WINDOW (self), "this is DirectWindow");
		_tmp6_ = config_facade_get_instance ();
		_tmp7_ = _tmp6_;
		configuration_facade_get_direct_window_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), &_tmp8_, &_tmp9_);
		self->maximized = _tmp8_;
		self->dimensions = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	_tmp10_ = self->dimensions;
	_tmp11_ = self->dimensions;
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp10_.width, _tmp11_.height);
	if (self->maximized) {
		gtk_window_maximize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	}
	_tmp12_ = app_window_command_manager;
	_vala_assert (_tmp12_ == NULL, "command_manager == null");
	_tmp13_ = command_manager_new (COMMAND_MANAGER_DEFAULT_DEPTH);
	_command_manager_unref0 (app_window_command_manager);
	app_window_command_manager = _tmp13_;
	_tmp14_ = app_window_command_manager;
	g_signal_connect_object (_tmp14_, "altered", (GCallback) _app_window_on_command_manager_altered_command_manager_altered, self, 0);
	app_window_add_actions (self);
	return self;
}

static void
app_window_real_on_fullscreen (AppWindow* self)
{
	g_critical ("Type `%s' does not implement abstract method `app_window_on_fullscreen'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
app_window_on_fullscreen (AppWindow* self)
{
	AppWindowClass* _klass_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->on_fullscreen) {
		_klass_->on_fullscreen (self);
	}
}

gboolean
app_window_has_instance (void)
{
	AppWindow* _tmp0_;
	gboolean result;
	_tmp0_ = app_window_instance;
	result = _tmp0_ != NULL;
	return result;
}

AppWindow*
app_window_get_instance (void)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* result;
	_tmp0_ = app_window_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

FullscreenWindow*
app_window_get_fullscreen (void)
{
	FullscreenWindow* _tmp0_;
	FullscreenWindow* _tmp1_;
	FullscreenWindow* result;
	_tmp0_ = app_window_fullscreen_window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
app_window_error_message (const gchar* message,
                          GtkWindow* parent)
{
	g_return_if_fail (message != NULL);
	g_return_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()));
	app_window_error_message_with_title (RESOURCES_APP_TITLE, message, parent, TRUE);
}

void
app_window_error_message_with_title (const gchar* title,
                                     const gchar* message,
                                     GtkWindow* parent,
                                     gboolean should_escape)
{
	GtkWindow* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (title != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()));
	if (parent != NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = _g_object_ref0 (parent);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		AppWindow* _tmp2_;
		_tmp2_ = app_window_get_instance ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow);
	}
	_tmp3_ = build_alert_body_text (title, message, should_escape);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	dialog = _tmp6_;
	_tmp7_ = build_alert_body_text (title, message, should_escape);
	_tmp8_ = _tmp7_;
	gtk_message_dialog_set_markup (dialog, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_set (dialog, "use-markup", TRUE, NULL);
	gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
	_g_object_unref0 (_tmp0_);
}

gboolean
app_window_negate_affirm_question (const gchar* message,
                                   const gchar* negative,
                                   const gchar* affirmative,
                                   const gchar* title,
                                   GtkWindow* parent)
{
	GtkWindow* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean response = FALSE;
	gboolean result;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (negative != NULL, FALSE);
	g_return_val_if_fail (affirmative != NULL, FALSE);
	g_return_val_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), FALSE);
	if (parent != NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = _g_object_ref0 (parent);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		AppWindow* _tmp2_;
		_tmp2_ = app_window_get_instance ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow);
	}
	_tmp3_ = build_alert_body_text (title, message, TRUE);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	dialog = _tmp6_;
	_tmp7_ = build_alert_body_text (title, message, TRUE);
	_tmp8_ = _tmp7_;
	gtk_message_dialog_set_markup (dialog, _tmp8_);
	_g_free0 (_tmp8_);
	gtk_dialog_add_buttons (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), negative, GTK_RESPONSE_NO, affirmative, GTK_RESPONSE_YES, NULL);
	gtk_window_set_urgency_hint (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), TRUE);
	response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog)) == ((gint) GTK_RESPONSE_YES);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	result = response;
	_g_object_unref0 (dialog);
	_g_object_unref0 (_tmp0_);
	return result;
}

GtkResponseType
app_window_negate_affirm_cancel_question (const gchar* message,
                                          const gchar* negative,
                                          const gchar* affirmative,
                                          const gchar* title,
                                          GtkWindow* parent)
{
	GtkWindow* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint response = 0;
	GtkResponseType result;
	g_return_val_if_fail (message != NULL, 0);
	g_return_val_if_fail (negative != NULL, 0);
	g_return_val_if_fail (affirmative != NULL, 0);
	g_return_val_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), 0);
	if (parent != NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = _g_object_ref0 (parent);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		AppWindow* _tmp2_;
		_tmp2_ = app_window_get_instance ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow);
	}
	_tmp3_ = build_alert_body_text (title, message, TRUE);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	dialog = _tmp6_;
	gtk_dialog_add_buttons (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog), negative, GTK_RESPONSE_NO, affirmative, GTK_RESPONSE_YES, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
	_tmp7_ = build_alert_body_text (title, message, TRUE);
	_tmp8_ = _tmp7_;
	gtk_message_dialog_set_markup (dialog, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_set (dialog, "use-markup", TRUE, NULL);
	response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_dialog_get_type (), GtkDialog));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	result = (GtkResponseType) response;
	_g_object_unref0 (dialog);
	_g_object_unref0 (_tmp0_);
	return result;
}

GtkResponseType
app_window_affirm_cancel_question (const gchar* message,
                                   const gchar* affirmative,
                                   const gchar* title,
                                   GtkWindow* parent)
{
	GtkWindow* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* _tmp8_;
	gint response = 0;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkResponseType result;
	g_return_val_if_fail (message != NULL, 0);
	g_return_val_if_fail (affirmative != NULL, 0);
	g_return_val_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), 0);
	if (parent != NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = _g_object_ref0 (parent);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		AppWindow* _tmp2_;
		_tmp2_ = app_window_get_instance ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow);
	}
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", message);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	gtk_message_dialog_set_markup (_tmp4_, message);
	_tmp5_ = dialog;
	g_object_set (_tmp5_, "use-markup", TRUE, NULL);
	if (title != NULL) {
		_tmp6_ = title;
	} else {
		_tmp6_ = RESOURCES_APP_TITLE;
	}
	_tmp7_ = dialog;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow), _tmp6_);
	_tmp8_ = dialog;
	gtk_dialog_add_buttons (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_dialog_get_type (), GtkDialog), affirmative, GTK_RESPONSE_YES, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
	_tmp9_ = dialog;
	response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_dialog_get_type (), GtkDialog));
	_tmp10_ = dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	result = (GtkResponseType) response;
	_g_object_unref0 (dialog);
	_g_object_unref0 (_tmp0_);
	return result;
}

gint
app_window_export_overwrite_or_replace_question (const gchar* message,
                                                 const gchar* alt1,
                                                 const gchar* alt2,
                                                 const gchar* alt4,
                                                 const gchar* alt6,
                                                 const gchar* title,
                                                 GtkWindow* parent)
{
	GtkWindow* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_;
	GtkBox* content = NULL;
	GtkMessageDialog* _tmp6_;
	GtkWidget* _tmp7_;
	GtkBox* _tmp8_;
	GtkCheckButton* c = NULL;
	GtkCheckButton* _tmp9_;
	GtkCheckButton* _tmp10_;
	GtkBox* _tmp11_;
	GtkCheckButton* _tmp12_;
	GtkMessageDialog* _tmp13_;
	gint response = 0;
	GtkMessageDialog* _tmp14_;
	GtkCheckButton* _tmp15_;
	GtkMessageDialog* _tmp16_;
	gint result;
	g_return_val_if_fail (message != NULL, 0);
	g_return_val_if_fail (alt1 != NULL, 0);
	g_return_val_if_fail (alt2 != NULL, 0);
	g_return_val_if_fail (alt4 != NULL, 0);
	g_return_val_if_fail (alt6 != NULL, 0);
	g_return_val_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), 0);
	if (parent != NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = _g_object_ref0 (parent);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		AppWindow* _tmp2_;
		_tmp2_ = app_window_get_instance ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow);
	}
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", message);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	if (title != NULL) {
		_tmp4_ = title;
	} else {
		_tmp4_ = RESOURCES_APP_TITLE;
	}
	_tmp5_ = dialog;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow), _tmp4_);
	_tmp6_ = dialog;
	_tmp7_ = gtk_message_dialog_get_message_area (_tmp6_);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_box_get_type (), GtkBox));
	content = _tmp8_;
	_tmp9_ = (GtkCheckButton*) gtk_check_button_new_with_label ("Apply conflict resolution to all other conflicts");
	g_object_ref_sink (_tmp9_);
	c = _tmp9_;
	_tmp10_ = c;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	_tmp11_ = content;
	_tmp12_ = c;
	gtk_box_pack_end (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	_tmp13_ = dialog;
	gtk_dialog_add_buttons (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_dialog_get_type (), GtkDialog), alt1, 1, alt2, 2, alt4, 4, alt6, 6, NULL);
	_tmp14_ = dialog;
	response = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_dialog_get_type (), GtkDialog));
	_tmp15_ = c;
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_button_get_type (), GtkToggleButton))) {
		response |= 0x80;
	}
	_tmp16_ = dialog;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	result = response;
	_g_object_unref0 (c);
	_g_object_unref0 (content);
	_g_object_unref0 (dialog);
	_g_object_unref0 (_tmp0_);
	return result;
}

void
app_window_database_error (GError* err)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (err != NULL);
	_tmp0_ = err->message;
	_tmp1_ = g_strdup_printf (_ ("A fatal error occurred when accessing Shotwell’s library. Shotwell can" \
"not continue.\n" \
"\n" \
"%s"), _tmp0_);
	_tmp2_ = _tmp1_;
	app_window_panic (_tmp2_);
	_g_free0 (_tmp2_);
}

void
app_window_panic (const gchar* msg)
{
	Application* _tmp0_;
	Application* _tmp1_;
	g_return_if_fail (msg != NULL);
	g_critical ("AppWindow.vala:576: %s", msg);
	app_window_error_message (msg, NULL);
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	application_panic (_tmp1_);
	_application_unref0 (_tmp1_);
}

static gchar*
app_window_real_get_app_role (AppWindow* self)
{
	g_critical ("Type `%s' does not implement abstract method `app_window_get_app_role'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
app_window_get_app_role (AppWindow* self)
{
	AppWindowClass* _klass_;
	g_return_val_if_fail (IS_APP_WINDOW (self), NULL);
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->get_app_role) {
		return _klass_->get_app_role (self);
	}
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
app_window_on_about (AppWindow* self)
{
	gchar* hash = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** artists = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint artists_length1;
	gint _artists_size_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* _tmp16_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = g_strdup ("");
	hash = _tmp0_;
	if (RESOURCES_GIT_VERSION != NULL) {
		_tmp2_ = g_strcmp0 (RESOURCES_GIT_VERSION, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_strcmp0 (RESOURCES_GIT_VERSION, RESOURCES_APP_VERSION) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = string_substring (RESOURCES_GIT_VERSION, (glong) 0, (glong) 7);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf (" (%s)", _tmp4_);
		_g_free0 (hash);
		hash = _tmp5_;
		_g_free0 (_tmp4_);
	}
	_tmp6_ = g_strdup ("Image of the Delmenhorst Town Hall by Charlie1965nrw, source: https://" \
"commons.wikimedia.org/wiki/File:Delmenhorst_Rathaus.jpg");
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp7_[1] = NULL;
	artists = _tmp7_;
	artists_length1 = 2;
	_artists_size_ = artists_length1;
	_tmp8_ = hash;
	_tmp9_ = g_strconcat (RESOURCES_APP_VERSION, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, " — Delmenhorst", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = app_window_get_app_role (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = resources_get_icon (RESOURCES_ICON_ABOUT_LOGO, -1);
	_tmp16_ = _tmp15_;
	gtk_show_about_dialog (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), "version", _tmp12_, "comments", _tmp14_, "copyright", RESOURCES_COPYRIGHT, "website", RESOURCES_HOME_URL, "license", RESOURCES_LICENSE, "website-label", _ ("Visit the Shotwell web site"), "authors", RESOURCES_AUTHORS, "logo", _tmp16_, "translator-credits", _ ("translator-credits"), "artists", artists, NULL, NULL);
	_g_object_unref0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (hash);
}

static void
app_window_on_help_contents (AppWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_APP_WINDOW (self));
	{
		resources_launch_help (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = g_strdup_printf (_ ("Unable to display help: %s"), _tmp1_);
		_tmp3_ = _tmp2_;
		app_window_error_message (_tmp3_, NULL);
		_g_free0 (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
app_window_on_help_report_problem (AppWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_APP_WINDOW (self));
	{
		app_window_show_uri (self, RESOURCES_BUG_DB_URL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = g_strdup_printf (_ ("Unable to navigate to bug database: %s"), _tmp1_);
		_tmp3_ = _tmp2_;
		app_window_error_message (_tmp3_, NULL);
		_g_free0 (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
app_window_on_help_faq (AppWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_APP_WINDOW (self));
	{
		app_window_show_uri (self, RESOURCES_FAQ_URL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = g_strdup_printf (_ ("Unable to display FAQ: %s"), _tmp1_);
		_tmp3_ = _tmp2_;
		app_window_error_message (_tmp3_, NULL);
		_g_free0 (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
app_window_real_on_quit (AppWindow* self)
{
	Application* _tmp0_;
	Application* _tmp1_;
	_tmp0_ = application_get_instance ();
	_tmp1_ = _tmp0_;
	application_exit (_tmp1_);
	_application_unref0 (_tmp1_);
}

void
app_window_on_quit (AppWindow* self)
{
	AppWindowClass* _klass_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->on_quit) {
		_klass_->on_quit (self);
	}
}

void
app_window_on_jump_to_file (AppWindow* self)
{
	Page* _tmp0_;
	Page* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	gboolean _tmp4_;
	MediaSource* media = NULL;
	Page* _tmp5_;
	Page* _tmp6_;
	ViewCollection* _tmp7_;
	ViewCollection* _tmp8_;
	DataView* _tmp9_;
	DataView* _tmp10_;
	DataSource* _tmp11_;
	MediaSource* _tmp12_;
	MediaSource* _tmp13_;
	MediaSource* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = view_collection_get_selected_count (_tmp3_) != 1;
	_data_collection_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp6_ = _tmp5_;
	_tmp7_ = page_get_view (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = view_collection_get_selected_at (_tmp8_, 0);
	_tmp10_ = _tmp9_;
	_tmp11_ = data_view_get_source (_tmp10_);
	_tmp12_ = IS_MEDIA_SOURCE (_tmp11_) ? ((MediaSource*) _tmp11_) : NULL;
	if (_tmp12_ == NULL) {
		_g_object_unref0 (_tmp11_);
	}
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	_data_collection_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	media = _tmp13_;
	_tmp14_ = media;
	if (_tmp14_ == NULL) {
		_g_object_unref0 (media);
		return;
	}
	{
		AppWindow* _tmp15_;
		AppWindow* _tmp16_;
		MediaSource* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		_tmp15_ = app_window_get_instance ();
		_tmp16_ = _tmp15_;
		_tmp17_ = media;
		_tmp18_ = media_source_get_master_file (_tmp17_);
		_tmp19_ = _tmp18_;
		app_window_show_file_uri (_tmp16_, _tmp19_, &_inner_error0_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp16_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = err;
		_tmp21_ = resources_jump_to_file_failed (_tmp20_);
		_tmp22_ = _tmp21_;
		app_window_error_message (_tmp22_, NULL);
		_g_free0 (_tmp22_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (media);
}

static void
app_window_real_destroy (GtkWidget* base)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_APP_WINDOW, AppWindow);
	app_window_on_quit (self);
}

void
app_window_show_file_uri (AppWindow* self,
                          GFile* file,
                          GError** error)
{
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	show_file_in_filemanager (file, NULL, NULL);
}

void
app_window_show_uri (AppWindow* self,
                     const gchar* url,
                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (url != NULL);
	gtk_show_uri_on_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), url, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
app_window_real_add_actions (AppWindow* self)
{
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), APP_WINDOW_common_actions, (gint) G_N_ELEMENTS (APP_WINDOW_common_actions), self);
}

void
app_window_add_actions (AppWindow* self)
{
	AppWindowClass* _klass_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->add_actions) {
		_klass_->add_actions (self);
	}
}

void
app_window_go_fullscreen (AppWindow* self,
                          Page* page)
{
	FullscreenWindow* _tmp0_;
	FullscreenWindowMonitor monitor = {0};
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	FullscreenWindowMonitor _tmp4_ = {0};
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp5_;
	GdkDisplay* _tmp6_;
	FullscreenWindow* fsw = NULL;
	FullscreenWindowMonitor _tmp18_;
	FullscreenWindow* _tmp19_;
	Page* _tmp20_;
	Page* _tmp21_;
	gboolean _tmp22_;
	FullscreenWindow* _tmp26_;
	FullscreenWindow* _tmp27_;
	FullscreenWindow* _tmp28_;
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (IS_PAGE (page));
	_tmp0_ = app_window_fullscreen_window;
	if (_tmp0_ != NULL) {
		FullscreenWindow* _tmp1_;
		_tmp1_ = app_window_fullscreen_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
		return;
	}
	_tmp2_ = gtk_window_get_screen (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_tmp4_.screen);
	_tmp4_.screen = _tmp3_;
	_g_object_unref0 (_tmp4_.monitor);
	_tmp4_.monitor = NULL;
	_tmp4_.monitor_nr = 0;
	monitor = _tmp4_;
	_tmp5_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = _g_object_ref0 (_tmp5_);
	display = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GdkDisplay* _tmp9_;
				GdkDisplay* _tmp10_;
				GdkMonitor* _tmp11_;
				GdkDisplay* _tmp12_;
				GdkWindow* _tmp13_;
				GdkMonitor* _tmp14_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = display;
				if (!(i < gdk_display_get_n_monitors (_tmp9_))) {
					break;
				}
				_tmp10_ = display;
				_tmp11_ = gdk_display_get_monitor (_tmp10_, i);
				_tmp12_ = display;
				_tmp13_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
				_tmp14_ = gdk_display_get_monitor_at_window (_tmp12_, _tmp13_);
				if (_tmp11_ == _tmp14_) {
					GdkDisplay* _tmp15_;
					GdkMonitor* _tmp16_;
					GdkMonitor* _tmp17_;
					_tmp15_ = display;
					_tmp16_ = gdk_display_get_monitor (_tmp15_, i);
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (monitor.monitor);
					monitor.monitor = _tmp17_;
					monitor.monitor_nr = i;
					break;
				}
			}
		}
	}
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = monitor;
	_tmp19_ = fullscreen_window_new (page, &_tmp18_);
	g_object_ref_sink (_tmp19_);
	fsw = _tmp19_;
	_tmp20_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_ != NULL;
	_g_object_unref0 (_tmp21_);
	if (_tmp22_) {
		Page* _tmp23_;
		Page* _tmp24_;
		FullscreenWindow* _tmp25_;
		_tmp23_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
		_tmp24_ = _tmp23_;
		_tmp25_ = fsw;
		page_switching_to_fullscreen (_tmp24_, _tmp25_);
		_g_object_unref0 (_tmp24_);
	}
	_tmp26_ = fsw;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (app_window_fullscreen_window);
	app_window_fullscreen_window = _tmp27_;
	_tmp28_ = app_window_fullscreen_window;
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_window_get_type (), GtkWindow));
	_g_object_unref0 (fsw);
	_g_object_unref0 (display);
	fullscreen_window_monitor_destroy (&monitor);
}

void
app_window_end_fullscreen (AppWindow* self)
{
	FullscreenWindow* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	gboolean _tmp3_;
	FullscreenWindow* _tmp7_;
	FullscreenWindow* _tmp8_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = app_window_fullscreen_window;
	if (_tmp0_ == NULL) {
		return;
	}
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		Page* _tmp4_;
		Page* _tmp5_;
		FullscreenWindow* _tmp6_;
		_tmp4_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
		_tmp5_ = _tmp4_;
		_tmp6_ = app_window_fullscreen_window;
		page_returning_from_fullscreen (_tmp5_, _tmp6_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp7_ = app_window_fullscreen_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = app_window_fullscreen_window;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (app_window_fullscreen_window);
	app_window_fullscreen_window = NULL;
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
}

GAction*
app_window_get_common_action (AppWindow* self,
                              const gchar* name)
{
	GAction* _tmp0_;
	GAction* _tmp1_;
	GAction* result;
	g_return_val_if_fail (IS_APP_WINDOW (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), name);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
app_window_set_common_action_sensitive (AppWindow* self,
                                        const gchar* name,
                                        gboolean sensitive)
{
	GSimpleAction* action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = app_window_get_common_action (self, name);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	action = _tmp1_;
	_tmp2_ = action;
	if (_tmp2_ != NULL) {
		GSimpleAction* _tmp3_;
		_tmp3_ = action;
		g_simple_action_set_enabled (_tmp3_, sensitive);
	}
	_g_object_unref0 (action);
}

void
app_window_set_common_action_important (AppWindow* self,
                                        const gchar* name,
                                        gboolean important)
{
	GSimpleAction* action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = app_window_get_common_action (self, name);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	action = _tmp1_;
	_tmp2_ = action;
	if (_tmp2_ != NULL) {
		GSimpleAction* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = action;
		_tmp4_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp5_ = _tmp4_;
		g_simple_action_set_enabled (_tmp3_, _tmp5_);
	}
	_g_object_unref0 (action);
}

void
app_window_set_common_action_visible (AppWindow* self,
                                      const gchar* name,
                                      gboolean visible)
{
	GSimpleAction* action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = app_window_get_common_action (self, name);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	action = _tmp1_;
	_tmp2_ = action;
	if (_tmp2_ != NULL) {
		GSimpleAction* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = action;
		_tmp4_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp5_ = _tmp4_;
		g_simple_action_set_enabled (_tmp3_, _tmp5_);
	}
	_g_object_unref0 (action);
}

static void
_app_window_on_update_common_actions_data_collection_contents_altered (DataCollection* _sender,
                                                                       GeeIterable* added,
                                                                       GeeIterable* removed,
                                                                       gpointer self)
{
	app_window_on_update_common_actions ((AppWindow*) self);
}

static void
_app_window_on_update_common_actions_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                              gpointer self)
{
	app_window_on_update_common_actions ((AppWindow*) self);
}

static void
_app_window_on_update_common_actions_view_collection_items_state_changed (ViewCollection* _sender,
                                                                          GeeIterable* changed,
                                                                          gpointer self)
{
	app_window_on_update_common_actions ((AppWindow*) self);
}

static void
app_window_real_switched_pages (PageWindow* base,
                                Page* old_page,
                                Page* new_page)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_APP_WINDOW, AppWindow);
	g_return_if_fail ((old_page == NULL) || IS_PAGE (old_page));
	g_return_if_fail ((new_page == NULL) || IS_PAGE (new_page));
	app_window_update_common_action_availability (self, old_page, new_page);
	if (old_page != NULL) {
		ViewCollection* _tmp0_;
		ViewCollection* _tmp1_;
		guint _tmp2_;
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		guint _tmp5_;
		ViewCollection* _tmp6_;
		ViewCollection* _tmp7_;
		guint _tmp8_;
		_tmp0_ = page_get_view (old_page);
		_tmp1_ = _tmp0_;
		g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _app_window_on_update_common_actions_data_collection_contents_altered, self);
		_data_collection_unref0 (_tmp1_);
		_tmp3_ = page_get_view (old_page);
		_tmp4_ = _tmp3_;
		g_signal_parse_name ("selection-group-altered", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _app_window_on_update_common_actions_view_collection_selection_group_altered, self);
		_data_collection_unref0 (_tmp4_);
		_tmp6_ = page_get_view (old_page);
		_tmp7_ = _tmp6_;
		g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _app_window_on_update_common_actions_view_collection_items_state_changed, self);
		_data_collection_unref0 (_tmp7_);
	}
	if (new_page != NULL) {
		ViewCollection* _tmp9_;
		ViewCollection* _tmp10_;
		ViewCollection* _tmp11_;
		ViewCollection* _tmp12_;
		ViewCollection* _tmp13_;
		ViewCollection* _tmp14_;
		ViewCollection* _tmp15_;
		ViewCollection* _tmp16_;
		ViewCollection* _tmp17_;
		ViewCollection* _tmp18_;
		_tmp9_ = page_get_view (new_page);
		_tmp10_ = _tmp9_;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _app_window_on_update_common_actions_data_collection_contents_altered, self, 0);
		_data_collection_unref0 (_tmp10_);
		_tmp11_ = page_get_view (new_page);
		_tmp12_ = _tmp11_;
		g_signal_connect_object (_tmp12_, "selection-group-altered", (GCallback) _app_window_on_update_common_actions_view_collection_selection_group_altered, self, 0);
		_data_collection_unref0 (_tmp12_);
		_tmp13_ = page_get_view (new_page);
		_tmp14_ = _tmp13_;
		g_signal_connect_object (_tmp14_, "items-state-changed", (GCallback) _app_window_on_update_common_actions_view_collection_items_state_changed, self, 0);
		_data_collection_unref0 (_tmp14_);
		_tmp15_ = page_get_view (new_page);
		_tmp16_ = _tmp15_;
		_tmp17_ = page_get_view (new_page);
		_tmp18_ = _tmp17_;
		app_window_update_common_actions (self, new_page, view_collection_get_selected_count (_tmp16_), data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_DATA_COLLECTION, DataCollection)));
		_data_collection_unref0 (_tmp18_);
		_data_collection_unref0 (_tmp16_);
	}
	PAGE_WINDOW_CLASS (app_window_parent_class)->switched_pages (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), old_page, new_page);
}

static void
app_window_real_update_common_action_availability (AppWindow* self,
                                                   Page* old_page,
                                                   Page* new_page)
{
	gboolean is_checkerboard = FALSE;
	g_return_if_fail ((old_page == NULL) || IS_PAGE (old_page));
	g_return_if_fail ((new_page == NULL) || IS_PAGE (new_page));
	is_checkerboard = IS_CHECKERBOARD_PAGE (new_page);
	app_window_set_common_action_sensitive (self, "CommonSelectAll", is_checkerboard);
	app_window_set_common_action_sensitive (self, "CommonSelectNone", is_checkerboard);
}

void
app_window_update_common_action_availability (AppWindow* self,
                                              Page* old_page,
                                              Page* new_page)
{
	AppWindowClass* _klass_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->update_common_action_availability) {
		_klass_->update_common_action_availability (self, old_page, new_page);
	}
}

static void
app_window_real_update_common_actions (AppWindow* self,
                                       Page* page,
                                       gint selected_count,
                                       gint count)
{
	g_return_if_fail (IS_PAGE (page));
	if (IS_CHECKERBOARD_PAGE (page)) {
		app_window_set_common_action_sensitive (self, "CommonSelectAll", count > 0);
	}
	app_window_set_common_action_sensitive (self, "CommonJumpToFile", selected_count == 1);
	app_window_decorate_undo_action (self);
	app_window_decorate_redo_action (self);
}

void
app_window_update_common_actions (AppWindow* self,
                                  Page* page,
                                  gint selected_count,
                                  gint count)
{
	AppWindowClass* _klass_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_klass_ = APP_WINDOW_GET_CLASS (self);
	if (_klass_->update_common_actions) {
		_klass_->update_common_actions (self, page, selected_count, count);
	}
}

static void
app_window_on_update_common_actions (AppWindow* self)
{
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	page = _tmp0_;
	_tmp1_ = page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		Page* _tmp3_;
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		Page* _tmp6_;
		ViewCollection* _tmp7_;
		ViewCollection* _tmp8_;
		_tmp2_ = page;
		_tmp3_ = page;
		_tmp4_ = page_get_view (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = page;
		_tmp7_ = page_get_view (_tmp6_);
		_tmp8_ = _tmp7_;
		app_window_update_common_actions (self, _tmp2_, view_collection_get_selected_count (_tmp5_), data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection)));
		_data_collection_unref0 (_tmp8_);
		_data_collection_unref0 (_tmp5_);
	}
	_g_object_unref0 (page);
}

void
app_window_update_menu_item_label (AppWindow* self,
                                   const gchar* id,
                                   const gchar* new_label)
{
	GMenu* bar = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	GMenuModel* _tmp2_;
	GMenu* _tmp3_;
	GMenu* _tmp4_;
	GMenu* _tmp5_;
	gint items = 0;
	GMenu* _tmp6_;
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail (new_label != NULL);
	_tmp0_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_menubar (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_menu_get_type ()) ? ((GMenu*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	bar = _tmp4_;
	_tmp5_ = bar;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (bar);
		return;
	}
	_tmp6_ = bar;
	items = g_menu_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_menu_model_get_type (), GMenuModel));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GMenuModel* model = NULL;
				GMenu* _tmp9_;
				GMenuModel* _tmp10_;
				GMenu* _tmp11_;
				gint model_items = 0;
				GMenuModel* _tmp12_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(i < items)) {
					break;
				}
				_tmp9_ = bar;
				_tmp10_ = g_menu_model_get_item_link (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_menu_model_get_type (), GMenuModel), i, G_MENU_LINK_SUBMENU);
				model = _tmp10_;
				_tmp11_ = bar;
				if (_tmp11_ == NULL) {
					_g_object_unref0 (model);
					continue;
				}
				_tmp12_ = model;
				model_items = g_menu_model_get_n_items (_tmp12_);
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							GMenuModel* subsection = NULL;
							GMenuModel* _tmp15_;
							GMenuModel* _tmp16_;
							GMenuModel* _tmp17_;
							gint sub_items = 0;
							GMenuModel* _tmp18_;
							if (!_tmp13_) {
								gint _tmp14_;
								_tmp14_ = j;
								j = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							if (!(j < model_items)) {
								break;
							}
							_tmp15_ = model;
							_tmp16_ = g_menu_model_get_item_link (_tmp15_, j, G_MENU_LINK_SECTION);
							subsection = _tmp16_;
							_tmp17_ = subsection;
							if (_tmp17_ == NULL) {
								_g_object_unref0 (subsection);
								continue;
							}
							_tmp18_ = subsection;
							sub_items = g_menu_model_get_n_items (_tmp18_);
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp19_ = FALSE;
									_tmp19_ = TRUE;
									while (TRUE) {
										GMenuAttributeIter* it = NULL;
										GMenuModel* _tmp21_;
										GMenuAttributeIter* _tmp22_;
										if (!_tmp19_) {
											gint _tmp20_;
											_tmp20_ = k;
											k = _tmp20_ + 1;
										}
										_tmp19_ = FALSE;
										if (!(k < sub_items)) {
											break;
										}
										_tmp21_ = subsection;
										_tmp22_ = g_menu_model_iterate_item_attributes (_tmp21_, k);
										it = _tmp22_;
										while (TRUE) {
											GMenuAttributeIter* _tmp23_;
											gboolean _tmp24_ = FALSE;
											gboolean _tmp25_ = FALSE;
											GMenuAttributeIter* _tmp26_;
											const gchar* _tmp27_;
											_tmp23_ = it;
											if (!g_menu_attribute_iter_next (_tmp23_)) {
												break;
											}
											_tmp26_ = it;
											_tmp27_ = g_menu_attribute_iter_get_name (_tmp26_);
											if (g_strcmp0 (_tmp27_, "id") == 0) {
												GMenuAttributeIter* _tmp28_;
												GVariant* _tmp29_;
												GVariant* _tmp30_;
												const gchar* _tmp31_;
												_tmp28_ = it;
												_tmp29_ = g_menu_attribute_iter_get_value (_tmp28_);
												_tmp30_ = _tmp29_;
												_tmp31_ = g_variant_get_string (_tmp30_, NULL);
												_tmp25_ = g_strcmp0 (_tmp31_, id) == 0;
												_g_variant_unref0 (_tmp30_);
											} else {
												_tmp25_ = FALSE;
											}
											if (_tmp25_) {
												_tmp24_ = TRUE;
											} else {
												gboolean _tmp32_ = FALSE;
												GMenuAttributeIter* _tmp33_;
												const gchar* _tmp34_;
												_tmp33_ = it;
												_tmp34_ = g_menu_attribute_iter_get_name (_tmp33_);
												if (g_strcmp0 (_tmp34_, "action") == 0) {
													GMenuAttributeIter* _tmp35_;
													GVariant* _tmp36_;
													GVariant* _tmp37_;
													const gchar* _tmp38_;
													gchar* _tmp39_;
													gchar* _tmp40_;
													_tmp35_ = it;
													_tmp36_ = g_menu_attribute_iter_get_value (_tmp35_);
													_tmp37_ = _tmp36_;
													_tmp38_ = g_variant_get_string (_tmp37_, NULL);
													_tmp39_ = g_strconcat (".", id, NULL);
													_tmp40_ = _tmp39_;
													_tmp32_ = g_str_has_suffix (_tmp38_, _tmp40_);
													_g_free0 (_tmp40_);
													_g_variant_unref0 (_tmp37_);
												} else {
													_tmp32_ = FALSE;
												}
												_tmp24_ = _tmp32_;
											}
											if (_tmp24_) {
												GMenu* md = NULL;
												GMenuModel* _tmp41_;
												GMenu* _tmp42_;
												GMenuItem* m = NULL;
												GMenuModel* _tmp43_;
												GMenuItem* _tmp44_;
												GMenuItem* _tmp45_;
												GMenu* _tmp46_;
												GMenu* _tmp47_;
												GMenuItem* _tmp48_;
												_tmp41_ = subsection;
												_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, g_menu_get_type ()) ? ((GMenu*) _tmp41_) : NULL);
												md = _tmp42_;
												_tmp43_ = subsection;
												_tmp44_ = g_menu_item_new_from_model (_tmp43_, k);
												m = _tmp44_;
												_tmp45_ = m;
												g_menu_item_set_label (_tmp45_, new_label);
												_tmp46_ = md;
												g_menu_remove (_tmp46_, k);
												_tmp47_ = md;
												_tmp48_ = m;
												g_menu_insert_item (_tmp47_, k, _tmp48_);
												_g_object_unref0 (m);
												_g_object_unref0 (md);
												_g_object_unref0 (it);
												_g_object_unref0 (subsection);
												_g_object_unref0 (model);
												_g_object_unref0 (bar);
												return;
											}
										}
										_g_object_unref0 (it);
									}
								}
							}
							_g_object_unref0 (subsection);
						}
					}
				}
				_g_object_unref0 (model);
			}
		}
	}
	_g_object_unref0 (bar);
}

static gpointer
_command_manager_ref0 (gpointer self)
{
	return self ? command_manager_ref (self) : NULL;
}

CommandManager*
app_window_get_command_manager (void)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	CommandManager* result;
	_tmp0_ = app_window_command_manager;
	_tmp1_ = _command_manager_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
app_window_on_command_manager_altered (AppWindow* self)
{
	g_return_if_fail (IS_APP_WINDOW (self));
	app_window_decorate_undo_action (self);
	app_window_decorate_redo_action (self);
}

static void
app_window_decorate_command_manager_action (AppWindow* self,
                                            const gchar* name,
                                            const gchar* prefix,
                                            const gchar* default_explanation,
                                            CommandDescription* desc)
{
	GSimpleAction* action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	gchar* label = NULL;
	gchar* _tmp3_;
	const gchar* _tmp13_;
	g_return_if_fail (IS_APP_WINDOW (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (prefix != NULL);
	g_return_if_fail (default_explanation != NULL);
	g_return_if_fail ((desc == NULL) || IS_COMMAND_DESCRIPTION (desc));
	_tmp0_ = app_window_get_common_action (self, name);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	action = _tmp1_;
	_tmp2_ = action;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (action);
		return;
	}
	_tmp3_ = g_strdup (prefix);
	label = _tmp3_;
	if (desc != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GSimpleAction* _tmp10_;
		_tmp4_ = label;
		_tmp5_ = command_description_get_name (desc);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (" ", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
		_g_free0 (label);
		label = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp10_ = action;
		g_simple_action_set_enabled (_tmp10_, TRUE);
	} else {
		gchar* _tmp11_;
		GSimpleAction* _tmp12_;
		_tmp11_ = g_strdup (prefix);
		_g_free0 (label);
		label = _tmp11_;
		_tmp12_ = action;
		g_simple_action_set_enabled (_tmp12_, FALSE);
	}
	_tmp13_ = label;
	app_window_update_menu_item_label (self, name, _tmp13_);
	_g_free0 (label);
	_g_object_unref0 (action);
}

void
app_window_decorate_undo_action (AppWindow* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	CommandDescription* _tmp2_;
	CommandDescription* _tmp3_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = app_window_get_command_manager ();
	_tmp1_ = _tmp0_;
	_tmp2_ = command_manager_get_undo_description (_tmp1_);
	_tmp3_ = _tmp2_;
	app_window_decorate_command_manager_action (self, "CommonUndo", RESOURCES_UNDO_MENU, "", _tmp3_);
	_g_object_unref0 (_tmp3_);
	_command_manager_unref0 (_tmp1_);
}

void
app_window_decorate_redo_action (AppWindow* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	CommandDescription* _tmp2_;
	CommandDescription* _tmp3_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = app_window_get_command_manager ();
	_tmp1_ = _tmp0_;
	_tmp2_ = command_manager_get_redo_description (_tmp1_);
	_tmp3_ = _tmp2_;
	app_window_decorate_command_manager_action (self, "CommonRedo", RESOURCES_REDO_MENU, "", _tmp3_);
	_g_object_unref0 (_tmp3_);
	_command_manager_unref0 (_tmp1_);
}

static void
app_window_on_undo (AppWindow* self)
{
	CommandManager* _tmp0_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = app_window_command_manager;
	command_manager_undo (_tmp0_);
}

static void
app_window_on_redo (AppWindow* self)
{
	CommandManager* _tmp0_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = app_window_command_manager;
	command_manager_redo (_tmp0_);
}

static void
app_window_on_select_all (AppWindow* self)
{
	Page* page = NULL;
	Page* _tmp0_;
	CheckerboardPage* _tmp1_;
	Page* _tmp2_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp1_ = IS_CHECKERBOARD_PAGE (_tmp0_) ? ((CheckerboardPage*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	page = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PAGE, Page);
	_tmp2_ = page;
	if (_tmp2_ != NULL) {
		Page* _tmp3_;
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		_tmp3_ = page;
		_tmp4_ = page_get_view (_tmp3_);
		_tmp5_ = _tmp4_;
		view_collection_select_all (_tmp5_);
		_data_collection_unref0 (_tmp5_);
	}
	_g_object_unref0 (page);
}

static void
app_window_on_select_none (AppWindow* self)
{
	Page* page = NULL;
	Page* _tmp0_;
	CheckerboardPage* _tmp1_;
	Page* _tmp2_;
	g_return_if_fail (IS_APP_WINDOW (self));
	_tmp0_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_tmp1_ = IS_CHECKERBOARD_PAGE (_tmp0_) ? ((CheckerboardPage*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	page = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PAGE, Page);
	_tmp2_ = page;
	if (_tmp2_ != NULL) {
		Page* _tmp3_;
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		_tmp3_ = page;
		_tmp4_ = page_get_view (_tmp3_);
		_tmp5_ = _tmp4_;
		view_collection_unselect_all (_tmp5_);
		_data_collection_unref0 (_tmp5_);
	}
	_g_object_unref0 (page);
}

static gboolean
app_window_real_configure_event (GtkWidget* base,
                                 GdkEventConfigure* event)
{
	AppWindow * self;
	GdkWindow* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_APP_WINDOW, AppWindow);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	self->maximized = gdk_window_get_state (_tmp0_) == GDK_WINDOW_STATE_MAXIMIZED;
	if (!self->maximized) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp1_, &_tmp2_);
		self->dimensions.width = _tmp1_;
		self->dimensions.height = _tmp2_;
	}
	result = GTK_WIDGET_CLASS (app_window_parent_class)->configure_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), gtk_widget_get_type (), GtkWidget), event);
	return result;
}

static void
app_window_class_init (AppWindowClass * klass,
                       gpointer klass_data)
{
	app_window_parent_class = g_type_class_peek_parent (klass);
	((AppWindowClass *) klass)->on_fullscreen = (void (*) (AppWindow*)) app_window_real_on_fullscreen;
	((AppWindowClass *) klass)->get_app_role = (gchar* (*) (AppWindow*)) app_window_real_get_app_role;
	((AppWindowClass *) klass)->on_quit = (void (*) (AppWindow*)) app_window_real_on_quit;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) app_window_real_destroy;
	((AppWindowClass *) klass)->add_actions = (void (*) (AppWindow*)) app_window_real_add_actions;
	((PageWindowClass *) klass)->switched_pages = (void (*) (PageWindow*, Page*, Page*)) app_window_real_switched_pages;
	((AppWindowClass *) klass)->update_common_action_availability = (void (*) (AppWindow*, Page*, Page*)) app_window_real_update_common_action_availability;
	((AppWindowClass *) klass)->update_common_actions = (void (*) (AppWindow*, Page*, gint, gint)) app_window_real_update_common_actions;
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) app_window_real_configure_event;
	G_OBJECT_CLASS (klass)->finalize = app_window_finalize;
}

static void
app_window_instance_init (AppWindow * self,
                          gpointer klass)
{
	self->maximized = FALSE;
}

static void
app_window_finalize (GObject * obj)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_WINDOW, AppWindow);
	G_OBJECT_CLASS (app_window_parent_class)->finalize (obj);
}

static GType
app_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppWindow), 0, (GInstanceInitFunc) app_window_instance_init, NULL };
	GType app_window_type_id;
	app_window_type_id = g_type_register_static (TYPE_PAGE_WINDOW, "AppWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return app_window_type_id;
}

GType
app_window_get_type (void)
{
	static volatile gsize app_window_type_id__once = 0;
	if (g_once_init_enter (&app_window_type_id__once)) {
		GType app_window_type_id;
		app_window_type_id = app_window_get_type_once ();
		g_once_init_leave (&app_window_type_id__once, app_window_type_id);
	}
	return app_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

