/* TransitionsInterfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from TransitionsInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-plugin-dev-1.0.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SPIT_TRANSITIONS_VISUALS_0_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_NUM_PROPERTIES
};
static GParamSpec* spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SPIT_TRANSITIONS_MOTION_0_PROPERTY,
	SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY,
	SPIT_TRANSITIONS_MOTION_FPS_PROPERTY,
	SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY,
	SPIT_TRANSITIONS_MOTION_TOTAL_FRAMES_PROPERTY,
	SPIT_TRANSITIONS_MOTION_TICK_MSEC_PROPERTY,
	SPIT_TRANSITIONS_MOTION_NUM_PROPERTIES
};
static GParamSpec* spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_NUM_PROPERTIES];

struct _SpitTransitionsVisualsPrivate {
	GdkPixbuf* _from_pixbuf;
	GdkRectangle _from_pos;
	GdkPixbuf* _to_pixbuf;
	GdkRectangle _to_pos;
	GdkRGBA _bg_color;
};

struct _SpitTransitionsMotionPrivate {
	SpitTransitionsDirection _direction;
	gint _fps;
	gint _duration_msec;
};

static gint SpitTransitionsVisuals_private_offset;
static gpointer spit_transitions_visuals_parent_class = NULL;
static gint SpitTransitionsMotion_private_offset;
static gpointer spit_transitions_motion_parent_class = NULL;

static void spit_transitions_visuals_set_from_pixbuf (SpitTransitionsVisuals* self,
                                               GdkPixbuf* value);
static void spit_transitions_visuals_set_from_pos (SpitTransitionsVisuals* self,
                                            GdkRectangle * value);
static void spit_transitions_visuals_set_to_pixbuf (SpitTransitionsVisuals* self,
                                             GdkPixbuf* value);
static void spit_transitions_visuals_set_to_pos (SpitTransitionsVisuals* self,
                                          GdkRectangle * value);
static void spit_transitions_visuals_set_bg_color (SpitTransitionsVisuals* self,
                                            GdkRGBA * value);
static void spit_transitions_visuals_real_reserved0 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved1 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved2 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved3 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved4 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved5 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved6 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved7 (SpitTransitionsVisuals* self);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static void spit_transitions_visuals_finalize (GObject * obj);
static GType spit_transitions_visuals_get_type_once (void);
static void _vala_spit_transitions_visuals_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_spit_transitions_visuals_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void spit_transitions_motion_set_direction (SpitTransitionsMotion* self,
                                            SpitTransitionsDirection value);
static void spit_transitions_motion_set_fps (SpitTransitionsMotion* self,
                                      gint value);
static void spit_transitions_motion_set_duration_msec (SpitTransitionsMotion* self,
                                                gint value);
static void spit_transitions_motion_real_reserved0 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved1 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved2 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved3 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved4 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved5 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved6 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved7 (SpitTransitionsMotion* self);
static void spit_transitions_motion_finalize (GObject * obj);
static GType spit_transitions_motion_get_type_once (void);
static void _vala_spit_transitions_motion_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_spit_transitions_motion_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void spit_transitions_descriptor_real_reserved0 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved1 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved2 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved3 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved4 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved5 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved6 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved7 (SpitTransitionsDescriptor* self);
static GType spit_transitions_descriptor_get_type_once (void);
static void spit_transitions_effect_real_reserved0 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved1 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved2 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved3 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved4 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved5 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved6 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved7 (SpitTransitionsEffect* self);
static GType spit_transitions_effect_get_type_once (void);

/**
 * Direction indicates what direction (animated motion) the {@link Effect} should simulate the 
 * images are moving, if appropriate.
 * 
 * The direction indicates from what side or corner of the screen the new image should come in from.
 * Thus, a LEFT slide means the current image exits via the left-hand edge of the screen and the 
 * new image moves into place from the right-hand edge.
 *
 * UP, DOWN, and diagonals may be added at some point.
 */
static GType
spit_transitions_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_TRANSITIONS_DIRECTION_LEFT, "SPIT_TRANSITIONS_DIRECTION_LEFT", "left"}, {SPIT_TRANSITIONS_DIRECTION_RIGHT, "SPIT_TRANSITIONS_DIRECTION_RIGHT", "right"}, {SPIT_TRANSITIONS_DIRECTION_FORWARD, "SPIT_TRANSITIONS_DIRECTION_FORWARD", "forward"}, {SPIT_TRANSITIONS_DIRECTION_BACKWARD, "SPIT_TRANSITIONS_DIRECTION_BACKWARD", "backward"}, {0, NULL, NULL}};
	GType spit_transitions_direction_type_id;
	spit_transitions_direction_type_id = g_enum_register_static ("SpitTransitionsDirection", values);
	return spit_transitions_direction_type_id;
}

GType
spit_transitions_direction_get_type (void)
{
	static volatile gsize spit_transitions_direction_type_id__once = 0;
	if (g_once_init_enter (&spit_transitions_direction_type_id__once)) {
		GType spit_transitions_direction_type_id;
		spit_transitions_direction_type_id = spit_transitions_direction_get_type_once ();
		g_once_init_leave (&spit_transitions_direction_type_id__once, spit_transitions_direction_type_id);
	}
	return spit_transitions_direction_type_id__once;
}

static inline gpointer
spit_transitions_visuals_get_instance_private (SpitTransitionsVisuals* self)
{
	return G_STRUCT_MEMBER_P (self, SpitTransitionsVisuals_private_offset);
}

SpitTransitionsVisuals*
spit_transitions_visuals_construct (GType object_type,
                                    GdkPixbuf* from_pixbuf,
                                    GdkRectangle* from_pos,
                                    GdkPixbuf* to_pixbuf,
                                    GdkRectangle* to_pos,
                                    GdkRGBA* bg_color)
{
	SpitTransitionsVisuals * self = NULL;
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRGBA _tmp2_;
	g_return_val_if_fail ((from_pixbuf == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (from_pixbuf, gdk_pixbuf_get_type ()), NULL);
	g_return_val_if_fail (from_pos != NULL, NULL);
	g_return_val_if_fail ((to_pixbuf == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (to_pixbuf, gdk_pixbuf_get_type ()), NULL);
	g_return_val_if_fail (to_pos != NULL, NULL);
	g_return_val_if_fail (bg_color != NULL, NULL);
	self = (SpitTransitionsVisuals*) g_object_new (object_type, NULL);
	spit_transitions_visuals_set_from_pixbuf (self, from_pixbuf);
	_tmp0_ = *from_pos;
	spit_transitions_visuals_set_from_pos (self, &_tmp0_);
	spit_transitions_visuals_set_to_pixbuf (self, to_pixbuf);
	_tmp1_ = *to_pos;
	spit_transitions_visuals_set_to_pos (self, &_tmp1_);
	_tmp2_ = *bg_color;
	spit_transitions_visuals_set_bg_color (self, &_tmp2_);
	return self;
}

SpitTransitionsVisuals*
spit_transitions_visuals_new (GdkPixbuf* from_pixbuf,
                              GdkRectangle* from_pos,
                              GdkPixbuf* to_pixbuf,
                              GdkRectangle* to_pos,
                              GdkRGBA* bg_color)
{
	return spit_transitions_visuals_construct (SPIT_TRANSITIONS_TYPE_VISUALS, from_pixbuf, from_pos, to_pixbuf, to_pos, bg_color);
}

static void
spit_transitions_visuals_real_reserved0 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved0 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved0) {
		_klass_->reserved0 (self);
	}
}

static void
spit_transitions_visuals_real_reserved1 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved1 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved1) {
		_klass_->reserved1 (self);
	}
}

static void
spit_transitions_visuals_real_reserved2 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved2 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved2) {
		_klass_->reserved2 (self);
	}
}

static void
spit_transitions_visuals_real_reserved3 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved3 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved3) {
		_klass_->reserved3 (self);
	}
}

static void
spit_transitions_visuals_real_reserved4 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved4 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved4) {
		_klass_->reserved4 (self);
	}
}

static void
spit_transitions_visuals_real_reserved5 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved5 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved5) {
		_klass_->reserved5 (self);
	}
}

static void
spit_transitions_visuals_real_reserved6 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved6 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved6) {
		_klass_->reserved6 (self);
	}
}

static void
spit_transitions_visuals_real_reserved7 (SpitTransitionsVisuals* self)
{
}

void
spit_transitions_visuals_reserved7 (SpitTransitionsVisuals* self)
{
	SpitTransitionsVisualsClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_klass_ = SPIT_TRANSITIONS_VISUALS_GET_CLASS (self);
	if (_klass_->reserved7) {
		_klass_->reserved7 (self);
	}
}

GdkPixbuf*
spit_transitions_visuals_get_from_pixbuf (SpitTransitionsVisuals* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self), NULL);
	_tmp0_ = self->priv->_from_pixbuf;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
spit_transitions_visuals_set_from_pixbuf (SpitTransitionsVisuals* self,
                                          GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	old_value = spit_transitions_visuals_get_from_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_from_pixbuf);
		self->priv->_from_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY]);
	}
}

void
spit_transitions_visuals_get_from_pos (SpitTransitionsVisuals* self,
                                       GdkRectangle * result)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_tmp0_ = self->priv->_from_pos;
	*result = _tmp0_;
	return;
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static void
spit_transitions_visuals_set_from_pos (SpitTransitionsVisuals* self,
                                       GdkRectangle * value)
{
	GdkRectangle old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	spit_transitions_visuals_get_from_pos (self, &old_value);
	if (_cairo_rectangle_int_equal (value, &old_value) != TRUE) {
		GdkRectangle _tmp0_;
		_tmp0_ = *value;
		self->priv->_from_pos = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY]);
	}
}

GdkPixbuf*
spit_transitions_visuals_get_to_pixbuf (SpitTransitionsVisuals* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self), NULL);
	_tmp0_ = self->priv->_to_pixbuf;
	result = _tmp0_;
	return result;
}

static void
spit_transitions_visuals_set_to_pixbuf (SpitTransitionsVisuals* self,
                                        GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	old_value = spit_transitions_visuals_get_to_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_to_pixbuf);
		self->priv->_to_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY]);
	}
}

void
spit_transitions_visuals_get_to_pos (SpitTransitionsVisuals* self,
                                     GdkRectangle * result)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_tmp0_ = self->priv->_to_pos;
	*result = _tmp0_;
	return;
}

static void
spit_transitions_visuals_set_to_pos (SpitTransitionsVisuals* self,
                                     GdkRectangle * value)
{
	GdkRectangle old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	spit_transitions_visuals_get_to_pos (self, &old_value);
	if (_cairo_rectangle_int_equal (value, &old_value) != TRUE) {
		GdkRectangle _tmp0_;
		_tmp0_ = *value;
		self->priv->_to_pos = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY]);
	}
}

void
spit_transitions_visuals_get_bg_color (SpitTransitionsVisuals* self,
                                       GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	_tmp0_ = self->priv->_bg_color;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

static void
spit_transitions_visuals_set_bg_color (SpitTransitionsVisuals* self,
                                       GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
	spit_transitions_visuals_get_bg_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_bg_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY]);
	}
}

static void
spit_transitions_visuals_class_init (SpitTransitionsVisualsClass * klass,
                                     gpointer klass_data)
{
	spit_transitions_visuals_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SpitTransitionsVisuals_private_offset);
	((SpitTransitionsVisualsClass *) klass)->reserved0 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved0;
	((SpitTransitionsVisualsClass *) klass)->reserved1 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved1;
	((SpitTransitionsVisualsClass *) klass)->reserved2 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved2;
	((SpitTransitionsVisualsClass *) klass)->reserved3 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved3;
	((SpitTransitionsVisualsClass *) klass)->reserved4 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved4;
	((SpitTransitionsVisualsClass *) klass)->reserved5 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved5;
	((SpitTransitionsVisualsClass *) klass)->reserved6 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved6;
	((SpitTransitionsVisualsClass *) klass)->reserved7 = (void (*) (SpitTransitionsVisuals*)) spit_transitions_visuals_real_reserved7;
	G_OBJECT_CLASS (klass)->get_property = _vala_spit_transitions_visuals_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_spit_transitions_visuals_set_property;
	G_OBJECT_CLASS (klass)->finalize = spit_transitions_visuals_finalize;
	/**
	     * Returns the starting pixbuf (the pixbuf currently on the display).
	     *
	     * If transitioning from a blank screen, this will return null.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY] = g_param_spec_object ("from-pixbuf", "from-pixbuf", "from-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the position of the starting pixbuf on the display.
	     *
	     * If transitioning from a blank screen, this will be zeroed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY] = g_param_spec_boxed ("from-pos", "from-pos", "from-pos", gdk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the ending pixbuf (the pixbuf that the transition should result in).
	     *
	     * If transitioning to a blank screen, this will return null.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY] = g_param_spec_object ("to-pixbuf", "to-pixbuf", "to-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the position of the ending pixbuf on the display.
	     *
	     * If transitioning to a blank screen, this will be zeroed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY] = g_param_spec_boxed ("to-pos", "to-pos", "to-pos", gdk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the background color of the viewport.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY, spit_transitions_visuals_properties[SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY] = g_param_spec_boxed ("bg-color", "bg-color", "bg-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
spit_transitions_visuals_instance_init (SpitTransitionsVisuals * self,
                                        gpointer klass)
{
	self->priv = spit_transitions_visuals_get_instance_private (self);
}

static void
spit_transitions_visuals_finalize (GObject * obj)
{
	SpitTransitionsVisuals * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisuals);
	_g_object_unref0 (self->priv->_from_pixbuf);
	_g_object_unref0 (self->priv->_to_pixbuf);
	G_OBJECT_CLASS (spit_transitions_visuals_parent_class)->finalize (obj);
}

/**
 * Visuals contains the pertinent drawing information for the transition that must occur.
 * 
 * A Visuals object is supplied to {@link Effect} at the start of the transition and during each 
 * call to paint to the screen.
 *
 * Note that if starting with a blank screen, from_pixbuf will be null and from_pos will be
 * zeroed. The transition should be considered to start from a blank screen of the supplied
 * background color.
 *
 * Also note that if transitioning to a blank screen, to_pixbuf will be null and to_pos will be
 * zeroed. Like the prior case, the transition should move toward a blank screen of the background
 * color.
 */
static GType
spit_transitions_visuals_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsVisualsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_transitions_visuals_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpitTransitionsVisuals), 0, (GInstanceInitFunc) spit_transitions_visuals_instance_init, NULL };
	GType spit_transitions_visuals_type_id;
	spit_transitions_visuals_type_id = g_type_register_static (G_TYPE_OBJECT, "SpitTransitionsVisuals", &g_define_type_info, 0);
	SpitTransitionsVisuals_private_offset = g_type_add_instance_private (spit_transitions_visuals_type_id, sizeof (SpitTransitionsVisualsPrivate));
	return spit_transitions_visuals_type_id;
}

GType
spit_transitions_visuals_get_type (void)
{
	static volatile gsize spit_transitions_visuals_type_id__once = 0;
	if (g_once_init_enter (&spit_transitions_visuals_type_id__once)) {
		GType spit_transitions_visuals_type_id;
		spit_transitions_visuals_type_id = spit_transitions_visuals_get_type_once ();
		g_once_init_leave (&spit_transitions_visuals_type_id__once, spit_transitions_visuals_type_id);
	}
	return spit_transitions_visuals_type_id__once;
}

static void
_vala_spit_transitions_visuals_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SpitTransitionsVisuals * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisuals);
	switch (property_id) {
		case SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY:
		g_value_set_object (value, spit_transitions_visuals_get_from_pixbuf (self));
		break;
		case SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY:
		{
			GdkRectangle boxed;
			spit_transitions_visuals_get_from_pos (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY:
		g_value_set_object (value, spit_transitions_visuals_get_to_pixbuf (self));
		break;
		case SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY:
		{
			GdkRectangle boxed;
			spit_transitions_visuals_get_to_pos (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			spit_transitions_visuals_get_bg_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_spit_transitions_visuals_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SpitTransitionsVisuals * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisuals);
	switch (property_id) {
		case SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY:
		spit_transitions_visuals_set_from_pixbuf (self, g_value_get_object (value));
		break;
		case SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY:
		spit_transitions_visuals_set_from_pos (self, g_value_get_boxed (value));
		break;
		case SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY:
		spit_transitions_visuals_set_to_pixbuf (self, g_value_get_object (value));
		break;
		case SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY:
		spit_transitions_visuals_set_to_pos (self, g_value_get_boxed (value));
		break;
		case SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY:
		spit_transitions_visuals_set_bg_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
spit_transitions_motion_get_instance_private (SpitTransitionsMotion* self)
{
	return G_STRUCT_MEMBER_P (self, SpitTransitionsMotion_private_offset);
}

SpitTransitionsMotion*
spit_transitions_motion_construct (GType object_type,
                                   SpitTransitionsDirection direction,
                                   gint fps,
                                   gint duration_msec)
{
	SpitTransitionsMotion * self = NULL;
	self = (SpitTransitionsMotion*) g_object_new (object_type, NULL);
	spit_transitions_motion_set_direction (self, direction);
	spit_transitions_motion_set_fps (self, fps);
	spit_transitions_motion_set_duration_msec (self, duration_msec);
	return self;
}

SpitTransitionsMotion*
spit_transitions_motion_new (SpitTransitionsDirection direction,
                             gint fps,
                             gint duration_msec)
{
	return spit_transitions_motion_construct (SPIT_TRANSITIONS_TYPE_MOTION, direction, fps, duration_msec);
}

/**
     * Returns a value from 0.0 to 1.0 that represents the percentage of the transition's completion
     * for the specified frame.
     */
gdouble
spit_transitions_motion_get_alpha (SpitTransitionsMotion* self,
                                   gint frame_number)
{
	gint _tmp0_;
	gint _tmp1_;
	gdouble result;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0.0);
	_tmp0_ = spit_transitions_motion_get_total_frames (self);
	_tmp1_ = _tmp0_;
	result = ((gdouble) frame_number) / ((gdouble) _tmp1_);
	return result;
}

static void
spit_transitions_motion_real_reserved0 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved0 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved0) {
		_klass_->reserved0 (self);
	}
}

static void
spit_transitions_motion_real_reserved1 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved1 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved1) {
		_klass_->reserved1 (self);
	}
}

static void
spit_transitions_motion_real_reserved2 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved2 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved2) {
		_klass_->reserved2 (self);
	}
}

static void
spit_transitions_motion_real_reserved3 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved3 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved3) {
		_klass_->reserved3 (self);
	}
}

static void
spit_transitions_motion_real_reserved4 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved4 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved4) {
		_klass_->reserved4 (self);
	}
}

static void
spit_transitions_motion_real_reserved5 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved5 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved5) {
		_klass_->reserved5 (self);
	}
}

static void
spit_transitions_motion_real_reserved6 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved6 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved6) {
		_klass_->reserved6 (self);
	}
}

static void
spit_transitions_motion_real_reserved7 (SpitTransitionsMotion* self)
{
}

void
spit_transitions_motion_reserved7 (SpitTransitionsMotion* self)
{
	SpitTransitionsMotionClass* _klass_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	_klass_ = SPIT_TRANSITIONS_MOTION_GET_CLASS (self);
	if (_klass_->reserved7) {
		_klass_->reserved7 (self);
	}
}

SpitTransitionsDirection
spit_transitions_motion_get_direction (SpitTransitionsMotion* self)
{
	SpitTransitionsDirection result;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
	result = self->priv->_direction;
	return result;
}

static void
spit_transitions_motion_set_direction (SpitTransitionsMotion* self,
                                       SpitTransitionsDirection value)
{
	SpitTransitionsDirection old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	old_value = spit_transitions_motion_get_direction (self);
	if (old_value != value) {
		self->priv->_direction = value;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY]);
	}
}

gint
spit_transitions_motion_get_fps (SpitTransitionsMotion* self)
{
	gint result;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
	result = self->priv->_fps;
	return result;
}

static void
spit_transitions_motion_set_fps (SpitTransitionsMotion* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	old_value = spit_transitions_motion_get_fps (self);
	if (old_value != value) {
		self->priv->_fps = value;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_FPS_PROPERTY]);
	}
}

gint
spit_transitions_motion_get_duration_msec (SpitTransitionsMotion* self)
{
	gint result;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
	result = self->priv->_duration_msec;
	return result;
}

static void
spit_transitions_motion_set_duration_msec (SpitTransitionsMotion* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
	old_value = spit_transitions_motion_get_duration_msec (self);
	if (old_value != value) {
		self->priv->_duration_msec = value;
		g_object_notify_by_pspec ((GObject *) self, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY]);
	}
}

gint
spit_transitions_motion_get_total_frames (SpitTransitionsMotion* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
	_tmp0_ = self->priv->_fps;
	_tmp1_ = self->priv->_duration_msec;
	result = (gint) (((gdouble) _tmp0_) * (((gdouble) _tmp1_) / 1000.0));
	return result;
}

gint
spit_transitions_motion_get_tick_msec (SpitTransitionsMotion* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
	_tmp0_ = self->priv->_fps;
	result = (gint) (1000.0 / ((gdouble) _tmp0_));
	return result;
}

static void
spit_transitions_motion_class_init (SpitTransitionsMotionClass * klass,
                                    gpointer klass_data)
{
	spit_transitions_motion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SpitTransitionsMotion_private_offset);
	((SpitTransitionsMotionClass *) klass)->reserved0 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved0;
	((SpitTransitionsMotionClass *) klass)->reserved1 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved1;
	((SpitTransitionsMotionClass *) klass)->reserved2 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved2;
	((SpitTransitionsMotionClass *) klass)->reserved3 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved3;
	((SpitTransitionsMotionClass *) klass)->reserved4 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved4;
	((SpitTransitionsMotionClass *) klass)->reserved5 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved5;
	((SpitTransitionsMotionClass *) klass)->reserved6 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved6;
	((SpitTransitionsMotionClass *) klass)->reserved7 = (void (*) (SpitTransitionsMotion*)) spit_transitions_motion_real_reserved7;
	G_OBJECT_CLASS (klass)->get_property = _vala_spit_transitions_motion_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_spit_transitions_motion_set_property;
	G_OBJECT_CLASS (klass)->finalize = spit_transitions_motion_finalize;
	/**
	     * Returns the direction the transition should occur in (if pertinent to the {@link Effect}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY] = g_param_spec_enum ("direction", "direction", "direction", SPIT_TRANSITIONS_TYPE_DIRECTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the frames per second of the {@link Effect}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_FPS_PROPERTY, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_FPS_PROPERTY] = g_param_spec_int ("fps", "fps", "fps", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the amount of time the transition should take (in milliseconds).
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY] = g_param_spec_int ("duration-msec", "duration-msec", "duration-msec", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the number of frames that should be required to perform the transition in the
	     * expected {@link duration_msec}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_TOTAL_FRAMES_PROPERTY, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_TOTAL_FRAMES_PROPERTY] = g_param_spec_int ("total-frames", "total-frames", "total-frames", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the approximate time between each frame draw (in milliseconds).
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_TICK_MSEC_PROPERTY, spit_transitions_motion_properties[SPIT_TRANSITIONS_MOTION_TICK_MSEC_PROPERTY] = g_param_spec_int ("tick-msec", "tick-msec", "tick-msec", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
spit_transitions_motion_instance_init (SpitTransitionsMotion * self,
                                       gpointer klass)
{
	self->priv = spit_transitions_motion_get_instance_private (self);
}

static void
spit_transitions_motion_finalize (GObject * obj)
{
	SpitTransitionsMotion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotion);
	G_OBJECT_CLASS (spit_transitions_motion_parent_class)->finalize (obj);
}

/**
 * Motion contains all the pertinent information regarding the animation of the transition.
 *
 * Some of Motion's information may not apply to a transition effect (such as Direction for a 
 * fade effect).
 */
static GType
spit_transitions_motion_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsMotionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_transitions_motion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpitTransitionsMotion), 0, (GInstanceInitFunc) spit_transitions_motion_instance_init, NULL };
	GType spit_transitions_motion_type_id;
	spit_transitions_motion_type_id = g_type_register_static (G_TYPE_OBJECT, "SpitTransitionsMotion", &g_define_type_info, 0);
	SpitTransitionsMotion_private_offset = g_type_add_instance_private (spit_transitions_motion_type_id, sizeof (SpitTransitionsMotionPrivate));
	return spit_transitions_motion_type_id;
}

GType
spit_transitions_motion_get_type (void)
{
	static volatile gsize spit_transitions_motion_type_id__once = 0;
	if (g_once_init_enter (&spit_transitions_motion_type_id__once)) {
		GType spit_transitions_motion_type_id;
		spit_transitions_motion_type_id = spit_transitions_motion_get_type_once ();
		g_once_init_leave (&spit_transitions_motion_type_id__once, spit_transitions_motion_type_id);
	}
	return spit_transitions_motion_type_id__once;
}

static void
_vala_spit_transitions_motion_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	SpitTransitionsMotion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotion);
	switch (property_id) {
		case SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY:
		g_value_set_enum (value, spit_transitions_motion_get_direction (self));
		break;
		case SPIT_TRANSITIONS_MOTION_FPS_PROPERTY:
		g_value_set_int (value, spit_transitions_motion_get_fps (self));
		break;
		case SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY:
		g_value_set_int (value, spit_transitions_motion_get_duration_msec (self));
		break;
		case SPIT_TRANSITIONS_MOTION_TOTAL_FRAMES_PROPERTY:
		g_value_set_int (value, spit_transitions_motion_get_total_frames (self));
		break;
		case SPIT_TRANSITIONS_MOTION_TICK_MSEC_PROPERTY:
		g_value_set_int (value, spit_transitions_motion_get_tick_msec (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_spit_transitions_motion_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	SpitTransitionsMotion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotion);
	switch (property_id) {
		case SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY:
		spit_transitions_motion_set_direction (self, g_value_get_enum (value));
		break;
		case SPIT_TRANSITIONS_MOTION_FPS_PROPERTY:
		spit_transitions_motion_set_fps (self, g_value_get_int (value));
		break;
		case SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY:
		spit_transitions_motion_set_duration_msec (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

/**
     * Returns an instance of the {@link Effect} this descriptor represents.
     */
SpitTransitionsEffect*
spit_transitions_descriptor_create (SpitTransitionsDescriptor* self,
                                    SpitHostInterface* host)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self), NULL);
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->create) {
		return _iface_->create (self, host);
	}
	return NULL;
}

static void
spit_transitions_descriptor_real_reserved0 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved0 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_transitions_descriptor_real_reserved1 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved1 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_transitions_descriptor_real_reserved2 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved2 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_transitions_descriptor_real_reserved3 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved3 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_transitions_descriptor_real_reserved4 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved4 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_transitions_descriptor_real_reserved5 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved5 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_transitions_descriptor_real_reserved6 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved6 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_transitions_descriptor_real_reserved7 (SpitTransitionsDescriptor* self)
{
}

void
spit_transitions_descriptor_reserved7 (SpitTransitionsDescriptor* self)
{
	SpitTransitionsDescriptorIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
	_iface_ = SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_transitions_descriptor_default_init (SpitTransitionsDescriptorIface * iface,
                                          gpointer iface_data)
{
	iface->reserved0 = spit_transitions_descriptor_real_reserved0;
	iface->reserved1 = spit_transitions_descriptor_real_reserved1;
	iface->reserved2 = spit_transitions_descriptor_real_reserved2;
	iface->reserved3 = spit_transitions_descriptor_real_reserved3;
	iface->reserved4 = spit_transitions_descriptor_real_reserved4;
	iface->reserved5 = spit_transitions_descriptor_real_reserved5;
	iface->reserved6 = spit_transitions_descriptor_real_reserved6;
	iface->reserved7 = spit_transitions_descriptor_real_reserved7;
}

/**
 * A Descriptor offers a factory method for creating {@link Effect} instances.
 */
static GType
spit_transitions_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsDescriptorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_transitions_descriptor_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_transitions_descriptor_type_id;
	spit_transitions_descriptor_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitTransitionsDescriptor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_transitions_descriptor_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (spit_transitions_descriptor_type_id, SPIT_TYPE_PLUGGABLE);
	return spit_transitions_descriptor_type_id;
}

GType
spit_transitions_descriptor_get_type (void)
{
	static volatile gsize spit_transitions_descriptor_type_id__once = 0;
	if (g_once_init_enter (&spit_transitions_descriptor_type_id__once)) {
		GType spit_transitions_descriptor_type_id;
		spit_transitions_descriptor_type_id = spit_transitions_descriptor_get_type_once ();
		g_once_init_leave (&spit_transitions_descriptor_type_id__once, spit_transitions_descriptor_type_id);
	}
	return spit_transitions_descriptor_type_id__once;
}

/**
     * Returns frames per second (FPS) information for this effect.
     *
     * If the min_fps is not met, the Effect may be cancelled or the host will skip ahead.
     *
     * @param desired_fps The desired FPS of the transition.  Return zero if no
     *        transition is to occur (instantaneous or null transition).
     * @param min_fps The minimum FPS before the effect is consider "ruined".
     *        Return zero if any FPS is acceptable.
     */
void
spit_transitions_effect_get_fps (SpitTransitionsEffect* self,
                                 gint* desired_fps,
                                 gint* min_fps)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->get_fps) {
		_iface_->get_fps (self, desired_fps, min_fps);
	}
}

/**
     * Called when the effect is starting.
     * 
     * All state should be reset. The frame number, which is not supplied, is one.
     */
void
spit_transitions_effect_start (SpitTransitionsEffect* self,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->start) {
		_iface_->start (self, visuals, motion);
	}
}

/**
     * Return true if the Effect needs the background cleared prior to calling {@link paint}.
     */
gboolean
spit_transitions_effect_needs_clear_background (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self), FALSE);
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->needs_clear_background) {
		return _iface_->needs_clear_background (self);
	}
	return FALSE;
}

/**
     * Called when the effect needs to paint (i.e. an expose or draw event has occurred).
     * 
     * This call should ''not'' advance the state of the effect (i.e. it may be called more than 
     * once for the same frame).
     *
     * @param ctx The Cairo context the Effect should use to paint the transition.
     * @param width The width (in pixels) of the Cairo surface.
     * @param height The height (in pixels) of the Cairo surface.
     * @param frame_number The ''one-based'' frame being drawn.
     */
void
spit_transitions_effect_paint (SpitTransitionsEffect* self,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion,
                               cairo_t* ctx,
                               gint width,
                               gint height,
                               gint frame_number)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->paint) {
		_iface_->paint (self, visuals, motion, ctx, width, height, frame_number);
	}
}

/**
     * Called to notify the effect that the state of the transition should advance to the specified
     * frame number.
     * 
     * Note: There is no guarantee frame numbers will be consecutive between calls
     * to next, especially if the transition clock is attempting to catch up.
     *
     * @param frame_number The ''one-based'' frame being advanced to.
     */
void
spit_transitions_effect_advance (SpitTransitionsEffect* self,
                                 SpitTransitionsVisuals* visuals,
                                 SpitTransitionsMotion* motion,
                                 gint frame_number)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->advance) {
		_iface_->advance (self, visuals, motion, frame_number);
	}
}

/**
     * Called if the Effect should halt the transition.
     * 
     * It only needs to reset state if {@link start} is called again.
     */
void
spit_transitions_effect_cancel (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->cancel) {
		_iface_->cancel (self);
	}
}

static void
spit_transitions_effect_real_reserved0 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved0 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_transitions_effect_real_reserved1 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved1 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_transitions_effect_real_reserved2 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved2 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_transitions_effect_real_reserved3 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved3 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_transitions_effect_real_reserved4 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved4 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_transitions_effect_real_reserved5 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved5 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_transitions_effect_real_reserved6 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved6 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_transitions_effect_real_reserved7 (SpitTransitionsEffect* self)
{
}

void
spit_transitions_effect_reserved7 (SpitTransitionsEffect* self)
{
	SpitTransitionsEffectIface* _iface_;
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
	_iface_ = SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_transitions_effect_default_init (SpitTransitionsEffectIface * iface,
                                      gpointer iface_data)
{
	iface->reserved0 = spit_transitions_effect_real_reserved0;
	iface->reserved1 = spit_transitions_effect_real_reserved1;
	iface->reserved2 = spit_transitions_effect_real_reserved2;
	iface->reserved3 = spit_transitions_effect_real_reserved3;
	iface->reserved4 = spit_transitions_effect_real_reserved4;
	iface->reserved5 = spit_transitions_effect_real_reserved5;
	iface->reserved6 = spit_transitions_effect_real_reserved6;
	iface->reserved7 = spit_transitions_effect_real_reserved7;
}

/**
 * An Effect represents an interstitial effect that is used to transition the display from one 
 * image to another.
 * 
 * An Effect must hold state so that it knows what it should be drawn at any call to {@link paint}
 * (which is called regularly during a transition). That is, it should be able to draw any frame of
 * the transition at any time. The same frame may need to be drawn multiple times, or the host
 * may skip ahead and ask for a frame well ahead of the last requested one.
 *
 * ''Frame numbers are one-based throughout this interface''. This is because the initial state (the
 * blank viewport or the starting pixbuf) is frame zero. The Effect is never called to paint this
 * frame.  The Effect is also not called to paint the final frame (a blank viewport or the ending
 * pixbuf).
 *
 * If the Effect uses background threads for its work, it should use the appropriate primitives
 * for critical sections. All calls to this interface will be from the context of the main UI
 * thread. ''None of these calls should block.''
 *
 * If the Details object needs to be held by the Effect, its reference to it should be dropped at
 * the end of the cycle (or shortly thereafter).
 *
 * An instance may be reused and should be prepared for restarts.
 */
static GType
spit_transitions_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsEffectIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_transitions_effect_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_transitions_effect_type_id;
	spit_transitions_effect_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitTransitionsEffect", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_transitions_effect_type_id, G_TYPE_OBJECT);
	return spit_transitions_effect_type_id;
}

GType
spit_transitions_effect_get_type (void)
{
	static volatile gsize spit_transitions_effect_type_id__once = 0;
	if (g_once_init_enter (&spit_transitions_effect_type_id__once)) {
		GType spit_transitions_effect_type_id;
		spit_transitions_effect_type_id = spit_transitions_effect_get_type_once ();
		g_once_init_leave (&spit_transitions_effect_type_id__once, spit_transitions_effect_type_id);
	}
	return spit_transitions_effect_type_id__once;
}

