/* PublishingInterfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from PublishingInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-plugin-dev-1.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SPIT_PUBLISHING_DEFAULT_ACCOUNT_0_PROPERTY,
	SPIT_PUBLISHING_DEFAULT_ACCOUNT_NUM_PROPERTIES
};
static GParamSpec* spit_publishing_default_account_properties[SPIT_PUBLISHING_DEFAULT_ACCOUNT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATED_SIGNAL,
	SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATION_FAILED_SIGNAL,
	SPIT_PUBLISHING_AUTHENTICATOR_NUM_SIGNALS
};
static guint spit_publishing_authenticator_signals[SPIT_PUBLISHING_AUTHENTICATOR_NUM_SIGNALS] = {0};

/**
 * Defines different kinds of errors that can occur during publishing.
 */

static gpointer spit_publishing_default_account_parent_class = NULL;
static SpitPublishingAccountIface * spit_publishing_default_account_spit_publishing_account_parent_iface = NULL;

static GType spit_publishing_authenticated_callback_get_type_once (void);
static void spit_publishing_publisher_real_reserved0 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved1 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved2 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved3 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved4 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved5 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved6 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved7 (SpitPublishingPublisher* self);
static GType spit_publishing_publisher_get_type_once (void);
static void spit_publishing_dialog_pane_real_reserved0 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved1 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved2 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved3 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved4 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved5 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved6 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved7 (SpitPublishingDialogPane* self);
static GType spit_publishing_dialog_pane_get_type_once (void);
static void spit_publishing_plugin_host_real_reserved0 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved1 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved2 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved3 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved4 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved5 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved6 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved7 (SpitPublishingPluginHost* self);
static GType spit_publishing_plugin_host_get_type_once (void);
static void spit_publishing_publishable_real_reserved0 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved1 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved2 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved3 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved4 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved5 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved6 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved7 (SpitPublishingPublishable* self);
static GType spit_publishing_publishable_get_type_once (void);
static GType spit_publishing_account_get_type_once (void);
static gchar* spit_publishing_default_account_real_display_name (SpitPublishingAccount* base);
static GType spit_publishing_default_account_get_type_once (void);
static SpitPublishingPublisher* spit_publishing_service_real_create_publisher_with_account (SpitPublishingService* self,
                                                                                     SpitPublishingPluginHost* host,
                                                                                     SpitPublishingAccount* account);
static GeeList* spit_publishing_service_real_get_accounts (SpitPublishingService* self,
                                                    const gchar* profile_id);
static void spit_publishing_service_real_reserved0 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved1 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved2 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved3 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved4 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved5 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved6 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved7 (SpitPublishingService* self);
static GType spit_publishing_service_get_type_once (void);
static GType spit_publishing_authenticator_get_type_once (void);
static GType spit_publishing_authenticator_factory_get_type_once (void);

GQuark
spit_publishing_publishing_error_quark (void)
{
	return g_quark_from_static_string ("spit-publishing-publishing-error-quark");
}

static GType
spit_publishing_publishing_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER, "SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER", "no-answer"}, {SPIT_PUBLISHING_PUBLISHING_ERROR_COMMUNICATION_FAILED, "SPIT_PUBLISHING_PUBLISHING_ERROR_COMMUNICATION_FAILED", "communication-failed"}, {SPIT_PUBLISHING_PUBLISHING_ERROR_PROTOCOL_ERROR, "SPIT_PUBLISHING_PUBLISHING_ERROR_PROTOCOL_ERROR", "protocol-error"}, {SPIT_PUBLISHING_PUBLISHING_ERROR_SERVICE_ERROR, "SPIT_PUBLISHING_PUBLISHING_ERROR_SERVICE_ERROR", "service-error"}, {SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE", "malformed-response"}, {SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR, "SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR", "local-file-error"}, {SPIT_PUBLISHING_PUBLISHING_ERROR_EXPIRED_SESSION, "SPIT_PUBLISHING_PUBLISHING_ERROR_EXPIRED_SESSION", "expired-session"}, {SPIT_PUBLISHING_PUBLISHING_ERROR_SSL_FAILED, "SPIT_PUBLISHING_PUBLISHING_ERROR_SSL_FAILED", "ssl-failed"}, {0, NULL, NULL}};
	GType spit_publishing_publishing_error_type_id;
	spit_publishing_publishing_error_type_id = g_enum_register_static ("SpitPublishingPublishingError", values);
	return spit_publishing_publishing_error_type_id;
}

GType
spit_publishing_publishing_error_get_type (void)
{
	static volatile gsize spit_publishing_publishing_error_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_publishing_error_type_id__once)) {
		GType spit_publishing_publishing_error_type_id;
		spit_publishing_publishing_error_type_id = spit_publishing_publishing_error_get_type_once ();
		g_once_init_leave (&spit_publishing_publishing_error_type_id__once, spit_publishing_publishing_error_type_id);
	}
	return spit_publishing_publishing_error_type_id__once;
}

void
spit_publishing_authenticated_callback_authenticated (SpitPublishingAuthenticatedCallback* self,
                                                      GHashTable* params)
{
	SpitPublishingAuthenticatedCallbackIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATED_CALLBACK (self));
	_iface_ = SPIT_PUBLISHING_AUTHENTICATED_CALLBACK_GET_INTERFACE (self);
	if (_iface_->authenticated) {
		_iface_->authenticated (self, params);
	}
}

static void
spit_publishing_authenticated_callback_default_init (SpitPublishingAuthenticatedCallbackIface * iface,
                                                     gpointer iface_data)
{
}

static GType
spit_publishing_authenticated_callback_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingAuthenticatedCallbackIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_authenticated_callback_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_authenticated_callback_type_id;
	spit_publishing_authenticated_callback_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingAuthenticatedCallback", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_authenticated_callback_type_id, G_TYPE_OBJECT);
	return spit_publishing_authenticated_callback_type_id;
}

GType
spit_publishing_authenticated_callback_get_type (void)
{
	static volatile gsize spit_publishing_authenticated_callback_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_authenticated_callback_type_id__once)) {
		GType spit_publishing_authenticated_callback_type_id;
		spit_publishing_authenticated_callback_type_id = spit_publishing_authenticated_callback_get_type_once ();
		g_once_init_leave (&spit_publishing_authenticated_callback_type_id__once, spit_publishing_authenticated_callback_type_id);
	}
	return spit_publishing_authenticated_callback_type_id__once;
}

/**
     * Describes the kinds of media a publishing service supports.
     *
     * Values can be masked together, for example: {{{(MediaType.PHOTO | MediaType.VIDEO)}}}
     * indicates that a publishing service supports the upload of both photos and videos.
     */
static GType
spit_publishing_publisher_media_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE", "none"}, {SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO", "photo"}, {SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO", "video"}, {0, NULL, NULL}};
	GType spit_publishing_publisher_media_type_type_id;
	spit_publishing_publisher_media_type_type_id = g_enum_register_static ("SpitPublishingPublisherMediaType", values);
	return spit_publishing_publisher_media_type_type_id;
}

GType
spit_publishing_publisher_media_type_get_type (void)
{
	static volatile gsize spit_publishing_publisher_media_type_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_publisher_media_type_type_id__once)) {
		GType spit_publishing_publisher_media_type_type_id;
		spit_publishing_publisher_media_type_type_id = spit_publishing_publisher_media_type_get_type_once ();
		g_once_init_leave (&spit_publishing_publisher_media_type_type_id__once, spit_publishing_publisher_media_type_type_id);
	}
	return spit_publishing_publisher_media_type_type_id__once;
}

/**
     * Returns a {@link Service} object describing the service to which this connects.
     */
SpitPublishingService*
spit_publishing_publisher_get_service (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self), NULL);
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->get_service) {
		return _iface_->get_service (self);
	}
	return NULL;
}

/**
     * Makes this publisher enter the running state and endows it with exclusive access
     * to the shared services provided by the {@link PluginHost}. Through the host’s interface,
     * this publisher can install user interface panes and query configuration information.
     * Only running services should perform network operations.
     */
void
spit_publishing_publisher_start (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->start) {
		_iface_->start (self);
	}
}

/**
     * Returns true if this publisher is in the running state; false otherwise.
     */
gboolean
spit_publishing_publisher_is_running (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self), FALSE);
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->is_running) {
		return _iface_->is_running (self);
	}
	return FALSE;
}

/**
     * Causes this publisher to enter a non-running state. This publisher should stop all
     * network operations and cease use of the shared services provided by the {@link PluginHost}.
     */
void
spit_publishing_publisher_stop (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->stop) {
		_iface_->stop (self);
	}
}

static void
spit_publishing_publisher_real_reserved0 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved0 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_publishing_publisher_real_reserved1 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved1 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_publishing_publisher_real_reserved2 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved2 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_publishing_publisher_real_reserved3 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved3 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_publishing_publisher_real_reserved4 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved4 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_publishing_publisher_real_reserved5 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved5 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_publishing_publisher_real_reserved6 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved6 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_publishing_publisher_real_reserved7 (SpitPublishingPublisher* self)
{
}

void
spit_publishing_publisher_reserved7 (SpitPublishingPublisher* self)
{
	SpitPublishingPublisherIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_publishing_publisher_default_init (SpitPublishingPublisherIface * iface,
                                        gpointer iface_data)
{
	iface->reserved0 = spit_publishing_publisher_real_reserved0;
	iface->reserved1 = spit_publishing_publisher_real_reserved1;
	iface->reserved2 = spit_publishing_publisher_real_reserved2;
	iface->reserved3 = spit_publishing_publisher_real_reserved3;
	iface->reserved4 = spit_publishing_publisher_real_reserved4;
	iface->reserved5 = spit_publishing_publisher_real_reserved5;
	iface->reserved6 = spit_publishing_publisher_real_reserved6;
	iface->reserved7 = spit_publishing_publisher_real_reserved7;
}

/** 
 * Represents a connection to a publishing service.
 *
 * Developers of publishing plugins provide a class that implements this interface. At
 * any given time, only one Publisher can be running. When a publisher is running, it is
 * allowed to access the network and has exclusive use of the shared user-interface and
 * configuration services provided by the {@link PluginHost}. Publishers are created in
 * a non-running state and do not begin running until start( ) is invoked. Publishers
 * run until stop( ) is invoked.
 */
static GType
spit_publishing_publisher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPublisherIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_publisher_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_publisher_type_id;
	spit_publishing_publisher_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPublisher", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_publisher_type_id, G_TYPE_OBJECT);
	return spit_publishing_publisher_type_id;
}

GType
spit_publishing_publisher_get_type (void)
{
	static volatile gsize spit_publishing_publisher_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_publisher_type_id__once)) {
		GType spit_publishing_publisher_type_id;
		spit_publishing_publisher_type_id = spit_publishing_publisher_get_type_once ();
		g_once_init_leave (&spit_publishing_publisher_type_id__once, spit_publishing_publisher_type_id);
	}
	return spit_publishing_publisher_type_id__once;
}

/**
     * Describes how the on-screen publishing dialog box should look and behave when an associated
     * pane is installed in the on-screen publishing dialog box.
     */
static GType
spit_publishing_dialog_pane_geometry_options_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE", "none"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE", "extended-size"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE", "resizable"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE", "colossal-size"}, {0, NULL, NULL}};
	GType spit_publishing_dialog_pane_geometry_options_type_id;
	spit_publishing_dialog_pane_geometry_options_type_id = g_enum_register_static ("SpitPublishingDialogPaneGeometryOptions", values);
	return spit_publishing_dialog_pane_geometry_options_type_id;
}

GType
spit_publishing_dialog_pane_geometry_options_get_type (void)
{
	static volatile gsize spit_publishing_dialog_pane_geometry_options_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_dialog_pane_geometry_options_type_id__once)) {
		GType spit_publishing_dialog_pane_geometry_options_type_id;
		spit_publishing_dialog_pane_geometry_options_type_id = spit_publishing_dialog_pane_geometry_options_get_type_once ();
		g_once_init_leave (&spit_publishing_dialog_pane_geometry_options_type_id__once, spit_publishing_dialog_pane_geometry_options_type_id);
	}
	return spit_publishing_dialog_pane_geometry_options_type_id__once;
}

/**
     * Returns the Gtk.Widget that is this pane's on-screen representation.
     */
GtkWidget*
spit_publishing_dialog_pane_get_widget (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self), NULL);
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->get_widget) {
		return _iface_->get_widget (self);
	}
	return NULL;
}

/**
     * Returns a {@link GeometryOptions} bitfield describing how the on-screen publishing dialog
     * box should look and behave when this pane is installed.
     */
SpitPublishingDialogPaneGeometryOptions
spit_publishing_dialog_pane_get_preferred_geometry (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self), 0);
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->get_preferred_geometry) {
		return _iface_->get_preferred_geometry (self);
	}
	return 0;
}

/**
     * Invoked automatically by Shotwell when this pane has been installed into the on-screen
     * publishing dialog box and become visible to the user.
     */
void
spit_publishing_dialog_pane_on_pane_installed (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->on_pane_installed) {
		_iface_->on_pane_installed (self);
	}
}

/**
     * Invoked automatically by Shotwell when this pane has been removed from the on-screen
     * publishing dialog box and is no longer visible to the user.
     */
void
spit_publishing_dialog_pane_on_pane_uninstalled (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->on_pane_uninstalled) {
		_iface_->on_pane_uninstalled (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved0 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved0 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved1 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved1 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved2 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved2 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved3 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved3 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved4 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved4 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved5 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved5 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved6 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved6 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_publishing_dialog_pane_real_reserved7 (SpitPublishingDialogPane* self)
{
}

void
spit_publishing_dialog_pane_reserved7 (SpitPublishingDialogPane* self)
{
	SpitPublishingDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
	_iface_ = SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_publishing_dialog_pane_default_init (SpitPublishingDialogPaneIface * iface,
                                          gpointer iface_data)
{
	iface->reserved0 = spit_publishing_dialog_pane_real_reserved0;
	iface->reserved1 = spit_publishing_dialog_pane_real_reserved1;
	iface->reserved2 = spit_publishing_dialog_pane_real_reserved2;
	iface->reserved3 = spit_publishing_dialog_pane_real_reserved3;
	iface->reserved4 = spit_publishing_dialog_pane_real_reserved4;
	iface->reserved5 = spit_publishing_dialog_pane_real_reserved5;
	iface->reserved6 = spit_publishing_dialog_pane_real_reserved6;
	iface->reserved7 = spit_publishing_dialog_pane_real_reserved7;
}

/**
 * Encapsulates a pane that can be installed in the on-screen publishing dialog box to
 * communicate status to and to get information from the user.
 *
 */
static GType
spit_publishing_dialog_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingDialogPaneIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_dialog_pane_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_dialog_pane_type_id;
	spit_publishing_dialog_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingDialogPane", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_dialog_pane_type_id, G_TYPE_OBJECT);
	return spit_publishing_dialog_pane_type_id;
}

GType
spit_publishing_dialog_pane_get_type (void)
{
	static volatile gsize spit_publishing_dialog_pane_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_dialog_pane_type_id__once)) {
		GType spit_publishing_dialog_pane_type_id;
		spit_publishing_dialog_pane_type_id = spit_publishing_dialog_pane_get_type_once ();
		g_once_init_leave (&spit_publishing_dialog_pane_type_id__once, spit_publishing_dialog_pane_type_id);
	}
	return spit_publishing_dialog_pane_type_id__once;
}

/**
     * Specifies the label text on the push button control that appears in the
     * lower-right-hand corner of the on-screen publishing dialog box.
     */
static GType
spit_publishing_plugin_host_button_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE, "SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE", "close"}, {SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL, "SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL", "cancel"}, {0, NULL, NULL}};
	GType spit_publishing_plugin_host_button_mode_type_id;
	spit_publishing_plugin_host_button_mode_type_id = g_enum_register_static ("SpitPublishingPluginHostButtonMode", values);
	return spit_publishing_plugin_host_button_mode_type_id;
}

GType
spit_publishing_plugin_host_button_mode_get_type (void)
{
	static volatile gsize spit_publishing_plugin_host_button_mode_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_plugin_host_button_mode_type_id__once)) {
		GType spit_publishing_plugin_host_button_mode_type_id;
		spit_publishing_plugin_host_button_mode_type_id = spit_publishing_plugin_host_button_mode_get_type_once ();
		g_once_init_leave (&spit_publishing_plugin_host_button_mode_type_id__once, spit_publishing_plugin_host_button_mode_type_id);
	}
	return spit_publishing_plugin_host_button_mode_type_id__once;
}

gchar*
spit_publishing_plugin_host_get_current_profile_id (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->get_current_profile_id) {
		return _iface_->get_current_profile_id (self);
	}
	return NULL;
}

/**
     * Notifies the user that an unrecoverable publishing error has occurred and halts
     * the publishing process.
     *
     * @param err An error object that describes the kind of error that occurred.
     */
void
spit_publishing_plugin_host_post_error (SpitPublishingPluginHost* self,
                                        GError* err)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->post_error) {
		_iface_->post_error (self, err);
	}
}

/**
     * Halts the publishing process.
     *
     * Calling this method stops all network activity and hides the on-screen publishing
     * dialog box.
     */
void
spit_publishing_plugin_host_stop_publishing (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->stop_publishing) {
		_iface_->stop_publishing (self);
	}
}

/**
     * Returns a reference to the {@link Publisher} object that this is currently hosting.
     */
SpitPublishingPublisher*
spit_publishing_plugin_host_get_publisher (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->get_publisher) {
		return _iface_->get_publisher (self);
	}
	return NULL;
}

/**
     * Attempts to install a pane in the on-screen publishing dialog box, making the pane visible
     * and allowing it to interact with the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param pane the pane to install
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void
spit_publishing_plugin_host_install_dialog_pane (SpitPublishingPluginHost* self,
                                                 SpitPublishingDialogPane* pane,
                                                 SpitPublishingPluginHostButtonMode mode)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_dialog_pane) {
		_iface_->install_dialog_pane (self, pane, mode);
	}
}

/**
     * Attempts to install a pane in the on-screen publishing dialog box that contains
     * static text.
     *
     * The text appears centered in the publishing dialog box and is drawn in
     * the system font. This is a convenience method only; similar results could be
     * achieved by manually constructing a Gtk.Label widget, wrapping it inside a
     * {@link DialogPane}, and installing it manually with a call to
     * install_dialog_pane( ). To provide visual consistency across publishing services,
     * however, always use this convenience method instead of constructing label panes when
     * you need to display static text to the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param message the text to show in the pane
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void
spit_publishing_plugin_host_install_static_message_pane (SpitPublishingPluginHost* self,
                                                         const gchar* message,
                                                         SpitPublishingPluginHostButtonMode mode)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_static_message_pane) {
		_iface_->install_static_message_pane (self, message, mode);
	}
}

/**
     * Works just like {@link install_static_message_pane} but allows markup to contain
     * Pango text formatting tags as well as unstyled text.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param markup the text to show in the pane, marked up with Pango formatting tags.
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void
spit_publishing_plugin_host_install_pango_message_pane (SpitPublishingPluginHost* self,
                                                        const gchar* markup,
                                                        SpitPublishingPluginHostButtonMode mode)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_pango_message_pane) {
		_iface_->install_pango_message_pane (self, markup, mode);
	}
}

/**
     * Attempts to install a pane in the on-screen publishing dialog box notifying the user
     * that his or her publishing operation completed successfully.
     * 
     * The text displayed depends on the type of media the current publishing service
     * supports. To provide visual consistency across publishing services and to allow
     * Shotwell to handle internationalization, always use this convenience method; don’t
     * construct and install success panes manually.
     *
     * If an error has posted, the {@link PluginHost} will not honor
     * this request.
     */
void
spit_publishing_plugin_host_install_success_pane (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_success_pane) {
		_iface_->install_success_pane (self);
	}
}

/**
     * Attempts to install a pane displaying the static text “Fetching account information...”
     * in the on-screen publishing dialog box, making it visible to the user.
     *
     * This is a convenience method only; similar results could be achieved by calling
     * {@link install_static_message_pane} with an appropriate text argument. To provide
     * visual consistency across publishing services and to allow Shotwell to handle
     * internationalization, however, you should always use this convenience method whenever
     * you need to tell the user that you’re querying account information over the network.
     * Queries such as this are almost always performed immediately after the user has logged
     * in to the remote service.
     * 
     * If an error has posted, the {@link PluginHost} will not honor this request.
     */
void
spit_publishing_plugin_host_install_account_fetch_wait_pane (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_account_fetch_wait_pane) {
		_iface_->install_account_fetch_wait_pane (self);
	}
}

/**
     * Works just like {@link install_account_fetch_wait_pane} but displays the static text
     * “Logging in...“
     * 
     * As with {@link install_account_fetch_wait_pane}, this is a convenience method, but
     * you should you use it provide to visual consistency and to let Shotwell handle
     * internationalization. See the description of {@link install_account_fetch_wait_pane}
     * for more information.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     */
void
spit_publishing_plugin_host_install_login_wait_pane (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_login_wait_pane) {
		_iface_->install_login_wait_pane (self);
	}
}

/**
     * Attempts to install a pane displaying the text 'welcome_message' above a push
     * button labeled “Login” in the on-screen publishing dialog box, making it visible to the
     * user.
     *
     * When the user clicks the “Login” button, you’ll be notified of the user’s action through
     * the callback 'on_login_clicked'. Every Publisher should provide a welcome pane to
     * introduce the service and explain service-specific features or restrictions. To provide
     * visual consistency across publishing services and to allow Shotwell to handle
     * internationalization, always use this convenience method; don’t construct and install
     * welcome panes manually.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param welcome_message the text to be displayed above a push button labeled “Login”
     * in the on-screen publishing dialog box.
     *
     * @param on_login_clicked specifies the callback that is invoked when the user clicks
     * the “Login” button.
     */
void
spit_publishing_plugin_host_install_welcome_pane (SpitPublishingPluginHost* self,
                                                  const gchar* welcome_message,
                                                  SpitPublishingLoginCallback on_login_clicked,
                                                  gpointer on_login_clicked_target)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_welcome_pane) {
		_iface_->install_welcome_pane (self, welcome_message, on_login_clicked, on_login_clicked_target);
	}
}

/**
     * Toggles whether the service selector combo box in the upper-right-hand corner of the
     * on-screen publishing dialog box is sensitive to input.
     *
     * Publishers should make the service selector box insensitive to input when they are performing
     * non-interruptible file or network operations, since switching to another publishing
     * service will halt whatever service is currently running. Under certain circumstances,
     * the {@link PluginHost} may not honor this request.
     *
     * @param is_locked when is_locked is true, the service selector combo box is made insensitive.
     * It appears greyed out and the user is prevented from switching to another publishing service.
     * When is_locked is false, the combo box is sensitive, allowing the user to freely switch
     * from the current service to another service. 
     */
void
spit_publishing_plugin_host_set_service_locked (SpitPublishingPluginHost* self,
                                                gboolean is_locked)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->set_service_locked) {
		_iface_->set_service_locked (self, is_locked);
	}
}

/**
     * Makes the designated widget the default widget for the publishing dialog.
     *
     * After a call to this method, the designated widget will be activated whenever the user
     * presses the [ENTER] key anywhere in the on-screen publishing dialog box. Under certain
     * circumstances, the {@link PluginHost} may not honor this request.
     *
     * @param widget a reference to the widget to designate as the default widget for the
     *               publishing dialog.
     */
void
spit_publishing_plugin_host_set_dialog_default_widget (SpitPublishingPluginHost* self,
                                                       GtkWidget* widget)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->set_dialog_default_widget) {
		_iface_->set_dialog_default_widget (self, widget);
	}
}

/**
     * Returns an array of the publishable media items that the user has selected for upload to the
     * remote service.
     */
SpitPublishingPublishable**
spit_publishing_plugin_host_get_publishables (SpitPublishingPluginHost* self,
                                              gint* result_length1)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->get_publishables) {
		return _iface_->get_publishables (self, result_length1);
	}
	return NULL;
}

/**
     * Writes all of the publishable media items that the user has selected for upload to the
     * remote service to a temporary directory on a local disk.
     *
     * You should call this method immediately before sending the publishable media items to the
     * remote service over the network. Because serializing several megabytes of data is a
     * potentially lengthy operation, calling this method installs an activity status pane in
     * the on-screen publishing dialog box. The activity status pane displays a progress bar along
     * with a string of informational text.
     *
     * Because sending items over the network to the remote service is also a potentially lengthy
     * operation, you should leave the activity status pane installed in the on-screen publishing
     * dialog box until this task is finished. Periodically during the sending process, you should
     * report to the user on the progress of his or her upload. You can do this by invoking the
     * returned {@link ProgressCallback} delegate.
     *
     * After calling this method, the activity status pane that this method installs remains
     * displayed in the on-screen publishing dialog box until you install a new pane.
     *
     * @param content_major_axis when serializing publishable media items that are photos,
     *                           ensure that neither the width nor the height of the serialized
     *                           photo is greater than content_major_axis pixels. The value of
     *                           this parameter has no effect on video publishables.
     *
     * @param strip_metadata when serializing publishable media items that are photos, if
     *                       strip_metadata is true, all EXIF, IPTC, and XMP metadata will be
     *                       removed from the serialized file. If strip_metadata is false, all
     *                       metadata will be left intact. The value of this parameter has no
     *                       effect on video publishables.
     */
SpitPublishingProgressCallback
spit_publishing_plugin_host_serialize_publishables (SpitPublishingPluginHost* self,
                                                    gint content_major_axis,
                                                    gboolean strip_metadata,
                                                    gpointer* result_target,
                                                    GDestroyNotify* result_target_destroy_notify)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->serialize_publishables) {
		return _iface_->serialize_publishables (self, content_major_axis, strip_metadata, result_target, result_target_destroy_notify);
	}
	return NULL;
}

/**
     * Returns a {@link Publisher.MediaType} bitfield describing which kinds of media are present
     * in the set of publishable media items that the user has selected for upload to the remote
     * service.
     */
SpitPublishingPublisherMediaType
spit_publishing_plugin_host_get_publishable_media_type (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), 0);
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->get_publishable_media_type) {
		return _iface_->get_publishable_media_type (self);
	}
	return 0;
}

void
spit_publishing_plugin_host_register_auth_callback (SpitPublishingPluginHost* self,
                                                    const gchar* cookie,
                                                    SpitPublishingAuthenticatedCallback* callback)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->register_auth_callback) {
		_iface_->register_auth_callback (self, cookie, callback);
	}
}

void
spit_publishing_plugin_host_unregister_auth_callback (SpitPublishingPluginHost* self,
                                                      const gchar* cookie)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->unregister_auth_callback) {
		_iface_->unregister_auth_callback (self, cookie);
	}
}

static void
spit_publishing_plugin_host_real_reserved0 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved0 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_publishing_plugin_host_real_reserved1 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved1 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_publishing_plugin_host_real_reserved2 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved2 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_publishing_plugin_host_real_reserved3 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved3 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_publishing_plugin_host_real_reserved4 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved4 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_publishing_plugin_host_real_reserved5 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved5 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_publishing_plugin_host_real_reserved6 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved6 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_publishing_plugin_host_real_reserved7 (SpitPublishingPluginHost* self)
{
}

void
spit_publishing_plugin_host_reserved7 (SpitPublishingPluginHost* self)
{
	SpitPublishingPluginHostIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_publishing_plugin_host_default_init (SpitPublishingPluginHostIface * iface,
                                          gpointer iface_data)
{
	iface->reserved0 = spit_publishing_plugin_host_real_reserved0;
	iface->reserved1 = spit_publishing_plugin_host_real_reserved1;
	iface->reserved2 = spit_publishing_plugin_host_real_reserved2;
	iface->reserved3 = spit_publishing_plugin_host_real_reserved3;
	iface->reserved4 = spit_publishing_plugin_host_real_reserved4;
	iface->reserved5 = spit_publishing_plugin_host_real_reserved5;
	iface->reserved6 = spit_publishing_plugin_host_real_reserved6;
	iface->reserved7 = spit_publishing_plugin_host_real_reserved7;
}

/**
 * Manages and provides services for publishing plugins.
 *
 * Implemented inside Shotwell, the PluginHost provides an interface through which the
 * developers of publishing plugins can query and make changes to the publishing
 * environment. For example, through the PluginHost, plugins can get a list of the photos
 * and videos to be published, install and remove user-interface panes in the publishing
 * dialog box, and request that the items to be uploaded be serialized to a temporary
 * directory on disk. Plugins can use the services of the PluginHost only when their
 * {@link Publisher} is in the running state. This ensures that non-running publishers
 * don’t destructively interfere with the actively running publisher.
 */
static GType
spit_publishing_plugin_host_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPluginHostIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_plugin_host_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_plugin_host_type_id;
	spit_publishing_plugin_host_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPluginHost", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_plugin_host_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (spit_publishing_plugin_host_type_id, SPIT_TYPE_HOST_INTERFACE);
	return spit_publishing_plugin_host_type_id;
}

GType
spit_publishing_plugin_host_get_type (void)
{
	static volatile gsize spit_publishing_plugin_host_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_plugin_host_type_id__once)) {
		GType spit_publishing_plugin_host_type_id;
		spit_publishing_plugin_host_type_id = spit_publishing_plugin_host_get_type_once ();
		g_once_init_leave (&spit_publishing_plugin_host_type_id__once, spit_publishing_plugin_host_type_id);
	}
	return spit_publishing_plugin_host_type_id__once;
}

/**
     * Returns a handle to the file on disk to which this publishable's data has been
     * serialized.
     *
     * You should use this file handle to read into memory the binary data you will send over
     * the network to the remote publishing service when this publishable is uploaded.
     */
GFile*
spit_publishing_publishable_get_serialized_file (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->get_serialized_file) {
		return _iface_->get_serialized_file (self);
	}
	return NULL;
}

/**
     * Returns a name that can be used to identify this publishable to the remote service.
     * If the publishing host cannot derive a sensible name, this method will
     * return an empty string. Plugins should be able to handle that situation
     * and provide a fallback value. One possible option for a fallback is:
     * get_param_string(Spit.Publishing.Publishable.PARAM_STRING_BASENAME)
     */
gchar*
spit_publishing_publishable_get_publishing_name (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->get_publishing_name) {
		return _iface_->get_publishing_name (self);
	}
	return NULL;
}

/**
     * Returns a string value from the publishable corresponding with the parameter name 
     * provided, or null if there is no value for this name.
     */
gchar*
spit_publishing_publishable_get_param_string (SpitPublishingPublishable* self,
                                              const gchar* name)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->get_param_string) {
		return _iface_->get_param_string (self, name);
	}
	return NULL;
}

/**
     * Returns an array of strings that should be used to tag or mark this publishable on the
     * remote service, or null if this publishable has no tags or markings.
     */
gchar**
spit_publishing_publishable_get_publishing_keywords (SpitPublishingPublishable* self,
                                                     gint* result_length1)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->get_publishing_keywords) {
		return _iface_->get_publishing_keywords (self, result_length1);
	}
	return NULL;
}

/**
     * Returns the kind of media item this publishable encapsulates.
     */
SpitPublishingPublisherMediaType
spit_publishing_publishable_get_media_type (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), 0);
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->get_media_type) {
		return _iface_->get_media_type (self);
	}
	return 0;
}

/**
     * Returns the creation timestamp on the file.
     */
GDateTime*
spit_publishing_publishable_get_exposure_date_time (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->get_exposure_date_time) {
		return _iface_->get_exposure_date_time (self);
	}
	return NULL;
}

/**
     * Returns the rating on the file.
     */
guint
spit_publishing_publishable_get_rating (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), 0U);
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->get_rating) {
		return _iface_->get_rating (self);
	}
	return 0U;
}

static void
spit_publishing_publishable_real_reserved0 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved0 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_publishing_publishable_real_reserved1 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved1 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_publishing_publishable_real_reserved2 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved2 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_publishing_publishable_real_reserved3 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved3 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_publishing_publishable_real_reserved4 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved4 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_publishing_publishable_real_reserved5 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved5 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_publishing_publishable_real_reserved6 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved6 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_publishing_publishable_real_reserved7 (SpitPublishingPublishable* self)
{
}

void
spit_publishing_publishable_reserved7 (SpitPublishingPublishable* self)
{
	SpitPublishingPublishableIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
	_iface_ = SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_publishing_publishable_default_init (SpitPublishingPublishableIface * iface,
                                          gpointer iface_data)
{
	iface->reserved0 = spit_publishing_publishable_real_reserved0;
	iface->reserved1 = spit_publishing_publishable_real_reserved1;
	iface->reserved2 = spit_publishing_publishable_real_reserved2;
	iface->reserved3 = spit_publishing_publishable_real_reserved3;
	iface->reserved4 = spit_publishing_publishable_real_reserved4;
	iface->reserved5 = spit_publishing_publishable_real_reserved5;
	iface->reserved6 = spit_publishing_publishable_real_reserved6;
	iface->reserved7 = spit_publishing_publishable_real_reserved7;
}

/**
 * Describes an underlying media item (such as a photo or a video) that your plugin
 * uploads to a remote publishing service.
 */
static GType
spit_publishing_publishable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPublishableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_publishable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_publishable_type_id;
	spit_publishing_publishable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPublishable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_publishable_type_id, G_TYPE_OBJECT);
	return spit_publishing_publishable_type_id;
}

GType
spit_publishing_publishable_get_type (void)
{
	static volatile gsize spit_publishing_publishable_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_publishable_type_id__once)) {
		GType spit_publishing_publishable_type_id;
		spit_publishing_publishable_type_id = spit_publishing_publishable_get_type_once ();
		g_once_init_leave (&spit_publishing_publishable_type_id__once, spit_publishing_publishable_type_id);
	}
	return spit_publishing_publishable_type_id__once;
}

gchar*
spit_publishing_account_display_name (SpitPublishingAccount* self)
{
	SpitPublishingAccountIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_ACCOUNT (self), NULL);
	_iface_ = SPIT_PUBLISHING_ACCOUNT_GET_INTERFACE (self);
	if (_iface_->display_name) {
		return _iface_->display_name (self);
	}
	return NULL;
}

static void
spit_publishing_account_default_init (SpitPublishingAccountIface * iface,
                                      gpointer iface_data)
{
}

static GType
spit_publishing_account_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingAccountIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_account_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_account_type_id;
	spit_publishing_account_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingAccount", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_account_type_id, G_TYPE_OBJECT);
	return spit_publishing_account_type_id;
}

GType
spit_publishing_account_get_type (void)
{
	static volatile gsize spit_publishing_account_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_account_type_id__once)) {
		GType spit_publishing_account_type_id;
		spit_publishing_account_type_id = spit_publishing_account_get_type_once ();
		g_once_init_leave (&spit_publishing_account_type_id__once, spit_publishing_account_type_id);
	}
	return spit_publishing_account_type_id__once;
}

static gchar*
spit_publishing_default_account_real_display_name (SpitPublishingAccount* base)
{
	SpitPublishingDefaultAccount * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SPIT_PUBLISHING_TYPE_DEFAULT_ACCOUNT, SpitPublishingDefaultAccount);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

SpitPublishingDefaultAccount*
spit_publishing_default_account_construct (GType object_type)
{
	SpitPublishingDefaultAccount * self = NULL;
	self = (SpitPublishingDefaultAccount*) g_object_new (object_type, NULL);
	return self;
}

SpitPublishingDefaultAccount*
spit_publishing_default_account_new (void)
{
	return spit_publishing_default_account_construct (SPIT_PUBLISHING_TYPE_DEFAULT_ACCOUNT);
}

static void
spit_publishing_default_account_class_init (SpitPublishingDefaultAccountClass * klass,
                                            gpointer klass_data)
{
	spit_publishing_default_account_parent_class = g_type_class_peek_parent (klass);
}

static void
spit_publishing_default_account_spit_publishing_account_interface_init (SpitPublishingAccountIface * iface,
                                                                        gpointer iface_data)
{
	spit_publishing_default_account_spit_publishing_account_parent_iface = g_type_interface_peek_parent (iface);
	iface->display_name = (gchar* (*) (SpitPublishingAccount*)) spit_publishing_default_account_real_display_name;
}

static void
spit_publishing_default_account_instance_init (SpitPublishingDefaultAccount * self,
                                               gpointer klass)
{
}

static GType
spit_publishing_default_account_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingDefaultAccountClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_default_account_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpitPublishingDefaultAccount), 0, (GInstanceInitFunc) spit_publishing_default_account_instance_init, NULL };
	static const GInterfaceInfo spit_publishing_account_info = { (GInterfaceInitFunc) spit_publishing_default_account_spit_publishing_account_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType spit_publishing_default_account_type_id;
	spit_publishing_default_account_type_id = g_type_register_static (G_TYPE_OBJECT, "SpitPublishingDefaultAccount", &g_define_type_info, 0);
	g_type_add_interface_static (spit_publishing_default_account_type_id, SPIT_PUBLISHING_TYPE_ACCOUNT, &spit_publishing_account_info);
	return spit_publishing_default_account_type_id;
}

GType
spit_publishing_default_account_get_type (void)
{
	static volatile gsize spit_publishing_default_account_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_default_account_type_id__once)) {
		GType spit_publishing_default_account_type_id;
		spit_publishing_default_account_type_id = spit_publishing_default_account_get_type_once ();
		g_once_init_leave (&spit_publishing_default_account_type_id__once, spit_publishing_default_account_type_id);
	}
	return spit_publishing_default_account_type_id__once;
}

/**
     * A factory method that instantiates and returns a new {@link Publisher} object that
     * encapsulates a connection to the remote publishing service that this Service describes.
     */
SpitPublishingPublisher*
spit_publishing_service_create_publisher (SpitPublishingService* self,
                                          SpitPublishingPluginHost* host)
{
	SpitPublishingServiceIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), NULL);
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->create_publisher) {
		return _iface_->create_publisher (self, host);
	}
	return NULL;
}

static SpitPublishingPublisher*
spit_publishing_service_real_create_publisher_with_account (SpitPublishingService* self,
                                                            SpitPublishingPluginHost* host,
                                                            SpitPublishingAccount* account)
{
	SpitPublishingPublisher* _tmp0_;
	SpitPublishingPublisher* result;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (host), NULL);
	g_return_val_if_fail ((account == NULL) || SPIT_PUBLISHING_IS_ACCOUNT (account), NULL);
	_tmp0_ = spit_publishing_service_create_publisher (self, host);
	result = _tmp0_;
	return result;
}

SpitPublishingPublisher*
spit_publishing_service_create_publisher_with_account (SpitPublishingService* self,
                                                       SpitPublishingPluginHost* host,
                                                       SpitPublishingAccount* account)
{
	SpitPublishingServiceIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), NULL);
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->create_publisher_with_account) {
		return _iface_->create_publisher_with_account (self, host, account);
	}
	return NULL;
}

/**
     * Returns the kinds of media that this service can work with.
     */
SpitPublishingPublisherMediaType
spit_publishing_service_get_supported_media (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), 0);
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_supported_media) {
		return _iface_->get_supported_media (self);
	}
	return 0;
}

/**
     * Returns a list of accounts associated with the service
     * Returns: null if there are no accounts, identifier
     */
static GeeList*
spit_publishing_service_real_get_accounts (SpitPublishingService* self,
                                           const gchar* profile_id)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	SpitPublishingDefaultAccount* _tmp1_;
	SpitPublishingDefaultAccount* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (profile_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (SPIT_PUBLISHING_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = spit_publishing_default_account_new ();
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SPIT_PUBLISHING_TYPE_ACCOUNT, SpitPublishingAccount));
	_g_object_unref0 (_tmp2_);
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_LIST, GeeList);
	return result;
}

GeeList*
spit_publishing_service_get_accounts (SpitPublishingService* self,
                                      const gchar* profile_id)
{
	SpitPublishingServiceIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), NULL);
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_accounts) {
		return _iface_->get_accounts (self, profile_id);
	}
	return NULL;
}

static void
spit_publishing_service_real_reserved0 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved0 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_publishing_service_real_reserved1 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved1 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_publishing_service_real_reserved2 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved2 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_publishing_service_real_reserved3 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved3 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_publishing_service_real_reserved4 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved4 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_publishing_service_real_reserved5 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved5 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_publishing_service_real_reserved6 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved6 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_publishing_service_real_reserved7 (SpitPublishingService* self)
{
}

void
spit_publishing_service_reserved7 (SpitPublishingService* self)
{
	SpitPublishingServiceIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
	_iface_ = SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_publishing_service_default_init (SpitPublishingServiceIface * iface,
                                      gpointer iface_data)
{
	iface->create_publisher_with_account = spit_publishing_service_real_create_publisher_with_account;
	iface->get_accounts = spit_publishing_service_real_get_accounts;
	iface->reserved0 = spit_publishing_service_real_reserved0;
	iface->reserved1 = spit_publishing_service_real_reserved1;
	iface->reserved2 = spit_publishing_service_real_reserved2;
	iface->reserved3 = spit_publishing_service_real_reserved3;
	iface->reserved4 = spit_publishing_service_real_reserved4;
	iface->reserved5 = spit_publishing_service_real_reserved5;
	iface->reserved6 = spit_publishing_service_real_reserved6;
	iface->reserved7 = spit_publishing_service_real_reserved7;
}

/**
 * Describes the features and capabilities of a remote publishing service.
 *
 * Developers of publishing plugins provide a class that implements this interface.
 */
static GType
spit_publishing_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_service_type_id;
	spit_publishing_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_service_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (spit_publishing_service_type_id, SPIT_TYPE_PLUGGABLE);
	return spit_publishing_service_type_id;
}

GType
spit_publishing_service_get_type (void)
{
	static volatile gsize spit_publishing_service_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_service_type_id__once)) {
		GType spit_publishing_service_type_id;
		spit_publishing_service_type_id = spit_publishing_service_get_type_once ();
		g_once_init_leave (&spit_publishing_service_type_id__once, spit_publishing_service_type_id);
	}
	return spit_publishing_service_type_id__once;
}

void
spit_publishing_authenticator_authenticate (SpitPublishingAuthenticator* self)
{
	SpitPublishingAuthenticatorIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self));
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self);
	if (_iface_->authenticate) {
		_iface_->authenticate (self);
	}
}

gboolean
spit_publishing_authenticator_can_logout (SpitPublishingAuthenticator* self)
{
	SpitPublishingAuthenticatorIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self), FALSE);
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self);
	if (_iface_->can_logout) {
		return _iface_->can_logout (self);
	}
	return FALSE;
}

void
spit_publishing_authenticator_logout (SpitPublishingAuthenticator* self)
{
	SpitPublishingAuthenticatorIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self));
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self);
	if (_iface_->logout) {
		_iface_->logout (self);
	}
}

void
spit_publishing_authenticator_refresh (SpitPublishingAuthenticator* self)
{
	SpitPublishingAuthenticatorIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self));
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self);
	if (_iface_->refresh) {
		_iface_->refresh (self);
	}
}

void
spit_publishing_authenticator_set_accountname (SpitPublishingAuthenticator* self,
                                               const gchar* name)
{
	SpitPublishingAuthenticatorIface* _iface_;
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self));
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self);
	if (_iface_->set_accountname) {
		_iface_->set_accountname (self, name);
	}
}

GHashTable*
spit_publishing_authenticator_get_authentication_parameter (SpitPublishingAuthenticator* self)
{
	SpitPublishingAuthenticatorIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self), NULL);
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self);
	if (_iface_->get_authentication_parameter) {
		return _iface_->get_authentication_parameter (self);
	}
	return NULL;
}

static void
spit_publishing_authenticator_default_init (SpitPublishingAuthenticatorIface * iface,
                                            gpointer iface_data)
{
	spit_publishing_authenticator_signals[SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATED_SIGNAL] = g_signal_new ("authenticated", SPIT_PUBLISHING_TYPE_AUTHENTICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	spit_publishing_authenticator_signals[SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATION_FAILED_SIGNAL] = g_signal_new ("authentication-failed", SPIT_PUBLISHING_TYPE_AUTHENTICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
spit_publishing_authenticator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingAuthenticatorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_authenticator_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_authenticator_type_id;
	spit_publishing_authenticator_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingAuthenticator", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_authenticator_type_id, G_TYPE_OBJECT);
	return spit_publishing_authenticator_type_id;
}

GType
spit_publishing_authenticator_get_type (void)
{
	static volatile gsize spit_publishing_authenticator_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_authenticator_type_id__once)) {
		GType spit_publishing_authenticator_type_id;
		spit_publishing_authenticator_type_id = spit_publishing_authenticator_get_type_once ();
		g_once_init_leave (&spit_publishing_authenticator_type_id__once, spit_publishing_authenticator_type_id);
	}
	return spit_publishing_authenticator_type_id__once;
}

GeeList*
spit_publishing_authenticator_factory_get_available_authenticators (SpitPublishingAuthenticatorFactory* self)
{
	SpitPublishingAuthenticatorFactoryIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR_FACTORY (self), NULL);
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_FACTORY_GET_INTERFACE (self);
	if (_iface_->get_available_authenticators) {
		return _iface_->get_available_authenticators (self);
	}
	return NULL;
}

SpitPublishingAuthenticator*
spit_publishing_authenticator_factory_create (SpitPublishingAuthenticatorFactory* self,
                                              const gchar* provider,
                                              SpitPublishingPluginHost* host)
{
	SpitPublishingAuthenticatorFactoryIface* _iface_;
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR_FACTORY (self), NULL);
	_iface_ = SPIT_PUBLISHING_AUTHENTICATOR_FACTORY_GET_INTERFACE (self);
	if (_iface_->create) {
		return _iface_->create (self, provider, host);
	}
	return NULL;
}

static void
spit_publishing_authenticator_factory_default_init (SpitPublishingAuthenticatorFactoryIface * iface,
                                                    gpointer iface_data)
{
}

static GType
spit_publishing_authenticator_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingAuthenticatorFactoryIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_publishing_authenticator_factory_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_publishing_authenticator_factory_type_id;
	spit_publishing_authenticator_factory_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingAuthenticatorFactory", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_publishing_authenticator_factory_type_id, G_TYPE_OBJECT);
	return spit_publishing_authenticator_factory_type_id;
}

GType
spit_publishing_authenticator_factory_get_type (void)
{
	static volatile gsize spit_publishing_authenticator_factory_type_id__once = 0;
	if (g_once_init_enter (&spit_publishing_authenticator_factory_type_id__once)) {
		GType spit_publishing_authenticator_factory_type_id;
		spit_publishing_authenticator_factory_type_id = spit_publishing_authenticator_factory_get_type_once ();
		g_once_init_leave (&spit_publishing_authenticator_factory_type_id__once, spit_publishing_authenticator_factory_type_id);
	}
	return spit_publishing_authenticator_factory_type_id__once;
}

