/* StripesEffect.c generated by valac 0.56.17, the Vala compiler
 * generated from StripesEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "shotwell-plugin-dev-1.0.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define STRIPES_EFFECT_DESIRED_FPS 25
#define STRIPES_EFFECT_MIN_FPS 10
#define STRIPES_EFFECT_STRIPE_HEIGHT 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_STRIPES_EFFECT_DESCRIPTOR (stripes_effect_descriptor_get_type ())
#define STRIPES_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRIPES_EFFECT_DESCRIPTOR, StripesEffectDescriptor))
#define STRIPES_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRIPES_EFFECT_DESCRIPTOR, StripesEffectDescriptorClass))
#define IS_STRIPES_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRIPES_EFFECT_DESCRIPTOR))
#define IS_STRIPES_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRIPES_EFFECT_DESCRIPTOR))
#define STRIPES_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRIPES_EFFECT_DESCRIPTOR, StripesEffectDescriptorClass))

typedef struct _StripesEffectDescriptor StripesEffectDescriptor;
typedef struct _StripesEffectDescriptorClass StripesEffectDescriptorClass;
typedef struct _StripesEffectDescriptorPrivate StripesEffectDescriptorPrivate;
enum  {
	STRIPES_EFFECT_DESCRIPTOR_0_PROPERTY,
	STRIPES_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* stripes_effect_descriptor_properties[STRIPES_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_STRIPES_EFFECT (stripes_effect_get_type ())
#define STRIPES_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRIPES_EFFECT, StripesEffect))
#define STRIPES_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRIPES_EFFECT, StripesEffectClass))
#define IS_STRIPES_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRIPES_EFFECT))
#define IS_STRIPES_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRIPES_EFFECT))
#define STRIPES_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRIPES_EFFECT, StripesEffectClass))

typedef struct _StripesEffect StripesEffect;
typedef struct _StripesEffectClass StripesEffectClass;
typedef struct _StripesEffectPrivate StripesEffectPrivate;
enum  {
	STRIPES_EFFECT_0_PROPERTY,
	STRIPES_EFFECT_NUM_PROPERTIES
};
static GParamSpec* stripes_effect_properties[STRIPES_EFFECT_NUM_PROPERTIES];

struct _StripesEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	StripesEffectDescriptorPrivate * priv;
};

struct _StripesEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _StripesEffect {
	GObject parent_instance;
	StripesEffectPrivate * priv;
};

struct _StripesEffectClass {
	GObjectClass parent_class;
};

struct _StripesEffectPrivate {
	gint stripe_count;
};

static gpointer stripes_effect_descriptor_parent_class = NULL;
static gint StripesEffect_private_offset;
static gpointer stripes_effect_parent_class = NULL;
static SpitTransitionsEffectIface * stripes_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType stripes_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StripesEffectDescriptor* stripes_effect_descriptor_new (void);
VALA_EXTERN StripesEffectDescriptor* stripes_effect_descriptor_construct (GType object_type);
static const gchar* stripes_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* stripes_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* stripes_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                              SpitHostInterface* host);
VALA_EXTERN StripesEffect* stripes_effect_new (void);
VALA_EXTERN StripesEffect* stripes_effect_construct (GType object_type);
VALA_EXTERN GType stripes_effect_get_type (void) G_GNUC_CONST ;
static GType stripes_effect_descriptor_get_type_once (void);
static void stripes_effect_real_get_fps (SpitTransitionsEffect* base,
                                  gint* desired_fps,
                                  gint* min_fps);
static void stripes_effect_real_start (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion);
static gboolean stripes_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void stripes_effect_real_paint (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                cairo_t* ctx,
                                gint width,
                                gint height,
                                gint frame_number);
static void stripes_effect_real_advance (SpitTransitionsEffect* base,
                                  SpitTransitionsVisuals* visuals,
                                  SpitTransitionsMotion* motion,
                                  gint frame_number);
static void stripes_effect_real_cancel (SpitTransitionsEffect* base);
static void stripes_effect_finalize (GObject * obj);
static GType stripes_effect_get_type_once (void);

StripesEffectDescriptor*
stripes_effect_descriptor_construct (GType object_type)
{
	StripesEffectDescriptor * self = NULL;
	self = (StripesEffectDescriptor*) shotwell_transition_descriptor_construct (object_type);
	return self;
}

StripesEffectDescriptor*
stripes_effect_descriptor_new (void)
{
	return stripes_effect_descriptor_construct (TYPE_STRIPES_EFFECT_DESCRIPTOR);
}

static const gchar*
stripes_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	StripesEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT_DESCRIPTOR, StripesEffectDescriptor);
	result = "org.gnome.shotwell.transitions.stripes";
	return result;
}

static const gchar*
stripes_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	StripesEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT_DESCRIPTOR, StripesEffectDescriptor);
	result = _ ("Stripes");
	return result;
}

static SpitTransitionsEffect*
stripes_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                       SpitHostInterface* host)
{
	StripesEffectDescriptor * self;
	StripesEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT_DESCRIPTOR, StripesEffectDescriptor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (host, SPIT_TYPE_HOST_INTERFACE), NULL);
	_tmp0_ = stripes_effect_new ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
	return result;
}

static void
stripes_effect_descriptor_class_init (StripesEffectDescriptorClass * klass,
                                      gpointer klass_data)
{
	stripes_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) stripes_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) stripes_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) stripes_effect_descriptor_real_create;
}

static void
stripes_effect_descriptor_instance_init (StripesEffectDescriptor * self,
                                         gpointer klass)
{
}

static GType
stripes_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StripesEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stripes_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StripesEffectDescriptor), 0, (GInstanceInitFunc) stripes_effect_descriptor_instance_init, NULL };
	GType stripes_effect_descriptor_type_id;
	stripes_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "StripesEffectDescriptor", &g_define_type_info, 0);
	return stripes_effect_descriptor_type_id;
}

GType
stripes_effect_descriptor_get_type (void)
{
	static volatile gsize stripes_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&stripes_effect_descriptor_type_id__once)) {
		GType stripes_effect_descriptor_type_id;
		stripes_effect_descriptor_type_id = stripes_effect_descriptor_get_type_once ();
		g_once_init_leave (&stripes_effect_descriptor_type_id__once, stripes_effect_descriptor_type_id);
	}
	return stripes_effect_descriptor_type_id__once;
}

static inline gpointer
stripes_effect_get_instance_private (StripesEffect* self)
{
	return G_STRUCT_MEMBER_P (self, StripesEffect_private_offset);
}

StripesEffect*
stripes_effect_construct (GType object_type)
{
	StripesEffect * self = NULL;
	self = (StripesEffect*) g_object_new (object_type, NULL);
	return self;
}

StripesEffect*
stripes_effect_new (void)
{
	return stripes_effect_construct (TYPE_STRIPES_EFFECT);
}

static void
stripes_effect_real_get_fps (SpitTransitionsEffect* base,
                             gint* desired_fps,
                             gint* min_fps)
{
	StripesEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT, StripesEffect);
	_vala_desired_fps = STRIPES_EFFECT_DESIRED_FPS;
	_vala_min_fps = STRIPES_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
stripes_effect_real_start (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion)
{
	StripesEffect * self;
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT, StripesEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
	spit_transitions_visuals_get_to_pos (visuals, &_tmp0_);
	_tmp1_ = _tmp0_;
	self->priv->stripe_count = (_tmp1_.height / STRIPES_EFFECT_STRIPE_HEIGHT) + 1;
}

static gboolean
stripes_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	StripesEffect * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT, StripesEffect);
	result = TRUE;
	return result;
}

static void
stripes_effect_real_paint (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           cairo_t* ctx,
                           gint width,
                           gint height,
                           gint frame_number)
{
	StripesEffect * self;
	gdouble alpha = 0.0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT, StripesEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkRectangle _tmp4_ = {0};
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle _tmp7_;
		_tmp2_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp3_ = _tmp2_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp4_);
		_tmp5_ = _tmp4_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
		_tmp7_ = _tmp6_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp3_, (gdouble) _tmp5_.x, (gdouble) _tmp7_.y);
		cairo_paint_with_alpha (ctx, 1 - fmin ((gdouble) 1, alpha * 2));
	}
	_tmp8_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_ = {0};
		GdkRectangle _tmp15_;
		gint x = 0;
		GdkRectangle _tmp16_ = {0};
		GdkRectangle _tmp17_;
		gint y = 0;
		GdkRectangle _tmp18_ = {0};
		GdkRectangle _tmp19_;
		_tmp10_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp11_ = _tmp10_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp12_);
		_tmp13_ = _tmp12_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp14_);
		_tmp15_ = _tmp14_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp11_, (gdouble) _tmp13_.x, (gdouble) _tmp15_.y);
		spit_transitions_visuals_get_to_pos (visuals, &_tmp16_);
		_tmp17_ = _tmp16_;
		x = _tmp17_.x;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp18_);
		_tmp19_ = _tmp18_;
		y = _tmp19_.y;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp20_ = FALSE;
				_tmp20_ = TRUE;
				while (TRUE) {
					SpitTransitionsDirection _tmp22_;
					SpitTransitionsDirection _tmp23_;
					if (!_tmp20_) {
						gint _tmp21_;
						_tmp21_ = i;
						i = _tmp21_ + 1;
					}
					_tmp20_ = FALSE;
					if (!(i <= self->priv->stripe_count)) {
						break;
					}
					_tmp22_ = spit_transitions_motion_get_direction (motion);
					_tmp23_ = _tmp22_;
					if ((i % 2) == ((gint) _tmp23_)) {
						GdkRectangle _tmp24_ = {0};
						GdkRectangle _tmp25_;
						GdkRectangle _tmp26_ = {0};
						GdkRectangle _tmp27_;
						GdkRectangle _tmp28_ = {0};
						GdkRectangle _tmp29_;
						spit_transitions_visuals_get_to_pos (visuals, &_tmp24_);
						_tmp25_ = _tmp24_;
						spit_transitions_visuals_get_to_pos (visuals, &_tmp26_);
						_tmp27_ = _tmp26_;
						spit_transitions_visuals_get_to_pos (visuals, &_tmp28_);
						_tmp29_ = _tmp28_;
						cairo_rectangle (ctx, (x + _tmp25_.width) - (alpha * _tmp27_.width), (gdouble) (y + (i * STRIPES_EFFECT_STRIPE_HEIGHT)), (gdouble) (x + _tmp29_.width), (gdouble) STRIPES_EFFECT_STRIPE_HEIGHT);
					} else {
						GdkRectangle _tmp30_ = {0};
						GdkRectangle _tmp31_;
						spit_transitions_visuals_get_to_pos (visuals, &_tmp30_);
						_tmp31_ = _tmp30_;
						cairo_rectangle (ctx, (gdouble) x, (gdouble) (y + (STRIPES_EFFECT_STRIPE_HEIGHT * i)), _tmp31_.width * alpha, (gdouble) STRIPES_EFFECT_STRIPE_HEIGHT);
					}
				}
			}
		}
		cairo_clip (ctx);
		cairo_paint_with_alpha (ctx, alpha);
	}
}

static void
stripes_effect_real_advance (SpitTransitionsEffect* base,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsMotion* motion,
                             gint frame_number)
{
	StripesEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT, StripesEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
}

static void
stripes_effect_real_cancel (SpitTransitionsEffect* base)
{
	StripesEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_STRIPES_EFFECT, StripesEffect);
}

static void
stripes_effect_class_init (StripesEffectClass * klass,
                           gpointer klass_data)
{
	stripes_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StripesEffect_private_offset);
	G_OBJECT_CLASS (klass)->finalize = stripes_effect_finalize;
}

static void
stripes_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                       gpointer iface_data)
{
	stripes_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) stripes_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) stripes_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) stripes_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) stripes_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) stripes_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) stripes_effect_real_cancel;
}

static void
stripes_effect_instance_init (StripesEffect * self,
                              gpointer klass)
{
	self->priv = stripes_effect_get_instance_private (self);
}

static void
stripes_effect_finalize (GObject * obj)
{
	StripesEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRIPES_EFFECT, StripesEffect);
	G_OBJECT_CLASS (stripes_effect_parent_class)->finalize (obj);
}

static GType
stripes_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StripesEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stripes_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StripesEffect), 0, (GInstanceInitFunc) stripes_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) stripes_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType stripes_effect_type_id;
	stripes_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "StripesEffect", &g_define_type_info, 0);
	g_type_add_interface_static (stripes_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	StripesEffect_private_offset = g_type_add_instance_private (stripes_effect_type_id, sizeof (StripesEffectPrivate));
	return stripes_effect_type_id;
}

GType
stripes_effect_get_type (void)
{
	static volatile gsize stripes_effect_type_id__once = 0;
	if (g_once_init_enter (&stripes_effect_type_id__once)) {
		GType stripes_effect_type_id;
		stripes_effect_type_id = stripes_effect_get_type_once ();
		g_once_init_leave (&stripes_effect_type_id__once, stripes_effect_type_id);
	}
	return stripes_effect_type_id__once;
}

