/* FadeEffect.c generated by valac 0.56.17, the Vala compiler
 * generated from FadeEffect.vala, do not modify */

/* Copyright 2010 Maxim Kartashev
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "shotwell-plugin-dev-1.0.h"
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#define FADE_EFFECT_DESIRED_FPS 30
#define FADE_EFFECT_MIN_FPS 20
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_FADE_EFFECT_DESCRIPTOR (fade_effect_descriptor_get_type ())
#define FADE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_EFFECT_DESCRIPTOR, FadeEffectDescriptor))
#define FADE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_EFFECT_DESCRIPTOR, FadeEffectDescriptorClass))
#define IS_FADE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_EFFECT_DESCRIPTOR))
#define IS_FADE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_EFFECT_DESCRIPTOR))
#define FADE_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_EFFECT_DESCRIPTOR, FadeEffectDescriptorClass))

typedef struct _FadeEffectDescriptor FadeEffectDescriptor;
typedef struct _FadeEffectDescriptorClass FadeEffectDescriptorClass;
typedef struct _FadeEffectDescriptorPrivate FadeEffectDescriptorPrivate;
enum  {
	FADE_EFFECT_DESCRIPTOR_0_PROPERTY,
	FADE_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* fade_effect_descriptor_properties[FADE_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_FADE_EFFECT (fade_effect_get_type ())
#define FADE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_EFFECT, FadeEffect))
#define FADE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_EFFECT, FadeEffectClass))
#define IS_FADE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_EFFECT))
#define IS_FADE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_EFFECT))
#define FADE_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_EFFECT, FadeEffectClass))

typedef struct _FadeEffect FadeEffect;
typedef struct _FadeEffectClass FadeEffectClass;
typedef struct _FadeEffectPrivate FadeEffectPrivate;
enum  {
	FADE_EFFECT_0_PROPERTY,
	FADE_EFFECT_NUM_PROPERTIES
};
static GParamSpec* fade_effect_properties[FADE_EFFECT_NUM_PROPERTIES];

struct _FadeEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	FadeEffectDescriptorPrivate * priv;
};

struct _FadeEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _FadeEffect {
	GObject parent_instance;
	FadeEffectPrivate * priv;
};

struct _FadeEffectClass {
	GObjectClass parent_class;
};

static gpointer fade_effect_descriptor_parent_class = NULL;
static gpointer fade_effect_parent_class = NULL;
static SpitTransitionsEffectIface * fade_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType fade_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FadeEffectDescriptor* fade_effect_descriptor_new (void);
VALA_EXTERN FadeEffectDescriptor* fade_effect_descriptor_construct (GType object_type);
static const gchar* fade_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* fade_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* fade_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                           SpitHostInterface* host);
VALA_EXTERN FadeEffect* fade_effect_new (void);
VALA_EXTERN FadeEffect* fade_effect_construct (GType object_type);
VALA_EXTERN GType fade_effect_get_type (void) G_GNUC_CONST ;
static GType fade_effect_descriptor_get_type_once (void);
static void fade_effect_real_get_fps (SpitTransitionsEffect* base,
                               gint* desired_fps,
                               gint* min_fps);
static void fade_effect_real_start (SpitTransitionsEffect* base,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsMotion* motion);
static gboolean fade_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void fade_effect_real_paint (SpitTransitionsEffect* base,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsMotion* motion,
                             cairo_t* ctx,
                             gint width,
                             gint height,
                             gint frame_number);
static void fade_effect_real_advance (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion,
                               gint frame_number);
static void fade_effect_real_cancel (SpitTransitionsEffect* base);
static GType fade_effect_get_type_once (void);

FadeEffectDescriptor*
fade_effect_descriptor_construct (GType object_type)
{
	FadeEffectDescriptor * self = NULL;
	self = (FadeEffectDescriptor*) shotwell_transition_descriptor_construct (object_type);
	return self;
}

FadeEffectDescriptor*
fade_effect_descriptor_new (void)
{
	return fade_effect_descriptor_construct (TYPE_FADE_EFFECT_DESCRIPTOR);
}

static const gchar*
fade_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	FadeEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT_DESCRIPTOR, FadeEffectDescriptor);
	result = "org.gnome.shotwell.transitions.fade";
	return result;
}

static const gchar*
fade_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	FadeEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT_DESCRIPTOR, FadeEffectDescriptor);
	result = _ ("Fade");
	return result;
}

static SpitTransitionsEffect*
fade_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                    SpitHostInterface* host)
{
	FadeEffectDescriptor * self;
	FadeEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT_DESCRIPTOR, FadeEffectDescriptor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (host, SPIT_TYPE_HOST_INTERFACE), NULL);
	_tmp0_ = fade_effect_new ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
	return result;
}

static void
fade_effect_descriptor_class_init (FadeEffectDescriptorClass * klass,
                                   gpointer klass_data)
{
	fade_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) fade_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) fade_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) fade_effect_descriptor_real_create;
}

static void
fade_effect_descriptor_instance_init (FadeEffectDescriptor * self,
                                      gpointer klass)
{
}

static GType
fade_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FadeEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fade_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FadeEffectDescriptor), 0, (GInstanceInitFunc) fade_effect_descriptor_instance_init, NULL };
	GType fade_effect_descriptor_type_id;
	fade_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "FadeEffectDescriptor", &g_define_type_info, 0);
	return fade_effect_descriptor_type_id;
}

GType
fade_effect_descriptor_get_type (void)
{
	static volatile gsize fade_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&fade_effect_descriptor_type_id__once)) {
		GType fade_effect_descriptor_type_id;
		fade_effect_descriptor_type_id = fade_effect_descriptor_get_type_once ();
		g_once_init_leave (&fade_effect_descriptor_type_id__once, fade_effect_descriptor_type_id);
	}
	return fade_effect_descriptor_type_id__once;
}

FadeEffect*
fade_effect_construct (GType object_type)
{
	FadeEffect * self = NULL;
	self = (FadeEffect*) g_object_new (object_type, NULL);
	return self;
}

FadeEffect*
fade_effect_new (void)
{
	return fade_effect_construct (TYPE_FADE_EFFECT);
}

static void
fade_effect_real_get_fps (SpitTransitionsEffect* base,
                          gint* desired_fps,
                          gint* min_fps)
{
	FadeEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT, FadeEffect);
	_vala_desired_fps = FADE_EFFECT_DESIRED_FPS;
	_vala_min_fps = FADE_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
fade_effect_real_start (SpitTransitionsEffect* base,
                        SpitTransitionsVisuals* visuals,
                        SpitTransitionsMotion* motion)
{
	FadeEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT, FadeEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
}

static gboolean
fade_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	FadeEffect * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT, FadeEffect);
	result = TRUE;
	return result;
}

static void
fade_effect_real_paint (SpitTransitionsEffect* base,
                        SpitTransitionsVisuals* visuals,
                        SpitTransitionsMotion* motion,
                        cairo_t* ctx,
                        gint width,
                        gint height,
                        gint frame_number)
{
	FadeEffect * self;
	gdouble alpha = 0.0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT, FadeEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkRectangle _tmp4_ = {0};
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle _tmp7_;
		_tmp2_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp3_ = _tmp2_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp4_);
		_tmp5_ = _tmp4_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
		_tmp7_ = _tmp6_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp3_, (gdouble) _tmp5_.x, (gdouble) _tmp7_.y);
		cairo_paint_with_alpha (ctx, 1.0 - alpha);
	}
	_tmp8_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_ = {0};
		GdkRectangle _tmp15_;
		_tmp10_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp11_ = _tmp10_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp12_);
		_tmp13_ = _tmp12_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp14_);
		_tmp15_ = _tmp14_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp11_, (gdouble) _tmp13_.x, (gdouble) _tmp15_.y);
		cairo_paint_with_alpha (ctx, alpha);
	}
}

static void
fade_effect_real_advance (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion,
                          gint frame_number)
{
	FadeEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT, FadeEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
}

static void
fade_effect_real_cancel (SpitTransitionsEffect* base)
{
	FadeEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FADE_EFFECT, FadeEffect);
}

static void
fade_effect_class_init (FadeEffectClass * klass,
                        gpointer klass_data)
{
	fade_effect_parent_class = g_type_class_peek_parent (klass);
}

static void
fade_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                    gpointer iface_data)
{
	fade_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) fade_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) fade_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) fade_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) fade_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) fade_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) fade_effect_real_cancel;
}

static void
fade_effect_instance_init (FadeEffect * self,
                           gpointer klass)
{
}

static GType
fade_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FadeEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fade_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FadeEffect), 0, (GInstanceInitFunc) fade_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) fade_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType fade_effect_type_id;
	fade_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "FadeEffect", &g_define_type_info, 0);
	g_type_add_interface_static (fade_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	return fade_effect_type_id;
}

GType
fade_effect_get_type (void)
{
	static volatile gsize fade_effect_type_id__once = 0;
	if (g_once_init_enter (&fade_effect_type_id__once)) {
		GType fade_effect_type_id;
		fade_effect_type_id = fade_effect_get_type_once ();
		g_once_init_leave (&fade_effect_type_id__once, fade_effect_type_id);
	}
	return fade_effect_type_id__once;
}

