/* CirclesEffect.c generated by valac 0.56.17, the Vala compiler
 * generated from CirclesEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "shotwell-plugin-dev-1.0.h"
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#define CIRCLES_EFFECT_DESIRED_FPS 25
#define CIRCLES_EFFECT_MIN_FPS 15
#define CIRCLES_EFFECT_SPEED 2.5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_CIRCLES_EFFECT_DESCRIPTOR (circles_effect_descriptor_get_type ())
#define CIRCLES_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCLES_EFFECT_DESCRIPTOR, CirclesEffectDescriptor))
#define CIRCLES_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCLES_EFFECT_DESCRIPTOR, CirclesEffectDescriptorClass))
#define IS_CIRCLES_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCLES_EFFECT_DESCRIPTOR))
#define IS_CIRCLES_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCLES_EFFECT_DESCRIPTOR))
#define CIRCLES_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCLES_EFFECT_DESCRIPTOR, CirclesEffectDescriptorClass))

typedef struct _CirclesEffectDescriptor CirclesEffectDescriptor;
typedef struct _CirclesEffectDescriptorClass CirclesEffectDescriptorClass;
typedef struct _CirclesEffectDescriptorPrivate CirclesEffectDescriptorPrivate;
enum  {
	CIRCLES_EFFECT_DESCRIPTOR_0_PROPERTY,
	CIRCLES_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* circles_effect_descriptor_properties[CIRCLES_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CIRCLES_EFFECT (circles_effect_get_type ())
#define CIRCLES_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCLES_EFFECT, CirclesEffect))
#define CIRCLES_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCLES_EFFECT, CirclesEffectClass))
#define IS_CIRCLES_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCLES_EFFECT))
#define IS_CIRCLES_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCLES_EFFECT))
#define CIRCLES_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCLES_EFFECT, CirclesEffectClass))

typedef struct _CirclesEffect CirclesEffect;
typedef struct _CirclesEffectClass CirclesEffectClass;
typedef struct _CirclesEffectPrivate CirclesEffectPrivate;
enum  {
	CIRCLES_EFFECT_0_PROPERTY,
	CIRCLES_EFFECT_NUM_PROPERTIES
};
static GParamSpec* circles_effect_properties[CIRCLES_EFFECT_NUM_PROPERTIES];

struct _CirclesEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	CirclesEffectDescriptorPrivate * priv;
};

struct _CirclesEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _CirclesEffect {
	GObject parent_instance;
	CirclesEffectPrivate * priv;
};

struct _CirclesEffectClass {
	GObjectClass parent_class;
};

static gpointer circles_effect_descriptor_parent_class = NULL;
static gpointer circles_effect_parent_class = NULL;
static SpitTransitionsEffectIface * circles_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType circles_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CirclesEffectDescriptor* circles_effect_descriptor_new (void);
VALA_EXTERN CirclesEffectDescriptor* circles_effect_descriptor_construct (GType object_type);
static const gchar* circles_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* circles_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* circles_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                              SpitHostInterface* host);
VALA_EXTERN CirclesEffect* circles_effect_new (void);
VALA_EXTERN CirclesEffect* circles_effect_construct (GType object_type);
VALA_EXTERN GType circles_effect_get_type (void) G_GNUC_CONST ;
static GType circles_effect_descriptor_get_type_once (void);
static void circles_effect_real_get_fps (SpitTransitionsEffect* base,
                                  gint* desired_fps,
                                  gint* min_fps);
static void circles_effect_real_start (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion);
static gboolean circles_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void circles_effect_real_paint (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                cairo_t* ctx,
                                gint width,
                                gint height,
                                gint frame_number);
static void circles_effect_real_advance (SpitTransitionsEffect* base,
                                  SpitTransitionsVisuals* visuals,
                                  SpitTransitionsMotion* motion,
                                  gint frame_number);
static void circles_effect_real_cancel (SpitTransitionsEffect* base);
static GType circles_effect_get_type_once (void);

CirclesEffectDescriptor*
circles_effect_descriptor_construct (GType object_type)
{
	CirclesEffectDescriptor * self = NULL;
	self = (CirclesEffectDescriptor*) shotwell_transition_descriptor_construct (object_type);
	return self;
}

CirclesEffectDescriptor*
circles_effect_descriptor_new (void)
{
	return circles_effect_descriptor_construct (TYPE_CIRCLES_EFFECT_DESCRIPTOR);
}

static const gchar*
circles_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	CirclesEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT_DESCRIPTOR, CirclesEffectDescriptor);
	result = "org.gnome.shotwell.transitions.circles";
	return result;
}

static const gchar*
circles_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	CirclesEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT_DESCRIPTOR, CirclesEffectDescriptor);
	result = _ ("Circles");
	return result;
}

static SpitTransitionsEffect*
circles_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                       SpitHostInterface* host)
{
	CirclesEffectDescriptor * self;
	CirclesEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT_DESCRIPTOR, CirclesEffectDescriptor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (host, SPIT_TYPE_HOST_INTERFACE), NULL);
	_tmp0_ = circles_effect_new ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
	return result;
}

static void
circles_effect_descriptor_class_init (CirclesEffectDescriptorClass * klass,
                                      gpointer klass_data)
{
	circles_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) circles_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) circles_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) circles_effect_descriptor_real_create;
}

static void
circles_effect_descriptor_instance_init (CirclesEffectDescriptor * self,
                                         gpointer klass)
{
}

static GType
circles_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CirclesEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) circles_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CirclesEffectDescriptor), 0, (GInstanceInitFunc) circles_effect_descriptor_instance_init, NULL };
	GType circles_effect_descriptor_type_id;
	circles_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "CirclesEffectDescriptor", &g_define_type_info, 0);
	return circles_effect_descriptor_type_id;
}

GType
circles_effect_descriptor_get_type (void)
{
	static volatile gsize circles_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&circles_effect_descriptor_type_id__once)) {
		GType circles_effect_descriptor_type_id;
		circles_effect_descriptor_type_id = circles_effect_descriptor_get_type_once ();
		g_once_init_leave (&circles_effect_descriptor_type_id__once, circles_effect_descriptor_type_id);
	}
	return circles_effect_descriptor_type_id__once;
}

CirclesEffect*
circles_effect_construct (GType object_type)
{
	CirclesEffect * self = NULL;
	self = (CirclesEffect*) g_object_new (object_type, NULL);
	return self;
}

CirclesEffect*
circles_effect_new (void)
{
	return circles_effect_construct (TYPE_CIRCLES_EFFECT);
}

static void
circles_effect_real_get_fps (SpitTransitionsEffect* base,
                             gint* desired_fps,
                             gint* min_fps)
{
	CirclesEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT, CirclesEffect);
	_vala_desired_fps = CIRCLES_EFFECT_DESIRED_FPS;
	_vala_min_fps = CIRCLES_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
circles_effect_real_start (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion)
{
	CirclesEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT, CirclesEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
}

static gboolean
circles_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	CirclesEffect * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT, CirclesEffect);
	result = TRUE;
	return result;
}

static void
circles_effect_real_paint (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           cairo_t* ctx,
                           gint width,
                           gint height,
                           gint frame_number)
{
	CirclesEffect * self;
	gdouble alpha = 0.0;
	gint distance = 0;
	gint radius = 0;
	gint circleCountX = 0;
	gint circleCountY = 0;
	gdouble maxRadius = 0.0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT, CirclesEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	distance = 60;
	circleCountX = width / (2 * distance);
	circleCountY = height / distance;
	maxRadius = CIRCLES_EFFECT_SPEED * distance;
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkRectangle _tmp4_ = {0};
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle _tmp7_;
		_tmp2_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp3_ = _tmp2_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp4_);
		_tmp5_ = _tmp4_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
		_tmp7_ = _tmp6_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp3_, (gdouble) _tmp5_.x, (gdouble) _tmp7_.y);
		cairo_paint_with_alpha (ctx, 1 - alpha);
	}
	_tmp8_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_ = {0};
		GdkRectangle _tmp15_;
		_tmp10_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp11_ = _tmp10_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp12_);
		_tmp13_ = _tmp12_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp14_);
		_tmp15_ = _tmp14_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp11_, (gdouble) _tmp13_.x, (gdouble) _tmp15_.y);
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = y;
						y = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					if (!(y <= circleCountY)) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp18_ = FALSE;
							_tmp18_ = TRUE;
							while (TRUE) {
								if (!_tmp18_) {
									gint _tmp19_;
									_tmp19_ = x;
									x = _tmp19_ + 1;
								}
								_tmp18_ = FALSE;
								if (!(x <= circleCountX)) {
									break;
								}
								radius = (gint) (fmax ((gdouble) 0, fmin ((gdouble) 1, alpha - (((gdouble) (x + y)) / ((gdouble) ((circleCountY + circleCountX) * CIRCLES_EFFECT_SPEED))))) * maxRadius);
								cairo_arc (ctx, (gdouble) ((2 * distance) * x), (gdouble) ((2 * distance) * y), (gdouble) radius, (gdouble) 0, 2 * G_PI);
								cairo_fill (ctx);
							}
						}
					}
				}
			}
		}
		cairo_clip (ctx);
		cairo_paint_with_alpha (ctx, alpha);
	}
}

static void
circles_effect_real_advance (SpitTransitionsEffect* base,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsMotion* motion,
                             gint frame_number)
{
	CirclesEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT, CirclesEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
}

static void
circles_effect_real_cancel (SpitTransitionsEffect* base)
{
	CirclesEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLES_EFFECT, CirclesEffect);
}

static void
circles_effect_class_init (CirclesEffectClass * klass,
                           gpointer klass_data)
{
	circles_effect_parent_class = g_type_class_peek_parent (klass);
}

static void
circles_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                       gpointer iface_data)
{
	circles_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) circles_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) circles_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) circles_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) circles_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) circles_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) circles_effect_real_cancel;
}

static void
circles_effect_instance_init (CirclesEffect * self,
                              gpointer klass)
{
}

static GType
circles_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CirclesEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) circles_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CirclesEffect), 0, (GInstanceInitFunc) circles_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) circles_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType circles_effect_type_id;
	circles_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "CirclesEffect", &g_define_type_info, 0);
	g_type_add_interface_static (circles_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	return circles_effect_type_id;
}

GType
circles_effect_get_type (void)
{
	static volatile gsize circles_effect_type_id__once = 0;
	if (g_once_init_enter (&circles_effect_type_id__once)) {
		GType circles_effect_type_id;
		circles_effect_type_id = circles_effect_get_type_once ();
		g_once_init_leave (&circles_effect_type_id__once, circles_effect_type_id);
	}
	return circles_effect_type_id__once;
}

