/* RESTSupport.c generated by valac 0.56.17, the Vala compiler
 * generated from RESTSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include "shotwell-plugin-common.h"
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <glib-object.h>
#include "shotwell-plugin-dev-1.0.h"
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <float.h>
#include <math.h>

#define PUBLISHING_REST_SUPPORT_SHA1_HMAC_LENGTH 20
#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_OAUTH_CLIENT_ID "1073902228337-gm4uf5etk25s0hnnm0g7uv2tm2bm1j0b.apps.googleusercontent." \
"com"
#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_OAUTH_CLIENT_SECRET "_kA4RZz72xqed4DqfO7xMmMN"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_hmac_unref0(var) ((var == NULL) ? NULL : (var = (g_hmac_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _publishing_rest_support_session_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_session_unref (var), NULL)))
typedef struct _PublishingRestSupportSessionSendWireMessageAsyncData PublishingRestSupportSessionSendWireMessageAsyncData;
typedef struct _PublishingRESTSupportParamSpecSession PublishingRESTSupportParamSpecSession;
enum  {
	PUBLISHING_REST_SUPPORT_SESSION_WIRE_MESSAGE_UNQUEUED_SIGNAL,
	PUBLISHING_REST_SUPPORT_SESSION_AUTHENTICATED_SIGNAL,
	PUBLISHING_REST_SUPPORT_SESSION_AUTHENTICATION_FAILED_SIGNAL,
	PUBLISHING_REST_SUPPORT_SESSION_NUM_SIGNALS
};
static guint publishing_rest_support_session_signals[PUBLISHING_REST_SUPPORT_SESSION_NUM_SIGNALS] = {0};
#define _publishing_rest_support_argument_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_argument_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _PublishingRESTSupportParamSpecArgument PublishingRESTSupportParamSpecArgument;
#define _publishing_rest_support_transaction_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_transaction_unref (var), NULL)))
typedef struct _PublishingRestSupportTransactionSendAsyncData PublishingRestSupportTransactionSendAsyncData;
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
typedef struct _PublishingRestSupportTransactionExecuteAsyncData PublishingRestSupportTransactionExecuteAsyncData;
typedef struct _PublishingRESTSupportParamSpecTransaction PublishingRESTSupportParamSpecTransaction;
enum  {
	PUBLISHING_REST_SUPPORT_TRANSACTION_CHUNK_TRANSMITTED_SIGNAL,
	PUBLISHING_REST_SUPPORT_TRANSACTION_COMPLETED_SIGNAL,
	PUBLISHING_REST_SUPPORT_TRANSACTION_NUM_SIGNALS
};
static guint publishing_rest_support_transaction_signals[PUBLISHING_REST_SUPPORT_TRANSACTION_NUM_SIGNALS] = {0};
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define __vala_SoupMultipart_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMultipart_free (var), NULL)))
typedef struct _PublishingRestSupportUploadTransactionExecuteAsyncData PublishingRestSupportUploadTransactionExecuteAsyncData;
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _publishing_rest_support_xml_document_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_xml_document_unref (var), NULL)))
typedef struct _PublishingRESTSupportParamSpecXmlDocument PublishingRESTSupportParamSpecXmlDocument;
#define _publishing_rest_support_batch_uploader_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_batch_uploader_unref (var), NULL)))
typedef struct _PublishingRestSupportBatchUploaderSendFilesAsyncData PublishingRestSupportBatchUploaderSendFilesAsyncData;
typedef struct _PublishingRestSupportBatchUploaderUploadAsyncData PublishingRestSupportBatchUploaderUploadAsyncData;
typedef struct _PublishingRESTSupportParamSpecBatchUploader PublishingRESTSupportParamSpecBatchUploader;
enum  {
	PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_UPLOAD_COMPLETE_SIGNAL,
	PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_UPLOAD_ERROR_SIGNAL,
	PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_NUM_SIGNALS
};
static guint publishing_rest_support_batch_uploader_signals[PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_NUM_SIGNALS] = {0};

#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL (publishing_rest_support_google_publisher_google_session_impl_get_type ())
#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GOOGLE_SESSION_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImpl))
#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GOOGLE_SESSION_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImplClass))
#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_IS_GOOGLE_SESSION_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL))
#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_IS_GOOGLE_SESSION_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL))
#define PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GOOGLE_SESSION_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImplClass))

typedef struct _PublishingRESTSupportGooglePublisherGoogleSessionImpl PublishingRESTSupportGooglePublisherGoogleSessionImpl;
typedef struct _PublishingRESTSupportGooglePublisherGoogleSessionImplClass PublishingRESTSupportGooglePublisherGoogleSessionImplClass;
enum  {
	PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_0_PROPERTY,
	PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_NUM_PROPERTIES
};
static GParamSpec* publishing_rest_support_google_publisher_properties[PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _PublishingRESTSupportGooglePublisherGoogleSessionImplPrivate PublishingRESTSupportGooglePublisherGoogleSessionImplPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PublishingRESTSupportSessionPrivate {
	gchar* endpoint_url;
	SoupSession* soup_session;
	gboolean transactions_stopped;
	GBytes* body;
	GError* transport_error;
	gboolean insecure;
};

struct _PublishingRestSupportSessionSendWireMessageAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingRESTSupportSession* self;
	SoupMessage* message;
	GBytes* _tmp0_;
	SoupSession* _tmp1_;
	GBytes* _tmp2_;
	GBytes* _tmp3_;
	GError* _error_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _inner_error0_;
};

struct _PublishingRESTSupportParamSpecSession {
	GParamSpec parent_instance;
};

struct _PublishingRESTSupportParamSpecArgument {
	GParamSpec parent_instance;
};

struct _PublishingRESTSupportTransactionPrivate {
	PublishingRESTSupportArgument** arguments;
	gint arguments_length1;
	gint _arguments_size_;
	gboolean is_executed;
	PublishingRESTSupportSession* parent_session;
	SoupMessage* message;
	guint bytes_written;
	gulong request_length;
	gchar* endpoint_url;
	gboolean use_custom_payload;
};

struct _PublishingRestSupportTransactionSendAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingRESTSupportTransaction* self;
	gulong id;
	SoupMessage* _tmp0_;
	gulong _tmp1_;
	SoupMessage* _tmp2_;
	PublishingRESTSupportSession* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
	guint _tmp8_;
	GError* _inner_error0_;
};

struct _PublishingRestSupportTransactionExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingRESTSupportTransaction* self;
	GUri* old_url;
	GUri* _tmp0_;
	SoupMessage* _tmp1_;
	GUri* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error1_;
	GUri* _tmp5_;
	SoupMessage* _tmp6_;
	GUri* _tmp7_;
	GError* _inner_error0_;
};

struct _PublishingRESTSupportParamSpecTransaction {
	GParamSpec parent_instance;
};

struct _PublishingRestSupportUploadTransactionExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingRESTSupportUploadTransaction* self;
	GError* _inner_error0_;
};

struct _PublishingRESTSupportXmlDocumentPrivate {
	xmlDoc* document;
};

struct _PublishingRESTSupportParamSpecXmlDocument {
	GParamSpec parent_instance;
};

struct _PublishingRESTSupportBatchUploaderPrivate {
	gint current_file;
	SpitPublishingPublishable** publishables;
	gint publishables_length1;
	gint _publishables_size_;
	PublishingRESTSupportSession* session;
	SpitPublishingProgressCallback status_updated;
	gpointer status_updated_target;
};

struct _PublishingRestSupportBatchUploaderSendFilesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingRESTSupportBatchUploader* self;
	SpitPublishingPublishable** _tmp0_;
	gint _tmp0__length1;
	SpitPublishingPublishable** publishable_collection;
	gint publishable_collection_length1;
	gint _publishable_collection_size_;
	gint publishable_it;
	SpitPublishingPublishable* _tmp1_;
	SpitPublishingPublishable* publishable;
	GFile* file;
	SpitPublishingPublishable* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gint _tmp5_;
	gdouble fraction_complete;
	SpitPublishingPublishable** _tmp6_;
	gint _tmp6__length1;
	SpitPublishingProgressCallback _tmp7_;
	gpointer _tmp7__target;
	SpitPublishingProgressCallback _tmp8_;
	gpointer _tmp8__target;
	PublishingRESTSupportTransaction* txn;
	SpitPublishingPublishable** _tmp9_;
	gint _tmp9__length1;
	SpitPublishingPublishable* _tmp10_;
	PublishingRESTSupportTransaction* _tmp11_;
	PublishingRESTSupportTransaction* _tmp12_;
	PublishingRESTSupportTransaction* _tmp13_;
	PublishingRESTSupportTransaction* _tmp14_;
	guint _tmp15_;
	gint _tmp16_;
	GError* _inner_error0_;
};

struct _PublishingRestSupportBatchUploaderUploadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingRESTSupportBatchUploader* self;
	SpitPublishingProgressCallback status_updated;
	gpointer status_updated_target;
	gint result;
	SpitPublishingPublishable** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_;
};

struct _PublishingRESTSupportParamSpecBatchUploader {
	GParamSpec parent_instance;
};

struct _PublishingRESTSupportGooglePublisherPrivate {
	gchar* scope;
	PublishingRESTSupportGooglePublisherGoogleSessionImpl* session;
	SpitPublishingPluginHost* host;
	SpitPublishingService* service;
	SpitPublishingAuthenticator* authenticator;
};

struct _PublishingRESTSupportGooglePublisherGoogleSessionImpl {
	PublishingRESTSupportGoogleSession parent_instance;
	PublishingRESTSupportGooglePublisherGoogleSessionImplPrivate * priv;
	gchar* access_token;
	gchar* user_name;
	gchar* refresh_token;
};

struct _PublishingRESTSupportGooglePublisherGoogleSessionImplClass {
	PublishingRESTSupportGoogleSessionClass parent_class;
};

static gint PublishingRESTSupportSession_private_offset;
static gpointer publishing_rest_support_session_parent_class = NULL;
static gpointer publishing_rest_support_argument_parent_class = NULL;
static gint PublishingRESTSupportTransaction_private_offset;
static gpointer publishing_rest_support_transaction_parent_class = NULL;
static gpointer publishing_rest_support_upload_transaction_parent_class = NULL;
static gint PublishingRESTSupportXmlDocument_private_offset;
static gpointer publishing_rest_support_xml_document_parent_class = NULL;
static gint PublishingRESTSupportBatchUploader_private_offset;
static gpointer publishing_rest_support_batch_uploader_parent_class = NULL;
static gpointer publishing_rest_support_google_session_parent_class = NULL;
static gint PublishingRESTSupportGooglePublisher_private_offset;
static gpointer publishing_rest_support_google_publisher_parent_class = NULL;
static gpointer publishing_rest_support_google_publisher_google_session_impl_parent_class = NULL;
static gpointer publishing_rest_support_google_publisher_authenticated_transaction_parent_class = NULL;
static SpitPublishingPublisherIface * publishing_rest_support_google_publisher_spit_publishing_publisher_parent_iface = NULL;

static SoupLoggerLogLevel ___lambda4_ (PublishingRESTSupportSession* self,
                                SoupLogger* logger,
                                SoupMessage* msg);
static SoupLoggerLogLevel ____lambda4__soup_logger_filter (SoupLogger* logger,
                                                    SoupMessage* msg,
                                                    gpointer self);
static gboolean publishing_rest_support_session_real_is_authenticated (PublishingRESTSupportSession* self);
static void publishing_rest_support_session_send_wire_message_async_data_free (gpointer _data);
static gboolean publishing_rest_support_session_send_wire_message_async_co (PublishingRestSupportSessionSendWireMessageAsyncData* _data_);
static void publishing_rest_support_session_send_wire_message_async_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static void publishing_rest_support_session_finalize (PublishingRESTSupportSession * obj);
static GType publishing_rest_support_session_get_type_once (void);
static gint _publishing_rest_support_argument_compare_gcompare_data_func (gconstpointer a,
                                                                   gconstpointer b,
                                                                   gpointer self);
static void publishing_rest_support_argument_finalize (PublishingRESTSupportArgument * obj);
static GType publishing_rest_support_argument_get_type_once (void);
static void publishing_rest_support_transaction_on_wrote_body_data (PublishingRESTSupportTransaction* self,
                                                             SoupMessage* message,
                                                             guint chunk_size);
static void _publishing_rest_support_transaction_on_wrote_body_data_soup_message_wrote_body_data (SoupMessage* _sender,
                                                                                           guint chunk_size,
                                                                                           gpointer self);
static PublishingRESTSupportArgument** _vala_array_dup1 (PublishingRESTSupportArgument** self,
                                                  gssize length);
static gboolean publishing_rest_support_transaction_on_accecpt_certificate (PublishingRESTSupportTransaction* self,
                                                                     SoupMessage* message,
                                                                     GTlsCertificate* cert,
                                                                     GTlsCertificateFlags errors);
static void publishing_rest_support_transaction_send_async_data_free (gpointer _data);
static gboolean publishing_rest_support_transaction_send_async_co (PublishingRestSupportTransactionSendAsyncData* _data_);
static void __lambda5_ (PublishingRESTSupportTransaction* self,
                 SoupMessage* message,
                 guint chunk_size);
static void ___lambda5__soup_message_wrote_body_data (SoupMessage* _sender,
                                               guint chunk_size,
                                               gpointer self);
static gboolean _publishing_rest_support_transaction_on_accecpt_certificate_soup_message_accept_certificate (SoupMessage* _sender,
                                                                                                      GTlsCertificate* tls_peer_certificate,
                                                                                                      GTlsCertificateFlags tls_peer_errors,
                                                                                                      gpointer self);
static void publishing_rest_support_transaction_send_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void publishing_rest_support_transaction_real_add_header (PublishingRESTSupportTransaction* self,
                                                          const gchar* key,
                                                          const gchar* value);
static GUri* publishing_rest_support_transaction_prepare_rest_message (PublishingRESTSupportTransaction* self);
static void publishing_rest_support_transaction_real_execute_async_data_free (gpointer _data);
static void publishing_rest_support_transaction_real_execute_async (PublishingRESTSupportTransaction* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean publishing_rest_support_transaction_real_execute_async_co (PublishingRestSupportTransactionExecuteAsyncData* _data_);
static void publishing_rest_support_transaction_execute_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void _vala_array_add1 (PublishingRESTSupportArgument** * array,
                       gint* length,
                       gint* size,
                       PublishingRESTSupportArgument* value);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void publishing_rest_support_transaction_finalize (PublishingRESTSupportTransaction * obj);
static GType publishing_rest_support_transaction_get_type_once (void);
static gchar* publishing_rest_support_upload_transaction_media_type_to_mime_type (SpitPublishingPublisherMediaType media_type);
static GHashTable* publishing_rest_support_upload_transaction_create_default_binary_disposition_table (PublishingRESTSupportUploadTransaction* self);
static void publishing_rest_support_upload_transaction_real_add_header (PublishingRESTSupportTransaction* base,
                                                                 const gchar* key,
                                                                 const gchar* value);
static void _g_free0_ (gpointer var);
static void publishing_rest_support_upload_transaction_prepare_execution (PublishingRESTSupportUploadTransaction* self,
                                                                   GError** error);
static void _vala_SoupMultipart_free (SoupMultipart* self);
static void publishing_rest_support_upload_transaction_real_execute_async_data_free (gpointer _data);
static void publishing_rest_support_upload_transaction_real_execute_async (PublishingRESTSupportTransaction* base,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static gboolean publishing_rest_support_upload_transaction_real_execute_async_co (PublishingRestSupportUploadTransactionExecuteAsyncData* _data_);
static void publishing_rest_support_upload_transaction_execute_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void publishing_rest_support_upload_transaction_finalize (PublishingRESTSupportTransaction * obj);
static GType publishing_rest_support_upload_transaction_get_type_once (void);
static PublishingRESTSupportXmlDocument* publishing_rest_support_xml_document_new (xmlDoc* doc);
static PublishingRESTSupportXmlDocument* publishing_rest_support_xml_document_construct (GType object_type,
                                                                                  xmlDoc* doc);
static void publishing_rest_support_xml_document_finalize (PublishingRESTSupportXmlDocument * obj);
static GType publishing_rest_support_xml_document_get_type_once (void);
static SpitPublishingPublishable** _vala_array_dup2 (SpitPublishingPublishable** self,
                                              gssize length);
static void publishing_rest_support_batch_uploader_send_files_async_data_free (gpointer _data);
static void publishing_rest_support_batch_uploader_send_files_async (PublishingRESTSupportBatchUploader* self,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void publishing_rest_support_batch_uploader_send_files_finish (PublishingRESTSupportBatchUploader* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static gboolean publishing_rest_support_batch_uploader_send_files_async_co (PublishingRestSupportBatchUploaderSendFilesAsyncData* _data_);
static void publishing_rest_support_batch_uploader_on_chunk_transmitted (PublishingRESTSupportBatchUploader* self,
                                                                  guint bytes_written_so_far,
                                                                  guint total_bytes);
static void _publishing_rest_support_batch_uploader_on_chunk_transmitted_publishing_rest_support_transaction_chunk_transmitted (PublishingRESTSupportTransaction* _sender,
                                                                                                                         guint bytes_written_so_far,
                                                                                                                         guint total_bytes,
                                                                                                                         gpointer self);
static void publishing_rest_support_batch_uploader_send_files_async_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static PublishingRESTSupportTransaction* publishing_rest_support_batch_uploader_real_create_transaction (PublishingRESTSupportBatchUploader* self,
                                                                                                  SpitPublishingPublishable* publishable);
static void publishing_rest_support_batch_uploader_upload_async_data_free (gpointer _data);
static gboolean publishing_rest_support_batch_uploader_upload_async_co (PublishingRestSupportBatchUploaderUploadAsyncData* _data_);
static void publishing_rest_support_batch_uploader_upload_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void publishing_rest_support_batch_uploader_finalize (PublishingRESTSupportBatchUploader * obj);
static GType publishing_rest_support_batch_uploader_get_type_once (void);
static gchar* publishing_rest_support_google_session_real_get_user_name (PublishingRESTSupportGoogleSession* self);
static gchar* publishing_rest_support_google_session_real_get_access_token (PublishingRESTSupportGoogleSession* self);
static void publishing_rest_support_google_session_real_deauthenticate (PublishingRESTSupportGoogleSession* self);
static GType publishing_rest_support_google_session_get_type_once (void);
static GType publishing_rest_support_google_publisher_google_session_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PublishingRESTSupportGooglePublisherGoogleSessionImpl* publishing_rest_support_google_publisher_google_session_impl_new (void);
static PublishingRESTSupportGooglePublisherGoogleSessionImpl* publishing_rest_support_google_publisher_google_session_impl_construct (GType object_type);
static void publishing_rest_support_google_publisher_on_authenticator_authenticated (PublishingRESTSupportGooglePublisher* self);
static void _publishing_rest_support_google_publisher_on_authenticator_authenticated_spit_publishing_authenticator_authenticated (SpitPublishingAuthenticator* _sender,
                                                                                                                           gpointer self);
static SpitPublishingAuthenticator* publishing_rest_support_google_publisher_real_get_authenticator (PublishingRESTSupportGooglePublisher* self);
static void publishing_rest_support_google_publisher_real_on_login_flow_complete (PublishingRESTSupportGooglePublisher* self);
static void publishing_rest_support_google_publisher_real_do_logout (PublishingRESTSupportGooglePublisher* self);
static gboolean publishing_rest_support_google_publisher_real_is_running (PublishingRESTSupportGooglePublisher* self);
static void publishing_rest_support_google_publisher_real_start (PublishingRESTSupportGooglePublisher* self);
static void publishing_rest_support_google_publisher_real_stop (PublishingRESTSupportGooglePublisher* self);
static SpitPublishingService* publishing_rest_support_google_publisher_real_get_service (SpitPublishingPublisher* base);
static gboolean publishing_rest_support_google_publisher_google_session_impl_real_is_authenticated (PublishingRESTSupportSession* base);
static gchar* publishing_rest_support_google_publisher_google_session_impl_real_get_user_name (PublishingRESTSupportGoogleSession* base);
static gchar* publishing_rest_support_google_publisher_google_session_impl_real_get_access_token (PublishingRESTSupportGoogleSession* base);
static void publishing_rest_support_google_publisher_google_session_impl_real_deauthenticate (PublishingRESTSupportGoogleSession* base);
static void publishing_rest_support_google_publisher_google_session_impl_finalize (PublishingRESTSupportSession * obj);
static GType publishing_rest_support_google_publisher_google_session_impl_get_type_once (void);
static PublishingRESTSupportGooglePublisherAuthenticatedTransaction* publishing_rest_support_google_publisher_authenticated_transaction_new_with_endpoint_url (PublishingRESTSupportGoogleSession* session,
                                                                                                                                                        const gchar* endpoint_url,
                                                                                                                                                        PublishingRESTSupportHttpMethod method);
static PublishingRESTSupportGooglePublisherAuthenticatedTransaction* publishing_rest_support_google_publisher_authenticated_transaction_construct_with_endpoint_url (GType object_type,
                                                                                                                                                              PublishingRESTSupportGoogleSession* session,
                                                                                                                                                              const gchar* endpoint_url,
                                                                                                                                                              PublishingRESTSupportHttpMethod method);
static GType publishing_rest_support_google_publisher_authenticated_transaction_get_type_once (void);
static void publishing_rest_support_google_publisher_finalize (GObject * obj);
static GType publishing_rest_support_google_publisher_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar*
publishing_rest_support_hmac_sha1 (const gchar* key,
                                   const gchar* message)
{
	guint8 buffer[PUBLISHING_REST_SUPPORT_SHA1_HMAC_LENGTH] = {0};
	gsize len = 0UL;
	GHmac* mac = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	GHmac* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	len = (gsize) PUBLISHING_REST_SUPPORT_SHA1_HMAC_LENGTH;
	_tmp0_ = string_get_data (key, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = g_hmac_new (G_CHECKSUM_SHA1, _tmp2_, _tmp2__length1);
	mac = _tmp3_;
	_tmp4_ = string_get_data (message, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	g_hmac_update (mac, _tmp6_, (gssize) _tmp6__length1);
	g_hmac_get_digest (mac, buffer, &len);
	_tmp7_ = g_base64_encode (buffer + 0, (gint) (((gint) len) - 0));
	result = _tmp7_;
	_g_hmac_unref0 (mac);
	return result;
}

static inline gpointer
publishing_rest_support_session_get_instance_private (PublishingRESTSupportSession* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingRESTSupportSession_private_offset);
}

static SoupLoggerLogLevel
___lambda4_ (PublishingRESTSupportSession* self,
             SoupLogger* logger,
             SoupMessage* msg)
{
	gchar* content_type = NULL;
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	SoupLoggerLogLevel result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (logger, soup_logger_get_type ()), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (msg, soup_message_get_type ()), 0);
	_tmp0_ = soup_message_get_request_headers (msg);
	_tmp1_ = soup_message_headers_get_content_type (_tmp0_, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	content_type = _tmp2_;
	_tmp4_ = content_type;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = content_type;
		_tmp3_ = g_strcmp0 (_tmp5_, "application/octet-stream") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = SOUP_LOGGER_LOG_HEADERS;
		_g_free0 (content_type);
		return result;
	}
	result = SOUP_LOGGER_LOG_BODY;
	_g_free0 (content_type);
	return result;
}

static SoupLoggerLogLevel
____lambda4__soup_logger_filter (SoupLogger* logger,
                                 SoupMessage* msg,
                                 gpointer self)
{
	SoupLoggerLogLevel result;
	result = ___lambda4_ ((PublishingRESTSupportSession*) self, logger, msg);
	return result;
}

PublishingRESTSupportSession*
publishing_rest_support_session_construct (GType object_type,
                                           const gchar* endpoint_url)
{
	PublishingRESTSupportSession* self = NULL;
	gchar* _tmp0_;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	self = (PublishingRESTSupportSession*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (endpoint_url);
	_g_free0 (self->priv->endpoint_url);
	self->priv->endpoint_url = _tmp0_;
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (self->priv->soup_session);
	self->priv->soup_session = _tmp1_;
	_tmp2_ = g_getenv ("SHOTWELL_SOUP_LOG");
	if (_tmp2_ != NULL) {
		SoupLogger* logger = NULL;
		SoupLogger* _tmp3_;
		SoupLogger* _tmp4_;
		SoupSession* _tmp5_;
		SoupLogger* _tmp6_;
		_tmp3_ = soup_logger_new (SOUP_LOGGER_LOG_BODY);
		logger = _tmp3_;
		_tmp4_ = logger;
		soup_logger_set_request_filter (_tmp4_, ____lambda4__soup_logger_filter, publishing_rest_support_session_ref (self), publishing_rest_support_session_unref);
		_tmp5_ = self->priv->soup_session;
		_tmp6_ = logger;
		soup_session_add_feature (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, soup_session_feature_get_type (), SoupSessionFeature));
		_g_object_unref0 (logger);
	}
	return self;
}

void
publishing_rest_support_session_notify_wire_message_unqueued (PublishingRESTSupportSession* self,
                                                              SoupMessage* message)
{
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, soup_message_get_type ()));
	g_signal_emit (self, publishing_rest_support_session_signals[PUBLISHING_REST_SUPPORT_SESSION_WIRE_MESSAGE_UNQUEUED_SIGNAL], 0, message);
}

void
publishing_rest_support_session_notify_authenticated (PublishingRESTSupportSession* self)
{
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self));
	g_signal_emit (self, publishing_rest_support_session_signals[PUBLISHING_REST_SUPPORT_SESSION_AUTHENTICATED_SIGNAL], 0);
}

void
publishing_rest_support_session_notify_authentication_failed (PublishingRESTSupportSession* self,
                                                              GError* err)
{
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self));
	g_signal_emit (self, publishing_rest_support_session_signals[PUBLISHING_REST_SUPPORT_SESSION_AUTHENTICATION_FAILED_SIGNAL], 0, err);
}

static gboolean
publishing_rest_support_session_real_is_authenticated (PublishingRESTSupportSession* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_session_is_authenticated'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
publishing_rest_support_session_is_authenticated (PublishingRESTSupportSession* self)
{
	PublishingRESTSupportSessionClass* _klass_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self), FALSE);
	_klass_ = PUBLISHING_REST_SUPPORT_SESSION_GET_CLASS (self);
	if (_klass_->is_authenticated) {
		return _klass_->is_authenticated (self);
	}
	return FALSE;
}

gchar*
publishing_rest_support_session_get_endpoint_url (PublishingRESTSupportSession* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self), NULL);
	_tmp0_ = self->priv->endpoint_url;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
publishing_rest_support_session_stop_transactions (PublishingRESTSupportSession* self)
{
	SoupSession* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self));
	self->priv->transactions_stopped = TRUE;
	_tmp0_ = self->priv->soup_session;
	soup_session_abort (_tmp0_);
}

gboolean
publishing_rest_support_session_are_transactions_stopped (PublishingRESTSupportSession* self)
{
	gboolean result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self), FALSE);
	result = self->priv->transactions_stopped;
	return result;
}

static void
publishing_rest_support_session_send_wire_message_async_data_free (gpointer _data)
{
	PublishingRestSupportSessionSendWireMessageAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_publishing_rest_support_session_unref0 (_data_->self);
	g_slice_free (PublishingRestSupportSessionSendWireMessageAsyncData, _data_);
}

static gpointer
_publishing_rest_support_session_ref0 (gpointer self)
{
	return self ? publishing_rest_support_session_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
publishing_rest_support_session_send_wire_message_async (PublishingRESTSupportSession* self,
                                                         SoupMessage* message,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	PublishingRestSupportSessionSendWireMessageAsyncData* _data_;
	PublishingRESTSupportSession* _tmp0_;
	SoupMessage* _tmp1_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, soup_message_get_type ()));
	_data_ = g_slice_new0 (PublishingRestSupportSessionSendWireMessageAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_rest_support_session_send_wire_message_async_data_free);
	_tmp0_ = _publishing_rest_support_session_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	publishing_rest_support_session_send_wire_message_async_co (_data_);
}

void
publishing_rest_support_session_send_wire_message_finish (PublishingRESTSupportSession* self,
                                                          GAsyncResult* _res_)
{
	PublishingRestSupportSessionSendWireMessageAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
publishing_rest_support_session_send_wire_message_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	PublishingRestSupportSessionSendWireMessageAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_rest_support_session_send_wire_message_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
publishing_rest_support_session_send_wire_message_async_co (PublishingRestSupportSessionSendWireMessageAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (publishing_rest_support_session_are_transactions_stopped (_data_->self)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->priv->soup_session;
		_data_->_state_ = 1;
		soup_session_send_and_read_async (_data_->_tmp1_, _data_->message, G_PRIORITY_DEFAULT, NULL, publishing_rest_support_session_send_wire_message_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = soup_session_send_and_read_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_bytes_unref0 (_data_->self->priv->body);
		_data_->self->priv->body = _data_->_tmp3_;
		_g_bytes_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->_error_;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_debug ("RESTSupport.vala:89: Failed to send_and_read: %s", _data_->_tmp5_);
		_data_->_tmp6_ = _data_->_error_;
		_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
		_g_error_free0 (_data_->self->priv->transport_error);
		_data_->self->priv->transport_error = _data_->_tmp7_;
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
publishing_rest_support_session_set_insecure (PublishingRESTSupportSession* self)
{
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self));
	self->priv->insecure = TRUE;
}

gboolean
publishing_rest_support_session_get_is_insecure (PublishingRESTSupportSession* self)
{
	gboolean result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self), FALSE);
	result = self->priv->insecure;
	return result;
}

GError*
publishing_rest_support_session_get_transport_error (PublishingRESTSupportSession* self)
{
	GError* _tmp0_;
	GError* _tmp1_;
	GError* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self), NULL);
	_tmp0_ = self->priv->transport_error;
	_tmp1_ = _g_error_copy0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

GBytes*
publishing_rest_support_session_get_body (PublishingRESTSupportSession* self)
{
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	GBytes* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (self), NULL);
	_tmp0_ = self->priv->body;
	_tmp1_ = _g_bytes_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
publishing_rest_support_value_session_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
publishing_rest_support_value_session_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		publishing_rest_support_session_unref (value->data[0].v_pointer);
	}
}

static void
publishing_rest_support_value_session_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = publishing_rest_support_session_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
publishing_rest_support_value_session_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
publishing_rest_support_value_session_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PublishingRESTSupportSession * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = publishing_rest_support_session_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
publishing_rest_support_value_session_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	PublishingRESTSupportSession ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = publishing_rest_support_session_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
publishing_rest_support_param_spec_session (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	PublishingRESTSupportParamSpecSession* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PUBLISHING_REST_SUPPORT_TYPE_SESSION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
publishing_rest_support_value_get_session (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_SESSION), NULL);
	return value->data[0].v_pointer;
}

void
publishing_rest_support_value_set_session (GValue* value,
                                           gpointer v_object)
{
	PublishingRESTSupportSession * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_SESSION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_SESSION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		publishing_rest_support_session_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_session_unref (old);
	}
}

void
publishing_rest_support_value_take_session (GValue* value,
                                            gpointer v_object)
{
	PublishingRESTSupportSession * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_SESSION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_SESSION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_session_unref (old);
	}
}

static void
publishing_rest_support_session_class_init (PublishingRESTSupportSessionClass * klass,
                                            gpointer klass_data)
{
	publishing_rest_support_session_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportSessionClass *) klass)->finalize = publishing_rest_support_session_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingRESTSupportSession_private_offset);
	((PublishingRESTSupportSessionClass *) klass)->is_authenticated = (gboolean (*) (PublishingRESTSupportSession*)) publishing_rest_support_session_real_is_authenticated;
	publishing_rest_support_session_signals[PUBLISHING_REST_SUPPORT_SESSION_WIRE_MESSAGE_UNQUEUED_SIGNAL] = g_signal_new ("wire-message-unqueued", PUBLISHING_REST_SUPPORT_TYPE_SESSION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
	publishing_rest_support_session_signals[PUBLISHING_REST_SUPPORT_SESSION_AUTHENTICATED_SIGNAL] = g_signal_new ("authenticated", PUBLISHING_REST_SUPPORT_TYPE_SESSION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	publishing_rest_support_session_signals[PUBLISHING_REST_SUPPORT_SESSION_AUTHENTICATION_FAILED_SIGNAL] = g_signal_new ("authentication-failed", PUBLISHING_REST_SUPPORT_TYPE_SESSION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_ERROR);
}

static void
publishing_rest_support_session_instance_init (PublishingRESTSupportSession * self,
                                               gpointer klass)
{
	self->priv = publishing_rest_support_session_get_instance_private (self);
	self->priv->endpoint_url = NULL;
	self->priv->soup_session = NULL;
	self->priv->transactions_stopped = FALSE;
	self->priv->body = NULL;
	self->priv->transport_error = NULL;
	self->priv->insecure = FALSE;
	self->ref_count = 1;
}

static void
publishing_rest_support_session_finalize (PublishingRESTSupportSession * obj)
{
	PublishingRESTSupportSession * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->endpoint_url);
	_g_object_unref0 (self->priv->soup_session);
	_g_bytes_unref0 (self->priv->body);
	_g_error_free0 (self->priv->transport_error);
}

static GType
publishing_rest_support_session_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { publishing_rest_support_value_session_init, publishing_rest_support_value_session_free_value, publishing_rest_support_value_session_copy_value, publishing_rest_support_value_session_peek_pointer, "p", publishing_rest_support_value_session_collect_value, "p", publishing_rest_support_value_session_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportSession), 0, (GInstanceInitFunc) publishing_rest_support_session_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType publishing_rest_support_session_type_id;
	publishing_rest_support_session_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PublishingRESTSupportSession", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	PublishingRESTSupportSession_private_offset = g_type_add_instance_private (publishing_rest_support_session_type_id, sizeof (PublishingRESTSupportSessionPrivate));
	return publishing_rest_support_session_type_id;
}

GType
publishing_rest_support_session_get_type (void)
{
	static volatile gsize publishing_rest_support_session_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_session_type_id__once)) {
		GType publishing_rest_support_session_type_id;
		publishing_rest_support_session_type_id = publishing_rest_support_session_get_type_once ();
		g_once_init_leave (&publishing_rest_support_session_type_id__once, publishing_rest_support_session_type_id);
	}
	return publishing_rest_support_session_type_id__once;
}

gpointer
publishing_rest_support_session_ref (gpointer instance)
{
	PublishingRESTSupportSession * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
publishing_rest_support_session_unref (gpointer instance)
{
	PublishingRESTSupportSession * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PUBLISHING_REST_SUPPORT_SESSION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gchar*
publishing_rest_support_http_method_to_string (PublishingRESTSupportHttpMethod self)
{
	gchar* result;
	switch (self) {
		case PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("GET");
			result = _tmp0_;
			return result;
		}
		case PUBLISHING_REST_SUPPORT_HTTP_METHOD_PUT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("PUT");
			result = _tmp1_;
			return result;
		}
		case PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("POST");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("RESTSupport.vala:128: unrecognized HTTP method enumeration value");
		}
	}
}

PublishingRESTSupportHttpMethod
publishing_rest_support_http_method_from_string (const gchar* str)
{
	PublishingRESTSupportHttpMethod result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "GET") == 0) {
		result = PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET;
		return result;
	} else {
		if (g_strcmp0 (str, "PUT") == 0) {
			result = PUBLISHING_REST_SUPPORT_HTTP_METHOD_PUT;
			return result;
		} else {
			if (g_strcmp0 (str, "POST") == 0) {
				result = PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST;
				return result;
			} else {
				g_error ("RESTSupport.vala:140: unrecognized HTTP method name: %s", str);
			}
		}
	}
}

static GType
publishing_rest_support_http_method_get_type_once (void)
{
	static const GEnumValue values[] = {{PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET, "PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET", "get"}, {PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST, "PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST", "post"}, {PUBLISHING_REST_SUPPORT_HTTP_METHOD_PUT, "PUBLISHING_REST_SUPPORT_HTTP_METHOD_PUT", "put"}, {0, NULL, NULL}};
	GType publishing_rest_support_http_method_type_id;
	publishing_rest_support_http_method_type_id = g_enum_register_static ("PublishingRESTSupportHttpMethod", values);
	return publishing_rest_support_http_method_type_id;
}

GType
publishing_rest_support_http_method_get_type (void)
{
	static volatile gsize publishing_rest_support_http_method_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_http_method_type_id__once)) {
		GType publishing_rest_support_http_method_type_id;
		publishing_rest_support_http_method_type_id = publishing_rest_support_http_method_get_type_once ();
		g_once_init_leave (&publishing_rest_support_http_method_type_id__once, publishing_rest_support_http_method_type_id);
	}
	return publishing_rest_support_http_method_type_id__once;
}

PublishingRESTSupportArgument*
publishing_rest_support_argument_construct (GType object_type,
                                            const gchar* key,
                                            const gchar* value)
{
	PublishingRESTSupportArgument* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (PublishingRESTSupportArgument*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (key);
	_g_free0 (self->key);
	self->key = _tmp0_;
	_tmp1_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp1_;
	return self;
}

PublishingRESTSupportArgument*
publishing_rest_support_argument_new (const gchar* key,
                                      const gchar* value)
{
	return publishing_rest_support_argument_construct (PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT, key, value);
}

gchar*
publishing_rest_support_argument_serialize_for_sbs (PublishingRESTSupportArgument** args,
                                                    gint args_length1)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = publishing_rest_support_argument_serialize_list (args, (gint) args_length1, TRUE, FALSE, "&");
	result = _tmp0_;
	return result;
}

gchar*
publishing_rest_support_argument_serialize_for_authorization_header (PublishingRESTSupportArgument** args,
                                                                     gint args_length1)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = publishing_rest_support_argument_serialize_list (args, (gint) args_length1, FALSE, TRUE, ", ");
	result = _tmp0_;
	return result;
}

static gpointer
_publishing_rest_support_argument_ref0 (gpointer self)
{
	return self ? publishing_rest_support_argument_ref (self) : NULL;
}

gchar*
publishing_rest_support_argument_serialize_list (PublishingRESTSupportArgument** args,
                                                 gint args_length1,
                                                 gboolean encode,
                                                 gboolean escape,
                                                 const gchar* separator)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp7_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		PublishingRESTSupportArgument** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = args;
		arg_collection_length1 = args_length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			PublishingRESTSupportArgument* _tmp1_;
			PublishingRESTSupportArgument* arg = NULL;
			_tmp1_ = _publishing_rest_support_argument_ref0 (arg_collection[arg_it]);
			arg = _tmp1_;
			{
				GString* _tmp2_;
				PublishingRESTSupportArgument* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GString* _tmp6_;
				_tmp2_ = builder;
				_tmp3_ = arg;
				_tmp4_ = publishing_rest_support_argument_to_string (_tmp3_, escape, encode);
				_tmp5_ = _tmp4_;
				g_string_append (_tmp2_, _tmp5_);
				_g_free0 (_tmp5_);
				_tmp6_ = builder;
				g_string_append (_tmp6_, separator);
				_publishing_rest_support_argument_unref0 (arg);
			}
		}
	}
	_tmp7_ = builder;
	if (_tmp7_->len > ((gssize) 0)) {
		GString* _tmp8_;
		GString* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = builder;
		_tmp9_ = builder;
		_tmp10_ = strlen (separator);
		_tmp11_ = _tmp10_;
		g_string_truncate (_tmp8_, (gsize) (_tmp9_->len - _tmp11_));
	}
	_tmp12_ = builder;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_string_free0 (builder);
	return result;
}

gint
publishing_rest_support_argument_compare (PublishingRESTSupportArgument* arg1,
                                          PublishingRESTSupportArgument* arg2)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_ARGUMENT (arg1), 0);
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_ARGUMENT (arg2), 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = arg1->key;
	_tmp2_ = arg2->key;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static gint
_publishing_rest_support_argument_compare_gcompare_data_func (gconstpointer a,
                                                              gconstpointer b,
                                                              gpointer self)
{
	gint result;
	result = publishing_rest_support_argument_compare ((PublishingRESTSupportArgument*) a, (PublishingRESTSupportArgument*) b);
	return result;
}

PublishingRESTSupportArgument**
publishing_rest_support_argument_sort (PublishingRESTSupportArgument** inputArray,
                                       gint inputArray_length1,
                                       gint* result_length1)
{
	GeeTreeSet* sorted_args = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSet* _tmp4_;
	gint _tmp5_ = 0;
	gpointer* _tmp6_;
	PublishingRESTSupportArgument** _tmp7_;
	gint _tmp7__length1;
	PublishingRESTSupportArgument** result;
	_tmp0_ = gee_tree_set_new (PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT, (GBoxedCopyFunc) publishing_rest_support_argument_ref, (GDestroyNotify) publishing_rest_support_argument_unref, _publishing_rest_support_argument_compare_gcompare_data_func, NULL, NULL);
	sorted_args = _tmp0_;
	{
		PublishingRESTSupportArgument** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = inputArray;
		arg_collection_length1 = inputArray_length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			PublishingRESTSupportArgument* _tmp1_;
			PublishingRESTSupportArgument* arg = NULL;
			_tmp1_ = _publishing_rest_support_argument_ref0 (arg_collection[arg_it]);
			arg = _tmp1_;
			{
				GeeTreeSet* _tmp2_;
				PublishingRESTSupportArgument* _tmp3_;
				_tmp2_ = sorted_args;
				_tmp3_ = arg;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp3_);
				_publishing_rest_support_argument_unref0 (arg);
			}
		}
	}
	_tmp4_ = sorted_args;
	_tmp6_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (sorted_args);
	return result;
}

gchar*
publishing_rest_support_argument_to_string (PublishingRESTSupportArgument* self,
                                            gboolean escape,
                                            gboolean encode)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_ARGUMENT (self), NULL);
	if (escape) {
		_tmp0_ = "\"";
	} else {
		_tmp0_ = "";
	}
	if (encode) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->value;
		_tmp3_ = g_uri_escape_string (_tmp2_, NULL, TRUE);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->value;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	if (escape) {
		_tmp6_ = "\"";
	} else {
		_tmp6_ = "";
	}
	_tmp7_ = self->key;
	_tmp8_ = g_strdup_printf ("%s=%s%s%s", _tmp7_, _tmp0_, _tmp1_, _tmp6_);
	result = _tmp8_;
	_g_free0 (_tmp1_);
	return result;
}

static void
publishing_rest_support_value_argument_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
publishing_rest_support_value_argument_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		publishing_rest_support_argument_unref (value->data[0].v_pointer);
	}
}

static void
publishing_rest_support_value_argument_copy_value (const GValue* src_value,
                                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = publishing_rest_support_argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
publishing_rest_support_value_argument_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
publishing_rest_support_value_argument_collect_value (GValue* value,
                                                      guint n_collect_values,
                                                      GTypeCValue* collect_values,
                                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PublishingRESTSupportArgument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = publishing_rest_support_argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
publishing_rest_support_value_argument_lcopy_value (const GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	PublishingRESTSupportArgument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = publishing_rest_support_argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
publishing_rest_support_param_spec_argument (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags)
{
	PublishingRESTSupportParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
publishing_rest_support_value_get_argument (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}

void
publishing_rest_support_value_set_argument (GValue* value,
                                            gpointer v_object)
{
	PublishingRESTSupportArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		publishing_rest_support_argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_argument_unref (old);
	}
}

void
publishing_rest_support_value_take_argument (GValue* value,
                                             gpointer v_object)
{
	PublishingRESTSupportArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_argument_unref (old);
	}
}

static void
publishing_rest_support_argument_class_init (PublishingRESTSupportArgumentClass * klass,
                                             gpointer klass_data)
{
	publishing_rest_support_argument_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportArgumentClass *) klass)->finalize = publishing_rest_support_argument_finalize;
}

static void
publishing_rest_support_argument_instance_init (PublishingRESTSupportArgument * self,
                                                gpointer klass)
{
	self->ref_count = 1;
}

static void
publishing_rest_support_argument_finalize (PublishingRESTSupportArgument * obj)
{
	PublishingRESTSupportArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT, PublishingRESTSupportArgument);
	g_signal_handlers_destroy (self);
	_g_free0 (self->key);
	_g_free0 (self->value);
}

static GType
publishing_rest_support_argument_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { publishing_rest_support_value_argument_init, publishing_rest_support_value_argument_free_value, publishing_rest_support_value_argument_copy_value, publishing_rest_support_value_argument_peek_pointer, "p", publishing_rest_support_value_argument_collect_value, "p", publishing_rest_support_value_argument_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportArgument), 0, (GInstanceInitFunc) publishing_rest_support_argument_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType publishing_rest_support_argument_type_id;
	publishing_rest_support_argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PublishingRESTSupportArgument", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return publishing_rest_support_argument_type_id;
}

GType
publishing_rest_support_argument_get_type (void)
{
	static volatile gsize publishing_rest_support_argument_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_argument_type_id__once)) {
		GType publishing_rest_support_argument_type_id;
		publishing_rest_support_argument_type_id = publishing_rest_support_argument_get_type_once ();
		g_once_init_leave (&publishing_rest_support_argument_type_id__once, publishing_rest_support_argument_type_id);
	}
	return publishing_rest_support_argument_type_id__once;
}

gpointer
publishing_rest_support_argument_ref (gpointer instance)
{
	PublishingRESTSupportArgument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
publishing_rest_support_argument_unref (gpointer instance)
{
	PublishingRESTSupportArgument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PUBLISHING_REST_SUPPORT_ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
publishing_rest_support_transaction_get_instance_private (PublishingRESTSupportTransaction* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingRESTSupportTransaction_private_offset);
}

static void
_publishing_rest_support_transaction_on_wrote_body_data_soup_message_wrote_body_data (SoupMessage* _sender,
                                                                                      guint chunk_size,
                                                                                      gpointer self)
{
	publishing_rest_support_transaction_on_wrote_body_data ((PublishingRESTSupportTransaction*) self, _sender, chunk_size);
}

PublishingRESTSupportTransaction*
publishing_rest_support_transaction_construct (GType object_type,
                                               PublishingRESTSupportSession* parent_session,
                                               PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportTransaction* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (parent_session), NULL);
	self = (PublishingRESTSupportTransaction*) g_type_create_instance (object_type);
	_tmp0_ = publishing_rest_support_session_get_endpoint_url (parent_session);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "parent_session.get_endpoint_url() != null");
	_g_free0 (_tmp1_);
	self->priv->parent_session = parent_session;
	_tmp2_ = publishing_rest_support_http_method_to_string (method);
	_tmp3_ = _tmp2_;
	_tmp4_ = publishing_rest_support_session_get_endpoint_url (parent_session);
	_tmp5_ = _tmp4_;
	_tmp6_ = soup_message_new (_tmp3_, _tmp5_);
	_g_object_unref0 (self->priv->message);
	self->priv->message = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp7_ = self->priv->message;
	g_signal_connect (_tmp7_, "wrote-body-data", (GCallback) _publishing_rest_support_transaction_on_wrote_body_data_soup_message_wrote_body_data, self);
	return self;
}

PublishingRESTSupportTransaction*
publishing_rest_support_transaction_new (PublishingRESTSupportSession* parent_session,
                                         PublishingRESTSupportHttpMethod method)
{
	return publishing_rest_support_transaction_construct (PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, parent_session, method);
}

PublishingRESTSupportTransaction*
publishing_rest_support_transaction_construct_with_endpoint_url (GType object_type,
                                                                 PublishingRESTSupportSession* parent_session,
                                                                 const gchar* endpoint_url,
                                                                 PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportTransaction* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* _tmp3_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (parent_session), NULL);
	g_return_val_if_fail (endpoint_url != NULL, NULL);
	self = (PublishingRESTSupportTransaction*) g_type_create_instance (object_type);
	self->priv->parent_session = parent_session;
	_tmp0_ = g_strdup (endpoint_url);
	_g_free0 (self->priv->endpoint_url);
	self->priv->endpoint_url = _tmp0_;
	_tmp1_ = publishing_rest_support_http_method_to_string (method);
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new (_tmp2_, endpoint_url);
	_g_object_unref0 (self->priv->message);
	self->priv->message = _tmp3_;
	_g_free0 (_tmp2_);
	return self;
}

PublishingRESTSupportTransaction*
publishing_rest_support_transaction_new_with_endpoint_url (PublishingRESTSupportSession* parent_session,
                                                           const gchar* endpoint_url,
                                                           PublishingRESTSupportHttpMethod method)
{
	return publishing_rest_support_transaction_construct_with_endpoint_url (PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, parent_session, endpoint_url, method);
}

static void
publishing_rest_support_transaction_on_wrote_body_data (PublishingRESTSupportTransaction* self,
                                                        SoupMessage* message,
                                                        guint chunk_size)
{
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, soup_message_get_type ()));
	self->priv->bytes_written = self->priv->bytes_written + chunk_size;
	g_signal_emit (self, publishing_rest_support_transaction_signals[PUBLISHING_REST_SUPPORT_TRANSACTION_CHUNK_TRANSMITTED_SIGNAL], 0, self->priv->bytes_written, (guint) self->priv->request_length);
}

gchar*
publishing_rest_support_transaction_detailed_error_from_tls_flags (PublishingRESTSupportTransaction* self,
                                                                   GTlsCertificate** cert)
{
	GTlsCertificate* _vala_cert = NULL;
	GTlsCertificateFlags tls_errors = 0U;
	SoupMessage* _tmp0_;
	GTlsCertificate* _tmp1_;
	GTlsCertificate* _tmp2_;
	SoupMessage* _tmp3_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_;
	GString* builder = NULL;
	GString* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_tmp0_ = self->priv->message;
	_tmp1_ = soup_message_get_tls_peer_certificate (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_vala_cert);
	_vala_cert = _tmp2_;
	_tmp3_ = self->priv->message;
	tls_errors = soup_message_get_tls_peer_certificate_errors (_tmp3_);
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp4_;
	if ((tls_errors & G_TLS_CERTIFICATE_BAD_IDENTITY) == G_TLS_CERTIFICATE_BAD_IDENTITY) {
		GeeArrayList* _tmp5_;
		_tmp5_ = list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _ ("⚫ This website presented identification that belongs to a different we" \
"bsite."));
	}
	if ((tls_errors & G_TLS_CERTIFICATE_EXPIRED) == G_TLS_CERTIFICATE_EXPIRED) {
		GeeArrayList* _tmp6_;
		_tmp6_ = list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _ ("⚫ This website’s identification is too old to trust. Check the date on" \
" your computer’s calendar."));
	}
	if ((tls_errors & G_TLS_CERTIFICATE_UNKNOWN_CA) == G_TLS_CERTIFICATE_UNKNOWN_CA) {
		GeeArrayList* _tmp7_;
		_tmp7_ = list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _ ("⚫ This website’s identification was not issued by a trusted organizati" \
"on."));
	}
	if ((tls_errors & G_TLS_CERTIFICATE_GENERIC_ERROR) == G_TLS_CERTIFICATE_GENERIC_ERROR) {
		GeeArrayList* _tmp8_;
		_tmp8_ = list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _ ("⚫ This website’s identification could not be processed. It may be corr" \
"upted."));
	}
	if ((tls_errors & G_TLS_CERTIFICATE_REVOKED) == G_TLS_CERTIFICATE_REVOKED) {
		GeeArrayList* _tmp9_;
		_tmp9_ = list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _ ("⚫ This website’s identification has been revoked by the trusted organi" \
"zation that issued it."));
	}
	if ((tls_errors & G_TLS_CERTIFICATE_INSECURE) == G_TLS_CERTIFICATE_INSECURE) {
		GeeArrayList* _tmp10_;
		_tmp10_ = list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _ ("⚫ This website’s identification cannot be trusted because it uses very" \
" weak encryption."));
	}
	if ((tls_errors & G_TLS_CERTIFICATE_NOT_ACTIVATED) == G_TLS_CERTIFICATE_NOT_ACTIVATED) {
		GeeArrayList* _tmp11_;
		_tmp11_ = list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _ ("⚫ This website’s identification is only valid for future dates. Check " \
"the date on your computer’s calendar."));
	}
	_tmp12_ = g_string_new ("");
	builder = _tmp12_;
	_tmp13_ = list;
	_tmp14_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp15_ = _tmp14_;
	if (_tmp15_ == 1) {
		GString* _tmp16_;
		GeeArrayList* _tmp17_;
		gpointer _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = builder;
		_tmp17_ = list;
		_tmp18_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		_tmp19_ = (gchar*) _tmp18_;
		g_string_append (_tmp16_, _tmp19_);
		_g_free0 (_tmp19_);
	} else {
		{
			GeeArrayList* _entry_list = NULL;
			GeeArrayList* _tmp20_;
			gint _entry_size = 0;
			GeeArrayList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _entry_index = 0;
			_tmp20_ = list;
			_entry_list = _tmp20_;
			_tmp21_ = _entry_list;
			_tmp22_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp23_ = _tmp22_;
			_entry_size = _tmp23_;
			_entry_index = -1;
			while (TRUE) {
				gint _tmp24_;
				gint _tmp25_;
				gchar* entry = NULL;
				GeeArrayList* _tmp26_;
				gpointer _tmp27_;
				GString* _tmp28_;
				const gchar* _tmp29_;
				_entry_index = _entry_index + 1;
				_tmp24_ = _entry_index;
				_tmp25_ = _entry_size;
				if (!(_tmp24_ < _tmp25_)) {
					break;
				}
				_tmp26_ = _entry_list;
				_tmp27_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _entry_index);
				entry = (gchar*) _tmp27_;
				_tmp28_ = builder;
				_tmp29_ = entry;
				g_string_append_printf (_tmp28_, "%s\n", _tmp29_);
				_g_free0 (entry);
			}
		}
	}
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	_g_string_free0 (builder);
	_g_object_unref0 (list);
	if (cert) {
		*cert = _vala_cert;
	} else {
		_g_object_unref0 (_vala_cert);
	}
	return result;
}

void
publishing_rest_support_transaction_check_response (PublishingRESTSupportTransaction* self,
                                                    SoupMessage* message,
                                                    GError** error)
{
	GError* transport_error = NULL;
	PublishingRESTSupportSession* _tmp0_;
	GError* _tmp1_;
	guint _tmp24_;
	guint _tmp25_;
	GBytes* body = NULL;
	PublishingRESTSupportSession* _tmp34_;
	GBytes* _tmp35_;
	gboolean _tmp36_ = FALSE;
	GBytes* _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, soup_message_get_type ()));
	_tmp0_ = self->priv->parent_session;
	_tmp1_ = publishing_rest_support_session_get_transport_error (_tmp0_);
	transport_error = _tmp1_;
	if (transport_error != NULL) {
		gchar* _tmp18_;
		gchar* _tmp19_;
		guint _tmp20_;
		guint _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		if (transport_error->domain == G_RESOLVER_ERROR) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			guint _tmp4_;
			guint _tmp5_;
			GError* _tmp6_;
			GError* _tmp7_;
			_tmp2_ = publishing_rest_support_transaction_get_endpoint_url (self);
			_tmp3_ = _tmp2_;
			g_object_get (message, "status-code", &_tmp4_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER, "Unable to resolve %s (error code %u)", _tmp3_, _tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp3_);
			_inner_error0_ = _tmp7_;
			if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_error_free0 (transport_error);
				return;
			} else {
				_g_error_free0 (transport_error);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (transport_error->domain == G_IO_ERROR) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			guint _tmp10_;
			guint _tmp11_;
			GError* _tmp12_;
			GError* _tmp13_;
			_tmp8_ = publishing_rest_support_transaction_get_endpoint_url (self);
			_tmp9_ = _tmp8_;
			g_object_get (message, "status-code", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER, "Unable to connect to %s (error code %u)", _tmp9_, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp9_);
			_inner_error0_ = _tmp13_;
			if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_error_free0 (transport_error);
				return;
			} else {
				_g_error_free0 (transport_error);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (transport_error->domain == G_TLS_ERROR) {
			gchar* _tmp14_;
			gchar* _tmp15_;
			GError* _tmp16_;
			GError* _tmp17_;
			_tmp14_ = publishing_rest_support_transaction_get_endpoint_url (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_SSL_FAILED, "Unable to connect to %s: Secure connection failed", _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			_inner_error0_ = _tmp17_;
			if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_error_free0 (transport_error);
				return;
			} else {
				_g_error_free0 (transport_error);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp18_ = publishing_rest_support_transaction_get_endpoint_url (self);
		_tmp19_ = _tmp18_;
		g_object_get (message, "status-code", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER, "Failure communicating with %s (error code %u)", _tmp19_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp19_);
		_inner_error0_ = _tmp23_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_error_free0 (transport_error);
			return;
		} else {
			_g_error_free0 (transport_error);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_object_get (message, "status-code", &_tmp24_, NULL);
	_tmp25_ = _tmp24_;
	switch (_tmp25_) {
		case SOUP_STATUS_OK:
		case SOUP_STATUS_CREATED:
		{
			break;
		}
		default:
		{
			gchar* _tmp26_;
			gchar* _tmp27_;
			guint _tmp28_;
			guint _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			GError* _tmp32_;
			GError* _tmp33_;
			_tmp26_ = publishing_rest_support_transaction_get_endpoint_url (self);
			_tmp27_ = _tmp26_;
			g_object_get (message, "status-code", &_tmp28_, NULL);
			_tmp29_ = _tmp28_;
			_tmp30_ = soup_message_get_reason_phrase (message);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER, "Service %s returned HTTP status code %u %s", _tmp27_, _tmp29_, _tmp31_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp27_);
			_inner_error0_ = _tmp33_;
			if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_error_free0 (transport_error);
				return;
			} else {
				_g_error_free0 (transport_error);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp34_ = self->priv->parent_session;
	_tmp35_ = publishing_rest_support_session_get_body (_tmp34_);
	body = _tmp35_;
	_tmp37_ = body;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		GBytes* _tmp38_;
		_tmp38_ = body;
		_tmp36_ = g_bytes_get_size (_tmp38_) == ((gsize) 0);
	}
	if (_tmp36_) {
		gchar* _tmp39_;
		gchar* _tmp40_;
		GError* _tmp41_;
		GError* _tmp42_;
		_tmp39_ = publishing_rest_support_transaction_get_endpoint_url (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "No response data from %s", _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		_inner_error0_ = _tmp42_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_bytes_unref0 (body);
			_g_error_free0 (transport_error);
			return;
		} else {
			_g_bytes_unref0 (body);
			_g_error_free0 (transport_error);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_bytes_unref0 (body);
	_g_error_free0 (transport_error);
}

static PublishingRESTSupportArgument**
_vala_array_dup1 (PublishingRESTSupportArgument** self,
                  gssize length)
{
	if (length >= 0) {
		PublishingRESTSupportArgument** result;
		gssize i;
		result = g_new0 (PublishingRESTSupportArgument*, length + 1);
		for (i = 0; i < length; i++) {
			PublishingRESTSupportArgument* _tmp0_;
			_tmp0_ = _publishing_rest_support_argument_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

PublishingRESTSupportArgument**
publishing_rest_support_transaction_get_arguments (PublishingRESTSupportTransaction* self,
                                                   gint* result_length1)
{
	PublishingRESTSupportArgument** _tmp0_;
	gint _tmp0__length1;
	PublishingRESTSupportArgument** _tmp1_;
	gint _tmp1__length1;
	PublishingRESTSupportArgument** _tmp2_;
	gint _tmp2__length1;
	PublishingRESTSupportArgument** result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_tmp0_ = self->priv->arguments;
	_tmp0__length1 = self->priv->arguments_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PublishingRESTSupportArgument**
publishing_rest_support_transaction_get_sorted_arguments (PublishingRESTSupportTransaction* self,
                                                          gint* result_length1)
{
	gint _tmp0_ = 0;
	PublishingRESTSupportArgument** _tmp1_;
	PublishingRESTSupportArgument** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	PublishingRESTSupportArgument** _tmp4_;
	PublishingRESTSupportArgument** _tmp5_;
	gint _tmp5__length1;
	PublishingRESTSupportArgument** _tmp6_;
	gint _tmp6__length1;
	PublishingRESTSupportArgument** result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_tmp1_ = publishing_rest_support_transaction_get_arguments (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = publishing_rest_support_argument_sort (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
publishing_rest_support_transaction_set_is_executed (PublishingRESTSupportTransaction* self,
                                                     gboolean is_executed)
{
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	self->priv->is_executed = is_executed;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
publishing_rest_support_transaction_on_accecpt_certificate (PublishingRESTSupportTransaction* self,
                                                            SoupMessage* message,
                                                            GTlsCertificate* cert,
                                                            GTlsCertificateFlags errors)
{
	PublishingRESTSupportSession* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PublishingRESTSupportSession* _tmp3_;
	gboolean result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, soup_message_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cert, g_tls_certificate_get_type ()), FALSE);
	_tmp0_ = self->priv->parent_session;
	_tmp1_ = bool_to_string (publishing_rest_support_session_get_is_insecure (_tmp0_));
	_tmp2_ = _tmp1_;
	g_debug ("RESTSupport.vala:337: HTTPS connect error. Will ignore? %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->parent_session;
	result = publishing_rest_support_session_get_is_insecure (_tmp3_);
	return result;
}

static void
publishing_rest_support_transaction_send_async_data_free (gpointer _data)
{
	PublishingRestSupportTransactionSendAsyncData* _data_;
	_data_ = _data;
	_publishing_rest_support_transaction_unref0 (_data_->self);
	g_slice_free (PublishingRestSupportTransactionSendAsyncData, _data_);
}

static gpointer
_publishing_rest_support_transaction_ref0 (gpointer self)
{
	return self ? publishing_rest_support_transaction_ref (self) : NULL;
}

void
publishing_rest_support_transaction_send_async (PublishingRESTSupportTransaction* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	PublishingRestSupportTransactionSendAsyncData* _data_;
	PublishingRESTSupportTransaction* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	_data_ = g_slice_new0 (PublishingRestSupportTransactionSendAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_rest_support_transaction_send_async_data_free);
	_tmp0_ = _publishing_rest_support_transaction_ref0 (self);
	_data_->self = _tmp0_;
	publishing_rest_support_transaction_send_async_co (_data_);
}

void
publishing_rest_support_transaction_send_finish (PublishingRESTSupportTransaction* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	PublishingRestSupportTransactionSendAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
__lambda5_ (PublishingRESTSupportTransaction* self,
            SoupMessage* message,
            guint chunk_size)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, soup_message_get_type ()));
	self->priv->bytes_written = chunk_size;
	g_signal_emit (self, publishing_rest_support_transaction_signals[PUBLISHING_REST_SUPPORT_TRANSACTION_CHUNK_TRANSMITTED_SIGNAL], 0, self->priv->bytes_written, (guint) self->priv->request_length);
}

static void
___lambda5__soup_message_wrote_body_data (SoupMessage* _sender,
                                          guint chunk_size,
                                          gpointer self)
{
	__lambda5_ ((PublishingRESTSupportTransaction*) self, _sender, chunk_size);
}

static gboolean
_publishing_rest_support_transaction_on_accecpt_certificate_soup_message_accept_certificate (SoupMessage* _sender,
                                                                                             GTlsCertificate* tls_peer_certificate,
                                                                                             GTlsCertificateFlags tls_peer_errors,
                                                                                             gpointer self)
{
	gboolean result;
	result = publishing_rest_support_transaction_on_accecpt_certificate ((PublishingRESTSupportTransaction*) self, _sender, tls_peer_certificate, tls_peer_errors);
	return result;
}

static void
publishing_rest_support_transaction_send_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	PublishingRestSupportTransactionSendAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_rest_support_transaction_send_async_co (_data_);
}

static gboolean
publishing_rest_support_transaction_send_async_co (PublishingRestSupportTransactionSendAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->message;
	_data_->_tmp1_ = g_signal_connect (_data_->_tmp0_, "wrote-body-data", (GCallback) ___lambda5__soup_message_wrote_body_data, _data_->self);
	_data_->id = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->message;
	g_signal_connect (_data_->_tmp2_, "accept-certificate", (GCallback) _publishing_rest_support_transaction_on_accecpt_certificate_soup_message_accept_certificate, _data_->self);
	_data_->_tmp3_ = _data_->self->priv->parent_session;
	_data_->_tmp4_ = _data_->self->priv->message;
	_data_->_state_ = 1;
	publishing_rest_support_session_send_wire_message_async (_data_->_tmp3_, _data_->_tmp4_, publishing_rest_support_transaction_send_async_ready, _data_);
	return FALSE;
	_state_1:
	publishing_rest_support_session_send_wire_message_finish (_data_->_tmp3_, _data_->_res_);
	_data_->_tmp5_ = _data_->self->priv->message;
	publishing_rest_support_transaction_check_response (_data_->self, _data_->_tmp5_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp6_ = _data_->self->priv->message;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, G_TYPE_OBJECT, GObject), _data_->id);
	_data_->_tmp7_ = _data_->self->priv->message;
	g_signal_parse_name ("accept-certificate", soup_message_get_type (), &_data_->_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data_->_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp8_, 0, NULL, (GCallback) _publishing_rest_support_transaction_on_accecpt_certificate_soup_message_accept_certificate, _data_->self);
	g_signal_emit (_data_->self, publishing_rest_support_transaction_signals[PUBLISHING_REST_SUPPORT_TRANSACTION_COMPLETED_SIGNAL], 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

PublishingRESTSupportHttpMethod
publishing_rest_support_transaction_get_method (PublishingRESTSupportTransaction* self)
{
	SoupMessage* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	PublishingRESTSupportHttpMethod result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), 0);
	_tmp0_ = self->priv->message;
	_tmp1_ = soup_message_get_method (_tmp0_);
	_tmp2_ = _tmp1_;
	result = publishing_rest_support_http_method_from_string (_tmp2_);
	return result;
}

static void
publishing_rest_support_transaction_real_add_header (PublishingRESTSupportTransaction* self,
                                                     const gchar* key,
                                                     const gchar* value)
{
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->message;
	_tmp1_ = soup_message_get_request_headers (_tmp0_);
	_tmp2_ = _tmp1_;
	soup_message_headers_append (_tmp2_, key, value);
}

void
publishing_rest_support_transaction_add_header (PublishingRESTSupportTransaction* self,
                                                const gchar* key,
                                                const gchar* value)
{
	PublishingRESTSupportTransactionClass* _klass_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	_klass_ = PUBLISHING_REST_SUPPORT_TRANSACTION_GET_CLASS (self);
	if (_klass_->add_header) {
		_klass_->add_header (self, key, value);
	}
}

void
publishing_rest_support_transaction_set_custom_payload (PublishingRESTSupportTransaction* self,
                                                        const gchar* custom_payload,
                                                        const gchar* payload_content_type,
                                                        gulong payload_length)
{
	gulong _tmp0_ = 0UL;
	gulong length = 0UL;
	SoupMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GBytes* _tmp7_;
	GBytes* _tmp8_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	g_return_if_fail (payload_content_type != NULL);
	_vala_assert (publishing_rest_support_transaction_get_method (self) != PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET, "get_method() != HttpMethod.GET");
	if (custom_payload == NULL) {
		self->priv->use_custom_payload = FALSE;
		return;
	}
	if (payload_length > ((gulong) 0)) {
		_tmp0_ = payload_length;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (custom_payload);
		_tmp2_ = _tmp1_;
		_tmp0_ = (gulong) _tmp2_;
	}
	length = _tmp0_;
	_tmp3_ = self->priv->message;
	_tmp4_ = string_get_data (custom_payload, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	_tmp7_ = g_bytes_new (_tmp6_ + 0, ((gint) length) - 0);
	_tmp8_ = _tmp7_;
	soup_message_set_request_body_from_bytes (_tmp3_, payload_content_type, _tmp8_);
	_g_bytes_unref0 (_tmp8_);
	self->priv->request_length = length;
	self->priv->use_custom_payload = TRUE;
}

void
publishing_rest_support_transaction_set_message (PublishingRESTSupportTransaction* self,
                                                 SoupMessage* message,
                                                 gulong request_length)
{
	SoupMessage* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, soup_message_get_type ()));
	_tmp0_ = _g_object_ref0 (message);
	_g_object_unref0 (self->priv->message);
	self->priv->message = _tmp0_;
	self->priv->request_length = request_length;
}

gboolean
publishing_rest_support_transaction_get_is_executed (PublishingRESTSupportTransaction* self)
{
	gboolean result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), FALSE);
	result = self->priv->is_executed;
	return result;
}

guint
publishing_rest_support_transaction_get_status_code (PublishingRESTSupportTransaction* self)
{
	SoupMessage* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), 0U);
	_vala_assert (publishing_rest_support_transaction_get_is_executed (self), "get_is_executed()");
	_tmp0_ = self->priv->message;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gpointer
_g_uri_ref0 (gpointer self)
{
	return self ? g_uri_ref (self) : NULL;
}

static GUri*
publishing_rest_support_transaction_prepare_rest_message (PublishingRESTSupportTransaction* self)
{
	GString* formdata_string = NULL;
	GString* _tmp1_;
	GUri* old_url = NULL;
	gchar* url_with_query = NULL;
	gboolean _tmp12_ = FALSE;
	GError* _inner_error0_ = NULL;
	GUri* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	if (publishing_rest_support_transaction_get_method (self) == PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST) {
		PublishingRESTSupportArgument** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = self->priv->arguments;
		_tmp0__length1 = self->priv->arguments_length1;
		_vala_assert (_tmp0__length1 > 0, "arguments.length > 0");
	}
	_tmp1_ = g_string_new ("");
	formdata_string = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				PublishingRESTSupportArgument** _tmp4_;
				gint _tmp4__length1;
				GString* _tmp5_;
				PublishingRESTSupportArgument** _tmp6_;
				gint _tmp6__length1;
				PublishingRESTSupportArgument* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				PublishingRESTSupportArgument** _tmp10_;
				gint _tmp10__length1;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->arguments;
				_tmp4__length1 = self->priv->arguments_length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = formdata_string;
				_tmp6_ = self->priv->arguments;
				_tmp6__length1 = self->priv->arguments_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = publishing_rest_support_argument_to_string (_tmp7_, FALSE, FALSE);
				_tmp9_ = _tmp8_;
				g_string_append (_tmp5_, _tmp9_);
				_g_free0 (_tmp9_);
				_tmp10_ = self->priv->arguments;
				_tmp10__length1 = self->priv->arguments_length1;
				if (i < (_tmp10__length1 - 1)) {
					GString* _tmp11_;
					_tmp11_ = formdata_string;
					g_string_append (_tmp11_, "&");
				}
			}
		}
	}
	old_url = NULL;
	url_with_query = NULL;
	if (publishing_rest_support_transaction_get_method (self) == PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET) {
		PublishingRESTSupportArgument** _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = self->priv->arguments;
		_tmp13__length1 = self->priv->arguments_length1;
		_tmp12_ = _tmp13__length1 > 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		SoupMessage* _tmp14_;
		GUri* _tmp15_;
		GUri* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GString* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp14_ = self->priv->message;
		_tmp15_ = soup_message_get_uri (_tmp14_);
		_tmp16_ = _g_uri_ref0 (_tmp15_);
		_g_uri_unref0 (old_url);
		old_url = _tmp16_;
		_tmp17_ = publishing_rest_support_transaction_get_endpoint_url (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, "?", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = formdata_string;
		_tmp22_ = _tmp21_->str;
		_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
		_g_free0 (url_with_query);
		url_with_query = _tmp23_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		{
			GUri* _tmp24_ = NULL;
			const gchar* _tmp25_;
			GUri* _tmp26_;
			SoupMessage* _tmp27_;
			_tmp25_ = url_with_query;
			_tmp26_ = g_uri_parse (_tmp25_, G_URI_FLAGS_ENCODED, &_inner_error0_);
			_tmp24_ = _tmp26_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp27_ = self->priv->message;
			soup_message_set_uri (_tmp27_, _tmp24_);
			_g_uri_unref0 (_tmp24_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp28_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = err->message;
			g_error ("RESTSupport.vala:432: Invalid uri for service: %s", _tmp28_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (url_with_query);
			_g_uri_unref0 (old_url);
			_g_string_free0 (formdata_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		SoupMessage* _tmp29_;
		GString* _tmp30_;
		GBytes* _tmp31_;
		GBytes* _tmp32_;
		_tmp29_ = self->priv->message;
		_tmp30_ = formdata_string;
		formdata_string = NULL;
		_tmp31_ = g_string_free_to_bytes (_tmp30_);
		_tmp32_ = _tmp31_;
		soup_message_set_request_body_from_bytes (_tmp29_, "application/x-www-form-urlencoded", _tmp32_);
		_g_bytes_unref0 (_tmp32_);
	}
	self->priv->is_executed = TRUE;
	result = old_url;
	_g_free0 (url_with_query);
	_g_string_free0 (formdata_string);
	return result;
}

static void
publishing_rest_support_transaction_real_execute_async_data_free (gpointer _data)
{
	PublishingRestSupportTransactionExecuteAsyncData* _data_;
	_data_ = _data;
	_publishing_rest_support_transaction_unref0 (_data_->self);
	g_slice_free (PublishingRestSupportTransactionExecuteAsyncData, _data_);
}

static void
publishing_rest_support_transaction_real_execute_async (PublishingRESTSupportTransaction* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	PublishingRestSupportTransactionExecuteAsyncData* _data_;
	PublishingRESTSupportTransaction* _tmp0_;
	_data_ = g_slice_new0 (PublishingRestSupportTransactionExecuteAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_rest_support_transaction_real_execute_async_data_free);
	_tmp0_ = _publishing_rest_support_transaction_ref0 (self);
	_data_->self = _tmp0_;
	publishing_rest_support_transaction_real_execute_async_co (_data_);
}

static void
publishing_rest_support_transaction_real_execute_finish (PublishingRESTSupportTransaction* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	PublishingRestSupportTransactionExecuteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
publishing_rest_support_transaction_execute_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	PublishingRestSupportTransactionExecuteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_rest_support_transaction_real_execute_async_co (_data_);
}

static gboolean
publishing_rest_support_transaction_real_execute_async_co (PublishingRestSupportTransactionExecuteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->use_custom_payload) {
		_data_->self->priv->is_executed = TRUE;
		_data_->_state_ = 1;
		publishing_rest_support_transaction_send_async (_data_->self, publishing_rest_support_transaction_execute_async_ready, _data_);
		return FALSE;
		_state_1:
		publishing_rest_support_transaction_send_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = publishing_rest_support_transaction_prepare_rest_message (_data_->self);
	_data_->old_url = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->message;
		_data_->_tmp2_ = soup_message_get_uri (_data_->_tmp1_);
		_data_->_tmp3_ = g_uri_to_string (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		g_debug ("RESTSupport.vala:457: sending message to URI = '%s'", _data_->_tmp4_);
		_g_free0 (_data_->_tmp4_);
		_data_->_state_ = 2;
		publishing_rest_support_transaction_send_async (_data_->self, publishing_rest_support_transaction_execute_async_ready, _data_);
		return FALSE;
		_state_2:
		publishing_rest_support_transaction_send_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		_data_->_tmp5_ = _data_->old_url;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp6_ = _data_->self->priv->message;
			_data_->_tmp7_ = _data_->old_url;
			soup_message_set_uri (_data_->_tmp6_, _data_->_tmp7_);
		}
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_uri_unref0 (_data_->old_url);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_uri_unref0 (_data_->old_url);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_uri_unref0 (_data_->old_url);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
publishing_rest_support_transaction_execute_async (PublishingRESTSupportTransaction* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	PublishingRESTSupportTransactionClass* _klass_;
	_klass_ = PUBLISHING_REST_SUPPORT_TRANSACTION_GET_CLASS (self);
	if (_klass_->execute_async) {
		_klass_->execute_async (self, _callback_, _user_data_);
	}
}

void
publishing_rest_support_transaction_execute_finish (PublishingRESTSupportTransaction* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	PublishingRESTSupportTransactionClass* _klass_;
	_klass_ = PUBLISHING_REST_SUPPORT_TRANSACTION_GET_CLASS (self);
	if (_klass_->execute_finish) {
		_klass_->execute_finish (self, _res_, error);
	}
}

gchar*
publishing_rest_support_transaction_get_response (PublishingRESTSupportTransaction* self)
{
	const gchar* _tmp0_ = NULL;
	PublishingRESTSupportSession* _tmp1_;
	GBytes* _tmp2_;
	GBytes* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_vala_assert (publishing_rest_support_transaction_get_is_executed (self), "get_is_executed()");
	_tmp1_ = self->priv->parent_session;
	_tmp2_ = publishing_rest_support_session_get_body (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_bytes_unref0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = "";
	} else {
		PublishingRESTSupportSession* _tmp5_;
		GBytes* _tmp6_;
		GBytes* _tmp7_;
		gsize _tmp8_ = 0;
		guint8* _tmp9_;
		_tmp5_ = self->priv->parent_session;
		_tmp6_ = publishing_rest_support_session_get_body (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp9_ = g_bytes_get_data (_tmp7_, &_tmp8_);
		_tmp0_ = (const gchar*) _tmp9_;
		_g_bytes_unref0 (_tmp7_);
	}
	_tmp10_ = g_strdup (_tmp0_);
	result = _tmp10_;
	return result;
}

SoupMessageHeaders*
publishing_rest_support_transaction_get_response_headers (PublishingRESTSupportTransaction* self)
{
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	SoupMessageHeaders* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_vala_assert (publishing_rest_support_transaction_get_is_executed (self), "get_is_executed()");
	_tmp0_ = self->priv->message;
	_tmp1_ = soup_message_get_response_headers (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

SoupMessage*
publishing_rest_support_transaction_get_message (PublishingRESTSupportTransaction* self)
{
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_vala_assert (publishing_rest_support_transaction_get_is_executed (self), "get_is_executed()");
	_tmp0_ = self->priv->message;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
_vala_array_add1 (PublishingRESTSupportArgument** * array,
                  gint* length,
                  gint* size,
                  PublishingRESTSupportArgument* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PublishingRESTSupportArgument*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
publishing_rest_support_transaction_add_argument (PublishingRESTSupportTransaction* self,
                                                  const gchar* name,
                                                  const gchar* value)
{
	PublishingRESTSupportArgument* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = publishing_rest_support_argument_new (name, value);
	_vala_array_add1 (&self->priv->arguments, &self->priv->arguments_length1, &self->priv->_arguments_size_, _tmp0_);
}

void
publishing_rest_support_transaction_set_argument (PublishingRESTSupportTransaction* self,
                                                  const gchar* name,
                                                  const gchar* value)
{
	PublishingRESTSupportArgument** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->arguments;
	_tmp0__length1 = self->priv->arguments_length1;
	{
		PublishingRESTSupportArgument** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp0_;
		arg_collection_length1 = _tmp0__length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			PublishingRESTSupportArgument* _tmp1_;
			PublishingRESTSupportArgument* arg = NULL;
			_tmp1_ = _publishing_rest_support_argument_ref0 (arg_collection[arg_it]);
			arg = _tmp1_;
			{
				PublishingRESTSupportArgument* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = arg;
				_tmp3_ = _tmp2_->key;
				if (g_strcmp0 (_tmp3_, name) == 0) {
					PublishingRESTSupportArgument* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = arg;
					_tmp5_ = g_strdup (value);
					_g_free0 (_tmp4_->value);
					_tmp4_->value = _tmp5_;
					_publishing_rest_support_argument_unref0 (arg);
					return;
				}
				_publishing_rest_support_argument_unref0 (arg);
			}
		}
	}
	publishing_rest_support_transaction_add_argument (self, name, value);
}

gchar*
publishing_rest_support_transaction_get_endpoint_url (PublishingRESTSupportTransaction* self)
{
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_tmp1_ = self->priv->endpoint_url;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->endpoint_url;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		PublishingRESTSupportSession* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->parent_session;
		_tmp5_ = publishing_rest_support_session_get_endpoint_url (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

PublishingRESTSupportSession*
publishing_rest_support_transaction_get_parent_session (PublishingRESTSupportTransaction* self)
{
	PublishingRESTSupportSession* _tmp0_;
	PublishingRESTSupportSession* _tmp1_;
	PublishingRESTSupportSession* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (self), NULL);
	_tmp0_ = self->priv->parent_session;
	_tmp1_ = _publishing_rest_support_session_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
publishing_rest_support_value_transaction_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
publishing_rest_support_value_transaction_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		publishing_rest_support_transaction_unref (value->data[0].v_pointer);
	}
}

static void
publishing_rest_support_value_transaction_copy_value (const GValue* src_value,
                                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = publishing_rest_support_transaction_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
publishing_rest_support_value_transaction_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
publishing_rest_support_value_transaction_collect_value (GValue* value,
                                                         guint n_collect_values,
                                                         GTypeCValue* collect_values,
                                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PublishingRESTSupportTransaction * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = publishing_rest_support_transaction_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
publishing_rest_support_value_transaction_lcopy_value (const GValue* value,
                                                       guint n_collect_values,
                                                       GTypeCValue* collect_values,
                                                       guint collect_flags)
{
	PublishingRESTSupportTransaction ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = publishing_rest_support_transaction_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
publishing_rest_support_param_spec_transaction (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags)
{
	PublishingRESTSupportParamSpecTransaction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
publishing_rest_support_value_get_transaction (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION), NULL);
	return value->data[0].v_pointer;
}

void
publishing_rest_support_value_set_transaction (GValue* value,
                                               gpointer v_object)
{
	PublishingRESTSupportTransaction * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		publishing_rest_support_transaction_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_transaction_unref (old);
	}
}

void
publishing_rest_support_value_take_transaction (GValue* value,
                                                gpointer v_object)
{
	PublishingRESTSupportTransaction * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_transaction_unref (old);
	}
}

static void
publishing_rest_support_transaction_class_init (PublishingRESTSupportTransactionClass * klass,
                                                gpointer klass_data)
{
	publishing_rest_support_transaction_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportTransactionClass *) klass)->finalize = publishing_rest_support_transaction_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingRESTSupportTransaction_private_offset);
	((PublishingRESTSupportTransactionClass *) klass)->add_header = (void (*) (PublishingRESTSupportTransaction*, const gchar*, const gchar*)) publishing_rest_support_transaction_real_add_header;
	((PublishingRESTSupportTransactionClass *) klass)->execute_async = (void (*) (PublishingRESTSupportTransaction*, GAsyncReadyCallback, gpointer)) publishing_rest_support_transaction_real_execute_async;
	((PublishingRESTSupportTransactionClass *) klass)->execute_finish = (void (*) (PublishingRESTSupportTransaction*, GAsyncResult*, GError**)) publishing_rest_support_transaction_real_execute_finish;
	publishing_rest_support_transaction_signals[PUBLISHING_REST_SUPPORT_TRANSACTION_CHUNK_TRANSMITTED_SIGNAL] = g_signal_new ("chunk-transmitted", PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	publishing_rest_support_transaction_signals[PUBLISHING_REST_SUPPORT_TRANSACTION_COMPLETED_SIGNAL] = g_signal_new ("completed", PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
publishing_rest_support_transaction_instance_init (PublishingRESTSupportTransaction * self,
                                                   gpointer klass)
{
	self->priv = publishing_rest_support_transaction_get_instance_private (self);
	self->priv->is_executed = FALSE;
	self->priv->parent_session = NULL;
	self->priv->message = NULL;
	self->priv->bytes_written = (guint) 0;
	self->priv->endpoint_url = NULL;
	self->ref_count = 1;
}

static void
publishing_rest_support_transaction_finalize (PublishingRESTSupportTransaction * obj)
{
	PublishingRESTSupportTransaction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction);
	g_signal_handlers_destroy (self);
	self->priv->arguments = (_vala_array_free (self->priv->arguments, self->priv->arguments_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
	_g_object_unref0 (self->priv->message);
	_g_free0 (self->priv->endpoint_url);
}

static GType
publishing_rest_support_transaction_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { publishing_rest_support_value_transaction_init, publishing_rest_support_value_transaction_free_value, publishing_rest_support_value_transaction_copy_value, publishing_rest_support_value_transaction_peek_pointer, "p", publishing_rest_support_value_transaction_collect_value, "p", publishing_rest_support_value_transaction_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportTransaction), 0, (GInstanceInitFunc) publishing_rest_support_transaction_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType publishing_rest_support_transaction_type_id;
	publishing_rest_support_transaction_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PublishingRESTSupportTransaction", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PublishingRESTSupportTransaction_private_offset = g_type_add_instance_private (publishing_rest_support_transaction_type_id, sizeof (PublishingRESTSupportTransactionPrivate));
	return publishing_rest_support_transaction_type_id;
}

GType
publishing_rest_support_transaction_get_type (void)
{
	static volatile gsize publishing_rest_support_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_transaction_type_id__once)) {
		GType publishing_rest_support_transaction_type_id;
		publishing_rest_support_transaction_type_id = publishing_rest_support_transaction_get_type_once ();
		g_once_init_leave (&publishing_rest_support_transaction_type_id__once, publishing_rest_support_transaction_type_id);
	}
	return publishing_rest_support_transaction_type_id__once;
}

gpointer
publishing_rest_support_transaction_ref (gpointer instance)
{
	PublishingRESTSupportTransaction * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
publishing_rest_support_transaction_unref (gpointer instance)
{
	PublishingRESTSupportTransaction * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PUBLISHING_REST_SUPPORT_TRANSACTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

PublishingRESTSupportUploadTransaction*
publishing_rest_support_upload_transaction_construct (GType object_type,
                                                      PublishingRESTSupportSession* session,
                                                      SpitPublishingPublishable* publishable)
{
	PublishingRESTSupportUploadTransaction* self = NULL;
	SpitPublishingPublishable* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (session), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (publishable, SPIT_PUBLISHING_TYPE_PUBLISHABLE), NULL);
	self = (PublishingRESTSupportUploadTransaction*) publishing_rest_support_transaction_construct (object_type, session, PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST);
	_tmp0_ = _g_object_ref0 (publishable);
	_g_object_unref0 (self->publishable);
	self->publishable = _tmp0_;
	_tmp1_ = publishing_rest_support_upload_transaction_media_type_to_mime_type (spit_publishing_publishable_get_media_type (publishable));
	_g_free0 (self->mime_type);
	self->mime_type = _tmp1_;
	_tmp2_ = publishing_rest_support_upload_transaction_create_default_binary_disposition_table (self);
	_g_hash_table_unref0 (self->binary_disposition_table);
	self->binary_disposition_table = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->message_headers);
	self->message_headers = _tmp3_;
	return self;
}

PublishingRESTSupportUploadTransaction*
publishing_rest_support_upload_transaction_new (PublishingRESTSupportSession* session,
                                                SpitPublishingPublishable* publishable)
{
	return publishing_rest_support_upload_transaction_construct (PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, session, publishable);
}

PublishingRESTSupportUploadTransaction*
publishing_rest_support_upload_transaction_construct_with_endpoint_url (GType object_type,
                                                                        PublishingRESTSupportSession* session,
                                                                        SpitPublishingPublishable* publishable,
                                                                        const gchar* endpoint_url)
{
	PublishingRESTSupportUploadTransaction* self = NULL;
	SpitPublishingPublishable* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (session), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (publishable, SPIT_PUBLISHING_TYPE_PUBLISHABLE), NULL);
	g_return_val_if_fail (endpoint_url != NULL, NULL);
	self = (PublishingRESTSupportUploadTransaction*) publishing_rest_support_transaction_construct_with_endpoint_url (object_type, session, endpoint_url, PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST);
	_tmp0_ = _g_object_ref0 (publishable);
	_g_object_unref0 (self->publishable);
	self->publishable = _tmp0_;
	_tmp1_ = publishing_rest_support_upload_transaction_media_type_to_mime_type (spit_publishing_publishable_get_media_type (publishable));
	_g_free0 (self->mime_type);
	self->mime_type = _tmp1_;
	_tmp2_ = publishing_rest_support_upload_transaction_create_default_binary_disposition_table (self);
	_g_hash_table_unref0 (self->binary_disposition_table);
	self->binary_disposition_table = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->message_headers);
	self->message_headers = _tmp3_;
	return self;
}

PublishingRESTSupportUploadTransaction*
publishing_rest_support_upload_transaction_new_with_endpoint_url (PublishingRESTSupportSession* session,
                                                                  SpitPublishingPublishable* publishable,
                                                                  const gchar* endpoint_url)
{
	return publishing_rest_support_upload_transaction_construct_with_endpoint_url (PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, session, publishable, endpoint_url);
}

static void
publishing_rest_support_upload_transaction_real_add_header (PublishingRESTSupportTransaction* base,
                                                            const gchar* key,
                                                            const gchar* value)
{
	PublishingRESTSupportUploadTransaction * self;
	GeeHashMap* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportUploadTransaction);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->message_headers;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key, value);
}

static gchar*
publishing_rest_support_upload_transaction_media_type_to_mime_type (SpitPublishingPublisherMediaType media_type)
{
	gchar* result;
	if (media_type == SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("image/jpeg");
		result = _tmp0_;
		return result;
	} else {
		if (media_type == SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("video/mpeg");
			result = _tmp1_;
			return result;
		} else {
			GEnumValue* _tmp2_;
			_tmp2_ = g_enum_get_value (g_type_class_ref (SPIT_PUBLISHING_PUBLISHER_TYPE_MEDIA_TYPE), media_type);
			g_error ("RESTSupport.vala:543: UploadTransaction: unknown media type %s.", (_tmp2_ != NULL) ? _tmp2_->value_name : NULL);
		}
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GHashTable*
publishing_rest_support_upload_transaction_create_default_binary_disposition_table (PublishingRESTSupportUploadTransaction* self)
{
	GHashTable* _result_ = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	SpitPublishingPublishable* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GHashTable* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_UPLOAD_TRANSACTION (self), NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_result_ = _tmp2_;
	_tmp3_ = g_strdup ("filename");
	_tmp4_ = self->publishable;
	_tmp5_ = spit_publishing_publishable_get_serialized_file (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_get_basename (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_uri_escape_string (_tmp8_, NULL, TRUE);
	g_hash_table_insert (_result_, _tmp3_, _tmp9_);
	_g_free0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	result = _result_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
publishing_rest_support_upload_transaction_set_binary_disposition_table (PublishingRESTSupportUploadTransaction* self,
                                                                         GHashTable* new_disp_table)
{
	GHashTable* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_UPLOAD_TRANSACTION (self));
	g_return_if_fail (new_disp_table != NULL);
	_tmp0_ = _g_hash_table_ref0 (new_disp_table);
	_g_hash_table_unref0 (self->binary_disposition_table);
	self->binary_disposition_table = _tmp0_;
}

static void
_vala_SoupMultipart_free (SoupMultipart* self)
{
	g_boxed_free (soup_multipart_get_type (), self);
}

static void
publishing_rest_support_upload_transaction_prepare_execution (PublishingRESTSupportUploadTransaction* self,
                                                              GError** error)
{
	PublishingRESTSupportArgument** request_arguments = NULL;
	gint _tmp0_ = 0;
	PublishingRESTSupportArgument** _tmp1_;
	gint request_arguments_length1;
	gint _request_arguments_size_;
	PublishingRESTSupportArgument** _tmp2_;
	gint _tmp2__length1;
	SoupMultipart* message_parts = NULL;
	SoupMultipart* _tmp3_;
	PublishingRESTSupportArgument** _tmp4_;
	gint _tmp4__length1;
	GMappedFile* mapped_file = NULL;
	SoupMultipart* _tmp21_;
	SpitPublishingPublishable* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GMappedFile* _tmp28_;
	GBytes* _tmp29_;
	GBytes* _tmp30_;
	SoupMessageHeaders* image_part_header = NULL;
	GBytes* image_part_body = NULL;
	gint payload_part_num = 0;
	SoupMultipart* _tmp31_;
	SoupMultipart* _tmp32_;
	SoupMessageHeaders* _tmp33_ = NULL;
	GBytes* _tmp34_ = NULL;
	SoupMessageHeaders* _tmp35_;
	SoupMessageHeaders* _tmp36_;
	GHashTable* _tmp37_;
	SoupMessage* outbound_message = NULL;
	gchar* _tmp38_;
	gchar* _tmp39_;
	SoupMultipart* _tmp40_;
	SoupMessage* _tmp41_;
	SoupMessage* _tmp42_;
	GeeMapIterator* i = NULL;
	GeeHashMap* _tmp43_;
	GeeMapIterator* _tmp44_;
	gboolean cont = FALSE;
	GeeMapIterator* _tmp45_;
	SoupMessage* _tmp56_;
	GMappedFile* _tmp57_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_UPLOAD_TRANSACTION (self));
	_tmp1_ = publishing_rest_support_transaction_get_arguments (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), &_tmp0_);
	request_arguments = _tmp1_;
	request_arguments_length1 = _tmp0_;
	_request_arguments_size_ = request_arguments_length1;
	_tmp2_ = request_arguments;
	_tmp2__length1 = request_arguments_length1;
	_vala_assert (_tmp2__length1 > 0, "request_arguments.length > 0");
	_tmp3_ = soup_multipart_new ("multipart/form-data");
	message_parts = _tmp3_;
	_tmp4_ = request_arguments;
	_tmp4__length1 = request_arguments_length1;
	{
		PublishingRESTSupportArgument** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			PublishingRESTSupportArgument* _tmp5_;
			PublishingRESTSupportArgument* arg = NULL;
			_tmp5_ = _publishing_rest_support_argument_ref0 (arg_collection[arg_it]);
			arg = _tmp5_;
			{
				SoupMultipart* _tmp6_;
				PublishingRESTSupportArgument* _tmp7_;
				const gchar* _tmp8_;
				PublishingRESTSupportArgument* _tmp9_;
				const gchar* _tmp10_;
				_tmp6_ = message_parts;
				_tmp7_ = arg;
				_tmp8_ = _tmp7_->key;
				_tmp9_ = arg;
				_tmp10_ = _tmp9_->value;
				soup_multipart_append_form_string (_tmp6_, _tmp8_, _tmp10_);
				_publishing_rest_support_argument_unref0 (arg);
			}
		}
	}
	mapped_file = NULL;
	{
		GMappedFile* _tmp11_ = NULL;
		SpitPublishingPublishable* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GMappedFile* _tmp17_;
		GMappedFile* _tmp18_;
		GMappedFile* _tmp19_;
		_tmp12_ = self->publishable;
		_tmp13_ = spit_publishing_publishable_get_serialized_file (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_get_path (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_mapped_file_new (_tmp16_, FALSE, &_inner_error0_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_g_object_unref0 (_tmp14_);
		_tmp11_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp19_ = _tmp11_;
		_tmp11_ = NULL;
		_g_mapped_file_unref0 (mapped_file);
		mapped_file = _tmp19_;
		_g_mapped_file_unref0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _tmp20_;
		g_clear_error (&_inner_error0_);
		_tmp20_ = g_error_new_literal (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR, _ ("A temporary file needed for publishing is unavailable"));
		_inner_error0_ = _tmp20_;
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_mapped_file_unref0 (mapped_file);
			__vala_SoupMultipart_free0 (message_parts);
			request_arguments = (_vala_array_free (request_arguments, request_arguments_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
			return;
		} else {
			_g_mapped_file_unref0 (mapped_file);
			__vala_SoupMultipart_free0 (message_parts);
			request_arguments = (_vala_array_free (request_arguments, request_arguments_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp21_ = message_parts;
	_tmp22_ = self->publishable;
	_tmp23_ = spit_publishing_publishable_get_serialized_file (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_file_get_path (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->mime_type;
	_tmp28_ = mapped_file;
	_tmp29_ = g_mapped_file_get_bytes (_tmp28_);
	_tmp30_ = _tmp29_;
	soup_multipart_append_form_file (_tmp21_, "", _tmp26_, _tmp27_, _tmp30_);
	_g_bytes_unref0 (_tmp30_);
	_g_free0 (_tmp26_);
	_g_object_unref0 (_tmp24_);
	_tmp31_ = message_parts;
	payload_part_num = soup_multipart_get_length (_tmp31_) - 1;
	_tmp32_ = message_parts;
	soup_multipart_get_part (_tmp32_, payload_part_num, &_tmp33_, &_tmp34_);
	image_part_header = _tmp33_;
	image_part_body = _tmp34_;
	_tmp35_ = image_part_header;
	g_debug ("RESTSupport.vala:584: Image part header %p", _tmp35_);
	_tmp36_ = image_part_header;
	_tmp37_ = self->binary_disposition_table;
	soup_message_headers_set_content_disposition (_tmp36_, "form-data", _tmp37_);
	_tmp38_ = publishing_rest_support_transaction_get_endpoint_url (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
	_tmp39_ = _tmp38_;
	_tmp40_ = message_parts;
	_tmp41_ = soup_message_new_from_multipart (_tmp39_, _tmp40_);
	_tmp42_ = _tmp41_;
	_g_free0 (_tmp39_);
	outbound_message = _tmp42_;
	_tmp43_ = self->message_headers;
	_tmp44_ = gee_abstract_map_map_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	i = _tmp44_;
	_tmp45_ = i;
	cont = gee_map_iterator_next (_tmp45_);
	while (TRUE) {
		SoupMessage* _tmp46_;
		SoupMessageHeaders* _tmp47_;
		SoupMessageHeaders* _tmp48_;
		GeeMapIterator* _tmp49_;
		gpointer _tmp50_;
		gchar* _tmp51_;
		GeeMapIterator* _tmp52_;
		gpointer _tmp53_;
		gchar* _tmp54_;
		GeeMapIterator* _tmp55_;
		if (!cont) {
			break;
		}
		_tmp46_ = outbound_message;
		_tmp47_ = soup_message_get_request_headers (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = i;
		_tmp50_ = gee_map_iterator_get_key (_tmp49_);
		_tmp51_ = (gchar*) _tmp50_;
		_tmp52_ = i;
		_tmp53_ = gee_map_iterator_get_value (_tmp52_);
		_tmp54_ = (gchar*) _tmp53_;
		soup_message_headers_append (_tmp48_, _tmp51_, _tmp54_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp51_);
		_tmp55_ = i;
		cont = gee_map_iterator_next (_tmp55_);
	}
	_tmp56_ = outbound_message;
	_tmp57_ = mapped_file;
	publishing_rest_support_transaction_set_message (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _tmp56_, (gulong) g_mapped_file_get_length (_tmp57_));
	publishing_rest_support_transaction_set_is_executed (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), TRUE);
	_g_object_unref0 (i);
	_g_object_unref0 (outbound_message);
	_g_mapped_file_unref0 (mapped_file);
	__vala_SoupMultipart_free0 (message_parts);
	request_arguments = (_vala_array_free (request_arguments, request_arguments_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
}

static void
publishing_rest_support_upload_transaction_real_execute_async_data_free (gpointer _data)
{
	PublishingRestSupportUploadTransactionExecuteAsyncData* _data_;
	_data_ = _data;
	_publishing_rest_support_transaction_unref0 (_data_->self);
	g_slice_free (PublishingRestSupportUploadTransactionExecuteAsyncData, _data_);
}

static void
publishing_rest_support_upload_transaction_real_execute_async (PublishingRESTSupportTransaction* base,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	PublishingRESTSupportUploadTransaction * self;
	PublishingRestSupportUploadTransactionExecuteAsyncData* _data_;
	PublishingRESTSupportUploadTransaction* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportUploadTransaction);
	_data_ = g_slice_new0 (PublishingRestSupportUploadTransactionExecuteAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_rest_support_upload_transaction_real_execute_async_data_free);
	_tmp0_ = _publishing_rest_support_transaction_ref0 (self);
	_data_->self = _tmp0_;
	publishing_rest_support_upload_transaction_real_execute_async_co (_data_);
}

static void
publishing_rest_support_upload_transaction_execute_finish (PublishingRESTSupportTransaction* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	PublishingRestSupportUploadTransactionExecuteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
publishing_rest_support_upload_transaction_execute_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	PublishingRestSupportUploadTransactionExecuteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_rest_support_upload_transaction_real_execute_async_co (_data_);
}

static gboolean
publishing_rest_support_upload_transaction_real_execute_async_co (PublishingRestSupportUploadTransactionExecuteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	publishing_rest_support_upload_transaction_prepare_execution (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_state_ = 1;
	publishing_rest_support_transaction_send_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), publishing_rest_support_upload_transaction_execute_async_ready, _data_);
	return FALSE;
	_state_1:
	publishing_rest_support_transaction_send_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_rest_support_upload_transaction_class_init (PublishingRESTSupportUploadTransactionClass * klass,
                                                       gpointer klass_data)
{
	publishing_rest_support_upload_transaction_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportTransactionClass *) klass)->finalize = publishing_rest_support_upload_transaction_finalize;
	((PublishingRESTSupportTransactionClass *) klass)->add_header = (void (*) (PublishingRESTSupportTransaction*, const gchar*, const gchar*)) publishing_rest_support_upload_transaction_real_add_header;
	((PublishingRESTSupportTransactionClass *) klass)->execute_async = (void (*) (PublishingRESTSupportTransaction*, GAsyncReadyCallback, gpointer)) publishing_rest_support_upload_transaction_real_execute_async;
	((PublishingRESTSupportTransactionClass *) klass)->execute_finish = (void (*) (PublishingRESTSupportTransaction*, GAsyncResult*, GError**)) publishing_rest_support_upload_transaction_execute_finish;
}

static void
publishing_rest_support_upload_transaction_instance_init (PublishingRESTSupportUploadTransaction * self,
                                                          gpointer klass)
{
	self->binary_disposition_table = NULL;
	self->publishable = NULL;
	self->message_headers = NULL;
}

static void
publishing_rest_support_upload_transaction_finalize (PublishingRESTSupportTransaction * obj)
{
	PublishingRESTSupportUploadTransaction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportUploadTransaction);
	_g_hash_table_unref0 (self->binary_disposition_table);
	_g_object_unref0 (self->publishable);
	_g_free0 (self->mime_type);
	_g_object_unref0 (self->message_headers);
	PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS (publishing_rest_support_upload_transaction_parent_class)->finalize (obj);
}

static GType
publishing_rest_support_upload_transaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportUploadTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_upload_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportUploadTransaction), 0, (GInstanceInitFunc) publishing_rest_support_upload_transaction_instance_init, NULL };
	GType publishing_rest_support_upload_transaction_type_id;
	publishing_rest_support_upload_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, "PublishingRESTSupportUploadTransaction", &g_define_type_info, 0);
	return publishing_rest_support_upload_transaction_type_id;
}

GType
publishing_rest_support_upload_transaction_get_type (void)
{
	static volatile gsize publishing_rest_support_upload_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_upload_transaction_type_id__once)) {
		GType publishing_rest_support_upload_transaction_type_id;
		publishing_rest_support_upload_transaction_type_id = publishing_rest_support_upload_transaction_get_type_once ();
		g_once_init_leave (&publishing_rest_support_upload_transaction_type_id__once, publishing_rest_support_upload_transaction_type_id);
	}
	return publishing_rest_support_upload_transaction_type_id__once;
}

static inline gpointer
publishing_rest_support_xml_document_get_instance_private (PublishingRESTSupportXmlDocument* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingRESTSupportXmlDocument_private_offset);
}

static PublishingRESTSupportXmlDocument*
publishing_rest_support_xml_document_construct (GType object_type,
                                                xmlDoc* doc)
{
	PublishingRESTSupportXmlDocument* self = NULL;
	self = (PublishingRESTSupportXmlDocument*) g_type_create_instance (object_type);
	self->priv->document = doc;
	return self;
}

static PublishingRESTSupportXmlDocument*
publishing_rest_support_xml_document_new (xmlDoc* doc)
{
	return publishing_rest_support_xml_document_construct (PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT, doc);
}

xmlNode*
publishing_rest_support_xml_document_get_root_node (PublishingRESTSupportXmlDocument* self)
{
	xmlDoc* _tmp0_;
	xmlNode* _tmp1_;
	xmlNode* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_XML_DOCUMENT (self), NULL);
	_tmp0_ = self->priv->document;
	_tmp1_ = xmlDocGetRootElement (_tmp0_);
	result = _tmp1_;
	return result;
}

xmlNode*
publishing_rest_support_xml_document_get_named_child (PublishingRESTSupportXmlDocument* self,
                                                      xmlNode* parent,
                                                      const gchar* child_name,
                                                      GError** error)
{
	xmlNode* doc_node_iter = NULL;
	xmlNode* _tmp0_;
	GError* _tmp8_;
	GError* _inner_error0_ = NULL;
	xmlNode* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_XML_DOCUMENT (self), NULL);
	g_return_val_if_fail (child_name != NULL, NULL);
	_tmp0_ = parent->children;
	doc_node_iter = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			xmlNode* _tmp4_;
			xmlNode* _tmp5_;
			const gchar* _tmp6_;
			if (!_tmp1_) {
				xmlNode* _tmp2_;
				xmlNode* _tmp3_;
				_tmp2_ = doc_node_iter;
				_tmp3_ = _tmp2_->next;
				doc_node_iter = _tmp3_;
			}
			_tmp1_ = FALSE;
			_tmp4_ = doc_node_iter;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = doc_node_iter;
			_tmp6_ = _tmp5_->name;
			if (g_strcmp0 (_tmp6_, child_name) == 0) {
				xmlNode* _tmp7_;
				_tmp7_ = doc_node_iter;
				result = _tmp7_;
				return result;
			}
		}
	}
	_tmp8_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "Can't find XML node %s", child_name);
	_inner_error0_ = _tmp8_;
	if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

gchar*
publishing_rest_support_xml_document_get_property_value (PublishingRESTSupportXmlDocument* self,
                                                         xmlNode* node,
                                                         const gchar* property_key,
                                                         GError** error)
{
	gchar* value_string = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_XML_DOCUMENT (self), NULL);
	g_return_val_if_fail (property_key != NULL, NULL);
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) property_key);
	value_string = _tmp0_;
	_tmp1_ = value_string;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GError* _tmp3_;
		_tmp2_ = node->name;
		_tmp3_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "Can't find XML " "property %s on node %s", property_key, _tmp2_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (value_string);
			return NULL;
		} else {
			_g_free0 (value_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = value_string;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

PublishingRESTSupportXmlDocument*
publishing_rest_support_xml_document_parse_string (const gchar* input_string,
                                                   PublishingRESTSupportXmlDocumentCheckForErrorResponse check_for_error_response,
                                                   gpointer check_for_error_response_target,
                                                   GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	xmlDoc* doc = NULL;
	gint _tmp15_;
	gint _tmp16_;
	xmlDoc* _tmp17_;
	xmlDoc* _tmp18_;
	xmlDoc* _tmp20_;
	xmlNode* _tmp21_;
	PublishingRESTSupportXmlDocument* rest_doc = NULL;
	xmlDoc* _tmp23_;
	PublishingRESTSupportXmlDocument* _tmp24_;
	gchar* _result_ = NULL;
	PublishingRESTSupportXmlDocument* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	PublishingRESTSupportXmlDocument* result;
	if (input_string == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (input_string);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "Empty XML string");
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = string_chug (input_string);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_chomp (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = !g_str_has_prefix (_tmp8_, "<");
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	if (_tmp9_) {
		_tmp4_ = TRUE;
	} else {
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = string_chug (input_string);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_chomp (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp4_ = !g_str_has_suffix (_tmp13_, ">");
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
	}
	if (_tmp4_) {
		GError* _tmp14_;
		_tmp14_ = g_error_new_literal (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "Unable to parse XML " "document");
		_inner_error0_ = _tmp14_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = strlen (input_string);
	_tmp16_ = _tmp15_;
	_tmp17_ = xmlReadMemory (input_string, (gint) _tmp16_, NULL, NULL, (gint) (XML_PARSE_NOBLANKS | XML_PARSE_RECOVER));
	doc = _tmp17_;
	_tmp18_ = doc;
	if (_tmp18_ == NULL) {
		GError* _tmp19_;
		_tmp19_ = g_error_new_literal (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "Unable to parse XML " "document");
		_inner_error0_ = _tmp19_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = doc;
	_tmp21_ = _tmp20_->children;
	if (_tmp21_ == NULL) {
		GError* _tmp22_;
		_tmp22_ = g_error_new_literal (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "Unable to parse XML " "document");
		_inner_error0_ = _tmp22_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp23_ = doc;
	_tmp24_ = publishing_rest_support_xml_document_new (_tmp23_);
	rest_doc = _tmp24_;
	_tmp25_ = rest_doc;
	_tmp26_ = check_for_error_response (_tmp25_, check_for_error_response_target);
	_result_ = _tmp26_;
	_tmp27_ = _result_;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_;
		GError* _tmp29_;
		_tmp28_ = _result_;
		_tmp29_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_SERVICE_ERROR, "%s", _tmp28_);
		_inner_error0_ = _tmp29_;
		if (_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_result_);
			_publishing_rest_support_xml_document_unref0 (rest_doc);
			return NULL;
		} else {
			_g_free0 (_result_);
			_publishing_rest_support_xml_document_unref0 (rest_doc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = rest_doc;
	_g_free0 (_result_);
	return result;
}

static void
publishing_rest_support_value_xml_document_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
publishing_rest_support_value_xml_document_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		publishing_rest_support_xml_document_unref (value->data[0].v_pointer);
	}
}

static void
publishing_rest_support_value_xml_document_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = publishing_rest_support_xml_document_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
publishing_rest_support_value_xml_document_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
publishing_rest_support_value_xml_document_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PublishingRESTSupportXmlDocument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = publishing_rest_support_xml_document_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
publishing_rest_support_value_xml_document_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	PublishingRESTSupportXmlDocument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = publishing_rest_support_xml_document_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
publishing_rest_support_param_spec_xml_document (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	PublishingRESTSupportParamSpecXmlDocument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
publishing_rest_support_value_get_xml_document (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT), NULL);
	return value->data[0].v_pointer;
}

void
publishing_rest_support_value_set_xml_document (GValue* value,
                                                gpointer v_object)
{
	PublishingRESTSupportXmlDocument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		publishing_rest_support_xml_document_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_xml_document_unref (old);
	}
}

void
publishing_rest_support_value_take_xml_document (GValue* value,
                                                 gpointer v_object)
{
	PublishingRESTSupportXmlDocument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_xml_document_unref (old);
	}
}

static void
publishing_rest_support_xml_document_class_init (PublishingRESTSupportXmlDocumentClass * klass,
                                                 gpointer klass_data)
{
	publishing_rest_support_xml_document_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportXmlDocumentClass *) klass)->finalize = publishing_rest_support_xml_document_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingRESTSupportXmlDocument_private_offset);
}

static void
publishing_rest_support_xml_document_instance_init (PublishingRESTSupportXmlDocument * self,
                                                    gpointer klass)
{
	self->priv = publishing_rest_support_xml_document_get_instance_private (self);
	self->ref_count = 1;
}

static void
publishing_rest_support_xml_document_finalize (PublishingRESTSupportXmlDocument * obj)
{
	PublishingRESTSupportXmlDocument * self;
	xmlDoc* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_TYPE_XML_DOCUMENT, PublishingRESTSupportXmlDocument);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->document;
	_xmlFreeDoc0 (_tmp0_);
}

static GType
publishing_rest_support_xml_document_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { publishing_rest_support_value_xml_document_init, publishing_rest_support_value_xml_document_free_value, publishing_rest_support_value_xml_document_copy_value, publishing_rest_support_value_xml_document_peek_pointer, "p", publishing_rest_support_value_xml_document_collect_value, "p", publishing_rest_support_value_xml_document_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportXmlDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_xml_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportXmlDocument), 0, (GInstanceInitFunc) publishing_rest_support_xml_document_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType publishing_rest_support_xml_document_type_id;
	publishing_rest_support_xml_document_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PublishingRESTSupportXmlDocument", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PublishingRESTSupportXmlDocument_private_offset = g_type_add_instance_private (publishing_rest_support_xml_document_type_id, sizeof (PublishingRESTSupportXmlDocumentPrivate));
	return publishing_rest_support_xml_document_type_id;
}

GType
publishing_rest_support_xml_document_get_type (void)
{
	static volatile gsize publishing_rest_support_xml_document_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_xml_document_type_id__once)) {
		GType publishing_rest_support_xml_document_type_id;
		publishing_rest_support_xml_document_type_id = publishing_rest_support_xml_document_get_type_once ();
		g_once_init_leave (&publishing_rest_support_xml_document_type_id__once, publishing_rest_support_xml_document_type_id);
	}
	return publishing_rest_support_xml_document_type_id__once;
}

gpointer
publishing_rest_support_xml_document_ref (gpointer instance)
{
	PublishingRESTSupportXmlDocument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
publishing_rest_support_xml_document_unref (gpointer instance)
{
	PublishingRESTSupportXmlDocument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PUBLISHING_REST_SUPPORT_XML_DOCUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gchar*
publishing_rest_support_decimal_entity_encode (const gchar* source)
{
	GString* encoded_str_builder = NULL;
	GString* _tmp0_;
	gchar* current_char = NULL;
	gchar* _tmp1_;
	GString* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = g_string_new ("");
	encoded_str_builder = _tmp0_;
	_tmp1_ = g_strdup (source);
	current_char = _tmp1_;
	while (TRUE) {
		gint current_char_value = 0;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp2_ = current_char;
		current_char_value = (gint) g_utf8_get_char_validated (_tmp2_, (gssize) -1);
		if (current_char_value < 1) {
			break;
		}
		if (current_char_value < 128) {
			_tmp5_ = current_char_value != ((gint) '&');
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = current_char_value != ((gint) '<');
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = current_char_value != ((gint) '>');
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GString* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = encoded_str_builder;
			_tmp7_ = current_char;
			g_string_append_unichar (_tmp6_, g_utf8_get_char_validated (_tmp7_, (gssize) -1));
		} else {
			GString* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = encoded_str_builder;
			_tmp9_ = g_strdup_printf ("&#%d;", current_char_value);
			_tmp10_ = _tmp9_;
			g_string_append (_tmp8_, _tmp10_);
			_g_free0 (_tmp10_);
		}
		_tmp11_ = current_char;
		_tmp12_ = g_utf8_next_char (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (current_char);
		current_char = _tmp13_;
	}
	_tmp14_ = encoded_str_builder;
	_tmp15_ = _tmp14_->str;
	_tmp16_ = g_strdup (_tmp15_);
	result = _tmp16_;
	_g_free0 (current_char);
	_g_string_free0 (encoded_str_builder);
	return result;
}

static inline gpointer
publishing_rest_support_batch_uploader_get_instance_private (PublishingRESTSupportBatchUploader* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingRESTSupportBatchUploader_private_offset);
}

static SpitPublishingPublishable**
_vala_array_dup2 (SpitPublishingPublishable** self,
                  gssize length)
{
	if (length >= 0) {
		SpitPublishingPublishable** result;
		gssize i;
		result = g_new0 (SpitPublishingPublishable*, length + 1);
		for (i = 0; i < length; i++) {
			SpitPublishingPublishable* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

PublishingRESTSupportBatchUploader*
publishing_rest_support_batch_uploader_construct (GType object_type,
                                                  PublishingRESTSupportSession* session,
                                                  SpitPublishingPublishable** publishables,
                                                  gint publishables_length1)
{
	PublishingRESTSupportBatchUploader* self = NULL;
	SpitPublishingPublishable** _tmp0_;
	gint _tmp0__length1;
	PublishingRESTSupportSession* _tmp1_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_SESSION (session), NULL);
	self = (PublishingRESTSupportBatchUploader*) g_type_create_instance (object_type);
	_tmp0_ = (publishables != NULL) ? _vala_array_dup2 (publishables, publishables_length1) : publishables;
	_tmp0__length1 = publishables_length1;
	self->priv->publishables = (_vala_array_free (self->priv->publishables, self->priv->publishables_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->publishables = _tmp0_;
	self->priv->publishables_length1 = _tmp0__length1;
	self->priv->_publishables_size_ = self->priv->publishables_length1;
	_tmp1_ = _publishing_rest_support_session_ref0 (session);
	_publishing_rest_support_session_unref0 (self->priv->session);
	self->priv->session = _tmp1_;
	return self;
}

static void
publishing_rest_support_batch_uploader_send_files_async_data_free (gpointer _data)
{
	PublishingRestSupportBatchUploaderSendFilesAsyncData* _data_;
	_data_ = _data;
	_publishing_rest_support_batch_uploader_unref0 (_data_->self);
	g_slice_free (PublishingRestSupportBatchUploaderSendFilesAsyncData, _data_);
}

static gpointer
_publishing_rest_support_batch_uploader_ref0 (gpointer self)
{
	return self ? publishing_rest_support_batch_uploader_ref (self) : NULL;
}

static void
publishing_rest_support_batch_uploader_send_files_async (PublishingRESTSupportBatchUploader* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	PublishingRestSupportBatchUploaderSendFilesAsyncData* _data_;
	PublishingRESTSupportBatchUploader* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_BATCH_UPLOADER (self));
	_data_ = g_slice_new0 (PublishingRestSupportBatchUploaderSendFilesAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_rest_support_batch_uploader_send_files_async_data_free);
	_tmp0_ = _publishing_rest_support_batch_uploader_ref0 (self);
	_data_->self = _tmp0_;
	publishing_rest_support_batch_uploader_send_files_async_co (_data_);
}

static void
publishing_rest_support_batch_uploader_send_files_finish (PublishingRESTSupportBatchUploader* self,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	PublishingRestSupportBatchUploaderSendFilesAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_publishing_rest_support_batch_uploader_on_chunk_transmitted_publishing_rest_support_transaction_chunk_transmitted (PublishingRESTSupportTransaction* _sender,
                                                                                                                    guint bytes_written_so_far,
                                                                                                                    guint total_bytes,
                                                                                                                    gpointer self)
{
	publishing_rest_support_batch_uploader_on_chunk_transmitted ((PublishingRESTSupportBatchUploader*) self, bytes_written_so_far, total_bytes);
}

static void
publishing_rest_support_batch_uploader_send_files_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	PublishingRestSupportBatchUploaderSendFilesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_rest_support_batch_uploader_send_files_async_co (_data_);
}

static gboolean
publishing_rest_support_batch_uploader_send_files_async_co (PublishingRestSupportBatchUploaderSendFilesAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->current_file = 0;
	_data_->_tmp0_ = _data_->self->priv->publishables;
	_data_->_tmp0__length1 = _data_->self->priv->publishables_length1;
	{
		_data_->publishable_collection_length1 = 0;
		_data_->_publishable_collection_size_ = 0;
		_data_->publishable_collection = _data_->_tmp0_;
		_data_->publishable_collection_length1 = _data_->_tmp0__length1;
		for (_data_->publishable_it = 0; _data_->publishable_it < _data_->publishable_collection_length1; _data_->publishable_it = _data_->publishable_it + 1) {
			_data_->_tmp1_ = _g_object_ref0 (_data_->publishable_collection[_data_->publishable_it]);
			_data_->publishable = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->publishable;
				_data_->_tmp3_ = spit_publishing_publishable_get_serialized_file (_data_->_tmp2_);
				_data_->file = _data_->_tmp3_;
				_data_->_tmp4_ = _data_->file;
				if (_data_->_tmp4_ == NULL) {
					_data_->_tmp5_ = _data_->self->priv->current_file;
					_data_->self->priv->current_file = _data_->_tmp5_ + 1;
					_g_object_unref0 (_data_->file);
					_g_object_unref0 (_data_->publishable);
					continue;
				}
				_data_->_tmp6_ = _data_->self->priv->publishables;
				_data_->_tmp6__length1 = _data_->self->priv->publishables_length1;
				_data_->fraction_complete = ((gdouble) _data_->self->priv->current_file) / _data_->_tmp6__length1;
				_data_->_tmp7_ = _data_->self->priv->status_updated;
				_data_->_tmp7__target = _data_->self->priv->status_updated_target;
				if (_data_->_tmp7_ != NULL) {
					_data_->_tmp8_ = _data_->self->priv->status_updated;
					_data_->_tmp8__target = _data_->self->priv->status_updated_target;
					_data_->_tmp8_ (_data_->self->priv->current_file + 1, _data_->fraction_complete, _data_->_tmp8__target);
				}
				_data_->_tmp9_ = _data_->self->priv->publishables;
				_data_->_tmp9__length1 = _data_->self->priv->publishables_length1;
				_data_->_tmp10_ = _data_->_tmp9_[_data_->self->priv->current_file];
				_data_->_tmp11_ = publishing_rest_support_batch_uploader_create_transaction (_data_->self, _data_->_tmp10_);
				_data_->txn = _data_->_tmp11_;
				_data_->_tmp12_ = _data_->txn;
				g_signal_connect (_data_->_tmp12_, "chunk-transmitted", (GCallback) _publishing_rest_support_batch_uploader_on_chunk_transmitted_publishing_rest_support_transaction_chunk_transmitted, _data_->self);
				_data_->_tmp13_ = _data_->txn;
				_data_->_state_ = 1;
				publishing_rest_support_transaction_execute_async (_data_->_tmp13_, publishing_rest_support_batch_uploader_send_files_async_ready, _data_);
				return FALSE;
				_state_1:
				publishing_rest_support_transaction_execute_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_publishing_rest_support_transaction_unref0 (_data_->txn);
						_g_object_unref0 (_data_->file);
						_g_object_unref0 (_data_->publishable);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_publishing_rest_support_transaction_unref0 (_data_->txn);
						_g_object_unref0 (_data_->file);
						_g_object_unref0 (_data_->publishable);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_data_->_tmp14_ = _data_->txn;
				g_signal_parse_name ("chunk-transmitted", PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, &_data_->_tmp15_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_data_->_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp15_, 0, NULL, (GCallback) _publishing_rest_support_batch_uploader_on_chunk_transmitted_publishing_rest_support_transaction_chunk_transmitted, _data_->self);
				_data_->_tmp16_ = _data_->self->priv->current_file;
				_data_->self->priv->current_file = _data_->_tmp16_ + 1;
				_publishing_rest_support_transaction_unref0 (_data_->txn);
				_g_object_unref0 (_data_->file);
				_g_object_unref0 (_data_->publishable);
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_rest_support_batch_uploader_on_chunk_transmitted (PublishingRESTSupportBatchUploader* self,
                                                             guint bytes_written_so_far,
                                                             guint total_bytes)
{
	gdouble file_span = 0.0;
	SpitPublishingPublishable** _tmp0_;
	gint _tmp0__length1;
	gdouble this_file_fraction_complete = 0.0;
	gdouble fraction_complete = 0.0;
	SpitPublishingProgressCallback _tmp1_;
	gpointer _tmp1__target;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_BATCH_UPLOADER (self));
	_tmp0_ = self->priv->publishables;
	_tmp0__length1 = self->priv->publishables_length1;
	file_span = 1.0 / _tmp0__length1;
	this_file_fraction_complete = ((gdouble) bytes_written_so_far) / total_bytes;
	fraction_complete = (self->priv->current_file * file_span) + (this_file_fraction_complete * file_span);
	_tmp1_ = self->priv->status_updated;
	_tmp1__target = self->priv->status_updated_target;
	if (_tmp1_ != NULL) {
		SpitPublishingProgressCallback _tmp2_;
		gpointer _tmp2__target;
		_tmp2_ = self->priv->status_updated;
		_tmp2__target = self->priv->status_updated_target;
		_tmp2_ (self->priv->current_file + 1, fraction_complete, _tmp2__target);
	}
}

PublishingRESTSupportSession*
publishing_rest_support_batch_uploader_get_session (PublishingRESTSupportBatchUploader* self)
{
	PublishingRESTSupportSession* _tmp0_;
	PublishingRESTSupportSession* _tmp1_;
	PublishingRESTSupportSession* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_BATCH_UPLOADER (self), NULL);
	_tmp0_ = self->priv->session;
	_tmp1_ = _publishing_rest_support_session_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

SpitPublishingPublishable*
publishing_rest_support_batch_uploader_get_current_publishable (PublishingRESTSupportBatchUploader* self)
{
	SpitPublishingPublishable** _tmp0_;
	gint _tmp0__length1;
	SpitPublishingPublishable* _tmp1_;
	SpitPublishingPublishable* _tmp2_;
	SpitPublishingPublishable* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_BATCH_UPLOADER (self), NULL);
	_tmp0_ = self->priv->publishables;
	_tmp0__length1 = self->priv->publishables_length1;
	_tmp1_ = _tmp0_[self->priv->current_file];
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static PublishingRESTSupportTransaction*
publishing_rest_support_batch_uploader_real_create_transaction (PublishingRESTSupportBatchUploader* self,
                                                                SpitPublishingPublishable* publishable)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_batch_uploader_create_transaction'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PublishingRESTSupportTransaction*
publishing_rest_support_batch_uploader_create_transaction (PublishingRESTSupportBatchUploader* self,
                                                           SpitPublishingPublishable* publishable)
{
	PublishingRESTSupportBatchUploaderClass* _klass_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_BATCH_UPLOADER (self), NULL);
	_klass_ = PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_GET_CLASS (self);
	if (_klass_->create_transaction) {
		return _klass_->create_transaction (self, publishable);
	}
	return NULL;
}

static void
publishing_rest_support_batch_uploader_upload_async_data_free (gpointer _data)
{
	PublishingRestSupportBatchUploaderUploadAsyncData* _data_;
	_data_ = _data;
	_publishing_rest_support_batch_uploader_unref0 (_data_->self);
	g_slice_free (PublishingRestSupportBatchUploaderUploadAsyncData, _data_);
}

void
publishing_rest_support_batch_uploader_upload_async (PublishingRESTSupportBatchUploader* self,
                                                     SpitPublishingProgressCallback status_updated,
                                                     gpointer status_updated_target,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	PublishingRestSupportBatchUploaderUploadAsyncData* _data_;
	PublishingRESTSupportBatchUploader* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_BATCH_UPLOADER (self));
	_data_ = g_slice_new0 (PublishingRestSupportBatchUploaderUploadAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_rest_support_batch_uploader_upload_async_data_free);
	_tmp0_ = _publishing_rest_support_batch_uploader_ref0 (self);
	_data_->self = _tmp0_;
	_data_->status_updated = status_updated;
	_data_->status_updated_target = status_updated_target;
	publishing_rest_support_batch_uploader_upload_async_co (_data_);
}

gint
publishing_rest_support_batch_uploader_upload_finish (PublishingRESTSupportBatchUploader* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	gint result;
	PublishingRestSupportBatchUploaderUploadAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gint _tmp0_ = 0;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
publishing_rest_support_batch_uploader_upload_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	PublishingRestSupportBatchUploaderUploadAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_rest_support_batch_uploader_upload_async_co (_data_);
}

static gboolean
publishing_rest_support_batch_uploader_upload_async_co (PublishingRestSupportBatchUploaderUploadAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->status_updated = _data_->status_updated;
	_data_->self->priv->status_updated_target = _data_->status_updated_target;
	_data_->_tmp0_ = _data_->self->priv->publishables;
	_data_->_tmp0__length1 = _data_->self->priv->publishables_length1;
	if (_data_->_tmp0__length1 > 0) {
		_data_->_state_ = 1;
		publishing_rest_support_batch_uploader_send_files_async (_data_->self, publishing_rest_support_batch_uploader_upload_async_ready, _data_);
		return FALSE;
		_state_1:
		publishing_rest_support_batch_uploader_send_files_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = _data_->self->priv->current_file;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_rest_support_value_batch_uploader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
publishing_rest_support_value_batch_uploader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		publishing_rest_support_batch_uploader_unref (value->data[0].v_pointer);
	}
}

static void
publishing_rest_support_value_batch_uploader_copy_value (const GValue* src_value,
                                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = publishing_rest_support_batch_uploader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
publishing_rest_support_value_batch_uploader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
publishing_rest_support_value_batch_uploader_collect_value (GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PublishingRESTSupportBatchUploader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = publishing_rest_support_batch_uploader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
publishing_rest_support_value_batch_uploader_lcopy_value (const GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	PublishingRESTSupportBatchUploader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = publishing_rest_support_batch_uploader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
publishing_rest_support_param_spec_batch_uploader (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags)
{
	PublishingRESTSupportParamSpecBatchUploader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
publishing_rest_support_value_get_batch_uploader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER), NULL);
	return value->data[0].v_pointer;
}

void
publishing_rest_support_value_set_batch_uploader (GValue* value,
                                                  gpointer v_object)
{
	PublishingRESTSupportBatchUploader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		publishing_rest_support_batch_uploader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_batch_uploader_unref (old);
	}
}

void
publishing_rest_support_value_take_batch_uploader (GValue* value,
                                                   gpointer v_object)
{
	PublishingRESTSupportBatchUploader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		publishing_rest_support_batch_uploader_unref (old);
	}
}

static void
publishing_rest_support_batch_uploader_class_init (PublishingRESTSupportBatchUploaderClass * klass,
                                                   gpointer klass_data)
{
	publishing_rest_support_batch_uploader_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportBatchUploaderClass *) klass)->finalize = publishing_rest_support_batch_uploader_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingRESTSupportBatchUploader_private_offset);
	((PublishingRESTSupportBatchUploaderClass *) klass)->create_transaction = (PublishingRESTSupportTransaction* (*) (PublishingRESTSupportBatchUploader*, SpitPublishingPublishable*)) publishing_rest_support_batch_uploader_real_create_transaction;
	publishing_rest_support_batch_uploader_signals[PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_UPLOAD_COMPLETE_SIGNAL] = g_signal_new ("upload-complete", PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	publishing_rest_support_batch_uploader_signals[PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_UPLOAD_ERROR_SIGNAL] = g_signal_new ("upload-error", PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_ERROR);
}

static void
publishing_rest_support_batch_uploader_instance_init (PublishingRESTSupportBatchUploader * self,
                                                      gpointer klass)
{
	self->priv = publishing_rest_support_batch_uploader_get_instance_private (self);
	self->priv->current_file = 0;
	self->priv->publishables = NULL;
	self->priv->publishables_length1 = 0;
	self->priv->_publishables_size_ = self->priv->publishables_length1;
	self->priv->session = NULL;
	self->priv->status_updated = NULL;
	self->priv->status_updated_target = NULL;
	self->ref_count = 1;
}

static void
publishing_rest_support_batch_uploader_finalize (PublishingRESTSupportBatchUploader * obj)
{
	PublishingRESTSupportBatchUploader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_TYPE_BATCH_UPLOADER, PublishingRESTSupportBatchUploader);
	g_signal_handlers_destroy (self);
	self->priv->publishables = (_vala_array_free (self->priv->publishables, self->priv->publishables_length1, (GDestroyNotify) g_object_unref), NULL);
	_publishing_rest_support_session_unref0 (self->priv->session);
}

static GType
publishing_rest_support_batch_uploader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { publishing_rest_support_value_batch_uploader_init, publishing_rest_support_value_batch_uploader_free_value, publishing_rest_support_value_batch_uploader_copy_value, publishing_rest_support_value_batch_uploader_peek_pointer, "p", publishing_rest_support_value_batch_uploader_collect_value, "p", publishing_rest_support_value_batch_uploader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportBatchUploaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_batch_uploader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportBatchUploader), 0, (GInstanceInitFunc) publishing_rest_support_batch_uploader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType publishing_rest_support_batch_uploader_type_id;
	publishing_rest_support_batch_uploader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PublishingRESTSupportBatchUploader", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	PublishingRESTSupportBatchUploader_private_offset = g_type_add_instance_private (publishing_rest_support_batch_uploader_type_id, sizeof (PublishingRESTSupportBatchUploaderPrivate));
	return publishing_rest_support_batch_uploader_type_id;
}

GType
publishing_rest_support_batch_uploader_get_type (void)
{
	static volatile gsize publishing_rest_support_batch_uploader_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_batch_uploader_type_id__once)) {
		GType publishing_rest_support_batch_uploader_type_id;
		publishing_rest_support_batch_uploader_type_id = publishing_rest_support_batch_uploader_get_type_once ();
		g_once_init_leave (&publishing_rest_support_batch_uploader_type_id__once, publishing_rest_support_batch_uploader_type_id);
	}
	return publishing_rest_support_batch_uploader_type_id__once;
}

gpointer
publishing_rest_support_batch_uploader_ref (gpointer instance)
{
	PublishingRESTSupportBatchUploader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
publishing_rest_support_batch_uploader_unref (gpointer instance)
{
	PublishingRESTSupportBatchUploader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PUBLISHING_REST_SUPPORT_BATCH_UPLOADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gchar*
publishing_rest_support_asciify_string (const gchar* s)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	GString* b = NULL;
	GString* _tmp1_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_utf8_normalize (s, (gssize) -1, G_NORMALIZE_DEFAULT);
	t = _tmp0_;
	_tmp1_ = g_string_new ("");
	b = _tmp1_;
	{
		const gchar* u = NULL;
		const gchar* _tmp2_;
		_tmp2_ = t;
		u = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_;
				gunichar c = 0U;
				const gchar* _tmp7_;
				if (!_tmp3_) {
					const gchar* _tmp4_;
					const gchar* _tmp5_;
					_tmp4_ = u;
					_tmp5_ = g_utf8_next_char (_tmp4_);
					u = _tmp5_;
				}
				_tmp3_ = FALSE;
				_tmp6_ = u;
				if (!(string_get_char (_tmp6_, (glong) 0) != ((gunichar) 0))) {
					break;
				}
				_tmp7_ = u;
				c = string_get_char (_tmp7_, (glong) 0);
				if (((gint) c) < 128) {
					GString* _tmp8_;
					_tmp8_ = b;
					g_string_append_unichar (_tmp8_, c);
				}
			}
		}
	}
	_tmp9_ = b;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (b);
	_g_free0 (t);
	return result;
}

static gchar*
publishing_rest_support_google_session_real_get_user_name (PublishingRESTSupportGoogleSession* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_session_get_user_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
publishing_rest_support_google_session_get_user_name (PublishingRESTSupportGoogleSession* self)
{
	PublishingRESTSupportGoogleSessionClass* _klass_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_SESSION (self), NULL);
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_SESSION_GET_CLASS (self);
	if (_klass_->get_user_name) {
		return _klass_->get_user_name (self);
	}
	return NULL;
}

static gchar*
publishing_rest_support_google_session_real_get_access_token (PublishingRESTSupportGoogleSession* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_session_get_access_token'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
publishing_rest_support_google_session_get_access_token (PublishingRESTSupportGoogleSession* self)
{
	PublishingRESTSupportGoogleSessionClass* _klass_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_SESSION (self), NULL);
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_SESSION_GET_CLASS (self);
	if (_klass_->get_access_token) {
		return _klass_->get_access_token (self);
	}
	return NULL;
}

static void
publishing_rest_support_google_session_real_deauthenticate (PublishingRESTSupportGoogleSession* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_session_deauthenticate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_rest_support_google_session_deauthenticate (PublishingRESTSupportGoogleSession* self)
{
	PublishingRESTSupportGoogleSessionClass* _klass_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_SESSION (self));
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_SESSION_GET_CLASS (self);
	if (_klass_->deauthenticate) {
		_klass_->deauthenticate (self);
	}
}

PublishingRESTSupportGoogleSession*
publishing_rest_support_google_session_construct (GType object_type)
{
	PublishingRESTSupportGoogleSession* self = NULL;
	self = (PublishingRESTSupportGoogleSession*) publishing_rest_support_session_construct (object_type, NULL);
	return self;
}

static void
publishing_rest_support_google_session_class_init (PublishingRESTSupportGoogleSessionClass * klass,
                                                   gpointer klass_data)
{
	publishing_rest_support_google_session_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportGoogleSessionClass *) klass)->get_user_name = (gchar* (*) (PublishingRESTSupportGoogleSession*)) publishing_rest_support_google_session_real_get_user_name;
	((PublishingRESTSupportGoogleSessionClass *) klass)->get_access_token = (gchar* (*) (PublishingRESTSupportGoogleSession*)) publishing_rest_support_google_session_real_get_access_token;
	((PublishingRESTSupportGoogleSessionClass *) klass)->deauthenticate = (void (*) (PublishingRESTSupportGoogleSession*)) publishing_rest_support_google_session_real_deauthenticate;
}

static void
publishing_rest_support_google_session_instance_init (PublishingRESTSupportGoogleSession * self,
                                                      gpointer klass)
{
}

static GType
publishing_rest_support_google_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportGoogleSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_google_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportGoogleSession), 0, (GInstanceInitFunc) publishing_rest_support_google_session_instance_init, NULL };
	GType publishing_rest_support_google_session_type_id;
	publishing_rest_support_google_session_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_SESSION, "PublishingRESTSupportGoogleSession", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return publishing_rest_support_google_session_type_id;
}

GType
publishing_rest_support_google_session_get_type (void)
{
	static volatile gsize publishing_rest_support_google_session_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_google_session_type_id__once)) {
		GType publishing_rest_support_google_session_type_id;
		publishing_rest_support_google_session_type_id = publishing_rest_support_google_session_get_type_once ();
		g_once_init_leave (&publishing_rest_support_google_session_type_id__once, publishing_rest_support_google_session_type_id);
	}
	return publishing_rest_support_google_session_type_id__once;
}

static inline gpointer
publishing_rest_support_google_publisher_get_instance_private (PublishingRESTSupportGooglePublisher* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingRESTSupportGooglePublisher_private_offset);
}

static void
_publishing_rest_support_google_publisher_on_authenticator_authenticated_spit_publishing_authenticator_authenticated (SpitPublishingAuthenticator* _sender,
                                                                                                                      gpointer self)
{
	publishing_rest_support_google_publisher_on_authenticator_authenticated ((PublishingRESTSupportGooglePublisher*) self);
}

PublishingRESTSupportGooglePublisher*
publishing_rest_support_google_publisher_construct (GType object_type,
                                                    SpitPublishingService* service,
                                                    SpitPublishingPluginHost* host,
                                                    const gchar* scope)
{
	PublishingRESTSupportGooglePublisher * self = NULL;
	gchar* _tmp0_;
	PublishingRESTSupportGooglePublisherGoogleSessionImpl* _tmp1_;
	SpitPublishingAuthenticator* _tmp2_;
	SpitPublishingAuthenticator* _tmp3_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, SPIT_PUBLISHING_TYPE_SERVICE), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (host, SPIT_PUBLISHING_TYPE_PLUGIN_HOST), NULL);
	g_return_val_if_fail (scope != NULL, NULL);
	self = (PublishingRESTSupportGooglePublisher*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (scope);
	_g_free0 (self->priv->scope);
	self->priv->scope = _tmp0_;
	_tmp1_ = publishing_rest_support_google_publisher_google_session_impl_new ();
	_publishing_rest_support_session_unref0 (self->priv->session);
	self->priv->session = _tmp1_;
	self->priv->service = service;
	self->priv->host = host;
	_tmp2_ = publishing_rest_support_google_publisher_get_authenticator (self);
	_g_object_unref0 (self->priv->authenticator);
	self->priv->authenticator = _tmp2_;
	_tmp3_ = self->priv->authenticator;
	g_signal_connect_object (_tmp3_, "authenticated", (GCallback) _publishing_rest_support_google_publisher_on_authenticator_authenticated_spit_publishing_authenticator_authenticated, self, 0);
	return self;
}

static SpitPublishingAuthenticator*
publishing_rest_support_google_publisher_real_get_authenticator (PublishingRESTSupportGooglePublisher* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_publisher_get_authenticator'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

SpitPublishingAuthenticator*
publishing_rest_support_google_publisher_get_authenticator (PublishingRESTSupportGooglePublisher* self)
{
	PublishingRESTSupportGooglePublisherClass* _klass_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self), NULL);
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GET_CLASS (self);
	if (_klass_->get_authenticator) {
		return _klass_->get_authenticator (self);
	}
	return NULL;
}

SpitPublishingPluginHost*
publishing_rest_support_google_publisher_get_host (PublishingRESTSupportGooglePublisher* self)
{
	SpitPublishingPluginHost* _tmp0_;
	SpitPublishingPluginHost* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self), NULL);
	_tmp0_ = self->priv->host;
	result = _tmp0_;
	return result;
}

PublishingRESTSupportGoogleSession*
publishing_rest_support_google_publisher_get_session (PublishingRESTSupportGooglePublisher* self)
{
	PublishingRESTSupportGooglePublisherGoogleSessionImpl* _tmp0_;
	PublishingRESTSupportGoogleSession* _tmp1_;
	PublishingRESTSupportGoogleSession* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self), NULL);
	_tmp0_ = self->priv->session;
	_tmp1_ = _publishing_rest_support_session_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PUBLISHING_REST_SUPPORT_TYPE_GOOGLE_SESSION, PublishingRESTSupportGoogleSession));
	result = _tmp1_;
	return result;
}

static void
publishing_rest_support_google_publisher_real_on_login_flow_complete (PublishingRESTSupportGooglePublisher* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_publisher_on_login_flow_complete'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_rest_support_google_publisher_on_login_flow_complete (PublishingRESTSupportGooglePublisher* self)
{
	PublishingRESTSupportGooglePublisherClass* _klass_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self));
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GET_CLASS (self);
	if (_klass_->on_login_flow_complete) {
		_klass_->on_login_flow_complete (self);
	}
}

static void
publishing_rest_support_google_publisher_real_do_logout (PublishingRESTSupportGooglePublisher* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_publisher_do_logout'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_rest_support_google_publisher_do_logout (PublishingRESTSupportGooglePublisher* self)
{
	PublishingRESTSupportGooglePublisherClass* _klass_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self));
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GET_CLASS (self);
	if (_klass_->do_logout) {
		_klass_->do_logout (self);
	}
}

static gboolean
publishing_rest_support_google_publisher_real_is_running (PublishingRESTSupportGooglePublisher* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_publisher_is_running'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
publishing_rest_support_google_publisher_is_running (PublishingRESTSupportGooglePublisher* self)
{
	PublishingRESTSupportGooglePublisherClass* _klass_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self), FALSE);
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GET_CLASS (self);
	if (_klass_->is_running) {
		return _klass_->is_running (self);
	}
	return FALSE;
}

static void
publishing_rest_support_google_publisher_real_start (PublishingRESTSupportGooglePublisher* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_publisher_start'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_rest_support_google_publisher_start (PublishingRESTSupportGooglePublisher* self)
{
	PublishingRESTSupportGooglePublisherClass* _klass_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self));
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GET_CLASS (self);
	if (_klass_->start) {
		_klass_->start (self);
	}
}

static void
publishing_rest_support_google_publisher_real_stop (PublishingRESTSupportGooglePublisher* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_rest_support_google_publisher_stop'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_rest_support_google_publisher_stop (PublishingRESTSupportGooglePublisher* self)
{
	PublishingRESTSupportGooglePublisherClass* _klass_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self));
	_klass_ = PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_GET_CLASS (self);
	if (_klass_->stop) {
		_klass_->stop (self);
	}
}

static SpitPublishingService*
publishing_rest_support_google_publisher_real_get_service (SpitPublishingPublisher* base)
{
	PublishingRESTSupportGooglePublisher * self;
	SpitPublishingService* _tmp0_;
	SpitPublishingService* _tmp1_;
	SpitPublishingService* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_TYPE_GOOGLE_PUBLISHER, PublishingRESTSupportGooglePublisher);
	_tmp0_ = self->priv->service;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
publishing_rest_support_google_publisher_on_authenticator_authenticated (PublishingRESTSupportGooglePublisher* self)
{
	GHashTable* params = NULL;
	SpitPublishingAuthenticator* _tmp0_;
	GHashTable* _tmp1_;
	GVariant* refresh_token = NULL;
	GVariant* access_token = NULL;
	GVariant* user_name = NULL;
	gconstpointer _tmp2_ = NULL;
	GVariant* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	GVariant* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	GVariant* _tmp7_;
	PublishingRESTSupportGooglePublisherGoogleSessionImpl* _tmp8_;
	GVariant* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	PublishingRESTSupportGooglePublisherGoogleSessionImpl* _tmp12_;
	GVariant* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	PublishingRESTSupportGooglePublisherGoogleSessionImpl* _tmp16_;
	GVariant* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_PUBLISHER (self));
	_tmp0_ = self->priv->authenticator;
	_tmp1_ = spit_publishing_authenticator_get_authentication_parameter (_tmp0_);
	params = _tmp1_;
	refresh_token = NULL;
	access_token = NULL;
	user_name = NULL;
	g_hash_table_lookup_extended (params, "RefreshToken", NULL, &_tmp2_);
	_g_variant_unref0 (refresh_token);
	_tmp3_ = _g_variant_ref0 ((GVariant*) _tmp2_);
	refresh_token = _tmp3_;
	g_hash_table_lookup_extended (params, "AccessToken", NULL, &_tmp4_);
	_g_variant_unref0 (access_token);
	_tmp5_ = _g_variant_ref0 ((GVariant*) _tmp4_);
	access_token = _tmp5_;
	g_hash_table_lookup_extended (params, "UserName", NULL, &_tmp6_);
	_g_variant_unref0 (user_name);
	_tmp7_ = _g_variant_ref0 ((GVariant*) _tmp6_);
	user_name = _tmp7_;
	_tmp8_ = self->priv->session;
	_tmp9_ = refresh_token;
	_tmp10_ = g_variant_get_string (_tmp9_, NULL);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_tmp8_->refresh_token);
	_tmp8_->refresh_token = _tmp11_;
	_tmp12_ = self->priv->session;
	_tmp13_ = access_token;
	_tmp14_ = g_variant_get_string (_tmp13_, NULL);
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (_tmp12_->access_token);
	_tmp12_->access_token = _tmp15_;
	_tmp16_ = self->priv->session;
	_tmp17_ = user_name;
	_tmp18_ = g_variant_get_string (_tmp17_, NULL);
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (_tmp16_->user_name);
	_tmp16_->user_name = _tmp19_;
	publishing_rest_support_google_publisher_on_login_flow_complete (self);
	_g_variant_unref0 (user_name);
	_g_variant_unref0 (access_token);
	_g_variant_unref0 (refresh_token);
	_g_hash_table_unref0 (params);
}

static PublishingRESTSupportGooglePublisherGoogleSessionImpl*
publishing_rest_support_google_publisher_google_session_impl_construct (GType object_type)
{
	PublishingRESTSupportGooglePublisherGoogleSessionImpl* self = NULL;
	self = (PublishingRESTSupportGooglePublisherGoogleSessionImpl*) publishing_rest_support_google_session_construct (object_type);
	_g_free0 (self->access_token);
	self->access_token = NULL;
	_g_free0 (self->user_name);
	self->user_name = NULL;
	_g_free0 (self->refresh_token);
	self->refresh_token = NULL;
	return self;
}

static PublishingRESTSupportGooglePublisherGoogleSessionImpl*
publishing_rest_support_google_publisher_google_session_impl_new (void)
{
	return publishing_rest_support_google_publisher_google_session_impl_construct (PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL);
}

static gboolean
publishing_rest_support_google_publisher_google_session_impl_real_is_authenticated (PublishingRESTSupportSession* base)
{
	PublishingRESTSupportGooglePublisherGoogleSessionImpl * self;
	const gchar* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImpl);
	_tmp0_ = self->access_token;
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
publishing_rest_support_google_publisher_google_session_impl_real_get_user_name (PublishingRESTSupportGoogleSession* base)
{
	PublishingRESTSupportGooglePublisherGoogleSessionImpl * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImpl);
	_tmp0_ = self->user_name;
	_vala_assert (_tmp0_ != NULL, "user_name != null");
	_tmp1_ = self->user_name;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
publishing_rest_support_google_publisher_google_session_impl_real_get_access_token (PublishingRESTSupportGoogleSession* base)
{
	PublishingRESTSupportGooglePublisherGoogleSessionImpl * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImpl);
	_vala_assert (publishing_rest_support_session_is_authenticated (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession)), "is_authenticated()");
	_tmp0_ = self->access_token;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
publishing_rest_support_google_publisher_google_session_impl_real_deauthenticate (PublishingRESTSupportGoogleSession* base)
{
	PublishingRESTSupportGooglePublisherGoogleSessionImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImpl);
	_g_free0 (self->access_token);
	self->access_token = NULL;
	_g_free0 (self->user_name);
	self->user_name = NULL;
	_g_free0 (self->refresh_token);
	self->refresh_token = NULL;
}

static void
publishing_rest_support_google_publisher_google_session_impl_class_init (PublishingRESTSupportGooglePublisherGoogleSessionImplClass * klass,
                                                                         gpointer klass_data)
{
	publishing_rest_support_google_publisher_google_session_impl_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportSessionClass *) klass)->finalize = publishing_rest_support_google_publisher_google_session_impl_finalize;
	((PublishingRESTSupportSessionClass *) klass)->is_authenticated = (gboolean (*) (PublishingRESTSupportSession*)) publishing_rest_support_google_publisher_google_session_impl_real_is_authenticated;
	((PublishingRESTSupportGoogleSessionClass *) klass)->get_user_name = (gchar* (*) (PublishingRESTSupportGoogleSession*)) publishing_rest_support_google_publisher_google_session_impl_real_get_user_name;
	((PublishingRESTSupportGoogleSessionClass *) klass)->get_access_token = (gchar* (*) (PublishingRESTSupportGoogleSession*)) publishing_rest_support_google_publisher_google_session_impl_real_get_access_token;
	((PublishingRESTSupportGoogleSessionClass *) klass)->deauthenticate = (void (*) (PublishingRESTSupportGoogleSession*)) publishing_rest_support_google_publisher_google_session_impl_real_deauthenticate;
}

static void
publishing_rest_support_google_publisher_google_session_impl_instance_init (PublishingRESTSupportGooglePublisherGoogleSessionImpl * self,
                                                                            gpointer klass)
{
}

static void
publishing_rest_support_google_publisher_google_session_impl_finalize (PublishingRESTSupportSession * obj)
{
	PublishingRESTSupportGooglePublisherGoogleSessionImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_GOOGLE_SESSION_IMPL, PublishingRESTSupportGooglePublisherGoogleSessionImpl);
	_g_free0 (self->access_token);
	_g_free0 (self->user_name);
	_g_free0 (self->refresh_token);
	PUBLISHING_REST_SUPPORT_SESSION_CLASS (publishing_rest_support_google_publisher_google_session_impl_parent_class)->finalize (obj);
}

static GType
publishing_rest_support_google_publisher_google_session_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportGooglePublisherGoogleSessionImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_google_publisher_google_session_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportGooglePublisherGoogleSessionImpl), 0, (GInstanceInitFunc) publishing_rest_support_google_publisher_google_session_impl_instance_init, NULL };
	GType publishing_rest_support_google_publisher_google_session_impl_type_id;
	publishing_rest_support_google_publisher_google_session_impl_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_GOOGLE_SESSION, "PublishingRESTSupportGooglePublisherGoogleSessionImpl", &g_define_type_info, 0);
	return publishing_rest_support_google_publisher_google_session_impl_type_id;
}

static GType
publishing_rest_support_google_publisher_google_session_impl_get_type (void)
{
	static volatile gsize publishing_rest_support_google_publisher_google_session_impl_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_google_publisher_google_session_impl_type_id__once)) {
		GType publishing_rest_support_google_publisher_google_session_impl_type_id;
		publishing_rest_support_google_publisher_google_session_impl_type_id = publishing_rest_support_google_publisher_google_session_impl_get_type_once ();
		g_once_init_leave (&publishing_rest_support_google_publisher_google_session_impl_type_id__once, publishing_rest_support_google_publisher_google_session_impl_type_id);
	}
	return publishing_rest_support_google_publisher_google_session_impl_type_id__once;
}

static PublishingRESTSupportGooglePublisherAuthenticatedTransaction*
publishing_rest_support_google_publisher_authenticated_transaction_construct_with_endpoint_url (GType object_type,
                                                                                                PublishingRESTSupportGoogleSession* session,
                                                                                                const gchar* endpoint_url,
                                                                                                PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportGooglePublisherAuthenticatedTransaction* self = NULL;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_SESSION (session), NULL);
	g_return_val_if_fail (endpoint_url != NULL, NULL);
	self = (PublishingRESTSupportGooglePublisherAuthenticatedTransaction*) publishing_rest_support_transaction_construct_with_endpoint_url (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), endpoint_url, method);
	return self;
}

static PublishingRESTSupportGooglePublisherAuthenticatedTransaction*
publishing_rest_support_google_publisher_authenticated_transaction_new_with_endpoint_url (PublishingRESTSupportGoogleSession* session,
                                                                                          const gchar* endpoint_url,
                                                                                          PublishingRESTSupportHttpMethod method)
{
	return publishing_rest_support_google_publisher_authenticated_transaction_construct_with_endpoint_url (PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_AUTHENTICATED_TRANSACTION, session, endpoint_url, method);
}

PublishingRESTSupportGooglePublisherAuthenticatedTransaction*
publishing_rest_support_google_publisher_authenticated_transaction_construct (GType object_type,
                                                                              PublishingRESTSupportGoogleSession* session,
                                                                              const gchar* endpoint_url,
                                                                              PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportGooglePublisherAuthenticatedTransaction* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_GOOGLE_SESSION (session), NULL);
	g_return_val_if_fail (endpoint_url != NULL, NULL);
	self = (PublishingRESTSupportGooglePublisherAuthenticatedTransaction*) publishing_rest_support_transaction_construct_with_endpoint_url (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), endpoint_url, method);
	_vala_assert (publishing_rest_support_session_is_authenticated (G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession)), "session.is_authenticated()");
	_tmp0_ = publishing_rest_support_google_session_get_access_token (session);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Bearer ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	publishing_rest_support_transaction_add_header (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "Authorization", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

PublishingRESTSupportGooglePublisherAuthenticatedTransaction*
publishing_rest_support_google_publisher_authenticated_transaction_new (PublishingRESTSupportGoogleSession* session,
                                                                        const gchar* endpoint_url,
                                                                        PublishingRESTSupportHttpMethod method)
{
	return publishing_rest_support_google_publisher_authenticated_transaction_construct (PUBLISHING_REST_SUPPORT_GOOGLE_PUBLISHER_TYPE_AUTHENTICATED_TRANSACTION, session, endpoint_url, method);
}

static void
publishing_rest_support_google_publisher_authenticated_transaction_class_init (PublishingRESTSupportGooglePublisherAuthenticatedTransactionClass * klass,
                                                                               gpointer klass_data)
{
	publishing_rest_support_google_publisher_authenticated_transaction_parent_class = g_type_class_peek_parent (klass);
}

static void
publishing_rest_support_google_publisher_authenticated_transaction_instance_init (PublishingRESTSupportGooglePublisherAuthenticatedTransaction * self,
                                                                                  gpointer klass)
{
}

static GType
publishing_rest_support_google_publisher_authenticated_transaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportGooglePublisherAuthenticatedTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_google_publisher_authenticated_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportGooglePublisherAuthenticatedTransaction), 0, (GInstanceInitFunc) publishing_rest_support_google_publisher_authenticated_transaction_instance_init, NULL };
	GType publishing_rest_support_google_publisher_authenticated_transaction_type_id;
	publishing_rest_support_google_publisher_authenticated_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, "PublishingRESTSupportGooglePublisherAuthenticatedTransaction", &g_define_type_info, 0);
	return publishing_rest_support_google_publisher_authenticated_transaction_type_id;
}

GType
publishing_rest_support_google_publisher_authenticated_transaction_get_type (void)
{
	static volatile gsize publishing_rest_support_google_publisher_authenticated_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_google_publisher_authenticated_transaction_type_id__once)) {
		GType publishing_rest_support_google_publisher_authenticated_transaction_type_id;
		publishing_rest_support_google_publisher_authenticated_transaction_type_id = publishing_rest_support_google_publisher_authenticated_transaction_get_type_once ();
		g_once_init_leave (&publishing_rest_support_google_publisher_authenticated_transaction_type_id__once, publishing_rest_support_google_publisher_authenticated_transaction_type_id);
	}
	return publishing_rest_support_google_publisher_authenticated_transaction_type_id__once;
}

static void
publishing_rest_support_google_publisher_class_init (PublishingRESTSupportGooglePublisherClass * klass,
                                                     gpointer klass_data)
{
	publishing_rest_support_google_publisher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PublishingRESTSupportGooglePublisher_private_offset);
	((PublishingRESTSupportGooglePublisherClass *) klass)->get_authenticator = (SpitPublishingAuthenticator* (*) (PublishingRESTSupportGooglePublisher*)) publishing_rest_support_google_publisher_real_get_authenticator;
	((PublishingRESTSupportGooglePublisherClass *) klass)->on_login_flow_complete = (void (*) (PublishingRESTSupportGooglePublisher*)) publishing_rest_support_google_publisher_real_on_login_flow_complete;
	((PublishingRESTSupportGooglePublisherClass *) klass)->do_logout = (void (*) (PublishingRESTSupportGooglePublisher*)) publishing_rest_support_google_publisher_real_do_logout;
	((PublishingRESTSupportGooglePublisherClass *) klass)->is_running = (gboolean (*) (PublishingRESTSupportGooglePublisher*)) publishing_rest_support_google_publisher_real_is_running;
	((PublishingRESTSupportGooglePublisherClass *) klass)->start = (void (*) (PublishingRESTSupportGooglePublisher*)) publishing_rest_support_google_publisher_real_start;
	((PublishingRESTSupportGooglePublisherClass *) klass)->stop = (void (*) (PublishingRESTSupportGooglePublisher*)) publishing_rest_support_google_publisher_real_stop;
	G_OBJECT_CLASS (klass)->finalize = publishing_rest_support_google_publisher_finalize;
}

static void
publishing_rest_support_google_publisher_spit_publishing_publisher_interface_init (SpitPublishingPublisherIface * iface,
                                                                                   gpointer iface_data)
{
	publishing_rest_support_google_publisher_spit_publishing_publisher_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_running = (gboolean (*) (SpitPublishingPublisher*)) publishing_rest_support_google_publisher_is_running;
	iface->start = (void (*) (SpitPublishingPublisher*)) publishing_rest_support_google_publisher_start;
	iface->stop = (void (*) (SpitPublishingPublisher*)) publishing_rest_support_google_publisher_stop;
	iface->get_service = (SpitPublishingService* (*) (SpitPublishingPublisher*)) publishing_rest_support_google_publisher_real_get_service;
}

static void
publishing_rest_support_google_publisher_instance_init (PublishingRESTSupportGooglePublisher * self,
                                                        gpointer klass)
{
	self->priv = publishing_rest_support_google_publisher_get_instance_private (self);
}

static void
publishing_rest_support_google_publisher_finalize (GObject * obj)
{
	PublishingRESTSupportGooglePublisher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_TYPE_GOOGLE_PUBLISHER, PublishingRESTSupportGooglePublisher);
	_g_free0 (self->priv->scope);
	_publishing_rest_support_session_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->authenticator);
	G_OBJECT_CLASS (publishing_rest_support_google_publisher_parent_class)->finalize (obj);
}

static GType
publishing_rest_support_google_publisher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportGooglePublisherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_google_publisher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportGooglePublisher), 0, (GInstanceInitFunc) publishing_rest_support_google_publisher_instance_init, NULL };
	static const GInterfaceInfo spit_publishing_publisher_info = { (GInterfaceInitFunc) publishing_rest_support_google_publisher_spit_publishing_publisher_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType publishing_rest_support_google_publisher_type_id;
	publishing_rest_support_google_publisher_type_id = g_type_register_static (G_TYPE_OBJECT, "PublishingRESTSupportGooglePublisher", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (publishing_rest_support_google_publisher_type_id, SPIT_PUBLISHING_TYPE_PUBLISHER, &spit_publishing_publisher_info);
	PublishingRESTSupportGooglePublisher_private_offset = g_type_add_instance_private (publishing_rest_support_google_publisher_type_id, sizeof (PublishingRESTSupportGooglePublisherPrivate));
	return publishing_rest_support_google_publisher_type_id;
}

GType
publishing_rest_support_google_publisher_get_type (void)
{
	static volatile gsize publishing_rest_support_google_publisher_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_google_publisher_type_id__once)) {
		GType publishing_rest_support_google_publisher_type_id;
		publishing_rest_support_google_publisher_type_id = publishing_rest_support_google_publisher_get_type_once ();
		g_once_init_leave (&publishing_rest_support_google_publisher_type_id__once, publishing_rest_support_google_publisher_type_id);
	}
	return publishing_rest_support_google_publisher_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

