/* OAuth1Support.c generated by valac 0.56.17, the Vala compiler
 * generated from OAuth1Support.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-plugin-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "shotwell-plugin-dev-1.0.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _publishing_rest_support_argument_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_argument_unref (var), NULL)))
#define _publishing_rest_support_session_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_session_unref (var), NULL)))
#define _publishing_rest_support_transaction_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_transaction_unref (var), NULL)))
typedef struct _PublishingRestSupportOauth1TransactionExecuteAsyncData PublishingRestSupportOauth1TransactionExecuteAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PublishingRESTSupportOAuth1SessionPrivate {
	gchar* request_phase_token;
	gchar* request_phase_token_secret;
	gchar* access_phase_token;
	gchar* access_phase_token_secret;
	gchar* username;
	gchar* consumer_key;
	gchar* consumer_secret;
};

struct _PublishingRestSupportOauth1TransactionExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingRESTSupportOAuth1Transaction* self;
	gchar* signature;
	PublishingRESTSupportSession* _tmp0_;
	PublishingRESTSupportOAuth1Session* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _PublishingRESTSupportOAuth1UploadTransactionPrivate {
	PublishingRESTSupportArgument** auth_header_fields;
	gint auth_header_fields_length1;
	gint _auth_header_fields_size_;
};

static gint PublishingRESTSupportOAuth1Session_private_offset;
static gpointer publishing_rest_support_oauth1_session_parent_class = NULL;
static gpointer publishing_rest_support_oauth1_transaction_parent_class = NULL;
static gint PublishingRESTSupportOAuth1UploadTransaction_private_offset;
static gpointer publishing_rest_support_oauth1_upload_transaction_parent_class = NULL;

static gboolean publishing_rest_support_oauth1_session_real_is_authenticated (PublishingRESTSupportSession* base);
static void _vala_array_add4 (PublishingRESTSupportArgument** * array,
                       gint* length,
                       gint* size,
                       PublishingRESTSupportArgument* value);
static void publishing_rest_support_oauth1_session_finalize (PublishingRESTSupportSession * obj);
static GType publishing_rest_support_oauth1_session_get_type_once (void);
static void publishing_rest_support_oauth1_transaction_setup_arguments (PublishingRESTSupportOAuth1Transaction* self);
static void publishing_rest_support_oauth1_transaction_real_execute_async_data_free (gpointer _data);
static void publishing_rest_support_oauth1_transaction_real_execute_async (PublishingRESTSupportTransaction* base,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static gboolean publishing_rest_support_oauth1_transaction_real_execute_async_co (PublishingRestSupportOauth1TransactionExecuteAsyncData* _data_);
static void publishing_rest_support_oauth1_transaction_execute_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static GType publishing_rest_support_oauth1_transaction_get_type_once (void);
static void _vala_array_add5 (PublishingRESTSupportArgument** * array,
                       gint* length,
                       gint* size,
                       PublishingRESTSupportArgument* value);
static void publishing_rest_support_oauth1_upload_transaction_finalize (PublishingRESTSupportTransaction * obj);
static GType publishing_rest_support_oauth1_upload_transaction_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
publishing_rest_support_oauth1_session_get_instance_private (PublishingRESTSupportOAuth1Session* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingRESTSupportOAuth1Session_private_offset);
}

PublishingRESTSupportOAuth1Session*
publishing_rest_support_oauth1_session_construct (GType object_type,
                                                  const gchar* endpoint_uri)
{
	PublishingRESTSupportOAuth1Session* self = NULL;
	self = (PublishingRESTSupportOAuth1Session*) publishing_rest_support_session_construct (object_type, endpoint_uri);
	return self;
}

PublishingRESTSupportOAuth1Session*
publishing_rest_support_oauth1_session_new (const gchar* endpoint_uri)
{
	return publishing_rest_support_oauth1_session_construct (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, endpoint_uri);
}

static gboolean
publishing_rest_support_oauth1_session_real_is_authenticated (PublishingRESTSupportSession* base)
{
	PublishingRESTSupportOAuth1Session * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
	_tmp2_ = self->priv->access_phase_token;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->access_phase_token_secret;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->username;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
publishing_rest_support_oauth1_session_authenticate_from_persistent_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                                 const gchar* token,
                                                                                 const gchar* secret,
                                                                                 const gchar* username)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
	g_return_if_fail (token != NULL);
	g_return_if_fail (secret != NULL);
	g_return_if_fail (username != NULL);
	_tmp0_ = g_strdup (token);
	_g_free0 (self->priv->access_phase_token);
	self->priv->access_phase_token = _tmp0_;
	_tmp1_ = g_strdup (secret);
	_g_free0 (self->priv->access_phase_token_secret);
	self->priv->access_phase_token_secret = _tmp1_;
	_tmp2_ = g_strdup (username);
	_g_free0 (self->priv->username);
	self->priv->username = _tmp2_;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), "authenticated");
}

void
publishing_rest_support_oauth1_session_deauthenticate (PublishingRESTSupportOAuth1Session* self)
{
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
	_g_free0 (self->priv->access_phase_token);
	self->priv->access_phase_token = NULL;
	_g_free0 (self->priv->access_phase_token_secret);
	self->priv->access_phase_token_secret = NULL;
	_g_free0 (self->priv->username);
	self->priv->username = NULL;
}

void
publishing_rest_support_oauth1_session_set_api_credentials (PublishingRESTSupportOAuth1Session* self,
                                                            const gchar* consumer_key,
                                                            const gchar* consumer_secret)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
	g_return_if_fail (consumer_key != NULL);
	g_return_if_fail (consumer_secret != NULL);
	_tmp0_ = g_strdup (consumer_key);
	_g_free0 (self->priv->consumer_key);
	self->priv->consumer_key = _tmp0_;
	_tmp1_ = g_strdup (consumer_secret);
	_g_free0 (self->priv->consumer_secret);
	self->priv->consumer_secret = _tmp1_;
}

static gpointer
_publishing_rest_support_argument_ref0 (gpointer self)
{
	return self ? publishing_rest_support_argument_ref (self) : NULL;
}

static void
_vala_array_add4 (PublishingRESTSupportArgument** * array,
                  gint* length,
                  gint* size,
                  PublishingRESTSupportArgument* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PublishingRESTSupportArgument*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
publishing_rest_support_oauth1_session_sign_transaction (PublishingRESTSupportOAuth1Session* self,
                                                         PublishingRESTSupportTransaction* txn,
                                                         PublishingRESTSupportArgument** extra_arguments,
                                                         gint extra_arguments_length1)
{
	gchar* http_method = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PublishingRESTSupportArgument** base_string_arguments = NULL;
	gint _tmp4_ = 0;
	PublishingRESTSupportArgument** _tmp5_;
	gint base_string_arguments_length1;
	gint _base_string_arguments_size_;
	PublishingRESTSupportArgument** sorted_args = NULL;
	PublishingRESTSupportArgument** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_ = 0;
	PublishingRESTSupportArgument** _tmp11_;
	gint sorted_args_length1;
	gint _sorted_args_size_;
	gchar* arguments_string = NULL;
	PublishingRESTSupportArgument** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar* signing_key = NULL;
	const gchar* _tmp14_;
	gchar* signature_base_string = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* signature = NULL;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (txn), NULL);
	_tmp0_ = publishing_rest_support_http_method_to_string (publishing_rest_support_transaction_get_method (txn));
	http_method = _tmp0_;
	g_debug ("OAuth1Support.vala:52: signing transaction with parameters:");
	_tmp1_ = http_method;
	_tmp2_ = g_strconcat ("HTTP method = ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	g_debug ("OAuth1Support.vala:53: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp5_ = publishing_rest_support_transaction_get_arguments (txn, &_tmp4_);
	base_string_arguments = _tmp5_;
	base_string_arguments_length1 = _tmp4_;
	_base_string_arguments_size_ = base_string_arguments_length1;
	{
		PublishingRESTSupportArgument** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = extra_arguments;
		arg_collection_length1 = extra_arguments_length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			PublishingRESTSupportArgument* _tmp6_;
			PublishingRESTSupportArgument* arg = NULL;
			_tmp6_ = _publishing_rest_support_argument_ref0 (arg_collection[arg_it]);
			arg = _tmp6_;
			{
				PublishingRESTSupportArgument* _tmp7_;
				PublishingRESTSupportArgument* _tmp8_;
				_tmp7_ = arg;
				_tmp8_ = _publishing_rest_support_argument_ref0 (_tmp7_);
				_vala_array_add4 (&base_string_arguments, &base_string_arguments_length1, &_base_string_arguments_size_, _tmp8_);
				_publishing_rest_support_argument_unref0 (arg);
			}
		}
	}
	_tmp9_ = base_string_arguments;
	_tmp9__length1 = base_string_arguments_length1;
	_tmp11_ = publishing_rest_support_argument_sort (_tmp9_, (gint) _tmp9__length1, &_tmp10_);
	sorted_args = _tmp11_;
	sorted_args_length1 = _tmp10_;
	_sorted_args_size_ = sorted_args_length1;
	_tmp12_ = sorted_args;
	_tmp12__length1 = sorted_args_length1;
	_tmp13_ = publishing_rest_support_argument_serialize_for_sbs (_tmp12_, (gint) _tmp12__length1);
	arguments_string = _tmp13_;
	signing_key = NULL;
	_tmp14_ = self->priv->access_phase_token_secret;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		g_debug ("OAuth1Support.vala:68: access phase token secret available; using it a" \
"s signing key");
		_tmp15_ = self->priv->consumer_secret;
		_tmp16_ = g_strconcat (_tmp15_, "&", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->access_phase_token_secret;
		_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
		_g_free0 (signing_key);
		signing_key = _tmp19_;
		_g_free0 (_tmp17_);
	} else {
		const gchar* _tmp20_;
		_tmp20_ = self->priv->request_phase_token_secret;
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			g_debug ("OAuth1Support.vala:72: request phase token secret available; using it " \
"as signing key");
			_tmp21_ = self->priv->consumer_secret;
			_tmp22_ = g_strconcat (_tmp21_, "&", NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->request_phase_token_secret;
			_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
			_g_free0 (signing_key);
			signing_key = _tmp25_;
			_g_free0 (_tmp23_);
		} else {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			g_debug ("OAuth1Support.vala:76: %s", "neither access phase nor request phase token secrets available; using " \
"API " "key as signing key");
			_tmp26_ = self->priv->consumer_secret;
			_tmp27_ = g_strconcat (_tmp26_, "&", NULL);
			_g_free0 (signing_key);
			signing_key = _tmp27_;
		}
	}
	_tmp28_ = http_method;
	_tmp29_ = g_strconcat (_tmp28_, "&", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = publishing_rest_support_transaction_get_endpoint_url (txn);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_uri_escape_string (_tmp32_, NULL, TRUE);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp30_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp36_, "&", NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = arguments_string;
	_tmp40_ = g_uri_escape_string (_tmp39_, NULL, TRUE);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp38_, _tmp41_, NULL);
	_tmp43_ = _tmp42_;
	_g_free0 (_tmp41_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	signature_base_string = _tmp43_;
	g_debug ("OAuth1Support.vala:86: signature base string = '%s'", signature_base_string);
	_tmp44_ = signing_key;
	g_debug ("OAuth1Support.vala:88: signing key = '%s'", _tmp44_);
	_tmp45_ = signing_key;
	_tmp46_ = publishing_rest_support_hmac_sha1 (_tmp45_, signature_base_string);
	signature = _tmp46_;
	_tmp47_ = signature;
	_tmp48_ = g_uri_escape_string (_tmp47_, NULL, TRUE);
	_g_free0 (signature);
	signature = _tmp48_;
	_tmp49_ = signature;
	g_debug ("OAuth1Support.vala:94: signature = '%s'", _tmp49_);
	result = signature;
	_g_free0 (signature_base_string);
	_g_free0 (signing_key);
	_g_free0 (arguments_string);
	sorted_args = (_vala_array_free (sorted_args, sorted_args_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
	base_string_arguments = (_vala_array_free (base_string_arguments, base_string_arguments_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
	_g_free0 (http_method);
	return result;
}

void
publishing_rest_support_oauth1_session_set_request_phase_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                      const gchar* token,
                                                                      const gchar* secret)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
	g_return_if_fail (token != NULL);
	g_return_if_fail (secret != NULL);
	_tmp0_ = g_strdup (token);
	_g_free0 (self->priv->request_phase_token);
	self->priv->request_phase_token = _tmp0_;
	_tmp1_ = g_strdup (secret);
	_g_free0 (self->priv->request_phase_token_secret);
	self->priv->request_phase_token_secret = _tmp1_;
}

void
publishing_rest_support_oauth1_session_set_access_phase_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                     const gchar* token,
                                                                     const gchar* secret,
                                                                     const gchar* username)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
	g_return_if_fail (token != NULL);
	g_return_if_fail (secret != NULL);
	g_return_if_fail (username != NULL);
	_tmp0_ = g_strdup (token);
	_g_free0 (self->priv->access_phase_token);
	self->priv->access_phase_token = _tmp0_;
	_tmp1_ = g_strdup (secret);
	_g_free0 (self->priv->access_phase_token_secret);
	self->priv->access_phase_token_secret = _tmp1_;
	_tmp2_ = g_strdup (username);
	_g_free0 (self->priv->username);
	self->priv->username = _tmp2_;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), "authenticated");
}

gchar*
publishing_rest_support_oauth1_session_get_oauth_nonce (PublishingRESTSupportOAuth1Session* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_get_real_time ());
	_tmp1_ = _tmp0_;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_, (gsize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
publishing_rest_support_oauth1_session_get_oauth_timestamp (PublishingRESTSupportOAuth1Session* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_get_real_time ());
	_tmp1_ = _tmp0_;
	_tmp2_ = string_substring (_tmp1_, (glong) 0, (glong) 10);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
publishing_rest_support_oauth1_session_get_consumer_key (PublishingRESTSupportOAuth1Session* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	_tmp0_ = self->priv->consumer_key;
	_vala_assert (_tmp0_ != NULL, "consumer_key != null");
	_tmp1_ = self->priv->consumer_key;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
publishing_rest_support_oauth1_session_get_request_phase_token (PublishingRESTSupportOAuth1Session* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	_tmp0_ = self->priv->request_phase_token;
	_vala_assert (_tmp0_ != NULL, "request_phase_token != null");
	_tmp1_ = self->priv->request_phase_token;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
publishing_rest_support_oauth1_session_get_access_phase_token (PublishingRESTSupportOAuth1Session* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	_tmp0_ = self->priv->access_phase_token;
	_vala_assert (_tmp0_ != NULL, "access_phase_token != null");
	_tmp1_ = self->priv->access_phase_token;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
publishing_rest_support_oauth1_session_has_access_phase_token (PublishingRESTSupportOAuth1Session* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), FALSE);
	_tmp0_ = self->priv->access_phase_token;
	result = _tmp0_ != NULL;
	return result;
}

gchar*
publishing_rest_support_oauth1_session_get_access_phase_token_secret (PublishingRESTSupportOAuth1Session* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	_tmp0_ = self->priv->access_phase_token_secret;
	_vala_assert (_tmp0_ != NULL, "access_phase_token_secret != null");
	_tmp1_ = self->priv->access_phase_token_secret;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
publishing_rest_support_oauth1_session_get_username (PublishingRESTSupportOAuth1Session* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
	_vala_assert (publishing_rest_support_session_is_authenticated (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession)), "is_authenticated()");
	_tmp0_ = self->priv->username;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
publishing_rest_support_oauth1_session_class_init (PublishingRESTSupportOAuth1SessionClass * klass,
                                                   gpointer klass_data)
{
	publishing_rest_support_oauth1_session_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportSessionClass *) klass)->finalize = publishing_rest_support_oauth1_session_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingRESTSupportOAuth1Session_private_offset);
	((PublishingRESTSupportSessionClass *) klass)->is_authenticated = (gboolean (*) (PublishingRESTSupportSession*)) publishing_rest_support_oauth1_session_real_is_authenticated;
}

static void
publishing_rest_support_oauth1_session_instance_init (PublishingRESTSupportOAuth1Session * self,
                                                      gpointer klass)
{
	self->priv = publishing_rest_support_oauth1_session_get_instance_private (self);
	self->priv->request_phase_token = NULL;
	self->priv->request_phase_token_secret = NULL;
	self->priv->access_phase_token = NULL;
	self->priv->access_phase_token_secret = NULL;
	self->priv->username = NULL;
	self->priv->consumer_key = NULL;
	self->priv->consumer_secret = NULL;
}

static void
publishing_rest_support_oauth1_session_finalize (PublishingRESTSupportSession * obj)
{
	PublishingRESTSupportOAuth1Session * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
	_g_free0 (self->priv->request_phase_token);
	_g_free0 (self->priv->request_phase_token_secret);
	_g_free0 (self->priv->access_phase_token);
	_g_free0 (self->priv->access_phase_token_secret);
	_g_free0 (self->priv->username);
	_g_free0 (self->priv->consumer_key);
	_g_free0 (self->priv->consumer_secret);
	PUBLISHING_REST_SUPPORT_SESSION_CLASS (publishing_rest_support_oauth1_session_parent_class)->finalize (obj);
}

static GType
publishing_rest_support_oauth1_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportOAuth1SessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_oauth1_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportOAuth1Session), 0, (GInstanceInitFunc) publishing_rest_support_oauth1_session_instance_init, NULL };
	GType publishing_rest_support_oauth1_session_type_id;
	publishing_rest_support_oauth1_session_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_SESSION, "PublishingRESTSupportOAuth1Session", &g_define_type_info, 0);
	PublishingRESTSupportOAuth1Session_private_offset = g_type_add_instance_private (publishing_rest_support_oauth1_session_type_id, sizeof (PublishingRESTSupportOAuth1SessionPrivate));
	return publishing_rest_support_oauth1_session_type_id;
}

GType
publishing_rest_support_oauth1_session_get_type (void)
{
	static volatile gsize publishing_rest_support_oauth1_session_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_oauth1_session_type_id__once)) {
		GType publishing_rest_support_oauth1_session_type_id;
		publishing_rest_support_oauth1_session_type_id = publishing_rest_support_oauth1_session_get_type_once ();
		g_once_init_leave (&publishing_rest_support_oauth1_session_type_id__once, publishing_rest_support_oauth1_session_type_id);
	}
	return publishing_rest_support_oauth1_session_type_id__once;
}

PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_construct (GType object_type,
                                                      PublishingRESTSupportOAuth1Session* session,
                                                      PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportOAuth1Transaction* self = NULL;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (session), NULL);
	self = (PublishingRESTSupportOAuth1Transaction*) publishing_rest_support_transaction_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), method);
	publishing_rest_support_oauth1_transaction_setup_arguments (self);
	return self;
}

PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                PublishingRESTSupportHttpMethod method)
{
	return publishing_rest_support_oauth1_transaction_construct (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, session, method);
}

PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_construct_with_uri (GType object_type,
                                                               PublishingRESTSupportOAuth1Session* session,
                                                               const gchar* uri,
                                                               PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportOAuth1Transaction* self = NULL;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (session), NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (PublishingRESTSupportOAuth1Transaction*) publishing_rest_support_transaction_construct_with_endpoint_url (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), uri, method);
	publishing_rest_support_oauth1_transaction_setup_arguments (self);
	return self;
}

PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_new_with_uri (PublishingRESTSupportOAuth1Session* session,
                                                         const gchar* uri,
                                                         PublishingRESTSupportHttpMethod method)
{
	return publishing_rest_support_oauth1_transaction_construct_with_uri (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, session, uri, method);
}

static void
publishing_rest_support_oauth1_transaction_setup_arguments (PublishingRESTSupportOAuth1Transaction* self)
{
	PublishingRESTSupportOAuth1Session* session = NULL;
	PublishingRESTSupportSession* _tmp0_;
	PublishingRESTSupportOAuth1Session* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PublishingRESTSupportOAuth1Session* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	PublishingRESTSupportOAuth1Session* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	PublishingRESTSupportOAuth1Session* _tmp10_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_TRANSACTION (self));
	_tmp0_ = publishing_rest_support_transaction_get_parent_session (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
	session = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
	_tmp1_ = session;
	_tmp2_ = publishing_rest_support_oauth1_session_get_oauth_nonce (_tmp1_);
	_tmp3_ = _tmp2_;
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_nonce", _tmp3_);
	_g_free0 (_tmp3_);
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_signature_method", "HMAC-SHA1");
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_version", "1.0");
	_tmp4_ = session;
	_tmp5_ = publishing_rest_support_oauth1_session_get_oauth_timestamp (_tmp4_);
	_tmp6_ = _tmp5_;
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_timestamp", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = session;
	_tmp8_ = publishing_rest_support_oauth1_session_get_consumer_key (_tmp7_);
	_tmp9_ = _tmp8_;
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_consumer_key", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = session;
	if (publishing_rest_support_oauth1_session_has_access_phase_token (_tmp10_)) {
		PublishingRESTSupportOAuth1Session* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = session;
		_tmp12_ = publishing_rest_support_oauth1_session_get_access_phase_token (_tmp11_);
		_tmp13_ = _tmp12_;
		publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_token", _tmp13_);
		_g_free0 (_tmp13_);
	}
	_publishing_rest_support_session_unref0 (session);
}

static void
publishing_rest_support_oauth1_transaction_real_execute_async_data_free (gpointer _data)
{
	PublishingRestSupportOauth1TransactionExecuteAsyncData* _data_;
	_data_ = _data;
	_publishing_rest_support_transaction_unref0 (_data_->self);
	g_slice_free (PublishingRestSupportOauth1TransactionExecuteAsyncData, _data_);
}

static gpointer
_publishing_rest_support_transaction_ref0 (gpointer self)
{
	return self ? publishing_rest_support_transaction_ref (self) : NULL;
}

static void
publishing_rest_support_oauth1_transaction_real_execute_async (PublishingRESTSupportTransaction* base,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	PublishingRESTSupportOAuth1Transaction * self;
	PublishingRestSupportOauth1TransactionExecuteAsyncData* _data_;
	PublishingRESTSupportOAuth1Transaction* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, PublishingRESTSupportOAuth1Transaction);
	_data_ = g_slice_new0 (PublishingRestSupportOauth1TransactionExecuteAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_rest_support_oauth1_transaction_real_execute_async_data_free);
	_tmp0_ = _publishing_rest_support_transaction_ref0 (self);
	_data_->self = _tmp0_;
	publishing_rest_support_oauth1_transaction_real_execute_async_co (_data_);
}

static void
publishing_rest_support_oauth1_transaction_execute_finish (PublishingRESTSupportTransaction* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	PublishingRestSupportOauth1TransactionExecuteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
publishing_rest_support_oauth1_transaction_execute_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	PublishingRestSupportOauth1TransactionExecuteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_rest_support_oauth1_transaction_real_execute_async_co (_data_);
}

static gboolean
publishing_rest_support_oauth1_transaction_real_execute_async_co (PublishingRestSupportOauth1TransactionExecuteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = publishing_rest_support_transaction_get_parent_session (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
	_data_->_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
	_data_->_tmp2_ = publishing_rest_support_oauth1_session_sign_transaction (_data_->_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), NULL, (gint) 0);
	_data_->_tmp3_ = _data_->_tmp2_;
	_publishing_rest_support_session_unref0 (_data_->_tmp1_);
	_data_->signature = _data_->_tmp3_;
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_signature", _data_->signature);
	_data_->_state_ = 1;
	PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS (publishing_rest_support_oauth1_transaction_parent_class)->execute_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), publishing_rest_support_oauth1_transaction_execute_async_ready, _data_);
	return FALSE;
	_state_1:
	PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS (publishing_rest_support_oauth1_transaction_parent_class)->execute_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->signature);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->signature);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_free0 (_data_->signature);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_rest_support_oauth1_transaction_class_init (PublishingRESTSupportOAuth1TransactionClass * klass,
                                                       gpointer klass_data)
{
	publishing_rest_support_oauth1_transaction_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportTransactionClass *) klass)->execute_async = (void (*) (PublishingRESTSupportTransaction*, GAsyncReadyCallback, gpointer)) publishing_rest_support_oauth1_transaction_real_execute_async;
	((PublishingRESTSupportTransactionClass *) klass)->execute_finish = (void (*) (PublishingRESTSupportTransaction*, GAsyncResult*, GError**)) publishing_rest_support_oauth1_transaction_execute_finish;
}

static void
publishing_rest_support_oauth1_transaction_instance_init (PublishingRESTSupportOAuth1Transaction * self,
                                                          gpointer klass)
{
}

static GType
publishing_rest_support_oauth1_transaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportOAuth1TransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_oauth1_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportOAuth1Transaction), 0, (GInstanceInitFunc) publishing_rest_support_oauth1_transaction_instance_init, NULL };
	GType publishing_rest_support_oauth1_transaction_type_id;
	publishing_rest_support_oauth1_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, "PublishingRESTSupportOAuth1Transaction", &g_define_type_info, 0);
	return publishing_rest_support_oauth1_transaction_type_id;
}

GType
publishing_rest_support_oauth1_transaction_get_type (void)
{
	static volatile gsize publishing_rest_support_oauth1_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_oauth1_transaction_type_id__once)) {
		GType publishing_rest_support_oauth1_transaction_type_id;
		publishing_rest_support_oauth1_transaction_type_id = publishing_rest_support_oauth1_transaction_get_type_once ();
		g_once_init_leave (&publishing_rest_support_oauth1_transaction_type_id__once, publishing_rest_support_oauth1_transaction_type_id);
	}
	return publishing_rest_support_oauth1_transaction_type_id__once;
}

static inline gpointer
publishing_rest_support_oauth1_upload_transaction_get_instance_private (PublishingRESTSupportOAuth1UploadTransaction* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingRESTSupportOAuth1UploadTransaction_private_offset);
}

PublishingRESTSupportOAuth1UploadTransaction*
publishing_rest_support_oauth1_upload_transaction_construct (GType object_type,
                                                             PublishingRESTSupportOAuth1Session* session,
                                                             SpitPublishingPublishable* publishable,
                                                             const gchar* endpoint_uri)
{
	PublishingRESTSupportOAuth1UploadTransaction* self = NULL;
	PublishingRESTSupportArgument** _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (session), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (publishable, SPIT_PUBLISHING_TYPE_PUBLISHABLE), NULL);
	g_return_val_if_fail (endpoint_uri != NULL, NULL);
	self = (PublishingRESTSupportOAuth1UploadTransaction*) publishing_rest_support_upload_transaction_construct_with_endpoint_url (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), publishable, endpoint_uri);
	_tmp0_ = g_new0 (PublishingRESTSupportArgument*, 0 + 1);
	self->priv->auth_header_fields = (_vala_array_free (self->priv->auth_header_fields, self->priv->auth_header_fields_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
	self->priv->auth_header_fields = _tmp0_;
	self->priv->auth_header_fields_length1 = 0;
	self->priv->_auth_header_fields_size_ = self->priv->auth_header_fields_length1;
	self->session = session;
	_tmp1_ = publishing_rest_support_oauth1_session_get_oauth_nonce (session);
	_tmp2_ = _tmp1_;
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_nonce", _tmp2_);
	_g_free0 (_tmp2_);
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_signature_method", "HMAC-SHA1");
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_version", "1.0");
	_tmp3_ = publishing_rest_support_oauth1_session_get_oauth_timestamp (session);
	_tmp4_ = _tmp3_;
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_timestamp", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = publishing_rest_support_oauth1_session_get_consumer_key (session);
	_tmp6_ = _tmp5_;
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_consumer_key", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = publishing_rest_support_oauth1_session_get_access_phase_token (session);
	_tmp8_ = _tmp7_;
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_token", _tmp8_);
	_g_free0 (_tmp8_);
	return self;
}

PublishingRESTSupportOAuth1UploadTransaction*
publishing_rest_support_oauth1_upload_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                       SpitPublishingPublishable* publishable,
                                                       const gchar* endpoint_uri)
{
	return publishing_rest_support_oauth1_upload_transaction_construct (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, session, publishable, endpoint_uri);
}

static void
_vala_array_add5 (PublishingRESTSupportArgument** * array,
                  gint* length,
                  gint* size,
                  PublishingRESTSupportArgument* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PublishingRESTSupportArgument*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (PublishingRESTSupportOAuth1UploadTransaction* self,
                                                                                  const gchar* key,
                                                                                  const gchar* value)
{
	PublishingRESTSupportArgument* _tmp0_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION (self));
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = publishing_rest_support_argument_new (key, value);
	_vala_array_add5 (&self->priv->auth_header_fields, &self->priv->auth_header_fields_length1, &self->priv->_auth_header_fields_size_, _tmp0_);
}

gchar*
publishing_rest_support_oauth1_upload_transaction_get_authorization_header_string (PublishingRESTSupportOAuth1UploadTransaction* self)
{
	PublishingRESTSupportArgument** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION (self), NULL);
	_tmp0_ = self->priv->auth_header_fields;
	_tmp0__length1 = self->priv->auth_header_fields_length1;
	_tmp1_ = publishing_rest_support_argument_serialize_list (_tmp0_, (gint) _tmp0__length1, FALSE, TRUE, ", ");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("OAuth ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

void
publishing_rest_support_oauth1_upload_transaction_authorize (PublishingRESTSupportOAuth1UploadTransaction* self)
{
	gchar* signature = NULL;
	PublishingRESTSupportOAuth1Session* _tmp0_;
	PublishingRESTSupportArgument** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* authorization_header = NULL;
	gchar* _tmp3_;
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION (self));
	_tmp0_ = self->session;
	_tmp1_ = self->priv->auth_header_fields;
	_tmp1__length1 = self->priv->auth_header_fields_length1;
	_tmp2_ = publishing_rest_support_oauth1_session_sign_transaction (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _tmp1_, (gint) _tmp1__length1);
	signature = _tmp2_;
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_signature", signature);
	_tmp3_ = publishing_rest_support_oauth1_upload_transaction_get_authorization_header_string (self);
	authorization_header = _tmp3_;
	g_debug ("OAuth1Support.vala:220: executing upload transaction: authorization he" \
"ader string = '%s'", authorization_header);
	publishing_rest_support_transaction_add_header (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "Authorization", authorization_header);
	_g_free0 (authorization_header);
	_g_free0 (signature);
}

static void
publishing_rest_support_oauth1_upload_transaction_class_init (PublishingRESTSupportOAuth1UploadTransactionClass * klass,
                                                              gpointer klass_data)
{
	publishing_rest_support_oauth1_upload_transaction_parent_class = g_type_class_peek_parent (klass);
	((PublishingRESTSupportTransactionClass *) klass)->finalize = publishing_rest_support_oauth1_upload_transaction_finalize;
	g_type_class_adjust_private_offset (klass, &PublishingRESTSupportOAuth1UploadTransaction_private_offset);
}

static void
publishing_rest_support_oauth1_upload_transaction_instance_init (PublishingRESTSupportOAuth1UploadTransaction * self,
                                                                 gpointer klass)
{
	self->priv = publishing_rest_support_oauth1_upload_transaction_get_instance_private (self);
}

static void
publishing_rest_support_oauth1_upload_transaction_finalize (PublishingRESTSupportTransaction * obj)
{
	PublishingRESTSupportOAuth1UploadTransaction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportOAuth1UploadTransaction);
	self->priv->auth_header_fields = (_vala_array_free (self->priv->auth_header_fields, self->priv->auth_header_fields_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
	PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS (publishing_rest_support_oauth1_upload_transaction_parent_class)->finalize (obj);
}

static GType
publishing_rest_support_oauth1_upload_transaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportOAuth1UploadTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_oauth1_upload_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportOAuth1UploadTransaction), 0, (GInstanceInitFunc) publishing_rest_support_oauth1_upload_transaction_instance_init, NULL };
	GType publishing_rest_support_oauth1_upload_transaction_type_id;
	publishing_rest_support_oauth1_upload_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, "PublishingRESTSupportOAuth1UploadTransaction", &g_define_type_info, 0);
	PublishingRESTSupportOAuth1UploadTransaction_private_offset = g_type_add_instance_private (publishing_rest_support_oauth1_upload_transaction_type_id, sizeof (PublishingRESTSupportOAuth1UploadTransactionPrivate));
	return publishing_rest_support_oauth1_upload_transaction_type_id;
}

GType
publishing_rest_support_oauth1_upload_transaction_get_type (void)
{
	static volatile gsize publishing_rest_support_oauth1_upload_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_rest_support_oauth1_upload_transaction_type_id__once)) {
		GType publishing_rest_support_oauth1_upload_transaction_type_id;
		publishing_rest_support_oauth1_upload_transaction_type_id = publishing_rest_support_oauth1_upload_transaction_get_type_once ();
		g_once_init_leave (&publishing_rest_support_oauth1_upload_transaction_type_id__once, publishing_rest_support_oauth1_upload_transaction_type_id);
	}
	return publishing_rest_support_oauth1_upload_transaction_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

