/* FlickrPublishingAuthenticator.c generated by valac 0.56.17, the Vala compiler
 * generated from FlickrPublishingAuthenticator.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "shotwell-plugin-common.h"
#include <glib-object.h>
#include "shotwell-plugin-dev-1.0.h"
#include <gio/gio.h>
#include <libsoup/soup.h>
#include "shotwell-authenticator.h"

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_ENDPOINT_URL "https://api.flickr.com/services/rest"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_EXPIRED_SESSION_ERROR_CODE "98"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_API_KEY "60dd96d4a2ad04888b09c9e18d82c26f"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_API_SECRET "d0960565e03547c1"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_SERVICE_WELCOME_MESSAGE _ ("You are not currently logged into Flickr.\n" \
"\n" \
"Click Log in to log into Flickr in your Web browser. You will have to " \
"authorize Shotwell Connect to link to your Flickr account.")
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_SERVICE_DISCLAIMER "<b>This product uses the Flickr API but is not endorsed or certified b" \
"y SmugMug, Inc.</b>"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_AUTHENTICATION_REQUEST_TRANSACTION (publishing_authenticator_shotwell_flickr_authentication_request_transaction_get_type ())
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_AUTHENTICATION_REQUEST_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_AUTHENTICATION_REQUEST_TRANSACTION, PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_AUTHENTICATION_REQUEST_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_AUTHENTICATION_REQUEST_TRANSACTION, PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionClass))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_AUTHENTICATION_REQUEST_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_AUTHENTICATION_REQUEST_TRANSACTION))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_AUTHENTICATION_REQUEST_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_AUTHENTICATION_REQUEST_TRANSACTION))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_AUTHENTICATION_REQUEST_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_AUTHENTICATION_REQUEST_TRANSACTION, PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionClass))

typedef struct _PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction;
typedef struct _PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionClass PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionClass;
typedef struct _PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionPrivate PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_ACCESS_TOKEN_FETCH_TRANSACTION (publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_get_type ())
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_ACCESS_TOKEN_FETCH_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_ACCESS_TOKEN_FETCH_TRANSACTION, PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_ACCESS_TOKEN_FETCH_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_ACCESS_TOKEN_FETCH_TRANSACTION, PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionClass))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_ACCESS_TOKEN_FETCH_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_ACCESS_TOKEN_FETCH_TRANSACTION))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_ACCESS_TOKEN_FETCH_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_ACCESS_TOKEN_FETCH_TRANSACTION))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_ACCESS_TOKEN_FETCH_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_ACCESS_TOKEN_FETCH_TRANSACTION, PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionClass))

typedef struct _PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction;
typedef struct _PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionClass PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionClass;
typedef struct _PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionPrivate PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionPrivate;

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR (publishing_authenticator_shotwell_oauth1_authenticator_get_type ())
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1AuthenticatorClass))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1AuthenticatorClass))

typedef struct _PublishingAuthenticatorShotwellOAuth1Authenticator PublishingAuthenticatorShotwellOAuth1Authenticator;
typedef struct _PublishingAuthenticatorShotwellOAuth1AuthenticatorClass PublishingAuthenticatorShotwellOAuth1AuthenticatorClass;
typedef struct _PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate;

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR (publishing_authenticator_shotwell_flickr_flickr_get_type ())
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickr))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickrClass))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickrClass))

typedef struct _PublishingAuthenticatorShotwellFlickrFlickr PublishingAuthenticatorShotwellFlickrFlickr;
typedef struct _PublishingAuthenticatorShotwellFlickrFlickrClass PublishingAuthenticatorShotwellFlickrFlickrClass;
typedef struct _PublishingAuthenticatorShotwellFlickrFlickrPrivate PublishingAuthenticatorShotwellFlickrFlickrPrivate;
enum  {
	PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_0_PROPERTY,
	PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_NUM_PROPERTIES
};
static GParamSpec* publishing_authenticator_shotwell_flickr_flickr_properties[PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _publishing_rest_support_transaction_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_transaction_unref (var), NULL)))
typedef struct _PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK (publishing_authenticator_shotwell_flickr_flickr_auth_callback_get_type ())
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK, PublishingAuthenticatorShotwellFlickrFlickrAuthCallback))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK, PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackClass))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_IS_AUTH_CALLBACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_IS_AUTH_CALLBACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK, PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackClass))

typedef struct _PublishingAuthenticatorShotwellFlickrFlickrAuthCallback PublishingAuthenticatorShotwellFlickrFlickrAuthCallback;
typedef struct _PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackClass PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackClass;
typedef struct _PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData;
typedef struct _PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData;
typedef struct _PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackPrivate PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackPrivate;
enum  {
	PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_0_PROPERTY,
	PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_NUM_PROPERTIES
};
static GParamSpec* publishing_authenticator_shotwell_flickr_flickr_auth_callback_properties[PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_NUM_PROPERTIES];
enum  {
	PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_AUTH_SIGNAL,
	PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_NUM_SIGNALS
};
static guint publishing_authenticator_shotwell_flickr_flickr_auth_callback_signals[PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_NUM_SIGNALS] = {0};

struct _PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction {
	PublishingRESTSupportOAuth1Transaction parent_instance;
	PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionPrivate * priv;
};

struct _PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionClass {
	PublishingRESTSupportOAuth1TransactionClass parent_class;
};

struct _PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction {
	PublishingRESTSupportOAuth1Transaction parent_instance;
	PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionPrivate * priv;
};

struct _PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionClass {
	PublishingRESTSupportOAuth1TransactionClass parent_class;
};

struct _PublishingAuthenticatorShotwellOAuth1Authenticator {
	GObject parent_instance;
	PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate * priv;
	GHashTable* params;
	PublishingRESTSupportOAuth1Session* session;
	SpitPublishingPluginHost* host;
};

struct _PublishingAuthenticatorShotwellOAuth1AuthenticatorClass {
	GObjectClass parent_class;
	void (*authenticate) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	gboolean (*can_logout) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	void (*logout) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	void (*refresh) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	void (*set_accountname) (PublishingAuthenticatorShotwellOAuth1Authenticator* self, const gchar* name);
};

struct _PublishingAuthenticatorShotwellFlickrFlickr {
	PublishingAuthenticatorShotwellOAuth1Authenticator parent_instance;
	PublishingAuthenticatorShotwellFlickrFlickrPrivate * priv;
};

struct _PublishingAuthenticatorShotwellFlickrFlickrClass {
	PublishingAuthenticatorShotwellOAuth1AuthenticatorClass parent_class;
};

struct _PublishingAuthenticatorShotwellFlickrFlickrPrivate {
	ShotwellPluginsCommonExternalWebPane* pane;
	gchar* auth_cookie;
};

struct _PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingAuthenticatorShotwellFlickrFlickr* self;
	SpitPublishingPluginHost* _tmp0_;
	SpitPublishingPluginHost* _tmp1_;
	PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction* txn;
	PublishingRESTSupportOAuth1Session* _tmp2_;
	const gchar* _tmp3_;
	PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* err;
	SpitPublishingPluginHost* _tmp9_;
	GError* _tmp10_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	PublishingAuthenticatorShotwellFlickrFlickr* self;
	gchar* web_auth_code;
	gpointer _async_data_;
};

struct _PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingAuthenticatorShotwellFlickrFlickr* self;
	gchar* token;
	Block1Data* _data1_;
	gchar* uri;
	gchar* _tmp0_;
	ShotwellPluginsCommonExternalWebPane* _tmp1_;
	SpitPublishingPluginHost* _tmp2_;
	ShotwellPluginsCommonExternalWebPane* _tmp3_;
	PublishingAuthenticatorShotwellFlickrFlickrAuthCallback* auth_callback;
	PublishingAuthenticatorShotwellFlickrFlickrAuthCallback* _tmp4_;
	SpitPublishingPluginHost* _tmp5_;
	const gchar* _tmp6_;
	SpitPublishingPluginHost* _tmp7_;
	const gchar* _tmp8_;
};

struct _PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PublishingAuthenticatorShotwellFlickrFlickr* self;
	gchar* pin;
	SpitPublishingPluginHost* _tmp0_;
	SpitPublishingPluginHost* _tmp1_;
	PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction* txn;
	PublishingRESTSupportOAuth1Session* _tmp2_;
	const gchar* _tmp3_;
	PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* err;
	SpitPublishingPluginHost* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_;
};

struct _PublishingAuthenticatorShotwellFlickrFlickrAuthCallback {
	GObject parent_instance;
	PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackPrivate * priv;
};

struct _PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackClass {
	GObjectClass parent_class;
};

static gpointer publishing_authenticator_shotwell_flickr_authentication_request_transaction_parent_class = NULL;
static gpointer publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_parent_class = NULL;
static gint PublishingAuthenticatorShotwellFlickrFlickr_private_offset;
static gpointer publishing_authenticator_shotwell_flickr_flickr_parent_class = NULL;
static gpointer publishing_authenticator_shotwell_flickr_flickr_auth_callback_parent_class = NULL;
static SpitPublishingAuthenticatedCallbackIface * publishing_authenticator_shotwell_flickr_flickr_auth_callback_spit_publishing_authenticated_callback_parent_iface = NULL;

VALA_EXTERN GType publishing_authenticator_shotwell_flickr_authentication_request_transaction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction* publishing_authenticator_shotwell_flickr_authentication_request_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                                                                                                                        const gchar* cookie);
VALA_EXTERN PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction* publishing_authenticator_shotwell_flickr_authentication_request_transaction_construct (GType object_type,
                                                                                                                                                              PublishingRESTSupportOAuth1Session* session,
                                                                                                                                                              const gchar* cookie);
static GType publishing_authenticator_shotwell_flickr_authentication_request_transaction_get_type_once (void);
VALA_EXTERN GType publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction* publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                                                                                                               const gchar* user_verifier,
                                                                                                                                               const gchar* cookie);
VALA_EXTERN PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction* publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_construct (GType object_type,
                                                                                                                                                     PublishingRESTSupportOAuth1Session* session,
                                                                                                                                                     const gchar* user_verifier,
                                                                                                                                                     const gchar* cookie);
static GType publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_get_type_once (void);
VALA_EXTERN GType publishing_authenticator_shotwell_oauth1_authenticator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType publishing_authenticator_shotwell_flickr_flickr_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_authenticate (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gboolean publishing_authenticator_shotwell_oauth1_authenticator_can_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_refresh (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN PublishingAuthenticatorShotwellFlickrFlickr* publishing_authenticator_shotwell_flickr_flickr_new (SpitPublishingPluginHost* host);
VALA_EXTERN PublishingAuthenticatorShotwellFlickrFlickr* publishing_authenticator_shotwell_flickr_flickr_construct (GType object_type,
                                                                                                        SpitPublishingPluginHost* host);
VALA_EXTERN PublishingAuthenticatorShotwellOAuth1Authenticator* publishing_authenticator_shotwell_oauth1_authenticator_construct (GType object_type,
                                                                                                                      const gchar* service,
                                                                                                                      const gchar* api_key,
                                                                                                                      const gchar* api_secret,
                                                                                                                      SpitPublishingPluginHost* host);
static void publishing_authenticator_shotwell_flickr_flickr_real_authenticate (PublishingAuthenticatorShotwellOAuth1Authenticator* base);
VALA_EXTERN gboolean publishing_authenticator_shotwell_oauth1_authenticator_is_persistent_session_valid (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gchar* publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gchar* publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token_secret (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gchar* publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_username (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static void publishing_authenticator_shotwell_flickr_flickr_do_show_login_welcome_pane (PublishingAuthenticatorShotwellFlickrFlickr* self);
static gboolean publishing_authenticator_shotwell_flickr_flickr_real_can_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* base);
static void publishing_authenticator_shotwell_flickr_flickr_real_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* base);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_invalidate_persistent_session (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static void publishing_authenticator_shotwell_flickr_flickr_real_refresh (PublishingAuthenticatorShotwellOAuth1Authenticator* base);
static void publishing_authenticator_shotwell_flickr_flickr_on_welcome_pane_login_clicked (PublishingAuthenticatorShotwellFlickrFlickr* self);
static void _publishing_authenticator_shotwell_flickr_flickr_on_welcome_pane_login_clicked_spit_publishing_login_callback (gpointer self);
static void publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                                GAsyncReadyCallback _callback_,
                                                                                                gpointer _user_data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_finish (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                                       GAsyncResult* _res_);
static void publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_data_free (gpointer _data);
static gboolean publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_co (PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData* _data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_ready (GObject* source_object,
                                                                                                      GAsyncResult* _res_,
                                                                                                      gpointer _user_data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_parse_token_info_from_auth_request (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                            const gchar* response);
static void publishing_authenticator_shotwell_flickr_flickr_on_authentication_token_available (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                        const gchar* token,
                                                                                        const gchar* token_secret);
static void publishing_authenticator_shotwell_flickr_flickr_do_web_authentication (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                            const gchar* token,
                                                                            GAsyncReadyCallback _callback_,
                                                                            gpointer _user_data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_finish (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                   GAsyncResult* _res_);
static void publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_data_free (gpointer _data);
static gboolean publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_co (PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GType publishing_authenticator_shotwell_flickr_flickr_auth_callback_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PublishingAuthenticatorShotwellFlickrFlickrAuthCallback* publishing_authenticator_shotwell_flickr_flickr_auth_callback_new (void);
static PublishingAuthenticatorShotwellFlickrFlickrAuthCallback* publishing_authenticator_shotwell_flickr_flickr_auth_callback_construct (GType object_type);
static void __lambda4_ (Block1Data* _data1_,
                 GHashTable* prm);
static void ___lambda4__publishing_authenticator_shotwell_flickr_flickr_auth_callback_auth (PublishingAuthenticatorShotwellFlickrFlickrAuthCallback* _sender,
                                                                                     GHashTable* params,
                                                                                     gpointer self);
static void publishing_authenticator_shotwell_flickr_flickr_do_verify_pin (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                    const gchar* pin,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_finish (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                           GAsyncResult* _res_);
static void publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_ready (GObject* source_object,
                                                                                  GAsyncResult* _res_,
                                                                                  gpointer _user_data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_data_free (gpointer _data);
static gboolean publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_co (PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData* _data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_ready (GObject* source_object,
                                                                          GAsyncResult* _res_,
                                                                          gpointer _user_data_);
static void publishing_authenticator_shotwell_flickr_flickr_do_extract_access_phase_credentials_from_response (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                                        const gchar* response);
static void publishing_authenticator_shotwell_flickr_flickr_auth_callback_real_authenticated (SpitPublishingAuthenticatedCallback* base,
                                                                                       GHashTable* params);
static GType publishing_authenticator_shotwell_flickr_flickr_auth_callback_get_type_once (void);
static void publishing_authenticator_shotwell_flickr_flickr_finalize (GObject * obj);
static GType publishing_authenticator_shotwell_flickr_flickr_get_type_once (void);

PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction*
publishing_authenticator_shotwell_flickr_authentication_request_transaction_construct (GType object_type,
                                                                                       PublishingRESTSupportOAuth1Session* session,
                                                                                       const gchar* cookie)
{
	PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (session, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION), NULL);
	g_return_val_if_fail (cookie != NULL, NULL);
	self = (PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction*) publishing_rest_support_oauth1_transaction_construct_with_uri (object_type, session, "https://www.flickr.com/services/oauth/request_token", PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET);
	_tmp0_ = g_strdup_printf ("shotwell-oauth2://localhost?sw_auth_cookie=%s", cookie);
	_tmp1_ = _tmp0_;
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_callback", _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction*
publishing_authenticator_shotwell_flickr_authentication_request_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                                                 const gchar* cookie)
{
	return publishing_authenticator_shotwell_flickr_authentication_request_transaction_construct (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_AUTHENTICATION_REQUEST_TRANSACTION, session, cookie);
}

static void
publishing_authenticator_shotwell_flickr_authentication_request_transaction_class_init (PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionClass * klass,
                                                                                        gpointer klass_data)
{
	publishing_authenticator_shotwell_flickr_authentication_request_transaction_parent_class = g_type_class_peek_parent (klass);
}

static void
publishing_authenticator_shotwell_flickr_authentication_request_transaction_instance_init (PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction * self,
                                                                                           gpointer klass)
{
}

static GType
publishing_authenticator_shotwell_flickr_authentication_request_transaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_authenticator_shotwell_flickr_authentication_request_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction), 0, (GInstanceInitFunc) publishing_authenticator_shotwell_flickr_authentication_request_transaction_instance_init, NULL };
	GType publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id;
	publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, "PublishingAuthenticatorShotwellFlickrAuthenticationRequestTransaction", &g_define_type_info, 0);
	return publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id;
}

GType
publishing_authenticator_shotwell_flickr_authentication_request_transaction_get_type (void)
{
	static volatile gsize publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id__once)) {
		GType publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id;
		publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id = publishing_authenticator_shotwell_flickr_authentication_request_transaction_get_type_once ();
		g_once_init_leave (&publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id__once, publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id);
	}
	return publishing_authenticator_shotwell_flickr_authentication_request_transaction_type_id__once;
}

PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction*
publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_construct (GType object_type,
                                                                                   PublishingRESTSupportOAuth1Session* session,
                                                                                   const gchar* user_verifier,
                                                                                   const gchar* cookie)
{
	PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (session, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION), NULL);
	g_return_val_if_fail (user_verifier != NULL, NULL);
	g_return_val_if_fail (cookie != NULL, NULL);
	self = (PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction*) publishing_rest_support_oauth1_transaction_construct_with_uri (object_type, session, "https://www.flickr.com/services/oauth/access_token", PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET);
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_verifier", user_verifier);
	_tmp0_ = publishing_rest_support_oauth1_session_get_request_phase_token (session);
	_tmp1_ = _tmp0_;
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_token", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup_printf ("shotwell-oauth2://localhost?sw_auth_cookie=%s", cookie);
	_tmp3_ = _tmp2_;
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_callback", _tmp3_);
	_g_free0 (_tmp3_);
	return self;
}

PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction*
publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                                             const gchar* user_verifier,
                                                                             const gchar* cookie)
{
	return publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_construct (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_ACCESS_TOKEN_FETCH_TRANSACTION, session, user_verifier, cookie);
}

static void
publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_class_init (PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionClass * klass,
                                                                                    gpointer klass_data)
{
	publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_parent_class = g_type_class_peek_parent (klass);
}

static void
publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_instance_init (PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction * self,
                                                                                       gpointer klass)
{
}

static GType
publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction), 0, (GInstanceInitFunc) publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_instance_init, NULL };
	GType publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id;
	publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, "PublishingAuthenticatorShotwellFlickrAccessTokenFetchTransaction", &g_define_type_info, 0);
	return publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id;
}

GType
publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_get_type (void)
{
	static volatile gsize publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id__once = 0;
	if (g_once_init_enter (&publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id__once)) {
		GType publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id;
		publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id = publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_get_type_once ();
		g_once_init_leave (&publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id__once, publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id);
	}
	return publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_type_id__once;
}

static inline gpointer
publishing_authenticator_shotwell_flickr_flickr_get_instance_private (PublishingAuthenticatorShotwellFlickrFlickr* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingAuthenticatorShotwellFlickrFlickr_private_offset);
}

PublishingAuthenticatorShotwellFlickrFlickr*
publishing_authenticator_shotwell_flickr_flickr_construct (GType object_type,
                                                           SpitPublishingPluginHost* host)
{
	PublishingAuthenticatorShotwellFlickrFlickr * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (host, SPIT_PUBLISHING_TYPE_PLUGIN_HOST), NULL);
	self = (PublishingAuthenticatorShotwellFlickrFlickr*) publishing_authenticator_shotwell_oauth1_authenticator_construct (object_type, "Flickr", PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_API_KEY, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_API_SECRET, host);
	return self;
}

PublishingAuthenticatorShotwellFlickrFlickr*
publishing_authenticator_shotwell_flickr_flickr_new (SpitPublishingPluginHost* host)
{
	return publishing_authenticator_shotwell_flickr_flickr_construct (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, host);
}

static void
publishing_authenticator_shotwell_flickr_flickr_real_authenticate (PublishingAuthenticatorShotwellOAuth1Authenticator* base)
{
	PublishingAuthenticatorShotwellFlickrFlickr * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickr);
	if (publishing_authenticator_shotwell_oauth1_authenticator_is_persistent_session_valid (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator))) {
		PublishingRESTSupportOAuth1Session* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		g_debug ("FlickrPublishingAuthenticator.vala:48: attempt start: a persistent ses" \
"sion is available; using it");
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->session;
		_tmp1_ = publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator));
		_tmp2_ = _tmp1_;
		_tmp3_ = publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token_secret (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator));
		_tmp4_ = _tmp3_;
		_tmp5_ = publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_username (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator));
		_tmp6_ = _tmp5_;
		publishing_rest_support_oauth1_session_authenticate_from_persistent_credentials (_tmp0_, _tmp2_, _tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		g_debug ("FlickrPublishingAuthenticator.vala:53: attempt start: no persistent se" \
"ssion available; showing login welcome pane");
		publishing_authenticator_shotwell_flickr_flickr_do_show_login_welcome_pane (self);
	}
}

static gboolean
publishing_authenticator_shotwell_flickr_flickr_real_can_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* base)
{
	PublishingAuthenticatorShotwellFlickrFlickr * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickr);
	result = TRUE;
	return result;
}

static void
publishing_authenticator_shotwell_flickr_flickr_real_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* base)
{
	PublishingAuthenticatorShotwellFlickrFlickr * self;
	PublishingRESTSupportOAuth1Session* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickr);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->session;
	publishing_rest_support_oauth1_session_deauthenticate (_tmp0_);
	publishing_authenticator_shotwell_oauth1_authenticator_invalidate_persistent_session (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator));
}

static void
publishing_authenticator_shotwell_flickr_flickr_real_refresh (PublishingAuthenticatorShotwellOAuth1Authenticator* base)
{
	PublishingAuthenticatorShotwellFlickrFlickr * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickr);
}

static void
_publishing_authenticator_shotwell_flickr_flickr_on_welcome_pane_login_clicked_spit_publishing_login_callback (gpointer self)
{
	publishing_authenticator_shotwell_flickr_flickr_on_welcome_pane_login_clicked ((PublishingAuthenticatorShotwellFlickrFlickr*) self);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_show_login_welcome_pane (PublishingAuthenticatorShotwellFlickrFlickr* self)
{
	SpitPublishingPluginHost* _tmp0_;
	SpitPublishingPluginHost* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	g_debug ("FlickrPublishingAuthenticator.vala:72: ACTION: installing login welcom" \
"e pane");
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	spit_publishing_plugin_host_set_service_locked (_tmp0_, FALSE);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	_tmp2_ = g_strdup_printf ("%s\n\n%s", PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_SERVICE_WELCOME_MESSAGE, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_SERVICE_DISCLAIMER);
	_tmp3_ = _tmp2_;
	spit_publishing_plugin_host_install_welcome_pane (_tmp1_, _tmp3_, _publishing_authenticator_shotwell_flickr_flickr_on_welcome_pane_login_clicked_spit_publishing_login_callback, self);
	_g_free0 (_tmp3_);
}

static void
publishing_authenticator_shotwell_flickr_flickr_on_welcome_pane_login_clicked (PublishingAuthenticatorShotwellFlickrFlickr* self)
{
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	g_debug ("FlickrPublishingAuthenticator.vala:79: EVENT: user clicked 'Login' but" \
"ton in the welcome pane");
	publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction (self, NULL, NULL);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_data_free (gpointer _data)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                           GAsyncReadyCallback _callback_,
                                                                                           gpointer _user_data_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData* _data_;
	PublishingAuthenticatorShotwellFlickrFlickr* _tmp0_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	_data_ = g_slice_new0 (PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_co (_data_);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_finish (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                                  GAsyncResult* _res_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_ready (GObject* source_object,
                                                                                                 GAsyncResult* _res_,
                                                                                                 gpointer _user_data_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_co (_data_);
}

static gboolean
publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_co (PublishingAuthenticatorShotwellFlickrFlickrDoRunAuthenticationRequestTransactionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("FlickrPublishingAuthenticator.vala:85: ACTION: running authentication " \
"request transaction");
	_data_->_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	spit_publishing_plugin_host_set_service_locked (_data_->_tmp0_, TRUE);
	_data_->_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	spit_publishing_plugin_host_install_static_message_pane (_data_->_tmp1_, _ ("Preparing for login…"), SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL);
	_data_->_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->session;
	_data_->_tmp3_ = _data_->self->priv->auth_cookie;
	_data_->_tmp4_ = publishing_authenticator_shotwell_flickr_authentication_request_transaction_new (_data_->_tmp2_, _data_->_tmp3_);
	_data_->txn = _data_->_tmp4_;
	{
		_data_->_state_ = 1;
		publishing_rest_support_transaction_execute_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), publishing_authenticator_shotwell_flickr_flickr_do_run_authentication_request_transaction_ready, _data_);
		return FALSE;
		_state_1:
		publishing_rest_support_transaction_execute_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = publishing_rest_support_transaction_get_response (G_TYPE_CHECK_INSTANCE_CAST (_data_->txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
		_data_->_tmp6_ = _data_->_tmp5_;
		g_debug ("FlickrPublishingAuthenticator.vala:93: EVENT: OAuth authentication req" \
"uest transaction completed; response = '%s'", _data_->_tmp6_);
		_g_free0 (_data_->_tmp6_);
		_data_->_tmp7_ = publishing_rest_support_transaction_get_response (G_TYPE_CHECK_INSTANCE_CAST (_data_->txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
		_data_->_tmp8_ = _data_->_tmp7_;
		publishing_authenticator_shotwell_flickr_flickr_do_parse_token_info_from_auth_request (_data_->self, _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_debug ("FlickrPublishingAuthenticator.vala:97: EVENT: OAuth authentication req" \
"uest transaction caused a network error");
		_data_->_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
		_data_->_tmp10_ = _data_->err;
		spit_publishing_plugin_host_post_error (_data_->_tmp9_, _data_->_tmp10_);
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, SPIT_PUBLISHING_TYPE_AUTHENTICATOR, SpitPublishingAuthenticator), "authentication-failed");
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_publishing_rest_support_transaction_unref0 (_data_->txn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_publishing_rest_support_transaction_unref0 (_data_->txn);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_parse_token_info_from_auth_request (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                       const gchar* response)
{
	gchar* oauth_token = NULL;
	gchar* oauth_token_secret = NULL;
	GHashTable* data = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	g_return_if_fail (response != NULL);
	g_debug ("FlickrPublishingAuthenticator.vala:105: ACTION: parsing authorization " \
"request response '%s' into token and secret", response);
	oauth_token = NULL;
	oauth_token_secret = NULL;
	_tmp0_ = soup_form_decode (response);
	data = _tmp0_;
	_tmp1_ = data;
	g_hash_table_lookup_extended (_tmp1_, "oauth_token", NULL, &_tmp2_);
	_g_free0 (oauth_token);
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	oauth_token = _tmp3_;
	_tmp4_ = data;
	g_hash_table_lookup_extended (_tmp4_, "oauth_token_secret", NULL, &_tmp5_);
	_g_free0 (oauth_token_secret);
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	oauth_token_secret = _tmp6_;
	_tmp8_ = oauth_token;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = oauth_token_secret;
		_tmp7_ = _tmp9_ == NULL;
	}
	if (_tmp7_) {
		SpitPublishingPluginHost* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
		_tmp11_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "'%s' isn't a valid response to an OAuth authentication request", response);
		_tmp12_ = _tmp11_;
		spit_publishing_plugin_host_post_error (_tmp10_, _tmp12_);
		_g_error_free0 (_tmp12_);
	}
	_tmp13_ = oauth_token;
	_tmp14_ = oauth_token_secret;
	publishing_authenticator_shotwell_flickr_flickr_on_authentication_token_available (self, _tmp13_, _tmp14_);
	_g_hash_table_unref0 (data);
	_g_free0 (oauth_token_secret);
	_g_free0 (oauth_token);
}

static void
publishing_authenticator_shotwell_flickr_flickr_on_authentication_token_available (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                   const gchar* token,
                                                                                   const gchar* token_secret)
{
	PublishingRESTSupportOAuth1Session* _tmp0_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	g_return_if_fail (token != NULL);
	g_return_if_fail (token_secret != NULL);
	g_debug ("FlickrPublishingAuthenticator.vala:123: EVENT: OAuth authentication to" \
"ken (%s) and token secret (%s) available", token, token_secret);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->session;
	publishing_rest_support_oauth1_session_set_request_phase_credentials (_tmp0_, token, token_secret);
	publishing_authenticator_shotwell_flickr_flickr_do_web_authentication (self, token, NULL, NULL);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_data_free (gpointer _data)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->token);
	_g_object_unref0 (_data_->self);
	g_slice_free (PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData, _data_);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_web_authentication (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                       const gchar* token,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData* _data_;
	PublishingAuthenticatorShotwellFlickrFlickr* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	g_return_if_fail (token != NULL);
	_data_ = g_slice_new0 (PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (token);
	_g_free0 (_data_->token);
	_data_->token = _tmp1_;
	publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_co (_data_);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_finish (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                              GAsyncResult* _res_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PublishingAuthenticatorShotwellFlickrFlickr* self;
		self = _data1_->self;
		_g_free0 (_data1_->web_auth_code);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_,
            GHashTable* prm)
{
	PublishingAuthenticatorShotwellFlickrFlickr* self;
	self = _data1_->self;
	g_return_if_fail (prm != NULL);
	if (g_hash_table_contains (prm, "oauth_verifier")) {
		gconstpointer _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_hash_table_lookup (prm, "oauth_verifier");
		_tmp1_ = g_strdup ((const gchar*) _tmp0_);
		_g_free0 (_data1_->web_auth_code);
		_data1_->web_auth_code = _tmp1_;
	}
	publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_co (_data1_->_async_data_);
}

static void
___lambda4__publishing_authenticator_shotwell_flickr_flickr_auth_callback_auth (PublishingAuthenticatorShotwellFlickrFlickrAuthCallback* _sender,
                                                                                GHashTable* params,
                                                                                gpointer self)
{
	__lambda4_ (self, params);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_ready (GObject* source_object,
                                                                             GAsyncResult* _res_,
                                                                             gpointer _user_data_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_co (_data_);
}

static gboolean
publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_co (PublishingAuthenticatorShotwellFlickrFlickrDoWebAuthenticationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = g_strdup_printf ("https://www.flickr.com/services/oauth/authorize?oauth_token=%s&perms=w" \
"rite", _data_->token);
	_data_->uri = _data_->_tmp0_;
	_data_->_tmp1_ = shotwell_plugins_common_external_web_pane_new (_data_->uri);
	_g_object_unref0 (_data_->self->priv->pane);
	_data_->self->priv->pane = _data_->_tmp1_;
	_data_->_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	_data_->_tmp3_ = _data_->self->priv->pane;
	spit_publishing_plugin_host_install_dialog_pane (_data_->_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, SPIT_PUBLISHING_TYPE_DIALOG_PANE, SpitPublishingDialogPane), SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL);
	_data_->_tmp4_ = publishing_authenticator_shotwell_flickr_flickr_auth_callback_new ();
	_data_->auth_callback = _data_->_tmp4_;
	_data_->_data1_->web_auth_code = NULL;
	g_signal_connect_data (_data_->auth_callback, "auth", (GCallback) ___lambda4__publishing_authenticator_shotwell_flickr_flickr_auth_callback_auth, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	_data_->_tmp6_ = _data_->self->priv->auth_cookie;
	spit_publishing_plugin_host_register_auth_callback (_data_->_tmp5_, _data_->_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_data_->auth_callback, SPIT_PUBLISHING_TYPE_AUTHENTICATED_CALLBACK, SpitPublishingAuthenticatedCallback));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	_data_->_tmp8_ = _data_->self->priv->auth_cookie;
	spit_publishing_plugin_host_unregister_auth_callback (_data_->_tmp7_, _data_->_tmp8_);
	_data_->_state_ = 2;
	publishing_authenticator_shotwell_flickr_flickr_do_verify_pin (_data_->self, _data_->_data1_->web_auth_code, publishing_authenticator_shotwell_flickr_flickr_do_web_authentication_ready, _data_);
	return FALSE;
	_state_2:
	publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->auth_callback);
	_g_free0 (_data_->uri);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_data_free (gpointer _data)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData* _data_;
	_data_ = _data;
	_g_free0 (_data_->pin);
	_g_object_unref0 (_data_->self);
	g_slice_free (PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData, _data_);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_verify_pin (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                               const gchar* pin,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData* _data_;
	PublishingAuthenticatorShotwellFlickrFlickr* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	g_return_if_fail (pin != NULL);
	_data_ = g_slice_new0 (PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (pin);
	_g_free0 (_data_->pin);
	_data_->pin = _tmp1_;
	publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_co (_data_);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_finish (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                      GAsyncResult* _res_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_)
{
	PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_co (_data_);
}

static gboolean
publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_co (PublishingAuthenticatorShotwellFlickrFlickrDoVerifyPinData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("FlickrPublishingAuthenticator.vala:158: ACTION: validating authorizati" \
"on PIN %s", _data_->pin);
	_data_->_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	spit_publishing_plugin_host_set_service_locked (_data_->_tmp0_, TRUE);
	_data_->_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
	spit_publishing_plugin_host_install_static_message_pane (_data_->_tmp1_, _ ("Verifying authorization…"), SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL);
	_data_->_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->session;
	_data_->_tmp3_ = _data_->self->priv->auth_cookie;
	_data_->_tmp4_ = publishing_authenticator_shotwell_flickr_access_token_fetch_transaction_new (_data_->_tmp2_, _data_->pin, _data_->_tmp3_);
	_data_->txn = _data_->_tmp4_;
	{
		_data_->_state_ = 1;
		publishing_rest_support_transaction_execute_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), publishing_authenticator_shotwell_flickr_flickr_do_verify_pin_ready, _data_);
		return FALSE;
		_state_1:
		publishing_rest_support_transaction_execute_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_debug ("FlickrPublishingAuthenticator.vala:167: EVENT: fetching OAuth access t" \
"oken over the network succeeded");
		_data_->_tmp5_ = publishing_rest_support_transaction_get_response (G_TYPE_CHECK_INSTANCE_CAST (_data_->txn, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
		_data_->_tmp6_ = _data_->_tmp5_;
		publishing_authenticator_shotwell_flickr_flickr_do_extract_access_phase_credentials_from_response (_data_->self, _data_->_tmp6_);
		_g_free0 (_data_->_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_debug ("FlickrPublishingAuthenticator.vala:171: EVENT: fetching OAuth access t" \
"oken over the network caused an error.");
		_data_->_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
		_data_->_tmp8_ = _data_->err;
		spit_publishing_plugin_host_post_error (_data_->_tmp7_, _data_->_tmp8_);
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, SPIT_PUBLISHING_TYPE_AUTHENTICATOR, SpitPublishingAuthenticator), "authentication-failed");
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_publishing_rest_support_transaction_unref0 (_data_->txn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_publishing_rest_support_transaction_unref0 (_data_->txn);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
publishing_authenticator_shotwell_flickr_flickr_do_extract_access_phase_credentials_from_response (PublishingAuthenticatorShotwellFlickrFlickr* self,
                                                                                                   const gchar* response)
{
	gchar* token = NULL;
	gchar* token_secret = NULL;
	gchar* username = NULL;
	GHashTable* data = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	gchar* _tmp6_;
	GHashTable* _tmp7_;
	gconstpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_IS_FLICKR (self));
	g_return_if_fail (response != NULL);
	g_debug ("FlickrPublishingAuthenticator.vala:179: ACTION: extracting access phas" \
"e credentials from '%s'", response);
	token = NULL;
	token_secret = NULL;
	username = NULL;
	_tmp0_ = soup_form_decode (response);
	data = _tmp0_;
	_tmp1_ = data;
	g_hash_table_lookup_extended (_tmp1_, "oauth_token", NULL, &_tmp2_);
	_g_free0 (token);
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	token = _tmp3_;
	_tmp4_ = data;
	g_hash_table_lookup_extended (_tmp4_, "oauth_token_secret", NULL, &_tmp5_);
	_g_free0 (token_secret);
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	token_secret = _tmp6_;
	_tmp7_ = data;
	g_hash_table_lookup_extended (_tmp7_, "username", NULL, &_tmp8_);
	_g_free0 (username);
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	username = _tmp9_;
	_tmp10_ = token;
	_tmp11_ = token_secret;
	_tmp12_ = username;
	g_debug ("FlickrPublishingAuthenticator.vala:190: access phase credentials: { to" \
"ken = '%s'; token_secret = '%s'; username = '%s' }", _tmp10_, _tmp11_, _tmp12_);
	_tmp15_ = token;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = token_secret;
		_tmp14_ = _tmp16_ == NULL;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp17_;
		_tmp17_ = username;
		_tmp13_ = _tmp17_ == NULL;
	}
	if (_tmp13_) {
		SpitPublishingPluginHost* _tmp18_;
		GError* _tmp19_;
		GError* _tmp20_;
		_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->host;
		_tmp19_ = g_error_new_literal (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE, "expected " "access phase credentials to contain token, token secret, and username " \
"but at " "least one of these is absent");
		_tmp20_ = _tmp19_;
		spit_publishing_plugin_host_post_error (_tmp18_, _tmp20_);
		_g_error_free0 (_tmp20_);
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, SPIT_PUBLISHING_TYPE_AUTHENTICATOR, SpitPublishingAuthenticator), "authentication-failed");
	} else {
		PublishingRESTSupportOAuth1Session* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator)->session;
		_tmp22_ = token;
		_tmp23_ = token_secret;
		_tmp24_ = username;
		publishing_rest_support_oauth1_session_set_access_phase_credentials (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
	}
	_g_hash_table_unref0 (data);
	_g_free0 (username);
	_g_free0 (token_secret);
	_g_free0 (token);
}

static void
publishing_authenticator_shotwell_flickr_flickr_auth_callback_real_authenticated (SpitPublishingAuthenticatedCallback* base,
                                                                                  GHashTable* params)
{
	PublishingAuthenticatorShotwellFlickrFlickrAuthCallback * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK, PublishingAuthenticatorShotwellFlickrFlickrAuthCallback);
	g_return_if_fail (params != NULL);
	g_signal_emit (self, publishing_authenticator_shotwell_flickr_flickr_auth_callback_signals[PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_AUTH_SIGNAL], 0, params);
}

static PublishingAuthenticatorShotwellFlickrFlickrAuthCallback*
publishing_authenticator_shotwell_flickr_flickr_auth_callback_construct (GType object_type)
{
	PublishingAuthenticatorShotwellFlickrFlickrAuthCallback * self = NULL;
	self = (PublishingAuthenticatorShotwellFlickrFlickrAuthCallback*) g_object_new (object_type, NULL);
	return self;
}

static PublishingAuthenticatorShotwellFlickrFlickrAuthCallback*
publishing_authenticator_shotwell_flickr_flickr_auth_callback_new (void)
{
	return publishing_authenticator_shotwell_flickr_flickr_auth_callback_construct (PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK);
}

static void
publishing_authenticator_shotwell_flickr_flickr_auth_callback_class_init (PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackClass * klass,
                                                                          gpointer klass_data)
{
	publishing_authenticator_shotwell_flickr_flickr_auth_callback_parent_class = g_type_class_peek_parent (klass);
	publishing_authenticator_shotwell_flickr_flickr_auth_callback_signals[PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_AUTH_CALLBACK_AUTH_SIGNAL] = g_signal_new ("auth", PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_FLICKR_TYPE_AUTH_CALLBACK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_HASH_TABLE);
}

static void
publishing_authenticator_shotwell_flickr_flickr_auth_callback_spit_publishing_authenticated_callback_interface_init (SpitPublishingAuthenticatedCallbackIface * iface,
                                                                                                                     gpointer iface_data)
{
	publishing_authenticator_shotwell_flickr_flickr_auth_callback_spit_publishing_authenticated_callback_parent_iface = g_type_interface_peek_parent (iface);
	iface->authenticated = (void (*) (SpitPublishingAuthenticatedCallback*, GHashTable*)) publishing_authenticator_shotwell_flickr_flickr_auth_callback_real_authenticated;
}

static void
publishing_authenticator_shotwell_flickr_flickr_auth_callback_instance_init (PublishingAuthenticatorShotwellFlickrFlickrAuthCallback * self,
                                                                             gpointer klass)
{
}

static GType
publishing_authenticator_shotwell_flickr_flickr_auth_callback_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingAuthenticatorShotwellFlickrFlickrAuthCallbackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_authenticator_shotwell_flickr_flickr_auth_callback_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingAuthenticatorShotwellFlickrFlickrAuthCallback), 0, (GInstanceInitFunc) publishing_authenticator_shotwell_flickr_flickr_auth_callback_instance_init, NULL };
	static const GInterfaceInfo spit_publishing_authenticated_callback_info = { (GInterfaceInitFunc) publishing_authenticator_shotwell_flickr_flickr_auth_callback_spit_publishing_authenticated_callback_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id;
	publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id = g_type_register_static (G_TYPE_OBJECT, "PublishingAuthenticatorShotwellFlickrFlickrAuthCallback", &g_define_type_info, 0);
	g_type_add_interface_static (publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id, SPIT_PUBLISHING_TYPE_AUTHENTICATED_CALLBACK, &spit_publishing_authenticated_callback_info);
	return publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id;
}

static GType
publishing_authenticator_shotwell_flickr_flickr_auth_callback_get_type (void)
{
	static volatile gsize publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id__once = 0;
	if (g_once_init_enter (&publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id__once)) {
		GType publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id;
		publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id = publishing_authenticator_shotwell_flickr_flickr_auth_callback_get_type_once ();
		g_once_init_leave (&publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id__once, publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id);
	}
	return publishing_authenticator_shotwell_flickr_flickr_auth_callback_type_id__once;
}

static void
publishing_authenticator_shotwell_flickr_flickr_class_init (PublishingAuthenticatorShotwellFlickrFlickrClass * klass,
                                                            gpointer klass_data)
{
	publishing_authenticator_shotwell_flickr_flickr_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PublishingAuthenticatorShotwellFlickrFlickr_private_offset);
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->authenticate = (void (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_flickr_flickr_real_authenticate;
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->can_logout = (gboolean (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_flickr_flickr_real_can_logout;
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->logout = (void (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_flickr_flickr_real_logout;
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->refresh = (void (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_flickr_flickr_real_refresh;
	G_OBJECT_CLASS (klass)->finalize = publishing_authenticator_shotwell_flickr_flickr_finalize;
}

static void
publishing_authenticator_shotwell_flickr_flickr_instance_init (PublishingAuthenticatorShotwellFlickrFlickr * self,
                                                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = publishing_authenticator_shotwell_flickr_flickr_get_instance_private (self);
	_tmp0_ = g_uuid_string_random ();
	self->priv->auth_cookie = _tmp0_;
}

static void
publishing_authenticator_shotwell_flickr_flickr_finalize (GObject * obj)
{
	PublishingAuthenticatorShotwellFlickrFlickr * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_AUTHENTICATOR_SHOTWELL_FLICKR_TYPE_FLICKR, PublishingAuthenticatorShotwellFlickrFlickr);
	_g_object_unref0 (self->priv->pane);
	_g_free0 (self->priv->auth_cookie);
	G_OBJECT_CLASS (publishing_authenticator_shotwell_flickr_flickr_parent_class)->finalize (obj);
}

static GType
publishing_authenticator_shotwell_flickr_flickr_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingAuthenticatorShotwellFlickrFlickrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_authenticator_shotwell_flickr_flickr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingAuthenticatorShotwellFlickrFlickr), 0, (GInstanceInitFunc) publishing_authenticator_shotwell_flickr_flickr_instance_init, NULL };
	GType publishing_authenticator_shotwell_flickr_flickr_type_id;
	publishing_authenticator_shotwell_flickr_flickr_type_id = g_type_register_static (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, "PublishingAuthenticatorShotwellFlickrFlickr", &g_define_type_info, 0);
	PublishingAuthenticatorShotwellFlickrFlickr_private_offset = g_type_add_instance_private (publishing_authenticator_shotwell_flickr_flickr_type_id, sizeof (PublishingAuthenticatorShotwellFlickrFlickrPrivate));
	return publishing_authenticator_shotwell_flickr_flickr_type_id;
}

GType
publishing_authenticator_shotwell_flickr_flickr_get_type (void)
{
	static volatile gsize publishing_authenticator_shotwell_flickr_flickr_type_id__once = 0;
	if (g_once_init_enter (&publishing_authenticator_shotwell_flickr_flickr_type_id__once)) {
		GType publishing_authenticator_shotwell_flickr_flickr_type_id;
		publishing_authenticator_shotwell_flickr_flickr_type_id = publishing_authenticator_shotwell_flickr_flickr_get_type_once ();
		g_once_init_leave (&publishing_authenticator_shotwell_flickr_flickr_type_id__once, publishing_authenticator_shotwell_flickr_flickr_type_id);
	}
	return publishing_authenticator_shotwell_flickr_flickr_type_id__once;
}

