/* seahorse-ssh.h generated by valac 0.56.7, the Vala compiler, do not modify */

#ifndef __SSH_SEAHORSE_SSH_H__
#define __SSH_SEAHORSE_SSH_H__

#include "seahorse-common.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gcr/gcr-base.h>
#include <gio/gio.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif
#define SEAHORSE_SSH_GENERATE_DEFAULT_DSA_SIZE 1024
#define SEAHORSE_SSH_GENERATE_DEFAULT_RSA_SIZE 2048
#define SEAHORSE_SSH_SEC_DATA_SSH_KEY_SECRET_SIG "# SSH PRIVATE KEY: "
#define SEAHORSE_SSH_SEC_DATA_SSH_PRIVATE_BEGIN "-----BEGIN "
#define SEAHORSE_SSH_SEC_DATA_SSH_PRIVATE_END "-----END "
#define SEAHORSE_SSH_KEY_SSH_IDENTIFIER_SIZE 8
#define SEAHORSE_SSH_SOURCE_AUTHORIZED_KEYS_FILE "authorized_keys"
#define SEAHORSE_SSH_SOURCE_OTHER_KEYS_FILE "other_keys.seahorse"
#define SEAHORSE_SSH_SEAHORSE_SSH_NAME "openssh"

#define SEAHORSE_SSH_TYPE_ACTIONS (seahorse_ssh_actions_get_type ())
#define SEAHORSE_SSH_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_ACTIONS, SeahorseSshActions))
#define SEAHORSE_SSH_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_ACTIONS, SeahorseSshActionsClass))
#define SEAHORSE_SSH_IS_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_ACTIONS))
#define SEAHORSE_SSH_IS_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_ACTIONS))
#define SEAHORSE_SSH_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_ACTIONS, SeahorseSshActionsClass))

typedef struct _SeahorseSshActions SeahorseSshActions;
typedef struct _SeahorseSshActionsClass SeahorseSshActionsClass;
typedef struct _SeahorseSshActionsPrivate SeahorseSshActionsPrivate;
typedef enum  {
	SEAHORSE_SSH_ALGORITHM_UNKNOWN,
	SEAHORSE_SSH_ALGORITHM_RSA,
	SEAHORSE_SSH_ALGORITHM_DSA,
	SEAHORSE_SSH_ALGORITHM_ECDSA,
	SEAHORSE_SSH_ALGORITHM_ED25519
} SeahorseSshAlgorithm;

#define SEAHORSE_SSH_TYPE_ALGORITHM (seahorse_ssh_algorithm_get_type ())

#define SEAHORSE_SSH_TYPE_BACKEND (seahorse_ssh_backend_get_type ())
#define SEAHORSE_SSH_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_BACKEND, SeahorseSshBackend))
#define SEAHORSE_SSH_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_BACKEND, SeahorseSshBackendClass))
#define SEAHORSE_SSH_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_BACKEND))
#define SEAHORSE_SSH_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_BACKEND))
#define SEAHORSE_SSH_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_BACKEND, SeahorseSshBackendClass))

typedef struct _SeahorseSshBackend SeahorseSshBackend;
typedef struct _SeahorseSshBackendClass SeahorseSshBackendClass;
typedef struct _SeahorseSshBackendPrivate SeahorseSshBackendPrivate;

#define SEAHORSE_SSH_TYPE_SOURCE (seahorse_ssh_source_get_type ())
#define SEAHORSE_SSH_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource))
#define SEAHORSE_SSH_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSourceClass))
#define SEAHORSE_SSH_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_SOURCE))
#define SEAHORSE_SSH_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_SOURCE))
#define SEAHORSE_SSH_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSourceClass))

typedef struct _SeahorseSshSource SeahorseSshSource;
typedef struct _SeahorseSshSourceClass SeahorseSshSourceClass;

#define SEAHORSE_SSH_TYPE_DELETER (seahorse_ssh_deleter_get_type ())
#define SEAHORSE_SSH_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_DELETER, SeahorseSshDeleter))
#define SEAHORSE_SSH_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_DELETER, SeahorseSshDeleterClass))
#define SEAHORSE_SSH_IS_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_DELETER))
#define SEAHORSE_SSH_IS_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_DELETER))
#define SEAHORSE_SSH_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_DELETER, SeahorseSshDeleterClass))

typedef struct _SeahorseSshDeleter SeahorseSshDeleter;
typedef struct _SeahorseSshDeleterClass SeahorseSshDeleterClass;
typedef struct _SeahorseSshDeleterPrivate SeahorseSshDeleterPrivate;

#define SEAHORSE_SSH_TYPE_KEY (seahorse_ssh_key_get_type ())
#define SEAHORSE_SSH_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_KEY, SeahorseSshKey))
#define SEAHORSE_SSH_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_KEY, SeahorseSshKeyClass))
#define SEAHORSE_SSH_IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_KEY))
#define SEAHORSE_SSH_IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_KEY))
#define SEAHORSE_SSH_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_KEY, SeahorseSshKeyClass))

typedef struct _SeahorseSshKey SeahorseSshKey;
typedef struct _SeahorseSshKeyClass SeahorseSshKeyClass;

#define SEAHORSE_SSH_TYPE_ERROR (seahorse_ssh_error_get_type ())

#define SEAHORSE_SSH_TYPE_EXPORTER (seahorse_ssh_exporter_get_type ())
#define SEAHORSE_SSH_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_EXPORTER, SeahorseSshExporter))
#define SEAHORSE_SSH_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_EXPORTER, SeahorseSshExporterClass))
#define SEAHORSE_SSH_IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_EXPORTER))
#define SEAHORSE_SSH_IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_EXPORTER))
#define SEAHORSE_SSH_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_EXPORTER, SeahorseSshExporterClass))

typedef struct _SeahorseSshExporter SeahorseSshExporter;
typedef struct _SeahorseSshExporterClass SeahorseSshExporterClass;
typedef struct _SeahorseSshExporterPrivate SeahorseSshExporterPrivate;

#define SEAHORSE_SSH_TYPE_GENERATE (seahorse_ssh_generate_get_type ())
#define SEAHORSE_SSH_GENERATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_GENERATE, SeahorseSshGenerate))
#define SEAHORSE_SSH_GENERATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_GENERATE, SeahorseSshGenerateClass))
#define SEAHORSE_SSH_IS_GENERATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_GENERATE))
#define SEAHORSE_SSH_IS_GENERATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_GENERATE))
#define SEAHORSE_SSH_GENERATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_GENERATE, SeahorseSshGenerateClass))

typedef struct _SeahorseSshGenerate SeahorseSshGenerate;
typedef struct _SeahorseSshGenerateClass SeahorseSshGenerateClass;
typedef struct _SeahorseSshGeneratePrivate SeahorseSshGeneratePrivate;

#define SEAHORSE_SSH_TYPE_KEY_DATA (seahorse_ssh_key_data_get_type ())
#define SEAHORSE_SSH_KEY_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_KEY_DATA, SeahorseSshKeyData))
#define SEAHORSE_SSH_KEY_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_KEY_DATA, SeahorseSshKeyDataClass))
#define SEAHORSE_SSH_IS_KEY_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_KEY_DATA))
#define SEAHORSE_SSH_IS_KEY_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_KEY_DATA))
#define SEAHORSE_SSH_KEY_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_KEY_DATA, SeahorseSshKeyDataClass))

typedef struct _SeahorseSshKeyData SeahorseSshKeyData;
typedef struct _SeahorseSshKeyDataClass SeahorseSshKeyDataClass;
typedef struct _SeahorseSshKeyDataPrivate SeahorseSshKeyDataPrivate;

#define SEAHORSE_SSH_TYPE_SEC_DATA (seahorse_ssh_sec_data_get_type ())
#define SEAHORSE_SSH_SEC_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_SEC_DATA, SeahorseSshSecData))
#define SEAHORSE_SSH_SEC_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_SEC_DATA, SeahorseSshSecDataClass))
#define SEAHORSE_SSH_IS_SEC_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_SEC_DATA))
#define SEAHORSE_SSH_IS_SEC_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_SEC_DATA))
#define SEAHORSE_SSH_SEC_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_SEC_DATA, SeahorseSshSecDataClass))

typedef struct _SeahorseSshSecData SeahorseSshSecData;
typedef struct _SeahorseSshSecDataClass SeahorseSshSecDataClass;
typedef struct _SeahorseSshSecDataPrivate SeahorseSshSecDataPrivate;

#define SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER (seahorse_ssh_key_length_chooser_get_type ())
#define SEAHORSE_SSH_KEY_LENGTH_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER, SeahorseSshKeyLengthChooser))
#define SEAHORSE_SSH_KEY_LENGTH_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER, SeahorseSshKeyLengthChooserClass))
#define SEAHORSE_SSH_IS_KEY_LENGTH_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER))
#define SEAHORSE_SSH_IS_KEY_LENGTH_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER))
#define SEAHORSE_SSH_KEY_LENGTH_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER, SeahorseSshKeyLengthChooserClass))

typedef struct _SeahorseSshKeyLengthChooser SeahorseSshKeyLengthChooser;
typedef struct _SeahorseSshKeyLengthChooserClass SeahorseSshKeyLengthChooserClass;
typedef struct _SeahorseSshKeyLengthChooserPrivate SeahorseSshKeyLengthChooserPrivate;

#define SEAHORSE_SSH_TYPE_KEY_PROPERTIES (seahorse_ssh_key_properties_get_type ())
#define SEAHORSE_SSH_KEY_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_KEY_PROPERTIES, SeahorseSshKeyProperties))
#define SEAHORSE_SSH_KEY_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_KEY_PROPERTIES, SeahorseSshKeyPropertiesClass))
#define SEAHORSE_SSH_IS_KEY_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_KEY_PROPERTIES))
#define SEAHORSE_SSH_IS_KEY_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_KEY_PROPERTIES))
#define SEAHORSE_SSH_KEY_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_KEY_PROPERTIES, SeahorseSshKeyPropertiesClass))

typedef struct _SeahorseSshKeyProperties SeahorseSshKeyProperties;
typedef struct _SeahorseSshKeyPropertiesClass SeahorseSshKeyPropertiesClass;
typedef struct _SeahorseSshKeyPropertiesPrivate SeahorseSshKeyPropertiesPrivate;
typedef struct _SeahorseSshKeyPrivate SeahorseSshKeyPrivate;

#define SEAHORSE_SSH_KEY_TYPE_KEY_PARSE_RESULT (seahorse_ssh_key_key_parse_result_get_type ())
typedef struct _SeahorseSshKeyKeyParseResult SeahorseSshKeyKeyParseResult;

#define SEAHORSE_SSH_TYPE_OPERATION (seahorse_ssh_operation_get_type ())
#define SEAHORSE_SSH_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_OPERATION, SeahorseSshOperation))
#define SEAHORSE_SSH_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_OPERATION, SeahorseSshOperationClass))
#define SEAHORSE_SSH_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_OPERATION))
#define SEAHORSE_SSH_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_OPERATION))
#define SEAHORSE_SSH_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_OPERATION, SeahorseSshOperationClass))

typedef struct _SeahorseSshOperation SeahorseSshOperation;
typedef struct _SeahorseSshOperationClass SeahorseSshOperationClass;
typedef struct _SeahorseSshOperationPrivate SeahorseSshOperationPrivate;

#define SEAHORSE_SSH_TYPE_UPLOAD_OPERATION (seahorse_ssh_upload_operation_get_type ())
#define SEAHORSE_SSH_UPLOAD_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_UPLOAD_OPERATION, SeahorseSshUploadOperation))
#define SEAHORSE_SSH_UPLOAD_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_UPLOAD_OPERATION, SeahorseSshUploadOperationClass))
#define SEAHORSE_SSH_IS_UPLOAD_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_UPLOAD_OPERATION))
#define SEAHORSE_SSH_IS_UPLOAD_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_UPLOAD_OPERATION))
#define SEAHORSE_SSH_UPLOAD_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_UPLOAD_OPERATION, SeahorseSshUploadOperationClass))

typedef struct _SeahorseSshUploadOperation SeahorseSshUploadOperation;
typedef struct _SeahorseSshUploadOperationClass SeahorseSshUploadOperationClass;
typedef struct _SeahorseSshUploadOperationPrivate SeahorseSshUploadOperationPrivate;

#define SEAHORSE_SSH_TYPE_CHANGE_PASSPHRASE_OPERATION (seahorse_ssh_change_passphrase_operation_get_type ())
#define SEAHORSE_SSH_CHANGE_PASSPHRASE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_CHANGE_PASSPHRASE_OPERATION, SeahorseSshChangePassphraseOperation))
#define SEAHORSE_SSH_CHANGE_PASSPHRASE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_CHANGE_PASSPHRASE_OPERATION, SeahorseSshChangePassphraseOperationClass))
#define SEAHORSE_SSH_IS_CHANGE_PASSPHRASE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_CHANGE_PASSPHRASE_OPERATION))
#define SEAHORSE_SSH_IS_CHANGE_PASSPHRASE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_CHANGE_PASSPHRASE_OPERATION))
#define SEAHORSE_SSH_CHANGE_PASSPHRASE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_CHANGE_PASSPHRASE_OPERATION, SeahorseSshChangePassphraseOperationClass))

typedef struct _SeahorseSshChangePassphraseOperation SeahorseSshChangePassphraseOperation;
typedef struct _SeahorseSshChangePassphraseOperationClass SeahorseSshChangePassphraseOperationClass;
typedef struct _SeahorseSshChangePassphraseOperationPrivate SeahorseSshChangePassphraseOperationPrivate;

#define SEAHORSE_SSH_TYPE_GENERATE_OPERATION (seahorse_ssh_generate_operation_get_type ())
#define SEAHORSE_SSH_GENERATE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_GENERATE_OPERATION, SeahorseSshGenerateOperation))
#define SEAHORSE_SSH_GENERATE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_GENERATE_OPERATION, SeahorseSshGenerateOperationClass))
#define SEAHORSE_SSH_IS_GENERATE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_GENERATE_OPERATION))
#define SEAHORSE_SSH_IS_GENERATE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_GENERATE_OPERATION))
#define SEAHORSE_SSH_GENERATE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_GENERATE_OPERATION, SeahorseSshGenerateOperationClass))

typedef struct _SeahorseSshGenerateOperation SeahorseSshGenerateOperation;
typedef struct _SeahorseSshGenerateOperationClass SeahorseSshGenerateOperationClass;
typedef struct _SeahorseSshGenerateOperationPrivate SeahorseSshGenerateOperationPrivate;

#define SEAHORSE_SSH_TYPE_PRIVATE_IMPORT_OPERATION (seahorse_ssh_private_import_operation_get_type ())
#define SEAHORSE_SSH_PRIVATE_IMPORT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_PRIVATE_IMPORT_OPERATION, SeahorseSshPrivateImportOperation))
#define SEAHORSE_SSH_PRIVATE_IMPORT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_PRIVATE_IMPORT_OPERATION, SeahorseSshPrivateImportOperationClass))
#define SEAHORSE_SSH_IS_PRIVATE_IMPORT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_PRIVATE_IMPORT_OPERATION))
#define SEAHORSE_SSH_IS_PRIVATE_IMPORT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_PRIVATE_IMPORT_OPERATION))
#define SEAHORSE_SSH_PRIVATE_IMPORT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_PRIVATE_IMPORT_OPERATION, SeahorseSshPrivateImportOperationClass))

typedef struct _SeahorseSshPrivateImportOperation SeahorseSshPrivateImportOperation;
typedef struct _SeahorseSshPrivateImportOperationClass SeahorseSshPrivateImportOperationClass;
typedef struct _SeahorseSshPrivateImportOperationPrivate SeahorseSshPrivateImportOperationPrivate;

#define SEAHORSE_SSH_TYPE_RENAME_OPERATION (seahorse_ssh_rename_operation_get_type ())
#define SEAHORSE_SSH_RENAME_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_RENAME_OPERATION, SeahorseSshRenameOperation))
#define SEAHORSE_SSH_RENAME_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_RENAME_OPERATION, SeahorseSshRenameOperationClass))
#define SEAHORSE_SSH_IS_RENAME_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_RENAME_OPERATION))
#define SEAHORSE_SSH_IS_RENAME_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_RENAME_OPERATION))
#define SEAHORSE_SSH_RENAME_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_RENAME_OPERATION, SeahorseSshRenameOperationClass))

typedef struct _SeahorseSshRenameOperation SeahorseSshRenameOperation;
typedef struct _SeahorseSshRenameOperationClass SeahorseSshRenameOperationClass;
typedef struct _SeahorseSshRenameOperationPrivate SeahorseSshRenameOperationPrivate;
typedef struct _SeahorseSshSourcePrivate SeahorseSshSourcePrivate;

#define SEAHORSE_SSH_TYPE_UPLOAD (seahorse_ssh_upload_get_type ())
#define SEAHORSE_SSH_UPLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_SSH_TYPE_UPLOAD, SeahorseSshUpload))
#define SEAHORSE_SSH_UPLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_SSH_TYPE_UPLOAD, SeahorseSshUploadClass))
#define SEAHORSE_SSH_IS_UPLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_SSH_TYPE_UPLOAD))
#define SEAHORSE_SSH_IS_UPLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_SSH_TYPE_UPLOAD))
#define SEAHORSE_SSH_UPLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_SSH_TYPE_UPLOAD, SeahorseSshUploadClass))

typedef struct _SeahorseSshUpload SeahorseSshUpload;
typedef struct _SeahorseSshUploadClass SeahorseSshUploadClass;
typedef struct _SeahorseSshUploadPrivate SeahorseSshUploadPrivate;

struct _SeahorseSshActions {
	SeahorseActionGroup parent_instance;
	SeahorseSshActionsPrivate * priv;
};

struct _SeahorseSshActionsClass {
	SeahorseActionGroupClass parent_class;
};

struct _SeahorseSshBackend {
	GObject parent_instance;
	SeahorseSshBackendPrivate * priv;
};

struct _SeahorseSshBackendClass {
	GObjectClass parent_class;
};

struct _SeahorseSshDeleter {
	SeahorseDeleter parent_instance;
	SeahorseSshDeleterPrivate * priv;
};

struct _SeahorseSshDeleterClass {
	SeahorseDeleterClass parent_class;
};

typedef enum  {
	SEAHORSE_SSH_ERROR_GENERAL
} SeahorseSshError;
#define SEAHORSE_SSH_ERROR seahorse_ssh_error_quark ()

struct _SeahorseSshExporter {
	GObject parent_instance;
	SeahorseSshExporterPrivate * priv;
};

struct _SeahorseSshExporterClass {
	GObjectClass parent_class;
};

struct _SeahorseSshGenerate {
	GtkDialog parent_instance;
	SeahorseSshGeneratePrivate * priv;
};

struct _SeahorseSshGenerateClass {
	GtkDialogClass parent_class;
};

struct _SeahorseSshKeyData {
	GObject parent_instance;
	SeahorseSshKeyDataPrivate * priv;
};

struct _SeahorseSshKeyDataClass {
	GObjectClass parent_class;
};

struct _SeahorseSshSecData {
	GObject parent_instance;
	SeahorseSshSecDataPrivate * priv;
};

struct _SeahorseSshSecDataClass {
	GObjectClass parent_class;
};

struct _SeahorseSshKeyLengthChooser {
	GtkStack parent_instance;
	SeahorseSshKeyLengthChooserPrivate * priv;
};

struct _SeahorseSshKeyLengthChooserClass {
	GtkStackClass parent_class;
};

struct _SeahorseSshKeyProperties {
	GtkDialog parent_instance;
	SeahorseSshKeyPropertiesPrivate * priv;
};

struct _SeahorseSshKeyPropertiesClass {
	GtkDialogClass parent_class;
};

struct _SeahorseSshKey {
	SeahorseObject parent_instance;
	SeahorseSshKeyPrivate * priv;
};

struct _SeahorseSshKeyClass {
	SeahorseObjectClass parent_class;
};

struct _SeahorseSshKeyKeyParseResult {
	SeahorseSshKeyData** public_keys;
	gint public_keys_length1;
	SeahorseSshSecData** secret_keys;
	gint secret_keys_length1;
};

struct _SeahorseSshOperation {
	GObject parent_instance;
	SeahorseSshOperationPrivate * priv;
	gchar* prompt_title;
	gchar* prompt_message;
	gchar* prompt_argument;
	gulong prompt_transient_for;
};

struct _SeahorseSshOperationClass {
	GObjectClass parent_class;
};

struct _SeahorseSshUploadOperation {
	SeahorseSshOperation parent_instance;
	SeahorseSshUploadOperationPrivate * priv;
};

struct _SeahorseSshUploadOperationClass {
	SeahorseSshOperationClass parent_class;
};

struct _SeahorseSshChangePassphraseOperation {
	SeahorseSshOperation parent_instance;
	SeahorseSshChangePassphraseOperationPrivate * priv;
};

struct _SeahorseSshChangePassphraseOperationClass {
	SeahorseSshOperationClass parent_class;
};

struct _SeahorseSshGenerateOperation {
	SeahorseSshOperation parent_instance;
	SeahorseSshGenerateOperationPrivate * priv;
};

struct _SeahorseSshGenerateOperationClass {
	SeahorseSshOperationClass parent_class;
};

struct _SeahorseSshPrivateImportOperation {
	SeahorseSshOperation parent_instance;
	SeahorseSshPrivateImportOperationPrivate * priv;
};

struct _SeahorseSshPrivateImportOperationClass {
	SeahorseSshOperationClass parent_class;
};

struct _SeahorseSshRenameOperation {
	SeahorseSshOperation parent_instance;
	SeahorseSshRenameOperationPrivate * priv;
};

struct _SeahorseSshRenameOperationClass {
	SeahorseSshOperationClass parent_class;
};

struct _SeahorseSshSource {
	GObject parent_instance;
	SeahorseSshSourcePrivate * priv;
};

struct _SeahorseSshSourceClass {
	GObjectClass parent_class;
};

struct _SeahorseSshUpload {
	GtkDialog parent_instance;
	SeahorseSshUploadPrivate * priv;
};

struct _SeahorseSshUploadClass {
	GtkDialogClass parent_class;
};

VALA_EXTERN GType seahorse_ssh_actions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshActions, g_object_unref)
VALA_EXTERN SeahorseSshActions* seahorse_ssh_actions_instance (void);
VALA_EXTERN GType seahorse_ssh_algorithm_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* seahorse_ssh_algorithm_to_string (SeahorseSshAlgorithm self);
VALA_EXTERN SeahorseSshAlgorithm seahorse_ssh_algorithm_from_string (const gchar* type);
VALA_EXTERN SeahorseSshAlgorithm seahorse_ssh_algorithm_guess_from_string (const gchar* str);
VALA_EXTERN GType seahorse_ssh_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshBackend, g_object_unref)
VALA_EXTERN SeahorseSshBackend* seahorse_ssh_backend_new (void);
VALA_EXTERN SeahorseSshBackend* seahorse_ssh_backend_construct (GType object_type);
VALA_EXTERN void seahorse_ssh_backend_initialize (void);
VALA_EXTERN GType seahorse_ssh_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshSource, g_object_unref)
VALA_EXTERN SeahorseSshSource* seahorse_ssh_backend_get_dot_ssh (SeahorseSshBackend* self);
VALA_EXTERN SeahorseSshBackend* seahorse_ssh_backend_get_instance (void);
VALA_EXTERN GType seahorse_ssh_deleter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshDeleter, g_object_unref)
VALA_EXTERN GType seahorse_ssh_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshKey, g_object_unref)
VALA_EXTERN SeahorseSshDeleter* seahorse_ssh_deleter_new (SeahorseSshKey* key);
VALA_EXTERN SeahorseSshDeleter* seahorse_ssh_deleter_construct (GType object_type,
                                                    SeahorseSshKey* key);
VALA_EXTERN void seahorse_ssh_deleter_delete_key (SeahorseSshDeleter* self,
                                      SeahorseSshKey* key,
                                      GError** error);
VALA_EXTERN GQuark seahorse_ssh_error_quark (void);
GType seahorse_ssh_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType seahorse_ssh_exporter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshExporter, g_object_unref)
VALA_EXTERN SeahorseSshExporter* seahorse_ssh_exporter_new (SeahorseSshKey* key,
                                                gboolean secret);
VALA_EXTERN SeahorseSshExporter* seahorse_ssh_exporter_construct (GType object_type,
                                                      SeahorseSshKey* key,
                                                      gboolean secret);
VALA_EXTERN gboolean seahorse_ssh_exporter_get_secret (SeahorseSshExporter* self);
VALA_EXTERN void seahorse_ssh_exporter_set_secret (SeahorseSshExporter* self,
                                       gboolean value);
VALA_EXTERN GType seahorse_ssh_generate_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshGenerate, g_object_unref)
VALA_EXTERN SeahorseSshGenerate* seahorse_ssh_generate_new (SeahorseSshSource* src,
                                                GtkWindow* parent);
VALA_EXTERN SeahorseSshGenerate* seahorse_ssh_generate_construct (GType object_type,
                                                      SeahorseSshSource* src,
                                                      GtkWindow* parent);
VALA_EXTERN void seahorse_ssh_generate_generate_key (SeahorseSshGenerate* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void seahorse_ssh_generate_generate_key_finish (SeahorseSshGenerate* self,
                                                GAsyncResult* _res_);
VALA_EXTERN SeahorseSshSource* seahorse_ssh_generate_get_source (SeahorseSshGenerate* self);
VALA_EXTERN void seahorse_ssh_generate_set_source (SeahorseSshGenerate* self,
                                       SeahorseSshSource* value);
VALA_EXTERN GType seahorse_ssh_key_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshKeyData, g_object_unref)
VALA_EXTERN gboolean seahorse_ssh_key_data_is_valid (SeahorseSshKeyData* self);
VALA_EXTERN gboolean seahorse_ssh_key_data_match (SeahorseSshKeyData* self,
                                      const gchar* line);
VALA_EXTERN SeahorseSshKeyData* seahorse_ssh_key_data_parse_line (const gchar* line,
                                                      GError** error);
VALA_EXTERN void seahorse_ssh_key_data_filter_file (const gchar* filename,
                                        SeahorseSshKeyData* add,
                                        SeahorseSshKeyData* remove,
                                        GError** error);
VALA_EXTERN gchar* seahorse_ssh_key_data_get_location (SeahorseSshKeyData* self);
VALA_EXTERN SeahorseSshKeyData* seahorse_ssh_key_data_new (void);
VALA_EXTERN SeahorseSshKeyData* seahorse_ssh_key_data_construct (GType object_type);
VALA_EXTERN const gchar* seahorse_ssh_key_data_get_privfile (SeahorseSshKeyData* self);
VALA_EXTERN void seahorse_ssh_key_data_set_privfile (SeahorseSshKeyData* self,
                                         const gchar* value);
VALA_EXTERN const gchar* seahorse_ssh_key_data_get_pubfile (SeahorseSshKeyData* self);
VALA_EXTERN void seahorse_ssh_key_data_set_pubfile (SeahorseSshKeyData* self,
                                        const gchar* value);
VALA_EXTERN gboolean seahorse_ssh_key_data_get_partial (SeahorseSshKeyData* self);
VALA_EXTERN void seahorse_ssh_key_data_set_partial (SeahorseSshKeyData* self,
                                        gboolean value);
VALA_EXTERN gboolean seahorse_ssh_key_data_get_authorized (SeahorseSshKeyData* self);
VALA_EXTERN void seahorse_ssh_key_data_set_authorized (SeahorseSshKeyData* self,
                                           gboolean value);
VALA_EXTERN const gchar* seahorse_ssh_key_data_get_rawdata (SeahorseSshKeyData* self);
VALA_EXTERN const gchar* seahorse_ssh_key_data_get_comment (SeahorseSshKeyData* self);
VALA_EXTERN const gchar* seahorse_ssh_key_data_get_fingerprint (SeahorseSshKeyData* self);
VALA_EXTERN guint seahorse_ssh_key_data_get_length (SeahorseSshKeyData* self);
VALA_EXTERN SeahorseSshAlgorithm seahorse_ssh_key_data_get_algo (SeahorseSshKeyData* self);
VALA_EXTERN GType seahorse_ssh_sec_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshSecData, g_object_unref)
VALA_EXTERN gboolean seahorse_ssh_sec_data_contains_private_key (const gchar* data);
VALA_EXTERN SeahorseSshSecData* seahorse_ssh_sec_data_parse_data (GString* data,
                                                      GError** error);
VALA_EXTERN SeahorseSshSecData* seahorse_ssh_sec_data_new (void);
VALA_EXTERN SeahorseSshSecData* seahorse_ssh_sec_data_construct (GType object_type);
VALA_EXTERN const gchar* seahorse_ssh_sec_data_get_rawdata (SeahorseSshSecData* self);
VALA_EXTERN const gchar* seahorse_ssh_sec_data_get_comment (SeahorseSshSecData* self);
VALA_EXTERN SeahorseSshAlgorithm seahorse_ssh_sec_data_get_algo (SeahorseSshSecData* self);
VALA_EXTERN GType seahorse_ssh_key_length_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshKeyLengthChooser, g_object_unref)
VALA_EXTERN SeahorseSshKeyLengthChooser* seahorse_ssh_key_length_chooser_new (SeahorseSshAlgorithm algo);
VALA_EXTERN SeahorseSshKeyLengthChooser* seahorse_ssh_key_length_chooser_construct (GType object_type,
                                                                        SeahorseSshAlgorithm algo);
VALA_EXTERN gint seahorse_ssh_key_length_chooser_get_length (SeahorseSshKeyLengthChooser* self);
VALA_EXTERN SeahorseSshAlgorithm seahorse_ssh_key_length_chooser_get_algorithm (SeahorseSshKeyLengthChooser* self);
VALA_EXTERN void seahorse_ssh_key_length_chooser_set_algorithm (SeahorseSshKeyLengthChooser* self,
                                                    SeahorseSshAlgorithm value);
VALA_EXTERN GType seahorse_ssh_key_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshKeyProperties, g_object_unref)
VALA_EXTERN SeahorseSshKeyProperties* seahorse_ssh_key_properties_new (SeahorseSshKey* key,
                                                           GtkWindow* parent);
VALA_EXTERN SeahorseSshKeyProperties* seahorse_ssh_key_properties_construct (GType object_type,
                                                                 SeahorseSshKey* key,
                                                                 GtkWindow* parent);
VALA_EXTERN void seahorse_ssh_key_properties_on_ssh_comment_activate (SeahorseSshKeyProperties* self,
                                                          GtkEntry* entry);
VALA_EXTERN SeahorseSshKey* seahorse_ssh_key_new (SeahorseSshSource* source,
                                      SeahorseSshKeyData* key_data);
VALA_EXTERN SeahorseSshKey* seahorse_ssh_key_construct (GType object_type,
                                            SeahorseSshSource* source,
                                            SeahorseSshKeyData* key_data);
VALA_EXTERN void seahorse_ssh_key_refresh (SeahorseSshKey* self);
VALA_EXTERN SeahorseSshAlgorithm seahorse_ssh_key_get_algo (SeahorseSshKey* self);
VALA_EXTERN gchar* seahorse_ssh_key_get_location (SeahorseSshKey* self);
VALA_EXTERN guint seahorse_ssh_key_get_strength (SeahorseSshKey* self);
VALA_EXTERN gchar* seahorse_ssh_key_calc_identifier (const gchar* id);
VALA_EXTERN void seahorse_ssh_key_merge_keydata (SeahorseSshKey* self,
                                     SeahorseSshKeyData* keydata);
VALA_EXTERN void seahorse_ssh_key_parse (const gchar* data,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN GType seahorse_ssh_key_key_parse_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SeahorseSshKeyKeyParseResult* seahorse_ssh_key_key_parse_result_dup (const SeahorseSshKeyKeyParseResult* self);
VALA_EXTERN void seahorse_ssh_key_key_parse_result_free (SeahorseSshKeyKeyParseResult* self);
VALA_EXTERN void seahorse_ssh_key_key_parse_result_copy (const SeahorseSshKeyKeyParseResult* self,
                                             SeahorseSshKeyKeyParseResult* dest);
VALA_EXTERN void seahorse_ssh_key_key_parse_result_destroy (SeahorseSshKeyKeyParseResult* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SeahorseSshKeyKeyParseResult, seahorse_ssh_key_key_parse_result_destroy)
VALA_EXTERN void seahorse_ssh_key_parse_finish (GAsyncResult* _res_,
                                    SeahorseSshKeyKeyParseResult* result,
                                    GError** error);
VALA_EXTERN void seahorse_ssh_key_parse_file (const gchar* filename,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void seahorse_ssh_key_parse_file_finish (GAsyncResult* _res_,
                                         SeahorseSshKeyKeyParseResult* result,
                                         GError** error);
VALA_EXTERN SeahorseSshKeyData* seahorse_ssh_key_get_key_data (SeahorseSshKey* self);
VALA_EXTERN void seahorse_ssh_key_set_key_data (SeahorseSshKey* self,
                                    SeahorseSshKeyData* value);
VALA_EXTERN const gchar* seahorse_ssh_key_get_fingerprint (SeahorseSshKey* self);
VALA_EXTERN const gchar* seahorse_ssh_key_get_pubkey (SeahorseSshKey* self);
VALA_EXTERN const gchar* seahorse_ssh_key_get_description (SeahorseSshKey* self);
VALA_EXTERN SeahorseValidity seahorse_ssh_key_get_validity (SeahorseSshKey* self);
VALA_EXTERN SeahorseValidity seahorse_ssh_key_get_trust (SeahorseSshKey* self);
VALA_EXTERN gulong seahorse_ssh_key_get_expires (SeahorseSshKey* self);
VALA_EXTERN guint seahorse_ssh_key_get_length (SeahorseSshKey* self);
VALA_EXTERN GType seahorse_ssh_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshOperation, g_object_unref)
VALA_EXTERN void seahorse_ssh_operation_operation_async (SeahorseSshOperation* self,
                                             const gchar* command,
                                             const gchar* input,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN gchar* seahorse_ssh_operation_operation_finish (SeahorseSshOperation* self,
                                                GAsyncResult* _res_,
                                                GError** error);
VALA_EXTERN SeahorseSshOperation* seahorse_ssh_operation_construct (GType object_type);
VALA_EXTERN GType seahorse_ssh_upload_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshUploadOperation, g_object_unref)
VALA_EXTERN void seahorse_ssh_upload_operation_upload_async (SeahorseSshUploadOperation* self,
                                                 GList* keys,
                                                 const gchar* username,
                                                 const gchar* hostname,
                                                 const gchar* port,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void seahorse_ssh_upload_operation_upload_finish (SeahorseSshUploadOperation* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
VALA_EXTERN SeahorseSshUploadOperation* seahorse_ssh_upload_operation_new (void);
VALA_EXTERN SeahorseSshUploadOperation* seahorse_ssh_upload_operation_construct (GType object_type);
VALA_EXTERN GType seahorse_ssh_change_passphrase_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshChangePassphraseOperation, g_object_unref)
VALA_EXTERN void seahorse_ssh_change_passphrase_operation_change_passphrase_async (SeahorseSshChangePassphraseOperation* self,
                                                                       SeahorseSshKey* key,
                                                                       GCancellable* cancellable,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_);
VALA_EXTERN void seahorse_ssh_change_passphrase_operation_change_passphrase_finish (SeahorseSshChangePassphraseOperation* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error);
VALA_EXTERN SeahorseSshChangePassphraseOperation* seahorse_ssh_change_passphrase_operation_new (void);
VALA_EXTERN SeahorseSshChangePassphraseOperation* seahorse_ssh_change_passphrase_operation_construct (GType object_type);
VALA_EXTERN GType seahorse_ssh_generate_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshGenerateOperation, g_object_unref)
VALA_EXTERN void seahorse_ssh_generate_operation_generate_async (SeahorseSshGenerateOperation* self,
                                                     const gchar* filename,
                                                     const gchar* email,
                                                     SeahorseSshAlgorithm type,
                                                     guint bits,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void seahorse_ssh_generate_operation_generate_finish (SeahorseSshGenerateOperation* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
VALA_EXTERN SeahorseSshGenerateOperation* seahorse_ssh_generate_operation_new (void);
VALA_EXTERN SeahorseSshGenerateOperation* seahorse_ssh_generate_operation_construct (GType object_type);
VALA_EXTERN GType seahorse_ssh_private_import_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshPrivateImportOperation, g_object_unref)
VALA_EXTERN void seahorse_ssh_private_import_operation_import_private_async (SeahorseSshPrivateImportOperation* self,
                                                                 SeahorseSshSource* source,
                                                                 SeahorseSshSecData* data,
                                                                 const gchar* filename,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
VALA_EXTERN gchar* seahorse_ssh_private_import_operation_import_private_finish (SeahorseSshPrivateImportOperation* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
VALA_EXTERN SeahorseSshPrivateImportOperation* seahorse_ssh_private_import_operation_new (void);
VALA_EXTERN SeahorseSshPrivateImportOperation* seahorse_ssh_private_import_operation_construct (GType object_type);
VALA_EXTERN GType seahorse_ssh_rename_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshRenameOperation, g_object_unref)
VALA_EXTERN void seahorse_ssh_rename_operation_rename_async (SeahorseSshRenameOperation* self,
                                                 SeahorseSshKey* key,
                                                 const gchar* new_comment,
                                                 GtkWindow* transient_for,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void seahorse_ssh_rename_operation_rename_finish (SeahorseSshRenameOperation* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
VALA_EXTERN SeahorseSshRenameOperation* seahorse_ssh_rename_operation_new (void);
VALA_EXTERN SeahorseSshRenameOperation* seahorse_ssh_rename_operation_construct (GType object_type);
VALA_EXTERN void seahorse_ssh_source_remove_object (SeahorseSshSource* self,
                                        GObject* object);
VALA_EXTERN gchar* seahorse_ssh_source_authorized_keys_path (SeahorseSshSource* self);
VALA_EXTERN gchar* seahorse_ssh_source_other_keys_path (SeahorseSshSource* self);
VALA_EXTERN void seahorse_ssh_source_add_key_from_filename (SeahorseSshSource* self,
                                                const gchar* privfile,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN SeahorseSshKey* seahorse_ssh_source_add_key_from_filename_finish (SeahorseSshSource* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
VALA_EXTERN gchar* seahorse_ssh_source_export_private (SeahorseSshSource* self,
                                           SeahorseSshKey* key,
                                           GError** error);
VALA_EXTERN SeahorseSshKey* seahorse_ssh_source_add_key_from_parsed_data (SeahorseSshSource* src,
                                                              SeahorseSshKeyData* keydata,
                                                              const gchar* pubfile,
                                                              gboolean partial,
                                                              gboolean authorized,
                                                              const gchar* privfile);
VALA_EXTERN void seahorse_ssh_source_import_async (SeahorseSshSource* self,
                                       GInputStream* input,
                                       GtkWindow* transient_for,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN GList* seahorse_ssh_source_import_finish (SeahorseSshSource* self,
                                          GAsyncResult* _res_,
                                          GError** error);
VALA_EXTERN void seahorse_ssh_source_import_public_async (SeahorseSshSource* self,
                                              SeahorseSshKeyData* data,
                                              const gchar* filename,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN gchar* seahorse_ssh_source_import_public_finish (SeahorseSshSource* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
VALA_EXTERN gchar* seahorse_ssh_source_new_filename_for_algorithm (SeahorseSshSource* self,
                                                       SeahorseSshAlgorithm algo);
VALA_EXTERN void seahorse_ssh_source_authorize_async (SeahorseSshSource* self,
                                          SeahorseSshKey* key,
                                          gboolean authorize,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void seahorse_ssh_source_authorize_finish (SeahorseSshSource* self,
                                           GAsyncResult* _res_,
                                           GError** error);
VALA_EXTERN SeahorseSshKey* seahorse_ssh_source_find_key_by_fingerprint (SeahorseSshSource* self,
                                                             const gchar* fingerprint);
VALA_EXTERN SeahorseSshSource* seahorse_ssh_source_new (void);
VALA_EXTERN SeahorseSshSource* seahorse_ssh_source_construct (GType object_type);
VALA_EXTERN const gchar* seahorse_ssh_source_get_base_directory (SeahorseSshSource* self);
VALA_EXTERN GType seahorse_ssh_upload_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSshUpload, g_object_unref)
VALA_EXTERN SeahorseSshUpload* seahorse_ssh_upload_new (GList* keys,
                                            GtkWindow* parent);
VALA_EXTERN SeahorseSshUpload* seahorse_ssh_upload_construct (GType object_type,
                                                  GList* keys,
                                                  GtkWindow* parent);
VALA_EXTERN void seahorse_ssh_upload_prompt (GList* keys,
                                 GtkWindow* parent);

G_END_DECLS

#endif
