/* backend.c generated by valac 0.56.7, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <glib.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gcr/gcr-base.h>

enum  {
	SEAHORSE_SSH_BACKEND_0_PROPERTY,
	SEAHORSE_SSH_BACKEND_NAME_PROPERTY,
	SEAHORSE_SSH_BACKEND_LABEL_PROPERTY,
	SEAHORSE_SSH_BACKEND_DESCRIPTION_PROPERTY,
	SEAHORSE_SSH_BACKEND_ACTIONS_PROPERTY,
	SEAHORSE_SSH_BACKEND_LOADED_PROPERTY,
	SEAHORSE_SSH_BACKEND_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_backend_properties[SEAHORSE_SSH_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SeahorseSshBackendPrivate {
	SeahorseSshSource* dot_ssh;
	gboolean _loaded;
};

static gint SeahorseSshBackend_private_offset;
static gpointer seahorse_ssh_backend_parent_class = NULL;
static SeahorseSshBackend* seahorse_ssh_backend__instance;
static SeahorseSshBackend* seahorse_ssh_backend__instance = NULL;
static GcrCollectionIface * seahorse_ssh_backend_gcr_collection_parent_iface = NULL;
static SeahorseBackendIface * seahorse_ssh_backend_seahorse_backend_parent_iface = NULL;

static guint seahorse_ssh_backend_real_get_length (GcrCollection* base);
static GList* seahorse_ssh_backend_real_get_objects (GcrCollection* base);
static gboolean seahorse_ssh_backend_real_contains (GcrCollection* base,
                                             GObject* object);
static SeahorsePlace* seahorse_ssh_backend_real_lookup_place (SeahorseBackend* base,
                                                       const gchar* uri);
VALA_EXTERN void seahorse_ssh_backend_set_instance (SeahorseSshBackend* value);
static GObject * seahorse_ssh_backend_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _seahorse_ssh_backend___lambda12_ (SeahorseSshBackend* self,
                                        GObject* obj,
                                        GAsyncResult* res);
static void __seahorse_ssh_backend___lambda12__gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self);
static void seahorse_ssh_backend_finalize (GObject * obj);
static GType seahorse_ssh_backend_get_type_once (void);
static void _vala_seahorse_ssh_backend_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_seahorse_ssh_backend_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
seahorse_ssh_backend_get_instance_private (SeahorseSshBackend* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshBackend_private_offset);
}

SeahorseSshBackend*
seahorse_ssh_backend_construct (GType object_type)
{
	SeahorseSshBackend * self = NULL;
	self = (SeahorseSshBackend*) g_object_new (object_type, NULL);
	seahorse_backend_register ((SeahorseBackend*) self);
	return self;
}

SeahorseSshBackend*
seahorse_ssh_backend_new (void)
{
	return seahorse_ssh_backend_construct (SEAHORSE_SSH_TYPE_BACKEND);
}

static guint
seahorse_ssh_backend_real_get_length (GcrCollection* base)
{
	SeahorseSshBackend * self;
	guint result;
	self = (SeahorseSshBackend*) base;
	result = (guint) 1;
	return result;
}

static GList*
seahorse_ssh_backend_real_get_objects (GcrCollection* base)
{
	SeahorseSshBackend * self;
	GList* list = NULL;
	SeahorseSshSource* _tmp0_;
	GList* result;
	self = (SeahorseSshBackend*) base;
	list = NULL;
	_tmp0_ = self->priv->dot_ssh;
	list = g_list_append (list, (GObject*) _tmp0_);
	result = list;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
seahorse_ssh_backend_real_contains (GcrCollection* base,
                                    GObject* object)
{
	SeahorseSshBackend * self;
	SeahorseSshSource* src = NULL;
	SeahorseSshSource* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SeahorseSshSource* _tmp2_;
	gboolean result;
	self = (SeahorseSshBackend*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (SEAHORSE_SSH_IS_SOURCE (object) ? ((SeahorseSshSource*) object) : NULL);
	src = _tmp0_;
	_tmp2_ = src;
	if (_tmp2_ != NULL) {
		SeahorseSshSource* _tmp3_;
		SeahorseSshSource* _tmp4_;
		_tmp3_ = self->priv->dot_ssh;
		_tmp4_ = src;
		_tmp1_ = _tmp3_ == _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (src);
	return result;
}

static SeahorsePlace*
seahorse_ssh_backend_real_lookup_place (SeahorseBackend* base,
                                        const gchar* uri)
{
	SeahorseSshBackend * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	SeahorseSshSource* _tmp2_;
	SeahorsePlace* result;
	self = (SeahorseSshBackend*) base;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp2_ = self->priv->dot_ssh;
	if (_tmp2_ != NULL) {
		SeahorseSshSource* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = self->priv->dot_ssh;
		_tmp4_ = seahorse_place_get_uri ((SeahorsePlace*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != NULL;
		_g_free0 (_tmp6_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		SeahorseSshSource* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = self->priv->dot_ssh;
		_tmp8_ = seahorse_place_get_uri ((SeahorsePlace*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp0_ = g_strcmp0 (_tmp10_, uri) == 0;
		_g_free0 (_tmp10_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SeahorseSshSource* _tmp11_;
		SeahorsePlace* _tmp12_;
		_tmp11_ = self->priv->dot_ssh;
		_tmp12_ = _g_object_ref0 ((SeahorsePlace*) _tmp11_);
		result = _tmp12_;
		return result;
	}
	result = NULL;
	return result;
}

void
seahorse_ssh_backend_initialize (void)
{
	SeahorseSshBackend* _tmp0_;
	SeahorseSshBackend* _tmp1_;
	_tmp0_ = seahorse_ssh_backend_new ();
	_tmp1_ = _tmp0_;
	seahorse_ssh_backend_set_instance (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

SeahorseSshSource*
seahorse_ssh_backend_get_dot_ssh (SeahorseSshBackend* self)
{
	SeahorseSshSource* _tmp0_;
	SeahorseSshSource* _tmp1_;
	SeahorseSshSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dot_ssh;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static const gchar*
seahorse_ssh_backend_real_get_name (SeahorseBackend* base)
{
	const gchar* result;
	SeahorseSshBackend* self;
	self = (SeahorseSshBackend*) base;
	result = SEAHORSE_SSH_SEAHORSE_SSH_NAME;
	return result;
}

static const gchar*
seahorse_ssh_backend_real_get_label (SeahorseBackend* base)
{
	const gchar* result;
	SeahorseSshBackend* self;
	self = (SeahorseSshBackend*) base;
	result = _ ("Secure Shell");
	return result;
}

static const gchar*
seahorse_ssh_backend_real_get_description (SeahorseBackend* base)
{
	const gchar* result;
	SeahorseSshBackend* self;
	self = (SeahorseSshBackend*) base;
	result = _ ("Keys used to connect securely to other computers");
	return result;
}

static SeahorseActionGroup*
seahorse_ssh_backend_real_get_actions (SeahorseBackend* base)
{
	SeahorseActionGroup* result;
	SeahorseSshBackend* self;
	SeahorseSshActions* _tmp0_;
	SeahorseActionGroup* _tmp1_;
	self = (SeahorseSshBackend*) base;
	_tmp0_ = seahorse_ssh_actions_instance ();
	_tmp1_ = _g_object_ref0 ((SeahorseActionGroup*) _tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
seahorse_ssh_backend_real_get_loaded (SeahorseBackend* base)
{
	gboolean result;
	SeahorseSshBackend* self;
	self = (SeahorseSshBackend*) base;
	result = self->priv->_loaded;
	return result;
}

SeahorseSshBackend*
seahorse_ssh_backend_get_instance (void)
{
	SeahorseSshBackend* result;
	SeahorseSshBackend* _tmp0_;
	_tmp0_ = seahorse_ssh_backend__instance;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_backend_set_instance (SeahorseSshBackend* value)
{
	SeahorseSshBackend* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (seahorse_ssh_backend__instance);
	seahorse_ssh_backend__instance = _tmp0_;
}

static void
_seahorse_ssh_backend___lambda12_ (SeahorseSshBackend* self,
                                   GObject* obj,
                                   GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		SeahorseSshSource* _tmp1_;
		_tmp1_ = self->priv->dot_ssh;
		_tmp0_ = seahorse_place_load_finish ((SeahorsePlace*) _tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->_loaded = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("backend.vala:40: Failed to initialize SSH backend: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__seahorse_ssh_backend___lambda12__gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self)
{
	_seahorse_ssh_backend___lambda12_ ((SeahorseSshBackend*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
seahorse_ssh_backend_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseSshBackend * self;
	SeahorseSshSource* _tmp0_;
	SeahorseSshSource* _tmp1_;
	parent_class = G_OBJECT_CLASS (seahorse_ssh_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_BACKEND, SeahorseSshBackend);
	_tmp0_ = seahorse_ssh_source_new ();
	_g_object_unref0 (self->priv->dot_ssh);
	self->priv->dot_ssh = _tmp0_;
	_tmp1_ = self->priv->dot_ssh;
	seahorse_place_load ((SeahorsePlace*) _tmp1_, NULL, __seahorse_ssh_backend___lambda12__gasync_ready_callback, g_object_ref (self));
	return obj;
}

static void
seahorse_ssh_backend_class_init (SeahorseSshBackendClass * klass,
                                 gpointer klass_data)
{
	seahorse_ssh_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshBackend_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_backend_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_ssh_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_BACKEND_NAME_PROPERTY, seahorse_ssh_backend_properties[SEAHORSE_SSH_BACKEND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_BACKEND_LABEL_PROPERTY, seahorse_ssh_backend_properties[SEAHORSE_SSH_BACKEND_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_BACKEND_DESCRIPTION_PROPERTY, seahorse_ssh_backend_properties[SEAHORSE_SSH_BACKEND_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_BACKEND_ACTIONS_PROPERTY, seahorse_ssh_backend_properties[SEAHORSE_SSH_BACKEND_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", SEAHORSE_TYPE_ACTION_GROUP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_BACKEND_LOADED_PROPERTY, seahorse_ssh_backend_properties[SEAHORSE_SSH_BACKEND_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_ssh_backend_gcr_collection_interface_init (GcrCollectionIface * iface,
                                                    gpointer iface_data)
{
	seahorse_ssh_backend_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_length = (guint (*) (GcrCollection*)) seahorse_ssh_backend_real_get_length;
	iface->get_objects = (GList* (*) (GcrCollection*)) seahorse_ssh_backend_real_get_objects;
	iface->contains = (gboolean (*) (GcrCollection*, GObject*)) seahorse_ssh_backend_real_contains;
}

static void
seahorse_ssh_backend_seahorse_backend_interface_init (SeahorseBackendIface * iface,
                                                      gpointer iface_data)
{
	seahorse_ssh_backend_seahorse_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_place = (SeahorsePlace* (*) (SeahorseBackend*, const gchar*)) seahorse_ssh_backend_real_lookup_place;
	iface->get_name = seahorse_ssh_backend_real_get_name;
	iface->get_label = seahorse_ssh_backend_real_get_label;
	iface->get_description = seahorse_ssh_backend_real_get_description;
	iface->get_actions = seahorse_ssh_backend_real_get_actions;
	iface->get_loaded = seahorse_ssh_backend_real_get_loaded;
}

static void
seahorse_ssh_backend_instance_init (SeahorseSshBackend * self,
                                    gpointer klass)
{
	self->priv = seahorse_ssh_backend_get_instance_private (self);
}

static void
seahorse_ssh_backend_finalize (GObject * obj)
{
	SeahorseSshBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_BACKEND, SeahorseSshBackend);
	_g_object_unref0 (self->priv->dot_ssh);
	G_OBJECT_CLASS (seahorse_ssh_backend_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshBackend), 0, (GInstanceInitFunc) seahorse_ssh_backend_instance_init, NULL };
	static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_ssh_backend_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_backend_info = { (GInterfaceInitFunc) seahorse_ssh_backend_seahorse_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_ssh_backend_type_id;
	seahorse_ssh_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseSshBackend", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_ssh_backend_type_id, gcr_collection_get_type (), &gcr_collection_info);
	g_type_add_interface_static (seahorse_ssh_backend_type_id, SEAHORSE_TYPE_BACKEND, &seahorse_backend_info);
	SeahorseSshBackend_private_offset = g_type_add_instance_private (seahorse_ssh_backend_type_id, sizeof (SeahorseSshBackendPrivate));
	return seahorse_ssh_backend_type_id;
}

GType
seahorse_ssh_backend_get_type (void)
{
	static volatile gsize seahorse_ssh_backend_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_backend_type_id__once)) {
		GType seahorse_ssh_backend_type_id;
		seahorse_ssh_backend_type_id = seahorse_ssh_backend_get_type_once ();
		g_once_init_leave (&seahorse_ssh_backend_type_id__once, seahorse_ssh_backend_type_id);
	}
	return seahorse_ssh_backend_type_id__once;
}

static void
_vala_seahorse_ssh_backend_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseSshBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_BACKEND, SeahorseSshBackend);
	switch (property_id) {
		case SEAHORSE_SSH_BACKEND_NAME_PROPERTY:
		g_value_set_string (value, seahorse_backend_get_name ((SeahorseBackend*) self));
		break;
		case SEAHORSE_SSH_BACKEND_LABEL_PROPERTY:
		g_value_set_string (value, seahorse_backend_get_label ((SeahorseBackend*) self));
		break;
		case SEAHORSE_SSH_BACKEND_DESCRIPTION_PROPERTY:
		g_value_set_string (value, seahorse_backend_get_description ((SeahorseBackend*) self));
		break;
		case SEAHORSE_SSH_BACKEND_ACTIONS_PROPERTY:
		g_value_take_object (value, seahorse_backend_get_actions ((SeahorseBackend*) self));
		break;
		case SEAHORSE_SSH_BACKEND_LOADED_PROPERTY:
		g_value_set_boolean (value, seahorse_backend_get_loaded ((SeahorseBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_backend_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseSshBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_BACKEND, SeahorseSshBackend);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

