/* algorithm.c generated by valac 0.56.7, the Vala compiler
 * generated from algorithm.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (c) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))

/**
 * Enumerates the possible algorithms in which an SSH key can be encrypted.
 * This is also known as the 'type' of a key.
 */
/**
     * Returns a (non-localized) string representation.
     *
     * @return A string representation, or null if UNKNOWN.
     */
gchar*
seahorse_ssh_algorithm_to_string (SeahorseSshAlgorithm self)
{
	gchar* result;
	switch (self) {
		case SEAHORSE_SSH_ALGORITHM_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("");
			result = _tmp0_;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_RSA:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("RSA");
			result = _tmp1_;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_DSA:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("DSA");
			result = _tmp2_;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_ECDSA:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ECDSA");
			result = _tmp3_;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_ED25519:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("ED25519");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

/**
     * Converts a string representation into a Algorithm.
     *
     * @return The algorithm (can be UNKNOWN).
     */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

SeahorseSshAlgorithm
seahorse_ssh_algorithm_from_string (const gchar* type)
{
	gboolean _tmp0_ = FALSE;
	gchar* _type = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	static GQuark _tmp7_label2 = 0;
	static GQuark _tmp7_label3 = 0;
	static GQuark _tmp7_label4 = 0;
	SeahorseSshAlgorithm result;
	if (type == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (type, "") == 0;
	}
	if (_tmp0_) {
		result = SEAHORSE_SSH_ALGORITHM_UNKNOWN;
		return result;
	}
	_tmp1_ = string_strip (type);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_type = _tmp4_;
	_tmp5_ = _type;
	_tmp6_ = _tmp5_;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("rsa")))) {
		switch (0) {
			default:
			{
				result = SEAHORSE_SSH_ALGORITHM_RSA;
				_g_free0 (_type);
				return result;
			}
		}
	} else if ((_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("dsa")))) || (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("dss"))))) {
		switch (0) {
			default:
			{
				result = SEAHORSE_SSH_ALGORITHM_DSA;
				_g_free0 (_type);
				return result;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label3) ? _tmp7_label3 : (_tmp7_label3 = g_quark_from_static_string ("ecdsa")))) {
		switch (0) {
			default:
			{
				result = SEAHORSE_SSH_ALGORITHM_ECDSA;
				_g_free0 (_type);
				return result;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label4) ? _tmp7_label4 : (_tmp7_label4 = g_quark_from_static_string ("ed25519")))) {
		switch (0) {
			default:
			{
				result = SEAHORSE_SSH_ALGORITHM_ED25519;
				_g_free0 (_type);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = SEAHORSE_SSH_ALGORITHM_UNKNOWN;
				_g_free0 (_type);
				return result;
			}
		}
	}
}

/**
     * Tries to make an educated guess for the algorithm type.
     * Basically it just checks if the given string contains the type.
     *
     * @return The guessed algorithm (can be UNKNOWN)
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

SeahorseSshAlgorithm
seahorse_ssh_algorithm_guess_from_string (const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gchar* str_down = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	SeahorseSshAlgorithm result;
	if (str == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (str, "") == 0;
	}
	if (_tmp0_) {
		result = SEAHORSE_SSH_ALGORITHM_UNKNOWN;
		return result;
	}
	_tmp1_ = g_utf8_strdown (str, (gssize) -1);
	str_down = _tmp1_;
	_tmp2_ = str_down;
	if (string_contains (_tmp2_, "rsa")) {
		result = SEAHORSE_SSH_ALGORITHM_RSA;
		_g_free0 (str_down);
		return result;
	}
	_tmp4_ = str_down;
	if (string_contains (_tmp4_, "dsa")) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = str_down;
		_tmp3_ = string_contains (_tmp5_, "dss");
	}
	if (_tmp3_) {
		result = SEAHORSE_SSH_ALGORITHM_DSA;
		_g_free0 (str_down);
		return result;
	}
	_tmp6_ = str_down;
	if (string_contains (_tmp6_, "ecdsa")) {
		result = SEAHORSE_SSH_ALGORITHM_ECDSA;
		_g_free0 (str_down);
		return result;
	}
	_tmp7_ = str_down;
	if (string_contains (_tmp7_, "ed25519")) {
		result = SEAHORSE_SSH_ALGORITHM_ED25519;
		_g_free0 (str_down);
		return result;
	}
	result = SEAHORSE_SSH_ALGORITHM_UNKNOWN;
	_g_free0 (str_down);
	return result;
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_algorithm_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_SSH_ALGORITHM_UNKNOWN, "SEAHORSE_SSH_ALGORITHM_UNKNOWN", "unknown"}, {SEAHORSE_SSH_ALGORITHM_RSA, "SEAHORSE_SSH_ALGORITHM_RSA", "rsa"}, {SEAHORSE_SSH_ALGORITHM_DSA, "SEAHORSE_SSH_ALGORITHM_DSA", "dsa"}, {SEAHORSE_SSH_ALGORITHM_ECDSA, "SEAHORSE_SSH_ALGORITHM_ECDSA", "ecdsa"}, {SEAHORSE_SSH_ALGORITHM_ED25519, "SEAHORSE_SSH_ALGORITHM_ED25519", "ed25519"}, {0, NULL, NULL}};
	GType seahorse_ssh_algorithm_type_id;
	seahorse_ssh_algorithm_type_id = g_enum_register_static ("SeahorseSshAlgorithm", values);
	return seahorse_ssh_algorithm_type_id;
}

GType
seahorse_ssh_algorithm_get_type (void)
{
	static volatile gsize seahorse_ssh_algorithm_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_algorithm_type_id__once)) {
		GType seahorse_ssh_algorithm_type_id;
		seahorse_ssh_algorithm_type_id = seahorse_ssh_algorithm_get_type_once ();
		g_once_init_leave (&seahorse_ssh_algorithm_type_id__once, seahorse_ssh_algorithm_type_id);
	}
	return seahorse_ssh_algorithm_type_id__once;
}

