/* key-manager.c generated by valac 0.56.7, the Vala compiler
 * generated from key-manager.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2017 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <glib-object.h>
#include <handy.h>
#include <gtk/gtk.h>
#include <gcr/gcr-base.h>
#include <gio/gio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SEAHORSE_TYPE_KEY_MANAGER (seahorse_key_manager_get_type ())
#define SEAHORSE_KEY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManager))
#define SEAHORSE_KEY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManagerClass))
#define SEAHORSE_IS_KEY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_KEY_MANAGER))
#define SEAHORSE_IS_KEY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_KEY_MANAGER))
#define SEAHORSE_KEY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManagerClass))

typedef struct _SeahorseKeyManager SeahorseKeyManager;
typedef struct _SeahorseKeyManagerClass SeahorseKeyManagerClass;
typedef struct _SeahorseKeyManagerPrivate SeahorseKeyManagerPrivate;

#define SEAHORSE_TYPE_SIDEBAR (seahorse_sidebar_get_type ())
#define SEAHORSE_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_SIDEBAR, SeahorseSidebar))
#define SEAHORSE_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_SIDEBAR, SeahorseSidebarClass))
#define SEAHORSE_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_SIDEBAR))
#define SEAHORSE_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_SIDEBAR))
#define SEAHORSE_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_SIDEBAR, SeahorseSidebarClass))

typedef struct _SeahorseSidebar SeahorseSidebar;
typedef struct _SeahorseSidebarClass SeahorseSidebarClass;
enum  {
	SEAHORSE_KEY_MANAGER_0_PROPERTY,
	SEAHORSE_KEY_MANAGER_NUM_PROPERTIES
};
static GParamSpec* seahorse_key_manager_properties[SEAHORSE_KEY_MANAGER_NUM_PROPERTIES];
typedef enum  {
	SEAHORSE_KEY_MANAGER_DND_TARGET_PLAIN,
	SEAHORSE_KEY_MANAGER_DND_TARGET_URIS
} SeahorseKeyManagerDndTarget;

#define SEAHORSE_KEY_MANAGER_TYPE_DND_TARGET (seahorse_key_manager_dnd_target_get_type ())
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SEAHORSE_TYPE_APPLICATION (seahorse_application_get_type ())
#define SEAHORSE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_APPLICATION, SeahorseApplication))
#define SEAHORSE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_APPLICATION, SeahorseApplicationClass))
#define SEAHORSE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_APPLICATION))
#define SEAHORSE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_APPLICATION))
#define SEAHORSE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_APPLICATION, SeahorseApplicationClass))

typedef struct _SeahorseApplication SeahorseApplication;
typedef struct _SeahorseApplicationClass SeahorseApplicationClass;

#define SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW (seahorse_key_manager_item_row_get_type ())
#define SEAHORSE_KEY_MANAGER_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW, SeahorseKeyManagerItemRow))
#define SEAHORSE_KEY_MANAGER_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW, SeahorseKeyManagerItemRowClass))
#define SEAHORSE_IS_KEY_MANAGER_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW))
#define SEAHORSE_IS_KEY_MANAGER_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW))
#define SEAHORSE_KEY_MANAGER_ITEM_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW, SeahorseKeyManagerItemRowClass))

typedef struct _SeahorseKeyManagerItemRow SeahorseKeyManagerItemRow;
typedef struct _SeahorseKeyManagerItemRowClass SeahorseKeyManagerItemRowClass;
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SEAHORSE_TYPE_IMPORT_DIALOG (seahorse_import_dialog_get_type ())
#define SEAHORSE_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_IMPORT_DIALOG, SeahorseImportDialog))
#define SEAHORSE_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_IMPORT_DIALOG, SeahorseImportDialogClass))
#define SEAHORSE_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_IMPORT_DIALOG))
#define SEAHORSE_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_IMPORT_DIALOG))
#define SEAHORSE_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_IMPORT_DIALOG, SeahorseImportDialogClass))

typedef struct _SeahorseImportDialog SeahorseImportDialog;
typedef struct _SeahorseImportDialogClass SeahorseImportDialogClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseKeyManager {
	SeahorseCatalog parent_instance;
	SeahorseKeyManagerPrivate * priv;
};

struct _SeahorseKeyManagerClass {
	SeahorseCatalogClass parent_class;
};

struct _SeahorseKeyManagerPrivate {
	HdyLeaflet* header;
	GtkHeaderBar* left_header;
	GtkHeaderBar* right_header;
	GtkRevealer* back_revealer;
	GtkSearchBar* search_bar;
	GtkSearchEntry* filter_entry;
	HdyLeaflet* content_box;
	GtkScrolledWindow* sidebar_area;
	SeahorseSidebar* sidebar;
	GtkStack* content_stack;
	GtkListBox* item_listbox;
	GtkMenuButton* new_item_button;
	GtkToggleButton* show_search_button;
	SeahorseItemList* item_list;
	GcrCollection* collection;
	GSettings* settings;
};

struct _Block2Data {
	int _ref_count_;
	SeahorseKeyManager* self;
	gchar** last_keyring;
	gint last_keyring_length1;
	gint _last_keyring_size_;
};

struct _Block3Data {
	int _ref_count_;
	SeahorseKeyManager* self;
	SeahorseLockable* place;
	GtkButton* unlock_button;
};

static gint SeahorseKeyManager_private_offset;
static gpointer seahorse_key_manager_parent_class = NULL;

VALA_EXTERN GType seahorse_key_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseKeyManager, g_object_unref)
VALA_EXTERN GType seahorse_sidebar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSidebar, g_object_unref)
static GType seahorse_key_manager_dnd_target_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void seahorse_key_manager_on_new_item (SeahorseKeyManager* self,
                                       GSimpleAction* action,
                                       GVariant* param);
static void _seahorse_key_manager_on_new_item_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void seahorse_key_manager_on_show_search (SeahorseKeyManager* self,
                                          GSimpleAction* action,
                                          GVariant* param);
static void _seahorse_key_manager_on_show_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void seahorse_key_manager_on_filter_items (SeahorseKeyManager* self,
                                           GSimpleAction* action,
                                           GVariant* param);
static void _seahorse_key_manager_on_filter_items_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void seahorse_key_manager_on_focus_place (SeahorseKeyManager* self,
                                          GSimpleAction* action,
                                          GVariant* param);
static void _seahorse_key_manager_on_focus_place_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void seahorse_key_manager_on_import_file (SeahorseKeyManager* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _seahorse_key_manager_on_import_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void seahorse_key_manager_on_paste (SeahorseKeyManager* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _seahorse_key_manager_on_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
VALA_EXTERN GType seahorse_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseApplication, g_object_unref)
VALA_EXTERN SeahorseKeyManager* seahorse_key_manager_new (SeahorseApplication* app);
VALA_EXTERN SeahorseKeyManager* seahorse_key_manager_construct (GType object_type,
                                                    SeahorseApplication* app);
static GcrCollection* seahorse_key_manager_setup_sidebar (SeahorseKeyManager* self);
static void seahorse_key_manager_load_css (SeahorseKeyManager* self);
static void __lambda20_ (SeahorseKeyManager* self,
                  guint idx,
                  guint removed,
                  guint added);
static void seahorse_key_manager_check_empty_state (SeahorseKeyManager* self);
static void ___lambda20__g_list_model_items_changed (GListModel* _sender,
                                              guint position,
                                              guint removed,
                                              guint added,
                                              gpointer self);
static GtkWidget* __lambda21_ (SeahorseKeyManager* self,
                        GObject* obj);
VALA_EXTERN SeahorseKeyManagerItemRow* seahorse_key_manager_item_row_new (GObject* object);
VALA_EXTERN SeahorseKeyManagerItemRow* seahorse_key_manager_item_row_construct (GType object_type,
                                                                    GObject* object);
VALA_EXTERN GType seahorse_key_manager_item_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseKeyManagerItemRow, g_object_unref)
static GtkWidget* ___lambda21__gtk_list_box_create_widget_func (GObject* item,
                                                         gpointer self);
static void seahorse_key_manager_on_item_listbox_row_activated (SeahorseKeyManager* self,
                                                         GtkListBox* item_listbox,
                                                         GtkListBoxRow* row);
static void _seahorse_key_manager_on_item_listbox_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                     GtkListBoxRow* row,
                                                                                     gpointer self);
static void seahorse_key_manager_on_item_listbox_selected_rows_changed (SeahorseKeyManager* self,
                                                                 GtkListBox* item_listbox);
static void _seahorse_key_manager_on_item_listbox_selected_rows_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                                                     gpointer self);
static gboolean seahorse_key_manager_on_item_listbox_popup_menu (SeahorseKeyManager* self,
                                                          GtkWidget* listview);
static gboolean _seahorse_key_manager_on_item_listbox_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                                 gpointer self);
static gboolean seahorse_key_manager_on_item_listbox_button_press_event (SeahorseKeyManager* self,
                                                                  GdkEventButton* event);
static gboolean _seahorse_key_manager_on_item_listbox_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                                 GdkEventButton* event,
                                                                                                 gpointer self);
static void seahorse_key_manager_init_actions (SeahorseKeyManager* self);
static void seahorse_key_manager_on_item_filter_changed (SeahorseKeyManager* self,
                                                  GSettings* settings,
                                                  const gchar* key);
static void _seahorse_key_manager_on_item_filter_changed_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self);
static void seahorse_key_manager_on_filter_changed (SeahorseKeyManager* self,
                                             GtkEditable* entry);
static void __lambda19_ (SeahorseKeyManager* self,
                  GtkCssSection* section,
                  GError* _error_);
static void ___lambda19__gtk_css_provider_parsing_error (GtkCssProvider* _sender,
                                                  GtkCssSection* section,
                                                  GError* _error_,
                                                  gpointer self);
VALA_EXTERN GObject* seahorse_key_manager_item_row_get_object (SeahorseKeyManagerItemRow* self);
static GList* seahorse_key_manager_get_selected_item_listbox_items (SeahorseKeyManager* self);
static void seahorse_key_manager_real_selection_changed (SeahorseCatalog* base);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN SeahorsePlace* seahorse_sidebar_get_focused_place (SeahorseSidebar* self);
static void _seahorse_key_manager_on_filter_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                              gpointer self);
static void seahorse_key_manager_on_back_clicked (SeahorseKeyManager* self);
static void seahorse_key_manager_show_sidebar_pane (SeahorseKeyManager* self);
static void _seahorse_key_manager_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void seahorse_key_manager_update_header (SeahorseKeyManager* self);
static void seahorse_key_manager_show_item_list_pane (SeahorseKeyManager* self);
static void seahorse_key_manager_on_fold (SeahorseKeyManager* self);
static void _seahorse_key_manager_on_fold_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
VALA_EXTERN void seahorse_key_manager_import_files (SeahorseKeyManager* self,
                                        gchar** uris,
                                        gint uris_length1);
VALA_EXTERN GType seahorse_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseImportDialog, g_object_unref)
VALA_EXTERN SeahorseImportDialog* seahorse_import_dialog_new (GtkWindow* parent);
VALA_EXTERN SeahorseImportDialog* seahorse_import_dialog_construct (GType object_type,
                                                        GtkWindow* parent);
VALA_EXTERN void seahorse_import_dialog_add_uris (SeahorseImportDialog* self,
                                      gchar** uris,
                                      gint uris_length1);
static void seahorse_key_manager_import_text (SeahorseKeyManager* self,
                                       const gchar* display_name,
                                       const gchar* text);
VALA_EXTERN void seahorse_import_dialog_add_text (SeahorseImportDialog* self,
                                      const gchar* display_name,
                                      const gchar* text);
static void seahorse_key_manager_on_drag_data_received (SeahorseKeyManager* self,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time);
static void _seahorse_key_manager_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                GdkDragContext* context,
                                                                                gint x,
                                                                                gint y,
                                                                                GtkSelectionData* selection_data,
                                                                                guint info,
                                                                                guint time_,
                                                                                gpointer self);
static void seahorse_key_manager_on_clipboard_received (SeahorseKeyManager* self,
                                                 GtkClipboard* board,
                                                 const gchar* text);
static void _seahorse_key_manager_on_clipboard_received_gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                                                                   const gchar* text,
                                                                                   gpointer self);
static void seahorse_key_manager_update_view_filter (SeahorseKeyManager* self,
                                              const gchar* filter_str,
                                              gboolean update_settings);
static GVariant* _variant_new1 (const gchar* value);
static GList* seahorse_key_manager_real_get_selected_objects (SeahorseCatalog* base);
VALA_EXTERN gboolean seahorse_sidebar_set_focused_place_for_scheme (SeahorseSidebar* self,
                                                        const gchar* uri_scheme);
VALA_EXTERN SeahorseSidebar* seahorse_sidebar_new (void);
VALA_EXTERN SeahorseSidebar* seahorse_sidebar_construct (GType object_type);
static void seahorse_key_manager_restore_keyring_selection (SeahorseKeyManager* self);
static void seahorse_key_manager_on_sidebar_selected_rows_changed (SeahorseKeyManager* self,
                                                            GtkListBox* sidebar);
static void _seahorse_key_manager_on_sidebar_selected_rows_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                                                gpointer self);
static void __lambda18_ (SeahorseKeyManager* self,
                  SeahorseSidebar* sidebar);
static void ___lambda18__seahorse_sidebar_current_collection_changed (SeahorseSidebar* _sender,
                                                               gpointer self);
VALA_EXTERN GcrUnionCollection* seahorse_sidebar_get_objects (SeahorseSidebar* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda17_ (Block2Data* _data2_);
VALA_EXTERN gboolean seahorse_sidebar_set_focused_place_for_uri (SeahorseSidebar* self,
                                                     const gchar* uri);
static gboolean ___lambda17__gsource_func (gpointer self);
static GList* seahorse_key_manager_real_get_backends (SeahorseCatalog* base);
VALA_EXTERN GList* seahorse_sidebar_get_backends (SeahorseSidebar* self);
static void seahorse_key_manager_on_popover_grab_notify (SeahorseKeyManager* self,
                                                  GtkWidget* widget,
                                                  gboolean was_grabbed);
static void _seahorse_key_manager_on_popover_grab_notify_gtk_widget_grab_notify (GtkWidget* _sender,
                                                                          gboolean was_grabbed,
                                                                          gpointer self);
static void seahorse_key_manager_on_locked_keyring_unlock_button_clicked (SeahorseKeyManager* self,
                                                                   GtkButton* unlock_button);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda22_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda22__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _seahorse_key_manager_on_locked_keyring_unlock_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                       gpointer self);
static gboolean seahorse_key_manager_on_key_pressed (SeahorseKeyManager* self,
                                              GtkWidget* widget,
                                              GdkEventKey* event);
VALA_EXTERN void seahorse_sidebar_select_next_place (SeahorseSidebar* self);
VALA_EXTERN void seahorse_sidebar_select_previous_place (SeahorseSidebar* self);
static gboolean _seahorse_key_manager_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                          GdkEventKey* event,
                                                                          gpointer self);
static void seahorse_key_manager_finalize (GObject * obj);
static GType seahorse_key_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry SEAHORSE_KEY_MANAGER_action_entries[6] = {{"new-item", _seahorse_key_manager_on_new_item_gsimple_action_activate_callback}, {"show-search", _seahorse_key_manager_on_show_search_gsimple_action_activate_callback}, {"filter-items", _seahorse_key_manager_on_filter_items_gsimple_action_activate_callback, "s", "'any'"}, {"focus-place", _seahorse_key_manager_on_focus_place_gsimple_action_activate_callback, "s", "'secret-service'"}, {"import-file", _seahorse_key_manager_on_import_file_gsimple_action_activate_callback}, {"paste", _seahorse_key_manager_on_paste_gsimple_action_activate_callback}};

static inline gpointer
seahorse_key_manager_get_instance_private (SeahorseKeyManager* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseKeyManager_private_offset);
}

 G_GNUC_NO_INLINE static GType
seahorse_key_manager_dnd_target_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_KEY_MANAGER_DND_TARGET_PLAIN, "SEAHORSE_KEY_MANAGER_DND_TARGET_PLAIN", "plain"}, {SEAHORSE_KEY_MANAGER_DND_TARGET_URIS, "SEAHORSE_KEY_MANAGER_DND_TARGET_URIS", "uris"}, {0, NULL, NULL}};
	GType seahorse_key_manager_dnd_target_type_id;
	seahorse_key_manager_dnd_target_type_id = g_enum_register_static ("SeahorseKeyManagerDndTarget", values);
	return seahorse_key_manager_dnd_target_type_id;
}

static GType
seahorse_key_manager_dnd_target_get_type (void)
{
	static volatile gsize seahorse_key_manager_dnd_target_type_id__once = 0;
	if (g_once_init_enter (&seahorse_key_manager_dnd_target_type_id__once)) {
		GType seahorse_key_manager_dnd_target_type_id;
		seahorse_key_manager_dnd_target_type_id = seahorse_key_manager_dnd_target_get_type_once ();
		g_once_init_leave (&seahorse_key_manager_dnd_target_type_id__once, seahorse_key_manager_dnd_target_type_id);
	}
	return seahorse_key_manager_dnd_target_type_id__once;
}

static void
_seahorse_key_manager_on_new_item_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	seahorse_key_manager_on_new_item ((SeahorseKeyManager*) self, action, parameter);
}

static void
_seahorse_key_manager_on_show_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	seahorse_key_manager_on_show_search ((SeahorseKeyManager*) self, action, parameter);
}

static void
_seahorse_key_manager_on_filter_items_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	seahorse_key_manager_on_filter_items ((SeahorseKeyManager*) self, action, parameter);
}

static void
_seahorse_key_manager_on_focus_place_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	seahorse_key_manager_on_focus_place ((SeahorseKeyManager*) self, action, parameter);
}

static void
_seahorse_key_manager_on_import_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	seahorse_key_manager_on_import_file ((SeahorseKeyManager*) self, action, parameter);
}

static void
_seahorse_key_manager_on_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	seahorse_key_manager_on_paste ((SeahorseKeyManager*) self, action, parameter);
}

static void
__lambda20_ (SeahorseKeyManager* self,
             guint idx,
             guint removed,
             guint added)
{
	seahorse_key_manager_check_empty_state (self);
}

static void
___lambda20__g_list_model_items_changed (GListModel* _sender,
                                         guint position,
                                         guint removed,
                                         guint added,
                                         gpointer self)
{
	__lambda20_ ((SeahorseKeyManager*) self, position, removed, added);
}

static GtkWidget*
__lambda21_ (SeahorseKeyManager* self,
             GObject* obj)
{
	SeahorseKeyManagerItemRow* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (obj != NULL, NULL);
	_tmp0_ = seahorse_key_manager_item_row_new (obj);
	g_object_ref_sink (_tmp0_);
	result = (GtkWidget*) _tmp0_;
	return result;
}

static GtkWidget*
___lambda21__gtk_list_box_create_widget_func (GObject* item,
                                              gpointer self)
{
	GtkWidget* result;
	result = __lambda21_ ((SeahorseKeyManager*) self, item);
	return result;
}

static void
_seahorse_key_manager_on_item_listbox_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                GtkListBoxRow* row,
                                                                                gpointer self)
{
	seahorse_key_manager_on_item_listbox_row_activated ((SeahorseKeyManager*) self, _sender, row);
}

static void
_seahorse_key_manager_on_item_listbox_selected_rows_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                                                gpointer self)
{
	seahorse_key_manager_on_item_listbox_selected_rows_changed ((SeahorseKeyManager*) self, _sender);
}

static gboolean
_seahorse_key_manager_on_item_listbox_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                        gpointer self)
{
	gboolean result;
	result = seahorse_key_manager_on_item_listbox_popup_menu ((SeahorseKeyManager*) self, _sender);
	return result;
}

static gboolean
_seahorse_key_manager_on_item_listbox_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                        GdkEventButton* event,
                                                                                        gpointer self)
{
	gboolean result;
	result = seahorse_key_manager_on_item_listbox_button_press_event ((SeahorseKeyManager*) self, event);
	return result;
}

static void
_seahorse_key_manager_on_item_filter_changed_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self)
{
	seahorse_key_manager_on_item_filter_changed ((SeahorseKeyManager*) self, _sender, key);
}

SeahorseKeyManager*
seahorse_key_manager_construct (GType object_type,
                                SeahorseApplication* app)
{
	SeahorseKeyManager * self = NULL;
	GSettings* _tmp0_;
	GcrCollection* _tmp1_;
	GcrCollection* _tmp2_;
	SeahorseItemList* _tmp3_;
	SeahorseItemList* _tmp4_;
	GtkListBox* _tmp5_;
	SeahorseItemList* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GtkSearchEntry* _tmp13_;
	GtkTargetEntry* _tmp14_;
	GtkTargetEntry* _tmp15_;
	gint _tmp15__length1;
	GtkTargetList* targets = NULL;
	GtkTargetList* _tmp16_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (SeahorseKeyManager*) g_object_new (object_type, "ui-name", "key-manager", "application", app, NULL);
	_tmp0_ = g_settings_new ("org.gnome.seahorse.manager");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = seahorse_key_manager_setup_sidebar (self);
	_g_object_unref0 (self->priv->collection);
	self->priv->collection = _tmp1_;
	seahorse_key_manager_load_css (self);
	_tmp2_ = self->priv->collection;
	_tmp3_ = seahorse_item_list_new (_tmp2_);
	_g_object_unref0 (self->priv->item_list);
	self->priv->item_list = _tmp3_;
	_tmp4_ = self->priv->item_list;
	g_signal_connect_object ((GListModel*) _tmp4_, "items-changed", (GCallback) ___lambda20__g_list_model_items_changed, self, 0);
	_tmp5_ = self->priv->item_listbox;
	_tmp6_ = self->priv->item_list;
	gtk_list_box_bind_model (_tmp5_, (GListModel*) _tmp6_, ___lambda21__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp7_ = self->priv->item_listbox;
	g_signal_connect_object (_tmp7_, "row-activated", (GCallback) _seahorse_key_manager_on_item_listbox_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp8_ = self->priv->item_listbox;
	g_signal_connect_object (_tmp8_, "selected-rows-changed", (GCallback) _seahorse_key_manager_on_item_listbox_selected_rows_changed_gtk_list_box_selected_rows_changed, self, 0);
	_tmp9_ = self->priv->item_listbox;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "popup-menu", (GCallback) _seahorse_key_manager_on_item_listbox_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp10_ = self->priv->item_listbox;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "button-press-event", (GCallback) _seahorse_key_manager_on_item_listbox_button_press_event_gtk_widget_button_press_event, self, 0);
	seahorse_key_manager_init_actions (self);
	_tmp11_ = self->priv->settings;
	g_signal_connect_object (_tmp11_, "changed::item-filter", (GCallback) _seahorse_key_manager_on_item_filter_changed_g_settings_changed, self, 0);
	_tmp12_ = self->priv->settings;
	seahorse_key_manager_on_item_filter_changed (self, _tmp12_, "item-filter");
	_tmp13_ = self->priv->filter_entry;
	seahorse_key_manager_on_filter_changed (self, (GtkEditable*) _tmp13_);
	_tmp14_ = g_new0 (GtkTargetEntry, 0);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 0;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp15_, (gint) 0, GDK_ACTION_COPY);
	_tmp15_ = (g_free (_tmp15_), NULL);
	_tmp16_ = gtk_target_list_new (NULL, 0);
	targets = _tmp16_;
	gtk_target_list_add_uri_targets (targets, (guint) SEAHORSE_KEY_MANAGER_DND_TARGET_URIS);
	gtk_target_list_add_text_targets (targets, (guint) SEAHORSE_KEY_MANAGER_DND_TARGET_PLAIN);
	gtk_drag_dest_set_target_list ((GtkWidget*) self, targets);
	seahorse_key_manager_check_empty_state (self);
	_gtk_target_list_unref0 (targets);
	return self;
}

SeahorseKeyManager*
seahorse_key_manager_new (SeahorseApplication* app)
{
	return seahorse_key_manager_construct (SEAHORSE_TYPE_KEY_MANAGER, app);
}

static void
seahorse_key_manager_init_actions (SeahorseKeyManager* self)
{
	g_return_if_fail (self != NULL);
	g_action_map_add_action_entries ((GActionMap*) self, SEAHORSE_KEY_MANAGER_action_entries, (gint) G_N_ELEMENTS (SEAHORSE_KEY_MANAGER_action_entries), self);
}

static void
__lambda19_ (SeahorseKeyManager* self,
             GtkCssSection* section,
             GError* _error_)
{
	guint start = 0U;
	guint end = 0U;
	g_return_if_fail (section != NULL);
	g_return_if_fail (_error_ != NULL);
	start = gtk_css_section_get_start_line (section);
	end = gtk_css_section_get_end_line (section);
	if (start == end) {
		const gchar* _tmp0_;
		_tmp0_ = _error_->message;
		g_debug ("key-manager.vala:128: Error parsing css on line %u: %s", start, _tmp0_);
	} else {
		const gchar* _tmp1_;
		_tmp1_ = _error_->message;
		g_debug ("key-manager.vala:130: Error parsing css on lines %u-%u: %s", start, end, _tmp1_);
	}
}

static void
___lambda19__gtk_css_provider_parsing_error (GtkCssProvider* _sender,
                                             GtkCssSection* section,
                                             GError* _error_,
                                             gpointer self)
{
	__lambda19_ ((SeahorseKeyManager*) self, section, _error_);
}

static void
seahorse_key_manager_load_css (SeahorseKeyManager* self)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkScreen* _tmp2_;
	GtkCssProvider* _tmp3_;
	GtkCssProvider* _tmp4_;
	GtkCssProvider* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gdk_display_get_default_screen (_tmp1_);
	_tmp3_ = provider;
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp4_ = provider;
	g_signal_connect_object (_tmp4_, "parsing-error", (GCallback) ___lambda19__gtk_css_provider_parsing_error, self, 0);
	_tmp5_ = provider;
	gtk_css_provider_load_from_resource (_tmp5_, "/org/gnome/Seahorse/seahorse.css");
	if (g_strcmp0 (PROFILE, "development") == 0) {
		GtkStyleContext* _tmp6_;
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp6_, "devel");
	}
	_g_object_unref0 (provider);
}

static void
seahorse_key_manager_on_item_listbox_row_activated (SeahorseKeyManager* self,
                                                    GtkListBox* item_listbox,
                                                    GtkListBoxRow* row)
{
	GObject* obj = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_listbox != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = seahorse_key_manager_item_row_get_object (G_TYPE_CHECK_INSTANCE_CAST (row, SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW, SeahorseKeyManagerItemRow));
	_tmp1_ = _tmp0_;
	obj = _tmp1_;
	_vala_assert (obj != NULL, "obj != null");
	seahorse_catalog_show_properties ((SeahorseCatalog*) self, obj);
}

static void
seahorse_key_manager_on_item_listbox_selected_rows_changed (SeahorseKeyManager* self,
                                                            GtkListBox* item_listbox)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_listbox != NULL);
	g_signal_emit_by_name ((SeahorseCatalog*) self, "selection-changed");
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
seahorse_key_manager_on_item_listbox_button_press_event (SeahorseKeyManager* self,
                                                         GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type == GDK_BUTTON_PRESS) {
		_tmp0_ = event->button == ((guint) 3);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp1_;
		GtkListBoxRow* _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GList* objects = NULL;
		GList* _tmp8_;
		GList* _tmp9_;
		GList* _tmp10_;
		_tmp1_ = self->priv->item_listbox;
		_tmp2_ = gtk_list_box_get_row_at_y (_tmp1_, (gint) event->y);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		row = _tmp3_;
		_tmp4_ = row;
		if (_tmp4_ != NULL) {
			GtkListBox* _tmp5_;
			GtkListBox* _tmp6_;
			GtkListBoxRow* _tmp7_;
			_tmp5_ = self->priv->item_listbox;
			gtk_list_box_unselect_all (_tmp5_);
			_tmp6_ = self->priv->item_listbox;
			_tmp7_ = row;
			gtk_list_box_select_row (_tmp6_, _tmp7_);
		}
		_tmp8_ = seahorse_key_manager_get_selected_item_listbox_items (self);
		objects = _tmp8_;
		_tmp9_ = objects;
		g_debug ("key-manager.vala:162: We have %u selected objects", g_list_length (_tmp9_));
		_tmp10_ = objects;
		if (_tmp10_ != NULL) {
			seahorse_catalog_show_context_menu ((SeahorseCatalog*) self, NULL);
		}
		result = TRUE;
		(objects == NULL) ? NULL : (objects = (g_list_free (objects), NULL));
		_g_object_unref0 (row);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
seahorse_key_manager_on_item_listbox_popup_menu (SeahorseKeyManager* self,
                                                 GtkWidget* listview)
{
	GList* objects = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = seahorse_key_manager_get_selected_item_listbox_items (self);
	objects = _tmp0_;
	_tmp1_ = objects;
	if (_tmp1_ != NULL) {
		seahorse_catalog_show_context_menu ((SeahorseCatalog*) self, NULL);
	}
	result = FALSE;
	(objects == NULL) ? NULL : (objects = (g_list_free (objects), NULL));
	return result;
}

static GList*
seahorse_key_manager_get_selected_item_listbox_items (SeahorseKeyManager* self)
{
	GList* rows = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* objects = NULL;
	GList* _tmp2_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->item_listbox;
	_tmp1_ = gtk_list_box_get_selected_rows (_tmp0_);
	rows = _tmp1_;
	objects = NULL;
	_tmp2_ = rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp2_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* row = NULL;
			row = (GtkListBoxRow*) row_it->data;
			{
				GtkListBoxRow* _tmp3_;
				GObject* _tmp4_;
				GObject* _tmp5_;
				_tmp3_ = row;
				_tmp4_ = seahorse_key_manager_item_row_get_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW, SeahorseKeyManagerItemRow));
				_tmp5_ = _tmp4_;
				objects = g_list_prepend (objects, _tmp5_);
			}
		}
	}
	result = objects;
	(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
seahorse_key_manager_real_selection_changed (SeahorseCatalog* base)
{
	SeahorseKeyManager * self;
	GList* objects = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	self = (SeahorseKeyManager*) base;
	SEAHORSE_CATALOG_CLASS (seahorse_key_manager_parent_class)->selection_changed (G_TYPE_CHECK_INSTANCE_CAST (self, SEAHORSE_TYPE_CATALOG, SeahorseCatalog));
	_tmp0_ = seahorse_catalog_get_selected_objects ((SeahorseCatalog*) self);
	objects = _tmp0_;
	_tmp1_ = seahorse_catalog_get_backends ((SeahorseCatalog*) self);
	{
		GList* backend_collection = NULL;
		GList* backend_it = NULL;
		backend_collection = _tmp1_;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			SeahorseBackend* backend = NULL;
			backend = (SeahorseBackend*) backend_it->data;
			{
				SeahorseBackend* _tmp2_;
				SeahorseActionGroup* _tmp3_;
				SeahorseActionGroup* _tmp4_;
				SeahorseActionGroup* _tmp5_;
				GList* _tmp6_;
				_tmp2_ = backend;
				_tmp3_ = seahorse_backend_get_actions (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = objects;
				seahorse_action_group_set_actions_for_selected_objects (_tmp5_, _tmp6_);
				_g_object_unref0 (_tmp5_);
			}
		}
		(backend_collection == NULL) ? NULL : (backend_collection = (g_list_free (backend_collection), NULL));
	}
	(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
seahorse_key_manager_check_empty_state (SeahorseKeyManager* self)
{
	gboolean empty = FALSE;
	SeahorseItemList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkToggleButton* _tmp3_;
	SeahorsePlace* place = NULL;
	SeahorseSidebar* _tmp5_;
	SeahorsePlace* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	SeahorsePlace* _tmp9_;
	GtkStack* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->item_list;
	empty = g_list_model_get_n_items ((GListModel*) _tmp0_) == ((guint) 0);
	_tmp1_ = bool_to_string (empty);
	_tmp2_ = _tmp1_;
	g_debug ("key-manager.vala:198: Checking empty state: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->show_search_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, !empty);
	if (!empty) {
		GtkStack* _tmp4_;
		_tmp4_ = self->priv->content_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "item_listbox_page");
		return;
	}
	_tmp5_ = self->priv->sidebar;
	_tmp6_ = seahorse_sidebar_get_focused_place (_tmp5_);
	place = _tmp6_;
	_tmp9_ = place;
	if (_tmp9_ != NULL) {
		SeahorsePlace* _tmp10_;
		_tmp10_ = place;
		_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, SEAHORSE_TYPE_LOCKABLE);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		SeahorsePlace* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = place;
		_tmp12_ = seahorse_lockable_get_unlockable (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SEAHORSE_TYPE_LOCKABLE, SeahorseLockable));
		_tmp13_ = _tmp12_;
		_tmp7_ = _tmp13_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GtkStack* _tmp14_;
		_tmp14_ = self->priv->content_stack;
		gtk_stack_set_visible_child_name (_tmp14_, "locked_keyring_page");
		_g_object_unref0 (place);
		return;
	}
	_tmp15_ = self->priv->content_stack;
	gtk_stack_set_visible_child_name (_tmp15_, "empty_state_page");
	_g_object_unref0 (place);
}

static void
seahorse_key_manager_on_new_item (SeahorseKeyManager* self,
                                  GSimpleAction* action,
                                  GVariant* param)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->new_item_button;
	g_signal_emit_by_name ((GtkButton*) _tmp0_, "activate");
}

static void
seahorse_key_manager_on_filter_changed (SeahorseKeyManager* self,
                                        GtkEditable* entry)
{
	SeahorseItemList* _tmp0_;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->item_list;
	_tmp1_ = self->priv->filter_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	seahorse_item_list_set_filter_text (_tmp0_, _tmp3_);
}

static void
_seahorse_key_manager_on_filter_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                         gpointer self)
{
	seahorse_key_manager_on_filter_changed ((SeahorseKeyManager*) self, _sender);
}

static void
seahorse_key_manager_on_back_clicked (SeahorseKeyManager* self)
{
	g_return_if_fail (self != NULL);
	seahorse_key_manager_show_sidebar_pane (self);
}

static void
_seahorse_key_manager_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	seahorse_key_manager_on_back_clicked ((SeahorseKeyManager*) self);
}

static void
seahorse_key_manager_show_sidebar_pane (SeahorseKeyManager* self)
{
	HdyLeaflet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	hdy_leaflet_set_visible_child_name (_tmp0_, "sidebar-pane");
	seahorse_key_manager_update_header (self);
}

static void
seahorse_key_manager_show_item_list_pane (SeahorseKeyManager* self)
{
	HdyLeaflet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	hdy_leaflet_set_visible_child_name (_tmp0_, "item-list-pane");
	seahorse_key_manager_update_header (self);
}

static void
seahorse_key_manager_on_fold (SeahorseKeyManager* self)
{
	g_return_if_fail (self != NULL);
	seahorse_key_manager_update_header (self);
}

static void
_seahorse_key_manager_on_fold_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	seahorse_key_manager_on_fold ((SeahorseKeyManager*) self);
}

static void
seahorse_key_manager_update_header (SeahorseKeyManager* self)
{
	gboolean folded = FALSE;
	HdyLeaflet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkHeaderBar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GtkHeaderBar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GtkRevealer* _tmp20_;
	GtkRevealer* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	_tmp1_ = hdy_leaflet_get_folded (_tmp0_);
	_tmp2_ = _tmp1_;
	folded = _tmp2_;
	if (!folded) {
		_tmp3_ = TRUE;
	} else {
		HdyLeaflet* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkHeaderBar* _tmp7_;
		_tmp4_ = self->priv->header;
		_tmp5_ = hdy_leaflet_get_visible_child (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->left_header;
		_tmp3_ = _tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget);
	}
	_tmp8_ = self->priv->left_header;
	gtk_header_bar_set_show_close_button (_tmp8_, _tmp3_);
	if (!folded) {
		_tmp9_ = TRUE;
	} else {
		HdyLeaflet* _tmp10_;
		GtkWidget* _tmp11_;
		GtkWidget* _tmp12_;
		GtkHeaderBar* _tmp13_;
		_tmp10_ = self->priv->header;
		_tmp11_ = hdy_leaflet_get_visible_child (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->right_header;
		_tmp9_ = _tmp12_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget);
	}
	_tmp14_ = self->priv->right_header;
	gtk_header_bar_set_show_close_button (_tmp14_, _tmp9_);
	if (folded) {
		HdyLeaflet* _tmp16_;
		GtkWidget* _tmp17_;
		GtkWidget* _tmp18_;
		GtkHeaderBar* _tmp19_;
		_tmp16_ = self->priv->header;
		_tmp17_ = hdy_leaflet_get_visible_child (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->right_header;
		_tmp15_ = _tmp18_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget);
	} else {
		_tmp15_ = FALSE;
	}
	_tmp20_ = self->priv->back_revealer;
	_tmp21_ = self->priv->back_revealer;
	gtk_widget_set_visible ((GtkWidget*) _tmp21_, _tmp15_);
	gtk_revealer_set_reveal_child (_tmp20_, _tmp15_);
}

void
seahorse_key_manager_import_files (SeahorseKeyManager* self,
                                   gchar** uris,
                                   gint uris_length1)
{
	SeahorseImportDialog* dialog = NULL;
	SeahorseImportDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = seahorse_import_dialog_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	seahorse_import_dialog_add_uris (dialog, uris, (gint) uris_length1);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static void
seahorse_key_manager_on_import_file (SeahorseKeyManager* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	GtkFileChooserNative* dialog = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp3_;
	GtkFileFilter* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileFilter* _tmp7_;
	GtkFileFilter* _tmp8_;
	GtkFileFilter* _tmp9_;
	GtkFileFilter* _tmp10_;
	GtkFileFilter* _tmp11_;
	GtkFileFilter* _tmp12_;
	GtkFileFilter* _tmp13_;
	GtkFileFilter* _tmp14_;
	GtkFileFilter* _tmp15_;
	GtkFileFilter* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* _tmp18_;
	GtkFileFilter* _tmp19_;
	GtkFileFilter* _tmp20_;
	GtkFileFilter* _tmp21_;
	GtkFileFilter* _tmp22_;
	GtkFileFilter* _tmp23_;
	GtkFileFilter* _tmp24_;
	GtkFileFilter* _tmp25_;
	GtkFileFilter* _tmp26_;
	GtkFileFilter* _tmp27_;
	GtkFileFilter* _tmp28_;
	GtkFileFilter* _tmp29_;
	GtkFileFilter* _tmp30_;
	GtkFileFilter* _tmp31_;
	GtkFileFilter* _tmp32_;
	GtkFileChooserNative* _tmp33_;
	GtkFileFilter* _tmp34_;
	GtkFileFilter* _tmp35_;
	GtkFileChooserNative* _tmp36_;
	GtkFileFilter* _tmp37_;
	GtkFileFilter* _tmp38_;
	GtkFileFilter* _tmp39_;
	GtkFileFilter* _tmp40_;
	GtkFileChooserNative* _tmp41_;
	GtkFileFilter* _tmp42_;
	GtkFileFilter* _tmp43_;
	gchar* uri = NULL;
	GtkFileChooserNative* _tmp44_;
	GtkFileChooserNative* _tmp47_;
	const gchar* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_file_chooser_native_new (_ ("Import Key"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Open"), _ ("_Cancel"));
	dialog = _tmp0_;
	_tmp1_ = dialog;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp1_, FALSE);
	_tmp2_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp2_);
	filter = _tmp2_;
	_tmp3_ = filter;
	gtk_buildable_set_name ((GtkBuildable*) _tmp3_, _ ("All key files"));
	_tmp4_ = filter;
	gtk_file_filter_add_mime_type (_tmp4_, "application/pgp-keys");
	_tmp5_ = filter;
	gtk_file_filter_add_mime_type (_tmp5_, "application/x-ssh-key");
	_tmp6_ = filter;
	gtk_file_filter_add_mime_type (_tmp6_, "application/pkcs12");
	_tmp7_ = filter;
	gtk_file_filter_add_mime_type (_tmp7_, "application/pkcs12+pem");
	_tmp8_ = filter;
	gtk_file_filter_add_mime_type (_tmp8_, "application/pkcs7-mime");
	_tmp9_ = filter;
	gtk_file_filter_add_mime_type (_tmp9_, "application/pkcs7-mime+pem");
	_tmp10_ = filter;
	gtk_file_filter_add_mime_type (_tmp10_, "application/pkcs8");
	_tmp11_ = filter;
	gtk_file_filter_add_mime_type (_tmp11_, "application/pkcs8+pem");
	_tmp12_ = filter;
	gtk_file_filter_add_mime_type (_tmp12_, "application/pkix-cert");
	_tmp13_ = filter;
	gtk_file_filter_add_mime_type (_tmp13_, "application/pkix-cert+pem");
	_tmp14_ = filter;
	gtk_file_filter_add_mime_type (_tmp14_, "application/pkix-crl");
	_tmp15_ = filter;
	gtk_file_filter_add_mime_type (_tmp15_, "application/pkix-crl+pem");
	_tmp16_ = filter;
	gtk_file_filter_add_mime_type (_tmp16_, "application/x-pem-file");
	_tmp17_ = filter;
	gtk_file_filter_add_mime_type (_tmp17_, "application/x-pem-key");
	_tmp18_ = filter;
	gtk_file_filter_add_mime_type (_tmp18_, "application/x-pkcs12");
	_tmp19_ = filter;
	gtk_file_filter_add_mime_type (_tmp19_, "application/x-pkcs7-certificates");
	_tmp20_ = filter;
	gtk_file_filter_add_mime_type (_tmp20_, "application/x-x509-ca-cert");
	_tmp21_ = filter;
	gtk_file_filter_add_mime_type (_tmp21_, "application/x-x509-user-cert");
	_tmp22_ = filter;
	gtk_file_filter_add_mime_type (_tmp22_, "application/pkcs10");
	_tmp23_ = filter;
	gtk_file_filter_add_mime_type (_tmp23_, "application/pkcs10+pem");
	_tmp24_ = filter;
	gtk_file_filter_add_mime_type (_tmp24_, "application/x-spkac");
	_tmp25_ = filter;
	gtk_file_filter_add_mime_type (_tmp25_, "application/x-spkac+base64");
	_tmp26_ = filter;
	gtk_file_filter_add_pattern (_tmp26_, "*.asc");
	_tmp27_ = filter;
	gtk_file_filter_add_pattern (_tmp27_, "*.gpg");
	_tmp28_ = filter;
	gtk_file_filter_add_pattern (_tmp28_, "*.pub");
	_tmp29_ = filter;
	gtk_file_filter_add_pattern (_tmp29_, "*.pfx");
	_tmp30_ = filter;
	gtk_file_filter_add_pattern (_tmp30_, "*.cer");
	_tmp31_ = filter;
	gtk_file_filter_add_pattern (_tmp31_, "*.crt");
	_tmp32_ = filter;
	gtk_file_filter_add_pattern (_tmp32_, "*.pem");
	_tmp33_ = dialog;
	_tmp34_ = filter;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp33_, _tmp35_);
	_tmp36_ = dialog;
	_tmp37_ = filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp36_, _tmp37_);
	_tmp38_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (filter);
	filter = _tmp38_;
	_tmp39_ = filter;
	gtk_buildable_set_name ((GtkBuildable*) _tmp39_, _ ("All files"));
	_tmp40_ = filter;
	gtk_file_filter_add_pattern (_tmp40_, "*");
	_tmp41_ = dialog;
	_tmp42_ = filter;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp41_, _tmp43_);
	uri = NULL;
	_tmp44_ = dialog;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp44_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp45_;
		gchar* _tmp46_;
		_tmp45_ = dialog;
		_tmp46_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp45_);
		_g_free0 (uri);
		uri = _tmp46_;
	}
	_tmp47_ = dialog;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp47_);
	_tmp48_ = uri;
	if (_tmp48_ != NULL) {
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar** _tmp51_;
		gchar** _tmp52_;
		gint _tmp52__length1;
		_tmp49_ = uri;
		_tmp50_ = g_strdup (_tmp49_);
		_tmp51_ = g_new0 (gchar*, 1 + 1);
		_tmp51_[0] = _tmp50_;
		_tmp52_ = _tmp51_;
		_tmp52__length1 = 1;
		seahorse_key_manager_import_files (self, _tmp52_, (gint) 1);
		_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (uri);
	_g_object_unref0 (filter);
	_g_object_unref0 (dialog);
}

static void
seahorse_key_manager_import_text (SeahorseKeyManager* self,
                                  const gchar* display_name,
                                  const gchar* text)
{
	SeahorseImportDialog* dialog = NULL;
	SeahorseImportDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = seahorse_import_dialog_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	seahorse_import_dialog_add_text (dialog, display_name, text);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static void
seahorse_key_manager_on_drag_data_received (SeahorseKeyManager* self,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (selection_data == NULL) {
		return;
	}
	if (info == ((guint) SEAHORSE_KEY_MANAGER_DND_TARGET_PLAIN)) {
		gchar* text = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = gtk_selection_data_get_text (selection_data);
		text = _tmp0_;
		_tmp1_ = text;
		seahorse_key_manager_import_text (self, _ ("Dropped text"), _tmp1_);
		_g_free0 (text);
	} else {
		if (info == ((guint) SEAHORSE_KEY_MANAGER_DND_TARGET_URIS)) {
			gchar** uris = NULL;
			gchar** _tmp2_;
			gchar** _tmp3_;
			gint uris_length1;
			gint _uris_size_;
			gchar** _tmp4_;
			gint _tmp4__length1;
			gchar** _tmp7_;
			gint _tmp7__length1;
			_tmp3_ = _tmp2_ = gtk_selection_data_get_uris (selection_data);
			uris = _tmp3_;
			uris_length1 = _vala_array_length (_tmp2_);
			_uris_size_ = uris_length1;
			_tmp4_ = uris;
			_tmp4__length1 = uris_length1;
			{
				gchar** uri_collection = NULL;
				gint uri_collection_length1 = 0;
				gint _uri_collection_size_ = 0;
				gint uri_it = 0;
				uri_collection = _tmp4_;
				uri_collection_length1 = _tmp4__length1;
				for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
					gchar* _tmp5_;
					gchar* uri = NULL;
					_tmp5_ = g_strdup (uri_collection[uri_it]);
					uri = _tmp5_;
					{
						const gchar* _tmp6_;
						_tmp6_ = uri;
						g_strstrip (_tmp6_);
						_g_free0 (uri);
					}
				}
			}
			_tmp7_ = uris;
			_tmp7__length1 = uris_length1;
			seahorse_key_manager_import_files (self, _tmp7_, (gint) _tmp7__length1);
			uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		}
	}
}

static void
_seahorse_key_manager_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                           GdkDragContext* context,
                                                                           gint x,
                                                                           gint y,
                                                                           GtkSelectionData* selection_data,
                                                                           guint info,
                                                                           guint time_,
                                                                           gpointer self)
{
	seahorse_key_manager_on_drag_data_received ((SeahorseKeyManager*) self, context, x, y, selection_data, info, time_);
}

static void
_seahorse_key_manager_on_clipboard_received_gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                                                              const gchar* text,
                                                                              gpointer self)
{
	seahorse_key_manager_on_clipboard_received ((SeahorseKeyManager*) self, clipboard, text);
	g_object_unref (self);
}

static void
seahorse_key_manager_on_paste (SeahorseKeyManager* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	GdkAtom atom = (GdkAtom) 0U;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	atom = gdk_atom_intern ("CLIPBOARD", FALSE);
	_tmp0_ = gtk_clipboard_get (atom);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	clipboard = _tmp1_;
	_tmp2_ = clipboard;
	if (gtk_clipboard_wait_is_text_available (_tmp2_)) {
		_g_object_unref0 (clipboard);
		return;
	}
	_tmp3_ = clipboard;
	gtk_clipboard_request_text (_tmp3_, _seahorse_key_manager_on_clipboard_received_gtk_clipboard_text_received_func, g_object_ref (self));
	_g_object_unref0 (clipboard);
}

static void
seahorse_key_manager_on_clipboard_received (SeahorseKeyManager* self,
                                            GtkClipboard* board,
                                            const gchar* text)
{
	GtkSearchEntry* _tmp0_;
	GtkSearchEntry* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	if (text == NULL) {
		return;
	}
	_tmp0_ = self->priv->filter_entry;
	_vala_assert (_tmp0_ != NULL, "this.filter_entry != null");
	_tmp1_ = self->priv->filter_entry;
	g_object_get ((GtkWidget*) _tmp1_, "is-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkSearchEntry* _tmp4_;
		_tmp4_ = self->priv->filter_entry;
		gtk_editable_paste_clipboard ((GtkEditable*) _tmp4_);
	} else {
		gboolean _tmp5_ = FALSE;
		if (text != NULL) {
			_tmp5_ = g_utf8_strlen (text, (gssize) -1) > 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			seahorse_key_manager_import_text (self, _ ("Clipboard text"), text);
		}
	}
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
seahorse_key_manager_update_view_filter (SeahorseKeyManager* self,
                                         const gchar* filter_str,
                                         gboolean update_settings)
{
	GSimpleAction* action = NULL;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GVariant* _tmp3_;
	SeahorseItemList* _tmp4_;
	SeahorseItemList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter_str != NULL);
	if (update_settings) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->settings;
		g_settings_set_string (_tmp0_, "item-filter", filter_str);
	}
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "filter-items");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp1_) : NULL);
	action = _tmp2_;
	_tmp3_ = _variant_new1 (filter_str);
	g_simple_action_set_state (action, _tmp3_);
	_g_variant_unref0 (_tmp3_);
	_tmp4_ = self->priv->item_list;
	seahorse_item_list_set_showfilter (_tmp4_, seahorse_item_list_show_filter_from_string (filter_str));
	_tmp5_ = self->priv->item_list;
	seahorse_item_list_refilter (_tmp5_);
	_g_object_unref0 (action);
}

static void
seahorse_key_manager_on_show_search (SeahorseKeyManager* self,
                                     GSimpleAction* action,
                                     GVariant* param)
{
	GtkToggleButton* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->show_search_button;
	gtk_toggle_button_set_active (_tmp0_, TRUE);
}

static void
seahorse_key_manager_on_filter_items (SeahorseKeyManager* self,
                                      GSimpleAction* action,
                                      GVariant* param)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	seahorse_key_manager_update_view_filter (self, _tmp0_, TRUE);
}

static void
seahorse_key_manager_on_item_filter_changed (SeahorseKeyManager* self,
                                             GSettings* settings,
                                             const gchar* key)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = g_settings_get_string (settings, "item-filter");
	_tmp1_ = _tmp0_;
	seahorse_key_manager_update_view_filter (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
}

static GList*
seahorse_key_manager_real_get_selected_objects (SeahorseCatalog* base)
{
	SeahorseKeyManager * self;
	GList* objects = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* result;
	self = (SeahorseKeyManager*) base;
	objects = NULL;
	_tmp0_ = self->priv->item_listbox;
	_tmp1_ = gtk_list_box_get_selected_rows (_tmp0_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* row = NULL;
			row = (GtkListBoxRow*) row_it->data;
			{
				GtkListBoxRow* _tmp2_;
				GObject* _tmp3_;
				GObject* _tmp4_;
				GObject* _tmp5_;
				_tmp2_ = row;
				_tmp3_ = seahorse_key_manager_item_row_get_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SEAHORSE_TYPE_KEY_MANAGER_ITEM_ROW, SeahorseKeyManagerItemRow));
				_tmp4_ = _tmp3_;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				objects = g_list_append (objects, _tmp5_);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	result = objects;
	return result;
}

static void
seahorse_key_manager_on_focus_place (SeahorseKeyManager* self,
                                     GSimpleAction* action,
                                     GVariant* param)
{
	gchar* uri_prefix = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	uri_prefix = _tmp1_;
	_tmp2_ = uri_prefix;
	if (_tmp2_ != NULL) {
		SeahorseSidebar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->sidebar;
		_tmp4_ = uri_prefix;
		seahorse_sidebar_set_focused_place_for_scheme (_tmp3_, _tmp4_);
	}
	_g_free0 (uri_prefix);
}

static void
_seahorse_key_manager_on_sidebar_selected_rows_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                                           gpointer self)
{
	seahorse_key_manager_on_sidebar_selected_rows_changed ((SeahorseKeyManager*) self, _sender);
}

static void
__lambda18_ (SeahorseKeyManager* self,
             SeahorseSidebar* sidebar)
{
	g_return_if_fail (sidebar != NULL);
	seahorse_key_manager_check_empty_state (self);
}

static void
___lambda18__seahorse_sidebar_current_collection_changed (SeahorseSidebar* _sender,
                                                          gpointer self)
{
	__lambda18_ ((SeahorseKeyManager*) self, _sender);
}

static GcrCollection*
seahorse_key_manager_setup_sidebar (SeahorseKeyManager* self)
{
	SeahorseSidebar* _tmp0_;
	SeahorseSidebar* _tmp1_;
	SeahorseSidebar* _tmp2_;
	GList* _tmp3_;
	GtkScrolledWindow* _tmp12_;
	SeahorseSidebar* _tmp13_;
	SeahorseSidebar* _tmp14_;
	SeahorseSidebar* _tmp15_;
	GcrUnionCollection* _tmp16_;
	GcrUnionCollection* _tmp17_;
	GcrCollection* _tmp18_;
	GcrCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = seahorse_sidebar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->sidebar);
	self->priv->sidebar = _tmp0_;
	seahorse_key_manager_restore_keyring_selection (self);
	_tmp1_ = self->priv->sidebar;
	g_signal_connect_object ((GtkListBox*) _tmp1_, "selected-rows-changed", (GCallback) _seahorse_key_manager_on_sidebar_selected_rows_changed_gtk_list_box_selected_rows_changed, self, 0);
	_tmp2_ = self->priv->sidebar;
	g_signal_connect_object (_tmp2_, "current-collection-changed", (GCallback) ___lambda18__seahorse_sidebar_current_collection_changed, self, 0);
	_tmp3_ = seahorse_catalog_get_backends ((SeahorseCatalog*) self);
	{
		GList* backend_collection = NULL;
		GList* backend_it = NULL;
		backend_collection = _tmp3_;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			SeahorseBackend* backend = NULL;
			backend = (SeahorseBackend*) backend_it->data;
			{
				SeahorseActionGroup* actions = NULL;
				SeahorseBackend* _tmp4_;
				SeahorseActionGroup* _tmp5_;
				SeahorseActionGroup* _tmp6_;
				SeahorseActionGroup* _tmp7_;
				SeahorseActionGroup* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				SeahorseActionGroup* _tmp11_;
				_tmp4_ = backend;
				_tmp5_ = seahorse_backend_get_actions (_tmp4_);
				_tmp6_ = _tmp5_;
				actions = _tmp6_;
				_tmp7_ = actions;
				seahorse_action_group_set_catalog (_tmp7_, (SeahorseCatalog*) self);
				_tmp8_ = actions;
				_tmp9_ = seahorse_action_group_get_prefix (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = actions;
				gtk_widget_insert_action_group ((GtkWidget*) self, _tmp10_, (GActionGroup*) _tmp11_);
				_g_object_unref0 (actions);
			}
		}
		(backend_collection == NULL) ? NULL : (backend_collection = (g_list_free (backend_collection), NULL));
	}
	_tmp12_ = self->priv->sidebar_area;
	_tmp13_ = self->priv->sidebar;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->sidebar;
	gtk_widget_show ((GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->sidebar;
	_tmp16_ = seahorse_sidebar_get_objects (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 ((GcrCollection*) _tmp17_);
	result = _tmp18_;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SeahorseKeyManager* self;
		self = _data2_->self;
		_data2_->last_keyring = (_vala_array_free (_data2_->last_keyring, _data2_->last_keyring_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda17_ (Block2Data* _data2_)
{
	SeahorseKeyManager* self;
	const gchar* uri = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SeahorseSidebar* _tmp3_;
	const gchar* _tmp4_;
	gchar* uri_scheme = NULL;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	SeahorseSidebar* _tmp12_;
	const gchar* _tmp13_;
	SeahorseSidebar* _tmp14_;
	SeahorseSidebar* _tmp15_;
	GtkListBoxRow* _tmp16_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = _data2_->last_keyring;
	_tmp0__length1 = _data2_->last_keyring_length1;
	_tmp1_ = _tmp0_[0];
	uri = _tmp1_;
	_tmp2_ = uri;
	g_debug ("key-manager.vala:447: Selecting last used place %s", _tmp2_);
	_tmp3_ = self->priv->sidebar;
	_tmp4_ = uri;
	if (seahorse_sidebar_set_focused_place_for_uri (_tmp3_, _tmp4_)) {
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp5_ = uri;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ":", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_tmp9_ = _tmp8_[0];
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	uri_scheme = _tmp11_;
	_tmp12_ = self->priv->sidebar;
	_tmp13_ = uri_scheme;
	if (seahorse_sidebar_set_focused_place_for_scheme (_tmp12_, _tmp13_)) {
		result = G_SOURCE_REMOVE;
		_g_free0 (uri_scheme);
		return result;
	}
	_tmp14_ = self->priv->sidebar;
	_tmp15_ = self->priv->sidebar;
	_tmp16_ = gtk_list_box_get_row_at_index ((GtkListBox*) _tmp15_, 0);
	gtk_list_box_select_row ((GtkListBox*) _tmp14_, _tmp16_);
	result = G_SOURCE_REMOVE;
	_g_free0 (uri_scheme);
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ (self);
	return result;
}

static void
seahorse_key_manager_restore_keyring_selection (SeahorseKeyManager* self)
{
	Block2Data* _data2_;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "keyrings-selected");
	_data2_->last_keyring = _tmp2_;
	_data2_->last_keyring_length1 = _vala_array_length (_tmp1_);
	_data2_->_last_keyring_size_ = _data2_->last_keyring_length1;
	_tmp4_ = _data2_->last_keyring;
	_tmp4__length1 = _data2_->last_keyring_length1;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = _data2_->last_keyring;
		_tmp5__length1 = _data2_->last_keyring_length1;
		_tmp3_ = _tmp5__length1 == 0;
	}
	if (_tmp3_) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, ___lambda17__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
seahorse_key_manager_on_sidebar_selected_rows_changed (SeahorseKeyManager* self,
                                                       GtkListBox* sidebar)
{
	SeahorsePlace* place = NULL;
	SeahorseSidebar* _tmp0_;
	SeahorsePlace* _tmp1_;
	GtkHeaderBar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GSettings* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sidebar != NULL);
	seahorse_key_manager_check_empty_state (self);
	seahorse_key_manager_show_item_list_pane (self);
	_tmp0_ = self->priv->sidebar;
	_tmp1_ = seahorse_sidebar_get_focused_place (_tmp0_);
	place = _tmp1_;
	g_return_if_fail (place != NULL);
	_tmp2_ = self->priv->right_header;
	_tmp3_ = seahorse_place_get_label (place);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_header_bar_set_title (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = seahorse_place_get_uri (place);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_new0 (gchar*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 1;
	g_settings_set_strv (_tmp6_, "keyrings-selected", _tmp10_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (place);
}

static GList*
seahorse_key_manager_real_get_backends (SeahorseCatalog* base)
{
	SeahorseKeyManager * self;
	SeahorseSidebar* _tmp0_;
	GList* _tmp1_;
	GList* result;
	self = (SeahorseKeyManager*) base;
	_tmp0_ = self->priv->sidebar;
	_tmp1_ = seahorse_sidebar_get_backends (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
seahorse_key_manager_on_popover_grab_notify (SeahorseKeyManager* self,
                                             GtkWidget* widget,
                                             gboolean was_grabbed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (!was_grabbed) {
		gtk_widget_hide (widget);
	}
}

static void
_seahorse_key_manager_on_popover_grab_notify_gtk_widget_grab_notify (GtkWidget* _sender,
                                                                     gboolean was_grabbed,
                                                                     gpointer self)
{
	seahorse_key_manager_on_popover_grab_notify ((SeahorseKeyManager*) self, _sender, was_grabbed);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SeahorseKeyManager* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->place);
		_g_object_unref0 (_data3_->unlock_button);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda22_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseKeyManager* self;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseLockable* _tmp0_;
		gtk_widget_set_sensitive ((GtkWidget*) _data3_->unlock_button, TRUE);
		_tmp0_ = _data3_->place;
		seahorse_lockable_unlock_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		seahorse_key_manager_check_empty_state (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		gtk_widget_set_sensitive ((GtkWidget*) _data3_->unlock_button, TRUE);
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t unlock keyring"), _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda22__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda22_ (self, source_object, res);
	block3_data_unref (self);
}

static void
seahorse_key_manager_on_locked_keyring_unlock_button_clicked (SeahorseKeyManager* self,
                                                              GtkButton* unlock_button)
{
	Block3Data* _data3_;
	GtkButton* _tmp0_;
	SeahorseSidebar* _tmp1_;
	SeahorsePlace* _tmp2_;
	SeahorseLockable* _tmp3_;
	gboolean _tmp4_ = FALSE;
	SeahorseLockable* _tmp5_;
	SeahorseLockable* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unlock_button != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (unlock_button);
	_g_object_unref0 (_data3_->unlock_button);
	_data3_->unlock_button = _tmp0_;
	_tmp1_ = self->priv->sidebar;
	_tmp2_ = seahorse_sidebar_get_focused_place (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, SEAHORSE_TYPE_LOCKABLE) ? ((SeahorseLockable*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	_data3_->place = _tmp3_;
	_tmp5_ = _data3_->place;
	if (_tmp5_ != NULL) {
		SeahorseLockable* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = _data3_->place;
		_tmp7_ = seahorse_lockable_get_unlockable (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_if_fail (_tmp4_);
	gtk_widget_set_sensitive ((GtkWidget*) _data3_->unlock_button, FALSE);
	_tmp9_ = _data3_->place;
	seahorse_lockable_unlock (_tmp9_, NULL, NULL, ___lambda22__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
_seahorse_key_manager_on_locked_keyring_unlock_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self)
{
	seahorse_key_manager_on_locked_keyring_unlock_button_clicked ((SeahorseKeyManager*) self, _sender);
}

static gboolean
seahorse_key_manager_on_key_pressed (SeahorseKeyManager* self,
                                     GtkWidget* widget,
                                     GdkEventKey* event)
{
	gboolean folded = FALSE;
	HdyLeaflet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkSearchBar* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->content_box;
	_tmp1_ = hdy_leaflet_get_folded (_tmp0_);
	_tmp2_ = _tmp1_;
	folded = _tmp2_;
	switch (event->keyval) {
		case GDK_KEY_Down:
		{
			gboolean _tmp3_ = FALSE;
			if ((event->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
				_tmp3_ = !folded;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				SeahorseSidebar* _tmp4_;
				_tmp4_ = self->priv->sidebar;
				seahorse_sidebar_select_next_place (_tmp4_);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Up:
		{
			gboolean _tmp5_ = FALSE;
			if ((event->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
				_tmp5_ = !folded;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				SeahorseSidebar* _tmp6_;
				_tmp6_ = self->priv->sidebar;
				seahorse_sidebar_select_previous_place (_tmp6_);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Left:
		{
			gboolean _tmp7_ = FALSE;
			if ((event->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
				_tmp7_ = folded;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				seahorse_key_manager_show_sidebar_pane (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Right:
		{
			gboolean _tmp8_ = FALSE;
			if ((event->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
				_tmp8_ = folded;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				seahorse_key_manager_show_item_list_pane (self);
				result = TRUE;
				return result;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp9_ = self->priv->search_bar;
	result = gtk_search_bar_handle_event (_tmp9_, (GdkEvent*) event);
	return result;
}

static gboolean
_seahorse_key_manager_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self)
{
	gboolean result;
	result = seahorse_key_manager_on_key_pressed ((SeahorseKeyManager*) self, _sender, event);
	return result;
}

static void
seahorse_key_manager_class_init (SeahorseKeyManagerClass * klass,
                                 gpointer klass_data)
{
	seahorse_key_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseKeyManager_private_offset);
	((SeahorseCatalogClass *) klass)->selection_changed = (void (*) (SeahorseCatalog*)) seahorse_key_manager_real_selection_changed;
	((SeahorseCatalogClass *) klass)->get_selected_objects = (GList* (*) (SeahorseCatalog*)) seahorse_key_manager_real_get_selected_objects;
	((SeahorseCatalogClass *) klass)->get_backends = (GList* (*) (SeahorseCatalog*)) seahorse_key_manager_real_get_backends;
	G_OBJECT_CLASS (klass)->finalize = seahorse_key_manager_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-key-manager.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_header", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, left_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "right_header", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, right_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_revealer", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, back_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_bar", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, search_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filter_entry", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, filter_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_box", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, content_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sidebar_area", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, sidebar_area));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_stack", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, content_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "item_listbox", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, item_listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_item_button", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, new_item_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_search_button", FALSE, SeahorseKeyManager_private_offset + G_STRUCT_OFFSET (SeahorseKeyManagerPrivate, show_search_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_filter_changed", G_CALLBACK(_seahorse_key_manager_on_filter_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_back_clicked", G_CALLBACK(_seahorse_key_manager_on_back_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_fold", G_CALLBACK(_seahorse_key_manager_on_fold_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_drag_data_received", G_CALLBACK(_seahorse_key_manager_on_drag_data_received_gtk_widget_drag_data_received));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_popover_grab_notify", G_CALLBACK(_seahorse_key_manager_on_popover_grab_notify_gtk_widget_grab_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_locked_keyring_unlock_button_clicked", G_CALLBACK(_seahorse_key_manager_on_locked_keyring_unlock_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_pressed", G_CALLBACK(_seahorse_key_manager_on_key_pressed_gtk_widget_key_press_event));
}

static void
seahorse_key_manager_instance_init (SeahorseKeyManager * self,
                                    gpointer klass)
{
	self->priv = seahorse_key_manager_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_key_manager_finalize (GObject * obj)
{
	SeahorseKeyManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManager);
	_g_object_unref0 (self->priv->sidebar);
	_g_object_unref0 (self->priv->item_list);
	_g_object_unref0 (self->priv->collection);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (seahorse_key_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_key_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseKeyManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_key_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseKeyManager), 0, (GInstanceInitFunc) seahorse_key_manager_instance_init, NULL };
	GType seahorse_key_manager_type_id;
	seahorse_key_manager_type_id = g_type_register_static (SEAHORSE_TYPE_CATALOG, "SeahorseKeyManager", &g_define_type_info, 0);
	SeahorseKeyManager_private_offset = g_type_add_instance_private (seahorse_key_manager_type_id, sizeof (SeahorseKeyManagerPrivate));
	return seahorse_key_manager_type_id;
}

GType
seahorse_key_manager_get_type (void)
{
	static volatile gsize seahorse_key_manager_type_id__once = 0;
	if (g_once_init_enter (&seahorse_key_manager_type_id__once)) {
		GType seahorse_key_manager_type_id;
		seahorse_key_manager_type_id = seahorse_key_manager_get_type_once ();
		g_once_init_leave (&seahorse_key_manager_type_id__once, seahorse_key_manager_type_id);
	}
	return seahorse_key_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

