/* pkcs11-request.c generated by valac 0.56.7, the Vala compiler
 * generated from pkcs11-request.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2013 Red Hat Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Stef Walter <stefw@redhat.com>
 */

#include "seahorse-pkcs11.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gck/gck.h>
#include <glib-object.h>
#include <gcr/gcr-base.h>
#include "seahorse-common.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

enum  {
	SEAHORSE_PKCS11_REQUEST_0_PROPERTY,
	SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY_PROPERTY,
	SEAHORSE_PKCS11_REQUEST_NUM_PROPERTIES
};
static GParamSpec* seahorse_pkcs11_request_properties[SEAHORSE_PKCS11_REQUEST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

struct _SeahorsePkcs11RequestPrivate {
	SeahorsePkcs11PrivateKey* _private_key;
	GtkEntry* _name_entry;
	guint8* _encoded;
	gint _encoded_length1;
	gint __encoded_size_;
};

struct _Block3Data {
	int _ref_count_;
	SeahorsePkcs11Request* self;
	GcrCertificateRequest* req;
};

struct _Block4Data {
	int _ref_count_;
	SeahorsePkcs11Request* self;
	GtkWindow* parent;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GFile* file;
};

static gint SeahorsePkcs11Request_private_offset;
static gpointer seahorse_pkcs11_request_parent_class = NULL;
static gchar* seahorse_pkcs11_request_BAD_FILENAME_CHARS;
static gchar* seahorse_pkcs11_request_BAD_FILENAME_CHARS = NULL;

static void seahorse_pkcs11_request_real_response (GtkDialog* base,
                                            gint response_id);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda5_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void seahorse_pkcs11_request_save_certificate_request (SeahorsePkcs11Request* self,
                                                       GcrCertificateRequest* req,
                                                       GtkWindow* parent);
static void ____lambda5__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void seahorse_pkcs11_request_update_response (SeahorsePkcs11Request* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda6_ (Block5Data* _data5_,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda6__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GObject * seahorse_pkcs11_request_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _seahorse_pkcs11_request___lambda7_ (SeahorsePkcs11Request* self);
static void __seahorse_pkcs11_request___lambda7__gtk_editable_changed (GtkEditable* _sender,
                                                                gpointer self);
static void seahorse_pkcs11_request_finalize (GObject * obj);
static GType seahorse_pkcs11_request_get_type_once (void);
static void _vala_seahorse_pkcs11_request_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_seahorse_pkcs11_request_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_pkcs11_request_get_instance_private (SeahorsePkcs11Request* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorsePkcs11Request_private_offset);
}

void
seahorse_pkcs11_request_prompt (GtkWindow* parent,
                                GckObject* private_key)
{
	SeahorsePkcs11Request* dialog = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	g_return_if_fail (private_key != NULL);
	_tmp0_ = g_object_new (SEAHORSE_PKCS11_TYPE_REQUEST, "transient-for", parent, "private-key", private_key, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	dialog = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
	gtk_dialog_run ((GtkDialog*) dialog);
	_g_object_unref0 (dialog);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SeahorsePkcs11Request* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->req);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda5_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorsePkcs11Request* self;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		GcrCertificateRequest* _tmp0_;
		GcrCertificateRequest* _tmp1_;
		GtkWindow* _tmp2_;
		GtkWindow* _tmp3_;
		_tmp0_ = _data3_->req;
		gcr_certificate_request_complete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = _data3_->req;
		_tmp2_ = gtk_window_get_transient_for ((GtkWindow*) self);
		_tmp3_ = _tmp2_;
		seahorse_pkcs11_request_save_certificate_request (self, _tmp1_, _tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp4_;
		GtkWindow* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = gtk_window_get_transient_for ((GtkWindow*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		seahorse_util_show_error ((GtkWidget*) _tmp5_, _ ("Couldn’t create certificate request"), _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda5__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda5_ (self, source_object, res);
	block3_data_unref (self);
}

static void
seahorse_pkcs11_request_real_response (GtkDialog* base,
                                       gint response_id)
{
	SeahorsePkcs11Request * self;
	self = (SeahorsePkcs11Request*) base;
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		Block3Data* _data3_;
		SeahorseInteraction* interaction = NULL;
		GtkWindow* _tmp0_;
		GtkWindow* _tmp1_;
		SeahorseInteraction* _tmp2_;
		GckSession* session = NULL;
		SeahorsePkcs11PrivateKey* _tmp3_;
		GckSession* _tmp4_;
		GckSession* _tmp5_;
		SeahorseInteraction* _tmp6_;
		SeahorsePkcs11PrivateKey* _tmp7_;
		GcrCertificateRequest* _tmp8_;
		GcrCertificateRequest* _tmp9_;
		GtkEntry* _tmp10_;
		const gchar* _tmp11_;
		GcrCertificateRequest* _tmp12_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->self = g_object_ref (self);
		_tmp0_ = gtk_window_get_transient_for ((GtkWindow*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = seahorse_interaction_new (_tmp1_);
		interaction = _tmp2_;
		_tmp3_ = self->priv->_private_key;
		_tmp4_ = gck_object_get_session ((GckObject*) _tmp3_);
		session = _tmp4_;
		_tmp5_ = session;
		_tmp6_ = interaction;
		gck_session_set_interaction (_tmp5_, (GTlsInteraction*) _tmp6_);
		_tmp7_ = self->priv->_private_key;
		_tmp8_ = gcr_certificate_request_prepare (GCR_CERTIFICATE_REQUEST_PKCS10, (GckObject*) _tmp7_);
		_data3_->req = _tmp8_;
		_tmp9_ = _data3_->req;
		_tmp10_ = self->priv->_name_entry;
		_tmp11_ = gtk_entry_get_text (_tmp10_);
		gcr_certificate_request_set_cn (_tmp9_, _tmp11_);
		_tmp12_ = _data3_->req;
		gcr_certificate_request_complete_async (_tmp12_, NULL, ____lambda5__gasync_ready_callback, block3_data_ref (_data3_));
		gtk_widget_hide ((GtkWidget*) self);
		_g_object_unref0 (session);
		_g_object_unref0 (interaction);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
}

static void
seahorse_pkcs11_request_update_response (SeahorsePkcs11Request* self)
{
	gchar* name = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_name_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, g_strcmp0 (name, "") != 0);
	_g_free0 (name);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SeahorsePkcs11Request* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SeahorsePkcs11Request* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->file);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda6_ (Block5Data* _data5_,
             GObject* obj,
             GAsyncResult* res)
{
	Block4Data* _data4_;
	SeahorsePkcs11Request* self;
	GError* _inner_error0_ = NULL;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		gchar* new_etag = NULL;
		GFile* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = _data5_->file;
		g_file_replace_contents_finish (_tmp0_, res, &_tmp1_, &_inner_error0_);
		_g_free0 (new_etag);
		new_etag = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_etag);
			goto __catch0_g_error;
		}
		_g_free0 (new_etag);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error ((GtkWidget*) _data4_->parent, _ ("Couldn’t save certificate request"), _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda6__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda6_ (self, source_object, res);
	block5_data_unref (self);
}

static void
seahorse_pkcs11_request_save_certificate_request (SeahorsePkcs11Request* self,
                                                  GcrCertificateRequest* req,
                                                  GtkWindow* parent)
{
	Block4Data* _data4_;
	GtkWindow* _tmp0_;
	GtkFileChooserNative* chooser = NULL;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileFilter* der_filter = NULL;
	GtkFileFilter* _tmp3_;
	GtkFileFilter* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileFilter* _tmp7_;
	GtkFileChooserNative* _tmp8_;
	GtkFileFilter* _tmp9_;
	GtkFileFilter* _tmp10_;
	GtkFileChooserNative* _tmp11_;
	GtkFileFilter* _tmp12_;
	GtkFileFilter* pem_filter = NULL;
	GtkFileFilter* _tmp13_;
	GtkFileFilter* _tmp14_;
	GtkFileFilter* _tmp15_;
	GtkFileFilter* _tmp16_;
	GtkFileChooserNative* _tmp17_;
	GtkFileFilter* _tmp18_;
	GtkFileFilter* _tmp19_;
	gchar* label = NULL;
	SeahorsePkcs11PrivateKey* _tmp20_;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gchar* filename = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GtkFileChooserNative* _tmp31_;
	const gchar* _tmp32_;
	GtkFileChooserNative* _tmp33_;
	gint response = 0;
	GtkFileChooserNative* _tmp34_;
	GtkFileChooserNative* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (req != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data4_->parent);
	_data4_->parent = _tmp0_;
	_tmp1_ = gtk_file_chooser_native_new (_ ("Save certificate request"), _data4_->parent, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Save"), _ ("_Cancel"));
	chooser = _tmp1_;
	_tmp2_ = chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp2_, FALSE);
	_tmp3_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp3_);
	der_filter = _tmp3_;
	_tmp4_ = der_filter;
	gtk_buildable_set_name ((GtkBuildable*) _tmp4_, _ ("Certificate request"));
	_tmp5_ = der_filter;
	gtk_file_filter_add_mime_type (_tmp5_, "application/pkcs10");
	_tmp6_ = der_filter;
	gtk_file_filter_add_pattern (_tmp6_, "*.p10");
	_tmp7_ = der_filter;
	gtk_file_filter_add_pattern (_tmp7_, "*.csr");
	_tmp8_ = chooser;
	_tmp9_ = der_filter;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp8_, _tmp10_);
	_tmp11_ = chooser;
	_tmp12_ = der_filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp11_, _tmp12_);
	_tmp13_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp13_);
	pem_filter = _tmp13_;
	_tmp14_ = pem_filter;
	gtk_buildable_set_name ((GtkBuildable*) _tmp14_, _ ("PEM encoded request"));
	_tmp15_ = pem_filter;
	gtk_file_filter_add_mime_type (_tmp15_, "application/pkcs10+pem");
	_tmp16_ = pem_filter;
	gtk_file_filter_add_pattern (_tmp16_, "*.pem");
	_tmp17_ = chooser;
	_tmp18_ = pem_filter;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp17_, _tmp19_);
	_tmp20_ = self->priv->_private_key;
	g_object_get ((GObject*) _tmp20_, "label", &_tmp21_, NULL);
	_g_free0 (label);
	label = _tmp21_;
	_tmp23_ = label;
	if (_tmp23_ == NULL) {
		_tmp22_ = TRUE;
	} else {
		const gchar* _tmp24_;
		_tmp24_ = label;
		_tmp22_ = g_strcmp0 (_tmp24_, "") == 0;
	}
	if (_tmp22_) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("Certificate Request");
		_g_free0 (label);
		label = _tmp25_;
	}
	_tmp26_ = label;
	_tmp27_ = g_strconcat (_tmp26_, ".csr", NULL);
	filename = _tmp27_;
	_tmp28_ = filename;
	_tmp29_ = seahorse_pkcs11_request_BAD_FILENAME_CHARS;
	_tmp30_ = string_delimit (_tmp28_, _tmp29_, '_');
	_g_free0 (filename);
	filename = _tmp30_;
	_tmp31_ = chooser;
	_tmp32_ = filename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp31_, _tmp32_);
	_tmp33_ = chooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp33_, TRUE);
	_tmp34_ = chooser;
	response = gtk_native_dialog_run ((GtkNativeDialog*) _tmp34_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		Block5Data* _data5_;
		gboolean textual = FALSE;
		GtkFileChooserNative* _tmp35_;
		GtkFileFilter* _tmp36_;
		GtkFileFilter* _tmp37_;
		gsize _tmp38_ = 0;
		guint8* _tmp39_;
		GtkFileChooserNative* _tmp40_;
		GFile* _tmp41_;
		GFile* _tmp42_;
		guint8* _tmp43_;
		gint _tmp43__length1;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		_tmp35_ = chooser;
		_tmp36_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp35_);
		_tmp37_ = pem_filter;
		textual = _tmp36_ == _tmp37_;
		_tmp39_ = gcr_certificate_request_encode (req, textual, &_tmp38_);
		self->priv->_encoded = (g_free (self->priv->_encoded), NULL);
		self->priv->_encoded = _tmp39_;
		self->priv->_encoded_length1 = _tmp38_;
		self->priv->__encoded_size_ = self->priv->_encoded_length1;
		_tmp40_ = chooser;
		_tmp41_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp40_);
		_data5_->file = _tmp41_;
		_tmp42_ = _data5_->file;
		_tmp43_ = self->priv->_encoded;
		_tmp43__length1 = self->priv->_encoded_length1;
		g_file_replace_contents_async (_tmp42_, _tmp43_, (gsize) _tmp43__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, ____lambda6__gasync_ready_callback, block5_data_ref (_data5_));
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_tmp44_ = chooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp44_);
	_g_free0 (filename);
	_g_free0 (label);
	_g_object_unref0 (pem_filter);
	_g_object_unref0 (der_filter);
	_g_object_unref0 (chooser);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

SeahorsePkcs11Request*
seahorse_pkcs11_request_construct (GType object_type)
{
	SeahorsePkcs11Request * self = NULL;
	self = (SeahorsePkcs11Request*) g_object_new (object_type, NULL);
	return self;
}

SeahorsePkcs11Request*
seahorse_pkcs11_request_new (void)
{
	return seahorse_pkcs11_request_construct (SEAHORSE_PKCS11_TYPE_REQUEST);
}

SeahorsePkcs11PrivateKey*
seahorse_pkcs11_request_get_private_key (SeahorsePkcs11Request* self)
{
	SeahorsePkcs11PrivateKey* result;
	SeahorsePkcs11PrivateKey* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_private_key;
	result = _tmp0_;
	return result;
}

static void
seahorse_pkcs11_request_set_private_key (SeahorsePkcs11Request* self,
                                         SeahorsePkcs11PrivateKey* value)
{
	SeahorsePkcs11PrivateKey* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_pkcs11_request_get_private_key (self);
	if (old_value != value) {
		SeahorsePkcs11PrivateKey* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_private_key);
		self->priv->_private_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_request_properties[SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY_PROPERTY]);
	}
}

static void
_seahorse_pkcs11_request___lambda7_ (SeahorsePkcs11Request* self)
{
	seahorse_pkcs11_request_update_response (self);
}

static void
__seahorse_pkcs11_request___lambda7__gtk_editable_changed (GtkEditable* _sender,
                                                           gpointer self)
{
	_seahorse_pkcs11_request___lambda7_ ((SeahorsePkcs11Request*) self);
}

static GObject *
seahorse_pkcs11_request_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Request * self;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	GtkBox* content = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkWidget* widget = NULL;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_;
	GtkWidget* _tmp9_;
	GtkBox* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkBuilder* _tmp13_;
	GObject* _tmp14_;
	GtkEntry* _tmp15_;
	GtkEntry* _tmp16_;
	SeahorsePkcs11PrivateKey* _tmp17_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_request_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = g_strdup ("/org/gnome/Seahorse/seahorse-pkcs11-request.ui");
	path = _tmp1_;
	{
		GtkBuilder* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = builder;
		_tmp3_ = path;
		gtk_builder_add_from_resource (_tmp2_, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp4_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = path;
		g_warning ("pkcs11-request.vala:41: couldn't load ui file: %s", _tmp4_);
		_g_free0 (path);
		_g_object_unref0 (builder);
		return obj;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp5_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	content = _tmp6_;
	_tmp7_ = builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "pkcs11-request");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	widget = _tmp9_;
	_tmp10_ = content;
	_tmp11_ = widget;
	gtk_container_add ((GtkContainer*) _tmp10_, _tmp11_);
	_tmp12_ = widget;
	gtk_widget_show (_tmp12_);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "request-name");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->_name_entry);
	self->priv->_name_entry = _tmp15_;
	_tmp16_ = self->priv->_name_entry;
	g_signal_connect_object ((GtkEditable*) _tmp16_, "changed", (GCallback) __seahorse_pkcs11_request___lambda7__gtk_editable_changed, self, 0);
	gtk_dialog_add_buttons ((GtkDialog*) self, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("Create"), GTK_RESPONSE_OK, NULL);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	seahorse_pkcs11_request_update_response (self);
	_tmp17_ = self->priv->_private_key;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gck_object_get_type ())) {
		const gchar* _tmp18_;
		_tmp18_ = g_type_name (gck_object_get_type ());
		g_critical ("pkcs11-request.vala:62: private key is not of type %s", _tmp18_);
	}
	_g_object_unref0 (widget);
	_g_object_unref0 (content);
	_g_free0 (path);
	_g_object_unref0 (builder);
	return obj;
}

static void
seahorse_pkcs11_request_class_init (SeahorsePkcs11RequestClass * klass,
                                    gpointer klass_data)
{
	gchar* _tmp0_;
	seahorse_pkcs11_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorsePkcs11Request_private_offset);
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog*, gint)) seahorse_pkcs11_request_real_response;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pkcs11_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pkcs11_request_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_request_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_request_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY_PROPERTY, seahorse_pkcs11_request_properties[SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY_PROPERTY] = g_param_spec_object ("private-key", "private-key", "private-key", SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_strdup ("/\\<>|?*");
	seahorse_pkcs11_request_BAD_FILENAME_CHARS = _tmp0_;
}

static void
seahorse_pkcs11_request_instance_init (SeahorsePkcs11Request * self,
                                       gpointer klass)
{
	self->priv = seahorse_pkcs11_request_get_instance_private (self);
}

static void
seahorse_pkcs11_request_finalize (GObject * obj)
{
	SeahorsePkcs11Request * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
	_g_object_unref0 (self->priv->_private_key);
	_g_object_unref0 (self->priv->_name_entry);
	self->priv->_encoded = (g_free (self->priv->_encoded), NULL);
	G_OBJECT_CLASS (seahorse_pkcs11_request_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_pkcs11_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Request), 0, (GInstanceInitFunc) seahorse_pkcs11_request_instance_init, NULL };
	GType seahorse_pkcs11_request_type_id;
	seahorse_pkcs11_request_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorsePkcs11Request", &g_define_type_info, 0);
	SeahorsePkcs11Request_private_offset = g_type_add_instance_private (seahorse_pkcs11_request_type_id, sizeof (SeahorsePkcs11RequestPrivate));
	return seahorse_pkcs11_request_type_id;
}

GType
seahorse_pkcs11_request_get_type (void)
{
	static volatile gsize seahorse_pkcs11_request_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pkcs11_request_type_id__once)) {
		GType seahorse_pkcs11_request_type_id;
		seahorse_pkcs11_request_type_id = seahorse_pkcs11_request_get_type_once ();
		g_once_init_leave (&seahorse_pkcs11_request_type_id__once, seahorse_pkcs11_request_type_id);
	}
	return seahorse_pkcs11_request_type_id__once;
}

static void
_vala_seahorse_pkcs11_request_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	SeahorsePkcs11Request * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
	switch (property_id) {
		case SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY_PROPERTY:
		g_value_set_object (value, seahorse_pkcs11_request_get_private_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_pkcs11_request_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	SeahorsePkcs11Request * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
	switch (property_id) {
		case SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY_PROPERTY:
		seahorse_pkcs11_request_set_private_key (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

