/* pkcs11-properties.c generated by valac 0.56.7, the Vala compiler
 * generated from pkcs11-properties.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2013 Red Hat Inc.
 * Copyright (C) 2020 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Author: Stef Walter <stefw@redhat.com>
 */

#include "seahorse-pkcs11.h"
#include <gck/gck.h>
#include <gtk/gtk.h>
#include <ui/gcr-ui.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "seahorse-common.h"
#include <gcr/gcr-base.h>

enum  {
	SEAHORSE_PKCS11_PROPERTIES_0_PROPERTY,
	SEAHORSE_PKCS11_PROPERTIES_OBJECT_PROPERTY,
	SEAHORSE_PKCS11_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* seahorse_pkcs11_properties_properties[SEAHORSE_PKCS11_PROPERTIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gck_attributes_unref0(var) ((var == NULL) ? NULL : (var = (gck_attributes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define SEAHORSE_PKCS11_TYPE_KEY_DELETER (seahorse_pkcs11_key_deleter_get_type ())
#define SEAHORSE_PKCS11_KEY_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_PKCS11_TYPE_KEY_DELETER, SeahorsePkcs11KeyDeleter))
#define SEAHORSE_PKCS11_KEY_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_PKCS11_TYPE_KEY_DELETER, SeahorsePkcs11KeyDeleterClass))
#define SEAHORSE_PKCS11_IS_KEY_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_PKCS11_TYPE_KEY_DELETER))
#define SEAHORSE_PKCS11_IS_KEY_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_PKCS11_TYPE_KEY_DELETER))
#define SEAHORSE_PKCS11_KEY_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_PKCS11_TYPE_KEY_DELETER, SeahorsePkcs11KeyDeleterClass))

typedef struct _SeahorsePkcs11KeyDeleter SeahorsePkcs11KeyDeleter;
typedef struct _SeahorsePkcs11KeyDeleterClass SeahorsePkcs11KeyDeleterClass;
typedef struct _Block2Data Block2Data;

struct _SeahorsePkcs11PropertiesPrivate {
	GckObject* _object;
	GtkButton* delete_button;
	GtkButton* export_button;
	GtkButton* request_certificate_button;
	GtkBox* content;
	GcrViewer* _viewer;
	GCancellable* _cancellable;
	GckObject* _request_key;
};

struct _Block1Data {
	int _ref_count_;
	SeahorsePkcs11Properties* self;
	SeahorsePkcs11Deleter* deleter;
};

struct _Block2Data {
	int _ref_count_;
	SeahorsePkcs11Properties* self;
	GObject* object;
};

static gint SeahorsePkcs11Properties_private_offset;
static gpointer seahorse_pkcs11_properties_parent_class = NULL;

static void seahorse_pkcs11_properties_real_dispose (GObject* base);
static void seahorse_pkcs11_properties_update_label (SeahorsePkcs11Properties* self);
static void seahorse_pkcs11_properties_add_renderer_for_object (SeahorsePkcs11Properties* self,
                                                         GObject* object);
static void seahorse_pkcs11_properties_on_export_button_clicked (SeahorsePkcs11Properties* self,
                                                          GtkButton* export_button);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _seahorse_pkcs11_properties_on_export_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void seahorse_pkcs11_properties_on_delete_button_clicked (SeahorsePkcs11Properties* self,
                                                          GtkButton* delete_button);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN SeahorsePkcs11KeyDeleter* seahorse_pkcs11_key_deleter_new (GckObject* cert_or_key);
VALA_EXTERN SeahorsePkcs11KeyDeleter* seahorse_pkcs11_key_deleter_construct (GType object_type,
                                                                 GckObject* cert_or_key);
VALA_EXTERN GType seahorse_pkcs11_key_deleter_get_type (void) G_GNUC_CONST ;
static void ___lambda4_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _seahorse_pkcs11_properties_on_delete_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void seahorse_pkcs11_properties_on_request_certificate_button_clicked (SeahorsePkcs11Properties* self,
                                                                       GtkButton* request_button);
static void _seahorse_pkcs11_properties_on_request_certificate_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                           gpointer self);
static void seahorse_pkcs11_properties_check_certificate_request_capable (SeahorsePkcs11Properties* self,
                                                                   GObject* object);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda8_ (Block2Data* _data2_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static GObject * seahorse_pkcs11_properties_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _seahorse_pkcs11_properties___lambda9_ (SeahorsePkcs11Properties* self);
static void __seahorse_pkcs11_properties___lambda9__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void seahorse_pkcs11_properties_finalize (GObject * obj);
static GType seahorse_pkcs11_properties_get_type_once (void);
static void _vala_seahorse_pkcs11_properties_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_seahorse_pkcs11_properties_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_pkcs11_properties_get_instance_private (SeahorsePkcs11Properties* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorsePkcs11Properties_private_offset);
}

SeahorsePkcs11Properties*
seahorse_pkcs11_properties_construct (GType object_type,
                                      GckObject* object,
                                      GtkWindow* window)
{
	SeahorsePkcs11Properties * self = NULL;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (SeahorsePkcs11Properties*) g_object_new (object_type, "object", object, "transient-for", window, NULL);
	return self;
}

SeahorsePkcs11Properties*
seahorse_pkcs11_properties_new (GckObject* object,
                                GtkWindow* window)
{
	return seahorse_pkcs11_properties_construct (SEAHORSE_PKCS11_TYPE_PROPERTIES, object, window);
}

static void
seahorse_pkcs11_properties_real_dispose (GObject* base)
{
	SeahorsePkcs11Properties * self;
	GCancellable* _tmp0_;
	self = (SeahorsePkcs11Properties*) base;
	_tmp0_ = self->priv->_cancellable;
	g_cancellable_cancel (_tmp0_);
	G_OBJECT_CLASS (seahorse_pkcs11_properties_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
}

static void
seahorse_pkcs11_properties_update_label (SeahorsePkcs11Properties* self)
{
	gchar* label = NULL;
	gchar* description = NULL;
	GckObject* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_object;
	g_object_get ((GObject*) _tmp0_, "label", &_tmp1_, "description", &_tmp2_, NULL);
	_g_free0 (label);
	label = _tmp1_;
	_g_free0 (description);
	description = _tmp2_;
	_tmp4_ = label;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = label;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (_ ("Unnamed"));
		_g_free0 (label);
		label = _tmp6_;
	}
	_tmp7_ = label;
	_tmp8_ = description;
	_tmp9_ = g_strdup_printf ("%s - %s", _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_window_set_title ((GtkWindow*) self, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (description);
	_g_free0 (label);
}

static void
seahorse_pkcs11_properties_add_renderer_for_object (SeahorsePkcs11Properties* self,
                                                    GObject* object)
{
	GckAttributes* attributes = NULL;
	gchar* label = NULL;
	GckAttributes* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	attributes = NULL;
	label = NULL;
	g_object_get (object, "label", &label, "attributes", &attributes, NULL);
	_tmp0_ = attributes;
	if (_tmp0_ != NULL) {
		GcrRenderer* renderer = NULL;
		const gchar* _tmp1_;
		GckAttributes* _tmp2_;
		GcrRenderer* _tmp3_;
		GcrRenderer* _tmp4_;
		_tmp1_ = label;
		_tmp2_ = attributes;
		_tmp3_ = gcr_renderer_create (_tmp1_, _tmp2_);
		renderer = _tmp3_;
		_tmp4_ = renderer;
		if (_tmp4_ != NULL) {
			GcrRenderer* _tmp5_;
			GcrRenderer* _tmp6_;
			GcrRenderer* _tmp7_;
			GObjectClass* _tmp8_;
			GParamSpec* _tmp9_;
			GcrViewer* _tmp11_;
			GcrRenderer* _tmp12_;
			_tmp5_ = renderer;
			g_object_bind_property_with_closures (object, "label", (GObject*) _tmp5_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_tmp6_ = renderer;
			g_object_bind_property_with_closures (object, "attributes", (GObject*) _tmp6_, "attributes", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_tmp7_ = renderer;
			_tmp8_ = G_OBJECT_GET_CLASS ((GObject*) _tmp7_);
			_tmp9_ = g_object_class_find_property (_tmp8_, "object");
			if (_tmp9_ != NULL) {
				GcrRenderer* _tmp10_;
				_tmp10_ = renderer;
				g_object_set ((GObject*) _tmp10_, "object", object, NULL);
			}
			_tmp11_ = self->priv->_viewer;
			_tmp12_ = renderer;
			gcr_viewer_add_renderer (_tmp11_, _tmp12_);
		}
		_g_object_unref0 (renderer);
	}
	_g_free0 (label);
	_gck_attributes_unref0 (attributes);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
seahorse_pkcs11_properties_on_export_button_clicked (SeahorsePkcs11Properties* self,
                                                     GtkButton* export_button)
{
	GList* objects = NULL;
	GckObject* _tmp0_;
	GObject* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (export_button != NULL);
	objects = NULL;
	_tmp0_ = self->priv->_object;
	_tmp1_ = _g_object_ref0 ((GObject*) _tmp0_);
	objects = g_list_append (objects, _tmp1_);
	{
		seahorse_exportable_export_to_prompt_wait (objects, (GtkWindow*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Failed to export certificate"), _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
}

static void
_seahorse_pkcs11_properties_on_export_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	seahorse_pkcs11_properties_on_export_button_clicked ((SeahorsePkcs11Properties*) self, _sender);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SeahorsePkcs11Properties* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->deleter);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorsePkcs11Properties* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		SeahorsePkcs11Deleter* _tmp1_;
		_tmp1_ = _data1_->deleter;
		_tmp0_ = seahorse_deleter_delete_finish ((SeahorseDeleter*) _tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			gtk_widget_destroy ((GtkWidget*) self);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t delete"), _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda4__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static void
seahorse_pkcs11_properties_on_delete_button_clicked (SeahorsePkcs11Properties* self,
                                                     GtkButton* delete_button)
{
	Block1Data* _data1_;
	GObject* partner = NULL;
	GckObject* _tmp0_;
	GObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GObject* _tmp3_;
	SeahorsePkcs11Deleter* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (delete_button != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->_object;
	g_object_get ((GObject*) _tmp0_, "partner", &_tmp1_, NULL);
	_g_object_unref0 (partner);
	partner = _tmp1_;
	_tmp3_ = partner;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		GckObject* _tmp4_;
		_tmp4_ = self->priv->_object;
		_tmp2_ = SEAHORSE_PKCS11_IS_PRIVATE_KEY (_tmp4_);
	}
	if (_tmp2_) {
		GckObject* _tmp5_;
		SeahorsePkcs11KeyDeleter* _tmp6_;
		SeahorsePkcs11Deleter* _tmp7_;
		GObject* _tmp8_;
		_tmp5_ = self->priv->_object;
		_tmp6_ = seahorse_pkcs11_key_deleter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gck_object_get_type (), GckObject));
		_g_object_unref0 (_data1_->deleter);
		_data1_->deleter = (SeahorsePkcs11Deleter*) _tmp6_;
		_tmp7_ = _data1_->deleter;
		_tmp8_ = partner;
		if (!seahorse_deleter_add_object ((SeahorseDeleter*) _tmp7_, _tmp8_)) {
			g_assert_not_reached ();
		}
	} else {
		GckObject* _tmp9_;
		SeahorsePkcs11Deleter* _tmp10_;
		_tmp9_ = self->priv->_object;
		_tmp10_ = seahorse_pkcs11_deleter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gck_object_get_type (), GckObject));
		_g_object_unref0 (_data1_->deleter);
		_data1_->deleter = _tmp10_;
	}
	_tmp11_ = _data1_->deleter;
	if (seahorse_deleter_prompt ((SeahorseDeleter*) _tmp11_, (GtkWindow*) self)) {
		SeahorsePkcs11Deleter* _tmp12_;
		GCancellable* _tmp13_;
		_tmp12_ = _data1_->deleter;
		_tmp13_ = self->priv->_cancellable;
		seahorse_deleter_delete ((SeahorseDeleter*) _tmp12_, _tmp13_, ____lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	}
	_g_object_unref0 (partner);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
_seahorse_pkcs11_properties_on_delete_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	seahorse_pkcs11_properties_on_delete_button_clicked ((SeahorsePkcs11Properties*) self, _sender);
}

static void
seahorse_pkcs11_properties_on_request_certificate_button_clicked (SeahorsePkcs11Properties* self,
                                                                  GtkButton* request_button)
{
	GckObject* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request_button != NULL);
	_tmp0_ = self->priv->_request_key;
	seahorse_pkcs11_request_prompt ((GtkWindow*) self, _tmp0_);
}

static void
_seahorse_pkcs11_properties_on_request_certificate_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                      gpointer self)
{
	seahorse_pkcs11_properties_on_request_certificate_button_clicked ((SeahorsePkcs11Properties*) self, _sender);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SeahorsePkcs11Properties* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->object);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda8_ (Block2Data* _data2_,
            GObject* obj,
            GAsyncResult* res)
{
	SeahorsePkcs11Properties* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = gcr_certificate_request_capable_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			GtkButton* _tmp1_;
			GckObject* _tmp2_;
			_tmp1_ = self->priv->request_certificate_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
			_tmp2_ = _g_object_ref0 ((GckObject*) G_TYPE_CHECK_INSTANCE_CAST (_data2_->object, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey));
			_g_object_unref0 (self->priv->_request_key);
			self->priv->_request_key = _tmp2_;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_message ("pkcs11-properties.vala:176: couldn't check capabilities of private key" \
": %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ (self, source_object, res);
	block2_data_unref (self);
}

static void
seahorse_pkcs11_properties_check_certificate_request_capable (SeahorsePkcs11Properties* self,
                                                              GObject* object)
{
	Block2Data* _data2_;
	GObject* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data2_->object);
	_data2_->object = _tmp0_;
	if (!SEAHORSE_PKCS11_IS_PRIVATE_KEY (_data2_->object)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp1_ = self->priv->_cancellable;
	gcr_certificate_request_capable_async ((GckObject*) G_TYPE_CHECK_INSTANCE_CAST (_data2_->object, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey), _tmp1_, ___lambda8__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

GckObject*
seahorse_pkcs11_properties_get_object (SeahorsePkcs11Properties* self)
{
	GckObject* result;
	GckObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object;
	result = _tmp0_;
	return result;
}

static void
seahorse_pkcs11_properties_set_object (SeahorsePkcs11Properties* self,
                                       GckObject* value)
{
	GckObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_pkcs11_properties_get_object (self);
	if (old_value != value) {
		GckObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_object);
		self->priv->_object = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_properties_properties[SEAHORSE_PKCS11_PROPERTIES_OBJECT_PROPERTY]);
	}
}

static void
_seahorse_pkcs11_properties___lambda9_ (SeahorsePkcs11Properties* self)
{
	seahorse_pkcs11_properties_update_label (self);
}

static void
__seahorse_pkcs11_properties___lambda9__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_seahorse_pkcs11_properties___lambda9_ ((SeahorsePkcs11Properties*) self);
}

static GObject *
seahorse_pkcs11_properties_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Properties * self;
	GCancellable* _tmp0_;
	GcrViewer* _tmp1_;
	GcrViewer* _tmp2_;
	GtkBox* _tmp3_;
	GcrViewer* _tmp4_;
	GcrViewer* _tmp5_;
	GcrViewer* _tmp6_;
	GcrViewer* _tmp7_;
	GckObject* _tmp8_;
	GtkButton* _tmp9_;
	GckObject* _tmp10_;
	GtkButton* _tmp11_;
	GckObject* _tmp12_;
	GckObject* _tmp13_;
	GckObject* _tmp14_;
	GObject* partner = NULL;
	GckObject* _tmp15_;
	GObject* _tmp16_ = NULL;
	GObject* _tmp17_;
	GList* exporters = NULL;
	GckObject* _tmp20_;
	GtkButton* _tmp23_;
	GList* _tmp24_;
	GcrViewer* _tmp25_;
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_properties_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_PROPERTIES, SeahorsePkcs11Properties);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp0_;
	_tmp1_ = gcr_viewer_new_scrolled ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_viewer);
	self->priv->_viewer = _tmp2_;
	_tmp3_ = self->priv->content;
	_tmp4_ = self->priv->_viewer;
	gtk_box_pack_start (_tmp3_, (GtkWidget*) _tmp4_, TRUE, TRUE, (guint) 0);
	_tmp5_ = self->priv->_viewer;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->_viewer;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->_viewer;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->_object;
	_tmp9_ = self->priv->delete_button;
	g_object_bind_property_with_closures ((GObject*) _tmp8_, "deletable", (GObject*) _tmp9_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->_object;
	_tmp11_ = self->priv->export_button;
	g_object_bind_property_with_closures ((GObject*) _tmp10_, "exportable", (GObject*) _tmp11_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp12_ = self->priv->_object;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::label", (GCallback) __seahorse_pkcs11_properties___lambda9__g_object_notify, self, 0);
	seahorse_pkcs11_properties_update_label (self);
	_tmp13_ = self->priv->_object;
	seahorse_pkcs11_properties_add_renderer_for_object (self, (GObject*) _tmp13_);
	_tmp14_ = self->priv->_object;
	seahorse_pkcs11_properties_check_certificate_request_capable (self, (GObject*) _tmp14_);
	_tmp15_ = self->priv->_object;
	g_object_get ((GObject*) _tmp15_, "partner", &_tmp16_, NULL);
	_g_object_unref0 (partner);
	partner = _tmp16_;
	_tmp17_ = partner;
	if (_tmp17_ != NULL) {
		GObject* _tmp18_;
		GObject* _tmp19_;
		_tmp18_ = partner;
		seahorse_pkcs11_properties_add_renderer_for_object (self, _tmp18_);
		_tmp19_ = partner;
		seahorse_pkcs11_properties_check_certificate_request_capable (self, _tmp19_);
	}
	exporters = NULL;
	_tmp20_ = self->priv->_object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, SEAHORSE_TYPE_EXPORTABLE)) {
		GckObject* _tmp21_;
		GList* _tmp22_;
		_tmp21_ = self->priv->_object;
		_tmp22_ = seahorse_exportable_create_exporters (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable), SEAHORSE_EXPORTER_TYPE_ANY);
		(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
		exporters = _tmp22_;
	}
	_tmp23_ = self->priv->export_button;
	_tmp24_ = exporters;
	gtk_widget_set_visible ((GtkWidget*) _tmp23_, _tmp24_ != NULL);
	_tmp25_ = self->priv->_viewer;
	gtk_widget_grab_focus ((GtkWidget*) _tmp25_);
	(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
	_g_object_unref0 (partner);
	return obj;
}

static void
seahorse_pkcs11_properties_class_init (SeahorsePkcs11PropertiesClass * klass,
                                       gpointer klass_data)
{
	seahorse_pkcs11_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorsePkcs11Properties_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) seahorse_pkcs11_properties_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pkcs11_properties_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pkcs11_properties_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_properties_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_properties_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_PROPERTIES_OBJECT_PROPERTY, seahorse_pkcs11_properties_properties[SEAHORSE_PKCS11_PROPERTIES_OBJECT_PROPERTY] = g_param_spec_object ("object", "object", "object", gck_object_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-pkcs11-properties.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, SeahorsePkcs11Properties_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11PropertiesPrivate, delete_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "export_button", FALSE, SeahorsePkcs11Properties_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11PropertiesPrivate, export_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "request_certificate_button", FALSE, SeahorsePkcs11Properties_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11PropertiesPrivate, request_certificate_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content", FALSE, SeahorsePkcs11Properties_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11PropertiesPrivate, content));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_export_button_clicked", G_CALLBACK(_seahorse_pkcs11_properties_on_export_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_button_clicked", G_CALLBACK(_seahorse_pkcs11_properties_on_delete_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_request_certificate_button_clicked", G_CALLBACK(_seahorse_pkcs11_properties_on_request_certificate_button_clicked_gtk_button_clicked));
}

static void
seahorse_pkcs11_properties_instance_init (SeahorsePkcs11Properties * self,
                                          gpointer klass)
{
	self->priv = seahorse_pkcs11_properties_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_pkcs11_properties_finalize (GObject * obj)
{
	SeahorsePkcs11Properties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_PROPERTIES, SeahorsePkcs11Properties);
	_g_object_unref0 (self->priv->_object);
	_g_object_unref0 (self->priv->_viewer);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->_request_key);
	G_OBJECT_CLASS (seahorse_pkcs11_properties_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_pkcs11_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11PropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Properties), 0, (GInstanceInitFunc) seahorse_pkcs11_properties_instance_init, NULL };
	GType seahorse_pkcs11_properties_type_id;
	seahorse_pkcs11_properties_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorsePkcs11Properties", &g_define_type_info, 0);
	SeahorsePkcs11Properties_private_offset = g_type_add_instance_private (seahorse_pkcs11_properties_type_id, sizeof (SeahorsePkcs11PropertiesPrivate));
	return seahorse_pkcs11_properties_type_id;
}

GType
seahorse_pkcs11_properties_get_type (void)
{
	static volatile gsize seahorse_pkcs11_properties_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pkcs11_properties_type_id__once)) {
		GType seahorse_pkcs11_properties_type_id;
		seahorse_pkcs11_properties_type_id = seahorse_pkcs11_properties_get_type_once ();
		g_once_init_leave (&seahorse_pkcs11_properties_type_id__once, seahorse_pkcs11_properties_type_id);
	}
	return seahorse_pkcs11_properties_type_id__once;
}

static void
_vala_seahorse_pkcs11_properties_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SeahorsePkcs11Properties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_PROPERTIES, SeahorsePkcs11Properties);
	switch (property_id) {
		case SEAHORSE_PKCS11_PROPERTIES_OBJECT_PROPERTY:
		g_value_set_object (value, seahorse_pkcs11_properties_get_object (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_pkcs11_properties_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SeahorsePkcs11Properties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_PROPERTIES, SeahorsePkcs11Properties);
	switch (property_id) {
		case SEAHORSE_PKCS11_PROPERTIES_OBJECT_PROPERTY:
		seahorse_pkcs11_properties_set_object (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

