/* certificate-der-exporter.c generated by valac 0.56.7, the Vala compiler
 * generated from certificate-der-exporter.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2012 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include "seahorse-pkcs11.h"
#include <gcr/gcr-base.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "seahorse-common.h"
#include <gtk/gtk.h>

enum  {
	SEAHORSE_CERTIFICATE_DER_EXPORTER_0_PROPERTY,
	SEAHORSE_CERTIFICATE_DER_EXPORTER_FILENAME_PROPERTY,
	SEAHORSE_CERTIFICATE_DER_EXPORTER_CONTENT_TYPE_PROPERTY,
	SEAHORSE_CERTIFICATE_DER_EXPORTER_FILE_FILTER_PROPERTY,
	SEAHORSE_CERTIFICATE_DER_EXPORTER_NUM_PROPERTIES
};
static GParamSpec* seahorse_certificate_der_exporter_properties[SEAHORSE_CERTIFICATE_DER_EXPORTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SeahorseCertificateDerExporterExportData SeahorseCertificateDerExporterExportData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SeahorseCertificateDerExporterPrivate {
	GcrCertificate* _certificate;
	GList* _objects;
};

struct _SeahorseCertificateDerExporterExportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseCertificateDerExporter* self;
	GCancellable* cancellable;
	guchar* result;
	size_t result_length1;
	GcrCertificate* _tmp0_;
	gsize _tmp1_;
	guint8* _tmp2_;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar* _tmp4_;
	gint _tmp4__length1;
};

static gint SeahorseCertificateDerExporter_private_offset;
static gpointer seahorse_certificate_der_exporter_parent_class = NULL;
static SeahorseExporterIface * seahorse_certificate_der_exporter_seahorse_exporter_parent_iface = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GList* seahorse_certificate_der_exporter_real_get_objects (SeahorseExporter* base);
static gboolean seahorse_certificate_der_exporter_real_add_object (SeahorseExporter* base,
                                                            GObject* obj);
static void seahorse_certificate_der_exporter_real_export_data_free (gpointer _data);
static void seahorse_certificate_der_exporter_real_export (SeahorseExporter* base,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean seahorse_certificate_der_exporter_real_export_co (SeahorseCertificateDerExporterExportData* _data_);
static guchar* _vala_array_dup1 (guchar* self,
                          gssize length);
static void seahorse_certificate_der_exporter_finalize (GObject * obj);
static GType seahorse_certificate_der_exporter_get_type_once (void);
static void _vala_seahorse_certificate_der_exporter_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_certificate_der_exporter_get_instance_private (SeahorseCertificateDerExporter* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseCertificateDerExporter_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SeahorseCertificateDerExporter*
seahorse_certificate_der_exporter_construct (GType object_type,
                                             GcrCertificate* certificate)
{
	SeahorseCertificateDerExporter * self = NULL;
	GcrCertificate* _tmp0_;
	GObject* _tmp1_;
	g_return_val_if_fail (certificate != NULL, NULL);
	self = (SeahorseCertificateDerExporter*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (certificate);
	_g_object_unref0 (self->priv->_certificate);
	self->priv->_certificate = _tmp0_;
	_tmp1_ = _g_object_ref0 ((GObject*) certificate);
	self->priv->_objects = g_list_append (self->priv->_objects, _tmp1_);
	return self;
}

SeahorseCertificateDerExporter*
seahorse_certificate_der_exporter_new (GcrCertificate* certificate)
{
	return seahorse_certificate_der_exporter_construct (SEAHORSE_TYPE_CERTIFICATE_DER_EXPORTER, certificate);
}

static GList*
seahorse_certificate_der_exporter_real_get_objects (SeahorseExporter* base)
{
	SeahorseCertificateDerExporter * self;
	GList* _tmp0_;
	GList* result;
	self = (SeahorseCertificateDerExporter*) base;
	_tmp0_ = self->priv->_objects;
	result = _tmp0_;
	return result;
}

static gboolean
seahorse_certificate_der_exporter_real_add_object (SeahorseExporter* base,
                                                   GObject* obj)
{
	SeahorseCertificateDerExporter * self;
	gboolean result;
	self = (SeahorseCertificateDerExporter*) base;
	g_return_val_if_fail (obj != NULL, FALSE);
	result = FALSE;
	return result;
}

static void
seahorse_certificate_der_exporter_real_export_data_free (gpointer _data)
{
	SeahorseCertificateDerExporterExportData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseCertificateDerExporterExportData, _data_);
}

static void
seahorse_certificate_der_exporter_real_export (SeahorseExporter* base,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SeahorseCertificateDerExporter * self;
	SeahorseCertificateDerExporterExportData* _data_;
	SeahorseCertificateDerExporter* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorseCertificateDerExporter*) base;
	_data_ = g_slice_new0 (SeahorseCertificateDerExporterExportData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_certificate_der_exporter_real_export_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_certificate_der_exporter_real_export_co (_data_);
}

static guchar*
seahorse_certificate_der_exporter_export_finish (SeahorseExporter* base,
                                                 GAsyncResult* _res_,
                                                 size_t* result_length1,
                                                 GError** error)
{
	guchar* result;
	SeahorseCertificateDerExporterExportData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static guchar*
_vala_array_dup1 (guchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guchar));
	}
	return NULL;
}

static gboolean
seahorse_certificate_der_exporter_real_export_co (SeahorseCertificateDerExporterExportData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_certificate;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = gcr_certificate_get_der_data (_data_->_tmp0_, &_data_->_tmp1_);
	_data_->_tmp3_ = (_data_->_tmp2_ != NULL) ? _vala_array_dup1 (_data_->_tmp2_, _data_->_tmp1_) : _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = _data_->_tmp3__length1;
	_data_->result_length1 = _data_->_tmp4__length1;
	_data_->result = _data_->_tmp4_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static gchar*
seahorse_certificate_der_exporter_real_get_filename (SeahorseExporter* base)
{
	gchar* result;
	SeahorseCertificateDerExporter* self;
	gchar* label = NULL;
	GcrCertificate* _tmp0_;
	const gchar* _tmp8_;
	gchar* filename = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	self = (SeahorseCertificateDerExporter*) base;
	label = NULL;
	_tmp0_ = self->priv->_certificate;
	if (_tmp0_ != NULL) {
		GcrCertificate* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->_certificate;
		g_object_get (_tmp1_, "label", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_g_free0 (label);
		label = _tmp3_;
		_tmp4_ = label;
		if (_tmp4_ == NULL) {
			GcrCertificate* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->_certificate;
			g_object_get (_tmp5_, "description", &_tmp6_, NULL);
			_tmp7_ = _tmp6_;
			_g_free0 (label);
			label = _tmp7_;
		}
	}
	_tmp8_ = label;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (_ ("Certificate"));
		_g_free0 (label);
		label = _tmp9_;
	}
	_tmp10_ = label;
	_tmp11_ = g_strconcat (_tmp10_, ".crt", NULL);
	filename = _tmp11_;
	_tmp12_ = string_delimit (filename, SEAHORSE_BAD_FILENAME_CHARS, '_');
	result = _tmp12_;
	_g_free0 (filename);
	_g_free0 (label);
	return result;
}

static const gchar*
seahorse_certificate_der_exporter_real_get_content_type (SeahorseExporter* base)
{
	const gchar* result;
	SeahorseCertificateDerExporter* self;
	self = (SeahorseCertificateDerExporter*) base;
	result = "application/pkix-cert";
	return result;
}

static GtkFileFilter*
seahorse_certificate_der_exporter_real_get_file_filter (SeahorseExporter* base)
{
	GtkFileFilter* result;
	SeahorseCertificateDerExporter* self;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	self = (SeahorseCertificateDerExporter*) base;
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	filter = _tmp0_;
	gtk_buildable_set_name ((GtkBuildable*) filter, _ ("Certificates (DER encoded)"));
	gtk_file_filter_add_mime_type (filter, "application/pkix-cert");
	gtk_file_filter_add_mime_type (filter, "application/x-x509-ca-cert");
	gtk_file_filter_add_mime_type (filter, "application/x-x509-user-cert");
	gtk_file_filter_add_pattern (filter, "*.cer");
	gtk_file_filter_add_pattern (filter, "*.crt");
	gtk_file_filter_add_pattern (filter, "*.cert");
	result = filter;
	return result;
}

static void
seahorse_certificate_der_exporter_class_init (SeahorseCertificateDerExporterClass * klass,
                                              gpointer klass_data)
{
	seahorse_certificate_der_exporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseCertificateDerExporter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_certificate_der_exporter_get_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_certificate_der_exporter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CERTIFICATE_DER_EXPORTER_FILENAME_PROPERTY, seahorse_certificate_der_exporter_properties[SEAHORSE_CERTIFICATE_DER_EXPORTER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CERTIFICATE_DER_EXPORTER_CONTENT_TYPE_PROPERTY, seahorse_certificate_der_exporter_properties[SEAHORSE_CERTIFICATE_DER_EXPORTER_CONTENT_TYPE_PROPERTY] = g_param_spec_string ("content-type", "content-type", "content-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CERTIFICATE_DER_EXPORTER_FILE_FILTER_PROPERTY, seahorse_certificate_der_exporter_properties[SEAHORSE_CERTIFICATE_DER_EXPORTER_FILE_FILTER_PROPERTY] = g_param_spec_object ("file-filter", "file-filter", "file-filter", gtk_file_filter_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_certificate_der_exporter_seahorse_exporter_interface_init (SeahorseExporterIface * iface,
                                                                    gpointer iface_data)
{
	seahorse_certificate_der_exporter_seahorse_exporter_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_objects = (GList* (*) (SeahorseExporter*)) seahorse_certificate_der_exporter_real_get_objects;
	iface->add_object = (gboolean (*) (SeahorseExporter*, GObject*)) seahorse_certificate_der_exporter_real_add_object;
	iface->export = (void (*) (SeahorseExporter*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_certificate_der_exporter_real_export;
	iface->export_finish = (guint8* (*) (SeahorseExporter*, GAsyncResult*, size_t*, GError**)) seahorse_certificate_der_exporter_export_finish;
	iface->get_filename = seahorse_certificate_der_exporter_real_get_filename;
	iface->get_content_type = seahorse_certificate_der_exporter_real_get_content_type;
	iface->get_file_filter = seahorse_certificate_der_exporter_real_get_file_filter;
}

static void
seahorse_certificate_der_exporter_instance_init (SeahorseCertificateDerExporter * self,
                                                 gpointer klass)
{
	self->priv = seahorse_certificate_der_exporter_get_instance_private (self);
}

static void
seahorse_certificate_der_exporter_finalize (GObject * obj)
{
	SeahorseCertificateDerExporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CERTIFICATE_DER_EXPORTER, SeahorseCertificateDerExporter);
	_g_object_unref0 (self->priv->_certificate);
	(self->priv->_objects == NULL) ? NULL : (self->priv->_objects = (_g_list_free__g_object_unref0_ (self->priv->_objects), NULL));
	G_OBJECT_CLASS (seahorse_certificate_der_exporter_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_certificate_der_exporter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseCertificateDerExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_certificate_der_exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseCertificateDerExporter), 0, (GInstanceInitFunc) seahorse_certificate_der_exporter_instance_init, NULL };
	static const GInterfaceInfo seahorse_exporter_info = { (GInterfaceInitFunc) seahorse_certificate_der_exporter_seahorse_exporter_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_certificate_der_exporter_type_id;
	seahorse_certificate_der_exporter_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseCertificateDerExporter", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_certificate_der_exporter_type_id, SEAHORSE_TYPE_EXPORTER, &seahorse_exporter_info);
	SeahorseCertificateDerExporter_private_offset = g_type_add_instance_private (seahorse_certificate_der_exporter_type_id, sizeof (SeahorseCertificateDerExporterPrivate));
	return seahorse_certificate_der_exporter_type_id;
}

GType
seahorse_certificate_der_exporter_get_type (void)
{
	static volatile gsize seahorse_certificate_der_exporter_type_id__once = 0;
	if (g_once_init_enter (&seahorse_certificate_der_exporter_type_id__once)) {
		GType seahorse_certificate_der_exporter_type_id;
		seahorse_certificate_der_exporter_type_id = seahorse_certificate_der_exporter_get_type_once ();
		g_once_init_leave (&seahorse_certificate_der_exporter_type_id__once, seahorse_certificate_der_exporter_type_id);
	}
	return seahorse_certificate_der_exporter_type_id__once;
}

static void
_vala_seahorse_certificate_der_exporter_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	SeahorseCertificateDerExporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CERTIFICATE_DER_EXPORTER, SeahorseCertificateDerExporter);
	switch (property_id) {
		case SEAHORSE_CERTIFICATE_DER_EXPORTER_FILENAME_PROPERTY:
		g_value_take_string (value, seahorse_exporter_get_filename ((SeahorseExporter*) self));
		break;
		case SEAHORSE_CERTIFICATE_DER_EXPORTER_CONTENT_TYPE_PROPERTY:
		g_value_set_string (value, seahorse_exporter_get_content_type ((SeahorseExporter*) self));
		break;
		case SEAHORSE_CERTIFICATE_DER_EXPORTER_FILE_FILTER_PROPERTY:
		g_value_take_object (value, seahorse_exporter_get_file_filter ((SeahorseExporter*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

