/* gkr-item-properties.c generated by valac 0.56.7, the Vala compiler
 * generated from gkr-item-properties.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2018 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-gkr.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <handy.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include "seahorse-common.h"
#include <gdk/gdk.h>

enum  {
	SEAHORSE_GKR_ITEM_PROPERTIES_0_PROPERTY,
	SEAHORSE_GKR_ITEM_PROPERTIES_ITEM_PROPERTY,
	SEAHORSE_GKR_ITEM_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_item_properties_properties[SEAHORSE_GKR_ITEM_PROPERTIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
typedef struct _SeahorseGkrItemPropertiesSavePasswordData SeahorseGkrItemPropertiesSavePasswordData;
typedef struct _SeahorseGkrItemPropertiesSaveDescriptionData SeahorseGkrItemPropertiesSaveDescriptionData;
typedef struct _Block4Data Block4Data;

struct _SeahorseGkrItemPropertiesPrivate {
	SeahorseGkrItem* _item;
	GtkEntry* description_field;
	gboolean description_has_changed;
	GtkLabel* use_field;
	GtkLabel* type_field;
	HdyPreferencesGroup* details_group;
	GtkListBox* details_box;
	HdyActionRow* server_row;
	GtkLabel* server_field;
	HdyActionRow* login_row;
	GtkLabel* login_field;
	GtkBox* password_box_area;
	SeahorseGkrPasswordEntry* password_entry;
};

struct _Block3Data {
	int _ref_count_;
	SeahorseGkrItemProperties* self;
	GtkMessageDialog* dialog;
};

struct _SeahorseGkrItemPropertiesSavePasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrItemProperties* self;
	SecretValue* pw;
	SeahorseGkrPasswordEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SecretValue* _tmp3_;
	SeahorseGkrItem* _tmp4_;
	GError* err;
	GError* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _SeahorseGkrItemPropertiesSaveDescriptionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrItemProperties* self;
	SeahorseGkrItem* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* err;
	GtkEntry* _tmp4_;
	SeahorseGkrItem* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	SeahorseGkrItemProperties* self;
	SeahorseDeleter* deleter;
};

static gint SeahorseGkrItemProperties_private_offset;
static gpointer seahorse_gkr_item_properties_parent_class = NULL;

static void seahorse_gkr_item_properties_real_response (GtkDialog* base,
                                                 gint response);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_,
                 gint resp);
static void seahorse_gkr_item_properties_save_password (SeahorseGkrItemProperties* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void seahorse_gkr_item_properties_save_password_finish (SeahorseGkrItemProperties* self,
                                                        GAsyncResult* _res_);
static void seahorse_gkr_item_properties_save_description (SeahorseGkrItemProperties* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static void seahorse_gkr_item_properties_save_description_finish (SeahorseGkrItemProperties* self,
                                                           GAsyncResult* _res_);
static void ___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static void seahorse_gkr_item_properties_update_use (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_type (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_visibility (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_server (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_user (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_update_details (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_save_password_data_free (gpointer _data);
static gboolean seahorse_gkr_item_properties_save_password_co (SeahorseGkrItemPropertiesSavePasswordData* _data_);
static void seahorse_gkr_item_properties_save_password_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void seahorse_gkr_item_properties_fetch_password (SeahorseGkrItemProperties* self);
static void seahorse_gkr_item_properties_save_description_data_free (gpointer _data);
static gboolean seahorse_gkr_item_properties_save_description_co (SeahorseGkrItemPropertiesSaveDescriptionData* _data_);
static void seahorse_gkr_item_properties_save_description_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void seahorse_gkr_item_properties_on_copy_button_clicked (SeahorseGkrItemProperties* self);
static void _seahorse_gkr_item_properties_on_copy_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void seahorse_gkr_item_properties_on_delete_button_clicked (SeahorseGkrItemProperties* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda9_ (Block4Data* _data4_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _seahorse_gkr_item_properties_on_delete_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self);
static GObject * seahorse_gkr_item_properties_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _seahorse_gkr_item_properties___lambda10_ (SeahorseGkrItemProperties* self);
static void __seahorse_gkr_item_properties___lambda10__gtk_editable_changed (GtkEditable* _sender,
                                                                      gpointer self);
static void _seahorse_gkr_item_properties___lambda11_ (SeahorseGkrItemProperties* self,
                                                GParamSpec* pspec);
static void __seahorse_gkr_item_properties___lambda11__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void seahorse_gkr_item_properties_finalize (GObject * obj);
static GType seahorse_gkr_item_properties_get_type_once (void);
static void _vala_seahorse_gkr_item_properties_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_seahorse_gkr_item_properties_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
seahorse_gkr_item_properties_get_instance_private (SeahorseGkrItemProperties* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrItemProperties_private_offset);
}

SeahorseGkrItemProperties*
seahorse_gkr_item_properties_construct (GType object_type,
                                        SeahorseGkrItem* item,
                                        GtkWindow* parent)
{
	SeahorseGkrItemProperties * self = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	self = (SeahorseGkrItemProperties*) g_object_new (object_type, "item", item, "transient-for", parent, "use-header-bar", 1, NULL);
	seahorse_gkr_item_refresh (item);
	return self;
}

SeahorseGkrItemProperties*
seahorse_gkr_item_properties_new (SeahorseGkrItem* item,
                                  GtkWindow* parent)
{
	return seahorse_gkr_item_properties_construct (SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, item, parent);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SeahorseGkrItemProperties* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda7_ (Block3Data* _data3_,
            gint resp)
{
	SeahorseGkrItemProperties* self;
	GtkMessageDialog* _tmp3_;
	self = _data3_->self;
	if (resp == ((gint) GTK_RESPONSE_OK)) {
		SeahorseGkrPasswordEntry* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->password_entry;
		_tmp1_ = seahorse_gkr_password_entry_get_has_changed (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			seahorse_gkr_item_properties_save_password (self, NULL, NULL);
		}
		if (self->priv->description_has_changed) {
			seahorse_gkr_item_properties_save_description (self, NULL, NULL);
		}
	}
	_tmp3_ = _data3_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
}

static void
___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda7_ (self, response_id);
}

static void
seahorse_gkr_item_properties_real_response (GtkDialog* base,
                                            gint response)
{
	SeahorseGkrItemProperties * self;
	Block3Data* _data3_;
	gboolean _tmp0_ = FALSE;
	SeahorseGkrPasswordEntry* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	self = (SeahorseGkrItemProperties*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp1_ = self->priv->password_entry;
	_tmp2_ = seahorse_gkr_password_entry_get_has_changed (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		_tmp0_ = !self->priv->description_has_changed;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_destroy ((GtkWidget*) self);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK_CANCEL, "%s", _ ("Save changes for this item?"));
	g_object_ref_sink (_tmp4_);
	_data3_->dialog = _tmp4_;
	_tmp5_ = _data3_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp5_, "response", (GCallback) ___lambda7__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp6_ = _data3_->dialog;
	gtk_dialog_run ((GtkDialog*) _tmp6_);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
seahorse_gkr_item_properties_update_use (SeahorseGkrItemProperties* self)
{
	SeahorseGkrItem* _tmp0_;
	SeahorseGkrUse _tmp1_;
	SeahorseGkrUse _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_gkr_item_get_use (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case SEAHORSE_GKR_USE_NETWORK:
		{
			GtkLabel* _tmp3_;
			_tmp3_ = self->priv->use_field;
			gtk_label_set_label (_tmp3_, _ ("Access a network share or resource"));
			break;
		}
		case SEAHORSE_GKR_USE_WEB:
		{
			GtkLabel* _tmp4_;
			_tmp4_ = self->priv->use_field;
			gtk_label_set_label (_tmp4_, _ ("Access a website"));
			break;
		}
		case SEAHORSE_GKR_USE_PGP:
		{
			GtkLabel* _tmp5_;
			_tmp5_ = self->priv->use_field;
			gtk_label_set_label (_tmp5_, _ ("Unlocks a PGP key"));
			break;
		}
		case SEAHORSE_GKR_USE_SSH:
		{
			GtkLabel* _tmp6_;
			_tmp6_ = self->priv->use_field;
			gtk_label_set_label (_tmp6_, _ ("Unlocks a Secure Shell key"));
			break;
		}
		case SEAHORSE_GKR_USE_OTHER:
		{
			GtkLabel* _tmp7_;
			_tmp7_ = self->priv->use_field;
			gtk_label_set_label (_tmp7_, _ ("Saved password or login"));
			break;
		}
		default:
		{
			GtkLabel* _tmp8_;
			_tmp8_ = self->priv->use_field;
			gtk_label_set_label (_tmp8_, "");
			break;
		}
	}
}

static void
seahorse_gkr_item_properties_update_type (SeahorseGkrItemProperties* self)
{
	SeahorseGkrItem* _tmp0_;
	SeahorseGkrUse _tmp1_;
	SeahorseGkrUse _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_gkr_item_get_use (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case SEAHORSE_GKR_USE_NETWORK:
		case SEAHORSE_GKR_USE_WEB:
		{
			GtkLabel* _tmp3_;
			_tmp3_ = self->priv->type_field;
			gtk_label_set_label (_tmp3_, _ ("Network Credentials"));
			break;
		}
		case SEAHORSE_GKR_USE_PGP:
		case SEAHORSE_GKR_USE_SSH:
		case SEAHORSE_GKR_USE_OTHER:
		{
			GtkLabel* _tmp4_;
			_tmp4_ = self->priv->type_field;
			gtk_label_set_label (_tmp4_, _ ("Password"));
			break;
		}
		default:
		{
			GtkLabel* _tmp5_;
			_tmp5_ = self->priv->type_field;
			gtk_label_set_label (_tmp5_, "");
			break;
		}
	}
}

static void
seahorse_gkr_item_properties_update_visibility (SeahorseGkrItemProperties* self)
{
	SeahorseGkrUse use = 0;
	SeahorseGkrItem* _tmp0_;
	SeahorseGkrUse _tmp1_;
	SeahorseGkrUse _tmp2_;
	gboolean _tmp3_ = FALSE;
	HdyActionRow* _tmp4_;
	HdyActionRow* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_gkr_item_get_use (_tmp0_);
	_tmp2_ = _tmp1_;
	use = _tmp2_;
	if (use == SEAHORSE_GKR_USE_NETWORK) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = use == SEAHORSE_GKR_USE_WEB;
	}
	_tmp4_ = self->priv->server_row;
	_tmp5_ = self->priv->login_row;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, _tmp3_);
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, _tmp3_);
}

static void
seahorse_gkr_item_properties_update_server (SeahorseGkrItemProperties* self)
{
	gchar* value = NULL;
	SeahorseGkrItem* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_gkr_item_get_attribute (_tmp0_, "server");
	value = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (value);
		value = _tmp3_;
	}
	_tmp4_ = self->priv->server_field;
	_tmp5_ = value;
	gtk_label_set_label (_tmp4_, _tmp5_);
	_g_free0 (value);
}

static void
seahorse_gkr_item_properties_update_user (SeahorseGkrItemProperties* self)
{
	gchar* value = NULL;
	SeahorseGkrItem* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_gkr_item_get_attribute (_tmp0_, "user");
	value = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (value);
		value = _tmp3_;
	}
	_tmp4_ = self->priv->login_field;
	_tmp5_ = value;
	gtk_label_set_label (_tmp4_, _tmp5_);
	_g_free0 (value);
}

static void
seahorse_gkr_item_properties_update_details (SeahorseGkrItemProperties* self)
{
	GHashTable* attrs = NULL;
	SeahorseGkrItem* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTableIter iter = {0};
	GHashTable* _tmp3_;
	gboolean any_details = FALSE;
	gchar* key = NULL;
	gchar* value = NULL;
	HdyPreferencesGroup* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	g_object_get ((SecretRetrievable*) _tmp0_, "attributes", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	attrs = _tmp2_;
	_tmp3_ = attrs;
	g_hash_table_iter_init (&iter, _tmp3_);
	any_details = FALSE;
	while (TRUE) {
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		HdyActionRow* row = NULL;
		HdyActionRow* _tmp12_;
		HdyActionRow* _tmp13_;
		const gchar* _tmp14_;
		HdyActionRow* _tmp15_;
		GtkLabel* label = NULL;
		const gchar* _tmp16_;
		GtkLabel* _tmp17_;
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		GtkLabel* _tmp20_;
		GtkLabel* _tmp21_;
		GtkLabel* _tmp22_;
		HdyActionRow* _tmp23_;
		GtkLabel* _tmp24_;
		HdyActionRow* _tmp25_;
		GtkListBox* _tmp26_;
		HdyActionRow* _tmp27_;
		_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
		_g_free0 (key);
		_tmp7_ = g_strdup ((const gchar*) _tmp4_);
		key = _tmp7_;
		_g_free0 (value);
		_tmp8_ = g_strdup ((const gchar*) _tmp5_);
		value = _tmp8_;
		if (!_tmp6_) {
			break;
		}
		_tmp10_ = key;
		if (g_str_has_prefix (_tmp10_, "gkr:")) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = key;
			_tmp9_ = g_str_has_prefix (_tmp11_, "xdg:");
		}
		if (_tmp9_) {
			continue;
		}
		any_details = TRUE;
		_tmp12_ = (HdyActionRow*) hdy_action_row_new ();
		g_object_ref_sink (_tmp12_);
		row = _tmp12_;
		_tmp13_ = row;
		_tmp14_ = key;
		hdy_preferences_row_set_title ((HdyPreferencesRow*) _tmp13_, _tmp14_);
		_tmp15_ = row;
		gtk_widget_set_can_focus ((GtkWidget*) _tmp15_, FALSE);
		_tmp16_ = value;
		_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
		g_object_ref_sink (_tmp17_);
		label = _tmp17_;
		_tmp18_ = label;
		gtk_label_set_xalign (_tmp18_, (gfloat) 1);
		_tmp19_ = label;
		gtk_label_set_selectable (_tmp19_, TRUE);
		_tmp20_ = label;
		g_object_set (_tmp20_, "wrap", TRUE, NULL);
		_tmp21_ = label;
		g_object_set (_tmp21_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
		_tmp22_ = label;
		gtk_label_set_max_width_chars (_tmp22_, 32);
		_tmp23_ = row;
		_tmp24_ = label;
		gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
		_tmp25_ = row;
		gtk_widget_show_all ((GtkWidget*) _tmp25_);
		_tmp26_ = self->priv->details_box;
		_tmp27_ = row;
		gtk_list_box_insert (_tmp26_, (GtkWidget*) _tmp27_, -1);
		_g_object_unref0 (label);
		_g_object_unref0 (row);
	}
	_tmp28_ = self->priv->details_group;
	gtk_widget_set_visible ((GtkWidget*) _tmp28_, any_details);
	_g_free0 (value);
	_g_free0 (key);
	_g_hash_table_unref0 (attrs);
}

static void
seahorse_gkr_item_properties_save_password_data_free (gpointer _data)
{
	SeahorseGkrItemPropertiesSavePasswordData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemPropertiesSavePasswordData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
seahorse_gkr_item_properties_save_password (SeahorseGkrItemProperties* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SeahorseGkrItemPropertiesSavePasswordData* _data_;
	SeahorseGkrItemProperties* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SeahorseGkrItemPropertiesSavePasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_item_properties_save_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	seahorse_gkr_item_properties_save_password_co (_data_);
}

static void
seahorse_gkr_item_properties_save_password_finish (SeahorseGkrItemProperties* self,
                                                   GAsyncResult* _res_)
{
	SeahorseGkrItemPropertiesSavePasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
seahorse_gkr_item_properties_save_password_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	SeahorseGkrItemPropertiesSavePasswordData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_properties_save_password_co (_data_);
}

static gboolean
seahorse_gkr_item_properties_save_password_co (SeahorseGkrItemPropertiesSavePasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->password_entry;
	_data_->_tmp1_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = secret_value_new (_data_->_tmp2_, (gssize) -1, "text/plain");
	_data_->pw = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->self->priv->_item;
		_data_->_state_ = 1;
		seahorse_gkr_item_set_secret (_data_->_tmp4_, _data_->pw, NULL, seahorse_gkr_item_properties_save_password_ready, _data_);
		return FALSE;
		_state_1:
		seahorse_gkr_item_set_secret_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->err;
		g_dbus_error_strip_remote_error (_data_->_tmp5_);
		_data_->_tmp6_ = _data_->err;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		seahorse_util_show_error ((GtkWidget*) _data_->self, _ ("Couldn’t change password."), _data_->_tmp7_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_secret_value_unref0 (_data_->pw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	seahorse_gkr_item_properties_fetch_password (_data_->self);
	_secret_value_unref0 (_data_->pw);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_item_properties_fetch_password (SeahorseGkrItemProperties* self)
{
	SecretValue* secret = NULL;
	SeahorseGkrItem* _tmp0_;
	SecretValue* _tmp1_;
	SecretValue* _tmp2_;
	SeahorseGkrPasswordEntry* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_gkr_item_get_secret (_tmp0_);
	secret = _tmp1_;
	_tmp2_ = secret;
	if (_tmp2_ != NULL) {
		const gchar* password = NULL;
		SecretValue* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = secret;
		_tmp4_ = secret_value_get_text (_tmp3_);
		password = _tmp4_;
		_tmp5_ = password;
		if (_tmp5_ != NULL) {
			SeahorseGkrPasswordEntry* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->priv->password_entry;
			_tmp7_ = password;
			seahorse_gkr_password_entry_set_initial_password (_tmp6_, _tmp7_);
			_secret_value_unref0 (secret);
			return;
		}
	}
	_tmp8_ = self->priv->password_entry;
	seahorse_gkr_password_entry_set_initial_password (_tmp8_, "");
	_secret_value_unref0 (secret);
}

static void
seahorse_gkr_item_properties_save_description_data_free (gpointer _data)
{
	SeahorseGkrItemPropertiesSaveDescriptionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemPropertiesSaveDescriptionData, _data_);
}

static void
seahorse_gkr_item_properties_save_description (SeahorseGkrItemProperties* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SeahorseGkrItemPropertiesSaveDescriptionData* _data_;
	SeahorseGkrItemProperties* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SeahorseGkrItemPropertiesSaveDescriptionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_item_properties_save_description_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	seahorse_gkr_item_properties_save_description_co (_data_);
}

static void
seahorse_gkr_item_properties_save_description_finish (SeahorseGkrItemProperties* self,
                                                      GAsyncResult* _res_)
{
	SeahorseGkrItemPropertiesSaveDescriptionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
seahorse_gkr_item_properties_save_description_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	SeahorseGkrItemPropertiesSaveDescriptionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_properties_save_description_co (_data_);
}

static gboolean
seahorse_gkr_item_properties_save_description_co (SeahorseGkrItemPropertiesSaveDescriptionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_item;
		_data_->_tmp1_ = _data_->self->priv->description_field;
		_data_->_tmp2_ = gtk_entry_get_text (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 1;
		secret_item_set_label ((SecretItem*) _data_->_tmp0_, _data_->_tmp3_, NULL, seahorse_gkr_item_properties_save_description_ready, _data_);
		return FALSE;
		_state_1:
		secret_item_set_label_finish ((SecretItem*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->description_field;
		_data_->_tmp5_ = _data_->self->priv->_item;
		_data_->_tmp6_ = seahorse_gkr_item_get_label (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->_tmp7_;
		gtk_entry_set_text (_data_->_tmp4_, _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		_data_->_tmp9_ = _data_->err;
		g_dbus_error_strip_remote_error (_data_->_tmp9_);
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		seahorse_util_show_error ((GtkWidget*) _data_->self, _ ("Couldn’t set description."), _data_->_tmp11_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_item_properties_on_copy_button_clicked (SeahorseGkrItemProperties* self)
{
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	SeahorseGkrItem* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gtk_clipboard_get_default (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = self->priv->_item;
	seahorse_gkr_item_copy_secret_to_clipboard (_tmp3_, clipboard, NULL, NULL);
	_g_object_unref0 (clipboard);
}

static void
_seahorse_gkr_item_properties_on_copy_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	seahorse_gkr_item_properties_on_copy_button_clicked ((SeahorseGkrItemProperties*) self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SeahorseGkrItemProperties* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->deleter);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda9_ (Block4Data* _data4_,
            GObject* obj,
            GAsyncResult* res)
{
	SeahorseGkrItemProperties* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseDeleter* _tmp0_;
		_tmp0_ = _data4_->deleter;
		seahorse_deleter_delete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gtk_widget_destroy ((GtkWidget*) self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GtkMessageDialog* dialog = NULL;
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* _tmp2_;
		GtkMessageDialog* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _ ("Error deleting the password."));
		g_object_ref_sink (_tmp1_);
		dialog = _tmp1_;
		_tmp2_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp2_);
		_tmp3_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
		_g_object_unref0 (dialog);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda9_ (self, source_object, res);
	block4_data_unref (self);
}

static void
seahorse_gkr_item_properties_on_delete_button_clicked (SeahorseGkrItemProperties* self)
{
	Block4Data* _data4_;
	SeahorseGkrItem* _tmp0_;
	SeahorseDeleter* _tmp1_;
	gboolean ret = FALSE;
	SeahorseDeleter* _tmp2_;
	SeahorseDeleter* _tmp3_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->_item;
	_tmp1_ = seahorse_deletable_create_deleter ((SeahorseDeletable*) _tmp0_);
	_data4_->deleter = _tmp1_;
	_tmp2_ = _data4_->deleter;
	ret = seahorse_deleter_prompt (_tmp2_, (GtkWindow*) self);
	if (!ret) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp3_ = _data4_->deleter;
	seahorse_deleter_delete (_tmp3_, NULL, ___lambda9__gasync_ready_callback, block4_data_ref (_data4_));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
_seahorse_gkr_item_properties_on_delete_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self)
{
	seahorse_gkr_item_properties_on_delete_button_clicked ((SeahorseGkrItemProperties*) self);
}

SeahorseGkrItem*
seahorse_gkr_item_properties_get_item (SeahorseGkrItemProperties* self)
{
	SeahorseGkrItem* result;
	SeahorseGkrItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item;
	result = _tmp0_;
	return result;
}

static void
seahorse_gkr_item_properties_set_item (SeahorseGkrItemProperties* self,
                                       SeahorseGkrItem* value)
{
	SeahorseGkrItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_gkr_item_properties_get_item (self);
	if (old_value != value) {
		SeahorseGkrItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_item);
		self->priv->_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_gkr_item_properties_properties[SEAHORSE_GKR_ITEM_PROPERTIES_ITEM_PROPERTY]);
	}
}

static void
_seahorse_gkr_item_properties___lambda10_ (SeahorseGkrItemProperties* self)
{
	self->priv->description_has_changed = TRUE;
}

static void
__seahorse_gkr_item_properties___lambda10__gtk_editable_changed (GtkEditable* _sender,
                                                                 gpointer self)
{
	_seahorse_gkr_item_properties___lambda10_ ((SeahorseGkrItemProperties*) self);
}

static void
_seahorse_gkr_item_properties___lambda11_ (SeahorseGkrItemProperties* self,
                                           GParamSpec* pspec)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec->name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("use")))) {
		switch (0) {
			default:
			{
				seahorse_gkr_item_properties_update_use (self);
				seahorse_gkr_item_properties_update_type (self);
				seahorse_gkr_item_properties_update_visibility (self);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("attributes")))) {
		switch (0) {
			default:
			{
				seahorse_gkr_item_properties_update_details (self);
				seahorse_gkr_item_properties_update_server (self);
				seahorse_gkr_item_properties_update_user (self);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("has-secret")))) {
		switch (0) {
			default:
			{
				seahorse_gkr_item_properties_fetch_password (self);
				break;
			}
		}
	}
}

static void
__seahorse_gkr_item_properties___lambda11__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_seahorse_gkr_item_properties___lambda11_ ((SeahorseGkrItemProperties*) self, pspec);
}

static GObject *
seahorse_gkr_item_properties_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrItemProperties * self;
	SeahorseGkrItem* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	SeahorseGkrItem* _tmp5_;
	GtkHeaderBar* _tmp6_;
	SeahorseGkrItem* _tmp7_;
	SeahorseGkrPasswordEntry* _tmp8_;
	GtkBox* _tmp9_;
	SeahorseGkrPasswordEntry* _tmp10_;
	SeahorseGkrItem* _tmp11_;
	SeahorseGkrPasswordEntry* _tmp12_;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_item_properties_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	_tmp0_ = self->priv->_item;
	_tmp1_ = self->priv->description_field;
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "label", (GObject*) _tmp1_, "text", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = self->priv->description_field;
	g_signal_connect_object ((GtkEditable*) _tmp2_, "changed", (GCallback) __seahorse_gkr_item_properties___lambda10__gtk_editable_changed, self, 0);
	_tmp3_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_header_bar_get_type (), GtkHeaderBar));
	headerbar = _tmp4_;
	_tmp5_ = self->priv->_item;
	_tmp6_ = headerbar;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "label", (GObject*) _tmp6_, "subtitle", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = self->priv->_item;
	g_signal_connect_object ((GObject*) _tmp7_, "notify", (GCallback) __seahorse_gkr_item_properties___lambda11__g_object_notify, self, 0);
	_tmp8_ = seahorse_gkr_password_entry_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp8_;
	_tmp9_ = self->priv->password_box_area;
	_tmp10_ = self->priv->password_entry;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) _tmp10_, TRUE, TRUE, (guint) 0);
	seahorse_gkr_item_properties_fetch_password (self);
	_tmp11_ = self->priv->_item;
	_tmp12_ = self->priv->password_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp11_, "has-secret", (GObject*) _tmp12_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (headerbar);
	return obj;
}

static void
seahorse_gkr_item_properties_class_init (SeahorseGkrItemPropertiesClass * klass,
                                         gpointer klass_data)
{
	seahorse_gkr_item_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrItemProperties_private_offset);
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog*, gint)) seahorse_gkr_item_properties_real_response;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_item_properties_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_item_properties_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_item_properties_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_properties_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_PROPERTIES_ITEM_PROPERTY, seahorse_gkr_item_properties_properties[SEAHORSE_GKR_ITEM_PROPERTIES_ITEM_PROPERTY] = g_param_spec_object ("item", "item", "item", SEAHORSE_GKR_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-gkr-item-properties.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_field", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, description_field));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "use_field", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, use_field));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "type_field", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, type_field));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "details_group", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, details_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "details_box", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, details_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "server_row", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, server_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "server_field", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, server_field));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "login_row", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, login_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "login_field", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, login_field));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_box_area", FALSE, SeahorseGkrItemProperties_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemPropertiesPrivate, password_box_area));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_copy_button_clicked", G_CALLBACK(_seahorse_gkr_item_properties_on_copy_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_button_clicked", G_CALLBACK(_seahorse_gkr_item_properties_on_delete_button_clicked_gtk_button_clicked));
}

static void
seahorse_gkr_item_properties_instance_init (SeahorseGkrItemProperties * self,
                                            gpointer klass)
{
	self->priv = seahorse_gkr_item_properties_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_gkr_item_properties_finalize (GObject * obj)
{
	SeahorseGkrItemProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	_g_object_unref0 (self->priv->_item);
	_g_object_unref0 (self->priv->password_entry);
	G_OBJECT_CLASS (seahorse_gkr_item_properties_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_item_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemProperties), 0, (GInstanceInitFunc) seahorse_gkr_item_properties_instance_init, NULL };
	GType seahorse_gkr_item_properties_type_id;
	seahorse_gkr_item_properties_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseGkrItemProperties", &g_define_type_info, 0);
	SeahorseGkrItemProperties_private_offset = g_type_add_instance_private (seahorse_gkr_item_properties_type_id, sizeof (SeahorseGkrItemPropertiesPrivate));
	return seahorse_gkr_item_properties_type_id;
}

GType
seahorse_gkr_item_properties_get_type (void)
{
	static volatile gsize seahorse_gkr_item_properties_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_item_properties_type_id__once)) {
		GType seahorse_gkr_item_properties_type_id;
		seahorse_gkr_item_properties_type_id = seahorse_gkr_item_properties_get_type_once ();
		g_once_init_leave (&seahorse_gkr_item_properties_type_id__once, seahorse_gkr_item_properties_type_id);
	}
	return seahorse_gkr_item_properties_type_id__once;
}

static void
_vala_seahorse_gkr_item_properties_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SeahorseGkrItemProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_PROPERTIES_ITEM_PROPERTY:
		g_value_set_object (value, seahorse_gkr_item_properties_get_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_gkr_item_properties_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SeahorseGkrItemProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM_PROPERTIES, SeahorseGkrItemProperties);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_PROPERTIES_ITEM_PROPERTY:
		seahorse_gkr_item_properties_set_item (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

