/* gkr-item-info.c generated by valac 0.56.7, the Vala compiler
 * generated from gkr-item-info.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2020 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>

enum  {
	SEAHORSE_GKR_ITEM_INFO_0_PROPERTY,
	SEAHORSE_GKR_ITEM_INFO_LABEL_PROPERTY,
	SEAHORSE_GKR_ITEM_INFO_DESCRIPTION_PROPERTY,
	SEAHORSE_GKR_ITEM_INFO_DETAILS_PROPERTY,
	SEAHORSE_GKR_ITEM_INFO_ICON_PROPERTY,
	SEAHORSE_GKR_ITEM_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SEAHORSE_GKR_NM_CONNECTION_INFO_0_PROPERTY,
	SEAHORSE_GKR_NM_CONNECTION_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_nm_connection_info_properties[SEAHORSE_GKR_NM_CONNECTION_INFO_NUM_PROPERTIES];
enum  {
	SEAHORSE_GKR_GKR_NETWORK_PASS_INFO_0_PROPERTY,
	SEAHORSE_GKR_GKR_NETWORK_PASS_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_gkr_network_pass_info_properties[SEAHORSE_GKR_GKR_NETWORK_PASS_INFO_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	SEAHORSE_GKR_EPIPHANY_PASS_INFO_0_PROPERTY,
	SEAHORSE_GKR_EPIPHANY_PASS_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_epiphany_pass_info_properties[SEAHORSE_GKR_EPIPHANY_PASS_INFO_NUM_PROPERTIES];
enum  {
	SEAHORSE_GKR_CHROME_PASS_INFO_0_PROPERTY,
	SEAHORSE_GKR_CHROME_PASS_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_chrome_pass_info_properties[SEAHORSE_GKR_CHROME_PASS_INFO_NUM_PROPERTIES];
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SEAHORSE_GKR_EMPATHY_INFO_0_PROPERTY,
	SEAHORSE_GKR_EMPATHY_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_empathy_info_properties[SEAHORSE_GKR_EMPATHY_INFO_NUM_PROPERTIES];
enum  {
	SEAHORSE_GKR_TELEPATHY_INFO_0_PROPERTY,
	SEAHORSE_GKR_TELEPATHY_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_telepathy_info_properties[SEAHORSE_GKR_TELEPATHY_INFO_NUM_PROPERTIES];
enum  {
	SEAHORSE_GKR_GOA_INFO_0_PROPERTY,
	SEAHORSE_GKR_GOA_INFO_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_goa_info_properties[SEAHORSE_GKR_GOA_INFO_NUM_PROPERTIES];

struct _SeahorseGkrItemInfoPrivate {
	gchar* _label;
	gchar* _description;
	gchar* _details;
	GIcon* _icon;
};

static gint SeahorseGkrItemInfo_private_offset;
static gpointer seahorse_gkr_item_info_parent_class = NULL;
static gpointer seahorse_gkr_nm_connection_info_parent_class = NULL;
static gpointer seahorse_gkr_gkr_network_pass_info_parent_class = NULL;
static gpointer seahorse_gkr_epiphany_pass_info_parent_class = NULL;
static gpointer seahorse_gkr_chrome_pass_info_parent_class = NULL;
static gpointer seahorse_gkr_empathy_info_parent_class = NULL;
static gpointer seahorse_gkr_telepathy_info_parent_class = NULL;
static gpointer seahorse_gkr_goa_info_parent_class = NULL;

static const gchar* seahorse_gkr_item_info_guess_username (SeahorseGkrItemInfo* self,
                                                    GHashTable* attrs);
static void seahorse_gkr_item_info_finalize (GObject * obj);
static GType seahorse_gkr_item_info_get_type_once (void);
static void _vala_seahorse_gkr_item_info_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_seahorse_gkr_item_info_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static GType seahorse_gkr_nm_connection_info_get_type_once (void);
static gboolean seahorse_gkr_gkr_network_pass_info_is_custom_network_label (SeahorseGkrGkrNetworkPassInfo* self,
                                                                     const gchar* server,
                                                                     const gchar* user,
                                                                     const gchar* object,
                                                                     gint port,
                                                                     const gchar* label);
static gchar* seahorse_gkr_gkr_network_pass_info_calc_network_label (SeahorseGkrGkrNetworkPassInfo* self,
                                                              GHashTable* attrs,
                                                              gboolean always);
static gboolean seahorse_gkr_gkr_network_pass_info_is_network_item (SeahorseGkrGkrNetworkPassInfo* self,
                                                             GHashTable* attrs,
                                                             const gchar* match);
static GType seahorse_gkr_gkr_network_pass_info_get_type_once (void);
static GType seahorse_gkr_epiphany_pass_info_get_type_once (void);
static GType seahorse_gkr_chrome_pass_info_get_type_once (void);
static GType seahorse_gkr_empathy_info_get_type_once (void);
static GType seahorse_gkr_telepathy_info_get_type_once (void);
static GType seahorse_gkr_goa_info_get_type_once (void);

static inline gpointer
seahorse_gkr_item_info_get_instance_private (SeahorseGkrItemInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrItemInfo_private_offset);
}

SeahorseGkrItemInfo*
seahorse_gkr_item_info_construct (GType object_type,
                                  const gchar* label,
                                  GHashTable* attrs,
                                  const gchar* description)
{
	SeahorseGkrItemInfo * self = NULL;
	const gchar* _tmp0_;
	self = (SeahorseGkrItemInfo*) g_object_new (object_type, "label", label, NULL);
	if (label != NULL) {
		seahorse_gkr_item_info_set_label (self, label);
	}
	if (description != NULL) {
		seahorse_gkr_item_info_set_description (self, description);
	}
	_tmp0_ = seahorse_gkr_item_info_guess_username (self, attrs);
	seahorse_gkr_item_info_set_details (self, _tmp0_);
	return self;
}

SeahorseGkrItemInfo*
seahorse_gkr_item_info_new (const gchar* label,
                            GHashTable* attrs,
                            const gchar* description)
{
	return seahorse_gkr_item_info_construct (SEAHORSE_GKR_TYPE_ITEM_INFO, label, attrs, description);
}

static const gchar*
seahorse_gkr_item_info_guess_username (SeahorseGkrItemInfo* self,
                                       GHashTable* attrs)
{
	const gchar* username = NULL;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gconstpointer _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gconstpointer _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gconstpointer _tmp18_;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	gconstpointer _tmp23_;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (attrs == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_details;
		_tmp0_ = g_strcmp0 (_tmp1_, "") != 0;
	}
	if (_tmp0_) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_details;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_hash_table_lookup (attrs, "username");
	username = (const gchar*) _tmp3_;
	_tmp5_ = username;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = username;
		_tmp4_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp7_;
		_tmp7_ = username;
		result = _tmp7_;
		return result;
	}
	_tmp8_ = g_hash_table_lookup (attrs, "user");
	username = (const gchar*) _tmp8_;
	_tmp10_ = username;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		_tmp11_ = username;
		_tmp9_ = g_strcmp0 (_tmp11_, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp12_;
		_tmp12_ = username;
		result = _tmp12_;
		return result;
	}
	_tmp13_ = g_hash_table_lookup (attrs, "uid");
	username = (const gchar*) _tmp13_;
	_tmp15_ = username;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		_tmp16_ = username;
		_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp17_;
		_tmp17_ = username;
		result = _tmp17_;
		return result;
	}
	_tmp18_ = g_hash_table_lookup (attrs, "login");
	username = (const gchar*) _tmp18_;
	_tmp20_ = username;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		_tmp21_ = username;
		_tmp19_ = g_strcmp0 (_tmp21_, "") != 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		const gchar* _tmp22_;
		_tmp22_ = username;
		result = _tmp22_;
		return result;
	}
	_tmp23_ = g_hash_table_lookup (attrs, "account");
	username = (const gchar*) _tmp23_;
	_tmp25_ = username;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = username;
		_tmp24_ = g_strcmp0 (_tmp26_, "") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		const gchar* _tmp27_;
		_tmp27_ = username;
		result = _tmp27_;
		return result;
	}
	result = NULL;
	return result;
}

void
seahorse_gkr_item_info_query_installed_apps (SeahorseGkrItemInfo* self,
                                             const gchar* item_type)
{
	GDesktopAppInfo* app_info = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	GIcon* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_type != NULL);
	_tmp0_ = g_strdup_printf ("%s.desktop", item_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_desktop_app_info_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	app_info = _tmp3_;
	_tmp4_ = app_info;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	_tmp5_ = app_info;
	_tmp6_ = g_app_info_get_icon ((GAppInfo*) _tmp5_);
	seahorse_gkr_item_info_set_icon (self, _tmp6_);
	_g_object_unref0 (app_info);
}

const gchar*
seahorse_gkr_item_info_get_attribute_string (SeahorseGkrItemInfo* self,
                                             GHashTable* attrs,
                                             const gchar* name)
{
	gconstpointer _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (attrs == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_hash_table_lookup (attrs, name);
	result = (const gchar*) _tmp0_;
	return result;
}

gint
seahorse_gkr_item_info_get_attribute_int (SeahorseGkrItemInfo* self,
                                          GHashTable* attrs,
                                          const gchar* name)
{
	gchar* value = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	if (attrs == NULL) {
		result = 0;
		return result;
	}
	_tmp0_ = g_hash_table_lookup (attrs, name);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	value = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = value;
		result = atoi (_tmp3_);
		_g_free0 (value);
		return result;
	}
	result = 0;
	_g_free0 (value);
	return result;
}

const gchar*
seahorse_gkr_item_info_get_label (SeahorseGkrItemInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
seahorse_gkr_item_info_set_label (SeahorseGkrItemInfo* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_gkr_item_info_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_LABEL_PROPERTY]);
	}
}

const gchar*
seahorse_gkr_item_info_get_description (SeahorseGkrItemInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
seahorse_gkr_item_info_set_description (SeahorseGkrItemInfo* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_gkr_item_info_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
seahorse_gkr_item_info_get_details (SeahorseGkrItemInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_details;
	result = _tmp0_;
	return result;
}

void
seahorse_gkr_item_info_set_details (SeahorseGkrItemInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_gkr_item_info_get_details (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_details);
		self->priv->_details = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_DETAILS_PROPERTY]);
	}
}

GIcon*
seahorse_gkr_item_info_get_icon (SeahorseGkrItemInfo* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
seahorse_gkr_item_info_set_icon (SeahorseGkrItemInfo* self,
                                 GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_gkr_item_info_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_ICON_PROPERTY]);
	}
}

static void
seahorse_gkr_item_info_class_init (SeahorseGkrItemInfoClass * klass,
                                   gpointer klass_data)
{
	seahorse_gkr_item_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrItemInfo_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_item_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_item_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_INFO_LABEL_PROPERTY, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_INFO_DESCRIPTION_PROPERTY, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_INFO_DETAILS_PROPERTY, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_DETAILS_PROPERTY] = g_param_spec_string ("details", "details", "details", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_INFO_ICON_PROPERTY, seahorse_gkr_item_info_properties[SEAHORSE_GKR_ITEM_INFO_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
seahorse_gkr_item_info_instance_init (SeahorseGkrItemInfo * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = seahorse_gkr_item_info_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_label = _tmp0_;
	_tmp1_ = g_strdup (_ ("Password or Secret"));
	self->priv->_description = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_details = _tmp2_;
}

static void
seahorse_gkr_item_info_finalize (GObject * obj)
{
	SeahorseGkrItemInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_INFO, SeahorseGkrItemInfo);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_details);
	_g_object_unref0 (self->priv->_icon);
	G_OBJECT_CLASS (seahorse_gkr_item_info_parent_class)->finalize (obj);
}

/**
 * The generic base class that holds extra info for a {@link Gkr.Item}.
 */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_item_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemInfo), 0, (GInstanceInitFunc) seahorse_gkr_item_info_instance_init, NULL };
	GType seahorse_gkr_item_info_type_id;
	seahorse_gkr_item_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseGkrItemInfo", &g_define_type_info, 0);
	SeahorseGkrItemInfo_private_offset = g_type_add_instance_private (seahorse_gkr_item_info_type_id, sizeof (SeahorseGkrItemInfoPrivate));
	return seahorse_gkr_item_info_type_id;
}

GType
seahorse_gkr_item_info_get_type (void)
{
	static volatile gsize seahorse_gkr_item_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_item_info_type_id__once)) {
		GType seahorse_gkr_item_info_type_id;
		seahorse_gkr_item_info_type_id = seahorse_gkr_item_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_item_info_type_id__once, seahorse_gkr_item_info_type_id);
	}
	return seahorse_gkr_item_info_type_id__once;
}

static void
_vala_seahorse_gkr_item_info_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SeahorseGkrItemInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM_INFO, SeahorseGkrItemInfo);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_INFO_LABEL_PROPERTY:
		g_value_set_string (value, seahorse_gkr_item_info_get_label (self));
		break;
		case SEAHORSE_GKR_ITEM_INFO_DESCRIPTION_PROPERTY:
		g_value_set_string (value, seahorse_gkr_item_info_get_description (self));
		break;
		case SEAHORSE_GKR_ITEM_INFO_DETAILS_PROPERTY:
		g_value_set_string (value, seahorse_gkr_item_info_get_details (self));
		break;
		case SEAHORSE_GKR_ITEM_INFO_ICON_PROPERTY:
		g_value_set_object (value, seahorse_gkr_item_info_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_gkr_item_info_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SeahorseGkrItemInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM_INFO, SeahorseGkrItemInfo);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_INFO_LABEL_PROPERTY:
		seahorse_gkr_item_info_set_label (self, g_value_get_string (value));
		break;
		case SEAHORSE_GKR_ITEM_INFO_DESCRIPTION_PROPERTY:
		seahorse_gkr_item_info_set_description (self, g_value_get_string (value));
		break;
		case SEAHORSE_GKR_ITEM_INFO_DETAILS_PROPERTY:
		seahorse_gkr_item_info_set_details (self, g_value_get_string (value));
		break;
		case SEAHORSE_GKR_ITEM_INFO_ICON_PROPERTY:
		seahorse_gkr_item_info_set_icon (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

SeahorseGkrNmConnectionInfo*
seahorse_gkr_nm_connection_info_construct (GType object_type,
                                           const gchar* label,
                                           GHashTable* attrs)
{
	SeahorseGkrNmConnectionInfo * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	const gchar* setting_name = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SeahorseGkrNmConnectionInfo*) seahorse_gkr_item_info_construct (object_type, label, attrs, _ ("Network connection secret"));
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("network-wired-symbolic");
	_tmp1_ = _tmp0_;
	seahorse_gkr_item_info_set_icon ((SeahorseGkrItemInfo*) self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "setting-name");
	setting_name = _tmp2_;
	_tmp3_ = setting_name;
	if (g_strcmp0 (_tmp3_, "802-11-wireless-security") == 0) {
		GThemedIcon* _tmp4_;
		GThemedIcon* _tmp5_;
		_tmp4_ = (GThemedIcon*) g_themed_icon_new ("network-wireless-symbolic");
		_tmp5_ = _tmp4_;
		seahorse_gkr_item_info_set_icon ((SeahorseGkrItemInfo*) self, (GIcon*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		seahorse_gkr_item_info_set_description ((SeahorseGkrItemInfo*) self, _ ("Wi-Fi password"));
	}
	if (g_str_has_prefix (label, "Network secret for ")) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = seahorse_gkr_item_info_get_label ((SeahorseGkrItemInfo*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = strlen ("Network secret for ");
		_tmp9_ = _tmp8_;
		_tmp10_ = string_substring (_tmp7_, (glong) _tmp9_, (glong) -1);
		_tmp11_ = _tmp10_;
		seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, _tmp11_);
		_g_free0 (_tmp11_);
	}
	return self;
}

SeahorseGkrNmConnectionInfo*
seahorse_gkr_nm_connection_info_new (const gchar* label,
                                     GHashTable* attrs)
{
	return seahorse_gkr_nm_connection_info_construct (SEAHORSE_GKR_TYPE_NM_CONNECTION_INFO, label, attrs);
}

static void
seahorse_gkr_nm_connection_info_class_init (SeahorseGkrNmConnectionInfoClass * klass,
                                            gpointer klass_data)
{
	seahorse_gkr_nm_connection_info_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_gkr_nm_connection_info_instance_init (SeahorseGkrNmConnectionInfo * self,
                                               gpointer klass)
{
}

/**
 * Used for NetworkManager connections, with xdg:schema
 * "org.freedesktop.NetworkManager.Connection"
 */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_nm_connection_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrNmConnectionInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_nm_connection_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrNmConnectionInfo), 0, (GInstanceInitFunc) seahorse_gkr_nm_connection_info_instance_init, NULL };
	GType seahorse_gkr_nm_connection_info_type_id;
	seahorse_gkr_nm_connection_info_type_id = g_type_register_static (SEAHORSE_GKR_TYPE_ITEM_INFO, "SeahorseGkrNmConnectionInfo", &g_define_type_info, 0);
	return seahorse_gkr_nm_connection_info_type_id;
}

GType
seahorse_gkr_nm_connection_info_get_type (void)
{
	static volatile gsize seahorse_gkr_nm_connection_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_nm_connection_info_type_id__once)) {
		GType seahorse_gkr_nm_connection_info_type_id;
		seahorse_gkr_nm_connection_info_type_id = seahorse_gkr_nm_connection_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_nm_connection_info_type_id__once, seahorse_gkr_nm_connection_info_type_id);
	}
	return seahorse_gkr_nm_connection_info_type_id__once;
}

SeahorseGkrGkrNetworkPassInfo*
seahorse_gkr_gkr_network_pass_info_construct (GType object_type,
                                              const gchar* label,
                                              GHashTable* attrs)
{
	SeahorseGkrGkrNetworkPassInfo * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	const gchar* server = NULL;
	const gchar* _tmp2_;
	const gchar* protocol = NULL;
	const gchar* _tmp3_;
	const gchar* object = NULL;
	const gchar* _tmp4_;
	const gchar* user = NULL;
	const gchar* _tmp5_;
	gint port = 0;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* symbol = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SeahorseGkrGkrNetworkPassInfo*) seahorse_gkr_item_info_construct (object_type, label, attrs, _ ("Network password"));
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("network-server-symbolic");
	_tmp1_ = _tmp0_;
	seahorse_gkr_item_info_set_icon ((SeahorseGkrItemInfo*) self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "server");
	server = _tmp2_;
	_tmp3_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "protocol");
	protocol = _tmp3_;
	_tmp4_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "object");
	object = _tmp4_;
	_tmp5_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "user");
	user = _tmp5_;
	port = seahorse_gkr_item_info_get_attribute_int ((SeahorseGkrItemInfo*) self, attrs, "port");
	_tmp6_ = protocol;
	if (_tmp6_ == NULL) {
		return self;
	}
	_tmp7_ = server;
	_tmp8_ = user;
	_tmp9_ = object;
	if (seahorse_gkr_gkr_network_pass_info_is_custom_network_label (self, _tmp7_, _tmp8_, _tmp9_, port, label)) {
		seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, label);
	} else {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = seahorse_gkr_gkr_network_pass_info_calc_network_label (self, attrs, TRUE);
		_tmp11_ = _tmp10_;
		seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, _tmp11_);
		_g_free0 (_tmp11_);
	}
	symbol = "@";
	_tmp12_ = user;
	if (_tmp12_ == NULL) {
		user = "";
		symbol = "";
	}
	_tmp13_ = object;
	if (_tmp13_ == NULL) {
		object = "";
	}
	_tmp15_ = server;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		_tmp16_ = protocol;
		_tmp14_ = _tmp16_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp17_ = protocol;
		_tmp18_ = user;
		_tmp19_ = symbol;
		_tmp20_ = server;
		_tmp21_ = object;
		_tmp22_ = g_markup_printf_escaped ("%s://%s%s%s/%s", _tmp17_, _tmp18_, _tmp19_, _tmp20_, _tmp21_);
		_tmp23_ = _tmp22_;
		seahorse_gkr_item_info_set_details ((SeahorseGkrItemInfo*) self, _tmp23_);
		_g_free0 (_tmp23_);
	}
	return self;
}

SeahorseGkrGkrNetworkPassInfo*
seahorse_gkr_gkr_network_pass_info_new (const gchar* label,
                                        GHashTable* attrs)
{
	return seahorse_gkr_gkr_network_pass_info_construct (SEAHORSE_GKR_TYPE_GKR_NETWORK_PASS_INFO, label, attrs);
}

static gboolean
seahorse_gkr_gkr_network_pass_info_is_custom_network_label (SeahorseGkrGkrNetworkPassInfo* self,
                                                            const gchar* server,
                                                            const gchar* user,
                                                            const gchar* object,
                                                            gint port,
                                                            const gchar* label)
{
	GString* generated = NULL;
	GString* _tmp0_;
	GString* _tmp2_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (server == NULL) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_string_new ("");
	generated = _tmp0_;
	if (user != NULL) {
		GString* _tmp1_;
		_tmp1_ = generated;
		g_string_append_printf (_tmp1_, "%s@", user);
	}
	_tmp2_ = generated;
	g_string_append (_tmp2_, server);
	if (port != 0) {
		GString* _tmp3_;
		_tmp3_ = generated;
		g_string_append_printf (_tmp3_, ":%d", port);
	}
	if (object != NULL) {
		GString* _tmp4_;
		_tmp4_ = generated;
		g_string_append_printf (_tmp4_, "/%s", object);
	}
	_tmp5_ = generated;
	_tmp6_ = _tmp5_->str;
	result = g_strcmp0 (_tmp6_, label) != 0;
	_g_string_free0 (generated);
	return result;
}

static gchar*
seahorse_gkr_gkr_network_pass_info_calc_network_label (SeahorseGkrGkrNetworkPassInfo* self,
                                                       GHashTable* attrs,
                                                       gboolean always)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (seahorse_gkr_gkr_network_pass_info_is_network_item (self, attrs, "http")) {
		_tmp0_ = attrs != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* val = NULL;
		const gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		_tmp1_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "object");
		val = _tmp1_;
		_tmp3_ = val;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			_tmp4_ = val;
			_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = val;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		if (always) {
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
			_tmp7_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "server");
			val = _tmp7_;
			_tmp9_ = val;
			if (_tmp9_ != NULL) {
				const gchar* _tmp10_;
				_tmp10_ = val;
				_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = val;
				_tmp12_ = g_strdup (_tmp11_);
				result = _tmp12_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}

static gboolean
seahorse_gkr_gkr_network_pass_info_is_network_item (SeahorseGkrGkrNetworkPassInfo* self,
                                                    GHashTable* attrs,
                                                    const gchar* match)
{
	const gchar* protocol = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "protocol");
	protocol = _tmp0_;
	_tmp2_ = protocol;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = protocol;
		_tmp1_ = g_ascii_strcasecmp (_tmp3_, match) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

static void
seahorse_gkr_gkr_network_pass_info_class_init (SeahorseGkrGkrNetworkPassInfoClass * klass,
                                               gpointer klass_data)
{
	seahorse_gkr_gkr_network_pass_info_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_gkr_gkr_network_pass_info_instance_init (SeahorseGkrGkrNetworkPassInfo * self,
                                                  gpointer klass)
{
}

/**
 * Used for entries in gnome-keyring with xdg:schema
 * "org.gnome.keyring.NetworkPassword"
 */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_gkr_network_pass_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrGkrNetworkPassInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_gkr_network_pass_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrGkrNetworkPassInfo), 0, (GInstanceInitFunc) seahorse_gkr_gkr_network_pass_info_instance_init, NULL };
	GType seahorse_gkr_gkr_network_pass_info_type_id;
	seahorse_gkr_gkr_network_pass_info_type_id = g_type_register_static (SEAHORSE_GKR_TYPE_ITEM_INFO, "SeahorseGkrGkrNetworkPassInfo", &g_define_type_info, 0);
	return seahorse_gkr_gkr_network_pass_info_type_id;
}

GType
seahorse_gkr_gkr_network_pass_info_get_type (void)
{
	static volatile gsize seahorse_gkr_gkr_network_pass_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_gkr_network_pass_info_type_id__once)) {
		GType seahorse_gkr_gkr_network_pass_info_type_id;
		seahorse_gkr_gkr_network_pass_info_type_id = seahorse_gkr_gkr_network_pass_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_gkr_network_pass_info_type_id__once, seahorse_gkr_gkr_network_pass_info_type_id);
	}
	return seahorse_gkr_gkr_network_pass_info_type_id__once;
}

SeahorseGkrEpiphanyPassInfo*
seahorse_gkr_epiphany_pass_info_construct (GType object_type,
                                           const gchar* label,
                                           GHashTable* attrs)
{
	SeahorseGkrEpiphanyPassInfo * self = NULL;
	const gchar* uri = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* username = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SeahorseGkrEpiphanyPassInfo*) seahorse_gkr_item_info_construct (object_type, label, attrs, _ ("GNOME Web password"));
	seahorse_gkr_item_info_query_installed_apps ((SeahorseGkrItemInfo*) self, "org.gnome.Epiphany");
	_tmp0_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "uri");
	uri = _tmp0_;
	_tmp1_ = uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = uri;
		seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, _tmp2_);
	}
	_tmp3_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "username");
	username = _tmp3_;
	_tmp4_ = username;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = username;
		_tmp6_ = g_markup_escape_text (_tmp5_, (gssize) -1);
		_tmp7_ = _tmp6_;
		seahorse_gkr_item_info_set_details ((SeahorseGkrItemInfo*) self, _tmp7_);
		_g_free0 (_tmp7_);
	}
	return self;
}

SeahorseGkrEpiphanyPassInfo*
seahorse_gkr_epiphany_pass_info_new (const gchar* label,
                                     GHashTable* attrs)
{
	return seahorse_gkr_epiphany_pass_info_construct (SEAHORSE_GKR_TYPE_EPIPHANY_PASS_INFO, label, attrs);
}

static void
seahorse_gkr_epiphany_pass_info_class_init (SeahorseGkrEpiphanyPassInfoClass * klass,
                                            gpointer klass_data)
{
	seahorse_gkr_epiphany_pass_info_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_gkr_epiphany_pass_info_instance_init (SeahorseGkrEpiphanyPassInfo * self,
                                               gpointer klass)
{
}

/** Used for GNOME Web (epiphany) passwordss */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_epiphany_pass_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrEpiphanyPassInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_epiphany_pass_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrEpiphanyPassInfo), 0, (GInstanceInitFunc) seahorse_gkr_epiphany_pass_info_instance_init, NULL };
	GType seahorse_gkr_epiphany_pass_info_type_id;
	seahorse_gkr_epiphany_pass_info_type_id = g_type_register_static (SEAHORSE_GKR_TYPE_ITEM_INFO, "SeahorseGkrEpiphanyPassInfo", &g_define_type_info, 0);
	return seahorse_gkr_epiphany_pass_info_type_id;
}

GType
seahorse_gkr_epiphany_pass_info_get_type (void)
{
	static volatile gsize seahorse_gkr_epiphany_pass_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_epiphany_pass_info_type_id__once)) {
		GType seahorse_gkr_epiphany_pass_info_type_id;
		seahorse_gkr_epiphany_pass_info_type_id = seahorse_gkr_epiphany_pass_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_epiphany_pass_info_type_id__once, seahorse_gkr_epiphany_pass_info_type_id);
	}
	return seahorse_gkr_epiphany_pass_info_type_id__once;
}

SeahorseGkrChromePassInfo*
seahorse_gkr_chrome_pass_info_construct (GType object_type,
                                         const gchar* label,
                                         GHashTable* attrs)
{
	SeahorseGkrChromePassInfo * self = NULL;
	const gchar* origin = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SeahorseGkrChromePassInfo*) seahorse_gkr_item_info_construct (object_type, label, attrs, _ ("Google Chrome password"));
	_tmp0_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "origin_url");
	origin = _tmp0_;
	if (label != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = origin;
		_tmp1_ = g_strcmp0 (label, _tmp2_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			GRegex* regex = NULL;
			GRegex* _tmp3_;
			GMatchInfo* match = NULL;
			GRegex* _tmp4_;
			GMatchInfo* _tmp5_ = NULL;
			gboolean _tmp6_;
			_tmp3_ = g_regex_new ("[a-z]+://([^/]+)/", G_REGEX_CASELESS, 0, &_inner_error0_);
			regex = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp4_ = regex;
			_tmp6_ = g_regex_match (_tmp4_, label, G_REGEX_MATCH_ANCHORED, &_tmp5_);
			_g_match_info_unref0 (match);
			match = _tmp5_;
			if (_tmp6_) {
				GMatchInfo* _tmp7_;
				_tmp7_ = match;
				if (g_match_info_matches (_tmp7_)) {
					GMatchInfo* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp8_ = match;
					_tmp9_ = g_match_info_fetch (_tmp8_, 1);
					_tmp10_ = _tmp9_;
					seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, _tmp10_);
					_g_free0 (_tmp10_);
				}
			}
			_g_match_info_unref0 (match);
			_g_regex_unref0 (regex);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = err;
			_tmp12_ = _tmp11_->message;
			g_critical ("gkr-item-info.vala:267: %s", _tmp12_);
			_g_error_free0 (err);
			return self;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp13_ = seahorse_gkr_item_info_get_label ((SeahorseGkrItemInfo*) self);
	_tmp14_ = _tmp13_;
	if (g_strcmp0 (_tmp14_, "") == 0) {
		seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, label);
	}
	_tmp15_ = origin;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = origin;
		_tmp17_ = g_markup_escape_text (_tmp16_, (gssize) -1);
		_tmp18_ = _tmp17_;
		seahorse_gkr_item_info_set_details ((SeahorseGkrItemInfo*) self, _tmp18_);
		_g_free0 (_tmp18_);
	} else {
		seahorse_gkr_item_info_set_details ((SeahorseGkrItemInfo*) self, "");
	}
	return self;
}

SeahorseGkrChromePassInfo*
seahorse_gkr_chrome_pass_info_new (const gchar* label,
                                   GHashTable* attrs)
{
	return seahorse_gkr_chrome_pass_info_construct (SEAHORSE_GKR_TYPE_CHROME_PASS_INFO, label, attrs);
}

static void
seahorse_gkr_chrome_pass_info_class_init (SeahorseGkrChromePassInfoClass * klass,
                                          gpointer klass_data)
{
	seahorse_gkr_chrome_pass_info_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_gkr_chrome_pass_info_instance_init (SeahorseGkrChromePassInfo * self,
                                             gpointer klass)
{
}

/** Used for passwords saved in Chrome/Chromium */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_chrome_pass_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrChromePassInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_chrome_pass_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrChromePassInfo), 0, (GInstanceInitFunc) seahorse_gkr_chrome_pass_info_instance_init, NULL };
	GType seahorse_gkr_chrome_pass_info_type_id;
	seahorse_gkr_chrome_pass_info_type_id = g_type_register_static (SEAHORSE_GKR_TYPE_ITEM_INFO, "SeahorseGkrChromePassInfo", &g_define_type_info, 0);
	return seahorse_gkr_chrome_pass_info_type_id;
}

GType
seahorse_gkr_chrome_pass_info_get_type (void)
{
	static volatile gsize seahorse_gkr_chrome_pass_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_chrome_pass_info_type_id__once)) {
		GType seahorse_gkr_chrome_pass_info_type_id;
		seahorse_gkr_chrome_pass_info_type_id = seahorse_gkr_chrome_pass_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_chrome_pass_info_type_id__once, seahorse_gkr_chrome_pass_info_type_id);
	}
	return seahorse_gkr_chrome_pass_info_type_id__once;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

SeahorseGkrEmpathyInfo*
seahorse_gkr_empathy_info_construct (GType object_type,
                                     const gchar* label,
                                     GHashTable* attrs)
{
	SeahorseGkrEmpathyInfo * self = NULL;
	const gchar* account = NULL;
	const gchar* _tmp0_;
	const gchar* prefix = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SeahorseGkrEmpathyInfo*) seahorse_gkr_item_info_construct (object_type, label, attrs, _ ("Instant messaging password"));
	_tmp0_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "account-id");
	account = _tmp0_;
	prefix = _ ("IM account password for ");
	if (label != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = prefix;
		_tmp1_ = g_str_has_prefix (label, _tmp2_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint len = 0;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint pos = 0;
		_tmp3_ = prefix;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		len = _tmp5_;
		pos = string_index_of_char (label, (gunichar) '(', (gint) len);
		if (pos != -1) {
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = string_slice (label, (glong) len, (glong) pos);
			_tmp7_ = _tmp6_;
			seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, _tmp7_);
			_g_free0 (_tmp7_);
		}
		{
			GRegex* regex = NULL;
			GRegex* _tmp8_;
			GMatchInfo* match = NULL;
			GRegex* _tmp9_;
			const gchar* _tmp10_;
			GMatchInfo* _tmp11_ = NULL;
			gboolean _tmp12_;
			_tmp8_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error0_);
			regex = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp9_ = regex;
			_tmp10_ = account;
			_tmp12_ = g_regex_match (_tmp9_, _tmp10_, G_REGEX_MATCH_ANCHORED, &_tmp11_);
			_g_match_info_unref0 (match);
			match = _tmp11_;
			if (_tmp12_) {
				GMatchInfo* _tmp13_;
				_tmp13_ = match;
				if (g_match_info_matches (_tmp13_)) {
					GMatchInfo* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp14_ = match;
					_tmp15_ = g_match_info_fetch (_tmp14_, 1);
					_tmp16_ = _tmp15_;
					_tmp17_ = seahorse_gkr_telepathy_info_decode_id (_tmp16_);
					_tmp18_ = _tmp17_;
					seahorse_gkr_item_info_set_details ((SeahorseGkrItemInfo*) self, _tmp18_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
				}
			}
			_g_match_info_unref0 (match);
			_g_regex_unref0 (regex);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = err;
			_tmp20_ = _tmp19_->message;
			g_critical ("gkr-item-info.vala:307: %s", _tmp20_);
			_g_error_free0 (err);
			return self;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp21_ = seahorse_gkr_item_info_get_label ((SeahorseGkrItemInfo*) self);
	_tmp22_ = _tmp21_;
	if (g_strcmp0 (_tmp22_, "") == 0) {
		seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, label);
	}
	_tmp23_ = seahorse_gkr_item_info_get_details ((SeahorseGkrItemInfo*) self);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == NULL) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = account;
		_tmp26_ = g_markup_escape_text (_tmp25_, (gssize) -1);
		_tmp27_ = _tmp26_;
		seahorse_gkr_item_info_set_details ((SeahorseGkrItemInfo*) self, _tmp27_);
		_g_free0 (_tmp27_);
	}
	return self;
}

SeahorseGkrEmpathyInfo*
seahorse_gkr_empathy_info_new (const gchar* label,
                               GHashTable* attrs)
{
	return seahorse_gkr_empathy_info_construct (SEAHORSE_GKR_TYPE_EMPATHY_INFO, label, attrs);
}

static void
seahorse_gkr_empathy_info_class_init (SeahorseGkrEmpathyInfoClass * klass,
                                      gpointer klass_data)
{
	seahorse_gkr_empathy_info_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_gkr_empathy_info_instance_init (SeahorseGkrEmpathyInfo * self,
                                         gpointer klass)
{
}

/** Used for Empathy */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_empathy_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrEmpathyInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_empathy_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrEmpathyInfo), 0, (GInstanceInitFunc) seahorse_gkr_empathy_info_instance_init, NULL };
	GType seahorse_gkr_empathy_info_type_id;
	seahorse_gkr_empathy_info_type_id = g_type_register_static (SEAHORSE_GKR_TYPE_ITEM_INFO, "SeahorseGkrEmpathyInfo", &g_define_type_info, 0);
	return seahorse_gkr_empathy_info_type_id;
}

GType
seahorse_gkr_empathy_info_get_type (void)
{
	static volatile gsize seahorse_gkr_empathy_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_empathy_info_type_id__once)) {
		GType seahorse_gkr_empathy_info_type_id;
		seahorse_gkr_empathy_info_type_id = seahorse_gkr_empathy_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_empathy_info_type_id__once, seahorse_gkr_empathy_info_type_id);
	}
	return seahorse_gkr_empathy_info_type_id__once;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

SeahorseGkrTelepathyInfo*
seahorse_gkr_telepathy_info_construct (GType object_type,
                                       const gchar* label,
                                       GHashTable* attrs)
{
	SeahorseGkrTelepathyInfo * self = NULL;
	const gchar* account = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SeahorseGkrTelepathyInfo*) seahorse_gkr_item_info_construct (object_type, label, attrs, _ ("Telepathy password"));
	_tmp0_ = seahorse_gkr_item_info_get_attribute_string ((SeahorseGkrItemInfo*) self, attrs, "account");
	account = _tmp0_;
	_tmp3_ = account;
	if (_tmp3_ != NULL) {
		_tmp2_ = label != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp4_;
		_tmp4_ = account;
		_tmp1_ = string_index_of (label, _tmp4_, 0) != -1;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			GRegex* regex = NULL;
			GRegex* _tmp5_;
			GMatchInfo* match = NULL;
			GRegex* _tmp6_;
			const gchar* _tmp7_;
			GMatchInfo* _tmp8_ = NULL;
			gboolean _tmp9_;
			_tmp5_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error0_);
			regex = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp6_ = regex;
			_tmp7_ = account;
			_tmp9_ = g_regex_match (_tmp6_, _tmp7_, G_REGEX_MATCH_ANCHORED, &_tmp8_);
			_g_match_info_unref0 (match);
			match = _tmp8_;
			if (_tmp9_) {
				GMatchInfo* _tmp10_;
				_tmp10_ = match;
				if (g_match_info_matches (_tmp10_)) {
					gchar* identifier = NULL;
					GMatchInfo* _tmp11_;
					gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = match;
					_tmp12_ = g_match_info_fetch (_tmp11_, 1);
					identifier = _tmp12_;
					_tmp13_ = identifier;
					_tmp14_ = seahorse_gkr_telepathy_info_decode_id (_tmp13_);
					_tmp15_ = _tmp14_;
					seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, _tmp15_);
					_g_free0 (_tmp15_);
					_g_free0 (identifier);
				}
			}
			_g_match_info_unref0 (match);
			_g_regex_unref0 (regex);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = err;
			_tmp17_ = _tmp16_->message;
			g_critical ("gkr-item-info.vala:337: %s", _tmp17_);
			_g_error_free0 (err);
			return self;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp18_ = seahorse_gkr_item_info_get_label ((SeahorseGkrItemInfo*) self);
	_tmp19_ = _tmp18_;
	if (g_strcmp0 (_tmp19_, "") == 0) {
		seahorse_gkr_item_info_set_label ((SeahorseGkrItemInfo*) self, label);
	}
	_tmp20_ = account;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = account;
		_tmp22_ = g_markup_escape_text (_tmp21_, (gssize) -1);
		_tmp23_ = _tmp22_;
		seahorse_gkr_item_info_set_details ((SeahorseGkrItemInfo*) self, _tmp23_);
		_g_free0 (_tmp23_);
	}
	return self;
}

SeahorseGkrTelepathyInfo*
seahorse_gkr_telepathy_info_new (const gchar* label,
                                 GHashTable* attrs)
{
	return seahorse_gkr_telepathy_info_construct (SEAHORSE_GKR_TYPE_TELEPATHY_INFO, label, attrs);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
seahorse_gkr_telepathy_info_decode_id (const gchar* account)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = string_replace (account, "_", "%");
	_tmp1_ = _tmp0_;
	_g_free0 (_tmp1_);
	_tmp2_ = g_uri_unescape_string (account, NULL);
	result = _tmp2_;
	return result;
}

static void
seahorse_gkr_telepathy_info_class_init (SeahorseGkrTelepathyInfoClass * klass,
                                        gpointer klass_data)
{
	seahorse_gkr_telepathy_info_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_gkr_telepathy_info_instance_init (SeahorseGkrTelepathyInfo * self,
                                           gpointer klass)
{
}

/** Used for Telepathy */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_telepathy_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrTelepathyInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_telepathy_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrTelepathyInfo), 0, (GInstanceInitFunc) seahorse_gkr_telepathy_info_instance_init, NULL };
	GType seahorse_gkr_telepathy_info_type_id;
	seahorse_gkr_telepathy_info_type_id = g_type_register_static (SEAHORSE_GKR_TYPE_ITEM_INFO, "SeahorseGkrTelepathyInfo", &g_define_type_info, 0);
	return seahorse_gkr_telepathy_info_type_id;
}

GType
seahorse_gkr_telepathy_info_get_type (void)
{
	static volatile gsize seahorse_gkr_telepathy_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_telepathy_info_type_id__once)) {
		GType seahorse_gkr_telepathy_info_type_id;
		seahorse_gkr_telepathy_info_type_id = seahorse_gkr_telepathy_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_telepathy_info_type_id__once, seahorse_gkr_telepathy_info_type_id);
	}
	return seahorse_gkr_telepathy_info_type_id__once;
}

SeahorseGkrGoaInfo*
seahorse_gkr_goa_info_construct (GType object_type,
                                 const gchar* label,
                                 GHashTable* attrs)
{
	SeahorseGkrGoaInfo * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SeahorseGkrGoaInfo*) seahorse_gkr_item_info_construct (object_type, label, attrs, _ ("GNOME Online Accounts password"));
	return self;
}

SeahorseGkrGoaInfo*
seahorse_gkr_goa_info_new (const gchar* label,
                           GHashTable* attrs)
{
	return seahorse_gkr_goa_info_construct (SEAHORSE_GKR_TYPE_GOA_INFO, label, attrs);
}

static void
seahorse_gkr_goa_info_class_init (SeahorseGkrGoaInfoClass * klass,
                                  gpointer klass_data)
{
	seahorse_gkr_goa_info_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_gkr_goa_info_instance_init (SeahorseGkrGoaInfo * self,
                                     gpointer klass)
{
}

/** Used for GNOME Online Accounts */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_goa_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrGoaInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_goa_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrGoaInfo), 0, (GInstanceInitFunc) seahorse_gkr_goa_info_instance_init, NULL };
	GType seahorse_gkr_goa_info_type_id;
	seahorse_gkr_goa_info_type_id = g_type_register_static (SEAHORSE_GKR_TYPE_ITEM_INFO, "SeahorseGkrGoaInfo", &g_define_type_info, 0);
	return seahorse_gkr_goa_info_type_id;
}

GType
seahorse_gkr_goa_info_get_type (void)
{
	static volatile gsize seahorse_gkr_goa_info_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_goa_info_type_id__once)) {
		GType seahorse_gkr_goa_info_type_id;
		seahorse_gkr_goa_info_type_id = seahorse_gkr_goa_info_get_type_once ();
		g_once_init_leave (&seahorse_gkr_goa_info_type_id__once, seahorse_gkr_goa_info_type_id);
	}
	return seahorse_gkr_goa_info_type_id__once;
}

