/* gkr-item-add.c generated by valac 0.56.7, the Vala compiler
 * generated from gkr-item-add.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2018 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-gkr.h"
#include <gtk/gtk.h>
#include <pwquality.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <libsecret/secret.h>
#include <gio/gio.h>
#include "seahorse-common.h"

enum  {
	SEAHORSE_GKR_ITEM_ADD_0_PROPERTY,
	SEAHORSE_GKR_ITEM_ADD_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_item_add_properties[SEAHORSE_GKR_ITEM_ADD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pwquality_free_settings0(var) ((var == NULL) ? NULL : (var = (pwquality_free_settings (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))

struct _SeahorseGkrItemAddPrivate {
	GtkComboBox* item_keyring_combo;
	GtkContainer* password_area;
	GtkEntry* password_entry;
	GtkEntry* item_entry;
	GtkLevelBar* password_strength_bar;
	GtkImage* password_strength_icon;
	pwquality_settings_t* pwquality;
};

struct _Block2Data {
	int _ref_count_;
	SeahorseGkrItemAdd* self;
	SecretCollection* collection;
	SeahorseGkrKeyring* keyring;
	GtkEntryBuffer* item_buffer;
	GtkEntryBuffer* secret_buffer;
};

static gint SeahorseGkrItemAdd_private_offset;
static gpointer seahorse_gkr_item_add_parent_class = NULL;

static void seahorse_gkr_item_add_on_add_item_entry_changed (SeahorseGkrItemAdd* self,
                                                      GtkEditable* entry);
static void _seahorse_gkr_item_add_on_add_item_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                            gpointer self);
static void seahorse_gkr_item_add_on_password_entry_changed (SeahorseGkrItemAdd* self,
                                                      GtkEditable* entry);
static void seahorse_gkr_item_add_real_response (GtkDialog* base,
                                          gint resp);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda16_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static void seahorse_gkr_item_add_create_secret (SeahorseGkrItemAdd* self,
                                          GtkEntryBuffer* item_buffer,
                                          GtkEntryBuffer* secret_buffer,
                                          SecretCollection* collection);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _g_free0_ (gpointer var);
static void __lambda17_ (SeahorseGkrItemAdd* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GObject * seahorse_gkr_item_add_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _seahorse_gkr_item_add_on_password_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                            gpointer self);
static void seahorse_gkr_item_add_finalize (GObject * obj);
static GType seahorse_gkr_item_add_get_type_once (void);

static inline gpointer
seahorse_gkr_item_add_get_instance_private (SeahorseGkrItemAdd* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrItemAdd_private_offset);
}

SeahorseGkrItemAdd*
seahorse_gkr_item_add_construct (GType object_type,
                                 GtkWindow* parent)
{
	SeahorseGkrItemAdd * self = NULL;
	self = (SeahorseGkrItemAdd*) g_object_new (object_type, "transient-for", parent, "use-header-bar", 1, NULL);
	return self;
}

SeahorseGkrItemAdd*
seahorse_gkr_item_add_new (GtkWindow* parent)
{
	return seahorse_gkr_item_add_construct (SEAHORSE_GKR_TYPE_ITEM_ADD, parent);
}

static void
seahorse_gkr_item_add_on_add_item_entry_changed (SeahorseGkrItemAdd* self,
                                                 GtkEditable* entry)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->item_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT, g_strcmp0 (_tmp2_, "") != 0);
}

static void
_seahorse_gkr_item_add_on_add_item_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self)
{
	seahorse_gkr_item_add_on_add_item_entry_changed ((SeahorseGkrItemAdd*) self, _sender);
}

static gchar*
pwquality_error_to_string (int self,
                           void* auxerror)
{
	gchar* ret = NULL;
	const gchar** retp = NULL;
	const gchar** _tmp0_;
	void* _tmp1_;
	void* res = NULL;
	const gchar** _tmp2_;
	void* _tmp3_;
	void* _tmp4_;
	const gchar** _tmp5_;
	gchar* result;
	ret = NULL;
	retp = &ret;
	_tmp0_ = retp;
	_tmp1_ = g_malloc ((gsize) PWQ_MAX_ERROR_MESSAGE_LEN);
	*_tmp0_ = _tmp1_;
	_tmp2_ = retp;
	_tmp3_ = pwquality_strerror (*_tmp2_, (gsize) PWQ_MAX_ERROR_MESSAGE_LEN, self, auxerror);
	res = _tmp3_;
	_tmp4_ = res;
	_tmp5_ = retp;
	if (_tmp4_ != (*_tmp5_)) {
		const gchar** _tmp6_;
		void* _tmp7_;
		void* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = retp;
		_tmp7_ = res;
		_tmp8_ = res;
		_tmp9_ = strlen ((const gchar*) _tmp8_);
		_tmp10_ = _tmp9_;
		memcpy (*_tmp6_, _tmp7_, (gsize) (_tmp10_ + 1));
	}
	result = ret;
	return result;
}

static void
seahorse_gkr_item_add_on_password_entry_changed (SeahorseGkrItemAdd* self,
                                                 GtkEditable* entry)
{
	void* auxerr = NULL;
	gint score = 0;
	pwquality_settings_t* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	void* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	GtkLevelBar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->pwquality;
	_tmp1_ = gtk_editable_get_chars (entry, 0, -1);
	_tmp2_ = _tmp1_;
	_tmp4_ = pwquality_check (_tmp0_, _tmp2_, NULL, NULL, &_tmp3_);
	auxerr = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	score = _tmp5_;
	if (score < 0) {
		int err = 0;
		GtkImage* _tmp6_;
		void* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GtkImage* _tmp10_;
		err = (int) score;
		_tmp6_ = self->priv->password_strength_icon;
		_tmp7_ = auxerr;
		_tmp8_ = pwquality_error_to_string (err, _tmp7_);
		_tmp9_ = _tmp8_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, g_dgettext ("libpwquality", _tmp9_));
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->password_strength_icon;
		gtk_widget_show ((GtkWidget*) _tmp10_);
	} else {
		GtkImage* _tmp11_;
		_tmp11_ = self->priv->password_strength_icon;
		gtk_widget_hide ((GtkWidget*) _tmp11_);
	}
	_tmp12_ = self->priv->password_strength_bar;
	gtk_level_bar_set_value (_tmp12_, (gdouble) CLAMP ((score / 25) + 1, 1, 5));
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SeahorseGkrItemAdd* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->secret_buffer);
		_g_object_unref0 (_data2_->item_buffer);
		_g_object_unref0 (_data2_->keyring);
		_g_object_unref0 (_data2_->collection);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda16_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseGkrItemAdd* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		SeahorseGkrKeyring* _tmp1_;
		_tmp1_ = _data2_->keyring;
		_tmp0_ = seahorse_lockable_unlock_finish ((SeahorseLockable*) _tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			GtkEntryBuffer* _tmp2_;
			GtkEntryBuffer* _tmp3_;
			SecretCollection* _tmp4_;
			_tmp2_ = _data2_->item_buffer;
			_tmp3_ = _data2_->secret_buffer;
			_tmp4_ = _data2_->collection;
			seahorse_gkr_item_add_create_secret (self, _tmp2_, _tmp3_, _tmp4_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t unlock"), _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ (self, source_object, res);
	block2_data_unref (self);
}

static void
seahorse_gkr_item_add_real_response (GtkDialog* base,
                                     gint resp)
{
	SeahorseGkrItemAdd * self;
	Block2Data* _data2_;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	SecretCollection* _tmp7_ = NULL;
	SecretCollection* _tmp8_;
	SeahorseGkrKeyring* _tmp9_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp10_;
	SeahorseInteraction* interaction = NULL;
	SeahorseInteraction* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntryBuffer* _tmp13_;
	GtkEntryBuffer* _tmp14_;
	GtkEntryBuffer* _tmp15_;
	GtkEntry* _tmp16_;
	GtkEntryBuffer* _tmp17_;
	GtkEntryBuffer* _tmp18_;
	GtkEntryBuffer* _tmp19_;
	SeahorseGkrKeyring* _tmp20_;
	SeahorseInteraction* _tmp21_;
	GCancellable* _tmp22_;
	self = (SeahorseGkrItemAdd*) base;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (resp != ((gint) GTK_RESPONSE_ACCEPT)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp0_ = self->priv->item_keyring_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp3_ = self->priv->item_keyring_combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &_tmp7_, -1, -1);
	_g_object_unref0 (_data2_->collection);
	_data2_->collection = _tmp7_;
	_tmp8_ = _data2_->collection;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
	_data2_->keyring = _tmp9_;
	_tmp10_ = g_cancellable_new ();
	cancellable = _tmp10_;
	_tmp11_ = seahorse_interaction_new ((GtkWindow*) self);
	interaction = _tmp11_;
	_tmp12_ = self->priv->item_entry;
	_tmp13_ = gtk_entry_get_buffer (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_data2_->item_buffer = _tmp15_;
	_tmp16_ = self->priv->password_entry;
	_tmp17_ = gtk_entry_get_buffer (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_data2_->secret_buffer = _tmp19_;
	_tmp20_ = _data2_->keyring;
	_tmp21_ = interaction;
	_tmp22_ = cancellable;
	seahorse_lockable_unlock ((SeahorseLockable*) _tmp20_, (GTlsInteraction*) _tmp21_, _tmp22_, ___lambda16__gasync_ready_callback, block2_data_ref (_data2_));
	_g_object_unref0 (interaction);
	_g_object_unref0 (cancellable);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
__lambda17_ (SeahorseGkrItemAdd* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SecretItem* _tmp0_;
		SecretItem* _tmp1_;
		seahorse_gkr_dialog_complete_request ((GtkWidget*) self, FALSE);
		_tmp0_ = secret_item_create_finish (res, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t add item"), _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ ((SeahorseGkrItemAdd*) self, source_object, res);
	g_object_unref (self);
}

static void
seahorse_gkr_item_add_create_secret (SeahorseGkrItemAdd* self,
                                     GtkEntryBuffer* item_buffer,
                                     GtkEntryBuffer* secret_buffer,
                                     SecretCollection* collection)
{
	SecretValue* secret = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SecretValue* _tmp2_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp3_;
	GHashTable* attributes = NULL;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	SecretSchema* schema = NULL;
	SecretSchema* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_buffer != NULL);
	g_return_if_fail (secret_buffer != NULL);
	g_return_if_fail (collection != NULL);
	_tmp0_ = gtk_entry_buffer_get_text (secret_buffer);
	_tmp1_ = _tmp0_;
	_tmp2_ = secret_value_new (_tmp1_, (gssize) -1, "text/plain");
	secret = _tmp2_;
	_tmp3_ = seahorse_gkr_dialog_begin_request ((GtkWidget*) self);
	cancellable = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_free0_);
	attributes = _tmp6_;
	_tmp7_ = secret_schema_new ("org.gnome.keyring.Note", SECRET_SCHEMA_NONE, NULL);
	schema = _tmp7_;
	_tmp8_ = gtk_entry_buffer_get_text (item_buffer);
	_tmp9_ = _tmp8_;
	secret_item_create (collection, schema, attributes, _tmp9_, secret, SECRET_ITEM_CREATE_NONE, cancellable, ___lambda17__gasync_ready_callback, g_object_ref (self));
	_secret_schema_unref0 (schema);
	_g_hash_table_unref0 (attributes);
	_g_object_unref0 (cancellable);
	_secret_value_unref0 (secret);
}

static void
_seahorse_gkr_item_add_on_password_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self)
{
	seahorse_gkr_item_add_on_password_entry_changed ((SeahorseGkrItemAdd*) self, _sender);
}

static GObject *
seahorse_gkr_item_add_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrItemAdd * self;
	GtkListStore* store = NULL;
	GtkListStore* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkListStore* _tmp2_;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkCellRendererText* _tmp7_;
	SeahorseGkrBackend* _tmp8_;
	SeahorseGkrBackend* _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	SeahorseGkrPasswordEntry* _tmp26_;
	GtkEntry* _tmp27_;
	GtkEntry* _tmp28_;
	GtkContainer* _tmp29_;
	GtkEntry* _tmp30_;
	GtkEntry* _tmp31_;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_item_add_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_ADD, SeahorseGkrItemAdd);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, secret_collection_get_type (), -1);
	store = _tmp0_;
	_tmp1_ = self->priv->item_keyring_combo;
	_tmp2_ = store;
	gtk_combo_box_set_model (_tmp1_, (GtkTreeModel*) _tmp2_);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp3_);
	cell = _tmp3_;
	_tmp4_ = self->priv->item_keyring_combo;
	_tmp5_ = cell;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) _tmp5_, TRUE);
	_tmp6_ = self->priv->item_keyring_combo;
	_tmp7_ = cell;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) _tmp7_, "text", 0);
	_tmp8_ = seahorse_gkr_backend_instance ();
	_tmp9_ = _tmp8_;
	_tmp10_ = seahorse_gkr_backend_get_keyrings (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	{
		GList* keyring_collection = NULL;
		GList* keyring_it = NULL;
		keyring_collection = _tmp11_;
		for (keyring_it = keyring_collection; keyring_it != NULL; keyring_it = keyring_it->next) {
			SeahorseGkrKeyring* keyring = NULL;
			keyring = (SeahorseGkrKeyring*) keyring_it->data;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp12_;
				GtkTreeIter _tmp13_ = {0};
				GtkListStore* _tmp14_;
				GtkTreeIter _tmp15_;
				SeahorseGkrKeyring* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				SeahorseGkrKeyring* _tmp20_;
				SeahorseGkrKeyring* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp12_ = store;
				gtk_list_store_append (_tmp12_, &_tmp13_);
				iter = _tmp13_;
				_tmp14_ = store;
				_tmp15_ = iter;
				_tmp16_ = keyring;
				_tmp17_ = seahorse_place_get_label ((SeahorsePlace*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_;
				_tmp20_ = keyring;
				gtk_list_store_set (_tmp14_, &_tmp15_, 0, _tmp19_, 1, _tmp20_, -1);
				_g_free0 (_tmp19_);
				_tmp21_ = keyring;
				_tmp22_ = seahorse_gkr_keyring_get_is_default (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_) {
					GtkComboBox* _tmp24_;
					GtkTreeIter _tmp25_;
					_tmp24_ = self->priv->item_keyring_combo;
					_tmp25_ = iter;
					gtk_combo_box_set_active_iter (_tmp24_, &_tmp25_);
				}
			}
		}
		(keyring_collection == NULL) ? NULL : (keyring_collection = (g_list_free (keyring_collection), NULL));
	}
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT, FALSE);
	_tmp26_ = seahorse_gkr_password_entry_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = (GtkEntry*) _tmp26_;
	_tmp27_ = self->priv->password_entry;
	gtk_entry_set_visibility (_tmp27_, FALSE);
	_tmp28_ = self->priv->password_entry;
	g_signal_connect_object ((GtkEditable*) _tmp28_, "changed", (GCallback) _seahorse_gkr_item_add_on_password_entry_changed_gtk_editable_changed, self, 0);
	_tmp29_ = self->priv->password_area;
	_tmp30_ = self->priv->password_entry;
	gtk_container_add (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->password_entry;
	gtk_widget_show ((GtkWidget*) _tmp31_);
	_g_object_unref0 (cell);
	_g_object_unref0 (store);
	return obj;
}

static void
seahorse_gkr_item_add_class_init (SeahorseGkrItemAddClass * klass,
                                  gpointer klass_data)
{
	seahorse_gkr_item_add_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrItemAdd_private_offset);
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog*, gint)) seahorse_gkr_item_add_real_response;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_item_add_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_add_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-gkr-add-item.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "item_keyring_combo", FALSE, SeahorseGkrItemAdd_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemAddPrivate, item_keyring_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_area", FALSE, SeahorseGkrItemAdd_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemAddPrivate, password_area));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "item_entry", FALSE, SeahorseGkrItemAdd_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemAddPrivate, item_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_strength_bar", FALSE, SeahorseGkrItemAdd_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemAddPrivate, password_strength_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_strength_icon", FALSE, SeahorseGkrItemAdd_private_offset + G_STRUCT_OFFSET (SeahorseGkrItemAddPrivate, password_strength_icon));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_add_item_entry_changed", G_CALLBACK(_seahorse_gkr_item_add_on_add_item_entry_changed_gtk_editable_changed));
}

static void
seahorse_gkr_item_add_instance_init (SeahorseGkrItemAdd * self,
                                     gpointer klass)
{
	pwquality_settings_t* _tmp0_;
	self->priv = seahorse_gkr_item_add_get_instance_private (self);
	_tmp0_ = pwquality_default_settings ();
	self->priv->pwquality = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_gkr_item_add_finalize (GObject * obj)
{
	SeahorseGkrItemAdd * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_ADD, SeahorseGkrItemAdd);
	_g_object_unref0 (self->priv->password_entry);
	_pwquality_free_settings0 (self->priv->pwquality);
	G_OBJECT_CLASS (seahorse_gkr_item_add_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_item_add_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemAddClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_add_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemAdd), 0, (GInstanceInitFunc) seahorse_gkr_item_add_instance_init, NULL };
	GType seahorse_gkr_item_add_type_id;
	seahorse_gkr_item_add_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseGkrItemAdd", &g_define_type_info, 0);
	SeahorseGkrItemAdd_private_offset = g_type_add_instance_private (seahorse_gkr_item_add_type_id, sizeof (SeahorseGkrItemAddPrivate));
	return seahorse_gkr_item_add_type_id;
}

GType
seahorse_gkr_item_add_get_type (void)
{
	static volatile gsize seahorse_gkr_item_add_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_item_add_type_id__once)) {
		GType seahorse_gkr_item_add_type_id;
		seahorse_gkr_item_add_type_id = seahorse_gkr_item_add_get_type_once ();
		g_once_init_leave (&seahorse_gkr_item_add_type_id__once, seahorse_gkr_item_add_type_id);
	}
	return seahorse_gkr_item_add_type_id__once;
}

