/* server-category.c generated by valac 0.56.7, the Vala compiler
 * generated from server-category.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2017 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "pgp/seahorse-server-source.h"
#include "pgp/seahorse-ldap-source.h"
#include <glib/gi18n-lib.h>
#include "pgp/seahorse-hkp-source.h"

enum  {
	SEAHORSE_SERVER_CATEGORY_0_PROPERTY,
	SEAHORSE_SERVER_CATEGORY_GTYPE_PROPERTY,
	SEAHORSE_SERVER_CATEGORY_SCHEME_PROPERTY,
	SEAHORSE_SERVER_CATEGORY_DESCRIPTION_PROPERTY,
	SEAHORSE_SERVER_CATEGORY_NUM_PROPERTIES
};
static GParamSpec* seahorse_server_category_properties[SEAHORSE_SERVER_CATEGORY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _SeahorseServerCategoryPrivate {
	GType _gtype;
	gchar* _scheme;
	gchar* _description;
};

static gint SeahorseServerCategory_private_offset;
static gpointer seahorse_server_category_parent_class = NULL;
static GPtrArray* seahorse_server_category_categories;
static GPtrArray* seahorse_server_category_categories = NULL;

static void _g_object_unref0_ (gpointer var);
static gboolean _seahorse_ldap_is_valid_uri_seahorse_valid_uri_func (const gchar* uri);
static gboolean _seahorse_hkp_is_valid_uri_seahorse_valid_uri_func (const gchar* uri);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void seahorse_server_category_finalize (GObject * obj);
static GType seahorse_server_category_get_type_once (void);
static void _vala_seahorse_server_category_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_seahorse_server_category_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
seahorse_server_category_get_instance_private (SeahorseServerCategory* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseServerCategory_private_offset);
}

SeahorseServerCategory*
seahorse_server_category_construct (GType object_type,
                                    GType gtype,
                                    const gchar* scheme,
                                    const gchar* description,
                                    SeahorseValidUriFunc validator)
{
	SeahorseServerCategory * self = NULL;
	g_return_val_if_fail (scheme != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (SeahorseServerCategory*) g_object_new (object_type, "gtype", gtype, "scheme", scheme, "description", description, NULL);
	self->validator = validator;
	return self;
}

SeahorseServerCategory*
seahorse_server_category_new (GType gtype,
                              const gchar* scheme,
                              const gchar* description,
                              SeahorseValidUriFunc validator)
{
	return seahorse_server_category_construct (SEAHORSE_TYPE_SERVER_CATEGORY, gtype, scheme, description, validator);
}

SeahorseServerSource*
seahorse_server_category_create_server (const gchar* uri)
{
	SeahorseServerCategory* cat = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	SeahorseServerCategory* _tmp2_;
	SeahorseServerCategory* _tmp3_;
	SeahorseServerCategory* _tmp4_;
	SeahorseServerCategory* _tmp7_;
	GType _tmp8_;
	GObject* _tmp9_;
	GObject* _tmp10_;
	SeahorseServerSource* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	_tmp1_ = _tmp0_;
	_tmp2_ = seahorse_server_category_find_category (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cat = _tmp3_;
	_tmp4_ = cat;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_uri_parse_scheme (uri);
		_tmp6_ = _tmp5_;
		g_warning ("server-category.vala:52: Unsupported scheme '%s'", _tmp6_);
		_g_free0 (_tmp6_);
		result = NULL;
		return result;
	}
	_tmp7_ = cat;
	_tmp8_ = _tmp7_->priv->_gtype;
	_tmp9_ = g_object_new (_tmp8_, "uri", uri, NULL);
	_tmp10_ = G_IS_INITIALLY_UNOWNED (_tmp9_) ? g_object_ref_sink (_tmp9_) : _tmp9_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SEAHORSE_TYPE_SERVER_SOURCE, SeahorseServerSource);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
_seahorse_ldap_is_valid_uri_seahorse_valid_uri_func (const gchar* uri)
{
	gboolean result;
	result = seahorse_ldap_is_valid_uri (uri);
	return result;
}

static gboolean
_seahorse_hkp_is_valid_uri_seahorse_valid_uri_func (const gchar* uri)
{
	gboolean result;
	result = seahorse_hkp_is_valid_uri (uri);
	return result;
}

void
seahorse_server_category_init (void)
{
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	SeahorseServerCategory* _tmp2_;
	GPtrArray* _tmp3_;
	SeahorseServerCategory* _tmp4_;
	GPtrArray* _tmp5_;
	SeahorseServerCategory* _tmp6_;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (seahorse_server_category_categories);
	seahorse_server_category_categories = _tmp0_;
	_tmp1_ = seahorse_server_category_categories;
	_tmp2_ = seahorse_server_category_new (SEAHORSE_TYPE_LDAP_SOURCE, "ldap", _ ("LDAP Key Server"), _seahorse_ldap_is_valid_uri_seahorse_valid_uri_func);
	g_ptr_array_add (_tmp1_, _tmp2_);
	_tmp3_ = seahorse_server_category_categories;
	_tmp4_ = seahorse_server_category_new (SEAHORSE_TYPE_HKP_SOURCE, "hkp", _ ("HTTP Key Server"), _seahorse_hkp_is_valid_uri_seahorse_valid_uri_func);
	g_ptr_array_add (_tmp3_, _tmp4_);
	_tmp5_ = seahorse_server_category_categories;
	_tmp6_ = seahorse_server_category_new (SEAHORSE_TYPE_HKP_SOURCE, "hkps", _ ("HTTPS Key Server"), _seahorse_hkp_is_valid_uri_seahorse_valid_uri_func);
	g_ptr_array_add (_tmp5_, _tmp6_);
}

/**
     * Returns a null-terminated string array of supported schemes
     */
static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
seahorse_server_category_get_types (void)
{
	gchar** types = NULL;
	gchar** _tmp0_;
	gint types_length1;
	gint _types_size_;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	types = _tmp0_;
	types_length1 = 0;
	_types_size_ = types_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gconstpointer _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = seahorse_server_category_categories;
				_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < ((guint) _tmp5_))) {
					break;
				}
				_tmp6_ = seahorse_server_category_categories;
				_tmp7_ = g_ptr_array_index (_tmp6_, i);
				_tmp8_ = ((SeahorseServerCategory*) _tmp7_)->priv->_scheme;
				_tmp9_ = g_strdup (_tmp8_);
				_vala_array_add9 (&types, &types_length1, &_types_size_, _tmp9_);
			}
		}
	}
	result = types;
	return result;
}

SeahorseServerCategory*
seahorse_server_category_find_category (const gchar* scheme)
{
	SeahorseServerCategory* result;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = seahorse_server_category_categories;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = seahorse_server_category_categories;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				_tmp7_ = ((SeahorseServerCategory*) _tmp6_)->priv->_scheme;
				if (g_strcmp0 (scheme, _tmp7_) == 0) {
					GPtrArray* _tmp8_;
					gconstpointer _tmp9_;
					_tmp8_ = seahorse_server_category_categories;
					_tmp9_ = g_ptr_array_index (_tmp8_, i);
					result = (SeahorseServerCategory*) _tmp9_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

/**
     * Checks to see if the passed uri is valid against registered validators
     */
gboolean
seahorse_server_category_is_valid_uri (const gchar* uri)
{
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp1_ = _tmp0_ = g_strsplit (uri, ":", 2);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	_tmp2_ = parts;
	_tmp2__length1 = parts_length1;
	if (_tmp2__length1 <= 0) {
		result = FALSE;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				GPtrArray* _tmp11_;
				gconstpointer _tmp12_;
				const gchar* _tmp13_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = seahorse_server_category_categories;
				_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < ((guint) _tmp7_))) {
					break;
				}
				_tmp9_ = parts;
				_tmp9__length1 = parts_length1;
				_tmp10_ = _tmp9_[0];
				_tmp11_ = seahorse_server_category_categories;
				_tmp12_ = g_ptr_array_index (_tmp11_, i);
				_tmp13_ = ((SeahorseServerCategory*) _tmp12_)->priv->_scheme;
				if (g_strcmp0 (_tmp10_, _tmp13_) == 0) {
					GPtrArray* _tmp14_;
					gconstpointer _tmp15_;
					SeahorseValidUriFunc _tmp16_;
					_tmp14_ = seahorse_server_category_categories;
					_tmp15_ = g_ptr_array_index (_tmp14_, i);
					_tmp16_ = ((SeahorseServerCategory*) _tmp15_)->validator;
					_tmp8_ = _tmp16_ (uri);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					result = TRUE;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = FALSE;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

GType
seahorse_server_category_get_gtype (SeahorseServerCategory* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_gtype;
	return result;
}

static void
seahorse_server_category_set_gtype (SeahorseServerCategory* self,
                                    GType value)
{
	GType old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_server_category_get_gtype (self);
	if (old_value != value) {
		self->priv->_gtype = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_server_category_properties[SEAHORSE_SERVER_CATEGORY_GTYPE_PROPERTY]);
	}
}

const gchar*
seahorse_server_category_get_scheme (SeahorseServerCategory* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scheme;
	result = _tmp0_;
	return result;
}

static void
seahorse_server_category_set_scheme (SeahorseServerCategory* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_server_category_get_scheme (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_scheme);
		self->priv->_scheme = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_server_category_properties[SEAHORSE_SERVER_CATEGORY_SCHEME_PROPERTY]);
	}
}

const gchar*
seahorse_server_category_get_description (SeahorseServerCategory* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
seahorse_server_category_set_description (SeahorseServerCategory* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_server_category_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_server_category_properties[SEAHORSE_SERVER_CATEGORY_DESCRIPTION_PROPERTY]);
	}
}

static void
seahorse_server_category_class_init (SeahorseServerCategoryClass * klass,
                                     gpointer klass_data)
{
	seahorse_server_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseServerCategory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_server_category_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_server_category_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_server_category_finalize;
	/** The scheme of servers (ie the scheme) */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SERVER_CATEGORY_GTYPE_PROPERTY, seahorse_server_category_properties[SEAHORSE_SERVER_CATEGORY_GTYPE_PROPERTY] = g_param_spec_gtype ("gtype", "gtype", "gtype", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/** The scheme of servers (ie the scheme) */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SERVER_CATEGORY_SCHEME_PROPERTY, seahorse_server_category_properties[SEAHORSE_SERVER_CATEGORY_SCHEME_PROPERTY] = g_param_spec_string ("scheme", "scheme", "scheme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/** User-facing string to describe it */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SERVER_CATEGORY_DESCRIPTION_PROPERTY, seahorse_server_category_properties[SEAHORSE_SERVER_CATEGORY_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
seahorse_server_category_instance_init (SeahorseServerCategory * self,
                                        gpointer klass)
{
	self->priv = seahorse_server_category_get_instance_private (self);
}

static void
seahorse_server_category_finalize (GObject * obj)
{
	SeahorseServerCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_SERVER_CATEGORY, SeahorseServerCategory);
	_g_free0 (self->priv->_scheme);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (seahorse_server_category_parent_class)->finalize (obj);
}

/**
 * Describes a category of servers
 */
 G_GNUC_NO_INLINE static GType
seahorse_server_category_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseServerCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_server_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseServerCategory), 0, (GInstanceInitFunc) seahorse_server_category_instance_init, NULL };
	GType seahorse_server_category_type_id;
	seahorse_server_category_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseServerCategory", &g_define_type_info, 0);
	SeahorseServerCategory_private_offset = g_type_add_instance_private (seahorse_server_category_type_id, sizeof (SeahorseServerCategoryPrivate));
	return seahorse_server_category_type_id;
}

GType
seahorse_server_category_get_type (void)
{
	static volatile gsize seahorse_server_category_type_id__once = 0;
	if (g_once_init_enter (&seahorse_server_category_type_id__once)) {
		GType seahorse_server_category_type_id;
		seahorse_server_category_type_id = seahorse_server_category_get_type_once ();
		g_once_init_leave (&seahorse_server_category_type_id__once, seahorse_server_category_type_id);
	}
	return seahorse_server_category_type_id__once;
}

static void
_vala_seahorse_server_category_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SeahorseServerCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_SERVER_CATEGORY, SeahorseServerCategory);
	switch (property_id) {
		case SEAHORSE_SERVER_CATEGORY_GTYPE_PROPERTY:
		g_value_set_gtype (value, seahorse_server_category_get_gtype (self));
		break;
		case SEAHORSE_SERVER_CATEGORY_SCHEME_PROPERTY:
		g_value_set_string (value, seahorse_server_category_get_scheme (self));
		break;
		case SEAHORSE_SERVER_CATEGORY_DESCRIPTION_PROPERTY:
		g_value_set_string (value, seahorse_server_category_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_server_category_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SeahorseServerCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_SERVER_CATEGORY, SeahorseServerCategory);
	switch (property_id) {
		case SEAHORSE_SERVER_CATEGORY_GTYPE_PROPERTY:
		seahorse_server_category_set_gtype (self, g_value_get_gtype (value));
		break;
		case SEAHORSE_SERVER_CATEGORY_SCHEME_PROPERTY:
		seahorse_server_category_set_scheme (self, g_value_get_string (value));
		break;
		case SEAHORSE_SERVER_CATEGORY_DESCRIPTION_PROPERTY:
		seahorse_server_category_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

