/* place.c generated by valac 0.56.7, the Vala compiler
 * generated from place.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2004,2005 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2013 Stef Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

static GType seahorse_place_get_type_once (void);

/**
     * We generally divide a SeahorsePlace in some high level categories.
     *
     * These are then used to group places in the sidebar.
     */
const gchar*
seahorse_place_category_to_string (SeahorsePlaceCategory self)
{
	const gchar* result;
	switch (self) {
		case SEAHORSE_PLACE_CATEGORY_PASSWORDS:
		{
			result = _ ("Passwords");
			return result;
		}
		case SEAHORSE_PLACE_CATEGORY_KEYS:
		{
			result = _ ("Keys");
			return result;
		}
		case SEAHORSE_PLACE_CATEGORY_CERTIFICATES:
		{
			result = _ ("Certificates");
			return result;
		}
		default:
		break;
	}
	g_return_val_if_reached (NULL);
}

 G_GNUC_NO_INLINE static GType
seahorse_place_category_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_PLACE_CATEGORY_PASSWORDS, "SEAHORSE_PLACE_CATEGORY_PASSWORDS", "passwords"}, {SEAHORSE_PLACE_CATEGORY_KEYS, "SEAHORSE_PLACE_CATEGORY_KEYS", "keys"}, {SEAHORSE_PLACE_CATEGORY_CERTIFICATES, "SEAHORSE_PLACE_CATEGORY_CERTIFICATES", "certificates"}, {0, NULL, NULL}};
	GType seahorse_place_category_type_id;
	seahorse_place_category_type_id = g_enum_register_static ("SeahorsePlaceCategory", values);
	return seahorse_place_category_type_id;
}

GType
seahorse_place_category_get_type (void)
{
	static volatile gsize seahorse_place_category_type_id__once = 0;
	if (g_once_init_enter (&seahorse_place_category_type_id__once)) {
		GType seahorse_place_category_type_id;
		seahorse_place_category_type_id = seahorse_place_category_get_type_once ();
		g_once_init_leave (&seahorse_place_category_type_id__once, seahorse_place_category_type_id);
	}
	return seahorse_place_category_type_id__once;
}

void
seahorse_place_load (SeahorsePlace* self,
                     GCancellable* cancellable,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	SeahorsePlaceIface* _iface_;
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->load) {
		_iface_->load (self, cancellable, _callback_, _user_data_);
	}
}

gboolean
seahorse_place_load_finish (SeahorsePlace* self,
                            GAsyncResult* _res_,
                            GError** error)
{
	SeahorsePlaceIface* _iface_;
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->load_finish) {
		return _iface_->load_finish (self, _res_, error);
	}
	return FALSE;
}

gchar*
seahorse_place_get_label (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_label) {
		return _iface_->get_label (self);
	}
	return NULL;
}

void
seahorse_place_set_label (SeahorsePlace* self,
                          const gchar* value)
{
	SeahorsePlaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->set_label) {
		_iface_->set_label (self, value);
	}
}

gchar*
seahorse_place_get_description (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_description) {
		return _iface_->get_description (self);
	}
	return NULL;
}

gchar*
seahorse_place_get_uri (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_uri) {
		return _iface_->get_uri (self);
	}
	return NULL;
}

GIcon*
seahorse_place_get_icon (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_icon) {
		return _iface_->get_icon (self);
	}
	return NULL;
}

SeahorsePlaceCategory
seahorse_place_get_category (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_category) {
		return _iface_->get_category (self);
	}
	return 0;
}

gboolean
seahorse_place_get_show_if_empty (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_show_if_empty) {
		return _iface_->get_show_if_empty (self);
	}
	return FALSE;
}

GActionGroup*
seahorse_place_get_actions (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_actions) {
		return _iface_->get_actions (self);
	}
	return NULL;
}

const gchar*
seahorse_place_get_action_prefix (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_action_prefix) {
		return _iface_->get_action_prefix (self);
	}
	return NULL;
}

GMenuModel*
seahorse_place_get_menu_model (SeahorsePlace* self)
{
	SeahorsePlaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_PLACE_GET_INTERFACE (self);
	if (_iface_->get_menu_model) {
		return _iface_->get_menu_model (self);
	}
	return NULL;
}

static void
seahorse_place_default_init (SeahorsePlaceIface * iface,
                             gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_enum ("category", "category", "category", SEAHORSE_PLACE_TYPE_CATEGORY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * In some cases, we do not want to show the Place in the sidebar
	     * if it's empty (for example p11-kit's System Trust), while we do
	     * want this for others (like libsecret keyrings).
	     */
	g_object_interface_install_property (iface, g_param_spec_boolean ("show-if-empty", "show-if-empty", "show-if-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the {@link GLib.Action}s that are defined for this Place,
	     * or null if none.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("actions", "actions", "actions", g_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the prefix that is used for the actions in this.menu_model.
	     */
	g_object_interface_install_property (iface, g_param_spec_string ("action-prefix", "action-prefix", "action-prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the menu of basic actions that apply specifically to
	     * this Place. Can be used for example to show a context menu.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("menu-model", "menu-model", "menu-model", g_menu_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * A SeahorsePlace is a collection of objects (passwords/keys/certificates/...).
 * An example of this is a keyring.
 */
 G_GNUC_NO_INLINE static GType
seahorse_place_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorsePlaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_place_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType seahorse_place_type_id;
	seahorse_place_type_id = g_type_register_static (G_TYPE_INTERFACE, "SeahorsePlace", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (seahorse_place_type_id, gcr_collection_get_type ());
	return seahorse_place_type_id;
}

GType
seahorse_place_get_type (void)
{
	static volatile gsize seahorse_place_type_id__once = 0;
	if (g_once_init_enter (&seahorse_place_type_id__once)) {
		GType seahorse_place_type_id;
		seahorse_place_type_id = seahorse_place_get_type_once ();
		g_once_init_leave (&seahorse_place_type_id__once, seahorse_place_type_id);
	}
	return seahorse_place_type_id__once;
}

