/* pgp-settings.c generated by valac 0.56.7, the Vala compiler
 * generated from pgp-settings.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2018 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */
/* This schema is installed by libgcr */

#include "seahorse-common.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

enum  {
	SEAHORSE_PGP_SETTINGS_0_PROPERTY,
	SEAHORSE_PGP_SETTINGS_ASCII_ARMOR_PROPERTY,
	SEAHORSE_PGP_SETTINGS_DEFAULT_KEY_PROPERTY,
	SEAHORSE_PGP_SETTINGS_ENCRYPT_TO_SELF_PROPERTY,
	SEAHORSE_PGP_SETTINGS_KEYSERVERS_PROPERTY,
	SEAHORSE_PGP_SETTINGS_LAST_SIGNER_PROPERTY,
	SEAHORSE_PGP_SETTINGS_SORT_RECIPIENTS_BY_PROPERTY,
	SEAHORSE_PGP_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer seahorse_pgp_settings_parent_class = NULL;
static SeahorsePgpSettings* seahorse_pgp_settings__instance;
static SeahorsePgpSettings* seahorse_pgp_settings__instance = NULL;

static gchar* seahorse_pgp_settings_get_uri_for_keyserver_entry (SeahorsePgpSettings* self,
                                                          const gchar* keyserver);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* seahorse_pgp_settings_get_name_for_keyserver_entry (SeahorsePgpSettings* self,
                                                           const gchar* keyserver);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void seahorse_pgp_settings_finalize (GObject * obj);
static GType seahorse_pgp_settings_get_type_once (void);
static void _vala_seahorse_pgp_settings_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_seahorse_pgp_settings_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

SeahorsePgpSettings*
seahorse_pgp_settings_construct (GType object_type)
{
	SeahorsePgpSettings * self = NULL;
	self = (SeahorsePgpSettings*) g_object_new (object_type, "schema-id", "org.gnome.crypto.pgp", NULL);
	seahorse_server_category_init ();
	return self;
}

SeahorsePgpSettings*
seahorse_pgp_settings_new (void)
{
	return seahorse_pgp_settings_construct (SEAHORSE_TYPE_PGP_SETTINGS);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SeahorsePgpSettings*
seahorse_pgp_settings_instance (void)
{
	SeahorsePgpSettings* _tmp0_;
	SeahorsePgpSettings* _tmp2_;
	SeahorsePgpSettings* _tmp3_;
	SeahorsePgpSettings* result;
	_tmp0_ = seahorse_pgp_settings__instance;
	if (_tmp0_ == NULL) {
		SeahorsePgpSettings* _tmp1_;
		_tmp1_ = seahorse_pgp_settings_new ();
		_g_object_unref0 (seahorse_pgp_settings__instance);
		seahorse_pgp_settings__instance = _tmp1_;
	}
	_tmp2_ = seahorse_pgp_settings__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
seahorse_pgp_settings_get_uris (SeahorsePgpSettings* self)
{
	gchar** uris = NULL;
	gchar** _tmp0_;
	gint uris_length1;
	gint _uris_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	uris = _tmp0_;
	uris_length1 = 0;
	_uris_size_ = uris_length1;
	_tmp1_ = seahorse_pgp_settings_get_keyservers (self, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	{
		gchar** server_collection = NULL;
		gint server_collection_length1 = 0;
		gint _server_collection_size_ = 0;
		gint server_it = 0;
		server_collection = _tmp3_;
		server_collection_length1 = _tmp3__length1;
		for (server_it = 0; server_it < server_collection_length1; server_it = server_it + 1) {
			const gchar* server = NULL;
			server = server_collection[server_it];
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = server;
				_tmp5_ = seahorse_pgp_settings_get_uri_for_keyserver_entry (self, _tmp4_);
				_vala_array_add1 (&uris, &uris_length1, &_uris_size_, _tmp5_);
			}
		}
		server_collection = (_vala_array_free (server_collection, server_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = uris;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
seahorse_pgp_settings_get_names (SeahorsePgpSettings* self)
{
	gchar** names = NULL;
	gchar** _tmp0_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	names = _tmp0_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp1_ = seahorse_pgp_settings_get_keyservers (self, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	{
		gchar** server_collection = NULL;
		gint server_collection_length1 = 0;
		gint _server_collection_size_ = 0;
		gint server_it = 0;
		server_collection = _tmp3_;
		server_collection_length1 = _tmp3__length1;
		for (server_it = 0; server_it < server_collection_length1; server_it = server_it + 1) {
			const gchar* server = NULL;
			server = server_collection[server_it];
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = server;
				_tmp5_ = seahorse_pgp_settings_get_name_for_keyserver_entry (self, _tmp4_);
				_vala_array_add2 (&names, &names_length1, &_names_size_, _tmp5_);
			}
		}
		server_collection = (_vala_array_free (server_collection, server_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = names;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
seahorse_pgp_settings_add_keyserver (SeahorsePgpSettings* self,
                                     const gchar* uri,
                                     const gchar* name)
{
	gchar** servers = NULL;
	gchar** _tmp0_;
	gint servers_length1;
	gint _servers_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	servers = _tmp0_;
	servers_length1 = 0;
	_servers_size_ = servers_length1;
	_tmp1_ = seahorse_pgp_settings_get_keyservers (self, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = _vala_string_array_contains (_tmp4_, _tmp3__length1, uri);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp5_) {
		servers = (_vala_array_free (servers, servers_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	g_debug ("pgp-settings.vala:92: Adding key server URL '%s'", uri);
	_tmp6_ = seahorse_pgp_settings_get_keyservers (self, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	{
		gchar** keyserver_collection = NULL;
		gint keyserver_collection_length1 = 0;
		gint _keyserver_collection_size_ = 0;
		gint keyserver_it = 0;
		keyserver_collection = _tmp8_;
		keyserver_collection_length1 = _tmp8__length1;
		for (keyserver_it = 0; keyserver_it < keyserver_collection_length1; keyserver_it = keyserver_it + 1) {
			const gchar* keyserver = NULL;
			keyserver = keyserver_collection[keyserver_it];
			{
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = keyserver;
				_tmp10_ = g_strdup (_tmp9_);
				_vala_array_add3 (&servers, &servers_length1, &_servers_size_, _tmp10_);
			}
		}
		keyserver_collection = (_vala_array_free (keyserver_collection, keyserver_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (name != NULL) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup_printf ("%s %s", uri, name);
		_vala_array_add4 (&servers, &servers_length1, &_servers_size_, _tmp11_);
	} else {
		gchar* _tmp12_;
		_tmp12_ = g_strdup (uri);
		_vala_array_add5 (&servers, &servers_length1, &_servers_size_, _tmp12_);
	}
	_vala_array_add6 (&servers, &servers_length1, &_servers_size_, NULL);
	_tmp13_ = servers;
	_tmp13__length1 = servers_length1;
	seahorse_pgp_settings_set_keyservers (self, _tmp13_, _tmp13__length1);
	servers = (_vala_array_free (servers, servers_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
seahorse_pgp_settings_remove_keyserver (SeahorsePgpSettings* self,
                                        const gchar* uri)
{
	gchar** servers = NULL;
	gchar** _tmp0_;
	gint servers_length1;
	gint _servers_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	servers = _tmp0_;
	servers_length1 = 0;
	_servers_size_ = servers_length1;
	_tmp1_ = seahorse_pgp_settings_get_keyservers (self, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = !_vala_string_array_contains (_tmp4_, _tmp3__length1, uri);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp5_) {
		servers = (_vala_array_free (servers, servers_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	g_debug ("pgp-settings.vala:111: Removing key server URL '%s'", uri);
	_tmp6_ = seahorse_pgp_settings_get_keyservers (self, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	{
		gchar** keyserver_collection = NULL;
		gint keyserver_collection_length1 = 0;
		gint _keyserver_collection_size_ = 0;
		gint keyserver_it = 0;
		keyserver_collection = _tmp8_;
		keyserver_collection_length1 = _tmp8__length1;
		for (keyserver_it = 0; keyserver_it < keyserver_collection_length1; keyserver_it = keyserver_it + 1) {
			const gchar* keyserver = NULL;
			keyserver = keyserver_collection[keyserver_it];
			{
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_;
				_tmp9_ = keyserver;
				_tmp10_ = seahorse_pgp_settings_get_uri_for_keyserver_entry (self, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strcmp0 (_tmp11_, uri) != 0;
				_g_free0 (_tmp11_);
				if (_tmp12_) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = keyserver;
					_tmp14_ = g_strdup (_tmp13_);
					_vala_array_add7 (&servers, &servers_length1, &_servers_size_, _tmp14_);
				}
			}
		}
		keyserver_collection = (_vala_array_free (keyserver_collection, keyserver_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_vala_array_add8 (&servers, &servers_length1, &_servers_size_, NULL);
	_tmp15_ = servers;
	_tmp15__length1 = servers_length1;
	seahorse_pgp_settings_set_keyservers (self, _tmp15_, _tmp15__length1);
	servers = (_vala_array_free (servers, servers_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
seahorse_pgp_settings_get_uri_for_keyserver_entry (SeahorsePgpSettings* self,
                                                   const gchar* keyserver)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (keyserver != NULL, NULL);
	_tmp0_ = string_strip (keyserver);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 2);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_tmp5_ = _tmp4_[0];
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

static gchar*
seahorse_pgp_settings_get_name_for_keyserver_entry (SeahorsePgpSettings* self,
                                                    const gchar* keyserver)
{
	gchar** split = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint split_length1;
	gint _split_size_;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (keyserver != NULL, NULL);
	_tmp0_ = string_strip (keyserver);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 2);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	split = _tmp4_;
	split_length1 = _tmp4__length1;
	_split_size_ = split_length1;
	_tmp6_ = split;
	_tmp6__length1 = split_length1;
	if (_tmp6__length1 == 1) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		_tmp7_ = split;
		_tmp7__length1 = split_length1;
		_tmp8_ = _tmp7_[0];
		_tmp5_ = _tmp8_;
	} else {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = split;
		_tmp9__length1 = split_length1;
		_tmp10_ = _tmp9_[1];
		_tmp5_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp5_);
	result = _tmp11_;
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gboolean
seahorse_pgp_settings_get_ascii_armor (SeahorsePgpSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = g_settings_get_boolean ((GSettings*) self, "ascii-armor");
	return result;
}

void
seahorse_pgp_settings_set_ascii_armor (SeahorsePgpSettings* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	g_settings_set_boolean ((GSettings*) self, "ascii-armor", value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_ASCII_ARMOR_PROPERTY]);
}

gchar*
seahorse_pgp_settings_get_default_key (SeahorsePgpSettings* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_settings_get_string ((GSettings*) self, "default-key");
	result = _tmp0_;
	return result;
}

void
seahorse_pgp_settings_set_default_key (SeahorsePgpSettings* self,
                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	g_settings_set_string ((GSettings*) self, "default-key", value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_DEFAULT_KEY_PROPERTY]);
}

gboolean
seahorse_pgp_settings_get_encrypt_to_self (SeahorsePgpSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = g_settings_get_boolean ((GSettings*) self, "encrypt-to-self");
	return result;
}

void
seahorse_pgp_settings_set_encrypt_to_self (SeahorsePgpSettings* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	g_settings_set_boolean ((GSettings*) self, "encrypt-to-self", value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_ENCRYPT_TO_SELF_PROPERTY]);
}

gchar**
seahorse_pgp_settings_get_keyservers (SeahorsePgpSettings* self,
                                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = _tmp0_ = g_settings_get_strv ((GSettings*) self, "keyservers");
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
seahorse_pgp_settings_set_keyservers (SeahorsePgpSettings* self,
                                      gchar** value,
                                      gint value_length1)
{
	g_return_if_fail (self != NULL);
	g_settings_set_strv ((GSettings*) self, "keyservers", value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_KEYSERVERS_PROPERTY]);
}

gchar*
seahorse_pgp_settings_get_last_signer (SeahorsePgpSettings* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_settings_get_string ((GSettings*) self, "last-signer");
	result = _tmp0_;
	return result;
}

void
seahorse_pgp_settings_set_last_signer (SeahorsePgpSettings* self,
                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	g_settings_set_string ((GSettings*) self, "last-signer", value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_LAST_SIGNER_PROPERTY]);
}

gchar*
seahorse_pgp_settings_get_sort_recipients_by (SeahorsePgpSettings* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_settings_get_string ((GSettings*) self, "sort-recipients-by");
	result = _tmp0_;
	return result;
}

void
seahorse_pgp_settings_set_sort_recipients_by (SeahorsePgpSettings* self,
                                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	g_settings_set_string ((GSettings*) self, "sort-recipients-by", value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_SORT_RECIPIENTS_BY_PROPERTY]);
}

static void
seahorse_pgp_settings_class_init (SeahorsePgpSettingsClass * klass,
                                  gpointer klass_data)
{
	seahorse_pgp_settings_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pgp_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pgp_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pgp_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PGP_SETTINGS_ASCII_ARMOR_PROPERTY, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_ASCII_ARMOR_PROPERTY] = g_param_spec_boolean ("ascii-armor", "ascii-armor", "ascii-armor", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PGP_SETTINGS_DEFAULT_KEY_PROPERTY, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_DEFAULT_KEY_PROPERTY] = g_param_spec_string ("default-key", "default-key", "default-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PGP_SETTINGS_ENCRYPT_TO_SELF_PROPERTY, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_ENCRYPT_TO_SELF_PROPERTY] = g_param_spec_boolean ("encrypt-to-self", "encrypt-to-self", "encrypt-to-self", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Returns a list of keyservers. Each entry is of either the format "uri"
	     * or "uri name", where `name` is a display name of the given keyserver.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PGP_SETTINGS_KEYSERVERS_PROPERTY, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_KEYSERVERS_PROPERTY] = g_param_spec_boxed ("keyservers", "keyservers", "keyservers", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PGP_SETTINGS_LAST_SIGNER_PROPERTY, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_LAST_SIGNER_PROPERTY] = g_param_spec_string ("last-signer", "last-signer", "last-signer", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PGP_SETTINGS_SORT_RECIPIENTS_BY_PROPERTY, seahorse_pgp_settings_properties[SEAHORSE_PGP_SETTINGS_SORT_RECIPIENTS_BY_PROPERTY] = g_param_spec_string ("sort-recipients-by", "sort-recipients-by", "sort-recipients-by", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
seahorse_pgp_settings_instance_init (SeahorsePgpSettings * self,
                                     gpointer klass)
{
}

static void
seahorse_pgp_settings_finalize (GObject * obj)
{
	SeahorsePgpSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_PGP_SETTINGS, SeahorsePgpSettings);
	G_OBJECT_CLASS (seahorse_pgp_settings_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_pgp_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorsePgpSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pgp_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePgpSettings), 0, (GInstanceInitFunc) seahorse_pgp_settings_instance_init, NULL };
	GType seahorse_pgp_settings_type_id;
	seahorse_pgp_settings_type_id = g_type_register_static (g_settings_get_type (), "SeahorsePgpSettings", &g_define_type_info, 0);
	return seahorse_pgp_settings_type_id;
}

GType
seahorse_pgp_settings_get_type (void)
{
	static volatile gsize seahorse_pgp_settings_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pgp_settings_type_id__once)) {
		GType seahorse_pgp_settings_type_id;
		seahorse_pgp_settings_type_id = seahorse_pgp_settings_get_type_once ();
		g_once_init_leave (&seahorse_pgp_settings_type_id__once, seahorse_pgp_settings_type_id);
	}
	return seahorse_pgp_settings_type_id__once;
}

static void
_vala_seahorse_pgp_settings_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SeahorsePgpSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_PGP_SETTINGS, SeahorsePgpSettings);
	switch (property_id) {
		case SEAHORSE_PGP_SETTINGS_ASCII_ARMOR_PROPERTY:
		g_value_set_boolean (value, seahorse_pgp_settings_get_ascii_armor (self));
		break;
		case SEAHORSE_PGP_SETTINGS_DEFAULT_KEY_PROPERTY:
		g_value_take_string (value, seahorse_pgp_settings_get_default_key (self));
		break;
		case SEAHORSE_PGP_SETTINGS_ENCRYPT_TO_SELF_PROPERTY:
		g_value_set_boolean (value, seahorse_pgp_settings_get_encrypt_to_self (self));
		break;
		case SEAHORSE_PGP_SETTINGS_KEYSERVERS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, seahorse_pgp_settings_get_keyservers (self, &length));
		}
		break;
		case SEAHORSE_PGP_SETTINGS_LAST_SIGNER_PROPERTY:
		g_value_take_string (value, seahorse_pgp_settings_get_last_signer (self));
		break;
		case SEAHORSE_PGP_SETTINGS_SORT_RECIPIENTS_BY_PROPERTY:
		g_value_take_string (value, seahorse_pgp_settings_get_sort_recipients_by (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_pgp_settings_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SeahorsePgpSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_PGP_SETTINGS, SeahorsePgpSettings);
	switch (property_id) {
		case SEAHORSE_PGP_SETTINGS_ASCII_ARMOR_PROPERTY:
		seahorse_pgp_settings_set_ascii_armor (self, g_value_get_boolean (value));
		break;
		case SEAHORSE_PGP_SETTINGS_DEFAULT_KEY_PROPERTY:
		seahorse_pgp_settings_set_default_key (self, g_value_get_string (value));
		break;
		case SEAHORSE_PGP_SETTINGS_ENCRYPT_TO_SELF_PROPERTY:
		seahorse_pgp_settings_set_encrypt_to_self (self, g_value_get_boolean (value));
		break;
		case SEAHORSE_PGP_SETTINGS_KEYSERVERS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			seahorse_pgp_settings_set_keyservers (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case SEAHORSE_PGP_SETTINGS_LAST_SIGNER_PROPERTY:
		seahorse_pgp_settings_set_last_signer (self, g_value_get_string (value));
		break;
		case SEAHORSE_PGP_SETTINGS_SORT_RECIPIENTS_BY_PROPERTY:
		seahorse_pgp_settings_set_sort_recipients_by (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

