/* keyserver-control.c generated by valac 0.56.7, the Vala compiler
 * generated from keyserver-control.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2005 Stefan Walter
 * Copyright (C) 2017 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

enum  {
	SEAHORSE_KEYSERVER_CONTROL_0_PROPERTY,
	SEAHORSE_KEYSERVER_CONTROL_SETTINGS_KEY_PROPERTY,
	SEAHORSE_KEYSERVER_CONTROL_NONE_OPTION_PROPERTY,
	SEAHORSE_KEYSERVER_CONTROL_NUM_PROPERTIES
};
static GParamSpec* seahorse_keyserver_control_properties[SEAHORSE_KEYSERVER_CONTROL_NUM_PROPERTIES];
typedef enum  {
	SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT,
	SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO
} SeahorseKeyserverControlColumn;

#define SEAHORSE_KEYSERVER_CONTROL_TYPE_COLUMN (seahorse_keyserver_control_column_get_type ())
typedef enum  {
	SEAHORSE_KEYSERVER_CONTROL_OPTION_NONE,
	SEAHORSE_KEYSERVER_CONTROL_OPTION_SEPARATOR,
	SEAHORSE_KEYSERVER_CONTROL_OPTION_KEYSERVER
} SeahorseKeyserverControlOption;

#define SEAHORSE_KEYSERVER_CONTROL_TYPE_OPTION (seahorse_keyserver_control_option_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseKeyserverControlPrivate {
	gchar* _settings_key;
	gchar* _none_option;
	gboolean updating;
};

static gint SeahorseKeyserverControl_private_offset;
static gpointer seahorse_keyserver_control_parent_class = NULL;

static GType seahorse_keyserver_control_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType seahorse_keyserver_control_option_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean seahorse_keyserver_control_separator_func (SeahorseKeyserverControl* self,
                                                    GtkTreeModel* model,
                                                    GtkTreeIter* iter);
static gboolean _seahorse_keyserver_control_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                      GtkTreeIter* iter,
                                                                                      gpointer self);
static void seahorse_keyserver_control_populate_combo (SeahorseKeyserverControl* self,
                                                gboolean with_key);
static void seahorse_keyserver_control_on_keyserver_changed (SeahorseKeyserverControl* self,
                                                      GtkComboBox* widget);
static void _seahorse_keyserver_control_on_keyserver_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self);
static void __lambda16_ (SeahorseKeyserverControl* self);
static void ___lambda16__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void ___lambda17_ (SeahorseKeyserverControl* self);
static void ____lambda17__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static gint seahorse_keyserver_control_compare_func (SeahorseKeyserverControl* self,
                                              GtkTreeModel* model,
                                              GtkTreeIter* a,
                                              GtkTreeIter* b);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static void seahorse_keyserver_control_append_entry (SeahorseKeyserverControl* self,
                                              GtkListStore* store,
                                              const gchar* keyserver,
                                              SeahorseKeyserverControlOption option,
                                              GtkTreeIter* result);
static gint _seahorse_keyserver_control_compare_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                          GtkTreeIter* a,
                                                                          GtkTreeIter* b,
                                                                          gpointer self);
static void seahorse_keyserver_control_finalize (GObject * obj);
static GType seahorse_keyserver_control_get_type_once (void);
static void _vala_seahorse_keyserver_control_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_seahorse_keyserver_control_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
seahorse_keyserver_control_get_instance_private (SeahorseKeyserverControl* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseKeyserverControl_private_offset);
}

 G_GNUC_NO_INLINE static GType
seahorse_keyserver_control_column_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, "SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT", "text"}, {SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO, "SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO", "info"}, {0, NULL, NULL}};
	GType seahorse_keyserver_control_column_type_id;
	seahorse_keyserver_control_column_type_id = g_enum_register_static ("SeahorseKeyserverControlColumn", values);
	return seahorse_keyserver_control_column_type_id;
}

static GType
seahorse_keyserver_control_column_get_type (void)
{
	static volatile gsize seahorse_keyserver_control_column_type_id__once = 0;
	if (g_once_init_enter (&seahorse_keyserver_control_column_type_id__once)) {
		GType seahorse_keyserver_control_column_type_id;
		seahorse_keyserver_control_column_type_id = seahorse_keyserver_control_column_get_type_once ();
		g_once_init_leave (&seahorse_keyserver_control_column_type_id__once, seahorse_keyserver_control_column_type_id);
	}
	return seahorse_keyserver_control_column_type_id__once;
}

 G_GNUC_NO_INLINE static GType
seahorse_keyserver_control_option_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_KEYSERVER_CONTROL_OPTION_NONE, "SEAHORSE_KEYSERVER_CONTROL_OPTION_NONE", "none"}, {SEAHORSE_KEYSERVER_CONTROL_OPTION_SEPARATOR, "SEAHORSE_KEYSERVER_CONTROL_OPTION_SEPARATOR", "separator"}, {SEAHORSE_KEYSERVER_CONTROL_OPTION_KEYSERVER, "SEAHORSE_KEYSERVER_CONTROL_OPTION_KEYSERVER", "keyserver"}, {0, NULL, NULL}};
	GType seahorse_keyserver_control_option_type_id;
	seahorse_keyserver_control_option_type_id = g_enum_register_static ("SeahorseKeyserverControlOption", values);
	return seahorse_keyserver_control_option_type_id;
}

static GType
seahorse_keyserver_control_option_get_type (void)
{
	static volatile gsize seahorse_keyserver_control_option_type_id__once = 0;
	if (g_once_init_enter (&seahorse_keyserver_control_option_type_id__once)) {
		GType seahorse_keyserver_control_option_type_id;
		seahorse_keyserver_control_option_type_id = seahorse_keyserver_control_option_get_type_once ();
		g_once_init_leave (&seahorse_keyserver_control_option_type_id__once, seahorse_keyserver_control_option_type_id);
	}
	return seahorse_keyserver_control_option_type_id__once;
}

static gboolean
_seahorse_keyserver_control_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                             GtkTreeIter* iter,
                                                                             gpointer self)
{
	gboolean result;
	result = seahorse_keyserver_control_separator_func ((SeahorseKeyserverControl*) self, model, iter);
	return result;
}

static void
_seahorse_keyserver_control_on_keyserver_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self)
{
	seahorse_keyserver_control_on_keyserver_changed ((SeahorseKeyserverControl*) self, _sender);
}

static void
__lambda16_ (SeahorseKeyserverControl* self)
{
	seahorse_keyserver_control_populate_combo (self, FALSE);
}

static void
___lambda16__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda16_ ((SeahorseKeyserverControl*) self);
}

static void
___lambda17_ (SeahorseKeyserverControl* self)
{
	seahorse_keyserver_control_populate_combo (self, TRUE);
}

static void
____lambda17__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda17_ ((SeahorseKeyserverControl*) self);
}

SeahorseKeyserverControl*
seahorse_keyserver_control_construct (GType object_type,
                                      const gchar* settings_key,
                                      const gchar* none_option)
{
	SeahorseKeyserverControl * self = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkCellRendererText* _tmp0_;
	GtkCellRenderer* _tmp1_;
	GtkCellRenderer* _tmp2_;
	SeahorsePgpSettings* _tmp3_;
	SeahorsePgpSettings* _tmp4_;
	const gchar* _tmp5_;
	self = (SeahorseKeyserverControl*) g_object_new (object_type, "settings-key", settings_key, "none-option", none_option, NULL);
	self->priv->updating = FALSE;
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp0_);
	renderer = (GtkCellRenderer*) _tmp0_;
	_tmp1_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) self, _tmp1_, TRUE);
	_tmp2_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self, _tmp2_, "text", SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, NULL, NULL);
	gtk_combo_box_set_row_separator_func ((GtkComboBox*) self, _seahorse_keyserver_control_separator_func_gtk_tree_view_row_separator_func, g_object_ref (self), g_object_unref);
	seahorse_keyserver_control_populate_combo (self, TRUE);
	g_signal_connect_object ((GtkComboBox*) self, "changed", (GCallback) _seahorse_keyserver_control_on_keyserver_changed_gtk_combo_box_changed, self, 0);
	_tmp3_ = seahorse_pgp_settings_instance ();
	_tmp4_ = _tmp3_;
	g_signal_connect_object ((GSettings*) _tmp4_, "changed::keyserver", (GCallback) ___lambda16__g_settings_changed, self, 0);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_settings_key;
	if (_tmp5_ != NULL) {
		SeahorseAppSettings* _tmp6_;
		SeahorseAppSettings* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = seahorse_app_settings_instance ();
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->_settings_key;
		_tmp9_ = g_strconcat ("changed::", _tmp8_, NULL);
		g_signal_connect_object ((GSettings*) _tmp7_, _tmp9_, (GCallback) ____lambda17__g_settings_changed, self, 0);
		_g_free0 (_tmp9_);
		_g_object_unref0 (_tmp7_);
	}
	_g_object_unref0 (renderer);
	return self;
}

SeahorseKeyserverControl*
seahorse_keyserver_control_new (const gchar* settings_key,
                                const gchar* none_option)
{
	return seahorse_keyserver_control_construct (SEAHORSE_TYPE_KEYSERVER_CONTROL, settings_key, none_option);
}

gchar*
seahorse_keyserver_control_selected (SeahorseKeyserverControl* self)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gint info = 0;
	gchar* server = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gtk_combo_box_get_active_iter ((GtkComboBox*) self, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = gtk_combo_box_get_model ((GtkComboBox*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, &_tmp5_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO, &_tmp6_, -1, -1);
	_g_free0 (server);
	server = _tmp5_;
	info = _tmp6_;
	if (info == ((gint) SEAHORSE_KEYSERVER_CONTROL_OPTION_KEYSERVER)) {
		result = server;
		return result;
	}
	result = NULL;
	_g_free0 (server);
	return result;
}

static void
seahorse_keyserver_control_on_keyserver_changed (SeahorseKeyserverControl* self,
                                                 GtkComboBox* widget)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->updating) {
		return;
	}
	_tmp0_ = self->priv->_settings_key;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		SeahorseAppSettings* _tmp4_;
		SeahorseAppSettings* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = seahorse_keyserver_control_selected (self);
		_tmp1_ = _tmp2_;
		if (_tmp1_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp3_;
		}
		_tmp4_ = seahorse_app_settings_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->_settings_key;
		g_settings_set_string ((GSettings*) _tmp5_, _tmp6_, _tmp1_);
		_g_object_unref0 (_tmp5_);
		_g_free0 (_tmp1_);
	}
}

static gint
seahorse_keyserver_control_compare_func (SeahorseKeyserverControl* self,
                                         GtkTreeModel* model,
                                         GtkTreeIter* a,
                                         GtkTreeIter* b)
{
	gchar* desc_a = NULL;
	gchar* desc_b = NULL;
	gint info_a = 0;
	gint info_b = 0;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *a;
	gtk_tree_model_get (model, &_tmp0_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, &_tmp1_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO, &_tmp2_, -1, -1);
	_g_free0 (desc_a);
	desc_a = _tmp1_;
	info_a = _tmp2_;
	_tmp3_ = *b;
	gtk_tree_model_get (model, &_tmp3_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, &_tmp4_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO, &_tmp5_, -1, -1);
	_g_free0 (desc_b);
	desc_b = _tmp4_;
	info_b = _tmp5_;
	if (info_a != info_b) {
		result = info_a - info_b;
		_g_free0 (desc_b);
		_g_free0 (desc_a);
		return result;
	}
	if (info_a == ((gint) SEAHORSE_KEYSERVER_CONTROL_OPTION_KEYSERVER)) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = desc_a;
		_tmp7_ = desc_b;
		result = g_utf8_collate (_tmp6_, _tmp7_);
		_g_free0 (desc_b);
		_g_free0 (desc_a);
		return result;
	}
	result = 0;
	_g_free0 (desc_b);
	_g_free0 (desc_a);
	return result;
}

static gboolean
seahorse_keyserver_control_separator_func (SeahorseKeyserverControl* self,
                                           GtkTreeModel* model,
                                           GtkTreeIter* iter)
{
	gint info = 0;
	GtkTreeIter _tmp0_;
	gint _tmp1_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO, &_tmp1_, -1, -1);
	info = _tmp1_;
	result = info == ((gint) SEAHORSE_KEYSERVER_CONTROL_OPTION_SEPARATOR);
	return result;
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static gint
_seahorse_keyserver_control_compare_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                     GtkTreeIter* a,
                                                                     GtkTreeIter* b,
                                                                     gpointer self)
{
	gint result;
	result = seahorse_keyserver_control_compare_func ((SeahorseKeyserverControl*) self, model, a, b);
	return result;
}

static void
seahorse_keyserver_control_populate_combo (SeahorseKeyserverControl* self,
                                           gboolean with_key)
{
	GtkTreeIter* iter = NULL;
	GtkTreeIter* none_iter = NULL;
	GtkTreeIter* chosen_iter = NULL;
	gchar* chosen = NULL;
	gint chosen_info = 0;
	gboolean _tmp0_ = FALSE;
	GtkListStore* store = NULL;
	GtkListStore* _tmp16_;
	const gchar* _tmp17_;
	gboolean chosen_iter_set = FALSE;
	SeahorsePgpSettings* _tmp25_;
	SeahorsePgpSettings* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GtkListStore* _tmp41_;
	GtkListStore* _tmp42_;
	GtkListStore* _tmp43_;
	g_return_if_fail (self != NULL);
	none_iter = NULL;
	chosen_iter = NULL;
	chosen = NULL;
	chosen_info = (gint) SEAHORSE_KEYSERVER_CONTROL_OPTION_KEYSERVER;
	if (with_key) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_settings_key;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SeahorseAppSettings* _tmp2_;
		SeahorseAppSettings* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = seahorse_app_settings_instance ();
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_settings_key;
		_tmp5_ = g_settings_get_string ((GSettings*) _tmp3_, _tmp4_);
		_g_free0 (chosen);
		chosen = _tmp5_;
		_g_object_unref0 (_tmp3_);
	} else {
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreeIter* _tmp9_;
		_tmp7_ = gtk_combo_box_get_active_iter ((GtkComboBox*) self, &_tmp6_);
		__vala_GtkTreeIter_free0 (iter);
		_tmp8_ = _tmp6_;
		_tmp9_ = __vala_GtkTreeIter_copy0 (&_tmp8_);
		iter = _tmp9_;
		if (_tmp7_) {
			GtkTreeModel* _tmp10_;
			GtkTreeModel* _tmp11_;
			GtkTreeIter* _tmp12_;
			GtkTreeIter _tmp13_;
			gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			_tmp10_ = gtk_combo_box_get_model ((GtkComboBox*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = iter;
			_tmp13_ = *_tmp12_;
			gtk_tree_model_get (_tmp11_, &_tmp13_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, &_tmp14_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO, &_tmp15_, -1, -1);
			_g_free0 (chosen);
			chosen = _tmp14_;
			chosen_info = _tmp15_;
		}
	}
	self->priv->updating = TRUE;
	gtk_combo_box_set_model ((GtkComboBox*) self, NULL);
	_tmp16_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT, -1);
	store = _tmp16_;
	_tmp17_ = self->priv->_none_option;
	if (_tmp17_ != NULL) {
		GtkListStore* _tmp18_;
		const gchar* _tmp19_;
		GtkTreeIter _tmp20_ = {0};
		GtkTreeIter* _tmp21_;
		GtkListStore* _tmp22_;
		GtkTreeIter _tmp23_ = {0};
		GtkTreeIter* _tmp24_;
		_tmp18_ = store;
		_tmp19_ = self->priv->_none_option;
		seahorse_keyserver_control_append_entry (self, _tmp18_, _tmp19_, SEAHORSE_KEYSERVER_CONTROL_OPTION_NONE, &_tmp20_);
		_tmp21_ = __vala_GtkTreeIter_copy0 (&_tmp20_);
		__vala_GtkTreeIter_free0 (none_iter);
		none_iter = _tmp21_;
		_tmp22_ = store;
		seahorse_keyserver_control_append_entry (self, _tmp22_, NULL, SEAHORSE_KEYSERVER_CONTROL_OPTION_SEPARATOR, &_tmp23_);
		_tmp24_ = __vala_GtkTreeIter_copy0 (&_tmp23_);
		__vala_GtkTreeIter_free0 (iter);
		iter = _tmp24_;
	}
	chosen_iter_set = FALSE;
	_tmp25_ = seahorse_pgp_settings_instance ();
	_tmp26_ = _tmp25_;
	_tmp28_ = _tmp27_ = seahorse_pgp_settings_get_uris (_tmp26_);
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _vala_array_length (_tmp27_);
	_g_object_unref0 (_tmp26_);
	{
		gchar** keyserver_collection = NULL;
		gint keyserver_collection_length1 = 0;
		gint _keyserver_collection_size_ = 0;
		gint keyserver_it = 0;
		keyserver_collection = _tmp29_;
		keyserver_collection_length1 = _tmp29__length1;
		for (keyserver_it = 0; keyserver_it < keyserver_collection_length1; keyserver_it = keyserver_it + 1) {
			const gchar* keyserver = NULL;
			keyserver = keyserver_collection[keyserver_it];
			{
				const gchar* _tmp30_;
				GtkListStore* _tmp31_;
				const gchar* _tmp32_;
				GtkTreeIter _tmp33_ = {0};
				GtkTreeIter* _tmp34_;
				gboolean _tmp35_ = FALSE;
				const gchar* _tmp36_;
				_tmp30_ = keyserver;
				_vala_assert (_tmp30_ != NULL, "keyserver != null");
				_tmp31_ = store;
				_tmp32_ = keyserver;
				seahorse_keyserver_control_append_entry (self, _tmp31_, _tmp32_, SEAHORSE_KEYSERVER_CONTROL_OPTION_KEYSERVER, &_tmp33_);
				_tmp34_ = __vala_GtkTreeIter_copy0 (&_tmp33_);
				__vala_GtkTreeIter_free0 (iter);
				iter = _tmp34_;
				_tmp36_ = chosen;
				if (_tmp36_ != NULL) {
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					_tmp37_ = chosen;
					_tmp38_ = keyserver;
					_tmp35_ = g_strcmp0 (_tmp37_, _tmp38_) == 0;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					GtkTreeIter* _tmp39_;
					GtkTreeIter* _tmp40_;
					_tmp39_ = iter;
					_tmp40_ = __vala_GtkTreeIter_copy0 (_tmp39_);
					__vala_GtkTreeIter_free0 (chosen_iter);
					chosen_iter = _tmp40_;
					chosen_iter_set = TRUE;
				}
			}
		}
		keyserver_collection = (_vala_array_free (keyserver_collection, keyserver_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp41_ = store;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp41_, (gint) SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, _seahorse_keyserver_control_compare_func_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_tmp42_ = store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp42_, (gint) SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, GTK_SORT_ASCENDING);
	_tmp43_ = store;
	gtk_combo_box_set_model ((GtkComboBox*) self, (GtkTreeModel*) _tmp43_);
	if (chosen_iter_set) {
		GtkTreeIter* _tmp44_;
		_tmp44_ = chosen_iter;
		gtk_combo_box_set_active_iter ((GtkComboBox*) self, _tmp44_);
	} else {
		const gchar* _tmp45_;
		_tmp45_ = self->priv->_none_option;
		if (_tmp45_ != NULL) {
			GtkTreeIter* _tmp46_;
			_tmp46_ = none_iter;
			gtk_combo_box_set_active_iter ((GtkComboBox*) self, _tmp46_);
		}
	}
	self->priv->updating = FALSE;
	_g_object_unref0 (store);
	_g_free0 (chosen);
	__vala_GtkTreeIter_free0 (chosen_iter);
	__vala_GtkTreeIter_free0 (none_iter);
	__vala_GtkTreeIter_free0 (iter);
}

static void
seahorse_keyserver_control_append_entry (SeahorseKeyserverControl* self,
                                         GtkListStore* store,
                                         const gchar* keyserver,
                                         SeahorseKeyserverControlOption option,
                                         GtkTreeIter* result)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	gtk_list_store_append (store, &_tmp0_);
	iter = _tmp0_;
	_tmp1_ = iter;
	gtk_list_store_set (store, &_tmp1_, SEAHORSE_KEYSERVER_CONTROL_COLUMN_TEXT, keyserver, SEAHORSE_KEYSERVER_CONTROL_COLUMN_INFO, option, -1);
	*result = iter;
	return;
}

const gchar*
seahorse_keyserver_control_get_settings_key (SeahorseKeyserverControl* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings_key;
	result = _tmp0_;
	return result;
}

void
seahorse_keyserver_control_set_settings_key (SeahorseKeyserverControl* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_keyserver_control_get_settings_key (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_settings_key);
		self->priv->_settings_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_keyserver_control_properties[SEAHORSE_KEYSERVER_CONTROL_SETTINGS_KEY_PROPERTY]);
	}
}

const gchar*
seahorse_keyserver_control_get_none_option (SeahorseKeyserverControl* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_none_option;
	result = _tmp0_;
	return result;
}

void
seahorse_keyserver_control_set_none_option (SeahorseKeyserverControl* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_keyserver_control_get_none_option (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_none_option);
		self->priv->_none_option = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_keyserver_control_properties[SEAHORSE_KEYSERVER_CONTROL_NONE_OPTION_PROPERTY]);
	}
}

static void
seahorse_keyserver_control_class_init (SeahorseKeyserverControlClass * klass,
                                       gpointer klass_data)
{
	seahorse_keyserver_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseKeyserverControl_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_keyserver_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_keyserver_control_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_keyserver_control_finalize;
	/**
	     * Settings key to read/write selection
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_KEYSERVER_CONTROL_SETTINGS_KEY_PROPERTY, seahorse_keyserver_control_properties[SEAHORSE_KEYSERVER_CONTROL_SETTINGS_KEY_PROPERTY] = g_param_spec_string ("settings-key", "settings-key", "settings-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * Puts in an option for 'no key server'
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_KEYSERVER_CONTROL_NONE_OPTION_PROPERTY, seahorse_keyserver_control_properties[SEAHORSE_KEYSERVER_CONTROL_NONE_OPTION_PROPERTY] = g_param_spec_string ("none-option", "none-option", "none-option", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
seahorse_keyserver_control_instance_init (SeahorseKeyserverControl * self,
                                          gpointer klass)
{
	self->priv = seahorse_keyserver_control_get_instance_private (self);
}

static void
seahorse_keyserver_control_finalize (GObject * obj)
{
	SeahorseKeyserverControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_KEYSERVER_CONTROL, SeahorseKeyserverControl);
	_g_free0 (self->priv->_settings_key);
	_g_free0 (self->priv->_none_option);
	G_OBJECT_CLASS (seahorse_keyserver_control_parent_class)->finalize (obj);
}

/**
 * KeyServerControl: a control which allows you to select from a set
 * of keyservers.
 *
 * - Also displays shares for keys found via DNS-SD over the network.
 *
 * Properties:
 *   settings-key: (gchar*) The GSettings key to retrieve and set keyservers.
 *   none-option: (gchar*) Text to display for 'no key server'
 */
 G_GNUC_NO_INLINE static GType
seahorse_keyserver_control_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseKeyserverControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_keyserver_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseKeyserverControl), 0, (GInstanceInitFunc) seahorse_keyserver_control_instance_init, NULL };
	GType seahorse_keyserver_control_type_id;
	seahorse_keyserver_control_type_id = g_type_register_static (gtk_combo_box_get_type (), "SeahorseKeyserverControl", &g_define_type_info, 0);
	SeahorseKeyserverControl_private_offset = g_type_add_instance_private (seahorse_keyserver_control_type_id, sizeof (SeahorseKeyserverControlPrivate));
	return seahorse_keyserver_control_type_id;
}

GType
seahorse_keyserver_control_get_type (void)
{
	static volatile gsize seahorse_keyserver_control_type_id__once = 0;
	if (g_once_init_enter (&seahorse_keyserver_control_type_id__once)) {
		GType seahorse_keyserver_control_type_id;
		seahorse_keyserver_control_type_id = seahorse_keyserver_control_get_type_once ();
		g_once_init_leave (&seahorse_keyserver_control_type_id__once, seahorse_keyserver_control_type_id);
	}
	return seahorse_keyserver_control_type_id__once;
}

static void
_vala_seahorse_keyserver_control_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SeahorseKeyserverControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_KEYSERVER_CONTROL, SeahorseKeyserverControl);
	switch (property_id) {
		case SEAHORSE_KEYSERVER_CONTROL_SETTINGS_KEY_PROPERTY:
		g_value_set_string (value, seahorse_keyserver_control_get_settings_key (self));
		break;
		case SEAHORSE_KEYSERVER_CONTROL_NONE_OPTION_PROPERTY:
		g_value_set_string (value, seahorse_keyserver_control_get_none_option (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_keyserver_control_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SeahorseKeyserverControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_KEYSERVER_CONTROL, SeahorseKeyserverControl);
	switch (property_id) {
		case SEAHORSE_KEYSERVER_CONTROL_SETTINGS_KEY_PROPERTY:
		seahorse_keyserver_control_set_settings_key (self, g_value_get_string (value));
		break;
		case SEAHORSE_KEYSERVER_CONTROL_NONE_OPTION_PROPERTY:
		seahorse_keyserver_control_set_none_option (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

