/* datepicker.c generated by valac 0.56.7, the Vala compiler
 * generated from datepicker.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2021 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

enum  {
	SEAHORSE_DATE_PICKER_0_PROPERTY,
	SEAHORSE_DATE_PICKER_DATETIME_PROPERTY,
	SEAHORSE_DATE_PICKER_NUM_PROPERTIES
};
static GParamSpec* seahorse_date_picker_properties[SEAHORSE_DATE_PICKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SeahorseDatePickerPrivate {
	GtkEntry* date_entry;
	GtkPopover* calendar_popover;
	GtkCalendar* calendar;
	GDateTime* _datetime;
};

static gint SeahorseDatePicker_private_offset;
static gpointer seahorse_date_picker_parent_class = NULL;

static void seahorse_date_picker_on_date_entry_activated (SeahorseDatePicker* self,
                                                   GtkEntry* date_entry);
static void seahorse_date_picker_on_calendar_day_selected (SeahorseDatePicker* self,
                                                    GtkCalendar* calendar);
static void seahorse_date_picker_on_calendar_day_selected_double_click (SeahorseDatePicker* self,
                                                                 GtkCalendar* calendar);
static GObject * seahorse_date_picker_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _seahorse_date_picker_on_date_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                       gpointer self);
static void _seahorse_date_picker_on_calendar_day_selected_gtk_calendar_day_selected (GtkCalendar* _sender,
                                                                               gpointer self);
static void _seahorse_date_picker_on_calendar_day_selected_double_click_gtk_calendar_day_selected_double_click (GtkCalendar* _sender,
                                                                                                         gpointer self);
static void seahorse_date_picker_finalize (GObject * obj);
static GType seahorse_date_picker_get_type_once (void);
static void _vala_seahorse_date_picker_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_seahorse_date_picker_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
seahorse_date_picker_get_instance_private (SeahorseDatePicker* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseDatePicker_private_offset);
}

GtkWidget*
seahorse_date_picker_construct (GType object_type)
{
	SeahorseDatePicker * self = NULL;
	self = (SeahorseDatePicker*) g_object_new (object_type, NULL);
	return (GtkWidget*) self;
}

GtkWidget*
seahorse_date_picker_new (void)
{
	return seahorse_date_picker_construct (SEAHORSE_TYPE_DATE_PICKER);
}

static void
seahorse_date_picker_on_date_entry_activated (SeahorseDatePicker* self,
                                              GtkEntry* date_entry)
{
	gint y = 0;
	gint m = 0;
	gint d = 0;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_;
	GDateTime* parsed_date = NULL;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date_entry != NULL);
	_tmp0_ = gtk_entry_get_text (date_entry);
	_tmp4_ = sscanf (_tmp0_, "%d-%d-%d", &_tmp1_, &_tmp2_, &_tmp3_);
	y = _tmp1_;
	m = _tmp2_;
	d = _tmp3_;
	if (_tmp4_ != 3) {
		return;
	}
	_tmp5_ = g_date_time_new_utc (y, m, d, 0, 0, (gdouble) 0);
	parsed_date = _tmp5_;
	_tmp6_ = parsed_date;
	g_warning ("datepicker.vala:91: activated, %p", _tmp6_);
	_tmp7_ = parsed_date;
	if (_tmp7_ == NULL) {
		_g_date_time_unref0 (parsed_date);
		return;
	}
	_tmp8_ = parsed_date;
	seahorse_date_picker_set_datetime (self, _tmp8_);
	_g_date_time_unref0 (parsed_date);
}

static void
seahorse_date_picker_on_calendar_day_selected (SeahorseDatePicker* self,
                                               GtkCalendar* calendar)
{
	guint y = 0U;
	guint m = 0U;
	guint d = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (calendar != NULL);
	gtk_calendar_get_date (calendar, &_tmp0_, &_tmp1_, &_tmp2_);
	y = _tmp0_;
	m = _tmp1_;
	d = _tmp2_;
	_tmp3_ = g_date_time_new_utc ((gint) y, ((gint) m) + 1, (gint) d, 0, 0, (gdouble) 0);
	_tmp4_ = _tmp3_;
	seahorse_date_picker_set_datetime (self, _tmp4_);
	_g_date_time_unref0 (_tmp4_);
}

static void
seahorse_date_picker_on_calendar_day_selected_double_click (SeahorseDatePicker* self,
                                                            GtkCalendar* calendar)
{
	GtkPopover* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (calendar != NULL);
	_tmp0_ = self->priv->calendar_popover;
	gtk_popover_popdown (_tmp0_);
}

GDateTime*
seahorse_date_picker_get_datetime (SeahorseDatePicker* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_datetime;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
seahorse_date_picker_set_datetime (SeahorseDatePicker* self,
                                   GDateTime* value)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GtkEntry* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkCalendar* _tmp5_;
	GtkCalendar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_datetime;
	if (g_date_time_equal (_tmp0_, value)) {
		return;
	}
	_tmp1_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_datetime);
	self->priv->_datetime = _tmp1_;
	_tmp2_ = self->priv->date_entry;
	_tmp3_ = g_date_time_format (value, "%F");
	_tmp4_ = _tmp3_;
	gtk_entry_set_text (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->calendar;
	gtk_calendar_select_month (_tmp5_, (guint) (g_date_time_get_month (value) - 1), (guint) g_date_time_get_year (value));
	_tmp6_ = self->priv->calendar;
	gtk_calendar_select_day (_tmp6_, (guint) g_date_time_get_day_of_month (value));
	g_object_notify_by_pspec ((GObject *) self, seahorse_date_picker_properties[SEAHORSE_DATE_PICKER_DATETIME_PROPERTY]);
}

static void
_seahorse_date_picker_on_date_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                  gpointer self)
{
	seahorse_date_picker_on_date_entry_activated ((SeahorseDatePicker*) self, _sender);
}

static void
_seahorse_date_picker_on_calendar_day_selected_gtk_calendar_day_selected (GtkCalendar* _sender,
                                                                          gpointer self)
{
	seahorse_date_picker_on_calendar_day_selected ((SeahorseDatePicker*) self, _sender);
}

static void
_seahorse_date_picker_on_calendar_day_selected_double_click_gtk_calendar_day_selected_double_click (GtkCalendar* _sender,
                                                                                                    gpointer self)
{
	seahorse_date_picker_on_calendar_day_selected_double_click ((SeahorseDatePicker*) self, _sender);
}

static GObject *
seahorse_date_picker_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseDatePicker * self;
	GtkStyleContext* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkMenuButton* calendar_button = NULL;
	GtkMenuButton* _tmp8_;
	GtkMenuButton* _tmp9_;
	GtkMenuButton* _tmp10_;
	GtkMenuButton* _tmp11_;
	GtkMenuButton* _tmp12_;
	GtkPopover* _tmp13_;
	GtkMenuButton* _tmp14_;
	GtkPopover* _tmp15_;
	GtkCalendar* _tmp16_;
	GtkCalendar* _tmp17_;
	GtkCalendar* _tmp18_;
	GtkCalendar* _tmp19_;
	GtkCalendar* _tmp20_;
	GtkCalendar* _tmp21_;
	GtkPopover* _tmp22_;
	GtkCalendar* _tmp23_;
	parent_class = G_OBJECT_CLASS (seahorse_date_picker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_DATE_PICKER, SeahorseDatePicker);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "linked");
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->date_entry);
	self->priv->date_entry = _tmp1_;
	_tmp2_ = self->priv->date_entry;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->date_entry;
	gtk_entry_set_max_length (_tmp3_, 10);
	_tmp4_ = self->priv->date_entry;
	gtk_entry_set_max_width_chars (_tmp4_, 10);
	_tmp5_ = self->priv->date_entry;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Enter the date directly"));
	_tmp6_ = self->priv->date_entry;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) _seahorse_date_picker_on_date_entry_activated_gtk_entry_activate, self, 0);
	_tmp7_ = self->priv->date_entry;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp8_);
	calendar_button = _tmp8_;
	_tmp9_ = calendar_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = calendar_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("Select the date from a calendar"));
	_tmp11_ = calendar_button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = calendar_button;
	_tmp13_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->calendar_popover);
	self->priv->calendar_popover = _tmp13_;
	_tmp14_ = calendar_button;
	_tmp15_ = self->priv->calendar_popover;
	gtk_menu_button_set_popover (_tmp14_, _tmp15_);
	_tmp16_ = (GtkCalendar*) gtk_calendar_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->calendar);
	self->priv->calendar = _tmp16_;
	_tmp17_ = self->priv->calendar;
	gtk_widget_set_visible ((GtkWidget*) _tmp17_, TRUE);
	_tmp18_ = self->priv->calendar;
	g_object_set (_tmp18_, "show-day-names", TRUE, NULL);
	_tmp19_ = self->priv->calendar;
	g_object_set (_tmp19_, "show-heading", TRUE, NULL);
	_tmp20_ = self->priv->calendar;
	g_signal_connect_object (_tmp20_, "day-selected", (GCallback) _seahorse_date_picker_on_calendar_day_selected_gtk_calendar_day_selected, self, 0);
	_tmp21_ = self->priv->calendar;
	g_signal_connect_object (_tmp21_, "day-selected-double-click", (GCallback) _seahorse_date_picker_on_calendar_day_selected_double_click_gtk_calendar_day_selected_double_click, self, 0);
	_tmp22_ = self->priv->calendar_popover;
	_tmp23_ = self->priv->calendar;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_g_object_unref0 (calendar_button);
	return obj;
}

static void
seahorse_date_picker_class_init (SeahorseDatePickerClass * klass,
                                 gpointer klass_data)
{
	seahorse_date_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseDatePicker_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_date_picker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_date_picker_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_date_picker_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_date_picker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_DATE_PICKER_DATETIME_PROPERTY, seahorse_date_picker_properties[SEAHORSE_DATE_PICKER_DATETIME_PROPERTY] = g_param_spec_boxed ("datetime", "datetime", "datetime", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
seahorse_date_picker_instance_init (SeahorseDatePicker * self,
                                    gpointer klass)
{
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	self->priv = seahorse_date_picker_get_instance_private (self);
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	self->priv->_datetime = _tmp2_;
	_g_time_zone_unref0 (_tmp1_);
}

static void
seahorse_date_picker_finalize (GObject * obj)
{
	SeahorseDatePicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_DATE_PICKER, SeahorseDatePicker);
	_g_object_unref0 (self->priv->date_entry);
	_g_object_unref0 (self->priv->calendar_popover);
	_g_object_unref0 (self->priv->calendar);
	_g_date_time_unref0 (self->priv->_datetime);
	G_OBJECT_CLASS (seahorse_date_picker_parent_class)->finalize (obj);
}

/**
 * Shows a configurable date. A user can configure it by either manually
 * changing a {@link Gtk.Entry} or by opening up a popover with a
 * {@link Gtk.Calendar} and finding the right date there.
 */
 G_GNUC_NO_INLINE static GType
seahorse_date_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseDatePickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_date_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseDatePicker), 0, (GInstanceInitFunc) seahorse_date_picker_instance_init, NULL };
	GType seahorse_date_picker_type_id;
	seahorse_date_picker_type_id = g_type_register_static (gtk_box_get_type (), "SeahorseDatePicker", &g_define_type_info, 0);
	SeahorseDatePicker_private_offset = g_type_add_instance_private (seahorse_date_picker_type_id, sizeof (SeahorseDatePickerPrivate));
	return seahorse_date_picker_type_id;
}

GType
seahorse_date_picker_get_type (void)
{
	static volatile gsize seahorse_date_picker_type_id__once = 0;
	if (g_once_init_enter (&seahorse_date_picker_type_id__once)) {
		GType seahorse_date_picker_type_id;
		seahorse_date_picker_type_id = seahorse_date_picker_get_type_once ();
		g_once_init_leave (&seahorse_date_picker_type_id__once, seahorse_date_picker_type_id);
	}
	return seahorse_date_picker_type_id__once;
}

static void
_vala_seahorse_date_picker_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseDatePicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_DATE_PICKER, SeahorseDatePicker);
	switch (property_id) {
		case SEAHORSE_DATE_PICKER_DATETIME_PROPERTY:
		g_value_set_boxed (value, seahorse_date_picker_get_datetime (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_date_picker_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseDatePicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_DATE_PICKER, SeahorseDatePicker);
	switch (property_id) {
		case SEAHORSE_DATE_PICKER_DATETIME_PROPERTY:
		seahorse_date_picker_set_datetime (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

