/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/source4/librpc/gen_ndr/ndr_winsif.h"

#include "librpc/gen_ndr/ndr_nbt.h"
static enum ndr_err_code ndr_push_winsif_Address(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_Address *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->addr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_Address(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_Address *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->addr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_Address(struct ndr_print *ndr, const char *name, const struct winsif_Address *r)
{
	ndr_print_struct(ndr, name, "winsif_Address");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "type", r->type);
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_ipv4address(ndr, "addr", r->addr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_Action(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_Action r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_Action(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_Action *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_Action(struct ndr_print *ndr, const char *name, enum winsif_Action r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_ACTION_INSERT: val = "WINSIF_ACTION_INSERT"; break;
		case WINSIF_ACTION_DELETE: val = "WINSIF_ACTION_DELETE"; break;
		case WINSIF_ACTION_RELEASE: val = "WINSIF_ACTION_RELEASE"; break;
		case WINSIF_ACTION_MODIFY: val = "WINSIF_ACTION_MODIFY"; break;
		case WINSIF_ACTION_QUERY: val = "WINSIF_ACTION_QUERY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_RecordType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_RecordType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_RecordType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_RecordType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_RecordType(struct ndr_print *ndr, const char *name, enum winsif_RecordType r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_RECORD_UNIQUE_NAME: val = "WINSIF_RECORD_UNIQUE_NAME"; break;
		case WINSIF_RECORD_GROUP_NAME: val = "WINSIF_RECORD_GROUP_NAME"; break;
		case WINSIF_RECORD_SGROUP_NAME: val = "WINSIF_RECORD_SGROUP_NAME"; break;
		case WINSIF_RECORD_MHOMED_NAME: val = "WINSIF_RECORD_MHOMED_NAME"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_NodeType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_NodeType r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_NodeType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_NodeType *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_NodeType(struct ndr_print *ndr, const char *name, enum winsif_NodeType r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_NODE_B: val = "WINSIF_NODE_B"; break;
		case WINSIF_NODE_P: val = "WINSIF_NODE_P"; break;
		case WINSIF_NODE_H: val = "WINSIF_NODE_H"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_RecordState(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_RecordState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_RecordState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_RecordState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_RecordState(struct ndr_print *ndr, const char *name, enum winsif_RecordState r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_RECORD_ACTIVE: val = "WINSIF_RECORD_ACTIVE"; break;
		case WINSIF_RECORD_RELEASED: val = "WINSIF_RECORD_RELEASED"; break;
		case WINSIF_RECORD_TOMBSTONE: val = "WINSIF_RECORD_TOMBSTONE"; break;
		case WINSIF_RECORD_DELETED: val = "WINSIF_RECORD_DELETED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_RecordAction(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_RecordAction *r)
{
	uint32_t cntr_addresses_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_winsif_Action(ndr, NDR_SCALARS, r->cmd));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name?16:0));
		NDR_CHECK(ndr_push_winsif_RecordType(ndr, NDR_SCALARS, r->record_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_of_addresses));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->addresses));
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, &r->address));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->version_number));
		NDR_CHECK(ndr_push_winsif_NodeType(ndr, NDR_SCALARS, r->node_type));
		NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->owner_address));
		NDR_CHECK(ndr_push_winsif_RecordState(ndr, NDR_SCALARS, r->record_state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_static));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->expire_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_wrepl_nbt_name(ndr, NDR_SCALARS, r->name));
		}
		if (r->addresses) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_of_addresses));
			for (cntr_addresses_1 = 0; cntr_addresses_1 < (r->num_of_addresses); cntr_addresses_1++) {
				NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, &r->addresses[cntr_addresses_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_RecordAction(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_RecordAction *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	uint32_t _ptr_addresses;
	uint32_t size_addresses_1 = 0;
	uint32_t cntr_addresses_1;
	TALLOC_CTX *_mem_save_addresses_0 = NULL;
	TALLOC_CTX *_mem_save_addresses_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_winsif_Action(ndr, NDR_SCALARS, &r->cmd));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name_len));
		NDR_CHECK(ndr_pull_winsif_RecordType(ndr, NDR_SCALARS, &r->record_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_of_addresses));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_addresses));
		if (_ptr_addresses) {
			NDR_PULL_ALLOC(ndr, r->addresses);
		} else {
			r->addresses = NULL;
		}
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, &r->address));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->version_number));
		NDR_CHECK(ndr_pull_winsif_NodeType(ndr, NDR_SCALARS, &r->node_type));
		NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->owner_address));
		NDR_CHECK(ndr_pull_winsif_RecordState(ndr, NDR_SCALARS, &r->record_state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_static));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->expire_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_wrepl_nbt_name(ndr, NDR_SCALARS, &r->name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->addresses) {
			_mem_save_addresses_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addresses, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->addresses));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->addresses, &size_addresses_1));
			NDR_PULL_ALLOC_N(ndr, r->addresses, size_addresses_1);
			_mem_save_addresses_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addresses, 0);
			for (cntr_addresses_1 = 0; cntr_addresses_1 < (size_addresses_1); cntr_addresses_1++) {
				NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, &r->addresses[cntr_addresses_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addresses_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addresses_0, 0);
		}
		if (r->addresses) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->addresses, r->num_of_addresses));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_RecordAction(struct ndr_print *ndr, const char *name, const struct winsif_RecordAction *r)
{
	uint32_t cntr_addresses_1;
	ndr_print_struct(ndr, name, "winsif_RecordAction");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_winsif_Action(ndr, "cmd", r->cmd);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_wrepl_nbt_name(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->name?16:0:r->name_len);
	ndr_print_winsif_RecordType(ndr, "record_type", r->record_type);
	ndr_print_uint32(ndr, "num_of_addresses", r->num_of_addresses);
	ndr_print_ptr(ndr, "addresses", r->addresses);
	ndr->depth++;
	if (r->addresses) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "addresses", (uint32_t)(r->num_of_addresses));
		ndr->depth++;
		for (cntr_addresses_1 = 0; cntr_addresses_1 < (r->num_of_addresses); cntr_addresses_1++) {
			ndr_print_winsif_Address(ndr, "addresses", &r->addresses[cntr_addresses_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_winsif_Address(ndr, "address", &r->address);
	ndr_print_hyper(ndr, "version_number", r->version_number);
	ndr_print_winsif_NodeType(ndr, "node_type", r->node_type);
	ndr_print_ipv4address(ndr, "owner_address", r->owner_address);
	ndr_print_winsif_RecordState(ndr, "record_state", r->record_state);
	ndr_print_uint32(ndr, "is_static", r->is_static);
	ndr_print_time_t(ndr, "expire_time", r->expire_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_AddressVersionMap(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_AddressVersionMap *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, &r->address));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->version_number));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_AddressVersionMap(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_AddressVersionMap *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, &r->address));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->version_number));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_AddressVersionMap(struct ndr_print *ndr, const char *name, const struct winsif_AddressVersionMap *r)
{
	ndr_print_struct(ndr, name, "winsif_AddressVersionMap");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_winsif_Address(ndr, "address", &r->address);
	ndr_print_hyper(ndr, "version_number", r->version_number);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_PriorityClass(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_PriorityClass r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_PriorityClass(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_PriorityClass *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_PriorityClass(struct ndr_print *ndr, const char *name, enum winsif_PriorityClass r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_PRIORITY_NORMAL: val = "WINSIF_PRIORITY_NORMAL"; break;
		case WINSIF_PRIORITY_HIGH: val = "WINSIF_PRIORITY_HIGH"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_ReplCounter(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_ReplCounter *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, &r->address));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_replications));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_communication_failures));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_ReplCounter(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_ReplCounter *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, &r->address));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_replications));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_communication_failures));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_ReplCounter(struct ndr_print *ndr, const char *name, const struct winsif_ReplCounter *r)
{
	ndr_print_struct(ndr, name, "winsif_ReplCounter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_winsif_Address(ndr, "address", &r->address);
	ndr_print_uint32(ndr, "num_replications", r->num_replications);
	ndr_print_uint32(ndr, "num_communication_failures", r->num_communication_failures);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_StatCounters(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_StatCounters *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_unique_registrations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_group_registrations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_queries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_successful_queries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_failed_queries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_unique_refreshes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_group_refreshes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_releases));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_successful_releases));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_failed_releases));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_unique_conflicts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_group_conflicts));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_StatCounters(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_StatCounters *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_unique_registrations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_group_registrations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_queries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_successful_queries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_failed_queries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_unique_refreshes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_group_refreshes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_releases));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_successful_releases));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_failed_releases));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_unique_conflicts));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_group_conflicts));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_StatCounters(struct ndr_print *ndr, const char *name, const struct winsif_StatCounters *r)
{
	ndr_print_struct(ndr, name, "winsif_StatCounters");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_unique_registrations", r->num_unique_registrations);
	ndr_print_uint32(ndr, "num_group_registrations", r->num_group_registrations);
	ndr_print_uint32(ndr, "num_queries", r->num_queries);
	ndr_print_uint32(ndr, "num_successful_queries", r->num_successful_queries);
	ndr_print_uint32(ndr, "num_failed_queries", r->num_failed_queries);
	ndr_print_uint32(ndr, "num_unique_refreshes", r->num_unique_refreshes);
	ndr_print_uint32(ndr, "num_group_refreshes", r->num_group_refreshes);
	ndr_print_uint32(ndr, "num_releases", r->num_releases);
	ndr_print_uint32(ndr, "num_successful_releases", r->num_successful_releases);
	ndr_print_uint32(ndr, "num_failed_releases", r->num_failed_releases);
	ndr_print_uint32(ndr, "num_unique_conflicts", r->num_unique_conflicts);
	ndr_print_uint32(ndr, "num_group_conflicts", r->num_group_conflicts);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_StatTimeStamps(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_StatTimeStamps *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->wins_start_time));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_periodic_scavenging));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_triggered_scavenging));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_tombstone_scavenging));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_verification_scavenging));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_periodic_pull_replication));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_triggered_pull_replication));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->ignore_last_ntrepl));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->ignore_last_actrepl));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_init_db));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->counter_reset));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_StatTimeStamps(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_StatTimeStamps *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->wins_start_time));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_periodic_scavenging));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_triggered_scavenging));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_tombstone_scavenging));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_verification_scavenging));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_periodic_pull_replication));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_triggered_pull_replication));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->ignore_last_ntrepl));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->ignore_last_actrepl));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_init_db));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->counter_reset));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_StatTimeStamps(struct ndr_print *ndr, const char *name, const struct winsif_StatTimeStamps *r)
{
	ndr_print_struct(ndr, name, "winsif_StatTimeStamps");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_time_t(ndr, "wins_start_time", r->wins_start_time);
	ndr_print_time_t(ndr, "last_periodic_scavenging", r->last_periodic_scavenging);
	ndr_print_time_t(ndr, "last_triggered_scavenging", r->last_triggered_scavenging);
	ndr_print_time_t(ndr, "last_tombstone_scavenging", r->last_tombstone_scavenging);
	ndr_print_time_t(ndr, "last_verification_scavenging", r->last_verification_scavenging);
	ndr_print_time_t(ndr, "last_periodic_pull_replication", r->last_periodic_pull_replication);
	ndr_print_time_t(ndr, "last_triggered_pull_replication", r->last_triggered_pull_replication);
	ndr_print_time_t(ndr, "ignore_last_ntrepl", r->ignore_last_ntrepl);
	ndr_print_time_t(ndr, "ignore_last_actrepl", r->ignore_last_actrepl);
	ndr_print_time_t(ndr, "last_init_db", r->last_init_db);
	ndr_print_time_t(ndr, "counter_reset", r->counter_reset);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_Stat(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_Stat *r)
{
	uint32_t cntr_partners_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_winsif_StatCounters(ndr, NDR_SCALARS, &r->counters));
		NDR_CHECK(ndr_push_winsif_StatTimeStamps(ndr, NDR_SCALARS, &r->time_stamps));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_partners));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->partners));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->partners) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_partners));
			for (cntr_partners_1 = 0; cntr_partners_1 < (r->num_partners); cntr_partners_1++) {
				NDR_CHECK(ndr_push_winsif_ReplCounter(ndr, NDR_SCALARS, &r->partners[cntr_partners_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_Stat(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_Stat *r)
{
	uint32_t _ptr_partners;
	uint32_t size_partners_1 = 0;
	uint32_t cntr_partners_1;
	TALLOC_CTX *_mem_save_partners_0 = NULL;
	TALLOC_CTX *_mem_save_partners_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_winsif_StatCounters(ndr, NDR_SCALARS, &r->counters));
		NDR_CHECK(ndr_pull_winsif_StatTimeStamps(ndr, NDR_SCALARS, &r->time_stamps));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_partners));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partners));
		if (_ptr_partners) {
			NDR_PULL_ALLOC(ndr, r->partners);
		} else {
			r->partners = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->partners) {
			_mem_save_partners_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->partners, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->partners));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->partners, &size_partners_1));
			NDR_PULL_ALLOC_N(ndr, r->partners, size_partners_1);
			_mem_save_partners_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->partners, 0);
			for (cntr_partners_1 = 0; cntr_partners_1 < (size_partners_1); cntr_partners_1++) {
				NDR_CHECK(ndr_pull_winsif_ReplCounter(ndr, NDR_SCALARS, &r->partners[cntr_partners_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partners_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partners_0, 0);
		}
		if (r->partners) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->partners, r->num_partners));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_Stat(struct ndr_print *ndr, const char *name, const struct winsif_Stat *r)
{
	uint32_t cntr_partners_1;
	ndr_print_struct(ndr, name, "winsif_Stat");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_winsif_StatCounters(ndr, "counters", &r->counters);
	ndr_print_winsif_StatTimeStamps(ndr, "time_stamps", &r->time_stamps);
	ndr_print_uint32(ndr, "num_partners", r->num_partners);
	ndr_print_ptr(ndr, "partners", r->partners);
	ndr->depth++;
	if (r->partners) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "partners", (uint32_t)(r->num_partners));
		ndr->depth++;
		for (cntr_partners_1 = 0; cntr_partners_1 < (r->num_partners); cntr_partners_1++) {
			ndr_print_winsif_ReplCounter(ndr, "partners", &r->partners[cntr_partners_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_Results(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_Results *r)
{
	uint32_t cntr_address_version_maps_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_owners));
		for (cntr_address_version_maps_0 = 0; cntr_address_version_maps_0 < (25); cntr_address_version_maps_0++) {
			NDR_CHECK(ndr_push_winsif_AddressVersionMap(ndr, NDR_SCALARS, &r->address_version_maps[cntr_address_version_maps_0]));
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->my_max_version_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->refresh_interval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tombstone_interval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tombstone_timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->verify_interval));
		NDR_CHECK(ndr_push_winsif_PriorityClass(ndr, NDR_SCALARS, r->prioritiy_class));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_worker_threads));
		NDR_CHECK(ndr_push_winsif_Stat(ndr, NDR_SCALARS, &r->wstat));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_winsif_Stat(ndr, NDR_BUFFERS, &r->wstat));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_Results(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_Results *r)
{
	uint32_t size_address_version_maps_0 = 0;
	uint32_t cntr_address_version_maps_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_owners));
		size_address_version_maps_0 = 25;
		for (cntr_address_version_maps_0 = 0; cntr_address_version_maps_0 < (size_address_version_maps_0); cntr_address_version_maps_0++) {
			NDR_CHECK(ndr_pull_winsif_AddressVersionMap(ndr, NDR_SCALARS, &r->address_version_maps[cntr_address_version_maps_0]));
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->my_max_version_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->refresh_interval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tombstone_interval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tombstone_timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->verify_interval));
		NDR_CHECK(ndr_pull_winsif_PriorityClass(ndr, NDR_SCALARS, &r->prioritiy_class));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_worker_threads));
		NDR_CHECK(ndr_pull_winsif_Stat(ndr, NDR_SCALARS, &r->wstat));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_winsif_Stat(ndr, NDR_BUFFERS, &r->wstat));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_Results(struct ndr_print *ndr, const char *name, const struct winsif_Results *r)
{
	uint32_t cntr_address_version_maps_0;
	ndr_print_struct(ndr, name, "winsif_Results");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_owners", r->num_owners);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "address_version_maps", (uint32_t)(25));
	ndr->depth++;
	for (cntr_address_version_maps_0 = 0; cntr_address_version_maps_0 < (25); cntr_address_version_maps_0++) {
		ndr_print_winsif_AddressVersionMap(ndr, "address_version_maps", &r->address_version_maps[cntr_address_version_maps_0]);
	}
	ndr->depth--;
	ndr_print_hyper(ndr, "my_max_version_number", r->my_max_version_number);
	ndr_print_uint32(ndr, "refresh_interval", r->refresh_interval);
	ndr_print_uint32(ndr, "tombstone_interval", r->tombstone_interval);
	ndr_print_uint32(ndr, "tombstone_timeout", r->tombstone_timeout);
	ndr_print_uint32(ndr, "verify_interval", r->verify_interval);
	ndr_print_winsif_PriorityClass(ndr, "prioritiy_class", r->prioritiy_class);
	ndr_print_uint32(ndr, "num_worker_threads", r->num_worker_threads);
	ndr_print_winsif_Stat(ndr, "wstat", &r->wstat);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_StatusCmd(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_StatusCmd r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_StatusCmd(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_StatusCmd *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_StatusCmd(struct ndr_print *ndr, const char *name, enum winsif_StatusCmd r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_STATUS_CMD_ADDRESS_VERSION_MAP: val = "WINSIF_STATUS_CMD_ADDRESS_VERSION_MAP"; break;
		case WINSIF_STATUS_CMD_CONFIG: val = "WINSIF_STATUS_CMD_CONFIG"; break;
		case WINSIF_STATUS_CMD_STAT: val = "WINSIF_STATUS_CMD_STAT"; break;
		case WINSIF_STATUS_CMD_ALL_MAPS: val = "WINSIF_STATUS_CMD_ALL_MAPS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_TriggerType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_TriggerType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_TriggerType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_TriggerType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_TriggerType(struct ndr_print *ndr, const char *name, enum winsif_TriggerType r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_TRIGGER_PULL: val = "WINSIF_TRIGGER_PULL"; break;
		case WINSIF_TRIGGER_PUSH: val = "WINSIF_TRIGGER_PUSH"; break;
		case WINSIF_TRIGGER_PUSH_PROP: val = "WINSIF_TRIGGER_PUSH_PROP"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_Records(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_Records *r)
{
	uint32_t cntr_row_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->buffer_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->row));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_records));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_num_records));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->row) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_records));
			for (cntr_row_1 = 0; cntr_row_1 < (r->num_records); cntr_row_1++) {
				NDR_CHECK(ndr_push_winsif_RecordAction(ndr, NDR_SCALARS, &r->row[cntr_row_1]));
			}
			for (cntr_row_1 = 0; cntr_row_1 < (r->num_records); cntr_row_1++) {
				NDR_CHECK(ndr_push_winsif_RecordAction(ndr, NDR_BUFFERS, &r->row[cntr_row_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_Records(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_Records *r)
{
	uint32_t _ptr_row;
	uint32_t size_row_1 = 0;
	uint32_t cntr_row_1;
	TALLOC_CTX *_mem_save_row_0 = NULL;
	TALLOC_CTX *_mem_save_row_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->buffer_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_row));
		if (_ptr_row) {
			NDR_PULL_ALLOC(ndr, r->row);
		} else {
			r->row = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_records));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_num_records));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->row) {
			_mem_save_row_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->row, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->row));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->row, &size_row_1));
			NDR_PULL_ALLOC_N(ndr, r->row, size_row_1);
			_mem_save_row_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->row, 0);
			for (cntr_row_1 = 0; cntr_row_1 < (size_row_1); cntr_row_1++) {
				NDR_CHECK(ndr_pull_winsif_RecordAction(ndr, NDR_SCALARS, &r->row[cntr_row_1]));
			}
			for (cntr_row_1 = 0; cntr_row_1 < (size_row_1); cntr_row_1++) {
				NDR_CHECK(ndr_pull_winsif_RecordAction(ndr, NDR_BUFFERS, &r->row[cntr_row_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_row_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_row_0, 0);
		}
		if (r->row) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->row, r->num_records));
		}
		for (cntr_row_1 = 0; cntr_row_1 < (size_row_1); cntr_row_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_Records(struct ndr_print *ndr, const char *name, const struct winsif_Records *r)
{
	uint32_t cntr_row_1;
	ndr_print_struct(ndr, name, "winsif_Records");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "buffer_size", r->buffer_size);
	ndr_print_ptr(ndr, "row", r->row);
	ndr->depth++;
	if (r->row) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "row", (uint32_t)(r->num_records));
		ndr->depth++;
		for (cntr_row_1 = 0; cntr_row_1 < (r->num_records); cntr_row_1++) {
			ndr_print_winsif_RecordAction(ndr, "row", &r->row[cntr_row_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_records", r->num_records);
	ndr_print_uint32(ndr, "total_num_records", r->total_num_records);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_BrowserInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_BrowserInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_BrowserInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_BrowserInfo *r)
{
	uint32_t _ptr_name;
	uint32_t size_name_1 = 0;
	uint32_t length_name_1 = 0;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->name, &size_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->name, &length_name_1));
			if (length_name_1 > size_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_name_1, length_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, length_name_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_BrowserInfo(struct ndr_print *ndr, const char *name, const struct winsif_BrowserInfo *r)
{
	ndr_print_struct(ndr, name, "winsif_BrowserInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "name_len", r->name_len);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_BrowserNames(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_BrowserNames *r)
{
	uint32_t cntr_info_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_entries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_entries));
			for (cntr_info_1 = 0; cntr_info_1 < (r->num_entries); cntr_info_1++) {
				NDR_CHECK(ndr_push_winsif_BrowserInfo(ndr, NDR_SCALARS, &r->info[cntr_info_1]));
			}
			for (cntr_info_1 = 0; cntr_info_1 < (r->num_entries); cntr_info_1++) {
				NDR_CHECK(ndr_push_winsif_BrowserInfo(ndr, NDR_BUFFERS, &r->info[cntr_info_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_BrowserNames(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_BrowserNames *r)
{
	uint32_t _ptr_info;
	uint32_t size_info_1 = 0;
	uint32_t cntr_info_1;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_entries));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->info));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->info, &size_info_1));
			NDR_PULL_ALLOC_N(ndr, r->info, size_info_1);
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			for (cntr_info_1 = 0; cntr_info_1 < (size_info_1); cntr_info_1++) {
				NDR_CHECK(ndr_pull_winsif_BrowserInfo(ndr, NDR_SCALARS, &r->info[cntr_info_1]));
			}
			for (cntr_info_1 = 0; cntr_info_1 < (size_info_1); cntr_info_1++) {
				NDR_CHECK(ndr_pull_winsif_BrowserInfo(ndr, NDR_BUFFERS, &r->info[cntr_info_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (r->info) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->info, r->num_entries));
		}
		for (cntr_info_1 = 0; cntr_info_1 < (size_info_1); cntr_info_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_BrowserNames(struct ndr_print *ndr, const char *name, const struct winsif_BrowserNames *r)
{
	uint32_t cntr_info_1;
	ndr_print_struct(ndr, name, "winsif_BrowserNames");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_entries", r->num_entries);
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "info", (uint32_t)(r->num_entries));
		ndr->depth++;
		for (cntr_info_1 = 0; cntr_info_1 < (r->num_entries); cntr_info_1++) {
			ndr_print_winsif_BrowserInfo(ndr, "info", &r->info[cntr_info_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_BindData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_BindData *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tcp_ip));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_address));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pipe_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_address, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_address, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_address, ndr_charset_length(r->server_address, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
		if (r->pipe_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pipe_name, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pipe_name, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pipe_name, ndr_charset_length(r->pipe_name, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_BindData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_BindData *r)
{
	uint32_t _ptr_server_address;
	uint32_t size_server_address_1 = 0;
	uint32_t length_server_address_1 = 0;
	TALLOC_CTX *_mem_save_server_address_0 = NULL;
	uint32_t _ptr_pipe_name;
	uint32_t size_pipe_name_1 = 0;
	uint32_t length_pipe_name_1 = 0;
	TALLOC_CTX *_mem_save_pipe_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tcp_ip));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_address));
		if (_ptr_server_address) {
			NDR_PULL_ALLOC(ndr, r->server_address);
		} else {
			r->server_address = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pipe_name));
		if (_ptr_pipe_name) {
			NDR_PULL_ALLOC(ndr, r->pipe_name);
		} else {
			r->pipe_name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_address) {
			_mem_save_server_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->server_address, &size_server_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->server_address, &length_server_address_1));
			if (length_server_address_1 > size_server_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_server_address_1, length_server_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_address_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_address, length_server_address_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_address_0, 0);
		}
		if (r->pipe_name) {
			_mem_save_pipe_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pipe_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pipe_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pipe_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pipe_name, &size_pipe_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pipe_name, &length_pipe_name_1));
			if (length_pipe_name_1 > size_pipe_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pipe_name_1, length_pipe_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pipe_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pipe_name, length_pipe_name_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pipe_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_BindData(struct ndr_print *ndr, const char *name, const struct winsif_BindData *r)
{
	ndr_print_struct(ndr, name, "winsif_BindData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "tcp_ip", r->tcp_ip);
	ndr_print_ptr(ndr, "server_address", r->server_address);
	ndr->depth++;
	if (r->server_address) {
		ndr_print_string(ndr, "server_address", r->server_address);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pipe_name", r->pipe_name);
	ndr->depth++;
	if (r->pipe_name) {
		ndr_print_string(ndr, "pipe_name", r->pipe_name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_ResultsNew(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_ResultsNew *r)
{
	uint32_t cntr_address_version_maps_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_owners));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->address_version_maps));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->my_max_version_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->refresh_interval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tombstone_interval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tombstone_timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->verify_interval));
		NDR_CHECK(ndr_push_winsif_PriorityClass(ndr, NDR_SCALARS, r->prioritiy_class));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_worker_threads));
		NDR_CHECK(ndr_push_winsif_Stat(ndr, NDR_SCALARS, &r->wstat));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->address_version_maps) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_owners));
			for (cntr_address_version_maps_1 = 0; cntr_address_version_maps_1 < (r->num_owners); cntr_address_version_maps_1++) {
				NDR_CHECK(ndr_push_winsif_AddressVersionMap(ndr, NDR_SCALARS, &r->address_version_maps[cntr_address_version_maps_1]));
			}
		}
		NDR_CHECK(ndr_push_winsif_Stat(ndr, NDR_BUFFERS, &r->wstat));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_ResultsNew(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_ResultsNew *r)
{
	uint32_t _ptr_address_version_maps;
	uint32_t size_address_version_maps_1 = 0;
	uint32_t cntr_address_version_maps_1;
	TALLOC_CTX *_mem_save_address_version_maps_0 = NULL;
	TALLOC_CTX *_mem_save_address_version_maps_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_owners));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_address_version_maps));
		if (_ptr_address_version_maps) {
			NDR_PULL_ALLOC(ndr, r->address_version_maps);
		} else {
			r->address_version_maps = NULL;
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->my_max_version_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->refresh_interval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tombstone_interval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tombstone_timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->verify_interval));
		NDR_CHECK(ndr_pull_winsif_PriorityClass(ndr, NDR_SCALARS, &r->prioritiy_class));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_worker_threads));
		NDR_CHECK(ndr_pull_winsif_Stat(ndr, NDR_SCALARS, &r->wstat));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->address_version_maps) {
			_mem_save_address_version_maps_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->address_version_maps, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->address_version_maps));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->address_version_maps, &size_address_version_maps_1));
			NDR_PULL_ALLOC_N(ndr, r->address_version_maps, size_address_version_maps_1);
			_mem_save_address_version_maps_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->address_version_maps, 0);
			for (cntr_address_version_maps_1 = 0; cntr_address_version_maps_1 < (size_address_version_maps_1); cntr_address_version_maps_1++) {
				NDR_CHECK(ndr_pull_winsif_AddressVersionMap(ndr, NDR_SCALARS, &r->address_version_maps[cntr_address_version_maps_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_address_version_maps_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_address_version_maps_0, 0);
		}
		NDR_CHECK(ndr_pull_winsif_Stat(ndr, NDR_BUFFERS, &r->wstat));
		if (r->address_version_maps) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->address_version_maps, r->num_owners));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_ResultsNew(struct ndr_print *ndr, const char *name, const struct winsif_ResultsNew *r)
{
	uint32_t cntr_address_version_maps_1;
	ndr_print_struct(ndr, name, "winsif_ResultsNew");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_owners", r->num_owners);
	ndr_print_ptr(ndr, "address_version_maps", r->address_version_maps);
	ndr->depth++;
	if (r->address_version_maps) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "address_version_maps", (uint32_t)(r->num_owners));
		ndr->depth++;
		for (cntr_address_version_maps_1 = 0; cntr_address_version_maps_1 < (r->num_owners); cntr_address_version_maps_1++) {
			ndr_print_winsif_AddressVersionMap(ndr, "address_version_maps", &r->address_version_maps[cntr_address_version_maps_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_hyper(ndr, "my_max_version_number", r->my_max_version_number);
	ndr_print_uint32(ndr, "refresh_interval", r->refresh_interval);
	ndr_print_uint32(ndr, "tombstone_interval", r->tombstone_interval);
	ndr_print_uint32(ndr, "tombstone_timeout", r->tombstone_timeout);
	ndr_print_uint32(ndr, "verify_interval", r->verify_interval);
	ndr_print_winsif_PriorityClass(ndr, "prioritiy_class", r->prioritiy_class);
	ndr_print_uint32(ndr, "num_worker_threads", r->num_worker_threads);
	ndr_print_winsif_Stat(ndr, "wstat", &r->wstat);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_ScavengingOpcode(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winsif_ScavengingOpcode r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_ScavengingOpcode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winsif_ScavengingOpcode *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_ScavengingOpcode(struct ndr_print *ndr, const char *name, enum winsif_ScavengingOpcode r)
{
	const char *val = NULL;

	switch (r) {
		case WINSIF_SCAVENGING_GENERAL: val = "WINSIF_SCAVENGING_GENERAL"; break;
		case WINSIF_SCAVENGING_VERIFY: val = "WINSIF_SCAVENGING_VERIFY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winsif_ScavengingRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winsif_ScavengingRequest *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_winsif_ScavengingOpcode(ndr, NDR_SCALARS, r->opcode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->force));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_ScavengingRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winsif_ScavengingRequest *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_winsif_ScavengingOpcode(ndr, NDR_SCALARS, &r->opcode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->force));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_ScavengingRequest(struct ndr_print *ndr, const char *name, const struct winsif_ScavengingRequest *r)
{
	ndr_print_struct(ndr, name, "winsif_ScavengingRequest");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_winsif_ScavengingOpcode(ndr, "opcode", r->opcode);
	ndr_print_uint32(ndr, "age", r->age);
	ndr_print_uint32(ndr, "force", r->force);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsRecordAction(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsRecordAction *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.record_action == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.record_action));
		if (*r->in.record_action) {
			NDR_CHECK(ndr_push_winsif_RecordAction(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.record_action));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.record_action == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.record_action));
		if (*r->out.record_action) {
			NDR_CHECK(ndr_push_winsif_RecordAction(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.record_action));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsRecordAction(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsRecordAction *r)
{
	uint32_t _ptr_record_action;
	TALLOC_CTX *_mem_save_record_action_0 = NULL;
	TALLOC_CTX *_mem_save_record_action_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.record_action);
		}
		_mem_save_record_action_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.record_action, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_record_action));
		if (_ptr_record_action) {
			NDR_PULL_ALLOC(ndr, *r->in.record_action);
		} else {
			*r->in.record_action = NULL;
		}
		if (*r->in.record_action) {
			_mem_save_record_action_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->in.record_action, 0);
			NDR_CHECK(ndr_pull_winsif_RecordAction(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.record_action));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_action_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_action_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.record_action);
		*r->out.record_action = *r->in.record_action;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.record_action == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.record_action);
			NDR_ZERO_STRUCTP(r->in.record_action);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.record_action);
		}
		_mem_save_record_action_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.record_action, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_record_action));
		if (_ptr_record_action) {
			NDR_PULL_ALLOC(ndr, *r->out.record_action);
		} else {
			*r->out.record_action = NULL;
		}
		if (*r->out.record_action) {
			_mem_save_record_action_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.record_action, 0);
			NDR_CHECK(ndr_pull_winsif_RecordAction(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.record_action));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_action_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_action_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsRecordAction(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsRecordAction *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsRecordAction");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsRecordAction");
		ndr->depth++;
		ndr_print_ptr(ndr, "record_action", r->in.record_action);
		ndr->depth++;
		ndr_print_ptr(ndr, "record_action", *r->in.record_action);
		ndr->depth++;
		if (*r->in.record_action) {
			ndr_print_winsif_RecordAction(ndr, "record_action", *r->in.record_action);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsRecordAction");
		ndr->depth++;
		ndr_print_ptr(ndr, "record_action", r->out.record_action);
		ndr->depth++;
		ndr_print_ptr(ndr, "record_action", *r->out.record_action);
		ndr->depth++;
		if (*r->out.record_action) {
			ndr_print_winsif_RecordAction(ndr, "record_action", *r->out.record_action);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsStatus(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsStatus *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.results == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_StatusCmd(ndr, NDR_SCALARS, r->in.cmd));
		NDR_CHECK(ndr_push_winsif_Results(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.results));
	}
	if (flags & NDR_OUT) {
		if (r->out.results == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Results(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.results));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsStatus(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsStatus *r)
{
	TALLOC_CTX *_mem_save_results_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_winsif_StatusCmd(ndr, NDR_SCALARS, &r->in.cmd));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.results);
		}
		_mem_save_results_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.results, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Results(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.results));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_results_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.results);
		*r->out.results = *r->in.results;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.results == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.results);
			NDR_ZERO_STRUCTP(r->in.results);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.results);
		}
		_mem_save_results_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.results, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Results(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.results));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_results_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsStatus(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsStatus *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsStatus");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsStatus");
		ndr->depth++;
		ndr_print_winsif_StatusCmd(ndr, "cmd", r->in.cmd);
		ndr_print_ptr(ndr, "results", r->in.results);
		ndr->depth++;
		ndr_print_winsif_Results(ndr, "results", r->in.results);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsStatus");
		ndr->depth++;
		ndr_print_ptr(ndr, "results", r->out.results);
		ndr->depth++;
		ndr_print_winsif_Results(ndr, "results", r->out.results);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsTrigger(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsTrigger *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.owner_address == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		NDR_CHECK(ndr_push_winsif_TriggerType(ndr, NDR_SCALARS, r->in.trigger_type));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsTrigger(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsTrigger *r)
{
	TALLOC_CTX *_mem_save_owner_address_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
		}
		_mem_save_owner_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.owner_address, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_owner_address_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_TriggerType(ndr, NDR_SCALARS, &r->in.trigger_type));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.owner_address == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
			NDR_ZERO_STRUCTP(r->in.owner_address);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsTrigger(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsTrigger *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsTrigger");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsTrigger");
		ndr->depth++;
		ndr_print_ptr(ndr, "owner_address", r->in.owner_address);
		ndr->depth++;
		ndr_print_winsif_Address(ndr, "owner_address", r->in.owner_address);
		ndr->depth--;
		ndr_print_winsif_TriggerType(ndr, "trigger_type", r->in.trigger_type);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsTrigger");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsDoStaticInit(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsDoStaticInit *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.data_file_path));
		if (r->in.data_file_path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.data_file_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.data_file_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.data_file_path, ndr_charset_length(r->in.data_file_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.delete_file));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsDoStaticInit(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsDoStaticInit *r)
{
	uint32_t _ptr_data_file_path;
	uint32_t size_data_file_path_1 = 0;
	uint32_t length_data_file_path_1 = 0;
	TALLOC_CTX *_mem_save_data_file_path_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file_path));
		if (_ptr_data_file_path) {
			NDR_PULL_ALLOC(ndr, r->in.data_file_path);
		} else {
			r->in.data_file_path = NULL;
		}
		if (r->in.data_file_path) {
			_mem_save_data_file_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.data_file_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data_file_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.data_file_path));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.data_file_path, &size_data_file_path_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.data_file_path, &length_data_file_path_1));
			if (length_data_file_path_1 > size_data_file_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_data_file_path_1, length_data_file_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_data_file_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.data_file_path, length_data_file_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_path_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.delete_file));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsDoStaticInit(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsDoStaticInit *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsDoStaticInit");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsDoStaticInit");
		ndr->depth++;
		ndr_print_ptr(ndr, "data_file_path", r->in.data_file_path);
		ndr->depth++;
		if (r->in.data_file_path) {
			ndr_print_string(ndr, "data_file_path", r->in.data_file_path);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "delete_file", r->in.delete_file);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsDoStaticInit");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsDoScavenging(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsDoScavenging *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsDoScavenging(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsDoScavenging *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsDoScavenging(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsDoScavenging *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsDoScavenging");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsDoScavenging");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsDoScavenging");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsGetDbRecs(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsGetDbRecs *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.owner_address));
		if (r->in.owner_address) {
			NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.min_version_number));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.max_version_number));
	}
	if (flags & NDR_OUT) {
		if (r->out.records == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Records(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.records));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsGetDbRecs(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsGetDbRecs *r)
{
	uint32_t _ptr_owner_address;
	TALLOC_CTX *_mem_save_owner_address_0 = NULL;
	TALLOC_CTX *_mem_save_records_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_owner_address));
		if (_ptr_owner_address) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
		} else {
			r->in.owner_address = NULL;
		}
		if (r->in.owner_address) {
			_mem_save_owner_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.owner_address, 0);
			NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_owner_address_0, 0);
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.min_version_number));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.max_version_number));
		NDR_PULL_ALLOC(ndr, r->out.records);
		NDR_ZERO_STRUCTP(r->out.records);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.records);
		}
		_mem_save_records_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.records, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Records(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.records));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_records_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsGetDbRecs(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsGetDbRecs *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsGetDbRecs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsGetDbRecs");
		ndr->depth++;
		ndr_print_ptr(ndr, "owner_address", r->in.owner_address);
		ndr->depth++;
		if (r->in.owner_address) {
			ndr_print_winsif_Address(ndr, "owner_address", r->in.owner_address);
		}
		ndr->depth--;
		ndr_print_hyper(ndr, "min_version_number", r->in.min_version_number);
		ndr_print_hyper(ndr, "max_version_number", r->in.max_version_number);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsGetDbRecs");
		ndr->depth++;
		ndr_print_ptr(ndr, "records", r->out.records);
		ndr->depth++;
		ndr_print_winsif_Records(ndr, "records", r->out.records);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsTerm(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsTerm *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.abrupt_termination));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsTerm(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsTerm *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.abrupt_termination));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsTerm(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsTerm *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsTerm");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsTerm");
		ndr->depth++;
		ndr_print_uint16(ndr, "abrupt_termination", r->in.abrupt_termination);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsTerm");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsBackup(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsBackup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.backup_path == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.backup_path, CH_DOS)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.backup_path, CH_DOS)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.backup_path, ndr_charset_length(r->in.backup_path, CH_DOS), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.incremental));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsBackup(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsBackup *r)
{
	uint32_t size_backup_path_1 = 0;
	uint32_t length_backup_path_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.backup_path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.backup_path));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.backup_path, &size_backup_path_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.backup_path, &length_backup_path_1));
		if (length_backup_path_1 > size_backup_path_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_backup_path_1, length_backup_path_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_backup_path_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.backup_path, length_backup_path_1, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.incremental));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsBackup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsBackup *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsBackup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsBackup");
		ndr->depth++;
		ndr_print_ptr(ndr, "backup_path", r->in.backup_path);
		ndr->depth++;
		ndr_print_string(ndr, "backup_path", r->in.backup_path);
		ndr->depth--;
		ndr_print_uint16(ndr, "incremental", r->in.incremental);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsBackup");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsDelDbRecs(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsDelDbRecs *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.owner_address == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.min_version_number));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.max_version_number));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsDelDbRecs(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsDelDbRecs *r)
{
	TALLOC_CTX *_mem_save_owner_address_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
		}
		_mem_save_owner_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.owner_address, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_owner_address_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.min_version_number));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.max_version_number));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.owner_address == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
			NDR_ZERO_STRUCTP(r->in.owner_address);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsDelDbRecs(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsDelDbRecs *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsDelDbRecs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsDelDbRecs");
		ndr->depth++;
		ndr_print_ptr(ndr, "owner_address", r->in.owner_address);
		ndr->depth++;
		ndr_print_winsif_Address(ndr, "owner_address", r->in.owner_address);
		ndr->depth--;
		ndr_print_hyper(ndr, "min_version_number", r->in.min_version_number);
		ndr_print_hyper(ndr, "max_version_number", r->in.max_version_number);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsDelDbRecs");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsPullRange(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsPullRange *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.server_address == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.owner_address == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->in.server_address));
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.min_version_number));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.max_version_number));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsPullRange(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsPullRange *r)
{
	TALLOC_CTX *_mem_save_server_address_0 = NULL;
	TALLOC_CTX *_mem_save_owner_address_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.server_address);
		}
		_mem_save_server_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.server_address, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->in.server_address));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_address_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
		}
		_mem_save_owner_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.owner_address, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_owner_address_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.min_version_number));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.max_version_number));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.server_address == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.server_address);
			NDR_ZERO_STRUCTP(r->in.server_address);
		}
		if (r->in.owner_address == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
			NDR_ZERO_STRUCTP(r->in.owner_address);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsPullRange(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsPullRange *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsPullRange");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsPullRange");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_address", r->in.server_address);
		ndr->depth++;
		ndr_print_winsif_Address(ndr, "server_address", r->in.server_address);
		ndr->depth--;
		ndr_print_ptr(ndr, "owner_address", r->in.owner_address);
		ndr->depth++;
		ndr_print_winsif_Address(ndr, "owner_address", r->in.owner_address);
		ndr->depth--;
		ndr_print_hyper(ndr, "min_version_number", r->in.min_version_number);
		ndr_print_hyper(ndr, "max_version_number", r->in.max_version_number);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsPullRange");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsSetPriorityClass(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsSetPriorityClass *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_winsif_PriorityClass(ndr, NDR_SCALARS, r->in.prioritiy_class));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsSetPriorityClass(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsSetPriorityClass *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_winsif_PriorityClass(ndr, NDR_SCALARS, &r->in.prioritiy_class));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsSetPriorityClass(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsSetPriorityClass *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsSetPriorityClass");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsSetPriorityClass");
		ndr->depth++;
		ndr_print_winsif_PriorityClass(ndr, "prioritiy_class", r->in.prioritiy_class);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsSetPriorityClass");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsResetCounters(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsResetCounters *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsResetCounters(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsResetCounters *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsResetCounters(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsResetCounters *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsResetCounters");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsResetCounters");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsResetCounters");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsWorkerThreadUpdate(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsWorkerThreadUpdate *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_of_threads));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsWorkerThreadUpdate(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsWorkerThreadUpdate *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_of_threads));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsWorkerThreadUpdate(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsWorkerThreadUpdate *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsWorkerThreadUpdate");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsWorkerThreadUpdate");
		ndr->depth++;
		ndr_print_uint32(ndr, "num_of_threads", r->in.num_of_threads);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsWorkerThreadUpdate");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsGetNameAndAdd(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsGetNameAndAdd *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.server_address == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.unc_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->out.server_address));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 80));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 80));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->out.unc_name, 80, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsGetNameAndAdd(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsGetNameAndAdd *r)
{
	uint32_t size_unc_name_1 = 0;
	uint32_t length_unc_name_1 = 0;
	TALLOC_CTX *_mem_save_server_address_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.server_address);
		NDR_ZERO_STRUCTP(r->out.server_address);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.server_address);
		}
		_mem_save_server_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.server_address, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->out.server_address));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_address_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.unc_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.unc_name));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.unc_name, &size_unc_name_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.unc_name, &length_unc_name_1));
		if (length_unc_name_1 > size_unc_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_unc_name_1, length_unc_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_unc_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->out.unc_name, length_unc_name_1, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.unc_name) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.unc_name, 80));
		}
		if (r->out.unc_name) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.unc_name, 80));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsGetNameAndAdd(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsGetNameAndAdd *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsGetNameAndAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsGetNameAndAdd");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsGetNameAndAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_address", r->out.server_address);
		ndr->depth++;
		ndr_print_winsif_Address(ndr, "server_address", r->out.server_address);
		ndr->depth--;
		ndr_print_ptr(ndr, "unc_name", r->out.unc_name);
		ndr->depth++;
		ndr_print_string(ndr, "unc_name", r->out.unc_name);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsGetBrowserNames_Old(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsGetBrowserNames_Old *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_BrowserNames(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsGetBrowserNames_Old(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsGetBrowserNames_Old *r)
{
	TALLOC_CTX *_mem_save_names_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.names);
		NDR_ZERO_STRUCTP(r->out.names);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_BrowserNames(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsGetBrowserNames_Old(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsGetBrowserNames_Old *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsGetBrowserNames_Old");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsGetBrowserNames_Old");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsGetBrowserNames_Old");
		ndr->depth++;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_winsif_BrowserNames(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsDeleteWins(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsDeleteWins *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.owner_address == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsDeleteWins(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsDeleteWins *r)
{
	TALLOC_CTX *_mem_save_owner_address_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
		}
		_mem_save_owner_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.owner_address, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_owner_address_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.owner_address == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
			NDR_ZERO_STRUCTP(r->in.owner_address);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsDeleteWins(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsDeleteWins *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsDeleteWins");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsDeleteWins");
		ndr->depth++;
		ndr_print_ptr(ndr, "owner_address", r->in.owner_address);
		ndr->depth++;
		ndr_print_winsif_Address(ndr, "owner_address", r->in.owner_address);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsDeleteWins");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsSetFlags(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsSetFlags *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsSetFlags(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsSetFlags *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsSetFlags(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsSetFlags *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsSetFlags");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsSetFlags");
		ndr->depth++;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsSetFlags");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsGetBrowserNames(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsGetBrowserNames *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.server_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_BindData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_BrowserNames(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsGetBrowserNames(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsGetBrowserNames *r)
{
	TALLOC_CTX *_mem_save_server_handle_0 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.server_handle);
		}
		_mem_save_server_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.server_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_BindData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.names);
		NDR_ZERO_STRUCTP(r->out.names);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.server_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.server_handle);
			NDR_ZERO_STRUCTP(r->in.server_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_BrowserNames(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsGetBrowserNames(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsGetBrowserNames *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsGetBrowserNames");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsGetBrowserNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_handle", r->in.server_handle);
		ndr->depth++;
		ndr_print_winsif_BindData(ndr, "server_handle", r->in.server_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsGetBrowserNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_winsif_BrowserNames(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsGetDbRecsByName(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsGetDbRecsByName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.owner_address));
		if (r->in.owner_address) {
			NDR_CHECK(ndr_push_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.search_backward));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.name));
		if (r->in.name) {
			NDR_CHECK(ndr_push_wrepl_nbt_name(ndr, NDR_SCALARS, r->in.name));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.name?16:0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_records_desired));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.only_statics));
	}
	if (flags & NDR_OUT) {
		if (r->out.records == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_Records(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.records));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsGetDbRecsByName(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsGetDbRecsByName *r)
{
	uint32_t _ptr_owner_address;
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_owner_address_0 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_records_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_owner_address));
		if (_ptr_owner_address) {
			NDR_PULL_ALLOC(ndr, r->in.owner_address);
		} else {
			r->in.owner_address = NULL;
		}
		if (r->in.owner_address) {
			_mem_save_owner_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.owner_address, 0);
			NDR_CHECK(ndr_pull_winsif_Address(ndr, NDR_SCALARS, r->in.owner_address));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_owner_address_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.search_backward));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		} else {
			r->in.name = NULL;
		}
		if (r->in.name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.name, 0);
			NDR_CHECK(ndr_pull_wrepl_nbt_name(ndr, NDR_SCALARS, &r->in.name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.name_len));
		if (r->in.name_len > 16) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.name_len), (uint32_t)(0), (uint32_t)(16));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_records_desired));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.only_statics));
		NDR_PULL_ALLOC(ndr, r->out.records);
		NDR_ZERO_STRUCTP(r->out.records);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.records);
		}
		_mem_save_records_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.records, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_Records(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.records));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_records_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsGetDbRecsByName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsGetDbRecsByName *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsGetDbRecsByName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsGetDbRecsByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "owner_address", r->in.owner_address);
		ndr->depth++;
		if (r->in.owner_address) {
			ndr_print_winsif_Address(ndr, "owner_address", r->in.owner_address);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "search_backward", r->in.search_backward);
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		if (r->in.name) {
			ndr_print_wrepl_nbt_name(ndr, "name", r->in.name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->in.name?16:0:r->in.name_len);
		ndr_print_uint32(ndr, "num_records_desired", r->in.num_records_desired);
		ndr_print_uint32(ndr, "only_statics", r->in.only_statics);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsGetDbRecsByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "records", r->out.records);
		ndr->depth++;
		ndr_print_winsif_Records(ndr, "records", r->out.records);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsStatusNew(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsStatusNew *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_winsif_StatusCmd(ndr, NDR_SCALARS, r->in.cmd));
	}
	if (flags & NDR_OUT) {
		if (r->out.results == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_ResultsNew(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.results));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsStatusNew(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsStatusNew *r)
{
	TALLOC_CTX *_mem_save_results_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_winsif_StatusCmd(ndr, NDR_SCALARS, &r->in.cmd));
		NDR_PULL_ALLOC(ndr, r->out.results);
		NDR_ZERO_STRUCTP(r->out.results);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.results);
		}
		_mem_save_results_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.results, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_ResultsNew(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.results));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_results_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsStatusNew(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsStatusNew *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsStatusNew");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsStatusNew");
		ndr->depth++;
		ndr_print_winsif_StatusCmd(ndr, "cmd", r->in.cmd);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsStatusNew");
		ndr->depth++;
		ndr_print_ptr(ndr, "results", r->out.results);
		ndr->depth++;
		ndr_print_winsif_ResultsNew(ndr, "results", r->out.results);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsStatusWHdl(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsStatusWHdl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.server_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.results == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_BindData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server_handle));
		NDR_CHECK(ndr_push_winsif_StatusCmd(ndr, NDR_SCALARS, r->in.cmd));
		NDR_CHECK(ndr_push_winsif_ResultsNew(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.results));
	}
	if (flags & NDR_OUT) {
		if (r->out.results == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_ResultsNew(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.results));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsStatusWHdl(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsStatusWHdl *r)
{
	TALLOC_CTX *_mem_save_server_handle_0 = NULL;
	TALLOC_CTX *_mem_save_results_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.server_handle);
		}
		_mem_save_server_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.server_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_BindData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_StatusCmd(ndr, NDR_SCALARS, &r->in.cmd));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.results);
		}
		_mem_save_results_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.results, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_ResultsNew(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.results));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_results_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.results);
		*r->out.results = *r->in.results;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.server_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.server_handle);
			NDR_ZERO_STRUCTP(r->in.server_handle);
		}
		if (r->in.results == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.results);
			NDR_ZERO_STRUCTP(r->in.results);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.results);
		}
		_mem_save_results_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.results, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_ResultsNew(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.results));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_results_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsStatusWHdl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsStatusWHdl *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsStatusWHdl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsStatusWHdl");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_handle", r->in.server_handle);
		ndr->depth++;
		ndr_print_winsif_BindData(ndr, "server_handle", r->in.server_handle);
		ndr->depth--;
		ndr_print_winsif_StatusCmd(ndr, "cmd", r->in.cmd);
		ndr_print_ptr(ndr, "results", r->in.results);
		ndr->depth++;
		ndr_print_winsif_ResultsNew(ndr, "results", r->in.results);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsStatusWHdl");
		ndr->depth++;
		ndr_print_ptr(ndr, "results", r->out.results);
		ndr->depth++;
		ndr_print_winsif_ResultsNew(ndr, "results", r->out.results);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winsif_WinsDoScanvengingNew(struct ndr_push *ndr, ndr_flags_type flags, const struct winsif_WinsDoScanvengingNew *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.request == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winsif_ScavengingRequest(ndr, NDR_SCALARS, r->in.request));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winsif_WinsDoScanvengingNew(struct ndr_pull *ndr, ndr_flags_type flags, struct winsif_WinsDoScanvengingNew *r)
{
	TALLOC_CTX *_mem_save_request_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.request);
		}
		_mem_save_request_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.request, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winsif_ScavengingRequest(ndr, NDR_SCALARS, r->in.request));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_request_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.request == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.request);
			NDR_ZERO_STRUCTP(r->in.request);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winsif_WinsDoScanvengingNew(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winsif_WinsDoScanvengingNew *r)
{
	ndr_print_struct(ndr, name, "winsif_WinsDoScanvengingNew");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winsif_WinsDoScanvengingNew");
		ndr->depth++;
		ndr_print_ptr(ndr, "request", r->in.request);
		ndr->depth++;
		ndr_print_winsif_ScavengingRequest(ndr, "request", r->in.request);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winsif_WinsDoScanvengingNew");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_winsif
static const struct ndr_interface_public_struct winsif_public_structs[] = {
	{ .name = NULL }
};

static const struct ndr_interface_call winsif_calls[] = {
	{
		"winsif_WinsRecordAction",
		sizeof(struct winsif_WinsRecordAction),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsRecordAction,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsRecordAction,
		(ndr_print_function_t) ndr_print_winsif_WinsRecordAction,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsStatus",
		sizeof(struct winsif_WinsStatus),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsStatus,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsStatus,
		(ndr_print_function_t) ndr_print_winsif_WinsStatus,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsTrigger",
		sizeof(struct winsif_WinsTrigger),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsTrigger,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsTrigger,
		(ndr_print_function_t) ndr_print_winsif_WinsTrigger,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsDoStaticInit",
		sizeof(struct winsif_WinsDoStaticInit),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsDoStaticInit,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsDoStaticInit,
		(ndr_print_function_t) ndr_print_winsif_WinsDoStaticInit,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsDoScavenging",
		sizeof(struct winsif_WinsDoScavenging),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsDoScavenging,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsDoScavenging,
		(ndr_print_function_t) ndr_print_winsif_WinsDoScavenging,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsGetDbRecs",
		sizeof(struct winsif_WinsGetDbRecs),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsGetDbRecs,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsGetDbRecs,
		(ndr_print_function_t) ndr_print_winsif_WinsGetDbRecs,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsTerm",
		sizeof(struct winsif_WinsTerm),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsTerm,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsTerm,
		(ndr_print_function_t) ndr_print_winsif_WinsTerm,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsBackup",
		sizeof(struct winsif_WinsBackup),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsBackup,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsBackup,
		(ndr_print_function_t) ndr_print_winsif_WinsBackup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsDelDbRecs",
		sizeof(struct winsif_WinsDelDbRecs),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsDelDbRecs,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsDelDbRecs,
		(ndr_print_function_t) ndr_print_winsif_WinsDelDbRecs,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsPullRange",
		sizeof(struct winsif_WinsPullRange),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsPullRange,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsPullRange,
		(ndr_print_function_t) ndr_print_winsif_WinsPullRange,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsSetPriorityClass",
		sizeof(struct winsif_WinsSetPriorityClass),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsSetPriorityClass,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsSetPriorityClass,
		(ndr_print_function_t) ndr_print_winsif_WinsSetPriorityClass,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsResetCounters",
		sizeof(struct winsif_WinsResetCounters),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsResetCounters,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsResetCounters,
		(ndr_print_function_t) ndr_print_winsif_WinsResetCounters,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsWorkerThreadUpdate",
		sizeof(struct winsif_WinsWorkerThreadUpdate),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsWorkerThreadUpdate,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsWorkerThreadUpdate,
		(ndr_print_function_t) ndr_print_winsif_WinsWorkerThreadUpdate,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsGetNameAndAdd",
		sizeof(struct winsif_WinsGetNameAndAdd),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsGetNameAndAdd,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsGetNameAndAdd,
		(ndr_print_function_t) ndr_print_winsif_WinsGetNameAndAdd,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsGetBrowserNames_Old",
		sizeof(struct winsif_WinsGetBrowserNames_Old),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsGetBrowserNames_Old,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsGetBrowserNames_Old,
		(ndr_print_function_t) ndr_print_winsif_WinsGetBrowserNames_Old,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsDeleteWins",
		sizeof(struct winsif_WinsDeleteWins),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsDeleteWins,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsDeleteWins,
		(ndr_print_function_t) ndr_print_winsif_WinsDeleteWins,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsSetFlags",
		sizeof(struct winsif_WinsSetFlags),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsSetFlags,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsSetFlags,
		(ndr_print_function_t) ndr_print_winsif_WinsSetFlags,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsGetBrowserNames",
		sizeof(struct winsif_WinsGetBrowserNames),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsGetBrowserNames,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsGetBrowserNames,
		(ndr_print_function_t) ndr_print_winsif_WinsGetBrowserNames,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsGetDbRecsByName",
		sizeof(struct winsif_WinsGetDbRecsByName),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsGetDbRecsByName,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsGetDbRecsByName,
		(ndr_print_function_t) ndr_print_winsif_WinsGetDbRecsByName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsStatusNew",
		sizeof(struct winsif_WinsStatusNew),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsStatusNew,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsStatusNew,
		(ndr_print_function_t) ndr_print_winsif_WinsStatusNew,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsStatusWHdl",
		sizeof(struct winsif_WinsStatusWHdl),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsStatusWHdl,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsStatusWHdl,
		(ndr_print_function_t) ndr_print_winsif_WinsStatusWHdl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winsif_WinsDoScanvengingNew",
		sizeof(struct winsif_WinsDoScanvengingNew),
		(ndr_push_flags_fn_t) ndr_push_winsif_WinsDoScanvengingNew,
		(ndr_pull_flags_fn_t) ndr_pull_winsif_WinsDoScanvengingNew,
		(ndr_print_function_t) ndr_print_winsif_WinsDoScanvengingNew,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const winsif_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\winsif]", 
};

static const struct ndr_interface_string_array winsif_endpoints = {
	.count	= 1,
	.names	= winsif_endpoint_strings
};

static const char * const winsif_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array winsif_authservices = {
	.count	= 1,
	.names	= winsif_authservice_strings
};


const struct ndr_interface_table ndr_table_winsif = {
	.name		= "winsif",
	.syntax_id	= {
		{0x45f52c28,0x7f9f,0x101a,{0xb5,0x2b},{0x08,0x00,0x2b,0x2e,0xfa,0xbe}},
		NDR_WINSIF_VERSION
	},
	.helpstring	= NDR_WINSIF_HELPSTRING,
	.num_calls	= 22,
	.calls		= winsif_calls,
	.num_public_structs	= 0,
	.public_structs		= winsif_public_structs,
	.endpoints	= &winsif_endpoints,
	.authservices	= &winsif_authservices
};

#endif /* SKIP_NDR_TABLE_winsif */
