/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/source4/librpc/gen_ndr/ndr_ntp_signd.h"

static enum ndr_err_code ndr_push_ntp_signd_op(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ntp_signd_op r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntp_signd_op(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ntp_signd_op *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntp_signd_op(struct ndr_print *ndr, const char *name, enum ntp_signd_op r)
{
	const char *val = NULL;

	switch (r) {
		case SIGN_TO_CLIENT: val = "SIGN_TO_CLIENT"; break;
		case ASK_SERVER_TO_SIGN: val = "ASK_SERVER_TO_SIGN"; break;
		case CHECK_SERVER_SIGNATURE: val = "CHECK_SERVER_SIGNATURE"; break;
		case SIGNING_SUCCESS: val = "SIGNING_SUCCESS"; break;
		case SIGNING_FAILURE: val = "SIGNING_FAILURE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_sign_request(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct sign_request *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, NTP_SIGND_PROTOCOL_VERSION_0));
			NDR_CHECK(ndr_push_ntp_signd_op(ndr, NDR_SCALARS, r->op));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->packet_id));
			{
				libndr_flags _flags_save_uint32 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->key_id));
				ndr->flags = _flags_save_uint32;
			}
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->packet_to_sign));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_sign_request(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct sign_request *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
			NDR_CHECK(ndr_pull_ntp_signd_op(ndr, NDR_SCALARS, &r->op));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->packet_id));
			{
				libndr_flags _flags_save_uint32 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->key_id));
				ndr->flags = _flags_save_uint32;
			}
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->packet_to_sign));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_sign_request(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct sign_request *r)
{
	ndr_print_sign_request(ndr, name, r);
}

_PUBLIC_ void ndr_print_sign_request(struct ndr_print *ndr, const char *name, const struct sign_request *r)
{
	ndr_print_struct(ndr, name, "sign_request");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr->depth++;
		ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NTP_SIGND_PROTOCOL_VERSION_0:r->version);
		ndr_print_ntp_signd_op(ndr, "op", r->op);
		ndr_print_uint16(ndr, "packet_id", r->packet_id);
		{
			libndr_flags _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
			ndr_print_uint32(ndr, "key_id", r->key_id);
			ndr->flags = _flags_save_uint32;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_DATA_BLOB(ndr, "packet_to_sign", r->packet_to_sign);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_signed_reply(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct signed_reply *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, NTP_SIGND_PROTOCOL_VERSION_0));
			NDR_CHECK(ndr_push_ntp_signd_op(ndr, NDR_SCALARS, r->op));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->packet_id));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->signed_packet));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_signed_reply(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct signed_reply *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
			NDR_CHECK(ndr_pull_ntp_signd_op(ndr, NDR_SCALARS, &r->op));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->packet_id));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->signed_packet));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_signed_reply(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct signed_reply *r)
{
	ndr_print_signed_reply(ndr, name, r);
}

_PUBLIC_ void ndr_print_signed_reply(struct ndr_print *ndr, const char *name, const struct signed_reply *r)
{
	ndr_print_struct(ndr, name, "signed_reply");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr->depth++;
		ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NTP_SIGND_PROTOCOL_VERSION_0:r->version);
		ndr_print_ntp_signd_op(ndr, "op", r->op);
		ndr_print_uint32(ndr, "packet_id", r->packet_id);
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_DATA_BLOB(ndr, "signed_packet", r->signed_packet);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_ntp_signd
static const struct ndr_interface_public_struct ntp_signd_public_structs[] = {
	{
		.name = "sign_request",
		.struct_size = sizeof(struct sign_request ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_sign_request,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_sign_request,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_sign_request,
	},
	{
		.name = "signed_reply",
		.struct_size = sizeof(struct signed_reply ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_signed_reply,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_signed_reply,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_signed_reply,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call ntp_signd_calls[] = {
	{ .name = NULL }
};

static const char * const ntp_signd_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ntp_signd]", 
};

static const struct ndr_interface_string_array ntp_signd_endpoints = {
	.count	= 1,
	.names	= ntp_signd_endpoint_strings
};

static const char * const ntp_signd_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array ntp_signd_authservices = {
	.count	= 1,
	.names	= ntp_signd_authservice_strings
};


const struct ndr_interface_table ndr_table_ntp_signd = {
	.name		= "ntp_signd",
	.syntax_id	= {
		{0x0da00951,0x5b6c,0x4488,{0x9a,0x89},{0x75,0x0c,0xac,0x70,0x92,0x0c}},
		NDR_NTP_SIGND_VERSION
	},
	.helpstring	= NDR_NTP_SIGND_HELPSTRING,
	.num_calls	= 0,
	.calls		= ntp_signd_calls,
	.num_public_structs	= 2,
	.public_structs		= ntp_signd_public_structs,
	.endpoints	= &ntp_signd_endpoints,
	.authservices	= &ntp_signd_authservices
};

#endif /* SKIP_NDR_TABLE_ntp_signd */
