#ifndef __SOURCE4_DSDB_SAMDB_LDB_MODULES_UTIL_PROTO_H__
#define __SOURCE4_DSDB_SAMDB_LDB_MODULES_UTIL_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/dsdb/samdb/ldb_modules/util.c  */

int dsdb_module_search_dn(struct ldb_module *module,
			  TALLOC_CTX *mem_ctx,
			  struct ldb_result **_res,
			  struct ldb_dn *basedn,
			  const char * const *attrs,
			  uint32_t dsdb_flags,
			  struct ldb_request *parent);
int dsdb_module_search_tree(struct ldb_module *module,
		       TALLOC_CTX *mem_ctx,
		       struct ldb_result **_res,
		       struct ldb_dn *basedn,
		       enum ldb_scope scope,
		       struct ldb_parse_tree *tree,
		       const char * const *attrs,
		       int dsdb_flags,
		       struct ldb_request *parent);
int dsdb_module_search(struct ldb_module *module,
		       TALLOC_CTX *mem_ctx,
		       struct ldb_result **_res,
		       struct ldb_dn *basedn, enum ldb_scope scope,
		       const char * const *attrs,
		       int dsdb_flags,
		       struct ldb_request *parent,
		       const char *format, ...) _PRINTF_ATTRIBUTE(9, 10);
int dsdb_module_obj_by_guid(struct ldb_module *module,
			    TALLOC_CTX *mem_ctx,
			    struct ldb_message **_msg,
			    const struct GUID *guid,
			    const char * const *attrs,
			    struct ldb_request *parent);
int dsdb_module_dn_by_guid(struct ldb_module *module, TALLOC_CTX *mem_ctx,
			   const struct GUID *guid, struct ldb_dn **dn,
			   struct ldb_request *parent);
int dsdb_module_guid_by_dn(struct ldb_module *module, struct ldb_dn *dn, struct GUID *guid,
			   struct ldb_request *parent);
int dsdb_module_extended(struct ldb_module *module,
			 TALLOC_CTX *mem_ctx,
			 struct ldb_result **_res,
			 const char* oid, void* data,
			 uint32_t dsdb_flags,
			 struct ldb_request *parent);
int dsdb_module_modify(struct ldb_module *module,
		       const struct ldb_message *message,
		       uint32_t dsdb_flags,
		       struct ldb_request *parent);
int dsdb_module_rename(struct ldb_module *module,
		       struct ldb_dn *olddn, struct ldb_dn *newdn,
		       uint32_t dsdb_flags,
		       struct ldb_request *parent);
int dsdb_module_add(struct ldb_module *module,
		    const struct ldb_message *message,
		    uint32_t dsdb_flags,
		    struct ldb_request *parent);
int dsdb_module_del(struct ldb_module *module,
		    struct ldb_dn *dn,
		    uint32_t dsdb_flags,
		    struct ldb_request *parent);
int dsdb_check_single_valued_link(const struct dsdb_attribute *attr,
				  const struct ldb_message_element *el);
int dsdb_check_samba_compatible_feature(struct ldb_module *module,
					const char *feature,
					bool *found);
int dsdb_check_optional_feature(struct ldb_module *module, struct GUID op_feature_guid, bool *feature_enabled);
int dsdb_module_find_ntdsguid_for_computer(struct ldb_module *module,
					   TALLOC_CTX *mem_ctx,
					   struct ldb_dn *computer_dn,
					   struct GUID *ntds_guid,
					   struct ldb_request *parent);
int dsdb_module_reference_dn(struct ldb_module *module, TALLOC_CTX *mem_ctx, struct ldb_dn *base,
			     const char *attribute, struct ldb_dn **dn, struct ldb_request *parent);
int dsdb_module_rid_manager_dn(struct ldb_module *module, TALLOC_CTX *mem_ctx, struct ldb_dn **dn,
			       struct ldb_request *parent);
int dsdb_next_callback(struct ldb_request *req, struct ldb_reply *ares);
int dsdb_module_load_partition_usn(struct ldb_module *module, struct ldb_dn *dn,
				   uint64_t *uSN, uint64_t *urgent_uSN, struct ldb_request *parent);
int dsdb_module_save_partition_usn(struct ldb_module *module, struct ldb_dn *dn,
				   uint64_t uSN, uint64_t urgent_uSN,
				   struct ldb_request *parent);
bool dsdb_module_am_system(struct ldb_module *module);
bool dsdb_module_am_administrator(struct ldb_module *module);
int dsdb_recyclebin_enabled(struct ldb_module *module, bool *enabled);
int dsdb_msg_constrainted_update_int32(struct ldb_module *module,
				       struct ldb_message *msg,
				       const char *attr,
				       const int32_t *old_val,
				       const int32_t *new_val);
int dsdb_msg_constrainted_update_uint32(struct ldb_module *module,
					struct ldb_message *msg,
					const char *attr,
					const uint32_t *old_val,
					const uint32_t *new_val);
int dsdb_msg_constrainted_update_int64(struct ldb_module *module,
				       struct ldb_message *msg,
				       const char *attr,
				       const int64_t *old_val,
				       const int64_t *new_val);
int dsdb_msg_constrainted_update_uint64(struct ldb_module *module,
					struct ldb_message *msg,
					const char *attr,
					const uint64_t *old_val,
					const uint64_t *new_val);
int dsdb_module_constrainted_update_int32(struct ldb_module *module,
					  struct ldb_dn *dn,
					  const char *attr,
					  const int32_t *old_val,
					  const int32_t *new_val,
					  struct ldb_request *parent);
int dsdb_module_constrainted_update_uint32(struct ldb_module *module,
					   struct ldb_dn *dn,
					   const char *attr,
					   const uint32_t *old_val,
					   const uint32_t *new_val,
					   struct ldb_request *parent);
int dsdb_module_constrainted_update_int64(struct ldb_module *module,
					  struct ldb_dn *dn,
					  const char *attr,
					  const int64_t *old_val,
					  const int64_t *new_val,
					  struct ldb_request *parent);
int dsdb_module_constrainted_update_uint64(struct ldb_module *module,
					   struct ldb_dn *dn,
					   const char *attr,
					   const uint64_t *old_val,
					   const uint64_t *new_val,
					   struct ldb_request *parent);
const struct ldb_val *dsdb_module_find_dsheuristics(struct ldb_module *module,
						    TALLOC_CTX *mem_ctx, struct ldb_request *parent);
bool dsdb_block_anonymous_ops(struct ldb_module *module, struct ldb_request *parent);
bool dsdb_user_password_support(struct ldb_module *module,
				TALLOC_CTX *mem_ctx,
				struct ldb_request *parent);
bool dsdb_do_list_object(struct ldb_module *module,
			 TALLOC_CTX *mem_ctx,
			 struct ldb_request *parent);
bool dsdb_attribute_authz_on_ldap_add(struct ldb_module *module,
				      TALLOC_CTX *mem_ctx,
				      struct ldb_request *parent);
bool dsdb_block_owner_implicit_rights(struct ldb_module *module,
				      TALLOC_CTX *mem_ctx,
				      struct ldb_request *parent);
void dsdb_req_chain_debug(struct ldb_request *req, int level);
int dsdb_get_expected_new_values(TALLOC_CTX *mem_ctx,
				 const struct ldb_message *msg,
				 const char *attr_name,
				 struct ldb_message_element **el,
				 enum ldb_request_type operation);
int dsdb_msg_add_get_single_value(const struct ldb_message *msg,
                                  const char *attr_name,
                                  const struct ldb_val **val);
int dsdb_msg_get_single_value(const struct ldb_message *msg,
			      const char *attr_name,
			      const struct ldb_val *original_val,
			      const struct ldb_val **val,
			      enum ldb_request_type operation);
const struct dsdb_class *dsdb_get_last_structural_class(const struct dsdb_schema *schema,
							const struct ldb_message_element *element);
const struct dsdb_class *dsdb_get_structural_oc_from_msg(const struct dsdb_schema *schema,
							 const struct ldb_message *msg);
const struct dsdb_class *dsdb_get_parent_class(const struct dsdb_schema *schema,
					       const struct dsdb_class *objectclass);
bool dsdb_is_subclass_of(const struct dsdb_schema *schema,
			 const struct dsdb_class *struct_objectclass,
			 const struct dsdb_class *other_objectclass);
int dsdb_fix_dn_rdncase(struct ldb_context *ldb, struct ldb_dn *dn);

/**
 * Make most specific objectCategory for the objectClass of passed object
 * NOTE: In this implementation we count that it is called on already
 * verified objectClass attribute value. See objectclass.c thorough
 * implementation for all the magic that involves
 *
 * @param ldb	ldb context
 * @param schema cached schema for ldb. We may get it, but it is very time consuming.
 * 			Hence leave the responsibility to the caller.
 * @param obj	AD object to determine objectCategory for
 * @param mem_ctx Memory context - usually it is obj actually
 * @param pobjectcategory location to store found objectCategory
 *
 * @return LDB_SUCCESS or error including out of memory error
 */
int dsdb_make_object_category(struct ldb_context *ldb, const struct dsdb_schema *schema,
			      const struct ldb_message *obj,
			      TALLOC_CTX *mem_ctx, const char **pobjectcategory);

/* The following definitions come from ../../source4/dsdb/samdb/ldb_modules/acl_util.c  */

struct security_token *acl_user_token(struct ldb_module *module);
int dsdb_module_check_access_on_dn(struct ldb_module *module,
				   TALLOC_CTX *mem_ctx,
				   struct ldb_dn *dn,
				   uint32_t access_mask,
				   const struct GUID *guid,
				   struct ldb_request *parent);
int acl_check_access_on_attribute_implicit_owner(struct ldb_module *module,
						 TALLOC_CTX *mem_ctx,
						 const struct security_descriptor *sd,
						 const struct dom_sid *rp_sid,
						 uint32_t access_mask,
						 const struct dsdb_attribute *attr,
						 const struct dsdb_class *objectclass,
						 enum implicit_owner_rights implicit_owner_rights);
int acl_check_access_on_attribute(struct ldb_module *module,
				  TALLOC_CTX *mem_ctx,
				  struct security_descriptor *sd,
				  struct dom_sid *rp_sid,
				  uint32_t access_mask,
				  const struct dsdb_attribute *attr,
				  const struct dsdb_class *objectclass);
int acl_check_access_on_objectclass(struct ldb_module *module,
				    TALLOC_CTX *mem_ctx,
				    struct security_descriptor *sd,
				    struct dom_sid *rp_sid,
				    uint32_t access_mask,
				    const struct dsdb_class *objectclass);
int acl_check_extended_right(TALLOC_CTX *mem_ctx,
			     struct ldb_module *module,
			     struct ldb_request *req,
			     const struct dsdb_class *objectclass,
			     struct security_descriptor *sd,
			     struct security_token *token,
			     const char *ext_right,
			     uint32_t right_type,
			     struct dom_sid *sid);
const char *acl_user_name(TALLOC_CTX *mem_ctx, struct ldb_module *module);
uint32_t dsdb_request_sd_flags(struct ldb_request *req, bool *explicit);
int dsdb_module_schedule_sd_propagation(struct ldb_module *module,
					struct ldb_dn *nc_root,
					struct GUID guid,
					struct GUID parent_guid,
					bool include_self);

/* The following definitions come from ../../source4/dsdb/samdb/ldb_modules/schema_util.c  */


/**
 * Reads schema_info structure from schemaInfo
 * attribute on SCHEMA partition
 *
 * @param dsdb_flags 	DSDB_FLAG_... flag of 0
 */
int dsdb_module_schema_info_blob_read(struct ldb_module *ldb_module,
				      uint32_t dsdb_flags,
				      TALLOC_CTX *mem_ctx,
				      struct ldb_val *schema_info_blob,
				      struct ldb_request *parent);

/**
 * Writes schema_info structure into schemaInfo
 * attribute on SCHEMA partition
 *
 * @param dsdb_flags 	DSDB_FLAG_... flag of 0
 */
int dsdb_module_schema_info_blob_write(struct ldb_module *ldb_module,
				       uint32_t dsdb_flags,
				       struct ldb_val *schema_info_blob,
				       struct ldb_request *parent);

/**
 * Increments schemaInfo revision and save it to DB
 * setting our invocationID in the process
 * NOTE: this function should be called in a transaction
 * much in the same way prefixMap update function is called
 *
 * @param ldb_module 	current module
 * @param schema 	schema cache
 * @param dsdb_flags 	DSDB_FLAG_... flag of 0
 */
int dsdb_module_schema_info_update(struct ldb_module *ldb_module,
				   struct dsdb_schema *schema,
				   int dsdb_flags, struct ldb_request *parent);

/* The following definitions come from ../../source4/dsdb/samdb/ldb_modules/netlogon.c  */

NTSTATUS fill_netlogon_samlogon_response(struct ldb_context *sam_ctx,
					 TALLOC_CTX *mem_ctx,
					 const char *domain,
					 const char *netbios_domain,
					 struct dom_sid *domain_sid,
					 const char *domain_guid,
					 const char *user,
					 uint32_t acct_control,
					 const char *src_address,
					 uint32_t version,
					 struct loadparm_context *lp_ctx,
					 struct netlogon_samlogon_response *netlogon,
					 bool fill_on_blank_request);
NTSTATUS parse_netlogon_request(struct ldb_parse_tree *tree,
				struct loadparm_context *lp_ctx,
				TALLOC_CTX *tmp_ctx,
				const char **domain,
				const char **host,
				const char **user,
				const char **domain_guid,
				struct dom_sid **domain_sid,
				int *acct_control,
				int *version);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_DSDB_SAMDB_LDB_MODULES_UTIL_PROTO_H__ */

