#ifndef __SOURCE4_AUTH_KERBEROS_KERBEROS_SRV_KEYTAB_H__
#define __SOURCE4_AUTH_KERBEROS_KERBEROS_SRV_KEYTAB_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/auth/kerberos/srv_keytab.c  */


/**
 * @brief Update a Kerberos keytab and removes any obsolete keytab entries.
 *
 * If the keytab does not exist, this function will create one.
 *
 * @param[in] parent_ctx	Talloc memory context
 * @param[in] context		Kerberos context
 * @param[in] keytab_name	Keytab to open
 * @param[in] samAccountName	User account to update
 * @param[in] realm		Kerberos realm
 * @param[in] SPNs		Service principal names to update
 * @param[in] num_SPNs		Length of SPNs
 * @param[in] saltPrincipal	Salt used for AES encryption.
 * 				Required, unless delete_all_kvno is set.
 * @param[in] old_secret	Old password
 * @param[in] new_secret	New password
 * @param[in] kvno		Current key version number
 * @param[in] supp_enctypes	msDS-SupportedEncryptionTypes bit-field
 * @param[in] delete_all_kvno	Removes all obsolete entries, without
 * 				recreating the keytab.
 * @param[out] _keytab		If supplied, returns the keytab
 * @param[out] perror_string	Error string on failure
 *
 * @return			0 on success, errno on failure
 */
krb5_error_code smb_krb5_update_keytab(TALLOC_CTX *parent_ctx,
				krb5_context context,
				const char *keytab_name,
				const char *samAccountName,
				const char *realm,
				const char **SPNs,
				int num_SPNs,
				const char *saltPrincipal,
				const char *new_secret,
				const char *old_secret,
				int kvno,
				uint32_t supp_enctypes,
				bool delete_all_kvno,
			        krb5_keytab *_keytab,
				const char **perror_string);

/**
 * @brief Wrapper around smb_krb5_update_keytab() for creating an in-memory keytab
 *
 * @param[in] parent_ctx	Talloc memory context
 * @param[in] context		Kerberos context
 * @param[in] new_secret	New password
 * @param[in] samAccountName	User account to update
 * @param[in] realm		Kerberos realm
 * @param[in] salt_principal	Salt used for AES encryption.
 * 				Required, unless delete_all_kvno is set.
 * @param[in] kvno		Current key version number
 * @param[out] keytab		If supplied, returns the keytab
 * @param[out] keytab_name	Returns the created keytab name
 *
 * @return			0 on success, errno on failure
 */
krb5_error_code smb_krb5_create_memory_keytab(TALLOC_CTX *parent_ctx,
				krb5_context context,
				const char *new_secret,
				const char *samAccountName,
				const char *realm,
				const char *salt_principal,
				int kvno,
				krb5_keytab *keytab,
				const char **keytab_name);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_AUTH_KERBEROS_KERBEROS_SRV_KEYTAB_H__ */

