/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_rpcd_witness
#define _PIDL_HEADER_rpcd_witness

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/server_id.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/witness.h"
#ifndef _HEADER_rpcd_witness
#define _HEADER_rpcd_witness

struct rpcd_witness_registration {
	enum witness_version version;
	const char *net_name;/* [charset(UTF8)] */
	const char *share_name;/* [charset(UTF8),unique] */
	const char *ip_address;/* [charset(UTF8)] */
	const char *client_computer_name;/* [charset(UTF8)] */
	uint32_t flags;
	uint32_t timeout;
	struct policy_handle context_handle;
	struct server_id server_id;
	const char *account_name;/* [charset(UTF8)] */
	const char *domain_name;/* [charset(UTF8)] */
	struct dom_sid account_sid;
	const char *local_address;/* [charset(UTF8)] */
	const char *remote_address;/* [charset(UTF8)] */
	NTTIME registration_time;
}/* [public] */;

enum rpcd_witness_registration_update_type
#ifndef USE_UINT_ENUMS
 {
	RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE=(int)(0x0001),
	RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4=(int)(0x0002),
	RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6=(int)(0x0003),
	RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE=(int)(0x0004),
	RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4=(int)(0x0005),
	RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6=(int)(0x0006),
	RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER=(int)(0x0007),
	RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE=(int)(0x0008)
}
#else
 { __do_not_use_enum_rpcd_witness_registration_update_type=INT_MAX}
#define RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE ( 0x0001 )
#define RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4 ( 0x0002 )
#define RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6 ( 0x0003 )
#define RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE ( 0x0004 )
#define RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4 ( 0x0005 )
#define RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6 ( 0x0006 )
#define RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER ( 0x0007 )
#define RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE ( 0x0008 )
#endif
;

struct rpcd_witness_registration_update_move_to_node {
	uint32_t new_node;
};

struct rpcd_witness_registration_update_move_to_ipv4 {
	const char * new_ipv4;/* [flag(LIBNDR_FLAG_BIGENDIAN)] */
};

struct rpcd_witness_registration_update_move_to_ipv6 {
	const char * new_ipv6;/* [flag(LIBNDR_FLAG_BIGENDIAN)] */
};

struct rpcd_witness_registration_update_force_response {
	struct witness_notifyResponse *response;/* [unique] */
	WERROR result;
};

union rpcd_witness_registration_updateU {
	struct rpcd_witness_registration_update_move_to_node client_move_to_node;/* [case(RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE)] */
	struct rpcd_witness_registration_update_move_to_ipv4 client_move_to_ipv4;/* [case(RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4)] */
	struct rpcd_witness_registration_update_move_to_ipv6 client_move_to_ipv6;/* [case(RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6)] */
	struct rpcd_witness_registration_update_move_to_node share_move_to_node;/* [case(RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE)] */
	struct rpcd_witness_registration_update_move_to_ipv4 share_move_to_ipv4;/* [case(RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4)] */
	struct rpcd_witness_registration_update_move_to_ipv6 share_move_to_ipv6;/* [case(RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6)] */
	struct rpcd_witness_registration_update_force_response force_response;/* [case(RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE)] */
}/* [switch_type(rpcd_witness_registration_update_type)] */;

struct rpcd_witness_registration_updateB {
	struct policy_handle context_handle;
	enum rpcd_witness_registration_update_type type;
	union rpcd_witness_registration_updateU update;/* [switch_is(type)] */
}/* [public] */;


struct rpcd_witness_registration_decode {
	struct {
		struct rpcd_witness_registration reg;
	} in;

};


struct rpcd_witness_registration_update_decode {
	struct {
		struct rpcd_witness_registration_updateB update;
	} in;

};

#endif /* _HEADER_rpcd_witness */
#endif /* _PIDL_HEADER_rpcd_witness */
