/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_open_files
#define _PIDL_HEADER_open_files

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/server_id.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/file_id.h"
#include "librpc/gen_ndr/smb2_lease_struct.h"
#include "librpc/gen_ndr/misc.h"
#ifndef _HEADER_open_files
#define _HEADER_open_files

#define VFS_DEFAULT_DURABLE_COOKIE_MAGIC	( "VFS_DEFAULT_DURABLE_COOKIE_MAGIC                " )
#define VFS_DEFAULT_DURABLE_COOKIE_VERSION	( 0 )
enum share_mode_entry_op_type
#ifndef USE_UINT_ENUMS
 {
	SHARE_MODE_ENTRY_OP_TYPE_NONE=(int)(0),
	SHARE_MODE_ENTRY_OP_TYPE_EXCLUSIVE=(int)(1),
	SHARE_MODE_ENTRY_OP_TYPE_BATCH_WITHOUT_EXCLUSIVE=(int)(2),
	SHARE_MODE_ENTRY_OP_TYPE_BATCH=(int)(3),
	SHARE_MODE_ENTRY_OP_TYPE_LEVEL_II=(int)(4),
	SHARE_MODE_ENTRY_OP_TYPE_LEASE=(int)(0x100)
}
#else
 { __do_not_use_enum_share_mode_entry_op_type=INT_MAX}
#define SHARE_MODE_ENTRY_OP_TYPE_NONE ( 0 )
#define SHARE_MODE_ENTRY_OP_TYPE_EXCLUSIVE ( 1 )
#define SHARE_MODE_ENTRY_OP_TYPE_BATCH_WITHOUT_EXCLUSIVE ( 2 )
#define SHARE_MODE_ENTRY_OP_TYPE_BATCH ( 3 )
#define SHARE_MODE_ENTRY_OP_TYPE_LEVEL_II ( 4 )
#define SHARE_MODE_ENTRY_OP_TYPE_LEASE ( 0x100 )
#endif
;

struct share_mode_entry {
	struct server_id pid;
	uint64_t op_mid;
	enum share_mode_entry_op_type op_type;
	struct GUID client_guid;
	struct smb2_lease_key lease_key;
	uint32_t access_mask;
	uint32_t share_access;
	uint32_t private_options;
	struct timeval time;
	uint64_t share_file_id;
	uint32_t uid;
	uint16_t flags;
	uint32_t name_hash;
	uint8_t stale;/* [skip] */
}/* [public] */;

struct delete_token {
	uint32_t name_hash;
	struct security_token *delete_nt_token;/* [unique] */
	struct security_unix_token *delete_token;/* [unique] */
}/* [public] */;

/* bitmap share_mode_flags */
#define SHARE_MODE_SHARE_DELETE ( 0x100 )
#define SHARE_MODE_SHARE_WRITE ( 0x080 )
#define SHARE_MODE_SHARE_READ ( 0x040 )
#define SHARE_MODE_ACCESS_DELETE ( 0x020 )
#define SHARE_MODE_ACCESS_WRITE ( 0x010 )
#define SHARE_MODE_ACCESS_READ ( 0x008 )
#define SHARE_MODE_LEASE_HANDLE ( 0x004 )
#define SHARE_MODE_LEASE_WRITE ( 0x002 )
#define SHARE_MODE_LEASE_READ ( 0x001 )

struct share_mode_data {
	uint64_t unique_content_epoch;
	uint16_t flags;
	const char *servicepath;/* [charset(UTF8),unique] */
	const char *base_name;/* [charset(UTF8),unique] */
	const char *stream_name;/* [charset(UTF8),unique] */
	uint32_t num_delete_tokens;
	struct delete_token *delete_tokens;/* [size_is(num_delete_tokens)] */
	NTTIME old_write_time;
	NTTIME changed_write_time;
	uint8_t not_stored;/* [skip] */
	uint8_t modified;/* [skip] */
	struct file_id id;/* [ignore] */
}/* [public] */;

struct vfs_default_durable_stat {
	uint64_t st_ex_dev;
	uint64_t st_ex_ino;
	uint64_t st_ex_mode;
	uint64_t st_ex_nlink;
	uint64_t st_ex_uid;
	uint64_t st_ex_gid;
	uint64_t st_ex_rdev;
	uint64_t st_ex_size;
	struct timespec st_ex_atime;
	struct timespec st_ex_mtime;
	struct timespec st_ex_ctime;
	struct timespec st_ex_btime;
	uint64_t st_ex_blksize;
	uint64_t st_ex_blocks;
	uint32_t st_ex_flags;
	uint32_t st_ex_iflags;
};

struct vfs_default_durable_cookie {
	const char *magic;/* [charset(DOS),value(VFS_DEFAULT_DURABLE_COOKIE_MAGIC)] */
	uint32_t version;/* [value(VFS_DEFAULT_DURABLE_COOKIE_VERSION)] */
	uint8_t allow_reconnect;
	struct file_id id;
	const char *servicepath;/* [charset(UTF8),unique] */
	const char *base_name;/* [charset(UTF8),unique] */
	uint64_t initial_allocation_size;
	uint64_t position_information;
	uint8_t update_write_time_triggered;
	uint8_t update_write_time_on_close;
	uint8_t write_time_forced;
	NTTIME close_write_time;
	struct vfs_default_durable_stat stat_info;
}/* [public] */;

struct oplock_break_message {
	struct file_id id;
	uint64_t share_file_id;
	uint8_t break_to;
}/* [public] */;

struct file_rename_message {
	struct file_id id;
	uint64_t share_file_id;
	const char *servicepath;/* [charset(UTF8),unique] */
	const char *base_name;/* [charset(UTF8),unique] */
	const char *stream_name;/* [charset(UTF8),unique] */
}/* [public] */;

#endif /* _HEADER_open_files */
#endif /* _PIDL_HEADER_open_files */
