/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/source3/librpc/gen_ndr/ndr_rpc_host.h"

#include "librpc/gen_ndr/ndr_named_pipe_auth.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
_PUBLIC_ enum ndr_err_code ndr_push_rpc_host_client(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpc_host_client *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->binding));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->npa_info8));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->bind_packet));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->binding) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->binding, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->binding, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->binding, ndr_charset_length(r->binding, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->npa_info8) {
			NDR_CHECK(ndr_push_named_pipe_auth_req_info8(ndr, NDR_SCALARS|NDR_BUFFERS, r->npa_info8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rpc_host_client(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpc_host_client *r)
{
	uint32_t _ptr_binding;
	uint32_t size_binding_1 = 0;
	uint32_t length_binding_1 = 0;
	TALLOC_CTX *_mem_save_binding_0 = NULL;
	uint32_t _ptr_npa_info8;
	TALLOC_CTX *_mem_save_npa_info8_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binding));
		if (_ptr_binding) {
			NDR_PULL_ALLOC(ndr, r->binding);
		} else {
			r->binding = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_npa_info8));
		if (_ptr_npa_info8) {
			NDR_PULL_ALLOC(ndr, r->npa_info8);
		} else {
			r->npa_info8 = NULL;
		}
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->bind_packet));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->binding) {
			_mem_save_binding_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->binding, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->binding));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->binding));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->binding, &size_binding_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->binding, &length_binding_1));
			if (length_binding_1 > size_binding_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_binding_1, length_binding_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_binding_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->binding, length_binding_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binding_0, 0);
		}
		if (r->npa_info8) {
			_mem_save_npa_info8_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->npa_info8, 0);
			NDR_CHECK(ndr_pull_named_pipe_auth_req_info8(ndr, NDR_SCALARS|NDR_BUFFERS, r->npa_info8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_npa_info8_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_rpc_host_client(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct rpc_host_client *r)
{
	ndr_print_rpc_host_client(ndr, name, r);
}

_PUBLIC_ void ndr_print_rpc_host_client(struct ndr_print *ndr, const char *name, const struct rpc_host_client *r)
{
	ndr_print_struct(ndr, name, "rpc_host_client");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "binding", r->binding);
	ndr->depth++;
	if (r->binding) {
		ndr_print_string(ndr, "binding", r->binding);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "npa_info8", r->npa_info8);
	ndr->depth++;
	if (r->npa_info8) {
		ndr_print_named_pipe_auth_req_info8(ndr, "npa_info8", r->npa_info8);
	}
	ndr->depth--;
	ndr_print_DATA_BLOB(ndr, "bind_packet", r->bind_packet);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rpc_worker_status(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpc_worker_status *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->server_index));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->worker_index));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_association_groups));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_connections));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rpc_worker_status(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpc_worker_status *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->server_index));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->worker_index));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_association_groups));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_connections));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_rpc_worker_status(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct rpc_worker_status *r)
{
	ndr_print_rpc_worker_status(ndr, name, r);
}

_PUBLIC_ void ndr_print_rpc_worker_status(struct ndr_print *ndr, const char *name, const struct rpc_worker_status *r)
{
	ndr_print_struct(ndr, name, "rpc_worker_status");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "server_index", r->server_index);
		ndr_print_uint32(ndr, "worker_index", r->worker_index);
		ndr_print_uint32(ndr, "num_association_groups", r->num_association_groups);
		ndr_print_uint32(ndr, "num_connections", r->num_connections);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_rpc_host_msg
static const struct ndr_interface_public_struct rpc_host_msg_public_structs[] = {
	{
		.name = "rpc_host_client",
		.struct_size = sizeof(struct rpc_host_client ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_rpc_host_client,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_rpc_host_client,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_rpc_host_client,
	},
	{
		.name = "rpc_worker_status",
		.struct_size = sizeof(struct rpc_worker_status ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_rpc_worker_status,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_rpc_worker_status,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_rpc_worker_status,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call rpc_host_msg_calls[] = {
	{ .name = NULL }
};

static const char * const rpc_host_msg_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\rpc_host_msg]", 
};

static const struct ndr_interface_string_array rpc_host_msg_endpoints = {
	.count	= 1,
	.names	= rpc_host_msg_endpoint_strings
};

static const char * const rpc_host_msg_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array rpc_host_msg_authservices = {
	.count	= 1,
	.names	= rpc_host_msg_authservice_strings
};


const struct ndr_interface_table ndr_table_rpc_host_msg = {
	.name		= "rpc_host_msg",
	.num_calls	= 0,
	.calls		= rpc_host_msg_calls,
	.num_public_structs	= 2,
	.public_structs		= rpc_host_msg_public_structs,
	.endpoints	= &rpc_host_msg_endpoints,
	.authservices	= &rpc_host_msg_authservices
};

#endif /* SKIP_NDR_TABLE_rpc_host_msg */
