/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_ads
#define _PIDL_HEADER_ads

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/nbt.h"
#include <system/network.h>
#ifndef _HEADER_ads
#define _HEADER_ads

#define ADS_SASL_WRAPPING_IN_MAX_WRAPPED	( 0x0FFFFFFF )
#define ADS_SASL_WRAPPING_OUT_MAX_WRAPPED	( 0x00A00000 )
enum ads_saslwrap_type
#ifndef USE_UINT_ENUMS
 {
	ADS_SASLWRAP_TYPE_PLAIN=(int)(1),
	ADS_SASLWRAP_TYPE_SIGN=(int)(2),
	ADS_SASLWRAP_TYPE_SEAL=(int)(4)
}
#else
 { __do_not_use_enum_ads_saslwrap_type=INT_MAX}
#define ADS_SASLWRAP_TYPE_PLAIN ( 1 )
#define ADS_SASLWRAP_TYPE_SIGN ( 2 )
#define ADS_SASLWRAP_TYPE_SEAL ( 4 )
#endif
;

/* bitmap ads_auth_flags */
#define ADS_AUTH_DISABLE_KERBEROS ( 0x0001 )
#define ADS_AUTH_NO_BIND ( 0x0002 )
#define ADS_AUTH_ANON_BIND ( 0x0004 )
#define ADS_AUTH_SIMPLE_BIND ( 0x0008 )
#define ADS_AUTH_ALLOW_NTLMSSP ( 0x0010 )
#define ADS_AUTH_SASL_SIGN ( 0x0020 )
#define ADS_AUTH_SASL_SEAL ( 0x0040 )
#define ADS_AUTH_SASL_FORCE ( 0x0080 )
#define ADS_AUTH_USER_CREDS ( 0x0100 )

struct ads_server {
	const char * realm;
	const char * workgroup;
	const char * ldap_server;
	uint8_t gc;
	uint8_t no_fallback;
}/* [nopull,nopush] */;

struct ads_auth {
	const char * realm;
	const char * password;
	const char * user_name;
	const char * kdc_server;
	uint32_t flags;
	int32_t time_offset;
	const char * ccache_name;
	time_t tgt_expire;
	time_t tgs_expire;
	time_t renewable;
}/* [nopull,nopush] */;

struct ads_config {
	uint32_t flags;
	const char * realm;
	const char * bind_path;
	const char * ldap_server_name;
	const char * server_site_name;
	const char * client_site_name;
	time_t current_time;
	const char * schema_path;
	const char * config_path;
	int32_t ldap_page_size;
}/* [nopull,nopush] */;

struct ads_ldap_buf_in {
	uint32_t ofs;
	uint32_t needed;
	uint32_t left;
	uint32_t max_wrapped;
	uint32_t min_wrapped;
	uint32_t size;
	uint8_t *buf;/* [unique] */
}/* [nopull,nopush] */;

struct ads_ldap_buf_out {
	uint32_t ofs;
	uint32_t left;
	uint32_t max_unwrapped;
	uint32_t sig_size;
	uint32_t size;
	uint8_t *buf;/* [unique] */
}/* [nopull,nopush] */;

struct ads_saslwrap {
	enum ads_saslwrap_type wrap_type;
	struct ads_saslwrap_ops *wrap_ops;/* [ignore] */
	struct Sockbuf_IO_Desc *sbiod;/* [ignore] */
	struct TALLOC_CTX *mem_ctx;/* [ignore] */
	void *wrap_private_data;/* [ignore] */
	struct ads_ldap_buf_in in;
	struct ads_ldap_buf_out out;
}/* [nopull,nopush] */;

struct ads_ldap {
	struct ldap *ld;/* [ignore] */
	struct sockaddr_storage ss;
	time_t last_attempt;
	int32_t port;
}/* [nopull,nopush] */;

struct ads_struct {
	struct ads_server server;
	struct ads_auth auth;
	struct ads_config config;
	struct ads_saslwrap ldap_wrap_data;
	struct ads_ldap ldap;
}/* [nopull,nopush,public] */;

#endif /* _HEADER_ads */
#endif /* _PIDL_HEADER_ads */
