/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_iremotewinspool
#define _PIDL_HEADER_iremotewinspool

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/winreg.h"
#include "librpc/gen_ndr/spoolss.h"
#ifndef _HEADER_iremotewinspool
#define _HEADER_iremotewinspool

#define IREMOTEWINSPOOL_OBJECT_GUID	( "9940CA8E-512F-4C58-88A9-61098D6896BD" )
struct winspool_NOTIFY_REPLY_CONTAINER {
	struct spoolss_NotifyInfo *pInfo;/* [unique] */
};

struct winspool_NOTIFY_OPTIONS_CONTAINER {
	struct spoolss_NotifyOption *pOptions;/* [unique] */
};

enum winspool_PrintPropertyType
#ifndef USE_UINT_ENUMS
 {
	winspool_PropertyTypeString=(int)(1),
	winspool_PropertyTypeInt32=(int)(2),
	winspool_PropertyTypeInt64=(int)(3),
	winspool_PropertyTypeByte=(int)(4),
	winspool_PropertyTypeTime=(int)(5),
	winspool_PropertyTypeDevMode=(int)(6),
	winspool_PropertyTypeSD=(int)(7),
	winspool_PropertyTypeNotificationReply=(int)(8),
	winspool_PropertyTypeNotificationOptions=(int)(9)
}
#else
 { __do_not_use_enum_winspool_PrintPropertyType=INT_MAX}
#define winspool_PropertyTypeString ( 1 )
#define winspool_PropertyTypeInt32 ( 2 )
#define winspool_PropertyTypeInt64 ( 3 )
#define winspool_PropertyTypeByte ( 4 )
#define winspool_PropertyTypeTime ( 5 )
#define winspool_PropertyTypeDevMode ( 6 )
#define winspool_PropertyTypeSD ( 7 )
#define winspool_PropertyTypeNotificationReply ( 8 )
#define winspool_PropertyTypeNotificationOptions ( 9 )
#endif
;

union winspool_PrintPropertyValueUnion {
	const char *propertyString;/* [case(winspool_PropertyTypeString),charset(UTF16),unique] */
	uint32_t propertyInt32;/* [case(winspool_PropertyTypeInt32)] */
	uint64_t propertyInt64;/* [case(winspool_PropertyTypeInt64)] */
	uint8_t propertyByte;/* [case(winspool_PropertyTypeByte)] */
	struct spoolss_TimeCtr propertyTimeContainer;/* [case(winspool_PropertyTypeTime)] */
	struct spoolss_DevmodeContainer propertyDevModeContainer;/* [case(winspool_PropertyTypeDevMode)] */
	struct sec_desc_buf propertySDContainer;/* [case(winspool_PropertyTypeSD)] */
	struct winspool_NOTIFY_REPLY_CONTAINER propertyReplyContainer;/* [case(winspool_PropertyTypeNotificationReply)] */
	struct winspool_NOTIFY_OPTIONS_CONTAINER propertyOptionsContainer;/* [case(winspool_PropertyTypeNotificationOptions)] */
}/* [ms_union,switch_type(winspool_PrintPropertyType)] */;

struct winspool_PrintPropertyValue {
	enum winspool_PrintPropertyType PropertyType;
	union winspool_PrintPropertyValueUnion value;/* [switch_is(PropertyType)] */
};

struct winspool_PrintNamedProperty {
	const char *propertyName;/* [charset(UTF16),unique] */
	struct winspool_PrintPropertyValue propertyValue;
};

struct winspool_PrintPropertiesCollection {
	uint32_t numberOfProperties;/* [range(0,50)] */
	struct winspool_PrintNamedProperty *propertiesCollection;/* [size_is(numberOfProperties),unique] */
};

/* bitmap winspool_InstallPrinterDriverFromPackageFlags */
#define IPDFP_FLAG_NONE ( 0x00000000 )
#define IPDFP_COPY_ALL_FILES ( 0x00000001 )

/* bitmap winspool_UploadPrinterDriverPackageFlags */
#define UPDP_FLAG_NONE ( 0x00000000 )
#define UPDP_UPLOAD_ALWAYS ( 0x00000002 )
#define UPDP_CHECK_DRIVERSTORE ( 0x00000004 )


struct winspool_AsyncOpenPrinter {
	struct {
		const char *pPrinterName;/* [charset(UTF16),unique] */
		const char *pDatatype;/* [charset(UTF16),unique] */
		struct spoolss_DevmodeContainer *pDevModeContainer;/* [ref] */
		uint32_t AccessRequired;
		struct spoolss_UserLevelCtr *pClientInfo;/* [ref] */
	} in;

	struct {
		struct policy_handle *pHandle;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncAddPrinter {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		struct spoolss_SetPrinterInfoCtr *pPrinterContainer;/* [ref] */
		struct spoolss_DevmodeContainer *pDevModeContainer;/* [ref] */
		struct sec_desc_buf *pSecurityContainer;/* [ref] */
		struct spoolss_UserLevelCtr *pClientInfo;/* [ref] */
	} in;

	struct {
		struct policy_handle *pHandle;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncSetJob {
	struct {
		struct policy_handle hPrinter;
		uint32_t JobId;
		struct spoolss_JobInfoContainer *pJobContainer;/* [unique] */
		uint32_t Command;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncGetJob {
	struct {
		struct policy_handle hPrinter;
		uint32_t JobId;
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pJob;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint8_t *pJob;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncEnumJobs {
	struct {
		struct policy_handle hPrinter;
		uint32_t FirstJob;
		uint32_t NoJobs;
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pJob;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pJob;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncAddJob {
	struct {
		struct policy_handle hPrinter;
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pAddJob;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint8_t *pAddJob;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncScheduleJob {
	struct {
		struct policy_handle hPrinter;
		uint32_t JobId;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrinter {
	struct {
		struct policy_handle hPrinter;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncSetPrinter {
	struct {
		struct policy_handle hPrinter;
		struct spoolss_SetPrinterInfoCtr *pPrinterContainer;/* [ref] */
		struct spoolss_DevmodeContainer *pDevModeContainer;/* [ref] */
		struct sec_desc_buf *pSecurityContainer;/* [ref] */
		uint32_t Command;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncGetPrinter {
	struct {
		struct policy_handle hPrinter;
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pPrinter;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint8_t *pPrinter;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncStartDocPrinter {
	struct {
		struct policy_handle hPrinter;
		struct spoolss_DocumentInfoCtr *pDocInfoContainer;/* [ref] */
	} in;

	struct {
		uint32_t *pJobId;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncStartPagePrinter {
	struct {
		struct policy_handle hPrinter;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncWritePrinter {
	struct {
		struct policy_handle hPrinter;
		uint8_t *pBuf;/* [ref,size_is(cbBuf)] */
		uint32_t cbBuf;
	} in;

	struct {
		uint32_t *pcWritten;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncEndPagePrinter {
	struct {
		struct policy_handle hPrinter;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncEndDocPrinter {
	struct {
		struct policy_handle hPrinter;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncAbortPrinter {
	struct {
		struct policy_handle hPrinter;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncGetPrinterData {
	struct {
		struct policy_handle hPrinter;
		const char *pValueName;/* [charset(UTF16),ref] */
		uint32_t nSize;
	} in;

	struct {
		uint32_t *pType;/* [ref] */
		uint8_t *pData;/* [ref,size_is(nSize)] */
		uint32_t *pcbNeeded;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncGetPrinterDataEx {
	struct {
		struct policy_handle hPrinter;
		const char *pKeyName;/* [charset(UTF16),ref] */
		const char *pValueName;/* [charset(UTF16),ref] */
		uint32_t nSize;
	} in;

	struct {
		uint32_t *pType;/* [ref] */
		uint8_t *pData;/* [ref,size_is(nSize)] */
		uint32_t *pcbNeeded;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncSetPrinterData {
	struct {
		struct policy_handle hPrinter;
		const char *pValueName;/* [charset(UTF16),ref] */
		uint32_t Type;
		uint8_t *pData;/* [ref,size_is(cbData)] */
		uint32_t cbData;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncSetPrinterDataEx {
	struct {
		struct policy_handle hPrinter;
		const char *pKeyName;/* [charset(UTF16),ref] */
		const char *pValueName;/* [charset(UTF16),ref] */
		uint32_t Type;
		uint8_t *pData;/* [ref,size_is(cbData)] */
		uint32_t cbData;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncClosePrinter {
	struct {
		struct policy_handle *phPrinter;/* [ref] */
	} in;

	struct {
		struct policy_handle *phPrinter;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncAddForm {
	struct {
		struct policy_handle hPrinter;
		struct spoolss_AddFormInfoCtr *pFormInfoContainer;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeleteForm {
	struct {
		struct policy_handle hPrinter;
		const char *pFormName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncGetForm {
	struct {
		struct policy_handle hPrinter;
		const char *pFormName;/* [charset(UTF16),ref] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pForm;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint8_t *pForm;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncSetForm {
	struct {
		struct policy_handle hPrinter;
		const char *pFormName;/* [charset(UTF16),ref] */
		struct spoolss_AddFormInfoCtr *pFormInfoContainer;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncEnumForms {
	struct {
		struct policy_handle hPrinter;
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pForm;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pForm;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncGetPrinterDriver {
	struct {
		struct policy_handle hPrinter;
		const char *pEnvironment;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint32_t dwClientMajorVersion;
		uint32_t dwClientMinorVersion;
		uint8_t *pDriver;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pdwServerMaxVersion;/* [ref] */
		uint32_t *pdwServerMinVersion;/* [ref] */
		uint8_t *pDriver;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPrinterData {
	struct {
		struct policy_handle hPrinter;
		uint32_t dwIndex;
		uint32_t cbValueName;
		uint32_t cbData;
	} in;

	struct {
		uint16_t *pValueName;/* [ref,size_is(cbValueName/2)] */
		uint32_t *pcbValueName;/* [ref] */
		uint32_t *pType;/* [ref] */
		uint8_t *pData;/* [ref,size_is(cbData)] */
		uint32_t *pcbData;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPrinterDataEx {
	struct {
		struct policy_handle hPrinter;
		const char *pKeyName;/* [charset(UTF16),ref] */
		uint32_t cbEnumValues;
	} in;

	struct {
		uint8_t *pEnumValues;/* [ref,size_is(cbEnumValues)] */
		uint32_t *pcbEnumValues;/* [ref] */
		uint32_t *pnEnumValues;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPrinterKey {
	struct {
		struct policy_handle hPrinter;
		const char *pKeyName;/* [charset(UTF16),ref] */
		uint32_t cbSubkey;
	} in;

	struct {
		uint16_t *pSubkey;/* [ref,size_is(cbSubkey/2)] */
		uint32_t *pcbSubkey;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrinterData {
	struct {
		struct policy_handle hPrinter;
		const char *pValueName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrinterDataEx {
	struct {
		struct policy_handle hPrinter;
		const char *pKeyName;/* [charset(UTF16),ref] */
		const char *pValueName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrinterKey {
	struct {
		struct policy_handle hPrinter;
		const char *pKeyName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncXcvData {
	struct {
		struct policy_handle hXcv;
		const char *pszDataName;/* [charset(UTF16),ref] */
		uint8_t *pInputData;/* [ref,size_is(cbInputData)] */
		uint32_t cbInputData;
		uint32_t cbOutputData;
		uint32_t *pdwStatus;/* [ref] */
	} in;

	struct {
		uint8_t *pOutputData;/* [ref,size_is(cbOutputData)] */
		uint32_t *pcbOutputNeeded;/* [ref] */
		uint32_t *pdwStatus;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncSendRecvBidiData {
	struct {
		struct policy_handle hPrinter;
		const char *pAction;/* [charset(UTF16),unique] */
		struct RPC_BIDI_REQUEST_CONTAINER *pReqData;/* [ref] */
	} in;

	struct {
		struct RPC_BIDI_RESPONSE_CONTAINER **ppRespData;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncCreatePrinterIC {
	struct {
		struct policy_handle hPrinter;
		struct spoolss_DevmodeContainer *pDevModeContainer;/* [ref] */
	} in;

	struct {
		struct policy_handle *pHandle;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncPlayGdiScriptOnPrinterIC {
	struct {
		struct policy_handle hPrinterIC;
		uint8_t *pIn;/* [ref,size_is(cIn)] */
		uint32_t cIn;
		uint32_t cOut;
		uint32_t ul;
	} in;

	struct {
		uint8_t *pOut;/* [ref,size_is(cOut)] */
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrinterIC {
	struct {
		struct policy_handle *phPrinterIC;/* [ref] */
	} in;

	struct {
		struct policy_handle *phPrinterIC;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPrinters {
	struct {
		uint32_t Flags;
		const char *pName;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pPrinterEnum;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pPrinterEnum;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncAddPrinterDriver {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		struct spoolss_AddDriverInfoCtr *pDriverContainer;/* [ref] */
		uint32_t dwFileCopyFlags;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPrinterDrivers {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pDrivers;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pDrivers;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncGetPrinterDriverDirectory {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pDriverDirectory;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint8_t *pDriverDirectory;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrinterDriver {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),ref] */
		const char *pDriverName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrinterDriverEx {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),ref] */
		const char *pDriverName;/* [charset(UTF16),ref] */
		uint32_t dwDeleteFlag;
		uint32_t dwVersionNum;
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncAddPrintProcessor {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),ref] */
		const char *pPathName;/* [charset(UTF16),ref] */
		const char *pPrintProcessorName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPrintProcessors {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pPrintProcessorInfo;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pPrintProcessorInfo;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncGetPrintProcessorDirectory {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pPrintProcessorDirectory;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint8_t *pPrintProcessorDirectory;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPorts {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pPort;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pPort;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncEnumMonitors {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pMonitor;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pMonitor;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncAddPort {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		struct spoolss_SetPortInfoContainer *pPortContainer;/* [ref] */
		struct spoolss_PortVarContainer *pPortVarContainer;/* [ref] */
		const char *pMonitorName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncSetPort {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pPortName;/* [charset(UTF16),unique] */
		struct spoolss_SetPortInfoContainer *pPortContainer;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncAddMonitor {
	struct {
		const char *Name;/* [charset(UTF16),unique] */
		struct spoolss_MonitorContainer *pMonitorContainer;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeleteMonitor {
	struct {
		const char *Name;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),unique] */
		const char *pMonitorName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePrintProcessor {
	struct {
		const char *Name;/* [charset(UTF16),unique] */
		const char *pEnvironment;/* [charset(UTF16),unique] */
		const char *pPrintProcessorName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPrintProcessorDatatypes {
	struct {
		const char *pName;/* [charset(UTF16),unique] */
		const char *pPrintProcessorName;/* [charset(UTF16),unique] */
		uint32_t Level;
		uint32_t cbBuf;
		uint8_t *pDatatypes;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pDatatypes;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_AsyncAddPerMachineConnection {
	struct {
		const char *pServer;/* [charset(UTF16),unique] */
		const char *pPrinterName;/* [charset(UTF16),ref] */
		const char *pPrintServer;/* [charset(UTF16),ref] */
		const char *pProvider;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeletePerMachineConnection {
	struct {
		const char *pServer;/* [charset(UTF16),unique] */
		const char *pPrinterName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncEnumPerMachineConnections {
	struct {
		const char *pServer;/* [charset(UTF16),unique] */
		uint32_t cbBuf;
		uint8_t *pPrinterEnum;/* [size_is(cbBuf),unique] */
	} in;

	struct {
		uint32_t *pcbNeeded;/* [ref] */
		uint32_t *pcReturned;/* [ref] */
		uint8_t *pPrinterEnum;/* [size_is(cbBuf),unique] */
		WERROR result;
	} out;

};


struct winspool_SyncRegisterForRemoteNotifications {
	struct {
		struct policy_handle hPrinter;
		struct winspool_PrintPropertiesCollection *pNotifyFilter;/* [ref] */
	} in;

	struct {
		struct policy_handle *phRpcHandle;/* [ref] */
		HRESULT result;
	} out;

};


struct winspool_SyncUnRegisterForRemoteNotifications {
	struct {
		struct policy_handle *phRpcHandle;/* [ref] */
	} in;

	struct {
		struct policy_handle *phRpcHandle;/* [ref] */
		HRESULT result;
	} out;

};


struct winspool_SyncRefreshRemoteNotifications {
	struct {
		struct policy_handle hRpcHandle;
		struct winspool_PrintPropertiesCollection *pNotifyFilter;/* [ref] */
	} in;

	struct {
		struct winspool_PrintPropertiesCollection **ppNotifyData;/* [ref] */
		HRESULT result;
	} out;

};


struct winspool_AsyncGetRemoteNotifications {
	struct {
		struct policy_handle hRpcHandle;
	} in;

	struct {
		struct winspool_PrintPropertiesCollection **ppNotifyData;/* [ref] */
		HRESULT result;
	} out;

};


struct winspool_AsyncInstallPrinterDriverFromPackage {
	struct {
		const char *pszServer;/* [charset(UTF16),unique] */
		const char *pszInfPath;/* [charset(UTF16),unique] */
		const char *pszDriverName;/* [charset(UTF16),ref] */
		const char *pszEnvironment;/* [charset(UTF16),ref] */
		uint32_t dwFlags;
	} in;

	struct {
		HRESULT result;
	} out;

};


struct winspool_AsyncUploadPrinterDriverPackage {
	struct {
		const char *pszServer;/* [charset(UTF16),unique] */
		const char *pszInfPath;/* [charset(UTF16),ref] */
		const char *pszEnvironment;/* [charset(UTF16),ref] */
		uint32_t dwFlags;
		const char *pszDestInfPath;/* [charset(UTF16),size_is(*pcchDestInfPath),unique] */
		uint32_t *pcchDestInfPath;/* [ref] */
	} in;

	struct {
		const char *pszDestInfPath;/* [charset(UTF16),size_is(*pcchDestInfPath),unique] */
		uint32_t *pcchDestInfPath;/* [ref] */
		HRESULT result;
	} out;

};


struct winspool_AsyncGetCorePrinterDrivers {
	struct {
		const char *pszServer;/* [charset(UTF16),unique] */
		const char *pszEnvironment;/* [charset(UTF16),ref] */
		uint32_t cchCoreDrivers;
		uint16_t *pszzCoreDriverDependencies;/* [ref,size_is(cchCoreDrivers)] */
		uint32_t cCorePrinterDrivers;
	} in;

	struct {
		struct spoolss_CorePrinterDriver *pCorePrinterDrivers;/* [ref,size_is(cCorePrinterDrivers)] */
		HRESULT result;
	} out;

};


struct winspool_AsyncCorePrinterDriverInstalled {
	struct {
		const char *pszServer;/* [charset(UTF16),unique] */
		const char *pszEnvironment;/* [charset(UTF16),ref] */
		struct GUID CoreDriverGUID;
		NTTIME ftDriverDate;
		uint64_t dwlDriverVersion;
	} in;

	struct {
		int32_t *pbDriverInstalled;/* [ref] */
		HRESULT result;
	} out;

};


struct winspool_AsyncGetPrinterDriverPackagePath {
	struct {
		const char *pszServer;/* [charset(UTF16),unique] */
		const char *pszEnvironment;/* [charset(UTF16),ref] */
		const char *pszLanguage;/* [charset(UTF16),unique] */
		const char *pszPackageID;/* [charset(UTF16),ref] */
		uint32_t cchDriverPackageCab;
		uint16_t *pszDriverPackageCab;/* [size_is(cchDriverPackageCab),unique] */
	} in;

	struct {
		uint32_t *pcchRequiredSize;/* [ref] */
		uint16_t *pszDriverPackageCab;/* [size_is(cchDriverPackageCab),unique] */
		HRESULT result;
	} out;

};


struct winspool_AsyncDeletePrinterDriverPackage {
	struct {
		const char *pszServer;/* [charset(UTF16),unique] */
		const char *pszInfPath;/* [charset(UTF16),ref] */
		const char *pszEnvironment;/* [charset(UTF16),ref] */
	} in;

	struct {
		HRESULT result;
	} out;

};


struct winspool_AsyncReadPrinter {
	struct {
		struct policy_handle hPrinter;
		uint32_t cbBuf;
	} in;

	struct {
		uint8_t *pBuf;/* [ref,size_is(cbBuf)] */
		uint32_t *pcNoBytesRead;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncResetPrinter {
	struct {
		struct policy_handle hPrinter;
		const char *pDatatype;/* [charset(UTF16),unique] */
		struct spoolss_DevmodeContainer *pDevModeContainer;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncGetJobNamedPropertyValue {
	struct {
		struct policy_handle hPrinter;
		uint32_t JobId;
		const char *pszName;/* [charset(UTF16),ref] */
	} in;

	struct {
		struct spoolss_PrintPropertyValue *pValue;/* [ref] */
		WERROR result;
	} out;

};


struct winspool_AsyncSetJobNamedProperty {
	struct {
		struct policy_handle hPrinter;
		uint32_t JobId;
		struct spoolss_PrintNamedProperty *pProperty;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncDeleteJobNamedProperty {
	struct {
		struct policy_handle hPrinter;
		uint32_t JobId;
		const char *pszName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct winspool_AsyncEnumJobNamedProperties {
	struct {
		struct policy_handle hPrinter;
		uint32_t JobId;
	} in;

	struct {
		uint32_t *pcProperties;/* [ref] */
		struct spoolss_PrintNamedProperty **ppProperties;/* [ref,size_is(,*pcProperties)] */
		WERROR result;
	} out;

};


struct winspool_AsyncLogJobInfoForBranchOffice {
	struct {
		struct policy_handle hPrinter;
		struct spoolss_BranchOfficeJobDataContainer *pBranchOfficeJobDataContainer;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};

#endif /* _HEADER_iremotewinspool */
#endif /* _PIDL_HEADER_iremotewinspool */
