
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_wkssvc.h"
#include "bin/default/librpc/gen_ndr/ndr_wkssvc_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/srvsvc.h"
#include "librpc/gen_ndr/lsa.h"
static PyTypeObject wkssvc_NetWkstaInfo100_Type;
static PyTypeObject wkssvc_NetWkstaInfo101_Type;
static PyTypeObject wkssvc_NetWkstaInfo102_Type;
static PyTypeObject wkssvc_NetWkstaInfo502_Type;
static PyTypeObject wkssvc_NetWkstaInfo1010_Type;
static PyTypeObject wkssvc_NetWkstaInfo1011_Type;
static PyTypeObject wkssvc_NetWkstaInfo1012_Type;
static PyTypeObject wkssvc_NetWkstaInfo1013_Type;
static PyTypeObject wkssvc_NetWkstaInfo1018_Type;
static PyTypeObject wkssvc_NetWkstaInfo1023_Type;
static PyTypeObject wkssvc_NetWkstaInfo1027_Type;
static PyTypeObject wkssvc_NetWkstaInfo1028_Type;
static PyTypeObject wkssvc_NetWkstaInfo1032_Type;
static PyTypeObject wkssvc_NetWkstaInfo1033_Type;
static PyTypeObject wkssvc_NetWkstaInfo1041_Type;
static PyTypeObject wkssvc_NetWkstaInfo1042_Type;
static PyTypeObject wkssvc_NetWkstaInfo1043_Type;
static PyTypeObject wkssvc_NetWkstaInfo1044_Type;
static PyTypeObject wkssvc_NetWkstaInfo1045_Type;
static PyTypeObject wkssvc_NetWkstaInfo1046_Type;
static PyTypeObject wkssvc_NetWkstaInfo1047_Type;
static PyTypeObject wkssvc_NetWkstaInfo1048_Type;
static PyTypeObject wkssvc_NetWkstaInfo1049_Type;
static PyTypeObject wkssvc_NetWkstaInfo1050_Type;
static PyTypeObject wkssvc_NetWkstaInfo1051_Type;
static PyTypeObject wkssvc_NetWkstaInfo1052_Type;
static PyTypeObject wkssvc_NetWkstaInfo1053_Type;
static PyTypeObject wkssvc_NetWkstaInfo1054_Type;
static PyTypeObject wkssvc_NetWkstaInfo1055_Type;
static PyTypeObject wkssvc_NetWkstaInfo1056_Type;
static PyTypeObject wkssvc_NetWkstaInfo1057_Type;
static PyTypeObject wkssvc_NetWkstaInfo1058_Type;
static PyTypeObject wkssvc_NetWkstaInfo1059_Type;
static PyTypeObject wkssvc_NetWkstaInfo1060_Type;
static PyTypeObject wkssvc_NetWkstaInfo1061_Type;
static PyTypeObject wkssvc_NetWkstaInfo1062_Type;
static PyTypeObject wkssvc_NetWkstaInfo_Type;
static PyTypeObject wkssvc_NetrWkstaUserInfo0_Type;
static PyTypeObject wkssvc_NetWkstaEnumUsersCtr0_Type;
static PyTypeObject wkssvc_NetrWkstaUserInfo1_Type;
static PyTypeObject wkssvc_NetWkstaEnumUsersCtr1_Type;
static PyTypeObject wkssvc_NetWkstaEnumUsersCtr_Type;
static PyTypeObject wkssvc_NetWkstaEnumUsersInfo_Type;
static PyTypeObject wkssvc_NetrWkstaUserInfo1101_Type;
static PyTypeObject wkssvc_NetrWkstaUserInfo_Type;
static PyTypeObject wkssvc_NetWkstaTransportInfo0_Type;
static PyTypeObject wkssvc_NetWkstaTransportCtr0_Type;
static PyTypeObject wkssvc_NetWkstaTransportCtr_Type;
static PyTypeObject wkssvc_NetWkstaTransportInfo_Type;
static PyTypeObject wkssvc_NetrUseInfo3_Type;
static PyTypeObject wkssvc_NetrUseInfo2_Type;
static PyTypeObject wkssvc_NetrUseInfo1_Type;
static PyTypeObject wkssvc_NetrUseInfo0_Type;
static PyTypeObject wkssvc_NetrUseGetInfoCtr_Type;
static PyTypeObject wkssvc_NetrUseEnumCtr2_Type;
static PyTypeObject wkssvc_NetrUseEnumCtr1_Type;
static PyTypeObject wkssvc_NetrUseEnumCtr0_Type;
static PyTypeObject wkssvc_NetrUseEnumCtr_Type;
static PyTypeObject wkssvc_NetrUseEnumInfo_Type;
static PyTypeObject wkssvc_NetrWorkstationStatistics_Type;
static PyTypeObject wkssvc_PasswordBuffer_Type;
static PyTypeObject wkssvc_ComputerNamesCtr_Type;
static PyTypeObject wkssvc_InterfaceType;
static PyTypeObject wkssvc_NetWkstaGetInfo_Type;
static PyTypeObject wkssvc_NetWkstaSetInfo_Type;
static PyTypeObject wkssvc_NetWkstaEnumUsers_Type;
static PyTypeObject wkssvc_NetrWkstaUserGetInfo_Type;
static PyTypeObject wkssvc_NetrWkstaUserSetInfo_Type;
static PyTypeObject wkssvc_NetWkstaTransportEnum_Type;
static PyTypeObject wkssvc_NetrWkstaTransportAdd_Type;
static PyTypeObject wkssvc_NetrWkstaTransportDel_Type;
static PyTypeObject wkssvc_NetrUseAdd_Type;
static PyTypeObject wkssvc_NetrUseGetInfo_Type;
static PyTypeObject wkssvc_NetrUseDel_Type;
static PyTypeObject wkssvc_NetrUseEnum_Type;
static PyTypeObject wkssvc_NetrMessageBufferSend_Type;
static PyTypeObject wkssvc_NetrWorkstationStatisticsGet_Type;
static PyTypeObject wkssvc_NetrLogonDomainNameAdd_Type;
static PyTypeObject wkssvc_NetrLogonDomainNameDel_Type;
static PyTypeObject wkssvc_NetrJoinDomain_Type;
static PyTypeObject wkssvc_NetrUnjoinDomain_Type;
static PyTypeObject wkssvc_NetrRenameMachineInDomain_Type;
static PyTypeObject wkssvc_NetrValidateName_Type;
static PyTypeObject wkssvc_NetrGetJoinInformation_Type;
static PyTypeObject wkssvc_NetrGetJoinableOus_Type;
static PyTypeObject wkssvc_NetrJoinDomain2_Type;
static PyTypeObject wkssvc_NetrUnjoinDomain2_Type;
static PyTypeObject wkssvc_NetrRenameMachineInDomain2_Type;
static PyTypeObject wkssvc_NetrValidateName2_Type;
static PyTypeObject wkssvc_NetrGetJoinableOus2_Type;
static PyTypeObject wkssvc_NetrAddAlternateComputerName_Type;
static PyTypeObject wkssvc_NetrRemoveAlternateComputerName_Type;
static PyTypeObject wkssvc_NetrSetPrimaryComputername_Type;
static PyTypeObject wkssvc_NetrEnumerateComputerNames_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *lsa_String_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_wkssvc_NetWkstaInfo100_get_platform_id(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(obj);
	PyObject *py_platform_id;
	py_platform_id = PyLong_FromUnsignedLongLong((uint32_t)(object->platform_id));
	return py_platform_id;
}

static int py_wkssvc_NetWkstaInfo100_set_platform_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->platform_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->platform_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->platform_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo100_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetWkstaInfo100_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->server_name");
		return -1;
	}
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo100_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_wkssvc_NetWkstaInfo100_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo100_get_version_major(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_major;
	py_version_major = PyLong_FromUnsignedLongLong((uint32_t)(object->version_major));
	return py_version_major;
}

static int py_wkssvc_NetWkstaInfo100_set_version_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version_major");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_major));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_major = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo100_get_version_minor(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_minor;
	py_version_minor = PyLong_FromUnsignedLongLong((uint32_t)(object->version_minor));
	return py_version_minor;
}

static int py_wkssvc_NetWkstaInfo100_set_version_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo100 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo100_getsetters[] = {
	{
		.name = discard_const_p(char, "platform_id"),
		.get = py_wkssvc_NetWkstaInfo100_get_platform_id,
		.set = py_wkssvc_NetWkstaInfo100_set_platform_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_PlatformId")
	},
	{
		.name = discard_const_p(char, "server_name"),
		.get = py_wkssvc_NetWkstaInfo100_get_server_name,
		.set = py_wkssvc_NetWkstaInfo100_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_wkssvc_NetWkstaInfo100_get_domain_name,
		.set = py_wkssvc_NetWkstaInfo100_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "version_major"),
		.get = py_wkssvc_NetWkstaInfo100_get_version_major,
		.set = py_wkssvc_NetWkstaInfo100_set_version_major,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version_minor"),
		.get = py_wkssvc_NetWkstaInfo100_get_version_minor,
		.set = py_wkssvc_NetWkstaInfo100_set_version_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo100_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo100, type);
}


static PyTypeObject wkssvc_NetWkstaInfo100_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo100",
	.tp_getset = py_wkssvc_NetWkstaInfo100_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo100_new,
};


static PyObject *py_wkssvc_NetWkstaInfo101_get_platform_id(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_platform_id;
	py_platform_id = PyLong_FromUnsignedLongLong((uint32_t)(object->platform_id));
	return py_platform_id;
}

static int py_wkssvc_NetWkstaInfo101_set_platform_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->platform_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->platform_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->platform_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo101_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetWkstaInfo101_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->server_name");
		return -1;
	}
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo101_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_wkssvc_NetWkstaInfo101_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo101_get_version_major(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_major;
	py_version_major = PyLong_FromUnsignedLongLong((uint32_t)(object->version_major));
	return py_version_major;
}

static int py_wkssvc_NetWkstaInfo101_set_version_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version_major");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_major));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_major = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo101_get_version_minor(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_minor;
	py_version_minor = PyLong_FromUnsignedLongLong((uint32_t)(object->version_minor));
	return py_version_minor;
}

static int py_wkssvc_NetWkstaInfo101_set_version_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo101_get_lan_root(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_lan_root;
	if (object->lan_root == NULL) {
		Py_RETURN_NONE;
	}
	if (object->lan_root == NULL) {
		py_lan_root = Py_None;
		Py_INCREF(py_lan_root);
	} else {
		if (object->lan_root == NULL) {
			py_lan_root = Py_None;
			Py_INCREF(py_lan_root);
		} else {
			py_lan_root = PyUnicode_Decode(object->lan_root, strlen(object->lan_root), "utf-8", "ignore");
		}
	}
	return py_lan_root;
}

static int py_wkssvc_NetWkstaInfo101_set_lan_root(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lan_root");
		return -1;
	}
	if (value == Py_None) {
		object->lan_root = NULL;
	} else {
		object->lan_root = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->lan_root = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo101_getsetters[] = {
	{
		.name = discard_const_p(char, "platform_id"),
		.get = py_wkssvc_NetWkstaInfo101_get_platform_id,
		.set = py_wkssvc_NetWkstaInfo101_set_platform_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_PlatformId")
	},
	{
		.name = discard_const_p(char, "server_name"),
		.get = py_wkssvc_NetWkstaInfo101_get_server_name,
		.set = py_wkssvc_NetWkstaInfo101_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_wkssvc_NetWkstaInfo101_get_domain_name,
		.set = py_wkssvc_NetWkstaInfo101_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "version_major"),
		.get = py_wkssvc_NetWkstaInfo101_get_version_major,
		.set = py_wkssvc_NetWkstaInfo101_set_version_major,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version_minor"),
		.get = py_wkssvc_NetWkstaInfo101_get_version_minor,
		.set = py_wkssvc_NetWkstaInfo101_set_version_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lan_root"),
		.get = py_wkssvc_NetWkstaInfo101_get_lan_root,
		.set = py_wkssvc_NetWkstaInfo101_set_lan_root,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo101_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo101, type);
}


static PyTypeObject wkssvc_NetWkstaInfo101_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo101",
	.tp_getset = py_wkssvc_NetWkstaInfo101_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo101_new,
};


static PyObject *py_wkssvc_NetWkstaInfo102_get_platform_id(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_platform_id;
	py_platform_id = PyLong_FromUnsignedLongLong((uint32_t)(object->platform_id));
	return py_platform_id;
}

static int py_wkssvc_NetWkstaInfo102_set_platform_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->platform_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->platform_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->platform_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo102_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetWkstaInfo102_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->server_name");
		return -1;
	}
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo102_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_wkssvc_NetWkstaInfo102_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo102_get_version_major(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_major;
	py_version_major = PyLong_FromUnsignedLongLong((uint32_t)(object->version_major));
	return py_version_major;
}

static int py_wkssvc_NetWkstaInfo102_set_version_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version_major");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_major));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_major = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo102_get_version_minor(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_minor;
	py_version_minor = PyLong_FromUnsignedLongLong((uint32_t)(object->version_minor));
	return py_version_minor;
}

static int py_wkssvc_NetWkstaInfo102_set_version_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo102_get_lan_root(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_lan_root;
	if (object->lan_root == NULL) {
		Py_RETURN_NONE;
	}
	if (object->lan_root == NULL) {
		py_lan_root = Py_None;
		Py_INCREF(py_lan_root);
	} else {
		if (object->lan_root == NULL) {
			py_lan_root = Py_None;
			Py_INCREF(py_lan_root);
		} else {
			py_lan_root = PyUnicode_Decode(object->lan_root, strlen(object->lan_root), "utf-8", "ignore");
		}
	}
	return py_lan_root;
}

static int py_wkssvc_NetWkstaInfo102_set_lan_root(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lan_root");
		return -1;
	}
	if (value == Py_None) {
		object->lan_root = NULL;
	} else {
		object->lan_root = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->lan_root = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo102_get_logged_on_users(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_logged_on_users;
	py_logged_on_users = PyLong_FromUnsignedLongLong((uint32_t)(object->logged_on_users));
	return py_logged_on_users;
}

static int py_wkssvc_NetWkstaInfo102_set_logged_on_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->logged_on_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logged_on_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logged_on_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo102_getsetters[] = {
	{
		.name = discard_const_p(char, "platform_id"),
		.get = py_wkssvc_NetWkstaInfo102_get_platform_id,
		.set = py_wkssvc_NetWkstaInfo102_set_platform_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_PlatformId")
	},
	{
		.name = discard_const_p(char, "server_name"),
		.get = py_wkssvc_NetWkstaInfo102_get_server_name,
		.set = py_wkssvc_NetWkstaInfo102_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_wkssvc_NetWkstaInfo102_get_domain_name,
		.set = py_wkssvc_NetWkstaInfo102_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "version_major"),
		.get = py_wkssvc_NetWkstaInfo102_get_version_major,
		.set = py_wkssvc_NetWkstaInfo102_set_version_major,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version_minor"),
		.get = py_wkssvc_NetWkstaInfo102_get_version_minor,
		.set = py_wkssvc_NetWkstaInfo102_set_version_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lan_root"),
		.get = py_wkssvc_NetWkstaInfo102_get_lan_root,
		.set = py_wkssvc_NetWkstaInfo102_set_lan_root,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "logged_on_users"),
		.get = py_wkssvc_NetWkstaInfo102_get_logged_on_users,
		.set = py_wkssvc_NetWkstaInfo102_set_logged_on_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo102_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo102, type);
}


static PyTypeObject wkssvc_NetWkstaInfo102_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo102",
	.tp_getset = py_wkssvc_NetWkstaInfo102_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo102_new,
};


static PyObject *py_wkssvc_NetWkstaInfo502_get_char_wait(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_char_wait;
	py_char_wait = PyLong_FromUnsignedLongLong((uint32_t)(object->char_wait));
	return py_char_wait;
}

static int py_wkssvc_NetWkstaInfo502_set_char_wait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->char_wait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->char_wait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->char_wait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_collection_time(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_collection_time;
	py_collection_time = PyLong_FromUnsignedLongLong((uint32_t)(object->collection_time));
	return py_collection_time;
}

static int py_wkssvc_NetWkstaInfo502_set_collection_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->collection_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->collection_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->collection_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_maximum_collection_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_maximum_collection_count;
	py_maximum_collection_count = PyLong_FromUnsignedLongLong((uint32_t)(object->maximum_collection_count));
	return py_maximum_collection_count;
}

static int py_wkssvc_NetWkstaInfo502_set_maximum_collection_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->maximum_collection_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maximum_collection_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maximum_collection_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_keep_connection(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_keep_connection;
	py_keep_connection = PyLong_FromUnsignedLongLong((uint32_t)(object->keep_connection));
	return py_keep_connection;
}

static int py_wkssvc_NetWkstaInfo502_set_keep_connection(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->keep_connection");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->keep_connection));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->keep_connection = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_max_commands(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_commands;
	py_max_commands = PyLong_FromUnsignedLongLong((uint32_t)(object->max_commands));
	return py_max_commands;
}

static int py_wkssvc_NetWkstaInfo502_set_max_commands(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->max_commands");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_commands));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_commands = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_session_timeout(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_session_timeout;
	py_session_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->session_timeout));
	return py_session_timeout;
}

static int py_wkssvc_NetWkstaInfo502_set_session_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->session_timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->session_timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->session_timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_size_char_buf(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_size_char_buf;
	py_size_char_buf = PyLong_FromUnsignedLongLong((uint32_t)(object->size_char_buf));
	return py_size_char_buf;
}

static int py_wkssvc_NetWkstaInfo502_set_size_char_buf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size_char_buf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size_char_buf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size_char_buf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_max_threads(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_threads;
	py_max_threads = PyLong_FromUnsignedLongLong((uint32_t)(object->max_threads));
	return py_max_threads;
}

static int py_wkssvc_NetWkstaInfo502_set_max_threads(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->max_threads");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_threads));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_threads = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_lock_quota(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_quota;
	py_lock_quota = PyLong_FromUnsignedLongLong((uint32_t)(object->lock_quota));
	return py_lock_quota;
}

static int py_wkssvc_NetWkstaInfo502_set_lock_quota(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_quota");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lock_quota));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lock_quota = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_lock_increment(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_increment;
	py_lock_increment = PyLong_FromUnsignedLongLong((uint32_t)(object->lock_increment));
	return py_lock_increment;
}

static int py_wkssvc_NetWkstaInfo502_set_lock_increment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_increment");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lock_increment));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lock_increment = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_lock_maximum(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_maximum;
	py_lock_maximum = PyLong_FromUnsignedLongLong((uint32_t)(object->lock_maximum));
	return py_lock_maximum;
}

static int py_wkssvc_NetWkstaInfo502_set_lock_maximum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_maximum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lock_maximum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lock_maximum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_pipe_increment(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_pipe_increment;
	py_pipe_increment = PyLong_FromUnsignedLongLong((uint32_t)(object->pipe_increment));
	return py_pipe_increment;
}

static int py_wkssvc_NetWkstaInfo502_set_pipe_increment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pipe_increment");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pipe_increment));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pipe_increment = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_pipe_maximum(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_pipe_maximum;
	py_pipe_maximum = PyLong_FromUnsignedLongLong((uint32_t)(object->pipe_maximum));
	return py_pipe_maximum;
}

static int py_wkssvc_NetWkstaInfo502_set_pipe_maximum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pipe_maximum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pipe_maximum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pipe_maximum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_cache_file_timeout(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_cache_file_timeout;
	py_cache_file_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->cache_file_timeout));
	return py_cache_file_timeout;
}

static int py_wkssvc_NetWkstaInfo502_set_cache_file_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cache_file_timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cache_file_timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cache_file_timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_dormant_file_limit(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_dormant_file_limit;
	py_dormant_file_limit = PyLong_FromUnsignedLongLong((uint32_t)(object->dormant_file_limit));
	return py_dormant_file_limit;
}

static int py_wkssvc_NetWkstaInfo502_set_dormant_file_limit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dormant_file_limit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dormant_file_limit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dormant_file_limit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_read_ahead_throughput(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_read_ahead_throughput;
	py_read_ahead_throughput = PyLong_FromUnsignedLongLong((uint32_t)(object->read_ahead_throughput));
	return py_read_ahead_throughput;
}

static int py_wkssvc_NetWkstaInfo502_set_read_ahead_throughput(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->read_ahead_throughput");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->read_ahead_throughput));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->read_ahead_throughput = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_num_mailslot_buffers(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_mailslot_buffers;
	py_num_mailslot_buffers = PyLong_FromUnsignedLongLong((uint32_t)(object->num_mailslot_buffers));
	return py_num_mailslot_buffers;
}

static int py_wkssvc_NetWkstaInfo502_set_num_mailslot_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_mailslot_buffers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_mailslot_buffers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_mailslot_buffers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_num_srv_announce_buffers(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_srv_announce_buffers;
	py_num_srv_announce_buffers = PyLong_FromUnsignedLongLong((uint32_t)(object->num_srv_announce_buffers));
	return py_num_srv_announce_buffers;
}

static int py_wkssvc_NetWkstaInfo502_set_num_srv_announce_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_srv_announce_buffers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_srv_announce_buffers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_srv_announce_buffers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_max_illegal_dgram_events(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_illegal_dgram_events;
	py_max_illegal_dgram_events = PyLong_FromUnsignedLongLong((uint32_t)(object->max_illegal_dgram_events));
	return py_max_illegal_dgram_events;
}

static int py_wkssvc_NetWkstaInfo502_set_max_illegal_dgram_events(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->max_illegal_dgram_events");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_illegal_dgram_events));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_illegal_dgram_events = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_dgram_event_reset_freq(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_dgram_event_reset_freq;
	py_dgram_event_reset_freq = PyLong_FromUnsignedLongLong((uint32_t)(object->dgram_event_reset_freq));
	return py_dgram_event_reset_freq;
}

static int py_wkssvc_NetWkstaInfo502_set_dgram_event_reset_freq(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dgram_event_reset_freq");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dgram_event_reset_freq));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dgram_event_reset_freq = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_log_election_packets(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_log_election_packets;
	py_log_election_packets = PyLong_FromUnsignedLongLong((uint32_t)(object->log_election_packets));
	return py_log_election_packets;
}

static int py_wkssvc_NetWkstaInfo502_set_log_election_packets(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->log_election_packets");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->log_election_packets));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->log_election_packets = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_opportunistic_locking(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_opportunistic_locking;
	py_use_opportunistic_locking = PyLong_FromUnsignedLongLong((uint32_t)(object->use_opportunistic_locking));
	return py_use_opportunistic_locking;
}

static int py_wkssvc_NetWkstaInfo502_set_use_opportunistic_locking(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_opportunistic_locking");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_opportunistic_locking));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_opportunistic_locking = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_unlock_behind(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_unlock_behind;
	py_use_unlock_behind = PyLong_FromUnsignedLongLong((uint32_t)(object->use_unlock_behind));
	return py_use_unlock_behind;
}

static int py_wkssvc_NetWkstaInfo502_set_use_unlock_behind(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_unlock_behind");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_unlock_behind));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_unlock_behind = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_close_behind(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_close_behind;
	py_use_close_behind = PyLong_FromUnsignedLongLong((uint32_t)(object->use_close_behind));
	return py_use_close_behind;
}

static int py_wkssvc_NetWkstaInfo502_set_use_close_behind(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_close_behind");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_close_behind));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_close_behind = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_buf_named_pipes(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_named_pipes;
	py_buf_named_pipes = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_named_pipes));
	return py_buf_named_pipes;
}

static int py_wkssvc_NetWkstaInfo502_set_buf_named_pipes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->buf_named_pipes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_named_pipes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_named_pipes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_lock_read_unlock(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_lock_read_unlock;
	py_use_lock_read_unlock = PyLong_FromUnsignedLongLong((uint32_t)(object->use_lock_read_unlock));
	return py_use_lock_read_unlock;
}

static int py_wkssvc_NetWkstaInfo502_set_use_lock_read_unlock(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_lock_read_unlock");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_lock_read_unlock));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_lock_read_unlock = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_utilize_nt_caching(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_utilize_nt_caching;
	py_utilize_nt_caching = PyLong_FromUnsignedLongLong((uint32_t)(object->utilize_nt_caching));
	return py_utilize_nt_caching;
}

static int py_wkssvc_NetWkstaInfo502_set_utilize_nt_caching(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->utilize_nt_caching");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->utilize_nt_caching));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->utilize_nt_caching = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_raw_read(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_raw_read;
	py_use_raw_read = PyLong_FromUnsignedLongLong((uint32_t)(object->use_raw_read));
	return py_use_raw_read;
}

static int py_wkssvc_NetWkstaInfo502_set_use_raw_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_raw_read");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_raw_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_raw_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_raw_write(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_raw_write;
	py_use_raw_write = PyLong_FromUnsignedLongLong((uint32_t)(object->use_raw_write));
	return py_use_raw_write;
}

static int py_wkssvc_NetWkstaInfo502_set_use_raw_write(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_raw_write");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_raw_write));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_raw_write = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_write_raw_data(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_write_raw_data;
	py_use_write_raw_data = PyLong_FromUnsignedLongLong((uint32_t)(object->use_write_raw_data));
	return py_use_write_raw_data;
}

static int py_wkssvc_NetWkstaInfo502_set_use_write_raw_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_write_raw_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_write_raw_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_write_raw_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_encryption(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_encryption;
	py_use_encryption = PyLong_FromUnsignedLongLong((uint32_t)(object->use_encryption));
	return py_use_encryption;
}

static int py_wkssvc_NetWkstaInfo502_set_use_encryption(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_encryption");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_encryption));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_encryption = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_buf_files_deny_write(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_files_deny_write;
	py_buf_files_deny_write = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_files_deny_write));
	return py_buf_files_deny_write;
}

static int py_wkssvc_NetWkstaInfo502_set_buf_files_deny_write(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->buf_files_deny_write");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_files_deny_write));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_files_deny_write = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_buf_read_only_files(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_read_only_files;
	py_buf_read_only_files = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_read_only_files));
	return py_buf_read_only_files;
}

static int py_wkssvc_NetWkstaInfo502_set_buf_read_only_files(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->buf_read_only_files");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_read_only_files));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_read_only_files = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_force_core_create_mode(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_force_core_create_mode;
	py_force_core_create_mode = PyLong_FromUnsignedLongLong((uint32_t)(object->force_core_create_mode));
	return py_force_core_create_mode;
}

static int py_wkssvc_NetWkstaInfo502_set_force_core_create_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->force_core_create_mode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_core_create_mode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_core_create_mode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaInfo502_get_use_512_byte_max_transfer(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_512_byte_max_transfer;
	py_use_512_byte_max_transfer = PyLong_FromUnsignedLongLong((uint32_t)(object->use_512_byte_max_transfer));
	return py_use_512_byte_max_transfer;
}

static int py_wkssvc_NetWkstaInfo502_set_use_512_byte_max_transfer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_512_byte_max_transfer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_512_byte_max_transfer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_512_byte_max_transfer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo502_getsetters[] = {
	{
		.name = discard_const_p(char, "char_wait"),
		.get = py_wkssvc_NetWkstaInfo502_get_char_wait,
		.set = py_wkssvc_NetWkstaInfo502_set_char_wait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "collection_time"),
		.get = py_wkssvc_NetWkstaInfo502_get_collection_time,
		.set = py_wkssvc_NetWkstaInfo502_set_collection_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maximum_collection_count"),
		.get = py_wkssvc_NetWkstaInfo502_get_maximum_collection_count,
		.set = py_wkssvc_NetWkstaInfo502_set_maximum_collection_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "keep_connection"),
		.get = py_wkssvc_NetWkstaInfo502_get_keep_connection,
		.set = py_wkssvc_NetWkstaInfo502_set_keep_connection,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_commands"),
		.get = py_wkssvc_NetWkstaInfo502_get_max_commands,
		.set = py_wkssvc_NetWkstaInfo502_set_max_commands,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "session_timeout"),
		.get = py_wkssvc_NetWkstaInfo502_get_session_timeout,
		.set = py_wkssvc_NetWkstaInfo502_set_session_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "size_char_buf"),
		.get = py_wkssvc_NetWkstaInfo502_get_size_char_buf,
		.set = py_wkssvc_NetWkstaInfo502_set_size_char_buf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_threads"),
		.get = py_wkssvc_NetWkstaInfo502_get_max_threads,
		.set = py_wkssvc_NetWkstaInfo502_set_max_threads,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lock_quota"),
		.get = py_wkssvc_NetWkstaInfo502_get_lock_quota,
		.set = py_wkssvc_NetWkstaInfo502_set_lock_quota,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lock_increment"),
		.get = py_wkssvc_NetWkstaInfo502_get_lock_increment,
		.set = py_wkssvc_NetWkstaInfo502_set_lock_increment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lock_maximum"),
		.get = py_wkssvc_NetWkstaInfo502_get_lock_maximum,
		.set = py_wkssvc_NetWkstaInfo502_set_lock_maximum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pipe_increment"),
		.get = py_wkssvc_NetWkstaInfo502_get_pipe_increment,
		.set = py_wkssvc_NetWkstaInfo502_set_pipe_increment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pipe_maximum"),
		.get = py_wkssvc_NetWkstaInfo502_get_pipe_maximum,
		.set = py_wkssvc_NetWkstaInfo502_set_pipe_maximum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cache_file_timeout"),
		.get = py_wkssvc_NetWkstaInfo502_get_cache_file_timeout,
		.set = py_wkssvc_NetWkstaInfo502_set_cache_file_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dormant_file_limit"),
		.get = py_wkssvc_NetWkstaInfo502_get_dormant_file_limit,
		.set = py_wkssvc_NetWkstaInfo502_set_dormant_file_limit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "read_ahead_throughput"),
		.get = py_wkssvc_NetWkstaInfo502_get_read_ahead_throughput,
		.set = py_wkssvc_NetWkstaInfo502_set_read_ahead_throughput,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_mailslot_buffers"),
		.get = py_wkssvc_NetWkstaInfo502_get_num_mailslot_buffers,
		.set = py_wkssvc_NetWkstaInfo502_set_num_mailslot_buffers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_srv_announce_buffers"),
		.get = py_wkssvc_NetWkstaInfo502_get_num_srv_announce_buffers,
		.set = py_wkssvc_NetWkstaInfo502_set_num_srv_announce_buffers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_illegal_dgram_events"),
		.get = py_wkssvc_NetWkstaInfo502_get_max_illegal_dgram_events,
		.set = py_wkssvc_NetWkstaInfo502_set_max_illegal_dgram_events,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dgram_event_reset_freq"),
		.get = py_wkssvc_NetWkstaInfo502_get_dgram_event_reset_freq,
		.set = py_wkssvc_NetWkstaInfo502_set_dgram_event_reset_freq,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "log_election_packets"),
		.get = py_wkssvc_NetWkstaInfo502_get_log_election_packets,
		.set = py_wkssvc_NetWkstaInfo502_set_log_election_packets,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_opportunistic_locking"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_opportunistic_locking,
		.set = py_wkssvc_NetWkstaInfo502_set_use_opportunistic_locking,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_unlock_behind"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_unlock_behind,
		.set = py_wkssvc_NetWkstaInfo502_set_use_unlock_behind,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_close_behind"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_close_behind,
		.set = py_wkssvc_NetWkstaInfo502_set_use_close_behind,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buf_named_pipes"),
		.get = py_wkssvc_NetWkstaInfo502_get_buf_named_pipes,
		.set = py_wkssvc_NetWkstaInfo502_set_buf_named_pipes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_lock_read_unlock"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_lock_read_unlock,
		.set = py_wkssvc_NetWkstaInfo502_set_use_lock_read_unlock,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "utilize_nt_caching"),
		.get = py_wkssvc_NetWkstaInfo502_get_utilize_nt_caching,
		.set = py_wkssvc_NetWkstaInfo502_set_utilize_nt_caching,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_raw_read"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_raw_read,
		.set = py_wkssvc_NetWkstaInfo502_set_use_raw_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_raw_write"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_raw_write,
		.set = py_wkssvc_NetWkstaInfo502_set_use_raw_write,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_write_raw_data"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_write_raw_data,
		.set = py_wkssvc_NetWkstaInfo502_set_use_write_raw_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_encryption"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_encryption,
		.set = py_wkssvc_NetWkstaInfo502_set_use_encryption,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buf_files_deny_write"),
		.get = py_wkssvc_NetWkstaInfo502_get_buf_files_deny_write,
		.set = py_wkssvc_NetWkstaInfo502_set_buf_files_deny_write,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buf_read_only_files"),
		.get = py_wkssvc_NetWkstaInfo502_get_buf_read_only_files,
		.set = py_wkssvc_NetWkstaInfo502_set_buf_read_only_files,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "force_core_create_mode"),
		.get = py_wkssvc_NetWkstaInfo502_get_force_core_create_mode,
		.set = py_wkssvc_NetWkstaInfo502_set_force_core_create_mode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_512_byte_max_transfer"),
		.get = py_wkssvc_NetWkstaInfo502_get_use_512_byte_max_transfer,
		.set = py_wkssvc_NetWkstaInfo502_set_use_512_byte_max_transfer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo502_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo502, type);
}


static PyTypeObject wkssvc_NetWkstaInfo502_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo502",
	.tp_getset = py_wkssvc_NetWkstaInfo502_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo502_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1010_get_char_wait(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1010 *object = pytalloc_get_ptr(obj);
	PyObject *py_char_wait;
	py_char_wait = PyLong_FromUnsignedLongLong((uint32_t)(object->char_wait));
	return py_char_wait;
}

static int py_wkssvc_NetWkstaInfo1010_set_char_wait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1010 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->char_wait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->char_wait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->char_wait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1010_getsetters[] = {
	{
		.name = discard_const_p(char, "char_wait"),
		.get = py_wkssvc_NetWkstaInfo1010_get_char_wait,
		.set = py_wkssvc_NetWkstaInfo1010_set_char_wait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1010_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1010, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1010_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1010",
	.tp_getset = py_wkssvc_NetWkstaInfo1010_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1010_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1011_get_collection_time(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1011 *object = pytalloc_get_ptr(obj);
	PyObject *py_collection_time;
	py_collection_time = PyLong_FromUnsignedLongLong((uint32_t)(object->collection_time));
	return py_collection_time;
}

static int py_wkssvc_NetWkstaInfo1011_set_collection_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1011 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->collection_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->collection_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->collection_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1011_getsetters[] = {
	{
		.name = discard_const_p(char, "collection_time"),
		.get = py_wkssvc_NetWkstaInfo1011_get_collection_time,
		.set = py_wkssvc_NetWkstaInfo1011_set_collection_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1011_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1011, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1011_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1011",
	.tp_getset = py_wkssvc_NetWkstaInfo1011_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1011_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1012_get_maximum_collection_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1012 *object = pytalloc_get_ptr(obj);
	PyObject *py_maximum_collection_count;
	py_maximum_collection_count = PyLong_FromUnsignedLongLong((uint32_t)(object->maximum_collection_count));
	return py_maximum_collection_count;
}

static int py_wkssvc_NetWkstaInfo1012_set_maximum_collection_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1012 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->maximum_collection_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maximum_collection_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maximum_collection_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1012_getsetters[] = {
	{
		.name = discard_const_p(char, "maximum_collection_count"),
		.get = py_wkssvc_NetWkstaInfo1012_get_maximum_collection_count,
		.set = py_wkssvc_NetWkstaInfo1012_set_maximum_collection_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1012_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1012, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1012_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1012",
	.tp_getset = py_wkssvc_NetWkstaInfo1012_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1012_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1013_get_keep_connection(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1013 *object = pytalloc_get_ptr(obj);
	PyObject *py_keep_connection;
	py_keep_connection = PyLong_FromUnsignedLongLong((uint32_t)(object->keep_connection));
	return py_keep_connection;
}

static int py_wkssvc_NetWkstaInfo1013_set_keep_connection(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1013 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->keep_connection");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->keep_connection));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->keep_connection = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1013_getsetters[] = {
	{
		.name = discard_const_p(char, "keep_connection"),
		.get = py_wkssvc_NetWkstaInfo1013_get_keep_connection,
		.set = py_wkssvc_NetWkstaInfo1013_set_keep_connection,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1013_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1013, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1013_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1013",
	.tp_getset = py_wkssvc_NetWkstaInfo1013_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1013_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1018_get_session_timeout(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1018 *object = pytalloc_get_ptr(obj);
	PyObject *py_session_timeout;
	py_session_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->session_timeout));
	return py_session_timeout;
}

static int py_wkssvc_NetWkstaInfo1018_set_session_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1018 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->session_timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->session_timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->session_timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1018_getsetters[] = {
	{
		.name = discard_const_p(char, "session_timeout"),
		.get = py_wkssvc_NetWkstaInfo1018_get_session_timeout,
		.set = py_wkssvc_NetWkstaInfo1018_set_session_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1018_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1018, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1018_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1018",
	.tp_getset = py_wkssvc_NetWkstaInfo1018_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1018_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1023_get_size_char_buf(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1023 *object = pytalloc_get_ptr(obj);
	PyObject *py_size_char_buf;
	py_size_char_buf = PyLong_FromUnsignedLongLong((uint32_t)(object->size_char_buf));
	return py_size_char_buf;
}

static int py_wkssvc_NetWkstaInfo1023_set_size_char_buf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1023 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size_char_buf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size_char_buf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size_char_buf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1023_getsetters[] = {
	{
		.name = discard_const_p(char, "size_char_buf"),
		.get = py_wkssvc_NetWkstaInfo1023_get_size_char_buf,
		.set = py_wkssvc_NetWkstaInfo1023_set_size_char_buf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1023_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1023, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1023_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1023",
	.tp_getset = py_wkssvc_NetWkstaInfo1023_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1023_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1027_get_errorlog_sz(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1027 *object = pytalloc_get_ptr(obj);
	PyObject *py_errorlog_sz;
	py_errorlog_sz = PyLong_FromUnsignedLongLong((uint32_t)(object->errorlog_sz));
	return py_errorlog_sz;
}

static int py_wkssvc_NetWkstaInfo1027_set_errorlog_sz(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1027 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->errorlog_sz");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->errorlog_sz));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->errorlog_sz = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1027_getsetters[] = {
	{
		.name = discard_const_p(char, "errorlog_sz"),
		.get = py_wkssvc_NetWkstaInfo1027_get_errorlog_sz,
		.set = py_wkssvc_NetWkstaInfo1027_set_errorlog_sz,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1027_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1027, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1027_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1027",
	.tp_getset = py_wkssvc_NetWkstaInfo1027_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1027_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1028_get_print_buf_time(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1028 *object = pytalloc_get_ptr(obj);
	PyObject *py_print_buf_time;
	py_print_buf_time = PyLong_FromUnsignedLongLong((uint32_t)(object->print_buf_time));
	return py_print_buf_time;
}

static int py_wkssvc_NetWkstaInfo1028_set_print_buf_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1028 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->print_buf_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->print_buf_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->print_buf_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1028_getsetters[] = {
	{
		.name = discard_const_p(char, "print_buf_time"),
		.get = py_wkssvc_NetWkstaInfo1028_get_print_buf_time,
		.set = py_wkssvc_NetWkstaInfo1028_set_print_buf_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1028_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1028, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1028_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1028",
	.tp_getset = py_wkssvc_NetWkstaInfo1028_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1028_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1032_get_wrk_heuristics(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1032 *object = pytalloc_get_ptr(obj);
	PyObject *py_wrk_heuristics;
	py_wrk_heuristics = PyLong_FromUnsignedLongLong((uint32_t)(object->wrk_heuristics));
	return py_wrk_heuristics;
}

static int py_wkssvc_NetWkstaInfo1032_set_wrk_heuristics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1032 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wrk_heuristics");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wrk_heuristics));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wrk_heuristics = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1032_getsetters[] = {
	{
		.name = discard_const_p(char, "wrk_heuristics"),
		.get = py_wkssvc_NetWkstaInfo1032_get_wrk_heuristics,
		.set = py_wkssvc_NetWkstaInfo1032_set_wrk_heuristics,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1032_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1032, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1032_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1032",
	.tp_getset = py_wkssvc_NetWkstaInfo1032_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1032_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1033_get_max_threads(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1033 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_threads;
	py_max_threads = PyLong_FromUnsignedLongLong((uint32_t)(object->max_threads));
	return py_max_threads;
}

static int py_wkssvc_NetWkstaInfo1033_set_max_threads(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1033 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->max_threads");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_threads));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_threads = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1033_getsetters[] = {
	{
		.name = discard_const_p(char, "max_threads"),
		.get = py_wkssvc_NetWkstaInfo1033_get_max_threads,
		.set = py_wkssvc_NetWkstaInfo1033_set_max_threads,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1033_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1033, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1033_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1033",
	.tp_getset = py_wkssvc_NetWkstaInfo1033_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1033_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1041_get_lock_quota(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1041 *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_quota;
	py_lock_quota = PyLong_FromUnsignedLongLong((uint32_t)(object->lock_quota));
	return py_lock_quota;
}

static int py_wkssvc_NetWkstaInfo1041_set_lock_quota(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1041 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_quota");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lock_quota));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lock_quota = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1041_getsetters[] = {
	{
		.name = discard_const_p(char, "lock_quota"),
		.get = py_wkssvc_NetWkstaInfo1041_get_lock_quota,
		.set = py_wkssvc_NetWkstaInfo1041_set_lock_quota,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1041_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1041, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1041_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1041",
	.tp_getset = py_wkssvc_NetWkstaInfo1041_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1041_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1042_get_lock_increment(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1042 *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_increment;
	py_lock_increment = PyLong_FromUnsignedLongLong((uint32_t)(object->lock_increment));
	return py_lock_increment;
}

static int py_wkssvc_NetWkstaInfo1042_set_lock_increment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1042 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_increment");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lock_increment));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lock_increment = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1042_getsetters[] = {
	{
		.name = discard_const_p(char, "lock_increment"),
		.get = py_wkssvc_NetWkstaInfo1042_get_lock_increment,
		.set = py_wkssvc_NetWkstaInfo1042_set_lock_increment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1042_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1042, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1042_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1042",
	.tp_getset = py_wkssvc_NetWkstaInfo1042_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1042_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1043_get_lock_maximum(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1043 *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_maximum;
	py_lock_maximum = PyLong_FromUnsignedLongLong((uint32_t)(object->lock_maximum));
	return py_lock_maximum;
}

static int py_wkssvc_NetWkstaInfo1043_set_lock_maximum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1043 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_maximum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lock_maximum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lock_maximum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1043_getsetters[] = {
	{
		.name = discard_const_p(char, "lock_maximum"),
		.get = py_wkssvc_NetWkstaInfo1043_get_lock_maximum,
		.set = py_wkssvc_NetWkstaInfo1043_set_lock_maximum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1043_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1043, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1043_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1043",
	.tp_getset = py_wkssvc_NetWkstaInfo1043_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1043_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1044_get_pipe_increment(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1044 *object = pytalloc_get_ptr(obj);
	PyObject *py_pipe_increment;
	py_pipe_increment = PyLong_FromUnsignedLongLong((uint32_t)(object->pipe_increment));
	return py_pipe_increment;
}

static int py_wkssvc_NetWkstaInfo1044_set_pipe_increment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1044 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pipe_increment");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pipe_increment));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pipe_increment = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1044_getsetters[] = {
	{
		.name = discard_const_p(char, "pipe_increment"),
		.get = py_wkssvc_NetWkstaInfo1044_get_pipe_increment,
		.set = py_wkssvc_NetWkstaInfo1044_set_pipe_increment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1044_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1044, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1044_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1044",
	.tp_getset = py_wkssvc_NetWkstaInfo1044_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1044_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1045_get_pipe_maximum(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1045 *object = pytalloc_get_ptr(obj);
	PyObject *py_pipe_maximum;
	py_pipe_maximum = PyLong_FromUnsignedLongLong((uint32_t)(object->pipe_maximum));
	return py_pipe_maximum;
}

static int py_wkssvc_NetWkstaInfo1045_set_pipe_maximum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1045 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pipe_maximum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pipe_maximum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pipe_maximum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1045_getsetters[] = {
	{
		.name = discard_const_p(char, "pipe_maximum"),
		.get = py_wkssvc_NetWkstaInfo1045_get_pipe_maximum,
		.set = py_wkssvc_NetWkstaInfo1045_set_pipe_maximum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1045_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1045, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1045_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1045",
	.tp_getset = py_wkssvc_NetWkstaInfo1045_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1045_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1046_get_dormant_file_limit(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1046 *object = pytalloc_get_ptr(obj);
	PyObject *py_dormant_file_limit;
	py_dormant_file_limit = PyLong_FromUnsignedLongLong((uint32_t)(object->dormant_file_limit));
	return py_dormant_file_limit;
}

static int py_wkssvc_NetWkstaInfo1046_set_dormant_file_limit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1046 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dormant_file_limit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dormant_file_limit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dormant_file_limit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1046_getsetters[] = {
	{
		.name = discard_const_p(char, "dormant_file_limit"),
		.get = py_wkssvc_NetWkstaInfo1046_get_dormant_file_limit,
		.set = py_wkssvc_NetWkstaInfo1046_set_dormant_file_limit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1046_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1046, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1046_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1046",
	.tp_getset = py_wkssvc_NetWkstaInfo1046_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1046_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1047_get_cache_file_timeout(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1047 *object = pytalloc_get_ptr(obj);
	PyObject *py_cache_file_timeout;
	py_cache_file_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->cache_file_timeout));
	return py_cache_file_timeout;
}

static int py_wkssvc_NetWkstaInfo1047_set_cache_file_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1047 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cache_file_timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cache_file_timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cache_file_timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1047_getsetters[] = {
	{
		.name = discard_const_p(char, "cache_file_timeout"),
		.get = py_wkssvc_NetWkstaInfo1047_get_cache_file_timeout,
		.set = py_wkssvc_NetWkstaInfo1047_set_cache_file_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1047_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1047, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1047_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1047",
	.tp_getset = py_wkssvc_NetWkstaInfo1047_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1047_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1048_get_use_opportunistic_locking(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1048 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_opportunistic_locking;
	py_use_opportunistic_locking = PyLong_FromUnsignedLongLong((uint32_t)(object->use_opportunistic_locking));
	return py_use_opportunistic_locking;
}

static int py_wkssvc_NetWkstaInfo1048_set_use_opportunistic_locking(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1048 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_opportunistic_locking");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_opportunistic_locking));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_opportunistic_locking = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1048_getsetters[] = {
	{
		.name = discard_const_p(char, "use_opportunistic_locking"),
		.get = py_wkssvc_NetWkstaInfo1048_get_use_opportunistic_locking,
		.set = py_wkssvc_NetWkstaInfo1048_set_use_opportunistic_locking,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1048_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1048, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1048_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1048",
	.tp_getset = py_wkssvc_NetWkstaInfo1048_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1048_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1049_get_use_unlock_behind(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1049 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_unlock_behind;
	py_use_unlock_behind = PyLong_FromUnsignedLongLong((uint32_t)(object->use_unlock_behind));
	return py_use_unlock_behind;
}

static int py_wkssvc_NetWkstaInfo1049_set_use_unlock_behind(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1049 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_unlock_behind");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_unlock_behind));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_unlock_behind = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1049_getsetters[] = {
	{
		.name = discard_const_p(char, "use_unlock_behind"),
		.get = py_wkssvc_NetWkstaInfo1049_get_use_unlock_behind,
		.set = py_wkssvc_NetWkstaInfo1049_set_use_unlock_behind,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1049_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1049, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1049_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1049",
	.tp_getset = py_wkssvc_NetWkstaInfo1049_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1049_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1050_get_use_close_behind(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1050 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_close_behind;
	py_use_close_behind = PyLong_FromUnsignedLongLong((uint32_t)(object->use_close_behind));
	return py_use_close_behind;
}

static int py_wkssvc_NetWkstaInfo1050_set_use_close_behind(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1050 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_close_behind");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_close_behind));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_close_behind = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1050_getsetters[] = {
	{
		.name = discard_const_p(char, "use_close_behind"),
		.get = py_wkssvc_NetWkstaInfo1050_get_use_close_behind,
		.set = py_wkssvc_NetWkstaInfo1050_set_use_close_behind,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1050_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1050, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1050_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1050",
	.tp_getset = py_wkssvc_NetWkstaInfo1050_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1050_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1051_get_buf_named_pipes(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1051 *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_named_pipes;
	py_buf_named_pipes = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_named_pipes));
	return py_buf_named_pipes;
}

static int py_wkssvc_NetWkstaInfo1051_set_buf_named_pipes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1051 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->buf_named_pipes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_named_pipes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_named_pipes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1051_getsetters[] = {
	{
		.name = discard_const_p(char, "buf_named_pipes"),
		.get = py_wkssvc_NetWkstaInfo1051_get_buf_named_pipes,
		.set = py_wkssvc_NetWkstaInfo1051_set_buf_named_pipes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1051_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1051, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1051_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1051",
	.tp_getset = py_wkssvc_NetWkstaInfo1051_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1051_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1052_get_use_lock_read_unlock(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1052 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_lock_read_unlock;
	py_use_lock_read_unlock = PyLong_FromUnsignedLongLong((uint32_t)(object->use_lock_read_unlock));
	return py_use_lock_read_unlock;
}

static int py_wkssvc_NetWkstaInfo1052_set_use_lock_read_unlock(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1052 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_lock_read_unlock");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_lock_read_unlock));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_lock_read_unlock = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1052_getsetters[] = {
	{
		.name = discard_const_p(char, "use_lock_read_unlock"),
		.get = py_wkssvc_NetWkstaInfo1052_get_use_lock_read_unlock,
		.set = py_wkssvc_NetWkstaInfo1052_set_use_lock_read_unlock,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1052_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1052, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1052_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1052",
	.tp_getset = py_wkssvc_NetWkstaInfo1052_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1052_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1053_get_utilize_nt_caching(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1053 *object = pytalloc_get_ptr(obj);
	PyObject *py_utilize_nt_caching;
	py_utilize_nt_caching = PyLong_FromUnsignedLongLong((uint32_t)(object->utilize_nt_caching));
	return py_utilize_nt_caching;
}

static int py_wkssvc_NetWkstaInfo1053_set_utilize_nt_caching(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1053 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->utilize_nt_caching");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->utilize_nt_caching));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->utilize_nt_caching = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1053_getsetters[] = {
	{
		.name = discard_const_p(char, "utilize_nt_caching"),
		.get = py_wkssvc_NetWkstaInfo1053_get_utilize_nt_caching,
		.set = py_wkssvc_NetWkstaInfo1053_set_utilize_nt_caching,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1053_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1053, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1053_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1053",
	.tp_getset = py_wkssvc_NetWkstaInfo1053_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1053_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1054_get_use_raw_read(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1054 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_raw_read;
	py_use_raw_read = PyLong_FromUnsignedLongLong((uint32_t)(object->use_raw_read));
	return py_use_raw_read;
}

static int py_wkssvc_NetWkstaInfo1054_set_use_raw_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1054 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_raw_read");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_raw_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_raw_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1054_getsetters[] = {
	{
		.name = discard_const_p(char, "use_raw_read"),
		.get = py_wkssvc_NetWkstaInfo1054_get_use_raw_read,
		.set = py_wkssvc_NetWkstaInfo1054_set_use_raw_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1054_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1054, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1054_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1054",
	.tp_getset = py_wkssvc_NetWkstaInfo1054_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1054_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1055_get_use_raw_write(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1055 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_raw_write;
	py_use_raw_write = PyLong_FromUnsignedLongLong((uint32_t)(object->use_raw_write));
	return py_use_raw_write;
}

static int py_wkssvc_NetWkstaInfo1055_set_use_raw_write(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1055 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_raw_write");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_raw_write));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_raw_write = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1055_getsetters[] = {
	{
		.name = discard_const_p(char, "use_raw_write"),
		.get = py_wkssvc_NetWkstaInfo1055_get_use_raw_write,
		.set = py_wkssvc_NetWkstaInfo1055_set_use_raw_write,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1055_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1055, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1055_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1055",
	.tp_getset = py_wkssvc_NetWkstaInfo1055_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1055_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1056_get_use_write_raw_data(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1056 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_write_raw_data;
	py_use_write_raw_data = PyLong_FromUnsignedLongLong((uint32_t)(object->use_write_raw_data));
	return py_use_write_raw_data;
}

static int py_wkssvc_NetWkstaInfo1056_set_use_write_raw_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1056 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_write_raw_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_write_raw_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_write_raw_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1056_getsetters[] = {
	{
		.name = discard_const_p(char, "use_write_raw_data"),
		.get = py_wkssvc_NetWkstaInfo1056_get_use_write_raw_data,
		.set = py_wkssvc_NetWkstaInfo1056_set_use_write_raw_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1056_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1056, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1056_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1056",
	.tp_getset = py_wkssvc_NetWkstaInfo1056_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1056_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1057_get_use_encryption(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1057 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_encryption;
	py_use_encryption = PyLong_FromUnsignedLongLong((uint32_t)(object->use_encryption));
	return py_use_encryption;
}

static int py_wkssvc_NetWkstaInfo1057_set_use_encryption(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1057 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_encryption");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_encryption));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_encryption = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1057_getsetters[] = {
	{
		.name = discard_const_p(char, "use_encryption"),
		.get = py_wkssvc_NetWkstaInfo1057_get_use_encryption,
		.set = py_wkssvc_NetWkstaInfo1057_set_use_encryption,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1057_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1057, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1057_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1057",
	.tp_getset = py_wkssvc_NetWkstaInfo1057_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1057_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1058_get_buf_files_deny_write(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1058 *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_files_deny_write;
	py_buf_files_deny_write = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_files_deny_write));
	return py_buf_files_deny_write;
}

static int py_wkssvc_NetWkstaInfo1058_set_buf_files_deny_write(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1058 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->buf_files_deny_write");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_files_deny_write));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_files_deny_write = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1058_getsetters[] = {
	{
		.name = discard_const_p(char, "buf_files_deny_write"),
		.get = py_wkssvc_NetWkstaInfo1058_get_buf_files_deny_write,
		.set = py_wkssvc_NetWkstaInfo1058_set_buf_files_deny_write,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1058_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1058, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1058_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1058",
	.tp_getset = py_wkssvc_NetWkstaInfo1058_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1058_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1059_get_buf_read_only_files(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1059 *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_read_only_files;
	py_buf_read_only_files = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_read_only_files));
	return py_buf_read_only_files;
}

static int py_wkssvc_NetWkstaInfo1059_set_buf_read_only_files(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1059 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->buf_read_only_files");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_read_only_files));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_read_only_files = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1059_getsetters[] = {
	{
		.name = discard_const_p(char, "buf_read_only_files"),
		.get = py_wkssvc_NetWkstaInfo1059_get_buf_read_only_files,
		.set = py_wkssvc_NetWkstaInfo1059_set_buf_read_only_files,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1059_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1059, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1059_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1059",
	.tp_getset = py_wkssvc_NetWkstaInfo1059_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1059_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1060_get_force_core_create_mode(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1060 *object = pytalloc_get_ptr(obj);
	PyObject *py_force_core_create_mode;
	py_force_core_create_mode = PyLong_FromUnsignedLongLong((uint32_t)(object->force_core_create_mode));
	return py_force_core_create_mode;
}

static int py_wkssvc_NetWkstaInfo1060_set_force_core_create_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1060 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->force_core_create_mode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_core_create_mode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_core_create_mode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1060_getsetters[] = {
	{
		.name = discard_const_p(char, "force_core_create_mode"),
		.get = py_wkssvc_NetWkstaInfo1060_get_force_core_create_mode,
		.set = py_wkssvc_NetWkstaInfo1060_set_force_core_create_mode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1060_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1060, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1060_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1060",
	.tp_getset = py_wkssvc_NetWkstaInfo1060_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1060_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1061_get_use_512_byte_max_transfer(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1061 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_512_byte_max_transfer;
	py_use_512_byte_max_transfer = PyLong_FromUnsignedLongLong((uint32_t)(object->use_512_byte_max_transfer));
	return py_use_512_byte_max_transfer;
}

static int py_wkssvc_NetWkstaInfo1061_set_use_512_byte_max_transfer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1061 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_512_byte_max_transfer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_512_byte_max_transfer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_512_byte_max_transfer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1061_getsetters[] = {
	{
		.name = discard_const_p(char, "use_512_byte_max_transfer"),
		.get = py_wkssvc_NetWkstaInfo1061_get_use_512_byte_max_transfer,
		.set = py_wkssvc_NetWkstaInfo1061_set_use_512_byte_max_transfer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1061_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1061, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1061_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1061",
	.tp_getset = py_wkssvc_NetWkstaInfo1061_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1061_new,
};


static PyObject *py_wkssvc_NetWkstaInfo1062_get_read_ahead_throughput(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaInfo1062 *object = pytalloc_get_ptr(obj);
	PyObject *py_read_ahead_throughput;
	py_read_ahead_throughput = PyLong_FromUnsignedLongLong((uint32_t)(object->read_ahead_throughput));
	return py_read_ahead_throughput;
}

static int py_wkssvc_NetWkstaInfo1062_set_read_ahead_throughput(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaInfo1062 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->read_ahead_throughput");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->read_ahead_throughput));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->read_ahead_throughput = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaInfo1062_getsetters[] = {
	{
		.name = discard_const_p(char, "read_ahead_throughput"),
		.get = py_wkssvc_NetWkstaInfo1062_get_read_ahead_throughput,
		.set = py_wkssvc_NetWkstaInfo1062_set_read_ahead_throughput,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo1062_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaInfo1062, type);
}


static PyTypeObject wkssvc_NetWkstaInfo1062_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo1062",
	.tp_getset = py_wkssvc_NetWkstaInfo1062_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo1062_new,
};

static PyObject *py_import_wkssvc_NetWkstaInfo(TALLOC_CTX *mem_ctx, int level, union wkssvc_NetWkstaInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 100:
			if (in->info100 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo100_Type, in->info100, in->info100);
			}
			return ret;

		case 101:
			if (in->info101 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo101_Type, in->info101, in->info101);
			}
			return ret;

		case 102:
			if (in->info102 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo102_Type, in->info102, in->info102);
			}
			return ret;

		case 502:
			if (in->info502 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo502_Type, in->info502, in->info502);
			}
			return ret;

		case 1010:
			if (in->info1010 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1010_Type, in->info1010, in->info1010);
			}
			return ret;

		case 1011:
			if (in->info1011 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1011_Type, in->info1011, in->info1011);
			}
			return ret;

		case 1012:
			if (in->info1012 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1012_Type, in->info1012, in->info1012);
			}
			return ret;

		case 1013:
			if (in->info1013 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1013_Type, in->info1013, in->info1013);
			}
			return ret;

		case 1018:
			if (in->info1018 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1018_Type, in->info1018, in->info1018);
			}
			return ret;

		case 1023:
			if (in->info1023 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1023_Type, in->info1023, in->info1023);
			}
			return ret;

		case 1027:
			if (in->info1027 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1027_Type, in->info1027, in->info1027);
			}
			return ret;

		case 1028:
			if (in->info1028 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1028_Type, in->info1028, in->info1028);
			}
			return ret;

		case 1032:
			if (in->info1032 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1032_Type, in->info1032, in->info1032);
			}
			return ret;

		case 1033:
			if (in->info1033 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1033_Type, in->info1033, in->info1033);
			}
			return ret;

		case 1041:
			if (in->info1041 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1041_Type, in->info1041, in->info1041);
			}
			return ret;

		case 1042:
			if (in->info1042 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1042_Type, in->info1042, in->info1042);
			}
			return ret;

		case 1043:
			if (in->info1043 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1043_Type, in->info1043, in->info1043);
			}
			return ret;

		case 1044:
			if (in->info1044 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1044_Type, in->info1044, in->info1044);
			}
			return ret;

		case 1045:
			if (in->info1045 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1045_Type, in->info1045, in->info1045);
			}
			return ret;

		case 1046:
			if (in->info1046 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1046_Type, in->info1046, in->info1046);
			}
			return ret;

		case 1047:
			if (in->info1047 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1047_Type, in->info1047, in->info1047);
			}
			return ret;

		case 1048:
			if (in->info1048 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1048_Type, in->info1048, in->info1048);
			}
			return ret;

		case 1049:
			if (in->info1049 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1049_Type, in->info1049, in->info1049);
			}
			return ret;

		case 1050:
			if (in->info1050 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1050_Type, in->info1050, in->info1050);
			}
			return ret;

		case 1051:
			if (in->info1051 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1051_Type, in->info1051, in->info1051);
			}
			return ret;

		case 1052:
			if (in->info1052 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1052_Type, in->info1052, in->info1052);
			}
			return ret;

		case 1053:
			if (in->info1053 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1053_Type, in->info1053, in->info1053);
			}
			return ret;

		case 1054:
			if (in->info1054 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1054_Type, in->info1054, in->info1054);
			}
			return ret;

		case 1055:
			if (in->info1055 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1055_Type, in->info1055, in->info1055);
			}
			return ret;

		case 1056:
			if (in->info1056 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1056_Type, in->info1056, in->info1056);
			}
			return ret;

		case 1057:
			if (in->info1057 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1057_Type, in->info1057, in->info1057);
			}
			return ret;

		case 1058:
			if (in->info1058 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1058_Type, in->info1058, in->info1058);
			}
			return ret;

		case 1059:
			if (in->info1059 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1059_Type, in->info1059, in->info1059);
			}
			return ret;

		case 1060:
			if (in->info1060 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1060_Type, in->info1060, in->info1060);
			}
			return ret;

		case 1061:
			if (in->info1061 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1061_Type, in->info1061, in->info1061);
			}
			return ret;

		case 1062:
			if (in->info1062 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaInfo1062_Type, in->info1062, in->info1062);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union wkssvc_NetWkstaInfo *py_export_wkssvc_NetWkstaInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union wkssvc_NetWkstaInfo *ret = talloc_zero(mem_ctx, union wkssvc_NetWkstaInfo);
	switch (level) {
		case 100:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info100");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info100 = NULL;
			} else {
				ret->info100 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo100_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info100 = (struct wkssvc_NetWkstaInfo100 *)pytalloc_get_ptr(in);
			}
			break;

		case 101:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info101");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info101 = NULL;
			} else {
				ret->info101 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo101_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info101 = (struct wkssvc_NetWkstaInfo101 *)pytalloc_get_ptr(in);
			}
			break;

		case 102:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info102");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info102 = NULL;
			} else {
				ret->info102 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo102_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info102 = (struct wkssvc_NetWkstaInfo102 *)pytalloc_get_ptr(in);
			}
			break;

		case 502:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info502");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info502 = NULL;
			} else {
				ret->info502 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo502_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info502 = (struct wkssvc_NetWkstaInfo502 *)pytalloc_get_ptr(in);
			}
			break;

		case 1010:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1010");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1010 = NULL;
			} else {
				ret->info1010 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1010_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1010 = (struct wkssvc_NetWkstaInfo1010 *)pytalloc_get_ptr(in);
			}
			break;

		case 1011:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1011");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1011 = NULL;
			} else {
				ret->info1011 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1011_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1011 = (struct wkssvc_NetWkstaInfo1011 *)pytalloc_get_ptr(in);
			}
			break;

		case 1012:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1012");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1012 = NULL;
			} else {
				ret->info1012 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1012_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1012 = (struct wkssvc_NetWkstaInfo1012 *)pytalloc_get_ptr(in);
			}
			break;

		case 1013:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1013");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1013 = NULL;
			} else {
				ret->info1013 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1013_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1013 = (struct wkssvc_NetWkstaInfo1013 *)pytalloc_get_ptr(in);
			}
			break;

		case 1018:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1018");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1018 = NULL;
			} else {
				ret->info1018 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1018_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1018 = (struct wkssvc_NetWkstaInfo1018 *)pytalloc_get_ptr(in);
			}
			break;

		case 1023:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1023");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1023 = NULL;
			} else {
				ret->info1023 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1023_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1023 = (struct wkssvc_NetWkstaInfo1023 *)pytalloc_get_ptr(in);
			}
			break;

		case 1027:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1027");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1027 = NULL;
			} else {
				ret->info1027 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1027_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1027 = (struct wkssvc_NetWkstaInfo1027 *)pytalloc_get_ptr(in);
			}
			break;

		case 1028:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1028");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1028 = NULL;
			} else {
				ret->info1028 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1028_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1028 = (struct wkssvc_NetWkstaInfo1028 *)pytalloc_get_ptr(in);
			}
			break;

		case 1032:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1032");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1032 = NULL;
			} else {
				ret->info1032 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1032_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1032 = (struct wkssvc_NetWkstaInfo1032 *)pytalloc_get_ptr(in);
			}
			break;

		case 1033:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1033");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1033 = NULL;
			} else {
				ret->info1033 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1033_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1033 = (struct wkssvc_NetWkstaInfo1033 *)pytalloc_get_ptr(in);
			}
			break;

		case 1041:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1041");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1041 = NULL;
			} else {
				ret->info1041 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1041_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1041 = (struct wkssvc_NetWkstaInfo1041 *)pytalloc_get_ptr(in);
			}
			break;

		case 1042:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1042");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1042 = NULL;
			} else {
				ret->info1042 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1042_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1042 = (struct wkssvc_NetWkstaInfo1042 *)pytalloc_get_ptr(in);
			}
			break;

		case 1043:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1043");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1043 = NULL;
			} else {
				ret->info1043 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1043_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1043 = (struct wkssvc_NetWkstaInfo1043 *)pytalloc_get_ptr(in);
			}
			break;

		case 1044:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1044");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1044 = NULL;
			} else {
				ret->info1044 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1044_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1044 = (struct wkssvc_NetWkstaInfo1044 *)pytalloc_get_ptr(in);
			}
			break;

		case 1045:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1045");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1045 = NULL;
			} else {
				ret->info1045 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1045_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1045 = (struct wkssvc_NetWkstaInfo1045 *)pytalloc_get_ptr(in);
			}
			break;

		case 1046:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1046");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1046 = NULL;
			} else {
				ret->info1046 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1046_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1046 = (struct wkssvc_NetWkstaInfo1046 *)pytalloc_get_ptr(in);
			}
			break;

		case 1047:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1047");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1047 = NULL;
			} else {
				ret->info1047 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1047_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1047 = (struct wkssvc_NetWkstaInfo1047 *)pytalloc_get_ptr(in);
			}
			break;

		case 1048:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1048");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1048 = NULL;
			} else {
				ret->info1048 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1048_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1048 = (struct wkssvc_NetWkstaInfo1048 *)pytalloc_get_ptr(in);
			}
			break;

		case 1049:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1049");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1049 = NULL;
			} else {
				ret->info1049 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1049_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1049 = (struct wkssvc_NetWkstaInfo1049 *)pytalloc_get_ptr(in);
			}
			break;

		case 1050:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1050");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1050 = NULL;
			} else {
				ret->info1050 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1050_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1050 = (struct wkssvc_NetWkstaInfo1050 *)pytalloc_get_ptr(in);
			}
			break;

		case 1051:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1051");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1051 = NULL;
			} else {
				ret->info1051 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1051_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1051 = (struct wkssvc_NetWkstaInfo1051 *)pytalloc_get_ptr(in);
			}
			break;

		case 1052:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1052");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1052 = NULL;
			} else {
				ret->info1052 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1052_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1052 = (struct wkssvc_NetWkstaInfo1052 *)pytalloc_get_ptr(in);
			}
			break;

		case 1053:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1053");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1053 = NULL;
			} else {
				ret->info1053 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1053_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1053 = (struct wkssvc_NetWkstaInfo1053 *)pytalloc_get_ptr(in);
			}
			break;

		case 1054:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1054");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1054 = NULL;
			} else {
				ret->info1054 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1054_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1054 = (struct wkssvc_NetWkstaInfo1054 *)pytalloc_get_ptr(in);
			}
			break;

		case 1055:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1055");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1055 = NULL;
			} else {
				ret->info1055 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1055_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1055 = (struct wkssvc_NetWkstaInfo1055 *)pytalloc_get_ptr(in);
			}
			break;

		case 1056:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1056");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1056 = NULL;
			} else {
				ret->info1056 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1056_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1056 = (struct wkssvc_NetWkstaInfo1056 *)pytalloc_get_ptr(in);
			}
			break;

		case 1057:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1057");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1057 = NULL;
			} else {
				ret->info1057 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1057_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1057 = (struct wkssvc_NetWkstaInfo1057 *)pytalloc_get_ptr(in);
			}
			break;

		case 1058:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1058");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1058 = NULL;
			} else {
				ret->info1058 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1058_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1058 = (struct wkssvc_NetWkstaInfo1058 *)pytalloc_get_ptr(in);
			}
			break;

		case 1059:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1059");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1059 = NULL;
			} else {
				ret->info1059 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1059_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1059 = (struct wkssvc_NetWkstaInfo1059 *)pytalloc_get_ptr(in);
			}
			break;

		case 1060:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1060");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1060 = NULL;
			} else {
				ret->info1060 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1060_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1060 = (struct wkssvc_NetWkstaInfo1060 *)pytalloc_get_ptr(in);
			}
			break;

		case 1061:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1061");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1061 = NULL;
			} else {
				ret->info1061 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1061_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1061 = (struct wkssvc_NetWkstaInfo1061 *)pytalloc_get_ptr(in);
			}
			break;

		case 1062:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1062");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1062 = NULL;
			} else {
				ret->info1062 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaInfo1062_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1062 = (struct wkssvc_NetWkstaInfo1062 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_wkssvc_NetWkstaInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union wkssvc_NetWkstaInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union wkssvc_NetWkstaInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union wkssvc_NetWkstaInfo!");
		return NULL;
	}

	return py_import_wkssvc_NetWkstaInfo(mem_ctx, level, in);
}

static PyObject *py_wkssvc_NetWkstaInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union wkssvc_NetWkstaInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_wkssvc_NetWkstaInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_wkssvc_NetWkstaInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_wkssvc_NetWkstaInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject wkssvc_NetWkstaInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaInfo",
	.tp_getset = NULL,
	.tp_methods = py_wkssvc_NetWkstaInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaInfo_new,
};


static PyObject *py_wkssvc_NetrWkstaUserInfo0_get_user_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	if (object->user_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user_name == NULL) {
		py_user_name = Py_None;
		Py_INCREF(py_user_name);
	} else {
		if (object->user_name == NULL) {
			py_user_name = Py_None;
			Py_INCREF(py_user_name);
		} else {
			py_user_name = PyUnicode_Decode(object->user_name, strlen(object->user_name), "utf-8", "ignore");
		}
	}
	return py_user_name;
}

static int py_wkssvc_NetrWkstaUserInfo0_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user_name");
		return -1;
	}
	if (value == Py_None) {
		object->user_name = NULL;
	} else {
		object->user_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user_name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWkstaUserInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_wkssvc_NetrWkstaUserInfo0_get_user_name,
		.set = py_wkssvc_NetrWkstaUserInfo0_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWkstaUserInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrWkstaUserInfo0, type);
}


static PyTypeObject wkssvc_NetrWkstaUserInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaUserInfo0",
	.tp_getset = py_wkssvc_NetrWkstaUserInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaUserInfo0_new,
};


static PyObject *py_wkssvc_NetWkstaEnumUsersCtr0_get_entries_read(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_entries_read;
	py_entries_read = PyLong_FromUnsignedLongLong((uint32_t)(object->entries_read));
	return py_entries_read;
}

static int py_wkssvc_NetWkstaEnumUsersCtr0_set_entries_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries_read");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->entries_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->entries_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsersCtr0_get_user0(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_user0;
	if (object->user0 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user0 == NULL) {
		py_user0 = Py_None;
		Py_INCREF(py_user0);
	} else {
		py_user0 = PyList_New(object->entries_read);
		if (py_user0 == NULL) {
			return NULL;
		}
		{
			int user0_cntr_1;
			for (user0_cntr_1 = 0; user0_cntr_1 < (object->entries_read); user0_cntr_1++) {
				PyObject *py_user0_1;
				py_user0_1 = pytalloc_reference_ex(&wkssvc_NetrWkstaUserInfo0_Type, object->user0, &(object->user0)[user0_cntr_1]);
				PyList_SetItem(py_user0, user0_cntr_1, py_user0_1);
			}
		}
	}
	return py_user0;
}

static int py_wkssvc_NetWkstaEnumUsersCtr0_set_user0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->user0));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user0");
		return -1;
	}
	if (value == Py_None) {
		object->user0 = NULL;
	} else {
		object->user0 = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int user0_cntr_1;
			object->user0 = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->user0, PyList_GET_SIZE(value));
			if (!object->user0) { return -1; }
			talloc_set_name_const(object->user0, "ARRAY: object->user0");
			for (user0_cntr_1 = 0; user0_cntr_1 < PyList_GET_SIZE(value); user0_cntr_1++) {
				if (PyList_GET_ITEM(value, user0_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->user0)[user0_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&wkssvc_NetrWkstaUserInfo0_Type, PyList_GET_ITEM(value, user0_cntr_1), return -1;);
				if (talloc_reference(object->user0, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, user0_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->user0)[user0_cntr_1] = *(struct wkssvc_NetrWkstaUserInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, user0_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaEnumUsersCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "entries_read"),
		.get = py_wkssvc_NetWkstaEnumUsersCtr0_get_entries_read,
		.set = py_wkssvc_NetWkstaEnumUsersCtr0_set_entries_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user0"),
		.get = py_wkssvc_NetWkstaEnumUsersCtr0_get_user0,
		.set = py_wkssvc_NetWkstaEnumUsersCtr0_set_user0,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrWkstaUserInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaEnumUsersCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaEnumUsersCtr0, type);
}


static PyTypeObject wkssvc_NetWkstaEnumUsersCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaEnumUsersCtr0",
	.tp_getset = py_wkssvc_NetWkstaEnumUsersCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaEnumUsersCtr0_new,
};


static PyObject *py_wkssvc_NetrWkstaUserInfo1_get_user_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	if (object->user_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user_name == NULL) {
		py_user_name = Py_None;
		Py_INCREF(py_user_name);
	} else {
		if (object->user_name == NULL) {
			py_user_name = Py_None;
			Py_INCREF(py_user_name);
		} else {
			py_user_name = PyUnicode_Decode(object->user_name, strlen(object->user_name), "utf-8", "ignore");
		}
	}
	return py_user_name;
}

static int py_wkssvc_NetrWkstaUserInfo1_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user_name");
		return -1;
	}
	if (value == Py_None) {
		object->user_name = NULL;
	} else {
		object->user_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserInfo1_get_logon_domain(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_domain;
	if (object->logon_domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->logon_domain == NULL) {
		py_logon_domain = Py_None;
		Py_INCREF(py_logon_domain);
	} else {
		if (object->logon_domain == NULL) {
			py_logon_domain = Py_None;
			Py_INCREF(py_logon_domain);
		} else {
			py_logon_domain = PyUnicode_Decode(object->logon_domain, strlen(object->logon_domain), "utf-8", "ignore");
		}
	}
	return py_logon_domain;
}

static int py_wkssvc_NetrWkstaUserInfo1_set_logon_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->logon_domain");
		return -1;
	}
	if (value == Py_None) {
		object->logon_domain = NULL;
	} else {
		object->logon_domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->logon_domain = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserInfo1_get_other_domains(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_other_domains;
	if (object->other_domains == NULL) {
		Py_RETURN_NONE;
	}
	if (object->other_domains == NULL) {
		py_other_domains = Py_None;
		Py_INCREF(py_other_domains);
	} else {
		if (object->other_domains == NULL) {
			py_other_domains = Py_None;
			Py_INCREF(py_other_domains);
		} else {
			py_other_domains = PyUnicode_Decode(object->other_domains, strlen(object->other_domains), "utf-8", "ignore");
		}
	}
	return py_other_domains;
}

static int py_wkssvc_NetrWkstaUserInfo1_set_other_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_domains");
		return -1;
	}
	if (value == Py_None) {
		object->other_domains = NULL;
	} else {
		object->other_domains = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->other_domains = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserInfo1_get_logon_server(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_server;
	if (object->logon_server == NULL) {
		Py_RETURN_NONE;
	}
	if (object->logon_server == NULL) {
		py_logon_server = Py_None;
		Py_INCREF(py_logon_server);
	} else {
		if (object->logon_server == NULL) {
			py_logon_server = Py_None;
			Py_INCREF(py_logon_server);
		} else {
			py_logon_server = PyUnicode_Decode(object->logon_server, strlen(object->logon_server), "utf-8", "ignore");
		}
	}
	return py_logon_server;
}

static int py_wkssvc_NetrWkstaUserInfo1_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->logon_server");
		return -1;
	}
	if (value == Py_None) {
		object->logon_server = NULL;
	} else {
		object->logon_server = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->logon_server = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWkstaUserInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_wkssvc_NetrWkstaUserInfo1_get_user_name,
		.set = py_wkssvc_NetrWkstaUserInfo1_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "logon_domain"),
		.get = py_wkssvc_NetrWkstaUserInfo1_get_logon_domain,
		.set = py_wkssvc_NetrWkstaUserInfo1_set_logon_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "other_domains"),
		.get = py_wkssvc_NetrWkstaUserInfo1_get_other_domains,
		.set = py_wkssvc_NetrWkstaUserInfo1_set_other_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "logon_server"),
		.get = py_wkssvc_NetrWkstaUserInfo1_get_logon_server,
		.set = py_wkssvc_NetrWkstaUserInfo1_set_logon_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWkstaUserInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrWkstaUserInfo1, type);
}


static PyTypeObject wkssvc_NetrWkstaUserInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaUserInfo1",
	.tp_getset = py_wkssvc_NetrWkstaUserInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaUserInfo1_new,
};


static PyObject *py_wkssvc_NetWkstaEnumUsersCtr1_get_entries_read(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_entries_read;
	py_entries_read = PyLong_FromUnsignedLongLong((uint32_t)(object->entries_read));
	return py_entries_read;
}

static int py_wkssvc_NetWkstaEnumUsersCtr1_set_entries_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries_read");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->entries_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->entries_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsersCtr1_get_user1(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_user1;
	if (object->user1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user1 == NULL) {
		py_user1 = Py_None;
		Py_INCREF(py_user1);
	} else {
		py_user1 = PyList_New(object->entries_read);
		if (py_user1 == NULL) {
			return NULL;
		}
		{
			int user1_cntr_1;
			for (user1_cntr_1 = 0; user1_cntr_1 < (object->entries_read); user1_cntr_1++) {
				PyObject *py_user1_1;
				py_user1_1 = pytalloc_reference_ex(&wkssvc_NetrWkstaUserInfo1_Type, object->user1, &(object->user1)[user1_cntr_1]);
				PyList_SetItem(py_user1, user1_cntr_1, py_user1_1);
			}
		}
	}
	return py_user1;
}

static int py_wkssvc_NetWkstaEnumUsersCtr1_set_user1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->user1));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user1");
		return -1;
	}
	if (value == Py_None) {
		object->user1 = NULL;
	} else {
		object->user1 = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int user1_cntr_1;
			object->user1 = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->user1, PyList_GET_SIZE(value));
			if (!object->user1) { return -1; }
			talloc_set_name_const(object->user1, "ARRAY: object->user1");
			for (user1_cntr_1 = 0; user1_cntr_1 < PyList_GET_SIZE(value); user1_cntr_1++) {
				if (PyList_GET_ITEM(value, user1_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->user1)[user1_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&wkssvc_NetrWkstaUserInfo1_Type, PyList_GET_ITEM(value, user1_cntr_1), return -1;);
				if (talloc_reference(object->user1, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, user1_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->user1)[user1_cntr_1] = *(struct wkssvc_NetrWkstaUserInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, user1_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaEnumUsersCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "entries_read"),
		.get = py_wkssvc_NetWkstaEnumUsersCtr1_get_entries_read,
		.set = py_wkssvc_NetWkstaEnumUsersCtr1_set_entries_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user1"),
		.get = py_wkssvc_NetWkstaEnumUsersCtr1_get_user1,
		.set = py_wkssvc_NetWkstaEnumUsersCtr1_set_user1,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrWkstaUserInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaEnumUsersCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaEnumUsersCtr1, type);
}


static PyTypeObject wkssvc_NetWkstaEnumUsersCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaEnumUsersCtr1",
	.tp_getset = py_wkssvc_NetWkstaEnumUsersCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaEnumUsersCtr1_new,
};

static PyObject *py_import_wkssvc_NetWkstaEnumUsersCtr(TALLOC_CTX *mem_ctx, int level, union wkssvc_NetWkstaEnumUsersCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->user0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaEnumUsersCtr0_Type, in->user0, in->user0);
			}
			return ret;

		case 1:
			if (in->user1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaEnumUsersCtr1_Type, in->user1, in->user1);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union wkssvc_NetWkstaEnumUsersCtr *py_export_wkssvc_NetWkstaEnumUsersCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union wkssvc_NetWkstaEnumUsersCtr *ret = talloc_zero(mem_ctx, union wkssvc_NetWkstaEnumUsersCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->user0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->user0 = NULL;
			} else {
				ret->user0 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaEnumUsersCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->user0 = (struct wkssvc_NetWkstaEnumUsersCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->user1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->user1 = NULL;
			} else {
				ret->user1 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaEnumUsersCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->user1 = (struct wkssvc_NetWkstaEnumUsersCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_wkssvc_NetWkstaEnumUsersCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union wkssvc_NetWkstaEnumUsersCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union wkssvc_NetWkstaEnumUsersCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union wkssvc_NetWkstaEnumUsersCtr!");
		return NULL;
	}

	return py_import_wkssvc_NetWkstaEnumUsersCtr(mem_ctx, level, in);
}

static PyObject *py_wkssvc_NetWkstaEnumUsersCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union wkssvc_NetWkstaEnumUsersCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_wkssvc_NetWkstaEnumUsersCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_wkssvc_NetWkstaEnumUsersCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaEnumUsersCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaEnumUsersCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_wkssvc_NetWkstaEnumUsersCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject wkssvc_NetWkstaEnumUsersCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaEnumUsersCtr",
	.tp_getset = NULL,
	.tp_methods = py_wkssvc_NetWkstaEnumUsersCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaEnumUsersCtr_new,
};


static PyObject *py_wkssvc_NetWkstaEnumUsersInfo_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_wkssvc_NetWkstaEnumUsersInfo_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsersInfo_get_ctr(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&wkssvc_NetWkstaEnumUsersCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union wkssvc_NetWkstaEnumUsersCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_wkssvc_NetWkstaEnumUsersInfo_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsersInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union wkssvc_NetWkstaEnumUsersCtr *ctr_switch_0;
		ctr_switch_0 = (union wkssvc_NetWkstaEnumUsersCtr *)pyrpc_export_union(&wkssvc_NetWkstaEnumUsersCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union wkssvc_NetWkstaEnumUsersCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaEnumUsersInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_wkssvc_NetWkstaEnumUsersInfo_get_level,
		.set = py_wkssvc_NetWkstaEnumUsersInfo_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_wkssvc_NetWkstaEnumUsersInfo_get_ctr,
		.set = py_wkssvc_NetWkstaEnumUsersInfo_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaEnumUsersCtr")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaEnumUsersInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaEnumUsersInfo, type);
}


static PyTypeObject wkssvc_NetWkstaEnumUsersInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaEnumUsersInfo",
	.tp_getset = py_wkssvc_NetWkstaEnumUsersInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaEnumUsersInfo_new,
};


static PyObject *py_wkssvc_NetrWkstaUserInfo1101_get_other_domains(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1101 *object = pytalloc_get_ptr(obj);
	PyObject *py_other_domains;
	if (object->other_domains == NULL) {
		Py_RETURN_NONE;
	}
	if (object->other_domains == NULL) {
		py_other_domains = Py_None;
		Py_INCREF(py_other_domains);
	} else {
		if (object->other_domains == NULL) {
			py_other_domains = Py_None;
			Py_INCREF(py_other_domains);
		} else {
			py_other_domains = PyUnicode_Decode(object->other_domains, strlen(object->other_domains), "utf-8", "ignore");
		}
	}
	return py_other_domains;
}

static int py_wkssvc_NetrWkstaUserInfo1101_set_other_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserInfo1101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_domains");
		return -1;
	}
	if (value == Py_None) {
		object->other_domains = NULL;
	} else {
		object->other_domains = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->other_domains = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWkstaUserInfo1101_getsetters[] = {
	{
		.name = discard_const_p(char, "other_domains"),
		.get = py_wkssvc_NetrWkstaUserInfo1101_get_other_domains,
		.set = py_wkssvc_NetrWkstaUserInfo1101_set_other_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWkstaUserInfo1101_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrWkstaUserInfo1101, type);
}


static PyTypeObject wkssvc_NetrWkstaUserInfo1101_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaUserInfo1101",
	.tp_getset = py_wkssvc_NetrWkstaUserInfo1101_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaUserInfo1101_new,
};

static PyObject *py_import_wkssvc_NetrWkstaUserInfo(TALLOC_CTX *mem_ctx, int level, union wkssvc_NetrWkstaUserInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrWkstaUserInfo0_Type, in->info0, in->info0);
			}
			return ret;

		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrWkstaUserInfo1_Type, in->info1, in->info1);
			}
			return ret;

		case 1101:
			if (in->info1101 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrWkstaUserInfo1101_Type, in->info1101, in->info1101);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union wkssvc_NetrWkstaUserInfo *py_export_wkssvc_NetrWkstaUserInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union wkssvc_NetrWkstaUserInfo *ret = talloc_zero(mem_ctx, union wkssvc_NetrWkstaUserInfo);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrWkstaUserInfo0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct wkssvc_NetrWkstaUserInfo0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrWkstaUserInfo1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1 = (struct wkssvc_NetrWkstaUserInfo1 *)pytalloc_get_ptr(in);
			}
			break;

		case 1101:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1101");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1101 = NULL;
			} else {
				ret->info1101 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrWkstaUserInfo1101_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1101 = (struct wkssvc_NetrWkstaUserInfo1101 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_wkssvc_NetrWkstaUserInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union wkssvc_NetrWkstaUserInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union wkssvc_NetrWkstaUserInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union wkssvc_NetrWkstaUserInfo!");
		return NULL;
	}

	return py_import_wkssvc_NetrWkstaUserInfo(mem_ctx, level, in);
}

static PyObject *py_wkssvc_NetrWkstaUserInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union wkssvc_NetrWkstaUserInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_wkssvc_NetrWkstaUserInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_wkssvc_NetrWkstaUserInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_wkssvc_NetrWkstaUserInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject wkssvc_NetrWkstaUserInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaUserInfo",
	.tp_getset = NULL,
	.tp_methods = py_wkssvc_NetrWkstaUserInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaUserInfo_new,
};


static PyObject *py_wkssvc_NetWkstaTransportInfo0_get_quality_of_service(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_quality_of_service;
	py_quality_of_service = PyLong_FromUnsignedLongLong((uint32_t)(object->quality_of_service));
	return py_quality_of_service;
}

static int py_wkssvc_NetWkstaTransportInfo0_set_quality_of_service(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->quality_of_service");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->quality_of_service));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->quality_of_service = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportInfo0_get_vc_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_vc_count;
	py_vc_count = PyLong_FromUnsignedLongLong((uint32_t)(object->vc_count));
	return py_vc_count;
}

static int py_wkssvc_NetWkstaTransportInfo0_set_vc_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->vc_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vc_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vc_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportInfo0_get_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_wkssvc_NetWkstaTransportInfo0_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportInfo0_get_address(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_address;
	if (object->address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->address == NULL) {
		py_address = Py_None;
		Py_INCREF(py_address);
	} else {
		if (object->address == NULL) {
			py_address = Py_None;
			Py_INCREF(py_address);
		} else {
			py_address = PyUnicode_Decode(object->address, strlen(object->address), "utf-8", "ignore");
		}
	}
	return py_address;
}

static int py_wkssvc_NetWkstaTransportInfo0_set_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->address");
		return -1;
	}
	if (value == Py_None) {
		object->address = NULL;
	} else {
		object->address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportInfo0_get_wan_link(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_wan_link;
	py_wan_link = PyLong_FromUnsignedLongLong((uint32_t)(object->wan_link));
	return py_wan_link;
}

static int py_wkssvc_NetWkstaTransportInfo0_set_wan_link(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wan_link");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wan_link));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wan_link = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaTransportInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "quality_of_service"),
		.get = py_wkssvc_NetWkstaTransportInfo0_get_quality_of_service,
		.set = py_wkssvc_NetWkstaTransportInfo0_set_quality_of_service,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "vc_count"),
		.get = py_wkssvc_NetWkstaTransportInfo0_get_vc_count,
		.set = py_wkssvc_NetWkstaTransportInfo0_set_vc_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_wkssvc_NetWkstaTransportInfo0_get_name,
		.set = py_wkssvc_NetWkstaTransportInfo0_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "address"),
		.get = py_wkssvc_NetWkstaTransportInfo0_get_address,
		.set = py_wkssvc_NetWkstaTransportInfo0_set_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wan_link"),
		.get = py_wkssvc_NetWkstaTransportInfo0_get_wan_link,
		.set = py_wkssvc_NetWkstaTransportInfo0_set_wan_link,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaTransportInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaTransportInfo0, type);
}


static PyTypeObject wkssvc_NetWkstaTransportInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaTransportInfo0",
	.tp_getset = py_wkssvc_NetWkstaTransportInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaTransportInfo0_new,
};


static PyObject *py_wkssvc_NetWkstaTransportCtr0_get_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_wkssvc_NetWkstaTransportCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportCtr0_get_array(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&wkssvc_NetWkstaTransportInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_wkssvc_NetWkstaTransportCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&wkssvc_NetWkstaTransportInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct wkssvc_NetWkstaTransportInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaTransportCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_wkssvc_NetWkstaTransportCtr0_get_count,
		.set = py_wkssvc_NetWkstaTransportCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_wkssvc_NetWkstaTransportCtr0_get_array,
		.set = py_wkssvc_NetWkstaTransportCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaTransportInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaTransportCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaTransportCtr0, type);
}


static PyTypeObject wkssvc_NetWkstaTransportCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaTransportCtr0",
	.tp_getset = py_wkssvc_NetWkstaTransportCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaTransportCtr0_new,
};

static PyObject *py_import_wkssvc_NetWkstaTransportCtr(TALLOC_CTX *mem_ctx, int level, union wkssvc_NetWkstaTransportCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetWkstaTransportCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union wkssvc_NetWkstaTransportCtr *py_export_wkssvc_NetWkstaTransportCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union wkssvc_NetWkstaTransportCtr *ret = talloc_zero(mem_ctx, union wkssvc_NetWkstaTransportCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetWkstaTransportCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct wkssvc_NetWkstaTransportCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_wkssvc_NetWkstaTransportCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union wkssvc_NetWkstaTransportCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union wkssvc_NetWkstaTransportCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union wkssvc_NetWkstaTransportCtr!");
		return NULL;
	}

	return py_import_wkssvc_NetWkstaTransportCtr(mem_ctx, level, in);
}

static PyObject *py_wkssvc_NetWkstaTransportCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union wkssvc_NetWkstaTransportCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_wkssvc_NetWkstaTransportCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_wkssvc_NetWkstaTransportCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaTransportCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaTransportCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_wkssvc_NetWkstaTransportCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject wkssvc_NetWkstaTransportCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaTransportCtr",
	.tp_getset = NULL,
	.tp_methods = py_wkssvc_NetWkstaTransportCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaTransportCtr_new,
};


static PyObject *py_wkssvc_NetWkstaTransportInfo_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_wkssvc_NetWkstaTransportInfo_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportInfo_get_ctr(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&wkssvc_NetWkstaTransportCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union wkssvc_NetWkstaTransportCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_wkssvc_NetWkstaTransportInfo_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union wkssvc_NetWkstaTransportCtr *ctr_switch_0;
		ctr_switch_0 = (union wkssvc_NetWkstaTransportCtr *)pyrpc_export_union(&wkssvc_NetWkstaTransportCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union wkssvc_NetWkstaTransportCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaTransportInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_wkssvc_NetWkstaTransportInfo_get_level,
		.set = py_wkssvc_NetWkstaTransportInfo_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_wkssvc_NetWkstaTransportInfo_get_ctr,
		.set = py_wkssvc_NetWkstaTransportInfo_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaTransportCtr")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaTransportInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetWkstaTransportInfo, type);
}


static PyTypeObject wkssvc_NetWkstaTransportInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaTransportInfo",
	.tp_getset = py_wkssvc_NetWkstaTransportInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaTransportInfo_new,
};


static PyObject *py_wkssvc_NetrUseInfo3_get_unknown1(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	if (object->unknown1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->unknown1 == NULL) {
		py_unknown1 = Py_None;
		Py_INCREF(py_unknown1);
	} else {
		if (object->unknown1 == NULL) {
			py_unknown1 = Py_None;
			Py_INCREF(py_unknown1);
		} else {
			py_unknown1 = PyUnicode_Decode(object->unknown1, strlen(object->unknown1), "utf-8", "ignore");
		}
	}
	return py_unknown1;
}

static int py_wkssvc_NetrUseInfo3_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown1");
		return -1;
	}
	if (value == Py_None) {
		object->unknown1 = NULL;
	} else {
		object->unknown1 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->unknown1 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo3_get_unknown2(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	if (object->unknown2 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->unknown2 == NULL) {
		py_unknown2 = Py_None;
		Py_INCREF(py_unknown2);
	} else {
		if (object->unknown2 == NULL) {
			py_unknown2 = Py_None;
			Py_INCREF(py_unknown2);
		} else {
			py_unknown2 = PyUnicode_Decode(object->unknown2, strlen(object->unknown2), "utf-8", "ignore");
		}
	}
	return py_unknown2;
}

static int py_wkssvc_NetrUseInfo3_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown2");
		return -1;
	}
	if (value == Py_None) {
		object->unknown2 = NULL;
	} else {
		object->unknown2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->unknown2 = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseInfo3_getsetters[] = {
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_wkssvc_NetrUseInfo3_get_unknown1,
		.set = py_wkssvc_NetrUseInfo3_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_wkssvc_NetrUseInfo3_get_unknown2,
		.set = py_wkssvc_NetrUseInfo3_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseInfo3, type);
}


static PyTypeObject wkssvc_NetrUseInfo3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseInfo3",
	.tp_getset = py_wkssvc_NetrUseInfo3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseInfo3_new,
};


static PyObject *py_wkssvc_NetrUseInfo2_get_local(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_local;
	if (object->local == NULL) {
		Py_RETURN_NONE;
	}
	if (object->local == NULL) {
		py_local = Py_None;
		Py_INCREF(py_local);
	} else {
		if (object->local == NULL) {
			py_local = Py_None;
			Py_INCREF(py_local);
		} else {
			py_local = PyUnicode_Decode(object->local, strlen(object->local), "utf-8", "ignore");
		}
	}
	return py_local;
}

static int py_wkssvc_NetrUseInfo2_set_local(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->local");
		return -1;
	}
	if (value == Py_None) {
		object->local = NULL;
	} else {
		object->local = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->local = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_remote(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_remote;
	if (object->remote == NULL) {
		Py_RETURN_NONE;
	}
	if (object->remote == NULL) {
		py_remote = Py_None;
		Py_INCREF(py_remote);
	} else {
		if (object->remote == NULL) {
			py_remote = Py_None;
			Py_INCREF(py_remote);
		} else {
			py_remote = PyUnicode_Decode(object->remote, strlen(object->remote), "utf-8", "ignore");
		}
	}
	return py_remote;
}

static int py_wkssvc_NetrUseInfo2_set_remote(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->remote");
		return -1;
	}
	if (value == Py_None) {
		object->remote = NULL;
	} else {
		object->remote = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->remote = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->password, strlen(object->password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_wkssvc_NetrUseInfo2_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->password");
		return -1;
	}
	if (value == Py_None) {
		object->password = NULL;
	} else {
		object->password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_status(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(object->status));
	return py_status;
}

static int py_wkssvc_NetrUseInfo2_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_asg_type(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_asg_type;
	py_asg_type = PyLong_FromUnsignedLongLong((uint32_t)(object->asg_type));
	return py_asg_type;
}

static int py_wkssvc_NetrUseInfo2_set_asg_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->asg_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->asg_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->asg_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_ref_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ref_count;
	py_ref_count = PyLong_FromUnsignedLongLong((uint32_t)(object->ref_count));
	return py_ref_count;
}

static int py_wkssvc_NetrUseInfo2_set_ref_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ref_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ref_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ref_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_use_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_count;
	py_use_count = PyLong_FromUnsignedLongLong((uint32_t)(object->use_count));
	return py_use_count;
}

static int py_wkssvc_NetrUseInfo2_set_use_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_user_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	if (object->user_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user_name == NULL) {
		py_user_name = Py_None;
		Py_INCREF(py_user_name);
	} else {
		if (object->user_name == NULL) {
			py_user_name = Py_None;
			Py_INCREF(py_user_name);
		} else {
			py_user_name = PyUnicode_Decode(object->user_name, strlen(object->user_name), "utf-8", "ignore");
		}
	}
	return py_user_name;
}

static int py_wkssvc_NetrUseInfo2_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user_name");
		return -1;
	}
	if (value == Py_None) {
		object->user_name = NULL;
	} else {
		object->user_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo2_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_wkssvc_NetrUseInfo2_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "local"),
		.get = py_wkssvc_NetrUseInfo2_get_local,
		.set = py_wkssvc_NetrUseInfo2_set_local,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "remote"),
		.get = py_wkssvc_NetrUseInfo2_get_remote,
		.set = py_wkssvc_NetrUseInfo2_set_remote,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_wkssvc_NetrUseInfo2_get_password,
		.set = py_wkssvc_NetrUseInfo2_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_wkssvc_NetrUseInfo2_get_status,
		.set = py_wkssvc_NetrUseInfo2_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "asg_type"),
		.get = py_wkssvc_NetrUseInfo2_get_asg_type,
		.set = py_wkssvc_NetrUseInfo2_set_asg_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ref_count"),
		.get = py_wkssvc_NetrUseInfo2_get_ref_count,
		.set = py_wkssvc_NetrUseInfo2_set_ref_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_count"),
		.get = py_wkssvc_NetrUseInfo2_get_use_count,
		.set = py_wkssvc_NetrUseInfo2_set_use_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_wkssvc_NetrUseInfo2_get_user_name,
		.set = py_wkssvc_NetrUseInfo2_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_wkssvc_NetrUseInfo2_get_domain_name,
		.set = py_wkssvc_NetrUseInfo2_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseInfo2, type);
}


static PyTypeObject wkssvc_NetrUseInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseInfo2",
	.tp_getset = py_wkssvc_NetrUseInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseInfo2_new,
};


static PyObject *py_wkssvc_NetrUseInfo1_get_local(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_local;
	if (object->local == NULL) {
		Py_RETURN_NONE;
	}
	if (object->local == NULL) {
		py_local = Py_None;
		Py_INCREF(py_local);
	} else {
		if (object->local == NULL) {
			py_local = Py_None;
			Py_INCREF(py_local);
		} else {
			py_local = PyUnicode_Decode(object->local, strlen(object->local), "utf-8", "ignore");
		}
	}
	return py_local;
}

static int py_wkssvc_NetrUseInfo1_set_local(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->local");
		return -1;
	}
	if (value == Py_None) {
		object->local = NULL;
	} else {
		object->local = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->local = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo1_get_remote(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_remote;
	if (object->remote == NULL) {
		Py_RETURN_NONE;
	}
	if (object->remote == NULL) {
		py_remote = Py_None;
		Py_INCREF(py_remote);
	} else {
		if (object->remote == NULL) {
			py_remote = Py_None;
			Py_INCREF(py_remote);
		} else {
			py_remote = PyUnicode_Decode(object->remote, strlen(object->remote), "utf-8", "ignore");
		}
	}
	return py_remote;
}

static int py_wkssvc_NetrUseInfo1_set_remote(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->remote");
		return -1;
	}
	if (value == Py_None) {
		object->remote = NULL;
	} else {
		object->remote = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->remote = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo1_get_password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->password, strlen(object->password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_wkssvc_NetrUseInfo1_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->password");
		return -1;
	}
	if (value == Py_None) {
		object->password = NULL;
	} else {
		object->password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo1_get_status(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(object->status));
	return py_status;
}

static int py_wkssvc_NetrUseInfo1_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo1_get_asg_type(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_asg_type;
	py_asg_type = PyLong_FromUnsignedLongLong((uint32_t)(object->asg_type));
	return py_asg_type;
}

static int py_wkssvc_NetrUseInfo1_set_asg_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->asg_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->asg_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->asg_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo1_get_ref_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_ref_count;
	py_ref_count = PyLong_FromUnsignedLongLong((uint32_t)(object->ref_count));
	return py_ref_count;
}

static int py_wkssvc_NetrUseInfo1_set_ref_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ref_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ref_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ref_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo1_get_use_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_use_count;
	py_use_count = PyLong_FromUnsignedLongLong((uint32_t)(object->use_count));
	return py_use_count;
}

static int py_wkssvc_NetrUseInfo1_set_use_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->use_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->use_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->use_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "local"),
		.get = py_wkssvc_NetrUseInfo1_get_local,
		.set = py_wkssvc_NetrUseInfo1_set_local,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "remote"),
		.get = py_wkssvc_NetrUseInfo1_get_remote,
		.set = py_wkssvc_NetrUseInfo1_set_remote,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_wkssvc_NetrUseInfo1_get_password,
		.set = py_wkssvc_NetrUseInfo1_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_wkssvc_NetrUseInfo1_get_status,
		.set = py_wkssvc_NetrUseInfo1_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "asg_type"),
		.get = py_wkssvc_NetrUseInfo1_get_asg_type,
		.set = py_wkssvc_NetrUseInfo1_set_asg_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ref_count"),
		.get = py_wkssvc_NetrUseInfo1_get_ref_count,
		.set = py_wkssvc_NetrUseInfo1_set_ref_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "use_count"),
		.get = py_wkssvc_NetrUseInfo1_get_use_count,
		.set = py_wkssvc_NetrUseInfo1_set_use_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseInfo1, type);
}


static PyTypeObject wkssvc_NetrUseInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseInfo1",
	.tp_getset = py_wkssvc_NetrUseInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseInfo1_new,
};


static PyObject *py_wkssvc_NetrUseInfo0_get_local(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_local;
	if (object->local == NULL) {
		Py_RETURN_NONE;
	}
	if (object->local == NULL) {
		py_local = Py_None;
		Py_INCREF(py_local);
	} else {
		if (object->local == NULL) {
			py_local = Py_None;
			Py_INCREF(py_local);
		} else {
			py_local = PyUnicode_Decode(object->local, strlen(object->local), "utf-8", "ignore");
		}
	}
	return py_local;
}

static int py_wkssvc_NetrUseInfo0_set_local(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->local");
		return -1;
	}
	if (value == Py_None) {
		object->local = NULL;
	} else {
		object->local = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->local = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseInfo0_get_remote(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_remote;
	if (object->remote == NULL) {
		Py_RETURN_NONE;
	}
	if (object->remote == NULL) {
		py_remote = Py_None;
		Py_INCREF(py_remote);
	} else {
		if (object->remote == NULL) {
			py_remote = Py_None;
			Py_INCREF(py_remote);
		} else {
			py_remote = PyUnicode_Decode(object->remote, strlen(object->remote), "utf-8", "ignore");
		}
	}
	return py_remote;
}

static int py_wkssvc_NetrUseInfo0_set_remote(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->remote");
		return -1;
	}
	if (value == Py_None) {
		object->remote = NULL;
	} else {
		object->remote = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->remote = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "local"),
		.get = py_wkssvc_NetrUseInfo0_get_local,
		.set = py_wkssvc_NetrUseInfo0_set_local,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "remote"),
		.get = py_wkssvc_NetrUseInfo0_get_remote,
		.set = py_wkssvc_NetrUseInfo0_set_remote,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseInfo0, type);
}


static PyTypeObject wkssvc_NetrUseInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseInfo0",
	.tp_getset = py_wkssvc_NetrUseInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseInfo0_new,
};

static PyObject *py_import_wkssvc_NetrUseGetInfoCtr(TALLOC_CTX *mem_ctx, int level, union wkssvc_NetrUseGetInfoCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrUseInfo0_Type, in->info0, in->info0);
			}
			return ret;

		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrUseInfo1_Type, in->info1, in->info1);
			}
			return ret;

		case 2:
			if (in->info2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrUseInfo2_Type, in->info2, in->info2);
			}
			return ret;

		case 3:
			if (in->info3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrUseInfo3_Type, in->info3, in->info3);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union wkssvc_NetrUseGetInfoCtr *py_export_wkssvc_NetrUseGetInfoCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union wkssvc_NetrUseGetInfoCtr *ret = talloc_zero(mem_ctx, union wkssvc_NetrUseGetInfoCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrUseInfo0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct wkssvc_NetrUseInfo0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrUseInfo1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1 = (struct wkssvc_NetrUseInfo1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info2 = NULL;
			} else {
				ret->info2 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrUseInfo2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info2 = (struct wkssvc_NetrUseInfo2 *)pytalloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info3");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info3 = NULL;
			} else {
				ret->info3 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrUseInfo3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info3 = (struct wkssvc_NetrUseInfo3 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_wkssvc_NetrUseGetInfoCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union wkssvc_NetrUseGetInfoCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union wkssvc_NetrUseGetInfoCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union wkssvc_NetrUseGetInfoCtr!");
		return NULL;
	}

	return py_import_wkssvc_NetrUseGetInfoCtr(mem_ctx, level, in);
}

static PyObject *py_wkssvc_NetrUseGetInfoCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union wkssvc_NetrUseGetInfoCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_wkssvc_NetrUseGetInfoCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_wkssvc_NetrUseGetInfoCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseGetInfoCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseGetInfoCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_wkssvc_NetrUseGetInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject wkssvc_NetrUseGetInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseGetInfoCtr",
	.tp_getset = NULL,
	.tp_methods = py_wkssvc_NetrUseGetInfoCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseGetInfoCtr_new,
};


static PyObject *py_wkssvc_NetrUseEnumCtr2_get_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_wkssvc_NetrUseEnumCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnumCtr2_get_array(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&wkssvc_NetrUseInfo2_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_wkssvc_NetrUseEnumCtr2_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&wkssvc_NetrUseInfo2_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct wkssvc_NetrUseInfo2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseEnumCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_wkssvc_NetrUseEnumCtr2_get_count,
		.set = py_wkssvc_NetrUseEnumCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_wkssvc_NetrUseEnumCtr2_get_array,
		.set = py_wkssvc_NetrUseEnumCtr2_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseInfo2")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseEnumCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseEnumCtr2, type);
}


static PyTypeObject wkssvc_NetrUseEnumCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseEnumCtr2",
	.tp_getset = py_wkssvc_NetrUseEnumCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseEnumCtr2_new,
};


static PyObject *py_wkssvc_NetrUseEnumCtr1_get_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_wkssvc_NetrUseEnumCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnumCtr1_get_array(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&wkssvc_NetrUseInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_wkssvc_NetrUseEnumCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&wkssvc_NetrUseInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct wkssvc_NetrUseInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseEnumCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_wkssvc_NetrUseEnumCtr1_get_count,
		.set = py_wkssvc_NetrUseEnumCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_wkssvc_NetrUseEnumCtr1_get_array,
		.set = py_wkssvc_NetrUseEnumCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseEnumCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseEnumCtr1, type);
}


static PyTypeObject wkssvc_NetrUseEnumCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseEnumCtr1",
	.tp_getset = py_wkssvc_NetrUseEnumCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseEnumCtr1_new,
};


static PyObject *py_wkssvc_NetrUseEnumCtr0_get_count(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_wkssvc_NetrUseEnumCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnumCtr0_get_array(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&wkssvc_NetrUseInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_wkssvc_NetrUseEnumCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&wkssvc_NetrUseInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct wkssvc_NetrUseInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseEnumCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_wkssvc_NetrUseEnumCtr0_get_count,
		.set = py_wkssvc_NetrUseEnumCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_wkssvc_NetrUseEnumCtr0_get_array,
		.set = py_wkssvc_NetrUseEnumCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseEnumCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseEnumCtr0, type);
}


static PyTypeObject wkssvc_NetrUseEnumCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseEnumCtr0",
	.tp_getset = py_wkssvc_NetrUseEnumCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseEnumCtr0_new,
};

static PyObject *py_import_wkssvc_NetrUseEnumCtr(TALLOC_CTX *mem_ctx, int level, union wkssvc_NetrUseEnumCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrUseEnumCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrUseEnumCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

		case 2:
			if (in->ctr2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&wkssvc_NetrUseEnumCtr2_Type, in->ctr2, in->ctr2);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union wkssvc_NetrUseEnumCtr *py_export_wkssvc_NetrUseEnumCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union wkssvc_NetrUseEnumCtr *ret = talloc_zero(mem_ctx, union wkssvc_NetrUseEnumCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrUseEnumCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct wkssvc_NetrUseEnumCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrUseEnumCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct wkssvc_NetrUseEnumCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr2 = NULL;
			} else {
				ret->ctr2 = NULL;
				PY_CHECK_TYPE(&wkssvc_NetrUseEnumCtr2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr2 = (struct wkssvc_NetrUseEnumCtr2 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_wkssvc_NetrUseEnumCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union wkssvc_NetrUseEnumCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union wkssvc_NetrUseEnumCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union wkssvc_NetrUseEnumCtr!");
		return NULL;
	}

	return py_import_wkssvc_NetrUseEnumCtr(mem_ctx, level, in);
}

static PyObject *py_wkssvc_NetrUseEnumCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union wkssvc_NetrUseEnumCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_wkssvc_NetrUseEnumCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_wkssvc_NetrUseEnumCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseEnumCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseEnumCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_wkssvc_NetrUseEnumCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject wkssvc_NetrUseEnumCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseEnumCtr",
	.tp_getset = NULL,
	.tp_methods = py_wkssvc_NetrUseEnumCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseEnumCtr_new,
};


static PyObject *py_wkssvc_NetrUseEnumInfo_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_wkssvc_NetrUseEnumInfo_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnumInfo_get_ctr(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&wkssvc_NetrUseEnumCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union wkssvc_NetrUseEnumCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_wkssvc_NetrUseEnumInfo_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union wkssvc_NetrUseEnumCtr *ctr_switch_0;
		ctr_switch_0 = (union wkssvc_NetrUseEnumCtr *)pyrpc_export_union(&wkssvc_NetrUseEnumCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union wkssvc_NetrUseEnumCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseEnumInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_wkssvc_NetrUseEnumInfo_get_level,
		.set = py_wkssvc_NetrUseEnumInfo_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_wkssvc_NetrUseEnumInfo_get_ctr,
		.set = py_wkssvc_NetrUseEnumInfo_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseEnumCtr")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseEnumInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrUseEnumInfo, type);
}


static PyTypeObject wkssvc_NetrUseEnumInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseEnumInfo",
	.tp_getset = py_wkssvc_NetrUseEnumInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseEnumInfo_new,
};


static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown1(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong(object->unknown1);
	return py_unknown1;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown2(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong(object->unknown2);
	return py_unknown2;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown3(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong(object->unknown3);
	return py_unknown3;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown4(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyLong_FromUnsignedLongLong(object->unknown4);
	return py_unknown4;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown5(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong(object->unknown5);
	return py_unknown5;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown6(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong(object->unknown6);
	return py_unknown6;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown7(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong(object->unknown7);
	return py_unknown7;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown8(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong(object->unknown8);
	return py_unknown8;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown9(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown9;
	py_unknown9 = PyLong_FromUnsignedLongLong(object->unknown9);
	return py_unknown9;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown9(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown9");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown9));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown9 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown10(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown10;
	py_unknown10 = PyLong_FromUnsignedLongLong(object->unknown10);
	return py_unknown10;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown10(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown10");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown10));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown10 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown11(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown11;
	py_unknown11 = PyLong_FromUnsignedLongLong(object->unknown11);
	return py_unknown11;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown11(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown11");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown11));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown11 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown12(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown12;
	py_unknown12 = PyLong_FromUnsignedLongLong(object->unknown12);
	return py_unknown12;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown12(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown12");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown12));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown12 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown13(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown13;
	py_unknown13 = PyLong_FromUnsignedLongLong(object->unknown13);
	return py_unknown13;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown13(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown13");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown13));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown13 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown14(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown14;
	py_unknown14 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown14));
	return py_unknown14;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown14(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown14");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown14));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown14 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown15(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown15;
	py_unknown15 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown15));
	return py_unknown15;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown15(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown15");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown15));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown15 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown16(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown16;
	py_unknown16 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown16));
	return py_unknown16;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown16(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown16");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown16));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown16 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown17(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown17;
	py_unknown17 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown17));
	return py_unknown17;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown17(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown17");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown17));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown17 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown18(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown18;
	py_unknown18 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown18));
	return py_unknown18;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown18(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown18");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown18));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown18 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown19(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown19;
	py_unknown19 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown19));
	return py_unknown19;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown19(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown19");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown19));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown19 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown20(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown20;
	py_unknown20 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown20));
	return py_unknown20;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown20(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown20");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown20));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown20 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown21(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown21;
	py_unknown21 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown21));
	return py_unknown21;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown21(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown21");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown21));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown21 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown22(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown22;
	py_unknown22 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown22));
	return py_unknown22;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown22(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown22");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown22));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown22 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown23(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown23;
	py_unknown23 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown23));
	return py_unknown23;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown23(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown23");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown23));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown23 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown24(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown24;
	py_unknown24 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown24));
	return py_unknown24;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown24(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown24");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown24));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown24 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown25(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown25;
	py_unknown25 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown25));
	return py_unknown25;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown25(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown25");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown25));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown25 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown26(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown26;
	py_unknown26 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown26));
	return py_unknown26;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown26(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown26");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown26));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown26 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown27(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown27;
	py_unknown27 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown27));
	return py_unknown27;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown27(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown27");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown27));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown27 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown28(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown28;
	py_unknown28 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown28));
	return py_unknown28;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown28(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown28");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown28));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown28 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown29(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown29;
	py_unknown29 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown29));
	return py_unknown29;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown29(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown29");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown29));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown29 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown30(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown30;
	py_unknown30 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown30));
	return py_unknown30;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown30(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown30");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown30));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown30 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown31(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown31;
	py_unknown31 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown31));
	return py_unknown31;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown31(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown31");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown31));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown31 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown32(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown32;
	py_unknown32 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown32));
	return py_unknown32;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown32(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown32");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown32));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown32 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown33(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown33;
	py_unknown33 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown33));
	return py_unknown33;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown33(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown33");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown33));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown33 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown34(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown34;
	py_unknown34 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown34));
	return py_unknown34;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown34(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown34");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown34));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown34 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown35(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown35;
	py_unknown35 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown35));
	return py_unknown35;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown35(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown35");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown35));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown35 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown36(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown36;
	py_unknown36 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown36));
	return py_unknown36;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown36(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown36");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown36));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown36 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown37(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown37;
	py_unknown37 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown37));
	return py_unknown37;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown37(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown37");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown37));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown37 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown38(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown38;
	py_unknown38 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown38));
	return py_unknown38;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown38(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown38");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown38));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown38 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown39(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown39;
	py_unknown39 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown39));
	return py_unknown39;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown39(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown39");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown39));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown39 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatistics_get_unknown40(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown40;
	py_unknown40 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown40));
	return py_unknown40;
}

static int py_wkssvc_NetrWorkstationStatistics_set_unknown40(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown40");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown40));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown40 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWorkstationStatistics_getsetters[] = {
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown1,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown2,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown3,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown4,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown5,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown6,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown7,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown8,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown9"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown9,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown9,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown10"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown10,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown10,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown11"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown11,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown11,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown12"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown12,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown12,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown13"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown13,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown13,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unknown14"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown14,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown14,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown15"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown15,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown15,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown16"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown16,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown16,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown17"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown17,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown17,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown18"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown18,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown18,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown19"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown19,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown19,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown20"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown20,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown20,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown21"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown21,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown21,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown22"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown22,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown22,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown23"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown23,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown23,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown24"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown24,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown24,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown25"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown25,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown25,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown26"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown26,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown26,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown27"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown27,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown27,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown28"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown28,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown28,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown29"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown29,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown29,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown30"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown30,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown30,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown31"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown31,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown31,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown32"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown32,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown32,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown33"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown33,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown33,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown34"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown34,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown34,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown35"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown35,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown35,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown36"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown36,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown36,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown37"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown37,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown37,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown38"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown38,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown38,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown39"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown39,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown39,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown40"),
		.get = py_wkssvc_NetrWorkstationStatistics_get_unknown40,
		.set = py_wkssvc_NetrWorkstationStatistics_set_unknown40,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWorkstationStatistics_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_NetrWorkstationStatistics, type);
}


static PyTypeObject wkssvc_NetrWorkstationStatistics_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWorkstationStatistics",
	.tp_getset = py_wkssvc_NetrWorkstationStatistics_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWorkstationStatistics_new,
};


static PyObject *py_wkssvc_PasswordBuffer_get_data(PyObject *obj, void *closure)
{
	struct wkssvc_PasswordBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(524);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (524); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_wkssvc_PasswordBuffer_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_PasswordBuffer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		if (ARRAY_SIZE(object->data) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->data),  PyList_GET_SIZE(value));
			return -1;
		}
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_PasswordBuffer_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_wkssvc_PasswordBuffer_get_data,
		.set = py_wkssvc_PasswordBuffer_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_PasswordBuffer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_PasswordBuffer, type);
}


static PyTypeObject wkssvc_PasswordBuffer_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.PasswordBuffer",
	.tp_getset = py_wkssvc_PasswordBuffer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_PasswordBuffer_new,
};


static PyObject *py_wkssvc_ComputerNamesCtr_get_count(PyObject *obj, void *closure)
{
	struct wkssvc_ComputerNamesCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_wkssvc_ComputerNamesCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_ComputerNamesCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_ComputerNamesCtr_get_computer_name(PyObject *obj, void *closure)
{
	struct wkssvc_ComputerNamesCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	if (object->computer_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->computer_name == NULL) {
		py_computer_name = Py_None;
		Py_INCREF(py_computer_name);
	} else {
		py_computer_name = PyList_New(object->count);
		if (py_computer_name == NULL) {
			return NULL;
		}
		{
			int computer_name_cntr_1;
			for (computer_name_cntr_1 = 0; computer_name_cntr_1 < (object->count); computer_name_cntr_1++) {
				PyObject *py_computer_name_1;
				py_computer_name_1 = pytalloc_reference_ex(lsa_String_Type, object->computer_name, &(object->computer_name)[computer_name_cntr_1]);
				PyList_SetItem(py_computer_name, computer_name_cntr_1, py_computer_name_1);
			}
		}
	}
	return py_computer_name;
}

static int py_wkssvc_ComputerNamesCtr_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_ComputerNamesCtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->computer_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->computer_name");
		return -1;
	}
	if (value == Py_None) {
		object->computer_name = NULL;
	} else {
		object->computer_name = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int computer_name_cntr_1;
			object->computer_name = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->computer_name, PyList_GET_SIZE(value));
			if (!object->computer_name) { return -1; }
			talloc_set_name_const(object->computer_name, "ARRAY: object->computer_name");
			for (computer_name_cntr_1 = 0; computer_name_cntr_1 < PyList_GET_SIZE(value); computer_name_cntr_1++) {
				if (PyList_GET_ITEM(value, computer_name_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->computer_name)[computer_name_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, computer_name_cntr_1), return -1;);
				if (talloc_reference(object->computer_name, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, computer_name_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->computer_name)[computer_name_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, computer_name_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wkssvc_ComputerNamesCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_wkssvc_ComputerNamesCtr_get_count,
		.set = py_wkssvc_ComputerNamesCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_wkssvc_ComputerNamesCtr_get_computer_name,
		.set = py_wkssvc_ComputerNamesCtr_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_ComputerNamesCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wkssvc_ComputerNamesCtr, type);
}


static PyTypeObject wkssvc_ComputerNamesCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.ComputerNamesCtr",
	.tp_getset = py_wkssvc_ComputerNamesCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_ComputerNamesCtr_new,
};



static PyObject *py_wkssvc_NetWkstaGetInfo_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetWkstaGetInfo_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaGetInfo_in_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_wkssvc_NetWkstaGetInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaGetInfo_out_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&wkssvc_NetWkstaInfo_Type, object->out.info, object->in.level, object->out.info, "union wkssvc_NetWkstaInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_wkssvc_NetWkstaGetInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union wkssvc_NetWkstaInfo *info_switch_1;
		info_switch_1 = (union wkssvc_NetWkstaInfo *)pyrpc_export_union(&wkssvc_NetWkstaInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union wkssvc_NetWkstaInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->out.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaGetInfo_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetWkstaGetInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaGetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetWkstaGetInfo_in_get_server_name,
		.set = py_wkssvc_NetWkstaGetInfo_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_wkssvc_NetWkstaGetInfo_in_get_level,
		.set = py_wkssvc_NetWkstaGetInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_wkssvc_NetWkstaGetInfo_out_get_info,
		.set = py_wkssvc_NetWkstaGetInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetWkstaGetInfo_get_result,
		.set = py_wkssvc_NetWkstaGetInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaGetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetWkstaGetInfo, type);
	struct wkssvc_NetWkstaGetInfo *_self = (struct wkssvc_NetWkstaGetInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.info = talloc_zero(mem_ctx, union wkssvc_NetWkstaInfo);
	return self;
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaGetInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaGetInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaGetInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaGetInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaGetInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaGetInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaGetInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaGetInfo_ndr_print(py_obj, "wkssvc_NetWkstaGetInfo_in", NDR_IN);
}

static PyObject *py_wkssvc_NetWkstaGetInfo_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaGetInfo_ndr_print(py_obj, "wkssvc_NetWkstaGetInfo_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetWkstaGetInfo_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetWkstaGetInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetWkstaGetInfo.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaGetInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaGetInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaGetInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaGetInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetWkstaGetInfo_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetWkstaGetInfo_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetWkstaGetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaGetInfo",
	.tp_getset = py_wkssvc_NetWkstaGetInfo_getsetters,
	.tp_methods = py_wkssvc_NetWkstaGetInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaGetInfo_new,
};

static bool pack_py_wkssvc_NetWkstaGetInfo_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetWkstaGetInfo *r)
{
	PyObject *py_server_name;
	PyObject *py_level;
	const char *kwnames[] = {
		"server_name", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wkssvc_NetWkstaGetInfo", discard_const_p(char *, kwnames), &py_server_name, &py_level)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetWkstaGetInfo_args_out(struct wkssvc_NetWkstaGetInfo *r)
{
	PyObject *result;
	PyObject *py_info;
	py_info = pyrpc_import_union(&wkssvc_NetWkstaInfo_Type, r->out.info, r->in.level, r->out.info, "union wkssvc_NetWkstaInfo");
	if (py_info == NULL) {
		return NULL;
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetWkstaSetInfo_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetWkstaSetInfo_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_in_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_wkssvc_NetWkstaSetInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_in_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&wkssvc_NetWkstaInfo_Type, object->in.info, object->in.level, object->in.info, "union wkssvc_NetWkstaInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_wkssvc_NetWkstaSetInfo_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union wkssvc_NetWkstaInfo *info_switch_1;
		info_switch_1 = (union wkssvc_NetWkstaInfo *)pyrpc_export_union(&wkssvc_NetWkstaInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union wkssvc_NetWkstaInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->in.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_in_get_parm_error(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_error;
	if (object->in.parm_error == NULL) {
		Py_RETURN_NONE;
	}
	py_parm_error = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.parm_error));
	return py_parm_error;
}

static int py_wkssvc_NetWkstaSetInfo_in_set_parm_error(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.parm_error));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.parm_error");
		return -1;
	}
	object->in.parm_error = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.parm_error);
	if (object->in.parm_error == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.parm_error));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.parm_error = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_out_get_parm_error(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_error;
	if (object->out.parm_error == NULL) {
		Py_RETURN_NONE;
	}
	py_parm_error = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.parm_error));
	return py_parm_error;
}

static int py_wkssvc_NetWkstaSetInfo_out_set_parm_error(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.parm_error));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.parm_error");
		return -1;
	}
	object->out.parm_error = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.parm_error);
	if (object->out.parm_error == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.parm_error));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.parm_error = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetWkstaSetInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaSetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetWkstaSetInfo_in_get_server_name,
		.set = py_wkssvc_NetWkstaSetInfo_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_wkssvc_NetWkstaSetInfo_in_get_level,
		.set = py_wkssvc_NetWkstaSetInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_wkssvc_NetWkstaSetInfo_in_get_info,
		.set = py_wkssvc_NetWkstaSetInfo_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaInfo")
	},
	{
		.name = discard_const_p(char, "in_parm_error"),
		.get = py_wkssvc_NetWkstaSetInfo_in_get_parm_error,
		.set = py_wkssvc_NetWkstaSetInfo_in_set_parm_error,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_parm_error"),
		.get = py_wkssvc_NetWkstaSetInfo_out_get_parm_error,
		.set = py_wkssvc_NetWkstaSetInfo_out_set_parm_error,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetWkstaSetInfo_get_result,
		.set = py_wkssvc_NetWkstaSetInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaSetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetWkstaSetInfo, type);
	struct wkssvc_NetWkstaSetInfo *_self = (struct wkssvc_NetWkstaSetInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info = talloc_zero(mem_ctx, union wkssvc_NetWkstaInfo);
	_self->in.parm_error = talloc_zero(mem_ctx, uint32_t);
	_self->out.parm_error = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaSetInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaSetInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaSetInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaSetInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaSetInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaSetInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaSetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaSetInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[1];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaSetInfo_ndr_print(py_obj, "wkssvc_NetWkstaSetInfo_in", NDR_IN);
}

static PyObject *py_wkssvc_NetWkstaSetInfo_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaSetInfo_ndr_print(py_obj, "wkssvc_NetWkstaSetInfo_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetWkstaSetInfo_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetWkstaSetInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetWkstaSetInfo.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaSetInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaSetInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaSetInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaSetInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetWkstaSetInfo_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetWkstaSetInfo_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetWkstaSetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaSetInfo",
	.tp_getset = py_wkssvc_NetWkstaSetInfo_getsetters,
	.tp_methods = py_wkssvc_NetWkstaSetInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaSetInfo_new,
};

static bool pack_py_wkssvc_NetWkstaSetInfo_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetWkstaSetInfo *r)
{
	PyObject *py_server_name;
	PyObject *py_level;
	PyObject *py_info;
	PyObject *py_parm_error;
	const char *kwnames[] = {
		"server_name", "level", "info", "parm_error", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetWkstaSetInfo", discard_const_p(char *, kwnames), &py_server_name, &py_level, &py_info, &py_parm_error)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union wkssvc_NetWkstaInfo *info_switch_1;
		info_switch_1 = (union wkssvc_NetWkstaInfo *)pyrpc_export_union(&wkssvc_NetWkstaInfo_Type, r, r->in.level, py_info, "union wkssvc_NetWkstaInfo");
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	if (py_parm_error == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.parm_error");
		return false;
	}
	r->in.parm_error = talloc_ptrtype(r, r->in.parm_error);
	if (r->in.parm_error == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.parm_error));
		if (PyLong_Check(py_parm_error)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_parm_error);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.parm_error = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetWkstaSetInfo_args_out(struct wkssvc_NetWkstaSetInfo *r)
{
	PyObject *result;
	PyObject *py_parm_error;
	py_parm_error = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.parm_error));
	result = py_parm_error;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetWkstaEnumUsers_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetWkstaEnumUsers_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_in_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wkssvc_NetWkstaEnumUsersInfo_Type, object->in.info, object->in.info);
	return py_info;
}

static int py_wkssvc_NetWkstaEnumUsers_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaEnumUsersInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info = (struct wkssvc_NetWkstaEnumUsersInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_out_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wkssvc_NetWkstaEnumUsersInfo_Type, object->out.info, object->out.info);
	return py_info;
}

static int py_wkssvc_NetWkstaEnumUsers_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaEnumUsersInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.info = (struct wkssvc_NetWkstaEnumUsersInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_in_get_prefmaxlen(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_prefmaxlen;
	py_prefmaxlen = PyLong_FromUnsignedLongLong((uint32_t)(object->in.prefmaxlen));
	return py_prefmaxlen;
}

static int py_wkssvc_NetWkstaEnumUsers_in_set_prefmaxlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.prefmaxlen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.prefmaxlen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.prefmaxlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_out_get_entries_read(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_entries_read;
	if (object->out.entries_read == NULL) {
		Py_RETURN_NONE;
	}
	py_entries_read = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.entries_read));
	return py_entries_read;
}

static int py_wkssvc_NetWkstaEnumUsers_out_set_entries_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.entries_read));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.entries_read");
		return -1;
	}
	object->out.entries_read = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.entries_read);
	if (object->out.entries_read == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.entries_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.entries_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_wkssvc_NetWkstaEnumUsers_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_wkssvc_NetWkstaEnumUsers_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetWkstaEnumUsers_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaEnumUsers_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetWkstaEnumUsers_in_get_server_name,
		.set = py_wkssvc_NetWkstaEnumUsers_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_wkssvc_NetWkstaEnumUsers_in_get_info,
		.set = py_wkssvc_NetWkstaEnumUsers_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaEnumUsersInfo")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_wkssvc_NetWkstaEnumUsers_out_get_info,
		.set = py_wkssvc_NetWkstaEnumUsers_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaEnumUsersInfo")
	},
	{
		.name = discard_const_p(char, "in_prefmaxlen"),
		.get = py_wkssvc_NetWkstaEnumUsers_in_get_prefmaxlen,
		.set = py_wkssvc_NetWkstaEnumUsers_in_set_prefmaxlen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_entries_read"),
		.get = py_wkssvc_NetWkstaEnumUsers_out_get_entries_read,
		.set = py_wkssvc_NetWkstaEnumUsers_out_set_entries_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_wkssvc_NetWkstaEnumUsers_in_get_resume_handle,
		.set = py_wkssvc_NetWkstaEnumUsers_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_wkssvc_NetWkstaEnumUsers_out_get_resume_handle,
		.set = py_wkssvc_NetWkstaEnumUsers_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetWkstaEnumUsers_get_result,
		.set = py_wkssvc_NetWkstaEnumUsers_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaEnumUsers_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetWkstaEnumUsers, type);
	struct wkssvc_NetWkstaEnumUsers *_self = (struct wkssvc_NetWkstaEnumUsers *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info = talloc_zero(mem_ctx, struct wkssvc_NetWkstaEnumUsersInfo);
	_self->out.info = talloc_zero(mem_ctx, struct wkssvc_NetWkstaEnumUsersInfo);
	_self->out.entries_read = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaEnumUsers_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaEnumUsers_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaEnumUsers_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaEnumUsers_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaEnumUsers_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaEnumUsers_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaEnumUsers *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaEnumUsers_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[2];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaEnumUsers_ndr_print(py_obj, "wkssvc_NetWkstaEnumUsers_in", NDR_IN);
}

static PyObject *py_wkssvc_NetWkstaEnumUsers_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaEnumUsers_ndr_print(py_obj, "wkssvc_NetWkstaEnumUsers_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetWkstaEnumUsers_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetWkstaEnumUsers_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetWkstaEnumUsers.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaEnumUsers_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaEnumUsers_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaEnumUsers_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaEnumUsers_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetWkstaEnumUsers_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetWkstaEnumUsers_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetWkstaEnumUsers_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaEnumUsers",
	.tp_getset = py_wkssvc_NetWkstaEnumUsers_getsetters,
	.tp_methods = py_wkssvc_NetWkstaEnumUsers_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaEnumUsers_new,
};

static bool pack_py_wkssvc_NetWkstaEnumUsers_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetWkstaEnumUsers *r)
{
	PyObject *py_server_name;
	PyObject *py_info;
	PyObject *py_prefmaxlen;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"server_name", "info", "prefmaxlen", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetWkstaEnumUsers", discard_const_p(char *, kwnames), &py_server_name, &py_info, &py_prefmaxlen, &py_resume_handle)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaEnumUsersInfo_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct wkssvc_NetWkstaEnumUsersInfo *)pytalloc_get_ptr(py_info);
	if (py_prefmaxlen == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.prefmaxlen");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.prefmaxlen));
		if (PyLong_Check(py_prefmaxlen)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_prefmaxlen);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.prefmaxlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		if (r->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
			if (PyLong_Check(py_resume_handle)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetWkstaEnumUsers_args_out(struct wkssvc_NetWkstaEnumUsers *r)
{
	PyObject *result;
	PyObject *py_info;
	PyObject *py_entries_read;
	PyObject *py_resume_handle;
	result = PyTuple_New(3);
	py_info = pytalloc_reference_ex(&wkssvc_NetWkstaEnumUsersInfo_Type, r->out.info, r->out.info);
	PyTuple_SetItem(result, 0, py_info);
	py_entries_read = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.entries_read));
	PyTuple_SetItem(result, 1, py_entries_read);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	}
	PyTuple_SetItem(result, 2, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrWkstaUserGetInfo_in_get_unknown(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	if (object->in.unknown == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.unknown == NULL) {
		py_unknown = Py_None;
		Py_INCREF(py_unknown);
	} else {
		if (object->in.unknown == NULL) {
			py_unknown = Py_None;
			Py_INCREF(py_unknown);
		} else {
			py_unknown = PyUnicode_Decode(object->in.unknown, strlen(object->in.unknown), "utf-8", "ignore");
		}
	}
	return py_unknown;
}

static int py_wkssvc_NetrWkstaUserGetInfo_in_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unknown");
		return -1;
	}
	if (value == Py_None) {
		object->in.unknown = NULL;
	} else {
		object->in.unknown = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.unknown = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_in_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_wkssvc_NetrWkstaUserGetInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_out_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&wkssvc_NetrWkstaUserInfo_Type, object->out.info, object->in.level, object->out.info, "union wkssvc_NetrWkstaUserInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_wkssvc_NetrWkstaUserGetInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union wkssvc_NetrWkstaUserInfo *info_switch_1;
		info_switch_1 = (union wkssvc_NetrWkstaUserInfo *)pyrpc_export_union(&wkssvc_NetrWkstaUserInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union wkssvc_NetrWkstaUserInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->out.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrWkstaUserGetInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWkstaUserGetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_unknown"),
		.get = py_wkssvc_NetrWkstaUserGetInfo_in_get_unknown,
		.set = py_wkssvc_NetrWkstaUserGetInfo_in_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_wkssvc_NetrWkstaUserGetInfo_in_get_level,
		.set = py_wkssvc_NetrWkstaUserGetInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_wkssvc_NetrWkstaUserGetInfo_out_get_info,
		.set = py_wkssvc_NetrWkstaUserGetInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrWkstaUserInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrWkstaUserGetInfo_get_result,
		.set = py_wkssvc_NetrWkstaUserGetInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrWkstaUserGetInfo, type);
	struct wkssvc_NetrWkstaUserGetInfo *_self = (struct wkssvc_NetrWkstaUserGetInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.info = talloc_zero(mem_ctx, union wkssvc_NetrWkstaUserInfo);
	return self;
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaUserGetInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaUserGetInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaUserGetInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaUserGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaUserGetInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[3];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaUserGetInfo_ndr_print(py_obj, "wkssvc_NetrWkstaUserGetInfo_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrWkstaUserGetInfo_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaUserGetInfo_ndr_print(py_obj, "wkssvc_NetrWkstaUserGetInfo_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrWkstaUserGetInfo_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrWkstaUserGetInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrWkstaUserGetInfo.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserGetInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserGetInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserGetInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrWkstaUserGetInfo_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrWkstaUserGetInfo_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrWkstaUserGetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaUserGetInfo",
	.tp_getset = py_wkssvc_NetrWkstaUserGetInfo_getsetters,
	.tp_methods = py_wkssvc_NetrWkstaUserGetInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaUserGetInfo_new,
};

static bool pack_py_wkssvc_NetrWkstaUserGetInfo_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrWkstaUserGetInfo *r)
{
	PyObject *py_unknown;
	PyObject *py_level;
	const char *kwnames[] = {
		"unknown", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wkssvc_NetrWkstaUserGetInfo", discard_const_p(char *, kwnames), &py_unknown, &py_level)) {
		return false;
	}

	if (py_unknown == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unknown");
		return false;
	}
	if (py_unknown == Py_None) {
		r->in.unknown = NULL;
	} else {
		r->in.unknown = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_unknown)) {
				unicode = PyUnicode_AsEncodedString(py_unknown, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_unknown)) {
				test_str = PyBytes_AS_STRING(py_unknown);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_unknown)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.unknown = talloc_str;
		}
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrWkstaUserGetInfo_args_out(struct wkssvc_NetrWkstaUserGetInfo *r)
{
	PyObject *result;
	PyObject *py_info;
	py_info = pyrpc_import_union(&wkssvc_NetrWkstaUserInfo_Type, r->out.info, r->in.level, r->out.info, "union wkssvc_NetrWkstaUserInfo");
	if (py_info == NULL) {
		return NULL;
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrWkstaUserSetInfo_in_get_unknown(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	if (object->in.unknown == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.unknown == NULL) {
		py_unknown = Py_None;
		Py_INCREF(py_unknown);
	} else {
		if (object->in.unknown == NULL) {
			py_unknown = Py_None;
			Py_INCREF(py_unknown);
		} else {
			py_unknown = PyUnicode_Decode(object->in.unknown, strlen(object->in.unknown), "utf-8", "ignore");
		}
	}
	return py_unknown;
}

static int py_wkssvc_NetrWkstaUserSetInfo_in_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unknown");
		return -1;
	}
	if (value == Py_None) {
		object->in.unknown = NULL;
	} else {
		object->in.unknown = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.unknown = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_in_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_wkssvc_NetrWkstaUserSetInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_in_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&wkssvc_NetrWkstaUserInfo_Type, object->in.info, object->in.level, object->in.info, "union wkssvc_NetrWkstaUserInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_wkssvc_NetrWkstaUserSetInfo_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union wkssvc_NetrWkstaUserInfo *info_switch_1;
		info_switch_1 = (union wkssvc_NetrWkstaUserInfo *)pyrpc_export_union(&wkssvc_NetrWkstaUserInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union wkssvc_NetrWkstaUserInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->in.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_in_get_parm_err(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_err;
	if (object->in.parm_err == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.parm_err));
	}
	return py_parm_err;
}

static int py_wkssvc_NetrWkstaUserSetInfo_in_set_parm_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.parm_err));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.parm_err");
		return -1;
	}
	if (value == Py_None) {
		object->in.parm_err = NULL;
	} else {
		object->in.parm_err = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.parm_err);
		if (object->in.parm_err == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.parm_err));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_out_get_parm_err(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_err;
	if (object->out.parm_err == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.parm_err));
	}
	return py_parm_err;
}

static int py_wkssvc_NetrWkstaUserSetInfo_out_set_parm_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.parm_err));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.parm_err");
		return -1;
	}
	if (value == Py_None) {
		object->out.parm_err = NULL;
	} else {
		object->out.parm_err = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.parm_err);
		if (object->out.parm_err == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.parm_err));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrWkstaUserSetInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWkstaUserSetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_unknown"),
		.get = py_wkssvc_NetrWkstaUserSetInfo_in_get_unknown,
		.set = py_wkssvc_NetrWkstaUserSetInfo_in_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_wkssvc_NetrWkstaUserSetInfo_in_get_level,
		.set = py_wkssvc_NetrWkstaUserSetInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_wkssvc_NetrWkstaUserSetInfo_in_get_info,
		.set = py_wkssvc_NetrWkstaUserSetInfo_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrWkstaUserInfo")
	},
	{
		.name = discard_const_p(char, "in_parm_err"),
		.get = py_wkssvc_NetrWkstaUserSetInfo_in_get_parm_err,
		.set = py_wkssvc_NetrWkstaUserSetInfo_in_set_parm_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_parm_err"),
		.get = py_wkssvc_NetrWkstaUserSetInfo_out_get_parm_err,
		.set = py_wkssvc_NetrWkstaUserSetInfo_out_set_parm_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrWkstaUserSetInfo_get_result,
		.set = py_wkssvc_NetrWkstaUserSetInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrWkstaUserSetInfo, type);
	struct wkssvc_NetrWkstaUserSetInfo *_self = (struct wkssvc_NetrWkstaUserSetInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info = talloc_zero(mem_ctx, union wkssvc_NetrWkstaUserInfo);
	return self;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaUserSetInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaUserSetInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaUserSetInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaUserSetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaUserSetInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[4];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaUserSetInfo_ndr_print(py_obj, "wkssvc_NetrWkstaUserSetInfo_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrWkstaUserSetInfo_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaUserSetInfo_ndr_print(py_obj, "wkssvc_NetrWkstaUserSetInfo_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrWkstaUserSetInfo_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrWkstaUserSetInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrWkstaUserSetInfo.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserSetInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserSetInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaUserSetInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrWkstaUserSetInfo_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrWkstaUserSetInfo_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrWkstaUserSetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaUserSetInfo",
	.tp_getset = py_wkssvc_NetrWkstaUserSetInfo_getsetters,
	.tp_methods = py_wkssvc_NetrWkstaUserSetInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaUserSetInfo_new,
};

static bool pack_py_wkssvc_NetrWkstaUserSetInfo_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrWkstaUserSetInfo *r)
{
	PyObject *py_unknown;
	PyObject *py_level;
	PyObject *py_info;
	PyObject *py_parm_err;
	const char *kwnames[] = {
		"unknown", "level", "info", "parm_err", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrWkstaUserSetInfo", discard_const_p(char *, kwnames), &py_unknown, &py_level, &py_info, &py_parm_err)) {
		return false;
	}

	if (py_unknown == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unknown");
		return false;
	}
	if (py_unknown == Py_None) {
		r->in.unknown = NULL;
	} else {
		r->in.unknown = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_unknown)) {
				unicode = PyUnicode_AsEncodedString(py_unknown, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_unknown)) {
				test_str = PyBytes_AS_STRING(py_unknown);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_unknown)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.unknown = talloc_str;
		}
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union wkssvc_NetrWkstaUserInfo *info_switch_1;
		info_switch_1 = (union wkssvc_NetrWkstaUserInfo *)pyrpc_export_union(&wkssvc_NetrWkstaUserInfo_Type, r, r->in.level, py_info, "union wkssvc_NetrWkstaUserInfo");
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	if (py_parm_err == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.parm_err");
		return false;
	}
	if (py_parm_err == Py_None) {
		r->in.parm_err = NULL;
	} else {
		r->in.parm_err = talloc_ptrtype(r, r->in.parm_err);
		if (r->in.parm_err == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.parm_err));
			if (PyLong_Check(py_parm_err)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_parm_err);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrWkstaUserSetInfo_args_out(struct wkssvc_NetrWkstaUserSetInfo *r)
{
	PyObject *result;
	PyObject *py_parm_err;
	if (r->out.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.parm_err));
	}
	result = py_parm_err;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetWkstaTransportEnum_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetWkstaTransportEnum_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_in_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wkssvc_NetWkstaTransportInfo_Type, object->in.info, object->in.info);
	return py_info;
}

static int py_wkssvc_NetWkstaTransportEnum_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaTransportInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info = (struct wkssvc_NetWkstaTransportInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_out_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wkssvc_NetWkstaTransportInfo_Type, object->out.info, object->out.info);
	return py_info;
}

static int py_wkssvc_NetWkstaTransportEnum_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaTransportInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.info = (struct wkssvc_NetWkstaTransportInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_in_get_max_buffer(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_max_buffer;
	py_max_buffer = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_buffer));
	return py_max_buffer;
}

static int py_wkssvc_NetWkstaTransportEnum_in_set_max_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.max_buffer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_buffer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_buffer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_out_get_total_entries(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_total_entries;
	if (object->out.total_entries == NULL) {
		Py_RETURN_NONE;
	}
	py_total_entries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.total_entries));
	return py_total_entries;
}

static int py_wkssvc_NetWkstaTransportEnum_out_set_total_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.total_entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.total_entries");
		return -1;
	}
	object->out.total_entries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.total_entries);
	if (object->out.total_entries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.total_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.total_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_wkssvc_NetWkstaTransportEnum_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_wkssvc_NetWkstaTransportEnum_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetWkstaTransportEnum_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetWkstaTransportEnum_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetWkstaTransportEnum_in_get_server_name,
		.set = py_wkssvc_NetWkstaTransportEnum_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_wkssvc_NetWkstaTransportEnum_in_get_info,
		.set = py_wkssvc_NetWkstaTransportEnum_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaTransportInfo")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_wkssvc_NetWkstaTransportEnum_out_get_info,
		.set = py_wkssvc_NetWkstaTransportEnum_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaTransportInfo")
	},
	{
		.name = discard_const_p(char, "in_max_buffer"),
		.get = py_wkssvc_NetWkstaTransportEnum_in_get_max_buffer,
		.set = py_wkssvc_NetWkstaTransportEnum_in_set_max_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_total_entries"),
		.get = py_wkssvc_NetWkstaTransportEnum_out_get_total_entries,
		.set = py_wkssvc_NetWkstaTransportEnum_out_set_total_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_wkssvc_NetWkstaTransportEnum_in_get_resume_handle,
		.set = py_wkssvc_NetWkstaTransportEnum_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_wkssvc_NetWkstaTransportEnum_out_get_resume_handle,
		.set = py_wkssvc_NetWkstaTransportEnum_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetWkstaTransportEnum_get_result,
		.set = py_wkssvc_NetWkstaTransportEnum_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetWkstaTransportEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetWkstaTransportEnum, type);
	struct wkssvc_NetWkstaTransportEnum *_self = (struct wkssvc_NetWkstaTransportEnum *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info = talloc_zero(mem_ctx, struct wkssvc_NetWkstaTransportInfo);
	_self->out.info = talloc_zero(mem_ctx, struct wkssvc_NetWkstaTransportInfo);
	_self->out.total_entries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaTransportEnum_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaTransportEnum_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetWkstaTransportEnum_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaTransportEnum_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaTransportEnum_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetWkstaTransportEnum_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetWkstaTransportEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetWkstaTransportEnum_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[5];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaTransportEnum_ndr_print(py_obj, "wkssvc_NetWkstaTransportEnum_in", NDR_IN);
}

static PyObject *py_wkssvc_NetWkstaTransportEnum_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetWkstaTransportEnum_ndr_print(py_obj, "wkssvc_NetWkstaTransportEnum_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetWkstaTransportEnum_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetWkstaTransportEnum_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetWkstaTransportEnum.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaTransportEnum_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaTransportEnum_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaTransportEnum_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetWkstaTransportEnum_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetWkstaTransportEnum_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetWkstaTransportEnum_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetWkstaTransportEnum_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetWkstaTransportEnum",
	.tp_getset = py_wkssvc_NetWkstaTransportEnum_getsetters,
	.tp_methods = py_wkssvc_NetWkstaTransportEnum_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetWkstaTransportEnum_new,
};

static bool pack_py_wkssvc_NetWkstaTransportEnum_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetWkstaTransportEnum *r)
{
	PyObject *py_server_name;
	PyObject *py_info;
	PyObject *py_max_buffer;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"server_name", "info", "max_buffer", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetWkstaTransportEnum", discard_const_p(char *, kwnames), &py_server_name, &py_info, &py_max_buffer, &py_resume_handle)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaTransportInfo_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct wkssvc_NetWkstaTransportInfo *)pytalloc_get_ptr(py_info);
	if (py_max_buffer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.max_buffer");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_buffer));
		if (PyLong_Check(py_max_buffer)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_buffer);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_buffer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		if (r->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
			if (PyLong_Check(py_resume_handle)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetWkstaTransportEnum_args_out(struct wkssvc_NetWkstaTransportEnum *r)
{
	PyObject *result;
	PyObject *py_info;
	PyObject *py_total_entries;
	PyObject *py_resume_handle;
	result = PyTuple_New(3);
	py_info = pytalloc_reference_ex(&wkssvc_NetWkstaTransportInfo_Type, r->out.info, r->out.info);
	PyTuple_SetItem(result, 0, py_info);
	py_total_entries = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.total_entries));
	PyTuple_SetItem(result, 1, py_total_entries);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	}
	PyTuple_SetItem(result, 2, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrWkstaTransportAdd_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrWkstaTransportAdd_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_in_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_wkssvc_NetrWkstaTransportAdd_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_in_get_info0(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_info0;
	if (object->in.info0 == NULL) {
		Py_RETURN_NONE;
	}
	py_info0 = pytalloc_reference_ex(&wkssvc_NetWkstaTransportInfo0_Type, object->in.info0, object->in.info0);
	return py_info0;
}

static int py_wkssvc_NetrWkstaTransportAdd_in_set_info0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info0));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info0");
		return -1;
	}
	object->in.info0 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info0);
	if (object->in.info0 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaTransportInfo0_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info0 = (struct wkssvc_NetWkstaTransportInfo0 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_in_get_parm_err(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_err;
	if (object->in.parm_err == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.parm_err));
	}
	return py_parm_err;
}

static int py_wkssvc_NetrWkstaTransportAdd_in_set_parm_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.parm_err));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.parm_err");
		return -1;
	}
	if (value == Py_None) {
		object->in.parm_err = NULL;
	} else {
		object->in.parm_err = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.parm_err);
		if (object->in.parm_err == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.parm_err));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_out_get_parm_err(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_err;
	if (object->out.parm_err == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.parm_err));
	}
	return py_parm_err;
}

static int py_wkssvc_NetrWkstaTransportAdd_out_set_parm_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.parm_err));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.parm_err");
		return -1;
	}
	if (value == Py_None) {
		object->out.parm_err = NULL;
	} else {
		object->out.parm_err = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.parm_err);
		if (object->out.parm_err == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.parm_err));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrWkstaTransportAdd_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWkstaTransportAdd_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrWkstaTransportAdd_in_get_server_name,
		.set = py_wkssvc_NetrWkstaTransportAdd_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_wkssvc_NetrWkstaTransportAdd_in_get_level,
		.set = py_wkssvc_NetrWkstaTransportAdd_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_info0"),
		.get = py_wkssvc_NetrWkstaTransportAdd_in_get_info0,
		.set = py_wkssvc_NetrWkstaTransportAdd_in_set_info0,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetWkstaTransportInfo0")
	},
	{
		.name = discard_const_p(char, "in_parm_err"),
		.get = py_wkssvc_NetrWkstaTransportAdd_in_get_parm_err,
		.set = py_wkssvc_NetrWkstaTransportAdd_in_set_parm_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_parm_err"),
		.get = py_wkssvc_NetrWkstaTransportAdd_out_get_parm_err,
		.set = py_wkssvc_NetrWkstaTransportAdd_out_set_parm_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrWkstaTransportAdd_get_result,
		.set = py_wkssvc_NetrWkstaTransportAdd_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWkstaTransportAdd_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrWkstaTransportAdd, type);
	struct wkssvc_NetrWkstaTransportAdd *_self = (struct wkssvc_NetrWkstaTransportAdd *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info0 = talloc_zero(mem_ctx, struct wkssvc_NetWkstaTransportInfo0);
	return self;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaTransportAdd_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaTransportAdd_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaTransportAdd_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaTransportAdd_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaTransportAdd_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaTransportAdd_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaTransportAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaTransportAdd_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[6];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaTransportAdd_ndr_print(py_obj, "wkssvc_NetrWkstaTransportAdd_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrWkstaTransportAdd_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaTransportAdd_ndr_print(py_obj, "wkssvc_NetrWkstaTransportAdd_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrWkstaTransportAdd_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrWkstaTransportAdd_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrWkstaTransportAdd.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportAdd_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportAdd_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportAdd_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportAdd_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrWkstaTransportAdd_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrWkstaTransportAdd_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrWkstaTransportAdd_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaTransportAdd",
	.tp_getset = py_wkssvc_NetrWkstaTransportAdd_getsetters,
	.tp_methods = py_wkssvc_NetrWkstaTransportAdd_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaTransportAdd_new,
};

static bool pack_py_wkssvc_NetrWkstaTransportAdd_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrWkstaTransportAdd *r)
{
	PyObject *py_server_name;
	PyObject *py_level;
	PyObject *py_info0;
	PyObject *py_parm_err;
	const char *kwnames[] = {
		"server_name", "level", "info0", "parm_err", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrWkstaTransportAdd", discard_const_p(char *, kwnames), &py_server_name, &py_level, &py_info0, &py_parm_err)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info0 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info0");
		return false;
	}
	r->in.info0 = talloc_ptrtype(r, r->in.info0);
	if (r->in.info0 == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wkssvc_NetWkstaTransportInfo0_Type, py_info0, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info0)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info0 = (struct wkssvc_NetWkstaTransportInfo0 *)pytalloc_get_ptr(py_info0);
	if (py_parm_err == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.parm_err");
		return false;
	}
	if (py_parm_err == Py_None) {
		r->in.parm_err = NULL;
	} else {
		r->in.parm_err = talloc_ptrtype(r, r->in.parm_err);
		if (r->in.parm_err == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.parm_err));
			if (PyLong_Check(py_parm_err)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_parm_err);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrWkstaTransportAdd_args_out(struct wkssvc_NetrWkstaTransportAdd *r)
{
	PyObject *result;
	PyObject *py_parm_err;
	if (r->out.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.parm_err));
	}
	result = py_parm_err;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrWkstaTransportDel_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrWkstaTransportDel_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_in_get_transport_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_name;
	if (object->in.transport_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.transport_name == NULL) {
		py_transport_name = Py_None;
		Py_INCREF(py_transport_name);
	} else {
		if (object->in.transport_name == NULL) {
			py_transport_name = Py_None;
			Py_INCREF(py_transport_name);
		} else {
			py_transport_name = PyUnicode_Decode(object->in.transport_name, strlen(object->in.transport_name), "utf-8", "ignore");
		}
	}
	return py_transport_name;
}

static int py_wkssvc_NetrWkstaTransportDel_in_set_transport_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.transport_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.transport_name = NULL;
	} else {
		object->in.transport_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.transport_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_in_get_unknown3(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown3));
	return py_unknown3;
}

static int py_wkssvc_NetrWkstaTransportDel_in_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrWkstaTransportDel_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWkstaTransportDel_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrWkstaTransportDel_in_get_server_name,
		.set = py_wkssvc_NetrWkstaTransportDel_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_transport_name"),
		.get = py_wkssvc_NetrWkstaTransportDel_in_get_transport_name,
		.set = py_wkssvc_NetrWkstaTransportDel_in_set_transport_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_unknown3"),
		.get = py_wkssvc_NetrWkstaTransportDel_in_get_unknown3,
		.set = py_wkssvc_NetrWkstaTransportDel_in_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrWkstaTransportDel_get_result,
		.set = py_wkssvc_NetrWkstaTransportDel_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWkstaTransportDel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrWkstaTransportDel, type);
	return self;
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaTransportDel_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaTransportDel_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWkstaTransportDel_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaTransportDel_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaTransportDel_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWkstaTransportDel_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWkstaTransportDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWkstaTransportDel_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[7];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaTransportDel_ndr_print(py_obj, "wkssvc_NetrWkstaTransportDel_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrWkstaTransportDel_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWkstaTransportDel_ndr_print(py_obj, "wkssvc_NetrWkstaTransportDel_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrWkstaTransportDel_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrWkstaTransportDel_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrWkstaTransportDel.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportDel_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportDel_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportDel_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWkstaTransportDel_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrWkstaTransportDel_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrWkstaTransportDel_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrWkstaTransportDel_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWkstaTransportDel",
	.tp_getset = py_wkssvc_NetrWkstaTransportDel_getsetters,
	.tp_methods = py_wkssvc_NetrWkstaTransportDel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWkstaTransportDel_new,
};

static bool pack_py_wkssvc_NetrWkstaTransportDel_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrWkstaTransportDel *r)
{
	PyObject *py_server_name;
	PyObject *py_transport_name;
	PyObject *py_unknown3;
	const char *kwnames[] = {
		"server_name", "transport_name", "unknown3", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:wkssvc_NetrWkstaTransportDel", discard_const_p(char *, kwnames), &py_server_name, &py_transport_name, &py_unknown3)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_transport_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.transport_name");
		return false;
	}
	if (py_transport_name == Py_None) {
		r->in.transport_name = NULL;
	} else {
		r->in.transport_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_transport_name)) {
				unicode = PyUnicode_AsEncodedString(py_transport_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_transport_name)) {
				test_str = PyBytes_AS_STRING(py_transport_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_transport_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.transport_name = talloc_str;
		}
	}
	if (py_unknown3 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unknown3");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown3));
		if (PyLong_Check(py_unknown3)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown3);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrWkstaTransportDel_args_out(struct wkssvc_NetrWkstaTransportDel *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrUseAdd_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrUseAdd_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseAdd_in_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_wkssvc_NetrUseAdd_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseAdd_in_get_ctr(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	if (object->in.ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_ctr = pyrpc_import_union(&wkssvc_NetrUseGetInfoCtr_Type, object->in.ctr, object->in.level, object->in.ctr, "union wkssvc_NetrUseGetInfoCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_wkssvc_NetrUseAdd_in_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ctr");
		return -1;
	}
	object->in.ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.ctr);
	if (object->in.ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union wkssvc_NetrUseGetInfoCtr *ctr_switch_1;
		ctr_switch_1 = (union wkssvc_NetrUseGetInfoCtr *)pyrpc_export_union(&wkssvc_NetrUseGetInfoCtr_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union wkssvc_NetrUseGetInfoCtr");
		if (ctr_switch_1 == NULL) {
			return -1;
		}
		object->in.ctr = ctr_switch_1;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseAdd_in_get_parm_err(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_err;
	if (object->in.parm_err == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.parm_err));
	}
	return py_parm_err;
}

static int py_wkssvc_NetrUseAdd_in_set_parm_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.parm_err));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.parm_err");
		return -1;
	}
	if (value == Py_None) {
		object->in.parm_err = NULL;
	} else {
		object->in.parm_err = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.parm_err);
		if (object->in.parm_err == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.parm_err));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseAdd_out_get_parm_err(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_parm_err;
	if (object->out.parm_err == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.parm_err));
	}
	return py_parm_err;
}

static int py_wkssvc_NetrUseAdd_out_set_parm_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.parm_err));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.parm_err");
		return -1;
	}
	if (value == Py_None) {
		object->out.parm_err = NULL;
	} else {
		object->out.parm_err = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.parm_err);
		if (object->out.parm_err == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.parm_err));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseAdd_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrUseAdd_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseAdd_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrUseAdd_in_get_server_name,
		.set = py_wkssvc_NetrUseAdd_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_wkssvc_NetrUseAdd_in_get_level,
		.set = py_wkssvc_NetrUseAdd_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_ctr"),
		.get = py_wkssvc_NetrUseAdd_in_get_ctr,
		.set = py_wkssvc_NetrUseAdd_in_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseGetInfoCtr")
	},
	{
		.name = discard_const_p(char, "in_parm_err"),
		.get = py_wkssvc_NetrUseAdd_in_get_parm_err,
		.set = py_wkssvc_NetrUseAdd_in_set_parm_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_parm_err"),
		.get = py_wkssvc_NetrUseAdd_out_get_parm_err,
		.set = py_wkssvc_NetrUseAdd_out_set_parm_err,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrUseAdd_get_result,
		.set = py_wkssvc_NetrUseAdd_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseAdd_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrUseAdd, type);
	struct wkssvc_NetrUseAdd *_self = (struct wkssvc_NetrUseAdd *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.ctr = talloc_zero(mem_ctx, union wkssvc_NetrUseGetInfoCtr);
	return self;
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseAdd_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseAdd_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseAdd_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseAdd_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseAdd_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseAdd_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseAdd_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[8];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseAdd_ndr_print(py_obj, "wkssvc_NetrUseAdd_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrUseAdd_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseAdd_ndr_print(py_obj, "wkssvc_NetrUseAdd_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrUseAdd_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrUseAdd_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrUseAdd.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseAdd_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseAdd_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseAdd_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseAdd_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrUseAdd_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrUseAdd_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrUseAdd_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseAdd",
	.tp_getset = py_wkssvc_NetrUseAdd_getsetters,
	.tp_methods = py_wkssvc_NetrUseAdd_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseAdd_new,
};

static bool pack_py_wkssvc_NetrUseAdd_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrUseAdd *r)
{
	PyObject *py_server_name;
	PyObject *py_level;
	PyObject *py_ctr;
	PyObject *py_parm_err;
	const char *kwnames[] = {
		"server_name", "level", "ctr", "parm_err", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrUseAdd", discard_const_p(char *, kwnames), &py_server_name, &py_level, &py_ctr, &py_parm_err)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_ctr == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ctr");
		return false;
	}
	r->in.ctr = talloc_ptrtype(r, r->in.ctr);
	if (r->in.ctr == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union wkssvc_NetrUseGetInfoCtr *ctr_switch_1;
		ctr_switch_1 = (union wkssvc_NetrUseGetInfoCtr *)pyrpc_export_union(&wkssvc_NetrUseGetInfoCtr_Type, r, r->in.level, py_ctr, "union wkssvc_NetrUseGetInfoCtr");
		if (ctr_switch_1 == NULL) {
			return false;
		}
		r->in.ctr = ctr_switch_1;
	}
	if (py_parm_err == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.parm_err");
		return false;
	}
	if (py_parm_err == Py_None) {
		r->in.parm_err = NULL;
	} else {
		r->in.parm_err = talloc_ptrtype(r, r->in.parm_err);
		if (r->in.parm_err == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.parm_err));
			if (PyLong_Check(py_parm_err)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_parm_err);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.parm_err = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrUseAdd_args_out(struct wkssvc_NetrUseAdd *r)
{
	PyObject *result;
	PyObject *py_parm_err;
	if (r->out.parm_err == NULL) {
		py_parm_err = Py_None;
		Py_INCREF(py_parm_err);
	} else {
		py_parm_err = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.parm_err));
	}
	result = py_parm_err;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrUseGetInfo_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrUseGetInfo_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseGetInfo_in_get_use_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_use_name;
	if (object->in.use_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.use_name == NULL) {
		py_use_name = Py_None;
		Py_INCREF(py_use_name);
	} else {
		py_use_name = PyUnicode_Decode(object->in.use_name, strlen(object->in.use_name), "utf-8", "ignore");
	}
	return py_use_name;
}

static int py_wkssvc_NetrUseGetInfo_in_set_use_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.use_name");
		return -1;
	}
	object->in.use_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.use_name);
	if (object->in.use_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.use_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseGetInfo_in_get_level(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_wkssvc_NetrUseGetInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseGetInfo_out_get_ctr(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	if (object->out.ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_ctr = pyrpc_import_union(&wkssvc_NetrUseGetInfoCtr_Type, object->out.ctr, object->in.level, object->out.ctr, "union wkssvc_NetrUseGetInfoCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_wkssvc_NetrUseGetInfo_out_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.ctr");
		return -1;
	}
	object->out.ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ctr);
	if (object->out.ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union wkssvc_NetrUseGetInfoCtr *ctr_switch_1;
		ctr_switch_1 = (union wkssvc_NetrUseGetInfoCtr *)pyrpc_export_union(&wkssvc_NetrUseGetInfoCtr_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union wkssvc_NetrUseGetInfoCtr");
		if (ctr_switch_1 == NULL) {
			return -1;
		}
		object->out.ctr = ctr_switch_1;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseGetInfo_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrUseGetInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseGetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrUseGetInfo_in_get_server_name,
		.set = py_wkssvc_NetrUseGetInfo_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_use_name"),
		.get = py_wkssvc_NetrUseGetInfo_in_get_use_name,
		.set = py_wkssvc_NetrUseGetInfo_in_set_use_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_wkssvc_NetrUseGetInfo_in_get_level,
		.set = py_wkssvc_NetrUseGetInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_ctr"),
		.get = py_wkssvc_NetrUseGetInfo_out_get_ctr,
		.set = py_wkssvc_NetrUseGetInfo_out_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseGetInfoCtr")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrUseGetInfo_get_result,
		.set = py_wkssvc_NetrUseGetInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseGetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrUseGetInfo, type);
	struct wkssvc_NetrUseGetInfo *_self = (struct wkssvc_NetrUseGetInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.ctr = talloc_zero(mem_ctx, union wkssvc_NetrUseGetInfoCtr);
	return self;
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(9);
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseGetInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[9];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseGetInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseGetInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseGetInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[9];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseGetInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseGetInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseGetInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[9];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseGetInfo_ndr_print(py_obj, "wkssvc_NetrUseGetInfo_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrUseGetInfo_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseGetInfo_ndr_print(py_obj, "wkssvc_NetrUseGetInfo_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrUseGetInfo_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrUseGetInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrUseGetInfo.opnum() -> 9 (0x09) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseGetInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseGetInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseGetInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseGetInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrUseGetInfo_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrUseGetInfo_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrUseGetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseGetInfo",
	.tp_getset = py_wkssvc_NetrUseGetInfo_getsetters,
	.tp_methods = py_wkssvc_NetrUseGetInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseGetInfo_new,
};

static bool pack_py_wkssvc_NetrUseGetInfo_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrUseGetInfo *r)
{
	PyObject *py_server_name;
	PyObject *py_use_name;
	PyObject *py_level;
	const char *kwnames[] = {
		"server_name", "use_name", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:wkssvc_NetrUseGetInfo", discard_const_p(char *, kwnames), &py_server_name, &py_use_name, &py_level)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_use_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.use_name");
		return false;
	}
	r->in.use_name = talloc_ptrtype(r, r->in.use_name);
	if (r->in.use_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_use_name)) {
			unicode = PyUnicode_AsEncodedString(py_use_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_use_name)) {
			test_str = PyBytes_AS_STRING(py_use_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_use_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.use_name = talloc_str;
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrUseGetInfo_args_out(struct wkssvc_NetrUseGetInfo *r)
{
	PyObject *result;
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&wkssvc_NetrUseGetInfoCtr_Type, r->out.ctr, r->in.level, r->out.ctr, "union wkssvc_NetrUseGetInfoCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	result = py_ctr;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrUseDel_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrUseDel_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseDel_in_get_use_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(obj);
	PyObject *py_use_name;
	if (object->in.use_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.use_name == NULL) {
		py_use_name = Py_None;
		Py_INCREF(py_use_name);
	} else {
		py_use_name = PyUnicode_Decode(object->in.use_name, strlen(object->in.use_name), "utf-8", "ignore");
	}
	return py_use_name;
}

static int py_wkssvc_NetrUseDel_in_set_use_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.use_name");
		return -1;
	}
	object->in.use_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.use_name);
	if (object->in.use_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.use_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseDel_in_get_force_cond(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(obj);
	PyObject *py_force_cond;
	py_force_cond = PyLong_FromUnsignedLongLong((uint32_t)(object->in.force_cond));
	return py_force_cond;
}

static int py_wkssvc_NetrUseDel_in_set_force_cond(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.force_cond");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.force_cond));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.force_cond = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseDel_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrUseDel_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseDel_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrUseDel_in_get_server_name,
		.set = py_wkssvc_NetrUseDel_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_use_name"),
		.get = py_wkssvc_NetrUseDel_in_get_use_name,
		.set = py_wkssvc_NetrUseDel_in_set_use_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_force_cond"),
		.get = py_wkssvc_NetrUseDel_in_get_force_cond,
		.set = py_wkssvc_NetrUseDel_in_set_force_cond,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrUseDel_get_result,
		.set = py_wkssvc_NetrUseDel_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseDel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrUseDel, type);
	return self;
}

static PyObject *py_wkssvc_NetrUseDel_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_wkssvc_NetrUseDel_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseDel_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrUseDel_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseDel_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseDel_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseDel_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseDel_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseDel_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrUseDel_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseDel_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseDel_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseDel_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseDel_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseDel_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[10];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrUseDel_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseDel_ndr_print(py_obj, "wkssvc_NetrUseDel_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrUseDel_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseDel_ndr_print(py_obj, "wkssvc_NetrUseDel_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrUseDel_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrUseDel_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrUseDel.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseDel_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseDel_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseDel_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseDel_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrUseDel_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrUseDel_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrUseDel_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseDel",
	.tp_getset = py_wkssvc_NetrUseDel_getsetters,
	.tp_methods = py_wkssvc_NetrUseDel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseDel_new,
};

static bool pack_py_wkssvc_NetrUseDel_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrUseDel *r)
{
	PyObject *py_server_name;
	PyObject *py_use_name;
	PyObject *py_force_cond;
	const char *kwnames[] = {
		"server_name", "use_name", "force_cond", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:wkssvc_NetrUseDel", discard_const_p(char *, kwnames), &py_server_name, &py_use_name, &py_force_cond)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_use_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.use_name");
		return false;
	}
	r->in.use_name = talloc_ptrtype(r, r->in.use_name);
	if (r->in.use_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_use_name)) {
			unicode = PyUnicode_AsEncodedString(py_use_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_use_name)) {
			test_str = PyBytes_AS_STRING(py_use_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_use_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.use_name = talloc_str;
	}
	if (py_force_cond == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.force_cond");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.force_cond));
		if (PyLong_Check(py_force_cond)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_force_cond);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.force_cond = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrUseDel_args_out(struct wkssvc_NetrUseDel *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrUseEnum_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrUseEnum_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnum_in_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wkssvc_NetrUseEnumInfo_Type, object->in.info, object->in.info);
	return py_info;
}

static int py_wkssvc_NetrUseEnum_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wkssvc_NetrUseEnumInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info = (struct wkssvc_NetrUseEnumInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnum_out_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wkssvc_NetrUseEnumInfo_Type, object->out.info, object->out.info);
	return py_info;
}

static int py_wkssvc_NetrUseEnum_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wkssvc_NetrUseEnumInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.info = (struct wkssvc_NetrUseEnumInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnum_in_get_prefmaxlen(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_prefmaxlen;
	py_prefmaxlen = PyLong_FromUnsignedLongLong((uint32_t)(object->in.prefmaxlen));
	return py_prefmaxlen;
}

static int py_wkssvc_NetrUseEnum_in_set_prefmaxlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.prefmaxlen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.prefmaxlen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.prefmaxlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnum_out_get_entries_read(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_entries_read;
	if (object->out.entries_read == NULL) {
		Py_RETURN_NONE;
	}
	py_entries_read = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.entries_read));
	return py_entries_read;
}

static int py_wkssvc_NetrUseEnum_out_set_entries_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.entries_read));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.entries_read");
		return -1;
	}
	object->out.entries_read = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.entries_read);
	if (object->out.entries_read == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.entries_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.entries_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnum_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_wkssvc_NetrUseEnum_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnum_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_wkssvc_NetrUseEnum_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUseEnum_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrUseEnum_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUseEnum_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrUseEnum_in_get_server_name,
		.set = py_wkssvc_NetrUseEnum_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_wkssvc_NetrUseEnum_in_get_info,
		.set = py_wkssvc_NetrUseEnum_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseEnumInfo")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_wkssvc_NetrUseEnum_out_get_info,
		.set = py_wkssvc_NetrUseEnum_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrUseEnumInfo")
	},
	{
		.name = discard_const_p(char, "in_prefmaxlen"),
		.get = py_wkssvc_NetrUseEnum_in_get_prefmaxlen,
		.set = py_wkssvc_NetrUseEnum_in_set_prefmaxlen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_entries_read"),
		.get = py_wkssvc_NetrUseEnum_out_get_entries_read,
		.set = py_wkssvc_NetrUseEnum_out_set_entries_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_wkssvc_NetrUseEnum_in_get_resume_handle,
		.set = py_wkssvc_NetrUseEnum_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_wkssvc_NetrUseEnum_out_get_resume_handle,
		.set = py_wkssvc_NetrUseEnum_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrUseEnum_get_result,
		.set = py_wkssvc_NetrUseEnum_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUseEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrUseEnum, type);
	struct wkssvc_NetrUseEnum *_self = (struct wkssvc_NetrUseEnum *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info = talloc_zero(mem_ctx, struct wkssvc_NetrUseEnumInfo);
	_self->out.info = talloc_zero(mem_ctx, struct wkssvc_NetrUseEnumInfo);
	_self->out.entries_read = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseEnum_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseEnum_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUseEnum_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseEnum_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseEnum_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUseEnum_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUseEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUseEnum_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[11];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseEnum_ndr_print(py_obj, "wkssvc_NetrUseEnum_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrUseEnum_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUseEnum_ndr_print(py_obj, "wkssvc_NetrUseEnum_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrUseEnum_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrUseEnum_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrUseEnum.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseEnum_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseEnum_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseEnum_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUseEnum_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrUseEnum_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrUseEnum_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrUseEnum_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUseEnum",
	.tp_getset = py_wkssvc_NetrUseEnum_getsetters,
	.tp_methods = py_wkssvc_NetrUseEnum_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUseEnum_new,
};

static bool pack_py_wkssvc_NetrUseEnum_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrUseEnum *r)
{
	PyObject *py_server_name;
	PyObject *py_info;
	PyObject *py_prefmaxlen;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"server_name", "info", "prefmaxlen", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrUseEnum", discard_const_p(char *, kwnames), &py_server_name, &py_info, &py_prefmaxlen, &py_resume_handle)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wkssvc_NetrUseEnumInfo_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct wkssvc_NetrUseEnumInfo *)pytalloc_get_ptr(py_info);
	if (py_prefmaxlen == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.prefmaxlen");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.prefmaxlen));
		if (PyLong_Check(py_prefmaxlen)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_prefmaxlen);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.prefmaxlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		if (r->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
			if (PyLong_Check(py_resume_handle)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrUseEnum_args_out(struct wkssvc_NetrUseEnum *r)
{
	PyObject *result;
	PyObject *py_info;
	PyObject *py_entries_read;
	PyObject *py_resume_handle;
	result = PyTuple_New(3);
	py_info = pytalloc_reference_ex(&wkssvc_NetrUseEnumInfo_Type, r->out.info, r->out.info);
	PyTuple_SetItem(result, 0, py_info);
	py_entries_read = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.entries_read));
	PyTuple_SetItem(result, 1, py_entries_read);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	}
	PyTuple_SetItem(result, 2, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrMessageBufferSend_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrMessageBufferSend_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_in_get_message_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(obj);
	PyObject *py_message_name;
	if (object->in.message_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.message_name == NULL) {
		py_message_name = Py_None;
		Py_INCREF(py_message_name);
	} else {
		py_message_name = PyUnicode_Decode(object->in.message_name, strlen(object->in.message_name), "utf-8", "ignore");
	}
	return py_message_name;
}

static int py_wkssvc_NetrMessageBufferSend_in_set_message_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.message_name");
		return -1;
	}
	object->in.message_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.message_name);
	if (object->in.message_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.message_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_in_get_message_sender_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(obj);
	PyObject *py_message_sender_name;
	if (object->in.message_sender_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.message_sender_name == NULL) {
		py_message_sender_name = Py_None;
		Py_INCREF(py_message_sender_name);
	} else {
		if (object->in.message_sender_name == NULL) {
			py_message_sender_name = Py_None;
			Py_INCREF(py_message_sender_name);
		} else {
			py_message_sender_name = PyUnicode_Decode(object->in.message_sender_name, strlen(object->in.message_sender_name), "utf-8", "ignore");
		}
	}
	return py_message_sender_name;
}

static int py_wkssvc_NetrMessageBufferSend_in_set_message_sender_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.message_sender_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.message_sender_name = NULL;
	} else {
		object->in.message_sender_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.message_sender_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_in_get_message_buffer(PyObject *obj, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(obj);
	PyObject *py_message_buffer;
	if (object->in.message_buffer == NULL) {
		Py_RETURN_NONE;
	}
	py_message_buffer = PyList_New(object->in.message_size);
	if (py_message_buffer == NULL) {
		return NULL;
	}
	{
		int message_buffer_cntr_1;
		for (message_buffer_cntr_1 = 0; message_buffer_cntr_1 < (object->in.message_size); message_buffer_cntr_1++) {
			PyObject *py_message_buffer_1;
			py_message_buffer_1 = PyLong_FromLong((uint16_t)((object->in.message_buffer)[message_buffer_cntr_1]));
			PyList_SetItem(py_message_buffer, message_buffer_cntr_1, py_message_buffer_1);
		}
	}
	return py_message_buffer;
}

static int py_wkssvc_NetrMessageBufferSend_in_set_message_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.message_buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.message_buffer");
		return -1;
	}
	object->in.message_buffer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.message_buffer);
	if (object->in.message_buffer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int message_buffer_cntr_1;
		object->in.message_buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.message_buffer, PyList_GET_SIZE(value));
		if (!object->in.message_buffer) { return -1; }
		talloc_set_name_const(object->in.message_buffer, "ARRAY: object->in.message_buffer");
		for (message_buffer_cntr_1 = 0; message_buffer_cntr_1 < PyList_GET_SIZE(value); message_buffer_cntr_1++) {
			if (PyList_GET_ITEM(value, message_buffer_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.message_buffer)[message_buffer_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.message_buffer)[message_buffer_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, message_buffer_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, message_buffer_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.message_buffer)[message_buffer_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_in_get_message_size(PyObject *obj, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(obj);
	PyObject *py_message_size;
	py_message_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.message_size));
	return py_message_size;
}

static int py_wkssvc_NetrMessageBufferSend_in_set_message_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.message_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.message_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.message_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrMessageBufferSend_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrMessageBufferSend_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrMessageBufferSend_in_get_server_name,
		.set = py_wkssvc_NetrMessageBufferSend_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_message_name"),
		.get = py_wkssvc_NetrMessageBufferSend_in_get_message_name,
		.set = py_wkssvc_NetrMessageBufferSend_in_set_message_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_message_sender_name"),
		.get = py_wkssvc_NetrMessageBufferSend_in_get_message_sender_name,
		.set = py_wkssvc_NetrMessageBufferSend_in_set_message_sender_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_message_buffer"),
		.get = py_wkssvc_NetrMessageBufferSend_in_get_message_buffer,
		.set = py_wkssvc_NetrMessageBufferSend_in_set_message_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_message_size"),
		.get = py_wkssvc_NetrMessageBufferSend_in_get_message_size,
		.set = py_wkssvc_NetrMessageBufferSend_in_set_message_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrMessageBufferSend_get_result,
		.set = py_wkssvc_NetrMessageBufferSend_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrMessageBufferSend_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrMessageBufferSend, type);
	struct wkssvc_NetrMessageBufferSend *_self = (struct wkssvc_NetrMessageBufferSend *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.message_buffer = talloc_zero(mem_ctx, uint8_t);
	return self;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrMessageBufferSend_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrMessageBufferSend_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrMessageBufferSend_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrMessageBufferSend_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrMessageBufferSend_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrMessageBufferSend_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrMessageBufferSend *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrMessageBufferSend_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[12];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrMessageBufferSend_ndr_print(py_obj, "wkssvc_NetrMessageBufferSend_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrMessageBufferSend_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrMessageBufferSend_ndr_print(py_obj, "wkssvc_NetrMessageBufferSend_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrMessageBufferSend_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrMessageBufferSend_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrMessageBufferSend.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrMessageBufferSend_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrMessageBufferSend_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrMessageBufferSend_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrMessageBufferSend_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrMessageBufferSend_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrMessageBufferSend_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrMessageBufferSend_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrMessageBufferSend",
	.tp_getset = py_wkssvc_NetrMessageBufferSend_getsetters,
	.tp_methods = py_wkssvc_NetrMessageBufferSend_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrMessageBufferSend_new,
};

static bool pack_py_wkssvc_NetrMessageBufferSend_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrMessageBufferSend *r)
{
	PyObject *py_server_name;
	PyObject *py_message_name;
	PyObject *py_message_sender_name;
	PyObject *py_message_buffer;
	const char *kwnames[] = {
		"server_name", "message_name", "message_sender_name", "message_buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrMessageBufferSend", discard_const_p(char *, kwnames), &py_server_name, &py_message_name, &py_message_sender_name, &py_message_buffer)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_message_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.message_name");
		return false;
	}
	r->in.message_name = talloc_ptrtype(r, r->in.message_name);
	if (r->in.message_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_message_name)) {
			unicode = PyUnicode_AsEncodedString(py_message_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_message_name)) {
			test_str = PyBytes_AS_STRING(py_message_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_message_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.message_name = talloc_str;
	}
	if (py_message_sender_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.message_sender_name");
		return false;
	}
	if (py_message_sender_name == Py_None) {
		r->in.message_sender_name = NULL;
	} else {
		r->in.message_sender_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_message_sender_name)) {
				unicode = PyUnicode_AsEncodedString(py_message_sender_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_message_sender_name)) {
				test_str = PyBytes_AS_STRING(py_message_sender_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_message_sender_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.message_sender_name = talloc_str;
		}
	}
	if (py_message_buffer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.message_buffer");
		return false;
	}
	r->in.message_buffer = talloc_ptrtype(r, r->in.message_buffer);
	if (r->in.message_buffer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_message_buffer, return false;);
	{
		int message_buffer_cntr_1;
		r->in.message_buffer = talloc_array_ptrtype(r, r->in.message_buffer, PyList_GET_SIZE(py_message_buffer));
		if (!r->in.message_buffer) { return false; }
		talloc_set_name_const(r->in.message_buffer, "ARRAY: r->in.message_buffer");
		for (message_buffer_cntr_1 = 0; message_buffer_cntr_1 < PyList_GET_SIZE(py_message_buffer); message_buffer_cntr_1++) {
			if (PyList_GET_ITEM(py_message_buffer, message_buffer_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.message_buffer)[message_buffer_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.message_buffer)[message_buffer_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_message_buffer, message_buffer_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_message_buffer, message_buffer_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.message_buffer)[message_buffer_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_message_buffer, return false;);
	r->in.message_size = PyList_GET_SIZE(py_message_buffer);
	return true;
}

static PyObject *unpack_py_wkssvc_NetrMessageBufferSend_args_out(struct wkssvc_NetrMessageBufferSend *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrWorkstationStatisticsGet_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_in_get_unknown2(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	if (object->in.unknown2 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.unknown2 == NULL) {
		py_unknown2 = Py_None;
		Py_INCREF(py_unknown2);
	} else {
		if (object->in.unknown2 == NULL) {
			py_unknown2 = Py_None;
			Py_INCREF(py_unknown2);
		} else {
			py_unknown2 = PyUnicode_Decode(object->in.unknown2, strlen(object->in.unknown2), "utf-8", "ignore");
		}
	}
	return py_unknown2;
}

static int py_wkssvc_NetrWorkstationStatisticsGet_in_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unknown2");
		return -1;
	}
	if (value == Py_None) {
		object->in.unknown2 = NULL;
	} else {
		object->in.unknown2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.unknown2 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_in_get_unknown3(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown3));
	return py_unknown3;
}

static int py_wkssvc_NetrWorkstationStatisticsGet_in_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_in_get_unknown4(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown4));
	return py_unknown4;
}

static int py_wkssvc_NetrWorkstationStatisticsGet_in_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unknown4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_out_get_info(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&wkssvc_NetrWorkstationStatistics_Type, *object->out.info, *object->out.info);
	}
	return py_info;
}

static int py_wkssvc_NetrWorkstationStatisticsGet_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.info = NULL;
	} else {
		*object->out.info = NULL;
		PY_CHECK_TYPE(&wkssvc_NetrWorkstationStatistics_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.info = (struct wkssvc_NetrWorkstationStatistics *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrWorkstationStatisticsGet_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrWorkstationStatisticsGet_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrWorkstationStatisticsGet_in_get_server_name,
		.set = py_wkssvc_NetrWorkstationStatisticsGet_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_unknown2"),
		.get = py_wkssvc_NetrWorkstationStatisticsGet_in_get_unknown2,
		.set = py_wkssvc_NetrWorkstationStatisticsGet_in_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_unknown3"),
		.get = py_wkssvc_NetrWorkstationStatisticsGet_in_get_unknown3,
		.set = py_wkssvc_NetrWorkstationStatisticsGet_in_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unknown4"),
		.get = py_wkssvc_NetrWorkstationStatisticsGet_in_get_unknown4,
		.set = py_wkssvc_NetrWorkstationStatisticsGet_in_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_wkssvc_NetrWorkstationStatisticsGet_out_get_info,
		.set = py_wkssvc_NetrWorkstationStatisticsGet_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetrWorkstationStatistics")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrWorkstationStatisticsGet_get_result,
		.set = py_wkssvc_NetrWorkstationStatisticsGet_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrWorkstationStatisticsGet, type);
	struct wkssvc_NetrWorkstationStatisticsGet *_self = (struct wkssvc_NetrWorkstationStatisticsGet *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.info = talloc_zero(mem_ctx, struct wkssvc_NetrWorkstationStatistics *);
	return self;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(13);
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[13];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[13];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrWorkstationStatisticsGet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrWorkstationStatisticsGet_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[13];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWorkstationStatisticsGet_ndr_print(py_obj, "wkssvc_NetrWorkstationStatisticsGet_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrWorkstationStatisticsGet_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrWorkstationStatisticsGet_ndr_print(py_obj, "wkssvc_NetrWorkstationStatisticsGet_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrWorkstationStatisticsGet_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrWorkstationStatisticsGet_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrWorkstationStatisticsGet.opnum() -> 13 (0x0d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWorkstationStatisticsGet_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrWorkstationStatisticsGet_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrWorkstationStatisticsGet_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrWorkstationStatisticsGet_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrWorkstationStatisticsGet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrWorkstationStatisticsGet",
	.tp_getset = py_wkssvc_NetrWorkstationStatisticsGet_getsetters,
	.tp_methods = py_wkssvc_NetrWorkstationStatisticsGet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrWorkstationStatisticsGet_new,
};

static bool pack_py_wkssvc_NetrWorkstationStatisticsGet_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrWorkstationStatisticsGet *r)
{
	PyObject *py_server_name;
	PyObject *py_unknown2;
	PyObject *py_unknown3;
	PyObject *py_unknown4;
	const char *kwnames[] = {
		"server_name", "unknown2", "unknown3", "unknown4", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrWorkstationStatisticsGet", discard_const_p(char *, kwnames), &py_server_name, &py_unknown2, &py_unknown3, &py_unknown4)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_unknown2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unknown2");
		return false;
	}
	if (py_unknown2 == Py_None) {
		r->in.unknown2 = NULL;
	} else {
		r->in.unknown2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_unknown2)) {
				unicode = PyUnicode_AsEncodedString(py_unknown2, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_unknown2)) {
				test_str = PyBytes_AS_STRING(py_unknown2);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_unknown2)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.unknown2 = talloc_str;
		}
	}
	if (py_unknown3 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unknown3");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown3));
		if (PyLong_Check(py_unknown3)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown3);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unknown4 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unknown4");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown4));
		if (PyLong_Check(py_unknown4)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown4);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrWorkstationStatisticsGet_args_out(struct wkssvc_NetrWorkstationStatisticsGet *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&wkssvc_NetrWorkstationStatistics_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrLogonDomainNameAdd_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrLogonDomainNameAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wkssvc_NetrLogonDomainNameAdd_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrLogonDomainNameAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrLogonDomainNameAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrLogonDomainNameAdd_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrLogonDomainNameAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrLogonDomainNameAdd_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wkssvc_NetrLogonDomainNameAdd_in_get_domain_name,
		.set = py_wkssvc_NetrLogonDomainNameAdd_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrLogonDomainNameAdd_get_result,
		.set = py_wkssvc_NetrLogonDomainNameAdd_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrLogonDomainNameAdd, type);
	return self;
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(14);
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrLogonDomainNameAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrLogonDomainNameAdd_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[14];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrLogonDomainNameAdd_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrLogonDomainNameAdd_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrLogonDomainNameAdd *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[14];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrLogonDomainNameAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrLogonDomainNameAdd_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[14];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrLogonDomainNameAdd_ndr_print(py_obj, "wkssvc_NetrLogonDomainNameAdd_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrLogonDomainNameAdd_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrLogonDomainNameAdd_ndr_print(py_obj, "wkssvc_NetrLogonDomainNameAdd_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrLogonDomainNameAdd_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrLogonDomainNameAdd_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrLogonDomainNameAdd.opnum() -> 14 (0x0e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameAdd_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameAdd_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameAdd_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrLogonDomainNameAdd_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrLogonDomainNameAdd_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrLogonDomainNameAdd_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrLogonDomainNameAdd",
	.tp_getset = py_wkssvc_NetrLogonDomainNameAdd_getsetters,
	.tp_methods = py_wkssvc_NetrLogonDomainNameAdd_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrLogonDomainNameAdd_new,
};

static bool pack_py_wkssvc_NetrLogonDomainNameAdd_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrLogonDomainNameAdd *r)
{
	PyObject *py_domain_name;
	const char *kwnames[] = {
		"domain_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wkssvc_NetrLogonDomainNameAdd", discard_const_p(char *, kwnames), &py_domain_name)) {
		return false;
	}

	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrLogonDomainNameAdd_args_out(struct wkssvc_NetrLogonDomainNameAdd *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrLogonDomainNameDel_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrLogonDomainNameDel *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wkssvc_NetrLogonDomainNameDel_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrLogonDomainNameDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrLogonDomainNameDel *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrLogonDomainNameDel_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrLogonDomainNameDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrLogonDomainNameDel_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wkssvc_NetrLogonDomainNameDel_in_get_domain_name,
		.set = py_wkssvc_NetrLogonDomainNameDel_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrLogonDomainNameDel_get_result,
		.set = py_wkssvc_NetrLogonDomainNameDel_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrLogonDomainNameDel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrLogonDomainNameDel, type);
	return self;
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(15);
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrLogonDomainNameDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrLogonDomainNameDel_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[15];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrLogonDomainNameDel_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrLogonDomainNameDel_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrLogonDomainNameDel *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrLogonDomainNameDel_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[15];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrLogonDomainNameDel_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrLogonDomainNameDel_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrLogonDomainNameDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrLogonDomainNameDel_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[15];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrLogonDomainNameDel_ndr_print(py_obj, "wkssvc_NetrLogonDomainNameDel_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrLogonDomainNameDel_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrLogonDomainNameDel_ndr_print(py_obj, "wkssvc_NetrLogonDomainNameDel_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrLogonDomainNameDel_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrLogonDomainNameDel_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrLogonDomainNameDel.opnum() -> 15 (0x0f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameDel_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameDel_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameDel_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrLogonDomainNameDel_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrLogonDomainNameDel_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrLogonDomainNameDel_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrLogonDomainNameDel_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrLogonDomainNameDel",
	.tp_getset = py_wkssvc_NetrLogonDomainNameDel_getsetters,
	.tp_methods = py_wkssvc_NetrLogonDomainNameDel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrLogonDomainNameDel_new,
};

static bool pack_py_wkssvc_NetrLogonDomainNameDel_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrLogonDomainNameDel *r)
{
	PyObject *py_domain_name;
	const char *kwnames[] = {
		"domain_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wkssvc_NetrLogonDomainNameDel", discard_const_p(char *, kwnames), &py_domain_name)) {
		return false;
	}

	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrLogonDomainNameDel_args_out(struct wkssvc_NetrLogonDomainNameDel *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrJoinDomain_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrJoinDomain_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wkssvc_NetrJoinDomain_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain_in_get_account_ou(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_account_ou;
	if (object->in.account_ou == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.account_ou == NULL) {
		py_account_ou = Py_None;
		Py_INCREF(py_account_ou);
	} else {
		if (object->in.account_ou == NULL) {
			py_account_ou = Py_None;
			Py_INCREF(py_account_ou);
		} else {
			py_account_ou = PyUnicode_Decode(object->in.account_ou, strlen(object->in.account_ou), "utf-8", "ignore");
		}
	}
	return py_account_ou;
}

static int py_wkssvc_NetrJoinDomain_in_set_account_ou(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.account_ou");
		return -1;
	}
	if (value == Py_None) {
		object->in.account_ou = NULL;
	} else {
		object->in.account_ou = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.account_ou = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrJoinDomain_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain_in_get_password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->in.password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->in.password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->in.password, strlen(object->in.password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_wkssvc_NetrJoinDomain_in_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password");
		return -1;
	}
	if (value == Py_None) {
		object->in.password = NULL;
	} else {
		object->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain_in_get_join_flags(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_join_flags;
	py_join_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.join_flags));
	return py_join_flags;
}

static int py_wkssvc_NetrJoinDomain_in_set_join_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.join_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.join_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.join_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrJoinDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrJoinDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrJoinDomain_in_get_server_name,
		.set = py_wkssvc_NetrJoinDomain_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wkssvc_NetrJoinDomain_in_get_domain_name,
		.set = py_wkssvc_NetrJoinDomain_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_account_ou"),
		.get = py_wkssvc_NetrJoinDomain_in_get_account_ou,
		.set = py_wkssvc_NetrJoinDomain_in_set_account_ou,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrJoinDomain_in_get_Account,
		.set = py_wkssvc_NetrJoinDomain_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_password"),
		.get = py_wkssvc_NetrJoinDomain_in_get_password,
		.set = py_wkssvc_NetrJoinDomain_in_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_join_flags"),
		.get = py_wkssvc_NetrJoinDomain_in_get_join_flags,
		.set = py_wkssvc_NetrJoinDomain_in_set_join_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_joinflags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrJoinDomain_get_result,
		.set = py_wkssvc_NetrJoinDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrJoinDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrJoinDomain, type);
	return self;
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(16);
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrJoinDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[16];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrJoinDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrJoinDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrJoinDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[16];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrJoinDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrJoinDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrJoinDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrJoinDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[16];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrJoinDomain_ndr_print(py_obj, "wkssvc_NetrJoinDomain_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrJoinDomain_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrJoinDomain_ndr_print(py_obj, "wkssvc_NetrJoinDomain_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrJoinDomain_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrJoinDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrJoinDomain.opnum() -> 16 (0x10) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrJoinDomain_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrJoinDomain_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrJoinDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrJoinDomain",
	.tp_getset = py_wkssvc_NetrJoinDomain_getsetters,
	.tp_methods = py_wkssvc_NetrJoinDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrJoinDomain_new,
};

static bool pack_py_wkssvc_NetrJoinDomain_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrJoinDomain *r)
{
	PyObject *py_server_name;
	PyObject *py_domain_name;
	PyObject *py_account_ou;
	PyObject *py_Account;
	PyObject *py_password;
	PyObject *py_join_flags;
	const char *kwnames[] = {
		"server_name", "domain_name", "account_ou", "Account", "password", "join_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:wkssvc_NetrJoinDomain", discard_const_p(char *, kwnames), &py_server_name, &py_domain_name, &py_account_ou, &py_Account, &py_password, &py_join_flags)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	if (py_account_ou == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.account_ou");
		return false;
	}
	if (py_account_ou == Py_None) {
		r->in.account_ou = NULL;
	} else {
		r->in.account_ou = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_account_ou)) {
				unicode = PyUnicode_AsEncodedString(py_account_ou, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_account_ou)) {
				test_str = PyBytes_AS_STRING(py_account_ou);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_ou)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.account_ou = talloc_str;
		}
	}
	if (py_Account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Account");
		return false;
	}
	if (py_Account == Py_None) {
		r->in.Account = NULL;
	} else {
		r->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Account)) {
				unicode = PyUnicode_AsEncodedString(py_Account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Account)) {
				test_str = PyBytes_AS_STRING(py_Account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Account = talloc_str;
		}
	}
	if (py_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.password");
		return false;
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_password)) {
				unicode = PyUnicode_AsEncodedString(py_password, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_password)) {
				test_str = PyBytes_AS_STRING(py_password);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_password)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.password = talloc_str;
		}
	}
	if (py_join_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.join_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.join_flags));
		if (PyLong_Check(py_join_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_join_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.join_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrJoinDomain_args_out(struct wkssvc_NetrJoinDomain *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrUnjoinDomain_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrUnjoinDomain_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrUnjoinDomain_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_in_get_password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->in.password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->in.password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->in.password, strlen(object->in.password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_wkssvc_NetrUnjoinDomain_in_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password");
		return -1;
	}
	if (value == Py_None) {
		object->in.password = NULL;
	} else {
		object->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_in_get_unjoin_flags(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_unjoin_flags;
	py_unjoin_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unjoin_flags));
	return py_unjoin_flags;
}

static int py_wkssvc_NetrUnjoinDomain_in_set_unjoin_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unjoin_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unjoin_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unjoin_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrUnjoinDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUnjoinDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrUnjoinDomain_in_get_server_name,
		.set = py_wkssvc_NetrUnjoinDomain_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrUnjoinDomain_in_get_Account,
		.set = py_wkssvc_NetrUnjoinDomain_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_password"),
		.get = py_wkssvc_NetrUnjoinDomain_in_get_password,
		.set = py_wkssvc_NetrUnjoinDomain_in_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_unjoin_flags"),
		.get = py_wkssvc_NetrUnjoinDomain_in_get_unjoin_flags,
		.set = py_wkssvc_NetrUnjoinDomain_in_set_unjoin_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_joinflags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrUnjoinDomain_get_result,
		.set = py_wkssvc_NetrUnjoinDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUnjoinDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrUnjoinDomain, type);
	return self;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(17);
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUnjoinDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[17];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUnjoinDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUnjoinDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUnjoinDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[17];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUnjoinDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUnjoinDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUnjoinDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUnjoinDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[17];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUnjoinDomain_ndr_print(py_obj, "wkssvc_NetrUnjoinDomain_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrUnjoinDomain_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUnjoinDomain_ndr_print(py_obj, "wkssvc_NetrUnjoinDomain_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrUnjoinDomain_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrUnjoinDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrUnjoinDomain.opnum() -> 17 (0x11) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrUnjoinDomain_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrUnjoinDomain_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrUnjoinDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUnjoinDomain",
	.tp_getset = py_wkssvc_NetrUnjoinDomain_getsetters,
	.tp_methods = py_wkssvc_NetrUnjoinDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUnjoinDomain_new,
};

static bool pack_py_wkssvc_NetrUnjoinDomain_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrUnjoinDomain *r)
{
	PyObject *py_server_name;
	PyObject *py_Account;
	PyObject *py_password;
	PyObject *py_unjoin_flags;
	const char *kwnames[] = {
		"server_name", "Account", "password", "unjoin_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrUnjoinDomain", discard_const_p(char *, kwnames), &py_server_name, &py_Account, &py_password, &py_unjoin_flags)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_Account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Account");
		return false;
	}
	if (py_Account == Py_None) {
		r->in.Account = NULL;
	} else {
		r->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Account)) {
				unicode = PyUnicode_AsEncodedString(py_Account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Account)) {
				test_str = PyBytes_AS_STRING(py_Account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Account = talloc_str;
		}
	}
	if (py_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.password");
		return false;
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_password)) {
				unicode = PyUnicode_AsEncodedString(py_password, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_password)) {
				test_str = PyBytes_AS_STRING(py_password);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_password)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.password = talloc_str;
		}
	}
	if (py_unjoin_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unjoin_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unjoin_flags));
		if (PyLong_Check(py_unjoin_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unjoin_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unjoin_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrUnjoinDomain_args_out(struct wkssvc_NetrUnjoinDomain *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrRenameMachineInDomain_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrRenameMachineInDomain_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_in_get_NewMachineName(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_NewMachineName;
	if (object->in.NewMachineName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.NewMachineName == NULL) {
		py_NewMachineName = Py_None;
		Py_INCREF(py_NewMachineName);
	} else {
		if (object->in.NewMachineName == NULL) {
			py_NewMachineName = Py_None;
			Py_INCREF(py_NewMachineName);
		} else {
			py_NewMachineName = PyUnicode_Decode(object->in.NewMachineName, strlen(object->in.NewMachineName), "utf-8", "ignore");
		}
	}
	return py_NewMachineName;
}

static int py_wkssvc_NetrRenameMachineInDomain_in_set_NewMachineName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.NewMachineName");
		return -1;
	}
	if (value == Py_None) {
		object->in.NewMachineName = NULL;
	} else {
		object->in.NewMachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.NewMachineName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrRenameMachineInDomain_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_in_get_password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->in.password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->in.password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->in.password, strlen(object->in.password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_wkssvc_NetrRenameMachineInDomain_in_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password");
		return -1;
	}
	if (value == Py_None) {
		object->in.password = NULL;
	} else {
		object->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_in_get_RenameOptions(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_RenameOptions;
	py_RenameOptions = PyLong_FromUnsignedLongLong((uint32_t)(object->in.RenameOptions));
	return py_RenameOptions;
}

static int py_wkssvc_NetrRenameMachineInDomain_in_set_RenameOptions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.RenameOptions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.RenameOptions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.RenameOptions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrRenameMachineInDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrRenameMachineInDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrRenameMachineInDomain_in_get_server_name,
		.set = py_wkssvc_NetrRenameMachineInDomain_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_NewMachineName"),
		.get = py_wkssvc_NetrRenameMachineInDomain_in_get_NewMachineName,
		.set = py_wkssvc_NetrRenameMachineInDomain_in_set_NewMachineName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrRenameMachineInDomain_in_get_Account,
		.set = py_wkssvc_NetrRenameMachineInDomain_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_password"),
		.get = py_wkssvc_NetrRenameMachineInDomain_in_get_password,
		.set = py_wkssvc_NetrRenameMachineInDomain_in_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_RenameOptions"),
		.get = py_wkssvc_NetrRenameMachineInDomain_in_get_RenameOptions,
		.set = py_wkssvc_NetrRenameMachineInDomain_in_set_RenameOptions,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_renameflags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrRenameMachineInDomain_get_result,
		.set = py_wkssvc_NetrRenameMachineInDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrRenameMachineInDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrRenameMachineInDomain, type);
	return self;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(18);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrRenameMachineInDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[18];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrRenameMachineInDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrRenameMachineInDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrRenameMachineInDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[18];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrRenameMachineInDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrRenameMachineInDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrRenameMachineInDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrRenameMachineInDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[18];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrRenameMachineInDomain_ndr_print(py_obj, "wkssvc_NetrRenameMachineInDomain_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrRenameMachineInDomain_ndr_print(py_obj, "wkssvc_NetrRenameMachineInDomain_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrRenameMachineInDomain_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrRenameMachineInDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrRenameMachineInDomain.opnum() -> 18 (0x12) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrRenameMachineInDomain_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrRenameMachineInDomain_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrRenameMachineInDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrRenameMachineInDomain",
	.tp_getset = py_wkssvc_NetrRenameMachineInDomain_getsetters,
	.tp_methods = py_wkssvc_NetrRenameMachineInDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrRenameMachineInDomain_new,
};

static bool pack_py_wkssvc_NetrRenameMachineInDomain_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrRenameMachineInDomain *r)
{
	PyObject *py_server_name;
	PyObject *py_NewMachineName;
	PyObject *py_Account;
	PyObject *py_password;
	PyObject *py_RenameOptions;
	const char *kwnames[] = {
		"server_name", "NewMachineName", "Account", "password", "RenameOptions", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:wkssvc_NetrRenameMachineInDomain", discard_const_p(char *, kwnames), &py_server_name, &py_NewMachineName, &py_Account, &py_password, &py_RenameOptions)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_NewMachineName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.NewMachineName");
		return false;
	}
	if (py_NewMachineName == Py_None) {
		r->in.NewMachineName = NULL;
	} else {
		r->in.NewMachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_NewMachineName)) {
				unicode = PyUnicode_AsEncodedString(py_NewMachineName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_NewMachineName)) {
				test_str = PyBytes_AS_STRING(py_NewMachineName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_NewMachineName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.NewMachineName = talloc_str;
		}
	}
	if (py_Account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Account");
		return false;
	}
	if (py_Account == Py_None) {
		r->in.Account = NULL;
	} else {
		r->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Account)) {
				unicode = PyUnicode_AsEncodedString(py_Account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Account)) {
				test_str = PyBytes_AS_STRING(py_Account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Account = talloc_str;
		}
	}
	if (py_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.password");
		return false;
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_password)) {
				unicode = PyUnicode_AsEncodedString(py_password, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_password)) {
				test_str = PyBytes_AS_STRING(py_password);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_password)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.password = talloc_str;
		}
	}
	if (py_RenameOptions == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.RenameOptions");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.RenameOptions));
		if (PyLong_Check(py_RenameOptions)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_RenameOptions);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.RenameOptions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrRenameMachineInDomain_args_out(struct wkssvc_NetrRenameMachineInDomain *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrValidateName_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrValidateName_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName_in_get_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->in.name, strlen(object->in.name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_wkssvc_NetrValidateName_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrValidateName_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName_in_get_Password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(obj);
	PyObject *py_Password;
	if (object->in.Password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Password == NULL) {
		py_Password = Py_None;
		Py_INCREF(py_Password);
	} else {
		if (object->in.Password == NULL) {
			py_Password = Py_None;
			Py_INCREF(py_Password);
		} else {
			py_Password = PyUnicode_Decode(object->in.Password, strlen(object->in.Password), "utf-8", "ignore");
		}
	}
	return py_Password;
}

static int py_wkssvc_NetrValidateName_in_set_Password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Password");
		return -1;
	}
	if (value == Py_None) {
		object->in.Password = NULL;
	} else {
		object->in.Password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName_in_get_name_type(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(obj);
	PyObject *py_name_type;
	py_name_type = PyLong_FromLong((uint16_t)(object->in.name_type));
	return py_name_type;
}

static int py_wkssvc_NetrValidateName_in_set_name_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.name_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.name_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrValidateName_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrValidateName_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrValidateName_in_get_server_name,
		.set = py_wkssvc_NetrValidateName_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_wkssvc_NetrValidateName_in_get_name,
		.set = py_wkssvc_NetrValidateName_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrValidateName_in_get_Account,
		.set = py_wkssvc_NetrValidateName_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Password"),
		.get = py_wkssvc_NetrValidateName_in_get_Password,
		.set = py_wkssvc_NetrValidateName_in_set_Password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_name_type"),
		.get = py_wkssvc_NetrValidateName_in_get_name_type,
		.set = py_wkssvc_NetrValidateName_in_set_name_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetValidateNameType")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrValidateName_get_result,
		.set = py_wkssvc_NetrValidateName_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrValidateName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrValidateName, type);
	return self;
}

static PyObject *py_wkssvc_NetrValidateName_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(19);
}

static PyObject *py_wkssvc_NetrValidateName_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrValidateName_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[19];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrValidateName_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrValidateName_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrValidateName_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrValidateName_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrValidateName_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrValidateName_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[19];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrValidateName_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrValidateName_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrValidateName_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrValidateName_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrValidateName_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrValidateName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrValidateName_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[19];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrValidateName_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrValidateName_ndr_print(py_obj, "wkssvc_NetrValidateName_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrValidateName_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrValidateName_ndr_print(py_obj, "wkssvc_NetrValidateName_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrValidateName_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrValidateName_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrValidateName.opnum() -> 19 (0x13) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrValidateName_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrValidateName_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrValidateName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrValidateName",
	.tp_getset = py_wkssvc_NetrValidateName_getsetters,
	.tp_methods = py_wkssvc_NetrValidateName_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrValidateName_new,
};

static bool pack_py_wkssvc_NetrValidateName_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrValidateName *r)
{
	PyObject *py_server_name;
	PyObject *py_name;
	PyObject *py_Account;
	PyObject *py_Password;
	PyObject *py_name_type;
	const char *kwnames[] = {
		"server_name", "name", "Account", "Password", "name_type", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:wkssvc_NetrValidateName", discard_const_p(char *, kwnames), &py_server_name, &py_name, &py_Account, &py_Password, &py_name_type)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_name)) {
			unicode = PyUnicode_AsEncodedString(py_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_name)) {
			test_str = PyBytes_AS_STRING(py_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.name = talloc_str;
	}
	if (py_Account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Account");
		return false;
	}
	if (py_Account == Py_None) {
		r->in.Account = NULL;
	} else {
		r->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Account)) {
				unicode = PyUnicode_AsEncodedString(py_Account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Account)) {
				test_str = PyBytes_AS_STRING(py_Account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Account = talloc_str;
		}
	}
	if (py_Password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Password");
		return false;
	}
	if (py_Password == Py_None) {
		r->in.Password = NULL;
	} else {
		r->in.Password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Password)) {
				unicode = PyUnicode_AsEncodedString(py_Password, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Password)) {
				test_str = PyBytes_AS_STRING(py_Password);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Password)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Password = talloc_str;
		}
	}
	if (py_name_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name_type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.name_type));
		if (PyLong_Check(py_name_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_name_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.name_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrValidateName_args_out(struct wkssvc_NetrValidateName *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrGetJoinInformation_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrGetJoinInformation_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_in_get_name_buffer(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_name_buffer;
	if (object->in.name_buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->in.name_buffer == NULL) {
		py_name_buffer = Py_None;
		Py_INCREF(py_name_buffer);
	} else {
		if (*object->in.name_buffer == NULL) {
			py_name_buffer = Py_None;
			Py_INCREF(py_name_buffer);
		} else {
			py_name_buffer = PyUnicode_Decode(*object->in.name_buffer, strlen(*object->in.name_buffer), "utf-8", "ignore");
		}
	}
	return py_name_buffer;
}

static int py_wkssvc_NetrGetJoinInformation_in_set_name_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.name_buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name_buffer");
		return -1;
	}
	object->in.name_buffer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name_buffer);
	if (object->in.name_buffer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->in.name_buffer = NULL;
	} else {
		*object->in.name_buffer = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->in.name_buffer = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_out_get_name_buffer(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_name_buffer;
	if (object->out.name_buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.name_buffer == NULL) {
		py_name_buffer = Py_None;
		Py_INCREF(py_name_buffer);
	} else {
		if (*object->out.name_buffer == NULL) {
			py_name_buffer = Py_None;
			Py_INCREF(py_name_buffer);
		} else {
			py_name_buffer = PyUnicode_Decode(*object->out.name_buffer, strlen(*object->out.name_buffer), "utf-8", "ignore");
		}
	}
	return py_name_buffer;
}

static int py_wkssvc_NetrGetJoinInformation_out_set_name_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.name_buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.name_buffer");
		return -1;
	}
	object->out.name_buffer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.name_buffer);
	if (object->out.name_buffer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.name_buffer = NULL;
	} else {
		*object->out.name_buffer = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.name_buffer = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_out_get_name_type(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_name_type;
	if (object->out.name_type == NULL) {
		Py_RETURN_NONE;
	}
	py_name_type = PyLong_FromLong((uint16_t)(*object->out.name_type));
	return py_name_type;
}

static int py_wkssvc_NetrGetJoinInformation_out_set_name_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.name_type));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.name_type");
		return -1;
	}
	object->out.name_type = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.name_type);
	if (object->out.name_type == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.name_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.name_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrGetJoinInformation_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrGetJoinInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrGetJoinInformation_in_get_server_name,
		.set = py_wkssvc_NetrGetJoinInformation_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_name_buffer"),
		.get = py_wkssvc_NetrGetJoinInformation_in_get_name_buffer,
		.set = py_wkssvc_NetrGetJoinInformation_in_set_name_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_name_buffer"),
		.get = py_wkssvc_NetrGetJoinInformation_out_get_name_buffer,
		.set = py_wkssvc_NetrGetJoinInformation_out_set_name_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_name_type"),
		.get = py_wkssvc_NetrGetJoinInformation_out_get_name_type,
		.set = py_wkssvc_NetrGetJoinInformation_out_set_name_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetJoinStatus")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrGetJoinInformation_get_result,
		.set = py_wkssvc_NetrGetJoinInformation_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrGetJoinInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrGetJoinInformation, type);
	struct wkssvc_NetrGetJoinInformation *_self = (struct wkssvc_NetrGetJoinInformation *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.name_type = talloc_zero(mem_ctx, enum wkssvc_NetJoinStatus);
	return self;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(20);
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinInformation_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[20];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrGetJoinInformation_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrGetJoinInformation_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinInformation_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[20];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrGetJoinInformation_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrGetJoinInformation_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinInformation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinInformation_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[20];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrGetJoinInformation_ndr_print(py_obj, "wkssvc_NetrGetJoinInformation_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrGetJoinInformation_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrGetJoinInformation_ndr_print(py_obj, "wkssvc_NetrGetJoinInformation_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrGetJoinInformation_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrGetJoinInformation_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrGetJoinInformation.opnum() -> 20 (0x14) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinInformation_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinInformation_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinInformation_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinInformation_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrGetJoinInformation_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrGetJoinInformation_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrGetJoinInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrGetJoinInformation",
	.tp_getset = py_wkssvc_NetrGetJoinInformation_getsetters,
	.tp_methods = py_wkssvc_NetrGetJoinInformation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrGetJoinInformation_new,
};

static bool pack_py_wkssvc_NetrGetJoinInformation_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrGetJoinInformation *r)
{
	PyObject *py_server_name;
	PyObject *py_name_buffer;
	const char *kwnames[] = {
		"server_name", "name_buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wkssvc_NetrGetJoinInformation", discard_const_p(char *, kwnames), &py_server_name, &py_name_buffer)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_name_buffer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name_buffer");
		return false;
	}
	r->in.name_buffer = talloc_ptrtype(r, r->in.name_buffer);
	if (r->in.name_buffer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	if (py_name_buffer == Py_None) {
		*r->in.name_buffer = NULL;
	} else {
		*r->in.name_buffer = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_name_buffer)) {
				unicode = PyUnicode_AsEncodedString(py_name_buffer, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_name_buffer)) {
				test_str = PyBytes_AS_STRING(py_name_buffer);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_name_buffer)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.name_buffer = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrGetJoinInformation_args_out(struct wkssvc_NetrGetJoinInformation *r)
{
	PyObject *result;
	PyObject *py_name_buffer;
	PyObject *py_name_type;
	result = PyTuple_New(2);
	if (*r->out.name_buffer == NULL) {
		py_name_buffer = Py_None;
		Py_INCREF(py_name_buffer);
	} else {
		if (*r->out.name_buffer == NULL) {
			py_name_buffer = Py_None;
			Py_INCREF(py_name_buffer);
		} else {
			py_name_buffer = PyUnicode_Decode(*r->out.name_buffer, strlen(*r->out.name_buffer), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 0, py_name_buffer);
	py_name_type = PyLong_FromLong((uint16_t)(*r->out.name_type));
	PyTuple_SetItem(result, 1, py_name_type);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrGetJoinableOus_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrGetJoinableOus_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wkssvc_NetrGetJoinableOus_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrGetJoinableOus_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_in_get_unknown(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	if (object->in.unknown == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.unknown == NULL) {
		py_unknown = Py_None;
		Py_INCREF(py_unknown);
	} else {
		if (object->in.unknown == NULL) {
			py_unknown = Py_None;
			Py_INCREF(py_unknown);
		} else {
			py_unknown = PyUnicode_Decode(object->in.unknown, strlen(object->in.unknown), "utf-8", "ignore");
		}
	}
	return py_unknown;
}

static int py_wkssvc_NetrGetJoinableOus_in_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unknown");
		return -1;
	}
	if (value == Py_None) {
		object->in.unknown = NULL;
	} else {
		object->in.unknown = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.unknown = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_in_get_num_ous(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ous;
	if (object->in.num_ous == NULL) {
		Py_RETURN_NONE;
	}
	py_num_ous = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.num_ous));
	return py_num_ous;
}

static int py_wkssvc_NetrGetJoinableOus_in_set_num_ous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.num_ous));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.num_ous");
		return -1;
	}
	object->in.num_ous = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.num_ous);
	if (object->in.num_ous == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.num_ous));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.num_ous = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_out_get_num_ous(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ous;
	if (object->out.num_ous == NULL) {
		Py_RETURN_NONE;
	}
	py_num_ous = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_ous));
	return py_num_ous;
}

static int py_wkssvc_NetrGetJoinableOus_out_set_num_ous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_ous));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.num_ous");
		return -1;
	}
	object->out.num_ous = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_ous);
	if (object->out.num_ous == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_ous));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_ous = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_out_get_ous(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_ous;
	if (object->out.ous == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.ous == NULL) {
		py_ous = Py_None;
		Py_INCREF(py_ous);
	} else {
		py_ous = PyList_New(*object->out.num_ous);
		if (py_ous == NULL) {
			return NULL;
		}
		{
			int ous_cntr_2;
			for (ous_cntr_2 = 0; ous_cntr_2 < (*object->out.num_ous); ous_cntr_2++) {
				PyObject *py_ous_2;
				if ((*object->out.ous)[ous_cntr_2] == NULL) {
					py_ous_2 = Py_None;
					Py_INCREF(py_ous_2);
				} else {
					if ((*object->out.ous)[ous_cntr_2] == NULL) {
						py_ous_2 = Py_None;
						Py_INCREF(py_ous_2);
					} else {
						py_ous_2 = PyUnicode_Decode((*object->out.ous)[ous_cntr_2], strlen((*object->out.ous)[ous_cntr_2]), "utf-8", "ignore");
					}
				}
				PyList_SetItem(py_ous, ous_cntr_2, py_ous_2);
			}
		}
	}
	return py_ous;
}

static int py_wkssvc_NetrGetJoinableOus_out_set_ous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ous));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.ous");
		return -1;
	}
	object->out.ous = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ous);
	if (object->out.ous == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.ous = NULL;
	} else {
		*object->out.ous = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int ous_cntr_2;
			*object->out.ous = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), *object->out.ous, PyList_GET_SIZE(value));
			if (!*object->out.ous) { return -1; }
			talloc_set_name_const(*object->out.ous, "ARRAY: *object->out.ous");
			for (ous_cntr_2 = 0; ous_cntr_2 < PyList_GET_SIZE(value); ous_cntr_2++) {
				if (PyList_GET_ITEM(value, ous_cntr_2) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (*object->out.ous)[ous_cntr_2]");
					return -1;
				}
				if (PyList_GET_ITEM(value, ous_cntr_2) == Py_None) {
					(*object->out.ous)[ous_cntr_2] = NULL;
				} else {
					(*object->out.ous)[ous_cntr_2] = NULL;
					{
						const char *test_str;
						const char *talloc_str;
						PyObject *unicode = NULL;
						if (PyUnicode_Check(PyList_GET_ITEM(value, ous_cntr_2))) {
							unicode = PyUnicode_AsEncodedString(PyList_GET_ITEM(value, ous_cntr_2), "utf-8", "ignore");
							if (unicode == NULL) {
								return -1;
							}
							test_str = PyBytes_AS_STRING(unicode);
						} else if (PyBytes_Check(PyList_GET_ITEM(value, ous_cntr_2))) {
							test_str = PyBytes_AS_STRING(PyList_GET_ITEM(value, ous_cntr_2));
						} else {
							PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(PyList_GET_ITEM(value, ous_cntr_2))->tp_name);
							return -1;
						}
						talloc_str = talloc_strdup(*object->out.ous, test_str);
						if (unicode != NULL) {
							Py_DECREF(unicode);
						}
						if (talloc_str == NULL) {
							PyErr_NoMemory();
							return -1;
						}
						(*object->out.ous)[ous_cntr_2] = talloc_str;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrGetJoinableOus_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrGetJoinableOus_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrGetJoinableOus_in_get_server_name,
		.set = py_wkssvc_NetrGetJoinableOus_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wkssvc_NetrGetJoinableOus_in_get_domain_name,
		.set = py_wkssvc_NetrGetJoinableOus_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrGetJoinableOus_in_get_Account,
		.set = py_wkssvc_NetrGetJoinableOus_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_unknown"),
		.get = py_wkssvc_NetrGetJoinableOus_in_get_unknown,
		.set = py_wkssvc_NetrGetJoinableOus_in_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_num_ous"),
		.get = py_wkssvc_NetrGetJoinableOus_in_get_num_ous,
		.set = py_wkssvc_NetrGetJoinableOus_in_set_num_ous,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_ous"),
		.get = py_wkssvc_NetrGetJoinableOus_out_get_num_ous,
		.set = py_wkssvc_NetrGetJoinableOus_out_set_num_ous,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_ous"),
		.get = py_wkssvc_NetrGetJoinableOus_out_get_ous,
		.set = py_wkssvc_NetrGetJoinableOus_out_set_ous,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrGetJoinableOus_get_result,
		.set = py_wkssvc_NetrGetJoinableOus_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrGetJoinableOus_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrGetJoinableOus, type);
	struct wkssvc_NetrGetJoinableOus *_self = (struct wkssvc_NetrGetJoinableOus *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.num_ous = talloc_zero(mem_ctx, uint32_t);
	_self->out.num_ous = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(21);
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinableOus_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[21];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrGetJoinableOus_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrGetJoinableOus_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinableOus_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[21];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrGetJoinableOus_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrGetJoinableOus_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinableOus *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinableOus_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[21];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrGetJoinableOus_ndr_print(py_obj, "wkssvc_NetrGetJoinableOus_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrGetJoinableOus_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrGetJoinableOus_ndr_print(py_obj, "wkssvc_NetrGetJoinableOus_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrGetJoinableOus_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrGetJoinableOus_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrGetJoinableOus.opnum() -> 21 (0x15) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinableOus_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinableOus_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinableOus_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinableOus_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrGetJoinableOus_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrGetJoinableOus_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrGetJoinableOus_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrGetJoinableOus",
	.tp_getset = py_wkssvc_NetrGetJoinableOus_getsetters,
	.tp_methods = py_wkssvc_NetrGetJoinableOus_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrGetJoinableOus_new,
};

static bool pack_py_wkssvc_NetrGetJoinableOus_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrGetJoinableOus *r)
{
	PyObject *py_server_name;
	PyObject *py_domain_name;
	PyObject *py_Account;
	PyObject *py_unknown;
	PyObject *py_num_ous;
	const char *kwnames[] = {
		"server_name", "domain_name", "Account", "unknown", "num_ous", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:wkssvc_NetrGetJoinableOus", discard_const_p(char *, kwnames), &py_server_name, &py_domain_name, &py_Account, &py_unknown, &py_num_ous)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	if (py_Account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Account");
		return false;
	}
	if (py_Account == Py_None) {
		r->in.Account = NULL;
	} else {
		r->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Account)) {
				unicode = PyUnicode_AsEncodedString(py_Account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Account)) {
				test_str = PyBytes_AS_STRING(py_Account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Account = talloc_str;
		}
	}
	if (py_unknown == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unknown");
		return false;
	}
	if (py_unknown == Py_None) {
		r->in.unknown = NULL;
	} else {
		r->in.unknown = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_unknown)) {
				unicode = PyUnicode_AsEncodedString(py_unknown, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_unknown)) {
				test_str = PyBytes_AS_STRING(py_unknown);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_unknown)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.unknown = talloc_str;
		}
	}
	if (py_num_ous == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.num_ous");
		return false;
	}
	r->in.num_ous = talloc_ptrtype(r, r->in.num_ous);
	if (r->in.num_ous == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.num_ous));
		if (PyLong_Check(py_num_ous)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_num_ous);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.num_ous = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrGetJoinableOus_args_out(struct wkssvc_NetrGetJoinableOus *r)
{
	PyObject *result;
	PyObject *py_num_ous;
	PyObject *py_ous;
	result = PyTuple_New(2);
	py_num_ous = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.num_ous));
	PyTuple_SetItem(result, 0, py_num_ous);
	if (*r->out.ous == NULL) {
		py_ous = Py_None;
		Py_INCREF(py_ous);
	} else {
		py_ous = PyList_New(*r->out.num_ous);
		if (py_ous == NULL) {
			return NULL;
		}
		{
			int ous_cntr_2;
			for (ous_cntr_2 = 0; ous_cntr_2 < (*r->out.num_ous); ous_cntr_2++) {
				PyObject *py_ous_2;
				if ((*r->out.ous)[ous_cntr_2] == NULL) {
					py_ous_2 = Py_None;
					Py_INCREF(py_ous_2);
				} else {
					if ((*r->out.ous)[ous_cntr_2] == NULL) {
						py_ous_2 = Py_None;
						Py_INCREF(py_ous_2);
					} else {
						py_ous_2 = PyUnicode_Decode((*r->out.ous)[ous_cntr_2], strlen((*r->out.ous)[ous_cntr_2]), "utf-8", "ignore");
					}
				}
				PyList_SetItem(py_ous, ous_cntr_2, py_ous_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_ous);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrJoinDomain2_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrJoinDomain2_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain2_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wkssvc_NetrJoinDomain2_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain2_in_get_account_ou(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_account_ou;
	if (object->in.account_ou == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.account_ou == NULL) {
		py_account_ou = Py_None;
		Py_INCREF(py_account_ou);
	} else {
		if (object->in.account_ou == NULL) {
			py_account_ou = Py_None;
			Py_INCREF(py_account_ou);
		} else {
			py_account_ou = PyUnicode_Decode(object->in.account_ou, strlen(object->in.account_ou), "utf-8", "ignore");
		}
	}
	return py_account_ou;
}

static int py_wkssvc_NetrJoinDomain2_in_set_account_ou(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.account_ou");
		return -1;
	}
	if (value == Py_None) {
		object->in.account_ou = NULL;
	} else {
		object->in.account_ou = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.account_ou = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain2_in_get_admin_account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_admin_account;
	if (object->in.admin_account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.admin_account == NULL) {
		py_admin_account = Py_None;
		Py_INCREF(py_admin_account);
	} else {
		if (object->in.admin_account == NULL) {
			py_admin_account = Py_None;
			Py_INCREF(py_admin_account);
		} else {
			py_admin_account = PyUnicode_Decode(object->in.admin_account, strlen(object->in.admin_account), "utf-8", "ignore");
		}
	}
	return py_admin_account;
}

static int py_wkssvc_NetrJoinDomain2_in_set_admin_account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.admin_account");
		return -1;
	}
	if (value == Py_None) {
		object->in.admin_account = NULL;
	} else {
		object->in.admin_account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.admin_account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain2_in_get_encrypted_password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_encrypted_password;
	if (object->in.encrypted_password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.encrypted_password == NULL) {
		py_encrypted_password = Py_None;
		Py_INCREF(py_encrypted_password);
	} else {
		py_encrypted_password = pytalloc_reference_ex(&wkssvc_PasswordBuffer_Type, object->in.encrypted_password, object->in.encrypted_password);
	}
	return py_encrypted_password;
}

static int py_wkssvc_NetrJoinDomain2_in_set_encrypted_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.encrypted_password));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.encrypted_password");
		return -1;
	}
	if (value == Py_None) {
		object->in.encrypted_password = NULL;
	} else {
		object->in.encrypted_password = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.encrypted_password = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain2_in_get_join_flags(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_join_flags;
	py_join_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.join_flags));
	return py_join_flags;
}

static int py_wkssvc_NetrJoinDomain2_in_set_join_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.join_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.join_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.join_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrJoinDomain2_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrJoinDomain2_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrJoinDomain2_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrJoinDomain2_in_get_server_name,
		.set = py_wkssvc_NetrJoinDomain2_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wkssvc_NetrJoinDomain2_in_get_domain_name,
		.set = py_wkssvc_NetrJoinDomain2_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_account_ou"),
		.get = py_wkssvc_NetrJoinDomain2_in_get_account_ou,
		.set = py_wkssvc_NetrJoinDomain2_in_set_account_ou,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_admin_account"),
		.get = py_wkssvc_NetrJoinDomain2_in_get_admin_account,
		.set = py_wkssvc_NetrJoinDomain2_in_set_admin_account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_encrypted_password"),
		.get = py_wkssvc_NetrJoinDomain2_in_get_encrypted_password,
		.set = py_wkssvc_NetrJoinDomain2_in_set_encrypted_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_PasswordBuffer")
	},
	{
		.name = discard_const_p(char, "in_join_flags"),
		.get = py_wkssvc_NetrJoinDomain2_in_get_join_flags,
		.set = py_wkssvc_NetrJoinDomain2_in_set_join_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_joinflags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrJoinDomain2_get_result,
		.set = py_wkssvc_NetrJoinDomain2_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrJoinDomain2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrJoinDomain2, type);
	return self;
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(22);
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrJoinDomain2_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[22];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrJoinDomain2_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrJoinDomain2_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrJoinDomain2_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[22];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrJoinDomain2_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrJoinDomain2_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrJoinDomain2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrJoinDomain2_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[22];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrJoinDomain2_ndr_print(py_obj, "wkssvc_NetrJoinDomain2_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrJoinDomain2_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrJoinDomain2_ndr_print(py_obj, "wkssvc_NetrJoinDomain2_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrJoinDomain2_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrJoinDomain2_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrJoinDomain2.opnum() -> 22 (0x16) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain2_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain2_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain2_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrJoinDomain2_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrJoinDomain2_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrJoinDomain2_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrJoinDomain2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrJoinDomain2",
	.tp_getset = py_wkssvc_NetrJoinDomain2_getsetters,
	.tp_methods = py_wkssvc_NetrJoinDomain2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrJoinDomain2_new,
};

static bool pack_py_wkssvc_NetrJoinDomain2_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrJoinDomain2 *r)
{
	PyObject *py_server_name;
	PyObject *py_domain_name;
	PyObject *py_account_ou;
	PyObject *py_admin_account;
	PyObject *py_encrypted_password;
	PyObject *py_join_flags;
	const char *kwnames[] = {
		"server_name", "domain_name", "account_ou", "admin_account", "encrypted_password", "join_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:wkssvc_NetrJoinDomain2", discard_const_p(char *, kwnames), &py_server_name, &py_domain_name, &py_account_ou, &py_admin_account, &py_encrypted_password, &py_join_flags)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	if (py_account_ou == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.account_ou");
		return false;
	}
	if (py_account_ou == Py_None) {
		r->in.account_ou = NULL;
	} else {
		r->in.account_ou = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_account_ou)) {
				unicode = PyUnicode_AsEncodedString(py_account_ou, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_account_ou)) {
				test_str = PyBytes_AS_STRING(py_account_ou);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_ou)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.account_ou = talloc_str;
		}
	}
	if (py_admin_account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.admin_account");
		return false;
	}
	if (py_admin_account == Py_None) {
		r->in.admin_account = NULL;
	} else {
		r->in.admin_account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_admin_account)) {
				unicode = PyUnicode_AsEncodedString(py_admin_account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_admin_account)) {
				test_str = PyBytes_AS_STRING(py_admin_account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_admin_account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.admin_account = talloc_str;
		}
	}
	if (py_encrypted_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.encrypted_password");
		return false;
	}
	if (py_encrypted_password == Py_None) {
		r->in.encrypted_password = NULL;
	} else {
		r->in.encrypted_password = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, py_encrypted_password, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_encrypted_password)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.encrypted_password = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(py_encrypted_password);
	}
	if (py_join_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.join_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.join_flags));
		if (PyLong_Check(py_join_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_join_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.join_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrJoinDomain2_args_out(struct wkssvc_NetrJoinDomain2 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrUnjoinDomain2_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrUnjoinDomain2_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_in_get_account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_account;
	if (object->in.account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.account == NULL) {
		py_account = Py_None;
		Py_INCREF(py_account);
	} else {
		if (object->in.account == NULL) {
			py_account = Py_None;
			Py_INCREF(py_account);
		} else {
			py_account = PyUnicode_Decode(object->in.account, strlen(object->in.account), "utf-8", "ignore");
		}
	}
	return py_account;
}

static int py_wkssvc_NetrUnjoinDomain2_in_set_account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.account");
		return -1;
	}
	if (value == Py_None) {
		object->in.account = NULL;
	} else {
		object->in.account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_in_get_encrypted_password(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_encrypted_password;
	if (object->in.encrypted_password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.encrypted_password == NULL) {
		py_encrypted_password = Py_None;
		Py_INCREF(py_encrypted_password);
	} else {
		py_encrypted_password = pytalloc_reference_ex(&wkssvc_PasswordBuffer_Type, object->in.encrypted_password, object->in.encrypted_password);
	}
	return py_encrypted_password;
}

static int py_wkssvc_NetrUnjoinDomain2_in_set_encrypted_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.encrypted_password));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.encrypted_password");
		return -1;
	}
	if (value == Py_None) {
		object->in.encrypted_password = NULL;
	} else {
		object->in.encrypted_password = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.encrypted_password = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_in_get_unjoin_flags(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_unjoin_flags;
	py_unjoin_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unjoin_flags));
	return py_unjoin_flags;
}

static int py_wkssvc_NetrUnjoinDomain2_in_set_unjoin_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unjoin_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unjoin_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unjoin_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrUnjoinDomain2_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrUnjoinDomain2_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrUnjoinDomain2_in_get_server_name,
		.set = py_wkssvc_NetrUnjoinDomain2_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_account"),
		.get = py_wkssvc_NetrUnjoinDomain2_in_get_account,
		.set = py_wkssvc_NetrUnjoinDomain2_in_set_account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_encrypted_password"),
		.get = py_wkssvc_NetrUnjoinDomain2_in_get_encrypted_password,
		.set = py_wkssvc_NetrUnjoinDomain2_in_set_encrypted_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_PasswordBuffer")
	},
	{
		.name = discard_const_p(char, "in_unjoin_flags"),
		.get = py_wkssvc_NetrUnjoinDomain2_in_get_unjoin_flags,
		.set = py_wkssvc_NetrUnjoinDomain2_in_set_unjoin_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_joinflags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrUnjoinDomain2_get_result,
		.set = py_wkssvc_NetrUnjoinDomain2_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrUnjoinDomain2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrUnjoinDomain2, type);
	return self;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(23);
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUnjoinDomain2_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[23];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUnjoinDomain2_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrUnjoinDomain2_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUnjoinDomain2_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[23];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUnjoinDomain2_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrUnjoinDomain2_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrUnjoinDomain2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrUnjoinDomain2_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[23];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUnjoinDomain2_ndr_print(py_obj, "wkssvc_NetrUnjoinDomain2_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrUnjoinDomain2_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrUnjoinDomain2_ndr_print(py_obj, "wkssvc_NetrUnjoinDomain2_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrUnjoinDomain2_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrUnjoinDomain2_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrUnjoinDomain2.opnum() -> 23 (0x17) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain2_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain2_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain2_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrUnjoinDomain2_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrUnjoinDomain2_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrUnjoinDomain2_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrUnjoinDomain2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrUnjoinDomain2",
	.tp_getset = py_wkssvc_NetrUnjoinDomain2_getsetters,
	.tp_methods = py_wkssvc_NetrUnjoinDomain2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrUnjoinDomain2_new,
};

static bool pack_py_wkssvc_NetrUnjoinDomain2_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrUnjoinDomain2 *r)
{
	PyObject *py_server_name;
	PyObject *py_account;
	PyObject *py_encrypted_password;
	PyObject *py_unjoin_flags;
	const char *kwnames[] = {
		"server_name", "account", "encrypted_password", "unjoin_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wkssvc_NetrUnjoinDomain2", discard_const_p(char *, kwnames), &py_server_name, &py_account, &py_encrypted_password, &py_unjoin_flags)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.account");
		return false;
	}
	if (py_account == Py_None) {
		r->in.account = NULL;
	} else {
		r->in.account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_account)) {
				unicode = PyUnicode_AsEncodedString(py_account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_account)) {
				test_str = PyBytes_AS_STRING(py_account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.account = talloc_str;
		}
	}
	if (py_encrypted_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.encrypted_password");
		return false;
	}
	if (py_encrypted_password == Py_None) {
		r->in.encrypted_password = NULL;
	} else {
		r->in.encrypted_password = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, py_encrypted_password, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_encrypted_password)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.encrypted_password = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(py_encrypted_password);
	}
	if (py_unjoin_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unjoin_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unjoin_flags));
		if (PyLong_Check(py_unjoin_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unjoin_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unjoin_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrUnjoinDomain2_args_out(struct wkssvc_NetrUnjoinDomain2 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrRenameMachineInDomain2_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrRenameMachineInDomain2_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_in_get_NewMachineName(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_NewMachineName;
	if (object->in.NewMachineName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.NewMachineName == NULL) {
		py_NewMachineName = Py_None;
		Py_INCREF(py_NewMachineName);
	} else {
		if (object->in.NewMachineName == NULL) {
			py_NewMachineName = Py_None;
			Py_INCREF(py_NewMachineName);
		} else {
			py_NewMachineName = PyUnicode_Decode(object->in.NewMachineName, strlen(object->in.NewMachineName), "utf-8", "ignore");
		}
	}
	return py_NewMachineName;
}

static int py_wkssvc_NetrRenameMachineInDomain2_in_set_NewMachineName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.NewMachineName");
		return -1;
	}
	if (value == Py_None) {
		object->in.NewMachineName = NULL;
	} else {
		object->in.NewMachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.NewMachineName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrRenameMachineInDomain2_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_in_get_EncryptedPassword(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_EncryptedPassword;
	if (object->in.EncryptedPassword == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.EncryptedPassword == NULL) {
		py_EncryptedPassword = Py_None;
		Py_INCREF(py_EncryptedPassword);
	} else {
		py_EncryptedPassword = pytalloc_reference_ex(&wkssvc_PasswordBuffer_Type, object->in.EncryptedPassword, object->in.EncryptedPassword);
	}
	return py_EncryptedPassword;
}

static int py_wkssvc_NetrRenameMachineInDomain2_in_set_EncryptedPassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.EncryptedPassword));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.EncryptedPassword");
		return -1;
	}
	if (value == Py_None) {
		object->in.EncryptedPassword = NULL;
	} else {
		object->in.EncryptedPassword = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.EncryptedPassword = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_in_get_RenameOptions(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_RenameOptions;
	py_RenameOptions = PyLong_FromUnsignedLongLong((uint32_t)(object->in.RenameOptions));
	return py_RenameOptions;
}

static int py_wkssvc_NetrRenameMachineInDomain2_in_set_RenameOptions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.RenameOptions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.RenameOptions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.RenameOptions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrRenameMachineInDomain2_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrRenameMachineInDomain2_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrRenameMachineInDomain2_in_get_server_name,
		.set = py_wkssvc_NetrRenameMachineInDomain2_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_NewMachineName"),
		.get = py_wkssvc_NetrRenameMachineInDomain2_in_get_NewMachineName,
		.set = py_wkssvc_NetrRenameMachineInDomain2_in_set_NewMachineName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrRenameMachineInDomain2_in_get_Account,
		.set = py_wkssvc_NetrRenameMachineInDomain2_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_EncryptedPassword"),
		.get = py_wkssvc_NetrRenameMachineInDomain2_in_get_EncryptedPassword,
		.set = py_wkssvc_NetrRenameMachineInDomain2_in_set_EncryptedPassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_PasswordBuffer")
	},
	{
		.name = discard_const_p(char, "in_RenameOptions"),
		.get = py_wkssvc_NetrRenameMachineInDomain2_in_get_RenameOptions,
		.set = py_wkssvc_NetrRenameMachineInDomain2_in_set_RenameOptions,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_renameflags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrRenameMachineInDomain2_get_result,
		.set = py_wkssvc_NetrRenameMachineInDomain2_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrRenameMachineInDomain2, type);
	return self;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(24);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrRenameMachineInDomain2_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[24];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrRenameMachineInDomain2_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrRenameMachineInDomain2_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[24];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrRenameMachineInDomain2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrRenameMachineInDomain2_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[24];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrRenameMachineInDomain2_ndr_print(py_obj, "wkssvc_NetrRenameMachineInDomain2_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrRenameMachineInDomain2_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrRenameMachineInDomain2_ndr_print(py_obj, "wkssvc_NetrRenameMachineInDomain2_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrRenameMachineInDomain2_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrRenameMachineInDomain2_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrRenameMachineInDomain2.opnum() -> 24 (0x18) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain2_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain2_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrRenameMachineInDomain2_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrRenameMachineInDomain2_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrRenameMachineInDomain2_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrRenameMachineInDomain2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrRenameMachineInDomain2",
	.tp_getset = py_wkssvc_NetrRenameMachineInDomain2_getsetters,
	.tp_methods = py_wkssvc_NetrRenameMachineInDomain2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrRenameMachineInDomain2_new,
};

static bool pack_py_wkssvc_NetrRenameMachineInDomain2_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	PyObject *py_server_name;
	PyObject *py_NewMachineName;
	PyObject *py_Account;
	PyObject *py_EncryptedPassword;
	PyObject *py_RenameOptions;
	const char *kwnames[] = {
		"server_name", "NewMachineName", "Account", "EncryptedPassword", "RenameOptions", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:wkssvc_NetrRenameMachineInDomain2", discard_const_p(char *, kwnames), &py_server_name, &py_NewMachineName, &py_Account, &py_EncryptedPassword, &py_RenameOptions)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_NewMachineName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.NewMachineName");
		return false;
	}
	if (py_NewMachineName == Py_None) {
		r->in.NewMachineName = NULL;
	} else {
		r->in.NewMachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_NewMachineName)) {
				unicode = PyUnicode_AsEncodedString(py_NewMachineName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_NewMachineName)) {
				test_str = PyBytes_AS_STRING(py_NewMachineName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_NewMachineName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.NewMachineName = talloc_str;
		}
	}
	if (py_Account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Account");
		return false;
	}
	if (py_Account == Py_None) {
		r->in.Account = NULL;
	} else {
		r->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Account)) {
				unicode = PyUnicode_AsEncodedString(py_Account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Account)) {
				test_str = PyBytes_AS_STRING(py_Account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Account = talloc_str;
		}
	}
	if (py_EncryptedPassword == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.EncryptedPassword");
		return false;
	}
	if (py_EncryptedPassword == Py_None) {
		r->in.EncryptedPassword = NULL;
	} else {
		r->in.EncryptedPassword = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, py_EncryptedPassword, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_EncryptedPassword)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.EncryptedPassword = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(py_EncryptedPassword);
	}
	if (py_RenameOptions == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.RenameOptions");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.RenameOptions));
		if (PyLong_Check(py_RenameOptions)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_RenameOptions);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.RenameOptions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrRenameMachineInDomain2_args_out(struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrValidateName2_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrValidateName2_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName2_in_get_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->in.name, strlen(object->in.name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_wkssvc_NetrValidateName2_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName2_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrValidateName2_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName2_in_get_EncryptedPassword(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_EncryptedPassword;
	if (object->in.EncryptedPassword == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.EncryptedPassword == NULL) {
		py_EncryptedPassword = Py_None;
		Py_INCREF(py_EncryptedPassword);
	} else {
		py_EncryptedPassword = pytalloc_reference_ex(&wkssvc_PasswordBuffer_Type, object->in.EncryptedPassword, object->in.EncryptedPassword);
	}
	return py_EncryptedPassword;
}

static int py_wkssvc_NetrValidateName2_in_set_EncryptedPassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.EncryptedPassword));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.EncryptedPassword");
		return -1;
	}
	if (value == Py_None) {
		object->in.EncryptedPassword = NULL;
	} else {
		object->in.EncryptedPassword = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.EncryptedPassword = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName2_in_get_name_type(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_name_type;
	py_name_type = PyLong_FromLong((uint16_t)(object->in.name_type));
	return py_name_type;
}

static int py_wkssvc_NetrValidateName2_in_set_name_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.name_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.name_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrValidateName2_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrValidateName2_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrValidateName2_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrValidateName2_in_get_server_name,
		.set = py_wkssvc_NetrValidateName2_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_wkssvc_NetrValidateName2_in_get_name,
		.set = py_wkssvc_NetrValidateName2_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrValidateName2_in_get_Account,
		.set = py_wkssvc_NetrValidateName2_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_EncryptedPassword"),
		.get = py_wkssvc_NetrValidateName2_in_get_EncryptedPassword,
		.set = py_wkssvc_NetrValidateName2_in_set_EncryptedPassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_PasswordBuffer")
	},
	{
		.name = discard_const_p(char, "in_name_type"),
		.get = py_wkssvc_NetrValidateName2_in_get_name_type,
		.set = py_wkssvc_NetrValidateName2_in_set_name_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_NetValidateNameType")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrValidateName2_get_result,
		.set = py_wkssvc_NetrValidateName2_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrValidateName2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrValidateName2, type);
	return self;
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(25);
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrValidateName2_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[25];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrValidateName2_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrValidateName2_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrValidateName2_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[25];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrValidateName2_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrValidateName2_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrValidateName2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrValidateName2_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[25];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrValidateName2_ndr_print(py_obj, "wkssvc_NetrValidateName2_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrValidateName2_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrValidateName2_ndr_print(py_obj, "wkssvc_NetrValidateName2_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrValidateName2_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrValidateName2_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrValidateName2.opnum() -> 25 (0x19) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName2_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName2_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName2_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrValidateName2_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_wkssvc_NetrValidateName2_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_wkssvc_NetrValidateName2_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wkssvc_NetrValidateName2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "wkssvc.NetrValidateName2",
	.tp_getset = py_wkssvc_NetrValidateName2_getsetters,
	.tp_methods = py_wkssvc_NetrValidateName2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wkssvc_NetrValidateName2_new,
};

static bool pack_py_wkssvc_NetrValidateName2_args_in(PyObject *args, PyObject *kwargs, struct wkssvc_NetrValidateName2 *r)
{
	PyObject *py_server_name;
	PyObject *py_name;
	PyObject *py_Account;
	PyObject *py_EncryptedPassword;
	PyObject *py_name_type;
	const char *kwnames[] = {
		"server_name", "name", "Account", "EncryptedPassword", "name_type", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:wkssvc_NetrValidateName2", discard_const_p(char *, kwnames), &py_server_name, &py_name, &py_Account, &py_EncryptedPassword, &py_name_type)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_name)) {
			unicode = PyUnicode_AsEncodedString(py_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_name)) {
			test_str = PyBytes_AS_STRING(py_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.name = talloc_str;
	}
	if (py_Account == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Account");
		return false;
	}
	if (py_Account == Py_None) {
		r->in.Account = NULL;
	} else {
		r->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Account)) {
				unicode = PyUnicode_AsEncodedString(py_Account, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Account)) {
				test_str = PyBytes_AS_STRING(py_Account);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Account)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Account = talloc_str;
		}
	}
	if (py_EncryptedPassword == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.EncryptedPassword");
		return false;
	}
	if (py_EncryptedPassword == Py_None) {
		r->in.EncryptedPassword = NULL;
	} else {
		r->in.EncryptedPassword = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, py_EncryptedPassword, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_EncryptedPassword)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.EncryptedPassword = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(py_EncryptedPassword);
	}
	if (py_name_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name_type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.name_type));
		if (PyLong_Check(py_name_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_name_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.name_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wkssvc_NetrValidateName2_args_out(struct wkssvc_NetrValidateName2 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_wkssvc_NetrGetJoinableOus2_in_get_server_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_wkssvc_NetrGetJoinableOus2_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wkssvc_NetrGetJoinableOus2_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_in_get_Account(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_Account;
	if (object->in.Account == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Account == NULL) {
		py_Account = Py_None;
		Py_INCREF(py_Account);
	} else {
		if (object->in.Account == NULL) {
			py_Account = Py_None;
			Py_INCREF(py_Account);
		} else {
			py_Account = PyUnicode_Decode(object->in.Account, strlen(object->in.Account), "utf-8", "ignore");
		}
	}
	return py_Account;
}

static int py_wkssvc_NetrGetJoinableOus2_in_set_Account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Account");
		return -1;
	}
	if (value == Py_None) {
		object->in.Account = NULL;
	} else {
		object->in.Account = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Account = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_in_get_EncryptedPassword(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_EncryptedPassword;
	if (object->in.EncryptedPassword == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.EncryptedPassword == NULL) {
		py_EncryptedPassword = Py_None;
		Py_INCREF(py_EncryptedPassword);
	} else {
		py_EncryptedPassword = pytalloc_reference_ex(&wkssvc_PasswordBuffer_Type, object->in.EncryptedPassword, object->in.EncryptedPassword);
	}
	return py_EncryptedPassword;
}

static int py_wkssvc_NetrGetJoinableOus2_in_set_EncryptedPassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.EncryptedPassword));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.EncryptedPassword");
		return -1;
	}
	if (value == Py_None) {
		object->in.EncryptedPassword = NULL;
	} else {
		object->in.EncryptedPassword = NULL;
		PY_CHECK_TYPE(&wkssvc_PasswordBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.EncryptedPassword = (struct wkssvc_PasswordBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_in_get_num_ous(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ous;
	if (object->in.num_ous == NULL) {
		Py_RETURN_NONE;
	}
	py_num_ous = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.num_ous));
	return py_num_ous;
}

static int py_wkssvc_NetrGetJoinableOus2_in_set_num_ous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.num_ous));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.num_ous");
		return -1;
	}
	object->in.num_ous = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.num_ous);
	if (object->in.num_ous == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.num_ous));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.num_ous = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_out_get_num_ous(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ous;
	if (object->out.num_ous == NULL) {
		Py_RETURN_NONE;
	}
	py_num_ous = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_ous));
	return py_num_ous;
}

static int py_wkssvc_NetrGetJoinableOus2_out_set_num_ous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_ous));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.num_ous");
		return -1;
	}
	object->out.num_ous = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_ous);
	if (object->out.num_ous == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_ous));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_ous = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_out_get_ous(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ous;
	if (object->out.ous == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.ous == NULL) {
		py_ous = Py_None;
		Py_INCREF(py_ous);
	} else {
		py_ous = PyList_New(*object->out.num_ous);
		if (py_ous == NULL) {
			return NULL;
		}
		{
			int ous_cntr_2;
			for (ous_cntr_2 = 0; ous_cntr_2 < (*object->out.num_ous); ous_cntr_2++) {
				PyObject *py_ous_2;
				if ((*object->out.ous)[ous_cntr_2] == NULL) {
					py_ous_2 = Py_None;
					Py_INCREF(py_ous_2);
				} else {
					if ((*object->out.ous)[ous_cntr_2] == NULL) {
						py_ous_2 = Py_None;
						Py_INCREF(py_ous_2);
					} else {
						py_ous_2 = PyUnicode_Decode((*object->out.ous)[ous_cntr_2], strlen((*object->out.ous)[ous_cntr_2]), "utf-8", "ignore");
					}
				}
				PyList_SetItem(py_ous, ous_cntr_2, py_ous_2);
			}
		}
	}
	return py_ous;
}

static int py_wkssvc_NetrGetJoinableOus2_out_set_ous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ous));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.ous");
		return -1;
	}
	object->out.ous = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ous);
	if (object->out.ous == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.ous = NULL;
	} else {
		*object->out.ous = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int ous_cntr_2;
			*object->out.ous = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), *object->out.ous, PyList_GET_SIZE(value));
			if (!*object->out.ous) { return -1; }
			talloc_set_name_const(*object->out.ous, "ARRAY: *object->out.ous");
			for (ous_cntr_2 = 0; ous_cntr_2 < PyList_GET_SIZE(value); ous_cntr_2++) {
				if (PyList_GET_ITEM(value, ous_cntr_2) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (*object->out.ous)[ous_cntr_2]");
					return -1;
				}
				if (PyList_GET_ITEM(value, ous_cntr_2) == Py_None) {
					(*object->out.ous)[ous_cntr_2] = NULL;
				} else {
					(*object->out.ous)[ous_cntr_2] = NULL;
					{
						const char *test_str;
						const char *talloc_str;
						PyObject *unicode = NULL;
						if (PyUnicode_Check(PyList_GET_ITEM(value, ous_cntr_2))) {
							unicode = PyUnicode_AsEncodedString(PyList_GET_ITEM(value, ous_cntr_2), "utf-8", "ignore");
							if (unicode == NULL) {
								return -1;
							}
							test_str = PyBytes_AS_STRING(unicode);
						} else if (PyBytes_Check(PyList_GET_ITEM(value, ous_cntr_2))) {
							test_str = PyBytes_AS_STRING(PyList_GET_ITEM(value, ous_cntr_2));
						} else {
							PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(PyList_GET_ITEM(value, ous_cntr_2))->tp_name);
							return -1;
						}
						talloc_str = talloc_strdup(*object->out.ous, test_str);
						if (unicode != NULL) {
							Py_DECREF(unicode);
						}
						if (talloc_str == NULL) {
							PyErr_NoMemory();
							return -1;
						}
						(*object->out.ous)[ous_cntr_2] = talloc_str;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_get_result(PyObject *obj, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_wkssvc_NetrGetJoinableOus2_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wkssvc_NetrGetJoinableOus2_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_wkssvc_NetrGetJoinableOus2_in_get_server_name,
		.set = py_wkssvc_NetrGetJoinableOus2_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wkssvc_NetrGetJoinableOus2_in_get_domain_name,
		.set = py_wkssvc_NetrGetJoinableOus2_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Account"),
		.get = py_wkssvc_NetrGetJoinableOus2_in_get_Account,
		.set = py_wkssvc_NetrGetJoinableOus2_in_set_Account,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_EncryptedPassword"),
		.get = py_wkssvc_NetrGetJoinableOus2_in_get_EncryptedPassword,
		.set = py_wkssvc_NetrGetJoinableOus2_in_set_EncryptedPassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type wkssvc_PasswordBuffer")
	},
	{
		.name = discard_const_p(char, "in_num_ous"),
		.get = py_wkssvc_NetrGetJoinableOus2_in_get_num_ous,
		.set = py_wkssvc_NetrGetJoinableOus2_in_set_num_ous,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_ous"),
		.get = py_wkssvc_NetrGetJoinableOus2_out_get_num_ous,
		.set = py_wkssvc_NetrGetJoinableOus2_out_set_num_ous,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_ous"),
		.get = py_wkssvc_NetrGetJoinableOus2_out_get_ous,
		.set = py_wkssvc_NetrGetJoinableOus2_out_set_ous,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wkssvc_NetrGetJoinableOus2_get_result,
		.set = py_wkssvc_NetrGetJoinableOus2_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_wkssvc_NetrGetJoinableOus2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wkssvc_NetrGetJoinableOus2, type);
	struct wkssvc_NetrGetJoinableOus2 *_self = (struct wkssvc_NetrGetJoinableOus2 *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.num_ous = talloc_zero(mem_ctx, uint32_t);
	_self->out.num_ous = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(26);
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinableOus2_ndr_pack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[26];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrGetJoinableOus2_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wkssvc_NetrGetJoinableOus2_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_wkssvc.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinableOus2_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[26];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrGetJoinableOus2_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wkssvc_NetrGetJoinableOus2_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wkssvc_NetrGetJoinableOus2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_wkssvc.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wkssvc_NetrGetJoinableOus2_ndr_print");
		return NULL;
	}
	call = &ndr_table_wkssvc.calls[26];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrGetJoinableOus2_ndr_print(py_obj, "wkssvc_NetrGetJoinableOus2_in", NDR_IN);
}

static PyObject *py_wkssvc_NetrGetJoinableOus2_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_wkssvc_NetrGetJoinableOus2_ndr_print(py_obj, "wkssvc_NetrGetJoinableOus2_out", NDR_OUT);
}

static PyMethodDef py_wkssvc_NetrGetJoinableOus2_methods[] = {
	{ "opnum", (PyCFunction)py_wkssvc_NetrGetJoinableOus2_ndr_opnum, METH_NOARGS|METH_CLASS,
		"wkssvc.NetrGetJoinableOus2.opnum() -> 26 (0x1a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinableOus2_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinableOus2_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wkssvc_NetrGetJoinableOus2_ndr_unpack_in), ME