
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_witness.h"
#include "bin/default/librpc/gen_ndr/ndr_witness_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject witness_interfaceInfo_Type;
static PyTypeObject witness_interfaceList_Type;
static PyTypeObject witness_ResourceChange_Type;
static PyTypeObject witness_IPaddrInfo_Type;
static PyTypeObject witness_IPaddrInfoList_Type;
static PyTypeObject witness_notifyResponse_message_Type;
static PyTypeObject witness_notifyResponse_Type;
static PyTypeObject witness_InterfaceType;
static PyTypeObject witness_GetInterfaceList_Type;
static PyTypeObject witness_Register_Type;
static PyTypeObject witness_UnRegister_Type;
static PyTypeObject witness_AsyncNotify_Type;
static PyTypeObject witness_RegisterEx_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_witness_interfaceInfo_get_group_name(PyObject *obj, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_group_name;
	if (object->group_name == NULL) {
		py_group_name = Py_None;
		Py_INCREF(py_group_name);
	} else {
		py_group_name = PyUnicode_Decode(object->group_name, strlen(object->group_name), "utf-8", "ignore");
	}
	return py_group_name;
}

static int py_witness_interfaceInfo_set_group_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->group_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->group_name = talloc_str;
	}
	return 0;
}

static PyObject *py_witness_interfaceInfo_get_version(PyObject *obj, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_witness_interfaceInfo_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_interfaceInfo_get_state(PyObject *obj, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_state;
	py_state = PyLong_FromLong((uint16_t)(object->state));
	return py_state;
}

static int py_witness_interfaceInfo_set_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_interfaceInfo_get_ipv4(PyObject *obj, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ipv4;
	py_ipv4 = PyString_FromStringOrNULL(object->ipv4);
	return py_ipv4;
}

static int py_witness_interfaceInfo_set_ipv4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ipv4");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipv4 = talloc_str;
	}
	return 0;
}

static PyObject *py_witness_interfaceInfo_get_ipv6(PyObject *obj, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ipv6;
	py_ipv6 = PyString_FromStringOrNULL(object->ipv6);
	return py_ipv6;
}

static int py_witness_interfaceInfo_set_ipv6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ipv6");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipv6 = talloc_str;
	}
	return 0;
}

static PyObject *py_witness_interfaceInfo_get_flags(PyObject *obj, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_witness_interfaceInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_witness_interfaceInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "group_name"),
		.get = py_witness_interfaceInfo_get_group_name,
		.set = py_witness_interfaceInfo_set_group_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_witness_interfaceInfo_get_version,
		.set = py_witness_interfaceInfo_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_version")
	},
	{
		.name = discard_const_p(char, "state"),
		.get = py_witness_interfaceInfo_get_state,
		.set = py_witness_interfaceInfo_set_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_interfaceInfo_state")
	},
	{
		.name = discard_const_p(char, "ipv4"),
		.get = py_witness_interfaceInfo_get_ipv4,
		.set = py_witness_interfaceInfo_set_ipv4,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{
		.name = discard_const_p(char, "ipv6"),
		.get = py_witness_interfaceInfo_get_ipv6,
		.set = py_witness_interfaceInfo_set_ipv6,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv6address")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_witness_interfaceInfo_get_flags,
		.set = py_witness_interfaceInfo_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_interfaceInfo_flags")
	},
	{ .name = NULL }
};

static PyObject *py_witness_interfaceInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct witness_interfaceInfo, type);
}


static PyTypeObject witness_interfaceInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.interfaceInfo",
	.tp_getset = py_witness_interfaceInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_interfaceInfo_new,
};


static PyObject *py_witness_interfaceList_get_num_interfaces(PyObject *obj, void *closure)
{
	struct witness_interfaceList *object = pytalloc_get_ptr(obj);
	PyObject *py_num_interfaces;
	py_num_interfaces = PyLong_FromUnsignedLongLong((uint32_t)(object->num_interfaces));
	return py_num_interfaces;
}

static int py_witness_interfaceList_set_num_interfaces(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_interfaces");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_interfaces));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_interfaces = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_interfaceList_get_interfaces(PyObject *obj, void *closure)
{
	struct witness_interfaceList *object = pytalloc_get_ptr(obj);
	PyObject *py_interfaces;
	if (object->interfaces == NULL) {
		Py_RETURN_NONE;
	}
	if (object->interfaces == NULL) {
		py_interfaces = Py_None;
		Py_INCREF(py_interfaces);
	} else {
		py_interfaces = PyList_New(object->num_interfaces);
		if (py_interfaces == NULL) {
			return NULL;
		}
		{
			int interfaces_cntr_1;
			for (interfaces_cntr_1 = 0; interfaces_cntr_1 < (object->num_interfaces); interfaces_cntr_1++) {
				PyObject *py_interfaces_1;
				py_interfaces_1 = pytalloc_reference_ex(&witness_interfaceInfo_Type, object->interfaces, &(object->interfaces)[interfaces_cntr_1]);
				PyList_SetItem(py_interfaces, interfaces_cntr_1, py_interfaces_1);
			}
		}
	}
	return py_interfaces;
}

static int py_witness_interfaceList_set_interfaces(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_interfaceList *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->interfaces));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->interfaces");
		return -1;
	}
	if (value == Py_None) {
		object->interfaces = NULL;
	} else {
		object->interfaces = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int interfaces_cntr_1;
			object->interfaces = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->interfaces, PyList_GET_SIZE(value));
			if (!object->interfaces) { return -1; }
			talloc_set_name_const(object->interfaces, "ARRAY: object->interfaces");
			for (interfaces_cntr_1 = 0; interfaces_cntr_1 < PyList_GET_SIZE(value); interfaces_cntr_1++) {
				if (PyList_GET_ITEM(value, interfaces_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->interfaces)[interfaces_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&witness_interfaceInfo_Type, PyList_GET_ITEM(value, interfaces_cntr_1), return -1;);
				if (talloc_reference(object->interfaces, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, interfaces_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->interfaces)[interfaces_cntr_1] = *(struct witness_interfaceInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, interfaces_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_witness_interfaceList_getsetters[] = {
	{
		.name = discard_const_p(char, "num_interfaces"),
		.get = py_witness_interfaceList_get_num_interfaces,
		.set = py_witness_interfaceList_set_num_interfaces,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "interfaces"),
		.get = py_witness_interfaceList_get_interfaces,
		.set = py_witness_interfaceList_set_interfaces,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_interfaceInfo")
	},
	{ .name = NULL }
};

static PyObject *py_witness_interfaceList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct witness_interfaceList, type);
}

static PyObject *py_witness_interfaceList_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct witness_interfaceList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_witness_interfaceList);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_witness_interfaceList_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct witness_interfaceList *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_interfaceList);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_interfaceList);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_witness_interfaceList_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct witness_interfaceList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_witness_interfaceList, "witness_interfaceList", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_witness_interfaceList_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_witness_interfaceList_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_interfaceList_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_witness_interfaceList_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_interfaceList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.interfaceList",
	.tp_getset = py_witness_interfaceList_getsetters,
	.tp_methods = py_witness_interfaceList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_interfaceList_new,
};


static PyObject *py_witness_ResourceChange_get_length(PyObject *obj, void *closure)
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_witness_ResourceChange_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_ResourceChange_get_type(PyObject *obj, void *closure)
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_witness_ResourceChange_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_ResourceChange_get_name(PyObject *obj, void *closure)
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_witness_ResourceChange_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_witness_ResourceChange_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_witness_ResourceChange_get_length,
		.set = py_witness_ResourceChange_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_witness_ResourceChange_get_type,
		.set = py_witness_ResourceChange_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_ResourceChange_type")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_witness_ResourceChange_get_name,
		.set = py_witness_ResourceChange_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_witness_ResourceChange_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct witness_ResourceChange, type);
}

static PyObject *py_witness_ResourceChange_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_witness_ResourceChange);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_witness_ResourceChange_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_ResourceChange);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_ResourceChange);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_witness_ResourceChange_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct witness_ResourceChange *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_witness_ResourceChange, "witness_ResourceChange", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_witness_ResourceChange_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_witness_ResourceChange_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_ResourceChange_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_witness_ResourceChange_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_ResourceChange_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.ResourceChange",
	.tp_getset = py_witness_ResourceChange_getsetters,
	.tp_methods = py_witness_ResourceChange_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_ResourceChange_new,
};


static PyObject *py_witness_IPaddrInfo_get_flags(PyObject *obj, void *closure)
{
	struct witness_IPaddrInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_witness_IPaddrInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_IPaddrInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_IPaddrInfo_get_ipv4(PyObject *obj, void *closure)
{
	struct witness_IPaddrInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ipv4;
	py_ipv4 = PyString_FromStringOrNULL(object->ipv4);
	return py_ipv4;
}

static int py_witness_IPaddrInfo_set_ipv4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_IPaddrInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ipv4");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipv4 = talloc_str;
	}
	return 0;
}

static PyObject *py_witness_IPaddrInfo_get_ipv6(PyObject *obj, void *closure)
{
	struct witness_IPaddrInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ipv6;
	py_ipv6 = PyString_FromStringOrNULL(object->ipv6);
	return py_ipv6;
}

static int py_witness_IPaddrInfo_set_ipv6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_IPaddrInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ipv6");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipv6 = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_witness_IPaddrInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_witness_IPaddrInfo_get_flags,
		.set = py_witness_IPaddrInfo_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_IPaddrInfo_flags")
	},
	{
		.name = discard_const_p(char, "ipv4"),
		.get = py_witness_IPaddrInfo_get_ipv4,
		.set = py_witness_IPaddrInfo_set_ipv4,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{
		.name = discard_const_p(char, "ipv6"),
		.get = py_witness_IPaddrInfo_get_ipv6,
		.set = py_witness_IPaddrInfo_set_ipv6,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv6address")
	},
	{ .name = NULL }
};

static PyObject *py_witness_IPaddrInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct witness_IPaddrInfo, type);
}


static PyTypeObject witness_IPaddrInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.IPaddrInfo",
	.tp_getset = py_witness_IPaddrInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_IPaddrInfo_new,
};


static PyObject *py_witness_IPaddrInfoList_get_length(PyObject *obj, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_witness_IPaddrInfoList_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_IPaddrInfoList_get_reserved(PyObject *obj, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_witness_IPaddrInfoList_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_IPaddrInfoList_get_num(PyObject *obj, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(obj);
	PyObject *py_num;
	py_num = PyLong_FromUnsignedLongLong((uint32_t)(object->num));
	return py_num;
}

static int py_witness_IPaddrInfoList_set_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_IPaddrInfoList_get_addr(PyObject *obj, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(obj);
	PyObject *py_addr;
	py_addr = PyList_New(object->num);
	if (py_addr == NULL) {
		return NULL;
	}
	{
		int addr_cntr_0;
		for (addr_cntr_0 = 0; addr_cntr_0 < (object->num); addr_cntr_0++) {
			PyObject *py_addr_0;
			py_addr_0 = pytalloc_reference_ex(&witness_IPaddrInfo_Type, object->addr, &(object->addr)[addr_cntr_0]);
			PyList_SetItem(py_addr, addr_cntr_0, py_addr_0);
		}
	}
	return py_addr;
}

static int py_witness_IPaddrInfoList_set_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->addr");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int addr_cntr_0;
		object->addr = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addr, PyList_GET_SIZE(value));
		if (!object->addr) { return -1; }
		talloc_set_name_const(object->addr, "ARRAY: object->addr");
		for (addr_cntr_0 = 0; addr_cntr_0 < PyList_GET_SIZE(value); addr_cntr_0++) {
			if (PyList_GET_ITEM(value, addr_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->addr)[addr_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&witness_IPaddrInfo_Type, PyList_GET_ITEM(value, addr_cntr_0), return -1;);
			if (talloc_reference(object->addr, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, addr_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->addr)[addr_cntr_0] = *(struct witness_IPaddrInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, addr_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_witness_IPaddrInfoList_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_witness_IPaddrInfoList_get_length,
		.set = py_witness_IPaddrInfoList_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_witness_IPaddrInfoList_get_reserved,
		.set = py_witness_IPaddrInfoList_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num"),
		.get = py_witness_IPaddrInfoList_get_num,
		.set = py_witness_IPaddrInfoList_set_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "addr"),
		.get = py_witness_IPaddrInfoList_get_addr,
		.set = py_witness_IPaddrInfoList_set_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_IPaddrInfo")
	},
	{ .name = NULL }
};

static PyObject *py_witness_IPaddrInfoList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct witness_IPaddrInfoList, type);
}

static PyObject *py_witness_IPaddrInfoList_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_witness_IPaddrInfoList);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_witness_IPaddrInfoList_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_IPaddrInfoList);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_IPaddrInfoList);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_witness_IPaddrInfoList_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct witness_IPaddrInfoList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_witness_IPaddrInfoList, "witness_IPaddrInfoList", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_witness_IPaddrInfoList_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_witness_IPaddrInfoList_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_IPaddrInfoList_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_witness_IPaddrInfoList_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_IPaddrInfoList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.IPaddrInfoList",
	.tp_getset = py_witness_IPaddrInfoList_getsetters,
	.tp_methods = py_witness_IPaddrInfoList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_IPaddrInfoList_new,
};

static PyObject *py_import_witness_notifyResponse_message(TALLOC_CTX *mem_ctx, int level, union witness_notifyResponse_message *in)
{
	PyObject *ret;

	switch (level) {
		case WITNESS_NOTIFY_RESOURCE_CHANGE:
			ret = pytalloc_reference_ex(&witness_ResourceChange_Type, mem_ctx, &in->resource_change);
			return ret;

		case WITNESS_NOTIFY_CLIENT_MOVE:
			ret = pytalloc_reference_ex(&witness_IPaddrInfoList_Type, mem_ctx, &in->client_move);
			return ret;

		case WITNESS_NOTIFY_SHARE_MOVE:
			ret = pytalloc_reference_ex(&witness_IPaddrInfoList_Type, mem_ctx, &in->share_move);
			return ret;

		case WITNESS_NOTIFY_IP_CHANGE:
			ret = pytalloc_reference_ex(&witness_IPaddrInfoList_Type, mem_ctx, &in->ip_change);
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->data).data, (in->data).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union witness_notifyResponse_message *py_export_witness_notifyResponse_message(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union witness_notifyResponse_message *ret = talloc_zero(mem_ctx, union witness_notifyResponse_message);
	switch (level) {
		case WITNESS_NOTIFY_RESOURCE_CHANGE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->resource_change");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&witness_ResourceChange_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->resource_change = *(struct witness_ResourceChange *)pytalloc_get_ptr(in);
			break;

		case WITNESS_NOTIFY_CLIENT_MOVE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->client_move");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&witness_IPaddrInfoList_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->client_move = *(struct witness_IPaddrInfoList *)pytalloc_get_ptr(in);
			break;

		case WITNESS_NOTIFY_SHARE_MOVE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->share_move");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&witness_IPaddrInfoList_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->share_move = *(struct witness_IPaddrInfoList *)pytalloc_get_ptr(in);
			break;

		case WITNESS_NOTIFY_IP_CHANGE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ip_change");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&witness_IPaddrInfoList_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ip_change = *(struct witness_IPaddrInfoList *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->data");
				talloc_free(ret); return NULL;
			}
			ret->data = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_witness_notifyResponse_message_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union witness_notifyResponse_message *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union witness_notifyResponse_message *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union witness_notifyResponse_message!");
		return NULL;
	}

	return py_import_witness_notifyResponse_message(mem_ctx, level, in);
}

static PyObject *py_witness_notifyResponse_message_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union witness_notifyResponse_message *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_witness_notifyResponse_message(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_witness_notifyResponse_message_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_notifyResponse_message_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_notifyResponse_message_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_witness_notifyResponse_message_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject witness_notifyResponse_message_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.notifyResponse_message",
	.tp_getset = NULL,
	.tp_methods = py_witness_notifyResponse_message_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_notifyResponse_message_new,
};


static PyObject *py_witness_notifyResponse_get_type(PyObject *obj, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_witness_notifyResponse_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_notifyResponse_get_length(PyObject *obj, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_witness_notifyResponse_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_notifyResponse_get_num(PyObject *obj, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(obj);
	PyObject *py_num;
	py_num = PyLong_FromUnsignedLongLong((uint32_t)(object->num));
	return py_num;
}

static int py_witness_notifyResponse_set_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_notifyResponse_get_messages(PyObject *obj, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(obj);
	PyObject *py_messages;
	if (object->messages == NULL) {
		Py_RETURN_NONE;
	}
	if (object->messages == NULL) {
		py_messages = Py_None;
		Py_INCREF(py_messages);
	} else {
		py_messages = PyList_New(object->num);
		if (py_messages == NULL) {
			return NULL;
		}
		{
			int messages_cntr_1;
			for (messages_cntr_1 = 0; messages_cntr_1 < (object->num); messages_cntr_1++) {
				PyObject *py_messages_1;
				py_messages_1 = pyrpc_import_union(&witness_notifyResponse_message_Type, object->messages, object->type, &(object->messages)[messages_cntr_1], "union witness_notifyResponse_message");
				if (py_messages_1 == NULL) {
					return NULL;
				}
				PyList_SetItem(py_messages, messages_cntr_1, py_messages_1);
			}
		}
	}
	return py_messages;
}

static int py_witness_notifyResponse_set_messages(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->messages));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->messages");
		return -1;
	}
	if (value == Py_None) {
		object->messages = NULL;
	} else {
		object->messages = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int messages_cntr_1;
			object->messages = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->messages, PyList_GET_SIZE(value));
			if (!object->messages) { return -1; }
			talloc_set_name_const(object->messages, "ARRAY: object->messages");
			for (messages_cntr_1 = 0; messages_cntr_1 < PyList_GET_SIZE(value); messages_cntr_1++) {
				if (PyList_GET_ITEM(value, messages_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->messages)[messages_cntr_1]");
					return -1;
				}
				{
					union witness_notifyResponse_message *messages_switch_3;
					messages_switch_3 = (union witness_notifyResponse_message *)pyrpc_export_union(&witness_notifyResponse_message_Type, object->messages, object->type, PyList_GET_ITEM(value, messages_cntr_1), "union witness_notifyResponse_message");
					if (messages_switch_3 == NULL) {
						return -1;
					}
					(object->messages)[messages_cntr_1] = *messages_switch_3;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_witness_notifyResponse_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_witness_notifyResponse_get_type,
		.set = py_witness_notifyResponse_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_notifyResponse_type")
	},
	{
		.name = discard_const_p(char, "length"),
		.get = py_witness_notifyResponse_get_length,
		.set = py_witness_notifyResponse_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num"),
		.get = py_witness_notifyResponse_get_num,
		.set = py_witness_notifyResponse_set_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "messages"),
		.get = py_witness_notifyResponse_get_messages,
		.set = py_witness_notifyResponse_set_messages,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_notifyResponse_message")
	},
	{ .name = NULL }
};

static PyObject *py_witness_notifyResponse_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct witness_notifyResponse, type);
}

static PyObject *py_witness_notifyResponse_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_witness_notifyResponse);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_witness_notifyResponse_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_notifyResponse);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_witness_notifyResponse);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_witness_notifyResponse_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct witness_notifyResponse *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_witness_notifyResponse, "witness_notifyResponse", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_witness_notifyResponse_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_witness_notifyResponse_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_notifyResponse_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_witness_notifyResponse_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_notifyResponse_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.notifyResponse",
	.tp_getset = py_witness_notifyResponse_getsetters,
	.tp_methods = py_witness_notifyResponse_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_notifyResponse_new,
};



static PyObject *py_witness_GetInterfaceList_out_get_interface_list(PyObject *obj, void *closure)
{
	struct witness_GetInterfaceList *object = pytalloc_get_ptr(obj);
	PyObject *py_interface_list;
	if (object->out.interface_list == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.interface_list == NULL) {
		py_interface_list = Py_None;
		Py_INCREF(py_interface_list);
	} else {
		py_interface_list = pytalloc_reference_ex(&witness_interfaceList_Type, *object->out.interface_list, *object->out.interface_list);
	}
	return py_interface_list;
}

static int py_witness_GetInterfaceList_out_set_interface_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_GetInterfaceList *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.interface_list));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.interface_list");
		return -1;
	}
	object->out.interface_list = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.interface_list);
	if (object->out.interface_list == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.interface_list = NULL;
	} else {
		*object->out.interface_list = NULL;
		PY_CHECK_TYPE(&witness_interfaceList_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.interface_list = (struct witness_interfaceList *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_witness_GetInterfaceList_get_result(PyObject *obj, void *closure)
{
	struct witness_GetInterfaceList *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_witness_GetInterfaceList_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_GetInterfaceList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_witness_GetInterfaceList_getsetters[] = {
	{
		.name = discard_const_p(char, "out_interface_list"),
		.get = py_witness_GetInterfaceList_out_get_interface_list,
		.set = py_witness_GetInterfaceList_out_set_interface_list,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_interfaceList")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_witness_GetInterfaceList_get_result,
		.set = py_witness_GetInterfaceList_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_witness_GetInterfaceList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct witness_GetInterfaceList, type);
	struct witness_GetInterfaceList *_self = (struct witness_GetInterfaceList *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.interface_list = talloc_zero(mem_ctx, struct witness_interfaceList *);
	return self;
}

static PyObject *py_witness_GetInterfaceList_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_witness_GetInterfaceList_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_GetInterfaceList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_GetInterfaceList_ndr_pack");
		return NULL;
	}
	call = &ndr_table_witness.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_witness_GetInterfaceList_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_GetInterfaceList_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_witness_GetInterfaceList_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_GetInterfaceList_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_witness_GetInterfaceList_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_GetInterfaceList *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_GetInterfaceList_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_witness.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_witness_GetInterfaceList_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_GetInterfaceList_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_GetInterfaceList_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_GetInterfaceList_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_GetInterfaceList_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_GetInterfaceList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_witness.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_GetInterfaceList_ndr_print");
		return NULL;
	}
	call = &ndr_table_witness.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_witness_GetInterfaceList_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_GetInterfaceList_ndr_print(py_obj, "witness_GetInterfaceList_in", NDR_IN);
}

static PyObject *py_witness_GetInterfaceList_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_GetInterfaceList_ndr_print(py_obj, "witness_GetInterfaceList_out", NDR_OUT);
}

static PyMethodDef py_witness_GetInterfaceList_methods[] = {
	{ "opnum", (PyCFunction)py_witness_GetInterfaceList_ndr_opnum, METH_NOARGS|METH_CLASS,
		"witness.GetInterfaceList.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_GetInterfaceList_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_GetInterfaceList_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_GetInterfaceList_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_GetInterfaceList_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_witness_GetInterfaceList_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_witness_GetInterfaceList_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_GetInterfaceList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.GetInterfaceList",
	.tp_getset = py_witness_GetInterfaceList_getsetters,
	.tp_methods = py_witness_GetInterfaceList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_GetInterfaceList_new,
};

static bool pack_py_witness_GetInterfaceList_args_in(PyObject *args, PyObject *kwargs, struct witness_GetInterfaceList *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":witness_GetInterfaceList", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_witness_GetInterfaceList_args_out(struct witness_GetInterfaceList *r)
{
	PyObject *result;
	PyObject *py_interface_list;
	if (*r->out.interface_list == NULL) {
		py_interface_list = Py_None;
		Py_INCREF(py_interface_list);
	} else {
		py_interface_list = pytalloc_reference_ex(&witness_interfaceList_Type, *r->out.interface_list, *r->out.interface_list);
	}
	result = py_interface_list;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_witness_Register_out_get_context_handle(PyObject *obj, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(obj);
	PyObject *py_context_handle;
	if (object->out.context_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_context_handle = pytalloc_reference_ex(policy_handle_Type, object->out.context_handle, object->out.context_handle);
	return py_context_handle;
}

static int py_witness_Register_out_set_context_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.context_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.context_handle");
		return -1;
	}
	object->out.context_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.context_handle);
	if (object->out.context_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.context_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_witness_Register_in_get_version(PyObject *obj, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->in.version));
	return py_version;
}

static int py_witness_Register_in_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_Register_in_get_net_name(PyObject *obj, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(obj);
	PyObject *py_net_name;
	if (object->in.net_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.net_name == NULL) {
		py_net_name = Py_None;
		Py_INCREF(py_net_name);
	} else {
		if (object->in.net_name == NULL) {
			py_net_name = Py_None;
			Py_INCREF(py_net_name);
		} else {
			py_net_name = PyUnicode_Decode(object->in.net_name, strlen(object->in.net_name), "utf-8", "ignore");
		}
	}
	return py_net_name;
}

static int py_witness_Register_in_set_net_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.net_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.net_name = NULL;
	} else {
		object->in.net_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.net_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_witness_Register_in_get_ip_address(PyObject *obj, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(obj);
	PyObject *py_ip_address;
	if (object->in.ip_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.ip_address == NULL) {
		py_ip_address = Py_None;
		Py_INCREF(py_ip_address);
	} else {
		if (object->in.ip_address == NULL) {
			py_ip_address = Py_None;
			Py_INCREF(py_ip_address);
		} else {
			py_ip_address = PyUnicode_Decode(object->in.ip_address, strlen(object->in.ip_address), "utf-8", "ignore");
		}
	}
	return py_ip_address;
}

static int py_witness_Register_in_set_ip_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ip_address");
		return -1;
	}
	if (value == Py_None) {
		object->in.ip_address = NULL;
	} else {
		object->in.ip_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.ip_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_witness_Register_in_get_client_computer_name(PyObject *obj, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(obj);
	PyObject *py_client_computer_name;
	if (object->in.client_computer_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_computer_name == NULL) {
		py_client_computer_name = Py_None;
		Py_INCREF(py_client_computer_name);
	} else {
		if (object->in.client_computer_name == NULL) {
			py_client_computer_name = Py_None;
			Py_INCREF(py_client_computer_name);
		} else {
			py_client_computer_name = PyUnicode_Decode(object->in.client_computer_name, strlen(object->in.client_computer_name), "utf-8", "ignore");
		}
	}
	return py_client_computer_name;
}

static int py_witness_Register_in_set_client_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.client_computer_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.client_computer_name = NULL;
	} else {
		object->in.client_computer_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.client_computer_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_witness_Register_get_result(PyObject *obj, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_witness_Register_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_witness_Register_getsetters[] = {
	{
		.name = discard_const_p(char, "out_context_handle"),
		.get = py_witness_Register_out_get_context_handle,
		.set = py_witness_Register_out_set_context_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_version"),
		.get = py_witness_Register_in_get_version,
		.set = py_witness_Register_in_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_version")
	},
	{
		.name = discard_const_p(char, "in_net_name"),
		.get = py_witness_Register_in_get_net_name,
		.set = py_witness_Register_in_set_net_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_ip_address"),
		.get = py_witness_Register_in_get_ip_address,
		.set = py_witness_Register_in_set_ip_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_client_computer_name"),
		.get = py_witness_Register_in_get_client_computer_name,
		.set = py_witness_Register_in_set_client_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_witness_Register_get_result,
		.set = py_witness_Register_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_witness_Register_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct witness_Register, type);
	struct witness_Register *_self = (struct witness_Register *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.context_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_witness_Register_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_witness_Register_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_Register_ndr_pack");
		return NULL;
	}
	call = &ndr_table_witness.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_witness_Register_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_Register_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_witness_Register_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_Register_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_witness_Register_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_Register_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_witness.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_witness_Register_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_Register_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_Register_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_Register_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_Register_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_Register *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_witness.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_Register_ndr_print");
		return NULL;
	}
	call = &ndr_table_witness.calls[1];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_witness_Register_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_Register_ndr_print(py_obj, "witness_Register_in", NDR_IN);
}

static PyObject *py_witness_Register_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_Register_ndr_print(py_obj, "witness_Register_out", NDR_OUT);
}

static PyMethodDef py_witness_Register_methods[] = {
	{ "opnum", (PyCFunction)py_witness_Register_ndr_opnum, METH_NOARGS|METH_CLASS,
		"witness.Register.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_Register_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_Register_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_Register_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_Register_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_witness_Register_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_witness_Register_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_Register_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.Register",
	.tp_getset = py_witness_Register_getsetters,
	.tp_methods = py_witness_Register_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_Register_new,
};

static bool pack_py_witness_Register_args_in(PyObject *args, PyObject *kwargs, struct witness_Register *r)
{
	PyObject *py_version;
	PyObject *py_net_name;
	PyObject *py_ip_address;
	PyObject *py_client_computer_name;
	const char *kwnames[] = {
		"version", "net_name", "ip_address", "client_computer_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:witness_Register", discard_const_p(char *, kwnames), &py_version, &py_net_name, &py_ip_address, &py_client_computer_name)) {
		return false;
	}

	if (py_version == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.version");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.version));
		if (PyLong_Check(py_version)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_version);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_net_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.net_name");
		return false;
	}
	if (py_net_name == Py_None) {
		r->in.net_name = NULL;
	} else {
		r->in.net_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_net_name)) {
				unicode = PyUnicode_AsEncodedString(py_net_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_net_name)) {
				test_str = PyBytes_AS_STRING(py_net_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_net_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.net_name = talloc_str;
		}
	}
	if (py_ip_address == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ip_address");
		return false;
	}
	if (py_ip_address == Py_None) {
		r->in.ip_address = NULL;
	} else {
		r->in.ip_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_ip_address)) {
				unicode = PyUnicode_AsEncodedString(py_ip_address, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_ip_address)) {
				test_str = PyBytes_AS_STRING(py_ip_address);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ip_address)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.ip_address = talloc_str;
		}
	}
	if (py_client_computer_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.client_computer_name");
		return false;
	}
	if (py_client_computer_name == Py_None) {
		r->in.client_computer_name = NULL;
	} else {
		r->in.client_computer_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_client_computer_name)) {
				unicode = PyUnicode_AsEncodedString(py_client_computer_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_client_computer_name)) {
				test_str = PyBytes_AS_STRING(py_client_computer_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_computer_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.client_computer_name = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_witness_Register_args_out(struct witness_Register *r)
{
	PyObject *result;
	PyObject *py_context_handle;
	py_context_handle = pytalloc_reference_ex(policy_handle_Type, r->out.context_handle, r->out.context_handle);
	result = py_context_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_witness_UnRegister_in_get_context_handle(PyObject *obj, void *closure)
{
	struct witness_UnRegister *object = pytalloc_get_ptr(obj);
	PyObject *py_context_handle;
	py_context_handle = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.context_handle);
	return py_context_handle;
}

static int py_witness_UnRegister_in_set_context_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_UnRegister *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.context_handle");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.context_handle = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_witness_UnRegister_get_result(PyObject *obj, void *closure)
{
	struct witness_UnRegister *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_witness_UnRegister_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_UnRegister *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_witness_UnRegister_getsetters[] = {
	{
		.name = discard_const_p(char, "in_context_handle"),
		.get = py_witness_UnRegister_in_get_context_handle,
		.set = py_witness_UnRegister_in_set_context_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_witness_UnRegister_get_result,
		.set = py_witness_UnRegister_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_witness_UnRegister_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct witness_UnRegister, type);
	return self;
}

static PyObject *py_witness_UnRegister_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_witness_UnRegister_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_UnRegister *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_UnRegister_ndr_pack");
		return NULL;
	}
	call = &ndr_table_witness.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_witness_UnRegister_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_UnRegister_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_witness_UnRegister_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_UnRegister_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_witness_UnRegister_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_UnRegister *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_UnRegister_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_witness.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_witness_UnRegister_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_UnRegister_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_UnRegister_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_UnRegister_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_UnRegister_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_UnRegister *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_witness.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_UnRegister_ndr_print");
		return NULL;
	}
	call = &ndr_table_witness.calls[2];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_witness_UnRegister_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_UnRegister_ndr_print(py_obj, "witness_UnRegister_in", NDR_IN);
}

static PyObject *py_witness_UnRegister_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_UnRegister_ndr_print(py_obj, "witness_UnRegister_out", NDR_OUT);
}

static PyMethodDef py_witness_UnRegister_methods[] = {
	{ "opnum", (PyCFunction)py_witness_UnRegister_ndr_opnum, METH_NOARGS|METH_CLASS,
		"witness.UnRegister.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_UnRegister_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_UnRegister_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_UnRegister_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_UnRegister_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_witness_UnRegister_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_witness_UnRegister_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_UnRegister_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.UnRegister",
	.tp_getset = py_witness_UnRegister_getsetters,
	.tp_methods = py_witness_UnRegister_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_UnRegister_new,
};

static bool pack_py_witness_UnRegister_args_in(PyObject *args, PyObject *kwargs, struct witness_UnRegister *r)
{
	PyObject *py_context_handle;
	const char *kwnames[] = {
		"context_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:witness_UnRegister", discard_const_p(char *, kwnames), &py_context_handle)) {
		return false;
	}

	if (py_context_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.context_handle");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_context_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_context_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.context_handle = *(struct policy_handle *)pytalloc_get_ptr(py_context_handle);
	return true;
}

static PyObject *unpack_py_witness_UnRegister_args_out(struct witness_UnRegister *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_witness_AsyncNotify_in_get_context_handle(PyObject *obj, void *closure)
{
	struct witness_AsyncNotify *object = pytalloc_get_ptr(obj);
	PyObject *py_context_handle;
	py_context_handle = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.context_handle);
	return py_context_handle;
}

static int py_witness_AsyncNotify_in_set_context_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_AsyncNotify *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.context_handle");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.context_handle = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_witness_AsyncNotify_out_get_response(PyObject *obj, void *closure)
{
	struct witness_AsyncNotify *object = pytalloc_get_ptr(obj);
	PyObject *py_response;
	if (object->out.response == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.response == NULL) {
		py_response = Py_None;
		Py_INCREF(py_response);
	} else {
		py_response = pytalloc_reference_ex(&witness_notifyResponse_Type, *object->out.response, *object->out.response);
	}
	return py_response;
}

static int py_witness_AsyncNotify_out_set_response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_AsyncNotify *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.response));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.response");
		return -1;
	}
	object->out.response = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.response);
	if (object->out.response == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.response = NULL;
	} else {
		*object->out.response = NULL;
		PY_CHECK_TYPE(&witness_notifyResponse_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.response = (struct witness_notifyResponse *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_witness_AsyncNotify_get_result(PyObject *obj, void *closure)
{
	struct witness_AsyncNotify *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_witness_AsyncNotify_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_AsyncNotify *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_witness_AsyncNotify_getsetters[] = {
	{
		.name = discard_const_p(char, "in_context_handle"),
		.get = py_witness_AsyncNotify_in_get_context_handle,
		.set = py_witness_AsyncNotify_in_set_context_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_response"),
		.get = py_witness_AsyncNotify_out_get_response,
		.set = py_witness_AsyncNotify_out_set_response,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_notifyResponse")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_witness_AsyncNotify_get_result,
		.set = py_witness_AsyncNotify_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_witness_AsyncNotify_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct witness_AsyncNotify, type);
	struct witness_AsyncNotify *_self = (struct witness_AsyncNotify *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.response = talloc_zero(mem_ctx, struct witness_notifyResponse *);
	return self;
}

static PyObject *py_witness_AsyncNotify_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_witness_AsyncNotify_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_AsyncNotify *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_AsyncNotify_ndr_pack");
		return NULL;
	}
	call = &ndr_table_witness.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_witness_AsyncNotify_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_AsyncNotify_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_witness_AsyncNotify_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_AsyncNotify_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_witness_AsyncNotify_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_AsyncNotify *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_AsyncNotify_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_witness.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_witness_AsyncNotify_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_AsyncNotify_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_AsyncNotify_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_AsyncNotify_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_AsyncNotify_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_AsyncNotify *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_witness.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_AsyncNotify_ndr_print");
		return NULL;
	}
	call = &ndr_table_witness.calls[3];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_witness_AsyncNotify_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_AsyncNotify_ndr_print(py_obj, "witness_AsyncNotify_in", NDR_IN);
}

static PyObject *py_witness_AsyncNotify_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_AsyncNotify_ndr_print(py_obj, "witness_AsyncNotify_out", NDR_OUT);
}

static PyMethodDef py_witness_AsyncNotify_methods[] = {
	{ "opnum", (PyCFunction)py_witness_AsyncNotify_ndr_opnum, METH_NOARGS|METH_CLASS,
		"witness.AsyncNotify.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_AsyncNotify_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_AsyncNotify_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_AsyncNotify_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_AsyncNotify_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_witness_AsyncNotify_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_witness_AsyncNotify_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_AsyncNotify_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.AsyncNotify",
	.tp_getset = py_witness_AsyncNotify_getsetters,
	.tp_methods = py_witness_AsyncNotify_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_AsyncNotify_new,
};

static bool pack_py_witness_AsyncNotify_args_in(PyObject *args, PyObject *kwargs, struct witness_AsyncNotify *r)
{
	PyObject *py_context_handle;
	const char *kwnames[] = {
		"context_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:witness_AsyncNotify", discard_const_p(char *, kwnames), &py_context_handle)) {
		return false;
	}

	if (py_context_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.context_handle");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_context_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_context_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.context_handle = *(struct policy_handle *)pytalloc_get_ptr(py_context_handle);
	return true;
}

static PyObject *unpack_py_witness_AsyncNotify_args_out(struct witness_AsyncNotify *r)
{
	PyObject *result;
	PyObject *py_response;
	if (*r->out.response == NULL) {
		py_response = Py_None;
		Py_INCREF(py_response);
	} else {
		py_response = pytalloc_reference_ex(&witness_notifyResponse_Type, *r->out.response, *r->out.response);
	}
	result = py_response;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_witness_RegisterEx_out_get_context_handle(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_context_handle;
	if (object->out.context_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_context_handle = pytalloc_reference_ex(policy_handle_Type, object->out.context_handle, object->out.context_handle);
	return py_context_handle;
}

static int py_witness_RegisterEx_out_set_context_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.context_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.context_handle");
		return -1;
	}
	object->out.context_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.context_handle);
	if (object->out.context_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.context_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_witness_RegisterEx_in_get_version(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->in.version));
	return py_version;
}

static int py_witness_RegisterEx_in_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_RegisterEx_in_get_net_name(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_net_name;
	if (object->in.net_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.net_name == NULL) {
		py_net_name = Py_None;
		Py_INCREF(py_net_name);
	} else {
		if (object->in.net_name == NULL) {
			py_net_name = Py_None;
			Py_INCREF(py_net_name);
		} else {
			py_net_name = PyUnicode_Decode(object->in.net_name, strlen(object->in.net_name), "utf-8", "ignore");
		}
	}
	return py_net_name;
}

static int py_witness_RegisterEx_in_set_net_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.net_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.net_name = NULL;
	} else {
		object->in.net_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.net_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_witness_RegisterEx_in_get_share_name(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_share_name;
	if (object->in.share_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.share_name == NULL) {
		py_share_name = Py_None;
		Py_INCREF(py_share_name);
	} else {
		if (object->in.share_name == NULL) {
			py_share_name = Py_None;
			Py_INCREF(py_share_name);
		} else {
			py_share_name = PyUnicode_Decode(object->in.share_name, strlen(object->in.share_name), "utf-8", "ignore");
		}
	}
	return py_share_name;
}

static int py_witness_RegisterEx_in_set_share_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.share_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.share_name = NULL;
	} else {
		object->in.share_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.share_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_witness_RegisterEx_in_get_ip_address(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_ip_address;
	if (object->in.ip_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.ip_address == NULL) {
		py_ip_address = Py_None;
		Py_INCREF(py_ip_address);
	} else {
		if (object->in.ip_address == NULL) {
			py_ip_address = Py_None;
			Py_INCREF(py_ip_address);
		} else {
			py_ip_address = PyUnicode_Decode(object->in.ip_address, strlen(object->in.ip_address), "utf-8", "ignore");
		}
	}
	return py_ip_address;
}

static int py_witness_RegisterEx_in_set_ip_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ip_address");
		return -1;
	}
	if (value == Py_None) {
		object->in.ip_address = NULL;
	} else {
		object->in.ip_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.ip_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_witness_RegisterEx_in_get_client_computer_name(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_client_computer_name;
	if (object->in.client_computer_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_computer_name == NULL) {
		py_client_computer_name = Py_None;
		Py_INCREF(py_client_computer_name);
	} else {
		if (object->in.client_computer_name == NULL) {
			py_client_computer_name = Py_None;
			Py_INCREF(py_client_computer_name);
		} else {
			py_client_computer_name = PyUnicode_Decode(object->in.client_computer_name, strlen(object->in.client_computer_name), "utf-8", "ignore");
		}
	}
	return py_client_computer_name;
}

static int py_witness_RegisterEx_in_set_client_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.client_computer_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.client_computer_name = NULL;
	} else {
		object->in.client_computer_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.client_computer_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_witness_RegisterEx_in_get_flags(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_witness_RegisterEx_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_RegisterEx_in_get_timeout(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_timeout;
	py_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->in.timeout));
	return py_timeout;
}

static int py_witness_RegisterEx_in_set_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_witness_RegisterEx_get_result(PyObject *obj, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_witness_RegisterEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_witness_RegisterEx_getsetters[] = {
	{
		.name = discard_const_p(char, "out_context_handle"),
		.get = py_witness_RegisterEx_out_get_context_handle,
		.set = py_witness_RegisterEx_out_set_context_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_version"),
		.get = py_witness_RegisterEx_in_get_version,
		.set = py_witness_RegisterEx_in_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_version")
	},
	{
		.name = discard_const_p(char, "in_net_name"),
		.get = py_witness_RegisterEx_in_get_net_name,
		.set = py_witness_RegisterEx_in_set_net_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_share_name"),
		.get = py_witness_RegisterEx_in_get_share_name,
		.set = py_witness_RegisterEx_in_set_share_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_ip_address"),
		.get = py_witness_RegisterEx_in_get_ip_address,
		.set = py_witness_RegisterEx_in_set_ip_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_client_computer_name"),
		.get = py_witness_RegisterEx_in_get_client_computer_name,
		.set = py_witness_RegisterEx_in_set_client_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_witness_RegisterEx_in_get_flags,
		.set = py_witness_RegisterEx_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type witness_RegisterEx_flags")
	},
	{
		.name = discard_const_p(char, "in_timeout"),
		.get = py_witness_RegisterEx_in_get_timeout,
		.set = py_witness_RegisterEx_in_set_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_witness_RegisterEx_get_result,
		.set = py_witness_RegisterEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_witness_RegisterEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct witness_RegisterEx, type);
	struct witness_RegisterEx *_self = (struct witness_RegisterEx *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.context_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_witness_RegisterEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_witness_RegisterEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_RegisterEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_witness.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_witness_RegisterEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_RegisterEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_witness_RegisterEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_witness_RegisterEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_witness_RegisterEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_witness.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_RegisterEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_witness.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_witness_RegisterEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_RegisterEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_RegisterEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_witness_RegisterEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_witness_RegisterEx_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct witness_RegisterEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_witness.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_witness_RegisterEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_witness.calls[4];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_witness_RegisterEx_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_RegisterEx_ndr_print(py_obj, "witness_RegisterEx_in", NDR_IN);
}

static PyObject *py_witness_RegisterEx_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_witness_RegisterEx_ndr_print(py_obj, "witness_RegisterEx_out", NDR_OUT);
}

static PyMethodDef py_witness_RegisterEx_methods[] = {
	{ "opnum", (PyCFunction)py_witness_RegisterEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"witness.RegisterEx.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_RegisterEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_RegisterEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_RegisterEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_witness_RegisterEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_witness_RegisterEx_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_witness_RegisterEx_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject witness_RegisterEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.RegisterEx",
	.tp_getset = py_witness_RegisterEx_getsetters,
	.tp_methods = py_witness_RegisterEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_witness_RegisterEx_new,
};

static bool pack_py_witness_RegisterEx_args_in(PyObject *args, PyObject *kwargs, struct witness_RegisterEx *r)
{
	PyObject *py_version;
	PyObject *py_net_name;
	PyObject *py_share_name;
	PyObject *py_ip_address;
	PyObject *py_client_computer_name;
	PyObject *py_flags;
	PyObject *py_timeout;
	const char *kwnames[] = {
		"version", "net_name", "share_name", "ip_address", "client_computer_name", "flags", "timeout", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:witness_RegisterEx", discard_const_p(char *, kwnames), &py_version, &py_net_name, &py_share_name, &py_ip_address, &py_client_computer_name, &py_flags, &py_timeout)) {
		return false;
	}

	if (py_version == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.version");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.version));
		if (PyLong_Check(py_version)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_version);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_net_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.net_name");
		return false;
	}
	if (py_net_name == Py_None) {
		r->in.net_name = NULL;
	} else {
		r->in.net_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_net_name)) {
				unicode = PyUnicode_AsEncodedString(py_net_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_net_name)) {
				test_str = PyBytes_AS_STRING(py_net_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_net_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.net_name = talloc_str;
		}
	}
	if (py_share_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.share_name");
		return false;
	}
	if (py_share_name == Py_None) {
		r->in.share_name = NULL;
	} else {
		r->in.share_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_share_name)) {
				unicode = PyUnicode_AsEncodedString(py_share_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_share_name)) {
				test_str = PyBytes_AS_STRING(py_share_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_share_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.share_name = talloc_str;
		}
	}
	if (py_ip_address == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ip_address");
		return false;
	}
	if (py_ip_address == Py_None) {
		r->in.ip_address = NULL;
	} else {
		r->in.ip_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_ip_address)) {
				unicode = PyUnicode_AsEncodedString(py_ip_address, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_ip_address)) {
				test_str = PyBytes_AS_STRING(py_ip_address);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ip_address)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.ip_address = talloc_str;
		}
	}
	if (py_client_computer_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.client_computer_name");
		return false;
	}
	if (py_client_computer_name == Py_None) {
		r->in.client_computer_name = NULL;
	} else {
		r->in.client_computer_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_client_computer_name)) {
				unicode = PyUnicode_AsEncodedString(py_client_computer_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_client_computer_name)) {
				test_str = PyBytes_AS_STRING(py_client_computer_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_computer_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.client_computer_name = talloc_str;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_timeout == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.timeout");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.timeout));
		if (PyLong_Check(py_timeout)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_timeout);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_witness_RegisterEx_args_out(struct witness_RegisterEx *r)
{
	PyObject *result;
	PyObject *py_context_handle;
	py_context_handle = pytalloc_reference_ex(policy_handle_Type, r->out.context_handle, r->out.context_handle);
	result = py_context_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_witness_methods[] = {
	{ "GetInterfaceList", "S.GetInterfaceList() -> interface_list", (py_dcerpc_call_fn)dcerpc_witness_GetInterfaceList_r, (py_data_pack_fn)pack_py_witness_GetInterfaceList_args_in, (py_data_unpack_fn)unpack_py_witness_GetInterfaceList_args_out, 0, &ndr_table_witness },
	{ "Register", "S.Register(version, net_name, ip_address, client_computer_name) -> context_handle", (py_dcerpc_call_fn)dcerpc_witness_Register_r, (py_data_pack_fn)pack_py_witness_Register_args_in, (py_data_unpack_fn)unpack_py_witness_Register_args_out, 1, &ndr_table_witness },
	{ "UnRegister", "S.UnRegister(context_handle) -> None", (py_dcerpc_call_fn)dcerpc_witness_UnRegister_r, (py_data_pack_fn)pack_py_witness_UnRegister_args_in, (py_data_unpack_fn)unpack_py_witness_UnRegister_args_out, 2, &ndr_table_witness },
	{ "AsyncNotify", "S.AsyncNotify(context_handle) -> response", (py_dcerpc_call_fn)dcerpc_witness_AsyncNotify_r, (py_data_pack_fn)pack_py_witness_AsyncNotify_args_in, (py_data_unpack_fn)unpack_py_witness_AsyncNotify_args_out, 3, &ndr_table_witness },
	{ "RegisterEx", "S.RegisterEx(version, net_name, share_name, ip_address, client_computer_name, flags, timeout) -> context_handle", (py_dcerpc_call_fn)dcerpc_witness_RegisterEx_r, (py_data_pack_fn)pack_py_witness_RegisterEx_args_in, (py_data_unpack_fn)unpack_py_witness_RegisterEx_args_out, 4, &ndr_table_witness },
	{0}
};

static PyObject *interface_witness_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_witness);
}

#define PY_DOC_WITNESS "SMB Witness Service"
static PyTypeObject witness_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.witness",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "witness(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_WITNESS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_witness_new,
};

static PyObject *syntax_witness_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_witness.syntax_id);
}

#define PY_DOC_WITNESS_SYNTAX "SMB Witness Service"
static PyTypeObject witness_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "witness.witness_abstract_syntax",
	.tp_doc = "witness_abstract_syntax()\n"PY_DOC_WITNESS_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_witness_new,
};

static PyMethodDef witness_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "witness",
	.m_doc = "witness DCE/RPC",
	.m_size = -1,
	.m_methods = witness_methods,
};
MODULE_INIT_FUNC(witness)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	witness_interfaceInfo_Type.tp_base = BaseObject_Type;
	witness_interfaceInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_interfaceList_Type.tp_base = BaseObject_Type;
	witness_interfaceList_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_ResourceChange_Type.tp_base = BaseObject_Type;
	witness_ResourceChange_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_IPaddrInfo_Type.tp_base = BaseObject_Type;
	witness_IPaddrInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_IPaddrInfoList_Type.tp_base = BaseObject_Type;
	witness_IPaddrInfoList_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_notifyResponse_message_Type.tp_base = BaseObject_Type;
	witness_notifyResponse_message_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_notifyResponse_Type.tp_base = BaseObject_Type;
	witness_notifyResponse_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_GetInterfaceList_Type.tp_base = BaseObject_Type;
	witness_GetInterfaceList_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_Register_Type.tp_base = BaseObject_Type;
	witness_Register_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_UnRegister_Type.tp_base = BaseObject_Type;
	witness_UnRegister_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_AsyncNotify_Type.tp_base = BaseObject_Type;
	witness_AsyncNotify_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_RegisterEx_Type.tp_base = BaseObject_Type;
	witness_RegisterEx_Type.tp_basicsize = pytalloc_BaseObject_size();

	witness_InterfaceType.tp_base = ClientConnection_Type;

	witness_SyntaxType.tp_base = ndr_syntax_id_Type;
	witness_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&witness_interfaceInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_interfaceList_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_ResourceChange_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_IPaddrInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_IPaddrInfoList_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_notifyResponse_message_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_notifyResponse_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_GetInterfaceList_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_Register_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_UnRegister_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_AsyncNotify_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_RegisterEx_Type) < 0)
		goto out;
	if (PyType_Ready(&witness_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&witness_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&witness_InterfaceType, py_ndr_witness_methods))
		return NULL;

#ifdef PY_INTERFACEINFO_PATCH
	PY_INTERFACEINFO_PATCH(&witness_interfaceInfo_Type);
#endif
#ifdef PY_INTERFACELIST_PATCH
	PY_INTERFACELIST_PATCH(&witness_interfaceList_Type);
#endif
#ifdef PY_RESOURCECHANGE_PATCH
	PY_RESOURCECHANGE_PATCH(&witness_ResourceChange_Type);
#endif
#ifdef PY_IPADDRINFO_PATCH
	PY_IPADDRINFO_PATCH(&witness_IPaddrInfo_Type);
#endif
#ifdef PY_IPADDRINFOLIST_PATCH
	PY_IPADDRINFOLIST_PATCH(&witness_IPaddrInfoList_Type);
#endif
#ifdef PY_NOTIFYRESPONSE_MESSAGE_PATCH
	PY_NOTIFYRESPONSE_MESSAGE_PATCH(&witness_notifyResponse_message_Type);
#endif
#ifdef PY_NOTIFYRESPONSE_PATCH
	PY_NOTIFYRESPONSE_PATCH(&witness_notifyResponse_Type);
#endif
#ifdef PY_GETINTERFACELIST_PATCH
	PY_GETINTERFACELIST_PATCH(&witness_GetInterfaceList_Type);
#endif
#ifdef PY_REGISTER_PATCH
	PY_REGISTER_PATCH(&witness_Register_Type);
#endif
#ifdef PY_UNREGISTER_PATCH
	PY_UNREGISTER_PATCH(&witness_UnRegister_Type);
#endif
#ifdef PY_ASYNCNOTIFY_PATCH
	PY_ASYNCNOTIFY_PATCH(&witness_AsyncNotify_Type);
#endif
#ifdef PY_REGISTEREX_PATCH
	PY_REGISTEREX_PATCH(&witness_RegisterEx_Type);
#endif
#ifdef PY_WITNESS_PATCH
	PY_WITNESS_PATCH(&witness_InterfaceType);
#endif
#ifdef PY_WITNESS_ABSTRACT_SYNTAX_PATCH
	PY_WITNESS_ABSTRACT_SYNTAX_PATCH(&witness_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&witness_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "WITNESS_V1", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_V1)));
	PyModule_AddObject(m, "WITNESS_V2", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_V2)));
	PyModule_AddObject(m, "WITNESS_UNSPECIFIED_VERSION", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_UNSPECIFIED_VERSION)));
	PyModule_AddObject(m, "WITNESS_STATE_UNKNOWN", PyLong_FromLong((uint16_t)(WITNESS_STATE_UNKNOWN)));
	PyModule_AddObject(m, "WITNESS_STATE_AVAILABLE", PyLong_FromLong((uint16_t)(WITNESS_STATE_AVAILABLE)));
	PyModule_AddObject(m, "WITNESS_STATE_UNAVAILABLE", PyLong_FromLong((uint16_t)(WITNESS_STATE_UNAVAILABLE)));
	PyModule_AddObject(m, "WITNESS_INFO_IPv4_VALID", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_INFO_IPv4_VALID)));
	PyModule_AddObject(m, "WITNESS_INFO_IPv6_VALID", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_INFO_IPv6_VALID)));
	PyModule_AddObject(m, "WITNESS_INFO_WITNESS_IF", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_INFO_WITNESS_IF)));
	PyModule_AddObject(m, "WITNESS_NOTIFY_RESOURCE_CHANGE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_NOTIFY_RESOURCE_CHANGE)));
	PyModule_AddObject(m, "WITNESS_NOTIFY_CLIENT_MOVE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_NOTIFY_CLIENT_MOVE)));
	PyModule_AddObject(m, "WITNESS_NOTIFY_SHARE_MOVE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_NOTIFY_SHARE_MOVE)));
	PyModule_AddObject(m, "WITNESS_NOTIFY_IP_CHANGE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_NOTIFY_IP_CHANGE)));
	PyModule_AddObject(m, "WITNESS_RESOURCE_STATE_UNKNOWN", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_RESOURCE_STATE_UNKNOWN)));
	PyModule_AddObject(m, "WITNESS_RESOURCE_STATE_AVAILABLE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_RESOURCE_STATE_AVAILABLE)));
	PyModule_AddObject(m, "WITNESS_RESOURCE_STATE_UNAVAILABLE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_RESOURCE_STATE_UNAVAILABLE)));
	PyModule_AddObject(m, "WITNESS_IPADDR_V4", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_IPADDR_V4)));
	PyModule_AddObject(m, "WITNESS_IPADDR_V6", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_IPADDR_V6)));
	PyModule_AddObject(m, "WITNESS_IPADDR_ONLINE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_IPADDR_ONLINE)));
	PyModule_AddObject(m, "WITNESS_IPADDR_OFFLINE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_IPADDR_OFFLINE)));
	PyModule_AddObject(m, "WITNESS_REGISTER_NONE", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_REGISTER_NONE)));
	PyModule_AddObject(m, "WITNESS_REGISTER_IP_NOTIFICATION", PyLong_FromUnsignedLongLong((uint32_t)(WITNESS_REGISTER_IP_NOTIFICATION)));
	Py_INCREF((PyObject *)(void *)&witness_interfaceInfo_Type);
	PyModule_AddObject(m, "interfaceInfo", (PyObject *)(void *)&witness_interfaceInfo_Type);
	Py_INCREF((PyObject *)(void *)&witness_interfaceList_Type);
	PyModule_AddObject(m, "interfaceList", (PyObject *)(void *)&witness_interfaceList_Type);
	Py_INCREF((PyObject *)(void *)&witness_ResourceChange_Type);
	PyModule_AddObject(m, "ResourceChange", (PyObject *)(void *)&witness_ResourceChange_Type);
	Py_INCREF((PyObject *)(void *)&witness_IPaddrInfo_Type);
	PyModule_AddObject(m, "IPaddrInfo", (PyObject *)(void *)&witness_IPaddrInfo_Type);
	Py_INCREF((PyObject *)(void *)&witness_IPaddrInfoList_Type);
	PyModule_AddObject(m, "IPaddrInfoList", (PyObject *)(void *)&witness_IPaddrInfoList_Type);
	Py_INCREF((PyObject *)(void *)&witness_notifyResponse_message_Type);
	PyModule_AddObject(m, "notifyResponse_message", (PyObject *)(void *)&witness_notifyResponse_message_Type);
	Py_INCREF((PyObject *)(void *)&witness_notifyResponse_Type);
	PyModule_AddObject(m, "notifyResponse", (PyObject *)(void *)&witness_notifyResponse_Type);
	Py_INCREF((PyObject *)(void *)&witness_GetInterfaceList_Type);
	PyModule_AddObject(m, "GetInterfaceList", (PyObject *)(void *)&witness_GetInterfaceList_Type);
	Py_INCREF((PyObject *)(void *)&witness_Register_Type);
	PyModule_AddObject(m, "Register", (PyObject *)(void *)&witness_Register_Type);
	Py_INCREF((PyObject *)(void *)&witness_UnRegister_Type);
	PyModule_AddObject(m, "UnRegister", (PyObject *)(void *)&witness_UnRegister_Type);
	Py_INCREF((PyObject *)(void *)&witness_AsyncNotify_Type);
	PyModule_AddObject(m, "AsyncNotify", (PyObject *)(void *)&witness_AsyncNotify_Type);
	Py_INCREF((PyObject *)(void *)&witness_RegisterEx_Type);
	PyModule_AddObject(m, "RegisterEx", (PyObject *)(void *)&witness_RegisterEx_Type);
	Py_INCREF((PyObject *)(void *)&witness_InterfaceType);
	PyModule_AddObject(m, "witness", (PyObject *)(void *)&witness_InterfaceType);
	Py_INCREF((PyObject *)(void *)&witness_SyntaxType);
	PyModule_AddObject(m, "witness_abstract_syntax", (PyObject *)(void *)&witness_SyntaxType);
	Py_INCREF((PyObject *)(void *)&witness_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&witness_SyntaxType);
#ifdef PY_MOD_WITNESS_PATCH
	PY_MOD_WITNESS_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
