
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_svcctl.h"
#include "bin/default/librpc/gen_ndr/ndr_svcctl_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
static PyTypeObject SERVICE_LOCK_STATUS_Type;
static PyTypeObject SERVICE_STATUS_Type;
static PyTypeObject SERVICE_STATUS_PROCESS_Type;
static PyTypeObject ENUM_SERVICE_STATUSW_Type;
static PyTypeObject ENUM_SERVICE_STATUSA_Type;
static PyTypeObject QUERY_SERVICE_CONFIG_Type;
static PyTypeObject svcctl_ArgumentString_Type;
static PyTypeObject SERVICE_DESCRIPTION_Type;
static PyTypeObject SC_ACTION_Type;
static PyTypeObject SERVICE_FAILURE_ACTIONSW_Type;
static PyTypeObject SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_Type;
static PyTypeObject SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_Type;
static PyTypeObject SC_RPC_NOTIFY_PARAMS_u_Type;
static PyTypeObject SC_RPC_NOTIFY_PARAMS_Type;
static PyTypeObject SC_RPC_NOTIFY_PARAMS_LIST_Type;
static PyTypeObject SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_Type;
static PyTypeObject SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_Type;
static PyTypeObject SC_RPC_SERVICE_CONTROL_IN_PARAMSA_Type;
static PyTypeObject SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_Type;
static PyTypeObject SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_Type;
static PyTypeObject SC_RPC_SERVICE_CONTROL_IN_PARAMSW_Type;
static PyTypeObject SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_Type;
static PyTypeObject SERVICE_DESCRIPTIONW_Type;
static PyTypeObject SERVICE_DELAYED_AUTO_START_INFO_Type;
static PyTypeObject SERVICE_FAILURE_ACTIONS_FLAG_Type;
static PyTypeObject SERVICE_SID_INFO_Type;
static PyTypeObject SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_Type;
static PyTypeObject SERVICE_PRESHUTDOWN_INFO_Type;
static PyTypeObject SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_Type;
static PyTypeObject SERVICE_TRIGGER_Type;
static PyTypeObject SERVICE_TRIGGER_INFO_Type;
static PyTypeObject SERVICE_PREFERRED_NODE_INFO_Type;
static PyTypeObject SC_RPC_CONFIG_INFOW_u_Type;
static PyTypeObject SC_RPC_CONFIG_INFOW_Type;
static PyTypeObject svcctl_InterfaceType;
static PyTypeObject svcctl_CloseServiceHandle_Type;
static PyTypeObject svcctl_ControlService_Type;
static PyTypeObject svcctl_DeleteService_Type;
static PyTypeObject svcctl_LockServiceDatabase_Type;
static PyTypeObject svcctl_QueryServiceObjectSecurity_Type;
static PyTypeObject svcctl_SetServiceObjectSecurity_Type;
static PyTypeObject svcctl_QueryServiceStatus_Type;
static PyTypeObject svcctl_UnlockServiceDatabase_Type;
static PyTypeObject svcctl_SCSetServiceBitsW_Type;
static PyTypeObject svcctl_ChangeServiceConfigW_Type;
static PyTypeObject svcctl_CreateServiceW_Type;
static PyTypeObject svcctl_EnumDependentServicesW_Type;
static PyTypeObject svcctl_EnumServicesStatusW_Type;
static PyTypeObject svcctl_OpenSCManagerW_Type;
static PyTypeObject svcctl_OpenServiceW_Type;
static PyTypeObject svcctl_QueryServiceConfigW_Type;
static PyTypeObject svcctl_QueryServiceLockStatusW_Type;
static PyTypeObject svcctl_StartServiceW_Type;
static PyTypeObject svcctl_GetServiceDisplayNameW_Type;
static PyTypeObject svcctl_GetServiceKeyNameW_Type;
static PyTypeObject svcctl_SCSetServiceBitsA_Type;
static PyTypeObject svcctl_ChangeServiceConfigA_Type;
static PyTypeObject svcctl_CreateServiceA_Type;
static PyTypeObject svcctl_EnumDependentServicesA_Type;
static PyTypeObject svcctl_EnumServicesStatusA_Type;
static PyTypeObject svcctl_OpenSCManagerA_Type;
static PyTypeObject svcctl_OpenServiceA_Type;
static PyTypeObject svcctl_QueryServiceConfigA_Type;
static PyTypeObject svcctl_QueryServiceLockStatusA_Type;
static PyTypeObject svcctl_StartServiceA_Type;
static PyTypeObject svcctl_GetServiceDisplayNameA_Type;
static PyTypeObject svcctl_GetServiceKeyNameA_Type;
static PyTypeObject svcctl_ChangeServiceConfig2A_Type;
static PyTypeObject svcctl_ChangeServiceConfig2W_Type;
static PyTypeObject svcctl_QueryServiceConfig2A_Type;
static PyTypeObject svcctl_QueryServiceConfig2W_Type;
static PyTypeObject svcctl_QueryServiceStatusEx_Type;
static PyTypeObject svcctl_EnumServicesStatusExA_Type;
static PyTypeObject svcctl_EnumServicesStatusExW_Type;
static PyTypeObject svcctl_CreateServiceWOW64A_Type;
static PyTypeObject svcctl_CreateServiceWOW64W_Type;
static PyTypeObject Opnum46NotUsedOnWire_Type;
static PyTypeObject svcctl_NotifyServiceStatusChange_Type;
static PyTypeObject svcctl_GetNotifyResults_Type;
static PyTypeObject svcctl_CloseNotifyHandle_Type;
static PyTypeObject svcctl_ControlServiceExA_Type;
static PyTypeObject svcctl_ControlServiceExW_Type;
static PyTypeObject Opnum52NotUsedOnWire_Type;
static PyTypeObject Opnum53NotUsedOnWire_Type;
static PyTypeObject Opnum54NotUsedOnWire_Type;
static PyTypeObject Opnum55NotUsedOnWire_Type;
static PyTypeObject svcctl_QueryServiceConfigEx_Type;
static PyTypeObject Opnum57NotUsedOnWire_Type;
static PyTypeObject Opnum58NotUsedOnWire_Type;
static PyTypeObject Opnum59NotUsedOnWire_Type;
static PyTypeObject svcctl_CreateWowService_Type;
static PyTypeObject svcctl_OpenSCManager2_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_SERVICE_LOCK_STATUS_get_is_locked(PyObject *obj, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_is_locked;
	py_is_locked = PyLong_FromUnsignedLongLong((uint32_t)(object->is_locked));
	return py_is_locked;
}

static int py_SERVICE_LOCK_STATUS_set_is_locked(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->is_locked");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_locked));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_locked = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_LOCK_STATUS_get_lock_owner(PyObject *obj, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_owner;
	if (object->lock_owner == NULL) {
		Py_RETURN_NONE;
	}
	if (object->lock_owner == NULL) {
		py_lock_owner = Py_None;
		Py_INCREF(py_lock_owner);
	} else {
		if (object->lock_owner == NULL) {
			py_lock_owner = Py_None;
			Py_INCREF(py_lock_owner);
		} else {
			py_lock_owner = PyUnicode_Decode(object->lock_owner, strlen(object->lock_owner), "utf-8", "ignore");
		}
	}
	return py_lock_owner;
}

static int py_SERVICE_LOCK_STATUS_set_lock_owner(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_owner");
		return -1;
	}
	if (value == Py_None) {
		object->lock_owner = NULL;
	} else {
		object->lock_owner = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->lock_owner = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_LOCK_STATUS_get_lock_duration(PyObject *obj, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_duration;
	py_lock_duration = PyLong_FromUnsignedLongLong((uint32_t)(object->lock_duration));
	return py_lock_duration;
}

static int py_SERVICE_LOCK_STATUS_set_lock_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lock_duration");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lock_duration));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lock_duration = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_LOCK_STATUS_getsetters[] = {
	{
		.name = discard_const_p(char, "is_locked"),
		.get = py_SERVICE_LOCK_STATUS_get_is_locked,
		.set = py_SERVICE_LOCK_STATUS_set_is_locked,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lock_owner"),
		.get = py_SERVICE_LOCK_STATUS_get_lock_owner,
		.set = py_SERVICE_LOCK_STATUS_set_lock_owner,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lock_duration"),
		.get = py_SERVICE_LOCK_STATUS_get_lock_duration,
		.set = py_SERVICE_LOCK_STATUS_set_lock_duration,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_LOCK_STATUS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_LOCK_STATUS, type);
}


static PyTypeObject SERVICE_LOCK_STATUS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_LOCK_STATUS",
	.tp_getset = py_SERVICE_LOCK_STATUS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_LOCK_STATUS_new,
};


static PyObject *py_SERVICE_STATUS_get_type(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_SERVICE_STATUS_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_state(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_state;
	py_state = PyLong_FromUnsignedLongLong((uint32_t)(object->state));
	return py_state;
}

static int py_SERVICE_STATUS_set_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_controls_accepted(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_controls_accepted;
	py_controls_accepted = PyLong_FromUnsignedLongLong((uint32_t)(object->controls_accepted));
	return py_controls_accepted;
}

static int py_SERVICE_STATUS_set_controls_accepted(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->controls_accepted");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->controls_accepted));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->controls_accepted = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_win32_exit_code(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_win32_exit_code;
	py_win32_exit_code = PyErr_FromWERROR(object->win32_exit_code);
	return py_win32_exit_code;
}

static int py_SERVICE_STATUS_set_win32_exit_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->win32_exit_code");
		return -1;
	}
	object->win32_exit_code = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_service_exit_code(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_service_exit_code;
	py_service_exit_code = PyLong_FromUnsignedLongLong((uint32_t)(object->service_exit_code));
	return py_service_exit_code;
}

static int py_SERVICE_STATUS_set_service_exit_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->service_exit_code");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->service_exit_code));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->service_exit_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_check_point(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_check_point;
	py_check_point = PyLong_FromUnsignedLongLong((uint32_t)(object->check_point));
	return py_check_point;
}

static int py_SERVICE_STATUS_set_check_point(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->check_point");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->check_point));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->check_point = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_wait_hint(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(obj);
	PyObject *py_wait_hint;
	py_wait_hint = PyLong_FromUnsignedLongLong((uint32_t)(object->wait_hint));
	return py_wait_hint;
}

static int py_SERVICE_STATUS_set_wait_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wait_hint");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wait_hint));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wait_hint = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_STATUS_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_SERVICE_STATUS_get_type,
		.set = py_SERVICE_STATUS_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "state"),
		.get = py_SERVICE_STATUS_get_state,
		.set = py_SERVICE_STATUS_set_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServiceStatus")
	},
	{
		.name = discard_const_p(char, "controls_accepted"),
		.get = py_SERVICE_STATUS_get_controls_accepted,
		.set = py_SERVICE_STATUS_set_controls_accepted,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ControlsAccepted")
	},
	{
		.name = discard_const_p(char, "win32_exit_code"),
		.get = py_SERVICE_STATUS_get_win32_exit_code,
		.set = py_SERVICE_STATUS_set_win32_exit_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "service_exit_code"),
		.get = py_SERVICE_STATUS_get_service_exit_code,
		.set = py_SERVICE_STATUS_set_service_exit_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "check_point"),
		.get = py_SERVICE_STATUS_get_check_point,
		.set = py_SERVICE_STATUS_set_check_point,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "wait_hint"),
		.get = py_SERVICE_STATUS_get_wait_hint,
		.set = py_SERVICE_STATUS_set_wait_hint,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_STATUS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_STATUS, type);
}


static PyTypeObject SERVICE_STATUS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_STATUS",
	.tp_getset = py_SERVICE_STATUS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_STATUS_new,
};


static PyObject *py_SERVICE_STATUS_PROCESS_get_status(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = pytalloc_reference_ex(&SERVICE_STATUS_Type, pytalloc_get_mem_ctx(obj), &object->status);
	return py_status;
}

static int py_SERVICE_STATUS_PROCESS_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->status");
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->status = *(struct SERVICE_STATUS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_SERVICE_STATUS_PROCESS_get_process_id(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(obj);
	PyObject *py_process_id;
	py_process_id = PyLong_FromUnsignedLongLong((uint32_t)(object->process_id));
	return py_process_id;
}

static int py_SERVICE_STATUS_PROCESS_set_process_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->process_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->process_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->process_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_STATUS_PROCESS_get_service_flags(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(obj);
	PyObject *py_service_flags;
	py_service_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->service_flags));
	return py_service_flags;
}

static int py_SERVICE_STATUS_PROCESS_set_service_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->service_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->service_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->service_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_STATUS_PROCESS_getsetters[] = {
	{
		.name = discard_const_p(char, "status"),
		.get = py_SERVICE_STATUS_PROCESS_get_status,
		.set = py_SERVICE_STATUS_PROCESS_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS")
	},
	{
		.name = discard_const_p(char, "process_id"),
		.get = py_SERVICE_STATUS_PROCESS_get_process_id,
		.set = py_SERVICE_STATUS_PROCESS_set_process_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "service_flags"),
		.get = py_SERVICE_STATUS_PROCESS_get_service_flags,
		.set = py_SERVICE_STATUS_PROCESS_set_service_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_STATUS_PROCESS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_STATUS_PROCESS, type);
}

static PyObject *py_SERVICE_STATUS_PROCESS_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_SERVICE_STATUS_PROCESS);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_SERVICE_STATUS_PROCESS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_STATUS_PROCESS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_STATUS_PROCESS);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_SERVICE_STATUS_PROCESS_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct SERVICE_STATUS_PROCESS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_SERVICE_STATUS_PROCESS, "SERVICE_STATUS_PROCESS", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_SERVICE_STATUS_PROCESS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_SERVICE_STATUS_PROCESS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SERVICE_STATUS_PROCESS_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_SERVICE_STATUS_PROCESS_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject SERVICE_STATUS_PROCESS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_STATUS_PROCESS",
	.tp_getset = py_SERVICE_STATUS_PROCESS_getsetters,
	.tp_methods = py_SERVICE_STATUS_PROCESS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_STATUS_PROCESS_new,
};


static PyObject *py_ENUM_SERVICE_STATUSW_get_service_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(obj);
	PyObject *py_service_name;
	if (object->service_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->service_name == NULL) {
		py_service_name = Py_None;
		Py_INCREF(py_service_name);
	} else {
		py_service_name = PyString_FromStringOrNULL(object->service_name);
	}
	return py_service_name;
}

static int py_ENUM_SERVICE_STATUSW_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->service_name");
		return -1;
	}
	if (value == Py_None) {
		object->service_name = NULL;
	} else {
		object->service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->service_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSW_get_display_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name;
	if (object->display_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		py_display_name = PyString_FromStringOrNULL(object->display_name);
	}
	return py_display_name;
}

static int py_ENUM_SERVICE_STATUSW_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->display_name");
		return -1;
	}
	if (value == Py_None) {
		object->display_name = NULL;
	} else {
		object->display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->display_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSW_get_status(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = pytalloc_reference_ex(&SERVICE_STATUS_Type, pytalloc_get_mem_ctx(obj), &object->status);
	return py_status;
}

static int py_ENUM_SERVICE_STATUSW_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->status");
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->status = *(struct SERVICE_STATUS *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_ENUM_SERVICE_STATUSW_getsetters[] = {
	{
		.name = discard_const_p(char, "service_name"),
		.get = py_ENUM_SERVICE_STATUSW_get_service_name,
		.set = py_ENUM_SERVICE_STATUSW_set_service_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "display_name"),
		.get = py_ENUM_SERVICE_STATUSW_get_display_name,
		.set = py_ENUM_SERVICE_STATUSW_set_display_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_ENUM_SERVICE_STATUSW_get_status,
		.set = py_ENUM_SERVICE_STATUSW_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS")
	},
	{ .name = NULL }
};

static PyObject *py_ENUM_SERVICE_STATUSW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ENUM_SERVICE_STATUSW, type);
}

static PyObject *py_ENUM_SERVICE_STATUSW_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ENUM_SERVICE_STATUSW);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ENUM_SERVICE_STATUSW_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ENUM_SERVICE_STATUSW);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ENUM_SERVICE_STATUSW);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ENUM_SERVICE_STATUSW_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct ENUM_SERVICE_STATUSW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ENUM_SERVICE_STATUSW, "ENUM_SERVICE_STATUSW", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ENUM_SERVICE_STATUSW_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ENUM_SERVICE_STATUSW_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ENUM_SERVICE_STATUSW_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ENUM_SERVICE_STATUSW_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ENUM_SERVICE_STATUSW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.ENUM_SERVICE_STATUSW",
	.tp_getset = py_ENUM_SERVICE_STATUSW_getsetters,
	.tp_methods = py_ENUM_SERVICE_STATUSW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ENUM_SERVICE_STATUSW_new,
};


static PyObject *py_ENUM_SERVICE_STATUSA_get_service_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(obj);
	PyObject *py_service_name;
	if (object->service_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->service_name == NULL) {
		py_service_name = Py_None;
		Py_INCREF(py_service_name);
	} else {
		py_service_name = PyString_FromStringOrNULL(object->service_name);
	}
	return py_service_name;
}

static int py_ENUM_SERVICE_STATUSA_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->service_name");
		return -1;
	}
	if (value == Py_None) {
		object->service_name = NULL;
	} else {
		object->service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->service_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSA_get_display_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name;
	if (object->display_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		py_display_name = PyString_FromStringOrNULL(object->display_name);
	}
	return py_display_name;
}

static int py_ENUM_SERVICE_STATUSA_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->display_name");
		return -1;
	}
	if (value == Py_None) {
		object->display_name = NULL;
	} else {
		object->display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->display_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSA_get_status(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = pytalloc_reference_ex(&SERVICE_STATUS_Type, pytalloc_get_mem_ctx(obj), &object->status);
	return py_status;
}

static int py_ENUM_SERVICE_STATUSA_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->status");
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->status = *(struct SERVICE_STATUS *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_ENUM_SERVICE_STATUSA_getsetters[] = {
	{
		.name = discard_const_p(char, "service_name"),
		.get = py_ENUM_SERVICE_STATUSA_get_service_name,
		.set = py_ENUM_SERVICE_STATUSA_set_service_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "display_name"),
		.get = py_ENUM_SERVICE_STATUSA_get_display_name,
		.set = py_ENUM_SERVICE_STATUSA_set_display_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_ENUM_SERVICE_STATUSA_get_status,
		.set = py_ENUM_SERVICE_STATUSA_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS")
	},
	{ .name = NULL }
};

static PyObject *py_ENUM_SERVICE_STATUSA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ENUM_SERVICE_STATUSA, type);
}

static PyObject *py_ENUM_SERVICE_STATUSA_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ENUM_SERVICE_STATUSA);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ENUM_SERVICE_STATUSA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ENUM_SERVICE_STATUSA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ENUM_SERVICE_STATUSA);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ENUM_SERVICE_STATUSA_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct ENUM_SERVICE_STATUSA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ENUM_SERVICE_STATUSA, "ENUM_SERVICE_STATUSA", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ENUM_SERVICE_STATUSA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ENUM_SERVICE_STATUSA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ENUM_SERVICE_STATUSA_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ENUM_SERVICE_STATUSA_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ENUM_SERVICE_STATUSA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.ENUM_SERVICE_STATUSA",
	.tp_getset = py_ENUM_SERVICE_STATUSA_getsetters,
	.tp_methods = py_ENUM_SERVICE_STATUSA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ENUM_SERVICE_STATUSA_new,
};


static PyObject *py_QUERY_SERVICE_CONFIG_get_service_type(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_service_type;
	py_service_type = PyLong_FromUnsignedLongLong((uint32_t)(object->service_type));
	return py_service_type;
}

static int py_QUERY_SERVICE_CONFIG_set_service_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->service_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->service_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->service_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_start_type(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_start_type;
	py_start_type = PyLong_FromUnsignedLongLong((uint32_t)(object->start_type));
	return py_start_type;
}

static int py_QUERY_SERVICE_CONFIG_set_start_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->start_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->start_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_error_control(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_error_control;
	py_error_control = PyLong_FromUnsignedLongLong((uint32_t)(object->error_control));
	return py_error_control;
}

static int py_QUERY_SERVICE_CONFIG_set_error_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->error_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->error_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_executablepath(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_executablepath;
	if (object->executablepath == NULL) {
		Py_RETURN_NONE;
	}
	if (object->executablepath == NULL) {
		py_executablepath = Py_None;
		Py_INCREF(py_executablepath);
	} else {
		if (object->executablepath == NULL) {
			py_executablepath = Py_None;
			Py_INCREF(py_executablepath);
		} else {
			py_executablepath = PyUnicode_Decode(object->executablepath, strlen(object->executablepath), "utf-8", "ignore");
		}
	}
	return py_executablepath;
}

static int py_QUERY_SERVICE_CONFIG_set_executablepath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->executablepath");
		return -1;
	}
	if (value == Py_None) {
		object->executablepath = NULL;
	} else {
		object->executablepath = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->executablepath = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_loadordergroup(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_loadordergroup;
	if (object->loadordergroup == NULL) {
		Py_RETURN_NONE;
	}
	if (object->loadordergroup == NULL) {
		py_loadordergroup = Py_None;
		Py_INCREF(py_loadordergroup);
	} else {
		if (object->loadordergroup == NULL) {
			py_loadordergroup = Py_None;
			Py_INCREF(py_loadordergroup);
		} else {
			py_loadordergroup = PyUnicode_Decode(object->loadordergroup, strlen(object->loadordergroup), "utf-8", "ignore");
		}
	}
	return py_loadordergroup;
}

static int py_QUERY_SERVICE_CONFIG_set_loadordergroup(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->loadordergroup");
		return -1;
	}
	if (value == Py_None) {
		object->loadordergroup = NULL;
	} else {
		object->loadordergroup = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->loadordergroup = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_tag_id(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_tag_id;
	py_tag_id = PyLong_FromUnsignedLongLong((uint32_t)(object->tag_id));
	return py_tag_id;
}

static int py_QUERY_SERVICE_CONFIG_set_tag_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->tag_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tag_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tag_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_dependencies(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_dependencies;
	if (object->dependencies == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dependencies == NULL) {
		py_dependencies = Py_None;
		Py_INCREF(py_dependencies);
	} else {
		if (object->dependencies == NULL) {
			py_dependencies = Py_None;
			Py_INCREF(py_dependencies);
		} else {
			py_dependencies = PyUnicode_Decode(object->dependencies, strlen(object->dependencies), "utf-8", "ignore");
		}
	}
	return py_dependencies;
}

static int py_QUERY_SERVICE_CONFIG_set_dependencies(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dependencies");
		return -1;
	}
	if (value == Py_None) {
		object->dependencies = NULL;
	} else {
		object->dependencies = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dependencies = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_startname(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_startname;
	if (object->startname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->startname == NULL) {
		py_startname = Py_None;
		Py_INCREF(py_startname);
	} else {
		if (object->startname == NULL) {
			py_startname = Py_None;
			Py_INCREF(py_startname);
		} else {
			py_startname = PyUnicode_Decode(object->startname, strlen(object->startname), "utf-8", "ignore");
		}
	}
	return py_startname;
}

static int py_QUERY_SERVICE_CONFIG_set_startname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->startname");
		return -1;
	}
	if (value == Py_None) {
		object->startname = NULL;
	} else {
		object->startname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->startname = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_displayname(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(obj);
	PyObject *py_displayname;
	if (object->displayname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->displayname == NULL) {
		py_displayname = Py_None;
		Py_INCREF(py_displayname);
	} else {
		if (object->displayname == NULL) {
			py_displayname = Py_None;
			Py_INCREF(py_displayname);
		} else {
			py_displayname = PyUnicode_Decode(object->displayname, strlen(object->displayname), "utf-8", "ignore");
		}
	}
	return py_displayname;
}

static int py_QUERY_SERVICE_CONFIG_set_displayname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->displayname");
		return -1;
	}
	if (value == Py_None) {
		object->displayname = NULL;
	} else {
		object->displayname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->displayname = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_QUERY_SERVICE_CONFIG_getsetters[] = {
	{
		.name = discard_const_p(char, "service_type"),
		.get = py_QUERY_SERVICE_CONFIG_get_service_type,
		.set = py_QUERY_SERVICE_CONFIG_set_service_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "start_type"),
		.get = py_QUERY_SERVICE_CONFIG_get_start_type,
		.set = py_QUERY_SERVICE_CONFIG_set_start_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_StartType")
	},
	{
		.name = discard_const_p(char, "error_control"),
		.get = py_QUERY_SERVICE_CONFIG_get_error_control,
		.set = py_QUERY_SERVICE_CONFIG_set_error_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ErrorControl")
	},
	{
		.name = discard_const_p(char, "executablepath"),
		.get = py_QUERY_SERVICE_CONFIG_get_executablepath,
		.set = py_QUERY_SERVICE_CONFIG_set_executablepath,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "loadordergroup"),
		.get = py_QUERY_SERVICE_CONFIG_get_loadordergroup,
		.set = py_QUERY_SERVICE_CONFIG_set_loadordergroup,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "tag_id"),
		.get = py_QUERY_SERVICE_CONFIG_get_tag_id,
		.set = py_QUERY_SERVICE_CONFIG_set_tag_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dependencies"),
		.get = py_QUERY_SERVICE_CONFIG_get_dependencies,
		.set = py_QUERY_SERVICE_CONFIG_set_dependencies,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "startname"),
		.get = py_QUERY_SERVICE_CONFIG_get_startname,
		.set = py_QUERY_SERVICE_CONFIG_set_startname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "displayname"),
		.get = py_QUERY_SERVICE_CONFIG_get_displayname,
		.set = py_QUERY_SERVICE_CONFIG_set_displayname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_QUERY_SERVICE_CONFIG_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct QUERY_SERVICE_CONFIG, type);
}

static PyObject *py_QUERY_SERVICE_CONFIG_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_QUERY_SERVICE_CONFIG);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_QUERY_SERVICE_CONFIG_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_QUERY_SERVICE_CONFIG);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_QUERY_SERVICE_CONFIG);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_QUERY_SERVICE_CONFIG_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct QUERY_SERVICE_CONFIG *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_QUERY_SERVICE_CONFIG, "QUERY_SERVICE_CONFIG", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_QUERY_SERVICE_CONFIG_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_QUERY_SERVICE_CONFIG_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_QUERY_SERVICE_CONFIG_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_QUERY_SERVICE_CONFIG_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject QUERY_SERVICE_CONFIG_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.QUERY_SERVICE_CONFIG",
	.tp_getset = py_QUERY_SERVICE_CONFIG_getsetters,
	.tp_methods = py_QUERY_SERVICE_CONFIG_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_QUERY_SERVICE_CONFIG_new,
};


static PyObject *py_svcctl_ArgumentString_get_string(PyObject *obj, void *closure)
{
	struct svcctl_ArgumentString *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_svcctl_ArgumentString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ArgumentString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_svcctl_ArgumentString_getsetters[] = {
	{
		.name = discard_const_p(char, "string"),
		.get = py_svcctl_ArgumentString_get_string,
		.set = py_svcctl_ArgumentString_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_ArgumentString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct svcctl_ArgumentString, type);
}


static PyTypeObject svcctl_ArgumentString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.ArgumentString",
	.tp_getset = py_svcctl_ArgumentString_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_ArgumentString_new,
};


static PyObject *py_SERVICE_DESCRIPTION_get_description(PyObject *obj, void *closure)
{
	struct SERVICE_DESCRIPTION *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	if (object->description == NULL) {
		Py_RETURN_NONE;
	}
	if (object->description == NULL) {
		py_description = Py_None;
		Py_INCREF(py_description);
	} else {
		py_description = PyString_FromStringOrNULL(object->description);
	}
	return py_description;
}

static int py_SERVICE_DESCRIPTION_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_DESCRIPTION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->description");
		return -1;
	}
	if (value == Py_None) {
		object->description = NULL;
	} else {
		object->description = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->description = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_DESCRIPTION_getsetters[] = {
	{
		.name = discard_const_p(char, "description"),
		.get = py_SERVICE_DESCRIPTION_get_description,
		.set = py_SERVICE_DESCRIPTION_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_DESCRIPTION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_DESCRIPTION, type);
}

static PyObject *py_SERVICE_DESCRIPTION_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct SERVICE_DESCRIPTION *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_SERVICE_DESCRIPTION);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_SERVICE_DESCRIPTION_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct SERVICE_DESCRIPTION *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_DESCRIPTION);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_DESCRIPTION);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_SERVICE_DESCRIPTION_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct SERVICE_DESCRIPTION *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_SERVICE_DESCRIPTION, "SERVICE_DESCRIPTION", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_SERVICE_DESCRIPTION_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_SERVICE_DESCRIPTION_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SERVICE_DESCRIPTION_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_SERVICE_DESCRIPTION_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject SERVICE_DESCRIPTION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_DESCRIPTION",
	.tp_getset = py_SERVICE_DESCRIPTION_getsetters,
	.tp_methods = py_SERVICE_DESCRIPTION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_DESCRIPTION_new,
};


static PyObject *py_SC_ACTION_get_type(PyObject *obj, void *closure)
{
	struct SC_ACTION *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_SC_ACTION_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_ACTION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SC_ACTION_get_delay(PyObject *obj, void *closure)
{
	struct SC_ACTION *object = pytalloc_get_ptr(obj);
	PyObject *py_delay;
	py_delay = PyLong_FromUnsignedLongLong((uint32_t)(object->delay));
	return py_delay;
}

static int py_SC_ACTION_set_delay(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_ACTION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->delay");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->delay));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->delay = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SC_ACTION_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_SC_ACTION_get_type,
		.set = py_SC_ACTION_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type SC_ACTION_TYPE")
	},
	{
		.name = discard_const_p(char, "delay"),
		.get = py_SC_ACTION_get_delay,
		.set = py_SC_ACTION_set_delay,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SC_ACTION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SC_ACTION, type);
}


static PyTypeObject SC_ACTION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_ACTION",
	.tp_getset = py_SC_ACTION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_ACTION_new,
};


static PyObject *py_SERVICE_FAILURE_ACTIONSW_get_reset_period(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(obj);
	PyObject *py_reset_period;
	py_reset_period = PyLong_FromUnsignedLongLong((uint32_t)(object->reset_period));
	return py_reset_period;
}

static int py_SERVICE_FAILURE_ACTIONSW_set_reset_period(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reset_period");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reset_period));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reset_period = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONSW_get_rebootmsg(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(obj);
	PyObject *py_rebootmsg;
	if (object->rebootmsg == NULL) {
		Py_RETURN_NONE;
	}
	if (object->rebootmsg == NULL) {
		py_rebootmsg = Py_None;
		Py_INCREF(py_rebootmsg);
	} else {
		py_rebootmsg = PyString_FromStringOrNULL(object->rebootmsg);
	}
	return py_rebootmsg;
}

static int py_SERVICE_FAILURE_ACTIONSW_set_rebootmsg(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rebootmsg");
		return -1;
	}
	if (value == Py_None) {
		object->rebootmsg = NULL;
	} else {
		object->rebootmsg = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->rebootmsg = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONSW_get_command(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	if (object->command == NULL) {
		Py_RETURN_NONE;
	}
	if (object->command == NULL) {
		py_command = Py_None;
		Py_INCREF(py_command);
	} else {
		py_command = PyString_FromStringOrNULL(object->command);
	}
	return py_command;
}

static int py_SERVICE_FAILURE_ACTIONSW_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->command");
		return -1;
	}
	if (value == Py_None) {
		object->command = NULL;
	} else {
		object->command = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->command = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONSW_get_num_actions(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(obj);
	PyObject *py_num_actions;
	py_num_actions = PyLong_FromUnsignedLongLong((uint32_t)(object->num_actions));
	return py_num_actions;
}

static int py_SERVICE_FAILURE_ACTIONSW_set_num_actions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_actions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_actions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_actions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONSW_get_actions(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(obj);
	PyObject *py_actions;
	if (object->actions == NULL) {
		Py_RETURN_NONE;
	}
	if (object->actions == NULL) {
		py_actions = Py_None;
		Py_INCREF(py_actions);
	} else {
		py_actions = PyList_New(object->num_actions);
		if (py_actions == NULL) {
			return NULL;
		}
		{
			int actions_cntr_1;
			for (actions_cntr_1 = 0; actions_cntr_1 < (object->num_actions); actions_cntr_1++) {
				PyObject *py_actions_1;
				py_actions_1 = pytalloc_reference_ex(&SC_ACTION_Type, object->actions, &(object->actions)[actions_cntr_1]);
				PyList_SetItem(py_actions, actions_cntr_1, py_actions_1);
			}
		}
	}
	return py_actions;
}

static int py_SERVICE_FAILURE_ACTIONSW_set_actions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->actions));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->actions");
		return -1;
	}
	if (value == Py_None) {
		object->actions = NULL;
	} else {
		object->actions = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int actions_cntr_1;
			object->actions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->actions, PyList_GET_SIZE(value));
			if (!object->actions) { return -1; }
			talloc_set_name_const(object->actions, "ARRAY: object->actions");
			for (actions_cntr_1 = 0; actions_cntr_1 < PyList_GET_SIZE(value); actions_cntr_1++) {
				if (PyList_GET_ITEM(value, actions_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->actions)[actions_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&SC_ACTION_Type, PyList_GET_ITEM(value, actions_cntr_1), return -1;);
				if (talloc_reference(object->actions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, actions_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->actions)[actions_cntr_1] = *(struct SC_ACTION *)pytalloc_get_ptr(PyList_GET_ITEM(value, actions_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_FAILURE_ACTIONSW_getsetters[] = {
	{
		.name = discard_const_p(char, "reset_period"),
		.get = py_SERVICE_FAILURE_ACTIONSW_get_reset_period,
		.set = py_SERVICE_FAILURE_ACTIONSW_set_reset_period,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rebootmsg"),
		.get = py_SERVICE_FAILURE_ACTIONSW_get_rebootmsg,
		.set = py_SERVICE_FAILURE_ACTIONSW_set_rebootmsg,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "command"),
		.get = py_SERVICE_FAILURE_ACTIONSW_get_command,
		.set = py_SERVICE_FAILURE_ACTIONSW_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "num_actions"),
		.get = py_SERVICE_FAILURE_ACTIONSW_get_num_actions,
		.set = py_SERVICE_FAILURE_ACTIONSW_set_num_actions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "actions"),
		.get = py_SERVICE_FAILURE_ACTIONSW_get_actions,
		.set = py_SERVICE_FAILURE_ACTIONSW_set_actions,
		.doc = discard_const_p(char, "PIDL-generated element of base type SC_ACTION")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_FAILURE_ACTIONSW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_FAILURE_ACTIONSW, type);
}

static PyObject *py_SERVICE_FAILURE_ACTIONSW_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_SERVICE_FAILURE_ACTIONSW);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_SERVICE_FAILURE_ACTIONSW_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_FAILURE_ACTIONSW);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_FAILURE_ACTIONSW);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_SERVICE_FAILURE_ACTIONSW_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct SERVICE_FAILURE_ACTIONSW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_SERVICE_FAILURE_ACTIONSW, "SERVICE_FAILURE_ACTIONSW", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_SERVICE_FAILURE_ACTIONSW_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_SERVICE_FAILURE_ACTIONSW_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SERVICE_FAILURE_ACTIONSW_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_SERVICE_FAILURE_ACTIONSW_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject SERVICE_FAILURE_ACTIONSW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_FAILURE_ACTIONSW",
	.tp_getset = py_SERVICE_FAILURE_ACTIONSW_getsetters,
	.tp_methods = py_SERVICE_FAILURE_ACTIONSW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_FAILURE_ACTIONSW_new,
};


static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_ullThreadId(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_ullThreadId;
	py_ullThreadId = PyLong_FromUnsignedLongLong(object->ullThreadId);
	return py_ullThreadId;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_ullThreadId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ullThreadId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ullThreadId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ullThreadId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_dwNotifyMask(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNotifyMask;
	py_dwNotifyMask = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNotifyMask));
	return py_dwNotifyMask;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_dwNotifyMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwNotifyMask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNotifyMask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNotifyMask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_CallbackAddressArray(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_CallbackAddressArray;
	py_CallbackAddressArray = PyList_New(16);
	if (py_CallbackAddressArray == NULL) {
		return NULL;
	}
	{
		int CallbackAddressArray_cntr_0;
		for (CallbackAddressArray_cntr_0 = 0; CallbackAddressArray_cntr_0 < (16); CallbackAddressArray_cntr_0++) {
			PyObject *py_CallbackAddressArray_0;
			py_CallbackAddressArray_0 = PyLong_FromLong((uint16_t)((object->CallbackAddressArray)[CallbackAddressArray_cntr_0]));
			PyList_SetItem(py_CallbackAddressArray, CallbackAddressArray_cntr_0, py_CallbackAddressArray_0);
		}
	}
	return py_CallbackAddressArray;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_CallbackAddressArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->CallbackAddressArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int CallbackAddressArray_cntr_0;
		if (ARRAY_SIZE(object->CallbackAddressArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->CallbackAddressArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (CallbackAddressArray_cntr_0 = 0; CallbackAddressArray_cntr_0 < PyList_GET_SIZE(value); CallbackAddressArray_cntr_0++) {
			if (PyList_GET_ITEM(value, CallbackAddressArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->CallbackAddressArray)[CallbackAddressArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->CallbackAddressArray)[CallbackAddressArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, CallbackAddressArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, CallbackAddressArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->CallbackAddressArray)[CallbackAddressArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_CallbackParamAddressArray(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_CallbackParamAddressArray;
	py_CallbackParamAddressArray = PyList_New(16);
	if (py_CallbackParamAddressArray == NULL) {
		return NULL;
	}
	{
		int CallbackParamAddressArray_cntr_0;
		for (CallbackParamAddressArray_cntr_0 = 0; CallbackParamAddressArray_cntr_0 < (16); CallbackParamAddressArray_cntr_0++) {
			PyObject *py_CallbackParamAddressArray_0;
			py_CallbackParamAddressArray_0 = PyLong_FromLong((uint16_t)((object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0]));
			PyList_SetItem(py_CallbackParamAddressArray, CallbackParamAddressArray_cntr_0, py_CallbackParamAddressArray_0);
		}
	}
	return py_CallbackParamAddressArray;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_CallbackParamAddressArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->CallbackParamAddressArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int CallbackParamAddressArray_cntr_0;
		if (ARRAY_SIZE(object->CallbackParamAddressArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->CallbackParamAddressArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (CallbackParamAddressArray_cntr_0 = 0; CallbackParamAddressArray_cntr_0 < PyList_GET_SIZE(value); CallbackParamAddressArray_cntr_0++) {
			if (PyList_GET_ITEM(value, CallbackParamAddressArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, CallbackParamAddressArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, CallbackParamAddressArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_ServiceStatus(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_ServiceStatus;
	py_ServiceStatus = pytalloc_reference_ex(&SERVICE_STATUS_PROCESS_Type, pytalloc_get_mem_ctx(obj), &object->ServiceStatus);
	return py_ServiceStatus;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_ServiceStatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ServiceStatus");
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_PROCESS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ServiceStatus = *(struct SERVICE_STATUS_PROCESS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_dwNotificationStatus(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNotificationStatus;
	py_dwNotificationStatus = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNotificationStatus));
	return py_dwNotificationStatus;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_dwNotificationStatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwNotificationStatus");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNotificationStatus));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNotificationStatus = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_dwSequence(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_dwSequence;
	py_dwSequence = PyLong_FromUnsignedLongLong((uint32_t)(object->dwSequence));
	return py_dwSequence;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_dwSequence(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwSequence");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwSequence));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwSequence = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_getsetters[] = {
	{
		.name = discard_const_p(char, "ullThreadId"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_ullThreadId,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_ullThreadId,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "dwNotifyMask"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_dwNotifyMask,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_dwNotifyMask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "CallbackAddressArray"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_CallbackAddressArray,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_CallbackAddressArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "CallbackParamAddressArray"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_CallbackParamAddressArray,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_CallbackParamAddressArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ServiceStatus"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_ServiceStatus,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_ServiceStatus,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS_PROCESS")
	},
	{
		.name = discard_const_p(char, "dwNotificationStatus"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_dwNotificationStatus,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_dwNotificationStatus,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwSequence"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_get_dwSequence,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_set_dwSequence,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1, type);
}


static PyTypeObject SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1",
	.tp_getset = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_new,
};


static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_ullThreadId(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ullThreadId;
	py_ullThreadId = PyLong_FromUnsignedLongLong(object->ullThreadId);
	return py_ullThreadId;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_ullThreadId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ullThreadId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ullThreadId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ullThreadId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwNotifyMask(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNotifyMask;
	py_dwNotifyMask = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNotifyMask));
	return py_dwNotifyMask;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwNotifyMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwNotifyMask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNotifyMask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNotifyMask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_CallbackAddressArray(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_CallbackAddressArray;
	py_CallbackAddressArray = PyList_New(16);
	if (py_CallbackAddressArray == NULL) {
		return NULL;
	}
	{
		int CallbackAddressArray_cntr_0;
		for (CallbackAddressArray_cntr_0 = 0; CallbackAddressArray_cntr_0 < (16); CallbackAddressArray_cntr_0++) {
			PyObject *py_CallbackAddressArray_0;
			py_CallbackAddressArray_0 = PyLong_FromLong((uint16_t)((object->CallbackAddressArray)[CallbackAddressArray_cntr_0]));
			PyList_SetItem(py_CallbackAddressArray, CallbackAddressArray_cntr_0, py_CallbackAddressArray_0);
		}
	}
	return py_CallbackAddressArray;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_CallbackAddressArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->CallbackAddressArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int CallbackAddressArray_cntr_0;
		if (ARRAY_SIZE(object->CallbackAddressArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->CallbackAddressArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (CallbackAddressArray_cntr_0 = 0; CallbackAddressArray_cntr_0 < PyList_GET_SIZE(value); CallbackAddressArray_cntr_0++) {
			if (PyList_GET_ITEM(value, CallbackAddressArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->CallbackAddressArray)[CallbackAddressArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->CallbackAddressArray)[CallbackAddressArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, CallbackAddressArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, CallbackAddressArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->CallbackAddressArray)[CallbackAddressArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_CallbackParamAddressArray(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_CallbackParamAddressArray;
	py_CallbackParamAddressArray = PyList_New(16);
	if (py_CallbackParamAddressArray == NULL) {
		return NULL;
	}
	{
		int CallbackParamAddressArray_cntr_0;
		for (CallbackParamAddressArray_cntr_0 = 0; CallbackParamAddressArray_cntr_0 < (16); CallbackParamAddressArray_cntr_0++) {
			PyObject *py_CallbackParamAddressArray_0;
			py_CallbackParamAddressArray_0 = PyLong_FromLong((uint16_t)((object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0]));
			PyList_SetItem(py_CallbackParamAddressArray, CallbackParamAddressArray_cntr_0, py_CallbackParamAddressArray_0);
		}
	}
	return py_CallbackParamAddressArray;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_CallbackParamAddressArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->CallbackParamAddressArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int CallbackParamAddressArray_cntr_0;
		if (ARRAY_SIZE(object->CallbackParamAddressArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->CallbackParamAddressArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (CallbackParamAddressArray_cntr_0 = 0; CallbackParamAddressArray_cntr_0 < PyList_GET_SIZE(value); CallbackParamAddressArray_cntr_0++) {
			if (PyList_GET_ITEM(value, CallbackParamAddressArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, CallbackParamAddressArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, CallbackParamAddressArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->CallbackParamAddressArray)[CallbackParamAddressArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_ServiceStatus(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ServiceStatus;
	py_ServiceStatus = pytalloc_reference_ex(&SERVICE_STATUS_PROCESS_Type, pytalloc_get_mem_ctx(obj), &object->ServiceStatus);
	return py_ServiceStatus;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_ServiceStatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ServiceStatus");
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_PROCESS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ServiceStatus = *(struct SERVICE_STATUS_PROCESS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwNotificationStatus(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNotificationStatus;
	py_dwNotificationStatus = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNotificationStatus));
	return py_dwNotificationStatus;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwNotificationStatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwNotificationStatus");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNotificationStatus));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNotificationStatus = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwSequence(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_dwSequence;
	py_dwSequence = PyLong_FromUnsignedLongLong((uint32_t)(object->dwSequence));
	return py_dwSequence;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwSequence(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwSequence");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwSequence));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwSequence = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwNotificationTriggered(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNotificationTriggered;
	py_dwNotificationTriggered = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNotificationTriggered));
	return py_dwNotificationTriggered;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwNotificationTriggered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwNotificationTriggered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNotificationTriggered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNotificationTriggered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_pszServiceNames(PyObject *obj, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_pszServiceNames;
	if (object->pszServiceNames == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszServiceNames == NULL) {
		py_pszServiceNames = Py_None;
		Py_INCREF(py_pszServiceNames);
	} else {
		if (object->pszServiceNames == NULL) {
			py_pszServiceNames = Py_None;
			Py_INCREF(py_pszServiceNames);
		} else {
			py_pszServiceNames = PyUnicode_Decode(object->pszServiceNames, strlen(object->pszServiceNames), "utf-8", "ignore");
		}
	}
	return py_pszServiceNames;
}

static int py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_pszServiceNames(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pszServiceNames");
		return -1;
	}
	if (value == Py_None) {
		object->pszServiceNames = NULL;
	} else {
		object->pszServiceNames = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszServiceNames = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_getsetters[] = {
	{
		.name = discard_const_p(char, "ullThreadId"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_ullThreadId,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_ullThreadId,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "dwNotifyMask"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwNotifyMask,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwNotifyMask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "CallbackAddressArray"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_CallbackAddressArray,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_CallbackAddressArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "CallbackParamAddressArray"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_CallbackParamAddressArray,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_CallbackParamAddressArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ServiceStatus"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_ServiceStatus,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_ServiceStatus,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS_PROCESS")
	},
	{
		.name = discard_const_p(char, "dwNotificationStatus"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwNotificationStatus,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwNotificationStatus,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwSequence"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwSequence,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwSequence,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwNotificationTriggered"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_dwNotificationTriggered,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_dwNotificationTriggered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszServiceNames"),
		.get = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_get_pszServiceNames,
		.set = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_set_pszServiceNames,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2, type);
}


static PyTypeObject SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2",
	.tp_getset = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_new,
};

static PyObject *py_import_SC_RPC_NOTIFY_PARAMS_u(TALLOC_CTX *mem_ctx, int level, union SC_RPC_NOTIFY_PARAMS_u *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->pStatusChangeParam1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_Type, in->pStatusChangeParam1, in->pStatusChangeParam1);
			}
			return ret;

		case 2:
			if (in->pStatusChangeParams == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_Type, in->pStatusChangeParams, in->pStatusChangeParams);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union SC_RPC_NOTIFY_PARAMS_u *py_export_SC_RPC_NOTIFY_PARAMS_u(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union SC_RPC_NOTIFY_PARAMS_u *ret = talloc_zero(mem_ctx, union SC_RPC_NOTIFY_PARAMS_u);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->pStatusChangeParam1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->pStatusChangeParam1 = NULL;
			} else {
				ret->pStatusChangeParam1 = NULL;
				PY_CHECK_TYPE(&SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->pStatusChangeParam1 = (struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->pStatusChangeParams");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->pStatusChangeParams = NULL;
			} else {
				ret->pStatusChangeParams = NULL;
				PY_CHECK_TYPE(&SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->pStatusChangeParams = (struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_SC_RPC_NOTIFY_PARAMS_u_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union SC_RPC_NOTIFY_PARAMS_u *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union SC_RPC_NOTIFY_PARAMS_u *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union SC_RPC_NOTIFY_PARAMS_u!");
		return NULL;
	}

	return py_import_SC_RPC_NOTIFY_PARAMS_u(mem_ctx, level, in);
}

static PyObject *py_SC_RPC_NOTIFY_PARAMS_u_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union SC_RPC_NOTIFY_PARAMS_u *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_SC_RPC_NOTIFY_PARAMS_u(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_SC_RPC_NOTIFY_PARAMS_u_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_NOTIFY_PARAMS_u_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_NOTIFY_PARAMS_u_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_SC_RPC_NOTIFY_PARAMS_u_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject SC_RPC_NOTIFY_PARAMS_u_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_NOTIFY_PARAMS_u",
	.tp_getset = NULL,
	.tp_methods = py_SC_RPC_NOTIFY_PARAMS_u_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_NOTIFY_PARAMS_u_new,
};


static PyObject *py_SC_RPC_NOTIFY_PARAMS_get_dwInfoLevel(PyObject *obj, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS *object = pytalloc_get_ptr(obj);
	PyObject *py_dwInfoLevel;
	py_dwInfoLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwInfoLevel));
	return py_dwInfoLevel;
}

static int py_SC_RPC_NOTIFY_PARAMS_set_dwInfoLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwInfoLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwInfoLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwInfoLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SC_RPC_NOTIFY_PARAMS_get_u(PyObject *obj, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS *object = pytalloc_get_ptr(obj);
	PyObject *py_u;
	py_u = pyrpc_import_union(&SC_RPC_NOTIFY_PARAMS_u_Type, pytalloc_get_mem_ctx(obj), object->dwInfoLevel, &object->u, "union SC_RPC_NOTIFY_PARAMS_u");
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_SC_RPC_NOTIFY_PARAMS_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->u");
		return -1;
	}
	{
		union SC_RPC_NOTIFY_PARAMS_u *u_switch_0;
		u_switch_0 = (union SC_RPC_NOTIFY_PARAMS_u *)pyrpc_export_union(&SC_RPC_NOTIFY_PARAMS_u_Type, pytalloc_get_mem_ctx(py_obj), object->dwInfoLevel, value, "union SC_RPC_NOTIFY_PARAMS_u");
		if (u_switch_0 == NULL) {
			return -1;
		}
		object->u = *u_switch_0;
	}
	return 0;
}

static PyGetSetDef py_SC_RPC_NOTIFY_PARAMS_getsetters[] = {
	{
		.name = discard_const_p(char, "dwInfoLevel"),
		.get = py_SC_RPC_NOTIFY_PARAMS_get_dwInfoLevel,
		.set = py_SC_RPC_NOTIFY_PARAMS_set_dwInfoLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "u"),
		.get = py_SC_RPC_NOTIFY_PARAMS_get_u,
		.set = py_SC_RPC_NOTIFY_PARAMS_set_u,
		.doc = discard_const_p(char, "PIDL-generated element of base type SC_RPC_NOTIFY_PARAMS_u")
	},
	{ .name = NULL }
};

static PyObject *py_SC_RPC_NOTIFY_PARAMS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SC_RPC_NOTIFY_PARAMS, type);
}


static PyTypeObject SC_RPC_NOTIFY_PARAMS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_NOTIFY_PARAMS",
	.tp_getset = py_SC_RPC_NOTIFY_PARAMS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_NOTIFY_PARAMS_new,
};


static PyObject *py_SC_RPC_NOTIFY_PARAMS_LIST_get_cElements(PyObject *obj, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_cElements;
	py_cElements = PyLong_FromUnsignedLongLong((uint32_t)(object->cElements));
	return py_cElements;
}

static int py_SC_RPC_NOTIFY_PARAMS_LIST_set_cElements(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cElements");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cElements));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cElements = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SC_RPC_NOTIFY_PARAMS_LIST_get_NotifyParamsArray(PyObject *obj, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_NotifyParamsArray;
	py_NotifyParamsArray = PyList_New(object->cElements);
	if (py_NotifyParamsArray == NULL) {
		return NULL;
	}
	{
		int NotifyParamsArray_cntr_0;
		for (NotifyParamsArray_cntr_0 = 0; NotifyParamsArray_cntr_0 < (object->cElements); NotifyParamsArray_cntr_0++) {
			PyObject *py_NotifyParamsArray_0;
			py_NotifyParamsArray_0 = pytalloc_reference_ex(&SC_RPC_NOTIFY_PARAMS_Type, object->NotifyParamsArray, &(object->NotifyParamsArray)[NotifyParamsArray_cntr_0]);
			PyList_SetItem(py_NotifyParamsArray, NotifyParamsArray_cntr_0, py_NotifyParamsArray_0);
		}
	}
	return py_NotifyParamsArray;
}

static int py_SC_RPC_NOTIFY_PARAMS_LIST_set_NotifyParamsArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_RPC_NOTIFY_PARAMS_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->NotifyParamsArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int NotifyParamsArray_cntr_0;
		object->NotifyParamsArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->NotifyParamsArray, PyList_GET_SIZE(value));
		if (!object->NotifyParamsArray) { return -1; }
		talloc_set_name_const(object->NotifyParamsArray, "ARRAY: object->NotifyParamsArray");
		for (NotifyParamsArray_cntr_0 = 0; NotifyParamsArray_cntr_0 < PyList_GET_SIZE(value); NotifyParamsArray_cntr_0++) {
			if (PyList_GET_ITEM(value, NotifyParamsArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->NotifyParamsArray)[NotifyParamsArray_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&SC_RPC_NOTIFY_PARAMS_Type, PyList_GET_ITEM(value, NotifyParamsArray_cntr_0), return -1;);
			if (talloc_reference(object->NotifyParamsArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, NotifyParamsArray_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->NotifyParamsArray)[NotifyParamsArray_cntr_0] = *(struct SC_RPC_NOTIFY_PARAMS *)pytalloc_get_ptr(PyList_GET_ITEM(value, NotifyParamsArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_SC_RPC_NOTIFY_PARAMS_LIST_getsetters[] = {
	{
		.name = discard_const_p(char, "cElements"),
		.get = py_SC_RPC_NOTIFY_PARAMS_LIST_get_cElements,
		.set = py_SC_RPC_NOTIFY_PARAMS_LIST_set_cElements,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "NotifyParamsArray"),
		.get = py_SC_RPC_NOTIFY_PARAMS_LIST_get_NotifyParamsArray,
		.set = py_SC_RPC_NOTIFY_PARAMS_LIST_set_NotifyParamsArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type SC_RPC_NOTIFY_PARAMS")
	},
	{ .name = NULL }
};

static PyObject *py_SC_RPC_NOTIFY_PARAMS_LIST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SC_RPC_NOTIFY_PARAMS_LIST, type);
}


static PyTypeObject SC_RPC_NOTIFY_PARAMS_LIST_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_NOTIFY_PARAMS_LIST",
	.tp_getset = py_SC_RPC_NOTIFY_PARAMS_LIST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_NOTIFY_PARAMS_LIST_new,
};


static PyObject *py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_get_dwReason(PyObject *obj, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReason;
	py_dwReason = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReason));
	return py_dwReason;
}

static int py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_set_dwReason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwReason");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReason));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_get_szComment(PyObject *obj, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *object = pytalloc_get_ptr(obj);
	PyObject *py_szComment;
	if (object->szComment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->szComment == NULL) {
		py_szComment = Py_None;
		Py_INCREF(py_szComment);
	} else {
		if (object->szComment == NULL) {
			py_szComment = Py_None;
			Py_INCREF(py_szComment);
		} else {
			py_szComment = PyUnicode_Decode(object->szComment, strlen(object->szComment), "utf-8", "ignore");
		}
	}
	return py_szComment;
}

static int py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_set_szComment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->szComment");
		return -1;
	}
	if (value == Py_None) {
		object->szComment = NULL;
	} else {
		object->szComment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->szComment = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_getsetters[] = {
	{
		.name = discard_const_p(char, "dwReason"),
		.get = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_get_dwReason,
		.set = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_set_dwReason,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "szComment"),
		.get = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_get_szComment,
		.set = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_set_szComment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA, type);
}


static PyTypeObject SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA",
	.tp_getset = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_new,
};


static PyObject *py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_get_ServiceStatus(PyObject *obj, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *object = pytalloc_get_ptr(obj);
	PyObject *py_ServiceStatus;
	py_ServiceStatus = pytalloc_reference_ex(&SERVICE_STATUS_PROCESS_Type, pytalloc_get_mem_ctx(obj), &object->ServiceStatus);
	return py_ServiceStatus;
}

static int py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_set_ServiceStatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ServiceStatus");
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_PROCESS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ServiceStatus = *(struct SERVICE_STATUS_PROCESS *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_getsetters[] = {
	{
		.name = discard_const_p(char, "ServiceStatus"),
		.get = py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_get_ServiceStatus,
		.set = py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_set_ServiceStatus,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS_PROCESS")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS, type);
}


static PyTypeObject SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS",
	.tp_getset = py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_new,
};

static PyObject *py_import_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(TALLOC_CTX *mem_ctx, int level, union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->psrInParams == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_Type, in->psrInParams, in->psrInParams);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *py_export_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *ret = talloc_zero(mem_ctx, union SC_RPC_SERVICE_CONTROL_IN_PARAMSA);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psrInParams");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psrInParams = NULL;
			} else {
				ret->psrInParams = NULL;
				PY_CHECK_TYPE(&SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psrInParams = (struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union SC_RPC_SERVICE_CONTROL_IN_PARAMSA!");
		return NULL;
	}

	return py_import_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(mem_ctx, level, in);
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject SC_RPC_SERVICE_CONTROL_IN_PARAMSA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_SERVICE_CONTROL_IN_PARAMSA",
	.tp_getset = NULL,
	.tp_methods = py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_SERVICE_CONTROL_IN_PARAMSA_new,
};

static PyObject *py_import_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(TALLOC_CTX *mem_ctx, int level, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->psrOutParams == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_Type, in->psrOutParams, in->psrOutParams);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *py_export_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *ret = talloc_zero(mem_ctx, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psrOutParams");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psrOutParams = NULL;
			} else {
				ret->psrOutParams = NULL;
				PY_CHECK_TYPE(&SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psrOutParams = (struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA!");
		return NULL;
	}

	return py_import_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(mem_ctx, level, in);
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_SERVICE_CONTROL_OUT_PARAMSA",
	.tp_getset = NULL,
	.tp_methods = py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA_new,
};


static PyObject *py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_get_dwReason(PyObject *obj, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReason;
	py_dwReason = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReason));
	return py_dwReason;
}

static int py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_set_dwReason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwReason");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReason));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_get_pszComment(PyObject *obj, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *object = pytalloc_get_ptr(obj);
	PyObject *py_pszComment;
	if (object->pszComment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszComment == NULL) {
		py_pszComment = Py_None;
		Py_INCREF(py_pszComment);
	} else {
		if (object->pszComment == NULL) {
			py_pszComment = Py_None;
			Py_INCREF(py_pszComment);
		} else {
			py_pszComment = PyUnicode_Decode(object->pszComment, strlen(object->pszComment), "utf-8", "ignore");
		}
	}
	return py_pszComment;
}

static int py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_set_pszComment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pszComment");
		return -1;
	}
	if (value == Py_None) {
		object->pszComment = NULL;
	} else {
		object->pszComment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszComment = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_getsetters[] = {
	{
		.name = discard_const_p(char, "dwReason"),
		.get = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_get_dwReason,
		.set = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_set_dwReason,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszComment"),
		.get = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_get_pszComment,
		.set = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_set_pszComment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW, type);
}


static PyTypeObject SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW",
	.tp_getset = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_new,
};

static PyObject *py_import_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(TALLOC_CTX *mem_ctx, int level, union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->psrInParams == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_Type, in->psrInParams, in->psrInParams);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *py_export_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *ret = talloc_zero(mem_ctx, union SC_RPC_SERVICE_CONTROL_IN_PARAMSW);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psrInParams");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psrInParams = NULL;
			} else {
				ret->psrInParams = NULL;
				PY_CHECK_TYPE(&SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psrInParams = (struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union SC_RPC_SERVICE_CONTROL_IN_PARAMSW!");
		return NULL;
	}

	return py_import_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(mem_ctx, level, in);
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject SC_RPC_SERVICE_CONTROL_IN_PARAMSW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_SERVICE_CONTROL_IN_PARAMSW",
	.tp_getset = NULL,
	.tp_methods = py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_SERVICE_CONTROL_IN_PARAMSW_new,
};

static PyObject *py_import_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(TALLOC_CTX *mem_ctx, int level, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->psrOutParams == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_Type, in->psrOutParams, in->psrOutParams);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *py_export_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *ret = talloc_zero(mem_ctx, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psrOutParams");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psrOutParams = NULL;
			} else {
				ret->psrOutParams = NULL;
				PY_CHECK_TYPE(&SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psrOutParams = (struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW!");
		return NULL;
	}

	return py_import_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(mem_ctx, level, in);
}

static PyObject *py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_SERVICE_CONTROL_OUT_PARAMSW",
	.tp_getset = NULL,
	.tp_methods = py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW_new,
};


static PyObject *py_SERVICE_DESCRIPTIONW_get_lpDescription(PyObject *obj, void *closure)
{
	struct SERVICE_DESCRIPTIONW *object = pytalloc_get_ptr(obj);
	PyObject *py_lpDescription;
	if (object->lpDescription == NULL) {
		Py_RETURN_NONE;
	}
	if (object->lpDescription == NULL) {
		py_lpDescription = Py_None;
		Py_INCREF(py_lpDescription);
	} else {
		if (object->lpDescription == NULL) {
			py_lpDescription = Py_None;
			Py_INCREF(py_lpDescription);
		} else {
			py_lpDescription = PyUnicode_Decode(object->lpDescription, strlen(object->lpDescription), "utf-8", "ignore");
		}
	}
	return py_lpDescription;
}

static int py_SERVICE_DESCRIPTIONW_set_lpDescription(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_DESCRIPTIONW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->lpDescription");
		return -1;
	}
	if (value == Py_None) {
		object->lpDescription = NULL;
	} else {
		object->lpDescription = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->lpDescription = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_DESCRIPTIONW_getsetters[] = {
	{
		.name = discard_const_p(char, "lpDescription"),
		.get = py_SERVICE_DESCRIPTIONW_get_lpDescription,
		.set = py_SERVICE_DESCRIPTIONW_set_lpDescription,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_DESCRIPTIONW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_DESCRIPTIONW, type);
}


static PyTypeObject SERVICE_DESCRIPTIONW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_DESCRIPTIONW",
	.tp_getset = py_SERVICE_DESCRIPTIONW_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_DESCRIPTIONW_new,
};


static PyObject *py_SERVICE_DELAYED_AUTO_START_INFO_get_fDelayedAutostart(PyObject *obj, void *closure)
{
	struct SERVICE_DELAYED_AUTO_START_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_fDelayedAutostart;
	py_fDelayedAutostart = PyLong_FromUnsignedLongLong((uint32_t)(object->fDelayedAutostart));
	return py_fDelayedAutostart;
}

static int py_SERVICE_DELAYED_AUTO_START_INFO_set_fDelayedAutostart(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_DELAYED_AUTO_START_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->fDelayedAutostart");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDelayedAutostart));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDelayedAutostart = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_DELAYED_AUTO_START_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "fDelayedAutostart"),
		.get = py_SERVICE_DELAYED_AUTO_START_INFO_get_fDelayedAutostart,
		.set = py_SERVICE_DELAYED_AUTO_START_INFO_set_fDelayedAutostart,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_DELAYED_AUTO_START_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_DELAYED_AUTO_START_INFO, type);
}


static PyTypeObject SERVICE_DELAYED_AUTO_START_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_DELAYED_AUTO_START_INFO",
	.tp_getset = py_SERVICE_DELAYED_AUTO_START_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_DELAYED_AUTO_START_INFO_new,
};


static PyObject *py_SERVICE_FAILURE_ACTIONS_FLAG_get_fFailureActionsOnNonCrashFailures(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS_FLAG *object = pytalloc_get_ptr(obj);
	PyObject *py_fFailureActionsOnNonCrashFailures;
	py_fFailureActionsOnNonCrashFailures = PyLong_FromUnsignedLongLong((uint32_t)(object->fFailureActionsOnNonCrashFailures));
	return py_fFailureActionsOnNonCrashFailures;
}

static int py_SERVICE_FAILURE_ACTIONS_FLAG_set_fFailureActionsOnNonCrashFailures(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS_FLAG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->fFailureActionsOnNonCrashFailures");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fFailureActionsOnNonCrashFailures));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fFailureActionsOnNonCrashFailures = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_FAILURE_ACTIONS_FLAG_getsetters[] = {
	{
		.name = discard_const_p(char, "fFailureActionsOnNonCrashFailures"),
		.get = py_SERVICE_FAILURE_ACTIONS_FLAG_get_fFailureActionsOnNonCrashFailures,
		.set = py_SERVICE_FAILURE_ACTIONS_FLAG_set_fFailureActionsOnNonCrashFailures,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_FAILURE_ACTIONS_FLAG_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_FAILURE_ACTIONS_FLAG, type);
}


static PyTypeObject SERVICE_FAILURE_ACTIONS_FLAG_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_FAILURE_ACTIONS_FLAG",
	.tp_getset = py_SERVICE_FAILURE_ACTIONS_FLAG_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_FAILURE_ACTIONS_FLAG_new,
};


static PyObject *py_SERVICE_SID_INFO_get_dwServiceSidType(PyObject *obj, void *closure)
{
	struct SERVICE_SID_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwServiceSidType;
	py_dwServiceSidType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwServiceSidType));
	return py_dwServiceSidType;
}

static int py_SERVICE_SID_INFO_set_dwServiceSidType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_SID_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwServiceSidType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwServiceSidType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwServiceSidType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_SID_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "dwServiceSidType"),
		.get = py_SERVICE_SID_INFO_get_dwServiceSidType,
		.set = py_SERVICE_SID_INFO_set_dwServiceSidType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_SID_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_SID_INFO, type);
}


static PyTypeObject SERVICE_SID_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_SID_INFO",
	.tp_getset = py_SERVICE_SID_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_SID_INFO_new,
};


static PyObject *py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_get_cbRequiredPrivileges(PyObject *obj, void *closure)
{
	struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_cbRequiredPrivileges;
	py_cbRequiredPrivileges = PyLong_FromUnsignedLongLong((uint32_t)(object->cbRequiredPrivileges));
	return py_cbRequiredPrivileges;
}

static int py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_set_cbRequiredPrivileges(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cbRequiredPrivileges");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cbRequiredPrivileges));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cbRequiredPrivileges = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_get_pRequiredPrivileges(PyObject *obj, void *closure)
{
	struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pRequiredPrivileges;
	if (object->pRequiredPrivileges == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pRequiredPrivileges == NULL) {
		py_pRequiredPrivileges = Py_None;
		Py_INCREF(py_pRequiredPrivileges);
	} else {
		py_pRequiredPrivileges = PyList_New(object->cbRequiredPrivileges);
		if (py_pRequiredPrivileges == NULL) {
			return NULL;
		}
		{
			int pRequiredPrivileges_cntr_1;
			for (pRequiredPrivileges_cntr_1 = 0; pRequiredPrivileges_cntr_1 < (object->cbRequiredPrivileges); pRequiredPrivileges_cntr_1++) {
				PyObject *py_pRequiredPrivileges_1;
				py_pRequiredPrivileges_1 = PyLong_FromLong((uint16_t)((object->pRequiredPrivileges)[pRequiredPrivileges_cntr_1]));
				PyList_SetItem(py_pRequiredPrivileges, pRequiredPrivileges_cntr_1, py_pRequiredPrivileges_1);
			}
		}
	}
	return py_pRequiredPrivileges;
}

static int py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_set_pRequiredPrivileges(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pRequiredPrivileges));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pRequiredPrivileges");
		return -1;
	}
	if (value == Py_None) {
		object->pRequiredPrivileges = NULL;
	} else {
		object->pRequiredPrivileges = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pRequiredPrivileges_cntr_1;
			object->pRequiredPrivileges = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pRequiredPrivileges, PyList_GET_SIZE(value));
			if (!object->pRequiredPrivileges) { return -1; }
			talloc_set_name_const(object->pRequiredPrivileges, "ARRAY: object->pRequiredPrivileges");
			for (pRequiredPrivileges_cntr_1 = 0; pRequiredPrivileges_cntr_1 < PyList_GET_SIZE(value); pRequiredPrivileges_cntr_1++) {
				if (PyList_GET_ITEM(value, pRequiredPrivileges_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->pRequiredPrivileges)[pRequiredPrivileges_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->pRequiredPrivileges)[pRequiredPrivileges_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pRequiredPrivileges_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pRequiredPrivileges_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->pRequiredPrivileges)[pRequiredPrivileges_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "cbRequiredPrivileges"),
		.get = py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_get_cbRequiredPrivileges,
		.set = py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_set_cbRequiredPrivileges,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pRequiredPrivileges"),
		.get = py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_get_pRequiredPrivileges,
		.set = py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_set_pRequiredPrivileges,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO, type);
}


static PyTypeObject SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_RPC_REQUIRED_PRIVILEGES_INFO",
	.tp_getset = py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_new,
};


static PyObject *py_SERVICE_PRESHUTDOWN_INFO_get_dwPreshutdownTimeout(PyObject *obj, void *closure)
{
	struct SERVICE_PRESHUTDOWN_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwPreshutdownTimeout;
	py_dwPreshutdownTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwPreshutdownTimeout));
	return py_dwPreshutdownTimeout;
}

static int py_SERVICE_PRESHUTDOWN_INFO_set_dwPreshutdownTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_PRESHUTDOWN_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwPreshutdownTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwPreshutdownTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwPreshutdownTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_PRESHUTDOWN_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "dwPreshutdownTimeout"),
		.get = py_SERVICE_PRESHUTDOWN_INFO_get_dwPreshutdownTimeout,
		.set = py_SERVICE_PRESHUTDOWN_INFO_set_dwPreshutdownTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_PRESHUTDOWN_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_PRESHUTDOWN_INFO, type);
}


static PyTypeObject SERVICE_PRESHUTDOWN_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_PRESHUTDOWN_INFO",
	.tp_getset = py_SERVICE_PRESHUTDOWN_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_PRESHUTDOWN_INFO_new,
};


static PyObject *py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_get_dwDataType(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDataType;
	py_dwDataType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDataType));
	return py_dwDataType;
}

static int py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_set_dwDataType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwDataType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDataType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDataType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_get_cbData(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *object = pytalloc_get_ptr(obj);
	PyObject *py_cbData;
	py_cbData = PyLong_FromUnsignedLongLong((uint32_t)(object->cbData));
	return py_cbData;
}

static int py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_set_cbData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cbData");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cbData));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cbData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_get_pData(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *object = pytalloc_get_ptr(obj);
	PyObject *py_pData;
	if (object->pData == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pData == NULL) {
		py_pData = Py_None;
		Py_INCREF(py_pData);
	} else {
		py_pData = PyList_New(object->cbData);
		if (py_pData == NULL) {
			return NULL;
		}
		{
			int pData_cntr_1;
			for (pData_cntr_1 = 0; pData_cntr_1 < (object->cbData); pData_cntr_1++) {
				PyObject *py_pData_1;
				py_pData_1 = PyLong_FromLong((uint16_t)((object->pData)[pData_cntr_1]));
				PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
			}
		}
	}
	return py_pData;
}

static int py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pData");
		return -1;
	}
	if (value == Py_None) {
		object->pData = NULL;
	} else {
		object->pData = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pData_cntr_1;
			object->pData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pData, PyList_GET_SIZE(value));
			if (!object->pData) { return -1; }
			talloc_set_name_const(object->pData, "ARRAY: object->pData");
			for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(value); pData_cntr_1++) {
				if (PyList_GET_ITEM(value, pData_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->pData)[pData_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->pData)[pData_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pData_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pData_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->pData)[pData_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_getsetters[] = {
	{
		.name = discard_const_p(char, "dwDataType"),
		.get = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_get_dwDataType,
		.set = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_set_dwDataType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cbData"),
		.get = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_get_cbData,
		.set = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_set_cbData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pData"),
		.get = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_get_pData,
		.set = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_set_pData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM, type);
}


static PyTypeObject SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_TRIGGER_SPECIFIC_DATA_ITEM",
	.tp_getset = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_new,
};


static PyObject *py_SERVICE_TRIGGER_get_dwTriggerType(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTriggerType;
	py_dwTriggerType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwTriggerType));
	return py_dwTriggerType;
}

static int py_SERVICE_TRIGGER_set_dwTriggerType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwTriggerType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwTriggerType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwTriggerType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_get_dwAction(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(obj);
	PyObject *py_dwAction;
	py_dwAction = PyLong_FromUnsignedLongLong((uint32_t)(object->dwAction));
	return py_dwAction;
}

static int py_SERVICE_TRIGGER_set_dwAction(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwAction");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwAction));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwAction = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_get_pTriggerSubtype(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(obj);
	PyObject *py_pTriggerSubtype;
	if (object->pTriggerSubtype == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pTriggerSubtype == NULL) {
		py_pTriggerSubtype = Py_None;
		Py_INCREF(py_pTriggerSubtype);
	} else {
		py_pTriggerSubtype = pytalloc_reference_ex(GUID_Type, object->pTriggerSubtype, object->pTriggerSubtype);
	}
	return py_pTriggerSubtype;
}

static int py_SERVICE_TRIGGER_set_pTriggerSubtype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pTriggerSubtype));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pTriggerSubtype");
		return -1;
	}
	if (value == Py_None) {
		object->pTriggerSubtype = NULL;
	} else {
		object->pTriggerSubtype = NULL;
		PY_CHECK_TYPE(GUID_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pTriggerSubtype = (struct GUID *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_get_cDataItems(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(obj);
	PyObject *py_cDataItems;
	py_cDataItems = PyLong_FromUnsignedLongLong((uint32_t)(object->cDataItems));
	return py_cDataItems;
}

static int py_SERVICE_TRIGGER_set_cDataItems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cDataItems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cDataItems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cDataItems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_get_pDataItems(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(obj);
	PyObject *py_pDataItems;
	if (object->pDataItems == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pDataItems == NULL) {
		py_pDataItems = Py_None;
		Py_INCREF(py_pDataItems);
	} else {
		py_pDataItems = PyList_New(object->cDataItems);
		if (py_pDataItems == NULL) {
			return NULL;
		}
		{
			int pDataItems_cntr_1;
			for (pDataItems_cntr_1 = 0; pDataItems_cntr_1 < (object->cDataItems); pDataItems_cntr_1++) {
				PyObject *py_pDataItems_1;
				py_pDataItems_1 = pytalloc_reference_ex(&SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_Type, object->pDataItems, &(object->pDataItems)[pDataItems_cntr_1]);
				PyList_SetItem(py_pDataItems, pDataItems_cntr_1, py_pDataItems_1);
			}
		}
	}
	return py_pDataItems;
}

static int py_SERVICE_TRIGGER_set_pDataItems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pDataItems));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pDataItems");
		return -1;
	}
	if (value == Py_None) {
		object->pDataItems = NULL;
	} else {
		object->pDataItems = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pDataItems_cntr_1;
			object->pDataItems = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pDataItems, PyList_GET_SIZE(value));
			if (!object->pDataItems) { return -1; }
			talloc_set_name_const(object->pDataItems, "ARRAY: object->pDataItems");
			for (pDataItems_cntr_1 = 0; pDataItems_cntr_1 < PyList_GET_SIZE(value); pDataItems_cntr_1++) {
				if (PyList_GET_ITEM(value, pDataItems_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->pDataItems)[pDataItems_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_Type, PyList_GET_ITEM(value, pDataItems_cntr_1), return -1;);
				if (talloc_reference(object->pDataItems, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pDataItems_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->pDataItems)[pDataItems_cntr_1] = *(struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *)pytalloc_get_ptr(PyList_GET_ITEM(value, pDataItems_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_TRIGGER_getsetters[] = {
	{
		.name = discard_const_p(char, "dwTriggerType"),
		.get = py_SERVICE_TRIGGER_get_dwTriggerType,
		.set = py_SERVICE_TRIGGER_set_dwTriggerType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwAction"),
		.get = py_SERVICE_TRIGGER_get_dwAction,
		.set = py_SERVICE_TRIGGER_set_dwAction,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pTriggerSubtype"),
		.get = py_SERVICE_TRIGGER_get_pTriggerSubtype,
		.set = py_SERVICE_TRIGGER_set_pTriggerSubtype,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "cDataItems"),
		.get = py_SERVICE_TRIGGER_get_cDataItems,
		.set = py_SERVICE_TRIGGER_set_cDataItems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pDataItems"),
		.get = py_SERVICE_TRIGGER_get_pDataItems,
		.set = py_SERVICE_TRIGGER_set_pDataItems,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_TRIGGER_SPECIFIC_DATA_ITEM")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_TRIGGER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_TRIGGER, type);
}


static PyTypeObject SERVICE_TRIGGER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_TRIGGER",
	.tp_getset = py_SERVICE_TRIGGER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_TRIGGER_new,
};


static PyObject *py_SERVICE_TRIGGER_INFO_get_cTriggers(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_cTriggers;
	py_cTriggers = PyLong_FromUnsignedLongLong((uint32_t)(object->cTriggers));
	return py_cTriggers;
}

static int py_SERVICE_TRIGGER_INFO_set_cTriggers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cTriggers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cTriggers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cTriggers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_INFO_get_pTriggers(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pTriggers;
	if (object->pTriggers == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pTriggers == NULL) {
		py_pTriggers = Py_None;
		Py_INCREF(py_pTriggers);
	} else {
		py_pTriggers = PyList_New(object->cTriggers);
		if (py_pTriggers == NULL) {
			return NULL;
		}
		{
			int pTriggers_cntr_1;
			for (pTriggers_cntr_1 = 0; pTriggers_cntr_1 < (object->cTriggers); pTriggers_cntr_1++) {
				PyObject *py_pTriggers_1;
				py_pTriggers_1 = pytalloc_reference_ex(&SERVICE_TRIGGER_Type, object->pTriggers, &(object->pTriggers)[pTriggers_cntr_1]);
				PyList_SetItem(py_pTriggers, pTriggers_cntr_1, py_pTriggers_1);
			}
		}
	}
	return py_pTriggers;
}

static int py_SERVICE_TRIGGER_INFO_set_pTriggers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pTriggers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pTriggers");
		return -1;
	}
	if (value == Py_None) {
		object->pTriggers = NULL;
	} else {
		object->pTriggers = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pTriggers_cntr_1;
			object->pTriggers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pTriggers, PyList_GET_SIZE(value));
			if (!object->pTriggers) { return -1; }
			talloc_set_name_const(object->pTriggers, "ARRAY: object->pTriggers");
			for (pTriggers_cntr_1 = 0; pTriggers_cntr_1 < PyList_GET_SIZE(value); pTriggers_cntr_1++) {
				if (PyList_GET_ITEM(value, pTriggers_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->pTriggers)[pTriggers_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&SERVICE_TRIGGER_Type, PyList_GET_ITEM(value, pTriggers_cntr_1), return -1;);
				if (talloc_reference(object->pTriggers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pTriggers_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->pTriggers)[pTriggers_cntr_1] = *(struct SERVICE_TRIGGER *)pytalloc_get_ptr(PyList_GET_ITEM(value, pTriggers_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_SERVICE_TRIGGER_INFO_get_pReserved(PyObject *obj, void *closure)
{
	struct SERVICE_TRIGGER_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pReserved;
	if (object->pReserved == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pReserved == NULL) {
		py_pReserved = Py_None;
		Py_INCREF(py_pReserved);
	} else {
		py_pReserved = PyLong_FromLong((uint16_t)(*object->pReserved));
	}
	return py_pReserved;
}

static int py_SERVICE_TRIGGER_INFO_set_pReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_TRIGGER_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pReserved));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pReserved");
		return -1;
	}
	if (value == Py_None) {
		object->pReserved = NULL;
	} else {
		object->pReserved = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pReserved);
		if (object->pReserved == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->pReserved));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->pReserved = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_TRIGGER_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "cTriggers"),
		.get = py_SERVICE_TRIGGER_INFO_get_cTriggers,
		.set = py_SERVICE_TRIGGER_INFO_set_cTriggers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pTriggers"),
		.get = py_SERVICE_TRIGGER_INFO_get_pTriggers,
		.set = py_SERVICE_TRIGGER_INFO_set_pTriggers,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_TRIGGER")
	},
	{
		.name = discard_const_p(char, "pReserved"),
		.get = py_SERVICE_TRIGGER_INFO_get_pReserved,
		.set = py_SERVICE_TRIGGER_INFO_set_pReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_TRIGGER_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_TRIGGER_INFO, type);
}


static PyTypeObject SERVICE_TRIGGER_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_TRIGGER_INFO",
	.tp_getset = py_SERVICE_TRIGGER_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_TRIGGER_INFO_new,
};


static PyObject *py_SERVICE_PREFERRED_NODE_INFO_get_usPreferredNode(PyObject *obj, void *closure)
{
	struct SERVICE_PREFERRED_NODE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_usPreferredNode;
	py_usPreferredNode = PyLong_FromLong((uint16_t)(object->usPreferredNode));
	return py_usPreferredNode;
}

static int py_SERVICE_PREFERRED_NODE_INFO_set_usPreferredNode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_PREFERRED_NODE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->usPreferredNode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->usPreferredNode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->usPreferredNode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SERVICE_PREFERRED_NODE_INFO_get_fDelete(PyObject *obj, void *closure)
{
	struct SERVICE_PREFERRED_NODE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_fDelete;
	py_fDelete = PyLong_FromUnsignedLongLong((uint32_t)(object->fDelete));
	return py_fDelete;
}

static int py_SERVICE_PREFERRED_NODE_INFO_set_fDelete(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_PREFERRED_NODE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->fDelete");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDelete));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDelete = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_PREFERRED_NODE_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "usPreferredNode"),
		.get = py_SERVICE_PREFERRED_NODE_INFO_get_usPreferredNode,
		.set = py_SERVICE_PREFERRED_NODE_INFO_set_usPreferredNode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "fDelete"),
		.get = py_SERVICE_PREFERRED_NODE_INFO_get_fDelete,
		.set = py_SERVICE_PREFERRED_NODE_INFO_set_fDelete,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_SERVICE_PREFERRED_NODE_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SERVICE_PREFERRED_NODE_INFO, type);
}


static PyTypeObject SERVICE_PREFERRED_NODE_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SERVICE_PREFERRED_NODE_INFO",
	.tp_getset = py_SERVICE_PREFERRED_NODE_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_PREFERRED_NODE_INFO_new,
};

static PyObject *py_import_SC_RPC_CONFIG_INFOW_u(TALLOC_CTX *mem_ctx, int level, union SC_RPC_CONFIG_INFOW_u *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->psd == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_DESCRIPTIONW_Type, in->psd, in->psd);
			}
			return ret;

		case 2:
			if (in->psfa == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_FAILURE_ACTIONSW_Type, in->psfa, in->psfa);
			}
			return ret;

		case 3:
			if (in->psda == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_DELAYED_AUTO_START_INFO_Type, in->psda, in->psda);
			}
			return ret;

		case 4:
			if (in->psfaf == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_FAILURE_ACTIONS_FLAG_Type, in->psfaf, in->psfaf);
			}
			return ret;

		case 5:
			if (in->pssid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_SID_INFO_Type, in->pssid, in->pssid);
			}
			return ret;

		case 6:
			if (in->psrp == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_Type, in->psrp, in->psrp);
			}
			return ret;

		case 7:
			if (in->psps == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_PRESHUTDOWN_INFO_Type, in->psps, in->psps);
			}
			return ret;

		case 8:
			if (in->psti == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_TRIGGER_INFO_Type, in->psti, in->psti);
			}
			return ret;

		case 9:
			if (in->pspn == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&SERVICE_PREFERRED_NODE_INFO_Type, in->pspn, in->pspn);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union SC_RPC_CONFIG_INFOW_u *py_export_SC_RPC_CONFIG_INFOW_u(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union SC_RPC_CONFIG_INFOW_u *ret = talloc_zero(mem_ctx, union SC_RPC_CONFIG_INFOW_u);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psd");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psd = NULL;
			} else {
				ret->psd = NULL;
				PY_CHECK_TYPE(&SERVICE_DESCRIPTIONW_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psd = (struct SERVICE_DESCRIPTIONW *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psfa");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psfa = NULL;
			} else {
				ret->psfa = NULL;
				PY_CHECK_TYPE(&SERVICE_FAILURE_ACTIONSW_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psfa = (struct SERVICE_FAILURE_ACTIONSW *)pytalloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psda");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psda = NULL;
			} else {
				ret->psda = NULL;
				PY_CHECK_TYPE(&SERVICE_DELAYED_AUTO_START_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psda = (struct SERVICE_DELAYED_AUTO_START_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psfaf");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psfaf = NULL;
			} else {
				ret->psfaf = NULL;
				PY_CHECK_TYPE(&SERVICE_FAILURE_ACTIONS_FLAG_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psfaf = (struct SERVICE_FAILURE_ACTIONS_FLAG *)pytalloc_get_ptr(in);
			}
			break;

		case 5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->pssid");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->pssid = NULL;
			} else {
				ret->pssid = NULL;
				PY_CHECK_TYPE(&SERVICE_SID_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->pssid = (struct SERVICE_SID_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case 6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psrp");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psrp = NULL;
			} else {
				ret->psrp = NULL;
				PY_CHECK_TYPE(&SERVICE_RPC_REQUIRED_PRIVILEGES_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psrp = (struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case 7:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psps");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psps = NULL;
			} else {
				ret->psps = NULL;
				PY_CHECK_TYPE(&SERVICE_PRESHUTDOWN_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psps = (struct SERVICE_PRESHUTDOWN_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case 8:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->psti");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->psti = NULL;
			} else {
				ret->psti = NULL;
				PY_CHECK_TYPE(&SERVICE_TRIGGER_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->psti = (struct SERVICE_TRIGGER_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case 9:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->pspn");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->pspn = NULL;
			} else {
				ret->pspn = NULL;
				PY_CHECK_TYPE(&SERVICE_PREFERRED_NODE_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->pspn = (struct SERVICE_PREFERRED_NODE_INFO *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_SC_RPC_CONFIG_INFOW_u_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union SC_RPC_CONFIG_INFOW_u *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union SC_RPC_CONFIG_INFOW_u *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union SC_RPC_CONFIG_INFOW_u!");
		return NULL;
	}

	return py_import_SC_RPC_CONFIG_INFOW_u(mem_ctx, level, in);
}

static PyObject *py_SC_RPC_CONFIG_INFOW_u_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union SC_RPC_CONFIG_INFOW_u *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_SC_RPC_CONFIG_INFOW_u(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_SC_RPC_CONFIG_INFOW_u_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_CONFIG_INFOW_u_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_SC_RPC_CONFIG_INFOW_u_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_SC_RPC_CONFIG_INFOW_u_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject SC_RPC_CONFIG_INFOW_u_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_CONFIG_INFOW_u",
	.tp_getset = NULL,
	.tp_methods = py_SC_RPC_CONFIG_INFOW_u_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_CONFIG_INFOW_u_new,
};


static PyObject *py_SC_RPC_CONFIG_INFOW_get_dwInfoLevel(PyObject *obj, void *closure)
{
	struct SC_RPC_CONFIG_INFOW *object = pytalloc_get_ptr(obj);
	PyObject *py_dwInfoLevel;
	py_dwInfoLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwInfoLevel));
	return py_dwInfoLevel;
}

static int py_SC_RPC_CONFIG_INFOW_set_dwInfoLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_RPC_CONFIG_INFOW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwInfoLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwInfoLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwInfoLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_SC_RPC_CONFIG_INFOW_get_u(PyObject *obj, void *closure)
{
	struct SC_RPC_CONFIG_INFOW *object = pytalloc_get_ptr(obj);
	PyObject *py_u;
	py_u = pyrpc_import_union(&SC_RPC_CONFIG_INFOW_u_Type, pytalloc_get_mem_ctx(obj), object->dwInfoLevel, &object->u, "union SC_RPC_CONFIG_INFOW_u");
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_SC_RPC_CONFIG_INFOW_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_RPC_CONFIG_INFOW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->u");
		return -1;
	}
	{
		union SC_RPC_CONFIG_INFOW_u *u_switch_0;
		u_switch_0 = (union SC_RPC_CONFIG_INFOW_u *)pyrpc_export_union(&SC_RPC_CONFIG_INFOW_u_Type, pytalloc_get_mem_ctx(py_obj), object->dwInfoLevel, value, "union SC_RPC_CONFIG_INFOW_u");
		if (u_switch_0 == NULL) {
			return -1;
		}
		object->u = *u_switch_0;
	}
	return 0;
}

static PyGetSetDef py_SC_RPC_CONFIG_INFOW_getsetters[] = {
	{
		.name = discard_const_p(char, "dwInfoLevel"),
		.get = py_SC_RPC_CONFIG_INFOW_get_dwInfoLevel,
		.set = py_SC_RPC_CONFIG_INFOW_set_dwInfoLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "u"),
		.get = py_SC_RPC_CONFIG_INFOW_get_u,
		.set = py_SC_RPC_CONFIG_INFOW_set_u,
		.doc = discard_const_p(char, "PIDL-generated element of base type SC_RPC_CONFIG_INFOW_u")
	},
	{ .name = NULL }
};

static PyObject *py_SC_RPC_CONFIG_INFOW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SC_RPC_CONFIG_INFOW, type);
}


static PyTypeObject SC_RPC_CONFIG_INFOW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SC_RPC_CONFIG_INFOW",
	.tp_getset = py_SC_RPC_CONFIG_INFOW_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_RPC_CONFIG_INFOW_new,
};



static PyObject *py_svcctl_CloseServiceHandle_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_CloseServiceHandle_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_CloseServiceHandle_out_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_svcctl_CloseServiceHandle_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_CloseServiceHandle_get_result(PyObject *obj, void *closure)
{
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_CloseServiceHandle_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_CloseServiceHandle_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_CloseServiceHandle_in_get_handle,
		.set = py_svcctl_CloseServiceHandle_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_svcctl_CloseServiceHandle_out_get_handle,
		.set = py_svcctl_CloseServiceHandle_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_CloseServiceHandle_get_result,
		.set = py_svcctl_CloseServiceHandle_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_CloseServiceHandle_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_CloseServiceHandle, type);
	struct svcctl_CloseServiceHandle *_self = (struct svcctl_CloseServiceHandle *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CloseServiceHandle_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_CloseServiceHandle_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_CloseServiceHandle_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CloseServiceHandle_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_CloseServiceHandle_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_CloseServiceHandle_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CloseServiceHandle *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CloseServiceHandle_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_CloseServiceHandle_ndr_print(py_obj, "svcctl_CloseServiceHandle_in", NDR_IN);
}

static PyObject *py_svcctl_CloseServiceHandle_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_CloseServiceHandle_ndr_print(py_obj, "svcctl_CloseServiceHandle_out", NDR_OUT);
}

static PyMethodDef py_svcctl_CloseServiceHandle_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_CloseServiceHandle_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.CloseServiceHandle.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CloseServiceHandle_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CloseServiceHandle_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CloseServiceHandle_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CloseServiceHandle_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_CloseServiceHandle_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_CloseServiceHandle_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_CloseServiceHandle_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.CloseServiceHandle",
	.tp_getset = py_svcctl_CloseServiceHandle_getsetters,
	.tp_methods = py_svcctl_CloseServiceHandle_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_CloseServiceHandle_new,
};

static bool pack_py_svcctl_CloseServiceHandle_args_in(PyObject *args, PyObject *kwargs, struct svcctl_CloseServiceHandle *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_CloseServiceHandle", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_CloseServiceHandle_args_out(struct svcctl_CloseServiceHandle *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_ControlService_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_ControlService_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_ControlService_in_get_control(PyObject *obj, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(obj);
	PyObject *py_control;
	py_control = PyLong_FromUnsignedLongLong((uint32_t)(object->in.control));
	return py_control;
}

static int py_svcctl_ControlService_in_set_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ControlService_out_get_service_status(PyObject *obj, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(obj);
	PyObject *py_service_status;
	if (object->out.service_status == NULL) {
		Py_RETURN_NONE;
	}
	py_service_status = pytalloc_reference_ex(&SERVICE_STATUS_Type, object->out.service_status, object->out.service_status);
	return py_service_status;
}

static int py_svcctl_ControlService_out_set_service_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.service_status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.service_status");
		return -1;
	}
	object->out.service_status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.service_status);
	if (object->out.service_status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.service_status = (struct SERVICE_STATUS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_ControlService_get_result(PyObject *obj, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_ControlService_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ControlService *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_ControlService_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_ControlService_in_get_handle,
		.set = py_svcctl_ControlService_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_control"),
		.get = py_svcctl_ControlService_in_get_control,
		.set = py_svcctl_ControlService_in_set_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_CONTROL")
	},
	{
		.name = discard_const_p(char, "out_service_status"),
		.get = py_svcctl_ControlService_out_get_service_status,
		.set = py_svcctl_ControlService_out_set_service_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_ControlService_get_result,
		.set = py_svcctl_ControlService_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_ControlService_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_ControlService, type);
	struct svcctl_ControlService *_self = (struct svcctl_ControlService *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.service_status = talloc_zero(mem_ctx, struct SERVICE_STATUS);
	return self;
}

static PyObject *py_svcctl_ControlService_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_svcctl_ControlService_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ControlService *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ControlService_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_ControlService_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ControlService_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_ControlService_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ControlService_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_ControlService_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ControlService *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ControlService_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_ControlService_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ControlService_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ControlService_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ControlService_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ControlService_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ControlService *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ControlService_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[1];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_ControlService_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ControlService_ndr_print(py_obj, "svcctl_ControlService_in", NDR_IN);
}

static PyObject *py_svcctl_ControlService_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ControlService_ndr_print(py_obj, "svcctl_ControlService_out", NDR_OUT);
}

static PyMethodDef py_svcctl_ControlService_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_ControlService_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.ControlService.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ControlService_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ControlService_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ControlService_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ControlService_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_ControlService_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_ControlService_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_ControlService_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.ControlService",
	.tp_getset = py_svcctl_ControlService_getsetters,
	.tp_methods = py_svcctl_ControlService_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_ControlService_new,
};

static bool pack_py_svcctl_ControlService_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ControlService *r)
{
	PyObject *py_handle;
	PyObject *py_control;
	const char *kwnames[] = {
		"handle", "control", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_ControlService", discard_const_p(char *, kwnames), &py_handle, &py_control)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_control == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.control");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.control));
		if (PyLong_Check(py_control)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_control);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_ControlService_args_out(struct svcctl_ControlService *r)
{
	PyObject *result;
	PyObject *py_service_status;
	py_service_status = pytalloc_reference_ex(&SERVICE_STATUS_Type, r->out.service_status, r->out.service_status);
	result = py_service_status;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_DeleteService_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_DeleteService *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_DeleteService_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_DeleteService *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_DeleteService_get_result(PyObject *obj, void *closure)
{
	struct svcctl_DeleteService *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_DeleteService_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_DeleteService *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_DeleteService_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_DeleteService_in_get_handle,
		.set = py_svcctl_DeleteService_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_DeleteService_get_result,
		.set = py_svcctl_DeleteService_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_DeleteService_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_DeleteService, type);
	struct svcctl_DeleteService *_self = (struct svcctl_DeleteService *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_DeleteService_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_svcctl_DeleteService_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_DeleteService *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_DeleteService_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_DeleteService_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_DeleteService_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_DeleteService_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_DeleteService_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_DeleteService_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_DeleteService *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_DeleteService_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_DeleteService_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_DeleteService_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_DeleteService_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_DeleteService_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_DeleteService_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_DeleteService *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_DeleteService_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[2];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_DeleteService_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_DeleteService_ndr_print(py_obj, "svcctl_DeleteService_in", NDR_IN);
}

static PyObject *py_svcctl_DeleteService_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_DeleteService_ndr_print(py_obj, "svcctl_DeleteService_out", NDR_OUT);
}

static PyMethodDef py_svcctl_DeleteService_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_DeleteService_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.DeleteService.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_DeleteService_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_DeleteService_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_DeleteService_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_DeleteService_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_DeleteService_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_DeleteService_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_DeleteService_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.DeleteService",
	.tp_getset = py_svcctl_DeleteService_getsetters,
	.tp_methods = py_svcctl_DeleteService_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_DeleteService_new,
};

static bool pack_py_svcctl_DeleteService_args_in(PyObject *args, PyObject *kwargs, struct svcctl_DeleteService *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_DeleteService", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_DeleteService_args_out(struct svcctl_DeleteService *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_LockServiceDatabase_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_LockServiceDatabase_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_LockServiceDatabase_out_get_lock(PyObject *obj, void *closure)
{
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(obj);
	PyObject *py_lock;
	if (object->out.lock == NULL) {
		Py_RETURN_NONE;
	}
	py_lock = pytalloc_reference_ex(policy_handle_Type, object->out.lock, object->out.lock);
	return py_lock;
}

static int py_svcctl_LockServiceDatabase_out_set_lock(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.lock));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.lock");
		return -1;
	}
	object->out.lock = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.lock);
	if (object->out.lock == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.lock = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_LockServiceDatabase_get_result(PyObject *obj, void *closure)
{
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_LockServiceDatabase_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_LockServiceDatabase_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_LockServiceDatabase_in_get_handle,
		.set = py_svcctl_LockServiceDatabase_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_lock"),
		.get = py_svcctl_LockServiceDatabase_out_get_lock,
		.set = py_svcctl_LockServiceDatabase_out_set_lock,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_LockServiceDatabase_get_result,
		.set = py_svcctl_LockServiceDatabase_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_LockServiceDatabase_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_LockServiceDatabase, type);
	struct svcctl_LockServiceDatabase *_self = (struct svcctl_LockServiceDatabase *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.lock = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_LockServiceDatabase_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_LockServiceDatabase_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_LockServiceDatabase_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_LockServiceDatabase_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_LockServiceDatabase_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_LockServiceDatabase_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_LockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_LockServiceDatabase_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[3];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_LockServiceDatabase_ndr_print(py_obj, "svcctl_LockServiceDatabase_in", NDR_IN);
}

static PyObject *py_svcctl_LockServiceDatabase_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_LockServiceDatabase_ndr_print(py_obj, "svcctl_LockServiceDatabase_out", NDR_OUT);
}

static PyMethodDef py_svcctl_LockServiceDatabase_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_LockServiceDatabase_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.LockServiceDatabase.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_LockServiceDatabase_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_LockServiceDatabase_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_LockServiceDatabase_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_LockServiceDatabase_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_LockServiceDatabase_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_LockServiceDatabase_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_LockServiceDatabase_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.LockServiceDatabase",
	.tp_getset = py_svcctl_LockServiceDatabase_getsetters,
	.tp_methods = py_svcctl_LockServiceDatabase_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_LockServiceDatabase_new,
};

static bool pack_py_svcctl_LockServiceDatabase_args_in(PyObject *args, PyObject *kwargs, struct svcctl_LockServiceDatabase *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_LockServiceDatabase", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_LockServiceDatabase_args_out(struct svcctl_LockServiceDatabase *r)
{
	PyObject *result;
	PyObject *py_lock;
	py_lock = pytalloc_reference_ex(policy_handle_Type, r->out.lock, r->out.lock);
	result = py_lock;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_QueryServiceObjectSecurity_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_QueryServiceObjectSecurity_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_in_get_security_flags(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_security_flags;
	py_security_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.security_flags));
	return py_security_flags;
}

static int py_svcctl_QueryServiceObjectSecurity_in_set_security_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.security_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.security_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.security_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_out_get_buffer(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->out.buffer == NULL) {
		Py_RETURN_NONE;
	}
	py_buffer = PyList_New(object->in.offered);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < (object->in.offered); buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyLong_FromLong((uint16_t)((object->out.buffer)[buffer_cntr_1]));
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	return py_buffer;
}

static int py_svcctl_QueryServiceObjectSecurity_out_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.buffer");
		return -1;
	}
	object->out.buffer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.buffer);
	if (object->out.buffer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffer_cntr_1;
		object->out.buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.buffer, PyList_GET_SIZE(value));
		if (!object->out.buffer) { return -1; }
		talloc_set_name_const(object->out.buffer, "ARRAY: object->out.buffer");
		for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
			if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->out.buffer)[buffer_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.buffer)[buffer_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.buffer)[buffer_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_QueryServiceObjectSecurity_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_QueryServiceObjectSecurity_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_get_result(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_QueryServiceObjectSecurity_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_QueryServiceObjectSecurity_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_QueryServiceObjectSecurity_in_get_handle,
		.set = py_svcctl_QueryServiceObjectSecurity_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_security_flags"),
		.get = py_svcctl_QueryServiceObjectSecurity_in_get_security_flags,
		.set = py_svcctl_QueryServiceObjectSecurity_in_set_security_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "out_buffer"),
		.get = py_svcctl_QueryServiceObjectSecurity_out_get_buffer,
		.set = py_svcctl_QueryServiceObjectSecurity_out_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_QueryServiceObjectSecurity_in_get_offered,
		.set = py_svcctl_QueryServiceObjectSecurity_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_QueryServiceObjectSecurity_out_get_needed,
		.set = py_svcctl_QueryServiceObjectSecurity_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_QueryServiceObjectSecurity_get_result,
		.set = py_svcctl_QueryServiceObjectSecurity_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_QueryServiceObjectSecurity_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_QueryServiceObjectSecurity, type);
	struct svcctl_QueryServiceObjectSecurity *_self = (struct svcctl_QueryServiceObjectSecurity *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.buffer = talloc_zero(mem_ctx, uint8_t);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceObjectSecurity_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceObjectSecurity_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceObjectSecurity_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceObjectSecurity_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceObjectSecurity_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceObjectSecurity_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceObjectSecurity_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[4];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceObjectSecurity_ndr_print(py_obj, "svcctl_QueryServiceObjectSecurity_in", NDR_IN);
}

static PyObject *py_svcctl_QueryServiceObjectSecurity_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceObjectSecurity_ndr_print(py_obj, "svcctl_QueryServiceObjectSecurity_out", NDR_OUT);
}

static PyMethodDef py_svcctl_QueryServiceObjectSecurity_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_QueryServiceObjectSecurity_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.QueryServiceObjectSecurity.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceObjectSecurity_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceObjectSecurity_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceObjectSecurity_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceObjectSecurity_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_QueryServiceObjectSecurity_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_QueryServiceObjectSecurity_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_QueryServiceObjectSecurity_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.QueryServiceObjectSecurity",
	.tp_getset = py_svcctl_QueryServiceObjectSecurity_getsetters,
	.tp_methods = py_svcctl_QueryServiceObjectSecurity_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_QueryServiceObjectSecurity_new,
};

static bool pack_py_svcctl_QueryServiceObjectSecurity_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceObjectSecurity *r)
{
	PyObject *py_handle;
	PyObject *py_security_flags;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "security_flags", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_QueryServiceObjectSecurity", discard_const_p(char *, kwnames), &py_handle, &py_security_flags, &py_offered)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_security_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.security_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.security_flags));
		if (PyLong_Check(py_security_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_security_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.security_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceObjectSecurity_args_out(struct svcctl_QueryServiceObjectSecurity *r)
{
	PyObject *result;
	PyObject *py_buffer;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_buffer = PyList_New(r->in.offered);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < (r->in.offered); buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyLong_FromLong((uint16_t)((r->out.buffer)[buffer_cntr_1]));
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	PyTuple_SetItem(result, 0, py_buffer);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_SetServiceObjectSecurity_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_SetServiceObjectSecurity_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_in_get_security_flags(PyObject *obj, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_security_flags;
	py_security_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.security_flags));
	return py_security_flags;
}

static int py_svcctl_SetServiceObjectSecurity_in_set_security_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.security_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.security_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.security_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_in_get_buffer(PyObject *obj, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->in.buffer == NULL) {
		Py_RETURN_NONE;
	}
	py_buffer = PyList_New(object->in.offered);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < (object->in.offered); buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyLong_FromLong((uint16_t)((object->in.buffer)[buffer_cntr_1]));
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	return py_buffer;
}

static int py_svcctl_SetServiceObjectSecurity_in_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.buffer");
		return -1;
	}
	object->in.buffer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.buffer);
	if (object->in.buffer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffer_cntr_1;
		object->in.buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.buffer, PyList_GET_SIZE(value));
		if (!object->in.buffer) { return -1; }
		talloc_set_name_const(object->in.buffer, "ARRAY: object->in.buffer");
		for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
			if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.buffer)[buffer_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.buffer)[buffer_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.buffer)[buffer_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_SetServiceObjectSecurity_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_get_result(PyObject *obj, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_SetServiceObjectSecurity_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_SetServiceObjectSecurity_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_SetServiceObjectSecurity_in_get_handle,
		.set = py_svcctl_SetServiceObjectSecurity_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_security_flags"),
		.get = py_svcctl_SetServiceObjectSecurity_in_get_security_flags,
		.set = py_svcctl_SetServiceObjectSecurity_in_set_security_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "in_buffer"),
		.get = py_svcctl_SetServiceObjectSecurity_in_get_buffer,
		.set = py_svcctl_SetServiceObjectSecurity_in_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_SetServiceObjectSecurity_in_get_offered,
		.set = py_svcctl_SetServiceObjectSecurity_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_SetServiceObjectSecurity_get_result,
		.set = py_svcctl_SetServiceObjectSecurity_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_SetServiceObjectSecurity_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_SetServiceObjectSecurity, type);
	struct svcctl_SetServiceObjectSecurity *_self = (struct svcctl_SetServiceObjectSecurity *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.buffer = talloc_zero(mem_ctx, uint8_t);
	return self;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SetServiceObjectSecurity_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_SetServiceObjectSecurity_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_SetServiceObjectSecurity_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SetServiceObjectSecurity_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_SetServiceObjectSecurity_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_SetServiceObjectSecurity_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SetServiceObjectSecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SetServiceObjectSecurity_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[5];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_SetServiceObjectSecurity_ndr_print(py_obj, "svcctl_SetServiceObjectSecurity_in", NDR_IN);
}

static PyObject *py_svcctl_SetServiceObjectSecurity_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_SetServiceObjectSecurity_ndr_print(py_obj, "svcctl_SetServiceObjectSecurity_out", NDR_OUT);
}

static PyMethodDef py_svcctl_SetServiceObjectSecurity_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_SetServiceObjectSecurity_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.SetServiceObjectSecurity.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SetServiceObjectSecurity_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SetServiceObjectSecurity_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SetServiceObjectSecurity_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SetServiceObjectSecurity_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_SetServiceObjectSecurity_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_SetServiceObjectSecurity_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_SetServiceObjectSecurity_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SetServiceObjectSecurity",
	.tp_getset = py_svcctl_SetServiceObjectSecurity_getsetters,
	.tp_methods = py_svcctl_SetServiceObjectSecurity_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_SetServiceObjectSecurity_new,
};

static bool pack_py_svcctl_SetServiceObjectSecurity_args_in(PyObject *args, PyObject *kwargs, struct svcctl_SetServiceObjectSecurity *r)
{
	PyObject *py_handle;
	PyObject *py_security_flags;
	PyObject *py_buffer;
	const char *kwnames[] = {
		"handle", "security_flags", "buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_SetServiceObjectSecurity", discard_const_p(char *, kwnames), &py_handle, &py_security_flags, &py_buffer)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_security_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.security_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.security_flags));
		if (PyLong_Check(py_security_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_security_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.security_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_buffer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.buffer");
		return false;
	}
	r->in.buffer = talloc_ptrtype(r, r->in.buffer);
	if (r->in.buffer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	{
		int buffer_cntr_1;
		r->in.buffer = talloc_array_ptrtype(r, r->in.buffer, PyList_GET_SIZE(py_buffer));
		if (!r->in.buffer) { return false; }
		talloc_set_name_const(r->in.buffer, "ARRAY: r->in.buffer");
		for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(py_buffer); buffer_cntr_1++) {
			if (PyList_GET_ITEM(py_buffer, buffer_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.buffer)[buffer_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.buffer)[buffer_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_buffer, buffer_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_buffer, buffer_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.buffer)[buffer_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	r->in.offered = PyList_GET_SIZE(py_buffer);
	return true;
}

static PyObject *unpack_py_svcctl_SetServiceObjectSecurity_args_out(struct svcctl_SetServiceObjectSecurity *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_QueryServiceStatus_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_QueryServiceStatus_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceStatus_out_get_service_status(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(obj);
	PyObject *py_service_status;
	if (object->out.service_status == NULL) {
		Py_RETURN_NONE;
	}
	py_service_status = pytalloc_reference_ex(&SERVICE_STATUS_Type, object->out.service_status, object->out.service_status);
	return py_service_status;
}

static int py_svcctl_QueryServiceStatus_out_set_service_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.service_status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.service_status");
		return -1;
	}
	object->out.service_status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.service_status);
	if (object->out.service_status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.service_status = (struct SERVICE_STATUS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceStatus_get_result(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_QueryServiceStatus_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_QueryServiceStatus_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_QueryServiceStatus_in_get_handle,
		.set = py_svcctl_QueryServiceStatus_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_service_status"),
		.get = py_svcctl_QueryServiceStatus_out_get_service_status,
		.set = py_svcctl_QueryServiceStatus_out_set_service_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_STATUS")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_QueryServiceStatus_get_result,
		.set = py_svcctl_QueryServiceStatus_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_QueryServiceStatus_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_QueryServiceStatus, type);
	struct svcctl_QueryServiceStatus *_self = (struct svcctl_QueryServiceStatus *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.service_status = talloc_zero(mem_ctx, struct SERVICE_STATUS);
	return self;
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceStatus_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceStatus_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceStatus_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceStatus_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceStatus_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceStatus_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceStatus *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceStatus_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[6];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceStatus_ndr_print(py_obj, "svcctl_QueryServiceStatus_in", NDR_IN);
}

static PyObject *py_svcctl_QueryServiceStatus_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceStatus_ndr_print(py_obj, "svcctl_QueryServiceStatus_out", NDR_OUT);
}

static PyMethodDef py_svcctl_QueryServiceStatus_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_QueryServiceStatus_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.QueryServiceStatus.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceStatus_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceStatus_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceStatus_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceStatus_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_QueryServiceStatus_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_QueryServiceStatus_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_QueryServiceStatus_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.QueryServiceStatus",
	.tp_getset = py_svcctl_QueryServiceStatus_getsetters,
	.tp_methods = py_svcctl_QueryServiceStatus_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_QueryServiceStatus_new,
};

static bool pack_py_svcctl_QueryServiceStatus_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceStatus *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_QueryServiceStatus", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceStatus_args_out(struct svcctl_QueryServiceStatus *r)
{
	PyObject *result;
	PyObject *py_service_status;
	py_service_status = pytalloc_reference_ex(&SERVICE_STATUS_Type, r->out.service_status, r->out.service_status);
	result = py_service_status;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_UnlockServiceDatabase_in_get_lock(PyObject *obj, void *closure)
{
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(obj);
	PyObject *py_lock;
	if (object->in.lock == NULL) {
		Py_RETURN_NONE;
	}
	py_lock = pytalloc_reference_ex(policy_handle_Type, object->in.lock, object->in.lock);
	return py_lock;
}

static int py_svcctl_UnlockServiceDatabase_in_set_lock(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.lock));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.lock");
		return -1;
	}
	object->in.lock = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.lock);
	if (object->in.lock == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.lock = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_UnlockServiceDatabase_out_get_lock(PyObject *obj, void *closure)
{
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(obj);
	PyObject *py_lock;
	if (object->out.lock == NULL) {
		Py_RETURN_NONE;
	}
	py_lock = pytalloc_reference_ex(policy_handle_Type, object->out.lock, object->out.lock);
	return py_lock;
}

static int py_svcctl_UnlockServiceDatabase_out_set_lock(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.lock));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.lock");
		return -1;
	}
	object->out.lock = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.lock);
	if (object->out.lock == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.lock = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_UnlockServiceDatabase_get_result(PyObject *obj, void *closure)
{
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_UnlockServiceDatabase_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_UnlockServiceDatabase_getsetters[] = {
	{
		.name = discard_const_p(char, "in_lock"),
		.get = py_svcctl_UnlockServiceDatabase_in_get_lock,
		.set = py_svcctl_UnlockServiceDatabase_in_set_lock,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_lock"),
		.get = py_svcctl_UnlockServiceDatabase_out_get_lock,
		.set = py_svcctl_UnlockServiceDatabase_out_set_lock,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_UnlockServiceDatabase_get_result,
		.set = py_svcctl_UnlockServiceDatabase_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_UnlockServiceDatabase_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_UnlockServiceDatabase, type);
	struct svcctl_UnlockServiceDatabase *_self = (struct svcctl_UnlockServiceDatabase *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.lock = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.lock = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_UnlockServiceDatabase_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_UnlockServiceDatabase_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_UnlockServiceDatabase_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_UnlockServiceDatabase_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_UnlockServiceDatabase_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_UnlockServiceDatabase_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_UnlockServiceDatabase *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_UnlockServiceDatabase_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[8];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_UnlockServiceDatabase_ndr_print(py_obj, "svcctl_UnlockServiceDatabase_in", NDR_IN);
}

static PyObject *py_svcctl_UnlockServiceDatabase_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_UnlockServiceDatabase_ndr_print(py_obj, "svcctl_UnlockServiceDatabase_out", NDR_OUT);
}

static PyMethodDef py_svcctl_UnlockServiceDatabase_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_UnlockServiceDatabase_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.UnlockServiceDatabase.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_UnlockServiceDatabase_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_UnlockServiceDatabase_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_UnlockServiceDatabase_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_UnlockServiceDatabase_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_UnlockServiceDatabase_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_UnlockServiceDatabase_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_UnlockServiceDatabase_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.UnlockServiceDatabase",
	.tp_getset = py_svcctl_UnlockServiceDatabase_getsetters,
	.tp_methods = py_svcctl_UnlockServiceDatabase_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_UnlockServiceDatabase_new,
};

static bool pack_py_svcctl_UnlockServiceDatabase_args_in(PyObject *args, PyObject *kwargs, struct svcctl_UnlockServiceDatabase *r)
{
	PyObject *py_lock;
	const char *kwnames[] = {
		"lock", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_UnlockServiceDatabase", discard_const_p(char *, kwnames), &py_lock)) {
		return false;
	}

	if (py_lock == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.lock");
		return false;
	}
	r->in.lock = talloc_ptrtype(r, r->in.lock);
	if (r->in.lock == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_lock, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_lock)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.lock = (struct policy_handle *)pytalloc_get_ptr(py_lock);
	return true;
}

static PyObject *unpack_py_svcctl_UnlockServiceDatabase_args_out(struct svcctl_UnlockServiceDatabase *r)
{
	PyObject *result;
	PyObject *py_lock;
	py_lock = pytalloc_reference_ex(policy_handle_Type, r->out.lock, r->out.lock);
	result = py_lock;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_SCSetServiceBitsW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_SCSetServiceBitsW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsW_in_get_bits(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(obj);
	PyObject *py_bits;
	py_bits = PyLong_FromUnsignedLongLong((uint32_t)(object->in.bits));
	return py_bits;
}

static int py_svcctl_SCSetServiceBitsW_in_set_bits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.bits");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.bits));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.bits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsW_in_get_bitson(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(obj);
	PyObject *py_bitson;
	py_bitson = PyLong_FromUnsignedLongLong((uint32_t)(object->in.bitson));
	return py_bitson;
}

static int py_svcctl_SCSetServiceBitsW_in_set_bitson(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.bitson");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.bitson));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.bitson = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsW_in_get_immediate(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(obj);
	PyObject *py_immediate;
	py_immediate = PyLong_FromUnsignedLongLong((uint32_t)(object->in.immediate));
	return py_immediate;
}

static int py_svcctl_SCSetServiceBitsW_in_set_immediate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.immediate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.immediate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.immediate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_SCSetServiceBitsW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_SCSetServiceBitsW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_SCSetServiceBitsW_in_get_handle,
		.set = py_svcctl_SCSetServiceBitsW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_bits"),
		.get = py_svcctl_SCSetServiceBitsW_in_get_bits,
		.set = py_svcctl_SCSetServiceBitsW_in_set_bits,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_bitson"),
		.get = py_svcctl_SCSetServiceBitsW_in_get_bitson,
		.set = py_svcctl_SCSetServiceBitsW_in_set_bitson,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_immediate"),
		.get = py_svcctl_SCSetServiceBitsW_in_get_immediate,
		.set = py_svcctl_SCSetServiceBitsW_in_set_immediate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_SCSetServiceBitsW_get_result,
		.set = py_svcctl_SCSetServiceBitsW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_SCSetServiceBitsW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_SCSetServiceBitsW, type);
	struct svcctl_SCSetServiceBitsW *_self = (struct svcctl_SCSetServiceBitsW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SCSetServiceBitsW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_SCSetServiceBitsW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_SCSetServiceBitsW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SCSetServiceBitsW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_SCSetServiceBitsW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_SCSetServiceBitsW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SCSetServiceBitsW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SCSetServiceBitsW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[10];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_SCSetServiceBitsW_ndr_print(py_obj, "svcctl_SCSetServiceBitsW_in", NDR_IN);
}

static PyObject *py_svcctl_SCSetServiceBitsW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_SCSetServiceBitsW_ndr_print(py_obj, "svcctl_SCSetServiceBitsW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_SCSetServiceBitsW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_SCSetServiceBitsW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.SCSetServiceBitsW.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_SCSetServiceBitsW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_SCSetServiceBitsW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_SCSetServiceBitsW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SCSetServiceBitsW",
	.tp_getset = py_svcctl_SCSetServiceBitsW_getsetters,
	.tp_methods = py_svcctl_SCSetServiceBitsW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_SCSetServiceBitsW_new,
};

static bool pack_py_svcctl_SCSetServiceBitsW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_SCSetServiceBitsW *r)
{
	PyObject *py_handle;
	PyObject *py_bits;
	PyObject *py_bitson;
	PyObject *py_immediate;
	const char *kwnames[] = {
		"handle", "bits", "bitson", "immediate", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:svcctl_SCSetServiceBitsW", discard_const_p(char *, kwnames), &py_handle, &py_bits, &py_bitson, &py_immediate)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_bits == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.bits");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.bits));
		if (PyLong_Check(py_bits)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_bits);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.bits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_bitson == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.bitson");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.bitson));
		if (PyLong_Check(py_bitson)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_bitson);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.bitson = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_immediate == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.immediate");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.immediate));
		if (PyLong_Check(py_immediate)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_immediate);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.immediate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_SCSetServiceBitsW_args_out(struct svcctl_SCSetServiceBitsW *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_ChangeServiceConfigW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_ChangeServiceConfigW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_type(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.type));
	return py_type;
}

static int py_svcctl_ChangeServiceConfigW_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_start_type(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_start_type;
	py_start_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.start_type));
	return py_start_type;
}

static int py_svcctl_ChangeServiceConfigW_in_set_start_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.start_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.start_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_error_control(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_error_control;
	py_error_control = PyLong_FromUnsignedLongLong((uint32_t)(object->in.error_control));
	return py_error_control;
}

static int py_svcctl_ChangeServiceConfigW_in_set_error_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.error_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.error_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_binary_path(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_binary_path;
	if (object->in.binary_path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.binary_path == NULL) {
		py_binary_path = Py_None;
		Py_INCREF(py_binary_path);
	} else {
		if (object->in.binary_path == NULL) {
			py_binary_path = Py_None;
			Py_INCREF(py_binary_path);
		} else {
			py_binary_path = PyUnicode_Decode(object->in.binary_path, strlen(object->in.binary_path), "utf-8", "ignore");
		}
	}
	return py_binary_path;
}

static int py_svcctl_ChangeServiceConfigW_in_set_binary_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.binary_path");
		return -1;
	}
	if (value == Py_None) {
		object->in.binary_path = NULL;
	} else {
		object->in.binary_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.binary_path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_load_order_group(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_load_order_group;
	if (object->in.load_order_group == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.load_order_group == NULL) {
		py_load_order_group = Py_None;
		Py_INCREF(py_load_order_group);
	} else {
		if (object->in.load_order_group == NULL) {
			py_load_order_group = Py_None;
			Py_INCREF(py_load_order_group);
		} else {
			py_load_order_group = PyUnicode_Decode(object->in.load_order_group, strlen(object->in.load_order_group), "utf-8", "ignore");
		}
	}
	return py_load_order_group;
}

static int py_svcctl_ChangeServiceConfigW_in_set_load_order_group(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.load_order_group");
		return -1;
	}
	if (value == Py_None) {
		object->in.load_order_group = NULL;
	} else {
		object->in.load_order_group = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.load_order_group = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_tag_id(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_tag_id;
	if (object->in.tag_id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.tag_id == NULL) {
		py_tag_id = Py_None;
		Py_INCREF(py_tag_id);
	} else {
		py_tag_id = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.tag_id));
	}
	return py_tag_id;
}

static int py_svcctl_ChangeServiceConfigW_in_set_tag_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.tag_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.tag_id");
		return -1;
	}
	if (value == Py_None) {
		object->in.tag_id = NULL;
	} else {
		object->in.tag_id = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.tag_id);
		if (object->in.tag_id == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.tag_id));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.tag_id = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_out_get_tag_id(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_tag_id;
	if (object->out.tag_id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.tag_id == NULL) {
		py_tag_id = Py_None;
		Py_INCREF(py_tag_id);
	} else {
		py_tag_id = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.tag_id));
	}
	return py_tag_id;
}

static int py_svcctl_ChangeServiceConfigW_out_set_tag_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.tag_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.tag_id");
		return -1;
	}
	if (value == Py_None) {
		object->out.tag_id = NULL;
	} else {
		object->out.tag_id = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.tag_id);
		if (object->out.tag_id == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.tag_id));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.tag_id = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_dependencies(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_dependencies;
	if (object->in.dependencies == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.dependencies == NULL) {
		py_dependencies = Py_None;
		Py_INCREF(py_dependencies);
	} else {
		if (object->in.dependencies == NULL) {
			py_dependencies = Py_None;
			Py_INCREF(py_dependencies);
		} else {
			py_dependencies = PyUnicode_Decode(object->in.dependencies, strlen(object->in.dependencies), "utf-8", "ignore");
		}
	}
	return py_dependencies;
}

static int py_svcctl_ChangeServiceConfigW_in_set_dependencies(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.dependencies");
		return -1;
	}
	if (value == Py_None) {
		object->in.dependencies = NULL;
	} else {
		object->in.dependencies = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.dependencies = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_dwDependSize(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDependSize;
	py_dwDependSize = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwDependSize));
	return py_dwDependSize;
}

static int py_svcctl_ChangeServiceConfigW_in_set_dwDependSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.dwDependSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwDependSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwDependSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_service_start_name(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_service_start_name;
	if (object->in.service_start_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_start_name == NULL) {
		py_service_start_name = Py_None;
		Py_INCREF(py_service_start_name);
	} else {
		if (object->in.service_start_name == NULL) {
			py_service_start_name = Py_None;
			Py_INCREF(py_service_start_name);
		} else {
			py_service_start_name = PyUnicode_Decode(object->in.service_start_name, strlen(object->in.service_start_name), "utf-8", "ignore");
		}
	}
	return py_service_start_name;
}

static int py_svcctl_ChangeServiceConfigW_in_set_service_start_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_start_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_start_name = NULL;
	} else {
		object->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_start_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_password(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->in.password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->in.password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->in.password, strlen(object->in.password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_svcctl_ChangeServiceConfigW_in_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password");
		return -1;
	}
	if (value == Py_None) {
		object->in.password = NULL;
	} else {
		object->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_dwPwSize(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_dwPwSize;
	py_dwPwSize = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwPwSize));
	return py_dwPwSize;
}

static int py_svcctl_ChangeServiceConfigW_in_set_dwPwSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.dwPwSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwPwSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwPwSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_in_get_display_name(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name;
	if (object->in.display_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		if (object->in.display_name == NULL) {
			py_display_name = Py_None;
			Py_INCREF(py_display_name);
		} else {
			py_display_name = PyUnicode_Decode(object->in.display_name, strlen(object->in.display_name), "utf-8", "ignore");
		}
	}
	return py_display_name;
}

static int py_svcctl_ChangeServiceConfigW_in_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.display_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.display_name = NULL;
	} else {
		object->in.display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.display_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_ChangeServiceConfigW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_ChangeServiceConfigW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_handle,
		.set = py_svcctl_ChangeServiceConfigW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_type,
		.set = py_svcctl_ChangeServiceConfigW_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_start_type"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_start_type,
		.set = py_svcctl_ChangeServiceConfigW_in_set_start_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_StartType")
	},
	{
		.name = discard_const_p(char, "in_error_control"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_error_control,
		.set = py_svcctl_ChangeServiceConfigW_in_set_error_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ErrorControl")
	},
	{
		.name = discard_const_p(char, "in_binary_path"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_binary_path,
		.set = py_svcctl_ChangeServiceConfigW_in_set_binary_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_load_order_group"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_load_order_group,
		.set = py_svcctl_ChangeServiceConfigW_in_set_load_order_group,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_tag_id"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_tag_id,
		.set = py_svcctl_ChangeServiceConfigW_in_set_tag_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_tag_id"),
		.get = py_svcctl_ChangeServiceConfigW_out_get_tag_id,
		.set = py_svcctl_ChangeServiceConfigW_out_set_tag_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dependencies"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_dependencies,
		.set = py_svcctl_ChangeServiceConfigW_in_set_dependencies,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_dwDependSize"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_dwDependSize,
		.set = py_svcctl_ChangeServiceConfigW_in_set_dwDependSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_service_start_name"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_service_start_name,
		.set = py_svcctl_ChangeServiceConfigW_in_set_service_start_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_password"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_password,
		.set = py_svcctl_ChangeServiceConfigW_in_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_dwPwSize"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_dwPwSize,
		.set = py_svcctl_ChangeServiceConfigW_in_set_dwPwSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_display_name"),
		.get = py_svcctl_ChangeServiceConfigW_in_get_display_name,
		.set = py_svcctl_ChangeServiceConfigW_in_set_display_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_ChangeServiceConfigW_get_result,
		.set = py_svcctl_ChangeServiceConfigW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_ChangeServiceConfigW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_ChangeServiceConfigW, type);
	struct svcctl_ChangeServiceConfigW *_self = (struct svcctl_ChangeServiceConfigW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfigW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ChangeServiceConfigW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ChangeServiceConfigW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfigW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ChangeServiceConfigW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ChangeServiceConfigW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfigW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfigW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[11];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ChangeServiceConfigW_ndr_print(py_obj, "svcctl_ChangeServiceConfigW_in", NDR_IN);
}

static PyObject *py_svcctl_ChangeServiceConfigW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ChangeServiceConfigW_ndr_print(py_obj, "svcctl_ChangeServiceConfigW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_ChangeServiceConfigW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_ChangeServiceConfigW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.ChangeServiceConfigW.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_ChangeServiceConfigW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_ChangeServiceConfigW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_ChangeServiceConfigW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.ChangeServiceConfigW",
	.tp_getset = py_svcctl_ChangeServiceConfigW_getsetters,
	.tp_methods = py_svcctl_ChangeServiceConfigW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_ChangeServiceConfigW_new,
};

static bool pack_py_svcctl_ChangeServiceConfigW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ChangeServiceConfigW *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_load_order_group;
	PyObject *py_tag_id;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	PyObject *py_display_name;
	const char *kwnames[] = {
		"handle", "type", "start_type", "error_control", "binary_path", "load_order_group", "tag_id", "dependencies", "service_start_name", "password", "display_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOO:svcctl_ChangeServiceConfigW", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_load_order_group, &py_tag_id, &py_dependencies, &py_service_start_name, &py_password, &py_display_name)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_start_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.start_type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.start_type));
		if (PyLong_Check(py_start_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_start_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_error_control == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.error_control");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.error_control));
		if (PyLong_Check(py_error_control)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_error_control);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_binary_path == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.binary_path");
		return false;
	}
	if (py_binary_path == Py_None) {
		r->in.binary_path = NULL;
	} else {
		r->in.binary_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_binary_path)) {
				unicode = PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_binary_path)) {
				test_str = PyBytes_AS_STRING(py_binary_path);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_binary_path)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.binary_path = talloc_str;
		}
	}
	if (py_load_order_group == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.load_order_group");
		return false;
	}
	if (py_load_order_group == Py_None) {
		r->in.load_order_group = NULL;
	} else {
		r->in.load_order_group = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_load_order_group)) {
				unicode = PyUnicode_AsEncodedString(py_load_order_group, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_load_order_group)) {
				test_str = PyBytes_AS_STRING(py_load_order_group);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_load_order_group)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.load_order_group = talloc_str;
		}
	}
	if (py_tag_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.tag_id");
		return false;
	}
	if (py_tag_id == Py_None) {
		r->in.tag_id = NULL;
	} else {
		r->in.tag_id = talloc_ptrtype(r, r->in.tag_id);
		if (r->in.tag_id == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.tag_id));
			if (PyLong_Check(py_tag_id)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_tag_id);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.tag_id = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_dependencies == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.dependencies");
		return false;
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_dependencies)) {
				unicode = PyUnicode_AsEncodedString(py_dependencies, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_dependencies)) {
				test_str = PyBytes_AS_STRING(py_dependencies);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_dependencies)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.dependencies = talloc_str;
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_dependencies, return false;);
	r->in.dwDependSize = PyList_GET_SIZE(py_dependencies);
	if (py_service_start_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_start_name");
		return false;
	}
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_start_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_start_name)) {
				test_str = PyBytes_AS_STRING(py_service_start_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_start_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_start_name = talloc_str;
		}
	}
	if (py_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.password");
		return false;
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_password)) {
				unicode = PyUnicode_AsEncodedString(py_password, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_password)) {
				test_str = PyBytes_AS_STRING(py_password);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_password)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.password = talloc_str;
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_password, return false;);
	r->in.dwPwSize = PyList_GET_SIZE(py_password);
	if (py_display_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.display_name");
		return false;
	}
	if (py_display_name == Py_None) {
		r->in.display_name = NULL;
	} else {
		r->in.display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_display_name)) {
				unicode = PyUnicode_AsEncodedString(py_display_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_display_name)) {
				test_str = PyBytes_AS_STRING(py_display_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_display_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.display_name = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_ChangeServiceConfigW_args_out(struct svcctl_ChangeServiceConfigW *r)
{
	PyObject *result;
	PyObject *py_tag_id;
	if (r->out.tag_id == NULL) {
		py_tag_id = Py_None;
		Py_INCREF(py_tag_id);
	} else {
		py_tag_id = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.tag_id));
	}
	result = py_tag_id;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_CreateServiceW_in_get_scmanager_handle(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_scmanager_handle;
	if (object->in.scmanager_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_scmanager_handle = pytalloc_reference_ex(policy_handle_Type, object->in.scmanager_handle, object->in.scmanager_handle);
	return py_scmanager_handle;
}

static int py_svcctl_CreateServiceW_in_set_scmanager_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.scmanager_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.scmanager_handle");
		return -1;
	}
	object->in.scmanager_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.scmanager_handle);
	if (object->in.scmanager_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.scmanager_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_ServiceName(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_ServiceName;
	if (object->in.ServiceName == NULL) {
		py_ServiceName = Py_None;
		Py_INCREF(py_ServiceName);
	} else {
		py_ServiceName = PyUnicode_Decode(object->in.ServiceName, strlen(object->in.ServiceName), "utf-8", "ignore");
	}
	return py_ServiceName;
}

static int py_svcctl_CreateServiceW_in_set_ServiceName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ServiceName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.ServiceName = talloc_str;
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_DisplayName(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_DisplayName;
	if (object->in.DisplayName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.DisplayName == NULL) {
		py_DisplayName = Py_None;
		Py_INCREF(py_DisplayName);
	} else {
		if (object->in.DisplayName == NULL) {
			py_DisplayName = Py_None;
			Py_INCREF(py_DisplayName);
		} else {
			py_DisplayName = PyUnicode_Decode(object->in.DisplayName, strlen(object->in.DisplayName), "utf-8", "ignore");
		}
	}
	return py_DisplayName;
}

static int py_svcctl_CreateServiceW_in_set_DisplayName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.DisplayName");
		return -1;
	}
	if (value == Py_None) {
		object->in.DisplayName = NULL;
	} else {
		object->in.DisplayName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.DisplayName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_desired_access(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_desired_access;
	py_desired_access = PyLong_FromUnsignedLongLong((uint32_t)(object->in.desired_access));
	return py_desired_access;
}

static int py_svcctl_CreateServiceW_in_set_desired_access(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.desired_access");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.desired_access));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.desired_access = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_type(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.type));
	return py_type;
}

static int py_svcctl_CreateServiceW_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_start_type(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_start_type;
	py_start_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.start_type));
	return py_start_type;
}

static int py_svcctl_CreateServiceW_in_set_start_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.start_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.start_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_error_control(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_error_control;
	py_error_control = PyLong_FromUnsignedLongLong((uint32_t)(object->in.error_control));
	return py_error_control;
}

static int py_svcctl_CreateServiceW_in_set_error_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.error_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.error_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_binary_path(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_binary_path;
	if (object->in.binary_path == NULL) {
		py_binary_path = Py_None;
		Py_INCREF(py_binary_path);
	} else {
		py_binary_path = PyUnicode_Decode(object->in.binary_path, strlen(object->in.binary_path), "utf-8", "ignore");
	}
	return py_binary_path;
}

static int py_svcctl_CreateServiceW_in_set_binary_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.binary_path");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.binary_path = talloc_str;
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_LoadOrderGroupKey(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_LoadOrderGroupKey;
	if (object->in.LoadOrderGroupKey == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.LoadOrderGroupKey == NULL) {
		py_LoadOrderGroupKey = Py_None;
		Py_INCREF(py_LoadOrderGroupKey);
	} else {
		if (object->in.LoadOrderGroupKey == NULL) {
			py_LoadOrderGroupKey = Py_None;
			Py_INCREF(py_LoadOrderGroupKey);
		} else {
			py_LoadOrderGroupKey = PyUnicode_Decode(object->in.LoadOrderGroupKey, strlen(object->in.LoadOrderGroupKey), "utf-8", "ignore");
		}
	}
	return py_LoadOrderGroupKey;
}

static int py_svcctl_CreateServiceW_in_set_LoadOrderGroupKey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.LoadOrderGroupKey");
		return -1;
	}
	if (value == Py_None) {
		object->in.LoadOrderGroupKey = NULL;
	} else {
		object->in.LoadOrderGroupKey = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.LoadOrderGroupKey = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_TagId(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_TagId;
	if (object->in.TagId == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.TagId == NULL) {
		py_TagId = Py_None;
		Py_INCREF(py_TagId);
	} else {
		py_TagId = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.TagId));
	}
	return py_TagId;
}

static int py_svcctl_CreateServiceW_in_set_TagId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.TagId));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.TagId");
		return -1;
	}
	if (value == Py_None) {
		object->in.TagId = NULL;
	} else {
		object->in.TagId = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.TagId);
		if (object->in.TagId == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.TagId));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.TagId = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_out_get_TagId(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_TagId;
	if (object->out.TagId == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.TagId == NULL) {
		py_TagId = Py_None;
		Py_INCREF(py_TagId);
	} else {
		py_TagId = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.TagId));
	}
	return py_TagId;
}

static int py_svcctl_CreateServiceW_out_set_TagId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.TagId));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.TagId");
		return -1;
	}
	if (value == Py_None) {
		object->out.TagId = NULL;
	} else {
		object->out.TagId = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.TagId);
		if (object->out.TagId == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.TagId));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.TagId = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_dependencies(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_dependencies;
	if (object->in.dependencies == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.dependencies == NULL) {
		py_dependencies = Py_None;
		Py_INCREF(py_dependencies);
	} else {
		py_dependencies = PyList_New(object->in.dependencies_size);
		if (py_dependencies == NULL) {
			return NULL;
		}
		{
			int dependencies_cntr_1;
			for (dependencies_cntr_1 = 0; dependencies_cntr_1 < (object->in.dependencies_size); dependencies_cntr_1++) {
				PyObject *py_dependencies_1;
				py_dependencies_1 = PyLong_FromLong((uint16_t)((object->in.dependencies)[dependencies_cntr_1]));
				PyList_SetItem(py_dependencies, dependencies_cntr_1, py_dependencies_1);
			}
		}
	}
	return py_dependencies;
}

static int py_svcctl_CreateServiceW_in_set_dependencies(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.dependencies));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.dependencies");
		return -1;
	}
	if (value == Py_None) {
		object->in.dependencies = NULL;
	} else {
		object->in.dependencies = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int dependencies_cntr_1;
			object->in.dependencies = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.dependencies, PyList_GET_SIZE(value));
			if (!object->in.dependencies) { return -1; }
			talloc_set_name_const(object->in.dependencies, "ARRAY: object->in.dependencies");
			for (dependencies_cntr_1 = 0; dependencies_cntr_1 < PyList_GET_SIZE(value); dependencies_cntr_1++) {
				if (PyList_GET_ITEM(value, dependencies_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.dependencies)[dependencies_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.dependencies)[dependencies_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, dependencies_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, dependencies_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.dependencies)[dependencies_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_dependencies_size(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_dependencies_size;
	py_dependencies_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dependencies_size));
	return py_dependencies_size;
}

static int py_svcctl_CreateServiceW_in_set_dependencies_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.dependencies_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dependencies_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dependencies_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_service_start_name(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_service_start_name;
	if (object->in.service_start_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_start_name == NULL) {
		py_service_start_name = Py_None;
		Py_INCREF(py_service_start_name);
	} else {
		if (object->in.service_start_name == NULL) {
			py_service_start_name = Py_None;
			Py_INCREF(py_service_start_name);
		} else {
			py_service_start_name = PyUnicode_Decode(object->in.service_start_name, strlen(object->in.service_start_name), "utf-8", "ignore");
		}
	}
	return py_service_start_name;
}

static int py_svcctl_CreateServiceW_in_set_service_start_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_start_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_start_name = NULL;
	} else {
		object->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_start_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_password(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->in.password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		py_password = PyList_New(object->in.password_size);
		if (py_password == NULL) {
			return NULL;
		}
		{
			int password_cntr_1;
			for (password_cntr_1 = 0; password_cntr_1 < (object->in.password_size); password_cntr_1++) {
				PyObject *py_password_1;
				py_password_1 = PyLong_FromLong((uint16_t)((object->in.password)[password_cntr_1]));
				PyList_SetItem(py_password, password_cntr_1, py_password_1);
			}
		}
	}
	return py_password;
}

static int py_svcctl_CreateServiceW_in_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.password));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password");
		return -1;
	}
	if (value == Py_None) {
		object->in.password = NULL;
	} else {
		object->in.password = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int password_cntr_1;
			object->in.password = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.password, PyList_GET_SIZE(value));
			if (!object->in.password) { return -1; }
			talloc_set_name_const(object->in.password, "ARRAY: object->in.password");
			for (password_cntr_1 = 0; password_cntr_1 < PyList_GET_SIZE(value); password_cntr_1++) {
				if (PyList_GET_ITEM(value, password_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.password)[password_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.password)[password_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, password_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, password_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.password)[password_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_in_get_password_size(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_password_size;
	py_password_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.password_size));
	return py_password_size;
}

static int py_svcctl_CreateServiceW_in_set_password_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.password_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.password_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_out_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_svcctl_CreateServiceW_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_CreateServiceW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_CreateServiceW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_CreateServiceW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_scmanager_handle"),
		.get = py_svcctl_CreateServiceW_in_get_scmanager_handle,
		.set = py_svcctl_CreateServiceW_in_set_scmanager_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_ServiceName"),
		.get = py_svcctl_CreateServiceW_in_get_ServiceName,
		.set = py_svcctl_CreateServiceW_in_set_ServiceName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_DisplayName"),
		.get = py_svcctl_CreateServiceW_in_get_DisplayName,
		.set = py_svcctl_CreateServiceW_in_set_DisplayName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_desired_access"),
		.get = py_svcctl_CreateServiceW_in_get_desired_access,
		.set = py_svcctl_CreateServiceW_in_set_desired_access,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_svcctl_CreateServiceW_in_get_type,
		.set = py_svcctl_CreateServiceW_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_start_type"),
		.get = py_svcctl_CreateServiceW_in_get_start_type,
		.set = py_svcctl_CreateServiceW_in_set_start_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_StartType")
	},
	{
		.name = discard_const_p(char, "in_error_control"),
		.get = py_svcctl_CreateServiceW_in_get_error_control,
		.set = py_svcctl_CreateServiceW_in_set_error_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ErrorControl")
	},
	{
		.name = discard_const_p(char, "in_binary_path"),
		.get = py_svcctl_CreateServiceW_in_get_binary_path,
		.set = py_svcctl_CreateServiceW_in_set_binary_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_LoadOrderGroupKey"),
		.get = py_svcctl_CreateServiceW_in_get_LoadOrderGroupKey,
		.set = py_svcctl_CreateServiceW_in_set_LoadOrderGroupKey,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_TagId"),
		.get = py_svcctl_CreateServiceW_in_get_TagId,
		.set = py_svcctl_CreateServiceW_in_set_TagId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_TagId"),
		.get = py_svcctl_CreateServiceW_out_get_TagId,
		.set = py_svcctl_CreateServiceW_out_set_TagId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dependencies"),
		.get = py_svcctl_CreateServiceW_in_get_dependencies,
		.set = py_svcctl_CreateServiceW_in_set_dependencies,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_dependencies_size"),
		.get = py_svcctl_CreateServiceW_in_get_dependencies_size,
		.set = py_svcctl_CreateServiceW_in_set_dependencies_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_service_start_name"),
		.get = py_svcctl_CreateServiceW_in_get_service_start_name,
		.set = py_svcctl_CreateServiceW_in_set_service_start_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_password"),
		.get = py_svcctl_CreateServiceW_in_get_password,
		.set = py_svcctl_CreateServiceW_in_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_password_size"),
		.get = py_svcctl_CreateServiceW_in_get_password_size,
		.set = py_svcctl_CreateServiceW_in_set_password_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_svcctl_CreateServiceW_out_get_handle,
		.set = py_svcctl_CreateServiceW_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_CreateServiceW_get_result,
		.set = py_svcctl_CreateServiceW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_CreateServiceW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_CreateServiceW, type);
	struct svcctl_CreateServiceW *_self = (struct svcctl_CreateServiceW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.scmanager_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_CreateServiceW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_svcctl_CreateServiceW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CreateServiceW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_CreateServiceW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_CreateServiceW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_CreateServiceW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_CreateServiceW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_CreateServiceW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CreateServiceW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_CreateServiceW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_CreateServiceW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_CreateServiceW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_CreateServiceW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_CreateServiceW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CreateServiceW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CreateServiceW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[12];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_CreateServiceW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_CreateServiceW_ndr_print(py_obj, "svcctl_CreateServiceW_in", NDR_IN);
}

static PyObject *py_svcctl_CreateServiceW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_CreateServiceW_ndr_print(py_obj, "svcctl_CreateServiceW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_CreateServiceW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_CreateServiceW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.CreateServiceW.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_CreateServiceW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_CreateServiceW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_CreateServiceW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.CreateServiceW",
	.tp_getset = py_svcctl_CreateServiceW_getsetters,
	.tp_methods = py_svcctl_CreateServiceW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_CreateServiceW_new,
};

static bool pack_py_svcctl_CreateServiceW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_CreateServiceW *r)
{
	PyObject *py_scmanager_handle;
	PyObject *py_ServiceName;
	PyObject *py_DisplayName;
	PyObject *py_desired_access;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_LoadOrderGroupKey;
	PyObject *py_TagId;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	const char *kwnames[] = {
		"scmanager_handle", "ServiceName", "DisplayName", "desired_access", "type", "start_type", "error_control", "binary_path", "LoadOrderGroupKey", "TagId", "dependencies", "service_start_name", "password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOOO:svcctl_CreateServiceW", discard_const_p(char *, kwnames), &py_scmanager_handle, &py_ServiceName, &py_DisplayName, &py_desired_access, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_LoadOrderGroupKey, &py_TagId, &py_dependencies, &py_service_start_name, &py_password)) {
		return false;
	}

	if (py_scmanager_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.scmanager_handle");
		return false;
	}
	r->in.scmanager_handle = talloc_ptrtype(r, r->in.scmanager_handle);
	if (r->in.scmanager_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_scmanager_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.scmanager_handle = (struct policy_handle *)pytalloc_get_ptr(py_scmanager_handle);
	if (py_ServiceName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ServiceName");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_ServiceName)) {
			unicode = PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_ServiceName)) {
			test_str = PyBytes_AS_STRING(py_ServiceName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ServiceName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.ServiceName = talloc_str;
	}
	if (py_DisplayName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.DisplayName");
		return false;
	}
	if (py_DisplayName == Py_None) {
		r->in.DisplayName = NULL;
	} else {
		r->in.DisplayName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_DisplayName)) {
				unicode = PyUnicode_AsEncodedString(py_DisplayName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_DisplayName)) {
				test_str = PyBytes_AS_STRING(py_DisplayName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_DisplayName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.DisplayName = talloc_str;
		}
	}
	if (py_desired_access == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.desired_access");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.desired_access));
		if (PyLong_Check(py_desired_access)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_desired_access);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.desired_access = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_start_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.start_type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.start_type));
		if (PyLong_Check(py_start_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_start_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_error_control == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.error_control");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.error_control));
		if (PyLong_Check(py_error_control)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_error_control);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_binary_path == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.binary_path");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_binary_path)) {
			unicode = PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_binary_path)) {
			test_str = PyBytes_AS_STRING(py_binary_path);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_binary_path)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.binary_path = talloc_str;
	}
	if (py_LoadOrderGroupKey == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.LoadOrderGroupKey");
		return false;
	}
	if (py_LoadOrderGroupKey == Py_None) {
		r->in.LoadOrderGroupKey = NULL;
	} else {
		r->in.LoadOrderGroupKey = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_LoadOrderGroupKey)) {
				unicode = PyUnicode_AsEncodedString(py_LoadOrderGroupKey, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_LoadOrderGroupKey)) {
				test_str = PyBytes_AS_STRING(py_LoadOrderGroupKey);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_LoadOrderGroupKey)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.LoadOrderGroupKey = talloc_str;
		}
	}
	if (py_TagId == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.TagId");
		return false;
	}
	if (py_TagId == Py_None) {
		r->in.TagId = NULL;
	} else {
		r->in.TagId = talloc_ptrtype(r, r->in.TagId);
		if (r->in.TagId == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.TagId));
			if (PyLong_Check(py_TagId)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_TagId);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.TagId = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_dependencies == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.dependencies");
		return false;
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_dependencies, return false;);
		{
			int dependencies_cntr_1;
			r->in.dependencies = talloc_array_ptrtype(r, r->in.dependencies, PyList_GET_SIZE(py_dependencies));
			if (!r->in.dependencies) { return false; }
			talloc_set_name_const(r->in.dependencies, "ARRAY: r->in.dependencies");
			for (dependencies_cntr_1 = 0; dependencies_cntr_1 < PyList_GET_SIZE(py_dependencies); dependencies_cntr_1++) {
				if (PyList_GET_ITEM(py_dependencies, dependencies_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.dependencies)[dependencies_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.dependencies)[dependencies_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_dependencies, dependencies_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_dependencies, dependencies_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.dependencies)[dependencies_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_dependencies, return false;);
	r->in.dependencies_size = PyList_GET_SIZE(py_dependencies);
	if (py_service_start_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_start_name");
		return false;
	}
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_start_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_start_name)) {
				test_str = PyBytes_AS_STRING(py_service_start_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_start_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_start_name = talloc_str;
		}
	}
	if (py_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.password");
		return false;
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_password, return false;);
		{
			int password_cntr_1;
			r->in.password = talloc_array_ptrtype(r, r->in.password, PyList_GET_SIZE(py_password));
			if (!r->in.password) { return false; }
			talloc_set_name_const(r->in.password, "ARRAY: r->in.password");
			for (password_cntr_1 = 0; password_cntr_1 < PyList_GET_SIZE(py_password); password_cntr_1++) {
				if (PyList_GET_ITEM(py_password, password_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.password)[password_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.password)[password_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_password, password_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_password, password_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.password)[password_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_password, return false;);
	r->in.password_size = PyList_GET_SIZE(py_password);
	return true;
}

static PyObject *unpack_py_svcctl_CreateServiceW_args_out(struct svcctl_CreateServiceW *r)
{
	PyObject *result;
	PyObject *py_TagId;
	PyObject *py_handle;
	result = PyTuple_New(2);
	if (r->out.TagId == NULL) {
		py_TagId = Py_None;
		Py_INCREF(py_TagId);
	} else {
		py_TagId = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.TagId));
	}
	PyTuple_SetItem(result, 0, py_TagId);
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	PyTuple_SetItem(result, 1, py_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_EnumDependentServicesW_in_get_service(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(obj);
	PyObject *py_service;
	if (object->in.service == NULL) {
		Py_RETURN_NONE;
	}
	py_service = pytalloc_reference_ex(policy_handle_Type, object->in.service, object->in.service);
	return py_service;
}

static int py_svcctl_EnumDependentServicesW_in_set_service(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.service));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service");
		return -1;
	}
	object->in.service = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.service);
	if (object->in.service == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.service = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesW_in_get_state(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(obj);
	PyObject *py_state;
	py_state = PyLong_FromUnsignedLongLong((uint32_t)(object->in.state));
	return py_state;
}

static int py_svcctl_EnumDependentServicesW_in_set_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesW_out_get_service_status(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(obj);
	PyObject *py_service_status;
	if (object->out.service_status == NULL) {
		Py_RETURN_NONE;
	}
	py_service_status = PyList_New(object->in.offered);
	if (py_service_status == NULL) {
		return NULL;
	}
	{
		int service_status_cntr_1;
		for (service_status_cntr_1 = 0; service_status_cntr_1 < (object->in.offered); service_status_cntr_1++) {
			PyObject *py_service_status_1;
			py_service_status_1 = PyLong_FromLong((uint16_t)((object->out.service_status)[service_status_cntr_1]));
			PyList_SetItem(py_service_status, service_status_cntr_1, py_service_status_1);
		}
	}
	return py_service_status;
}

static int py_svcctl_EnumDependentServicesW_out_set_service_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.service_status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.service_status");
		return -1;
	}
	object->out.service_status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.service_status);
	if (object->out.service_status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int service_status_cntr_1;
		object->out.service_status = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.service_status, PyList_GET_SIZE(value));
		if (!object->out.service_status) { return -1; }
		talloc_set_name_const(object->out.service_status, "ARRAY: object->out.service_status");
		for (service_status_cntr_1 = 0; service_status_cntr_1 < PyList_GET_SIZE(value); service_status_cntr_1++) {
			if (PyList_GET_ITEM(value, service_status_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->out.service_status)[service_status_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.service_status)[service_status_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, service_status_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, service_status_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.service_status)[service_status_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesW_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_EnumDependentServicesW_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesW_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_EnumDependentServicesW_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesW_out_get_services_returned(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(obj);
	PyObject *py_services_returned;
	if (object->out.services_returned == NULL) {
		Py_RETURN_NONE;
	}
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.services_returned));
	return py_services_returned;
}

static int py_svcctl_EnumDependentServicesW_out_set_services_returned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.services_returned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.services_returned");
		return -1;
	}
	object->out.services_returned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.services_returned);
	if (object->out.services_returned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.services_returned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.services_returned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_EnumDependentServicesW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_EnumDependentServicesW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_service"),
		.get = py_svcctl_EnumDependentServicesW_in_get_service,
		.set = py_svcctl_EnumDependentServicesW_in_set_service,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_state"),
		.get = py_svcctl_EnumDependentServicesW_in_get_state,
		.set = py_svcctl_EnumDependentServicesW_in_set_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServiceState")
	},
	{
		.name = discard_const_p(char, "out_service_status"),
		.get = py_svcctl_EnumDependentServicesW_out_get_service_status,
		.set = py_svcctl_EnumDependentServicesW_out_set_service_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_EnumDependentServicesW_in_get_offered,
		.set = py_svcctl_EnumDependentServicesW_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_EnumDependentServicesW_out_get_needed,
		.set = py_svcctl_EnumDependentServicesW_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_services_returned"),
		.get = py_svcctl_EnumDependentServicesW_out_get_services_returned,
		.set = py_svcctl_EnumDependentServicesW_out_set_services_returned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_EnumDependentServicesW_get_result,
		.set = py_svcctl_EnumDependentServicesW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_EnumDependentServicesW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_EnumDependentServicesW, type);
	struct svcctl_EnumDependentServicesW *_self = (struct svcctl_EnumDependentServicesW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.service = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.service_status = talloc_zero(mem_ctx, uint8_t);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	_self->out.services_returned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(13);
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumDependentServicesW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[13];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumDependentServicesW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumDependentServicesW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumDependentServicesW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[13];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumDependentServicesW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumDependentServicesW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumDependentServicesW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumDependentServicesW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[13];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumDependentServicesW_ndr_print(py_obj, "svcctl_EnumDependentServicesW_in", NDR_IN);
}

static PyObject *py_svcctl_EnumDependentServicesW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumDependentServicesW_ndr_print(py_obj, "svcctl_EnumDependentServicesW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_EnumDependentServicesW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_EnumDependentServicesW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.EnumDependentServicesW.opnum() -> 13 (0x0d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_EnumDependentServicesW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_EnumDependentServicesW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_EnumDependentServicesW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.EnumDependentServicesW",
	.tp_getset = py_svcctl_EnumDependentServicesW_getsetters,
	.tp_methods = py_svcctl_EnumDependentServicesW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_EnumDependentServicesW_new,
};

static bool pack_py_svcctl_EnumDependentServicesW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumDependentServicesW *r)
{
	PyObject *py_service;
	PyObject *py_state;
	PyObject *py_offered;
	const char *kwnames[] = {
		"service", "state", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_EnumDependentServicesW", discard_const_p(char *, kwnames), &py_service, &py_state, &py_offered)) {
		return false;
	}

	if (py_service == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service");
		return false;
	}
	r->in.service = talloc_ptrtype(r, r->in.service);
	if (r->in.service == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_service, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_service)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.service = (struct policy_handle *)pytalloc_get_ptr(py_service);
	if (py_state == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.state");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.state));
		if (PyLong_Check(py_state)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_state);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_EnumDependentServicesW_args_out(struct svcctl_EnumDependentServicesW *r)
{
	PyObject *result;
	PyObject *py_service_status;
	PyObject *py_needed;
	PyObject *py_services_returned;
	result = PyTuple_New(3);
	py_service_status = PyList_New(r->in.offered);
	if (py_service_status == NULL) {
		return NULL;
	}
	{
		int service_status_cntr_1;
		for (service_status_cntr_1 = 0; service_status_cntr_1 < (r->in.offered); service_status_cntr_1++) {
			PyObject *py_service_status_1;
			py_service_status_1 = PyLong_FromLong((uint16_t)((r->out.service_status)[service_status_cntr_1]));
			PyList_SetItem(py_service_status, service_status_cntr_1, py_service_status_1);
		}
	}
	PyTuple_SetItem(result, 0, py_service_status);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.services_returned));
	PyTuple_SetItem(result, 2, py_services_returned);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_EnumServicesStatusW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_EnumServicesStatusW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_in_get_type(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.type));
	return py_type;
}

static int py_svcctl_EnumServicesStatusW_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_in_get_state(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_state;
	py_state = PyLong_FromUnsignedLongLong((uint32_t)(object->in.state));
	return py_state;
}

static int py_svcctl_EnumServicesStatusW_in_set_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_out_get_service(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_service;
	if (object->out.service == NULL) {
		Py_RETURN_NONE;
	}
	py_service = PyList_New(object->in.offered);
	if (py_service == NULL) {
		return NULL;
	}
	{
		int service_cntr_1;
		for (service_cntr_1 = 0; service_cntr_1 < (object->in.offered); service_cntr_1++) {
			PyObject *py_service_1;
			py_service_1 = PyLong_FromLong((uint16_t)((object->out.service)[service_cntr_1]));
			PyList_SetItem(py_service, service_cntr_1, py_service_1);
		}
	}
	return py_service;
}

static int py_svcctl_EnumServicesStatusW_out_set_service(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.service));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.service");
		return -1;
	}
	object->out.service = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.service);
	if (object->out.service == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int service_cntr_1;
		object->out.service = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.service, PyList_GET_SIZE(value));
		if (!object->out.service) { return -1; }
		talloc_set_name_const(object->out.service, "ARRAY: object->out.service");
		for (service_cntr_1 = 0; service_cntr_1 < PyList_GET_SIZE(value); service_cntr_1++) {
			if (PyList_GET_ITEM(value, service_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->out.service)[service_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.service)[service_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, service_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, service_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.service)[service_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_EnumServicesStatusW_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_EnumServicesStatusW_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_out_get_services_returned(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_services_returned;
	if (object->out.services_returned == NULL) {
		Py_RETURN_NONE;
	}
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.services_returned));
	return py_services_returned;
}

static int py_svcctl_EnumServicesStatusW_out_set_services_returned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.services_returned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.services_returned");
		return -1;
	}
	object->out.services_returned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.services_returned);
	if (object->out.services_returned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.services_returned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.services_returned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_svcctl_EnumServicesStatusW_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_svcctl_EnumServicesStatusW_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_EnumServicesStatusW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_EnumServicesStatusW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_EnumServicesStatusW_in_get_handle,
		.set = py_svcctl_EnumServicesStatusW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_svcctl_EnumServicesStatusW_in_get_type,
		.set = py_svcctl_EnumServicesStatusW_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_state"),
		.get = py_svcctl_EnumServicesStatusW_in_get_state,
		.set = py_svcctl_EnumServicesStatusW_in_set_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServiceState")
	},
	{
		.name = discard_const_p(char, "out_service"),
		.get = py_svcctl_EnumServicesStatusW_out_get_service,
		.set = py_svcctl_EnumServicesStatusW_out_set_service,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_EnumServicesStatusW_in_get_offered,
		.set = py_svcctl_EnumServicesStatusW_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_EnumServicesStatusW_out_get_needed,
		.set = py_svcctl_EnumServicesStatusW_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_services_returned"),
		.get = py_svcctl_EnumServicesStatusW_out_get_services_returned,
		.set = py_svcctl_EnumServicesStatusW_out_set_services_returned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_svcctl_EnumServicesStatusW_in_get_resume_handle,
		.set = py_svcctl_EnumServicesStatusW_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_svcctl_EnumServicesStatusW_out_get_resume_handle,
		.set = py_svcctl_EnumServicesStatusW_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_EnumServicesStatusW_get_result,
		.set = py_svcctl_EnumServicesStatusW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_EnumServicesStatusW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_EnumServicesStatusW, type);
	struct svcctl_EnumServicesStatusW *_self = (struct svcctl_EnumServicesStatusW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.service = talloc_zero(mem_ctx, uint8_t);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	_self->out.services_returned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(14);
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumServicesStatusW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[14];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumServicesStatusW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumServicesStatusW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumServicesStatusW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[14];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumServicesStatusW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumServicesStatusW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumServicesStatusW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumServicesStatusW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[14];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumServicesStatusW_ndr_print(py_obj, "svcctl_EnumServicesStatusW_in", NDR_IN);
}

static PyObject *py_svcctl_EnumServicesStatusW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumServicesStatusW_ndr_print(py_obj, "svcctl_EnumServicesStatusW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_EnumServicesStatusW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_EnumServicesStatusW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.EnumServicesStatusW.opnum() -> 14 (0x0e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_EnumServicesStatusW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_EnumServicesStatusW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_EnumServicesStatusW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.EnumServicesStatusW",
	.tp_getset = py_svcctl_EnumServicesStatusW_getsetters,
	.tp_methods = py_svcctl_EnumServicesStatusW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_EnumServicesStatusW_new,
};

static bool pack_py_svcctl_EnumServicesStatusW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumServicesStatusW *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_state;
	PyObject *py_offered;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"handle", "type", "state", "offered", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:svcctl_EnumServicesStatusW", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_state, &py_offered, &py_resume_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_state == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.state");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.state));
		if (PyLong_Check(py_state)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_state);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		if (r->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
			if (PyLong_Check(py_resume_handle)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_EnumServicesStatusW_args_out(struct svcctl_EnumServicesStatusW *r)
{
	PyObject *result;
	PyObject *py_service;
	PyObject *py_needed;
	PyObject *py_services_returned;
	PyObject *py_resume_handle;
	result = PyTuple_New(4);
	py_service = PyList_New(r->in.offered);
	if (py_service == NULL) {
		return NULL;
	}
	{
		int service_cntr_1;
		for (service_cntr_1 = 0; service_cntr_1 < (r->in.offered); service_cntr_1++) {
			PyObject *py_service_1;
			py_service_1 = PyLong_FromLong((uint16_t)((r->out.service)[service_cntr_1]));
			PyList_SetItem(py_service, service_cntr_1, py_service_1);
		}
	}
	PyTuple_SetItem(result, 0, py_service);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.services_returned));
	PyTuple_SetItem(result, 2, py_services_returned);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	}
	PyTuple_SetItem(result, 3, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_OpenSCManagerW_in_get_MachineName(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(obj);
	PyObject *py_MachineName;
	if (object->in.MachineName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.MachineName == NULL) {
		py_MachineName = Py_None;
		Py_INCREF(py_MachineName);
	} else {
		if (object->in.MachineName == NULL) {
			py_MachineName = Py_None;
			Py_INCREF(py_MachineName);
		} else {
			py_MachineName = PyUnicode_Decode(object->in.MachineName, strlen(object->in.MachineName), "utf-8", "ignore");
		}
	}
	return py_MachineName;
}

static int py_svcctl_OpenSCManagerW_in_set_MachineName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.MachineName");
		return -1;
	}
	if (value == Py_None) {
		object->in.MachineName = NULL;
	} else {
		object->in.MachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.MachineName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerW_in_get_DatabaseName(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(obj);
	PyObject *py_DatabaseName;
	if (object->in.DatabaseName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.DatabaseName == NULL) {
		py_DatabaseName = Py_None;
		Py_INCREF(py_DatabaseName);
	} else {
		if (object->in.DatabaseName == NULL) {
			py_DatabaseName = Py_None;
			Py_INCREF(py_DatabaseName);
		} else {
			py_DatabaseName = PyUnicode_Decode(object->in.DatabaseName, strlen(object->in.DatabaseName), "utf-8", "ignore");
		}
	}
	return py_DatabaseName;
}

static int py_svcctl_OpenSCManagerW_in_set_DatabaseName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.DatabaseName");
		return -1;
	}
	if (value == Py_None) {
		object->in.DatabaseName = NULL;
	} else {
		object->in.DatabaseName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.DatabaseName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerW_in_get_access_mask(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_svcctl_OpenSCManagerW_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerW_out_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_svcctl_OpenSCManagerW_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_OpenSCManagerW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_OpenSCManagerW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_MachineName"),
		.get = py_svcctl_OpenSCManagerW_in_get_MachineName,
		.set = py_svcctl_OpenSCManagerW_in_set_MachineName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_DatabaseName"),
		.get = py_svcctl_OpenSCManagerW_in_get_DatabaseName,
		.set = py_svcctl_OpenSCManagerW_in_set_DatabaseName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_svcctl_OpenSCManagerW_in_get_access_mask,
		.set = py_svcctl_OpenSCManagerW_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_MgrAccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_svcctl_OpenSCManagerW_out_get_handle,
		.set = py_svcctl_OpenSCManagerW_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_OpenSCManagerW_get_result,
		.set = py_svcctl_OpenSCManagerW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_OpenSCManagerW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_OpenSCManagerW, type);
	struct svcctl_OpenSCManagerW *_self = (struct svcctl_OpenSCManagerW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(15);
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenSCManagerW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[15];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenSCManagerW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenSCManagerW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenSCManagerW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[15];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenSCManagerW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenSCManagerW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenSCManagerW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenSCManagerW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[15];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenSCManagerW_ndr_print(py_obj, "svcctl_OpenSCManagerW_in", NDR_IN);
}

static PyObject *py_svcctl_OpenSCManagerW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenSCManagerW_ndr_print(py_obj, "svcctl_OpenSCManagerW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_OpenSCManagerW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_OpenSCManagerW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.OpenSCManagerW.opnum() -> 15 (0x0f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_OpenSCManagerW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_OpenSCManagerW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_OpenSCManagerW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.OpenSCManagerW",
	.tp_getset = py_svcctl_OpenSCManagerW_getsetters,
	.tp_methods = py_svcctl_OpenSCManagerW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_OpenSCManagerW_new,
};

static bool pack_py_svcctl_OpenSCManagerW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenSCManagerW *r)
{
	PyObject *py_MachineName;
	PyObject *py_DatabaseName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"MachineName", "DatabaseName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenSCManagerW", discard_const_p(char *, kwnames), &py_MachineName, &py_DatabaseName, &py_access_mask)) {
		return false;
	}

	if (py_MachineName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.MachineName");
		return false;
	}
	if (py_MachineName == Py_None) {
		r->in.MachineName = NULL;
	} else {
		r->in.MachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_MachineName)) {
				unicode = PyUnicode_AsEncodedString(py_MachineName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_MachineName)) {
				test_str = PyBytes_AS_STRING(py_MachineName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_MachineName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.MachineName = talloc_str;
		}
	}
	if (py_DatabaseName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.DatabaseName");
		return false;
	}
	if (py_DatabaseName == Py_None) {
		r->in.DatabaseName = NULL;
	} else {
		r->in.DatabaseName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_DatabaseName)) {
				unicode = PyUnicode_AsEncodedString(py_DatabaseName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_DatabaseName)) {
				test_str = PyBytes_AS_STRING(py_DatabaseName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_DatabaseName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.DatabaseName = talloc_str;
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_OpenSCManagerW_args_out(struct svcctl_OpenSCManagerW *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_OpenServiceW_in_get_scmanager_handle(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_scmanager_handle;
	if (object->in.scmanager_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_scmanager_handle = pytalloc_reference_ex(policy_handle_Type, object->in.scmanager_handle, object->in.scmanager_handle);
	return py_scmanager_handle;
}

static int py_svcctl_OpenServiceW_in_set_scmanager_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.scmanager_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.scmanager_handle");
		return -1;
	}
	object->in.scmanager_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.scmanager_handle);
	if (object->in.scmanager_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.scmanager_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_OpenServiceW_in_get_ServiceName(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_ServiceName;
	if (object->in.ServiceName == NULL) {
		py_ServiceName = Py_None;
		Py_INCREF(py_ServiceName);
	} else {
		py_ServiceName = PyUnicode_Decode(object->in.ServiceName, strlen(object->in.ServiceName), "utf-8", "ignore");
	}
	return py_ServiceName;
}

static int py_svcctl_OpenServiceW_in_set_ServiceName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ServiceName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.ServiceName = talloc_str;
	}
	return 0;
}

static PyObject *py_svcctl_OpenServiceW_in_get_access_mask(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_svcctl_OpenServiceW_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenServiceW_out_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_svcctl_OpenServiceW_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_OpenServiceW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_OpenServiceW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_OpenServiceW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_scmanager_handle"),
		.get = py_svcctl_OpenServiceW_in_get_scmanager_handle,
		.set = py_svcctl_OpenServiceW_in_set_scmanager_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_ServiceName"),
		.get = py_svcctl_OpenServiceW_in_get_ServiceName,
		.set = py_svcctl_OpenServiceW_in_set_ServiceName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_svcctl_OpenServiceW_in_get_access_mask,
		.set = py_svcctl_OpenServiceW_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServiceAccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_svcctl_OpenServiceW_out_get_handle,
		.set = py_svcctl_OpenServiceW_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_OpenServiceW_get_result,
		.set = py_svcctl_OpenServiceW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_OpenServiceW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_OpenServiceW, type);
	struct svcctl_OpenServiceW *_self = (struct svcctl_OpenServiceW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.scmanager_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_OpenServiceW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(16);
}

static PyObject *py_svcctl_OpenServiceW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenServiceW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[16];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_OpenServiceW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenServiceW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_OpenServiceW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenServiceW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_OpenServiceW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenServiceW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[16];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_OpenServiceW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenServiceW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenServiceW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenServiceW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenServiceW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenServiceW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenServiceW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[16];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_OpenServiceW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenServiceW_ndr_print(py_obj, "svcctl_OpenServiceW_in", NDR_IN);
}

static PyObject *py_svcctl_OpenServiceW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenServiceW_ndr_print(py_obj, "svcctl_OpenServiceW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_OpenServiceW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_OpenServiceW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.OpenServiceW.opnum() -> 16 (0x10) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_OpenServiceW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_OpenServiceW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_OpenServiceW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.OpenServiceW",
	.tp_getset = py_svcctl_OpenServiceW_getsetters,
	.tp_methods = py_svcctl_OpenServiceW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_OpenServiceW_new,
};

static bool pack_py_svcctl_OpenServiceW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenServiceW *r)
{
	PyObject *py_scmanager_handle;
	PyObject *py_ServiceName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"scmanager_handle", "ServiceName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenServiceW", discard_const_p(char *, kwnames), &py_scmanager_handle, &py_ServiceName, &py_access_mask)) {
		return false;
	}

	if (py_scmanager_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.scmanager_handle");
		return false;
	}
	r->in.scmanager_handle = talloc_ptrtype(r, r->in.scmanager_handle);
	if (r->in.scmanager_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_scmanager_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.scmanager_handle = (struct policy_handle *)pytalloc_get_ptr(py_scmanager_handle);
	if (py_ServiceName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ServiceName");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_ServiceName)) {
			unicode = PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_ServiceName)) {
			test_str = PyBytes_AS_STRING(py_ServiceName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ServiceName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.ServiceName = talloc_str;
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_OpenServiceW_args_out(struct svcctl_OpenServiceW *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_QueryServiceConfigW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_QueryServiceConfigW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigW_out_get_query(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_query;
	if (object->out.query == NULL) {
		Py_RETURN_NONE;
	}
	py_query = pytalloc_reference_ex(&QUERY_SERVICE_CONFIG_Type, object->out.query, object->out.query);
	return py_query;
}

static int py_svcctl_QueryServiceConfigW_out_set_query(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.query));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.query");
		return -1;
	}
	object->out.query = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.query);
	if (object->out.query == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&QUERY_SERVICE_CONFIG_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.query = (struct QUERY_SERVICE_CONFIG *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigW_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_QueryServiceConfigW_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigW_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_QueryServiceConfigW_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_QueryServiceConfigW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_QueryServiceConfigW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_QueryServiceConfigW_in_get_handle,
		.set = py_svcctl_QueryServiceConfigW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_query"),
		.get = py_svcctl_QueryServiceConfigW_out_get_query,
		.set = py_svcctl_QueryServiceConfigW_out_set_query,
		.doc = discard_const_p(char, "PIDL-generated element of base type QUERY_SERVICE_CONFIG")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_QueryServiceConfigW_in_get_offered,
		.set = py_svcctl_QueryServiceConfigW_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_QueryServiceConfigW_out_get_needed,
		.set = py_svcctl_QueryServiceConfigW_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_QueryServiceConfigW_get_result,
		.set = py_svcctl_QueryServiceConfigW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_QueryServiceConfigW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_QueryServiceConfigW, type);
	struct svcctl_QueryServiceConfigW *_self = (struct svcctl_QueryServiceConfigW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.query = talloc_zero(mem_ctx, struct QUERY_SERVICE_CONFIG);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(17);
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceConfigW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[17];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceConfigW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceConfigW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceConfigW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[17];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceConfigW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceConfigW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceConfigW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceConfigW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[17];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceConfigW_ndr_print(py_obj, "svcctl_QueryServiceConfigW_in", NDR_IN);
}

static PyObject *py_svcctl_QueryServiceConfigW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceConfigW_ndr_print(py_obj, "svcctl_QueryServiceConfigW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_QueryServiceConfigW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_QueryServiceConfigW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.QueryServiceConfigW.opnum() -> 17 (0x11) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_QueryServiceConfigW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_QueryServiceConfigW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_QueryServiceConfigW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.QueryServiceConfigW",
	.tp_getset = py_svcctl_QueryServiceConfigW_getsetters,
	.tp_methods = py_svcctl_QueryServiceConfigW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_QueryServiceConfigW_new,
};

static bool pack_py_svcctl_QueryServiceConfigW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceConfigW *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceConfigW", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceConfigW_args_out(struct svcctl_QueryServiceConfigW *r)
{
	PyObject *result;
	PyObject *py_query;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_query = pytalloc_reference_ex(&QUERY_SERVICE_CONFIG_Type, r->out.query, r->out.query);
	PyTuple_SetItem(result, 0, py_query);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_QueryServiceLockStatusW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_QueryServiceLockStatusW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_QueryServiceLockStatusW_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_out_get_lock_status(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_status;
	if (object->out.lock_status == NULL) {
		Py_RETURN_NONE;
	}
	py_lock_status = pytalloc_reference_ex(&SERVICE_LOCK_STATUS_Type, object->out.lock_status, object->out.lock_status);
	return py_lock_status;
}

static int py_svcctl_QueryServiceLockStatusW_out_set_lock_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.lock_status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.lock_status");
		return -1;
	}
	object->out.lock_status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.lock_status);
	if (object->out.lock_status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_LOCK_STATUS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.lock_status = (struct SERVICE_LOCK_STATUS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_QueryServiceLockStatusW_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_QueryServiceLockStatusW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_QueryServiceLockStatusW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_QueryServiceLockStatusW_in_get_handle,
		.set = py_svcctl_QueryServiceLockStatusW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_QueryServiceLockStatusW_in_get_offered,
		.set = py_svcctl_QueryServiceLockStatusW_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_lock_status"),
		.get = py_svcctl_QueryServiceLockStatusW_out_get_lock_status,
		.set = py_svcctl_QueryServiceLockStatusW_out_set_lock_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_LOCK_STATUS")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_QueryServiceLockStatusW_out_get_needed,
		.set = py_svcctl_QueryServiceLockStatusW_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_QueryServiceLockStatusW_get_result,
		.set = py_svcctl_QueryServiceLockStatusW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_QueryServiceLockStatusW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_QueryServiceLockStatusW, type);
	struct svcctl_QueryServiceLockStatusW *_self = (struct svcctl_QueryServiceLockStatusW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.lock_status = talloc_zero(mem_ctx, struct SERVICE_LOCK_STATUS);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(18);
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceLockStatusW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[18];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceLockStatusW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceLockStatusW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceLockStatusW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[18];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceLockStatusW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceLockStatusW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceLockStatusW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceLockStatusW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[18];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceLockStatusW_ndr_print(py_obj, "svcctl_QueryServiceLockStatusW_in", NDR_IN);
}

static PyObject *py_svcctl_QueryServiceLockStatusW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceLockStatusW_ndr_print(py_obj, "svcctl_QueryServiceLockStatusW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_QueryServiceLockStatusW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_QueryServiceLockStatusW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.QueryServiceLockStatusW.opnum() -> 18 (0x12) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_QueryServiceLockStatusW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_QueryServiceLockStatusW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_QueryServiceLockStatusW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.QueryServiceLockStatusW",
	.tp_getset = py_svcctl_QueryServiceLockStatusW_getsetters,
	.tp_methods = py_svcctl_QueryServiceLockStatusW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_QueryServiceLockStatusW_new,
};

static bool pack_py_svcctl_QueryServiceLockStatusW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceLockStatusW *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceLockStatusW", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceLockStatusW_args_out(struct svcctl_QueryServiceLockStatusW *r)
{
	PyObject *result;
	PyObject *py_lock_status;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_lock_status = pytalloc_reference_ex(&SERVICE_LOCK_STATUS_Type, r->out.lock_status, r->out.lock_status);
	PyTuple_SetItem(result, 0, py_lock_status);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_StartServiceW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_StartServiceW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_StartServiceW_in_get_NumArgs(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_NumArgs;
	py_NumArgs = PyLong_FromUnsignedLongLong((uint32_t)(object->in.NumArgs));
	return py_NumArgs;
}

static int py_svcctl_StartServiceW_in_set_NumArgs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.NumArgs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.NumArgs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.NumArgs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_StartServiceW_in_get_Arguments(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_Arguments;
	if (object->in.Arguments == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Arguments == NULL) {
		py_Arguments = Py_None;
		Py_INCREF(py_Arguments);
	} else {
		py_Arguments = PyList_New(object->in.NumArgs);
		if (py_Arguments == NULL) {
			return NULL;
		}
		{
			int Arguments_cntr_1;
			for (Arguments_cntr_1 = 0; Arguments_cntr_1 < (object->in.NumArgs); Arguments_cntr_1++) {
				PyObject *py_Arguments_1;
				py_Arguments_1 = pytalloc_reference_ex(&svcctl_ArgumentString_Type, object->in.Arguments, &(object->in.Arguments)[Arguments_cntr_1]);
				PyList_SetItem(py_Arguments, Arguments_cntr_1, py_Arguments_1);
			}
		}
	}
	return py_Arguments;
}

static int py_svcctl_StartServiceW_in_set_Arguments(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.Arguments));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Arguments");
		return -1;
	}
	if (value == Py_None) {
		object->in.Arguments = NULL;
	} else {
		object->in.Arguments = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int Arguments_cntr_1;
			object->in.Arguments = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.Arguments, PyList_GET_SIZE(value));
			if (!object->in.Arguments) { return -1; }
			talloc_set_name_const(object->in.Arguments, "ARRAY: object->in.Arguments");
			for (Arguments_cntr_1 = 0; Arguments_cntr_1 < PyList_GET_SIZE(value); Arguments_cntr_1++) {
				if (PyList_GET_ITEM(value, Arguments_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.Arguments)[Arguments_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&svcctl_ArgumentString_Type, PyList_GET_ITEM(value, Arguments_cntr_1), return -1;);
				if (talloc_reference(object->in.Arguments, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, Arguments_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->in.Arguments)[Arguments_cntr_1] = *(struct svcctl_ArgumentString *)pytalloc_get_ptr(PyList_GET_ITEM(value, Arguments_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_StartServiceW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_StartServiceW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_StartServiceW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_StartServiceW_in_get_handle,
		.set = py_svcctl_StartServiceW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_NumArgs"),
		.get = py_svcctl_StartServiceW_in_get_NumArgs,
		.set = py_svcctl_StartServiceW_in_set_NumArgs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_Arguments"),
		.get = py_svcctl_StartServiceW_in_get_Arguments,
		.set = py_svcctl_StartServiceW_in_set_Arguments,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ArgumentString")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_StartServiceW_get_result,
		.set = py_svcctl_StartServiceW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_StartServiceW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_StartServiceW, type);
	struct svcctl_StartServiceW *_self = (struct svcctl_StartServiceW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_StartServiceW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(19);
}

static PyObject *py_svcctl_StartServiceW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_StartServiceW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[19];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_StartServiceW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_StartServiceW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_StartServiceW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_StartServiceW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_StartServiceW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_StartServiceW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[19];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_StartServiceW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_StartServiceW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_StartServiceW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_StartServiceW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_StartServiceW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_StartServiceW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_StartServiceW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[19];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_StartServiceW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_StartServiceW_ndr_print(py_obj, "svcctl_StartServiceW_in", NDR_IN);
}

static PyObject *py_svcctl_StartServiceW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_StartServiceW_ndr_print(py_obj, "svcctl_StartServiceW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_StartServiceW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_StartServiceW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.StartServiceW.opnum() -> 19 (0x13) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_StartServiceW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_StartServiceW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_StartServiceW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.StartServiceW",
	.tp_getset = py_svcctl_StartServiceW_getsetters,
	.tp_methods = py_svcctl_StartServiceW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_StartServiceW_new,
};

static bool pack_py_svcctl_StartServiceW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_StartServiceW *r)
{
	PyObject *py_handle;
	PyObject *py_Arguments;
	const char *kwnames[] = {
		"handle", "Arguments", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_StartServiceW", discard_const_p(char *, kwnames), &py_handle, &py_Arguments)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyList_Type, py_Arguments, return false;);
	r->in.NumArgs = PyList_GET_SIZE(py_Arguments);
	if (py_Arguments == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Arguments");
		return false;
	}
	if (py_Arguments == Py_None) {
		r->in.Arguments = NULL;
	} else {
		r->in.Arguments = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_Arguments, return false;);
		{
			int Arguments_cntr_1;
			r->in.Arguments = talloc_array_ptrtype(r, r->in.Arguments, PyList_GET_SIZE(py_Arguments));
			if (!r->in.Arguments) { return false; }
			talloc_set_name_const(r->in.Arguments, "ARRAY: r->in.Arguments");
			for (Arguments_cntr_1 = 0; Arguments_cntr_1 < PyList_GET_SIZE(py_Arguments); Arguments_cntr_1++) {
				if (PyList_GET_ITEM(py_Arguments, Arguments_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.Arguments)[Arguments_cntr_1]");
					return false;
				}
				PY_CHECK_TYPE(&svcctl_ArgumentString_Type, PyList_GET_ITEM(py_Arguments, Arguments_cntr_1), return false;);
				if (talloc_reference(r->in.Arguments, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_Arguments, Arguments_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return false;
				}
				(r->in.Arguments)[Arguments_cntr_1] = *(struct svcctl_ArgumentString *)pytalloc_get_ptr(PyList_GET_ITEM(py_Arguments, Arguments_cntr_1));
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_StartServiceW_args_out(struct svcctl_StartServiceW *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_GetServiceDisplayNameW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_GetServiceDisplayNameW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_in_get_service_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_service_name;
	if (object->in.service_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_name == NULL) {
		py_service_name = Py_None;
		Py_INCREF(py_service_name);
	} else {
		if (object->in.service_name == NULL) {
			py_service_name = Py_None;
			Py_INCREF(py_service_name);
		} else {
			py_service_name = PyUnicode_Decode(object->in.service_name, strlen(object->in.service_name), "utf-8", "ignore");
		}
	}
	return py_service_name;
}

static int py_svcctl_GetServiceDisplayNameW_in_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_name = NULL;
	} else {
		object->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_out_get_display_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name;
	if (object->out.display_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		if (*object->out.display_name == NULL) {
			py_display_name = Py_None;
			Py_INCREF(py_display_name);
		} else {
			py_display_name = PyUnicode_Decode(*object->out.display_name, strlen(*object->out.display_name), "utf-8", "ignore");
		}
	}
	return py_display_name;
}

static int py_svcctl_GetServiceDisplayNameW_out_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.display_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.display_name");
		return -1;
	}
	object->out.display_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.display_name);
	if (object->out.display_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.display_name = NULL;
	} else {
		*object->out.display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.display_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_in_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->in.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceDisplayNameW_in_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->in.display_name_length = NULL;
	} else {
		object->in.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.display_name_length);
		if (object->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_out_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->out.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceDisplayNameW_out_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->out.display_name_length = NULL;
	} else {
		object->out.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.display_name_length);
		if (object->out.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_GetServiceDisplayNameW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_GetServiceDisplayNameW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_GetServiceDisplayNameW_in_get_handle,
		.set = py_svcctl_GetServiceDisplayNameW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_service_name"),
		.get = py_svcctl_GetServiceDisplayNameW_in_get_service_name,
		.set = py_svcctl_GetServiceDisplayNameW_in_set_service_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_display_name"),
		.get = py_svcctl_GetServiceDisplayNameW_out_get_display_name,
		.set = py_svcctl_GetServiceDisplayNameW_out_set_display_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_display_name_length"),
		.get = py_svcctl_GetServiceDisplayNameW_in_get_display_name_length,
		.set = py_svcctl_GetServiceDisplayNameW_in_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_display_name_length"),
		.get = py_svcctl_GetServiceDisplayNameW_out_get_display_name_length,
		.set = py_svcctl_GetServiceDisplayNameW_out_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_GetServiceDisplayNameW_get_result,
		.set = py_svcctl_GetServiceDisplayNameW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_GetServiceDisplayNameW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_GetServiceDisplayNameW, type);
	struct svcctl_GetServiceDisplayNameW *_self = (struct svcctl_GetServiceDisplayNameW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(20);
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceDisplayNameW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[20];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceDisplayNameW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceDisplayNameW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceDisplayNameW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[20];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceDisplayNameW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceDisplayNameW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceDisplayNameW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceDisplayNameW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[20];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceDisplayNameW_ndr_print(py_obj, "svcctl_GetServiceDisplayNameW_in", NDR_IN);
}

static PyObject *py_svcctl_GetServiceDisplayNameW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceDisplayNameW_ndr_print(py_obj, "svcctl_GetServiceDisplayNameW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_GetServiceDisplayNameW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_GetServiceDisplayNameW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.GetServiceDisplayNameW.opnum() -> 20 (0x14) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_GetServiceDisplayNameW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_GetServiceDisplayNameW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_GetServiceDisplayNameW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.GetServiceDisplayNameW",
	.tp_getset = py_svcctl_GetServiceDisplayNameW_getsetters,
	.tp_methods = py_svcctl_GetServiceDisplayNameW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_GetServiceDisplayNameW_new,
};

static bool pack_py_svcctl_GetServiceDisplayNameW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceDisplayNameW *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceDisplayNameW", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_service_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_name");
		return false;
	}
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_name)) {
				test_str = PyBytes_AS_STRING(py_service_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_name = talloc_str;
		}
	}
	if (py_display_name_length == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.display_name_length");
		return false;
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		if (r->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.display_name_length));
			if (PyLong_Check(py_display_name_length)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_display_name_length);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceDisplayNameW_args_out(struct svcctl_GetServiceDisplayNameW *r)
{
	PyObject *result;
	PyObject *py_display_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		if (*r->out.display_name == NULL) {
			py_display_name = Py_None;
			Py_INCREF(py_display_name);
		} else {
			py_display_name = PyUnicode_Decode(*r->out.display_name, strlen(*r->out.display_name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 0, py_display_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.display_name_length));
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_GetServiceKeyNameW_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_GetServiceKeyNameW_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameW_in_get_service_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_service_name;
	if (object->in.service_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_name == NULL) {
		py_service_name = Py_None;
		Py_INCREF(py_service_name);
	} else {
		if (object->in.service_name == NULL) {
			py_service_name = Py_None;
			Py_INCREF(py_service_name);
		} else {
			py_service_name = PyUnicode_Decode(object->in.service_name, strlen(object->in.service_name), "utf-8", "ignore");
		}
	}
	return py_service_name;
}

static int py_svcctl_GetServiceKeyNameW_in_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_name = NULL;
	} else {
		object->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameW_out_get_key_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_key_name;
	if (object->out.key_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.key_name == NULL) {
		py_key_name = Py_None;
		Py_INCREF(py_key_name);
	} else {
		if (*object->out.key_name == NULL) {
			py_key_name = Py_None;
			Py_INCREF(py_key_name);
		} else {
			py_key_name = PyUnicode_Decode(*object->out.key_name, strlen(*object->out.key_name), "utf-8", "ignore");
		}
	}
	return py_key_name;
}

static int py_svcctl_GetServiceKeyNameW_out_set_key_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.key_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.key_name");
		return -1;
	}
	object->out.key_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.key_name);
	if (object->out.key_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.key_name = NULL;
	} else {
		*object->out.key_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.key_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameW_in_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->in.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceKeyNameW_in_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->in.display_name_length = NULL;
	} else {
		object->in.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.display_name_length);
		if (object->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameW_out_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->out.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceKeyNameW_out_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->out.display_name_length = NULL;
	} else {
		object->out.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.display_name_length);
		if (object->out.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameW_get_result(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_GetServiceKeyNameW_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_GetServiceKeyNameW_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_GetServiceKeyNameW_in_get_handle,
		.set = py_svcctl_GetServiceKeyNameW_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_service_name"),
		.get = py_svcctl_GetServiceKeyNameW_in_get_service_name,
		.set = py_svcctl_GetServiceKeyNameW_in_set_service_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_key_name"),
		.get = py_svcctl_GetServiceKeyNameW_out_get_key_name,
		.set = py_svcctl_GetServiceKeyNameW_out_set_key_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_display_name_length"),
		.get = py_svcctl_GetServiceKeyNameW_in_get_display_name_length,
		.set = py_svcctl_GetServiceKeyNameW_in_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_display_name_length"),
		.get = py_svcctl_GetServiceKeyNameW_out_get_display_name_length,
		.set = py_svcctl_GetServiceKeyNameW_out_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_GetServiceKeyNameW_get_result,
		.set = py_svcctl_GetServiceKeyNameW_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_GetServiceKeyNameW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_GetServiceKeyNameW, type);
	struct svcctl_GetServiceKeyNameW *_self = (struct svcctl_GetServiceKeyNameW *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(21);
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceKeyNameW_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[21];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceKeyNameW_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceKeyNameW_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceKeyNameW_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[21];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceKeyNameW_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceKeyNameW_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceKeyNameW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceKeyNameW_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[21];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceKeyNameW_ndr_print(py_obj, "svcctl_GetServiceKeyNameW_in", NDR_IN);
}

static PyObject *py_svcctl_GetServiceKeyNameW_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceKeyNameW_ndr_print(py_obj, "svcctl_GetServiceKeyNameW_out", NDR_OUT);
}

static PyMethodDef py_svcctl_GetServiceKeyNameW_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_GetServiceKeyNameW_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.GetServiceKeyNameW.opnum() -> 21 (0x15) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameW_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameW_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameW_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameW_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_GetServiceKeyNameW_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_GetServiceKeyNameW_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_GetServiceKeyNameW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.GetServiceKeyNameW",
	.tp_getset = py_svcctl_GetServiceKeyNameW_getsetters,
	.tp_methods = py_svcctl_GetServiceKeyNameW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_GetServiceKeyNameW_new,
};

static bool pack_py_svcctl_GetServiceKeyNameW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceKeyNameW *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceKeyNameW", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_service_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_name");
		return false;
	}
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_name)) {
				test_str = PyBytes_AS_STRING(py_service_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_name = talloc_str;
		}
	}
	if (py_display_name_length == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.display_name_length");
		return false;
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		if (r->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.display_name_length));
			if (PyLong_Check(py_display_name_length)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_display_name_length);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceKeyNameW_args_out(struct svcctl_GetServiceKeyNameW *r)
{
	PyObject *result;
	PyObject *py_key_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.key_name == NULL) {
		py_key_name = Py_None;
		Py_INCREF(py_key_name);
	} else {
		if (*r->out.key_name == NULL) {
			py_key_name = Py_None;
			Py_INCREF(py_key_name);
		} else {
			py_key_name = PyUnicode_Decode(*r->out.key_name, strlen(*r->out.key_name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 0, py_key_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.display_name_length));
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_SCSetServiceBitsA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_SCSetServiceBitsA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsA_in_get_bits(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(obj);
	PyObject *py_bits;
	py_bits = PyLong_FromUnsignedLongLong((uint32_t)(object->in.bits));
	return py_bits;
}

static int py_svcctl_SCSetServiceBitsA_in_set_bits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.bits");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.bits));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.bits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsA_in_get_bitson(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(obj);
	PyObject *py_bitson;
	py_bitson = PyLong_FromUnsignedLongLong((uint32_t)(object->in.bitson));
	return py_bitson;
}

static int py_svcctl_SCSetServiceBitsA_in_set_bitson(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.bitson");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.bitson));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.bitson = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsA_in_get_immediate(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(obj);
	PyObject *py_immediate;
	py_immediate = PyLong_FromUnsignedLongLong((uint32_t)(object->in.immediate));
	return py_immediate;
}

static int py_svcctl_SCSetServiceBitsA_in_set_immediate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.immediate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.immediate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.immediate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_SCSetServiceBitsA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_SCSetServiceBitsA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_SCSetServiceBitsA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_SCSetServiceBitsA_in_get_handle,
		.set = py_svcctl_SCSetServiceBitsA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_bits"),
		.get = py_svcctl_SCSetServiceBitsA_in_get_bits,
		.set = py_svcctl_SCSetServiceBitsA_in_set_bits,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_bitson"),
		.get = py_svcctl_SCSetServiceBitsA_in_get_bitson,
		.set = py_svcctl_SCSetServiceBitsA_in_set_bitson,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_immediate"),
		.get = py_svcctl_SCSetServiceBitsA_in_get_immediate,
		.set = py_svcctl_SCSetServiceBitsA_in_set_immediate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_SCSetServiceBitsA_get_result,
		.set = py_svcctl_SCSetServiceBitsA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_SCSetServiceBitsA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_SCSetServiceBitsA, type);
	struct svcctl_SCSetServiceBitsA *_self = (struct svcctl_SCSetServiceBitsA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(22);
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SCSetServiceBitsA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[22];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_SCSetServiceBitsA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_SCSetServiceBitsA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SCSetServiceBitsA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[22];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_SCSetServiceBitsA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_SCSetServiceBitsA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_SCSetServiceBitsA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_SCSetServiceBitsA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[22];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_SCSetServiceBitsA_ndr_print(py_obj, "svcctl_SCSetServiceBitsA_in", NDR_IN);
}

static PyObject *py_svcctl_SCSetServiceBitsA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_SCSetServiceBitsA_ndr_print(py_obj, "svcctl_SCSetServiceBitsA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_SCSetServiceBitsA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_SCSetServiceBitsA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.SCSetServiceBitsA.opnum() -> 22 (0x16) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_SCSetServiceBitsA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_SCSetServiceBitsA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_SCSetServiceBitsA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_SCSetServiceBitsA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.SCSetServiceBitsA",
	.tp_getset = py_svcctl_SCSetServiceBitsA_getsetters,
	.tp_methods = py_svcctl_SCSetServiceBitsA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_SCSetServiceBitsA_new,
};

static bool pack_py_svcctl_SCSetServiceBitsA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_SCSetServiceBitsA *r)
{
	PyObject *py_handle;
	PyObject *py_bits;
	PyObject *py_bitson;
	PyObject *py_immediate;
	const char *kwnames[] = {
		"handle", "bits", "bitson", "immediate", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:svcctl_SCSetServiceBitsA", discard_const_p(char *, kwnames), &py_handle, &py_bits, &py_bitson, &py_immediate)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_bits == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.bits");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.bits));
		if (PyLong_Check(py_bits)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_bits);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.bits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_bitson == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.bitson");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.bitson));
		if (PyLong_Check(py_bitson)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_bitson);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.bitson = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_immediate == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.immediate");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.immediate));
		if (PyLong_Check(py_immediate)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_immediate);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.immediate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_SCSetServiceBitsA_args_out(struct svcctl_SCSetServiceBitsA *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_ChangeServiceConfigA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_ChangeServiceConfigA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_type(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.type));
	return py_type;
}

static int py_svcctl_ChangeServiceConfigA_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_start_type(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_start_type;
	py_start_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.start_type));
	return py_start_type;
}

static int py_svcctl_ChangeServiceConfigA_in_set_start_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.start_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.start_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_error_control(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_error_control;
	py_error_control = PyLong_FromUnsignedLongLong((uint32_t)(object->in.error_control));
	return py_error_control;
}

static int py_svcctl_ChangeServiceConfigA_in_set_error_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.error_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.error_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_binary_path(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_binary_path;
	if (object->in.binary_path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.binary_path == NULL) {
		py_binary_path = Py_None;
		Py_INCREF(py_binary_path);
	} else {
		if (object->in.binary_path == NULL) {
			py_binary_path = Py_None;
			Py_INCREF(py_binary_path);
		} else {
			py_binary_path = PyUnicode_Decode(object->in.binary_path, strlen(object->in.binary_path), "utf-8", "ignore");
		}
	}
	return py_binary_path;
}

static int py_svcctl_ChangeServiceConfigA_in_set_binary_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.binary_path");
		return -1;
	}
	if (value == Py_None) {
		object->in.binary_path = NULL;
	} else {
		object->in.binary_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.binary_path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_load_order_group(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_load_order_group;
	if (object->in.load_order_group == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.load_order_group == NULL) {
		py_load_order_group = Py_None;
		Py_INCREF(py_load_order_group);
	} else {
		if (object->in.load_order_group == NULL) {
			py_load_order_group = Py_None;
			Py_INCREF(py_load_order_group);
		} else {
			py_load_order_group = PyUnicode_Decode(object->in.load_order_group, strlen(object->in.load_order_group), "utf-8", "ignore");
		}
	}
	return py_load_order_group;
}

static int py_svcctl_ChangeServiceConfigA_in_set_load_order_group(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.load_order_group");
		return -1;
	}
	if (value == Py_None) {
		object->in.load_order_group = NULL;
	} else {
		object->in.load_order_group = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.load_order_group = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_out_get_tag_id(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_tag_id;
	if (object->out.tag_id == NULL) {
		Py_RETURN_NONE;
	}
	py_tag_id = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.tag_id));
	return py_tag_id;
}

static int py_svcctl_ChangeServiceConfigA_out_set_tag_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.tag_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.tag_id");
		return -1;
	}
	object->out.tag_id = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.tag_id);
	if (object->out.tag_id == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.tag_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.tag_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_dependencies(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_dependencies;
	if (object->in.dependencies == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.dependencies == NULL) {
		py_dependencies = Py_None;
		Py_INCREF(py_dependencies);
	} else {
		if (object->in.dependencies == NULL) {
			py_dependencies = Py_None;
			Py_INCREF(py_dependencies);
		} else {
			py_dependencies = PyUnicode_Decode(object->in.dependencies, strlen(object->in.dependencies), "utf-8", "ignore");
		}
	}
	return py_dependencies;
}

static int py_svcctl_ChangeServiceConfigA_in_set_dependencies(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.dependencies");
		return -1;
	}
	if (value == Py_None) {
		object->in.dependencies = NULL;
	} else {
		object->in.dependencies = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.dependencies = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_service_start_name(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_service_start_name;
	if (object->in.service_start_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_start_name == NULL) {
		py_service_start_name = Py_None;
		Py_INCREF(py_service_start_name);
	} else {
		if (object->in.service_start_name == NULL) {
			py_service_start_name = Py_None;
			Py_INCREF(py_service_start_name);
		} else {
			py_service_start_name = PyUnicode_Decode(object->in.service_start_name, strlen(object->in.service_start_name), "utf-8", "ignore");
		}
	}
	return py_service_start_name;
}

static int py_svcctl_ChangeServiceConfigA_in_set_service_start_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_start_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_start_name = NULL;
	} else {
		object->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_start_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_password(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->in.password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->in.password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->in.password, strlen(object->in.password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_svcctl_ChangeServiceConfigA_in_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password");
		return -1;
	}
	if (value == Py_None) {
		object->in.password = NULL;
	} else {
		object->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_in_get_display_name(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name;
	if (object->in.display_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		if (object->in.display_name == NULL) {
			py_display_name = Py_None;
			Py_INCREF(py_display_name);
		} else {
			py_display_name = PyUnicode_Decode(object->in.display_name, strlen(object->in.display_name), "utf-8", "ignore");
		}
	}
	return py_display_name;
}

static int py_svcctl_ChangeServiceConfigA_in_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.display_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.display_name = NULL;
	} else {
		object->in.display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.display_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfigA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_ChangeServiceConfigA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_ChangeServiceConfigA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_handle,
		.set = py_svcctl_ChangeServiceConfigA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_type,
		.set = py_svcctl_ChangeServiceConfigA_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_start_type"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_start_type,
		.set = py_svcctl_ChangeServiceConfigA_in_set_start_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_StartType")
	},
	{
		.name = discard_const_p(char, "in_error_control"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_error_control,
		.set = py_svcctl_ChangeServiceConfigA_in_set_error_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ErrorControl")
	},
	{
		.name = discard_const_p(char, "in_binary_path"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_binary_path,
		.set = py_svcctl_ChangeServiceConfigA_in_set_binary_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_load_order_group"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_load_order_group,
		.set = py_svcctl_ChangeServiceConfigA_in_set_load_order_group,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_tag_id"),
		.get = py_svcctl_ChangeServiceConfigA_out_get_tag_id,
		.set = py_svcctl_ChangeServiceConfigA_out_set_tag_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dependencies"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_dependencies,
		.set = py_svcctl_ChangeServiceConfigA_in_set_dependencies,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_service_start_name"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_service_start_name,
		.set = py_svcctl_ChangeServiceConfigA_in_set_service_start_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_password"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_password,
		.set = py_svcctl_ChangeServiceConfigA_in_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_display_name"),
		.get = py_svcctl_ChangeServiceConfigA_in_get_display_name,
		.set = py_svcctl_ChangeServiceConfigA_in_set_display_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_ChangeServiceConfigA_get_result,
		.set = py_svcctl_ChangeServiceConfigA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_ChangeServiceConfigA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_ChangeServiceConfigA, type);
	struct svcctl_ChangeServiceConfigA *_self = (struct svcctl_ChangeServiceConfigA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.tag_id = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(23);
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfigA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[23];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ChangeServiceConfigA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ChangeServiceConfigA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfigA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[23];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ChangeServiceConfigA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ChangeServiceConfigA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfigA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfigA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[23];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ChangeServiceConfigA_ndr_print(py_obj, "svcctl_ChangeServiceConfigA_in", NDR_IN);
}

static PyObject *py_svcctl_ChangeServiceConfigA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ChangeServiceConfigA_ndr_print(py_obj, "svcctl_ChangeServiceConfigA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_ChangeServiceConfigA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_ChangeServiceConfigA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.ChangeServiceConfigA.opnum() -> 23 (0x17) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfigA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_ChangeServiceConfigA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_ChangeServiceConfigA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_ChangeServiceConfigA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.ChangeServiceConfigA",
	.tp_getset = py_svcctl_ChangeServiceConfigA_getsetters,
	.tp_methods = py_svcctl_ChangeServiceConfigA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_ChangeServiceConfigA_new,
};

static bool pack_py_svcctl_ChangeServiceConfigA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ChangeServiceConfigA *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_load_order_group;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	PyObject *py_display_name;
	const char *kwnames[] = {
		"handle", "type", "start_type", "error_control", "binary_path", "load_order_group", "dependencies", "service_start_name", "password", "display_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOO:svcctl_ChangeServiceConfigA", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_load_order_group, &py_dependencies, &py_service_start_name, &py_password, &py_display_name)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_start_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.start_type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.start_type));
		if (PyLong_Check(py_start_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_start_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_error_control == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.error_control");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.error_control));
		if (PyLong_Check(py_error_control)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_error_control);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_binary_path == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.binary_path");
		return false;
	}
	if (py_binary_path == Py_None) {
		r->in.binary_path = NULL;
	} else {
		r->in.binary_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_binary_path)) {
				unicode = PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_binary_path)) {
				test_str = PyBytes_AS_STRING(py_binary_path);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_binary_path)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.binary_path = talloc_str;
		}
	}
	if (py_load_order_group == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.load_order_group");
		return false;
	}
	if (py_load_order_group == Py_None) {
		r->in.load_order_group = NULL;
	} else {
		r->in.load_order_group = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_load_order_group)) {
				unicode = PyUnicode_AsEncodedString(py_load_order_group, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_load_order_group)) {
				test_str = PyBytes_AS_STRING(py_load_order_group);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_load_order_group)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.load_order_group = talloc_str;
		}
	}
	if (py_dependencies == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.dependencies");
		return false;
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_dependencies)) {
				unicode = PyUnicode_AsEncodedString(py_dependencies, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_dependencies)) {
				test_str = PyBytes_AS_STRING(py_dependencies);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_dependencies)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.dependencies = talloc_str;
		}
	}
	if (py_service_start_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_start_name");
		return false;
	}
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_start_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_start_name)) {
				test_str = PyBytes_AS_STRING(py_service_start_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_start_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_start_name = talloc_str;
		}
	}
	if (py_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.password");
		return false;
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_password)) {
				unicode = PyUnicode_AsEncodedString(py_password, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_password)) {
				test_str = PyBytes_AS_STRING(py_password);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_password)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.password = talloc_str;
		}
	}
	if (py_display_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.display_name");
		return false;
	}
	if (py_display_name == Py_None) {
		r->in.display_name = NULL;
	} else {
		r->in.display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_display_name)) {
				unicode = PyUnicode_AsEncodedString(py_display_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_display_name)) {
				test_str = PyBytes_AS_STRING(py_display_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_display_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.display_name = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_ChangeServiceConfigA_args_out(struct svcctl_ChangeServiceConfigA *r)
{
	PyObject *result;
	PyObject *py_tag_id;
	py_tag_id = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.tag_id));
	result = py_tag_id;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_CreateServiceA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_CreateServiceA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_ServiceName(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_ServiceName;
	if (object->in.ServiceName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.ServiceName == NULL) {
		py_ServiceName = Py_None;
		Py_INCREF(py_ServiceName);
	} else {
		if (object->in.ServiceName == NULL) {
			py_ServiceName = Py_None;
			Py_INCREF(py_ServiceName);
		} else {
			py_ServiceName = PyUnicode_Decode(object->in.ServiceName, strlen(object->in.ServiceName), "utf-8", "ignore");
		}
	}
	return py_ServiceName;
}

static int py_svcctl_CreateServiceA_in_set_ServiceName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ServiceName");
		return -1;
	}
	if (value == Py_None) {
		object->in.ServiceName = NULL;
	} else {
		object->in.ServiceName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.ServiceName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_DisplayName(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_DisplayName;
	if (object->in.DisplayName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.DisplayName == NULL) {
		py_DisplayName = Py_None;
		Py_INCREF(py_DisplayName);
	} else {
		if (object->in.DisplayName == NULL) {
			py_DisplayName = Py_None;
			Py_INCREF(py_DisplayName);
		} else {
			py_DisplayName = PyUnicode_Decode(object->in.DisplayName, strlen(object->in.DisplayName), "utf-8", "ignore");
		}
	}
	return py_DisplayName;
}

static int py_svcctl_CreateServiceA_in_set_DisplayName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.DisplayName");
		return -1;
	}
	if (value == Py_None) {
		object->in.DisplayName = NULL;
	} else {
		object->in.DisplayName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.DisplayName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_desired_access(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_desired_access;
	py_desired_access = PyLong_FromUnsignedLongLong((uint32_t)(object->in.desired_access));
	return py_desired_access;
}

static int py_svcctl_CreateServiceA_in_set_desired_access(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.desired_access");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.desired_access));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.desired_access = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_type(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.type));
	return py_type;
}

static int py_svcctl_CreateServiceA_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_start_type(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_start_type;
	py_start_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.start_type));
	return py_start_type;
}

static int py_svcctl_CreateServiceA_in_set_start_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.start_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.start_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_error_control(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_error_control;
	py_error_control = PyLong_FromUnsignedLongLong((uint32_t)(object->in.error_control));
	return py_error_control;
}

static int py_svcctl_CreateServiceA_in_set_error_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.error_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.error_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_binary_path(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_binary_path;
	if (object->in.binary_path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.binary_path == NULL) {
		py_binary_path = Py_None;
		Py_INCREF(py_binary_path);
	} else {
		if (object->in.binary_path == NULL) {
			py_binary_path = Py_None;
			Py_INCREF(py_binary_path);
		} else {
			py_binary_path = PyUnicode_Decode(object->in.binary_path, strlen(object->in.binary_path), "utf-8", "ignore");
		}
	}
	return py_binary_path;
}

static int py_svcctl_CreateServiceA_in_set_binary_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.binary_path");
		return -1;
	}
	if (value == Py_None) {
		object->in.binary_path = NULL;
	} else {
		object->in.binary_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.binary_path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_LoadOrderGroupKey(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_LoadOrderGroupKey;
	if (object->in.LoadOrderGroupKey == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.LoadOrderGroupKey == NULL) {
		py_LoadOrderGroupKey = Py_None;
		Py_INCREF(py_LoadOrderGroupKey);
	} else {
		if (object->in.LoadOrderGroupKey == NULL) {
			py_LoadOrderGroupKey = Py_None;
			Py_INCREF(py_LoadOrderGroupKey);
		} else {
			py_LoadOrderGroupKey = PyUnicode_Decode(object->in.LoadOrderGroupKey, strlen(object->in.LoadOrderGroupKey), "utf-8", "ignore");
		}
	}
	return py_LoadOrderGroupKey;
}

static int py_svcctl_CreateServiceA_in_set_LoadOrderGroupKey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.LoadOrderGroupKey");
		return -1;
	}
	if (value == Py_None) {
		object->in.LoadOrderGroupKey = NULL;
	} else {
		object->in.LoadOrderGroupKey = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.LoadOrderGroupKey = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_out_get_TagId(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_TagId;
	if (object->out.TagId == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.TagId == NULL) {
		py_TagId = Py_None;
		Py_INCREF(py_TagId);
	} else {
		py_TagId = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.TagId));
	}
	return py_TagId;
}

static int py_svcctl_CreateServiceA_out_set_TagId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.TagId));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.TagId");
		return -1;
	}
	if (value == Py_None) {
		object->out.TagId = NULL;
	} else {
		object->out.TagId = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.TagId);
		if (object->out.TagId == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.TagId));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.TagId = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_dependencies(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_dependencies;
	if (object->in.dependencies == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.dependencies == NULL) {
		py_dependencies = Py_None;
		Py_INCREF(py_dependencies);
	} else {
		if (object->in.dependencies == NULL) {
			py_dependencies = Py_None;
			Py_INCREF(py_dependencies);
		} else {
			py_dependencies = PyUnicode_Decode(object->in.dependencies, strlen(object->in.dependencies), "utf-8", "ignore");
		}
	}
	return py_dependencies;
}

static int py_svcctl_CreateServiceA_in_set_dependencies(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.dependencies");
		return -1;
	}
	if (value == Py_None) {
		object->in.dependencies = NULL;
	} else {
		object->in.dependencies = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.dependencies = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_service_start_name(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_service_start_name;
	if (object->in.service_start_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_start_name == NULL) {
		py_service_start_name = Py_None;
		Py_INCREF(py_service_start_name);
	} else {
		if (object->in.service_start_name == NULL) {
			py_service_start_name = Py_None;
			Py_INCREF(py_service_start_name);
		} else {
			py_service_start_name = PyUnicode_Decode(object->in.service_start_name, strlen(object->in.service_start_name), "utf-8", "ignore");
		}
	}
	return py_service_start_name;
}

static int py_svcctl_CreateServiceA_in_set_service_start_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_start_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_start_name = NULL;
	} else {
		object->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_start_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_in_get_password(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->in.password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->in.password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->in.password, strlen(object->in.password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_svcctl_CreateServiceA_in_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.password");
		return -1;
	}
	if (value == Py_None) {
		object->in.password = NULL;
	} else {
		object->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_CreateServiceA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_CreateServiceA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_CreateServiceA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_CreateServiceA_in_get_handle,
		.set = py_svcctl_CreateServiceA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_ServiceName"),
		.get = py_svcctl_CreateServiceA_in_get_ServiceName,
		.set = py_svcctl_CreateServiceA_in_set_ServiceName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_DisplayName"),
		.get = py_svcctl_CreateServiceA_in_get_DisplayName,
		.set = py_svcctl_CreateServiceA_in_set_DisplayName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_desired_access"),
		.get = py_svcctl_CreateServiceA_in_get_desired_access,
		.set = py_svcctl_CreateServiceA_in_set_desired_access,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_svcctl_CreateServiceA_in_get_type,
		.set = py_svcctl_CreateServiceA_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_start_type"),
		.get = py_svcctl_CreateServiceA_in_get_start_type,
		.set = py_svcctl_CreateServiceA_in_set_start_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_StartType")
	},
	{
		.name = discard_const_p(char, "in_error_control"),
		.get = py_svcctl_CreateServiceA_in_get_error_control,
		.set = py_svcctl_CreateServiceA_in_set_error_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ErrorControl")
	},
	{
		.name = discard_const_p(char, "in_binary_path"),
		.get = py_svcctl_CreateServiceA_in_get_binary_path,
		.set = py_svcctl_CreateServiceA_in_set_binary_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_LoadOrderGroupKey"),
		.get = py_svcctl_CreateServiceA_in_get_LoadOrderGroupKey,
		.set = py_svcctl_CreateServiceA_in_set_LoadOrderGroupKey,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_TagId"),
		.get = py_svcctl_CreateServiceA_out_get_TagId,
		.set = py_svcctl_CreateServiceA_out_set_TagId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dependencies"),
		.get = py_svcctl_CreateServiceA_in_get_dependencies,
		.set = py_svcctl_CreateServiceA_in_set_dependencies,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_service_start_name"),
		.get = py_svcctl_CreateServiceA_in_get_service_start_name,
		.set = py_svcctl_CreateServiceA_in_set_service_start_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_password"),
		.get = py_svcctl_CreateServiceA_in_get_password,
		.set = py_svcctl_CreateServiceA_in_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_CreateServiceA_get_result,
		.set = py_svcctl_CreateServiceA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_CreateServiceA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_CreateServiceA, type);
	struct svcctl_CreateServiceA *_self = (struct svcctl_CreateServiceA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_CreateServiceA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(24);
}

static PyObject *py_svcctl_CreateServiceA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CreateServiceA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[24];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_CreateServiceA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_CreateServiceA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_CreateServiceA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_CreateServiceA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_CreateServiceA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CreateServiceA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[24];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_CreateServiceA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_CreateServiceA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_CreateServiceA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_CreateServiceA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_CreateServiceA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_CreateServiceA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_CreateServiceA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[24];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_CreateServiceA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_CreateServiceA_ndr_print(py_obj, "svcctl_CreateServiceA_in", NDR_IN);
}

static PyObject *py_svcctl_CreateServiceA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_CreateServiceA_ndr_print(py_obj, "svcctl_CreateServiceA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_CreateServiceA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_CreateServiceA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.CreateServiceA.opnum() -> 24 (0x18) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_CreateServiceA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_CreateServiceA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_CreateServiceA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_CreateServiceA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.CreateServiceA",
	.tp_getset = py_svcctl_CreateServiceA_getsetters,
	.tp_methods = py_svcctl_CreateServiceA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_CreateServiceA_new,
};

static bool pack_py_svcctl_CreateServiceA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_CreateServiceA *r)
{
	PyObject *py_handle;
	PyObject *py_ServiceName;
	PyObject *py_DisplayName;
	PyObject *py_desired_access;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_LoadOrderGroupKey;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	const char *kwnames[] = {
		"handle", "ServiceName", "DisplayName", "desired_access", "type", "start_type", "error_control", "binary_path", "LoadOrderGroupKey", "dependencies", "service_start_name", "password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOO:svcctl_CreateServiceA", discard_const_p(char *, kwnames), &py_handle, &py_ServiceName, &py_DisplayName, &py_desired_access, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_LoadOrderGroupKey, &py_dependencies, &py_service_start_name, &py_password)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_ServiceName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ServiceName");
		return false;
	}
	if (py_ServiceName == Py_None) {
		r->in.ServiceName = NULL;
	} else {
		r->in.ServiceName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_ServiceName)) {
				unicode = PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_ServiceName)) {
				test_str = PyBytes_AS_STRING(py_ServiceName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ServiceName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.ServiceName = talloc_str;
		}
	}
	if (py_DisplayName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.DisplayName");
		return false;
	}
	if (py_DisplayName == Py_None) {
		r->in.DisplayName = NULL;
	} else {
		r->in.DisplayName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_DisplayName)) {
				unicode = PyUnicode_AsEncodedString(py_DisplayName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_DisplayName)) {
				test_str = PyBytes_AS_STRING(py_DisplayName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_DisplayName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.DisplayName = talloc_str;
		}
	}
	if (py_desired_access == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.desired_access");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.desired_access));
		if (PyLong_Check(py_desired_access)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_desired_access);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.desired_access = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_start_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.start_type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.start_type));
		if (PyLong_Check(py_start_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_start_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.start_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_error_control == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.error_control");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.error_control));
		if (PyLong_Check(py_error_control)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_error_control);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.error_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_binary_path == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.binary_path");
		return false;
	}
	if (py_binary_path == Py_None) {
		r->in.binary_path = NULL;
	} else {
		r->in.binary_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_binary_path)) {
				unicode = PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_binary_path)) {
				test_str = PyBytes_AS_STRING(py_binary_path);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_binary_path)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.binary_path = talloc_str;
		}
	}
	if (py_LoadOrderGroupKey == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.LoadOrderGroupKey");
		return false;
	}
	if (py_LoadOrderGroupKey == Py_None) {
		r->in.LoadOrderGroupKey = NULL;
	} else {
		r->in.LoadOrderGroupKey = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_LoadOrderGroupKey)) {
				unicode = PyUnicode_AsEncodedString(py_LoadOrderGroupKey, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_LoadOrderGroupKey)) {
				test_str = PyBytes_AS_STRING(py_LoadOrderGroupKey);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_LoadOrderGroupKey)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.LoadOrderGroupKey = talloc_str;
		}
	}
	if (py_dependencies == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.dependencies");
		return false;
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_dependencies)) {
				unicode = PyUnicode_AsEncodedString(py_dependencies, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_dependencies)) {
				test_str = PyBytes_AS_STRING(py_dependencies);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_dependencies)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.dependencies = talloc_str;
		}
	}
	if (py_service_start_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_start_name");
		return false;
	}
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_start_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_start_name)) {
				test_str = PyBytes_AS_STRING(py_service_start_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_start_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_start_name = talloc_str;
		}
	}
	if (py_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.password");
		return false;
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_password)) {
				unicode = PyUnicode_AsEncodedString(py_password, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_password)) {
				test_str = PyBytes_AS_STRING(py_password);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_password)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.password = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_CreateServiceA_args_out(struct svcctl_CreateServiceA *r)
{
	PyObject *result;
	PyObject *py_TagId;
	if (r->out.TagId == NULL) {
		py_TagId = Py_None;
		Py_INCREF(py_TagId);
	} else {
		py_TagId = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.TagId));
	}
	result = py_TagId;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_EnumDependentServicesA_in_get_service(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(obj);
	PyObject *py_service;
	if (object->in.service == NULL) {
		Py_RETURN_NONE;
	}
	py_service = pytalloc_reference_ex(policy_handle_Type, object->in.service, object->in.service);
	return py_service;
}

static int py_svcctl_EnumDependentServicesA_in_set_service(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.service));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service");
		return -1;
	}
	object->in.service = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.service);
	if (object->in.service == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.service = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesA_in_get_state(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(obj);
	PyObject *py_state;
	py_state = PyLong_FromUnsignedLongLong((uint32_t)(object->in.state));
	return py_state;
}

static int py_svcctl_EnumDependentServicesA_in_set_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesA_out_get_service_status(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(obj);
	PyObject *py_service_status;
	if (object->out.service_status == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.service_status == NULL) {
		py_service_status = Py_None;
		Py_INCREF(py_service_status);
	} else {
		py_service_status = pytalloc_reference_ex(&ENUM_SERVICE_STATUSA_Type, object->out.service_status, object->out.service_status);
	}
	return py_service_status;
}

static int py_svcctl_EnumDependentServicesA_out_set_service_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.service_status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.service_status");
		return -1;
	}
	if (value == Py_None) {
		object->out.service_status = NULL;
	} else {
		object->out.service_status = NULL;
		PY_CHECK_TYPE(&ENUM_SERVICE_STATUSA_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->out.service_status = (struct ENUM_SERVICE_STATUSA *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesA_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_EnumDependentServicesA_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesA_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_EnumDependentServicesA_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesA_out_get_services_returned(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(obj);
	PyObject *py_services_returned;
	if (object->out.services_returned == NULL) {
		Py_RETURN_NONE;
	}
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.services_returned));
	return py_services_returned;
}

static int py_svcctl_EnumDependentServicesA_out_set_services_returned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.services_returned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.services_returned");
		return -1;
	}
	object->out.services_returned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.services_returned);
	if (object->out.services_returned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.services_returned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.services_returned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumDependentServicesA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_EnumDependentServicesA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_EnumDependentServicesA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_service"),
		.get = py_svcctl_EnumDependentServicesA_in_get_service,
		.set = py_svcctl_EnumDependentServicesA_in_set_service,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_state"),
		.get = py_svcctl_EnumDependentServicesA_in_get_state,
		.set = py_svcctl_EnumDependentServicesA_in_set_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServiceState")
	},
	{
		.name = discard_const_p(char, "out_service_status"),
		.get = py_svcctl_EnumDependentServicesA_out_get_service_status,
		.set = py_svcctl_EnumDependentServicesA_out_set_service_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type ENUM_SERVICE_STATUSA")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_EnumDependentServicesA_in_get_offered,
		.set = py_svcctl_EnumDependentServicesA_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_EnumDependentServicesA_out_get_needed,
		.set = py_svcctl_EnumDependentServicesA_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_services_returned"),
		.get = py_svcctl_EnumDependentServicesA_out_get_services_returned,
		.set = py_svcctl_EnumDependentServicesA_out_set_services_returned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_EnumDependentServicesA_get_result,
		.set = py_svcctl_EnumDependentServicesA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_EnumDependentServicesA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_EnumDependentServicesA, type);
	struct svcctl_EnumDependentServicesA *_self = (struct svcctl_EnumDependentServicesA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.service = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	_self->out.services_returned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(25);
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumDependentServicesA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[25];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumDependentServicesA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumDependentServicesA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumDependentServicesA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[25];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumDependentServicesA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumDependentServicesA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumDependentServicesA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumDependentServicesA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[25];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumDependentServicesA_ndr_print(py_obj, "svcctl_EnumDependentServicesA_in", NDR_IN);
}

static PyObject *py_svcctl_EnumDependentServicesA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumDependentServicesA_ndr_print(py_obj, "svcctl_EnumDependentServicesA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_EnumDependentServicesA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_EnumDependentServicesA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.EnumDependentServicesA.opnum() -> 25 (0x19) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumDependentServicesA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_EnumDependentServicesA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_EnumDependentServicesA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_EnumDependentServicesA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.EnumDependentServicesA",
	.tp_getset = py_svcctl_EnumDependentServicesA_getsetters,
	.tp_methods = py_svcctl_EnumDependentServicesA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_EnumDependentServicesA_new,
};

static bool pack_py_svcctl_EnumDependentServicesA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumDependentServicesA *r)
{
	PyObject *py_service;
	PyObject *py_state;
	PyObject *py_offered;
	const char *kwnames[] = {
		"service", "state", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_EnumDependentServicesA", discard_const_p(char *, kwnames), &py_service, &py_state, &py_offered)) {
		return false;
	}

	if (py_service == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service");
		return false;
	}
	r->in.service = talloc_ptrtype(r, r->in.service);
	if (r->in.service == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_service, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_service)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.service = (struct policy_handle *)pytalloc_get_ptr(py_service);
	if (py_state == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.state");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.state));
		if (PyLong_Check(py_state)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_state);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_EnumDependentServicesA_args_out(struct svcctl_EnumDependentServicesA *r)
{
	PyObject *result;
	PyObject *py_service_status;
	PyObject *py_needed;
	PyObject *py_services_returned;
	result = PyTuple_New(3);
	if (r->out.service_status == NULL) {
		py_service_status = Py_None;
		Py_INCREF(py_service_status);
	} else {
		py_service_status = pytalloc_reference_ex(&ENUM_SERVICE_STATUSA_Type, r->out.service_status, r->out.service_status);
	}
	PyTuple_SetItem(result, 0, py_service_status);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.services_returned));
	PyTuple_SetItem(result, 2, py_services_returned);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_EnumServicesStatusA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_EnumServicesStatusA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_in_get_type(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.type));
	return py_type;
}

static int py_svcctl_EnumServicesStatusA_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_in_get_state(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_state;
	py_state = PyLong_FromUnsignedLongLong((uint32_t)(object->in.state));
	return py_state;
}

static int py_svcctl_EnumServicesStatusA_in_set_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_EnumServicesStatusA_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_out_get_service(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_service;
	py_service = PyList_New(object->in.offered);
	if (py_service == NULL) {
		return NULL;
	}
	{
		int service_cntr_0;
		for (service_cntr_0 = 0; service_cntr_0 < (object->in.offered); service_cntr_0++) {
			PyObject *py_service_0;
			py_service_0 = PyLong_FromLong((uint16_t)((object->out.service)[service_cntr_0]));
			PyList_SetItem(py_service, service_cntr_0, py_service_0);
		}
	}
	return py_service;
}

static int py_svcctl_EnumServicesStatusA_out_set_service(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.service");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int service_cntr_0;
		object->out.service = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.service, PyList_GET_SIZE(value));
		if (!object->out.service) { return -1; }
		talloc_set_name_const(object->out.service, "ARRAY: object->out.service");
		for (service_cntr_0 = 0; service_cntr_0 < PyList_GET_SIZE(value); service_cntr_0++) {
			if (PyList_GET_ITEM(value, service_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->out.service)[service_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.service)[service_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, service_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, service_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.service)[service_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_EnumServicesStatusA_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_out_get_services_returned(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_services_returned;
	if (object->out.services_returned == NULL) {
		Py_RETURN_NONE;
	}
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.services_returned));
	return py_services_returned;
}

static int py_svcctl_EnumServicesStatusA_out_set_services_returned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.services_returned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.services_returned");
		return -1;
	}
	object->out.services_returned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.services_returned);
	if (object->out.services_returned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.services_returned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.services_returned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_svcctl_EnumServicesStatusA_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_svcctl_EnumServicesStatusA_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_EnumServicesStatusA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_EnumServicesStatusA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_EnumServicesStatusA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_EnumServicesStatusA_in_get_handle,
		.set = py_svcctl_EnumServicesStatusA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_svcctl_EnumServicesStatusA_in_get_type,
		.set = py_svcctl_EnumServicesStatusA_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_state"),
		.get = py_svcctl_EnumServicesStatusA_in_get_state,
		.set = py_svcctl_EnumServicesStatusA_in_set_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServiceState")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_EnumServicesStatusA_in_get_offered,
		.set = py_svcctl_EnumServicesStatusA_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_service"),
		.get = py_svcctl_EnumServicesStatusA_out_get_service,
		.set = py_svcctl_EnumServicesStatusA_out_set_service,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_EnumServicesStatusA_out_get_needed,
		.set = py_svcctl_EnumServicesStatusA_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_services_returned"),
		.get = py_svcctl_EnumServicesStatusA_out_get_services_returned,
		.set = py_svcctl_EnumServicesStatusA_out_set_services_returned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_svcctl_EnumServicesStatusA_in_get_resume_handle,
		.set = py_svcctl_EnumServicesStatusA_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_svcctl_EnumServicesStatusA_out_get_resume_handle,
		.set = py_svcctl_EnumServicesStatusA_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_EnumServicesStatusA_get_result,
		.set = py_svcctl_EnumServicesStatusA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_EnumServicesStatusA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_EnumServicesStatusA, type);
	struct svcctl_EnumServicesStatusA *_self = (struct svcctl_EnumServicesStatusA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	_self->out.services_returned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(26);
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumServicesStatusA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[26];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumServicesStatusA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_EnumServicesStatusA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumServicesStatusA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[26];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumServicesStatusA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_EnumServicesStatusA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_EnumServicesStatusA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_EnumServicesStatusA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[26];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumServicesStatusA_ndr_print(py_obj, "svcctl_EnumServicesStatusA_in", NDR_IN);
}

static PyObject *py_svcctl_EnumServicesStatusA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_EnumServicesStatusA_ndr_print(py_obj, "svcctl_EnumServicesStatusA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_EnumServicesStatusA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_EnumServicesStatusA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.EnumServicesStatusA.opnum() -> 26 (0x1a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_EnumServicesStatusA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_EnumServicesStatusA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_EnumServicesStatusA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_EnumServicesStatusA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.EnumServicesStatusA",
	.tp_getset = py_svcctl_EnumServicesStatusA_getsetters,
	.tp_methods = py_svcctl_EnumServicesStatusA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_EnumServicesStatusA_new,
};

static bool pack_py_svcctl_EnumServicesStatusA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumServicesStatusA *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_state;
	PyObject *py_offered;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"handle", "type", "state", "offered", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:svcctl_EnumServicesStatusA", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_state, &py_offered, &py_resume_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_state == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.state");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.state));
		if (PyLong_Check(py_state)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_state);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		if (r->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
			if (PyLong_Check(py_resume_handle)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_EnumServicesStatusA_args_out(struct svcctl_EnumServicesStatusA *r)
{
	PyObject *result;
	PyObject *py_service;
	PyObject *py_needed;
	PyObject *py_services_returned;
	PyObject *py_resume_handle;
	result = PyTuple_New(4);
	py_service = PyList_New(r->in.offered);
	if (py_service == NULL) {
		return NULL;
	}
	{
		int service_cntr_0;
		for (service_cntr_0 = 0; service_cntr_0 < (r->in.offered); service_cntr_0++) {
			PyObject *py_service_0;
			py_service_0 = PyLong_FromLong((uint16_t)((r->out.service)[service_cntr_0]));
			PyList_SetItem(py_service, service_cntr_0, py_service_0);
		}
	}
	PyTuple_SetItem(result, 0, py_service);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.services_returned));
	PyTuple_SetItem(result, 2, py_services_returned);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	}
	PyTuple_SetItem(result, 3, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_OpenSCManagerA_in_get_MachineName(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(obj);
	PyObject *py_MachineName;
	if (object->in.MachineName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.MachineName == NULL) {
		py_MachineName = Py_None;
		Py_INCREF(py_MachineName);
	} else {
		if (object->in.MachineName == NULL) {
			py_MachineName = Py_None;
			Py_INCREF(py_MachineName);
		} else {
			py_MachineName = PyUnicode_Decode(object->in.MachineName, strlen(object->in.MachineName), "utf-8", "ignore");
		}
	}
	return py_MachineName;
}

static int py_svcctl_OpenSCManagerA_in_set_MachineName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.MachineName");
		return -1;
	}
	if (value == Py_None) {
		object->in.MachineName = NULL;
	} else {
		object->in.MachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.MachineName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerA_in_get_DatabaseName(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(obj);
	PyObject *py_DatabaseName;
	if (object->in.DatabaseName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.DatabaseName == NULL) {
		py_DatabaseName = Py_None;
		Py_INCREF(py_DatabaseName);
	} else {
		if (object->in.DatabaseName == NULL) {
			py_DatabaseName = Py_None;
			Py_INCREF(py_DatabaseName);
		} else {
			py_DatabaseName = PyUnicode_Decode(object->in.DatabaseName, strlen(object->in.DatabaseName), "utf-8", "ignore");
		}
	}
	return py_DatabaseName;
}

static int py_svcctl_OpenSCManagerA_in_set_DatabaseName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.DatabaseName");
		return -1;
	}
	if (value == Py_None) {
		object->in.DatabaseName = NULL;
	} else {
		object->in.DatabaseName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.DatabaseName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerA_in_get_access_mask(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_svcctl_OpenSCManagerA_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerA_out_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_svcctl_OpenSCManagerA_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_OpenSCManagerA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_OpenSCManagerA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_OpenSCManagerA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_MachineName"),
		.get = py_svcctl_OpenSCManagerA_in_get_MachineName,
		.set = py_svcctl_OpenSCManagerA_in_set_MachineName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_DatabaseName"),
		.get = py_svcctl_OpenSCManagerA_in_get_DatabaseName,
		.set = py_svcctl_OpenSCManagerA_in_set_DatabaseName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_svcctl_OpenSCManagerA_in_get_access_mask,
		.set = py_svcctl_OpenSCManagerA_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_svcctl_OpenSCManagerA_out_get_handle,
		.set = py_svcctl_OpenSCManagerA_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_OpenSCManagerA_get_result,
		.set = py_svcctl_OpenSCManagerA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_OpenSCManagerA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_OpenSCManagerA, type);
	struct svcctl_OpenSCManagerA *_self = (struct svcctl_OpenSCManagerA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(27);
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenSCManagerA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[27];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenSCManagerA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenSCManagerA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenSCManagerA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[27];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenSCManagerA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenSCManagerA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenSCManagerA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenSCManagerA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[27];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenSCManagerA_ndr_print(py_obj, "svcctl_OpenSCManagerA_in", NDR_IN);
}

static PyObject *py_svcctl_OpenSCManagerA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenSCManagerA_ndr_print(py_obj, "svcctl_OpenSCManagerA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_OpenSCManagerA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_OpenSCManagerA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.OpenSCManagerA.opnum() -> 27 (0x1b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenSCManagerA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_OpenSCManagerA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_OpenSCManagerA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_OpenSCManagerA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.OpenSCManagerA",
	.tp_getset = py_svcctl_OpenSCManagerA_getsetters,
	.tp_methods = py_svcctl_OpenSCManagerA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_OpenSCManagerA_new,
};

static bool pack_py_svcctl_OpenSCManagerA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenSCManagerA *r)
{
	PyObject *py_MachineName;
	PyObject *py_DatabaseName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"MachineName", "DatabaseName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenSCManagerA", discard_const_p(char *, kwnames), &py_MachineName, &py_DatabaseName, &py_access_mask)) {
		return false;
	}

	if (py_MachineName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.MachineName");
		return false;
	}
	if (py_MachineName == Py_None) {
		r->in.MachineName = NULL;
	} else {
		r->in.MachineName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_MachineName)) {
				unicode = PyUnicode_AsEncodedString(py_MachineName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_MachineName)) {
				test_str = PyBytes_AS_STRING(py_MachineName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_MachineName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.MachineName = talloc_str;
		}
	}
	if (py_DatabaseName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.DatabaseName");
		return false;
	}
	if (py_DatabaseName == Py_None) {
		r->in.DatabaseName = NULL;
	} else {
		r->in.DatabaseName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_DatabaseName)) {
				unicode = PyUnicode_AsEncodedString(py_DatabaseName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_DatabaseName)) {
				test_str = PyBytes_AS_STRING(py_DatabaseName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_DatabaseName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.DatabaseName = talloc_str;
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_OpenSCManagerA_args_out(struct svcctl_OpenSCManagerA *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_OpenServiceA_in_get_scmanager_handle(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_scmanager_handle;
	if (object->in.scmanager_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_scmanager_handle = pytalloc_reference_ex(policy_handle_Type, object->in.scmanager_handle, object->in.scmanager_handle);
	return py_scmanager_handle;
}

static int py_svcctl_OpenServiceA_in_set_scmanager_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.scmanager_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.scmanager_handle");
		return -1;
	}
	object->in.scmanager_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.scmanager_handle);
	if (object->in.scmanager_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.scmanager_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_OpenServiceA_in_get_ServiceName(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_ServiceName;
	if (object->in.ServiceName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.ServiceName == NULL) {
		py_ServiceName = Py_None;
		Py_INCREF(py_ServiceName);
	} else {
		if (object->in.ServiceName == NULL) {
			py_ServiceName = Py_None;
			Py_INCREF(py_ServiceName);
		} else {
			py_ServiceName = PyUnicode_Decode(object->in.ServiceName, strlen(object->in.ServiceName), "utf-8", "ignore");
		}
	}
	return py_ServiceName;
}

static int py_svcctl_OpenServiceA_in_set_ServiceName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ServiceName");
		return -1;
	}
	if (value == Py_None) {
		object->in.ServiceName = NULL;
	} else {
		object->in.ServiceName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.ServiceName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenServiceA_in_get_access_mask(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_svcctl_OpenServiceA_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_OpenServiceA_out_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_svcctl_OpenServiceA_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_OpenServiceA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_OpenServiceA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_OpenServiceA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_scmanager_handle"),
		.get = py_svcctl_OpenServiceA_in_get_scmanager_handle,
		.set = py_svcctl_OpenServiceA_in_set_scmanager_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_ServiceName"),
		.get = py_svcctl_OpenServiceA_in_get_ServiceName,
		.set = py_svcctl_OpenServiceA_in_set_ServiceName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_svcctl_OpenServiceA_in_get_access_mask,
		.set = py_svcctl_OpenServiceA_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_svcctl_OpenServiceA_out_get_handle,
		.set = py_svcctl_OpenServiceA_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_OpenServiceA_get_result,
		.set = py_svcctl_OpenServiceA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_OpenServiceA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_OpenServiceA, type);
	struct svcctl_OpenServiceA *_self = (struct svcctl_OpenServiceA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.scmanager_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_OpenServiceA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(28);
}

static PyObject *py_svcctl_OpenServiceA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenServiceA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[28];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_OpenServiceA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenServiceA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_OpenServiceA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_OpenServiceA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_OpenServiceA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenServiceA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[28];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_OpenServiceA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenServiceA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenServiceA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_OpenServiceA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_OpenServiceA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_OpenServiceA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_OpenServiceA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[28];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_OpenServiceA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenServiceA_ndr_print(py_obj, "svcctl_OpenServiceA_in", NDR_IN);
}

static PyObject *py_svcctl_OpenServiceA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_OpenServiceA_ndr_print(py_obj, "svcctl_OpenServiceA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_OpenServiceA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_OpenServiceA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.OpenServiceA.opnum() -> 28 (0x1c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_OpenServiceA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_OpenServiceA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_OpenServiceA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_OpenServiceA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.OpenServiceA",
	.tp_getset = py_svcctl_OpenServiceA_getsetters,
	.tp_methods = py_svcctl_OpenServiceA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_OpenServiceA_new,
};

static bool pack_py_svcctl_OpenServiceA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenServiceA *r)
{
	PyObject *py_scmanager_handle;
	PyObject *py_ServiceName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"scmanager_handle", "ServiceName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenServiceA", discard_const_p(char *, kwnames), &py_scmanager_handle, &py_ServiceName, &py_access_mask)) {
		return false;
	}

	if (py_scmanager_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.scmanager_handle");
		return false;
	}
	r->in.scmanager_handle = talloc_ptrtype(r, r->in.scmanager_handle);
	if (r->in.scmanager_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_scmanager_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.scmanager_handle = (struct policy_handle *)pytalloc_get_ptr(py_scmanager_handle);
	if (py_ServiceName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ServiceName");
		return false;
	}
	if (py_ServiceName == Py_None) {
		r->in.ServiceName = NULL;
	} else {
		r->in.ServiceName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_ServiceName)) {
				unicode = PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_ServiceName)) {
				test_str = PyBytes_AS_STRING(py_ServiceName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ServiceName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.ServiceName = talloc_str;
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_OpenServiceA_args_out(struct svcctl_OpenServiceA *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_QueryServiceConfigA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_QueryServiceConfigA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigA_out_get_query(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_query;
	py_query = PyList_New(object->in.offered);
	if (py_query == NULL) {
		return NULL;
	}
	{
		int query_cntr_0;
		for (query_cntr_0 = 0; query_cntr_0 < (object->in.offered); query_cntr_0++) {
			PyObject *py_query_0;
			py_query_0 = PyLong_FromLong((uint16_t)((object->out.query)[query_cntr_0]));
			PyList_SetItem(py_query, query_cntr_0, py_query_0);
		}
	}
	return py_query;
}

static int py_svcctl_QueryServiceConfigA_out_set_query(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.query");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int query_cntr_0;
		object->out.query = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.query, PyList_GET_SIZE(value));
		if (!object->out.query) { return -1; }
		talloc_set_name_const(object->out.query, "ARRAY: object->out.query");
		for (query_cntr_0 = 0; query_cntr_0 < PyList_GET_SIZE(value); query_cntr_0++) {
			if (PyList_GET_ITEM(value, query_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->out.query)[query_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.query)[query_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, query_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, query_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.query)[query_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigA_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_QueryServiceConfigA_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigA_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_QueryServiceConfigA_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceConfigA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_QueryServiceConfigA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_QueryServiceConfigA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_QueryServiceConfigA_in_get_handle,
		.set = py_svcctl_QueryServiceConfigA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_query"),
		.get = py_svcctl_QueryServiceConfigA_out_get_query,
		.set = py_svcctl_QueryServiceConfigA_out_set_query,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_QueryServiceConfigA_in_get_offered,
		.set = py_svcctl_QueryServiceConfigA_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_QueryServiceConfigA_out_get_needed,
		.set = py_svcctl_QueryServiceConfigA_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_QueryServiceConfigA_get_result,
		.set = py_svcctl_QueryServiceConfigA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_QueryServiceConfigA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_QueryServiceConfigA, type);
	struct svcctl_QueryServiceConfigA *_self = (struct svcctl_QueryServiceConfigA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(29);
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceConfigA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[29];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceConfigA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceConfigA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceConfigA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[29];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceConfigA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceConfigA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceConfigA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceConfigA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[29];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceConfigA_ndr_print(py_obj, "svcctl_QueryServiceConfigA_in", NDR_IN);
}

static PyObject *py_svcctl_QueryServiceConfigA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceConfigA_ndr_print(py_obj, "svcctl_QueryServiceConfigA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_QueryServiceConfigA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_QueryServiceConfigA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.QueryServiceConfigA.opnum() -> 29 (0x1d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceConfigA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_QueryServiceConfigA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_QueryServiceConfigA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_QueryServiceConfigA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.QueryServiceConfigA",
	.tp_getset = py_svcctl_QueryServiceConfigA_getsetters,
	.tp_methods = py_svcctl_QueryServiceConfigA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_QueryServiceConfigA_new,
};

static bool pack_py_svcctl_QueryServiceConfigA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceConfigA *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceConfigA", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceConfigA_args_out(struct svcctl_QueryServiceConfigA *r)
{
	PyObject *result;
	PyObject *py_query;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_query = PyList_New(r->in.offered);
	if (py_query == NULL) {
		return NULL;
	}
	{
		int query_cntr_0;
		for (query_cntr_0 = 0; query_cntr_0 < (r->in.offered); query_cntr_0++) {
			PyObject *py_query_0;
			py_query_0 = PyLong_FromLong((uint16_t)((r->out.query)[query_cntr_0]));
			PyList_SetItem(py_query, query_cntr_0, py_query_0);
		}
	}
	PyTuple_SetItem(result, 0, py_query);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_QueryServiceLockStatusA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_QueryServiceLockStatusA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_in_get_offered(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_offered;
	py_offered = PyLong_FromUnsignedLongLong((uint32_t)(object->in.offered));
	return py_offered;
}

static int py_svcctl_QueryServiceLockStatusA_in_set_offered(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.offered");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.offered));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_out_get_lock_status(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_status;
	if (object->out.lock_status == NULL) {
		Py_RETURN_NONE;
	}
	py_lock_status = pytalloc_reference_ex(&SERVICE_LOCK_STATUS_Type, object->out.lock_status, object->out.lock_status);
	return py_lock_status;
}

static int py_svcctl_QueryServiceLockStatusA_out_set_lock_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.lock_status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.lock_status");
		return -1;
	}
	object->out.lock_status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.lock_status);
	if (object->out.lock_status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&SERVICE_LOCK_STATUS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.lock_status = (struct SERVICE_LOCK_STATUS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_out_get_needed(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_needed;
	if (object->out.needed == NULL) {
		Py_RETURN_NONE;
	}
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.needed));
	return py_needed;
}

static int py_svcctl_QueryServiceLockStatusA_out_set_needed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.needed));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.needed");
		return -1;
	}
	object->out.needed = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.needed);
	if (object->out.needed == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.needed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.needed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_QueryServiceLockStatusA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_QueryServiceLockStatusA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_QueryServiceLockStatusA_in_get_handle,
		.set = py_svcctl_QueryServiceLockStatusA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_offered"),
		.get = py_svcctl_QueryServiceLockStatusA_in_get_offered,
		.set = py_svcctl_QueryServiceLockStatusA_in_set_offered,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_lock_status"),
		.get = py_svcctl_QueryServiceLockStatusA_out_get_lock_status,
		.set = py_svcctl_QueryServiceLockStatusA_out_set_lock_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type SERVICE_LOCK_STATUS")
	},
	{
		.name = discard_const_p(char, "out_needed"),
		.get = py_svcctl_QueryServiceLockStatusA_out_get_needed,
		.set = py_svcctl_QueryServiceLockStatusA_out_set_needed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_QueryServiceLockStatusA_get_result,
		.set = py_svcctl_QueryServiceLockStatusA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_QueryServiceLockStatusA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_QueryServiceLockStatusA, type);
	struct svcctl_QueryServiceLockStatusA *_self = (struct svcctl_QueryServiceLockStatusA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.lock_status = talloc_zero(mem_ctx, struct SERVICE_LOCK_STATUS);
	_self->out.needed = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(30);
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceLockStatusA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[30];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceLockStatusA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_QueryServiceLockStatusA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceLockStatusA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[30];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceLockStatusA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_QueryServiceLockStatusA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_QueryServiceLockStatusA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_QueryServiceLockStatusA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[30];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceLockStatusA_ndr_print(py_obj, "svcctl_QueryServiceLockStatusA_in", NDR_IN);
}

static PyObject *py_svcctl_QueryServiceLockStatusA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_QueryServiceLockStatusA_ndr_print(py_obj, "svcctl_QueryServiceLockStatusA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_QueryServiceLockStatusA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_QueryServiceLockStatusA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.QueryServiceLockStatusA.opnum() -> 30 (0x1e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_QueryServiceLockStatusA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_QueryServiceLockStatusA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_QueryServiceLockStatusA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_QueryServiceLockStatusA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.QueryServiceLockStatusA",
	.tp_getset = py_svcctl_QueryServiceLockStatusA_getsetters,
	.tp_methods = py_svcctl_QueryServiceLockStatusA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_QueryServiceLockStatusA_new,
};

static bool pack_py_svcctl_QueryServiceLockStatusA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceLockStatusA *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceLockStatusA", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_offered == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.offered");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.offered));
		if (PyLong_Check(py_offered)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_offered);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.offered = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceLockStatusA_args_out(struct svcctl_QueryServiceLockStatusA *r)
{
	PyObject *result;
	PyObject *py_lock_status;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_lock_status = pytalloc_reference_ex(&SERVICE_LOCK_STATUS_Type, r->out.lock_status, r->out.lock_status);
	PyTuple_SetItem(result, 0, py_lock_status);
	py_needed = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.needed));
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_StartServiceA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_StartServiceA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_StartServiceA_in_get_NumArgs(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_NumArgs;
	py_NumArgs = PyLong_FromUnsignedLongLong((uint32_t)(object->in.NumArgs));
	return py_NumArgs;
}

static int py_svcctl_StartServiceA_in_set_NumArgs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.NumArgs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.NumArgs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.NumArgs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_StartServiceA_in_get_Arguments(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_Arguments;
	if (object->in.Arguments == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.Arguments == NULL) {
		py_Arguments = Py_None;
		Py_INCREF(py_Arguments);
	} else {
		if (object->in.Arguments == NULL) {
			py_Arguments = Py_None;
			Py_INCREF(py_Arguments);
		} else {
			py_Arguments = PyUnicode_Decode(object->in.Arguments, strlen(object->in.Arguments), "utf-8", "ignore");
		}
	}
	return py_Arguments;
}

static int py_svcctl_StartServiceA_in_set_Arguments(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.Arguments");
		return -1;
	}
	if (value == Py_None) {
		object->in.Arguments = NULL;
	} else {
		object->in.Arguments = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.Arguments = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_StartServiceA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_StartServiceA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_StartServiceA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_StartServiceA_in_get_handle,
		.set = py_svcctl_StartServiceA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_NumArgs"),
		.get = py_svcctl_StartServiceA_in_get_NumArgs,
		.set = py_svcctl_StartServiceA_in_set_NumArgs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_Arguments"),
		.get = py_svcctl_StartServiceA_in_get_Arguments,
		.set = py_svcctl_StartServiceA_in_set_Arguments,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_StartServiceA_get_result,
		.set = py_svcctl_StartServiceA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_StartServiceA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_StartServiceA, type);
	struct svcctl_StartServiceA *_self = (struct svcctl_StartServiceA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_StartServiceA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(31);
}

static PyObject *py_svcctl_StartServiceA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_StartServiceA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[31];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_StartServiceA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_StartServiceA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_StartServiceA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_StartServiceA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_StartServiceA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_StartServiceA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[31];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_StartServiceA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_StartServiceA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_StartServiceA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_StartServiceA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_StartServiceA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_StartServiceA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_StartServiceA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[31];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_StartServiceA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_StartServiceA_ndr_print(py_obj, "svcctl_StartServiceA_in", NDR_IN);
}

static PyObject *py_svcctl_StartServiceA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_StartServiceA_ndr_print(py_obj, "svcctl_StartServiceA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_StartServiceA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_StartServiceA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.StartServiceA.opnum() -> 31 (0x1f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_StartServiceA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_StartServiceA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_StartServiceA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_StartServiceA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.StartServiceA",
	.tp_getset = py_svcctl_StartServiceA_getsetters,
	.tp_methods = py_svcctl_StartServiceA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_StartServiceA_new,
};

static bool pack_py_svcctl_StartServiceA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_StartServiceA *r)
{
	PyObject *py_handle;
	PyObject *py_NumArgs;
	PyObject *py_Arguments;
	const char *kwnames[] = {
		"handle", "NumArgs", "Arguments", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_StartServiceA", discard_const_p(char *, kwnames), &py_handle, &py_NumArgs, &py_Arguments)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_NumArgs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.NumArgs");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.NumArgs));
		if (PyLong_Check(py_NumArgs)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_NumArgs);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.NumArgs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_Arguments == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.Arguments");
		return false;
	}
	if (py_Arguments == Py_None) {
		r->in.Arguments = NULL;
	} else {
		r->in.Arguments = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_Arguments)) {
				unicode = PyUnicode_AsEncodedString(py_Arguments, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_Arguments)) {
				test_str = PyBytes_AS_STRING(py_Arguments);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_Arguments)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.Arguments = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_StartServiceA_args_out(struct svcctl_StartServiceA *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_GetServiceDisplayNameA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_GetServiceDisplayNameA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_in_get_service_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_service_name;
	if (object->in.service_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_name == NULL) {
		py_service_name = Py_None;
		Py_INCREF(py_service_name);
	} else {
		if (object->in.service_name == NULL) {
			py_service_name = Py_None;
			Py_INCREF(py_service_name);
		} else {
			py_service_name = PyUnicode_Decode(object->in.service_name, strlen(object->in.service_name), "utf-8", "ignore");
		}
	}
	return py_service_name;
}

static int py_svcctl_GetServiceDisplayNameA_in_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_name = NULL;
	} else {
		object->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_out_get_display_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name;
	if (object->out.display_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		if (*object->out.display_name == NULL) {
			py_display_name = Py_None;
			Py_INCREF(py_display_name);
		} else {
			py_display_name = PyUnicode_Decode(*object->out.display_name, strlen(*object->out.display_name), "utf-8", "ignore");
		}
	}
	return py_display_name;
}

static int py_svcctl_GetServiceDisplayNameA_out_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.display_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.display_name");
		return -1;
	}
	object->out.display_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.display_name);
	if (object->out.display_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.display_name = NULL;
	} else {
		*object->out.display_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.display_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_in_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->in.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceDisplayNameA_in_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->in.display_name_length = NULL;
	} else {
		object->in.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.display_name_length);
		if (object->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_out_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->out.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceDisplayNameA_out_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->out.display_name_length = NULL;
	} else {
		object->out.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.display_name_length);
		if (object->out.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_GetServiceDisplayNameA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_GetServiceDisplayNameA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_GetServiceDisplayNameA_in_get_handle,
		.set = py_svcctl_GetServiceDisplayNameA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_service_name"),
		.get = py_svcctl_GetServiceDisplayNameA_in_get_service_name,
		.set = py_svcctl_GetServiceDisplayNameA_in_set_service_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_display_name"),
		.get = py_svcctl_GetServiceDisplayNameA_out_get_display_name,
		.set = py_svcctl_GetServiceDisplayNameA_out_set_display_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_display_name_length"),
		.get = py_svcctl_GetServiceDisplayNameA_in_get_display_name_length,
		.set = py_svcctl_GetServiceDisplayNameA_in_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_display_name_length"),
		.get = py_svcctl_GetServiceDisplayNameA_out_get_display_name_length,
		.set = py_svcctl_GetServiceDisplayNameA_out_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_GetServiceDisplayNameA_get_result,
		.set = py_svcctl_GetServiceDisplayNameA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_GetServiceDisplayNameA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_GetServiceDisplayNameA, type);
	struct svcctl_GetServiceDisplayNameA *_self = (struct svcctl_GetServiceDisplayNameA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(32);
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceDisplayNameA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[32];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceDisplayNameA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceDisplayNameA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceDisplayNameA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[32];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceDisplayNameA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceDisplayNameA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceDisplayNameA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceDisplayNameA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[32];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceDisplayNameA_ndr_print(py_obj, "svcctl_GetServiceDisplayNameA_in", NDR_IN);
}

static PyObject *py_svcctl_GetServiceDisplayNameA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceDisplayNameA_ndr_print(py_obj, "svcctl_GetServiceDisplayNameA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_GetServiceDisplayNameA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_GetServiceDisplayNameA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.GetServiceDisplayNameA.opnum() -> 32 (0x20) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceDisplayNameA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_GetServiceDisplayNameA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_GetServiceDisplayNameA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_GetServiceDisplayNameA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.GetServiceDisplayNameA",
	.tp_getset = py_svcctl_GetServiceDisplayNameA_getsetters,
	.tp_methods = py_svcctl_GetServiceDisplayNameA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_GetServiceDisplayNameA_new,
};

static bool pack_py_svcctl_GetServiceDisplayNameA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceDisplayNameA *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceDisplayNameA", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_service_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_name");
		return false;
	}
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_name)) {
				test_str = PyBytes_AS_STRING(py_service_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_name = talloc_str;
		}
	}
	if (py_display_name_length == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.display_name_length");
		return false;
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		if (r->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.display_name_length));
			if (PyLong_Check(py_display_name_length)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_display_name_length);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceDisplayNameA_args_out(struct svcctl_GetServiceDisplayNameA *r)
{
	PyObject *result;
	PyObject *py_display_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.display_name == NULL) {
		py_display_name = Py_None;
		Py_INCREF(py_display_name);
	} else {
		if (*r->out.display_name == NULL) {
			py_display_name = Py_None;
			Py_INCREF(py_display_name);
		} else {
			py_display_name = PyUnicode_Decode(*r->out.display_name, strlen(*r->out.display_name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 0, py_display_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.display_name_length));
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_GetServiceKeyNameA_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_GetServiceKeyNameA_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameA_in_get_service_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_service_name;
	if (object->in.service_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.service_name == NULL) {
		py_service_name = Py_None;
		Py_INCREF(py_service_name);
	} else {
		if (object->in.service_name == NULL) {
			py_service_name = Py_None;
			Py_INCREF(py_service_name);
		} else {
			py_service_name = PyUnicode_Decode(object->in.service_name, strlen(object->in.service_name), "utf-8", "ignore");
		}
	}
	return py_service_name;
}

static int py_svcctl_GetServiceKeyNameA_in_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.service_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.service_name = NULL;
	} else {
		object->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.service_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameA_out_get_key_name(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_key_name;
	if (object->out.key_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.key_name == NULL) {
		py_key_name = Py_None;
		Py_INCREF(py_key_name);
	} else {
		if (*object->out.key_name == NULL) {
			py_key_name = Py_None;
			Py_INCREF(py_key_name);
		} else {
			py_key_name = PyUnicode_Decode(*object->out.key_name, strlen(*object->out.key_name), "utf-8", "ignore");
		}
	}
	return py_key_name;
}

static int py_svcctl_GetServiceKeyNameA_out_set_key_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.key_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.key_name");
		return -1;
	}
	object->out.key_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.key_name);
	if (object->out.key_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.key_name = NULL;
	} else {
		*object->out.key_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.key_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameA_in_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->in.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceKeyNameA_in_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->in.display_name_length = NULL;
	} else {
		object->in.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.display_name_length);
		if (object->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameA_out_get_display_name_length(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_display_name_length;
	if (object->out.display_name_length == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.display_name_length));
	}
	return py_display_name_length;
}

static int py_svcctl_GetServiceKeyNameA_out_set_display_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.display_name_length));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.display_name_length");
		return -1;
	}
	if (value == Py_None) {
		object->out.display_name_length = NULL;
	} else {
		object->out.display_name_length = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.display_name_length);
		if (object->out.display_name_length == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.display_name_length));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_GetServiceKeyNameA_get_result(PyObject *obj, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_GetServiceKeyNameA_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_GetServiceKeyNameA_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_GetServiceKeyNameA_in_get_handle,
		.set = py_svcctl_GetServiceKeyNameA_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_service_name"),
		.get = py_svcctl_GetServiceKeyNameA_in_get_service_name,
		.set = py_svcctl_GetServiceKeyNameA_in_set_service_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_key_name"),
		.get = py_svcctl_GetServiceKeyNameA_out_get_key_name,
		.set = py_svcctl_GetServiceKeyNameA_out_set_key_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_display_name_length"),
		.get = py_svcctl_GetServiceKeyNameA_in_get_display_name_length,
		.set = py_svcctl_GetServiceKeyNameA_in_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_display_name_length"),
		.get = py_svcctl_GetServiceKeyNameA_out_get_display_name_length,
		.set = py_svcctl_GetServiceKeyNameA_out_set_display_name_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_GetServiceKeyNameA_get_result,
		.set = py_svcctl_GetServiceKeyNameA_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_GetServiceKeyNameA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_GetServiceKeyNameA, type);
	struct svcctl_GetServiceKeyNameA *_self = (struct svcctl_GetServiceKeyNameA *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(33);
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceKeyNameA_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[33];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceKeyNameA_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_GetServiceKeyNameA_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceKeyNameA_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[33];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceKeyNameA_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_GetServiceKeyNameA_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_GetServiceKeyNameA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_GetServiceKeyNameA_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[33];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceKeyNameA_ndr_print(py_obj, "svcctl_GetServiceKeyNameA_in", NDR_IN);
}

static PyObject *py_svcctl_GetServiceKeyNameA_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_GetServiceKeyNameA_ndr_print(py_obj, "svcctl_GetServiceKeyNameA_out", NDR_OUT);
}

static PyMethodDef py_svcctl_GetServiceKeyNameA_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_GetServiceKeyNameA_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.GetServiceKeyNameA.opnum() -> 33 (0x21) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameA_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameA_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameA_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_GetServiceKeyNameA_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_GetServiceKeyNameA_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_GetServiceKeyNameA_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_GetServiceKeyNameA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.GetServiceKeyNameA",
	.tp_getset = py_svcctl_GetServiceKeyNameA_getsetters,
	.tp_methods = py_svcctl_GetServiceKeyNameA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_GetServiceKeyNameA_new,
};

static bool pack_py_svcctl_GetServiceKeyNameA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceKeyNameA *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceKeyNameA", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_service_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.service_name");
		return false;
	}
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_service_name)) {
				unicode = PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_service_name)) {
				test_str = PyBytes_AS_STRING(py_service_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_service_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.service_name = talloc_str;
		}
	}
	if (py_display_name_length == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.display_name_length");
		return false;
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		if (r->in.display_name_length == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.display_name_length));
			if (PyLong_Check(py_display_name_length)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_display_name_length);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.display_name_length = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceKeyNameA_args_out(struct svcctl_GetServiceKeyNameA *r)
{
	PyObject *result;
	PyObject *py_key_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.key_name == NULL) {
		py_key_name = Py_None;
		Py_INCREF(py_key_name);
	} else {
		if (*r->out.key_name == NULL) {
			py_key_name = Py_None;
			Py_INCREF(py_key_name);
		} else {
			py_key_name = PyUnicode_Decode(*r->out.key_name, strlen(*r->out.key_name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 0, py_key_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
		Py_INCREF(py_display_name_length);
	} else {
		py_display_name_length = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.display_name_length));
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_ChangeServiceConfig2A_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_ChangeServiceConfig2A_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfig2A_in_get_info_level(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(obj);
	PyObject *py_info_level;
	py_info_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.info_level));
	return py_info_level;
}

static int py_svcctl_ChangeServiceConfig2A_in_set_info_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.info_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.info_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfig2A_in_get_info(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = PyLong_FromLong((uint16_t)(*object->in.info));
	}
	return py_info;
}

static int py_svcctl_ChangeServiceConfig2A_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	if (value == Py_None) {
		object->in.info = NULL;
	} else {
		object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
		if (object->in.info == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.info));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.info = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfig2A_get_result(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_svcctl_ChangeServiceConfig2A_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_svcctl_ChangeServiceConfig2A_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_svcctl_ChangeServiceConfig2A_in_get_handle,
		.set = py_svcctl_ChangeServiceConfig2A_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_info_level"),
		.get = py_svcctl_ChangeServiceConfig2A_in_get_info_level,
		.set = py_svcctl_ChangeServiceConfig2A_in_set_info_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_svcctl_ChangeServiceConfig2A_in_get_info,
		.set = py_svcctl_ChangeServiceConfig2A_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_svcctl_ChangeServiceConfig2A_get_result,
		.set = py_svcctl_ChangeServiceConfig2A_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_svcctl_ChangeServiceConfig2A_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct svcctl_ChangeServiceConfig2A, type);
	struct svcctl_ChangeServiceConfig2A *_self = (struct svcctl_ChangeServiceConfig2A *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(36);
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 37) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfig2A_ndr_pack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[36];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ChangeServiceConfig2A_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_svcctl_ChangeServiceConfig2A_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_svcctl.num_calls < 37) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfig2A_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[36];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ChangeServiceConfig2A_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_svcctl_ChangeServiceConfig2A_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct svcctl_ChangeServiceConfig2A *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_svcctl.num_calls < 37) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_svcctl_ChangeServiceConfig2A_ndr_print");
		return NULL;
	}
	call = &ndr_table_svcctl.calls[36];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ChangeServiceConfig2A_ndr_print(py_obj, "svcctl_ChangeServiceConfig2A_in", NDR_IN);
}

static PyObject *py_svcctl_ChangeServiceConfig2A_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_svcctl_ChangeServiceConfig2A_ndr_print(py_obj, "svcctl_ChangeServiceConfig2A_out", NDR_OUT);
}

static PyMethodDef py_svcctl_ChangeServiceConfig2A_methods[] = {
	{ "opnum", (PyCFunction)py_svcctl_ChangeServiceConfig2A_ndr_opnum, METH_NOARGS|METH_CLASS,
		"svcctl.ChangeServiceConfig2A.opnum() -> 36 (0x24) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfig2A_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfig2A_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfig2A_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_svcctl_ChangeServiceConfig2A_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_svcctl_ChangeServiceConfig2A_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_svcctl_ChangeServiceConfig2A_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject svcctl_ChangeServiceConfig2A_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "svcctl.ChangeServiceConfig2A",
	.tp_getset = py_svcctl_ChangeServiceConfig2A_getsetters,
	.tp_methods = py_svcctl_ChangeServiceConfig2A_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_ChangeServiceConfig2A_new,
};

static bool pack_py_svcctl_ChangeServiceConfig2A_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ChangeServiceConfig2A *r)
{
	PyObject *py_handle;
	PyObject *py_info_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "info_level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_ChangeServiceConfig2A", discard_const_p(char *, kwnames), &py_handle, &py_info_level, &py_info)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_info_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info_level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.info_level));
		if (PyLong_Check(py_info_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_info_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.info_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	if (py_info == Py_None) {
		r->in.info = NULL;
	} else {
		r->in.info = talloc_ptrtype(r, r->in.info);
		if (r->in.info == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.info));
			if (PyLong_Check(py_info)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_info);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.info = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_ChangeServiceConfig2A_args_out(struct svcctl_ChangeServiceConfig2A *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_svcctl_ChangeServiceConfig2W_in_get_handle(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfig2W *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_svcctl_ChangeServiceConfig2W_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfig2W *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_svcctl_ChangeServiceConfig2W_in_get_info_level(PyObject *obj, void *closure)
{
	struct svcctl_ChangeServiceConfig2W *object = pytalloc_get_ptr(obj);
	PyObject *py_info_level;
	py_info_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.info_level));
	return py_info_level;
}

static int py_svcctl_ChangeServiceConfig2W_in_set_info_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ChangeServiceConfig2W *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.info_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			t