
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_smb3posix.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/security.h"
static PyTypeObject smb3_posix_cc_info_Type;
static PyTypeObject smb3_file_posix_information_Type;

static PyTypeObject *dom_sid_Type;
static PyTypeObject *BaseObject_Type;

static PyObject *py_smb3_posix_cc_info_get_nlinks(PyObject *obj, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(obj);
	PyObject *py_nlinks;
	py_nlinks = PyLong_FromUnsignedLongLong((uint32_t)(object->nlinks));
	return py_nlinks;
}

static int py_smb3_posix_cc_info_set_nlinks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->nlinks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nlinks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nlinks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_posix_cc_info_get_reparse_tag(PyObject *obj, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(obj);
	PyObject *py_reparse_tag;
	py_reparse_tag = PyLong_FromUnsignedLongLong((uint32_t)(object->reparse_tag));
	return py_reparse_tag;
}

static int py_smb3_posix_cc_info_set_reparse_tag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reparse_tag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reparse_tag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reparse_tag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_posix_cc_info_get_posix_perms(PyObject *obj, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(obj);
	PyObject *py_posix_perms;
	py_posix_perms = PyLong_FromUnsignedLongLong((uint32_t)(object->posix_perms));
	return py_posix_perms;
}

static int py_smb3_posix_cc_info_set_posix_perms(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->posix_perms");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->posix_perms));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->posix_perms = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_posix_cc_info_get_owner(PyObject *obj, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(obj);
	PyObject *py_owner;
	py_owner = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->owner);
	return py_owner;
}

static int py_smb3_posix_cc_info_set_owner(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->owner");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->owner = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smb3_posix_cc_info_get_group(PyObject *obj, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(obj);
	PyObject *py_group;
	py_group = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->group);
	return py_group;
}

static int py_smb3_posix_cc_info_set_group(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->group");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->group = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_smb3_posix_cc_info_getsetters[] = {
	{
		.name = discard_const_p(char, "nlinks"),
		.get = py_smb3_posix_cc_info_get_nlinks,
		.set = py_smb3_posix_cc_info_set_nlinks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reparse_tag"),
		.get = py_smb3_posix_cc_info_get_reparse_tag,
		.set = py_smb3_posix_cc_info_set_reparse_tag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "posix_perms"),
		.get = py_smb3_posix_cc_info_get_posix_perms,
		.set = py_smb3_posix_cc_info_set_posix_perms,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "owner"),
		.get = py_smb3_posix_cc_info_get_owner,
		.set = py_smb3_posix_cc_info_set_owner,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "group"),
		.get = py_smb3_posix_cc_info_get_group,
		.set = py_smb3_posix_cc_info_set_group,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{ .name = NULL }
};

static PyObject *py_smb3_posix_cc_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb3_posix_cc_info, type);
}

static PyObject *py_smb3_posix_cc_info_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smb3_posix_cc_info);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smb3_posix_cc_info_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smb3_posix_cc_info);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smb3_posix_cc_info);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smb3_posix_cc_info_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct smb3_posix_cc_info *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smb3_posix_cc_info, "smb3_posix_cc_info", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smb3_posix_cc_info_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smb3_posix_cc_info_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smb3_posix_cc_info_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_smb3_posix_cc_info_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smb3_posix_cc_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb3posix.smb3_posix_cc_info",
	.tp_getset = py_smb3_posix_cc_info_getsetters,
	.tp_methods = py_smb3_posix_cc_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb3_posix_cc_info_new,
};


static PyObject *py_smb3_file_posix_information_get_creation_time(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_creation_time;
	py_creation_time = PyLong_FromUnsignedLongLong(object->creation_time);
	return py_creation_time;
}

static int py_smb3_file_posix_information_set_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_last_access_time(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_last_access_time;
	py_last_access_time = PyLong_FromUnsignedLongLong(object->last_access_time);
	return py_last_access_time;
}

static int py_smb3_file_posix_information_set_last_access_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->last_access_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_access_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_access_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_last_write_time(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_last_write_time;
	py_last_write_time = PyLong_FromUnsignedLongLong(object->last_write_time);
	return py_last_write_time;
}

static int py_smb3_file_posix_information_set_last_write_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->last_write_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_write_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_write_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_change_time(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_change_time;
	py_change_time = PyLong_FromUnsignedLongLong(object->change_time);
	return py_change_time;
}

static int py_smb3_file_posix_information_set_change_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->change_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->change_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->change_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_end_of_file(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_end_of_file;
	py_end_of_file = PyLong_FromUnsignedLongLong(object->end_of_file);
	return py_end_of_file;
}

static int py_smb3_file_posix_information_set_end_of_file(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->end_of_file");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->end_of_file));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->end_of_file = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_allocation_size(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_allocation_size;
	py_allocation_size = PyLong_FromUnsignedLongLong(object->allocation_size);
	return py_allocation_size;
}

static int py_smb3_file_posix_information_set_allocation_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->allocation_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->allocation_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->allocation_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_file_attributes(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_file_attributes;
	py_file_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->file_attributes));
	return py_file_attributes;
}

static int py_smb3_file_posix_information_set_file_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->file_attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->file_attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->file_attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_inode(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_inode;
	py_inode = PyLong_FromUnsignedLongLong(object->inode);
	return py_inode;
}

static int py_smb3_file_posix_information_set_inode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->inode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->inode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->inode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_device(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_device;
	py_device = PyLong_FromUnsignedLongLong((uint32_t)(object->device));
	return py_device;
}

static int py_smb3_file_posix_information_set_device(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->device");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->device));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->device = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_reserved(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smb3_file_posix_information_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb3_file_posix_information_get_cc(PyObject *obj, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(obj);
	PyObject *py_cc;
	py_cc = pytalloc_reference_ex(&smb3_posix_cc_info_Type, pytalloc_get_mem_ctx(obj), &object->cc);
	return py_cc;
}

static int py_smb3_file_posix_information_set_cc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cc");
		return -1;
	}
	PY_CHECK_TYPE(&smb3_posix_cc_info_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->cc = *(struct smb3_posix_cc_info *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_smb3_file_posix_information_getsetters[] = {
	{
		.name = discard_const_p(char, "creation_time"),
		.get = py_smb3_file_posix_information_get_creation_time,
		.set = py_smb3_file_posix_information_set_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_access_time"),
		.get = py_smb3_file_posix_information_get_last_access_time,
		.set = py_smb3_file_posix_information_set_last_access_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_write_time"),
		.get = py_smb3_file_posix_information_get_last_write_time,
		.set = py_smb3_file_posix_information_set_last_write_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "change_time"),
		.get = py_smb3_file_posix_information_get_change_time,
		.set = py_smb3_file_posix_information_set_change_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "end_of_file"),
		.get = py_smb3_file_posix_information_get_end_of_file,
		.set = py_smb3_file_posix_information_set_end_of_file,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "allocation_size"),
		.get = py_smb3_file_posix_information_get_allocation_size,
		.set = py_smb3_file_posix_information_set_allocation_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "file_attributes"),
		.get = py_smb3_file_posix_information_get_file_attributes,
		.set = py_smb3_file_posix_information_set_file_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "inode"),
		.get = py_smb3_file_posix_information_get_inode,
		.set = py_smb3_file_posix_information_set_inode,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "device"),
		.get = py_smb3_file_posix_information_get_device,
		.set = py_smb3_file_posix_information_set_device,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smb3_file_posix_information_get_reserved,
		.set = py_smb3_file_posix_information_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cc"),
		.get = py_smb3_file_posix_information_get_cc,
		.set = py_smb3_file_posix_information_set_cc,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb3_posix_cc_info")
	},
	{ .name = NULL }
};

static PyObject *py_smb3_file_posix_information_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb3_file_posix_information, type);
}

static PyObject *py_smb3_file_posix_information_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smb3_file_posix_information);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smb3_file_posix_information_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smb3_file_posix_information);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smb3_file_posix_information);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smb3_file_posix_information_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct smb3_file_posix_information *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smb3_file_posix_information, "smb3_file_posix_information", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smb3_file_posix_information_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smb3_file_posix_information_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smb3_file_posix_information_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_smb3_file_posix_information_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smb3_file_posix_information_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb3posix.smb3_file_posix_information",
	.tp_getset = py_smb3_file_posix_information_getsetters,
	.tp_methods = py_smb3_file_posix_information_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb3_file_posix_information_new,
};

static PyMethodDef smb3posix_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "smb3posix",
	.m_doc = "smb3posix DCE/RPC",
	.m_size = -1,
	.m_methods = smb3posix_methods,
};
MODULE_INIT_FUNC(smb3posix)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_talloc = NULL;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	smb3_posix_cc_info_Type.tp_base = BaseObject_Type;
	smb3_posix_cc_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb3_file_posix_information_Type.tp_base = BaseObject_Type;
	smb3_file_posix_information_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&smb3_posix_cc_info_Type) < 0)
		goto out;
	if (PyType_Ready(&smb3_file_posix_information_Type) < 0)
		goto out;
#ifdef PY_SMB3_POSIX_CC_INFO_PATCH
	PY_SMB3_POSIX_CC_INFO_PATCH(&smb3_posix_cc_info_Type);
#endif
#ifdef PY_SMB3_FILE_POSIX_INFORMATION_PATCH
	PY_SMB3_FILE_POSIX_INFORMATION_PATCH(&smb3_file_posix_information_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	Py_INCREF((PyObject *)(void *)&smb3_posix_cc_info_Type);
	PyModule_AddObject(m, "smb3_posix_cc_info", (PyObject *)(void *)&smb3_posix_cc_info_Type);
	Py_INCREF((PyObject *)(void *)&smb3_file_posix_information_Type);
	PyModule_AddObject(m, "smb3_file_posix_information", (PyObject *)(void *)&smb3_file_posix_information_Type);
#ifdef PY_MOD_SMB3POSIX_PATCH
	PY_MOD_SMB3POSIX_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_talloc);
	return m;

}
