
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_security.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject dom_sid_Type;
static PyTypeObject security_ace_object_type_Type;
static PyTypeObject security_ace_object_inherited_type_Type;
static PyTypeObject security_ace_object_Type;
static PyTypeObject claim_values_Type;
static PyTypeObject CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type;
static PyTypeObject security_ace_object_ctr_Type;
static PyTypeObject security_ace_coda_Type;
static PyTypeObject security_ace_Type;
static PyTypeObject security_acl_Type;
static PyTypeObject security_descriptor_Type;
static PyTypeObject sec_desc_buf_Type;
static PyTypeObject security_token_Type;
static PyTypeObject security_token_descriptor_fuzzing_pair_Type;
static PyTypeObject security_unix_token_Type;
static PyTypeObject LSAP_TOKEN_INFO_INTEGRITY_Type;
static PyTypeObject generic_mapping_Type;
static PyTypeObject standard_mapping_Type;
static PyTypeObject security_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;
#include "librpc/ndr/py_security.c"


static PyObject *py_dom_sid_get_sid_rev_num(PyObject *obj, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_rev_num;
	py_sid_rev_num = PyLong_FromLong((uint16_t)(object->sid_rev_num));
	return py_sid_rev_num;
}

static int py_dom_sid_set_sid_rev_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_rev_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_rev_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_rev_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dom_sid_get_num_auths(PyObject *obj, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(obj);
	PyObject *py_num_auths;
	py_num_auths = PyLong_FromLong(object->num_auths);
	return py_num_auths;
}

static int py_dom_sid_set_num_auths(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_auths");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->num_auths));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->num_auths = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dom_sid_get_id_auth(PyObject *obj, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(obj);
	PyObject *py_id_auth;
	py_id_auth = PyList_New(6);
	if (py_id_auth == NULL) {
		return NULL;
	}
	{
		int id_auth_cntr_0;
		for (id_auth_cntr_0 = 0; id_auth_cntr_0 < (6); id_auth_cntr_0++) {
			PyObject *py_id_auth_0;
			py_id_auth_0 = PyLong_FromLong((uint16_t)((object->id_auth)[id_auth_cntr_0]));
			PyList_SetItem(py_id_auth, id_auth_cntr_0, py_id_auth_0);
		}
	}
	return py_id_auth;
}

static int py_dom_sid_set_id_auth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->id_auth");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int id_auth_cntr_0;
		if (ARRAY_SIZE(object->id_auth) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->id_auth),  PyList_GET_SIZE(value));
			return -1;
		}
		for (id_auth_cntr_0 = 0; id_auth_cntr_0 < PyList_GET_SIZE(value); id_auth_cntr_0++) {
			if (PyList_GET_ITEM(value, id_auth_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->id_auth)[id_auth_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->id_auth)[id_auth_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, id_auth_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, id_auth_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->id_auth)[id_auth_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_dom_sid_get_sub_auths(PyObject *obj, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(obj);
	PyObject *py_sub_auths;
	py_sub_auths = PyList_New(15);
	if (py_sub_auths == NULL) {
		return NULL;
	}
	{
		int sub_auths_cntr_0;
		for (sub_auths_cntr_0 = 0; sub_auths_cntr_0 < (15); sub_auths_cntr_0++) {
			PyObject *py_sub_auths_0;
			py_sub_auths_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->sub_auths)[sub_auths_cntr_0]));
			PyList_SetItem(py_sub_auths, sub_auths_cntr_0, py_sub_auths_0);
		}
	}
	return py_sub_auths;
}

static int py_dom_sid_set_sub_auths(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sub_auths");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sub_auths_cntr_0;
		if (ARRAY_SIZE(object->sub_auths) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->sub_auths),  PyList_GET_SIZE(value));
			return -1;
		}
		for (sub_auths_cntr_0 = 0; sub_auths_cntr_0 < PyList_GET_SIZE(value); sub_auths_cntr_0++) {
			if (PyList_GET_ITEM(value, sub_auths_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->sub_auths)[sub_auths_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->sub_auths)[sub_auths_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, sub_auths_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, sub_auths_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->sub_auths)[sub_auths_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dom_sid_getsetters[] = {
	{
		.name = discard_const_p(char, "sid_rev_num"),
		.get = py_dom_sid_get_sid_rev_num,
		.set = py_dom_sid_set_sid_rev_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "num_auths"),
		.get = py_dom_sid_get_num_auths,
		.set = py_dom_sid_set_num_auths,
		.doc = discard_const_p(char, "PIDL-generated element of base type int8")
	},
	{
		.name = discard_const_p(char, "id_auth"),
		.get = py_dom_sid_get_id_auth,
		.set = py_dom_sid_set_id_auth,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "sub_auths"),
		.get = py_dom_sid_get_sub_auths,
		.set = py_dom_sid_set_sub_auths,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dom_sid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dom_sid, type);
}

static PyObject *py_dom_sid_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dom_sid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dom_sid);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dom_sid_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dom_sid *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dom_sid);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dom_sid);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dom_sid_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dom_sid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dom_sid, "dom_sid", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dom_sid_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dom_sid_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dom_sid_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dom_sid_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dom_sid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.dom_sid",
	.tp_getset = py_dom_sid_getsetters,
	.tp_methods = py_dom_sid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dom_sid_new,
};

static PyObject *py_import_security_ace_object_type(TALLOC_CTX *mem_ctx, int level, union security_ace_object_type *in)
{
	PyObject *ret;

	switch (level) {
		case SEC_ACE_OBJECT_TYPE_PRESENT:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->type);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union security_ace_object_type *py_export_security_ace_object_type(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union security_ace_object_type *ret = talloc_zero(mem_ctx, union security_ace_object_type);
	switch (level) {
		case SEC_ACE_OBJECT_TYPE_PRESENT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->type");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->type = *(struct GUID *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_security_ace_object_type_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union security_ace_object_type *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union security_ace_object_type *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union security_ace_object_type!");
		return NULL;
	}

	return py_import_security_ace_object_type(mem_ctx, level, in);
}

static PyObject *py_security_ace_object_type_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union security_ace_object_type *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_security_ace_object_type(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_security_ace_object_type_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_object_type_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_object_type_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_security_ace_object_type_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject security_ace_object_type_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.ace_object_type",
	.tp_getset = NULL,
	.tp_methods = py_security_ace_object_type_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_object_type_new,
};

static PyObject *py_import_security_ace_object_inherited_type(TALLOC_CTX *mem_ctx, int level, union security_ace_object_inherited_type *in)
{
	PyObject *ret;

	switch (level) {
		case SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->inherited_type);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union security_ace_object_inherited_type *py_export_security_ace_object_inherited_type(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union security_ace_object_inherited_type *ret = talloc_zero(mem_ctx, union security_ace_object_inherited_type);
	switch (level) {
		case SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->inherited_type");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->inherited_type = *(struct GUID *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_security_ace_object_inherited_type_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union security_ace_object_inherited_type *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union security_ace_object_inherited_type *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union security_ace_object_inherited_type!");
		return NULL;
	}

	return py_import_security_ace_object_inherited_type(mem_ctx, level, in);
}

static PyObject *py_security_ace_object_inherited_type_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union security_ace_object_inherited_type *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_security_ace_object_inherited_type(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_security_ace_object_inherited_type_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_object_inherited_type_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_object_inherited_type_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_security_ace_object_inherited_type_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject security_ace_object_inherited_type_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.ace_object_inherited_type",
	.tp_getset = NULL,
	.tp_methods = py_security_ace_object_inherited_type_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_object_inherited_type_new,
};


static PyObject *py_security_ace_object_get_flags(PyObject *obj, void *closure)
{
	struct security_ace_object *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_security_ace_object_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace_object *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_ace_object_get_type(PyObject *obj, void *closure)
{
	struct security_ace_object *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = pyrpc_import_union(&security_ace_object_type_Type, pytalloc_get_mem_ctx(obj), object->flags & SEC_ACE_OBJECT_TYPE_PRESENT, &object->type, "union security_ace_object_type");
	if (py_type == NULL) {
		return NULL;
	}
	return py_type;
}

static int py_security_ace_object_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace_object *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		union security_ace_object_type *type_switch_0;
		type_switch_0 = (union security_ace_object_type *)pyrpc_export_union(&security_ace_object_type_Type, pytalloc_get_mem_ctx(py_obj), object->flags & SEC_ACE_OBJECT_TYPE_PRESENT, value, "union security_ace_object_type");
		if (type_switch_0 == NULL) {
			return -1;
		}
		object->type = *type_switch_0;
	}
	return 0;
}

static PyObject *py_security_ace_object_get_inherited_type(PyObject *obj, void *closure)
{
	struct security_ace_object *object = pytalloc_get_ptr(obj);
	PyObject *py_inherited_type;
	py_inherited_type = pyrpc_import_union(&security_ace_object_inherited_type_Type, pytalloc_get_mem_ctx(obj), object->flags & SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT, &object->inherited_type, "union security_ace_object_inherited_type");
	if (py_inherited_type == NULL) {
		return NULL;
	}
	return py_inherited_type;
}

static int py_security_ace_object_set_inherited_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace_object *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->inherited_type");
		return -1;
	}
	{
		union security_ace_object_inherited_type *inherited_type_switch_0;
		inherited_type_switch_0 = (union security_ace_object_inherited_type *)pyrpc_export_union(&security_ace_object_inherited_type_Type, pytalloc_get_mem_ctx(py_obj), object->flags & SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT, value, "union security_ace_object_inherited_type");
		if (inherited_type_switch_0 == NULL) {
			return -1;
		}
		object->inherited_type = *inherited_type_switch_0;
	}
	return 0;
}

static PyGetSetDef py_security_ace_object_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_security_ace_object_get_flags,
		.set = py_security_ace_object_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace_object_flags")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_security_ace_object_get_type,
		.set = py_security_ace_object_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace_object_type")
	},
	{
		.name = discard_const_p(char, "inherited_type"),
		.get = py_security_ace_object_get_inherited_type,
		.set = py_security_ace_object_set_inherited_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace_object_inherited_type")
	},
	{ .name = NULL }
};

static PyObject *py_security_ace_object_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct security_ace_object, type);
}


static PyTypeObject security_ace_object_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.ace_object",
	.tp_getset = py_security_ace_object_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_object_new,
};

static PyObject *py_import_claim_values(TALLOC_CTX *mem_ctx, int level, union claim_values *in)
{
	PyObject *ret;

	switch (level) {
		case CLAIM_SECURITY_ATTRIBUTE_TYPE_INT64:
			if (in->int_value == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromLongLong(*in->int_value);
			}
			return ret;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_UINT64:
			if (in->uint_value == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->uint_value);
			}
			return ret;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_STRING:
			if (in->string_value == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyString_FromStringOrNULL(in->string_value);
			}
			return ret;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_SID:
			if (in->sid_value == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyBytes_FromStringAndSize((char *)(*in->sid_value).data, (*in->sid_value).length);
			}
			return ret;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING:
			if (in->octet_value == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyBytes_FromStringAndSize((char *)(*in->octet_value).data, (*in->octet_value).length);
			}
			return ret;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_BOOLEAN:
			if (in->uint_value == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->uint_value);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union claim_values *py_export_claim_values(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union claim_values *ret = talloc_zero(mem_ctx, union claim_values);
	switch (level) {
		case CLAIM_SECURITY_ATTRIBUTE_TYPE_INT64:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->int_value");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->int_value = NULL;
			} else {
				ret->int_value = talloc_ptrtype(mem_ctx, ret->int_value);
				if (ret->int_value == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const long long int_max = ndr_sizeof2intmax(sizeof(*ret->int_value));
					const long long int_min = -int_max - 1;
					if (PyLong_Check(in)) {
						long long test_var;
						test_var = PyLong_AsLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var < int_min || test_var > int_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
							  PyLong_Type.tp_name, int_min, int_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->int_value = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_UINT64:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->uint_value");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->uint_value = NULL;
			} else {
				ret->uint_value = talloc_ptrtype(mem_ctx, ret->uint_value);
				if (ret->uint_value == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->uint_value));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->uint_value = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_STRING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->string_value");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->string_value = NULL;
			} else {
				ret->string_value = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->string_value = talloc_str;
				}
			}
			break;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_SID:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->sid_value");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sid_value = NULL;
			} else {
				ret->sid_value = talloc_ptrtype(mem_ctx, ret->sid_value);
				if (ret->sid_value == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				*ret->sid_value = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			}
			break;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->octet_value");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->octet_value = NULL;
			} else {
				ret->octet_value = talloc_ptrtype(mem_ctx, ret->octet_value);
				if (ret->octet_value == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				*ret->octet_value = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			}
			break;

		case CLAIM_SECURITY_ATTRIBUTE_TYPE_BOOLEAN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->uint_value");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->uint_value = NULL;
			} else {
				ret->uint_value = talloc_ptrtype(mem_ctx, ret->uint_value);
				if (ret->uint_value == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->uint_value));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->uint_value = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_claim_values_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union claim_values *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union claim_values *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union claim_values!");
		return NULL;
	}

	return py_import_claim_values(mem_ctx, level, in);
}

static PyObject *py_claim_values_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union claim_values *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_claim_values(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_claim_values_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_claim_values_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_claim_values_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_claim_values_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject claim_values_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.claim_values",
	.tp_getset = NULL,
	.tp_methods = py_claim_values_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claim_values_new,
};


static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_name(PyObject *obj, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyString_FromStringOrNULL(object->name);
	}
	return py_name;
}

static int py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_value_type(PyObject *obj, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_value_type;
	py_value_type = PyLong_FromLong((uint16_t)(object->value_type));
	return py_value_type;
}

static int py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_value_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_flags(PyObject *obj, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_value_count(PyObject *obj, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_value_count;
	py_value_count = PyLong_FromUnsignedLongLong((uint32_t)(object->value_count));
	return py_value_count;
}

static int py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_value_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_values(PyObject *obj, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(obj);
	PyObject *py_values;
	py_values = PyList_New(object->value_count);
	if (py_values == NULL) {
		return NULL;
	}
	{
		int values_cntr_0;
		for (values_cntr_0 = 0; values_cntr_0 < (object->value_count); values_cntr_0++) {
			PyObject *py_values_0;
			py_values_0 = pyrpc_import_union(&claim_values_Type, object->values, object->value_type, &(object->values)[values_cntr_0], "union claim_values");
			if (py_values_0 == NULL) {
				return NULL;
			}
			PyList_SetItem(py_values, values_cntr_0, py_values_0);
		}
	}
	return py_values;
}

static int py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->values");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int values_cntr_0;
		object->values = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->values, PyList_GET_SIZE(value));
		if (!object->values) { return -1; }
		talloc_set_name_const(object->values, "ARRAY: object->values");
		for (values_cntr_0 = 0; values_cntr_0 < PyList_GET_SIZE(value); values_cntr_0++) {
			if (PyList_GET_ITEM(value, values_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->values)[values_cntr_0]");
				return -1;
			}
			{
				union claim_values *values_switch_1;
				values_switch_1 = (union claim_values *)pyrpc_export_union(&claim_values_Type, object->values, object->value_type, PyList_GET_ITEM(value, values_cntr_0), "union claim_values");
				if (values_switch_1 == NULL) {
					return -1;
				}
				(object->values)[values_cntr_0] = *values_switch_1;
			}
		}
	}
	return 0;
}

static PyGetSetDef py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_name,
		.set = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "value_type"),
		.get = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_value_type,
		.set = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_value_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_flags,
		.set = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "value_count"),
		.get = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_value_count,
		.set = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_value_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "values"),
		.get = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_get_values,
		.set = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_set_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type claim_values")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1, type);
}

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1, "CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1",
	.tp_getset = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_getsetters,
	.tp_methods = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_new,
};

static PyObject *py_import_security_ace_object_ctr(TALLOC_CTX *mem_ctx, int level, union security_ace_object_ctr *in)
{
	PyObject *ret;

	switch (level) {
		default:
			ret = pytalloc_reference_ex(&security_ace_object_Type, mem_ctx, &in->object);
			return ret;

		case false:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union security_ace_object_ctr *py_export_security_ace_object_ctr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union security_ace_object_ctr *ret = talloc_zero(mem_ctx, union security_ace_object_ctr);
	switch (level) {
		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->object");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&security_ace_object_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->object = *(struct security_ace_object *)pytalloc_get_ptr(in);
			break;

		case false:
			break;

	}

	return ret;
}

static PyObject *py_security_ace_object_ctr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union security_ace_object_ctr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union security_ace_object_ctr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union security_ace_object_ctr!");
		return NULL;
	}

	return py_import_security_ace_object_ctr(mem_ctx, level, in);
}

static PyObject *py_security_ace_object_ctr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union security_ace_object_ctr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_security_ace_object_ctr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_security_ace_object_ctr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_object_ctr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_object_ctr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_security_ace_object_ctr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject security_ace_object_ctr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.ace_object_ctr",
	.tp_getset = NULL,
	.tp_methods = py_security_ace_object_ctr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_object_ctr_new,
};

static PyObject *py_import_security_ace_coda(TALLOC_CTX *mem_ctx, int level, union security_ace_coda *in)
{
	PyObject *ret;

	switch (level) {
		case SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK:
			ret = PyBytes_FromStringAndSize((char *)(in->conditions).data, (in->conditions).length);
			return ret;

		case SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK:
			ret = PyBytes_FromStringAndSize((char *)(in->conditions).data, (in->conditions).length);
			return ret;

		case SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK_OBJECT:
			ret = PyBytes_FromStringAndSize((char *)(in->conditions).data, (in->conditions).length);
			return ret;

		case SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK_OBJECT:
			ret = PyBytes_FromStringAndSize((char *)(in->conditions).data, (in->conditions).length);
			return ret;

		case SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK:
			ret = PyBytes_FromStringAndSize((char *)(in->conditions).data, (in->conditions).length);
			return ret;

		case SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK_OBJECT:
			ret = PyBytes_FromStringAndSize((char *)(in->conditions).data, (in->conditions).length);
			return ret;

		case SEC_ACE_TYPE_SYSTEM_RESOURCE_ATTRIBUTE:
			ret = pytalloc_reference_ex(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, mem_ctx, &in->claim);
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->ignored).data, (in->ignored).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union security_ace_coda *py_export_security_ace_coda(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union security_ace_coda *ret = talloc_zero(mem_ctx, union security_ace_coda);
	switch (level) {
		case SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->conditions");
				talloc_free(ret); return NULL;
			}
			ret->conditions = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->conditions");
				talloc_free(ret); return NULL;
			}
			ret->conditions = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK_OBJECT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->conditions");
				talloc_free(ret); return NULL;
			}
			ret->conditions = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK_OBJECT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->conditions");
				talloc_free(ret); return NULL;
			}
			ret->conditions = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->conditions");
				talloc_free(ret); return NULL;
			}
			ret->conditions = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK_OBJECT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->conditions");
				talloc_free(ret); return NULL;
			}
			ret->conditions = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case SEC_ACE_TYPE_SYSTEM_RESOURCE_ATTRIBUTE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->claim");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->claim = *(struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ignored");
				talloc_free(ret); return NULL;
			}
			ret->ignored = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_security_ace_coda_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union security_ace_coda *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union security_ace_coda *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union security_ace_coda!");
		return NULL;
	}

	return py_import_security_ace_coda(mem_ctx, level, in);
}

static PyObject *py_security_ace_coda_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union security_ace_coda *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_security_ace_coda(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_security_ace_coda_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_coda_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_coda_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_security_ace_coda_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject security_ace_coda_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.ace_coda",
	.tp_getset = NULL,
	.tp_methods = py_security_ace_coda_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_coda_new,
};


static PyObject *py_security_ace_get_type(PyObject *obj, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_security_ace_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_ace_get_flags(PyObject *obj, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_security_ace_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_ace_get_size(PyObject *obj, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_security_ace_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_ace_get_access_mask(PyObject *obj, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->access_mask));
	return py_access_mask;
}

static int py_security_ace_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_ace_get_object(PyObject *obj, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pyrpc_import_union(&security_ace_object_ctr_Type, pytalloc_get_mem_ctx(obj), sec_ace_object(object->type), &object->object, "union security_ace_object_ctr");
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_security_ace_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->object");
		return -1;
	}
	{
		union security_ace_object_ctr *object_switch_0;
		object_switch_0 = (union security_ace_object_ctr *)pyrpc_export_union(&security_ace_object_ctr_Type, pytalloc_get_mem_ctx(py_obj), sec_ace_object(object->type), value, "union security_ace_object_ctr");
		if (object_switch_0 == NULL) {
			return -1;
		}
		object->object = *object_switch_0;
	}
	return 0;
}

static PyObject *py_security_ace_get_trustee(PyObject *obj, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(obj);
	PyObject *py_trustee;
	py_trustee = pytalloc_reference_ex(&dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->trustee);
	return py_trustee;
}

static int py_security_ace_set_trustee(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->trustee");
		return -1;
	}
	PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->trustee = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_security_ace_get_coda(PyObject *obj, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(obj);
	PyObject *py_coda;
	py_coda = pyrpc_import_union(&security_ace_coda_Type, pytalloc_get_mem_ctx(obj), object->type, &object->coda, "union security_ace_coda");
	if (py_coda == NULL) {
		return NULL;
	}
	return py_coda;
}

static int py_security_ace_set_coda(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->coda");
		return -1;
	}
	{
		union security_ace_coda *coda_switch_1;
		coda_switch_1 = (union security_ace_coda *)pyrpc_export_union(&security_ace_coda_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union security_ace_coda");
		if (coda_switch_1 == NULL) {
			return -1;
		}
		object->coda = *coda_switch_1;
	}
	return 0;
}

static PyGetSetDef py_security_ace_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_security_ace_get_type,
		.set = py_security_ace_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace_type")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_security_ace_get_flags,
		.set = py_security_ace_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace_flags")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_security_ace_get_size,
		.set = py_security_ace_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "access_mask"),
		.get = py_security_ace_get_access_mask,
		.set = py_security_ace_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "object"),
		.get = py_security_ace_get_object,
		.set = py_security_ace_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace_object_ctr")
	},
	{
		.name = discard_const_p(char, "trustee"),
		.get = py_security_ace_get_trustee,
		.set = py_security_ace_set_trustee,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "coda"),
		.get = py_security_ace_get_coda,
		.set = py_security_ace_set_coda,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace_coda")
	},
	{ .name = NULL }
};

static PyObject *py_security_ace_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct security_ace, type);
}

static PyObject *py_security_ace_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_security_ace);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_security_ace_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_ace);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_ace);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_security_ace_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct security_ace *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_security_ace, "security_ace", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_security_ace_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_ace_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_ace_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_security_ace_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_ace_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.ace",
	.tp_getset = py_security_ace_getsetters,
	.tp_methods = py_security_ace_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_new,
};


static PyObject *py_security_acl_get_revision(PyObject *obj, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(obj);
	PyObject *py_revision;
	py_revision = PyLong_FromLong((uint16_t)(object->revision));
	return py_revision;
}

static int py_security_acl_set_revision(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->revision");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->revision));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->revision = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_acl_get_size(PyObject *obj, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_security_acl_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_acl_get_num_aces(PyObject *obj, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(obj);
	PyObject *py_num_aces;
	py_num_aces = PyLong_FromUnsignedLongLong((uint32_t)(object->num_aces));
	return py_num_aces;
}

static int py_security_acl_set_num_aces(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_aces");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_aces));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_aces = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_acl_get_aces(PyObject *obj, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(obj);
	PyObject *py_aces;
	py_aces = PyList_New(object->num_aces);
	if (py_aces == NULL) {
		return NULL;
	}
	{
		int aces_cntr_0;
		for (aces_cntr_0 = 0; aces_cntr_0 < (object->num_aces); aces_cntr_0++) {
			PyObject *py_aces_0;
			py_aces_0 = pytalloc_reference_ex(&security_ace_Type, object->aces, &(object->aces)[aces_cntr_0]);
			PyList_SetItem(py_aces, aces_cntr_0, py_aces_0);
		}
	}
	return py_aces;
}

static int py_security_acl_set_aces(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->aces");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int aces_cntr_0;
		object->aces = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->aces, PyList_GET_SIZE(value));
		if (!object->aces) { return -1; }
		talloc_set_name_const(object->aces, "ARRAY: object->aces");
		for (aces_cntr_0 = 0; aces_cntr_0 < PyList_GET_SIZE(value); aces_cntr_0++) {
			if (PyList_GET_ITEM(value, aces_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->aces)[aces_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&security_ace_Type, PyList_GET_ITEM(value, aces_cntr_0), return -1;);
			if (talloc_reference(object->aces, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, aces_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->aces)[aces_cntr_0] = *(struct security_ace *)pytalloc_get_ptr(PyList_GET_ITEM(value, aces_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_security_acl_getsetters[] = {
	{
		.name = discard_const_p(char, "revision"),
		.get = py_security_acl_get_revision,
		.set = py_security_acl_set_revision,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_acl_revision")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_security_acl_get_size,
		.set = py_security_acl_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_aces"),
		.get = py_security_acl_get_num_aces,
		.set = py_security_acl_set_num_aces,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aces"),
		.get = py_security_acl_get_aces,
		.set = py_security_acl_set_aces,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_ace")
	},
	{ .name = NULL }
};

static PyObject *py_security_acl_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct security_acl, type);
}

static PyObject *py_security_acl_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct security_acl *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_security_acl);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_security_acl_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct security_acl *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_acl);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_acl);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_security_acl_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct security_acl *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_security_acl, "security_acl", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_security_acl_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_acl_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_acl_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_security_acl_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_acl_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.acl",
	.tp_getset = py_security_acl_getsetters,
	.tp_methods = py_security_acl_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_acl_new,
};


static PyObject *py_security_descriptor_get_revision(PyObject *obj, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(obj);
	PyObject *py_revision;
	py_revision = PyLong_FromLong((uint16_t)(object->revision));
	return py_revision;
}

static int py_security_descriptor_set_revision(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->revision");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->revision));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->revision = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_descriptor_get_type(PyObject *obj, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_security_descriptor_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_descriptor_get_owner_sid(PyObject *obj, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(obj);
	PyObject *py_owner_sid;
	if (object->owner_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->owner_sid == NULL) {
		py_owner_sid = Py_None;
		Py_INCREF(py_owner_sid);
	} else {
		py_owner_sid = pytalloc_reference_ex(&dom_sid_Type, object->owner_sid, object->owner_sid);
	}
	return py_owner_sid;
}

static int py_security_descriptor_set_owner_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->owner_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->owner_sid");
		return -1;
	}
	if (value == Py_None) {
		object->owner_sid = NULL;
	} else {
		object->owner_sid = NULL;
		PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->owner_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_descriptor_get_group_sid(PyObject *obj, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(obj);
	PyObject *py_group_sid;
	if (object->group_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->group_sid == NULL) {
		py_group_sid = Py_None;
		Py_INCREF(py_group_sid);
	} else {
		py_group_sid = pytalloc_reference_ex(&dom_sid_Type, object->group_sid, object->group_sid);
	}
	return py_group_sid;
}

static int py_security_descriptor_set_group_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->group_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->group_sid");
		return -1;
	}
	if (value == Py_None) {
		object->group_sid = NULL;
	} else {
		object->group_sid = NULL;
		PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->group_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_descriptor_get_sacl(PyObject *obj, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(obj);
	PyObject *py_sacl;
	if (object->sacl == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sacl == NULL) {
		py_sacl = Py_None;
		Py_INCREF(py_sacl);
	} else {
		py_sacl = pytalloc_reference_ex(&security_acl_Type, object->sacl, object->sacl);
	}
	return py_sacl;
}

static int py_security_descriptor_set_sacl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sacl));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sacl");
		return -1;
	}
	if (value == Py_None) {
		object->sacl = NULL;
	} else {
		object->sacl = NULL;
		PY_CHECK_TYPE(&security_acl_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sacl = (struct security_acl *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_descriptor_get_dacl(PyObject *obj, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(obj);
	PyObject *py_dacl;
	if (object->dacl == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dacl == NULL) {
		py_dacl = Py_None;
		Py_INCREF(py_dacl);
	} else {
		py_dacl = pytalloc_reference_ex(&security_acl_Type, object->dacl, object->dacl);
	}
	return py_dacl;
}

static int py_security_descriptor_set_dacl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->dacl));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dacl");
		return -1;
	}
	if (value == Py_None) {
		object->dacl = NULL;
	} else {
		object->dacl = NULL;
		PY_CHECK_TYPE(&security_acl_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dacl = (struct security_acl *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_security_descriptor_getsetters[] = {
	{
		.name = discard_const_p(char, "revision"),
		.get = py_security_descriptor_get_revision,
		.set = py_security_descriptor_set_revision,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_descriptor_revision")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_security_descriptor_get_type,
		.set = py_security_descriptor_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_descriptor_type")
	},
	{
		.name = discard_const_p(char, "owner_sid"),
		.get = py_security_descriptor_get_owner_sid,
		.set = py_security_descriptor_set_owner_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "group_sid"),
		.get = py_security_descriptor_get_group_sid,
		.set = py_security_descriptor_set_group_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "sacl"),
		.get = py_security_descriptor_get_sacl,
		.set = py_security_descriptor_set_sacl,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_acl")
	},
	{
		.name = discard_const_p(char, "dacl"),
		.get = py_security_descriptor_get_dacl,
		.set = py_security_descriptor_set_dacl,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_acl")
	},
	{ .name = NULL }
};

static PyObject *py_security_descriptor_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct security_descriptor, type);
}

static PyObject *py_security_descriptor_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_security_descriptor);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_security_descriptor_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_descriptor);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_descriptor);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_security_descriptor_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct security_descriptor *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_security_descriptor, "security_descriptor", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_security_descriptor_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_descriptor_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_descriptor_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_security_descriptor_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_descriptor_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.descriptor",
	.tp_getset = py_security_descriptor_getsetters,
	.tp_methods = py_security_descriptor_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_descriptor_new,
};


static PyObject *py_sec_desc_buf_get_sd_size(PyObject *obj, void *closure)
{
	struct sec_desc_buf *object = pytalloc_get_ptr(obj);
	PyObject *py_sd_size;
	py_sd_size = PyLong_FromUnsignedLongLong((uint32_t)(object->sd_size));
	return py_sd_size;
}

static int py_sec_desc_buf_set_sd_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct sec_desc_buf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sd_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sd_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sd_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_sec_desc_buf_get_sd(PyObject *obj, void *closure)
{
	struct sec_desc_buf *object = pytalloc_get_ptr(obj);
	PyObject *py_sd;
	if (object->sd == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sd == NULL) {
		py_sd = Py_None;
		Py_INCREF(py_sd);
	} else {
		py_sd = pytalloc_reference_ex(&security_descriptor_Type, object->sd, object->sd);
	}
	return py_sd;
}

static int py_sec_desc_buf_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct sec_desc_buf *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sd));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sd");
		return -1;
	}
	if (value == Py_None) {
		object->sd = NULL;
	} else {
		object->sd = NULL;
		PY_CHECK_TYPE(&security_descriptor_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sd = (struct security_descriptor *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_sec_desc_buf_getsetters[] = {
	{
		.name = discard_const_p(char, "sd_size"),
		.get = py_sec_desc_buf_get_sd_size,
		.set = py_sec_desc_buf_set_sd_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sd"),
		.get = py_sec_desc_buf_get_sd,
		.set = py_sec_desc_buf_set_sd,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_descriptor")
	},
	{ .name = NULL }
};

static PyObject *py_sec_desc_buf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct sec_desc_buf, type);
}

static PyObject *py_sec_desc_buf_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct sec_desc_buf *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_sec_desc_buf);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_sec_desc_buf_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct sec_desc_buf *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_sec_desc_buf);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_sec_desc_buf);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_sec_desc_buf_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct sec_desc_buf *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_sec_desc_buf, "sec_desc_buf", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_sec_desc_buf_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_sec_desc_buf_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_sec_desc_buf_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_sec_desc_buf_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject sec_desc_buf_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.sec_desc_buf",
	.tp_getset = py_sec_desc_buf_getsetters,
	.tp_methods = py_sec_desc_buf_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_sec_desc_buf_new,
};


static PyObject *py_security_token_get_num_sids(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_sids));
	return py_num_sids;
}

static int py_security_token_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_sids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_sids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_sids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_token_get_sids(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = PyList_New(object->num_sids);
	if (py_sids == NULL) {
		return NULL;
	}
	{
		int sids_cntr_0;
		for (sids_cntr_0 = 0; sids_cntr_0 < (object->num_sids); sids_cntr_0++) {
			PyObject *py_sids_0;
			py_sids_0 = pytalloc_reference_ex(&dom_sid_Type, object->sids, &(object->sids)[sids_cntr_0]);
			PyList_SetItem(py_sids, sids_cntr_0, py_sids_0);
		}
	}
	return py_sids;
}

static int py_security_token_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sids_cntr_0;
		object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
		if (!object->sids) { return -1; }
		talloc_set_name_const(object->sids, "ARRAY: object->sids");
		for (sids_cntr_0 = 0; sids_cntr_0 < PyList_GET_SIZE(value); sids_cntr_0++) {
			if (PyList_GET_ITEM(value, sids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->sids)[sids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dom_sid_Type, PyList_GET_ITEM(value, sids_cntr_0), return -1;);
			if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->sids)[sids_cntr_0] = *(struct dom_sid *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_security_token_get_privilege_mask(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_privilege_mask;
	py_privilege_mask = PyLong_FromUnsignedLongLong(object->privilege_mask);
	return py_privilege_mask;
}

static int py_security_token_set_privilege_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->privilege_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->privilege_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->privilege_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_token_get_rights_mask(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_rights_mask;
	py_rights_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->rights_mask));
	return py_rights_mask;
}

static int py_security_token_set_rights_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rights_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rights_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rights_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_token_get_num_local_claims(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_num_local_claims;
	py_num_local_claims = PyLong_FromUnsignedLongLong((uint32_t)(object->num_local_claims));
	return py_num_local_claims;
}

static int py_security_token_set_num_local_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_local_claims");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_local_claims));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_local_claims = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_token_get_num_user_claims(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_num_user_claims;
	py_num_user_claims = PyLong_FromUnsignedLongLong((uint32_t)(object->num_user_claims));
	return py_num_user_claims;
}

static int py_security_token_set_num_user_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_user_claims");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_user_claims));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_user_claims = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_token_get_num_device_claims(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_num_device_claims;
	py_num_device_claims = PyLong_FromUnsignedLongLong((uint32_t)(object->num_device_claims));
	return py_num_device_claims;
}

static int py_security_token_set_num_device_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_device_claims");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_device_claims));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_device_claims = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_token_get_num_device_sids(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_num_device_sids;
	py_num_device_sids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_device_sids));
	return py_num_device_sids;
}

static int py_security_token_set_num_device_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_device_sids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_device_sids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_device_sids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_token_get_local_claims(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_local_claims;
	py_local_claims = PyList_New(object->num_local_claims);
	if (py_local_claims == NULL) {
		return NULL;
	}
	{
		int local_claims_cntr_0;
		for (local_claims_cntr_0 = 0; local_claims_cntr_0 < (object->num_local_claims); local_claims_cntr_0++) {
			PyObject *py_local_claims_0;
			py_local_claims_0 = pytalloc_reference_ex(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, object->local_claims, &(object->local_claims)[local_claims_cntr_0]);
			PyList_SetItem(py_local_claims, local_claims_cntr_0, py_local_claims_0);
		}
	}
	return py_local_claims;
}

static int py_security_token_set_local_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->local_claims");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int local_claims_cntr_0;
		object->local_claims = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->local_claims, PyList_GET_SIZE(value));
		if (!object->local_claims) { return -1; }
		talloc_set_name_const(object->local_claims, "ARRAY: object->local_claims");
		for (local_claims_cntr_0 = 0; local_claims_cntr_0 < PyList_GET_SIZE(value); local_claims_cntr_0++) {
			if (PyList_GET_ITEM(value, local_claims_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->local_claims)[local_claims_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, PyList_GET_ITEM(value, local_claims_cntr_0), return -1;);
			if (talloc_reference(object->local_claims, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, local_claims_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->local_claims)[local_claims_cntr_0] = *(struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, local_claims_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_security_token_get_user_claims(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_user_claims;
	py_user_claims = PyList_New(object->num_user_claims);
	if (py_user_claims == NULL) {
		return NULL;
	}
	{
		int user_claims_cntr_0;
		for (user_claims_cntr_0 = 0; user_claims_cntr_0 < (object->num_user_claims); user_claims_cntr_0++) {
			PyObject *py_user_claims_0;
			py_user_claims_0 = pytalloc_reference_ex(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, object->user_claims, &(object->user_claims)[user_claims_cntr_0]);
			PyList_SetItem(py_user_claims, user_claims_cntr_0, py_user_claims_0);
		}
	}
	return py_user_claims;
}

static int py_security_token_set_user_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user_claims");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int user_claims_cntr_0;
		object->user_claims = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->user_claims, PyList_GET_SIZE(value));
		if (!object->user_claims) { return -1; }
		talloc_set_name_const(object->user_claims, "ARRAY: object->user_claims");
		for (user_claims_cntr_0 = 0; user_claims_cntr_0 < PyList_GET_SIZE(value); user_claims_cntr_0++) {
			if (PyList_GET_ITEM(value, user_claims_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->user_claims)[user_claims_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, PyList_GET_ITEM(value, user_claims_cntr_0), return -1;);
			if (talloc_reference(object->user_claims, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, user_claims_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->user_claims)[user_claims_cntr_0] = *(struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, user_claims_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_security_token_get_device_claims(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_device_claims;
	py_device_claims = PyList_New(object->num_device_claims);
	if (py_device_claims == NULL) {
		return NULL;
	}
	{
		int device_claims_cntr_0;
		for (device_claims_cntr_0 = 0; device_claims_cntr_0 < (object->num_device_claims); device_claims_cntr_0++) {
			PyObject *py_device_claims_0;
			py_device_claims_0 = pytalloc_reference_ex(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, object->device_claims, &(object->device_claims)[device_claims_cntr_0]);
			PyList_SetItem(py_device_claims, device_claims_cntr_0, py_device_claims_0);
		}
	}
	return py_device_claims;
}

static int py_security_token_set_device_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->device_claims");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int device_claims_cntr_0;
		object->device_claims = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->device_claims, PyList_GET_SIZE(value));
		if (!object->device_claims) { return -1; }
		talloc_set_name_const(object->device_claims, "ARRAY: object->device_claims");
		for (device_claims_cntr_0 = 0; device_claims_cntr_0 < PyList_GET_SIZE(value); device_claims_cntr_0++) {
			if (PyList_GET_ITEM(value, device_claims_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->device_claims)[device_claims_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type, PyList_GET_ITEM(value, device_claims_cntr_0), return -1;);
			if (talloc_reference(object->device_claims, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, device_claims_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->device_claims)[device_claims_cntr_0] = *(struct CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, device_claims_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_security_token_get_device_sids(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_device_sids;
	py_device_sids = PyList_New(object->num_device_sids);
	if (py_device_sids == NULL) {
		return NULL;
	}
	{
		int device_sids_cntr_0;
		for (device_sids_cntr_0 = 0; device_sids_cntr_0 < (object->num_device_sids); device_sids_cntr_0++) {
			PyObject *py_device_sids_0;
			py_device_sids_0 = pytalloc_reference_ex(&dom_sid_Type, object->device_sids, &(object->device_sids)[device_sids_cntr_0]);
			PyList_SetItem(py_device_sids, device_sids_cntr_0, py_device_sids_0);
		}
	}
	return py_device_sids;
}

static int py_security_token_set_device_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->device_sids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int device_sids_cntr_0;
		object->device_sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->device_sids, PyList_GET_SIZE(value));
		if (!object->device_sids) { return -1; }
		talloc_set_name_const(object->device_sids, "ARRAY: object->device_sids");
		for (device_sids_cntr_0 = 0; device_sids_cntr_0 < PyList_GET_SIZE(value); device_sids_cntr_0++) {
			if (PyList_GET_ITEM(value, device_sids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->device_sids)[device_sids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dom_sid_Type, PyList_GET_ITEM(value, device_sids_cntr_0), return -1;);
			if (talloc_reference(object->device_sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, device_sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->device_sids)[device_sids_cntr_0] = *(struct dom_sid *)pytalloc_get_ptr(PyList_GET_ITEM(value, device_sids_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_security_token_get_evaluate_claims(PyObject *obj, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(obj);
	PyObject *py_evaluate_claims;
	py_evaluate_claims = PyLong_FromLong((uint16_t)(object->evaluate_claims));
	return py_evaluate_claims;
}

static int py_security_token_set_evaluate_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->evaluate_claims");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->evaluate_claims));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->evaluate_claims = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_security_token_getsetters[] = {
	{
		.name = discard_const_p(char, "num_sids"),
		.get = py_security_token_get_num_sids,
		.set = py_security_token_set_num_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_security_token_get_sids,
		.set = py_security_token_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "privilege_mask"),
		.get = py_security_token_get_privilege_mask,
		.set = py_security_token_set_privilege_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type se_privilege")
	},
	{
		.name = discard_const_p(char, "rights_mask"),
		.get = py_security_token_get_rights_mask,
		.set = py_security_token_set_rights_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SystemAccessModeFlags")
	},
	{
		.name = discard_const_p(char, "num_local_claims"),
		.get = py_security_token_get_num_local_claims,
		.set = py_security_token_set_num_local_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_user_claims"),
		.get = py_security_token_get_num_user_claims,
		.set = py_security_token_set_num_user_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_device_claims"),
		.get = py_security_token_get_num_device_claims,
		.set = py_security_token_set_num_device_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_device_sids"),
		.get = py_security_token_get_num_device_sids,
		.set = py_security_token_set_num_device_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "local_claims"),
		.get = py_security_token_get_local_claims,
		.set = py_security_token_set_local_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1")
	},
	{
		.name = discard_const_p(char, "user_claims"),
		.get = py_security_token_get_user_claims,
		.set = py_security_token_set_user_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1")
	},
	{
		.name = discard_const_p(char, "device_claims"),
		.get = py_security_token_get_device_claims,
		.set = py_security_token_set_device_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1")
	},
	{
		.name = discard_const_p(char, "device_sids"),
		.get = py_security_token_get_device_sids,
		.set = py_security_token_set_device_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "evaluate_claims"),
		.get = py_security_token_get_evaluate_claims,
		.set = py_security_token_set_evaluate_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_evaluation_control")
	},
	{ .name = NULL }
};

static PyObject *py_security_token_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct security_token, type);
}

static PyObject *py_security_token_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_security_token);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_security_token_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_token);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_token);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_security_token_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct security_token *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_security_token, "security_token", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_security_token_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_token_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_token_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_security_token_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_token_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.token",
	.tp_getset = py_security_token_getsetters,
	.tp_methods = py_security_token_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_token_new,
};


static PyObject *py_security_token_descriptor_fuzzing_pair_get_token(PyObject *obj, void *closure)
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(obj);
	PyObject *py_token;
	py_token = pytalloc_reference_ex(&security_token_Type, pytalloc_get_mem_ctx(obj), &object->token);
	return py_token;
}

static int py_security_token_descriptor_fuzzing_pair_set_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->token");
		return -1;
	}
	PY_CHECK_TYPE(&security_token_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->token = *(struct security_token *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_security_token_descriptor_fuzzing_pair_get_sd(PyObject *obj, void *closure)
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(obj);
	PyObject *py_sd;
	py_sd = pytalloc_reference_ex(&security_descriptor_Type, pytalloc_get_mem_ctx(obj), &object->sd);
	return py_sd;
}

static int py_security_token_descriptor_fuzzing_pair_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sd");
		return -1;
	}
	PY_CHECK_TYPE(&security_descriptor_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sd = *(struct security_descriptor *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_security_token_descriptor_fuzzing_pair_get_access_desired(PyObject *obj, void *closure)
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(obj);
	PyObject *py_access_desired;
	py_access_desired = PyLong_FromUnsignedLongLong((uint32_t)(object->access_desired));
	return py_access_desired;
}

static int py_security_token_descriptor_fuzzing_pair_set_access_desired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->access_desired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->access_desired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->access_desired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_security_token_descriptor_fuzzing_pair_getsetters[] = {
	{
		.name = discard_const_p(char, "token"),
		.get = py_security_token_descriptor_fuzzing_pair_get_token,
		.set = py_security_token_descriptor_fuzzing_pair_set_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_token")
	},
	{
		.name = discard_const_p(char, "sd"),
		.get = py_security_token_descriptor_fuzzing_pair_get_sd,
		.set = py_security_token_descriptor_fuzzing_pair_set_sd,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_descriptor")
	},
	{
		.name = discard_const_p(char, "access_desired"),
		.get = py_security_token_descriptor_fuzzing_pair_get_access_desired,
		.set = py_security_token_descriptor_fuzzing_pair_set_access_desired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_security_token_descriptor_fuzzing_pair_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct security_token_descriptor_fuzzing_pair, type);
}

static PyObject *py_security_token_descriptor_fuzzing_pair_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_security_token_descriptor_fuzzing_pair);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_security_token_descriptor_fuzzing_pair_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_token_descriptor_fuzzing_pair);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_token_descriptor_fuzzing_pair);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_security_token_descriptor_fuzzing_pair_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct security_token_descriptor_fuzzing_pair *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_security_token_descriptor_fuzzing_pair, "security_token_descriptor_fuzzing_pair", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_security_token_descriptor_fuzzing_pair_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_token_descriptor_fuzzing_pair_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_token_descriptor_fuzzing_pair_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_security_token_descriptor_fuzzing_pair_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_token_descriptor_fuzzing_pair_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.token_descriptor_fuzzing_pair",
	.tp_getset = py_security_token_descriptor_fuzzing_pair_getsetters,
	.tp_methods = py_security_token_descriptor_fuzzing_pair_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_token_descriptor_fuzzing_pair_new,
};


static PyObject *py_security_unix_token_get_uid(PyObject *obj, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	py_uid = PyLong_FromUnsignedLongLong(object->uid);
	return py_uid;
}

static int py_security_unix_token_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->uid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_unix_token_get_gid(PyObject *obj, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(obj);
	PyObject *py_gid;
	py_gid = PyLong_FromUnsignedLongLong(object->gid);
	return py_gid;
}

static int py_security_unix_token_set_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_unix_token_get_ngroups(PyObject *obj, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(obj);
	PyObject *py_ngroups;
	py_ngroups = PyLong_FromUnsignedLongLong((uint32_t)(object->ngroups));
	return py_ngroups;
}

static int py_security_unix_token_set_ngroups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ngroups");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ngroups));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ngroups = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_security_unix_token_get_groups(PyObject *obj, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(obj);
	PyObject *py_groups;
	py_groups = PyList_New(object->ngroups);
	if (py_groups == NULL) {
		return NULL;
	}
	{
		int groups_cntr_0;
		for (groups_cntr_0 = 0; groups_cntr_0 < (object->ngroups); groups_cntr_0++) {
			PyObject *py_groups_0;
			py_groups_0 = PyLong_FromUnsignedLongLong((object->groups)[groups_cntr_0]);
			PyList_SetItem(py_groups, groups_cntr_0, py_groups_0);
		}
	}
	return py_groups;
}

static int py_security_unix_token_set_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_unix_token *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->groups");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int groups_cntr_0;
		object->groups = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->groups, PyList_GET_SIZE(value));
		if (!object->groups) { return -1; }
		talloc_set_name_const(object->groups, "ARRAY: object->groups");
		for (groups_cntr_0 = 0; groups_cntr_0 < PyList_GET_SIZE(value); groups_cntr_0++) {
			if (PyList_GET_ITEM(value, groups_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->groups)[groups_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->groups)[groups_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, groups_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, groups_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->groups)[groups_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_security_unix_token_getsetters[] = {
	{
		.name = discard_const_p(char, "uid"),
		.get = py_security_unix_token_get_uid,
		.set = py_security_unix_token_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uid_t")
	},
	{
		.name = discard_const_p(char, "gid"),
		.get = py_security_unix_token_get_gid,
		.set = py_security_unix_token_set_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type gid_t")
	},
	{
		.name = discard_const_p(char, "ngroups"),
		.get = py_security_unix_token_get_ngroups,
		.set = py_security_unix_token_set_ngroups,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "groups"),
		.get = py_security_unix_token_get_groups,
		.set = py_security_unix_token_set_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type gid_t")
	},
	{ .name = NULL }
};

static PyObject *py_security_unix_token_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct security_unix_token, type);
}

static PyObject *py_security_unix_token_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct security_unix_token *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_security_unix_token);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_security_unix_token_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct security_unix_token *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_unix_token);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_security_unix_token);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_security_unix_token_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct security_unix_token *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_security_unix_token, "security_unix_token", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_security_unix_token_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_unix_token_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_security_unix_token_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_security_unix_token_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_unix_token_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.unix_token",
	.tp_getset = py_security_unix_token_getsetters,
	.tp_methods = py_security_unix_token_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_unix_token_new,
};


static PyObject *py_LSAP_TOKEN_INFO_INTEGRITY_get_Flags(PyObject *obj, void *closure)
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromUnsignedLongLong((uint32_t)(object->Flags));
	return py_Flags;
}

static int py_LSAP_TOKEN_INFO_INTEGRITY_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_LSAP_TOKEN_INFO_INTEGRITY_get_TokenIL(PyObject *obj, void *closure)
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(obj);
	PyObject *py_TokenIL;
	py_TokenIL = PyLong_FromUnsignedLongLong((uint32_t)(object->TokenIL));
	return py_TokenIL;
}

static int py_LSAP_TOKEN_INFO_INTEGRITY_set_TokenIL(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->TokenIL");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->TokenIL));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->TokenIL = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_LSAP_TOKEN_INFO_INTEGRITY_get_MachineId(PyObject *obj, void *closure)
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(obj);
	PyObject *py_MachineId;
	py_MachineId = PyList_New(32);
	if (py_MachineId == NULL) {
		return NULL;
	}
	{
		int MachineId_cntr_0;
		for (MachineId_cntr_0 = 0; MachineId_cntr_0 < (32); MachineId_cntr_0++) {
			PyObject *py_MachineId_0;
			py_MachineId_0 = PyLong_FromLong((uint16_t)((object->MachineId)[MachineId_cntr_0]));
			PyList_SetItem(py_MachineId, MachineId_cntr_0, py_MachineId_0);
		}
	}
	return py_MachineId;
}

static int py_LSAP_TOKEN_INFO_INTEGRITY_set_MachineId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->MachineId");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int MachineId_cntr_0;
		if (ARRAY_SIZE(object->MachineId) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->MachineId),  PyList_GET_SIZE(value));
			return -1;
		}
		for (MachineId_cntr_0 = 0; MachineId_cntr_0 < PyList_GET_SIZE(value); MachineId_cntr_0++) {
			if (PyList_GET_ITEM(value, MachineId_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->MachineId)[MachineId_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->MachineId)[MachineId_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, MachineId_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, MachineId_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->MachineId)[MachineId_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_LSAP_TOKEN_INFO_INTEGRITY_getsetters[] = {
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_LSAP_TOKEN_INFO_INTEGRITY_get_Flags,
		.set = py_LSAP_TOKEN_INFO_INTEGRITY_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "TokenIL"),
		.get = py_LSAP_TOKEN_INFO_INTEGRITY_get_TokenIL,
		.set = py_LSAP_TOKEN_INFO_INTEGRITY_set_TokenIL,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "MachineId"),
		.get = py_LSAP_TOKEN_INFO_INTEGRITY_get_MachineId,
		.set = py_LSAP_TOKEN_INFO_INTEGRITY_set_MachineId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_LSAP_TOKEN_INFO_INTEGRITY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct LSAP_TOKEN_INFO_INTEGRITY, type);
}

static PyObject *py_LSAP_TOKEN_INFO_INTEGRITY_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_LSAP_TOKEN_INFO_INTEGRITY);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_LSAP_TOKEN_INFO_INTEGRITY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_LSAP_TOKEN_INFO_INTEGRITY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_LSAP_TOKEN_INFO_INTEGRITY);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_LSAP_TOKEN_INFO_INTEGRITY_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct LSAP_TOKEN_INFO_INTEGRITY *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_LSAP_TOKEN_INFO_INTEGRITY, "LSAP_TOKEN_INFO_INTEGRITY", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_LSAP_TOKEN_INFO_INTEGRITY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_LSAP_TOKEN_INFO_INTEGRITY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_LSAP_TOKEN_INFO_INTEGRITY_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_LSAP_TOKEN_INFO_INTEGRITY_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject LSAP_TOKEN_INFO_INTEGRITY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.LSAP_TOKEN_INFO_INTEGRITY",
	.tp_getset = py_LSAP_TOKEN_INFO_INTEGRITY_getsetters,
	.tp_methods = py_LSAP_TOKEN_INFO_INTEGRITY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_LSAP_TOKEN_INFO_INTEGRITY_new,
};


static PyObject *py_generic_mapping_get_generic_read(PyObject *obj, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_generic_read;
	py_generic_read = PyLong_FromUnsignedLongLong((uint32_t)(object->generic_read));
	return py_generic_read;
}

static int py_generic_mapping_set_generic_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->generic_read");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->generic_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->generic_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_generic_mapping_get_generic_write(PyObject *obj, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_generic_write;
	py_generic_write = PyLong_FromUnsignedLongLong((uint32_t)(object->generic_write));
	return py_generic_write;
}

static int py_generic_mapping_set_generic_write(PyObject *py_obj, PyObject *value, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->generic_write");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->generic_write));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->generic_write = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_generic_mapping_get_generic_execute(PyObject *obj, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_generic_execute;
	py_generic_execute = PyLong_FromUnsignedLongLong((uint32_t)(object->generic_execute));
	return py_generic_execute;
}

static int py_generic_mapping_set_generic_execute(PyObject *py_obj, PyObject *value, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->generic_execute");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->generic_execute));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->generic_execute = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_generic_mapping_get_generic_all(PyObject *obj, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_generic_all;
	py_generic_all = PyLong_FromUnsignedLongLong((uint32_t)(object->generic_all));
	return py_generic_all;
}

static int py_generic_mapping_set_generic_all(PyObject *py_obj, PyObject *value, void *closure)
{
	struct generic_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->generic_all");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->generic_all));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->generic_all = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_generic_mapping_getsetters[] = {
	{
		.name = discard_const_p(char, "generic_read"),
		.get = py_generic_mapping_get_generic_read,
		.set = py_generic_mapping_set_generic_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "generic_write"),
		.get = py_generic_mapping_get_generic_write,
		.set = py_generic_mapping_set_generic_write,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "generic_execute"),
		.get = py_generic_mapping_get_generic_execute,
		.set = py_generic_mapping_set_generic_execute,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "generic_all"),
		.get = py_generic_mapping_get_generic_all,
		.set = py_generic_mapping_set_generic_all,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_generic_mapping_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct generic_mapping, type);
}


static PyTypeObject generic_mapping_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.generic_mapping",
	.tp_getset = py_generic_mapping_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_generic_mapping_new,
};


static PyObject *py_standard_mapping_get_std_read(PyObject *obj, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_std_read;
	py_std_read = PyLong_FromUnsignedLongLong((uint32_t)(object->std_read));
	return py_std_read;
}

static int py_standard_mapping_set_std_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->std_read");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->std_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->std_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_standard_mapping_get_std_write(PyObject *obj, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_std_write;
	py_std_write = PyLong_FromUnsignedLongLong((uint32_t)(object->std_write));
	return py_std_write;
}

static int py_standard_mapping_set_std_write(PyObject *py_obj, PyObject *value, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->std_write");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->std_write));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->std_write = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_standard_mapping_get_std_execute(PyObject *obj, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_std_execute;
	py_std_execute = PyLong_FromUnsignedLongLong((uint32_t)(object->std_execute));
	return py_std_execute;
}

static int py_standard_mapping_set_std_execute(PyObject *py_obj, PyObject *value, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->std_execute");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->std_execute));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->std_execute = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_standard_mapping_get_std_all(PyObject *obj, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(obj);
	PyObject *py_std_all;
	py_std_all = PyLong_FromUnsignedLongLong((uint32_t)(object->std_all));
	return py_std_all;
}

static int py_standard_mapping_set_std_all(PyObject *py_obj, PyObject *value, void *closure)
{
	struct standard_mapping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->std_all");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->std_all));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->std_all = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_standard_mapping_getsetters[] = {
	{
		.name = discard_const_p(char, "std_read"),
		.get = py_standard_mapping_get_std_read,
		.set = py_standard_mapping_set_std_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "std_write"),
		.get = py_standard_mapping_get_std_write,
		.set = py_standard_mapping_set_std_write,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "std_execute"),
		.get = py_standard_mapping_get_std_execute,
		.set = py_standard_mapping_set_std_execute,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "std_all"),
		.get = py_standard_mapping_get_std_all,
		.set = py_standard_mapping_set_std_all,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_standard_mapping_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct standard_mapping, type);
}


static PyTypeObject standard_mapping_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.standard_mapping",
	.tp_getset = py_standard_mapping_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_standard_mapping_new,
};


const struct PyNdrRpcMethodDef py_ndr_security_methods[] = {
	{0}
};

static PyObject *interface_security_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_security);
}

static PyTypeObject security_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.security",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "security(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_security_new,
};

static PyObject *syntax_security_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_security.syntax_id);
}

static PyTypeObject security_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "security.security_abstract_syntax",
	.tp_doc = "security_abstract_syntax()\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_security_new,
};

static PyMethodDef security_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "security",
	.m_doc = "security DCE/RPC",
	.m_size = -1,
	.m_methods = security_methods,
};
MODULE_INIT_FUNC(security)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	dom_sid_Type.tp_base = BaseObject_Type;
	dom_sid_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_ace_object_type_Type.tp_base = BaseObject_Type;
	security_ace_object_type_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_ace_object_inherited_type_Type.tp_base = BaseObject_Type;
	security_ace_object_inherited_type_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_ace_object_Type.tp_base = BaseObject_Type;
	security_ace_object_Type.tp_basicsize = pytalloc_BaseObject_size();

	claim_values_Type.tp_base = BaseObject_Type;
	claim_values_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type.tp_base = BaseObject_Type;
	CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_ace_object_ctr_Type.tp_base = BaseObject_Type;
	security_ace_object_ctr_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_ace_coda_Type.tp_base = BaseObject_Type;
	security_ace_coda_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_ace_Type.tp_base = BaseObject_Type;
	security_ace_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_acl_Type.tp_base = BaseObject_Type;
	security_acl_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_descriptor_Type.tp_base = BaseObject_Type;
	security_descriptor_Type.tp_basicsize = pytalloc_BaseObject_size();

	sec_desc_buf_Type.tp_base = BaseObject_Type;
	sec_desc_buf_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_token_Type.tp_base = BaseObject_Type;
	security_token_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_token_descriptor_fuzzing_pair_Type.tp_base = BaseObject_Type;
	security_token_descriptor_fuzzing_pair_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_unix_token_Type.tp_base = BaseObject_Type;
	security_unix_token_Type.tp_basicsize = pytalloc_BaseObject_size();

	LSAP_TOKEN_INFO_INTEGRITY_Type.tp_base = BaseObject_Type;
	LSAP_TOKEN_INFO_INTEGRITY_Type.tp_basicsize = pytalloc_BaseObject_size();

	generic_mapping_Type.tp_base = BaseObject_Type;
	generic_mapping_Type.tp_basicsize = pytalloc_BaseObject_size();

	standard_mapping_Type.tp_base = BaseObject_Type;
	standard_mapping_Type.tp_basicsize = pytalloc_BaseObject_size();

	security_InterfaceType.tp_base = ClientConnection_Type;

	security_SyntaxType.tp_base = ndr_syntax_id_Type;
	security_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&dom_sid_Type) < 0)
		goto out;
	if (PyType_Ready(&security_ace_object_type_Type) < 0)
		goto out;
	if (PyType_Ready(&security_ace_object_inherited_type_Type) < 0)
		goto out;
	if (PyType_Ready(&security_ace_object_Type) < 0)
		goto out;
	if (PyType_Ready(&claim_values_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type) < 0)
		goto out;
	if (PyType_Ready(&security_ace_object_ctr_Type) < 0)
		goto out;
	if (PyType_Ready(&security_ace_coda_Type) < 0)
		goto out;
	if (PyType_Ready(&security_ace_Type) < 0)
		goto out;
	if (PyType_Ready(&security_acl_Type) < 0)
		goto out;
	if (PyType_Ready(&security_descriptor_Type) < 0)
		goto out;
	if (PyType_Ready(&sec_desc_buf_Type) < 0)
		goto out;
	if (PyType_Ready(&security_token_Type) < 0)
		goto out;
	if (PyType_Ready(&security_token_descriptor_fuzzing_pair_Type) < 0)
		goto out;
	if (PyType_Ready(&security_unix_token_Type) < 0)
		goto out;
	if (PyType_Ready(&LSAP_TOKEN_INFO_INTEGRITY_Type) < 0)
		goto out;
	if (PyType_Ready(&generic_mapping_Type) < 0)
		goto out;
	if (PyType_Ready(&standard_mapping_Type) < 0)
		goto out;
	if (PyType_Ready(&security_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&security_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&security_InterfaceType, py_ndr_security_methods))
		return NULL;

#ifdef PY_DOM_SID_PATCH
	PY_DOM_SID_PATCH(&dom_sid_Type);
#endif
#ifdef PY_ACE_OBJECT_TYPE_PATCH
	PY_ACE_OBJECT_TYPE_PATCH(&security_ace_object_type_Type);
#endif
#ifdef PY_ACE_OBJECT_INHERITED_TYPE_PATCH
	PY_ACE_OBJECT_INHERITED_TYPE_PATCH(&security_ace_object_inherited_type_Type);
#endif
#ifdef PY_ACE_OBJECT_PATCH
	PY_ACE_OBJECT_PATCH(&security_ace_object_Type);
#endif
#ifdef PY_CLAIM_VALUES_PATCH
	PY_CLAIM_VALUES_PATCH(&claim_values_Type);
#endif
#ifdef PY_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_PATCH
	PY_CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_PATCH(&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type);
#endif
#ifdef PY_ACE_OBJECT_CTR_PATCH
	PY_ACE_OBJECT_CTR_PATCH(&security_ace_object_ctr_Type);
#endif
#ifdef PY_ACE_CODA_PATCH
	PY_ACE_CODA_PATCH(&security_ace_coda_Type);
#endif
#ifdef PY_ACE_PATCH
	PY_ACE_PATCH(&security_ace_Type);
#endif
#ifdef PY_ACL_PATCH
	PY_ACL_PATCH(&security_acl_Type);
#endif
#ifdef PY_DESCRIPTOR_PATCH
	PY_DESCRIPTOR_PATCH(&security_descriptor_Type);
#endif
#ifdef PY_SEC_DESC_BUF_PATCH
	PY_SEC_DESC_BUF_PATCH(&sec_desc_buf_Type);
#endif
#ifdef PY_TOKEN_PATCH
	PY_TOKEN_PATCH(&security_token_Type);
#endif
#ifdef PY_TOKEN_DESCRIPTOR_FUZZING_PAIR_PATCH
	PY_TOKEN_DESCRIPTOR_FUZZING_PAIR_PATCH(&security_token_descriptor_fuzzing_pair_Type);
#endif
#ifdef PY_UNIX_TOKEN_PATCH
	PY_UNIX_TOKEN_PATCH(&security_unix_token_Type);
#endif
#ifdef PY_LSAP_TOKEN_INFO_INTEGRITY_PATCH
	PY_LSAP_TOKEN_INFO_INTEGRITY_PATCH(&LSAP_TOKEN_INFO_INTEGRITY_Type);
#endif
#ifdef PY_GENERIC_MAPPING_PATCH
	PY_GENERIC_MAPPING_PATCH(&generic_mapping_Type);
#endif
#ifdef PY_STANDARD_MAPPING_PATCH
	PY_STANDARD_MAPPING_PATCH(&standard_mapping_Type);
#endif
#ifdef PY_SECURITY_PATCH
	PY_SECURITY_PATCH(&security_InterfaceType);
#endif
#ifdef PY_SECURITY_ABSTRACT_SYNTAX_PATCH
	PY_SECURITY_ABSTRACT_SYNTAX_PATCH(&security_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&security_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "SEC_MASK_GENERIC", PyLong_FromUnsignedLongLong(0xF0000000));
	PyModule_AddObject(m, "SEC_MASK_FLAGS", PyLong_FromUnsignedLongLong(0x0F000000));
	PyModule_AddObject(m, "SEC_MASK_STANDARD", PyLong_FromUnsignedLongLong(0x00FF0000));
	PyModule_AddObject(m, "SEC_MASK_SPECIFIC", PyLong_FromUnsignedLongLong(0x0000FFFF));
	PyModule_AddObject(m, "SEC_GENERIC_ALL", PyLong_FromUnsignedLongLong(0x10000000));
	PyModule_AddObject(m, "SEC_GENERIC_EXECUTE", PyLong_FromUnsignedLongLong(0x20000000));
	PyModule_AddObject(m, "SEC_GENERIC_WRITE", PyLong_FromUnsignedLongLong(0x40000000));
	PyModule_AddObject(m, "SEC_GENERIC_READ", PyLong_FromUnsignedLongLong(0x80000000));
	PyModule_AddObject(m, "SEC_FLAG_SYSTEM_SECURITY", PyLong_FromUnsignedLongLong(0x01000000));
	PyModule_AddObject(m, "SEC_FLAG_MAXIMUM_ALLOWED", PyLong_FromUnsignedLongLong(0x02000000));
	PyModule_AddObject(m, "SEC_STD_DELETE", PyLong_FromUnsignedLongLong(0x00010000));
	PyModule_AddObject(m, "SEC_STD_READ_CONTROL", PyLong_FromUnsignedLongLong(0x00020000));
	PyModule_AddObject(m, "SEC_STD_WRITE_DAC", PyLong_FromUnsignedLongLong(0x00040000));
	PyModule_AddObject(m, "SEC_STD_WRITE_OWNER", PyLong_FromUnsignedLongLong(0x00080000));
	PyModule_AddObject(m, "SEC_STD_SYNCHRONIZE", PyLong_FromUnsignedLongLong(0x00100000));
	PyModule_AddObject(m, "SEC_STD_REQUIRED", PyLong_FromUnsignedLongLong(0x000F0000));
	PyModule_AddObject(m, "SEC_STD_ALL", PyLong_FromUnsignedLongLong(0x001F0000));
	PyModule_AddObject(m, "SEC_FILE_READ_DATA", PyLong_FromUnsignedLongLong(0x00000001));
	PyModule_AddObject(m, "SEC_FILE_WRITE_DATA", PyLong_FromUnsignedLongLong(0x00000002));
	PyModule_AddObject(m, "SEC_FILE_APPEND_DATA", PyLong_FromUnsignedLongLong(0x00000004));
	PyModule_AddObject(m, "SEC_FILE_READ_EA", PyLong_FromUnsignedLongLong(0x00000008));
	PyModule_AddObject(m, "SEC_FILE_WRITE_EA", PyLong_FromUnsignedLongLong(0x00000010));
	PyModule_AddObject(m, "SEC_FILE_EXECUTE", PyLong_FromUnsignedLongLong(0x00000020));
	PyModule_AddObject(m, "SEC_FILE_READ_ATTRIBUTE", PyLong_FromUnsignedLongLong(0x00000080));
	PyModule_AddObject(m, "SEC_FILE_WRITE_ATTRIBUTE", PyLong_FromUnsignedLongLong(0x00000100));
	PyModule_AddObject(m, "SEC_FILE_ALL", PyLong_FromUnsignedLongLong(0x000001ff));
	PyModule_AddObject(m, "SEC_DIR_LIST", PyLong_FromUnsignedLongLong(0x00000001));
	PyModule_AddObject(m, "SEC_DIR_ADD_FILE", PyLong_FromUnsignedLongLong(0x00000002));
	PyModule_AddObject(m, "SEC_DIR_ADD_SUBDIR", PyLong_FromUnsignedLongLong(0x00000004));
	PyModule_AddObject(m, "SEC_DIR_READ_EA", PyLong_FromUnsignedLongLong(0x00000008));
	PyModule_AddObject(m, "SEC_DIR_WRITE_EA", PyLong_FromUnsignedLongLong(0x00000010));
	PyModule_AddObject(m, "SEC_DIR_TRAVERSE", PyLong_FromUnsignedLongLong(0x00000020));
	PyModule_AddObject(m, "SEC_DIR_DELETE_CHILD", PyLong_FromUnsignedLongLong(0x00000040));
	PyModule_AddObject(m, "SEC_DIR_READ_ATTRIBUTE", PyLong_FromUnsignedLongLong(0x00000080));
	PyModule_AddObject(m, "SEC_DIR_WRITE_ATTRIBUTE", PyLong_FromUnsignedLongLong(0x00000100));
	PyModule_AddObject(m, "SEC_REG_QUERY_VALUE", PyLong_FromUnsignedLongLong(0x00000001));
	PyModule_AddObject(m, "SEC_REG_SET_VALUE", PyLong_FromUnsignedLongLong(0x00000002));
	PyModule_AddObject(m, "SEC_REG_CREATE_SUBKEY", PyLong_FromUnsignedLongLong(0x00000004));
	PyModule_AddObject(m, "SEC_REG_ENUM_SUBKEYS", PyLong_FromUnsignedLongLong(0x00000008));
	PyModule_AddObject(m, "SEC_REG_NOTIFY", PyLong_FromUnsignedLongLong(0x00000010));
	PyModule_AddObject(m, "SEC_REG_CREATE_LINK", PyLong_FromUnsignedLongLong(0x00000020));
	PyModule_AddObject(m, "SEC_ADS_CREATE_CHILD", PyLong_FromUnsignedLongLong(0x00000001));
	PyModule_AddObject(m, "SEC_ADS_DELETE_CHILD", PyLong_FromUnsignedLongLong(0x00000002));
	PyModule_AddObject(m, "SEC_ADS_LIST", PyLong_FromUnsignedLongLong(0x00000004));
	PyModule_AddObject(m, "SEC_ADS_SELF_WRITE", PyLong_FromUnsignedLongLong(0x00000008));
	PyModule_AddObject(m, "SEC_ADS_READ_PROP", PyLong_FromUnsignedLongLong(0x00000010));
	PyModule_AddObject(m, "SEC_ADS_WRITE_PROP", PyLong_FromUnsignedLongLong(0x00000020));
	PyModule_AddObject(m, "SEC_ADS_DELETE_TREE", PyLong_FromUnsignedLongLong(0x00000040));
	PyModule_AddObject(m, "SEC_ADS_LIST_OBJECT", PyLong_FromUnsignedLongLong(0x00000080));
	PyModule_AddObject(m, "SEC_ADS_CONTROL_ACCESS", PyLong_FromUnsignedLongLong(0x00000100));
	PyModule_AddObject(m, "SEC_MASK_INVALID", PyLong_FromUnsignedLongLong(0x0ce0fe00));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_READ", PyLong_FromLong(SEC_STD_READ_CONTROL|SEC_STD_SYNCHRONIZE|SEC_FILE_READ_DATA|SEC_FILE_READ_ATTRIBUTE|SEC_FILE_READ_EA));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_WRITE", PyLong_FromLong(SEC_STD_READ_CONTROL|SEC_STD_SYNCHRONIZE|SEC_FILE_WRITE_DATA|SEC_FILE_WRITE_ATTRIBUTE|SEC_FILE_WRITE_EA|SEC_FILE_APPEND_DATA));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_EXECUTE", PyLong_FromLong(SEC_STD_SYNCHRONIZE|SEC_STD_READ_CONTROL|SEC_FILE_READ_ATTRIBUTE|SEC_FILE_EXECUTE));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_ALL", PyLong_FromLong(SEC_STD_ALL|SEC_FILE_ALL));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_READ", PyLong_FromLong(SEC_RIGHTS_FILE_READ));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_WRITE", PyLong_FromLong(SEC_RIGHTS_FILE_WRITE));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_EXECUTE", PyLong_FromLong(SEC_RIGHTS_FILE_EXECUTE));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_ALL", PyLong_FromLong(SEC_RIGHTS_FILE_ALL));
	PyModule_AddObject(m, "SEC_RIGHTS_PRIV_BACKUP", PyLong_FromLong(SEC_STD_READ_CONTROL|SEC_FLAG_SYSTEM_SECURITY|SEC_RIGHTS_FILE_READ|SEC_DIR_TRAVERSE));
	PyModule_AddObject(m, "SEC_RIGHTS_PRIV_RESTORE", PyLong_FromLong(SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER|SEC_FLAG_SYSTEM_SECURITY|SEC_RIGHTS_FILE_WRITE|SEC_DIR_ADD_FILE|SEC_DIR_ADD_SUBDIR|SEC_STD_DELETE));
	PyModule_AddObject(m, "STANDARD_RIGHTS_ALL_ACCESS", PyLong_FromLong(SEC_STD_ALL));
	PyModule_AddObject(m, "STANDARD_RIGHTS_MODIFY_ACCESS", PyLong_FromLong(SEC_STD_READ_CONTROL));
	PyModule_AddObject(m, "STANDARD_RIGHTS_EXECUTE_ACCESS", PyLong_FromLong(SEC_STD_READ_CONTROL));
	PyModule_AddObject(m, "STANDARD_RIGHTS_READ_ACCESS", PyLong_FromLong(SEC_STD_READ_CONTROL));
	PyModule_AddObject(m, "STANDARD_RIGHTS_WRITE_ACCESS", PyLong_FromLong((SEC_STD_WRITE_OWNER|SEC_STD_WRITE_DAC|SEC_STD_DELETE)));
	PyModule_AddObject(m, "STANDARD_RIGHTS_REQUIRED_ACCESS", PyLong_FromLong((SEC_STD_DELETE|SEC_STD_READ_CONTROL|SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER)));
	PyModule_AddObject(m, "SEC_ADS_GENERIC_ALL_DS", PyLong_FromLong((SEC_STD_DELETE|SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER|SEC_ADS_CREATE_CHILD|SEC_ADS_DELETE_CHILD|SEC_ADS_DELETE_TREE|SEC_ADS_CONTROL_ACCESS)));
	PyModule_AddObject(m, "SEC_ADS_GENERIC_EXECUTE", PyLong_FromLong(SEC_STD_READ_CONTROL|SEC_ADS_LIST));
	PyModule_AddObject(m, "SEC_ADS_GENERIC_WRITE", PyLong_FromLong((SEC_STD_READ_CONTROL|SEC_ADS_SELF_WRITE|SEC_ADS_WRITE_PROP)));
	PyModule_AddObject(m, "SEC_ADS_GENERIC_READ", PyLong_FromLong((SEC_STD_READ_CONTROL|SEC_ADS_LIST|SEC_ADS_READ_PROP|SEC_ADS_LIST_OBJECT)));
	PyModule_AddObject(m, "SEC_ADS_GENERIC_ALL", PyLong_FromLong((SEC_ADS_GENERIC_EXECUTE|SEC_ADS_GENERIC_WRITE|SEC_ADS_GENERIC_READ|SEC_ADS_GENERIC_ALL_DS)));
	PyModule_AddObject(m, "SID_NULL", PyUnicode_FromString("S-1-0-0"));
	PyModule_AddObject(m, "NAME_WORLD", PyUnicode_FromString("WORLD"));
	PyModule_AddObject(m, "SID_WORLD_DOMAIN", PyUnicode_FromString("S-1-1"));
	PyModule_AddObject(m, "SID_WORLD", PyUnicode_FromString("S-1-1-0"));
	PyModule_AddObject(m, "SID_CREATOR_OWNER_DOMAIN", PyUnicode_FromString("S-1-3"));
	PyModule_AddObject(m, "SID_CREATOR_OWNER", PyUnicode_FromString("S-1-3-0"));
	PyModule_AddObject(m, "SID_CREATOR_GROUP", PyUnicode_FromString("S-1-3-1"));
	PyModule_AddObject(m, "SID_OWNER_RIGHTS", PyUnicode_FromString("S-1-3-4"));
	PyModule_AddObject(m, "NAME_NT_AUTHORITY", PyUnicode_FromString("NT AUTHORITY"));
	PyModule_AddObject(m, "SID_NT_AUTHORITY", PyUnicode_FromString("S-1-5"));
	PyModule_AddObject(m, "SID_NT_DIALUP", PyUnicode_FromString("S-1-5-1"));
	PyModule_AddObject(m, "SID_NT_NETWORK", PyUnicode_FromString("S-1-5-2"));
	PyModule_AddObject(m, "SID_NT_BATCH", PyUnicode_FromString("S-1-5-3"));
	PyModule_AddObject(m, "SID_NT_INTERACTIVE", PyUnicode_FromString("S-1-5-4"));
	PyModule_AddObject(m, "SID_NT_SERVICE", PyUnicode_FromString("S-1-5-6"));
	PyModule_AddObject(m, "SID_NT_ANONYMOUS", PyUnicode_FromString("S-1-5-7"));
	PyModule_AddObject(m, "SID_NT_PROXY", PyUnicode_FromString("S-1-5-8"));
	PyModule_AddObject(m, "SID_NT_ENTERPRISE_DCS", PyUnicode_FromString("S-1-5-9"));
	PyModule_AddObject(m, "SID_NT_SELF", PyUnicode_FromString("S-1-5-10"));
	PyModule_AddObject(m, "SID_NT_AUTHENTICATED_USERS", PyUnicode_FromString("S-1-5-11"));
	PyModule_AddObject(m, "SID_NT_RESTRICTED", PyUnicode_FromString("S-1-5-12"));
	PyModule_AddObject(m, "SID_NT_TERMINAL_SERVER_USERS", PyUnicode_FromString("S-1-5-13"));
	PyModule_AddObject(m, "SID_NT_REMOTE_INTERACTIVE", PyUnicode_FromString("S-1-5-14"));
	PyModule_AddObject(m, "SID_NT_THIS_ORGANISATION", PyUnicode_FromString("S-1-5-15"));
	PyModule_AddObject(m, "SID_NT_IUSR", PyUnicode_FromString("S-1-5-17"));
	PyModule_AddObject(m, "SID_NT_SYSTEM", PyUnicode_FromString("S-1-5-18"));
	PyModule_AddObject(m, "SID_NT_LOCAL_SERVICE", PyUnicode_FromString("S-1-5-19"));
	PyModule_AddObject(m, "SID_NT_NETWORK_SERVICE", PyUnicode_FromString("S-1-5-20"));
	PyModule_AddObject(m, "SID_NT_DIGEST_AUTHENTICATION", PyUnicode_FromString("S-1-5-64-21"));
	PyModule_AddObject(m, "SID_NT_NTLM_AUTHENTICATION", PyUnicode_FromString("S-1-5-64-10"));
	PyModule_AddObject(m, "SID_NT_SCHANNEL_AUTHENTICATION", PyUnicode_FromString("S-1-5-64-14"));
	PyModule_AddObject(m, "SID_NT_OTHER_ORGANISATION", PyUnicode_FromString("S-1-5-1000"));
	PyModule_AddObject(m, "NAME_BUILTIN", PyUnicode_FromString("BUILTIN"));
	PyModule_AddObject(m, "SID_BUILTIN", PyUnicode_FromString("S-1-5-32"));
	PyModule_AddObject(m, "SID_BUILTIN_ADMINISTRATORS", PyUnicode_FromString("S-1-5-32-544"));
	PyModule_AddObject(m, "SID_BUILTIN_USERS", PyUnicode_FromString("S-1-5-32-545"));
	PyModule_AddObject(m, "SID_BUILTIN_GUESTS", PyUnicode_FromString("S-1-5-32-546"));
	PyModule_AddObject(m, "SID_BUILTIN_POWER_USERS", PyUnicode_FromString("S-1-5-32-547"));
	PyModule_AddObject(m, "SID_BUILTIN_ACCOUNT_OPERATORS", PyUnicode_FromString("S-1-5-32-548"));
	PyModule_AddObject(m, "SID_BUILTIN_SERVER_OPERATORS", PyUnicode_FromString("S-1-5-32-549"));
	PyModule_AddObject(m, "SID_BUILTIN_PRINT_OPERATORS", PyUnicode_FromString("S-1-5-32-550"));
	PyModule_AddObject(m, "SID_BUILTIN_BACKUP_OPERATORS", PyUnicode_FromString("S-1-5-32-551"));
	PyModule_AddObject(m, "SID_BUILTIN_REPLICATOR", PyUnicode_FromString("S-1-5-32-552"));
	PyModule_AddObject(m, "SID_BUILTIN_RAS_SERVERS", PyUnicode_FromString("S-1-5-32-553"));
	PyModule_AddObject(m, "SID_BUILTIN_PREW2K", PyUnicode_FromString("S-1-5-32-554"));
	PyModule_AddObject(m, "SID_BUILTIN_REMOTE_DESKTOP_USERS", PyUnicode_FromString("S-1-5-32-555"));
	PyModule_AddObject(m, "SID_BUILTIN_NETWORK_CONF_OPERATORS", PyUnicode_FromString("S-1-5-32-556"));
	PyModule_AddObject(m, "SID_BUILTIN_INCOMING_FOREST_TRUST", PyUnicode_FromString("S-1-5-32-557"));
	PyModule_AddObject(m, "SID_BUILTIN_PERFMON_USERS", PyUnicode_FromString("S-1-5-32-558"));
	PyModule_AddObject(m, "SID_BUILTIN_PERFLOG_USERS", PyUnicode_FromString("S-1-5-32-559"));
	PyModule_AddObject(m, "SID_BUILTIN_AUTH_ACCESS", PyUnicode_FromString("S-1-5-32-560"));
	PyModule_AddObject(m, "SID_BUILTIN_TS_LICENSE_SERVERS", PyUnicode_FromString("S-1-5-32-561"));
	PyModule_AddObject(m, "SID_BUILTIN_DISTRIBUTED_COM_USERS", PyUnicode_FromString("S-1-5-32-562"));
	PyModule_AddObject(m, "SID_BUILTIN_IUSERS", PyUnicode_FromString("S-1-5-32-568"));
	PyModule_AddObject(m, "SID_BUILTIN_CRYPTO_OPERATORS", PyUnicode_FromString("S-1-5-32-569"));
	PyModule_AddObject(m, "SID_BUILTIN_EVENT_LOG_READERS", PyUnicode_FromString("S-1-5-32-573"));
	PyModule_AddObject(m, "SID_BUILTIN_CERT_SERV_DCOM_ACCESS", PyUnicode_FromString("S-1-5-32-574"));
	PyModule_AddObject(m, "SID_BUILTIN_RDS_REMOTE_ACCESS_SERVERS", PyUnicode_FromString("S-1-5-32-575"));
	PyModule_AddObject(m, "SID_BUILTIN_RDS_ENDPOINT_SERVERS", PyUnicode_FromString("S-1-5-32-576"));
	PyModule_AddObject(m, "SID_BUILTIN_RDS_MANAGEMENT_SERVERS", PyUnicode_FromString("S-1-5-32-577"));
	PyModule_AddObject(m, "SID_BUILTIN_HYPER_V_ADMINS", PyUnicode_FromString("S-1-5-32-578"));
	PyModule_AddObject(m, "SID_BUILTIN_ACCESS_CONTROL_ASSISTANCE_OPS", PyUnicode_FromString("S-1-5-32-579"));
	PyModule_AddObject(m, "SID_BUILTIN_REMOTE_MANAGEMENT_USERS", PyUnicode_FromString("S-1-5-32-580"));
	PyModule_AddObject(m, "SID_BUILTIN_SYSTEM_MANAGED_ACCOUNTS_GRP", PyUnicode_FromString("S-1-5-32-581"));
	PyModule_AddObject(m, "SID_BUILTIN_STORAGE_REPLICA_ADMINISTRATORS", PyUnicode_FromString("S-1-5-32-582"));
	PyModule_AddObject(m, "SID_SECURITY_RESTRICTED_CODE", PyUnicode_FromString("S-1-5-33"));
	PyModule_AddObject(m, "SID_SAMBA_UNIX_USER_OWNER", PyUnicode_FromString("S-1-22-1"));
	PyModule_AddObject(m, "SID_SAMBA_UNIX_GROUP_OWNER", PyUnicode_FromString("S-1-22-2"));
	PyModule_AddObject(m, "NAME_NT_SERVICE", PyUnicode_FromString("NT SERVICE"));
	PyModule_AddObject(m, "SID_NT_NT_SERVICE", PyUnicode_FromString("S-1-5-80"));
	PyModule_AddObject(m, "SID_NT_TRUSTED_INSTALLER", PyUnicode_FromString("S-1-5-80-956008885-3418522649-1831038044-1853292631-2271478464"));
	PyModule_AddObject(m, "SID_AUTHENTICATION_AUTHORITY_ASSERTED_IDENTITY", PyUnicode_FromString("S-1-18-1"));
	PyModule_AddObject(m, "SID_SERVICE_ASSERTED_IDENTITY", PyUnicode_FromString("S-1-18-2"));
	PyModule_AddObject(m, "SID_COMPOUNDED_AUTHENTICATION", PyUnicode_FromString("S-1-5-21-0-0-0-496"));
	PyModule_AddObject(m, "SID_CLAIMS_VALID", PyUnicode_FromString("S-1-5-21-0-0-0-497"));
	PyModule_AddObject(m, "SID_USER_MODE_DRIVERS", PyUnicode_FromString("S-1-5-84-0-0-0-0-0"));
	PyModule_AddObject(m, "SID_SECURITY_BUILTIN_PACKAGE_ANY_PACKAGE", PyUnicode_FromString("S-1-15-2-1"));
	PyModule_AddObject(m, "SID_SECURITY_MANDATORY_LOW", PyUnicode_FromString("S-1-16-4096"));
	PyModule_AddObject(m, "SID_SECURITY_MANDATORY_MEDIUM", PyUnicode_FromString("S-1-16-8192"));
	PyModule_AddObject(m, "SID_SECURITY_MANDATORY_MEDIUM_PLUS", PyUnicode_FromString("S-1-16-8448"));
	PyModule_AddObject(m, "SID_SECURITY_MANDATORY_HIGH", PyUnicode_FromString("S-1-16-12288"));
	PyModule_AddObject(m, "SID_SECURITY_MANDATORY_SYSTEM", PyUnicode_FromString("S-1-16-16384"));
	PyModule_AddObject(m, "SID_NT_NFS_SUBSYSTEM", PyUnicode_FromString("S-1-5-88"));
	PyModule_AddObject(m, "SID_NT_NFS_USER", PyUnicode_FromString("S-1-5-88-1"));
	PyModule_AddObject(m, "SID_NT_NFS_GROUP", PyUnicode_FromString("S-1-5-88-2"));
	PyModule_AddObject(m, "SID_NT_NFS_MASK", PyUnicode_FromString("S-1-5-88-3"));
	PyModule_AddObject(m, "SID_NT_NFS_OTHERS", PyUnicode_FromString("S-1-5-88-4"));
	PyModule_AddObject(m, "DOMAIN_RID_LOGON", PyLong_FromUnsignedLongLong(9));
	PyModule_AddObject(m, "DOMAIN_RID_ENTERPRISE_READONLY_DCS", PyLong_FromUnsignedLongLong(498));
	PyModule_AddObject(m, "DOMAIN_RID_ADMINISTRATOR", PyLong_FromUnsignedLongLong(500));
	PyModule_AddObject(m, "DOMAIN_RID_GUEST", PyLong_FromUnsignedLongLong(501));
	PyModule_AddObject(m, "DOMAIN_RID_KRBTGT", PyLong_FromUnsignedLongLong(502));
	PyModule_AddObject(m, "DOMAIN_RID_ADMINS", PyLong_FromUnsignedLongLong(512));
	PyModule_AddObject(m, "DOMAIN_RID_USERS", PyLong_FromUnsignedLongLong(513));
	PyModule_AddObject(m, "DOMAIN_RID_GUESTS", PyLong_FromUnsignedLongLong(514));
	PyModule_AddObject(m, "DOMAIN_RID_DOMAIN_MEMBERS", PyLong_FromUnsignedLongLong(515));
	PyModule_AddObject(m, "DOMAIN_RID_DCS", PyLong_FromUnsignedLongLong(516));
	PyModule_AddObject(m, "DOMAIN_RID_CERT_ADMINS", PyLong_FromUnsignedLongLong(517));
	PyModule_AddObject(m, "DOMAIN_RID_SCHEMA_ADMINS", PyLong_FromUnsignedLongLong(518));
	PyModule_AddObject(m, "DOMAIN_RID_ENTERPRISE_ADMINS", PyLong_FromUnsignedLongLong(519));
	PyModule_AddObject(m, "DOMAIN_RID_POLICY_ADMINS", PyLong_FromUnsignedLongLong(520));
	PyModule_AddObject(m, "DOMAIN_RID_READONLY_DCS", PyLong_FromUnsignedLongLong(521));
	PyModule_AddObject(m, "DOMAIN_RID_CLONEABLE_CONTROLLERS", PyLong_FromUnsignedLongLong(522));
	PyModule_AddObject(m, "DOMAIN_RID_PROTECTED_USERS", PyLong_FromUnsignedLongLong(525));
	PyModule_AddObject(m, "DOMAIN_RID_KEY_ADMINS", PyLong_FromUnsignedLongLong(526));
	PyModule_AddObject(m, "DOMAIN_RID_ENTERPRISE_KEY_ADMINS", PyLong_FromUnsignedLongLong(527));
	PyModule_AddObject(m, "DOMAIN_RID_RAS_SERVERS", PyLong_FromUnsignedLongLong(553));
	PyModule_AddObject(m, "DOMAIN_RID_RODC_ALLOW", PyLong_FromUnsignedLongLong(571));
	PyModule_AddObject(m, "DOMAIN_RID_RODC_DENY", PyLong_FromUnsignedLongLong(572));
	PyModule_AddObject(m, "BUILTIN_RID_ADMINISTRATORS", PyLong_FromUnsignedLongLong(544));
	PyModule_AddObject(m, "BUILTIN_RID_USERS", PyLong_FromUnsignedLongLong(545));
	PyModule_AddObject(m, "BUILTIN_RID_GUESTS", PyLong_FromUnsignedLongLong(546));
	PyModule_AddObject(m, "BUILTIN_RID_POWER_USERS", PyLong_FromUnsignedLongLong(547));
	PyModule_AddObject(m, "BUILTIN_RID_ACCOUNT_OPERATORS", PyLong_FromUnsignedLongLong(548));
	PyModule_AddObject(m, "BUILTIN_RID_SERVER_OPERATORS", PyLong_FromUnsignedLongLong(549));
	PyModule_AddObject(m, "BUILTIN_RID_PRINT_OPERATORS", PyLong_FromUnsignedLongLong(550));
	PyModule_AddObject(m, "BUILTIN_RID_BACKUP_OPERATORS", PyLong_FromUnsignedLongLong(551));
	PyModule_AddObject(m, "BUILTIN_RID_REPLICATOR", PyLong_FromUnsignedLongLong(552));
	PyModule_AddObject(m, "BUILTIN_RID_RAS_SERVERS", PyLong_FromUnsignedLongLong(553));
	PyModule_AddObject(m, "BUILTIN_RID_PRE_2K_ACCESS", PyLong_FromUnsignedLongLong(554));
	PyModule_AddObject(m, "BUILTIN_RID_REMOTE_DESKTOP_USERS", PyLong_FromUnsignedLongLong(555));
	PyModule_AddObject(m, "BUILTIN_RID_NETWORK_CONF_OPERATORS", PyLong_FromUnsignedLongLong(556));
	PyModule_AddObject(m, "BUILTIN_RID_INCOMING_FOREST_TRUST", PyLong_FromUnsignedLongLong(557));
	PyModule_AddObject(m, "BUILTIN_RID_PERFMON_USERS", PyLong_FromUnsignedLongLong(558));
	PyModule_AddObject(m, "BUILTIN_RID_PERFLOG_USERS", PyLong_FromUnsignedLongLong(559));
	PyModule_AddObject(m, "BUILTIN_RID_AUTH_ACCESS", PyLong_FromUnsignedLongLong(560));
	PyModule_AddObject(m, "BUILTIN_RID_TS_LICENSE_SERVERS", PyLong_FromUnsignedLongLong(561));
	PyModule_AddObject(m, "BUILTIN_RID_DISTRIBUTED_COM_USERS", PyLong_FromUnsignedLongLong(562));
	PyModule_AddObject(m, "BUILTIN_RID_IUSERS", PyLong_FromUnsignedLongLong(568));
	PyModule_AddObject(m, "BUILTIN_RID_CRYPTO_OPERATORS", PyLong_FromUnsignedLongLong(569));
	PyModule_AddObject(m, "BUILTIN_RID_EVENT_LOG_READERS", PyLong_FromUnsignedLongLong(573));
	PyModule_AddObject(m, "BUILTIN_RID_CERT_SERV_DCOM_ACCESS", PyLong_FromUnsignedLongLong(574));
	PyModule_AddObject(m, "BUILTIN_RID_RDS_REMOTE_ACCESS_SERVERS", PyLong_FromUnsignedLongLong(575));
	PyModule_AddObject(m, "BUILTIN_RID_RDS_ENDPOINT_SERVERS", PyLong_FromUnsignedLongLong(576));
	PyModule_AddObject(m, "BUILTIN_RID_RDS_MANAGEMENT_SERVERS", PyLong_FromUnsignedLongLong(577));
	PyModule_AddObject(m, "BUILTIN_RID_HYPER_V_ADMINS", PyLong_FromUnsignedLongLong(578));
	PyModule_AddObject(m, "BUILTIN_RID_ACCESS_CONTROL_ASSISTANCE_OPS", PyLong_FromUnsignedLongLong(579));
	PyModule_AddObject(m, "BUILTIN_RID_REMOTE_MANAGEMENT_USERS", PyLong_FromUnsignedLongLong(580));
	PyModule_AddObject(m, "NT4_ACL_REVISION", PyLong_FromUnsignedLongLong((uint32_t)(SECURITY_ACL_REVISION_NT4)));
	PyModule_AddObject(m, "SD_REVISION", PyLong_FromLong(SECURITY_DESCRIPTOR_REVISION_1));
	PyModule_AddObject(m, "SE_GROUP_DEFAULT_FLAGS", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_MANDATORY|SE_GROUP_ENABLED_BY_DEFAULT|SE_GROUP_ENABLED)));
	PyModule_AddObject(m, "SMB_SUPPORTED_SECINFO_FLAGS", PyLong_FromLong((SECINFO_OWNER|SECINFO_GROUP|SECINFO_DACL|SECINFO_SACL|SECINFO_LABEL|SECINFO_ATTRIBUTE|SECINFO_SCOPE|SECINFO_BACKUP|0)));
	PyModule_AddObject(m, "GUID_DRS_ALLOCATE_RIDS", PyUnicode_FromString("1abd7cf8-0a99-11d1-adbb-00c04fd8d5cd"));
	PyModule_AddObject(m, "GUID_DRS_CHANGE_DOMAIN_MASTER", PyUnicode_FromString("014bf69c-7b3b-11d1-85f6-08002be74fab"));
	PyModule_AddObject(m, "GUID_DRS_CHANGE_INFR_MASTER", PyUnicode_FromString("cc17b1fb-33d9-11d2-97d4-00c04fd8d5cd"));
	PyModule_AddObject(m, "GUID_DRS_CHANGE_PDC", PyUnicode_FromString("bae50096-4752-11d1-9052-00c04fc2d4cf"));
	PyModule_AddObject(m, "GUID_DRS_CHANGE_RID_MASTER", PyUnicode_FromString("d58d5f36-0a98-11d1-adbb-00c04fd8d5cd"));
	PyModule_AddObject(m, "GUID_DRS_CHANGE_SCHEMA_MASTER", PyUnicode_FromString("e12b56b6-0a95-11d1-adbb-00c04fd8d5cd"));
	PyModule_AddObject(m, "GUID_DRS_GET_CHANGES", PyUnicode_FromString("1131f6aa-9c07-11d1-f79f-00c04fc2dcd2"));
	PyModule_AddObject(m, "GUID_DRS_REPL_SYNCRONIZE", PyUnicode_FromString("1131f6ab-9c07-11d1-f79f-00c04fc2dcd2"));
	PyModule_AddObject(m, "GUID_DRS_MANAGE_TOPOLOGY", PyUnicode_FromString("1131f6ac-9c07-11d1-f79f-00c04fc2dcd2"));
	PyModule_AddObject(m, "GUID_DRS_GET_ALL_CHANGES", PyUnicode_FromString("1131f6ad-9c07-11d1-f79f-00c04fc2dcd2"));
	PyModule_AddObject(m, "GUID_DRS_RO_REPL_SECRET_SYNC", PyUnicode_FromString("1131f6ae-9c07-11d1-f79f-00c04fc2dcd2"));
	PyModule_AddObject(m, "GUID_DRS_GET_FILTERED_ATTRIBUTES", PyUnicode_FromString("89e95b76-444d-4c62-991a-0facbeda640c"));
	PyModule_AddObject(m, "GUID_DRS_MONITOR_TOPOLOGY", PyUnicode_FromString("f98340fb-7c5b-4cdb-a00b-2ebdfa115a96"));
	PyModule_AddObject(m, "GUID_DRS_USER_CHANGE_PASSWORD", PyUnicode_FromString("ab721a53-1e2f-11d0-9819-00aa0040529b"));
	PyModule_AddObject(m, "GUID_DRS_FORCE_CHANGE_PASSWORD", PyUnicode_FromString("00299570-246d-11d0-a768-00aa006e0529"));
	PyModule_AddObject(m, "GUID_DRS_UPDATE_PASSWORD_NOT_REQUIRED_BIT", PyUnicode_FromString("280f369c-67c7-438e-ae98-1d46f3c6f541"));
	PyModule_AddObject(m, "GUID_DRS_UNEXPIRE_PASSWORD", PyUnicode_FromString("ccc2dc7d-a6ad-4a7a-8846-c04e3cc53501"));
	PyModule_AddObject(m, "GUID_DRS_ENABLE_PER_USER_REVERSIBLY_ENCRYPTED_PASSWORD", PyUnicode_FromString("05c74c5e-4deb-43b4-bd9f-86664c2a7fd5"));
	PyModule_AddObject(m, "GUID_DRS_DS_INSTALL_REPLICA", PyUnicode_FromString("9923a32a-3607-11d2-b9be-0000f87a36b2"));
	PyModule_AddObject(m, "GUID_DRS_REANIMATE_TOMBSTONE", PyUnicode_FromString("45ec5156-db7e-47bb-b53f-dbeb2d03c40f"));
	PyModule_AddObject(m, "GUID_DRS_ALLOWED_TO_AUTHENTICATE", PyUnicode_FromString("68b1d179-0d15-4D4F-ab71-46152e79a7bc"));
	PyModule_AddObject(m, "GUID_DRS_VALIDATE_SPN", PyUnicode_FromString("f3a64788-5306-11d1-a9c5-0000f80367c1"));
	PyModule_AddObject(m, "GUID_DRS_SELF_MEMBERSHIP", PyUnicode_FromString("bf9679c0-0de6-11d0-a285-00aa003049e2"));
	PyModule_AddObject(m, "GUID_DRS_DNS_HOST_NAME", PyUnicode_FromString("72e39547-7b18-11d1-adef-00c04fd8d5cd"));
	PyModule_AddObject(m, "GUID_DRS_ADD_DNS_HOST_NAME", PyUnicode_FromString("80863791-dbe9-4eb8-837e-7f0ab55d9ac7"));
	PyModule_AddObject(m, "GUID_DRS_BEHAVIOR_VERSION", PyUnicode_FromString("d31a8757-2447-4545-8081-3bb610cacbf2"));
	PyModule_AddObject(m, "IMPLICIT_OWNER_READ_CONTROL_RIGHTS", PyLong_FromLong((uint16_t)(IMPLICIT_OWNER_READ_CONTROL_RIGHTS)));
	PyModule_AddObject(m, "IMPLICIT_OWNER_READ_CONTROL_AND_WRITE_DAC_RIGHTS", PyLong_FromLong((uint16_t)(IMPLICIT_OWNER_READ_CONTROL_AND_WRITE_DAC_RIGHTS)));
	PyModule_AddObject(m, "SEC_PRIV_INVALID", PyLong_FromLong((uint16_t)(SEC_PRIV_INVALID)));
	PyModule_AddObject(m, "SEC_PRIV_INCREASE_QUOTA", PyLong_FromLong((uint16_t)(SEC_PRIV_INCREASE_QUOTA)));
	PyModule_AddObject(m, "SEC_PRIV_MACHINE_ACCOUNT", PyLong_FromLong((uint16_t)(SEC_PRIV_MACHINE_ACCOUNT)));
	PyModule_AddObject(m, "SEC_PRIV_SECURITY", PyLong_FromLong((uint16_t)(SEC_PRIV_SECURITY)));
	PyModule_AddObject(m, "SEC_PRIV_TAKE_OWNERSHIP", PyLong_FromLong((uint16_t)(SEC_PRIV_TAKE_OWNERSHIP)));
	PyModule_AddObject(m, "SEC_PRIV_LOAD_DRIVER", PyLong_FromLong((uint16_t)(SEC_PRIV_LOAD_DRIVER)));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEM_PROFILE", PyLong_FromLong((uint16_t)(SEC_PRIV_SYSTEM_PROFILE)));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEMTIME", PyLong_FromLong((uint16_t)(SEC_PRIV_SYSTEMTIME)));
	PyModule_AddObject(m, "SEC_PRIV_PROFILE_SINGLE_PROCESS", PyLong_FromLong((uint16_t)(SEC_PRIV_PROFILE_SINGLE_PROCESS)));
	PyModule_AddObject(m, "SEC_PRIV_INCREASE_BASE_PRIORITY", PyLong_FromLong((uint16_t)(SEC_PRIV_INCREASE_BASE_PRIORITY)));
	PyModule_AddObject(m, "SEC_PRIV_CREATE_PAGEFILE", PyLong_FromLong((uint16_t)(SEC_PRIV_CREATE_PAGEFILE)));
	PyModule_AddObject(m, "SEC_PRIV_BACKUP", PyLong_FromLong((uint16_t)(SEC_PRIV_BACKUP)));
	PyModule_AddObject(m, "SEC_PRIV_RESTORE", PyLong_FromLong((uint16_t)(SEC_PRIV_RESTORE)));
	PyModule_AddObject(m, "SEC_PRIV_SHUTDOWN", PyLong_FromLong((uint16_t)(SEC_PRIV_SHUTDOWN)));
	PyModule_AddObject(m, "SEC_PRIV_DEBUG", PyLong_FromLong((uint16_t)(SEC_PRIV_DEBUG)));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEM_ENVIRONMENT", PyLong_FromLong((uint16_t)(SEC_PRIV_SYSTEM_ENVIRONMENT)));
	PyModule_AddObject(m, "SEC_PRIV_CHANGE_NOTIFY", PyLong_FromLong((uint16_t)(SEC_PRIV_CHANGE_NOTIFY)));
	PyModule_AddObject(m, "SEC_PRIV_REMOTE_SHUTDOWN", PyLong_FromLong((uint16_t)(SEC_PRIV_REMOTE_SHUTDOWN)));
	PyModule_AddObject(m, "SEC_PRIV_UNDOCK", PyLong_FromLong((uint16_t)(SEC_PRIV_UNDOCK)));
	PyModule_AddObject(m, "SEC_PRIV_ENABLE_DELEGATION", PyLong_FromLong((uint16_t)(SEC_PRIV_ENABLE_DELEGATION)));
	PyModule_AddObject(m, "SEC_PRIV_MANAGE_VOLUME", PyLong_FromLong((uint16_t)(SEC_PRIV_MANAGE_VOLUME)));
	PyModule_AddObject(m, "SEC_PRIV_IMPERSONATE", PyLong_FromLong((uint16_t)(SEC_PRIV_IMPERSONATE)));
	PyModule_AddObject(m, "SEC_PRIV_CREATE_GLOBAL", PyLong_FromLong((uint16_t)(SEC_PRIV_CREATE_GLOBAL)));
	PyModule_AddObject(m, "SEC_PRIV_PRINT_OPERATOR", PyLong_FromLong((uint16_t)(SEC_PRIV_PRINT_OPERATOR)));
	PyModule_AddObject(m, "SEC_PRIV_ADD_USERS", PyLong_FromLong((uint16_t)(SEC_PRIV_ADD_USERS)));
	PyModule_AddObject(m, "SEC_PRIV_DISK_OPERATOR", PyLong_FromLong((uint16_t)(SEC_PRIV_DISK_OPERATOR)));
	PyModule_AddObject(m, "SEC_PRIV_MACHINE_ACCOUNT_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_MACHINE_ACCOUNT_BIT));
	PyModule_AddObject(m, "SEC_PRIV_PRINT_OPERATOR_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_PRINT_OPERATOR_BIT));
	PyModule_AddObject(m, "SEC_PRIV_ADD_USERS_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_ADD_USERS_BIT));
	PyModule_AddObject(m, "SEC_PRIV_DISK_OPERATOR_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_DISK_OPERATOR_BIT));
	PyModule_AddObject(m, "SEC_PRIV_REMOTE_SHUTDOWN_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_REMOTE_SHUTDOWN_BIT));
	PyModule_AddObject(m, "SEC_PRIV_BACKUP_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_BACKUP_BIT));
	PyModule_AddObject(m, "SEC_PRIV_RESTORE_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_RESTORE_BIT));
	PyModule_AddObject(m, "SEC_PRIV_TAKE_OWNERSHIP_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_TAKE_OWNERSHIP_BIT));
	PyModule_AddObject(m, "SEC_PRIV_INCREASE_QUOTA_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_INCREASE_QUOTA_BIT));
	PyModule_AddObject(m, "SEC_PRIV_SECURITY_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_SECURITY_BIT));
	PyModule_AddObject(m, "SEC_PRIV_LOAD_DRIVER_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_LOAD_DRIVER_BIT));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEM_PROFILE_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_SYSTEM_PROFILE_BIT));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEMTIME_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_SYSTEMTIME_BIT));
	PyModule_AddObject(m, "SEC_PRIV_PROFILE_SINGLE_PROCESS_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_PROFILE_SINGLE_PROCESS_BIT));
	PyModule_AddObject(m, "SEC_PRIV_INCREASE_BASE_PRIORITY_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_INCREASE_BASE_PRIORITY_BIT));
	PyModule_AddObject(m, "SEC_PRIV_CREATE_PAGEFILE_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_CREATE_PAGEFILE_BIT));
	PyModule_AddObject(m, "SEC_PRIV_SHUTDOWN_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_SHUTDOWN_BIT));
	PyModule_AddObject(m, "SEC_PRIV_DEBUG_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_DEBUG_BIT));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEM_ENVIRONMENT_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_SYSTEM_ENVIRONMENT_BIT));
	PyModule_AddObject(m, "SEC_PRIV_CHANGE_NOTIFY_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_CHANGE_NOTIFY_BIT));
	PyModule_AddObject(m, "SEC_PRIV_UNDOCK_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_UNDOCK_BIT));
	PyModule_AddObject(m, "SEC_PRIV_ENABLE_DELEGATION_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_ENABLE_DELEGATION_BIT));
	PyModule_AddObject(m, "SEC_PRIV_MANAGE_VOLUME_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_MANAGE_VOLUME_BIT));
	PyModule_AddObject(m, "SEC_PRIV_IMPERSONATE_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_IMPERSONATE_BIT));
	PyModule_AddObject(m, "SEC_PRIV_CREATE_GLOBAL_BIT", PyLong_FromUnsignedLongLong(SEC_PRIV_CREATE_GLOBAL_BIT));
	PyModule_AddObject(m, "LSA_POLICY_MODE_INTERACTIVE", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_INTERACTIVE)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_NETWORK", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_NETWORK)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_BATCH", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_BATCH)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_SERVICE", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_SERVICE)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_PROXY", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_PROXY)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_DENY_INTERACTIVE", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_DENY_INTERACTIVE)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_DENY_NETWORK", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_DENY_NETWORK)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_DENY_BATCH", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_DENY_BATCH)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_DENY_SERVICE", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_DENY_SERVICE)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_REMOTE_INTERACTIVE", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_REMOTE_INTERACTIVE)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_DENY_REMOTE_INTERACTIVE", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_DENY_REMOTE_INTERACTIVE)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_ALL", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_ALL)));
	PyModule_AddObject(m, "LSA_POLICY_MODE_ALL_NT4", PyLong_FromUnsignedLongLong((uint32_t)(LSA_POLICY_MODE_ALL_NT4)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_OBJECT_INHERIT", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_OBJECT_INHERIT)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_CONTAINER_INHERIT", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_CONTAINER_INHERIT)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_NO_PROPAGATE_INHERIT", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_NO_PROPAGATE_INHERIT)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_INHERIT_ONLY", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_INHERIT_ONLY)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_INHERITED_ACE", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_INHERITED_ACE)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_VALID_INHERIT", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_VALID_INHERIT)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_SUCCESSFUL_ACCESS", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_SUCCESSFUL_ACCESS)));
	PyModule_AddObject(m, "SEC_ACE_FLAG_FAILED_ACCESS", PyLong_FromLong((uint16_t)(SEC_ACE_FLAG_FAILED_ACCESS)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_ALLOWED", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_ALLOWED)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_DENIED", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_DENIED)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_AUDIT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_AUDIT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_ALARM", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_ALARM)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ALLOWED_COMPOUND", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ALLOWED_COMPOUND)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_DENIED_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_DENIED_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_ALLOWED_CALLBACK_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_ACCESS_DENIED_CALLBACK_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_ALARM_CALLBACK", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_ALARM_CALLBACK)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_AUDIT_CALLBACK_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_ALARM_CALLBACK_OBJECT", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_ALARM_CALLBACK_OBJECT)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_MANDATORY_LABEL", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_MANDATORY_LABEL)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_RESOURCE_ATTRIBUTE", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_RESOURCE_ATTRIBUTE)));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_SCOPED_POLICY_ID", PyLong_FromLong((uint16_t)(SEC_ACE_TYPE_SYSTEM_SCOPED_POLICY_ID)));
	PyModule_AddObject(m, "SEC_ACE_OBJECT_TYPE_PRESENT", PyLong_FromUnsignedLongLong((uint32_t)(SEC_ACE_OBJECT_TYPE_PRESENT)));
	PyModule_AddObject(m, "SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT", PyLong_FromUnsignedLongLong((uint32_t)(SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_NON_INHERITABLE", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_NON_INHERITABLE)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_DISABLED", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_DISABLED)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_MANDATORY", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_MANDATORY)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_MANUAL", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_MANUAL)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_POLICY_DERIVED", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_POLICY_DERIVED)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_UNIQUE_AND_SORTED", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_UNIQUE_AND_SORTED)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_RESERVED_FOR_SAMBA", PyLong_FromUnsignedLongLong((uint32_t)(CLAIM_SECURITY_ATTRIBUTE_RESERVED_FOR_SAMBA)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_TYPE_INT64", PyLong_FromLong((uint16_t)(CLAIM_SECURITY_ATTRIBUTE_TYPE_INT64)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_TYPE_UINT64", PyLong_FromLong((uint16_t)(CLAIM_SECURITY_ATTRIBUTE_TYPE_UINT64)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_TYPE_STRING", PyLong_FromLong((uint16_t)(CLAIM_SECURITY_ATTRIBUTE_TYPE_STRING)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_TYPE_SID", PyLong_FromLong((uint16_t)(CLAIM_SECURITY_ATTRIBUTE_TYPE_SID)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_TYPE_BOOLEAN", PyLong_FromLong((uint16_t)(CLAIM_SECURITY_ATTRIBUTE_TYPE_BOOLEAN)));
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING", PyLong_FromLong((uint16_t)(CLAIM_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING)));
	PyModule_AddObject(m, "SECURITY_ACL_REVISION_NT4", PyLong_FromLong((uint16_t)(SECURITY_ACL_REVISION_NT4)));
	PyModule_AddObject(m, "SECURITY_ACL_REVISION_ADS", PyLong_FromLong((uint16_t)(SECURITY_ACL_REVISION_ADS)));
	PyModule_AddObject(m, "SECURITY_DESCRIPTOR_REVISION_1", PyLong_FromLong((uint16_t)(SECURITY_DESCRIPTOR_REVISION_1)));
	PyModule_AddObject(m, "SEC_DESC_OWNER_DEFAULTED", PyLong_FromLong((uint16_t)(SEC_DESC_OWNER_DEFAULTED)));
	PyModule_AddObject(m, "SEC_DESC_GROUP_DEFAULTED", PyLong_FromLong((uint16_t)(SEC_DESC_GROUP_DEFAULTED)));
	PyModule_AddObject(m, "SEC_DESC_DACL_PRESENT", PyLong_FromLong((uint16_t)(SEC_DESC_DACL_PRESENT)));
	PyModule_AddObject(m, "SEC_DESC_DACL_DEFAULTED", PyLong_FromLong((uint16_t)(SEC_DESC_DACL_DEFAULTED)));
	PyModule_AddObject(m, "SEC_DESC_SACL_PRESENT", PyLong_FromLong((uint16_t)(SEC_DESC_SACL_PRESENT)));
	PyModule_AddObject(m, "SEC_DESC_SACL_DEFAULTED", PyLong_FromLong((uint16_t)(SEC_DESC_SACL_DEFAULTED)));
	PyModule_AddObject(m, "SEC_DESC_DACL_TRUSTED", PyLong_FromLong((uint16_t)(SEC_DESC_DACL_TRUSTED)));
	PyModule_AddObject(m, "SEC_DESC_SERVER_SECURITY", PyLong_FromLong((uint16_t)(SEC_DESC_SERVER_SECURITY)));
	PyModule_AddObject(m, "SEC_DESC_DACL_AUTO_INHERIT_REQ", PyLong_FromLong((uint16_t)(SEC_DESC_DACL_AUTO_INHERIT_REQ)));
	PyModule_AddObject(m, "SEC_DESC_SACL_AUTO_INHERIT_REQ", PyLong_FromLong((uint16_t)(SEC_DESC_SACL_AUTO_INHERIT_REQ)));
	PyModule_AddObject(m, "SEC_DESC_DACL_AUTO_INHERITED", PyLong_FromLong((uint16_t)(SEC_DESC_DACL_AUTO_INHERITED)));
	PyModule_AddObject(m, "SEC_DESC_SACL_AUTO_INHERITED", PyLong_FromLong((uint16_t)(SEC_DESC_SACL_AUTO_INHERITED)));
	PyModule_AddObject(m, "SEC_DESC_DACL_PROTECTED", PyLong_FromLong((uint16_t)(SEC_DESC_DACL_PROTECTED)));
	PyModule_AddObject(m, "SEC_DESC_SACL_PROTECTED", PyLong_FromLong((uint16_t)(SEC_DESC_SACL_PROTECTED)));
	PyModule_AddObject(m, "SEC_DESC_RM_CONTROL_VALID", PyLong_FromLong((uint16_t)(SEC_DESC_RM_CONTROL_VALID)));
	PyModule_AddObject(m, "SEC_DESC_SELF_RELATIVE", PyLong_FromLong((uint16_t)(SEC_DESC_SELF_RELATIVE)));
	PyModule_AddObject(m, "SE_GROUP_MANDATORY", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_MANDATORY)));
	PyModule_AddObject(m, "SE_GROUP_ENABLED_BY_DEFAULT", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_ENABLED_BY_DEFAULT)));
	PyModule_AddObject(m, "SE_GROUP_ENABLED", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_ENABLED)));
	PyModule_AddObject(m, "SE_GROUP_OWNER", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_OWNER)));
	PyModule_AddObject(m, "SE_GROUP_USE_FOR_DENY_ONLY", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_USE_FOR_DENY_ONLY)));
	PyModule_AddObject(m, "SE_GROUP_INTEGRITY", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_INTEGRITY)));
	PyModule_AddObject(m, "SE_GROUP_INTEGRITY_ENABLED", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_INTEGRITY_ENABLED)));
	PyModule_AddObject(m, "SE_GROUP_RESOURCE", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_RESOURCE)));
	PyModule_AddObject(m, "SE_GROUP_LOGON_ID", PyLong_FromUnsignedLongLong((uint32_t)(SE_GROUP_LOGON_ID)));
	PyModule_AddObject(m, "CLAIMS_EVALUATION_INVALID_STATE", PyLong_FromLong((uint16_t)(CLAIMS_EVALUATION_INVALID_STATE)));
	PyModule_AddObject(m, "CLAIMS_EVALUATION_NEVER", PyLong_FromLong((uint16_t)(CLAIMS_EVALUATION_NEVER)));
	PyModule_AddObject(m, "CLAIMS_EVALUATION_ALWAYS", PyLong_FromLong((uint16_t)(CLAIMS_EVALUATION_ALWAYS)));
	PyModule_AddObject(m, "SECINFO_OWNER", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_OWNER)));
	PyModule_AddObject(m, "SECINFO_GROUP", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_GROUP)));
	PyModule_AddObject(m, "SECINFO_DACL", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_DACL)));
	PyModule_AddObject(m, "SECINFO_SACL", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_SACL)));
	PyModule_AddObject(m, "SECINFO_LABEL", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_LABEL)));
	PyModule_AddObject(m, "SECINFO_ATTRIBUTE", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_ATTRIBUTE)));
	PyModule_AddObject(m, "SECINFO_SCOPE", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_SCOPE)));
	PyModule_AddObject(m, "SECINFO_BACKUP", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_BACKUP)));
	PyModule_AddObject(m, "SECINFO_UNPROTECTED_SACL", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_UNPROTECTED_SACL)));
	PyModule_AddObject(m, "SECINFO_UNPROTECTED_DACL", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_UNPROTECTED_DACL)));
	PyModule_AddObject(m, "SECINFO_PROTECTED_SACL", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_PROTECTED_SACL)));
	PyModule_AddObject(m, "SECINFO_PROTECTED_DACL", PyLong_FromUnsignedLongLong((uint32_t)(SECINFO_PROTECTED_DACL)));
	PyModule_AddObject(m, "KERB_ENCTYPE_DES_CBC_CRC", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_DES_CBC_CRC)));
	PyModule_AddObject(m, "KERB_ENCTYPE_DES_CBC_MD5", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_DES_CBC_MD5)));
	PyModule_AddObject(m, "KERB_ENCTYPE_RC4_HMAC_MD5", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_RC4_HMAC_MD5)));
	PyModule_AddObject(m, "KERB_ENCTYPE_AES128_CTS_HMAC_SHA1_96", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_AES128_CTS_HMAC_SHA1_96)));
	PyModule_AddObject(m, "KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96)));
	PyModule_AddObject(m, "KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96_SK", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96_SK)));
	PyModule_AddObject(m, "KERB_ENCTYPE_FAST_SUPPORTED", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_FAST_SUPPORTED)));
	PyModule_AddObject(m, "KERB_ENCTYPE_COMPOUND_IDENTITY_SUPPORTED", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_COMPOUND_IDENTITY_SUPPORTED)));
	PyModule_AddObject(m, "KERB_ENCTYPE_CLAIMS_SUPPORTED", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_CLAIMS_SUPPORTED)));
	PyModule_AddObject(m, "KERB_ENCTYPE_RESOURCE_SID_COMPRESSION_DISABLED", PyLong_FromUnsignedLongLong((uint32_t)(KERB_ENCTYPE_RESOURCE_SID_COMPRESSION_DISABLED)));
	PyModule_AddObject(m, "SEC_DACL_AUTO_INHERIT", PyLong_FromUnsignedLongLong((uint32_t)(SEC_DACL_AUTO_INHERIT)));
	PyModule_AddObject(m, "SEC_SACL_AUTO_INHERIT", PyLong_FromUnsignedLongLong((uint32_t)(SEC_SACL_AUTO_INHERIT)));
	PyModule_AddObject(m, "SEC_DEFAULT_DESCRIPTOR", PyLong_FromUnsignedLongLong((uint32_t)(SEC_DEFAULT_DESCRIPTOR)));
	PyModule_AddObject(m, "SEC_OWNER_FROM_PARENT", PyLong_FromUnsignedLongLong((uint32_t)(SEC_OWNER_FROM_PARENT)));
	PyModule_AddObject(m, "SEC_GROUP_FROM_PARENT", PyLong_FromUnsignedLongLong((uint32_t)(SEC_GROUP_FROM_PARENT)));
	Py_INCREF((PyObject *)(void *)&dom_sid_Type);
	PyModule_AddObject(m, "dom_sid", (PyObject *)(void *)&dom_sid_Type);
	Py_INCREF((PyObject *)(void *)&security_ace_object_type_Type);
	PyModule_AddObject(m, "ace_object_type", (PyObject *)(void *)&security_ace_object_type_Type);
	Py_INCREF((PyObject *)(void *)&security_ace_object_inherited_type_Type);
	PyModule_AddObject(m, "ace_object_inherited_type", (PyObject *)(void *)&security_ace_object_inherited_type_Type);
	Py_INCREF((PyObject *)(void *)&security_ace_object_Type);
	PyModule_AddObject(m, "ace_object", (PyObject *)(void *)&security_ace_object_Type);
	Py_INCREF((PyObject *)(void *)&claim_values_Type);
	PyModule_AddObject(m, "claim_values", (PyObject *)(void *)&claim_values_Type);
	Py_INCREF((PyObject *)(void *)&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type);
	PyModule_AddObject(m, "CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1", (PyObject *)(void *)&CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1_Type);
	Py_INCREF((PyObject *)(void *)&security_ace_object_ctr_Type);
	PyModule_AddObject(m, "ace_object_ctr", (PyObject *)(void *)&security_ace_object_ctr_Type);
	Py_INCREF((PyObject *)(void *)&security_ace_coda_Type);
	PyModule_AddObject(m, "ace_coda", (PyObject *)(void *)&security_ace_coda_Type);
	Py_INCREF((PyObject *)(void *)&security_ace_Type);
	PyModule_AddObject(m, "ace", (PyObject *)(void *)&security_ace_Type);
	Py_INCREF((PyObject *)(void *)&security_acl_Type);
	PyModule_AddObject(m, "acl", (PyObject *)(void *)&security_acl_Type);
	Py_INCREF((PyObject *)(void *)&security_descriptor_Type);
	PyModule_AddObject(m, "descriptor", (PyObject *)(void *)&security_descriptor_Type);
	Py_INCREF((PyObject *)(void *)&sec_desc_buf_Type);
	PyModule_AddObject(m, "sec_desc_buf", (PyObject *)(void *)&sec_desc_buf_Type);
	Py_INCREF((PyObject *)(void *)&security_token_Type);
	PyModule_AddObject(m, "token", (PyObject *)(void *)&security_token_Type);
	Py_INCREF((PyObject *)(void *)&security_token_descriptor_fuzzing_pair_Type);
	PyModule_AddObject(m, "token_descriptor_fuzzing_pair", (PyObject *)(void *)&security_token_descriptor_fuzzing_pair_Type);
	Py_INCREF((PyObject *)(void *)&security_unix_token_Type);
	PyModule_AddObject(m, "unix_token", (PyObject *)(void *)&security_unix_token_Type);
	Py_INCREF((PyObject *)(void *)&LSAP_TOKEN_INFO_INTEGRITY_Type);
	PyModule_AddObject(m, "LSAP_TOKEN_INFO_INTEGRITY", (PyObject *)(void *)&LSAP_TOKEN_INFO_INTEGRITY_Type);
	Py_INCREF((PyObject *)(void *)&generic_mapping_Type);
	PyModule_AddObject(m, "generic_mapping", (PyObject *)(void *)&generic_mapping_Type);
	Py_INCREF((PyObject *)(void *)&standard_mapping_Type);
	PyModule_AddObject(m, "standard_mapping", (PyObject *)(void *)&standard_mapping_Type);
	Py_INCREF((PyObject *)(void *)&security_InterfaceType);
	PyModule_AddObject(m, "security", (PyObject *)(void *)&security_InterfaceType);
	Py_INCREF((PyObject *)(void *)&security_SyntaxType);
	PyModule_AddObject(m, "security_abstract_syntax", (PyObject *)(void *)&security_SyntaxType);
	Py_INCREF((PyObject *)(void *)&security_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&security_SyntaxType);
#ifdef PY_MOD_SECURITY_PATCH
	PY_MOD_SECURITY_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
