
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_mdssvc.h"
#include "bin/default/librpc/gen_ndr/ndr_mdssvc_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject mdssvc_blob_Type;
static PyTypeObject mdssvc_InterfaceType;
static PyTypeObject mdssvc_open_Type;
static PyTypeObject mdssvc_unknown1_Type;
static PyTypeObject mdssvc_cmd_Type;
static PyTypeObject mdssvc_close_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_mdssvc_blob_get_length(PyObject *obj, void *closure)
{
	struct mdssvc_blob *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_mdssvc_blob_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_blob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_blob_get_size(PyObject *obj, void *closure)
{
	struct mdssvc_blob *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_mdssvc_blob_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_blob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_blob_get_spotlight_blob(PyObject *obj, void *closure)
{
	struct mdssvc_blob *object = pytalloc_get_ptr(obj);
	PyObject *py_spotlight_blob;
	if (object->spotlight_blob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->spotlight_blob == NULL) {
		py_spotlight_blob = Py_None;
		Py_INCREF(py_spotlight_blob);
	} else {
		py_spotlight_blob = PyList_New(object->length);
		if (py_spotlight_blob == NULL) {
			return NULL;
		}
		{
			int spotlight_blob_cntr_1;
			for (spotlight_blob_cntr_1 = 0; spotlight_blob_cntr_1 < (object->length); spotlight_blob_cntr_1++) {
				PyObject *py_spotlight_blob_1;
				py_spotlight_blob_1 = PyLong_FromLong((uint16_t)((object->spotlight_blob)[spotlight_blob_cntr_1]));
				PyList_SetItem(py_spotlight_blob, spotlight_blob_cntr_1, py_spotlight_blob_1);
			}
		}
	}
	return py_spotlight_blob;
}

static int py_mdssvc_blob_set_spotlight_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_blob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->spotlight_blob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->spotlight_blob");
		return -1;
	}
	if (value == Py_None) {
		object->spotlight_blob = NULL;
	} else {
		object->spotlight_blob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int spotlight_blob_cntr_1;
			object->spotlight_blob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->spotlight_blob, PyList_GET_SIZE(value));
			if (!object->spotlight_blob) { return -1; }
			talloc_set_name_const(object->spotlight_blob, "ARRAY: object->spotlight_blob");
			for (spotlight_blob_cntr_1 = 0; spotlight_blob_cntr_1 < PyList_GET_SIZE(value); spotlight_blob_cntr_1++) {
				if (PyList_GET_ITEM(value, spotlight_blob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->spotlight_blob)[spotlight_blob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->spotlight_blob)[spotlight_blob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, spotlight_blob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, spotlight_blob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->spotlight_blob)[spotlight_blob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_mdssvc_blob_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_mdssvc_blob_get_length,
		.set = py_mdssvc_blob_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_mdssvc_blob_get_size,
		.set = py_mdssvc_blob_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "spotlight_blob"),
		.get = py_mdssvc_blob_get_spotlight_blob,
		.set = py_mdssvc_blob_set_spotlight_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_mdssvc_blob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct mdssvc_blob, type);
}

static PyObject *py_mdssvc_blob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct mdssvc_blob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_mdssvc_blob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_mdssvc_blob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct mdssvc_blob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_mdssvc_blob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_mdssvc_blob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_mdssvc_blob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct mdssvc_blob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_mdssvc_blob, "mdssvc_blob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_mdssvc_blob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_mdssvc_blob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_blob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_mdssvc_blob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mdssvc_blob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mdssvc.blob",
	.tp_getset = py_mdssvc_blob_getsetters,
	.tp_methods = py_mdssvc_blob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mdssvc_blob_new,
};



static PyObject *py_mdssvc_open_in_get_device_id(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_device_id;
	if (object->in.device_id == NULL) {
		Py_RETURN_NONE;
	}
	py_device_id = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.device_id));
	return py_device_id;
}

static int py_mdssvc_open_in_set_device_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.device_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.device_id");
		return -1;
	}
	object->in.device_id = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.device_id);
	if (object->in.device_id == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.device_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_open_out_get_device_id(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_device_id;
	if (object->out.device_id == NULL) {
		Py_RETURN_NONE;
	}
	py_device_id = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.device_id));
	return py_device_id;
}

static int py_mdssvc_open_out_set_device_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.device_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.device_id");
		return -1;
	}
	object->out.device_id = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.device_id);
	if (object->out.device_id == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.device_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_open_in_get_unkn2(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn2;
	if (object->in.unkn2 == NULL) {
		Py_RETURN_NONE;
	}
	py_unkn2 = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.unkn2));
	return py_unkn2;
}

static int py_mdssvc_open_in_set_unkn2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.unkn2));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn2");
		return -1;
	}
	object->in.unkn2 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.unkn2);
	if (object->in.unkn2 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.unkn2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.unkn2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_open_out_get_unkn2(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn2;
	if (object->out.unkn2 == NULL) {
		Py_RETURN_NONE;
	}
	py_unkn2 = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.unkn2));
	return py_unkn2;
}

static int py_mdssvc_open_out_set_unkn2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.unkn2));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.unkn2");
		return -1;
	}
	object->out.unkn2 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.unkn2);
	if (object->out.unkn2 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.unkn2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.unkn2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_open_in_get_unkn3(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn3;
	if (object->in.unkn3 == NULL) {
		Py_RETURN_NONE;
	}
	py_unkn3 = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.unkn3));
	return py_unkn3;
}

static int py_mdssvc_open_in_set_unkn3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.unkn3));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn3");
		return -1;
	}
	object->in.unkn3 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.unkn3);
	if (object->in.unkn3 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.unkn3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_open_out_get_unkn3(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn3;
	if (object->out.unkn3 == NULL) {
		Py_RETURN_NONE;
	}
	py_unkn3 = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.unkn3));
	return py_unkn3;
}

static int py_mdssvc_open_out_set_unkn3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.unkn3));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.unkn3");
		return -1;
	}
	object->out.unkn3 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.unkn3);
	if (object->out.unkn3 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.unkn3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_open_in_get_share_mount_path(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_share_mount_path;
	if (object->in.share_mount_path == NULL) {
		py_share_mount_path = Py_None;
		Py_INCREF(py_share_mount_path);
	} else {
		py_share_mount_path = PyUnicode_Decode(object->in.share_mount_path, strlen(object->in.share_mount_path), "utf-8", "ignore");
	}
	return py_share_mount_path;
}

static int py_mdssvc_open_in_set_share_mount_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.share_mount_path");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.share_mount_path = talloc_str;
	}
	return 0;
}

static PyObject *py_mdssvc_open_in_get_share_name(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_share_name;
	if (object->in.share_name == NULL) {
		py_share_name = Py_None;
		Py_INCREF(py_share_name);
	} else {
		py_share_name = PyUnicode_Decode(object->in.share_name, strlen(object->in.share_name), "utf-8", "ignore");
	}
	return py_share_name;
}

static int py_mdssvc_open_in_set_share_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.share_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.share_name = talloc_str;
	}
	return 0;
}

static PyObject *py_mdssvc_open_out_get_share_path(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_share_path;
	if (object->out.share_path == NULL) {
		py_share_path = Py_None;
		Py_INCREF(py_share_path);
	} else {
		py_share_path = PyUnicode_Decode(object->out.share_path, strlen(object->out.share_path), "utf-8", "ignore");
	}
	return py_share_path;
}

static int py_mdssvc_open_out_set_share_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.share_path");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->out.share_path = talloc_str;
	}
	return 0;
}

static PyObject *py_mdssvc_open_out_get_handle(PyObject *obj, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_mdssvc_open_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_mdssvc_open_getsetters[] = {
	{
		.name = discard_const_p(char, "in_device_id"),
		.get = py_mdssvc_open_in_get_device_id,
		.set = py_mdssvc_open_in_set_device_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_device_id"),
		.get = py_mdssvc_open_out_get_device_id,
		.set = py_mdssvc_open_out_set_device_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn2"),
		.get = py_mdssvc_open_in_get_unkn2,
		.set = py_mdssvc_open_in_set_unkn2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_unkn2"),
		.get = py_mdssvc_open_out_get_unkn2,
		.set = py_mdssvc_open_out_set_unkn2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn3"),
		.get = py_mdssvc_open_in_get_unkn3,
		.set = py_mdssvc_open_in_set_unkn3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_unkn3"),
		.get = py_mdssvc_open_out_get_unkn3,
		.set = py_mdssvc_open_out_set_unkn3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_share_mount_path"),
		.get = py_mdssvc_open_in_get_share_mount_path,
		.set = py_mdssvc_open_in_set_share_mount_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_share_name"),
		.get = py_mdssvc_open_in_get_share_name,
		.set = py_mdssvc_open_in_set_share_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_share_path"),
		.get = py_mdssvc_open_out_get_share_path,
		.set = py_mdssvc_open_out_set_share_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_mdssvc_open_out_get_handle,
		.set = py_mdssvc_open_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{ .name = NULL }
};

static PyObject *py_mdssvc_open_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mdssvc_open, type);
	struct mdssvc_open *_self = (struct mdssvc_open *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.device_id = talloc_zero(mem_ctx, uint32_t);
	_self->out.device_id = talloc_zero(mem_ctx, uint32_t);
	_self->in.unkn2 = talloc_zero(mem_ctx, uint32_t);
	_self->out.unkn2 = talloc_zero(mem_ctx, uint32_t);
	_self->in.unkn3 = talloc_zero(mem_ctx, uint32_t);
	_self->out.unkn3 = talloc_zero(mem_ctx, uint32_t);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_mdssvc_open_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_mdssvc_open_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_open_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mdssvc_open_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_open_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mdssvc_open_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_open_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mdssvc_open_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_open_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mdssvc_open_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_open_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_open_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_open_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_open_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_open *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_mdssvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_open_ndr_print");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mdssvc_open_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_open_ndr_print(py_obj, "mdssvc_open_in", NDR_IN);
}

static PyObject *py_mdssvc_open_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_open_ndr_print(py_obj, "mdssvc_open_out", NDR_OUT);
}

static PyMethodDef py_mdssvc_open_methods[] = {
	{ "opnum", (PyCFunction)py_mdssvc_open_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mdssvc.open.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_open_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_open_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_open_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_open_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_mdssvc_open_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_mdssvc_open_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mdssvc_open_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mdssvc.open",
	.tp_getset = py_mdssvc_open_getsetters,
	.tp_methods = py_mdssvc_open_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mdssvc_open_new,
};

static bool pack_py_mdssvc_open_args_in(PyObject *args, PyObject *kwargs, struct mdssvc_open *r)
{
	PyObject *py_device_id;
	PyObject *py_unkn2;
	PyObject *py_unkn3;
	PyObject *py_share_mount_path;
	PyObject *py_share_name;
	const char *kwnames[] = {
		"device_id", "unkn2", "unkn3", "share_mount_path", "share_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:mdssvc_open", discard_const_p(char *, kwnames), &py_device_id, &py_unkn2, &py_unkn3, &py_share_mount_path, &py_share_name)) {
		return false;
	}

	if (py_device_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.device_id");
		return false;
	}
	r->in.device_id = talloc_ptrtype(r, r->in.device_id);
	if (r->in.device_id == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.device_id));
		if (PyLong_Check(py_device_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_device_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn2");
		return false;
	}
	r->in.unkn2 = talloc_ptrtype(r, r->in.unkn2);
	if (r->in.unkn2 == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.unkn2));
		if (PyLong_Check(py_unkn2)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn2);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.unkn2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn3 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn3");
		return false;
	}
	r->in.unkn3 = talloc_ptrtype(r, r->in.unkn3);
	if (r->in.unkn3 == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.unkn3));
		if (PyLong_Check(py_unkn3)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn3);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_share_mount_path == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.share_mount_path");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_share_mount_path)) {
			unicode = PyUnicode_AsEncodedString(py_share_mount_path, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_share_mount_path)) {
			test_str = PyBytes_AS_STRING(py_share_mount_path);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_share_mount_path)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.share_mount_path = talloc_str;
	}
	if (py_share_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.share_name");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_share_name)) {
			unicode = PyUnicode_AsEncodedString(py_share_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_share_name)) {
			test_str = PyBytes_AS_STRING(py_share_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_share_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.share_name = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_mdssvc_open_args_out(struct mdssvc_open *r)
{
	PyObject *result;
	PyObject *py_device_id;
	PyObject *py_unkn2;
	PyObject *py_unkn3;
	PyObject *py_share_path;
	PyObject *py_handle;
	result = PyTuple_New(5);
	py_device_id = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.device_id));
	PyTuple_SetItem(result, 0, py_device_id);
	py_unkn2 = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.unkn2));
	PyTuple_SetItem(result, 1, py_unkn2);
	py_unkn3 = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.unkn3));
	PyTuple_SetItem(result, 2, py_unkn3);
	if (r->out.share_path == NULL) {
		py_share_path = Py_None;
		Py_INCREF(py_share_path);
	} else {
		py_share_path = PyUnicode_Decode(r->out.share_path, strlen(r->out.share_path), "utf-8", "ignore");
	}
	PyTuple_SetItem(result, 3, py_share_path);
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	PyTuple_SetItem(result, 4, py_handle);
	return result;
}


static PyObject *py_mdssvc_unknown1_in_get_handle(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_mdssvc_unknown1_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_mdssvc_unknown1_in_get_unkn1(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn1;
	py_unkn1 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn1));
	return py_unkn1;
}

static int py_mdssvc_unknown1_in_set_unkn1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_in_get_device_id(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_device_id;
	py_device_id = PyLong_FromUnsignedLongLong((uint32_t)(object->in.device_id));
	return py_device_id;
}

static int py_mdssvc_unknown1_in_set_device_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.device_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.device_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_in_get_unkn3(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn3;
	py_unkn3 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn3));
	return py_unkn3;
}

static int py_mdssvc_unknown1_in_set_unkn3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_in_get_unkn4(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn4;
	py_unkn4 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn4));
	return py_unkn4;
}

static int py_mdssvc_unknown1_in_set_unkn4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_in_get_uid(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	py_uid = PyLong_FromUnsignedLongLong((uint32_t)(object->in.uid));
	return py_uid;
}

static int py_mdssvc_unknown1_in_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.uid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_in_get_gid(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_gid;
	py_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->in.gid));
	return py_gid;
}

static int py_mdssvc_unknown1_in_set_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_out_get_status(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	if (object->out.status == NULL) {
		Py_RETURN_NONE;
	}
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.status));
	return py_status;
}

static int py_mdssvc_unknown1_out_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.status");
		return -1;
	}
	object->out.status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.status);
	if (object->out.status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_out_get_flags(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	if (object->out.flags == NULL) {
		Py_RETURN_NONE;
	}
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.flags));
	return py_flags;
}

static int py_mdssvc_unknown1_out_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.flags));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.flags");
		return -1;
	}
	object->out.flags = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.flags);
	if (object->out.flags == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_unknown1_out_get_unkn7(PyObject *obj, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn7;
	if (object->out.unkn7 == NULL) {
		Py_RETURN_NONE;
	}
	py_unkn7 = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.unkn7));
	return py_unkn7;
}

static int py_mdssvc_unknown1_out_set_unkn7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.unkn7));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.unkn7");
		return -1;
	}
	object->out.unkn7 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.unkn7);
	if (object->out.unkn7 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.unkn7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.unkn7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_mdssvc_unknown1_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_mdssvc_unknown1_in_get_handle,
		.set = py_mdssvc_unknown1_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_unkn1"),
		.get = py_mdssvc_unknown1_in_get_unkn1,
		.set = py_mdssvc_unknown1_in_set_unkn1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_device_id"),
		.get = py_mdssvc_unknown1_in_get_device_id,
		.set = py_mdssvc_unknown1_in_set_device_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn3"),
		.get = py_mdssvc_unknown1_in_get_unkn3,
		.set = py_mdssvc_unknown1_in_set_unkn3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn4"),
		.get = py_mdssvc_unknown1_in_get_unkn4,
		.set = py_mdssvc_unknown1_in_set_unkn4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_uid"),
		.get = py_mdssvc_unknown1_in_get_uid,
		.set = py_mdssvc_unknown1_in_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_gid"),
		.get = py_mdssvc_unknown1_in_get_gid,
		.set = py_mdssvc_unknown1_in_set_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_status"),
		.get = py_mdssvc_unknown1_out_get_status,
		.set = py_mdssvc_unknown1_out_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_flags"),
		.get = py_mdssvc_unknown1_out_get_flags,
		.set = py_mdssvc_unknown1_out_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_unkn7"),
		.get = py_mdssvc_unknown1_out_get_unkn7,
		.set = py_mdssvc_unknown1_out_set_unkn7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_mdssvc_unknown1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mdssvc_unknown1, type);
	struct mdssvc_unknown1 *_self = (struct mdssvc_unknown1 *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.status = talloc_zero(mem_ctx, uint32_t);
	_self->out.flags = talloc_zero(mem_ctx, uint32_t);
	_self->out.unkn7 = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_mdssvc_unknown1_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_mdssvc_unknown1_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_unknown1_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mdssvc_unknown1_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_unknown1_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mdssvc_unknown1_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_unknown1_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mdssvc_unknown1_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_unknown1_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mdssvc_unknown1_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_unknown1_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_unknown1_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_unknown1_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_unknown1_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_unknown1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_mdssvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_unknown1_ndr_print");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[1];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mdssvc_unknown1_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_unknown1_ndr_print(py_obj, "mdssvc_unknown1_in", NDR_IN);
}

static PyObject *py_mdssvc_unknown1_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_unknown1_ndr_print(py_obj, "mdssvc_unknown1_out", NDR_OUT);
}

static PyMethodDef py_mdssvc_unknown1_methods[] = {
	{ "opnum", (PyCFunction)py_mdssvc_unknown1_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mdssvc.unknown1.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_unknown1_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_unknown1_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_unknown1_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_unknown1_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_mdssvc_unknown1_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_mdssvc_unknown1_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mdssvc_unknown1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mdssvc.unknown1",
	.tp_getset = py_mdssvc_unknown1_getsetters,
	.tp_methods = py_mdssvc_unknown1_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mdssvc_unknown1_new,
};

static bool pack_py_mdssvc_unknown1_args_in(PyObject *args, PyObject *kwargs, struct mdssvc_unknown1 *r)
{
	PyObject *py_handle;
	PyObject *py_unkn1;
	PyObject *py_device_id;
	PyObject *py_unkn3;
	PyObject *py_unkn4;
	PyObject *py_uid;
	PyObject *py_gid;
	const char *kwnames[] = {
		"handle", "unkn1", "device_id", "unkn3", "unkn4", "uid", "gid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:mdssvc_unknown1", discard_const_p(char *, kwnames), &py_handle, &py_unkn1, &py_device_id, &py_unkn3, &py_unkn4, &py_uid, &py_gid)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_unkn1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn1");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn1));
		if (PyLong_Check(py_unkn1)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn1);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_device_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.device_id");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.device_id));
		if (PyLong_Check(py_device_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_device_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn3 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn3");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn3));
		if (PyLong_Check(py_unkn3)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn3);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn4 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn4");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn4));
		if (PyLong_Check(py_unkn4)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn4);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_uid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.uid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.uid));
		if (PyLong_Check(py_uid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_uid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_gid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.gid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.gid));
		if (PyLong_Check(py_gid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_gid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_mdssvc_unknown1_args_out(struct mdssvc_unknown1 *r)
{
	PyObject *result;
	PyObject *py_status;
	PyObject *py_flags;
	PyObject *py_unkn7;
	result = PyTuple_New(3);
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.status));
	PyTuple_SetItem(result, 0, py_status);
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.flags));
	PyTuple_SetItem(result, 1, py_flags);
	py_unkn7 = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.unkn7));
	PyTuple_SetItem(result, 2, py_unkn7);
	return result;
}


static PyObject *py_mdssvc_cmd_in_get_handle(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_mdssvc_cmd_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_unkn1(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn1;
	py_unkn1 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn1));
	return py_unkn1;
}

static int py_mdssvc_cmd_in_set_unkn1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_device_id(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_device_id;
	py_device_id = PyLong_FromUnsignedLongLong((uint32_t)(object->in.device_id));
	return py_device_id;
}

static int py_mdssvc_cmd_in_set_device_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.device_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.device_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_unkn3(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn3;
	py_unkn3 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn3));
	return py_unkn3;
}

static int py_mdssvc_cmd_in_set_unkn3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_next_fragment(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_next_fragment;
	py_next_fragment = PyLong_FromUnsignedLongLong((uint32_t)(object->in.next_fragment));
	return py_next_fragment;
}

static int py_mdssvc_cmd_in_set_next_fragment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.next_fragment");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.next_fragment));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.next_fragment = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_flags(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_mdssvc_cmd_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_request_blob(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_request_blob;
	py_request_blob = pytalloc_reference_ex(&mdssvc_blob_Type, pytalloc_get_mem_ctx(obj), &object->in.request_blob);
	return py_request_blob;
}

static int py_mdssvc_cmd_in_set_request_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.request_blob");
		return -1;
	}
	PY_CHECK_TYPE(&mdssvc_blob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.request_blob = *(struct mdssvc_blob *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_unkn5(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn5;
	py_unkn5 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn5));
	return py_unkn5;
}

static int py_mdssvc_cmd_in_set_unkn5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_max_fragment_size1(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_max_fragment_size1;
	py_max_fragment_size1 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_fragment_size1));
	return py_max_fragment_size1;
}

static int py_mdssvc_cmd_in_set_max_fragment_size1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.max_fragment_size1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_fragment_size1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_fragment_size1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_unkn6(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn6;
	py_unkn6 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn6));
	return py_unkn6;
}

static int py_mdssvc_cmd_in_set_unkn6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_max_fragment_size2(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_max_fragment_size2;
	py_max_fragment_size2 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_fragment_size2));
	return py_max_fragment_size2;
}

static int py_mdssvc_cmd_in_set_max_fragment_size2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.max_fragment_size2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_fragment_size2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_fragment_size2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_unkn7(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn7;
	py_unkn7 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn7));
	return py_unkn7;
}

static int py_mdssvc_cmd_in_set_unkn7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_in_get_unkn8(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn8;
	py_unkn8 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn8));
	return py_unkn8;
}

static int py_mdssvc_cmd_in_set_unkn8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_out_get_fragment(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_fragment;
	if (object->out.fragment == NULL) {
		Py_RETURN_NONE;
	}
	py_fragment = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.fragment));
	return py_fragment;
}

static int py_mdssvc_cmd_out_set_fragment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.fragment));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.fragment");
		return -1;
	}
	object->out.fragment = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.fragment);
	if (object->out.fragment == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.fragment));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.fragment = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_cmd_out_get_response_blob(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_response_blob;
	if (object->out.response_blob == NULL) {
		Py_RETURN_NONE;
	}
	py_response_blob = pytalloc_reference_ex(&mdssvc_blob_Type, object->out.response_blob, object->out.response_blob);
	return py_response_blob;
}

static int py_mdssvc_cmd_out_set_response_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.response_blob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.response_blob");
		return -1;
	}
	object->out.response_blob = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.response_blob);
	if (object->out.response_blob == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&mdssvc_blob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.response_blob = (struct mdssvc_blob *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_mdssvc_cmd_out_get_unkn9(PyObject *obj, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn9;
	if (object->out.unkn9 == NULL) {
		Py_RETURN_NONE;
	}
	py_unkn9 = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.unkn9));
	return py_unkn9;
}

static int py_mdssvc_cmd_out_set_unkn9(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.unkn9));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.unkn9");
		return -1;
	}
	object->out.unkn9 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.unkn9);
	if (object->out.unkn9 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.unkn9));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.unkn9 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_mdssvc_cmd_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_mdssvc_cmd_in_get_handle,
		.set = py_mdssvc_cmd_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_unkn1"),
		.get = py_mdssvc_cmd_in_get_unkn1,
		.set = py_mdssvc_cmd_in_set_unkn1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_device_id"),
		.get = py_mdssvc_cmd_in_get_device_id,
		.set = py_mdssvc_cmd_in_set_device_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn3"),
		.get = py_mdssvc_cmd_in_get_unkn3,
		.set = py_mdssvc_cmd_in_set_unkn3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_next_fragment"),
		.get = py_mdssvc_cmd_in_get_next_fragment,
		.set = py_mdssvc_cmd_in_set_next_fragment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_mdssvc_cmd_in_get_flags,
		.set = py_mdssvc_cmd_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_request_blob"),
		.get = py_mdssvc_cmd_in_get_request_blob,
		.set = py_mdssvc_cmd_in_set_request_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type mdssvc_blob")
	},
	{
		.name = discard_const_p(char, "in_unkn5"),
		.get = py_mdssvc_cmd_in_get_unkn5,
		.set = py_mdssvc_cmd_in_set_unkn5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_max_fragment_size1"),
		.get = py_mdssvc_cmd_in_get_max_fragment_size1,
		.set = py_mdssvc_cmd_in_set_max_fragment_size1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn6"),
		.get = py_mdssvc_cmd_in_get_unkn6,
		.set = py_mdssvc_cmd_in_set_unkn6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_max_fragment_size2"),
		.get = py_mdssvc_cmd_in_get_max_fragment_size2,
		.set = py_mdssvc_cmd_in_set_max_fragment_size2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn7"),
		.get = py_mdssvc_cmd_in_get_unkn7,
		.set = py_mdssvc_cmd_in_set_unkn7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn8"),
		.get = py_mdssvc_cmd_in_get_unkn8,
		.set = py_mdssvc_cmd_in_set_unkn8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_fragment"),
		.get = py_mdssvc_cmd_out_get_fragment,
		.set = py_mdssvc_cmd_out_set_fragment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_response_blob"),
		.get = py_mdssvc_cmd_out_get_response_blob,
		.set = py_mdssvc_cmd_out_set_response_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type mdssvc_blob")
	},
	{
		.name = discard_const_p(char, "out_unkn9"),
		.get = py_mdssvc_cmd_out_get_unkn9,
		.set = py_mdssvc_cmd_out_set_unkn9,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_mdssvc_cmd_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mdssvc_cmd, type);
	struct mdssvc_cmd *_self = (struct mdssvc_cmd *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.fragment = talloc_zero(mem_ctx, uint32_t);
	_self->out.response_blob = talloc_zero(mem_ctx, struct mdssvc_blob);
	_self->out.unkn9 = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_mdssvc_cmd_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_mdssvc_cmd_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_cmd_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mdssvc_cmd_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_cmd_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mdssvc_cmd_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_cmd_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mdssvc_cmd_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_cmd_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mdssvc_cmd_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_cmd_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_cmd_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_cmd_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_cmd_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_cmd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_mdssvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_cmd_ndr_print");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[2];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mdssvc_cmd_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_cmd_ndr_print(py_obj, "mdssvc_cmd_in", NDR_IN);
}

static PyObject *py_mdssvc_cmd_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_cmd_ndr_print(py_obj, "mdssvc_cmd_out", NDR_OUT);
}

static PyMethodDef py_mdssvc_cmd_methods[] = {
	{ "opnum", (PyCFunction)py_mdssvc_cmd_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mdssvc.cmd.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_cmd_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_cmd_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_cmd_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_cmd_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_mdssvc_cmd_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_mdssvc_cmd_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mdssvc_cmd_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mdssvc.cmd",
	.tp_getset = py_mdssvc_cmd_getsetters,
	.tp_methods = py_mdssvc_cmd_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mdssvc_cmd_new,
};

static bool pack_py_mdssvc_cmd_args_in(PyObject *args, PyObject *kwargs, struct mdssvc_cmd *r)
{
	PyObject *py_handle;
	PyObject *py_unkn1;
	PyObject *py_device_id;
	PyObject *py_unkn3;
	PyObject *py_next_fragment;
	PyObject *py_flags;
	PyObject *py_request_blob;
	PyObject *py_unkn5;
	PyObject *py_max_fragment_size1;
	PyObject *py_unkn6;
	PyObject *py_max_fragment_size2;
	PyObject *py_unkn7;
	PyObject *py_unkn8;
	const char *kwnames[] = {
		"handle", "unkn1", "device_id", "unkn3", "next_fragment", "flags", "request_blob", "unkn5", "max_fragment_size1", "unkn6", "max_fragment_size2", "unkn7", "unkn8", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOOO:mdssvc_cmd", discard_const_p(char *, kwnames), &py_handle, &py_unkn1, &py_device_id, &py_unkn3, &py_next_fragment, &py_flags, &py_request_blob, &py_unkn5, &py_max_fragment_size1, &py_unkn6, &py_max_fragment_size2, &py_unkn7, &py_unkn8)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_unkn1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn1");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn1));
		if (PyLong_Check(py_unkn1)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn1);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_device_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.device_id");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.device_id));
		if (PyLong_Check(py_device_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_device_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn3 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn3");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn3));
		if (PyLong_Check(py_unkn3)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn3);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_next_fragment == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.next_fragment");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.next_fragment));
		if (PyLong_Check(py_next_fragment)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_next_fragment);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.next_fragment = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_request_blob == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.request_blob");
		return false;
	}
	PY_CHECK_TYPE(&mdssvc_blob_Type, py_request_blob, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_request_blob)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.request_blob = *(struct mdssvc_blob *)pytalloc_get_ptr(py_request_blob);
	if (py_unkn5 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn5");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn5));
		if (PyLong_Check(py_unkn5)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn5);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_fragment_size1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.max_fragment_size1");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_fragment_size1));
		if (PyLong_Check(py_max_fragment_size1)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_fragment_size1);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_fragment_size1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn6 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn6");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn6));
		if (PyLong_Check(py_unkn6)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn6);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_fragment_size2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.max_fragment_size2");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_fragment_size2));
		if (PyLong_Check(py_max_fragment_size2)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_fragment_size2);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_fragment_size2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn7 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn7");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn7));
		if (PyLong_Check(py_unkn7)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn7);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn8 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn8");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn8));
		if (PyLong_Check(py_unkn8)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn8);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_mdssvc_cmd_args_out(struct mdssvc_cmd *r)
{
	PyObject *result;
	PyObject *py_fragment;
	PyObject *py_response_blob;
	PyObject *py_unkn9;
	result = PyTuple_New(3);
	py_fragment = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.fragment));
	PyTuple_SetItem(result, 0, py_fragment);
	py_response_blob = pytalloc_reference_ex(&mdssvc_blob_Type, r->out.response_blob, r->out.response_blob);
	PyTuple_SetItem(result, 1, py_response_blob);
	py_unkn9 = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.unkn9));
	PyTuple_SetItem(result, 2, py_unkn9);
	return result;
}


static PyObject *py_mdssvc_close_in_get_in_handle(PyObject *obj, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(obj);
	PyObject *py_in_handle;
	if (object->in.in_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_in_handle = pytalloc_reference_ex(policy_handle_Type, object->in.in_handle, object->in.in_handle);
	return py_in_handle;
}

static int py_mdssvc_close_in_set_in_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.in_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.in_handle");
		return -1;
	}
	object->in.in_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.in_handle);
	if (object->in.in_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.in_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_mdssvc_close_in_get_unkn1(PyObject *obj, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn1;
	py_unkn1 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn1));
	return py_unkn1;
}

static int py_mdssvc_close_in_set_unkn1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_close_in_get_device_id(PyObject *obj, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(obj);
	PyObject *py_device_id;
	py_device_id = PyLong_FromUnsignedLongLong((uint32_t)(object->in.device_id));
	return py_device_id;
}

static int py_mdssvc_close_in_set_device_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.device_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.device_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_close_in_get_unkn2(PyObject *obj, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn2;
	py_unkn2 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn2));
	return py_unkn2;
}

static int py_mdssvc_close_in_set_unkn2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_close_in_get_unkn3(PyObject *obj, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(obj);
	PyObject *py_unkn3;
	py_unkn3 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unkn3));
	return py_unkn3;
}

static int py_mdssvc_close_in_set_unkn3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.unkn3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unkn3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mdssvc_close_out_get_out_handle(PyObject *obj, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(obj);
	PyObject *py_out_handle;
	if (object->out.out_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_out_handle = pytalloc_reference_ex(policy_handle_Type, object->out.out_handle, object->out.out_handle);
	return py_out_handle;
}

static int py_mdssvc_close_out_set_out_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.out_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.out_handle");
		return -1;
	}
	object->out.out_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.out_handle);
	if (object->out.out_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.out_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_mdssvc_close_out_get_status(PyObject *obj, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	if (object->out.status == NULL) {
		Py_RETURN_NONE;
	}
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.status));
	return py_status;
}

static int py_mdssvc_close_out_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.status");
		return -1;
	}
	object->out.status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.status);
	if (object->out.status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_mdssvc_close_getsetters[] = {
	{
		.name = discard_const_p(char, "in_in_handle"),
		.get = py_mdssvc_close_in_get_in_handle,
		.set = py_mdssvc_close_in_set_in_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_unkn1"),
		.get = py_mdssvc_close_in_get_unkn1,
		.set = py_mdssvc_close_in_set_unkn1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_device_id"),
		.get = py_mdssvc_close_in_get_device_id,
		.set = py_mdssvc_close_in_set_device_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn2"),
		.get = py_mdssvc_close_in_get_unkn2,
		.set = py_mdssvc_close_in_set_unkn2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unkn3"),
		.get = py_mdssvc_close_in_get_unkn3,
		.set = py_mdssvc_close_in_set_unkn3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_out_handle"),
		.get = py_mdssvc_close_out_get_out_handle,
		.set = py_mdssvc_close_out_set_out_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_status"),
		.get = py_mdssvc_close_out_get_status,
		.set = py_mdssvc_close_out_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_mdssvc_close_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mdssvc_close, type);
	struct mdssvc_close *_self = (struct mdssvc_close *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.in_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.out_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.status = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_mdssvc_close_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_mdssvc_close_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_close_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mdssvc_close_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_close_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mdssvc_close_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mdssvc_close_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mdssvc_close_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mdssvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_close_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mdssvc_close_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_close_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_close_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mdssvc_close_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mdssvc_close_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mdssvc_close *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_mdssvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mdssvc_close_ndr_print");
		return NULL;
	}
	call = &ndr_table_mdssvc.calls[3];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mdssvc_close_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_close_ndr_print(py_obj, "mdssvc_close_in", NDR_IN);
}

static PyObject *py_mdssvc_close_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_mdssvc_close_ndr_print(py_obj, "mdssvc_close_out", NDR_OUT);
}

static PyMethodDef py_mdssvc_close_methods[] = {
	{ "opnum", (PyCFunction)py_mdssvc_close_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mdssvc.close.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_close_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_close_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_close_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mdssvc_close_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_mdssvc_close_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_mdssvc_close_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mdssvc_close_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mdssvc.close",
	.tp_getset = py_mdssvc_close_getsetters,
	.tp_methods = py_mdssvc_close_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mdssvc_close_new,
};

static bool pack_py_mdssvc_close_args_in(PyObject *args, PyObject *kwargs, struct mdssvc_close *r)
{
	PyObject *py_in_handle;
	PyObject *py_unkn1;
	PyObject *py_device_id;
	PyObject *py_unkn2;
	PyObject *py_unkn3;
	const char *kwnames[] = {
		"in_handle", "unkn1", "device_id", "unkn2", "unkn3", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:mdssvc_close", discard_const_p(char *, kwnames), &py_in_handle, &py_unkn1, &py_device_id, &py_unkn2, &py_unkn3)) {
		return false;
	}

	if (py_in_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.in_handle");
		return false;
	}
	r->in.in_handle = talloc_ptrtype(r, r->in.in_handle);
	if (r->in.in_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_in_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_in_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.in_handle = (struct policy_handle *)pytalloc_get_ptr(py_in_handle);
	if (py_unkn1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn1");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn1));
		if (PyLong_Check(py_unkn1)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn1);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_device_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.device_id");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.device_id));
		if (PyLong_Check(py_device_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_device_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.device_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn2");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn2));
		if (PyLong_Check(py_unkn2)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn2);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unkn3 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.unkn3");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unkn3));
		if (PyLong_Check(py_unkn3)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unkn3);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unkn3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_mdssvc_close_args_out(struct mdssvc_close *r)
{
	PyObject *result;
	PyObject *py_out_handle;
	PyObject *py_status;
	result = PyTuple_New(2);
	py_out_handle = pytalloc_reference_ex(policy_handle_Type, r->out.out_handle, r->out.out_handle);
	PyTuple_SetItem(result, 0, py_out_handle);
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.status));
	PyTuple_SetItem(result, 1, py_status);
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_mdssvc_methods[] = {
	{ "open", "S.open(device_id, unkn2, unkn3, share_mount_path, share_name) -> (device_id, unkn2, unkn3, share_path, handle)", (py_dcerpc_call_fn)dcerpc_mdssvc_open_r, (py_data_pack_fn)pack_py_mdssvc_open_args_in, (py_data_unpack_fn)unpack_py_mdssvc_open_args_out, 0, &ndr_table_mdssvc },
	{ "unknown1", "S.unknown1(handle, unkn1, device_id, unkn3, unkn4, uid, gid) -> (status, flags, unkn7)", (py_dcerpc_call_fn)dcerpc_mdssvc_unknown1_r, (py_data_pack_fn)pack_py_mdssvc_unknown1_args_in, (py_data_unpack_fn)unpack_py_mdssvc_unknown1_args_out, 1, &ndr_table_mdssvc },
	{ "cmd", "S.cmd(handle, unkn1, device_id, unkn3, next_fragment, flags, request_blob, unkn5, max_fragment_size1, unkn6, max_fragment_size2, unkn7, unkn8) -> (fragment, response_blob, unkn9)", (py_dcerpc_call_fn)dcerpc_mdssvc_cmd_r, (py_data_pack_fn)pack_py_mdssvc_cmd_args_in, (py_data_unpack_fn)unpack_py_mdssvc_cmd_args_out, 2, &ndr_table_mdssvc },
	{ "close", "S.close(in_handle, unkn1, device_id, unkn2, unkn3) -> (out_handle, status)", (py_dcerpc_call_fn)dcerpc_mdssvc_close_r, (py_data_pack_fn)pack_py_mdssvc_close_args_in, (py_data_unpack_fn)unpack_py_mdssvc_close_args_out, 3, &ndr_table_mdssvc },
	{0}
};

static PyObject *interface_mdssvc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_mdssvc);
}

#define PY_DOC_MDSSVC "Spotlight metadata search service"
static PyTypeObject mdssvc_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mdssvc.mdssvc",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "mdssvc(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_MDSSVC,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_mdssvc_new,
};

static PyObject *syntax_mdssvc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_mdssvc.syntax_id);
}

#define PY_DOC_MDSSVC_SYNTAX "Spotlight metadata search service"
static PyTypeObject mdssvc_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mdssvc.mdssvc_abstract_syntax",
	.tp_doc = "mdssvc_abstract_syntax()\n"PY_DOC_MDSSVC_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_mdssvc_new,
};

static PyMethodDef mdssvc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "mdssvc",
	.m_doc = "mdssvc DCE/RPC",
	.m_size = -1,
	.m_methods = mdssvc_methods,
};
MODULE_INIT_FUNC(mdssvc)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	mdssvc_blob_Type.tp_base = BaseObject_Type;
	mdssvc_blob_Type.tp_basicsize = pytalloc_BaseObject_size();

	mdssvc_open_Type.tp_base = BaseObject_Type;
	mdssvc_open_Type.tp_basicsize = pytalloc_BaseObject_size();

	mdssvc_unknown1_Type.tp_base = BaseObject_Type;
	mdssvc_unknown1_Type.tp_basicsize = pytalloc_BaseObject_size();

	mdssvc_cmd_Type.tp_base = BaseObject_Type;
	mdssvc_cmd_Type.tp_basicsize = pytalloc_BaseObject_size();

	mdssvc_close_Type.tp_base = BaseObject_Type;
	mdssvc_close_Type.tp_basicsize = pytalloc_BaseObject_size();

	mdssvc_InterfaceType.tp_base = ClientConnection_Type;

	mdssvc_SyntaxType.tp_base = ndr_syntax_id_Type;
	mdssvc_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&mdssvc_blob_Type) < 0)
		goto out;
	if (PyType_Ready(&mdssvc_open_Type) < 0)
		goto out;
	if (PyType_Ready(&mdssvc_unknown1_Type) < 0)
		goto out;
	if (PyType_Ready(&mdssvc_cmd_Type) < 0)
		goto out;
	if (PyType_Ready(&mdssvc_close_Type) < 0)
		goto out;
	if (PyType_Ready(&mdssvc_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&mdssvc_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&mdssvc_InterfaceType, py_ndr_mdssvc_methods))
		return NULL;

#ifdef PY_BLOB_PATCH
	PY_BLOB_PATCH(&mdssvc_blob_Type);
#endif
#ifdef PY_OPEN_PATCH
	PY_OPEN_PATCH(&mdssvc_open_Type);
#endif
#ifdef PY_UNKNOWN1_PATCH
	PY_UNKNOWN1_PATCH(&mdssvc_unknown1_Type);
#endif
#ifdef PY_CMD_PATCH
	PY_CMD_PATCH(&mdssvc_cmd_Type);
#endif
#ifdef PY_CLOSE_PATCH
	PY_CLOSE_PATCH(&mdssvc_close_Type);
#endif
#ifdef PY_MDSSVC_PATCH
	PY_MDSSVC_PATCH(&mdssvc_InterfaceType);
#endif
#ifdef PY_MDSSVC_ABSTRACT_SYNTAX_PATCH
	PY_MDSSVC_ABSTRACT_SYNTAX_PATCH(&mdssvc_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&mdssvc_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	Py_INCREF((PyObject *)(void *)&mdssvc_blob_Type);
	PyModule_AddObject(m, "blob", (PyObject *)(void *)&mdssvc_blob_Type);
	Py_INCREF((PyObject *)(void *)&mdssvc_open_Type);
	PyModule_AddObject(m, "open", (PyObject *)(void *)&mdssvc_open_Type);
	Py_INCREF((PyObject *)(void *)&mdssvc_unknown1_Type);
	PyModule_AddObject(m, "unknown1", (PyObject *)(void *)&mdssvc_unknown1_Type);
	Py_INCREF((PyObject *)(void *)&mdssvc_cmd_Type);
	PyModule_AddObject(m, "cmd", (PyObject *)(void *)&mdssvc_cmd_Type);
	Py_INCREF((PyObject *)(void *)&mdssvc_close_Type);
	PyModule_AddObject(m, "close", (PyObject *)(void *)&mdssvc_close_Type);
	Py_INCREF((PyObject *)(void *)&mdssvc_InterfaceType);
	PyModule_AddObject(m, "mdssvc", (PyObject *)(void *)&mdssvc_InterfaceType);
	Py_INCREF((PyObject *)(void *)&mdssvc_SyntaxType);
	PyModule_AddObject(m, "mdssvc_abstract_syntax", (PyObject *)(void *)&mdssvc_SyntaxType);
	Py_INCREF((PyObject *)(void *)&mdssvc_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&mdssvc_SyntaxType);
#ifdef PY_MOD_MDSSVC_PATCH
	PY_MOD_MDSSVC_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
