
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_lsa.h"
#include "bin/default/librpc/gen_ndr/ndr_lsa_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
static PyTypeObject lsa_String_Type;
static PyTypeObject lsa_StringLarge_Type;
static PyTypeObject lsa_Strings_Type;
static PyTypeObject lsa_AsciiString_Type;
static PyTypeObject lsa_AsciiStringLarge_Type;
static PyTypeObject lsa_BinaryString_Type;
static PyTypeObject lsa_LUID_Type;
static PyTypeObject lsa_PrivEntry_Type;
static PyTypeObject lsa_PrivArray_Type;
static PyTypeObject lsa_QosInfo_Type;
static PyTypeObject lsa_ObjectAttribute_Type;
static PyTypeObject lsa_AuditLogInfo_Type;
static PyTypeObject lsa_AuditEventsInfo_Type;
static PyTypeObject lsa_DomainInfo_Type;
static PyTypeObject lsa_PDAccountInfo_Type;
static PyTypeObject lsa_ServerRole_Type;
static PyTypeObject lsa_ReplicaSourceInfo_Type;
static PyTypeObject lsa_DefaultQuotaInfo_Type;
static PyTypeObject lsa_ModificationInfo_Type;
static PyTypeObject lsa_AuditFullSetInfo_Type;
static PyTypeObject lsa_AuditFullQueryInfo_Type;
static PyTypeObject lsa_DnsDomainInfo_Type;
static PyTypeObject lsa_PolicyInformation_Type;
static PyTypeObject lsa_SidPtr_Type;
static PyTypeObject lsa_SidArray_Type;
static PyTypeObject lsa_DomainList_Type;
static PyTypeObject lsa_TranslatedSid_Type;
static PyTypeObject lsa_TransSidArray_Type;
static PyTypeObject lsa_RefDomainList_Type;
static PyTypeObject lsa_TranslatedName_Type;
static PyTypeObject lsa_TransNameArray_Type;
static PyTypeObject lsa_LUIDAttribute_Type;
static PyTypeObject lsa_PrivilegeSet_Type;
static PyTypeObject lsa_DATA_BUF_Type;
static PyTypeObject lsa_DATA_BUF2_Type;
static PyTypeObject lsa_TrustDomainInfoName_Type;
static PyTypeObject lsa_TrustDomainInfoControllers_Type;
static PyTypeObject lsa_TrustDomainInfoPosixOffset_Type;
static PyTypeObject lsa_TrustDomainInfoPassword_Type;
static PyTypeObject lsa_TrustDomainInfoBasic_Type;
static PyTypeObject lsa_TrustDomainInfoInfoEx_Type;
static PyTypeObject lsa_TrustDomainInfoBuffer_Type;
static PyTypeObject lsa_TrustDomainInfoAuthInfo_Type;
static PyTypeObject lsa_TrustDomainInfoFullInfo_Type;
static PyTypeObject lsa_TrustDomainInfoAuthInfoInternal_Type;
static PyTypeObject lsa_TrustDomainInfoFullInfoInternal_Type;
static PyTypeObject lsa_TrustDomainInfoAuthInfoInternalAES_Type;
static PyTypeObject lsa_TrustDomainInfoFullInfoInternalAES_Type;
static PyTypeObject lsa_TrustDomainInfoInfoEx2Internal_Type;
static PyTypeObject lsa_TrustDomainInfoFullInfo2Internal_Type;
static PyTypeObject lsa_TrustDomainInfoSupportedEncTypes_Type;
static PyTypeObject lsa_TrustedDomainInfo_Type;
static PyTypeObject lsa_DATA_BUF_PTR_Type;
static PyTypeObject lsa_RightAttribute_Type;
static PyTypeObject lsa_RightSet_Type;
static PyTypeObject lsa_DomainListEx_Type;
static PyTypeObject lsa_DomainInfoQoS_Type;
static PyTypeObject lsa_DomainInfoKerberos_Type;
static PyTypeObject lsa_DomainInfoEfs_Type;
static PyTypeObject lsa_DomainInformationPolicy_Type;
static PyTypeObject lsa_TranslatedName2_Type;
static PyTypeObject lsa_TransNameArray2_Type;
static PyTypeObject lsa_TranslatedSid2_Type;
static PyTypeObject lsa_TransSidArray2_Type;
static PyTypeObject lsa_TranslatedSid3_Type;
static PyTypeObject lsa_TransSidArray3_Type;
static PyTypeObject lsa_ForestTrustBinaryData_Type;
static PyTypeObject lsa_ForestTrustDomainInfo_Type;
static PyTypeObject lsa_ForestTrustData_Type;
static PyTypeObject lsa_ForestTrustRecord_Type;
static PyTypeObject lsa_ForestTrustInformation_Type;
static PyTypeObject lsa_ForestTrustCollisionRecord_Type;
static PyTypeObject lsa_ForestTrustCollisionInfo_Type;
static PyTypeObject lsa_revision_info1_Type;
static PyTypeObject lsa_revision_info_Type;
static PyTypeObject lsa_ForestTrustData2_Type;
static PyTypeObject lsa_ForestTrustRecord2_Type;
static PyTypeObject lsa_ForestTrustInformation2_Type;
static PyTypeObject lsarpc_InterfaceType;
static PyTypeObject lsa_Close_Type;
static PyTypeObject lsa_Delete_Type;
static PyTypeObject lsa_EnumPrivs_Type;
static PyTypeObject lsa_QuerySecurity_Type;
static PyTypeObject lsa_SetSecObj_Type;
static PyTypeObject lsa_OpenPolicy_Type;
static PyTypeObject lsa_QueryInfoPolicy_Type;
static PyTypeObject lsa_SetInfoPolicy_Type;
static PyTypeObject lsa_CreateAccount_Type;
static PyTypeObject lsa_EnumAccounts_Type;
static PyTypeObject lsa_CreateTrustedDomain_Type;
static PyTypeObject lsa_EnumTrustDom_Type;
static PyTypeObject lsa_LookupNames_Type;
static PyTypeObject lsa_LookupSids_Type;
static PyTypeObject lsa_CreateSecret_Type;
static PyTypeObject lsa_OpenAccount_Type;
static PyTypeObject lsa_EnumPrivsAccount_Type;
static PyTypeObject lsa_AddPrivilegesToAccount_Type;
static PyTypeObject lsa_RemovePrivilegesFromAccount_Type;
static PyTypeObject lsa_GetSystemAccessAccount_Type;
static PyTypeObject lsa_SetSystemAccessAccount_Type;
static PyTypeObject lsa_OpenTrustedDomain_Type;
static PyTypeObject lsa_QueryTrustedDomainInfo_Type;
static PyTypeObject lsa_SetInformationTrustedDomain_Type;
static PyTypeObject lsa_OpenSecret_Type;
static PyTypeObject lsa_SetSecret_Type;
static PyTypeObject lsa_QuerySecret_Type;
static PyTypeObject lsa_LookupPrivValue_Type;
static PyTypeObject lsa_LookupPrivName_Type;
static PyTypeObject lsa_LookupPrivDisplayName_Type;
static PyTypeObject lsa_DeleteObject_Type;
static PyTypeObject lsa_EnumAccountsWithUserRight_Type;
static PyTypeObject lsa_EnumAccountRights_Type;
static PyTypeObject lsa_AddAccountRights_Type;
static PyTypeObject lsa_RemoveAccountRights_Type;
static PyTypeObject lsa_QueryTrustedDomainInfoBySid_Type;
static PyTypeObject lsa_SetTrustedDomainInfo_Type;
static PyTypeObject lsa_DeleteTrustedDomain_Type;
static PyTypeObject lsa_StorePrivateData_Type;
static PyTypeObject lsa_RetrievePrivateData_Type;
static PyTypeObject lsa_OpenPolicy2_Type;
static PyTypeObject lsa_GetUserName_Type;
static PyTypeObject lsa_QueryInfoPolicy2_Type;
static PyTypeObject lsa_SetInfoPolicy2_Type;
static PyTypeObject lsa_QueryTrustedDomainInfoByName_Type;
static PyTypeObject lsa_SetTrustedDomainInfoByName_Type;
static PyTypeObject lsa_EnumTrustedDomainsEx_Type;
static PyTypeObject lsa_CreateTrustedDomainEx_Type;
static PyTypeObject lsa_CloseTrustedDomainEx_Type;
static PyTypeObject lsa_QueryDomainInformationPolicy_Type;
static PyTypeObject lsa_SetDomainInformationPolicy_Type;
static PyTypeObject lsa_OpenTrustedDomainByName_Type;
static PyTypeObject lsa_LookupSids2_Type;
static PyTypeObject lsa_LookupNames2_Type;
static PyTypeObject lsa_CreateTrustedDomainEx2_Type;
static PyTypeObject lsa_LookupNames3_Type;
static PyTypeObject lsa_lsaRQueryForestTrustInformation_Type;
static PyTypeObject lsa_lsaRSetForestTrustInformation_Type;
static PyTypeObject lsa_LookupSids3_Type;
static PyTypeObject lsa_LookupNames4_Type;
static PyTypeObject lsa_CreateTrustedDomainEx3_Type;
static PyTypeObject lsa_OpenPolicy3_Type;
static PyTypeObject lsa_lsaRQueryForestTrustInformation2_Type;
static PyTypeObject lsa_lsaRSetForestTrustInformation2_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *security_descriptor_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *ndr_pointer_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;
#include "librpc/ndr/py_lsa.c"


static PyObject *py_lsa_String_get_length(PyObject *obj, void *closure)
{
	struct lsa_String *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_lsa_String_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_String *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_String_get_size(PyObject *obj, void *closure)
{
	struct lsa_String *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_lsa_String_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_String *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_String_get_string(PyObject *obj, void *closure)
{
	struct lsa_String *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_String_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_String *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_String_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_lsa_String_get_length,
		.set = py_lsa_String_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_lsa_String_get_size,
		.set = py_lsa_String_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_lsa_String_get_string,
		.set = py_lsa_String_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_String_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_String, type);
}

static PyObject *py_lsa_String_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_String *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_String);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_String_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_String *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_String);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_String);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_String_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_String *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_String, "lsa_String", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_String_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_String_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_String_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_String_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_String_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.String",
	.tp_getset = py_lsa_String_getsetters,
	.tp_methods = py_lsa_String_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_String_new,
};


static PyObject *py_lsa_StringLarge_get_length(PyObject *obj, void *closure)
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_lsa_StringLarge_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_StringLarge_get_size(PyObject *obj, void *closure)
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_lsa_StringLarge_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_StringLarge_get_string(PyObject *obj, void *closure)
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_StringLarge_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_StringLarge_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_lsa_StringLarge_get_length,
		.set = py_lsa_StringLarge_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_lsa_StringLarge_get_size,
		.set = py_lsa_StringLarge_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_lsa_StringLarge_get_string,
		.set = py_lsa_StringLarge_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_StringLarge_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_StringLarge, type);
}

static PyObject *py_lsa_StringLarge_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_StringLarge);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_StringLarge_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_StringLarge);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_StringLarge);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_StringLarge_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_StringLarge *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_StringLarge, "lsa_StringLarge", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_StringLarge_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_StringLarge_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_StringLarge_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_StringLarge_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_StringLarge_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.StringLarge",
	.tp_getset = py_lsa_StringLarge_getsetters,
	.tp_methods = py_lsa_StringLarge_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_StringLarge_new,
};


static PyObject *py_lsa_Strings_get_count(PyObject *obj, void *closure)
{
	struct lsa_Strings *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_Strings_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Strings *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_Strings_get_names(PyObject *obj, void *closure)
{
	struct lsa_Strings *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < (object->count); names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_String_Type, object->names, &(object->names)[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_Strings_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Strings *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->names");
		return -1;
	}
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				if (PyList_GET_ITEM(value, names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->names)[names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->names)[names_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_Strings_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_Strings_get_count,
		.set = py_lsa_Strings_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "names"),
		.get = py_lsa_Strings_get_names,
		.set = py_lsa_Strings_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_Strings_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_Strings, type);
}

static PyObject *py_lsa_Strings_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_Strings *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_Strings);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_Strings_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_Strings *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_Strings);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_Strings);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_Strings_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_Strings *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_Strings, "lsa_Strings", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_Strings_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_Strings_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Strings_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_Strings_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_Strings_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.Strings",
	.tp_getset = py_lsa_Strings_getsetters,
	.tp_methods = py_lsa_Strings_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_Strings_new,
};


static PyObject *py_lsa_AsciiString_get_length(PyObject *obj, void *closure)
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_lsa_AsciiString_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AsciiString_get_size(PyObject *obj, void *closure)
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_lsa_AsciiString_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AsciiString_get_string(PyObject *obj, void *closure)
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_AsciiString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AsciiString_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_lsa_AsciiString_get_length,
		.set = py_lsa_AsciiString_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_lsa_AsciiString_get_size,
		.set = py_lsa_AsciiString_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_lsa_AsciiString_get_string,
		.set = py_lsa_AsciiString_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_AsciiString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AsciiString, type);
}

static PyObject *py_lsa_AsciiString_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_AsciiString);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_AsciiString_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiString);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiString);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_AsciiString_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_AsciiString *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_AsciiString, "lsa_AsciiString", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_AsciiString_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_AsciiString_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_AsciiString_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_AsciiString_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_AsciiString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.AsciiString",
	.tp_getset = py_lsa_AsciiString_getsetters,
	.tp_methods = py_lsa_AsciiString_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_AsciiString_new,
};


static PyObject *py_lsa_AsciiStringLarge_get_length(PyObject *obj, void *closure)
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_lsa_AsciiStringLarge_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AsciiStringLarge_get_size(PyObject *obj, void *closure)
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_lsa_AsciiStringLarge_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AsciiStringLarge_get_string(PyObject *obj, void *closure)
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_AsciiStringLarge_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AsciiStringLarge_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_lsa_AsciiStringLarge_get_length,
		.set = py_lsa_AsciiStringLarge_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_lsa_AsciiStringLarge_get_size,
		.set = py_lsa_AsciiStringLarge_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_lsa_AsciiStringLarge_get_string,
		.set = py_lsa_AsciiStringLarge_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_AsciiStringLarge_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AsciiStringLarge, type);
}

static PyObject *py_lsa_AsciiStringLarge_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_AsciiStringLarge);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_AsciiStringLarge_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiStringLarge);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiStringLarge);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_AsciiStringLarge_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_AsciiStringLarge *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_AsciiStringLarge, "lsa_AsciiStringLarge", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_AsciiStringLarge_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_AsciiStringLarge_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_AsciiStringLarge_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_AsciiStringLarge_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_AsciiStringLarge_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.AsciiStringLarge",
	.tp_getset = py_lsa_AsciiStringLarge_getsetters,
	.tp_methods = py_lsa_AsciiStringLarge_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_AsciiStringLarge_new,
};


static PyObject *py_lsa_BinaryString_get_length(PyObject *obj, void *closure)
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_lsa_BinaryString_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_BinaryString_get_size(PyObject *obj, void *closure)
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_lsa_BinaryString_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_BinaryString_get_array(PyObject *obj, void *closure)
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->length / 2);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->length / 2); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = PyLong_FromLong((uint16_t)((object->array)[array_cntr_1]));
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_lsa_BinaryString_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->array)[array_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, array_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, array_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->array)[array_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_BinaryString_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_lsa_BinaryString_get_length,
		.set = py_lsa_BinaryString_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_lsa_BinaryString_get_size,
		.set = py_lsa_BinaryString_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_lsa_BinaryString_get_array,
		.set = py_lsa_BinaryString_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_BinaryString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_BinaryString, type);
}

static PyObject *py_lsa_BinaryString_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_BinaryString);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_BinaryString_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_BinaryString);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_BinaryString);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_BinaryString_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_BinaryString *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_BinaryString, "lsa_BinaryString", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_BinaryString_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_BinaryString_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_BinaryString_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_BinaryString_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_BinaryString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.BinaryString",
	.tp_getset = py_lsa_BinaryString_getsetters,
	.tp_methods = py_lsa_BinaryString_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_BinaryString_new,
};


static PyObject *py_lsa_LUID_get_low(PyObject *obj, void *closure)
{
	struct lsa_LUID *object = pytalloc_get_ptr(obj);
	PyObject *py_low;
	py_low = PyLong_FromUnsignedLongLong((uint32_t)(object->low));
	return py_low;
}

static int py_lsa_LUID_set_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->low");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->low));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->low = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LUID_get_high(PyObject *obj, void *closure)
{
	struct lsa_LUID *object = pytalloc_get_ptr(obj);
	PyObject *py_high;
	py_high = PyLong_FromUnsignedLongLong((uint32_t)(object->high));
	return py_high;
}

static int py_lsa_LUID_set_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->high");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->high));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->high = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_LUID_getsetters[] = {
	{
		.name = discard_const_p(char, "low"),
		.get = py_lsa_LUID_get_low,
		.set = py_lsa_LUID_set_low,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "high"),
		.get = py_lsa_LUID_get_high,
		.set = py_lsa_LUID_set_high,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_LUID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_LUID, type);
}


static PyTypeObject lsa_LUID_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.LUID",
	.tp_getset = py_lsa_LUID_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_LUID_new,
};


static PyObject *py_lsa_PrivEntry_get_name(PyObject *obj, void *closure)
{
	struct lsa_PrivEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_PrivEntry_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_PrivEntry_get_luid(PyObject *obj, void *closure)
{
	struct lsa_PrivEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_luid;
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, pytalloc_get_mem_ctx(obj), &object->luid);
	return py_luid;
}

static int py_lsa_PrivEntry_set_luid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->luid");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_LUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->luid = *(struct lsa_LUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_PrivEntry_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_PrivEntry_get_name,
		.set = py_lsa_PrivEntry_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "luid"),
		.get = py_lsa_PrivEntry_get_luid,
		.set = py_lsa_PrivEntry_set_luid,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_LUID")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_PrivEntry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PrivEntry, type);
}


static PyTypeObject lsa_PrivEntry_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.PrivEntry",
	.tp_getset = py_lsa_PrivEntry_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_PrivEntry_new,
};


static PyObject *py_lsa_PrivArray_get_count(PyObject *obj, void *closure)
{
	struct lsa_PrivArray *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_PrivArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_PrivArray_get_privs(PyObject *obj, void *closure)
{
	struct lsa_PrivArray *object = pytalloc_get_ptr(obj);
	PyObject *py_privs;
	if (object->privs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->privs == NULL) {
		py_privs = Py_None;
		Py_INCREF(py_privs);
	} else {
		py_privs = PyList_New(object->count);
		if (py_privs == NULL) {
			return NULL;
		}
		{
			int privs_cntr_1;
			for (privs_cntr_1 = 0; privs_cntr_1 < (object->count); privs_cntr_1++) {
				PyObject *py_privs_1;
				py_privs_1 = pytalloc_reference_ex(&lsa_PrivEntry_Type, object->privs, &(object->privs)[privs_cntr_1]);
				PyList_SetItem(py_privs, privs_cntr_1, py_privs_1);
			}
		}
	}
	return py_privs;
}

static int py_lsa_PrivArray_set_privs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->privs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->privs");
		return -1;
	}
	if (value == Py_None) {
		object->privs = NULL;
	} else {
		object->privs = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privs_cntr_1;
			object->privs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->privs, PyList_GET_SIZE(value));
			if (!object->privs) { return -1; }
			talloc_set_name_const(object->privs, "ARRAY: object->privs");
			for (privs_cntr_1 = 0; privs_cntr_1 < PyList_GET_SIZE(value); privs_cntr_1++) {
				if (PyList_GET_ITEM(value, privs_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->privs)[privs_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_PrivEntry_Type, PyList_GET_ITEM(value, privs_cntr_1), return -1;);
				if (talloc_reference(object->privs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, privs_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->privs)[privs_cntr_1] = *(struct lsa_PrivEntry *)pytalloc_get_ptr(PyList_GET_ITEM(value, privs_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_PrivArray_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_PrivArray_get_count,
		.set = py_lsa_PrivArray_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "privs"),
		.get = py_lsa_PrivArray_get_privs,
		.set = py_lsa_PrivArray_set_privs,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PrivEntry")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_PrivArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PrivArray, type);
}


static PyTypeObject lsa_PrivArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.PrivArray",
	.tp_getset = py_lsa_PrivArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_PrivArray_new,
};


static PyObject *py_lsa_QosInfo_get_len(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromUnsignedLongLong((uint32_t)(object->len));
	return py_len;
}

static int py_lsa_QosInfo_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_QosInfo_get_impersonation_level(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_impersonation_level;
	py_impersonation_level = PyLong_FromLong((uint16_t)(object->impersonation_level));
	return py_impersonation_level;
}

static int py_lsa_QosInfo_set_impersonation_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->impersonation_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->impersonation_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->impersonation_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_QosInfo_get_context_mode(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_context_mode;
	py_context_mode = PyLong_FromLong((uint16_t)(object->context_mode));
	return py_context_mode;
}

static int py_lsa_QosInfo_set_context_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->context_mode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->context_mode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->context_mode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_QosInfo_get_effective_only(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_effective_only;
	py_effective_only = PyLong_FromLong((uint16_t)(object->effective_only));
	return py_effective_only;
}

static int py_lsa_QosInfo_set_effective_only(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->effective_only");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->effective_only));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->effective_only = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_QosInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "len"),
		.get = py_lsa_QosInfo_get_len,
		.set = py_lsa_QosInfo_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "impersonation_level"),
		.get = py_lsa_QosInfo_get_impersonation_level,
		.set = py_lsa_QosInfo_set_impersonation_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SecurityImpersonationLevel")
	},
	{
		.name = discard_const_p(char, "context_mode"),
		.get = py_lsa_QosInfo_get_context_mode,
		.set = py_lsa_QosInfo_set_context_mode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "effective_only"),
		.get = py_lsa_QosInfo_get_effective_only,
		.set = py_lsa_QosInfo_set_effective_only,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_QosInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_QosInfo, type);
}


static PyTypeObject lsa_QosInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.QosInfo",
	.tp_getset = py_lsa_QosInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_QosInfo_new,
};


static PyObject *py_lsa_ObjectAttribute_get_len(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromUnsignedLongLong((uint32_t)(object->len));
	return py_len;
}

static int py_lsa_ObjectAttribute_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_root_dir(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_root_dir;
	if (object->root_dir == NULL) {
		Py_RETURN_NONE;
	}
	if (object->root_dir == NULL) {
		py_root_dir = Py_None;
		Py_INCREF(py_root_dir);
	} else {
		py_root_dir = PyLong_FromLong((uint16_t)(*object->root_dir));
	}
	return py_root_dir;
}

static int py_lsa_ObjectAttribute_set_root_dir(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->root_dir));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->root_dir");
		return -1;
	}
	if (value == Py_None) {
		object->root_dir = NULL;
	} else {
		object->root_dir = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->root_dir);
		if (object->root_dir == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->root_dir));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->root_dir = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_object_name(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_object_name;
	if (object->object_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->object_name == NULL) {
		py_object_name = Py_None;
		Py_INCREF(py_object_name);
	} else {
		if (object->object_name == NULL) {
			py_object_name = Py_None;
			Py_INCREF(py_object_name);
		} else {
			py_object_name = PyUnicode_Decode(object->object_name, strlen(object->object_name), "utf-8", "ignore");
		}
	}
	return py_object_name;
}

static int py_lsa_ObjectAttribute_set_object_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->object_name");
		return -1;
	}
	if (value == Py_None) {
		object->object_name = NULL;
	} else {
		object->object_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->object_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_attributes(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->attributes));
	return py_attributes;
}

static int py_lsa_ObjectAttribute_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_sec_desc(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_desc;
	if (object->sec_desc == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sec_desc == NULL) {
		py_sec_desc = Py_None;
		Py_INCREF(py_sec_desc);
	} else {
		py_sec_desc = pytalloc_reference_ex(security_descriptor_Type, object->sec_desc, object->sec_desc);
	}
	return py_sec_desc;
}

static int py_lsa_ObjectAttribute_set_sec_desc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sec_desc));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sec_desc");
		return -1;
	}
	if (value == Py_None) {
		object->sec_desc = NULL;
	} else {
		object->sec_desc = NULL;
		PY_CHECK_TYPE(security_descriptor_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sec_desc = (struct security_descriptor *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_sec_qos(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_qos;
	if (object->sec_qos == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sec_qos == NULL) {
		py_sec_qos = Py_None;
		Py_INCREF(py_sec_qos);
	} else {
		py_sec_qos = pytalloc_reference_ex(&lsa_QosInfo_Type, object->sec_qos, object->sec_qos);
	}
	return py_sec_qos;
}

static int py_lsa_ObjectAttribute_set_sec_qos(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sec_qos));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sec_qos");
		return -1;
	}
	if (value == Py_None) {
		object->sec_qos = NULL;
	} else {
		object->sec_qos = NULL;
		PY_CHECK_TYPE(&lsa_QosInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sec_qos = (struct lsa_QosInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_ObjectAttribute_getsetters[] = {
	{
		.name = discard_const_p(char, "len"),
		.get = py_lsa_ObjectAttribute_get_len,
		.set = py_lsa_ObjectAttribute_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "root_dir"),
		.get = py_lsa_ObjectAttribute_get_root_dir,
		.set = py_lsa_ObjectAttribute_set_root_dir,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "object_name"),
		.get = py_lsa_ObjectAttribute_get_object_name,
		.set = py_lsa_ObjectAttribute_set_object_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_lsa_ObjectAttribute_get_attributes,
		.set = py_lsa_ObjectAttribute_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sec_desc"),
		.get = py_lsa_ObjectAttribute_get_sec_desc,
		.set = py_lsa_ObjectAttribute_set_sec_desc,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_descriptor")
	},
	{
		.name = discard_const_p(char, "sec_qos"),
		.get = py_lsa_ObjectAttribute_get_sec_qos,
		.set = py_lsa_ObjectAttribute_set_sec_qos,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_QosInfo")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ObjectAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ObjectAttribute, type);
}


static PyTypeObject lsa_ObjectAttribute_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ObjectAttribute",
	.tp_getset = py_lsa_ObjectAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ObjectAttribute_new,
};


static PyObject *py_lsa_AuditLogInfo_get_percent_full(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_percent_full;
	py_percent_full = PyLong_FromUnsignedLongLong((uint32_t)(object->percent_full));
	return py_percent_full;
}

static int py_lsa_AuditLogInfo_set_percent_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->percent_full");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->percent_full));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->percent_full = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_maximum_log_size(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_maximum_log_size;
	py_maximum_log_size = PyLong_FromUnsignedLongLong((uint32_t)(object->maximum_log_size));
	return py_maximum_log_size;
}

static int py_lsa_AuditLogInfo_set_maximum_log_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->maximum_log_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maximum_log_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maximum_log_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_retention_time(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_retention_time;
	py_retention_time = PyLong_FromUnsignedLongLong(object->retention_time);
	return py_retention_time;
}

static int py_lsa_AuditLogInfo_set_retention_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->retention_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->retention_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->retention_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_shutdown_in_progress(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_shutdown_in_progress;
	py_shutdown_in_progress = PyLong_FromLong((uint16_t)(object->shutdown_in_progress));
	return py_shutdown_in_progress;
}

static int py_lsa_AuditLogInfo_set_shutdown_in_progress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->shutdown_in_progress");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->shutdown_in_progress));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->shutdown_in_progress = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_time_to_shutdown(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_time_to_shutdown;
	py_time_to_shutdown = PyLong_FromUnsignedLongLong(object->time_to_shutdown);
	return py_time_to_shutdown;
}

static int py_lsa_AuditLogInfo_set_time_to_shutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time_to_shutdown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time_to_shutdown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time_to_shutdown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_next_audit_record(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_next_audit_record;
	py_next_audit_record = PyLong_FromUnsignedLongLong((uint32_t)(object->next_audit_record));
	return py_next_audit_record;
}

static int py_lsa_AuditLogInfo_set_next_audit_record(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->next_audit_record");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->next_audit_record));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->next_audit_record = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AuditLogInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "percent_full"),
		.get = py_lsa_AuditLogInfo_get_percent_full,
		.set = py_lsa_AuditLogInfo_set_percent_full,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maximum_log_size"),
		.get = py_lsa_AuditLogInfo_get_maximum_log_size,
		.set = py_lsa_AuditLogInfo_set_maximum_log_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "retention_time"),
		.get = py_lsa_AuditLogInfo_get_retention_time,
		.set = py_lsa_AuditLogInfo_set_retention_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "shutdown_in_progress"),
		.get = py_lsa_AuditLogInfo_get_shutdown_in_progress,
		.set = py_lsa_AuditLogInfo_set_shutdown_in_progress,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "time_to_shutdown"),
		.get = py_lsa_AuditLogInfo_get_time_to_shutdown,
		.set = py_lsa_AuditLogInfo_set_time_to_shutdown,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "next_audit_record"),
		.get = py_lsa_AuditLogInfo_get_next_audit_record,
		.set = py_lsa_AuditLogInfo_set_next_audit_record,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_AuditLogInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditLogInfo, type);
}


static PyTypeObject lsa_AuditLogInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.AuditLogInfo",
	.tp_getset = py_lsa_AuditLogInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_AuditLogInfo_new,
};


static PyObject *py_lsa_AuditEventsInfo_get_auditing_mode(PyObject *obj, void *closure)
{
	struct lsa_AuditEventsInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_auditing_mode;
	py_auditing_mode = PyLong_FromUnsignedLongLong((uint32_t)(object->auditing_mode));
	return py_auditing_mode;
}

static int py_lsa_AuditEventsInfo_set_auditing_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditEventsInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->auditing_mode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auditing_mode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auditing_mode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditEventsInfo_get_settings(PyObject *obj, void *closure)
{
	struct lsa_AuditEventsInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_settings;
	if (object->settings == NULL) {
		Py_RETURN_NONE;
	}
	if (object->settings == NULL) {
		py_settings = Py_None;
		Py_INCREF(py_settings);
	} else {
		py_settings = PyList_New(object->count);
		if (py_settings == NULL) {
			return NULL;
		}
		{
			int settings_cntr_1;
			for (settings_cntr_1 = 0; settings_cntr_1 < (object->count); settings_cntr_1++) {
				PyObject *py_settings_1;
				py_settings_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->settings)[settings_cntr_1]));
				PyList_SetItem(py_settings, settings_cntr_1, py_settings_1);
			}
		}
	}
	return py_settings;
}

static int py_lsa_AuditEventsInfo_set_settings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditEventsInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->settings));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->settings");
		return -1;
	}
	if (value == Py_None) {
		object->settings = NULL;
	} else {
		object->settings = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int settings_cntr_1;
			object->settings = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->settings, PyList_GET_SIZE(value));
			if (!object->settings) { return -1; }
			talloc_set_name_const(object->settings, "ARRAY: object->settings");
			for (settings_cntr_1 = 0; settings_cntr_1 < PyList_GET_SIZE(value); settings_cntr_1++) {
				if (PyList_GET_ITEM(value, settings_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->settings)[settings_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->settings)[settings_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, settings_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, settings_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->settings)[settings_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditEventsInfo_get_count(PyObject *obj, void *closure)
{
	struct lsa_AuditEventsInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_AuditEventsInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditEventsInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AuditEventsInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "auditing_mode"),
		.get = py_lsa_AuditEventsInfo_get_auditing_mode,
		.set = py_lsa_AuditEventsInfo_set_auditing_mode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "settings"),
		.get = py_lsa_AuditEventsInfo_get_settings,
		.set = py_lsa_AuditEventsInfo_set_settings,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PolicyAuditPolicy")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_AuditEventsInfo_get_count,
		.set = py_lsa_AuditEventsInfo_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_AuditEventsInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditEventsInfo, type);
}


static PyTypeObject lsa_AuditEventsInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.AuditEventsInfo",
	.tp_getset = py_lsa_AuditEventsInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_AuditEventsInfo_new,
};


static PyObject *py_lsa_DomainInfo_get_name(PyObject *obj, void *closure)
{
	struct lsa_DomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_DomainInfo_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DomainInfo_get_sid(PyObject *obj, void *closure)
{
	struct lsa_DomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_DomainInfo_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_DomainInfo_get_name,
		.set = py_lsa_DomainInfo_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_lsa_DomainInfo_get_sid,
		.set = py_lsa_DomainInfo_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainInfo, type);
}


static PyTypeObject lsa_DomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DomainInfo",
	.tp_getset = py_lsa_DomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DomainInfo_new,
};


static PyObject *py_lsa_PDAccountInfo_get_name(PyObject *obj, void *closure)
{
	struct lsa_PDAccountInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_PDAccountInfo_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PDAccountInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_PDAccountInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_PDAccountInfo_get_name,
		.set = py_lsa_PDAccountInfo_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_PDAccountInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PDAccountInfo, type);
}


static PyTypeObject lsa_PDAccountInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.PDAccountInfo",
	.tp_getset = py_lsa_PDAccountInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_PDAccountInfo_new,
};


static PyObject *py_lsa_ServerRole_get_role(PyObject *obj, void *closure)
{
	struct lsa_ServerRole *object = pytalloc_get_ptr(obj);
	PyObject *py_role;
	py_role = PyLong_FromUnsignedLongLong((uint32_t)(object->role));
	return py_role;
}

static int py_lsa_ServerRole_set_role(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ServerRole *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->role");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->role));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->role = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ServerRole_getsetters[] = {
	{
		.name = discard_const_p(char, "role"),
		.get = py_lsa_ServerRole_get_role,
		.set = py_lsa_ServerRole_set_role,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_Role")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ServerRole_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ServerRole, type);
}


static PyTypeObject lsa_ServerRole_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ServerRole",
	.tp_getset = py_lsa_ServerRole_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ServerRole_new,
};


static PyObject *py_lsa_ReplicaSourceInfo_get_source(PyObject *obj, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_source;
	py_source = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->source);
	return py_source;
}

static int py_lsa_ReplicaSourceInfo_set_source(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->source");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_ReplicaSourceInfo_get_account(PyObject *obj, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_account;
	py_account = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account);
	return py_account;
}

static int py_lsa_ReplicaSourceInfo_set_account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->account");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_ReplicaSourceInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "source"),
		.get = py_lsa_ReplicaSourceInfo_get_source,
		.set = py_lsa_ReplicaSourceInfo_set_source,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "account"),
		.get = py_lsa_ReplicaSourceInfo_get_account,
		.set = py_lsa_ReplicaSourceInfo_set_account,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ReplicaSourceInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ReplicaSourceInfo, type);
}


static PyTypeObject lsa_ReplicaSourceInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ReplicaSourceInfo",
	.tp_getset = py_lsa_ReplicaSourceInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ReplicaSourceInfo_new,
};


static PyObject *py_lsa_DefaultQuotaInfo_get_paged_pool(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_paged_pool;
	py_paged_pool = PyLong_FromUnsignedLongLong((uint32_t)(object->paged_pool));
	return py_paged_pool;
}

static int py_lsa_DefaultQuotaInfo_set_paged_pool(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->paged_pool");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->paged_pool));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->paged_pool = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_non_paged_pool(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_non_paged_pool;
	py_non_paged_pool = PyLong_FromUnsignedLongLong((uint32_t)(object->non_paged_pool));
	return py_non_paged_pool;
}

static int py_lsa_DefaultQuotaInfo_set_non_paged_pool(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->non_paged_pool");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->non_paged_pool));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->non_paged_pool = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_min_wss(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_min_wss;
	py_min_wss = PyLong_FromUnsignedLongLong((uint32_t)(object->min_wss));
	return py_min_wss;
}

static int py_lsa_DefaultQuotaInfo_set_min_wss(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->min_wss");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->min_wss));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->min_wss = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_max_wss(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_max_wss;
	py_max_wss = PyLong_FromUnsignedLongLong((uint32_t)(object->max_wss));
	return py_max_wss;
}

static int py_lsa_DefaultQuotaInfo_set_max_wss(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->max_wss");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_wss));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_wss = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_pagefile(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pagefile;
	py_pagefile = PyLong_FromUnsignedLongLong((uint32_t)(object->pagefile));
	return py_pagefile;
}

static int py_lsa_DefaultQuotaInfo_set_pagefile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pagefile");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pagefile));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pagefile = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong(object->unknown);
	return py_unknown;
}

static int py_lsa_DefaultQuotaInfo_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DefaultQuotaInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "paged_pool"),
		.get = py_lsa_DefaultQuotaInfo_get_paged_pool,
		.set = py_lsa_DefaultQuotaInfo_set_paged_pool,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "non_paged_pool"),
		.get = py_lsa_DefaultQuotaInfo_get_non_paged_pool,
		.set = py_lsa_DefaultQuotaInfo_set_non_paged_pool,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "min_wss"),
		.get = py_lsa_DefaultQuotaInfo_get_min_wss,
		.set = py_lsa_DefaultQuotaInfo_set_min_wss,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_wss"),
		.get = py_lsa_DefaultQuotaInfo_get_max_wss,
		.set = py_lsa_DefaultQuotaInfo_set_max_wss,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pagefile"),
		.get = py_lsa_DefaultQuotaInfo_get_pagefile,
		.set = py_lsa_DefaultQuotaInfo_set_pagefile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown"),
		.get = py_lsa_DefaultQuotaInfo_get_unknown,
		.set = py_lsa_DefaultQuotaInfo_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DefaultQuotaInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DefaultQuotaInfo, type);
}


static PyTypeObject lsa_DefaultQuotaInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DefaultQuotaInfo",
	.tp_getset = py_lsa_DefaultQuotaInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DefaultQuotaInfo_new,
};


static PyObject *py_lsa_ModificationInfo_get_modified_id(PyObject *obj, void *closure)
{
	struct lsa_ModificationInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_modified_id;
	py_modified_id = PyLong_FromUnsignedLongLong(object->modified_id);
	return py_modified_id;
}

static int py_lsa_ModificationInfo_set_modified_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ModificationInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->modified_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->modified_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->modified_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ModificationInfo_get_db_create_time(PyObject *obj, void *closure)
{
	struct lsa_ModificationInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_db_create_time;
	py_db_create_time = PyLong_FromUnsignedLongLong(object->db_create_time);
	return py_db_create_time;
}

static int py_lsa_ModificationInfo_set_db_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ModificationInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->db_create_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->db_create_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->db_create_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ModificationInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "modified_id"),
		.get = py_lsa_ModificationInfo_get_modified_id,
		.set = py_lsa_ModificationInfo_set_modified_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "db_create_time"),
		.get = py_lsa_ModificationInfo_get_db_create_time,
		.set = py_lsa_ModificationInfo_set_db_create_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ModificationInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ModificationInfo, type);
}


static PyTypeObject lsa_ModificationInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ModificationInfo",
	.tp_getset = py_lsa_ModificationInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ModificationInfo_new,
};


static PyObject *py_lsa_AuditFullSetInfo_get_shutdown_on_full(PyObject *obj, void *closure)
{
	struct lsa_AuditFullSetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_shutdown_on_full;
	py_shutdown_on_full = PyLong_FromLong((uint16_t)(object->shutdown_on_full));
	return py_shutdown_on_full;
}

static int py_lsa_AuditFullSetInfo_set_shutdown_on_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditFullSetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->shutdown_on_full");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->shutdown_on_full));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->shutdown_on_full = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AuditFullSetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "shutdown_on_full"),
		.get = py_lsa_AuditFullSetInfo_get_shutdown_on_full,
		.set = py_lsa_AuditFullSetInfo_set_shutdown_on_full,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_AuditFullSetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditFullSetInfo, type);
}


static PyTypeObject lsa_AuditFullSetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.AuditFullSetInfo",
	.tp_getset = py_lsa_AuditFullSetInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_AuditFullSetInfo_new,
};


static PyObject *py_lsa_AuditFullQueryInfo_get_shutdown_on_full(PyObject *obj, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_shutdown_on_full;
	py_shutdown_on_full = PyLong_FromLong((uint16_t)(object->shutdown_on_full));
	return py_shutdown_on_full;
}

static int py_lsa_AuditFullQueryInfo_set_shutdown_on_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->shutdown_on_full");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->shutdown_on_full));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->shutdown_on_full = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditFullQueryInfo_get_log_is_full(PyObject *obj, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_log_is_full;
	py_log_is_full = PyLong_FromLong((uint16_t)(object->log_is_full));
	return py_log_is_full;
}

static int py_lsa_AuditFullQueryInfo_set_log_is_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->log_is_full");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->log_is_full));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->log_is_full = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AuditFullQueryInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "shutdown_on_full"),
		.get = py_lsa_AuditFullQueryInfo_get_shutdown_on_full,
		.set = py_lsa_AuditFullQueryInfo_set_shutdown_on_full,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "log_is_full"),
		.get = py_lsa_AuditFullQueryInfo_get_log_is_full,
		.set = py_lsa_AuditFullQueryInfo_set_log_is_full,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_AuditFullQueryInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditFullQueryInfo, type);
}


static PyTypeObject lsa_AuditFullQueryInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.AuditFullQueryInfo",
	.tp_getset = py_lsa_AuditFullQueryInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_AuditFullQueryInfo_new,
};


static PyObject *py_lsa_DnsDomainInfo_get_name(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_DnsDomainInfo_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_dns_domain(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain;
	py_dns_domain = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_domain);
	return py_dns_domain;
}

static int py_lsa_DnsDomainInfo_set_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dns_domain");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domain = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_dns_forest(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_forest;
	py_dns_forest = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_forest);
	return py_dns_forest;
}

static int py_lsa_DnsDomainInfo_set_dns_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dns_forest");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_forest = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_domain_guid(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_guid;
	py_domain_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_guid);
	return py_domain_guid;
}

static int py_lsa_DnsDomainInfo_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_sid(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_DnsDomainInfo_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_DnsDomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_DnsDomainInfo_get_name,
		.set = py_lsa_DnsDomainInfo_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dns_domain"),
		.get = py_lsa_DnsDomainInfo_get_dns_domain,
		.set = py_lsa_DnsDomainInfo_set_dns_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dns_forest"),
		.get = py_lsa_DnsDomainInfo_get_dns_forest,
		.set = py_lsa_DnsDomainInfo_set_dns_forest,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "domain_guid"),
		.get = py_lsa_DnsDomainInfo_get_domain_guid,
		.set = py_lsa_DnsDomainInfo_set_domain_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_lsa_DnsDomainInfo_get_sid,
		.set = py_lsa_DnsDomainInfo_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DnsDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DnsDomainInfo, type);
}

static PyObject *py_lsa_DnsDomainInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_DnsDomainInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_DnsDomainInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_DnsDomainInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_DnsDomainInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_DnsDomainInfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_DnsDomainInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_DnsDomainInfo, "lsa_DnsDomainInfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_DnsDomainInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_DnsDomainInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_DnsDomainInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_DnsDomainInfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_DnsDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DnsDomainInfo",
	.tp_getset = py_lsa_DnsDomainInfo_getsetters,
	.tp_methods = py_lsa_DnsDomainInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DnsDomainInfo_new,
};

static PyObject *py_import_lsa_PolicyInformation(TALLOC_CTX *mem_ctx, int level, union lsa_PolicyInformation *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_POLICY_INFO_AUDIT_LOG:
			ret = pytalloc_reference_ex(&lsa_AuditLogInfo_Type, mem_ctx, &in->audit_log);
			return ret;

		case LSA_POLICY_INFO_AUDIT_EVENTS:
			ret = pytalloc_reference_ex(&lsa_AuditEventsInfo_Type, mem_ctx, &in->audit_events);
			return ret;

		case LSA_POLICY_INFO_DOMAIN:
			ret = pytalloc_reference_ex(&lsa_DomainInfo_Type, mem_ctx, &in->domain);
			return ret;

		case LSA_POLICY_INFO_PD:
			ret = pytalloc_reference_ex(&lsa_PDAccountInfo_Type, mem_ctx, &in->pd);
			return ret;

		case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
			ret = pytalloc_reference_ex(&lsa_DomainInfo_Type, mem_ctx, &in->account_domain);
			return ret;

		case LSA_POLICY_INFO_ROLE:
			ret = pytalloc_reference_ex(&lsa_ServerRole_Type, mem_ctx, &in->role);
			return ret;

		case LSA_POLICY_INFO_REPLICA:
			ret = pytalloc_reference_ex(&lsa_ReplicaSourceInfo_Type, mem_ctx, &in->replica);
			return ret;

		case LSA_POLICY_INFO_QUOTA:
			ret = pytalloc_reference_ex(&lsa_DefaultQuotaInfo_Type, mem_ctx, &in->quota);
			return ret;

		case LSA_POLICY_INFO_MOD:
			ret = pytalloc_reference_ex(&lsa_ModificationInfo_Type, mem_ctx, &in->mod);
			return ret;

		case LSA_POLICY_INFO_AUDIT_FULL_SET:
			ret = pytalloc_reference_ex(&lsa_AuditFullSetInfo_Type, mem_ctx, &in->auditfullset);
			return ret;

		case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			ret = pytalloc_reference_ex(&lsa_AuditFullQueryInfo_Type, mem_ctx, &in->auditfullquery);
			return ret;

		case LSA_POLICY_INFO_DNS:
			ret = pytalloc_reference_ex(&lsa_DnsDomainInfo_Type, mem_ctx, &in->dns);
			return ret;

		case LSA_POLICY_INFO_DNS_INT:
			ret = pytalloc_reference_ex(&lsa_DnsDomainInfo_Type, mem_ctx, &in->dns_int);
			return ret;

		case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN:
			ret = pytalloc_reference_ex(&lsa_DomainInfo_Type, mem_ctx, &in->l_account_domain);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union lsa_PolicyInformation *py_export_lsa_PolicyInformation(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_PolicyInformation *ret = talloc_zero(mem_ctx, union lsa_PolicyInformation);
	switch (level) {
		case LSA_POLICY_INFO_AUDIT_LOG:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->audit_log");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_AuditLogInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->audit_log = *(struct lsa_AuditLogInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_AUDIT_EVENTS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->audit_events");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_AuditEventsInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->audit_events = *(struct lsa_AuditEventsInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_DOMAIN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->domain");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->domain = *(struct lsa_DomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_PD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->pd");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_PDAccountInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->pd = *(struct lsa_PDAccountInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->account_domain");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->account_domain = *(struct lsa_DomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_ROLE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->role");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ServerRole_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->role = *(struct lsa_ServerRole *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_REPLICA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->replica");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ReplicaSourceInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->replica = *(struct lsa_ReplicaSourceInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_QUOTA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->quota");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DefaultQuotaInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->quota = *(struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_MOD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->mod");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ModificationInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mod = *(struct lsa_ModificationInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_AUDIT_FULL_SET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->auditfullset");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_AuditFullSetInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auditfullset = *(struct lsa_AuditFullSetInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->auditfullquery");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_AuditFullQueryInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auditfullquery = *(struct lsa_AuditFullQueryInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_DNS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->dns");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DnsDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dns = *(struct lsa_DnsDomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_DNS_INT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->dns_int");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DnsDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dns_int = *(struct lsa_DnsDomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->l_account_domain");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->l_account_domain = *(struct lsa_DomainInfo *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_lsa_PolicyInformation_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union lsa_PolicyInformation *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union lsa_PolicyInformation *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union lsa_PolicyInformation!");
		return NULL;
	}

	return py_import_lsa_PolicyInformation(mem_ctx, level, in);
}

static PyObject *py_lsa_PolicyInformation_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union lsa_PolicyInformation *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_lsa_PolicyInformation(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_lsa_PolicyInformation_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_PolicyInformation_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_PolicyInformation_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_lsa_PolicyInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject lsa_PolicyInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.PolicyInformation",
	.tp_getset = NULL,
	.tp_methods = py_lsa_PolicyInformation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_PolicyInformation_new,
};


static PyObject *py_lsa_SidPtr_get_sid(PyObject *obj, void *closure)
{
	struct lsa_SidPtr *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_SidPtr_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SidPtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_SidPtr_getsetters[] = {
	{
		.name = discard_const_p(char, "sid"),
		.get = py_lsa_SidPtr_get_sid,
		.set = py_lsa_SidPtr_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_SidPtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_SidPtr, type);
}


static PyTypeObject lsa_SidPtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.SidPtr",
	.tp_getset = py_lsa_SidPtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_SidPtr_new,
};


static PyObject *py_lsa_SidArray_get_num_sids(PyObject *obj, void *closure)
{
	struct lsa_SidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_sids));
	return py_num_sids;
}

static int py_lsa_SidArray_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SidArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_sids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_sids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_sids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_SidArray_get_sids(PyObject *obj, void *closure)
{
	struct lsa_SidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->num_sids);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->num_sids); sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_SidPtr_Type, object->sids, &(object->sids)[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_SidArray_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SidArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->sids)[sids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_SidPtr_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sids)[sids_cntr_1] = *(struct lsa_SidPtr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_SidArray_getsetters[] = {
	{
		.name = discard_const_p(char, "num_sids"),
		.get = py_lsa_SidArray_get_num_sids,
		.set = py_lsa_SidArray_set_num_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_lsa_SidArray_get_sids,
		.set = py_lsa_SidArray_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidPtr")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_SidArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_SidArray, type);
}

static PyObject *py_lsa_SidArray_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_SidArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_SidArray);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_SidArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_SidArray *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_SidArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_SidArray);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_SidArray_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_SidArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_SidArray, "lsa_SidArray", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_SidArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_SidArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SidArray_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_SidArray_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_SidArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.SidArray",
	.tp_getset = py_lsa_SidArray_getsetters,
	.tp_methods = py_lsa_SidArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_SidArray_new,
};


static PyObject *py_lsa_DomainList_get_count(PyObject *obj, void *closure)
{
	struct lsa_DomainList *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_DomainList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainList_get_domains(PyObject *obj, void *closure)
{
	struct lsa_DomainList *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->domains == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = PyList_New(object->count);
		if (py_domains == NULL) {
			return NULL;
		}
		{
			int domains_cntr_1;
			for (domains_cntr_1 = 0; domains_cntr_1 < (object->count); domains_cntr_1++) {
				PyObject *py_domains_1;
				py_domains_1 = pytalloc_reference_ex(&lsa_DomainInfo_Type, object->domains, &(object->domains)[domains_cntr_1]);
				PyList_SetItem(py_domains, domains_cntr_1, py_domains_1);
			}
		}
	}
	return py_domains;
}

static int py_lsa_DomainList_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainList *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domains");
		return -1;
	}
	if (value == Py_None) {
		object->domains = NULL;
	} else {
		object->domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int domains_cntr_1;
			object->domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->domains, PyList_GET_SIZE(value));
			if (!object->domains) { return -1; }
			talloc_set_name_const(object->domains, "ARRAY: object->domains");
			for (domains_cntr_1 = 0; domains_cntr_1 < PyList_GET_SIZE(value); domains_cntr_1++) {
				if (PyList_GET_ITEM(value, domains_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->domains)[domains_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_DomainInfo_Type, PyList_GET_ITEM(value, domains_cntr_1), return -1;);
				if (talloc_reference(object->domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->domains)[domains_cntr_1] = *(struct lsa_DomainInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainList_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_DomainList_get_count,
		.set = py_lsa_DomainList_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domains"),
		.get = py_lsa_DomainList_get_domains,
		.set = py_lsa_DomainList_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DomainInfo")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DomainList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainList, type);
}


static PyTypeObject lsa_DomainList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DomainList",
	.tp_getset = py_lsa_DomainList_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DomainList_new,
};


static PyObject *py_lsa_TranslatedSid_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyLong_FromLong((uint16_t)(object->sid_type));
	return py_sid_type;
}

static int py_lsa_TranslatedSid_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid_get_rid(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_lsa_TranslatedSid_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_index));
	return py_sid_index;
}

static int py_lsa_TranslatedSid_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TranslatedSid_getsetters[] = {
	{
		.name = discard_const_p(char, "sid_type"),
		.get = py_lsa_TranslatedSid_get_sid_type,
		.set = py_lsa_TranslatedSid_set_sid_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_lsa_TranslatedSid_get_rid,
		.set = py_lsa_TranslatedSid_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sid_index"),
		.get = py_lsa_TranslatedSid_get_sid_index,
		.set = py_lsa_TranslatedSid_set_sid_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TranslatedSid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedSid, type);
}


static PyTypeObject lsa_TranslatedSid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TranslatedSid",
	.tp_getset = py_lsa_TranslatedSid_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TranslatedSid_new,
};


static PyObject *py_lsa_TransSidArray_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_TransSidArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TransSidArray_get_sids(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->count);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->count); sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_TranslatedSid_Type, object->sids, &(object->sids)[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_TransSidArray_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->sids)[sids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_TranslatedSid_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sids)[sids_cntr_1] = *(struct lsa_TranslatedSid *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransSidArray_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_TransSidArray_get_count,
		.set = py_lsa_TransSidArray_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_lsa_TransSidArray_get_sids,
		.set = py_lsa_TransSidArray_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TranslatedSid")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TransSidArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransSidArray, type);
}


static PyTypeObject lsa_TransSidArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TransSidArray",
	.tp_getset = py_lsa_TransSidArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TransSidArray_new,
};


static PyObject *py_lsa_RefDomainList_get_count(PyObject *obj, void *closure)
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_RefDomainList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_RefDomainList_get_domains(PyObject *obj, void *closure)
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->domains == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = PyList_New(object->count);
		if (py_domains == NULL) {
			return NULL;
		}
		{
			int domains_cntr_1;
			for (domains_cntr_1 = 0; domains_cntr_1 < (object->count); domains_cntr_1++) {
				PyObject *py_domains_1;
				py_domains_1 = pytalloc_reference_ex(&lsa_DomainInfo_Type, object->domains, &(object->domains)[domains_cntr_1]);
				PyList_SetItem(py_domains, domains_cntr_1, py_domains_1);
			}
		}
	}
	return py_domains;
}

static int py_lsa_RefDomainList_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domains");
		return -1;
	}
	if (value == Py_None) {
		object->domains = NULL;
	} else {
		object->domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int domains_cntr_1;
			object->domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->domains, PyList_GET_SIZE(value));
			if (!object->domains) { return -1; }
			talloc_set_name_const(object->domains, "ARRAY: object->domains");
			for (domains_cntr_1 = 0; domains_cntr_1 < PyList_GET_SIZE(value); domains_cntr_1++) {
				if (PyList_GET_ITEM(value, domains_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->domains)[domains_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_DomainInfo_Type, PyList_GET_ITEM(value, domains_cntr_1), return -1;);
				if (talloc_reference(object->domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->domains)[domains_cntr_1] = *(struct lsa_DomainInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_RefDomainList_get_max_size(PyObject *obj, void *closure)
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(obj);
	PyObject *py_max_size;
	py_max_size = PyLong_FromUnsignedLongLong((uint32_t)(object->max_size));
	return py_max_size;
}

static int py_lsa_RefDomainList_set_max_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->max_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_RefDomainList_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_RefDomainList_get_count,
		.set = py_lsa_RefDomainList_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domains"),
		.get = py_lsa_RefDomainList_get_domains,
		.set = py_lsa_RefDomainList_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DomainInfo")
	},
	{
		.name = discard_const_p(char, "max_size"),
		.get = py_lsa_RefDomainList_get_max_size,
		.set = py_lsa_RefDomainList_set_max_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_RefDomainList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_RefDomainList, type);
}

static PyObject *py_lsa_RefDomainList_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_RefDomainList);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_RefDomainList_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_RefDomainList);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_RefDomainList);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_RefDomainList_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_RefDomainList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_RefDomainList, "lsa_RefDomainList", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_RefDomainList_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_RefDomainList_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_RefDomainList_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_RefDomainList_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_RefDomainList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.RefDomainList",
	.tp_getset = py_lsa_RefDomainList_getsetters,
	.tp_methods = py_lsa_RefDomainList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_RefDomainList_new,
};


static PyObject *py_lsa_TranslatedName_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyLong_FromLong((uint16_t)(object->sid_type));
	return py_sid_type;
}

static int py_lsa_TranslatedName_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedName_get_name(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_TranslatedName_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TranslatedName_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_index));
	return py_sid_index;
}

static int py_lsa_TranslatedName_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TranslatedName_getsetters[] = {
	{
		.name = discard_const_p(char, "sid_type"),
		.get = py_lsa_TranslatedName_get_sid_type,
		.set = py_lsa_TranslatedName_set_sid_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_TranslatedName_get_name,
		.set = py_lsa_TranslatedName_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "sid_index"),
		.get = py_lsa_TranslatedName_get_sid_index,
		.set = py_lsa_TranslatedName_set_sid_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TranslatedName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedName, type);
}


static PyTypeObject lsa_TranslatedName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TranslatedName",
	.tp_getset = py_lsa_TranslatedName_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TranslatedName_new,
};


static PyObject *py_lsa_TransNameArray_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_TransNameArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TransNameArray_get_names(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < (object->count); names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_TranslatedName_Type, object->names, &(object->names)[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_TransNameArray_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->names");
		return -1;
	}
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				if (PyList_GET_ITEM(value, names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->names)[names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_TranslatedName_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->names)[names_cntr_1] = *(struct lsa_TranslatedName *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransNameArray_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_TransNameArray_get_count,
		.set = py_lsa_TransNameArray_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "names"),
		.get = py_lsa_TransNameArray_get_names,
		.set = py_lsa_TransNameArray_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TranslatedName")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TransNameArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransNameArray, type);
}

static PyObject *py_lsa_TransNameArray_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_TransNameArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_TransNameArray);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_TransNameArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_TransNameArray *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TransNameArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TransNameArray);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_TransNameArray_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_TransNameArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_TransNameArray, "lsa_TransNameArray", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_TransNameArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_TransNameArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_TransNameArray_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_TransNameArray_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_TransNameArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TransNameArray",
	.tp_getset = py_lsa_TransNameArray_getsetters,
	.tp_methods = py_lsa_TransNameArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TransNameArray_new,
};


static PyObject *py_lsa_LUIDAttribute_get_luid(PyObject *obj, void *closure)
{
	struct lsa_LUIDAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_luid;
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, pytalloc_get_mem_ctx(obj), &object->luid);
	return py_luid;
}

static int py_lsa_LUIDAttribute_set_luid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUIDAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->luid");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_LUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->luid = *(struct lsa_LUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LUIDAttribute_get_attribute(PyObject *obj, void *closure)
{
	struct lsa_LUIDAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_attribute;
	py_attribute = PyLong_FromUnsignedLongLong((uint32_t)(object->attribute));
	return py_attribute;
}

static int py_lsa_LUIDAttribute_set_attribute(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUIDAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->attribute");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attribute));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attribute = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_LUIDAttribute_getsetters[] = {
	{
		.name = discard_const_p(char, "luid"),
		.get = py_lsa_LUIDAttribute_get_luid,
		.set = py_lsa_LUIDAttribute_set_luid,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_LUID")
	},
	{
		.name = discard_const_p(char, "attribute"),
		.get = py_lsa_LUIDAttribute_get_attribute,
		.set = py_lsa_LUIDAttribute_set_attribute,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_LUIDAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_LUIDAttribute, type);
}


static PyTypeObject lsa_LUIDAttribute_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.LUIDAttribute",
	.tp_getset = py_lsa_LUIDAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_LUIDAttribute_new,
};


static PyObject *py_lsa_PrivilegeSet_get_count(PyObject *obj, void *closure)
{
	struct lsa_PrivilegeSet *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_PrivilegeSet_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivilegeSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_PrivilegeSet_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_PrivilegeSet *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown));
	return py_unknown;
}

static int py_lsa_PrivilegeSet_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivilegeSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_PrivilegeSet_get_set(PyObject *obj, void *closure)
{
	struct lsa_PrivilegeSet *object = pytalloc_get_ptr(obj);
	PyObject *py_set;
	py_set = PyList_New(object->count);
	if (py_set == NULL) {
		return NULL;
	}
	{
		int set_cntr_0;
		for (set_cntr_0 = 0; set_cntr_0 < (object->count); set_cntr_0++) {
			PyObject *py_set_0;
			py_set_0 = pytalloc_reference_ex(&lsa_LUIDAttribute_Type, object->set, &(object->set)[set_cntr_0]);
			PyList_SetItem(py_set, set_cntr_0, py_set_0);
		}
	}
	return py_set;
}

static int py_lsa_PrivilegeSet_set_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivilegeSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->set");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int set_cntr_0;
		object->set = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->set, PyList_GET_SIZE(value));
		if (!object->set) { return -1; }
		talloc_set_name_const(object->set, "ARRAY: object->set");
		for (set_cntr_0 = 0; set_cntr_0 < PyList_GET_SIZE(value); set_cntr_0++) {
			if (PyList_GET_ITEM(value, set_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->set)[set_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&lsa_LUIDAttribute_Type, PyList_GET_ITEM(value, set_cntr_0), return -1;);
			if (talloc_reference(object->set, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, set_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->set)[set_cntr_0] = *(struct lsa_LUIDAttribute *)pytalloc_get_ptr(PyList_GET_ITEM(value, set_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_PrivilegeSet_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_PrivilegeSet_get_count,
		.set = py_lsa_PrivilegeSet_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown"),
		.get = py_lsa_PrivilegeSet_get_unknown,
		.set = py_lsa_PrivilegeSet_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "set"),
		.get = py_lsa_PrivilegeSet_get_set,
		.set = py_lsa_PrivilegeSet_set_set,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_LUIDAttribute")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_PrivilegeSet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PrivilegeSet, type);
}


static PyTypeObject lsa_PrivilegeSet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.PrivilegeSet",
	.tp_getset = py_lsa_PrivilegeSet_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_PrivilegeSet_new,
};


static PyObject *py_lsa_DATA_BUF_get_length(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_lsa_DATA_BUF_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DATA_BUF_get_size(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_lsa_DATA_BUF_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DATA_BUF_get_data(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_lsa_DATA_BUF_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DATA_BUF_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_lsa_DATA_BUF_get_length,
		.set = py_lsa_DATA_BUF_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_lsa_DATA_BUF_get_size,
		.set = py_lsa_DATA_BUF_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_lsa_DATA_BUF_get_data,
		.set = py_lsa_DATA_BUF_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DATA_BUF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DATA_BUF, type);
}


static PyTypeObject lsa_DATA_BUF_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DATA_BUF",
	.tp_getset = py_lsa_DATA_BUF_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DATA_BUF_new,
};


static PyObject *py_lsa_DATA_BUF2_get_size(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF2 *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_lsa_DATA_BUF2_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DATA_BUF2_get_data(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF2 *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->size);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->size); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_lsa_DATA_BUF2_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DATA_BUF2_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_lsa_DATA_BUF2_get_size,
		.set = py_lsa_DATA_BUF2_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_lsa_DATA_BUF2_get_data,
		.set = py_lsa_DATA_BUF2_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DATA_BUF2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DATA_BUF2, type);
}


static PyTypeObject lsa_DATA_BUF2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DATA_BUF2",
	.tp_getset = py_lsa_DATA_BUF2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DATA_BUF2_new,
};


static PyObject *py_lsa_TrustDomainInfoName_get_netbios_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoName *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	py_netbios_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->netbios_name);
	return py_netbios_name;
}

static int py_lsa_TrustDomainInfoName_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->netbios_name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoName_getsetters[] = {
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_lsa_TrustDomainInfoName_get_netbios_name,
		.set = py_lsa_TrustDomainInfoName_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoName, type);
}


static PyTypeObject lsa_TrustDomainInfoName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoName",
	.tp_getset = py_lsa_TrustDomainInfoName_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoName_new,
};


static PyObject *py_lsa_TrustDomainInfoControllers_get_entries(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyLong_FromUnsignedLongLong((uint32_t)(object->entries));
	return py_entries;
}

static int py_lsa_TrustDomainInfoControllers_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoControllers_get_netbios_names(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_names;
	if (object->netbios_names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->netbios_names == NULL) {
		py_netbios_names = Py_None;
		Py_INCREF(py_netbios_names);
	} else {
		py_netbios_names = PyList_New(object->entries);
		if (py_netbios_names == NULL) {
			return NULL;
		}
		{
			int netbios_names_cntr_1;
			for (netbios_names_cntr_1 = 0; netbios_names_cntr_1 < (object->entries); netbios_names_cntr_1++) {
				PyObject *py_netbios_names_1;
				py_netbios_names_1 = pytalloc_reference_ex(&lsa_StringLarge_Type, object->netbios_names, &(object->netbios_names)[netbios_names_cntr_1]);
				PyList_SetItem(py_netbios_names, netbios_names_cntr_1, py_netbios_names_1);
			}
		}
	}
	return py_netbios_names;
}

static int py_lsa_TrustDomainInfoControllers_set_netbios_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->netbios_names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->netbios_names");
		return -1;
	}
	if (value == Py_None) {
		object->netbios_names = NULL;
	} else {
		object->netbios_names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int netbios_names_cntr_1;
			object->netbios_names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->netbios_names, PyList_GET_SIZE(value));
			if (!object->netbios_names) { return -1; }
			talloc_set_name_const(object->netbios_names, "ARRAY: object->netbios_names");
			for (netbios_names_cntr_1 = 0; netbios_names_cntr_1 < PyList_GET_SIZE(value); netbios_names_cntr_1++) {
				if (PyList_GET_ITEM(value, netbios_names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->netbios_names)[netbios_names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_StringLarge_Type, PyList_GET_ITEM(value, netbios_names_cntr_1), return -1;);
				if (talloc_reference(object->netbios_names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, netbios_names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->netbios_names)[netbios_names_cntr_1] = *(struct lsa_StringLarge *)pytalloc_get_ptr(PyList_GET_ITEM(value, netbios_names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoControllers_getsetters[] = {
	{
		.name = discard_const_p(char, "entries"),
		.get = py_lsa_TrustDomainInfoControllers_get_entries,
		.set = py_lsa_TrustDomainInfoControllers_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "netbios_names"),
		.get = py_lsa_TrustDomainInfoControllers_get_netbios_names,
		.set = py_lsa_TrustDomainInfoControllers_set_netbios_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoControllers_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoControllers, type);
}


static PyTypeObject lsa_TrustDomainInfoControllers_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoControllers",
	.tp_getset = py_lsa_TrustDomainInfoControllers_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoControllers_new,
};


static PyObject *py_lsa_TrustDomainInfoPosixOffset_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoPosixOffset *object = pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = PyLong_FromUnsignedLongLong((uint32_t)(object->posix_offset));
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoPosixOffset_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoPosixOffset *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->posix_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->posix_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->posix_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoPosixOffset_getsetters[] = {
	{
		.name = discard_const_p(char, "posix_offset"),
		.get = py_lsa_TrustDomainInfoPosixOffset_get_posix_offset,
		.set = py_lsa_TrustDomainInfoPosixOffset_set_posix_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoPosixOffset_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoPosixOffset, type);
}


static PyTypeObject lsa_TrustDomainInfoPosixOffset_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoPosixOffset",
	.tp_getset = py_lsa_TrustDomainInfoPosixOffset_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoPosixOffset_new,
};


static PyObject *py_lsa_TrustDomainInfoPassword_get_password(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		py_password = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->password, object->password);
	}
	return py_password;
}

static int py_lsa_TrustDomainInfoPassword_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->password));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->password");
		return -1;
	}
	if (value == Py_None) {
		object->password = NULL;
	} else {
		object->password = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->password = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoPassword_get_old_password(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = pytalloc_get_ptr(obj);
	PyObject *py_old_password;
	if (object->old_password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->old_password == NULL) {
		py_old_password = Py_None;
		Py_INCREF(py_old_password);
	} else {
		py_old_password = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->old_password, object->old_password);
	}
	return py_old_password;
}

static int py_lsa_TrustDomainInfoPassword_set_old_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->old_password));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->old_password");
		return -1;
	}
	if (value == Py_None) {
		object->old_password = NULL;
	} else {
		object->old_password = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->old_password = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoPassword_getsetters[] = {
	{
		.name = discard_const_p(char, "password"),
		.get = py_lsa_TrustDomainInfoPassword_get_password,
		.set = py_lsa_TrustDomainInfoPassword_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF")
	},
	{
		.name = discard_const_p(char, "old_password"),
		.get = py_lsa_TrustDomainInfoPassword_get_old_password,
		.set = py_lsa_TrustDomainInfoPassword_set_old_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoPassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoPassword, type);
}


static PyTypeObject lsa_TrustDomainInfoPassword_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoPassword",
	.tp_getset = py_lsa_TrustDomainInfoPassword_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoPassword_new,
};


static PyObject *py_lsa_TrustDomainInfoBasic_get_netbios_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	py_netbios_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->netbios_name);
	return py_netbios_name;
}

static int py_lsa_TrustDomainInfoBasic_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->netbios_name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoBasic_get_sid(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_TrustDomainInfoBasic_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoBasic_getsetters[] = {
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_lsa_TrustDomainInfoBasic_get_netbios_name,
		.set = py_lsa_TrustDomainInfoBasic_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_lsa_TrustDomainInfoBasic_get_sid,
		.set = py_lsa_TrustDomainInfoBasic_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoBasic_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoBasic, type);
}


static PyTypeObject lsa_TrustDomainInfoBasic_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoBasic",
	.tp_getset = py_lsa_TrustDomainInfoBasic_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoBasic_new,
};


static PyObject *py_lsa_TrustDomainInfoInfoEx_get_domain_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_lsa_TrustDomainInfoInfoEx_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_netbios_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	py_netbios_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->netbios_name);
	return py_netbios_name;
}

static int py_lsa_TrustDomainInfoInfoEx_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->netbios_name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_sid(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_TrustDomainInfoInfoEx_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_trust_direction(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_direction;
	py_trust_direction = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_direction));
	return py_trust_direction;
}

static int py_lsa_TrustDomainInfoInfoEx_set_trust_direction(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->trust_direction");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_direction));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_direction = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_trust_type(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_type));
	return py_trust_type;
}

static int py_lsa_TrustDomainInfoInfoEx_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->trust_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_trust_attributes(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_attributes));
	return py_trust_attributes;
}

static int py_lsa_TrustDomainInfoInfoEx_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->trust_attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoInfoEx_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_lsa_TrustDomainInfoInfoEx_get_domain_name,
		.set = py_lsa_TrustDomainInfoInfoEx_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_lsa_TrustDomainInfoInfoEx_get_netbios_name,
		.set = py_lsa_TrustDomainInfoInfoEx_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_lsa_TrustDomainInfoInfoEx_get_sid,
		.set = py_lsa_TrustDomainInfoInfoEx_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "trust_direction"),
		.get = py_lsa_TrustDomainInfoInfoEx_get_trust_direction,
		.set = py_lsa_TrustDomainInfoInfoEx_set_trust_direction,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDirection")
	},
	{
		.name = discard_const_p(char, "trust_type"),
		.get = py_lsa_TrustDomainInfoInfoEx_get_trust_type,
		.set = py_lsa_TrustDomainInfoInfoEx_set_trust_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustType")
	},
	{
		.name = discard_const_p(char, "trust_attributes"),
		.get = py_lsa_TrustDomainInfoInfoEx_get_trust_attributes,
		.set = py_lsa_TrustDomainInfoInfoEx_set_trust_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustAttributes")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoInfoEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoInfoEx, type);
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_TrustDomainInfoInfoEx);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TrustDomainInfoInfoEx);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TrustDomainInfoInfoEx);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_TrustDomainInfoInfoEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_TrustDomainInfoInfoEx, "lsa_TrustDomainInfoInfoEx", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_TrustDomainInfoInfoEx_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_TrustDomainInfoInfoEx_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_TrustDomainInfoInfoEx_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_TrustDomainInfoInfoEx_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_TrustDomainInfoInfoEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoInfoEx",
	.tp_getset = py_lsa_TrustDomainInfoInfoEx_getsetters,
	.tp_methods = py_lsa_TrustDomainInfoInfoEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoInfoEx_new,
};


static PyObject *py_lsa_TrustDomainInfoBuffer_get_last_update_time(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_last_update_time;
	py_last_update_time = PyLong_FromUnsignedLongLong(object->last_update_time);
	return py_last_update_time;
}

static int py_lsa_TrustDomainInfoBuffer_set_last_update_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->last_update_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_update_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_update_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoBuffer_get_AuthType(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_AuthType;
	py_AuthType = PyLong_FromUnsignedLongLong((uint32_t)(object->AuthType));
	return py_AuthType;
}

static int py_lsa_TrustDomainInfoBuffer_set_AuthType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->AuthType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AuthType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AuthType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoBuffer_get_data(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pytalloc_reference_ex(&lsa_DATA_BUF2_Type, pytalloc_get_mem_ctx(obj), &object->data);
	return py_data;
}

static int py_lsa_TrustDomainInfoBuffer_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_DATA_BUF2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->data = *(struct lsa_DATA_BUF2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoBuffer_getsetters[] = {
	{
		.name = discard_const_p(char, "last_update_time"),
		.get = py_lsa_TrustDomainInfoBuffer_get_last_update_time,
		.set = py_lsa_TrustDomainInfoBuffer_set_last_update_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "AuthType"),
		.get = py_lsa_TrustDomainInfoBuffer_get_AuthType,
		.set = py_lsa_TrustDomainInfoBuffer_set_AuthType,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustAuthType")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_lsa_TrustDomainInfoBuffer_get_data,
		.set = py_lsa_TrustDomainInfoBuffer_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoBuffer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoBuffer, type);
}


static PyTypeObject lsa_TrustDomainInfoBuffer_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoBuffer",
	.tp_getset = py_lsa_TrustDomainInfoBuffer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoBuffer_new,
};


static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_incoming_count(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_incoming_count;
	py_incoming_count = PyLong_FromUnsignedLongLong((uint32_t)(object->incoming_count));
	return py_incoming_count;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_incoming_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->incoming_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->incoming_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->incoming_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_incoming_current_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_incoming_current_auth_info;
	if (object->incoming_current_auth_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->incoming_current_auth_info == NULL) {
		py_incoming_current_auth_info = Py_None;
		Py_INCREF(py_incoming_current_auth_info);
	} else {
		py_incoming_current_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->incoming_current_auth_info, object->incoming_current_auth_info);
	}
	return py_incoming_current_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_incoming_current_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->incoming_current_auth_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->incoming_current_auth_info");
		return -1;
	}
	if (value == Py_None) {
		object->incoming_current_auth_info = NULL;
	} else {
		object->incoming_current_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->incoming_current_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_incoming_previous_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_incoming_previous_auth_info;
	if (object->incoming_previous_auth_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->incoming_previous_auth_info == NULL) {
		py_incoming_previous_auth_info = Py_None;
		Py_INCREF(py_incoming_previous_auth_info);
	} else {
		py_incoming_previous_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->incoming_previous_auth_info, object->incoming_previous_auth_info);
	}
	return py_incoming_previous_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_incoming_previous_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->incoming_previous_auth_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->incoming_previous_auth_info");
		return -1;
	}
	if (value == Py_None) {
		object->incoming_previous_auth_info = NULL;
	} else {
		object->incoming_previous_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->incoming_previous_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_outgoing_count(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_outgoing_count;
	py_outgoing_count = PyLong_FromUnsignedLongLong((uint32_t)(object->outgoing_count));
	return py_outgoing_count;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_outgoing_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->outgoing_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->outgoing_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->outgoing_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_outgoing_current_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_outgoing_current_auth_info;
	if (object->outgoing_current_auth_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->outgoing_current_auth_info == NULL) {
		py_outgoing_current_auth_info = Py_None;
		Py_INCREF(py_outgoing_current_auth_info);
	} else {
		py_outgoing_current_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->outgoing_current_auth_info, object->outgoing_current_auth_info);
	}
	return py_outgoing_current_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_outgoing_current_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->outgoing_current_auth_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->outgoing_current_auth_info");
		return -1;
	}
	if (value == Py_None) {
		object->outgoing_current_auth_info = NULL;
	} else {
		object->outgoing_current_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->outgoing_current_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_outgoing_previous_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_outgoing_previous_auth_info;
	if (object->outgoing_previous_auth_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->outgoing_previous_auth_info == NULL) {
		py_outgoing_previous_auth_info = Py_None;
		Py_INCREF(py_outgoing_previous_auth_info);
	} else {
		py_outgoing_previous_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->outgoing_previous_auth_info, object->outgoing_previous_auth_info);
	}
	return py_outgoing_previous_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_outgoing_previous_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->outgoing_previous_auth_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->outgoing_previous_auth_info");
		return -1;
	}
	if (value == Py_None) {
		object->outgoing_previous_auth_info = NULL;
	} else {
		object->outgoing_previous_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->outgoing_previous_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoAuthInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "incoming_count"),
		.get = py_lsa_TrustDomainInfoAuthInfo_get_incoming_count,
		.set = py_lsa_TrustDomainInfoAuthInfo_set_incoming_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "incoming_current_auth_info"),
		.get = py_lsa_TrustDomainInfoAuthInfo_get_incoming_current_auth_info,
		.set = py_lsa_TrustDomainInfoAuthInfo_set_incoming_current_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoBuffer")
	},
	{
		.name = discard_const_p(char, "incoming_previous_auth_info"),
		.get = py_lsa_TrustDomainInfoAuthInfo_get_incoming_previous_auth_info,
		.set = py_lsa_TrustDomainInfoAuthInfo_set_incoming_previous_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoBuffer")
	},
	{
		.name = discard_const_p(char, "outgoing_count"),
		.get = py_lsa_TrustDomainInfoAuthInfo_get_outgoing_count,
		.set = py_lsa_TrustDomainInfoAuthInfo_set_outgoing_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "outgoing_current_auth_info"),
		.get = py_lsa_TrustDomainInfoAuthInfo_get_outgoing_current_auth_info,
		.set = py_lsa_TrustDomainInfoAuthInfo_set_outgoing_current_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoBuffer")
	},
	{
		.name = discard_const_p(char, "outgoing_previous_auth_info"),
		.get = py_lsa_TrustDomainInfoAuthInfo_get_outgoing_previous_auth_info,
		.set = py_lsa_TrustDomainInfoAuthInfo_set_outgoing_previous_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoBuffer")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoAuthInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoAuthInfo, type);
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_TrustDomainInfoAuthInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TrustDomainInfoAuthInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TrustDomainInfoAuthInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_TrustDomainInfoAuthInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_TrustDomainInfoAuthInfo, "lsa_TrustDomainInfoAuthInfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_TrustDomainInfoAuthInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_TrustDomainInfoAuthInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_TrustDomainInfoAuthInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_TrustDomainInfoAuthInfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_TrustDomainInfoAuthInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoAuthInfo",
	.tp_getset = py_lsa_TrustDomainInfoAuthInfo_getsetters,
	.tp_methods = py_lsa_TrustDomainInfoAuthInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoAuthInfo_new,
};


static PyObject *py_lsa_TrustDomainInfoFullInfo_get_info_ex(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ex;
	py_info_ex = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->info_ex);
	return py_info_ex;
}

static int py_lsa_TrustDomainInfoFullInfo_set_info_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info_ex");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, pytalloc_get_mem_ctx(obj), &object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoFullInfo_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->posix_offset");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo_get_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfo_Type, pytalloc_get_mem_ctx(obj), &object->auth_info);
	return py_auth_info;
}

static int py_lsa_TrustDomainInfoFullInfo_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->auth_info");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_info = *(struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoFullInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "info_ex"),
		.get = py_lsa_TrustDomainInfoFullInfo_get_info_ex,
		.set = py_lsa_TrustDomainInfoFullInfo_set_info_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoInfoEx")
	},
	{
		.name = discard_const_p(char, "posix_offset"),
		.get = py_lsa_TrustDomainInfoFullInfo_get_posix_offset,
		.set = py_lsa_TrustDomainInfoFullInfo_set_posix_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoPosixOffset")
	},
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_lsa_TrustDomainInfoFullInfo_get_auth_info,
		.set = py_lsa_TrustDomainInfoFullInfo_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoAuthInfo")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoFullInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoFullInfo, type);
}


static PyTypeObject lsa_TrustDomainInfoFullInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoFullInfo",
	.tp_getset = py_lsa_TrustDomainInfoFullInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoFullInfo_new,
};


static PyObject *py_lsa_TrustDomainInfoAuthInfoInternal_get_auth_blob(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternal *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_blob;
	py_auth_blob = pytalloc_reference_ex(&lsa_DATA_BUF2_Type, pytalloc_get_mem_ctx(obj), &object->auth_blob);
	return py_auth_blob;
}

static int py_lsa_TrustDomainInfoAuthInfoInternal_set_auth_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->auth_blob");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_DATA_BUF2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_blob = *(struct lsa_DATA_BUF2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoAuthInfoInternal_getsetters[] = {
	{
		.name = discard_const_p(char, "auth_blob"),
		.get = py_lsa_TrustDomainInfoAuthInfoInternal_get_auth_blob,
		.set = py_lsa_TrustDomainInfoAuthInfoInternal_set_auth_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoAuthInfoInternal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoAuthInfoInternal, type);
}


static PyTypeObject lsa_TrustDomainInfoAuthInfoInternal_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoAuthInfoInternal",
	.tp_getset = py_lsa_TrustDomainInfoAuthInfoInternal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoAuthInfoInternal_new,
};


static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_get_info_ex(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ex;
	py_info_ex = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->info_ex);
	return py_info_ex;
}

static int py_lsa_TrustDomainInfoFullInfoInternal_set_info_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info_ex");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, pytalloc_get_mem_ctx(obj), &object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoFullInfoInternal_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->posix_offset");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_get_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfoInternal_Type, pytalloc_get_mem_ctx(obj), &object->auth_info);
	return py_auth_info;
}

static int py_lsa_TrustDomainInfoFullInfoInternal_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->auth_info");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfoInternal_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_info = *(struct lsa_TrustDomainInfoAuthInfoInternal *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoFullInfoInternal_getsetters[] = {
	{
		.name = discard_const_p(char, "info_ex"),
		.get = py_lsa_TrustDomainInfoFullInfoInternal_get_info_ex,
		.set = py_lsa_TrustDomainInfoFullInfoInternal_set_info_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoInfoEx")
	},
	{
		.name = discard_const_p(char, "posix_offset"),
		.get = py_lsa_TrustDomainInfoFullInfoInternal_get_posix_offset,
		.set = py_lsa_TrustDomainInfoFullInfoInternal_set_posix_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoPosixOffset")
	},
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_lsa_TrustDomainInfoFullInfoInternal_get_auth_info,
		.set = py_lsa_TrustDomainInfoFullInfoInternal_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoAuthInfoInternal")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoFullInfoInternal, type);
}


static PyTypeObject lsa_TrustDomainInfoFullInfoInternal_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoFullInfoInternal",
	.tp_getset = py_lsa_TrustDomainInfoFullInfoInternal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoFullInfoInternal_new,
};


static PyObject *py_lsa_TrustDomainInfoAuthInfoInternalAES_get_auth_data(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternalAES *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_data;
	py_auth_data = PyList_New(64);
	if (py_auth_data == NULL) {
		return NULL;
	}
	{
		int auth_data_cntr_0;
		for (auth_data_cntr_0 = 0; auth_data_cntr_0 < (64); auth_data_cntr_0++) {
			PyObject *py_auth_data_0;
			py_auth_data_0 = PyLong_FromLong((uint16_t)((object->auth_data)[auth_data_cntr_0]));
			PyList_SetItem(py_auth_data, auth_data_cntr_0, py_auth_data_0);
		}
	}
	return py_auth_data;
}

static int py_lsa_TrustDomainInfoAuthInfoInternalAES_set_auth_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternalAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->auth_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int auth_data_cntr_0;
		if (ARRAY_SIZE(object->auth_data) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->auth_data),  PyList_GET_SIZE(value));
			return -1;
		}
		for (auth_data_cntr_0 = 0; auth_data_cntr_0 < PyList_GET_SIZE(value); auth_data_cntr_0++) {
			if (PyList_GET_ITEM(value, auth_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->auth_data)[auth_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->auth_data)[auth_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, auth_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, auth_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->auth_data)[auth_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfoInternalAES_get_salt(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternalAES *object = pytalloc_get_ptr(obj);
	PyObject *py_salt;
	py_salt = PyList_New(16);
	if (py_salt == NULL) {
		return NULL;
	}
	{
		int salt_cntr_0;
		for (salt_cntr_0 = 0; salt_cntr_0 < (16); salt_cntr_0++) {
			PyObject *py_salt_0;
			py_salt_0 = PyLong_FromLong((uint16_t)((object->salt)[salt_cntr_0]));
			PyList_SetItem(py_salt, salt_cntr_0, py_salt_0);
		}
	}
	return py_salt;
}

static int py_lsa_TrustDomainInfoAuthInfoInternalAES_set_salt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternalAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->salt");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int salt_cntr_0;
		if (ARRAY_SIZE(object->salt) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->salt),  PyList_GET_SIZE(value));
			return -1;
		}
		for (salt_cntr_0 = 0; salt_cntr_0 < PyList_GET_SIZE(value); salt_cntr_0++) {
			if (PyList_GET_ITEM(value, salt_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->salt)[salt_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->salt)[salt_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, salt_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, salt_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->salt)[salt_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfoInternalAES_get_cipher(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternalAES *object = pytalloc_get_ptr(obj);
	PyObject *py_cipher;
	py_cipher = pytalloc_reference_ex(&lsa_DATA_BUF2_Type, pytalloc_get_mem_ctx(obj), &object->cipher);
	return py_cipher;
}

static int py_lsa_TrustDomainInfoAuthInfoInternalAES_set_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternalAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cipher");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_DATA_BUF2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->cipher = *(struct lsa_DATA_BUF2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoAuthInfoInternalAES_getsetters[] = {
	{
		.name = discard_const_p(char, "auth_data"),
		.get = py_lsa_TrustDomainInfoAuthInfoInternalAES_get_auth_data,
		.set = py_lsa_TrustDomainInfoAuthInfoInternalAES_set_auth_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "salt"),
		.get = py_lsa_TrustDomainInfoAuthInfoInternalAES_get_salt,
		.set = py_lsa_TrustDomainInfoAuthInfoInternalAES_set_salt,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "cipher"),
		.get = py_lsa_TrustDomainInfoAuthInfoInternalAES_get_cipher,
		.set = py_lsa_TrustDomainInfoAuthInfoInternalAES_set_cipher,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoAuthInfoInternalAES_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoAuthInfoInternalAES, type);
}


static PyTypeObject lsa_TrustDomainInfoAuthInfoInternalAES_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoAuthInfoInternalAES",
	.tp_getset = py_lsa_TrustDomainInfoAuthInfoInternalAES_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoAuthInfoInternalAES_new,
};


static PyObject *py_lsa_TrustDomainInfoFullInfoInternalAES_get_info_ex(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternalAES *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ex;
	py_info_ex = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->info_ex);
	return py_info_ex;
}

static int py_lsa_TrustDomainInfoFullInfoInternalAES_set_info_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternalAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info_ex");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfoInternalAES_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternalAES *object = pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, pytalloc_get_mem_ctx(obj), &object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoFullInfoInternalAES_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternalAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->posix_offset");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfoInternalAES_get_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternalAES *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfoInternalAES_Type, pytalloc_get_mem_ctx(obj), &object->auth_info);
	return py_auth_info;
}

static int py_lsa_TrustDomainInfoFullInfoInternalAES_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternalAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->auth_info");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfoInternalAES_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_info = *(struct lsa_TrustDomainInfoAuthInfoInternalAES *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoFullInfoInternalAES_getsetters[] = {
	{
		.name = discard_const_p(char, "info_ex"),
		.get = py_lsa_TrustDomainInfoFullInfoInternalAES_get_info_ex,
		.set = py_lsa_TrustDomainInfoFullInfoInternalAES_set_info_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoInfoEx")
	},
	{
		.name = discard_const_p(char, "posix_offset"),
		.get = py_lsa_TrustDomainInfoFullInfoInternalAES_get_posix_offset,
		.set = py_lsa_TrustDomainInfoFullInfoInternalAES_set_posix_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoPosixOffset")
	},
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_lsa_TrustDomainInfoFullInfoInternalAES_get_auth_info,
		.set = py_lsa_TrustDomainInfoFullInfoInternalAES_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoAuthInfoInternalAES")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoFullInfoInternalAES_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoFullInfoInternalAES, type);
}


static PyTypeObject lsa_TrustDomainInfoFullInfoInternalAES_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoFullInfoInternalAES",
	.tp_getset = py_lsa_TrustDomainInfoFullInfoInternalAES_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoFullInfoInternalAES_new,
};


static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_get_info_ex(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ex;
	py_info_ex = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->info_ex);
	return py_info_ex;
}

static int py_lsa_TrustDomainInfoInfoEx2Internal_set_info_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info_ex");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_length(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_length;
	py_forest_trust_length = PyLong_FromUnsignedLongLong((uint32_t)(object->forest_trust_length));
	return py_forest_trust_length;
}

static int py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_trust_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->forest_trust_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->forest_trust_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_data(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_data;
	if (object->forest_trust_data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->forest_trust_data == NULL) {
		py_forest_trust_data = Py_None;
		Py_INCREF(py_forest_trust_data);
	} else {
		py_forest_trust_data = PyList_New(object->forest_trust_length);
		if (py_forest_trust_data == NULL) {
			return NULL;
		}
		{
			int forest_trust_data_cntr_1;
			for (forest_trust_data_cntr_1 = 0; forest_trust_data_cntr_1 < (object->forest_trust_length); forest_trust_data_cntr_1++) {
				PyObject *py_forest_trust_data_1;
				py_forest_trust_data_1 = PyLong_FromLong((uint16_t)((object->forest_trust_data)[forest_trust_data_cntr_1]));
				PyList_SetItem(py_forest_trust_data, forest_trust_data_cntr_1, py_forest_trust_data_1);
			}
		}
	}
	return py_forest_trust_data;
}

static int py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->forest_trust_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_trust_data");
		return -1;
	}
	if (value == Py_None) {
		object->forest_trust_data = NULL;
	} else {
		object->forest_trust_data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int forest_trust_data_cntr_1;
			object->forest_trust_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->forest_trust_data, PyList_GET_SIZE(value));
			if (!object->forest_trust_data) { return -1; }
			talloc_set_name_const(object->forest_trust_data, "ARRAY: object->forest_trust_data");
			for (forest_trust_data_cntr_1 = 0; forest_trust_data_cntr_1 < PyList_GET_SIZE(value); forest_trust_data_cntr_1++) {
				if (PyList_GET_ITEM(value, forest_trust_data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->forest_trust_data)[forest_trust_data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->forest_trust_data)[forest_trust_data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, forest_trust_data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, forest_trust_data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->forest_trust_data)[forest_trust_data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoInfoEx2Internal_getsetters[] = {
	{
		.name = discard_const_p(char, "info_ex"),
		.get = py_lsa_TrustDomainInfoInfoEx2Internal_get_info_ex,
		.set = py_lsa_TrustDomainInfoInfoEx2Internal_set_info_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoInfoEx")
	},
	{
		.name = discard_const_p(char, "forest_trust_length"),
		.get = py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_length,
		.set = py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "forest_trust_data"),
		.get = py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_data,
		.set = py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoInfoEx2Internal, type);
}


static PyTypeObject lsa_TrustDomainInfoInfoEx2Internal_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoInfoEx2Internal",
	.tp_getset = py_lsa_TrustDomainInfoInfoEx2Internal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoInfoEx2Internal_new,
};


static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_get_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx2Internal_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_lsa_TrustDomainInfoFullInfo2Internal_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx2Internal_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, pytalloc_get_mem_ctx(obj), &object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoFullInfo2Internal_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->posix_offset");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_get_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfo_Type, pytalloc_get_mem_ctx(obj), &object->auth_info);
	return py_auth_info;
}

static int py_lsa_TrustDomainInfoFullInfo2Internal_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->auth_info");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_info = *(struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoFullInfo2Internal_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_lsa_TrustDomainInfoFullInfo2Internal_get_info,
		.set = py_lsa_TrustDomainInfoFullInfo2Internal_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoInfoEx2Internal")
	},
	{
		.name = discard_const_p(char, "posix_offset"),
		.get = py_lsa_TrustDomainInfoFullInfo2Internal_get_posix_offset,
		.set = py_lsa_TrustDomainInfoFullInfo2Internal_set_posix_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoPosixOffset")
	},
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_lsa_TrustDomainInfoFullInfo2Internal_get_auth_info,
		.set = py_lsa_TrustDomainInfoFullInfo2Internal_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoAuthInfo")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoFullInfo2Internal, type);
}


static PyTypeObject lsa_TrustDomainInfoFullInfo2Internal_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoFullInfo2Internal",
	.tp_getset = py_lsa_TrustDomainInfoFullInfo2Internal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoFullInfo2Internal_new,
};


static PyObject *py_lsa_TrustDomainInfoSupportedEncTypes_get_enc_types(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoSupportedEncTypes *object = pytalloc_get_ptr(obj);
	PyObject *py_enc_types;
	py_enc_types = PyLong_FromUnsignedLongLong((uint32_t)(object->enc_types));
	return py_enc_types;
}

static int py_lsa_TrustDomainInfoSupportedEncTypes_set_enc_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoSupportedEncTypes *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->enc_types");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enc_types));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enc_types = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoSupportedEncTypes_getsetters[] = {
	{
		.name = discard_const_p(char, "enc_types"),
		.get = py_lsa_TrustDomainInfoSupportedEncTypes_get_enc_types,
		.set = py_lsa_TrustDomainInfoSupportedEncTypes_set_enc_types,
		.doc = discard_const_p(char, "PIDL-generated element of base type kerb_EncTypes")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TrustDomainInfoSupportedEncTypes_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoSupportedEncTypes, type);
}


static PyTypeObject lsa_TrustDomainInfoSupportedEncTypes_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustDomainInfoSupportedEncTypes",
	.tp_getset = py_lsa_TrustDomainInfoSupportedEncTypes_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustDomainInfoSupportedEncTypes_new,
};

static PyObject *py_import_lsa_TrustedDomainInfo(TALLOC_CTX *mem_ctx, int level, union lsa_TrustedDomainInfo *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoName_Type, mem_ctx, &in->name);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoControllers_Type, mem_ctx, &in->controllers);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, mem_ctx, &in->posix_offset);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoPassword_Type, mem_ctx, &in->password);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoBasic_Type, mem_ctx, &in->info_basic);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, mem_ctx, &in->info_ex);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfo_Type, mem_ctx, &in->auth_info);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoFullInfo_Type, mem_ctx, &in->full_info);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfoInternal_Type, mem_ctx, &in->auth_info_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoFullInfoInternal_Type, mem_ctx, &in->full_info_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx2Internal_Type, mem_ctx, &in->info_ex2_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoFullInfo2Internal_Type, mem_ctx, &in->full_info2_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoSupportedEncTypes_Type, mem_ctx, &in->enc_types);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfoInternalAES_Type, mem_ctx, &in->auth_info_internal_aes);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoFullInfoInternalAES_Type, mem_ctx, &in->full_info_internal_aes);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union lsa_TrustedDomainInfo *py_export_lsa_TrustedDomainInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_TrustedDomainInfo *ret = talloc_zero(mem_ctx, union lsa_TrustedDomainInfo);
	switch (level) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoName_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct lsa_TrustDomainInfoName *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->controllers");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoControllers_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->controllers = *(struct lsa_TrustDomainInfoControllers *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->posix_offset");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->password");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoPassword_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->password = *(struct lsa_TrustDomainInfoPassword *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info_basic");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoBasic_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info_basic = *(struct lsa_TrustDomainInfoBasic *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info_ex");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->auth_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auth_info = *(struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->full_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoFullInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_info = *(struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->auth_info_internal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfoInternal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auth_info_internal = *(struct lsa_TrustDomainInfoAuthInfoInternal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->full_info_internal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoFullInfoInternal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_info_internal = *(struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info_ex2_internal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx2Internal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info_ex2_internal = *(struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->full_info2_internal");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoFullInfo2Internal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_info2_internal = *(struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->enc_types");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoSupportedEncTypes_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->enc_types = *(struct lsa_TrustDomainInfoSupportedEncTypes *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL_AES:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->auth_info_internal_aes");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfoInternalAES_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auth_info_internal_aes = *(struct lsa_TrustDomainInfoAuthInfoInternalAES *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL_AES:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->full_info_internal_aes");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_TrustDomainInfoFullInfoInternalAES_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_info_internal_aes = *(struct lsa_TrustDomainInfoFullInfoInternalAES *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_lsa_TrustedDomainInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union lsa_TrustedDomainInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union lsa_TrustedDomainInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union lsa_TrustedDomainInfo!");
		return NULL;
	}

	return py_import_lsa_TrustedDomainInfo(mem_ctx, level, in);
}

static PyObject *py_lsa_TrustedDomainInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union lsa_TrustedDomainInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_lsa_TrustedDomainInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_lsa_TrustedDomainInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_TrustedDomainInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_TrustedDomainInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_lsa_TrustedDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject lsa_TrustedDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TrustedDomainInfo",
	.tp_getset = NULL,
	.tp_methods = py_lsa_TrustedDomainInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TrustedDomainInfo_new,
};


static PyObject *py_lsa_DATA_BUF_PTR_get_buf(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF_PTR *object = pytalloc_get_ptr(obj);
	PyObject *py_buf;
	if (object->buf == NULL) {
		Py_RETURN_NONE;
	}
	if (object->buf == NULL) {
		py_buf = Py_None;
		Py_INCREF(py_buf);
	} else {
		py_buf = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->buf, object->buf);
	}
	return py_buf;
}

static int py_lsa_DATA_BUF_PTR_set_buf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF_PTR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->buf));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->buf");
		return -1;
	}
	if (value == Py_None) {
		object->buf = NULL;
	} else {
		object->buf = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->buf = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_DATA_BUF_PTR_getsetters[] = {
	{
		.name = discard_const_p(char, "buf"),
		.get = py_lsa_DATA_BUF_PTR_get_buf,
		.set = py_lsa_DATA_BUF_PTR_set_buf,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DATA_BUF_PTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DATA_BUF_PTR, type);
}


static PyTypeObject lsa_DATA_BUF_PTR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DATA_BUF_PTR",
	.tp_getset = py_lsa_DATA_BUF_PTR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DATA_BUF_PTR_new,
};


static PyObject *py_lsa_RightAttribute_get_name(PyObject *obj, void *closure)
{
	struct lsa_RightAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_lsa_RightAttribute_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RightAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_RightAttribute_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_RightAttribute_get_name,
		.set = py_lsa_RightAttribute_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_RightAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_RightAttribute, type);
}


static PyTypeObject lsa_RightAttribute_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.RightAttribute",
	.tp_getset = py_lsa_RightAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_RightAttribute_new,
};


static PyObject *py_lsa_RightSet_get_count(PyObject *obj, void *closure)
{
	struct lsa_RightSet *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_RightSet_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RightSet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_RightSet_get_names(PyObject *obj, void *closure)
{
	struct lsa_RightSet *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < (object->count); names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_StringLarge_Type, object->names, &(object->names)[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_RightSet_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RightSet *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->names");
		return -1;
	}
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				if (PyList_GET_ITEM(value, names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->names)[names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_StringLarge_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->names)[names_cntr_1] = *(struct lsa_StringLarge *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_RightSet_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_RightSet_get_count,
		.set = py_lsa_RightSet_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "names"),
		.get = py_lsa_RightSet_get_names,
		.set = py_lsa_RightSet_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_RightSet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_RightSet, type);
}


static PyTypeObject lsa_RightSet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.RightSet",
	.tp_getset = py_lsa_RightSet_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_RightSet_new,
};


static PyObject *py_lsa_DomainListEx_get_count(PyObject *obj, void *closure)
{
	struct lsa_DomainListEx *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_DomainListEx_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainListEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainListEx_get_domains(PyObject *obj, void *closure)
{
	struct lsa_DomainListEx *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->domains == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = PyList_New(object->count);
		if (py_domains == NULL) {
			return NULL;
		}
		{
			int domains_cntr_1;
			for (domains_cntr_1 = 0; domains_cntr_1 < (object->count); domains_cntr_1++) {
				PyObject *py_domains_1;
				py_domains_1 = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, object->domains, &(object->domains)[domains_cntr_1]);
				PyList_SetItem(py_domains, domains_cntr_1, py_domains_1);
			}
		}
	}
	return py_domains;
}

static int py_lsa_DomainListEx_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainListEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domains");
		return -1;
	}
	if (value == Py_None) {
		object->domains = NULL;
	} else {
		object->domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int domains_cntr_1;
			object->domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->domains, PyList_GET_SIZE(value));
			if (!object->domains) { return -1; }
			talloc_set_name_const(object->domains, "ARRAY: object->domains");
			for (domains_cntr_1 = 0; domains_cntr_1 < PyList_GET_SIZE(value); domains_cntr_1++) {
				if (PyList_GET_ITEM(value, domains_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->domains)[domains_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, PyList_GET_ITEM(value, domains_cntr_1), return -1;);
				if (talloc_reference(object->domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->domains)[domains_cntr_1] = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(PyList_GET_ITEM(value, domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainListEx_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_DomainListEx_get_count,
		.set = py_lsa_DomainListEx_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domains"),
		.get = py_lsa_DomainListEx_get_domains,
		.set = py_lsa_DomainListEx_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomainInfoInfoEx")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DomainListEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainListEx, type);
}


static PyTypeObject lsa_DomainListEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DomainListEx",
	.tp_getset = py_lsa_DomainListEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DomainListEx_new,
};


static PyObject *py_lsa_DomainInfoQoS_get_quality_of_service(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoQoS *object = pytalloc_get_ptr(obj);
	PyObject *py_quality_of_service;
	py_quality_of_service = PyLong_FromUnsignedLongLong((uint32_t)(object->quality_of_service));
	return py_quality_of_service;
}

static int py_lsa_DomainInfoQoS_set_quality_of_service(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoQoS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->quality_of_service");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->quality_of_service));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->quality_of_service = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainInfoQoS_getsetters[] = {
	{
		.name = discard_const_p(char, "quality_of_service"),
		.get = py_lsa_DomainInfoQoS_get_quality_of_service,
		.set = py_lsa_DomainInfoQoS_set_quality_of_service,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DomainInfoQoS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainInfoQoS, type);
}


static PyTypeObject lsa_DomainInfoQoS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DomainInfoQoS",
	.tp_getset = py_lsa_DomainInfoQoS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DomainInfoQoS_new,
};


static PyObject *py_lsa_DomainInfoKerberos_get_authentication_options(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_authentication_options;
	py_authentication_options = PyLong_FromUnsignedLongLong((uint32_t)(object->authentication_options));
	return py_authentication_options;
}

static int py_lsa_DomainInfoKerberos_set_authentication_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->authentication_options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->authentication_options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->authentication_options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_service_tkt_lifetime(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_service_tkt_lifetime;
	py_service_tkt_lifetime = PyLong_FromUnsignedLongLong(object->service_tkt_lifetime);
	return py_service_tkt_lifetime;
}

static int py_lsa_DomainInfoKerberos_set_service_tkt_lifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->service_tkt_lifetime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->service_tkt_lifetime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->service_tkt_lifetime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_user_tkt_lifetime(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_user_tkt_lifetime;
	py_user_tkt_lifetime = PyLong_FromUnsignedLongLong(object->user_tkt_lifetime);
	return py_user_tkt_lifetime;
}

static int py_lsa_DomainInfoKerberos_set_user_tkt_lifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user_tkt_lifetime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_tkt_lifetime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_tkt_lifetime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_user_tkt_renewaltime(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_user_tkt_renewaltime;
	py_user_tkt_renewaltime = PyLong_FromUnsignedLongLong(object->user_tkt_renewaltime);
	return py_user_tkt_renewaltime;
}

static int py_lsa_DomainInfoKerberos_set_user_tkt_renewaltime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->user_tkt_renewaltime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_tkt_renewaltime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_tkt_renewaltime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_clock_skew(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_clock_skew;
	py_clock_skew = PyLong_FromUnsignedLongLong(object->clock_skew);
	return py_clock_skew;
}

static int py_lsa_DomainInfoKerberos_set_clock_skew(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->clock_skew");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->clock_skew));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->clock_skew = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_reserved(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong(object->reserved);
	return py_reserved;
}

static int py_lsa_DomainInfoKerberos_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainInfoKerberos_getsetters[] = {
	{
		.name = discard_const_p(char, "authentication_options"),
		.get = py_lsa_DomainInfoKerberos_get_authentication_options,
		.set = py_lsa_DomainInfoKerberos_set_authentication_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_krbAuthenticationOptions")
	},
	{
		.name = discard_const_p(char, "service_tkt_lifetime"),
		.get = py_lsa_DomainInfoKerberos_get_service_tkt_lifetime,
		.set = py_lsa_DomainInfoKerberos_set_service_tkt_lifetime,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "user_tkt_lifetime"),
		.get = py_lsa_DomainInfoKerberos_get_user_tkt_lifetime,
		.set = py_lsa_DomainInfoKerberos_set_user_tkt_lifetime,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "user_tkt_renewaltime"),
		.get = py_lsa_DomainInfoKerberos_get_user_tkt_renewaltime,
		.set = py_lsa_DomainInfoKerberos_set_user_tkt_renewaltime,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "clock_skew"),
		.get = py_lsa_DomainInfoKerberos_get_clock_skew,
		.set = py_lsa_DomainInfoKerberos_set_clock_skew,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_lsa_DomainInfoKerberos_get_reserved,
		.set = py_lsa_DomainInfoKerberos_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DomainInfoKerberos_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainInfoKerberos, type);
}


static PyTypeObject lsa_DomainInfoKerberos_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DomainInfoKerberos",
	.tp_getset = py_lsa_DomainInfoKerberos_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DomainInfoKerberos_new,
};


static PyObject *py_lsa_DomainInfoEfs_get_blob_size(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoEfs *object = pytalloc_get_ptr(obj);
	PyObject *py_blob_size;
	py_blob_size = PyLong_FromUnsignedLongLong((uint32_t)(object->blob_size));
	return py_blob_size;
}

static int py_lsa_DomainInfoEfs_set_blob_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoEfs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->blob_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->blob_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->blob_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoEfs_get_efs_blob(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoEfs *object = pytalloc_get_ptr(obj);
	PyObject *py_efs_blob;
	if (object->efs_blob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->efs_blob == NULL) {
		py_efs_blob = Py_None;
		Py_INCREF(py_efs_blob);
	} else {
		py_efs_blob = PyList_New(object->blob_size);
		if (py_efs_blob == NULL) {
			return NULL;
		}
		{
			int efs_blob_cntr_1;
			for (efs_blob_cntr_1 = 0; efs_blob_cntr_1 < (object->blob_size); efs_blob_cntr_1++) {
				PyObject *py_efs_blob_1;
				py_efs_blob_1 = PyLong_FromLong((uint16_t)((object->efs_blob)[efs_blob_cntr_1]));
				PyList_SetItem(py_efs_blob, efs_blob_cntr_1, py_efs_blob_1);
			}
		}
	}
	return py_efs_blob;
}

static int py_lsa_DomainInfoEfs_set_efs_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoEfs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->efs_blob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->efs_blob");
		return -1;
	}
	if (value == Py_None) {
		object->efs_blob = NULL;
	} else {
		object->efs_blob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int efs_blob_cntr_1;
			object->efs_blob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->efs_blob, PyList_GET_SIZE(value));
			if (!object->efs_blob) { return -1; }
			talloc_set_name_const(object->efs_blob, "ARRAY: object->efs_blob");
			for (efs_blob_cntr_1 = 0; efs_blob_cntr_1 < PyList_GET_SIZE(value); efs_blob_cntr_1++) {
				if (PyList_GET_ITEM(value, efs_blob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->efs_blob)[efs_blob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->efs_blob)[efs_blob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, efs_blob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, efs_blob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->efs_blob)[efs_blob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainInfoEfs_getsetters[] = {
	{
		.name = discard_const_p(char, "blob_size"),
		.get = py_lsa_DomainInfoEfs_get_blob_size,
		.set = py_lsa_DomainInfoEfs_set_blob_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "efs_blob"),
		.get = py_lsa_DomainInfoEfs_get_efs_blob,
		.set = py_lsa_DomainInfoEfs_set_efs_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DomainInfoEfs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainInfoEfs, type);
}


static PyTypeObject lsa_DomainInfoEfs_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DomainInfoEfs",
	.tp_getset = py_lsa_DomainInfoEfs_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DomainInfoEfs_new,
};

static PyObject *py_import_lsa_DomainInformationPolicy(TALLOC_CTX *mem_ctx, int level, union lsa_DomainInformationPolicy *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_DOMAIN_INFO_POLICY_QOS:
			ret = pytalloc_reference_ex(&lsa_DomainInfoQoS_Type, mem_ctx, &in->qos_info);
			return ret;

		case LSA_DOMAIN_INFO_POLICY_EFS:
			ret = pytalloc_reference_ex(&lsa_DomainInfoEfs_Type, mem_ctx, &in->efs_info);
			return ret;

		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			ret = pytalloc_reference_ex(&lsa_DomainInfoKerberos_Type, mem_ctx, &in->kerberos_info);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union lsa_DomainInformationPolicy *py_export_lsa_DomainInformationPolicy(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_DomainInformationPolicy *ret = talloc_zero(mem_ctx, union lsa_DomainInformationPolicy);
	switch (level) {
		case LSA_DOMAIN_INFO_POLICY_QOS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->qos_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DomainInfoQoS_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->qos_info = *(struct lsa_DomainInfoQoS *)pytalloc_get_ptr(in);
			break;

		case LSA_DOMAIN_INFO_POLICY_EFS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->efs_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DomainInfoEfs_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->efs_info = *(struct lsa_DomainInfoEfs *)pytalloc_get_ptr(in);
			break;

		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->kerberos_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_DomainInfoKerberos_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->kerberos_info = *(struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_lsa_DomainInformationPolicy_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union lsa_DomainInformationPolicy *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union lsa_DomainInformationPolicy *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union lsa_DomainInformationPolicy!");
		return NULL;
	}

	return py_import_lsa_DomainInformationPolicy(mem_ctx, level, in);
}

static PyObject *py_lsa_DomainInformationPolicy_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union lsa_DomainInformationPolicy *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_lsa_DomainInformationPolicy(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_lsa_DomainInformationPolicy_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_DomainInformationPolicy_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_DomainInformationPolicy_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_lsa_DomainInformationPolicy_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject lsa_DomainInformationPolicy_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DomainInformationPolicy",
	.tp_getset = NULL,
	.tp_methods = py_lsa_DomainInformationPolicy_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DomainInformationPolicy_new,
};


static PyObject *py_lsa_TranslatedName2_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyLong_FromLong((uint16_t)(object->sid_type));
	return py_sid_type;
}

static int py_lsa_TranslatedName2_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedName2_get_name(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_TranslatedName2_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TranslatedName2_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_index));
	return py_sid_index;
}

static int py_lsa_TranslatedName2_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedName2_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown));
	return py_unknown;
}

static int py_lsa_TranslatedName2_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TranslatedName2_getsetters[] = {
	{
		.name = discard_const_p(char, "sid_type"),
		.get = py_lsa_TranslatedName2_get_sid_type,
		.set = py_lsa_TranslatedName2_set_sid_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_TranslatedName2_get_name,
		.set = py_lsa_TranslatedName2_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "sid_index"),
		.get = py_lsa_TranslatedName2_get_sid_index,
		.set = py_lsa_TranslatedName2_set_sid_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown"),
		.get = py_lsa_TranslatedName2_get_unknown,
		.set = py_lsa_TranslatedName2_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TranslatedName2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedName2, type);
}


static PyTypeObject lsa_TranslatedName2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TranslatedName2",
	.tp_getset = py_lsa_TranslatedName2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TranslatedName2_new,
};


static PyObject *py_lsa_TransNameArray2_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_TransNameArray2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TransNameArray2_get_names(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray2 *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < (object->count); names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_TranslatedName2_Type, object->names, &(object->names)[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_TransNameArray2_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->names");
		return -1;
	}
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				if (PyList_GET_ITEM(value, names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->names)[names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_TranslatedName2_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->names)[names_cntr_1] = *(struct lsa_TranslatedName2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransNameArray2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_TransNameArray2_get_count,
		.set = py_lsa_TransNameArray2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "names"),
		.get = py_lsa_TransNameArray2_get_names,
		.set = py_lsa_TransNameArray2_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TranslatedName2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TransNameArray2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransNameArray2, type);
}


static PyTypeObject lsa_TransNameArray2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TransNameArray2",
	.tp_getset = py_lsa_TransNameArray2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TransNameArray2_new,
};


static PyObject *py_lsa_TranslatedSid2_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyLong_FromLong((uint16_t)(object->sid_type));
	return py_sid_type;
}

static int py_lsa_TranslatedSid2_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid2_get_rid(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_lsa_TranslatedSid2_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid2_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_index));
	return py_sid_index;
}

static int py_lsa_TranslatedSid2_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid2_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown));
	return py_unknown;
}

static int py_lsa_TranslatedSid2_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TranslatedSid2_getsetters[] = {
	{
		.name = discard_const_p(char, "sid_type"),
		.get = py_lsa_TranslatedSid2_get_sid_type,
		.set = py_lsa_TranslatedSid2_set_sid_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_lsa_TranslatedSid2_get_rid,
		.set = py_lsa_TranslatedSid2_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sid_index"),
		.get = py_lsa_TranslatedSid2_get_sid_index,
		.set = py_lsa_TranslatedSid2_set_sid_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown"),
		.get = py_lsa_TranslatedSid2_get_unknown,
		.set = py_lsa_TranslatedSid2_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TranslatedSid2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedSid2, type);
}


static PyTypeObject lsa_TranslatedSid2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TranslatedSid2",
	.tp_getset = py_lsa_TranslatedSid2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TranslatedSid2_new,
};


static PyObject *py_lsa_TransSidArray2_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_TransSidArray2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TransSidArray2_get_sids(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray2 *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->count);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->count); sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_TranslatedSid2_Type, object->sids, &(object->sids)[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_TransSidArray2_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->sids)[sids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_TranslatedSid2_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sids)[sids_cntr_1] = *(struct lsa_TranslatedSid2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransSidArray2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_TransSidArray2_get_count,
		.set = py_lsa_TransSidArray2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_lsa_TransSidArray2_get_sids,
		.set = py_lsa_TransSidArray2_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TranslatedSid2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TransSidArray2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransSidArray2, type);
}


static PyTypeObject lsa_TransSidArray2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TransSidArray2",
	.tp_getset = py_lsa_TransSidArray2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TransSidArray2_new,
};


static PyObject *py_lsa_TranslatedSid3_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyLong_FromLong((uint16_t)(object->sid_type));
	return py_sid_type;
}

static int py_lsa_TranslatedSid3_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid3_get_sid(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_TranslatedSid3_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid3_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_index));
	return py_sid_index;
}

static int py_lsa_TranslatedSid3_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid3_get_flags(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_lsa_TranslatedSid3_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TranslatedSid3_getsetters[] = {
	{
		.name = discard_const_p(char, "sid_type"),
		.get = py_lsa_TranslatedSid3_get_sid_type,
		.set = py_lsa_TranslatedSid3_set_sid_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_lsa_TranslatedSid3_get_sid,
		.set = py_lsa_TranslatedSid3_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "sid_index"),
		.get = py_lsa_TranslatedSid3_get_sid_index,
		.set = py_lsa_TranslatedSid3_set_sid_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_lsa_TranslatedSid3_get_flags,
		.set = py_lsa_TranslatedSid3_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TranslatedSid3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedSid3, type);
}


static PyTypeObject lsa_TranslatedSid3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TranslatedSid3",
	.tp_getset = py_lsa_TranslatedSid3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TranslatedSid3_new,
};


static PyObject *py_lsa_TransSidArray3_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray3 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_TransSidArray3_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_TransSidArray3_get_sids(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray3 *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->count);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->count); sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_TranslatedSid3_Type, object->sids, &(object->sids)[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_TransSidArray3_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->sids)[sids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&lsa_TranslatedSid3_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sids)[sids_cntr_1] = *(struct lsa_TranslatedSid3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransSidArray3_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_TransSidArray3_get_count,
		.set = py_lsa_TransSidArray3_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_lsa_TransSidArray3_get_sids,
		.set = py_lsa_TransSidArray3_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TranslatedSid3")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_TransSidArray3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransSidArray3, type);
}


static PyTypeObject lsa_TransSidArray3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.TransSidArray3",
	.tp_getset = py_lsa_TransSidArray3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_TransSidArray3_new,
};


static PyObject *py_lsa_ForestTrustBinaryData_get_length(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_lsa_ForestTrustBinaryData_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustBinaryData_get_data(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_lsa_ForestTrustBinaryData_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustBinaryData_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_lsa_ForestTrustBinaryData_get_length,
		.set = py_lsa_ForestTrustBinaryData_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_lsa_ForestTrustBinaryData_get_data,
		.set = py_lsa_ForestTrustBinaryData_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustBinaryData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustBinaryData, type);
}


static PyTypeObject lsa_ForestTrustBinaryData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustBinaryData",
	.tp_getset = py_lsa_ForestTrustBinaryData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustBinaryData_new,
};


static PyObject *py_lsa_ForestTrustDomainInfo_get_domain_sid(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_lsa_ForestTrustDomainInfo_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domain_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_sid");
		return -1;
	}
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustDomainInfo_get_dns_domain_name(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_name;
	py_dns_domain_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_domain_name);
	return py_dns_domain_name;
}

static int py_lsa_ForestTrustDomainInfo_set_dns_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dns_domain_name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domain_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_ForestTrustDomainInfo_get_netbios_domain_name(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_domain_name;
	py_netbios_domain_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->netbios_domain_name);
	return py_netbios_domain_name;
}

static int py_lsa_ForestTrustDomainInfo_set_netbios_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->netbios_domain_name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_domain_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustDomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_sid"),
		.get = py_lsa_ForestTrustDomainInfo_get_domain_sid,
		.set = py_lsa_ForestTrustDomainInfo_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "dns_domain_name"),
		.get = py_lsa_ForestTrustDomainInfo_get_dns_domain_name,
		.set = py_lsa_ForestTrustDomainInfo_set_dns_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "netbios_domain_name"),
		.get = py_lsa_ForestTrustDomainInfo_get_netbios_domain_name,
		.set = py_lsa_ForestTrustDomainInfo_set_netbios_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustDomainInfo, type);
}


static PyTypeObject lsa_ForestTrustDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustDomainInfo",
	.tp_getset = py_lsa_ForestTrustDomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustDomainInfo_new,
};

static PyObject *py_import_lsa_ForestTrustData(TALLOC_CTX *mem_ctx, int level, union lsa_ForestTrustData *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			ret = pytalloc_reference_ex(&lsa_StringLarge_Type, mem_ctx, &in->top_level_name);
			return ret;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			ret = pytalloc_reference_ex(&lsa_StringLarge_Type, mem_ctx, &in->top_level_name_ex);
			return ret;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			ret = pytalloc_reference_ex(&lsa_ForestTrustDomainInfo_Type, mem_ctx, &in->domain_info);
			return ret;

		default:
			ret = pytalloc_reference_ex(&lsa_ForestTrustBinaryData_Type, mem_ctx, &in->data);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union lsa_ForestTrustData *py_export_lsa_ForestTrustData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_ForestTrustData *ret = talloc_zero(mem_ctx, union lsa_ForestTrustData);
	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->top_level_name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_StringLarge_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->top_level_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->top_level_name_ex");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_StringLarge_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->top_level_name_ex = *(struct lsa_StringLarge *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->domain_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ForestTrustDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->domain_info = *(struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->data");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ForestTrustBinaryData_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->data = *(struct lsa_ForestTrustBinaryData *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_lsa_ForestTrustData_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union lsa_ForestTrustData *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union lsa_ForestTrustData *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union lsa_ForestTrustData!");
		return NULL;
	}

	return py_import_lsa_ForestTrustData(mem_ctx, level, in);
}

static PyObject *py_lsa_ForestTrustData_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union lsa_ForestTrustData *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_lsa_ForestTrustData(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_lsa_ForestTrustData_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustData_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustData_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_lsa_ForestTrustData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject lsa_ForestTrustData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustData",
	.tp_getset = NULL,
	.tp_methods = py_lsa_ForestTrustData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustData_new,
};


static PyObject *py_lsa_ForestTrustRecord_get_flags(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_lsa_ForestTrustRecord_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord_get_type(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_lsa_ForestTrustRecord_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord_get_time(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong(object->time);
	return py_time;
}

static int py_lsa_ForestTrustRecord_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord_get_forest_trust_data(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_data;
	py_forest_trust_data = pyrpc_import_union(&lsa_ForestTrustData_Type, pytalloc_get_mem_ctx(obj), object->type, &object->forest_trust_data, "union lsa_ForestTrustData");
	if (py_forest_trust_data == NULL) {
		return NULL;
	}
	return py_forest_trust_data;
}

static int py_lsa_ForestTrustRecord_set_forest_trust_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_trust_data");
		return -1;
	}
	{
		union lsa_ForestTrustData *forest_trust_data_switch_0;
		forest_trust_data_switch_0 = (union lsa_ForestTrustData *)pyrpc_export_union(&lsa_ForestTrustData_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union lsa_ForestTrustData");
		if (forest_trust_data_switch_0 == NULL) {
			return -1;
		}
		object->forest_trust_data = *forest_trust_data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustRecord_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_lsa_ForestTrustRecord_get_flags,
		.set = py_lsa_ForestTrustRecord_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecordFlags")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_lsa_ForestTrustRecord_get_type,
		.set = py_lsa_ForestTrustRecord_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecordType")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_lsa_ForestTrustRecord_get_time,
		.set = py_lsa_ForestTrustRecord_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "forest_trust_data"),
		.get = py_lsa_ForestTrustRecord_get_forest_trust_data,
		.set = py_lsa_ForestTrustRecord_set_forest_trust_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustData")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustRecord_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustRecord, type);
}


static PyTypeObject lsa_ForestTrustRecord_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustRecord",
	.tp_getset = py_lsa_ForestTrustRecord_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustRecord_new,
};


static PyObject *py_lsa_ForestTrustInformation_get_count(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_ForestTrustInformation_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustInformation_get_entries(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				if ((object->entries)[entries_cntr_1] == NULL) {
					py_entries_1 = Py_None;
					Py_INCREF(py_entries_1);
				} else {
					py_entries_1 = pytalloc_reference_ex(&lsa_ForestTrustRecord_Type, (object->entries)[entries_cntr_1], (object->entries)[entries_cntr_1]);
				}
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_lsa_ForestTrustInformation_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->entries)[entries_cntr_1]");
					return -1;
				}
				if (PyList_GET_ITEM(value, entries_cntr_1) == Py_None) {
					(object->entries)[entries_cntr_1] = NULL;
				} else {
					(object->entries)[entries_cntr_1] = NULL;
					PY_CHECK_TYPE(&lsa_ForestTrustRecord_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
					if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					(object->entries)[entries_cntr_1] = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_ForestTrustInformation_get_count,
		.set = py_lsa_ForestTrustInformation_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_lsa_ForestTrustInformation_get_entries,
		.set = py_lsa_ForestTrustInformation_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecord")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustInformation, type);
}

static PyObject *py_lsa_ForestTrustInformation_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_ForestTrustInformation);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_ForestTrustInformation_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_ForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustInformation);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustInformation);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_ForestTrustInformation_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_ForestTrustInformation, "lsa_ForestTrustInformation", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_ForestTrustInformation_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_ForestTrustInformation_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustInformation_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_ForestTrustInformation_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_ForestTrustInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustInformation",
	.tp_getset = py_lsa_ForestTrustInformation_getsetters,
	.tp_methods = py_lsa_ForestTrustInformation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustInformation_new,
};


static PyObject *py_lsa_ForestTrustCollisionRecord_get_index(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_index;
	py_index = PyLong_FromUnsignedLongLong((uint32_t)(object->index));
	return py_index;
}

static int py_lsa_ForestTrustCollisionRecord_set_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_get_type(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_lsa_ForestTrustCollisionRecord_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_get_flags(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_lsa_ForestTrustCollisionRecord_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_get_name(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_ForestTrustCollisionRecord_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustCollisionRecord_getsetters[] = {
	{
		.name = discard_const_p(char, "index"),
		.get = py_lsa_ForestTrustCollisionRecord_get_index,
		.set = py_lsa_ForestTrustCollisionRecord_set_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_lsa_ForestTrustCollisionRecord_get_type,
		.set = py_lsa_ForestTrustCollisionRecord_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustCollisionRecordType")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_lsa_ForestTrustCollisionRecord_get_flags,
		.set = py_lsa_ForestTrustCollisionRecord_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecordFlags")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_lsa_ForestTrustCollisionRecord_get_name,
		.set = py_lsa_ForestTrustCollisionRecord_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustCollisionRecord_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustCollisionRecord, type);
}

static PyObject *py_lsa_ForestTrustCollisionRecord_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_ForestTrustCollisionRecord);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionRecord);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionRecord);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustCollisionRecord *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_ForestTrustCollisionRecord, "lsa_ForestTrustCollisionRecord", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_ForestTrustCollisionRecord_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_ForestTrustCollisionRecord_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustCollisionRecord_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_ForestTrustCollisionRecord_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_ForestTrustCollisionRecord_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustCollisionRecord",
	.tp_getset = py_lsa_ForestTrustCollisionRecord_getsetters,
	.tp_methods = py_lsa_ForestTrustCollisionRecord_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustCollisionRecord_new,
};


static PyObject *py_lsa_ForestTrustCollisionInfo_get_count(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_ForestTrustCollisionInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionInfo_get_entries(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				if ((object->entries)[entries_cntr_1] == NULL) {
					py_entries_1 = Py_None;
					Py_INCREF(py_entries_1);
				} else {
					py_entries_1 = pytalloc_reference_ex(&lsa_ForestTrustCollisionRecord_Type, (object->entries)[entries_cntr_1], (object->entries)[entries_cntr_1]);
				}
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_lsa_ForestTrustCollisionInfo_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->entries)[entries_cntr_1]");
					return -1;
				}
				if (PyList_GET_ITEM(value, entries_cntr_1) == Py_None) {
					(object->entries)[entries_cntr_1] = NULL;
				} else {
					(object->entries)[entries_cntr_1] = NULL;
					PY_CHECK_TYPE(&lsa_ForestTrustCollisionRecord_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
					if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					(object->entries)[entries_cntr_1] = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustCollisionInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_ForestTrustCollisionInfo_get_count,
		.set = py_lsa_ForestTrustCollisionInfo_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_lsa_ForestTrustCollisionInfo_get_entries,
		.set = py_lsa_ForestTrustCollisionInfo_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustCollisionRecord")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustCollisionInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustCollisionInfo, type);
}

static PyObject *py_lsa_ForestTrustCollisionInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustCollisionInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_ForestTrustCollisionInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_ForestTrustCollisionInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_ForestTrustCollisionInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_ForestTrustCollisionInfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustCollisionInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_ForestTrustCollisionInfo, "lsa_ForestTrustCollisionInfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_ForestTrustCollisionInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_ForestTrustCollisionInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustCollisionInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_ForestTrustCollisionInfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_ForestTrustCollisionInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustCollisionInfo",
	.tp_getset = py_lsa_ForestTrustCollisionInfo_getsetters,
	.tp_methods = py_lsa_ForestTrustCollisionInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustCollisionInfo_new,
};


static PyObject *py_lsa_revision_info1_get_revision(PyObject *obj, void *closure)
{
	struct lsa_revision_info1 *object = pytalloc_get_ptr(obj);
	PyObject *py_revision;
	py_revision = PyLong_FromUnsignedLongLong((uint32_t)(object->revision));
	return py_revision;
}

static int py_lsa_revision_info1_set_revision(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_revision_info1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->revision");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->revision));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->revision = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_revision_info1_get_supported_features(PyObject *obj, void *closure)
{
	struct lsa_revision_info1 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_features;
	py_supported_features = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_features));
	return py_supported_features;
}

static int py_lsa_revision_info1_set_supported_features(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_revision_info1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->supported_features");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_features));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_features = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_revision_info1_getsetters[] = {
	{
		.name = discard_const_p(char, "revision"),
		.get = py_lsa_revision_info1_get_revision,
		.set = py_lsa_revision_info1_set_revision,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "supported_features"),
		.get = py_lsa_revision_info1_get_supported_features,
		.set = py_lsa_revision_info1_set_supported_features,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_RevisionSupportedFeature")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_revision_info1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_revision_info1, type);
}


static PyTypeObject lsa_revision_info1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.revision_info1",
	.tp_getset = py_lsa_revision_info1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_revision_info1_new,
};

static PyObject *py_import_lsa_revision_info(TALLOC_CTX *mem_ctx, int level, union lsa_revision_info *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&lsa_revision_info1_Type, mem_ctx, &in->info1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union lsa_revision_info *py_export_lsa_revision_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_revision_info *ret = talloc_zero(mem_ctx, union lsa_revision_info);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_revision_info1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct lsa_revision_info1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_lsa_revision_info_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union lsa_revision_info *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union lsa_revision_info *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union lsa_revision_info!");
		return NULL;
	}

	return py_import_lsa_revision_info(mem_ctx, level, in);
}

static PyObject *py_lsa_revision_info_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union lsa_revision_info *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_lsa_revision_info(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_lsa_revision_info_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_revision_info_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_revision_info_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_lsa_revision_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject lsa_revision_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.revision_info",
	.tp_getset = NULL,
	.tp_methods = py_lsa_revision_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_revision_info_new,
};

static PyObject *py_import_lsa_ForestTrustData2(TALLOC_CTX *mem_ctx, int level, union lsa_ForestTrustData2 *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			ret = pytalloc_reference_ex(&lsa_StringLarge_Type, mem_ctx, &in->top_level_name);
			return ret;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			ret = pytalloc_reference_ex(&lsa_StringLarge_Type, mem_ctx, &in->top_level_name_ex);
			return ret;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			ret = pytalloc_reference_ex(&lsa_ForestTrustDomainInfo_Type, mem_ctx, &in->domain_info);
			return ret;

		case LSA_FOREST_TRUST_BINARY_DATA:
			ret = pytalloc_reference_ex(&lsa_ForestTrustBinaryData_Type, mem_ctx, &in->data);
			return ret;

		case LSA_FOREST_TRUST_SCANNER_INFO:
			ret = pytalloc_reference_ex(&lsa_ForestTrustDomainInfo_Type, mem_ctx, &in->scanner_info);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union lsa_ForestTrustData2 *py_export_lsa_ForestTrustData2(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_ForestTrustData2 *ret = talloc_zero(mem_ctx, union lsa_ForestTrustData2);
	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->top_level_name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_StringLarge_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->top_level_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->top_level_name_ex");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_StringLarge_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->top_level_name_ex = *(struct lsa_StringLarge *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->domain_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ForestTrustDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->domain_info = *(struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_BINARY_DATA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->data");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ForestTrustBinaryData_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->data = *(struct lsa_ForestTrustBinaryData *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_SCANNER_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->scanner_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&lsa_ForestTrustDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->scanner_info = *(struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_lsa_ForestTrustData2_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union lsa_ForestTrustData2 *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union lsa_ForestTrustData2 *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union lsa_ForestTrustData2!");
		return NULL;
	}

	return py_import_lsa_ForestTrustData2(mem_ctx, level, in);
}

static PyObject *py_lsa_ForestTrustData2_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union lsa_ForestTrustData2 *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_lsa_ForestTrustData2(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_lsa_ForestTrustData2_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustData2_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustData2_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_lsa_ForestTrustData2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject lsa_ForestTrustData2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustData2",
	.tp_getset = NULL,
	.tp_methods = py_lsa_ForestTrustData2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustData2_new,
};


static PyObject *py_lsa_ForestTrustRecord2_get_flags(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_lsa_ForestTrustRecord2_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord2_get_type(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_lsa_ForestTrustRecord2_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord2_get_time(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong(object->time);
	return py_time;
}

static int py_lsa_ForestTrustRecord2_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord2_get_forest_trust_data(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_data;
	py_forest_trust_data = pyrpc_import_union(&lsa_ForestTrustData2_Type, pytalloc_get_mem_ctx(obj), object->type, &object->forest_trust_data, "union lsa_ForestTrustData2");
	if (py_forest_trust_data == NULL) {
		return NULL;
	}
	return py_forest_trust_data;
}

static int py_lsa_ForestTrustRecord2_set_forest_trust_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_trust_data");
		return -1;
	}
	{
		union lsa_ForestTrustData2 *forest_trust_data_switch_0;
		forest_trust_data_switch_0 = (union lsa_ForestTrustData2 *)pyrpc_export_union(&lsa_ForestTrustData2_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union lsa_ForestTrustData2");
		if (forest_trust_data_switch_0 == NULL) {
			return -1;
		}
		object->forest_trust_data = *forest_trust_data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustRecord2_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_lsa_ForestTrustRecord2_get_flags,
		.set = py_lsa_ForestTrustRecord2_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecordFlags")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_lsa_ForestTrustRecord2_get_type,
		.set = py_lsa_ForestTrustRecord2_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecordType")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_lsa_ForestTrustRecord2_get_time,
		.set = py_lsa_ForestTrustRecord2_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "forest_trust_data"),
		.get = py_lsa_ForestTrustRecord2_get_forest_trust_data,
		.set = py_lsa_ForestTrustRecord2_set_forest_trust_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustData2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustRecord2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustRecord2, type);
}


static PyTypeObject lsa_ForestTrustRecord2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustRecord2",
	.tp_getset = py_lsa_ForestTrustRecord2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustRecord2_new,
};


static PyObject *py_lsa_ForestTrustInformation2_get_count(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustInformation2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_lsa_ForestTrustInformation2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustInformation2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustInformation2_get_entries(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustInformation2 *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				if ((object->entries)[entries_cntr_1] == NULL) {
					py_entries_1 = Py_None;
					Py_INCREF(py_entries_1);
				} else {
					py_entries_1 = pytalloc_reference_ex(&lsa_ForestTrustRecord2_Type, (object->entries)[entries_cntr_1], (object->entries)[entries_cntr_1]);
				}
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_lsa_ForestTrustInformation2_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustInformation2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->entries)[entries_cntr_1]");
					return -1;
				}
				if (PyList_GET_ITEM(value, entries_cntr_1) == Py_None) {
					(object->entries)[entries_cntr_1] = NULL;
				} else {
					(object->entries)[entries_cntr_1] = NULL;
					PY_CHECK_TYPE(&lsa_ForestTrustRecord2_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
					if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					(object->entries)[entries_cntr_1] = (struct lsa_ForestTrustRecord2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustInformation2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_lsa_ForestTrustInformation2_get_count,
		.set = py_lsa_ForestTrustInformation2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_lsa_ForestTrustInformation2_get_entries,
		.set = py_lsa_ForestTrustInformation2_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecord2")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_ForestTrustInformation2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustInformation2, type);
}

static PyObject *py_lsa_ForestTrustInformation2_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustInformation2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_lsa_ForestTrustInformation2);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_lsa_ForestTrustInformation2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_ForestTrustInformation2 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustInformation2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustInformation2);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_ForestTrustInformation2_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct lsa_ForestTrustInformation2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_ForestTrustInformation2, "lsa_ForestTrustInformation2", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_ForestTrustInformation2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_ForestTrustInformation2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_ForestTrustInformation2_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_ForestTrustInformation2_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_ForestTrustInformation2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.ForestTrustInformation2",
	.tp_getset = py_lsa_ForestTrustInformation2_getsetters,
	.tp_methods = py_lsa_ForestTrustInformation2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_ForestTrustInformation2_new,
};



static PyObject *py_lsa_Close_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_Close *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_Close_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Close *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_Close_out_get_handle(PyObject *obj, void *closure)
{
	struct lsa_Close *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_lsa_Close_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Close *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_Close_get_result(PyObject *obj, void *closure)
{
	struct lsa_Close *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_Close_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Close *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_Close_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_Close_in_get_handle,
		.set = py_lsa_Close_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_lsa_Close_out_get_handle,
		.set = py_lsa_Close_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_Close_get_result,
		.set = py_lsa_Close_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_Close_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_Close, type);
	struct lsa_Close *_self = (struct lsa_Close *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_Close_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_lsa_Close_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_Close *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_Close_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_Close_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_Close_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_Close_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_Close_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_Close_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_Close *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_Close_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_Close_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_Close_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_Close_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_Close_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_Close_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_Close *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_Close_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_Close_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_Close_ndr_print(py_obj, "lsa_Close_in", NDR_IN);
}

static PyObject *py_lsa_Close_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_Close_ndr_print(py_obj, "lsa_Close_out", NDR_OUT);
}

static PyMethodDef py_lsa_Close_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_Close_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.Close.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Close_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Close_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Close_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Close_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_Close_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_Close_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_Close_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.Close",
	.tp_getset = py_lsa_Close_getsetters,
	.tp_methods = py_lsa_Close_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_Close_new,
};

static bool pack_py_lsa_Close_args_in(PyObject *args, PyObject *kwargs, struct lsa_Close *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_Close", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_Close_args_out(struct lsa_Close *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_Delete_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_Delete *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_Delete_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Delete *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_Delete_get_result(PyObject *obj, void *closure)
{
	struct lsa_Delete *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_Delete_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Delete *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_Delete_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_Delete_in_get_handle,
		.set = py_lsa_Delete_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_Delete_get_result,
		.set = py_lsa_Delete_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_Delete_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_Delete, type);
	struct lsa_Delete *_self = (struct lsa_Delete *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_Delete_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_lsa_Delete_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_Delete *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_Delete_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_Delete_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_Delete_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_Delete_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_Delete_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_Delete_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_Delete *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_Delete_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_Delete_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_Delete_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_Delete_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_Delete_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_Delete_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_Delete *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_Delete_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[1];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_Delete_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_Delete_ndr_print(py_obj, "lsa_Delete_in", NDR_IN);
}

static PyObject *py_lsa_Delete_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_Delete_ndr_print(py_obj, "lsa_Delete_out", NDR_OUT);
}

static PyMethodDef py_lsa_Delete_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_Delete_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.Delete.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Delete_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Delete_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Delete_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_Delete_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_Delete_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_Delete_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_Delete_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.Delete",
	.tp_getset = py_lsa_Delete_getsetters,
	.tp_methods = py_lsa_Delete_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_Delete_new,
};

static bool pack_py_lsa_Delete_args_in(PyObject *args, PyObject *kwargs, struct lsa_Delete *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_Delete", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_Delete_args_out(struct lsa_Delete *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_EnumPrivs_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_EnumPrivs_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumPrivs_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	return py_resume_handle;
}

static int py_lsa_EnumPrivs_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
	if (object->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumPrivs_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	return py_resume_handle;
}

static int py_lsa_EnumPrivs_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
	if (object->out.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumPrivs_out_get_privs(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(obj);
	PyObject *py_privs;
	if (object->out.privs == NULL) {
		Py_RETURN_NONE;
	}
	py_privs = pytalloc_reference_ex(&lsa_PrivArray_Type, object->out.privs, object->out.privs);
	return py_privs;
}

static int py_lsa_EnumPrivs_out_set_privs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.privs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.privs");
		return -1;
	}
	object->out.privs = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.privs);
	if (object->out.privs == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_PrivArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.privs = (struct lsa_PrivArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumPrivs_in_get_max_count(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(obj);
	PyObject *py_max_count;
	py_max_count = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_count));
	return py_max_count;
}

static int py_lsa_EnumPrivs_in_set_max_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.max_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumPrivs_get_result(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_EnumPrivs_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_EnumPrivs_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_EnumPrivs_in_get_handle,
		.set = py_lsa_EnumPrivs_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_lsa_EnumPrivs_in_get_resume_handle,
		.set = py_lsa_EnumPrivs_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_lsa_EnumPrivs_out_get_resume_handle,
		.set = py_lsa_EnumPrivs_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_privs"),
		.get = py_lsa_EnumPrivs_out_get_privs,
		.set = py_lsa_EnumPrivs_out_set_privs,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PrivArray")
	},
	{
		.name = discard_const_p(char, "in_max_count"),
		.get = py_lsa_EnumPrivs_in_get_max_count,
		.set = py_lsa_EnumPrivs_in_set_max_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_EnumPrivs_get_result,
		.set = py_lsa_EnumPrivs_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_EnumPrivs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_EnumPrivs, type);
	struct lsa_EnumPrivs *_self = (struct lsa_EnumPrivs *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.privs = talloc_zero(mem_ctx, struct lsa_PrivArray);
	return self;
}

static PyObject *py_lsa_EnumPrivs_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_lsa_EnumPrivs_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumPrivs_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_EnumPrivs_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumPrivs_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_EnumPrivs_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumPrivs_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_EnumPrivs_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumPrivs_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_EnumPrivs_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumPrivs_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumPrivs_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumPrivs_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumPrivs_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumPrivs *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumPrivs_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[2];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_EnumPrivs_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumPrivs_ndr_print(py_obj, "lsa_EnumPrivs_in", NDR_IN);
}

static PyObject *py_lsa_EnumPrivs_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumPrivs_ndr_print(py_obj, "lsa_EnumPrivs_out", NDR_OUT);
}

static PyMethodDef py_lsa_EnumPrivs_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_EnumPrivs_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.EnumPrivs.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivs_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivs_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivs_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivs_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_EnumPrivs_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_EnumPrivs_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_EnumPrivs_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.EnumPrivs",
	.tp_getset = py_lsa_EnumPrivs_getsetters,
	.tp_methods = py_lsa_EnumPrivs_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_EnumPrivs_new,
};

static bool pack_py_lsa_EnumPrivs_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumPrivs *r)
{
	PyObject *py_handle;
	PyObject *py_resume_handle;
	PyObject *py_max_count;
	const char *kwnames[] = {
		"handle", "resume_handle", "max_count", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_EnumPrivs", discard_const_p(char *, kwnames), &py_handle, &py_resume_handle, &py_max_count)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	if (r->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
		if (PyLong_Check(py_resume_handle)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_count == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.max_count");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_count));
		if (PyLong_Check(py_max_count)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_count);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_EnumPrivs_args_out(struct lsa_EnumPrivs *r)
{
	PyObject *result;
	PyObject *py_resume_handle;
	PyObject *py_privs;
	result = PyTuple_New(2);
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	PyTuple_SetItem(result, 0, py_resume_handle);
	py_privs = pytalloc_reference_ex(&lsa_PrivArray_Type, r->out.privs, r->out.privs);
	PyTuple_SetItem(result, 1, py_privs);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_QuerySecurity_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_QuerySecurity_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_QuerySecurity_in_get_sec_info(PyObject *obj, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_info;
	py_sec_info = PyLong_FromUnsignedLongLong((uint32_t)(object->in.sec_info));
	return py_sec_info;
}

static int py_lsa_QuerySecurity_in_set_sec_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sec_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.sec_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_QuerySecurity_out_get_sdbuf(PyObject *obj, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	if (object->out.sdbuf == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.sdbuf == NULL) {
		py_sdbuf = Py_None;
		Py_INCREF(py_sdbuf);
	} else {
		py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, *object->out.sdbuf, *object->out.sdbuf);
	}
	return py_sdbuf;
}

static int py_lsa_QuerySecurity_out_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sdbuf));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.sdbuf");
		return -1;
	}
	object->out.sdbuf = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sdbuf);
	if (object->out.sdbuf == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.sdbuf = NULL;
	} else {
		*object->out.sdbuf = NULL;
		PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.sdbuf = (struct sec_desc_buf *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_QuerySecurity_get_result(PyObject *obj, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_QuerySecurity_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_QuerySecurity_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_QuerySecurity_in_get_handle,
		.set = py_lsa_QuerySecurity_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sec_info"),
		.get = py_lsa_QuerySecurity_in_get_sec_info,
		.set = py_lsa_QuerySecurity_in_set_sec_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "out_sdbuf"),
		.get = py_lsa_QuerySecurity_out_get_sdbuf,
		.set = py_lsa_QuerySecurity_out_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_QuerySecurity_get_result,
		.set = py_lsa_QuerySecurity_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_QuerySecurity_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_QuerySecurity, type);
	struct lsa_QuerySecurity *_self = (struct lsa_QuerySecurity *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.sdbuf = talloc_zero(mem_ctx, struct sec_desc_buf *);
	return self;
}

static PyObject *py_lsa_QuerySecurity_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_lsa_QuerySecurity_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QuerySecurity_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_QuerySecurity_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QuerySecurity_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_QuerySecurity_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QuerySecurity_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_QuerySecurity_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QuerySecurity_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_QuerySecurity_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QuerySecurity_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QuerySecurity_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QuerySecurity_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QuerySecurity_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QuerySecurity_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[3];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_QuerySecurity_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QuerySecurity_ndr_print(py_obj, "lsa_QuerySecurity_in", NDR_IN);
}

static PyObject *py_lsa_QuerySecurity_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QuerySecurity_ndr_print(py_obj, "lsa_QuerySecurity_out", NDR_OUT);
}

static PyMethodDef py_lsa_QuerySecurity_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_QuerySecurity_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.QuerySecurity.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecurity_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecurity_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecurity_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecurity_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_QuerySecurity_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_QuerySecurity_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_QuerySecurity_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.QuerySecurity",
	.tp_getset = py_lsa_QuerySecurity_getsetters,
	.tp_methods = py_lsa_QuerySecurity_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_QuerySecurity_new,
};

static bool pack_py_lsa_QuerySecurity_args_in(PyObject *args, PyObject *kwargs, struct lsa_QuerySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	const char *kwnames[] = {
		"handle", "sec_info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QuerySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sec_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sec_info");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.sec_info));
		if (PyLong_Check(py_sec_info)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_sec_info);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_QuerySecurity_args_out(struct lsa_QuerySecurity *r)
{
	PyObject *result;
	PyObject *py_sdbuf;
	if (*r->out.sdbuf == NULL) {
		py_sdbuf = Py_None;
		Py_INCREF(py_sdbuf);
	} else {
		py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, *r->out.sdbuf, *r->out.sdbuf);
	}
	result = py_sdbuf;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_SetSecObj_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_SetSecObj_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_SetSecObj_in_get_sec_info(PyObject *obj, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_info;
	py_sec_info = PyLong_FromUnsignedLongLong((uint32_t)(object->in.sec_info));
	return py_sec_info;
}

static int py_lsa_SetSecObj_in_set_sec_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sec_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.sec_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_SetSecObj_in_get_sdbuf(PyObject *obj, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	if (object->in.sdbuf == NULL) {
		Py_RETURN_NONE;
	}
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, object->in.sdbuf, object->in.sdbuf);
	return py_sdbuf;
}

static int py_lsa_SetSecObj_in_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sdbuf));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sdbuf");
		return -1;
	}
	object->in.sdbuf = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sdbuf);
	if (object->in.sdbuf == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sdbuf = (struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_SetSecObj_get_result(PyObject *obj, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_SetSecObj_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecObj *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_SetSecObj_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_SetSecObj_in_get_handle,
		.set = py_lsa_SetSecObj_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sec_info"),
		.get = py_lsa_SetSecObj_in_get_sec_info,
		.set = py_lsa_SetSecObj_in_set_sec_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "in_sdbuf"),
		.get = py_lsa_SetSecObj_in_get_sdbuf,
		.set = py_lsa_SetSecObj_in_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_SetSecObj_get_result,
		.set = py_lsa_SetSecObj_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_SetSecObj_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_SetSecObj, type);
	struct lsa_SetSecObj *_self = (struct lsa_SetSecObj *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sdbuf = talloc_zero(mem_ctx, struct sec_desc_buf);
	return self;
}

static PyObject *py_lsa_SetSecObj_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_lsa_SetSecObj_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSecObj *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSecObj_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_SetSecObj_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetSecObj_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_SetSecObj_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetSecObj_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_SetSecObj_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSecObj *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSecObj_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_SetSecObj_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetSecObj_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetSecObj_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetSecObj_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetSecObj_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSecObj *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSecObj_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[4];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_SetSecObj_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetSecObj_ndr_print(py_obj, "lsa_SetSecObj_in", NDR_IN);
}

static PyObject *py_lsa_SetSecObj_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetSecObj_ndr_print(py_obj, "lsa_SetSecObj_out", NDR_OUT);
}

static PyMethodDef py_lsa_SetSecObj_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_SetSecObj_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.SetSecObj.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecObj_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecObj_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecObj_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecObj_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_SetSecObj_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_SetSecObj_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_SetSecObj_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.SetSecObj",
	.tp_getset = py_lsa_SetSecObj_getsetters,
	.tp_methods = py_lsa_SetSecObj_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_SetSecObj_new,
};

static bool pack_py_lsa_SetSecObj_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetSecObj *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sdbuf;
	const char *kwnames[] = {
		"handle", "sec_info", "sdbuf", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetSecObj", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sdbuf)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sec_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sec_info");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.sec_info));
		if (PyLong_Check(py_sec_info)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_sec_info);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_sdbuf == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sdbuf");
		return false;
	}
	r->in.sdbuf = talloc_ptrtype(r, r->in.sdbuf);
	if (r->in.sdbuf == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, py_sdbuf, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sdbuf)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sdbuf = (struct sec_desc_buf *)pytalloc_get_ptr(py_sdbuf);
	return true;
}

static PyObject *unpack_py_lsa_SetSecObj_args_out(struct lsa_SetSecObj *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_OpenPolicy_in_get_system_name(PyObject *obj, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_lsa_OpenPolicy_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_OpenPolicy_in_get_attr(PyObject *obj, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_attr;
	if (object->in.attr == NULL) {
		Py_RETURN_NONE;
	}
	py_attr = pytalloc_reference_ex(&lsa_ObjectAttribute_Type, object->in.attr, object->in.attr);
	return py_attr;
}

static int py_lsa_OpenPolicy_in_set_attr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.attr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.attr");
		return -1;
	}
	object->in.attr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.attr);
	if (object->in.attr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_ObjectAttribute_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.attr = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenPolicy_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_OpenPolicy_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_OpenPolicy_out_get_handle(PyObject *obj, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_lsa_OpenPolicy_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenPolicy_get_result(PyObject *obj, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_OpenPolicy_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_OpenPolicy_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_lsa_OpenPolicy_in_get_system_name,
		.set = py_lsa_OpenPolicy_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_attr"),
		.get = py_lsa_OpenPolicy_in_get_attr,
		.set = py_lsa_OpenPolicy_in_set_attr,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ObjectAttribute")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_OpenPolicy_in_get_access_mask,
		.set = py_lsa_OpenPolicy_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PolicyAccessMask")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_lsa_OpenPolicy_out_get_handle,
		.set = py_lsa_OpenPolicy_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_OpenPolicy_get_result,
		.set = py_lsa_OpenPolicy_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_OpenPolicy_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_OpenPolicy, type);
	struct lsa_OpenPolicy *_self = (struct lsa_OpenPolicy *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.attr = talloc_zero(mem_ctx, struct lsa_ObjectAttribute);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_OpenPolicy_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_lsa_OpenPolicy_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenPolicy_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_OpenPolicy_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenPolicy_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_OpenPolicy_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenPolicy_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_OpenPolicy_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenPolicy_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_OpenPolicy_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenPolicy_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenPolicy_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenPolicy_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenPolicy_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenPolicy *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenPolicy_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[6];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_OpenPolicy_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenPolicy_ndr_print(py_obj, "lsa_OpenPolicy_in", NDR_IN);
}

static PyObject *py_lsa_OpenPolicy_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenPolicy_ndr_print(py_obj, "lsa_OpenPolicy_out", NDR_OUT);
}

static PyMethodDef py_lsa_OpenPolicy_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_OpenPolicy_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.OpenPolicy.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenPolicy_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenPolicy_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenPolicy_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenPolicy_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_OpenPolicy_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_OpenPolicy_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_OpenPolicy_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.OpenPolicy",
	.tp_getset = py_lsa_OpenPolicy_getsetters,
	.tp_methods = py_lsa_OpenPolicy_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_OpenPolicy_new,
};

static bool pack_py_lsa_OpenPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenPolicy *r)
{
	PyObject *py_system_name;
	PyObject *py_attr;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "attr", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenPolicy", discard_const_p(char *, kwnames), &py_system_name, &py_attr, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_attr == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.attr");
		return false;
	}
	r->in.attr = talloc_ptrtype(r, r->in.attr);
	if (r->in.attr == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_ObjectAttribute_Type, py_attr, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_attr)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.attr = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_attr);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenPolicy_args_out(struct lsa_OpenPolicy *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_QueryInfoPolicy_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_QueryInfoPolicy_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_QueryInfoPolicy_in_get_level(PyObject *obj, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_lsa_QueryInfoPolicy_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_QueryInfoPolicy_out_get_info(PyObject *obj, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&lsa_PolicyInformation_Type, *object->out.info, object->in.level, *object->out.info, "union lsa_PolicyInformation");
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_lsa_QueryInfoPolicy_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.info = NULL;
	} else {
		*object->out.info = NULL;
		{
			union lsa_PolicyInformation *info_switch_2;
			info_switch_2 = (union lsa_PolicyInformation *)pyrpc_export_union(&lsa_PolicyInformation_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union lsa_PolicyInformation");
			if (info_switch_2 == NULL) {
				return -1;
			}
			*object->out.info = info_switch_2;
		}
	}
	return 0;
}

static PyObject *py_lsa_QueryInfoPolicy_get_result(PyObject *obj, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_QueryInfoPolicy_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_QueryInfoPolicy_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_QueryInfoPolicy_in_get_handle,
		.set = py_lsa_QueryInfoPolicy_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_lsa_QueryInfoPolicy_in_get_level,
		.set = py_lsa_QueryInfoPolicy_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PolicyInfo")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_lsa_QueryInfoPolicy_out_get_info,
		.set = py_lsa_QueryInfoPolicy_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PolicyInformation")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_QueryInfoPolicy_get_result,
		.set = py_lsa_QueryInfoPolicy_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_QueryInfoPolicy_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_QueryInfoPolicy, type);
	struct lsa_QueryInfoPolicy *_self = (struct lsa_QueryInfoPolicy *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.info = talloc_zero(mem_ctx, union lsa_PolicyInformation *);
	return self;
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QueryInfoPolicy_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QueryInfoPolicy_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QueryInfoPolicy_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QueryInfoPolicy_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QueryInfoPolicy_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QueryInfoPolicy_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QueryInfoPolicy *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QueryInfoPolicy_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[7];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QueryInfoPolicy_ndr_print(py_obj, "lsa_QueryInfoPolicy_in", NDR_IN);
}

static PyObject *py_lsa_QueryInfoPolicy_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QueryInfoPolicy_ndr_print(py_obj, "lsa_QueryInfoPolicy_out", NDR_OUT);
}

static PyMethodDef py_lsa_QueryInfoPolicy_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_QueryInfoPolicy_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.QueryInfoPolicy.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryInfoPolicy_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryInfoPolicy_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryInfoPolicy_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryInfoPolicy_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_QueryInfoPolicy_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_QueryInfoPolicy_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_QueryInfoPolicy_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.QueryInfoPolicy",
	.tp_getset = py_lsa_QueryInfoPolicy_getsetters,
	.tp_methods = py_lsa_QueryInfoPolicy_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_QueryInfoPolicy_new,
};

static bool pack_py_lsa_QueryInfoPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryInfoPolicy *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QueryInfoPolicy", discard_const_p(char *, kwnames), &py_handle, &py_level)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_QueryInfoPolicy_args_out(struct lsa_QueryInfoPolicy *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&lsa_PolicyInformation_Type, *r->out.info, r->in.level, *r->out.info, "union lsa_PolicyInformation");
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_SetInfoPolicy_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_SetInfoPolicy_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_SetInfoPolicy_in_get_level(PyObject *obj, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_lsa_SetInfoPolicy_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_SetInfoPolicy_in_get_info(PyObject *obj, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&lsa_PolicyInformation_Type, object->in.info, object->in.level, object->in.info, "union lsa_PolicyInformation");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_lsa_SetInfoPolicy_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union lsa_PolicyInformation *info_switch_1;
		info_switch_1 = (union lsa_PolicyInformation *)pyrpc_export_union(&lsa_PolicyInformation_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union lsa_PolicyInformation");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->in.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_lsa_SetInfoPolicy_get_result(PyObject *obj, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_SetInfoPolicy_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_SetInfoPolicy_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_SetInfoPolicy_in_get_handle,
		.set = py_lsa_SetInfoPolicy_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_lsa_SetInfoPolicy_in_get_level,
		.set = py_lsa_SetInfoPolicy_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PolicyInfo")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_lsa_SetInfoPolicy_in_get_info,
		.set = py_lsa_SetInfoPolicy_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PolicyInformation")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_SetInfoPolicy_get_result,
		.set = py_lsa_SetInfoPolicy_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_SetInfoPolicy_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_SetInfoPolicy, type);
	struct lsa_SetInfoPolicy *_self = (struct lsa_SetInfoPolicy *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.info = talloc_zero(mem_ctx, union lsa_PolicyInformation);
	return self;
}

static PyObject *py_lsa_SetInfoPolicy_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_lsa_SetInfoPolicy_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetInfoPolicy_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_SetInfoPolicy_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetInfoPolicy_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_SetInfoPolicy_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetInfoPolicy_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_SetInfoPolicy_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetInfoPolicy_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_SetInfoPolicy_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetInfoPolicy_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetInfoPolicy_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetInfoPolicy_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetInfoPolicy_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetInfoPolicy *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetInfoPolicy_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[8];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_SetInfoPolicy_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetInfoPolicy_ndr_print(py_obj, "lsa_SetInfoPolicy_in", NDR_IN);
}

static PyObject *py_lsa_SetInfoPolicy_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetInfoPolicy_ndr_print(py_obj, "lsa_SetInfoPolicy_out", NDR_OUT);
}

static PyMethodDef py_lsa_SetInfoPolicy_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_SetInfoPolicy_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.SetInfoPolicy.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInfoPolicy_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInfoPolicy_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInfoPolicy_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInfoPolicy_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_SetInfoPolicy_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_SetInfoPolicy_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_SetInfoPolicy_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.SetInfoPolicy",
	.tp_getset = py_lsa_SetInfoPolicy_getsetters,
	.tp_methods = py_lsa_SetInfoPolicy_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_SetInfoPolicy_new,
};

static bool pack_py_lsa_SetInfoPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetInfoPolicy *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetInfoPolicy", discard_const_p(char *, kwnames), &py_handle, &py_level, &py_info)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union lsa_PolicyInformation *info_switch_1;
		info_switch_1 = (union lsa_PolicyInformation *)pyrpc_export_union(&lsa_PolicyInformation_Type, r, r->in.level, py_info, "union lsa_PolicyInformation");
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetInfoPolicy_args_out(struct lsa_SetInfoPolicy *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_CreateAccount_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_CreateAccount_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateAccount_in_get_sid(PyObject *obj, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_lsa_CreateAccount_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateAccount_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_CreateAccount_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_CreateAccount_out_get_acct_handle(PyObject *obj, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_handle;
	if (object->out.acct_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_acct_handle = pytalloc_reference_ex(policy_handle_Type, object->out.acct_handle, object->out.acct_handle);
	return py_acct_handle;
}

static int py_lsa_CreateAccount_out_set_acct_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.acct_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.acct_handle");
		return -1;
	}
	object->out.acct_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.acct_handle);
	if (object->out.acct_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.acct_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateAccount_get_result(PyObject *obj, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_CreateAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_CreateAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_CreateAccount_in_get_handle,
		.set = py_lsa_CreateAccount_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_lsa_CreateAccount_in_get_sid,
		.set = py_lsa_CreateAccount_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_CreateAccount_in_get_access_mask,
		.set = py_lsa_CreateAccount_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_AccountAccessMask")
	},
	{
		.name = discard_const_p(char, "out_acct_handle"),
		.get = py_lsa_CreateAccount_out_get_acct_handle,
		.set = py_lsa_CreateAccount_out_set_acct_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_CreateAccount_get_result,
		.set = py_lsa_CreateAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_CreateAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_CreateAccount, type);
	struct lsa_CreateAccount *_self = (struct lsa_CreateAccount *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid2);
	_self->out.acct_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_CreateAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_lsa_CreateAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_CreateAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_CreateAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_CreateAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_CreateAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_CreateAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_CreateAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_CreateAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_CreateAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_CreateAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_CreateAccount_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[10];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_CreateAccount_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_CreateAccount_ndr_print(py_obj, "lsa_CreateAccount_in", NDR_IN);
}

static PyObject *py_lsa_CreateAccount_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_CreateAccount_ndr_print(py_obj, "lsa_CreateAccount_out", NDR_OUT);
}

static PyMethodDef py_lsa_CreateAccount_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_CreateAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.CreateAccount.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_CreateAccount_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_CreateAccount_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_CreateAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.CreateAccount",
	.tp_getset = py_lsa_CreateAccount_getsetters,
	.tp_methods = py_lsa_CreateAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_CreateAccount_new,
};

static bool pack_py_lsa_CreateAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateAccount *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "sid", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_CreateAccount", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_access_mask)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateAccount_args_out(struct lsa_CreateAccount *r)
{
	PyObject *result;
	PyObject *py_acct_handle;
	py_acct_handle = pytalloc_reference_ex(policy_handle_Type, r->out.acct_handle, r->out.acct_handle);
	result = py_acct_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_EnumAccounts_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_EnumAccounts_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumAccounts_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	return py_resume_handle;
}

static int py_lsa_EnumAccounts_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
	if (object->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumAccounts_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	return py_resume_handle;
}

static int py_lsa_EnumAccounts_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
	if (object->out.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumAccounts_out_get_sids(PyObject *obj, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->out.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&lsa_SidArray_Type, object->out.sids, object->out.sids);
	return py_sids;
}

static int py_lsa_EnumAccounts_out_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.sids");
		return -1;
	}
	object->out.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sids);
	if (object->out.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sids = (struct lsa_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumAccounts_in_get_num_entries(PyObject *obj, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_entries));
	return py_num_entries;
}

static int py_lsa_EnumAccounts_in_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.num_entries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumAccounts_get_result(PyObject *obj, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_EnumAccounts_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_EnumAccounts_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_EnumAccounts_in_get_handle,
		.set = py_lsa_EnumAccounts_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_lsa_EnumAccounts_in_get_resume_handle,
		.set = py_lsa_EnumAccounts_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_lsa_EnumAccounts_out_get_resume_handle,
		.set = py_lsa_EnumAccounts_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_sids"),
		.get = py_lsa_EnumAccounts_out_get_sids,
		.set = py_lsa_EnumAccounts_out_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidArray")
	},
	{
		.name = discard_const_p(char, "in_num_entries"),
		.get = py_lsa_EnumAccounts_in_get_num_entries,
		.set = py_lsa_EnumAccounts_in_set_num_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_EnumAccounts_get_result,
		.set = py_lsa_EnumAccounts_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_EnumAccounts_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_EnumAccounts, type);
	struct lsa_EnumAccounts *_self = (struct lsa_EnumAccounts *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.sids = talloc_zero(mem_ctx, struct lsa_SidArray);
	return self;
}

static PyObject *py_lsa_EnumAccounts_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_lsa_EnumAccounts_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumAccounts_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_EnumAccounts_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumAccounts_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_EnumAccounts_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumAccounts_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_EnumAccounts_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumAccounts_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_EnumAccounts_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumAccounts_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumAccounts_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumAccounts_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumAccounts_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumAccounts *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumAccounts_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[11];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_EnumAccounts_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumAccounts_ndr_print(py_obj, "lsa_EnumAccounts_in", NDR_IN);
}

static PyObject *py_lsa_EnumAccounts_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumAccounts_ndr_print(py_obj, "lsa_EnumAccounts_out", NDR_OUT);
}

static PyMethodDef py_lsa_EnumAccounts_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_EnumAccounts_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.EnumAccounts.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumAccounts_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumAccounts_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumAccounts_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumAccounts_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_EnumAccounts_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_EnumAccounts_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_EnumAccounts_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.EnumAccounts",
	.tp_getset = py_lsa_EnumAccounts_getsetters,
	.tp_methods = py_lsa_EnumAccounts_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_EnumAccounts_new,
};

static bool pack_py_lsa_EnumAccounts_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumAccounts *r)
{
	PyObject *py_handle;
	PyObject *py_resume_handle;
	PyObject *py_num_entries;
	const char *kwnames[] = {
		"handle", "resume_handle", "num_entries", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_EnumAccounts", discard_const_p(char *, kwnames), &py_handle, &py_resume_handle, &py_num_entries)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	if (r->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
		if (PyLong_Check(py_resume_handle)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_num_entries == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.num_entries");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.num_entries));
		if (PyLong_Check(py_num_entries)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_num_entries);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.num_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_EnumAccounts_args_out(struct lsa_EnumAccounts *r)
{
	PyObject *result;
	PyObject *py_resume_handle;
	PyObject *py_sids;
	result = PyTuple_New(2);
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	PyTuple_SetItem(result, 0, py_resume_handle);
	py_sids = pytalloc_reference_ex(&lsa_SidArray_Type, r->out.sids, r->out.sids);
	PyTuple_SetItem(result, 1, py_sids);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_CreateTrustedDomain_in_get_policy_handle(PyObject *obj, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_policy_handle;
	if (object->in.policy_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_policy_handle = pytalloc_reference_ex(policy_handle_Type, object->in.policy_handle, object->in.policy_handle);
	return py_policy_handle;
}

static int py_lsa_CreateTrustedDomain_in_set_policy_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.policy_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.policy_handle");
		return -1;
	}
	object->in.policy_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.policy_handle);
	if (object->in.policy_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.policy_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateTrustedDomain_in_get_info(PyObject *obj, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&lsa_DomainInfo_Type, object->in.info, object->in.info);
	return py_info;
}

static int py_lsa_CreateTrustedDomain_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_DomainInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info = (struct lsa_DomainInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateTrustedDomain_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_CreateTrustedDomain_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_CreateTrustedDomain_out_get_trustdom_handle(PyObject *obj, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_trustdom_handle;
	if (object->out.trustdom_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, object->out.trustdom_handle, object->out.trustdom_handle);
	return py_trustdom_handle;
}

static int py_lsa_CreateTrustedDomain_out_set_trustdom_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.trustdom_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.trustdom_handle");
		return -1;
	}
	object->out.trustdom_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.trustdom_handle);
	if (object->out.trustdom_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateTrustedDomain_get_result(PyObject *obj, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_CreateTrustedDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_CreateTrustedDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_policy_handle"),
		.get = py_lsa_CreateTrustedDomain_in_get_policy_handle,
		.set = py_lsa_CreateTrustedDomain_in_set_policy_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_lsa_CreateTrustedDomain_in_get_info,
		.set = py_lsa_CreateTrustedDomain_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DomainInfo")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_CreateTrustedDomain_in_get_access_mask,
		.set = py_lsa_CreateTrustedDomain_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustedAccessMask")
	},
	{
		.name = discard_const_p(char, "out_trustdom_handle"),
		.get = py_lsa_CreateTrustedDomain_out_get_trustdom_handle,
		.set = py_lsa_CreateTrustedDomain_out_set_trustdom_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_CreateTrustedDomain_get_result,
		.set = py_lsa_CreateTrustedDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_CreateTrustedDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_CreateTrustedDomain, type);
	struct lsa_CreateTrustedDomain *_self = (struct lsa_CreateTrustedDomain *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.policy_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.info = talloc_zero(mem_ctx, struct lsa_DomainInfo);
	_self->out.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateTrustedDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_CreateTrustedDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_CreateTrustedDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateTrustedDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_CreateTrustedDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_CreateTrustedDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateTrustedDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateTrustedDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[12];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_CreateTrustedDomain_ndr_print(py_obj, "lsa_CreateTrustedDomain_in", NDR_IN);
}

static PyObject *py_lsa_CreateTrustedDomain_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_CreateTrustedDomain_ndr_print(py_obj, "lsa_CreateTrustedDomain_out", NDR_OUT);
}

static PyMethodDef py_lsa_CreateTrustedDomain_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_CreateTrustedDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.CreateTrustedDomain.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateTrustedDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateTrustedDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateTrustedDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateTrustedDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_CreateTrustedDomain_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_CreateTrustedDomain_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_CreateTrustedDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.CreateTrustedDomain",
	.tp_getset = py_lsa_CreateTrustedDomain_getsetters,
	.tp_methods = py_lsa_CreateTrustedDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_CreateTrustedDomain_new,
};

static bool pack_py_lsa_CreateTrustedDomain_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateTrustedDomain *r)
{
	PyObject *py_policy_handle;
	PyObject *py_info;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"policy_handle", "info", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_CreateTrustedDomain", discard_const_p(char *, kwnames), &py_policy_handle, &py_info, &py_access_mask)) {
		return false;
	}

	if (py_policy_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.policy_handle");
		return false;
	}
	r->in.policy_handle = talloc_ptrtype(r, r->in.policy_handle);
	if (r->in.policy_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_policy_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_policy_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.policy_handle = (struct policy_handle *)pytalloc_get_ptr(py_policy_handle);
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_DomainInfo_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct lsa_DomainInfo *)pytalloc_get_ptr(py_info);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateTrustedDomain_args_out(struct lsa_CreateTrustedDomain *r)
{
	PyObject *result;
	PyObject *py_trustdom_handle;
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, r->out.trustdom_handle, r->out.trustdom_handle);
	result = py_trustdom_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_EnumTrustDom_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_EnumTrustDom_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumTrustDom_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	return py_resume_handle;
}

static int py_lsa_EnumTrustDom_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
	if (object->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumTrustDom_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	return py_resume_handle;
}

static int py_lsa_EnumTrustDom_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
	if (object->out.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumTrustDom_out_get_domains(PyObject *obj, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->out.domains == NULL) {
		Py_RETURN_NONE;
	}
	py_domains = pytalloc_reference_ex(&lsa_DomainList_Type, object->out.domains, object->out.domains);
	return py_domains;
}

static int py_lsa_EnumTrustDom_out_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.domains");
		return -1;
	}
	object->out.domains = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domains);
	if (object->out.domains == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_DomainList_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.domains = (struct lsa_DomainList *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumTrustDom_in_get_max_size(PyObject *obj, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(obj);
	PyObject *py_max_size;
	py_max_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_size));
	return py_max_size;
}

static int py_lsa_EnumTrustDom_in_set_max_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.max_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_EnumTrustDom_get_result(PyObject *obj, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_EnumTrustDom_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_EnumTrustDom_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_EnumTrustDom_in_get_handle,
		.set = py_lsa_EnumTrustDom_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_lsa_EnumTrustDom_in_get_resume_handle,
		.set = py_lsa_EnumTrustDom_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_lsa_EnumTrustDom_out_get_resume_handle,
		.set = py_lsa_EnumTrustDom_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_domains"),
		.get = py_lsa_EnumTrustDom_out_get_domains,
		.set = py_lsa_EnumTrustDom_out_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DomainList")
	},
	{
		.name = discard_const_p(char, "in_max_size"),
		.get = py_lsa_EnumTrustDom_in_get_max_size,
		.set = py_lsa_EnumTrustDom_in_set_max_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_EnumTrustDom_get_result,
		.set = py_lsa_EnumTrustDom_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_EnumTrustDom_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_EnumTrustDom, type);
	struct lsa_EnumTrustDom *_self = (struct lsa_EnumTrustDom *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.domains = talloc_zero(mem_ctx, struct lsa_DomainList);
	return self;
}

static PyObject *py_lsa_EnumTrustDom_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(13);
}

static PyObject *py_lsa_EnumTrustDom_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumTrustDom_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[13];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_EnumTrustDom_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumTrustDom_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_EnumTrustDom_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumTrustDom_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_EnumTrustDom_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumTrustDom_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[13];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_EnumTrustDom_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumTrustDom_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumTrustDom_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumTrustDom_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumTrustDom_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumTrustDom *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumTrustDom_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[13];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_EnumTrustDom_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumTrustDom_ndr_print(py_obj, "lsa_EnumTrustDom_in", NDR_IN);
}

static PyObject *py_lsa_EnumTrustDom_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumTrustDom_ndr_print(py_obj, "lsa_EnumTrustDom_out", NDR_OUT);
}

static PyMethodDef py_lsa_EnumTrustDom_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_EnumTrustDom_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.EnumTrustDom.opnum() -> 13 (0x0d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumTrustDom_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumTrustDom_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumTrustDom_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumTrustDom_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_EnumTrustDom_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_EnumTrustDom_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_EnumTrustDom_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.EnumTrustDom",
	.tp_getset = py_lsa_EnumTrustDom_getsetters,
	.tp_methods = py_lsa_EnumTrustDom_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_EnumTrustDom_new,
};

static bool pack_py_lsa_EnumTrustDom_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumTrustDom *r)
{
	PyObject *py_handle;
	PyObject *py_resume_handle;
	PyObject *py_max_size;
	const char *kwnames[] = {
		"handle", "resume_handle", "max_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_EnumTrustDom", discard_const_p(char *, kwnames), &py_handle, &py_resume_handle, &py_max_size)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	if (r->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
		if (PyLong_Check(py_resume_handle)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.max_size");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_size));
		if (PyLong_Check(py_max_size)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_size);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_EnumTrustDom_args_out(struct lsa_EnumTrustDom *r)
{
	PyObject *result;
	PyObject *py_resume_handle;
	PyObject *py_domains;
	result = PyTuple_New(2);
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	PyTuple_SetItem(result, 0, py_resume_handle);
	py_domains = pytalloc_reference_ex(&lsa_DomainList_Type, r->out.domains, r->out.domains);
	PyTuple_SetItem(result, 1, py_domains);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_LookupNames_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_LookupNames_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupNames_in_get_num_names(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_num_names;
	py_num_names = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_names));
	return py_num_names;
}

static int py_lsa_LookupNames_in_set_num_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.num_names");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_names));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_names = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupNames_in_get_names(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	py_names = PyList_New(object->in.num_names);
	if (py_names == NULL) {
		return NULL;
	}
	{
		int names_cntr_0;
		for (names_cntr_0 = 0; names_cntr_0 < (object->in.num_names); names_cntr_0++) {
			PyObject *py_names_0;
			py_names_0 = pytalloc_reference_ex(&lsa_String_Type, object->in.names, &(object->in.names)[names_cntr_0]);
			PyList_SetItem(py_names, names_cntr_0, py_names_0);
		}
	}
	return py_names;
}

static int py_lsa_LookupNames_in_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.names");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int names_cntr_0;
		object->in.names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.names, PyList_GET_SIZE(value));
		if (!object->in.names) { return -1; }
		talloc_set_name_const(object->in.names, "ARRAY: object->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(value); names_cntr_0++) {
			if (PyList_GET_ITEM(value, names_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.names)[names_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(value, names_cntr_0), return -1;);
			if (talloc_reference(object->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.names)[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupNames_out_get_domains(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->out.domains == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *object->out.domains, *object->out.domains);
	}
	return py_domains;
}

static int py_lsa_LookupNames_out_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.domains");
		return -1;
	}
	object->out.domains = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domains);
	if (object->out.domains == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.domains = NULL;
	} else {
		*object->out.domains = NULL;
		PY_CHECK_TYPE(&lsa_RefDomainList_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.domains = (struct lsa_RefDomainList *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_LookupNames_in_get_sids(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->in.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&lsa_TransSidArray_Type, object->in.sids, object->in.sids);
	return py_sids;
}

static int py_lsa_LookupNames_in_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sids");
		return -1;
	}
	object->in.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sids);
	if (object->in.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TransSidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sids = (struct lsa_TransSidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupNames_out_get_sids(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->out.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&lsa_TransSidArray_Type, object->out.sids, object->out.sids);
	return py_sids;
}

static int py_lsa_LookupNames_out_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.sids");
		return -1;
	}
	object->out.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sids);
	if (object->out.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TransSidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sids = (struct lsa_TransSidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupNames_in_get_level(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_lsa_LookupNames_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupNames_in_get_count(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	if (object->in.count == NULL) {
		Py_RETURN_NONE;
	}
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.count));
	return py_count;
}

static int py_lsa_LookupNames_in_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.count));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.count");
		return -1;
	}
	object->in.count = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.count);
	if (object->in.count == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupNames_out_get_count(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	if (object->out.count == NULL) {
		Py_RETURN_NONE;
	}
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.count));
	return py_count;
}

static int py_lsa_LookupNames_out_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.count));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.count");
		return -1;
	}
	object->out.count = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.count);
	if (object->out.count == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupNames_get_result(PyObject *obj, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_LookupNames_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_LookupNames_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_LookupNames_in_get_handle,
		.set = py_lsa_LookupNames_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_num_names"),
		.get = py_lsa_LookupNames_in_get_num_names,
		.set = py_lsa_LookupNames_in_set_num_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_names"),
		.get = py_lsa_LookupNames_in_get_names,
		.set = py_lsa_LookupNames_in_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "out_domains"),
		.get = py_lsa_LookupNames_out_get_domains,
		.set = py_lsa_LookupNames_out_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_RefDomainList")
	},
	{
		.name = discard_const_p(char, "in_sids"),
		.get = py_lsa_LookupNames_in_get_sids,
		.set = py_lsa_LookupNames_in_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TransSidArray")
	},
	{
		.name = discard_const_p(char, "out_sids"),
		.get = py_lsa_LookupNames_out_get_sids,
		.set = py_lsa_LookupNames_out_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TransSidArray")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_lsa_LookupNames_in_get_level,
		.set = py_lsa_LookupNames_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_LookupNamesLevel")
	},
	{
		.name = discard_const_p(char, "in_count"),
		.get = py_lsa_LookupNames_in_get_count,
		.set = py_lsa_LookupNames_in_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_count"),
		.get = py_lsa_LookupNames_out_get_count,
		.set = py_lsa_LookupNames_out_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_LookupNames_get_result,
		.set = py_lsa_LookupNames_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_LookupNames_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_LookupNames, type);
	struct lsa_LookupNames *_self = (struct lsa_LookupNames *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
	_self->in.sids = talloc_zero(mem_ctx, struct lsa_TransSidArray);
	_self->out.sids = talloc_zero(mem_ctx, struct lsa_TransSidArray);
	_self->in.count = talloc_zero(mem_ctx, uint32_t);
	_self->out.count = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_lsa_LookupNames_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(14);
}

static PyObject *py_lsa_LookupNames_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupNames_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[14];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_LookupNames_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupNames_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_LookupNames_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupNames_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_LookupNames_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupNames_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[14];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_LookupNames_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupNames_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupNames_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupNames_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupNames_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupNames *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupNames_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[14];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_LookupNames_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupNames_ndr_print(py_obj, "lsa_LookupNames_in", NDR_IN);
}

static PyObject *py_lsa_LookupNames_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupNames_ndr_print(py_obj, "lsa_LookupNames_out", NDR_OUT);
}

static PyMethodDef py_lsa_LookupNames_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_LookupNames_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.LookupNames.opnum() -> 14 (0x0e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupNames_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupNames_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupNames_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupNames_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_LookupNames_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_LookupNames_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_LookupNames_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.LookupNames",
	.tp_getset = py_lsa_LookupNames_getsetters,
	.tp_methods = py_lsa_LookupNames_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_LookupNames_new,
};

static bool pack_py_lsa_LookupNames_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupNames *r)
{
	PyObject *py_handle;
	PyObject *py_names;
	PyObject *py_sids;
	PyObject *py_level;
	PyObject *py_count;
	const char *kwnames[] = {
		"handle", "names", "sids", "level", "count", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:lsa_LookupNames", discard_const_p(char *, kwnames), &py_handle, &py_names, &py_sids, &py_level, &py_count)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	r->in.num_names = PyList_GET_SIZE(py_names);
	if (py_names == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.names");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	{
		int names_cntr_0;
		r->in.names = talloc_array_ptrtype(r, r->in.names, PyList_GET_SIZE(py_names));
		if (!r->in.names) { return false; }
		talloc_set_name_const(r->in.names, "ARRAY: r->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(py_names); names_cntr_0++) {
			if (PyList_GET_ITEM(py_names, names_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.names)[names_cntr_0]");
				return false;
			}
			PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(py_names, names_cntr_0), return false;);
			if (talloc_reference(r->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_names, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.names)[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_names, names_cntr_0));
		}
	}
	if (py_sids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sids");
		return false;
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	if (r->in.sids == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_TransSidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_TransSidArray *)pytalloc_get_ptr(py_sids);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_count == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.count");
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	if (r->in.count == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.count));
		if (PyLong_Check(py_count)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_count);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupNames_args_out(struct lsa_LookupNames *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_sids;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_sids = pytalloc_reference_ex(&lsa_TransSidArray_Type, r->out.sids, r->out.sids);
	PyTuple_SetItem(result, 1, py_sids);
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.count));
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_LookupSids_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_LookupSids_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupSids_in_get_sids(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->in.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&lsa_SidArray_Type, object->in.sids, object->in.sids);
	return py_sids;
}

static int py_lsa_LookupSids_in_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sids");
		return -1;
	}
	object->in.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sids);
	if (object->in.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupSids_out_get_domains(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->out.domains == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *object->out.domains, *object->out.domains);
	}
	return py_domains;
}

static int py_lsa_LookupSids_out_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.domains");
		return -1;
	}
	object->out.domains = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domains);
	if (object->out.domains == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.domains = NULL;
	} else {
		*object->out.domains = NULL;
		PY_CHECK_TYPE(&lsa_RefDomainList_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.domains = (struct lsa_RefDomainList *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_LookupSids_in_get_names(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->in.names == NULL) {
		Py_RETURN_NONE;
	}
	py_names = pytalloc_reference_ex(&lsa_TransNameArray_Type, object->in.names, object->in.names);
	return py_names;
}

static int py_lsa_LookupSids_in_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.names");
		return -1;
	}
	object->in.names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.names);
	if (object->in.names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TransNameArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.names = (struct lsa_TransNameArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupSids_out_get_names(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->out.names == NULL) {
		Py_RETURN_NONE;
	}
	py_names = pytalloc_reference_ex(&lsa_TransNameArray_Type, object->out.names, object->out.names);
	return py_names;
}

static int py_lsa_LookupSids_out_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.names");
		return -1;
	}
	object->out.names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.names);
	if (object->out.names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_TransNameArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.names = (struct lsa_TransNameArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupSids_in_get_level(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_lsa_LookupSids_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupSids_in_get_count(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	if (object->in.count == NULL) {
		Py_RETURN_NONE;
	}
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.count));
	return py_count;
}

static int py_lsa_LookupSids_in_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.count));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.count");
		return -1;
	}
	object->in.count = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.count);
	if (object->in.count == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupSids_out_get_count(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	if (object->out.count == NULL) {
		Py_RETURN_NONE;
	}
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.count));
	return py_count;
}

static int py_lsa_LookupSids_out_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.count));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.count");
		return -1;
	}
	object->out.count = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.count);
	if (object->out.count == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupSids_get_result(PyObject *obj, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_LookupSids_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_LookupSids_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_LookupSids_in_get_handle,
		.set = py_lsa_LookupSids_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sids"),
		.get = py_lsa_LookupSids_in_get_sids,
		.set = py_lsa_LookupSids_in_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidArray")
	},
	{
		.name = discard_const_p(char, "out_domains"),
		.get = py_lsa_LookupSids_out_get_domains,
		.set = py_lsa_LookupSids_out_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_RefDomainList")
	},
	{
		.name = discard_const_p(char, "in_names"),
		.get = py_lsa_LookupSids_in_get_names,
		.set = py_lsa_LookupSids_in_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TransNameArray")
	},
	{
		.name = discard_const_p(char, "out_names"),
		.get = py_lsa_LookupSids_out_get_names,
		.set = py_lsa_LookupSids_out_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TransNameArray")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_lsa_LookupSids_in_get_level,
		.set = py_lsa_LookupSids_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_LookupNamesLevel")
	},
	{
		.name = discard_const_p(char, "in_count"),
		.get = py_lsa_LookupSids_in_get_count,
		.set = py_lsa_LookupSids_in_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_count"),
		.get = py_lsa_LookupSids_out_get_count,
		.set = py_lsa_LookupSids_out_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_LookupSids_get_result,
		.set = py_lsa_LookupSids_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_LookupSids_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_LookupSids, type);
	struct lsa_LookupSids *_self = (struct lsa_LookupSids *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sids = talloc_zero(mem_ctx, struct lsa_SidArray);
	/* a pointer to a NULL pointer */
	_self->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
	_self->in.names = talloc_zero(mem_ctx, struct lsa_TransNameArray);
	_self->out.names = talloc_zero(mem_ctx, struct lsa_TransNameArray);
	_self->in.count = talloc_zero(mem_ctx, uint32_t);
	_self->out.count = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_lsa_LookupSids_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(15);
}

static PyObject *py_lsa_LookupSids_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupSids_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[15];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_LookupSids_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupSids_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_LookupSids_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupSids_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_LookupSids_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupSids_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[15];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_LookupSids_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupSids_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupSids_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupSids_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupSids_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupSids *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupSids_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[15];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_LookupSids_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupSids_ndr_print(py_obj, "lsa_LookupSids_in", NDR_IN);
}

static PyObject *py_lsa_LookupSids_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupSids_ndr_print(py_obj, "lsa_LookupSids_out", NDR_OUT);
}

static PyMethodDef py_lsa_LookupSids_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_LookupSids_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.LookupSids.opnum() -> 15 (0x0f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupSids_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupSids_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupSids_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupSids_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_LookupSids_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_LookupSids_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_LookupSids_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.LookupSids",
	.tp_getset = py_lsa_LookupSids_getsetters,
	.tp_methods = py_lsa_LookupSids_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_LookupSids_new,
};

static bool pack_py_lsa_LookupSids_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupSids *r)
{
	PyObject *py_handle;
	PyObject *py_sids;
	PyObject *py_names;
	PyObject *py_level;
	PyObject *py_count;
	const char *kwnames[] = {
		"handle", "sids", "names", "level", "count", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:lsa_LookupSids", discard_const_p(char *, kwnames), &py_handle, &py_sids, &py_names, &py_level, &py_count)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sids");
		return false;
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	if (r->in.sids == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_SidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(py_sids);
	if (py_names == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.names");
		return false;
	}
	r->in.names = talloc_ptrtype(r, r->in.names);
	if (r->in.names == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_TransNameArray_Type, py_names, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_names)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.names = (struct lsa_TransNameArray *)pytalloc_get_ptr(py_names);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_count == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.count");
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	if (r->in.count == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.count));
		if (PyLong_Check(py_count)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_count);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupSids_args_out(struct lsa_LookupSids *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_names;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_names = pytalloc_reference_ex(&lsa_TransNameArray_Type, r->out.names, r->out.names);
	PyTuple_SetItem(result, 1, py_names);
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.count));
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_CreateSecret_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_CreateSecret_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateSecret_in_get_name(PyObject *obj, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->in.name);
	return py_name;
}

static int py_lsa_CreateSecret_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateSecret_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_CreateSecret_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_CreateSecret_out_get_sec_handle(PyObject *obj, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_handle;
	if (object->out.sec_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, object->out.sec_handle, object->out.sec_handle);
	return py_sec_handle;
}

static int py_lsa_CreateSecret_out_set_sec_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sec_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.sec_handle");
		return -1;
	}
	object->out.sec_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sec_handle);
	if (object->out.sec_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sec_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_CreateSecret_get_result(PyObject *obj, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_CreateSecret_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_CreateSecret_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_CreateSecret_in_get_handle,
		.set = py_lsa_CreateSecret_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_lsa_CreateSecret_in_get_name,
		.set = py_lsa_CreateSecret_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_CreateSecret_in_get_access_mask,
		.set = py_lsa_CreateSecret_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SecretAccessMask")
	},
	{
		.name = discard_const_p(char, "out_sec_handle"),
		.get = py_lsa_CreateSecret_out_get_sec_handle,
		.set = py_lsa_CreateSecret_out_set_sec_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_CreateSecret_get_result,
		.set = py_lsa_CreateSecret_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_CreateSecret_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_CreateSecret, type);
	struct lsa_CreateSecret *_self = (struct lsa_CreateSecret *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.sec_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_CreateSecret_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(16);
}

static PyObject *py_lsa_CreateSecret_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateSecret_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[16];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_CreateSecret_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_CreateSecret_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_CreateSecret_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_CreateSecret_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_CreateSecret_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateSecret_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[16];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_CreateSecret_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_CreateSecret_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_CreateSecret_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_CreateSecret_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_CreateSecret_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_CreateSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_CreateSecret_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[16];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_CreateSecret_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_CreateSecret_ndr_print(py_obj, "lsa_CreateSecret_in", NDR_IN);
}

static PyObject *py_lsa_CreateSecret_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_CreateSecret_ndr_print(py_obj, "lsa_CreateSecret_out", NDR_OUT);
}

static PyMethodDef py_lsa_CreateSecret_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_CreateSecret_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.CreateSecret.opnum() -> 16 (0x10) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateSecret_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateSecret_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateSecret_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_CreateSecret_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_CreateSecret_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_CreateSecret_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_CreateSecret_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.CreateSecret",
	.tp_getset = py_lsa_CreateSecret_getsetters,
	.tp_methods = py_lsa_CreateSecret_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_CreateSecret_new,
};

static bool pack_py_lsa_CreateSecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateSecret *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_CreateSecret", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_access_mask)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name");
		return false;
	}
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct lsa_String *)pytalloc_get_ptr(py_name);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateSecret_args_out(struct lsa_CreateSecret *r)
{
	PyObject *result;
	PyObject *py_sec_handle;
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, r->out.sec_handle, r->out.sec_handle);
	result = py_sec_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_OpenAccount_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_OpenAccount_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenAccount_in_get_sid(PyObject *obj, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_lsa_OpenAccount_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenAccount_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_OpenAccount_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_OpenAccount_out_get_acct_handle(PyObject *obj, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_handle;
	if (object->out.acct_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_acct_handle = pytalloc_reference_ex(policy_handle_Type, object->out.acct_handle, object->out.acct_handle);
	return py_acct_handle;
}

static int py_lsa_OpenAccount_out_set_acct_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.acct_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.acct_handle");
		return -1;
	}
	object->out.acct_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.acct_handle);
	if (object->out.acct_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.acct_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenAccount_get_result(PyObject *obj, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_OpenAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_OpenAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_OpenAccount_in_get_handle,
		.set = py_lsa_OpenAccount_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_lsa_OpenAccount_in_get_sid,
		.set = py_lsa_OpenAccount_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_OpenAccount_in_get_access_mask,
		.set = py_lsa_OpenAccount_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_AccountAccessMask")
	},
	{
		.name = discard_const_p(char, "out_acct_handle"),
		.get = py_lsa_OpenAccount_out_get_acct_handle,
		.set = py_lsa_OpenAccount_out_set_acct_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_OpenAccount_get_result,
		.set = py_lsa_OpenAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_OpenAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_OpenAccount, type);
	struct lsa_OpenAccount *_self = (struct lsa_OpenAccount *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid2);
	_self->out.acct_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_OpenAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(17);
}

static PyObject *py_lsa_OpenAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[17];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_OpenAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_OpenAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_OpenAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[17];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_OpenAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenAccount_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[17];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_OpenAccount_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenAccount_ndr_print(py_obj, "lsa_OpenAccount_in", NDR_IN);
}

static PyObject *py_lsa_OpenAccount_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenAccount_ndr_print(py_obj, "lsa_OpenAccount_out", NDR_OUT);
}

static PyMethodDef py_lsa_OpenAccount_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_OpenAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.OpenAccount.opnum() -> 17 (0x11) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_OpenAccount_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_OpenAccount_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_OpenAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.OpenAccount",
	.tp_getset = py_lsa_OpenAccount_getsetters,
	.tp_methods = py_lsa_OpenAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_OpenAccount_new,
};

static bool pack_py_lsa_OpenAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenAccount *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "sid", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenAccount", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_access_mask)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenAccount_args_out(struct lsa_OpenAccount *r)
{
	PyObject *result;
	PyObject *py_acct_handle;
	py_acct_handle = pytalloc_reference_ex(policy_handle_Type, r->out.acct_handle, r->out.acct_handle);
	result = py_acct_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_EnumPrivsAccount_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_EnumPrivsAccount_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumPrivsAccount_out_get_privs(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_privs;
	if (object->out.privs == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.privs == NULL) {
		py_privs = Py_None;
		Py_INCREF(py_privs);
	} else {
		py_privs = pytalloc_reference_ex(&lsa_PrivilegeSet_Type, *object->out.privs, *object->out.privs);
	}
	return py_privs;
}

static int py_lsa_EnumPrivsAccount_out_set_privs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.privs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.privs");
		return -1;
	}
	object->out.privs = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.privs);
	if (object->out.privs == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.privs = NULL;
	} else {
		*object->out.privs = NULL;
		PY_CHECK_TYPE(&lsa_PrivilegeSet_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.privs = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_EnumPrivsAccount_get_result(PyObject *obj, void *closure)
{
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_EnumPrivsAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_EnumPrivsAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_EnumPrivsAccount_in_get_handle,
		.set = py_lsa_EnumPrivsAccount_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_privs"),
		.get = py_lsa_EnumPrivsAccount_out_get_privs,
		.set = py_lsa_EnumPrivsAccount_out_set_privs,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PrivilegeSet")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_EnumPrivsAccount_get_result,
		.set = py_lsa_EnumPrivsAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_EnumPrivsAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_EnumPrivsAccount, type);
	struct lsa_EnumPrivsAccount *_self = (struct lsa_EnumPrivsAccount *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.privs = talloc_zero(mem_ctx, struct lsa_PrivilegeSet *);
	return self;
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(18);
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumPrivsAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[18];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumPrivsAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_EnumPrivsAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumPrivsAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[18];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumPrivsAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_EnumPrivsAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_EnumPrivsAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_EnumPrivsAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[18];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumPrivsAccount_ndr_print(py_obj, "lsa_EnumPrivsAccount_in", NDR_IN);
}

static PyObject *py_lsa_EnumPrivsAccount_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_EnumPrivsAccount_ndr_print(py_obj, "lsa_EnumPrivsAccount_out", NDR_OUT);
}

static PyMethodDef py_lsa_EnumPrivsAccount_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_EnumPrivsAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.EnumPrivsAccount.opnum() -> 18 (0x12) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivsAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivsAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivsAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_EnumPrivsAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_EnumPrivsAccount_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_EnumPrivsAccount_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_EnumPrivsAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.EnumPrivsAccount",
	.tp_getset = py_lsa_EnumPrivsAccount_getsetters,
	.tp_methods = py_lsa_EnumPrivsAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_EnumPrivsAccount_new,
};

static bool pack_py_lsa_EnumPrivsAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumPrivsAccount *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_EnumPrivsAccount", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_EnumPrivsAccount_args_out(struct lsa_EnumPrivsAccount *r)
{
	PyObject *result;
	PyObject *py_privs;
	if (*r->out.privs == NULL) {
		py_privs = Py_None;
		Py_INCREF(py_privs);
	} else {
		py_privs = pytalloc_reference_ex(&lsa_PrivilegeSet_Type, *r->out.privs, *r->out.privs);
	}
	result = py_privs;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_AddPrivilegesToAccount_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_AddPrivilegesToAccount_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_AddPrivilegesToAccount_in_get_privs(PyObject *obj, void *closure)
{
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_privs;
	if (object->in.privs == NULL) {
		Py_RETURN_NONE;
	}
	py_privs = pytalloc_reference_ex(&lsa_PrivilegeSet_Type, object->in.privs, object->in.privs);
	return py_privs;
}

static int py_lsa_AddPrivilegesToAccount_in_set_privs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.privs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.privs");
		return -1;
	}
	object->in.privs = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.privs);
	if (object->in.privs == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_PrivilegeSet_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.privs = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_AddPrivilegesToAccount_get_result(PyObject *obj, void *closure)
{
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_AddPrivilegesToAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_AddPrivilegesToAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_AddPrivilegesToAccount_in_get_handle,
		.set = py_lsa_AddPrivilegesToAccount_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_privs"),
		.get = py_lsa_AddPrivilegesToAccount_in_get_privs,
		.set = py_lsa_AddPrivilegesToAccount_in_set_privs,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PrivilegeSet")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_AddPrivilegesToAccount_get_result,
		.set = py_lsa_AddPrivilegesToAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_AddPrivilegesToAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_AddPrivilegesToAccount, type);
	struct lsa_AddPrivilegesToAccount *_self = (struct lsa_AddPrivilegesToAccount *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.privs = talloc_zero(mem_ctx, struct lsa_PrivilegeSet);
	return self;
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(19);
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_AddPrivilegesToAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[19];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_AddPrivilegesToAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_AddPrivilegesToAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_AddPrivilegesToAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[19];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_AddPrivilegesToAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_AddPrivilegesToAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_AddPrivilegesToAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_AddPrivilegesToAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[19];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_AddPrivilegesToAccount_ndr_print(py_obj, "lsa_AddPrivilegesToAccount_in", NDR_IN);
}

static PyObject *py_lsa_AddPrivilegesToAccount_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_AddPrivilegesToAccount_ndr_print(py_obj, "lsa_AddPrivilegesToAccount_out", NDR_OUT);
}

static PyMethodDef py_lsa_AddPrivilegesToAccount_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_AddPrivilegesToAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.AddPrivilegesToAccount.opnum() -> 19 (0x13) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_AddPrivilegesToAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_AddPrivilegesToAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_AddPrivilegesToAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_AddPrivilegesToAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_AddPrivilegesToAccount_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_AddPrivilegesToAccount_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_AddPrivilegesToAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.AddPrivilegesToAccount",
	.tp_getset = py_lsa_AddPrivilegesToAccount_getsetters,
	.tp_methods = py_lsa_AddPrivilegesToAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_AddPrivilegesToAccount_new,
};

static bool pack_py_lsa_AddPrivilegesToAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_AddPrivilegesToAccount *r)
{
	PyObject *py_handle;
	PyObject *py_privs;
	const char *kwnames[] = {
		"handle", "privs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_AddPrivilegesToAccount", discard_const_p(char *, kwnames), &py_handle, &py_privs)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_privs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.privs");
		return false;
	}
	r->in.privs = talloc_ptrtype(r, r->in.privs);
	if (r->in.privs == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_PrivilegeSet_Type, py_privs, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_privs)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.privs = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(py_privs);
	return true;
}

static PyObject *unpack_py_lsa_AddPrivilegesToAccount_args_out(struct lsa_AddPrivilegesToAccount *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_RemovePrivilegesFromAccount_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_RemovePrivilegesFromAccount_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_in_get_remove_all(PyObject *obj, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_remove_all;
	py_remove_all = PyLong_FromLong((uint16_t)(object->in.remove_all));
	return py_remove_all;
}

static int py_lsa_RemovePrivilegesFromAccount_in_set_remove_all(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.remove_all");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.remove_all));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.remove_all = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_in_get_privs(PyObject *obj, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_privs;
	if (object->in.privs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.privs == NULL) {
		py_privs = Py_None;
		Py_INCREF(py_privs);
	} else {
		py_privs = pytalloc_reference_ex(&lsa_PrivilegeSet_Type, object->in.privs, object->in.privs);
	}
	return py_privs;
}

static int py_lsa_RemovePrivilegesFromAccount_in_set_privs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.privs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.privs");
		return -1;
	}
	if (value == Py_None) {
		object->in.privs = NULL;
	} else {
		object->in.privs = NULL;
		PY_CHECK_TYPE(&lsa_PrivilegeSet_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.privs = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_get_result(PyObject *obj, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_RemovePrivilegesFromAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_RemovePrivilegesFromAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_RemovePrivilegesFromAccount_in_get_handle,
		.set = py_lsa_RemovePrivilegesFromAccount_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_remove_all"),
		.get = py_lsa_RemovePrivilegesFromAccount_in_get_remove_all,
		.set = py_lsa_RemovePrivilegesFromAccount_in_set_remove_all,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_privs"),
		.get = py_lsa_RemovePrivilegesFromAccount_in_get_privs,
		.set = py_lsa_RemovePrivilegesFromAccount_in_set_privs,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_PrivilegeSet")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_RemovePrivilegesFromAccount_get_result,
		.set = py_lsa_RemovePrivilegesFromAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_RemovePrivilegesFromAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_RemovePrivilegesFromAccount, type);
	struct lsa_RemovePrivilegesFromAccount *_self = (struct lsa_RemovePrivilegesFromAccount *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(20);
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_RemovePrivilegesFromAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[20];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_RemovePrivilegesFromAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_RemovePrivilegesFromAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_RemovePrivilegesFromAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[20];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_RemovePrivilegesFromAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_RemovePrivilegesFromAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_RemovePrivilegesFromAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_RemovePrivilegesFromAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[20];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_RemovePrivilegesFromAccount_ndr_print(py_obj, "lsa_RemovePrivilegesFromAccount_in", NDR_IN);
}

static PyObject *py_lsa_RemovePrivilegesFromAccount_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_RemovePrivilegesFromAccount_ndr_print(py_obj, "lsa_RemovePrivilegesFromAccount_out", NDR_OUT);
}

static PyMethodDef py_lsa_RemovePrivilegesFromAccount_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_RemovePrivilegesFromAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.RemovePrivilegesFromAccount.opnum() -> 20 (0x14) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_RemovePrivilegesFromAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_RemovePrivilegesFromAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_RemovePrivilegesFromAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_RemovePrivilegesFromAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_RemovePrivilegesFromAccount_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_RemovePrivilegesFromAccount_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_RemovePrivilegesFromAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.RemovePrivilegesFromAccount",
	.tp_getset = py_lsa_RemovePrivilegesFromAccount_getsetters,
	.tp_methods = py_lsa_RemovePrivilegesFromAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_RemovePrivilegesFromAccount_new,
};

static bool pack_py_lsa_RemovePrivilegesFromAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_RemovePrivilegesFromAccount *r)
{
	PyObject *py_handle;
	PyObject *py_remove_all;
	PyObject *py_privs;
	const char *kwnames[] = {
		"handle", "remove_all", "privs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_RemovePrivilegesFromAccount", discard_const_p(char *, kwnames), &py_handle, &py_remove_all, &py_privs)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_remove_all == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.remove_all");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.remove_all));
		if (PyLong_Check(py_remove_all)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_remove_all);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.remove_all = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_privs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.privs");
		return false;
	}
	if (py_privs == Py_None) {
		r->in.privs = NULL;
	} else {
		r->in.privs = NULL;
		PY_CHECK_TYPE(&lsa_PrivilegeSet_Type, py_privs, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_privs)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.privs = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(py_privs);
	}
	return true;
}

static PyObject *unpack_py_lsa_RemovePrivilegesFromAccount_args_out(struct lsa_RemovePrivilegesFromAccount *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_GetSystemAccessAccount_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_GetSystemAccessAccount_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_GetSystemAccessAccount_out_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	if (object->out.access_mask == NULL) {
		Py_RETURN_NONE;
	}
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.access_mask));
	return py_access_mask;
}

static int py_lsa_GetSystemAccessAccount_out_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.access_mask));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.access_mask");
		return -1;
	}
	object->out.access_mask = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.access_mask);
	if (object->out.access_mask == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_GetSystemAccessAccount_get_result(PyObject *obj, void *closure)
{
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_GetSystemAccessAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_GetSystemAccessAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_GetSystemAccessAccount_in_get_handle,
		.set = py_lsa_GetSystemAccessAccount_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_access_mask"),
		.get = py_lsa_GetSystemAccessAccount_out_get_access_mask,
		.set = py_lsa_GetSystemAccessAccount_out_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_AccountAccessMask")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_GetSystemAccessAccount_get_result,
		.set = py_lsa_GetSystemAccessAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_GetSystemAccessAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_GetSystemAccessAccount, type);
	struct lsa_GetSystemAccessAccount *_self = (struct lsa_GetSystemAccessAccount *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.access_mask = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(23);
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_GetSystemAccessAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[23];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_GetSystemAccessAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_GetSystemAccessAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_GetSystemAccessAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[23];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_GetSystemAccessAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_GetSystemAccessAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_GetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_GetSystemAccessAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[23];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_GetSystemAccessAccount_ndr_print(py_obj, "lsa_GetSystemAccessAccount_in", NDR_IN);
}

static PyObject *py_lsa_GetSystemAccessAccount_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_GetSystemAccessAccount_ndr_print(py_obj, "lsa_GetSystemAccessAccount_out", NDR_OUT);
}

static PyMethodDef py_lsa_GetSystemAccessAccount_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_GetSystemAccessAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.GetSystemAccessAccount.opnum() -> 23 (0x17) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_GetSystemAccessAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_GetSystemAccessAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_GetSystemAccessAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_GetSystemAccessAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_GetSystemAccessAccount_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_GetSystemAccessAccount_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_GetSystemAccessAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.GetSystemAccessAccount",
	.tp_getset = py_lsa_GetSystemAccessAccount_getsetters,
	.tp_methods = py_lsa_GetSystemAccessAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_GetSystemAccessAccount_new,
};

static bool pack_py_lsa_GetSystemAccessAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_GetSystemAccessAccount *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_GetSystemAccessAccount", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_GetSystemAccessAccount_args_out(struct lsa_GetSystemAccessAccount *r)
{
	PyObject *result;
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.access_mask));
	result = py_access_mask;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_SetSystemAccessAccount_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_SetSystemAccessAccount_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_SetSystemAccessAccount_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_SetSystemAccessAccount_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_SetSystemAccessAccount_get_result(PyObject *obj, void *closure)
{
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_SetSystemAccessAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_SetSystemAccessAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_SetSystemAccessAccount_in_get_handle,
		.set = py_lsa_SetSystemAccessAccount_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_SetSystemAccessAccount_in_get_access_mask,
		.set = py_lsa_SetSystemAccessAccount_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_AccountAccessMask")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_SetSystemAccessAccount_get_result,
		.set = py_lsa_SetSystemAccessAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_SetSystemAccessAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_SetSystemAccessAccount, type);
	struct lsa_SetSystemAccessAccount *_self = (struct lsa_SetSystemAccessAccount *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(24);
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSystemAccessAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[24];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetSystemAccessAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetSystemAccessAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSystemAccessAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[24];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetSystemAccessAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetSystemAccessAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSystemAccessAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSystemAccessAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[24];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetSystemAccessAccount_ndr_print(py_obj, "lsa_SetSystemAccessAccount_in", NDR_IN);
}

static PyObject *py_lsa_SetSystemAccessAccount_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetSystemAccessAccount_ndr_print(py_obj, "lsa_SetSystemAccessAccount_out", NDR_OUT);
}

static PyMethodDef py_lsa_SetSystemAccessAccount_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_SetSystemAccessAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.SetSystemAccessAccount.opnum() -> 24 (0x18) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSystemAccessAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSystemAccessAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSystemAccessAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSystemAccessAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_SetSystemAccessAccount_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_SetSystemAccessAccount_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_SetSystemAccessAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.SetSystemAccessAccount",
	.tp_getset = py_lsa_SetSystemAccessAccount_getsetters,
	.tp_methods = py_lsa_SetSystemAccessAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_SetSystemAccessAccount_new,
};

static bool pack_py_lsa_SetSystemAccessAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetSystemAccessAccount *r)
{
	PyObject *py_handle;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_SetSystemAccessAccount", discard_const_p(char *, kwnames), &py_handle, &py_access_mask)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_SetSystemAccessAccount_args_out(struct lsa_SetSystemAccessAccount *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_OpenTrustedDomain_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_OpenTrustedDomain_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenTrustedDomain_in_get_sid(PyObject *obj, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_lsa_OpenTrustedDomain_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenTrustedDomain_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_OpenTrustedDomain_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_OpenTrustedDomain_out_get_trustdom_handle(PyObject *obj, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_trustdom_handle;
	if (object->out.trustdom_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, object->out.trustdom_handle, object->out.trustdom_handle);
	return py_trustdom_handle;
}

static int py_lsa_OpenTrustedDomain_out_set_trustdom_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.trustdom_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.trustdom_handle");
		return -1;
	}
	object->out.trustdom_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.trustdom_handle);
	if (object->out.trustdom_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenTrustedDomain_get_result(PyObject *obj, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_OpenTrustedDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_OpenTrustedDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_OpenTrustedDomain_in_get_handle,
		.set = py_lsa_OpenTrustedDomain_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_lsa_OpenTrustedDomain_in_get_sid,
		.set = py_lsa_OpenTrustedDomain_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_OpenTrustedDomain_in_get_access_mask,
		.set = py_lsa_OpenTrustedDomain_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustedAccessMask")
	},
	{
		.name = discard_const_p(char, "out_trustdom_handle"),
		.get = py_lsa_OpenTrustedDomain_out_get_trustdom_handle,
		.set = py_lsa_OpenTrustedDomain_out_set_trustdom_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_OpenTrustedDomain_get_result,
		.set = py_lsa_OpenTrustedDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_OpenTrustedDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_OpenTrustedDomain, type);
	struct lsa_OpenTrustedDomain *_self = (struct lsa_OpenTrustedDomain *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid2);
	_self->out.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(25);
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenTrustedDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[25];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenTrustedDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenTrustedDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenTrustedDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[25];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenTrustedDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenTrustedDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenTrustedDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenTrustedDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[25];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenTrustedDomain_ndr_print(py_obj, "lsa_OpenTrustedDomain_in", NDR_IN);
}

static PyObject *py_lsa_OpenTrustedDomain_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenTrustedDomain_ndr_print(py_obj, "lsa_OpenTrustedDomain_out", NDR_OUT);
}

static PyMethodDef py_lsa_OpenTrustedDomain_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_OpenTrustedDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.OpenTrustedDomain.opnum() -> 25 (0x19) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenTrustedDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenTrustedDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenTrustedDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenTrustedDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_OpenTrustedDomain_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_OpenTrustedDomain_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_OpenTrustedDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.OpenTrustedDomain",
	.tp_getset = py_lsa_OpenTrustedDomain_getsetters,
	.tp_methods = py_lsa_OpenTrustedDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_OpenTrustedDomain_new,
};

static bool pack_py_lsa_OpenTrustedDomain_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenTrustedDomain *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "sid", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenTrustedDomain", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_access_mask)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenTrustedDomain_args_out(struct lsa_OpenTrustedDomain *r)
{
	PyObject *result;
	PyObject *py_trustdom_handle;
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, r->out.trustdom_handle, r->out.trustdom_handle);
	result = py_trustdom_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_QueryTrustedDomainInfo_in_get_trustdom_handle(PyObject *obj, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_trustdom_handle;
	if (object->in.trustdom_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, object->in.trustdom_handle, object->in.trustdom_handle);
	return py_trustdom_handle;
}

static int py_lsa_QueryTrustedDomainInfo_in_set_trustdom_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.trustdom_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.trustdom_handle");
		return -1;
	}
	object->in.trustdom_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.trustdom_handle);
	if (object->in.trustdom_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_QueryTrustedDomainInfo_in_get_level(PyObject *obj, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_lsa_QueryTrustedDomainInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_QueryTrustedDomainInfo_out_get_info(PyObject *obj, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&lsa_TrustedDomainInfo_Type, *object->out.info, object->in.level, *object->out.info, "union lsa_TrustedDomainInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_lsa_QueryTrustedDomainInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.info = NULL;
	} else {
		*object->out.info = NULL;
		{
			union lsa_TrustedDomainInfo *info_switch_2;
			info_switch_2 = (union lsa_TrustedDomainInfo *)pyrpc_export_union(&lsa_TrustedDomainInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union lsa_TrustedDomainInfo");
			if (info_switch_2 == NULL) {
				return -1;
			}
			*object->out.info = info_switch_2;
		}
	}
	return 0;
}

static PyObject *py_lsa_QueryTrustedDomainInfo_get_result(PyObject *obj, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_QueryTrustedDomainInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_QueryTrustedDomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_trustdom_handle"),
		.get = py_lsa_QueryTrustedDomainInfo_in_get_trustdom_handle,
		.set = py_lsa_QueryTrustedDomainInfo_in_set_trustdom_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_lsa_QueryTrustedDomainInfo_in_get_level,
		.set = py_lsa_QueryTrustedDomainInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomInfoEnum")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_lsa_QueryTrustedDomainInfo_out_get_info,
		.set = py_lsa_QueryTrustedDomainInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustedDomainInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_QueryTrustedDomainInfo_get_result,
		.set = py_lsa_QueryTrustedDomainInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_QueryTrustedDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_QueryTrustedDomainInfo, type);
	struct lsa_QueryTrustedDomainInfo *_self = (struct lsa_QueryTrustedDomainInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.info = talloc_zero(mem_ctx, union lsa_TrustedDomainInfo *);
	return self;
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(26);
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QueryTrustedDomainInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[26];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QueryTrustedDomainInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QueryTrustedDomainInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QueryTrustedDomainInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[26];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QueryTrustedDomainInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QueryTrustedDomainInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QueryTrustedDomainInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QueryTrustedDomainInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[26];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QueryTrustedDomainInfo_ndr_print(py_obj, "lsa_QueryTrustedDomainInfo_in", NDR_IN);
}

static PyObject *py_lsa_QueryTrustedDomainInfo_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QueryTrustedDomainInfo_ndr_print(py_obj, "lsa_QueryTrustedDomainInfo_out", NDR_OUT);
}

static PyMethodDef py_lsa_QueryTrustedDomainInfo_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_QueryTrustedDomainInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.QueryTrustedDomainInfo.opnum() -> 26 (0x1a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryTrustedDomainInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryTrustedDomainInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryTrustedDomainInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QueryTrustedDomainInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_QueryTrustedDomainInfo_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_QueryTrustedDomainInfo_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_QueryTrustedDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.QueryTrustedDomainInfo",
	.tp_getset = py_lsa_QueryTrustedDomainInfo_getsetters,
	.tp_methods = py_lsa_QueryTrustedDomainInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_QueryTrustedDomainInfo_new,
};

static bool pack_py_lsa_QueryTrustedDomainInfo_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryTrustedDomainInfo *r)
{
	PyObject *py_trustdom_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"trustdom_handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QueryTrustedDomainInfo", discard_const_p(char *, kwnames), &py_trustdom_handle, &py_level)) {
		return false;
	}

	if (py_trustdom_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.trustdom_handle");
		return false;
	}
	r->in.trustdom_handle = talloc_ptrtype(r, r->in.trustdom_handle);
	if (r->in.trustdom_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_trustdom_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trustdom_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(py_trustdom_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_QueryTrustedDomainInfo_args_out(struct lsa_QueryTrustedDomainInfo *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&lsa_TrustedDomainInfo_Type, *r->out.info, r->in.level, *r->out.info, "union lsa_TrustedDomainInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_SetInformationTrustedDomain_in_get_trustdom_handle(PyObject *obj, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_trustdom_handle;
	if (object->in.trustdom_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, object->in.trustdom_handle, object->in.trustdom_handle);
	return py_trustdom_handle;
}

static int py_lsa_SetInformationTrustedDomain_in_set_trustdom_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.trustdom_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.trustdom_handle");
		return -1;
	}
	object->in.trustdom_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.trustdom_handle);
	if (object->in.trustdom_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_SetInformationTrustedDomain_in_get_level(PyObject *obj, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_lsa_SetInformationTrustedDomain_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_SetInformationTrustedDomain_in_get_info(PyObject *obj, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&lsa_TrustedDomainInfo_Type, object->in.info, object->in.level, object->in.info, "union lsa_TrustedDomainInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_lsa_SetInformationTrustedDomain_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union lsa_TrustedDomainInfo *info_switch_1;
		info_switch_1 = (union lsa_TrustedDomainInfo *)pyrpc_export_union(&lsa_TrustedDomainInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union lsa_TrustedDomainInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->in.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_lsa_SetInformationTrustedDomain_get_result(PyObject *obj, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_SetInformationTrustedDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_SetInformationTrustedDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_trustdom_handle"),
		.get = py_lsa_SetInformationTrustedDomain_in_get_trustdom_handle,
		.set = py_lsa_SetInformationTrustedDomain_in_set_trustdom_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_lsa_SetInformationTrustedDomain_in_get_level,
		.set = py_lsa_SetInformationTrustedDomain_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustDomInfoEnum")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_lsa_SetInformationTrustedDomain_in_get_info,
		.set = py_lsa_SetInformationTrustedDomain_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustedDomainInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_SetInformationTrustedDomain_get_result,
		.set = py_lsa_SetInformationTrustedDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_SetInformationTrustedDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_SetInformationTrustedDomain, type);
	struct lsa_SetInformationTrustedDomain *_self = (struct lsa_SetInformationTrustedDomain *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.info = talloc_zero(mem_ctx, union lsa_TrustedDomainInfo);
	return self;
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(27);
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetInformationTrustedDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[27];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetInformationTrustedDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetInformationTrustedDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetInformationTrustedDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[27];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetInformationTrustedDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetInformationTrustedDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetInformationTrustedDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetInformationTrustedDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[27];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetInformationTrustedDomain_ndr_print(py_obj, "lsa_SetInformationTrustedDomain_in", NDR_IN);
}

static PyObject *py_lsa_SetInformationTrustedDomain_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetInformationTrustedDomain_ndr_print(py_obj, "lsa_SetInformationTrustedDomain_out", NDR_OUT);
}

static PyMethodDef py_lsa_SetInformationTrustedDomain_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_SetInformationTrustedDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.SetInformationTrustedDomain.opnum() -> 27 (0x1b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInformationTrustedDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInformationTrustedDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInformationTrustedDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetInformationTrustedDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_SetInformationTrustedDomain_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_SetInformationTrustedDomain_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_SetInformationTrustedDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.SetInformationTrustedDomain",
	.tp_getset = py_lsa_SetInformationTrustedDomain_getsetters,
	.tp_methods = py_lsa_SetInformationTrustedDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_SetInformationTrustedDomain_new,
};

static bool pack_py_lsa_SetInformationTrustedDomain_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetInformationTrustedDomain *r)
{
	PyObject *py_trustdom_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"trustdom_handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetInformationTrustedDomain", discard_const_p(char *, kwnames), &py_trustdom_handle, &py_level, &py_info)) {
		return false;
	}

	if (py_trustdom_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.trustdom_handle");
		return false;
	}
	r->in.trustdom_handle = talloc_ptrtype(r, r->in.trustdom_handle);
	if (r->in.trustdom_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_trustdom_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trustdom_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(py_trustdom_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union lsa_TrustedDomainInfo *info_switch_1;
		info_switch_1 = (union lsa_TrustedDomainInfo *)pyrpc_export_union(&lsa_TrustedDomainInfo_Type, r, r->in.level, py_info, "union lsa_TrustedDomainInfo");
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetInformationTrustedDomain_args_out(struct lsa_SetInformationTrustedDomain *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_OpenSecret_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_OpenSecret_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenSecret_in_get_name(PyObject *obj, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->in.name);
	return py_name;
}

static int py_lsa_OpenSecret_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name");
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenSecret_in_get_access_mask(PyObject *obj, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_lsa_OpenSecret_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_OpenSecret_out_get_sec_handle(PyObject *obj, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_handle;
	if (object->out.sec_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, object->out.sec_handle, object->out.sec_handle);
	return py_sec_handle;
}

static int py_lsa_OpenSecret_out_set_sec_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sec_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.sec_handle");
		return -1;
	}
	object->out.sec_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sec_handle);
	if (object->out.sec_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sec_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_OpenSecret_get_result(PyObject *obj, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_OpenSecret_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_OpenSecret_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_OpenSecret_in_get_handle,
		.set = py_lsa_OpenSecret_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_lsa_OpenSecret_in_get_name,
		.set = py_lsa_OpenSecret_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_lsa_OpenSecret_in_get_access_mask,
		.set = py_lsa_OpenSecret_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SecretAccessMask")
	},
	{
		.name = discard_const_p(char, "out_sec_handle"),
		.get = py_lsa_OpenSecret_out_get_sec_handle,
		.set = py_lsa_OpenSecret_out_set_sec_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_OpenSecret_get_result,
		.set = py_lsa_OpenSecret_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_OpenSecret_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_OpenSecret, type);
	struct lsa_OpenSecret *_self = (struct lsa_OpenSecret *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.sec_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_OpenSecret_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(28);
}

static PyObject *py_lsa_OpenSecret_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenSecret_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[28];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_OpenSecret_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenSecret_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_OpenSecret_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_OpenSecret_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_OpenSecret_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenSecret_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[28];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_OpenSecret_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenSecret_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenSecret_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_OpenSecret_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_OpenSecret_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_OpenSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_OpenSecret_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[28];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_OpenSecret_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenSecret_ndr_print(py_obj, "lsa_OpenSecret_in", NDR_IN);
}

static PyObject *py_lsa_OpenSecret_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_OpenSecret_ndr_print(py_obj, "lsa_OpenSecret_out", NDR_OUT);
}

static PyMethodDef py_lsa_OpenSecret_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_OpenSecret_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.OpenSecret.opnum() -> 28 (0x1c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenSecret_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenSecret_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenSecret_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_OpenSecret_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_OpenSecret_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_OpenSecret_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_OpenSecret_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.OpenSecret",
	.tp_getset = py_lsa_OpenSecret_getsetters,
	.tp_methods = py_lsa_OpenSecret_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_OpenSecret_new,
};

static bool pack_py_lsa_OpenSecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenSecret *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenSecret", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_access_mask)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name");
		return false;
	}
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct lsa_String *)pytalloc_get_ptr(py_name);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenSecret_args_out(struct lsa_OpenSecret *r)
{
	PyObject *result;
	PyObject *py_sec_handle;
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, r->out.sec_handle, r->out.sec_handle);
	result = py_sec_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_SetSecret_in_get_sec_handle(PyObject *obj, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_handle;
	if (object->in.sec_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, object->in.sec_handle, object->in.sec_handle);
	return py_sec_handle;
}

static int py_lsa_SetSecret_in_set_sec_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sec_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sec_handle");
		return -1;
	}
	object->in.sec_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sec_handle);
	if (object->in.sec_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sec_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_SetSecret_in_get_new_val(PyObject *obj, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_new_val;
	if (object->in.new_val == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.new_val == NULL) {
		py_new_val = Py_None;
		Py_INCREF(py_new_val);
	} else {
		py_new_val = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->in.new_val, object->in.new_val);
	}
	return py_new_val;
}

static int py_lsa_SetSecret_in_set_new_val(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.new_val));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.new_val");
		return -1;
	}
	if (value == Py_None) {
		object->in.new_val = NULL;
	} else {
		object->in.new_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.new_val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_SetSecret_in_get_old_val(PyObject *obj, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_old_val;
	if (object->in.old_val == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.old_val == NULL) {
		py_old_val = Py_None;
		Py_INCREF(py_old_val);
	} else {
		py_old_val = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->in.old_val, object->in.old_val);
	}
	return py_old_val;
}

static int py_lsa_SetSecret_in_set_old_val(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.old_val));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.old_val");
		return -1;
	}
	if (value == Py_None) {
		object->in.old_val = NULL;
	} else {
		object->in.old_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.old_val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_SetSecret_get_result(PyObject *obj, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_SetSecret_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SetSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_SetSecret_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sec_handle"),
		.get = py_lsa_SetSecret_in_get_sec_handle,
		.set = py_lsa_SetSecret_in_set_sec_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_new_val"),
		.get = py_lsa_SetSecret_in_get_new_val,
		.set = py_lsa_SetSecret_in_set_new_val,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF")
	},
	{
		.name = discard_const_p(char, "in_old_val"),
		.get = py_lsa_SetSecret_in_get_old_val,
		.set = py_lsa_SetSecret_in_set_old_val,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_SetSecret_get_result,
		.set = py_lsa_SetSecret_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_SetSecret_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_SetSecret, type);
	struct lsa_SetSecret *_self = (struct lsa_SetSecret *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sec_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_SetSecret_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(29);
}

static PyObject *py_lsa_SetSecret_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSecret_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[29];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_SetSecret_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetSecret_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_SetSecret_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_SetSecret_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_SetSecret_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSecret *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSecret_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[29];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_SetSecret_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetSecret_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetSecret_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_SetSecret_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_SetSecret_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_SetSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_SetSecret_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[29];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_SetSecret_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetSecret_ndr_print(py_obj, "lsa_SetSecret_in", NDR_IN);
}

static PyObject *py_lsa_SetSecret_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_SetSecret_ndr_print(py_obj, "lsa_SetSecret_out", NDR_OUT);
}

static PyMethodDef py_lsa_SetSecret_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_SetSecret_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.SetSecret.opnum() -> 29 (0x1d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecret_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecret_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecret_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_SetSecret_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_SetSecret_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_SetSecret_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_SetSecret_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.SetSecret",
	.tp_getset = py_lsa_SetSecret_getsetters,
	.tp_methods = py_lsa_SetSecret_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_SetSecret_new,
};

static bool pack_py_lsa_SetSecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetSecret *r)
{
	PyObject *py_sec_handle;
	PyObject *py_new_val;
	PyObject *py_old_val;
	const char *kwnames[] = {
		"sec_handle", "new_val", "old_val", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetSecret", discard_const_p(char *, kwnames), &py_sec_handle, &py_new_val, &py_old_val)) {
		return false;
	}

	if (py_sec_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sec_handle");
		return false;
	}
	r->in.sec_handle = talloc_ptrtype(r, r->in.sec_handle);
	if (r->in.sec_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_sec_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sec_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sec_handle = (struct policy_handle *)pytalloc_get_ptr(py_sec_handle);
	if (py_new_val == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.new_val");
		return false;
	}
	if (py_new_val == Py_None) {
		r->in.new_val = NULL;
	} else {
		r->in.new_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, py_new_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_new_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.new_val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_new_val);
	}
	if (py_old_val == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.old_val");
		return false;
	}
	if (py_old_val == Py_None) {
		r->in.old_val = NULL;
	} else {
		r->in.old_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, py_old_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_old_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.old_val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_old_val);
	}
	return true;
}

static PyObject *unpack_py_lsa_SetSecret_args_out(struct lsa_SetSecret *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_QuerySecret_in_get_sec_handle(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_handle;
	if (object->in.sec_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, object->in.sec_handle, object->in.sec_handle);
	return py_sec_handle;
}

static int py_lsa_QuerySecret_in_set_sec_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sec_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.sec_handle");
		return -1;
	}
	object->in.sec_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sec_handle);
	if (object->in.sec_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sec_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_QuerySecret_in_get_new_val(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_new_val;
	if (object->in.new_val == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.new_val == NULL) {
		py_new_val = Py_None;
		Py_INCREF(py_new_val);
	} else {
		py_new_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, object->in.new_val, object->in.new_val);
	}
	return py_new_val;
}

static int py_lsa_QuerySecret_in_set_new_val(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.new_val));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.new_val");
		return -1;
	}
	if (value == Py_None) {
		object->in.new_val = NULL;
	} else {
		object->in.new_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.new_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_out_get_new_val(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_new_val;
	if (object->out.new_val == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.new_val == NULL) {
		py_new_val = Py_None;
		Py_INCREF(py_new_val);
	} else {
		py_new_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, object->out.new_val, object->out.new_val);
	}
	return py_new_val;
}

static int py_lsa_QuerySecret_out_set_new_val(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.new_val));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.new_val");
		return -1;
	}
	if (value == Py_None) {
		object->out.new_val = NULL;
	} else {
		object->out.new_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->out.new_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_in_get_new_mtime(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_new_mtime;
	if (object->in.new_mtime == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.new_mtime == NULL) {
		py_new_mtime = Py_None;
		Py_INCREF(py_new_mtime);
	} else {
		py_new_mtime = PyLong_FromUnsignedLongLong(*object->in.new_mtime);
	}
	return py_new_mtime;
}

static int py_lsa_QuerySecret_in_set_new_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.new_mtime));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.new_mtime");
		return -1;
	}
	if (value == Py_None) {
		object->in.new_mtime = NULL;
	} else {
		object->in.new_mtime = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.new_mtime);
		if (object->in.new_mtime == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.new_mtime));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.new_mtime = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_out_get_new_mtime(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_new_mtime;
	if (object->out.new_mtime == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.new_mtime == NULL) {
		py_new_mtime = Py_None;
		Py_INCREF(py_new_mtime);
	} else {
		py_new_mtime = PyLong_FromUnsignedLongLong(*object->out.new_mtime);
	}
	return py_new_mtime;
}

static int py_lsa_QuerySecret_out_set_new_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.new_mtime));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.new_mtime");
		return -1;
	}
	if (value == Py_None) {
		object->out.new_mtime = NULL;
	} else {
		object->out.new_mtime = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.new_mtime);
		if (object->out.new_mtime == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.new_mtime));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.new_mtime = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_in_get_old_val(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_old_val;
	if (object->in.old_val == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.old_val == NULL) {
		py_old_val = Py_None;
		Py_INCREF(py_old_val);
	} else {
		py_old_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, object->in.old_val, object->in.old_val);
	}
	return py_old_val;
}

static int py_lsa_QuerySecret_in_set_old_val(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.old_val));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.old_val");
		return -1;
	}
	if (value == Py_None) {
		object->in.old_val = NULL;
	} else {
		object->in.old_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.old_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_out_get_old_val(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_old_val;
	if (object->out.old_val == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.old_val == NULL) {
		py_old_val = Py_None;
		Py_INCREF(py_old_val);
	} else {
		py_old_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, object->out.old_val, object->out.old_val);
	}
	return py_old_val;
}

static int py_lsa_QuerySecret_out_set_old_val(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.old_val));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.old_val");
		return -1;
	}
	if (value == Py_None) {
		object->out.old_val = NULL;
	} else {
		object->out.old_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->out.old_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_in_get_old_mtime(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_old_mtime;
	if (object->in.old_mtime == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.old_mtime == NULL) {
		py_old_mtime = Py_None;
		Py_INCREF(py_old_mtime);
	} else {
		py_old_mtime = PyLong_FromUnsignedLongLong(*object->in.old_mtime);
	}
	return py_old_mtime;
}

static int py_lsa_QuerySecret_in_set_old_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.old_mtime));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.old_mtime");
		return -1;
	}
	if (value == Py_None) {
		object->in.old_mtime = NULL;
	} else {
		object->in.old_mtime = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.old_mtime);
		if (object->in.old_mtime == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.old_mtime));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.old_mtime = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_out_get_old_mtime(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_old_mtime;
	if (object->out.old_mtime == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.old_mtime == NULL) {
		py_old_mtime = Py_None;
		Py_INCREF(py_old_mtime);
	} else {
		py_old_mtime = PyLong_FromUnsignedLongLong(*object->out.old_mtime);
	}
	return py_old_mtime;
}

static int py_lsa_QuerySecret_out_set_old_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.old_mtime));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.old_mtime");
		return -1;
	}
	if (value == Py_None) {
		object->out.old_mtime = NULL;
	} else {
		object->out.old_mtime = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.old_mtime);
		if (object->out.old_mtime == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.old_mtime));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.old_mtime = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_QuerySecret_get_result(PyObject *obj, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_QuerySecret_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_QuerySecret_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sec_handle"),
		.get = py_lsa_QuerySecret_in_get_sec_handle,
		.set = py_lsa_QuerySecret_in_set_sec_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_new_val"),
		.get = py_lsa_QuerySecret_in_get_new_val,
		.set = py_lsa_QuerySecret_in_set_new_val,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF_PTR")
	},
	{
		.name = discard_const_p(char, "out_new_val"),
		.get = py_lsa_QuerySecret_out_get_new_val,
		.set = py_lsa_QuerySecret_out_set_new_val,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF_PTR")
	},
	{
		.name = discard_const_p(char, "in_new_mtime"),
		.get = py_lsa_QuerySecret_in_get_new_mtime,
		.set = py_lsa_QuerySecret_in_set_new_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "out_new_mtime"),
		.get = py_lsa_QuerySecret_out_get_new_mtime,
		.set = py_lsa_QuerySecret_out_set_new_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "in_old_val"),
		.get = py_lsa_QuerySecret_in_get_old_val,
		.set = py_lsa_QuerySecret_in_set_old_val,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF_PTR")
	},
	{
		.name = discard_const_p(char, "out_old_val"),
		.get = py_lsa_QuerySecret_out_get_old_val,
		.set = py_lsa_QuerySecret_out_set_old_val,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_DATA_BUF_PTR")
	},
	{
		.name = discard_const_p(char, "in_old_mtime"),
		.get = py_lsa_QuerySecret_in_get_old_mtime,
		.set = py_lsa_QuerySecret_in_set_old_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "out_old_mtime"),
		.get = py_lsa_QuerySecret_out_get_old_mtime,
		.set = py_lsa_QuerySecret_out_set_old_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_QuerySecret_get_result,
		.set = py_lsa_QuerySecret_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_QuerySecret_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_QuerySecret, type);
	struct lsa_QuerySecret *_self = (struct lsa_QuerySecret *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sec_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_QuerySecret_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(30);
}

static PyObject *py_lsa_QuerySecret_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QuerySecret_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[30];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_QuerySecret_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QuerySecret_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_QuerySecret_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_QuerySecret_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_QuerySecret_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QuerySecret_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[30];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_QuerySecret_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QuerySecret_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QuerySecret_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_QuerySecret_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_QuerySecret_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_QuerySecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_QuerySecret_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[30];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_QuerySecret_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QuerySecret_ndr_print(py_obj, "lsa_QuerySecret_in", NDR_IN);
}

static PyObject *py_lsa_QuerySecret_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_QuerySecret_ndr_print(py_obj, "lsa_QuerySecret_out", NDR_OUT);
}

static PyMethodDef py_lsa_QuerySecret_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_QuerySecret_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.QuerySecret.opnum() -> 30 (0x1e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecret_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecret_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecret_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_QuerySecret_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_QuerySecret_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_QuerySecret_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_QuerySecret_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.QuerySecret",
	.tp_getset = py_lsa_QuerySecret_getsetters,
	.tp_methods = py_lsa_QuerySecret_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_QuerySecret_new,
};

static bool pack_py_lsa_QuerySecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_QuerySecret *r)
{
	PyObject *py_sec_handle;
	PyObject *py_new_val;
	PyObject *py_new_mtime;
	PyObject *py_old_val;
	PyObject *py_old_mtime;
	const char *kwnames[] = {
		"sec_handle", "new_val", "new_mtime", "old_val", "old_mtime", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:lsa_QuerySecret", discard_const_p(char *, kwnames), &py_sec_handle, &py_new_val, &py_new_mtime, &py_old_val, &py_old_mtime)) {
		return false;
	}

	if (py_sec_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.sec_handle");
		return false;
	}
	r->in.sec_handle = talloc_ptrtype(r, r->in.sec_handle);
	if (r->in.sec_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_sec_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sec_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sec_handle = (struct policy_handle *)pytalloc_get_ptr(py_sec_handle);
	if (py_new_val == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.new_val");
		return false;
	}
	if (py_new_val == Py_None) {
		r->in.new_val = NULL;
	} else {
		r->in.new_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, py_new_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_new_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.new_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(py_new_val);
	}
	if (py_new_mtime == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.new_mtime");
		return false;
	}
	if (py_new_mtime == Py_None) {
		r->in.new_mtime = NULL;
	} else {
		r->in.new_mtime = talloc_ptrtype(r, r->in.new_mtime);
		if (r->in.new_mtime == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.new_mtime));
			if (PyLong_Check(py_new_mtime)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_new_mtime);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.new_mtime = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_old_val == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.old_val");
		return false;
	}
	if (py_old_val == Py_None) {
		r->in.old_val = NULL;
	} else {
		r->in.old_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, py_old_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_old_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.old_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(py_old_val);
	}
	if (py_old_mtime == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.old_mtime");
		return false;
	}
	if (py_old_mtime == Py_None) {
		r->in.old_mtime = NULL;
	} else {
		r->in.old_mtime = talloc_ptrtype(r, r->in.old_mtime);
		if (r->in.old_mtime == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.old_mtime));
			if (PyLong_Check(py_old_mtime)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_old_mtime);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.old_mtime = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_QuerySecret_args_out(struct lsa_QuerySecret *r)
{
	PyObject *result;
	PyObject *py_new_val;
	PyObject *py_new_mtime;
	PyObject *py_old_val;
	PyObject *py_old_mtime;
	result = PyTuple_New(4);
	if (r->out.new_val == NULL) {
		py_new_val = Py_None;
		Py_INCREF(py_new_val);
	} else {
		py_new_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, r->out.new_val, r->out.new_val);
	}
	PyTuple_SetItem(result, 0, py_new_val);
	if (r->out.new_mtime == NULL) {
		py_new_mtime = Py_None;
		Py_INCREF(py_new_mtime);
	} else {
		py_new_mtime = PyLong_FromUnsignedLongLong(*r->out.new_mtime);
	}
	PyTuple_SetItem(result, 1, py_new_mtime);
	if (r->out.old_val == NULL) {
		py_old_val = Py_None;
		Py_INCREF(py_old_val);
	} else {
		py_old_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, r->out.old_val, r->out.old_val);
	}
	PyTuple_SetItem(result, 2, py_old_val);
	if (r->out.old_mtime == NULL) {
		py_old_mtime = Py_None;
		Py_INCREF(py_old_mtime);
	} else {
		py_old_mtime = PyLong_FromUnsignedLongLong(*r->out.old_mtime);
	}
	PyTuple_SetItem(result, 3, py_old_mtime);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_LookupPrivValue_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_LookupPrivValue_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupPrivValue_in_get_name(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	py_name = pytalloc_reference_ex(&lsa_String_Type, object->in.name, object->in.name);
	return py_name;
}

static int py_lsa_LookupPrivValue_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = (struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupPrivValue_out_get_luid(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(obj);
	PyObject *py_luid;
	if (object->out.luid == NULL) {
		Py_RETURN_NONE;
	}
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, object->out.luid, object->out.luid);
	return py_luid;
}

static int py_lsa_LookupPrivValue_out_set_luid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.luid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.luid");
		return -1;
	}
	object->out.luid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.luid);
	if (object->out.luid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_LUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.luid = (struct lsa_LUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupPrivValue_get_result(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_LookupPrivValue_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_LookupPrivValue_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_LookupPrivValue_in_get_handle,
		.set = py_lsa_LookupPrivValue_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_lsa_LookupPrivValue_in_get_name,
		.set = py_lsa_LookupPrivValue_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "out_luid"),
		.get = py_lsa_LookupPrivValue_out_get_luid,
		.set = py_lsa_LookupPrivValue_out_set_luid,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_LUID")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_LookupPrivValue_get_result,
		.set = py_lsa_LookupPrivValue_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_LookupPrivValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_LookupPrivValue, type);
	struct lsa_LookupPrivValue *_self = (struct lsa_LookupPrivValue *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.name = talloc_zero(mem_ctx, struct lsa_String);
	_self->out.luid = talloc_zero(mem_ctx, struct lsa_LUID);
	return self;
}

static PyObject *py_lsa_LookupPrivValue_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(31);
}

static PyObject *py_lsa_LookupPrivValue_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivValue_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[31];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_LookupPrivValue_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupPrivValue_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_LookupPrivValue_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupPrivValue_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_LookupPrivValue_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivValue_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[31];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_LookupPrivValue_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupPrivValue_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupPrivValue_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupPrivValue_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupPrivValue_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivValue *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivValue_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[31];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_LookupPrivValue_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupPrivValue_ndr_print(py_obj, "lsa_LookupPrivValue_in", NDR_IN);
}

static PyObject *py_lsa_LookupPrivValue_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupPrivValue_ndr_print(py_obj, "lsa_LookupPrivValue_out", NDR_OUT);
}

static PyMethodDef py_lsa_LookupPrivValue_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_LookupPrivValue_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.LookupPrivValue.opnum() -> 31 (0x1f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivValue_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivValue_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivValue_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivValue_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_LookupPrivValue_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_LookupPrivValue_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_LookupPrivValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.LookupPrivValue",
	.tp_getset = py_lsa_LookupPrivValue_getsetters,
	.tp_methods = py_lsa_LookupPrivValue_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_LookupPrivValue_new,
};

static bool pack_py_lsa_LookupPrivValue_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupPrivValue *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	const char *kwnames[] = {
		"handle", "name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_LookupPrivValue", discard_const_p(char *, kwnames), &py_handle, &py_name)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	return true;
}

static PyObject *unpack_py_lsa_LookupPrivValue_args_out(struct lsa_LookupPrivValue *r)
{
	PyObject *result;
	PyObject *py_luid;
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, r->out.luid, r->out.luid);
	result = py_luid;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_LookupPrivName_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_LookupPrivName_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupPrivName_in_get_luid(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(obj);
	PyObject *py_luid;
	if (object->in.luid == NULL) {
		Py_RETURN_NONE;
	}
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, object->in.luid, object->in.luid);
	return py_luid;
}

static int py_lsa_LookupPrivName_in_set_luid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.luid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.luid");
		return -1;
	}
	object->in.luid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.luid);
	if (object->in.luid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_LUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.luid = (struct lsa_LUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupPrivName_out_get_name(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->out.name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, *object->out.name, *object->out.name);
	}
	return py_name;
}

static int py_lsa_LookupPrivName_out_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.name");
		return -1;
	}
	object->out.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.name);
	if (object->out.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.name = NULL;
	} else {
		*object->out.name = NULL;
		PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.name = (struct lsa_StringLarge *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_LookupPrivName_get_result(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_LookupPrivName_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_LookupPrivName_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_LookupPrivName_in_get_handle,
		.set = py_lsa_LookupPrivName_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_luid"),
		.get = py_lsa_LookupPrivName_in_get_luid,
		.set = py_lsa_LookupPrivName_in_set_luid,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_LUID")
	},
	{
		.name = discard_const_p(char, "out_name"),
		.get = py_lsa_LookupPrivName_out_get_name,
		.set = py_lsa_LookupPrivName_out_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_LookupPrivName_get_result,
		.set = py_lsa_LookupPrivName_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_LookupPrivName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_LookupPrivName, type);
	struct lsa_LookupPrivName *_self = (struct lsa_LookupPrivName *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.luid = talloc_zero(mem_ctx, struct lsa_LUID);
	/* a pointer to a NULL pointer */
	_self->out.name = talloc_zero(mem_ctx, struct lsa_StringLarge *);
	return self;
}

static PyObject *py_lsa_LookupPrivName_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(32);
}

static PyObject *py_lsa_LookupPrivName_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivName_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[32];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_LookupPrivName_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupPrivName_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_LookupPrivName_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupPrivName_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_LookupPrivName_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivName_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[32];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_LookupPrivName_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupPrivName_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupPrivName_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupPrivName_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupPrivName_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivName_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[32];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_LookupPrivName_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupPrivName_ndr_print(py_obj, "lsa_LookupPrivName_in", NDR_IN);
}

static PyObject *py_lsa_LookupPrivName_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupPrivName_ndr_print(py_obj, "lsa_LookupPrivName_out", NDR_OUT);
}

static PyMethodDef py_lsa_LookupPrivName_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_LookupPrivName_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.LookupPrivName.opnum() -> 32 (0x20) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivName_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivName_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivName_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivName_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_LookupPrivName_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_LookupPrivName_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_LookupPrivName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.LookupPrivName",
	.tp_getset = py_lsa_LookupPrivName_getsetters,
	.tp_methods = py_lsa_LookupPrivName_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_LookupPrivName_new,
};

static bool pack_py_lsa_LookupPrivName_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupPrivName *r)
{
	PyObject *py_handle;
	PyObject *py_luid;
	const char *kwnames[] = {
		"handle", "luid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_LookupPrivName", discard_const_p(char *, kwnames), &py_handle, &py_luid)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_luid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.luid");
		return false;
	}
	r->in.luid = talloc_ptrtype(r, r->in.luid);
	if (r->in.luid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_LUID_Type, py_luid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_luid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.luid = (struct lsa_LUID *)pytalloc_get_ptr(py_luid);
	return true;
}

static PyObject *unpack_py_lsa_LookupPrivName_args_out(struct lsa_LookupPrivName *r)
{
	PyObject *result;
	PyObject *py_name;
	if (*r->out.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, *r->out.name, *r->out.name);
	}
	result = py_name;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_LookupPrivDisplayName_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_LookupPrivDisplayName_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupPrivDisplayName_in_get_name(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	py_name = pytalloc_reference_ex(&lsa_String_Type, object->in.name, object->in.name);
	return py_name;
}

static int py_lsa_LookupPrivDisplayName_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = (struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LookupPrivDisplayName_in_get_language_id(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(obj);
	PyObject *py_language_id;
	py_language_id = PyLong_FromLong((uint16_t)(object->in.language_id));
	return py_language_id;
}

static int py_lsa_LookupPrivDisplayName_in_set_language_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.language_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.language_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.language_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupPrivDisplayName_in_get_language_id_sys(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(obj);
	PyObject *py_language_id_sys;
	py_language_id_sys = PyLong_FromLong((uint16_t)(object->in.language_id_sys));
	return py_language_id_sys;
}

static int py_lsa_LookupPrivDisplayName_in_set_language_id_sys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.language_id_sys");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.language_id_sys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.language_id_sys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupPrivDisplayName_out_get_disp_name(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(obj);
	PyObject *py_disp_name;
	if (object->out.disp_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.disp_name == NULL) {
		py_disp_name = Py_None;
		Py_INCREF(py_disp_name);
	} else {
		py_disp_name = pytalloc_reference_ex(&lsa_StringLarge_Type, *object->out.disp_name, *object->out.disp_name);
	}
	return py_disp_name;
}

static int py_lsa_LookupPrivDisplayName_out_set_disp_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.disp_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.disp_name");
		return -1;
	}
	object->out.disp_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.disp_name);
	if (object->out.disp_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.disp_name = NULL;
	} else {
		*object->out.disp_name = NULL;
		PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.disp_name = (struct lsa_StringLarge *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_LookupPrivDisplayName_out_get_returned_language_id(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(obj);
	PyObject *py_returned_language_id;
	if (object->out.returned_language_id == NULL) {
		Py_RETURN_NONE;
	}
	py_returned_language_id = PyLong_FromLong((uint16_t)(*object->out.returned_language_id));
	return py_returned_language_id;
}

static int py_lsa_LookupPrivDisplayName_out_set_returned_language_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.returned_language_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.returned_language_id");
		return -1;
	}
	object->out.returned_language_id = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.returned_language_id);
	if (object->out.returned_language_id == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.returned_language_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.returned_language_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_LookupPrivDisplayName_get_result(PyObject *obj, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_LookupPrivDisplayName_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_LookupPrivDisplayName_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_LookupPrivDisplayName_in_get_handle,
		.set = py_lsa_LookupPrivDisplayName_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_lsa_LookupPrivDisplayName_in_get_name,
		.set = py_lsa_LookupPrivDisplayName_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "in_language_id"),
		.get = py_lsa_LookupPrivDisplayName_in_get_language_id,
		.set = py_lsa_LookupPrivDisplayName_in_set_language_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_language_id_sys"),
		.get = py_lsa_LookupPrivDisplayName_in_get_language_id_sys,
		.set = py_lsa_LookupPrivDisplayName_in_set_language_id_sys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_disp_name"),
		.get = py_lsa_LookupPrivDisplayName_out_get_disp_name,
		.set = py_lsa_LookupPrivDisplayName_out_set_disp_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "out_returned_language_id"),
		.get = py_lsa_LookupPrivDisplayName_out_get_returned_language_id,
		.set = py_lsa_LookupPrivDisplayName_out_set_returned_language_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_LookupPrivDisplayName_get_result,
		.set = py_lsa_LookupPrivDisplayName_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_LookupPrivDisplayName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_LookupPrivDisplayName, type);
	struct lsa_LookupPrivDisplayName *_self = (struct lsa_LookupPrivDisplayName *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.name = talloc_zero(mem_ctx, struct lsa_String);
	/* a pointer to a NULL pointer */
	_self->out.disp_name = talloc_zero(mem_ctx, struct lsa_StringLarge *);
	_self->out.returned_language_id = talloc_zero(mem_ctx, uint16_t);
	return self;
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(33);
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivDisplayName_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[33];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupPrivDisplayName_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_LookupPrivDisplayName_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivDisplayName_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[33];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupPrivDisplayName_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_LookupPrivDisplayName_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_LookupPrivDisplayName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_LookupPrivDisplayName_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[33];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupPrivDisplayName_ndr_print(py_obj, "lsa_LookupPrivDisplayName_in", NDR_IN);
}

static PyObject *py_lsa_LookupPrivDisplayName_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_LookupPrivDisplayName_ndr_print(py_obj, "lsa_LookupPrivDisplayName_out", NDR_OUT);
}

static PyMethodDef py_lsa_LookupPrivDisplayName_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_LookupPrivDisplayName_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.LookupPrivDisplayName.opnum() -> 33 (0x21) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivDisplayName_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivDisplayName_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivDisplayName_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_LookupPrivDisplayName_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_LookupPrivDisplayName_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_LookupPrivDisplayName_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_LookupPrivDisplayName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.LookupPrivDisplayName",
	.tp_getset = py_lsa_LookupPrivDisplayName_getsetters,
	.tp_methods = py_lsa_LookupPrivDisplayName_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_LookupPrivDisplayName_new,
};

static bool pack_py_lsa_LookupPrivDisplayName_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupPrivDisplayName *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_language_id;
	PyObject *py_language_id_sys;
	const char *kwnames[] = {
		"handle", "name", "language_id", "language_id_sys", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:lsa_LookupPrivDisplayName", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_language_id, &py_language_id_sys)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	if (py_language_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.language_id");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.language_id));
		if (PyLong_Check(py_language_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_language_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.language_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_language_id_sys == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.language_id_sys");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.language_id_sys));
		if (PyLong_Check(py_language_id_sys)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_language_id_sys);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.language_id_sys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupPrivDisplayName_args_out(struct lsa_LookupPrivDisplayName *r)
{
	PyObject *result;
	PyObject *py_disp_name;
	PyObject *py_returned_language_id;
	result = PyTuple_New(2);
	if (*r->out.disp_name == NULL) {
		py_disp_name = Py_None;
		Py_INCREF(py_disp_name);
	} else {
		py_disp_name = pytalloc_reference_ex(&lsa_StringLarge_Type, *r->out.disp_name, *r->out.disp_name);
	}
	PyTuple_SetItem(result, 0, py_disp_name);
	py_returned_language_id = PyLong_FromLong((uint16_t)(*r->out.returned_language_id));
	PyTuple_SetItem(result, 1, py_returned_language_id);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_DeleteObject_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_DeleteObject *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_DeleteObject_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DeleteObject *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DeleteObject_out_get_handle(PyObject *obj, void *closure)
{
	struct lsa_DeleteObject *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_lsa_DeleteObject_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DeleteObject *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DeleteObject_get_result(PyObject *obj, void *closure)
{
	struct lsa_DeleteObject *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_DeleteObject_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DeleteObject *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_lsa_DeleteObject_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_lsa_DeleteObject_in_get_handle,
		.set = py_lsa_DeleteObject_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_lsa_DeleteObject_out_get_handle,
		.set = py_lsa_DeleteObject_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_lsa_DeleteObject_get_result,
		.set = py_lsa_DeleteObject_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_lsa_DeleteObject_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct lsa_DeleteObject, type);
	struct lsa_DeleteObject *_self = (struct lsa_DeleteObject *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_lsa_DeleteObject_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(34);
}

static PyObject *py_lsa_DeleteObject_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_DeleteObject *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_DeleteObject_ndr_pack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[34];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_lsa_DeleteObject_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_DeleteObject_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_lsa_DeleteObject_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_lsa_DeleteObject_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_lsa_DeleteObject_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_DeleteObject *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_lsarpc.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_DeleteObject_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[34];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_lsa_DeleteObject_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_DeleteObject_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_DeleteObject_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_lsa_DeleteObject_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_lsa_DeleteObject_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct lsa_DeleteObject *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_lsarpc.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_lsa_DeleteObject_ndr_print");
		return NULL;
	}
	call = &ndr_table_lsarpc.calls[34];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_lsa_DeleteObject_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_DeleteObject_ndr_print(py_obj, "lsa_DeleteObject_in", NDR_IN);
}

static PyObject *py_lsa_DeleteObject_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_lsa_DeleteObject_ndr_print(py_obj, "lsa_DeleteObject_out", NDR_OUT);
}

static PyMethodDef py_lsa_DeleteObject_methods[] = {
	{ "opnum", (PyCFunction)py_lsa_DeleteObject_ndr_opnum, METH_NOARGS|METH_CLASS,
		"lsa.DeleteObject.opnum() -> 34 (0x22) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_DeleteObject_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_DeleteObject_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_DeleteObject_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_lsa_DeleteObject_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_lsa_DeleteObject_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_lsa_DeleteObject_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_DeleteObject_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "lsa.DeleteObject",
	.tp_getset = py_lsa_DeleteObject_getsetters,
	.tp_methods = py_lsa_DeleteObject_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_lsa_DeleteObject_new,
};

static bool pack_py_lsa_DeleteObject_args_in(PyObject *args, PyObject *kwargs, struct lsa_DeleteObject *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_DeleteObject", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_DeleteObject_args_out(struct lsa_DeleteObject *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_lsa_EnumAccountsWithUserRight_in_get_handle(PyObject *obj, void *closure)
{
	struct lsa_EnumAccountsWithUserRight *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_lsa_EnumAccountsWithUserRight_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccountsWithUserRight *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumAccountsWithUserRight_in_get_name(PyObject *obj, void *closure)
{
	struct lsa_EnumAccountsWithUserRight *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = pytalloc_reference_ex(&lsa_String_Type, object->in.name, object->in.name);
	}
	return py_name;
}

static int py_lsa_EnumAccountsWithUserRight_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccountsWithUserRight *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.name");
		return -1;
	}
	if (value == Py_None) {
		object->in.name = NULL;
	} else {
		object->in.name = NULL;
		PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.name = (struct lsa_String *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_EnumAccountsWithUserRight_out_get_sids(PyObject *obj, void *closure)
{
	struct lsa_EnumAccountsWithUserRight *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->out.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&lsa_SidArray_Type, object->out.sids, object->out.sids);
	return py_sids;
}

static int py_lsa_EnumAccountsWithUserRight_out_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_EnumAccountsWithUserRight *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.sids");
		return -1;
	}
	object->out.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sids);
	if (object->out.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&lsa_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sids = (struct lsa_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_EnumAccountsWithUserRight_get_result(PyObject *obj, void *closure)
{
	struct lsa_EnumAccountsWithUserRight *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_lsa_EnumAccountsWithUserRight_set_result(PyObject *py_obj, PyObje