
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_krb5ccache.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject PRINCIPAL_Type;
static PyTypeObject KEYBLOCK_Type;
static PyTypeObject ADDRESS_Type;
static PyTypeObject ADDRESSES_Type;
static PyTypeObject AUTHDATUM_Type;
static PyTypeObject AUTHDATA_Type;
static PyTypeObject CREDENTIAL_Type;
static PyTypeObject DELTATIME_TAG_Type;
static PyTypeObject FIELD_Type;
static PyTypeObject V4TAG_Type;
static PyTypeObject V4TAGS_Type;
static PyTypeObject V4HEADER_Type;
static PyTypeObject OPTIONAL_HEADER_Type;
static PyTypeObject CCACHE_Type;
static PyTypeObject MULTIPLE_CREDENTIALS_Type;
static PyTypeObject krb5ccache_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_PRINCIPAL_get_name_type(PyObject *obj, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(obj);
	PyObject *py_name_type;
	py_name_type = PyLong_FromUnsignedLongLong((uint32_t)(object->name_type));
	return py_name_type;
}

static int py_PRINCIPAL_set_name_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PRINCIPAL_get_component_count(PyObject *obj, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(obj);
	PyObject *py_component_count;
	py_component_count = PyLong_FromUnsignedLongLong((uint32_t)(object->component_count));
	return py_component_count;
}

static int py_PRINCIPAL_set_component_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->component_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->component_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->component_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PRINCIPAL_get_realm(PyObject *obj, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(obj);
	PyObject *py_realm;
	py_realm = PyString_FromStringOrNULL(object->realm);
	return py_realm;
}

static int py_PRINCIPAL_set_realm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->realm");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->realm = talloc_str;
	}
	return 0;
}

static PyObject *py_PRINCIPAL_get_components(PyObject *obj, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(obj);
	PyObject *py_components;
	py_components = PyList_New(object->component_count);
	if (py_components == NULL) {
		return NULL;
	}
	{
		int components_cntr_0;
		for (components_cntr_0 = 0; components_cntr_0 < (object->component_count); components_cntr_0++) {
			PyObject *py_components_0;
			py_components_0 = PyString_FromStringOrNULL((object->components)[components_cntr_0]);
			PyList_SetItem(py_components, components_cntr_0, py_components_0);
		}
	}
	return py_components;
}

static int py_PRINCIPAL_set_components(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PRINCIPAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->components");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int components_cntr_0;
		object->components = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->components, PyList_GET_SIZE(value));
		if (!object->components) { return -1; }
		talloc_set_name_const(object->components, "ARRAY: object->components");
		for (components_cntr_0 = 0; components_cntr_0 < PyList_GET_SIZE(value); components_cntr_0++) {
			if (PyList_GET_ITEM(value, components_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->components)[components_cntr_0]");
				return -1;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(PyList_GET_ITEM(value, components_cntr_0))) {
					unicode = PyUnicode_AsEncodedString(PyList_GET_ITEM(value, components_cntr_0), "utf-8", "ignore");
					if (unicode == NULL) {
						return -1;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(PyList_GET_ITEM(value, components_cntr_0))) {
					test_str = PyBytes_AS_STRING(PyList_GET_ITEM(value, components_cntr_0));
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(PyList_GET_ITEM(value, components_cntr_0))->tp_name);
					return -1;
				}
				talloc_str = talloc_strdup(object->components, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->components)[components_cntr_0] = talloc_str;
			}
		}
	}
	return 0;
}

static PyGetSetDef py_PRINCIPAL_getsetters[] = {
	{
		.name = discard_const_p(char, "name_type"),
		.get = py_PRINCIPAL_get_name_type,
		.set = py_PRINCIPAL_set_name_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "component_count"),
		.get = py_PRINCIPAL_get_component_count,
		.set = py_PRINCIPAL_set_component_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "realm"),
		.get = py_PRINCIPAL_get_realm,
		.set = py_PRINCIPAL_set_realm,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "components"),
		.get = py_PRINCIPAL_get_components,
		.set = py_PRINCIPAL_set_components,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_PRINCIPAL_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PRINCIPAL, type);
}


static PyTypeObject PRINCIPAL_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.PRINCIPAL",
	.tp_getset = py_PRINCIPAL_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PRINCIPAL_new,
};


static PyObject *py_KEYBLOCK_get_enctype(PyObject *obj, void *closure)
{
	struct KEYBLOCK *object = pytalloc_get_ptr(obj);
	PyObject *py_enctype;
	py_enctype = PyLong_FromLong((uint16_t)(object->enctype));
	return py_enctype;
}

static int py_KEYBLOCK_set_enctype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYBLOCK *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->enctype");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enctype));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enctype = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KEYBLOCK_get_data(PyObject *obj, void *closure)
{
	struct KEYBLOCK *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyBytes_FromStringAndSize((char *)(object->data).data, (object->data).length);
	return py_data;
}

static int py_KEYBLOCK_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYBLOCK *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	object->data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_KEYBLOCK_getsetters[] = {
	{
		.name = discard_const_p(char, "enctype"),
		.get = py_KEYBLOCK_get_enctype,
		.set = py_KEYBLOCK_set_enctype,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_KEYBLOCK_get_data,
		.set = py_KEYBLOCK_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_KEYBLOCK_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KEYBLOCK, type);
}


static PyTypeObject KEYBLOCK_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.KEYBLOCK",
	.tp_getset = py_KEYBLOCK_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KEYBLOCK_new,
};


static PyObject *py_ADDRESS_get_addrtype(PyObject *obj, void *closure)
{
	struct ADDRESS *object = pytalloc_get_ptr(obj);
	PyObject *py_addrtype;
	py_addrtype = PyLong_FromLong((uint16_t)(object->addrtype));
	return py_addrtype;
}

static int py_ADDRESS_set_addrtype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ADDRESS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->addrtype");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->addrtype));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->addrtype = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ADDRESS_get_data(PyObject *obj, void *closure)
{
	struct ADDRESS *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyBytes_FromStringAndSize((char *)(object->data).data, (object->data).length);
	return py_data;
}

static int py_ADDRESS_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ADDRESS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	object->data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_ADDRESS_getsetters[] = {
	{
		.name = discard_const_p(char, "addrtype"),
		.get = py_ADDRESS_get_addrtype,
		.set = py_ADDRESS_set_addrtype,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_ADDRESS_get_data,
		.set = py_ADDRESS_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_ADDRESS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ADDRESS, type);
}


static PyTypeObject ADDRESS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.ADDRESS",
	.tp_getset = py_ADDRESS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ADDRESS_new,
};


static PyObject *py_ADDRESSES_get_count(PyObject *obj, void *closure)
{
	struct ADDRESSES *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_ADDRESSES_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ADDRESSES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ADDRESSES_get_data(PyObject *obj, void *closure)
{
	struct ADDRESSES *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->count);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->count); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = pytalloc_reference_ex(&ADDRESS_Type, object->data, &(object->data)[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_ADDRESSES_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ADDRESSES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&ADDRESS_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			if (talloc_reference(object->data, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, data_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->data)[data_cntr_0] = *(struct ADDRESS *)pytalloc_get_ptr(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_ADDRESSES_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_ADDRESSES_get_count,
		.set = py_ADDRESSES_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_ADDRESSES_get_data,
		.set = py_ADDRESSES_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type ADDRESS")
	},
	{ .name = NULL }
};

static PyObject *py_ADDRESSES_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ADDRESSES, type);
}


static PyTypeObject ADDRESSES_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.ADDRESSES",
	.tp_getset = py_ADDRESSES_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ADDRESSES_new,
};


static PyObject *py_AUTHDATUM_get_ad_type(PyObject *obj, void *closure)
{
	struct AUTHDATUM *object = pytalloc_get_ptr(obj);
	PyObject *py_ad_type;
	py_ad_type = PyLong_FromLong((uint16_t)(object->ad_type));
	return py_ad_type;
}

static int py_AUTHDATUM_set_ad_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHDATUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ad_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ad_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ad_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHDATUM_get_data(PyObject *obj, void *closure)
{
	struct AUTHDATUM *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyBytes_FromStringAndSize((char *)(object->data).data, (object->data).length);
	return py_data;
}

static int py_AUTHDATUM_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHDATUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	object->data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_AUTHDATUM_getsetters[] = {
	{
		.name = discard_const_p(char, "ad_type"),
		.get = py_AUTHDATUM_get_ad_type,
		.set = py_AUTHDATUM_set_ad_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_AUTHDATUM_get_data,
		.set = py_AUTHDATUM_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_AUTHDATUM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AUTHDATUM, type);
}


static PyTypeObject AUTHDATUM_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.AUTHDATUM",
	.tp_getset = py_AUTHDATUM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AUTHDATUM_new,
};


static PyObject *py_AUTHDATA_get_count(PyObject *obj, void *closure)
{
	struct AUTHDATA *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_AUTHDATA_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHDATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHDATA_get_data(PyObject *obj, void *closure)
{
	struct AUTHDATA *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->count);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->count); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = pytalloc_reference_ex(&AUTHDATUM_Type, object->data, &(object->data)[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_AUTHDATA_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHDATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&AUTHDATUM_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			if (talloc_reference(object->data, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, data_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->data)[data_cntr_0] = *(struct AUTHDATUM *)pytalloc_get_ptr(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_AUTHDATA_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_AUTHDATA_get_count,
		.set = py_AUTHDATA_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_AUTHDATA_get_data,
		.set = py_AUTHDATA_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type AUTHDATUM")
	},
	{ .name = NULL }
};

static PyObject *py_AUTHDATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AUTHDATA, type);
}


static PyTypeObject AUTHDATA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.AUTHDATA",
	.tp_getset = py_AUTHDATA_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AUTHDATA_new,
};


static PyObject *py_CREDENTIAL_get_client(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	py_client = pytalloc_reference_ex(&PRINCIPAL_Type, pytalloc_get_mem_ctx(obj), &object->client);
	return py_client;
}

static int py_CREDENTIAL_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->client");
		return -1;
	}
	PY_CHECK_TYPE(&PRINCIPAL_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client = *(struct PRINCIPAL *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_CREDENTIAL_get_server(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_server;
	py_server = pytalloc_reference_ex(&PRINCIPAL_Type, pytalloc_get_mem_ctx(obj), &object->server);
	return py_server;
}

static int py_CREDENTIAL_set_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->server");
		return -1;
	}
	PY_CHECK_TYPE(&PRINCIPAL_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server = *(struct PRINCIPAL *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_CREDENTIAL_get_keyblock(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_keyblock;
	py_keyblock = pytalloc_reference_ex(&KEYBLOCK_Type, pytalloc_get_mem_ctx(obj), &object->keyblock);
	return py_keyblock;
}

static int py_CREDENTIAL_set_keyblock(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->keyblock");
		return -1;
	}
	PY_CHECK_TYPE(&KEYBLOCK_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->keyblock = *(struct KEYBLOCK *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_CREDENTIAL_get_authtime(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_authtime;
	py_authtime = PyLong_FromUnsignedLongLong((uint32_t)(object->authtime));
	return py_authtime;
}

static int py_CREDENTIAL_set_authtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->authtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->authtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->authtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CREDENTIAL_get_starttime(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_starttime;
	py_starttime = PyLong_FromUnsignedLongLong((uint32_t)(object->starttime));
	return py_starttime;
}

static int py_CREDENTIAL_set_starttime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->starttime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->starttime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->starttime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CREDENTIAL_get_endtime(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_endtime;
	py_endtime = PyLong_FromUnsignedLongLong((uint32_t)(object->endtime));
	return py_endtime;
}

static int py_CREDENTIAL_set_endtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->endtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->endtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->endtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CREDENTIAL_get_renew_till(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_renew_till;
	py_renew_till = PyLong_FromUnsignedLongLong((uint32_t)(object->renew_till));
	return py_renew_till;
}

static int py_CREDENTIAL_set_renew_till(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->renew_till");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->renew_till));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->renew_till = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CREDENTIAL_get_is_skey(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_is_skey;
	py_is_skey = PyLong_FromLong((uint16_t)(object->is_skey));
	return py_is_skey;
}

static int py_CREDENTIAL_set_is_skey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->is_skey");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->is_skey));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->is_skey = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CREDENTIAL_get_ticket_flags(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_ticket_flags;
	py_ticket_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->ticket_flags));
	return py_ticket_flags;
}

static int py_CREDENTIAL_set_ticket_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ticket_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ticket_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ticket_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CREDENTIAL_get_addresses(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_addresses;
	py_addresses = pytalloc_reference_ex(&ADDRESSES_Type, pytalloc_get_mem_ctx(obj), &object->addresses);
	return py_addresses;
}

static int py_CREDENTIAL_set_addresses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->addresses");
		return -1;
	}
	PY_CHECK_TYPE(&ADDRESSES_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->addresses = *(struct ADDRESSES *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_CREDENTIAL_get_authdata(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_authdata;
	py_authdata = pytalloc_reference_ex(&AUTHDATA_Type, pytalloc_get_mem_ctx(obj), &object->authdata);
	return py_authdata;
}

static int py_CREDENTIAL_set_authdata(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->authdata");
		return -1;
	}
	PY_CHECK_TYPE(&AUTHDATA_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->authdata = *(struct AUTHDATA *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_CREDENTIAL_get_ticket(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_ticket;
	py_ticket = PyBytes_FromStringAndSize((char *)(object->ticket).data, (object->ticket).length);
	return py_ticket;
}

static int py_CREDENTIAL_set_ticket(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ticket");
		return -1;
	}
	object->ticket = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_CREDENTIAL_get_second_ticket(PyObject *obj, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(obj);
	PyObject *py_second_ticket;
	py_second_ticket = PyBytes_FromStringAndSize((char *)(object->second_ticket).data, (object->second_ticket).length);
	return py_second_ticket;
}

static int py_CREDENTIAL_set_second_ticket(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CREDENTIAL *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->second_ticket");
		return -1;
	}
	object->second_ticket = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_CREDENTIAL_getsetters[] = {
	{
		.name = discard_const_p(char, "client"),
		.get = py_CREDENTIAL_get_client,
		.set = py_CREDENTIAL_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type PRINCIPAL")
	},
	{
		.name = discard_const_p(char, "server"),
		.get = py_CREDENTIAL_get_server,
		.set = py_CREDENTIAL_set_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type PRINCIPAL")
	},
	{
		.name = discard_const_p(char, "keyblock"),
		.get = py_CREDENTIAL_get_keyblock,
		.set = py_CREDENTIAL_set_keyblock,
		.doc = discard_const_p(char, "PIDL-generated element of base type KEYBLOCK")
	},
	{
		.name = discard_const_p(char, "authtime"),
		.get = py_CREDENTIAL_get_authtime,
		.set = py_CREDENTIAL_set_authtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "starttime"),
		.get = py_CREDENTIAL_get_starttime,
		.set = py_CREDENTIAL_set_starttime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "endtime"),
		.get = py_CREDENTIAL_get_endtime,
		.set = py_CREDENTIAL_set_endtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "renew_till"),
		.get = py_CREDENTIAL_get_renew_till,
		.set = py_CREDENTIAL_set_renew_till,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "is_skey"),
		.get = py_CREDENTIAL_get_is_skey,
		.set = py_CREDENTIAL_set_is_skey,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ticket_flags"),
		.get = py_CREDENTIAL_get_ticket_flags,
		.set = py_CREDENTIAL_set_ticket_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "addresses"),
		.get = py_CREDENTIAL_get_addresses,
		.set = py_CREDENTIAL_set_addresses,
		.doc = discard_const_p(char, "PIDL-generated element of base type ADDRESSES")
	},
	{
		.name = discard_const_p(char, "authdata"),
		.get = py_CREDENTIAL_get_authdata,
		.set = py_CREDENTIAL_set_authdata,
		.doc = discard_const_p(char, "PIDL-generated element of base type AUTHDATA")
	},
	{
		.name = discard_const_p(char, "ticket"),
		.get = py_CREDENTIAL_get_ticket,
		.set = py_CREDENTIAL_set_ticket,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "second_ticket"),
		.get = py_CREDENTIAL_get_second_ticket,
		.set = py_CREDENTIAL_set_second_ticket,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_CREDENTIAL_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CREDENTIAL, type);
}


static PyTypeObject CREDENTIAL_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.CREDENTIAL",
	.tp_getset = py_CREDENTIAL_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CREDENTIAL_new,
};


static PyObject *py_DELTATIME_TAG_get_kdc_sec_offset(PyObject *obj, void *closure)
{
	struct DELTATIME_TAG *object = pytalloc_get_ptr(obj);
	PyObject *py_kdc_sec_offset;
	py_kdc_sec_offset = PyLong_FromLong(object->kdc_sec_offset);
	return py_kdc_sec_offset;
}

static int py_DELTATIME_TAG_set_kdc_sec_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DELTATIME_TAG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->kdc_sec_offset");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->kdc_sec_offset));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->kdc_sec_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DELTATIME_TAG_get_kdc_usec_offset(PyObject *obj, void *closure)
{
	struct DELTATIME_TAG *object = pytalloc_get_ptr(obj);
	PyObject *py_kdc_usec_offset;
	py_kdc_usec_offset = PyLong_FromLong(object->kdc_usec_offset);
	return py_kdc_usec_offset;
}

static int py_DELTATIME_TAG_set_kdc_usec_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DELTATIME_TAG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->kdc_usec_offset");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->kdc_usec_offset));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->kdc_usec_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DELTATIME_TAG_getsetters[] = {
	{
		.name = discard_const_p(char, "kdc_sec_offset"),
		.get = py_DELTATIME_TAG_get_kdc_sec_offset,
		.set = py_DELTATIME_TAG_set_kdc_sec_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "kdc_usec_offset"),
		.get = py_DELTATIME_TAG_get_kdc_usec_offset,
		.set = py_DELTATIME_TAG_set_kdc_usec_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{ .name = NULL }
};

static PyObject *py_DELTATIME_TAG_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DELTATIME_TAG, type);
}


static PyTypeObject DELTATIME_TAG_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.DELTATIME_TAG",
	.tp_getset = py_DELTATIME_TAG_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DELTATIME_TAG_new,
};

static PyObject *py_import_FIELD(TALLOC_CTX *mem_ctx, int level, union FIELD *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&DELTATIME_TAG_Type, mem_ctx, &in->deltatime_tag);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union FIELD *py_export_FIELD(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union FIELD *ret = talloc_zero(mem_ctx, union FIELD);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->deltatime_tag");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DELTATIME_TAG_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->deltatime_tag = *(struct DELTATIME_TAG *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_FIELD_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union FIELD *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union FIELD *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union FIELD!");
		return NULL;
	}

	return py_import_FIELD(mem_ctx, level, in);
}

static PyObject *py_FIELD_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union FIELD *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_FIELD(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_FIELD_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_FIELD_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_FIELD_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_FIELD_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject FIELD_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.FIELD",
	.tp_getset = NULL,
	.tp_methods = py_FIELD_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_FIELD_new,
};


static PyObject *py_V4TAG_get_tag(PyObject *obj, void *closure)
{
	struct V4TAG *object = pytalloc_get_ptr(obj);
	PyObject *py_tag;
	py_tag = PyLong_FromLong((uint16_t)(object->tag));
	return py_tag;
}

static int py_V4TAG_set_tag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct V4TAG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->tag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_V4TAG_get_field(PyObject *obj, void *closure)
{
	struct V4TAG *object = pytalloc_get_ptr(obj);
	PyObject *py_field;
	py_field = pyrpc_import_union(&FIELD_Type, pytalloc_get_mem_ctx(obj), object->tag, &object->field, "union FIELD");
	if (py_field == NULL) {
		return NULL;
	}
	return py_field;
}

static int py_V4TAG_set_field(PyObject *py_obj, PyObject *value, void *closure)
{
	struct V4TAG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->field");
		return -1;
	}
	{
		union FIELD *field_switch_1;
		field_switch_1 = (union FIELD *)pyrpc_export_union(&FIELD_Type, pytalloc_get_mem_ctx(py_obj), object->tag, value, "union FIELD");
		if (field_switch_1 == NULL) {
			return -1;
		}
		object->field = *field_switch_1;
	}
	return 0;
}

static PyGetSetDef py_V4TAG_getsetters[] = {
	{
		.name = discard_const_p(char, "tag"),
		.get = py_V4TAG_get_tag,
		.set = py_V4TAG_set_tag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "field"),
		.get = py_V4TAG_get_field,
		.set = py_V4TAG_set_field,
		.doc = discard_const_p(char, "PIDL-generated element of base type FIELD")
	},
	{ .name = NULL }
};

static PyObject *py_V4TAG_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct V4TAG, type);
}


static PyTypeObject V4TAG_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.V4TAG",
	.tp_getset = py_V4TAG_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_V4TAG_new,
};


static PyObject *py_V4TAGS_get_tag(PyObject *obj, void *closure)
{
	struct V4TAGS *object = pytalloc_get_ptr(obj);
	PyObject *py_tag;
	py_tag = pytalloc_reference_ex(&V4TAG_Type, pytalloc_get_mem_ctx(obj), &object->tag);
	return py_tag;
}

static int py_V4TAGS_set_tag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct V4TAGS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->tag");
		return -1;
	}
	PY_CHECK_TYPE(&V4TAG_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->tag = *(struct V4TAG *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_V4TAGS_get_further_tags(PyObject *obj, void *closure)
{
	struct V4TAGS *object = pytalloc_get_ptr(obj);
	PyObject *py_further_tags;
	py_further_tags = PyBytes_FromStringAndSize((char *)(object->further_tags).data, (object->further_tags).length);
	return py_further_tags;
}

static int py_V4TAGS_set_further_tags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct V4TAGS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->further_tags");
		return -1;
	}
	object->further_tags = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_V4TAGS_getsetters[] = {
	{
		.name = discard_const_p(char, "tag"),
		.get = py_V4TAGS_get_tag,
		.set = py_V4TAGS_set_tag,
		.doc = discard_const_p(char, "PIDL-generated element of base type V4TAG")
	},
	{
		.name = discard_const_p(char, "further_tags"),
		.get = py_V4TAGS_get_further_tags,
		.set = py_V4TAGS_set_further_tags,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_V4TAGS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct V4TAGS, type);
}


static PyTypeObject V4TAGS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.V4TAGS",
	.tp_getset = py_V4TAGS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_V4TAGS_new,
};


static PyObject *py_V4HEADER_get_v4tags(PyObject *obj, void *closure)
{
	struct V4HEADER *object = pytalloc_get_ptr(obj);
	PyObject *py_v4tags;
	py_v4tags = pytalloc_reference_ex(&V4TAGS_Type, pytalloc_get_mem_ctx(obj), &object->v4tags);
	return py_v4tags;
}

static int py_V4HEADER_set_v4tags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct V4HEADER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v4tags");
		return -1;
	}
	PY_CHECK_TYPE(&V4TAGS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->v4tags = *(struct V4TAGS *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_V4HEADER_getsetters[] = {
	{
		.name = discard_const_p(char, "v4tags"),
		.get = py_V4HEADER_get_v4tags,
		.set = py_V4HEADER_set_v4tags,
		.doc = discard_const_p(char, "PIDL-generated element of base type V4TAGS")
	},
	{ .name = NULL }
};

static PyObject *py_V4HEADER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct V4HEADER, type);
}


static PyTypeObject V4HEADER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.V4HEADER",
	.tp_getset = py_V4HEADER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_V4HEADER_new,
};

static PyObject *py_import_OPTIONAL_HEADER(TALLOC_CTX *mem_ctx, int level, union OPTIONAL_HEADER *in)
{
	PyObject *ret;

	switch (level) {
		case 3:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case 4:
			ret = pytalloc_reference_ex(&V4HEADER_Type, mem_ctx, &in->v4header);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union OPTIONAL_HEADER *py_export_OPTIONAL_HEADER(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union OPTIONAL_HEADER *ret = talloc_zero(mem_ctx, union OPTIONAL_HEADER);
	switch (level) {
		case 3:
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->v4header");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&V4HEADER_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->v4header = *(struct V4HEADER *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_OPTIONAL_HEADER_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union OPTIONAL_HEADER *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union OPTIONAL_HEADER *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union OPTIONAL_HEADER!");
		return NULL;
	}

	return py_import_OPTIONAL_HEADER(mem_ctx, level, in);
}

static PyObject *py_OPTIONAL_HEADER_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union OPTIONAL_HEADER *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_OPTIONAL_HEADER(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_OPTIONAL_HEADER_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_OPTIONAL_HEADER_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_OPTIONAL_HEADER_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_OPTIONAL_HEADER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject OPTIONAL_HEADER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.OPTIONAL_HEADER",
	.tp_getset = NULL,
	.tp_methods = py_OPTIONAL_HEADER_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_OPTIONAL_HEADER_new,
};


static PyObject *py_CCACHE_get_pvno(PyObject *obj, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(obj);
	PyObject *py_pvno;
	py_pvno = PyLong_FromLong((uint16_t)(object->pvno));
	return py_pvno;
}

static int py_CCACHE_set_pvno(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pvno");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pvno));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pvno = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CCACHE_get_version(PyObject *obj, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromLong((uint16_t)(object->version));
	return py_version;
}

static int py_CCACHE_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CCACHE_get_optional_header(PyObject *obj, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(obj);
	PyObject *py_optional_header;
	py_optional_header = pyrpc_import_union(&OPTIONAL_HEADER_Type, pytalloc_get_mem_ctx(obj), object->version, &object->optional_header, "union OPTIONAL_HEADER");
	if (py_optional_header == NULL) {
		return NULL;
	}
	return py_optional_header;
}

static int py_CCACHE_set_optional_header(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->optional_header");
		return -1;
	}
	{
		union OPTIONAL_HEADER *optional_header_switch_0;
		optional_header_switch_0 = (union OPTIONAL_HEADER *)pyrpc_export_union(&OPTIONAL_HEADER_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union OPTIONAL_HEADER");
		if (optional_header_switch_0 == NULL) {
			return -1;
		}
		object->optional_header = *optional_header_switch_0;
	}
	return 0;
}

static PyObject *py_CCACHE_get_principal(PyObject *obj, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(obj);
	PyObject *py_principal;
	py_principal = pytalloc_reference_ex(&PRINCIPAL_Type, pytalloc_get_mem_ctx(obj), &object->principal);
	return py_principal;
}

static int py_CCACHE_set_principal(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->principal");
		return -1;
	}
	PY_CHECK_TYPE(&PRINCIPAL_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->principal = *(struct PRINCIPAL *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_CCACHE_get_cred(PyObject *obj, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(obj);
	PyObject *py_cred;
	py_cred = pytalloc_reference_ex(&CREDENTIAL_Type, pytalloc_get_mem_ctx(obj), &object->cred);
	return py_cred;
}

static int py_CCACHE_set_cred(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cred");
		return -1;
	}
	PY_CHECK_TYPE(&CREDENTIAL_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->cred = *(struct CREDENTIAL *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_CCACHE_get_further_creds(PyObject *obj, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(obj);
	PyObject *py_further_creds;
	py_further_creds = PyBytes_FromStringAndSize((char *)(object->further_creds).data, (object->further_creds).length);
	return py_further_creds;
}

static int py_CCACHE_set_further_creds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->further_creds");
		return -1;
	}
	object->further_creds = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_CCACHE_getsetters[] = {
	{
		.name = discard_const_p(char, "pvno"),
		.get = py_CCACHE_get_pvno,
		.set = py_CCACHE_set_pvno,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_CCACHE_get_version,
		.set = py_CCACHE_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "optional_header"),
		.get = py_CCACHE_get_optional_header,
		.set = py_CCACHE_set_optional_header,
		.doc = discard_const_p(char, "PIDL-generated element of base type OPTIONAL_HEADER")
	},
	{
		.name = discard_const_p(char, "principal"),
		.get = py_CCACHE_get_principal,
		.set = py_CCACHE_set_principal,
		.doc = discard_const_p(char, "PIDL-generated element of base type PRINCIPAL")
	},
	{
		.name = discard_const_p(char, "cred"),
		.get = py_CCACHE_get_cred,
		.set = py_CCACHE_set_cred,
		.doc = discard_const_p(char, "PIDL-generated element of base type CREDENTIAL")
	},
	{
		.name = discard_const_p(char, "further_creds"),
		.get = py_CCACHE_get_further_creds,
		.set = py_CCACHE_set_further_creds,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_CCACHE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CCACHE, type);
}

static PyObject *py_CCACHE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_CCACHE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_CCACHE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CCACHE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CCACHE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_CCACHE_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct CCACHE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CCACHE, "CCACHE", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_CCACHE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CCACHE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CCACHE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_CCACHE_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CCACHE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.CCACHE",
	.tp_getset = py_CCACHE_getsetters,
	.tp_methods = py_CCACHE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CCACHE_new,
};


static PyObject *py_MULTIPLE_CREDENTIALS_get_cred(PyObject *obj, void *closure)
{
	struct MULTIPLE_CREDENTIALS *object = pytalloc_get_ptr(obj);
	PyObject *py_cred;
	py_cred = pytalloc_reference_ex(&CREDENTIAL_Type, pytalloc_get_mem_ctx(obj), &object->cred);
	return py_cred;
}

static int py_MULTIPLE_CREDENTIALS_set_cred(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MULTIPLE_CREDENTIALS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cred");
		return -1;
	}
	PY_CHECK_TYPE(&CREDENTIAL_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->cred = *(struct CREDENTIAL *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_MULTIPLE_CREDENTIALS_get_further_creds(PyObject *obj, void *closure)
{
	struct MULTIPLE_CREDENTIALS *object = pytalloc_get_ptr(obj);
	PyObject *py_further_creds;
	py_further_creds = PyBytes_FromStringAndSize((char *)(object->further_creds).data, (object->further_creds).length);
	return py_further_creds;
}

static int py_MULTIPLE_CREDENTIALS_set_further_creds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MULTIPLE_CREDENTIALS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->further_creds");
		return -1;
	}
	object->further_creds = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_MULTIPLE_CREDENTIALS_getsetters[] = {
	{
		.name = discard_const_p(char, "cred"),
		.get = py_MULTIPLE_CREDENTIALS_get_cred,
		.set = py_MULTIPLE_CREDENTIALS_set_cred,
		.doc = discard_const_p(char, "PIDL-generated element of base type CREDENTIAL")
	},
	{
		.name = discard_const_p(char, "further_creds"),
		.get = py_MULTIPLE_CREDENTIALS_get_further_creds,
		.set = py_MULTIPLE_CREDENTIALS_set_further_creds,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_MULTIPLE_CREDENTIALS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct MULTIPLE_CREDENTIALS, type);
}

static PyObject *py_MULTIPLE_CREDENTIALS_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct MULTIPLE_CREDENTIALS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_MULTIPLE_CREDENTIALS);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_MULTIPLE_CREDENTIALS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct MULTIPLE_CREDENTIALS *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_MULTIPLE_CREDENTIALS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_MULTIPLE_CREDENTIALS);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_MULTIPLE_CREDENTIALS_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct MULTIPLE_CREDENTIALS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_MULTIPLE_CREDENTIALS, "MULTIPLE_CREDENTIALS", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_MULTIPLE_CREDENTIALS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_MULTIPLE_CREDENTIALS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_MULTIPLE_CREDENTIALS_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_MULTIPLE_CREDENTIALS_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject MULTIPLE_CREDENTIALS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.MULTIPLE_CREDENTIALS",
	.tp_getset = py_MULTIPLE_CREDENTIALS_getsetters,
	.tp_methods = py_MULTIPLE_CREDENTIALS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_MULTIPLE_CREDENTIALS_new,
};


const struct PyNdrRpcMethodDef py_ndr_krb5ccache_methods[] = {
	{0}
};

static PyObject *interface_krb5ccache_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_krb5ccache);
}

#define PY_DOC_KRB5CCACHE "KRB5 credentials cache"
static PyTypeObject krb5ccache_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.krb5ccache",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "krb5ccache(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_KRB5CCACHE,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_krb5ccache_new,
};

static PyObject *syntax_krb5ccache_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_krb5ccache.syntax_id);
}

#define PY_DOC_KRB5CCACHE_SYNTAX "KRB5 credentials cache"
static PyTypeObject krb5ccache_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5ccache.krb5ccache_abstract_syntax",
	.tp_doc = "krb5ccache_abstract_syntax()\n"PY_DOC_KRB5CCACHE_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_krb5ccache_new,
};

static PyMethodDef krb5ccache_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "krb5ccache",
	.m_doc = "krb5ccache DCE/RPC",
	.m_size = -1,
	.m_methods = krb5ccache_methods,
};
MODULE_INIT_FUNC(krb5ccache)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	PRINCIPAL_Type.tp_base = BaseObject_Type;
	PRINCIPAL_Type.tp_basicsize = pytalloc_BaseObject_size();

	KEYBLOCK_Type.tp_base = BaseObject_Type;
	KEYBLOCK_Type.tp_basicsize = pytalloc_BaseObject_size();

	ADDRESS_Type.tp_base = BaseObject_Type;
	ADDRESS_Type.tp_basicsize = pytalloc_BaseObject_size();

	ADDRESSES_Type.tp_base = BaseObject_Type;
	ADDRESSES_Type.tp_basicsize = pytalloc_BaseObject_size();

	AUTHDATUM_Type.tp_base = BaseObject_Type;
	AUTHDATUM_Type.tp_basicsize = pytalloc_BaseObject_size();

	AUTHDATA_Type.tp_base = BaseObject_Type;
	AUTHDATA_Type.tp_basicsize = pytalloc_BaseObject_size();

	CREDENTIAL_Type.tp_base = BaseObject_Type;
	CREDENTIAL_Type.tp_basicsize = pytalloc_BaseObject_size();

	DELTATIME_TAG_Type.tp_base = BaseObject_Type;
	DELTATIME_TAG_Type.tp_basicsize = pytalloc_BaseObject_size();

	FIELD_Type.tp_base = BaseObject_Type;
	FIELD_Type.tp_basicsize = pytalloc_BaseObject_size();

	V4TAG_Type.tp_base = BaseObject_Type;
	V4TAG_Type.tp_basicsize = pytalloc_BaseObject_size();

	V4TAGS_Type.tp_base = BaseObject_Type;
	V4TAGS_Type.tp_basicsize = pytalloc_BaseObject_size();

	V4HEADER_Type.tp_base = BaseObject_Type;
	V4HEADER_Type.tp_basicsize = pytalloc_BaseObject_size();

	OPTIONAL_HEADER_Type.tp_base = BaseObject_Type;
	OPTIONAL_HEADER_Type.tp_basicsize = pytalloc_BaseObject_size();

	CCACHE_Type.tp_base = BaseObject_Type;
	CCACHE_Type.tp_basicsize = pytalloc_BaseObject_size();

	MULTIPLE_CREDENTIALS_Type.tp_base = BaseObject_Type;
	MULTIPLE_CREDENTIALS_Type.tp_basicsize = pytalloc_BaseObject_size();

	krb5ccache_InterfaceType.tp_base = ClientConnection_Type;

	krb5ccache_SyntaxType.tp_base = ndr_syntax_id_Type;
	krb5ccache_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&PRINCIPAL_Type) < 0)
		goto out;
	if (PyType_Ready(&KEYBLOCK_Type) < 0)
		goto out;
	if (PyType_Ready(&ADDRESS_Type) < 0)
		goto out;
	if (PyType_Ready(&ADDRESSES_Type) < 0)
		goto out;
	if (PyType_Ready(&AUTHDATUM_Type) < 0)
		goto out;
	if (PyType_Ready(&AUTHDATA_Type) < 0)
		goto out;
	if (PyType_Ready(&CREDENTIAL_Type) < 0)
		goto out;
	if (PyType_Ready(&DELTATIME_TAG_Type) < 0)
		goto out;
	if (PyType_Ready(&FIELD_Type) < 0)
		goto out;
	if (PyType_Ready(&V4TAG_Type) < 0)
		goto out;
	if (PyType_Ready(&V4TAGS_Type) < 0)
		goto out;
	if (PyType_Ready(&V4HEADER_Type) < 0)
		goto out;
	if (PyType_Ready(&OPTIONAL_HEADER_Type) < 0)
		goto out;
	if (PyType_Ready(&CCACHE_Type) < 0)
		goto out;
	if (PyType_Ready(&MULTIPLE_CREDENTIALS_Type) < 0)
		goto out;
	if (PyType_Ready(&krb5ccache_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&krb5ccache_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&krb5ccache_InterfaceType, py_ndr_krb5ccache_methods))
		return NULL;

#ifdef PY_PRINCIPAL_PATCH
	PY_PRINCIPAL_PATCH(&PRINCIPAL_Type);
#endif
#ifdef PY_KEYBLOCK_PATCH
	PY_KEYBLOCK_PATCH(&KEYBLOCK_Type);
#endif
#ifdef PY_ADDRESS_PATCH
	PY_ADDRESS_PATCH(&ADDRESS_Type);
#endif
#ifdef PY_ADDRESSES_PATCH
	PY_ADDRESSES_PATCH(&ADDRESSES_Type);
#endif
#ifdef PY_AUTHDATUM_PATCH
	PY_AUTHDATUM_PATCH(&AUTHDATUM_Type);
#endif
#ifdef PY_AUTHDATA_PATCH
	PY_AUTHDATA_PATCH(&AUTHDATA_Type);
#endif
#ifdef PY_CREDENTIAL_PATCH
	PY_CREDENTIAL_PATCH(&CREDENTIAL_Type);
#endif
#ifdef PY_DELTATIME_TAG_PATCH
	PY_DELTATIME_TAG_PATCH(&DELTATIME_TAG_Type);
#endif
#ifdef PY_FIELD_PATCH
	PY_FIELD_PATCH(&FIELD_Type);
#endif
#ifdef PY_V4TAG_PATCH
	PY_V4TAG_PATCH(&V4TAG_Type);
#endif
#ifdef PY_V4TAGS_PATCH
	PY_V4TAGS_PATCH(&V4TAGS_Type);
#endif
#ifdef PY_V4HEADER_PATCH
	PY_V4HEADER_PATCH(&V4HEADER_Type);
#endif
#ifdef PY_OPTIONAL_HEADER_PATCH
	PY_OPTIONAL_HEADER_PATCH(&OPTIONAL_HEADER_Type);
#endif
#ifdef PY_CCACHE_PATCH
	PY_CCACHE_PATCH(&CCACHE_Type);
#endif
#ifdef PY_MULTIPLE_CREDENTIALS_PATCH
	PY_MULTIPLE_CREDENTIALS_PATCH(&MULTIPLE_CREDENTIALS_Type);
#endif
#ifdef PY_KRB5CCACHE_PATCH
	PY_KRB5CCACHE_PATCH(&krb5ccache_InterfaceType);
#endif
#ifdef PY_KRB5CCACHE_ABSTRACT_SYNTAX_PATCH
	PY_KRB5CCACHE_ABSTRACT_SYNTAX_PATCH(&krb5ccache_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&krb5ccache_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	Py_INCREF((PyObject *)(void *)&PRINCIPAL_Type);
	PyModule_AddObject(m, "PRINCIPAL", (PyObject *)(void *)&PRINCIPAL_Type);
	Py_INCREF((PyObject *)(void *)&KEYBLOCK_Type);
	PyModule_AddObject(m, "KEYBLOCK", (PyObject *)(void *)&KEYBLOCK_Type);
	Py_INCREF((PyObject *)(void *)&ADDRESS_Type);
	PyModule_AddObject(m, "ADDRESS", (PyObject *)(void *)&ADDRESS_Type);
	Py_INCREF((PyObject *)(void *)&ADDRESSES_Type);
	PyModule_AddObject(m, "ADDRESSES", (PyObject *)(void *)&ADDRESSES_Type);
	Py_INCREF((PyObject *)(void *)&AUTHDATUM_Type);
	PyModule_AddObject(m, "AUTHDATUM", (PyObject *)(void *)&AUTHDATUM_Type);
	Py_INCREF((PyObject *)(void *)&AUTHDATA_Type);
	PyModule_AddObject(m, "AUTHDATA", (PyObject *)(void *)&AUTHDATA_Type);
	Py_INCREF((PyObject *)(void *)&CREDENTIAL_Type);
	PyModule_AddObject(m, "CREDENTIAL", (PyObject *)(void *)&CREDENTIAL_Type);
	Py_INCREF((PyObject *)(void *)&DELTATIME_TAG_Type);
	PyModule_AddObject(m, "DELTATIME_TAG", (PyObject *)(void *)&DELTATIME_TAG_Type);
	Py_INCREF((PyObject *)(void *)&FIELD_Type);
	PyModule_AddObject(m, "FIELD", (PyObject *)(void *)&FIELD_Type);
	Py_INCREF((PyObject *)(void *)&V4TAG_Type);
	PyModule_AddObject(m, "V4TAG", (PyObject *)(void *)&V4TAG_Type);
	Py_INCREF((PyObject *)(void *)&V4TAGS_Type);
	PyModule_AddObject(m, "V4TAGS", (PyObject *)(void *)&V4TAGS_Type);
	Py_INCREF((PyObject *)(void *)&V4HEADER_Type);
	PyModule_AddObject(m, "V4HEADER", (PyObject *)(void *)&V4HEADER_Type);
	Py_INCREF((PyObject *)(void *)&OPTIONAL_HEADER_Type);
	PyModule_AddObject(m, "OPTIONAL_HEADER", (PyObject *)(void *)&OPTIONAL_HEADER_Type);
	Py_INCREF((PyObject *)(void *)&CCACHE_Type);
	PyModule_AddObject(m, "CCACHE", (PyObject *)(void *)&CCACHE_Type);
	Py_INCREF((PyObject *)(void *)&MULTIPLE_CREDENTIALS_Type);
	PyModule_AddObject(m, "MULTIPLE_CREDENTIALS", (PyObject *)(void *)&MULTIPLE_CREDENTIALS_Type);
	Py_INCREF((PyObject *)(void *)&krb5ccache_InterfaceType);
	PyModule_AddObject(m, "krb5ccache", (PyObject *)(void *)&krb5ccache_InterfaceType);
	Py_INCREF((PyObject *)(void *)&krb5ccache_SyntaxType);
	PyModule_AddObject(m, "krb5ccache_abstract_syntax", (PyObject *)(void *)&krb5ccache_SyntaxType);
	Py_INCREF((PyObject *)(void *)&krb5ccache_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&krb5ccache_SyntaxType);
#ifdef PY_MOD_KRB5CCACHE_PATCH
	PY_MOD_KRB5CCACHE_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
