
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_gmsa.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject MANAGEDPASSWORD_BLOB_PASSWORDS_Type;
static PyTypeObject MANAGEDPASSWORD_BLOB_Type;
static PyTypeObject gmsa_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_current(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_current;
	if (object->current == NULL) {
		Py_RETURN_NONE;
	}
	if (object->current == NULL) {
		py_current = Py_None;
		Py_INCREF(py_current);
	} else {
		py_current = PyBytes_FromUtf16StringOrNULL(object->current);
	}
	return py_current;
}

static int py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_current(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->current");
		return -1;
	}
	if (value == Py_None) {
		object->current = NULL;
	} else {
		object->current = NULL;
		{
			unsigned char *str = NULL;

			str = PyUtf16String_FromBytes(
				pytalloc_get_mem_ctx(py_obj), value);
			if (str == NULL) {
				return -1;
			}

			object->current = str;
		}
	}
	return 0;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_previous(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_previous;
	if (object->previous == NULL) {
		Py_RETURN_NONE;
	}
	if (object->previous == NULL) {
		py_previous = Py_None;
		Py_INCREF(py_previous);
	} else {
		py_previous = PyBytes_FromUtf16StringOrNULL(object->previous);
	}
	return py_previous;
}

static int py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_previous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->previous");
		return -1;
	}
	if (value == Py_None) {
		object->previous = NULL;
	} else {
		object->previous = NULL;
		{
			unsigned char *str = NULL;

			str = PyUtf16String_FromBytes(
				pytalloc_get_mem_ctx(py_obj), value);
			if (str == NULL) {
				return -1;
			}

			object->previous = str;
		}
	}
	return 0;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_query_interval(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_query_interval;
	if (object->query_interval == NULL) {
		Py_RETURN_NONE;
	}
	if (object->query_interval == NULL) {
		py_query_interval = Py_None;
		Py_INCREF(py_query_interval);
	} else {
		py_query_interval = PyLong_FromUnsignedLongLong(*object->query_interval);
	}
	return py_query_interval;
}

static int py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_query_interval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->query_interval));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->query_interval");
		return -1;
	}
	if (value == Py_None) {
		object->query_interval = NULL;
	} else {
		object->query_interval = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->query_interval);
		if (object->query_interval == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->query_interval));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->query_interval = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_unchanged_interval(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_unchanged_interval;
	if (object->unchanged_interval == NULL) {
		Py_RETURN_NONE;
	}
	if (object->unchanged_interval == NULL) {
		py_unchanged_interval = Py_None;
		Py_INCREF(py_unchanged_interval);
	} else {
		py_unchanged_interval = PyLong_FromUnsignedLongLong(*object->unchanged_interval);
	}
	return py_unchanged_interval;
}

static int py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_unchanged_interval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB_PASSWORDS *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->unchanged_interval));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unchanged_interval");
		return -1;
	}
	if (value == Py_None) {
		object->unchanged_interval = NULL;
	} else {
		object->unchanged_interval = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->unchanged_interval);
		if (object->unchanged_interval == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->unchanged_interval));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->unchanged_interval = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyGetSetDef py_MANAGEDPASSWORD_BLOB_PASSWORDS_getsetters[] = {
	{
		.name = discard_const_p(char, "current"),
		.get = py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_current,
		.set = py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_current,
		.doc = discard_const_p(char, "PIDL-generated element of base type u16string")
	},
	{
		.name = discard_const_p(char, "previous"),
		.get = py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_previous,
		.set = py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_previous,
		.doc = discard_const_p(char, "PIDL-generated element of base type u16string")
	},
	{
		.name = discard_const_p(char, "query_interval"),
		.get = py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_query_interval,
		.set = py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_query_interval,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "unchanged_interval"),
		.get = py_MANAGEDPASSWORD_BLOB_PASSWORDS_get_unchanged_interval,
		.set = py_MANAGEDPASSWORD_BLOB_PASSWORDS_set_unchanged_interval,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_MANAGEDPASSWORD_BLOB_PASSWORDS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct MANAGEDPASSWORD_BLOB_PASSWORDS, type);
}


static PyTypeObject MANAGEDPASSWORD_BLOB_PASSWORDS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gmsa.MANAGEDPASSWORD_BLOB_PASSWORDS",
	.tp_getset = py_MANAGEDPASSWORD_BLOB_PASSWORDS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_MANAGEDPASSWORD_BLOB_PASSWORDS_new,
};


static PyObject *py_MANAGEDPASSWORD_BLOB_get_version(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromLong((uint16_t)(object->version));
	return py_version;
}

static int py_MANAGEDPASSWORD_BLOB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_get_reserved(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromLong((uint16_t)(object->reserved));
	return py_reserved;
}

static int py_MANAGEDPASSWORD_BLOB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_get_length(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_MANAGEDPASSWORD_BLOB_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_get_passwords(PyObject *obj, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_passwords;
	py_passwords = pytalloc_reference_ex(&MANAGEDPASSWORD_BLOB_PASSWORDS_Type, pytalloc_get_mem_ctx(obj), &object->passwords);
	return py_passwords;
}

static int py_MANAGEDPASSWORD_BLOB_set_passwords(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->passwords");
		return -1;
	}
	PY_CHECK_TYPE(&MANAGEDPASSWORD_BLOB_PASSWORDS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->passwords = *(struct MANAGEDPASSWORD_BLOB_PASSWORDS *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_MANAGEDPASSWORD_BLOB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_MANAGEDPASSWORD_BLOB_get_version,
		.set = py_MANAGEDPASSWORD_BLOB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_MANAGEDPASSWORD_BLOB_get_reserved,
		.set = py_MANAGEDPASSWORD_BLOB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "length"),
		.get = py_MANAGEDPASSWORD_BLOB_get_length,
		.set = py_MANAGEDPASSWORD_BLOB_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "passwords"),
		.get = py_MANAGEDPASSWORD_BLOB_get_passwords,
		.set = py_MANAGEDPASSWORD_BLOB_set_passwords,
		.doc = discard_const_p(char, "PIDL-generated element of base type MANAGEDPASSWORD_BLOB_PASSWORDS")
	},
	{ .name = NULL }
};

static PyObject *py_MANAGEDPASSWORD_BLOB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct MANAGEDPASSWORD_BLOB, type);
}

static PyObject *py_MANAGEDPASSWORD_BLOB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_MANAGEDPASSWORD_BLOB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_MANAGEDPASSWORD_BLOB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_MANAGEDPASSWORD_BLOB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_MANAGEDPASSWORD_BLOB_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct MANAGEDPASSWORD_BLOB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_MANAGEDPASSWORD_BLOB, "MANAGEDPASSWORD_BLOB", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_MANAGEDPASSWORD_BLOB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_MANAGEDPASSWORD_BLOB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_MANAGEDPASSWORD_BLOB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_MANAGEDPASSWORD_BLOB_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject MANAGEDPASSWORD_BLOB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gmsa.MANAGEDPASSWORD_BLOB",
	.tp_getset = py_MANAGEDPASSWORD_BLOB_getsetters,
	.tp_methods = py_MANAGEDPASSWORD_BLOB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_MANAGEDPASSWORD_BLOB_new,
};


const struct PyNdrRpcMethodDef py_ndr_gmsa_methods[] = {
	{0}
};

static PyObject *interface_gmsa_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_gmsa);
}

#define PY_DOC_GMSA "Active Directory Group Managed Service Accounts"
static PyTypeObject gmsa_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gmsa.gmsa",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "gmsa(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_GMSA,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_gmsa_new,
};

static PyObject *syntax_gmsa_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_gmsa.syntax_id);
}

#define PY_DOC_GMSA_SYNTAX "Active Directory Group Managed Service Accounts"
static PyTypeObject gmsa_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gmsa.gmsa_abstract_syntax",
	.tp_doc = "gmsa_abstract_syntax()\n"PY_DOC_GMSA_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_gmsa_new,
};

static PyMethodDef gmsa_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "gmsa",
	.m_doc = "gmsa DCE/RPC",
	.m_size = -1,
	.m_methods = gmsa_methods,
};
MODULE_INIT_FUNC(gmsa)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	MANAGEDPASSWORD_BLOB_PASSWORDS_Type.tp_base = BaseObject_Type;
	MANAGEDPASSWORD_BLOB_PASSWORDS_Type.tp_basicsize = pytalloc_BaseObject_size();

	MANAGEDPASSWORD_BLOB_Type.tp_base = BaseObject_Type;
	MANAGEDPASSWORD_BLOB_Type.tp_basicsize = pytalloc_BaseObject_size();

	gmsa_InterfaceType.tp_base = ClientConnection_Type;

	gmsa_SyntaxType.tp_base = ndr_syntax_id_Type;
	gmsa_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&MANAGEDPASSWORD_BLOB_PASSWORDS_Type) < 0)
		goto out;
	if (PyType_Ready(&MANAGEDPASSWORD_BLOB_Type) < 0)
		goto out;
	if (PyType_Ready(&gmsa_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&gmsa_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&gmsa_InterfaceType, py_ndr_gmsa_methods))
		return NULL;

#ifdef PY_MANAGEDPASSWORD_BLOB_PASSWORDS_PATCH
	PY_MANAGEDPASSWORD_BLOB_PASSWORDS_PATCH(&MANAGEDPASSWORD_BLOB_PASSWORDS_Type);
#endif
#ifdef PY_MANAGEDPASSWORD_BLOB_PATCH
	PY_MANAGEDPASSWORD_BLOB_PATCH(&MANAGEDPASSWORD_BLOB_Type);
#endif
#ifdef PY_GMSA_PATCH
	PY_GMSA_PATCH(&gmsa_InterfaceType);
#endif
#ifdef PY_GMSA_ABSTRACT_SYNTAX_PATCH
	PY_GMSA_ABSTRACT_SYNTAX_PATCH(&gmsa_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&gmsa_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	Py_INCREF((PyObject *)(void *)&MANAGEDPASSWORD_BLOB_PASSWORDS_Type);
	PyModule_AddObject(m, "MANAGEDPASSWORD_BLOB_PASSWORDS", (PyObject *)(void *)&MANAGEDPASSWORD_BLOB_PASSWORDS_Type);
	Py_INCREF((PyObject *)(void *)&MANAGEDPASSWORD_BLOB_Type);
	PyModule_AddObject(m, "MANAGEDPASSWORD_BLOB", (PyObject *)(void *)&MANAGEDPASSWORD_BLOB_Type);
	Py_INCREF((PyObject *)(void *)&gmsa_InterfaceType);
	PyModule_AddObject(m, "gmsa", (PyObject *)(void *)&gmsa_InterfaceType);
	Py_INCREF((PyObject *)(void *)&gmsa_SyntaxType);
	PyModule_AddObject(m, "gmsa_abstract_syntax", (PyObject *)(void *)&gmsa_SyntaxType);
	Py_INCREF((PyObject *)(void *)&gmsa_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&gmsa_SyntaxType);
#ifdef PY_MOD_GMSA_PATCH
	PY_MOD_GMSA_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
