
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_gkdi.h"
#include "bin/default/librpc/gen_ndr/ndr_gkdi_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject KeyEnvelope_Type;
static PyTypeObject GroupKeyEnvelope_Type;
static PyTypeObject KdfParameters_Type;
static PyTypeObject FfcDhParameters_Type;
static PyTypeObject GkdiDerivationCtx_Type;
static PyTypeObject gkdi_InterfaceType;
static PyTypeObject gkdi_GetKey_Type;

static PyTypeObject *GUID_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_KeyEnvelope_get_version(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_KeyEnvelope_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_magic(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyLong_FromUnsignedLongLong((uint32_t)(object->magic));
	return py_magic;
}

static int py_KeyEnvelope_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->magic");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_flags(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_KeyEnvelope_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_l0_index(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l0_index;
	py_l0_index = PyLong_FromUnsignedLongLong((uint32_t)(object->l0_index));
	return py_l0_index;
}

static int py_KeyEnvelope_set_l0_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l0_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l0_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l0_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_l1_index(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l1_index;
	py_l1_index = PyLong_FromUnsignedLongLong((uint32_t)(object->l1_index));
	return py_l1_index;
}

static int py_KeyEnvelope_set_l1_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l1_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l1_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l1_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_l2_index(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l2_index;
	py_l2_index = PyLong_FromUnsignedLongLong((uint32_t)(object->l2_index));
	return py_l2_index;
}

static int py_KeyEnvelope_set_l2_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l2_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l2_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l2_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_root_key_id(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_root_key_id;
	py_root_key_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->root_key_id);
	return py_root_key_id;
}

static int py_KeyEnvelope_set_root_key_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->root_key_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->root_key_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_KeyEnvelope_get_additional_info_len(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_additional_info_len;
	py_additional_info_len = PyLong_FromUnsignedLongLong((uint32_t)(object->additional_info_len));
	return py_additional_info_len;
}

static int py_KeyEnvelope_set_additional_info_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->additional_info_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->additional_info_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->additional_info_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_domain_name_len(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name_len;
	py_domain_name_len = PyLong_FromUnsignedLongLong((uint32_t)(object->domain_name_len));
	return py_domain_name_len;
}

static int py_KeyEnvelope_set_domain_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_name_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_name_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_forest_name_len(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_name_len;
	py_forest_name_len = PyLong_FromUnsignedLongLong((uint32_t)(object->forest_name_len));
	return py_forest_name_len;
}

static int py_KeyEnvelope_set_forest_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_name_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->forest_name_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->forest_name_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_additional_info(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_additional_info;
	py_additional_info = PyList_New(object->additional_info_len);
	if (py_additional_info == NULL) {
		return NULL;
	}
	{
		int additional_info_cntr_0;
		for (additional_info_cntr_0 = 0; additional_info_cntr_0 < (object->additional_info_len); additional_info_cntr_0++) {
			PyObject *py_additional_info_0;
			py_additional_info_0 = PyLong_FromLong((uint16_t)((object->additional_info)[additional_info_cntr_0]));
			PyList_SetItem(py_additional_info, additional_info_cntr_0, py_additional_info_0);
		}
	}
	return py_additional_info;
}

static int py_KeyEnvelope_set_additional_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->additional_info");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int additional_info_cntr_0;
		object->additional_info = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->additional_info, PyList_GET_SIZE(value));
		if (!object->additional_info) { return -1; }
		talloc_set_name_const(object->additional_info, "ARRAY: object->additional_info");
		for (additional_info_cntr_0 = 0; additional_info_cntr_0 < PyList_GET_SIZE(value); additional_info_cntr_0++) {
			if (PyList_GET_ITEM(value, additional_info_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->additional_info)[additional_info_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->additional_info)[additional_info_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, additional_info_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, additional_info_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->additional_info)[additional_info_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_domain_name(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_KeyEnvelope_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_KeyEnvelope_get_forest_name(PyObject *obj, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_name;
	py_forest_name = PyString_FromStringOrNULL(object->forest_name);
	return py_forest_name;
}

static int py_KeyEnvelope_set_forest_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->forest_name = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_KeyEnvelope_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_KeyEnvelope_get_version,
		.set = py_KeyEnvelope_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "magic"),
		.get = py_KeyEnvelope_get_magic,
		.set = py_KeyEnvelope_set_magic,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_KeyEnvelope_get_flags,
		.set = py_KeyEnvelope_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type EnvelopeFlags")
	},
	{
		.name = discard_const_p(char, "l0_index"),
		.get = py_KeyEnvelope_get_l0_index,
		.set = py_KeyEnvelope_set_l0_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "l1_index"),
		.get = py_KeyEnvelope_get_l1_index,
		.set = py_KeyEnvelope_set_l1_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "l2_index"),
		.get = py_KeyEnvelope_get_l2_index,
		.set = py_KeyEnvelope_set_l2_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "root_key_id"),
		.get = py_KeyEnvelope_get_root_key_id,
		.set = py_KeyEnvelope_set_root_key_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "additional_info_len"),
		.get = py_KeyEnvelope_get_additional_info_len,
		.set = py_KeyEnvelope_set_additional_info_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domain_name_len"),
		.get = py_KeyEnvelope_get_domain_name_len,
		.set = py_KeyEnvelope_set_domain_name_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "forest_name_len"),
		.get = py_KeyEnvelope_get_forest_name_len,
		.set = py_KeyEnvelope_set_forest_name_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "additional_info"),
		.get = py_KeyEnvelope_get_additional_info,
		.set = py_KeyEnvelope_set_additional_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_KeyEnvelope_get_domain_name,
		.set = py_KeyEnvelope_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "forest_name"),
		.get = py_KeyEnvelope_get_forest_name,
		.set = py_KeyEnvelope_set_forest_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_KeyEnvelope_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KeyEnvelope, type);
}

static PyObject *py_KeyEnvelope_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_KeyEnvelope);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_KeyEnvelope_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KeyEnvelope);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KeyEnvelope);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_KeyEnvelope_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct KeyEnvelope *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KeyEnvelope, "KeyEnvelope", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_KeyEnvelope_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_KeyEnvelope_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KeyEnvelope_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_KeyEnvelope_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject KeyEnvelope_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.KeyEnvelope",
	.tp_getset = py_KeyEnvelope_getsetters,
	.tp_methods = py_KeyEnvelope_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KeyEnvelope_new,
};


static PyObject *py_GroupKeyEnvelope_get_version(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_GroupKeyEnvelope_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_magic(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyLong_FromUnsignedLongLong((uint32_t)(object->magic));
	return py_magic;
}

static int py_GroupKeyEnvelope_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->magic");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_flags(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_GroupKeyEnvelope_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_l0_index(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l0_index;
	py_l0_index = PyLong_FromUnsignedLongLong((uint32_t)(object->l0_index));
	return py_l0_index;
}

static int py_GroupKeyEnvelope_set_l0_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l0_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l0_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l0_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_l1_index(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l1_index;
	py_l1_index = PyLong_FromUnsignedLongLong((uint32_t)(object->l1_index));
	return py_l1_index;
}

static int py_GroupKeyEnvelope_set_l1_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l1_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l1_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l1_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_l2_index(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l2_index;
	py_l2_index = PyLong_FromUnsignedLongLong((uint32_t)(object->l2_index));
	return py_l2_index;
}

static int py_GroupKeyEnvelope_set_l2_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l2_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l2_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l2_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_root_key_id(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_root_key_id;
	py_root_key_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->root_key_id);
	return py_root_key_id;
}

static int py_GroupKeyEnvelope_set_root_key_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->root_key_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->root_key_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_kdf_algorithm_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_kdf_algorithm_len;
	py_kdf_algorithm_len = PyLong_FromUnsignedLongLong((uint32_t)(object->kdf_algorithm_len));
	return py_kdf_algorithm_len;
}

static int py_GroupKeyEnvelope_set_kdf_algorithm_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->kdf_algorithm_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->kdf_algorithm_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->kdf_algorithm_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_kdf_parameters_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_kdf_parameters_len;
	py_kdf_parameters_len = PyLong_FromUnsignedLongLong((uint32_t)(object->kdf_parameters_len));
	return py_kdf_parameters_len;
}

static int py_GroupKeyEnvelope_set_kdf_parameters_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->kdf_parameters_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->kdf_parameters_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->kdf_parameters_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_secret_agreement_algorithm_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_secret_agreement_algorithm_len;
	py_secret_agreement_algorithm_len = PyLong_FromUnsignedLongLong((uint32_t)(object->secret_agreement_algorithm_len));
	return py_secret_agreement_algorithm_len;
}

static int py_GroupKeyEnvelope_set_secret_agreement_algorithm_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->secret_agreement_algorithm_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->secret_agreement_algorithm_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->secret_agreement_algorithm_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_secret_agreement_parameters_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_secret_agreement_parameters_len;
	py_secret_agreement_parameters_len = PyLong_FromUnsignedLongLong((uint32_t)(object->secret_agreement_parameters_len));
	return py_secret_agreement_parameters_len;
}

static int py_GroupKeyEnvelope_set_secret_agreement_parameters_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->secret_agreement_parameters_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->secret_agreement_parameters_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->secret_agreement_parameters_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_private_key_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_private_key_len;
	py_private_key_len = PyLong_FromUnsignedLongLong((uint32_t)(object->private_key_len));
	return py_private_key_len;
}

static int py_GroupKeyEnvelope_set_private_key_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->private_key_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->private_key_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->private_key_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_public_key_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_public_key_len;
	py_public_key_len = PyLong_FromUnsignedLongLong((uint32_t)(object->public_key_len));
	return py_public_key_len;
}

static int py_GroupKeyEnvelope_set_public_key_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->public_key_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->public_key_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->public_key_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_l1_key_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l1_key_len;
	py_l1_key_len = PyLong_FromUnsignedLongLong((uint32_t)(object->l1_key_len));
	return py_l1_key_len;
}

static int py_GroupKeyEnvelope_set_l1_key_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l1_key_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l1_key_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l1_key_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_l2_key_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l2_key_len;
	py_l2_key_len = PyLong_FromUnsignedLongLong((uint32_t)(object->l2_key_len));
	return py_l2_key_len;
}

static int py_GroupKeyEnvelope_set_l2_key_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l2_key_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->l2_key_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->l2_key_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_domain_name_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name_len;
	py_domain_name_len = PyLong_FromUnsignedLongLong((uint32_t)(object->domain_name_len));
	return py_domain_name_len;
}

static int py_GroupKeyEnvelope_set_domain_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_name_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_name_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_forest_name_len(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_name_len;
	py_forest_name_len = PyLong_FromUnsignedLongLong((uint32_t)(object->forest_name_len));
	return py_forest_name_len;
}

static int py_GroupKeyEnvelope_set_forest_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_name_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->forest_name_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->forest_name_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_kdf_algorithm(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_kdf_algorithm;
	py_kdf_algorithm = PyString_FromStringOrNULL(object->kdf_algorithm);
	return py_kdf_algorithm;
}

static int py_GroupKeyEnvelope_set_kdf_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->kdf_algorithm");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->kdf_algorithm = talloc_str;
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_kdf_parameters(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_kdf_parameters;
	py_kdf_parameters = PyList_New(object->kdf_parameters_len);
	if (py_kdf_parameters == NULL) {
		return NULL;
	}
	{
		int kdf_parameters_cntr_0;
		for (kdf_parameters_cntr_0 = 0; kdf_parameters_cntr_0 < (object->kdf_parameters_len); kdf_parameters_cntr_0++) {
			PyObject *py_kdf_parameters_0;
			py_kdf_parameters_0 = PyLong_FromLong((uint16_t)((object->kdf_parameters)[kdf_parameters_cntr_0]));
			PyList_SetItem(py_kdf_parameters, kdf_parameters_cntr_0, py_kdf_parameters_0);
		}
	}
	return py_kdf_parameters;
}

static int py_GroupKeyEnvelope_set_kdf_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->kdf_parameters");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int kdf_parameters_cntr_0;
		object->kdf_parameters = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->kdf_parameters, PyList_GET_SIZE(value));
		if (!object->kdf_parameters) { return -1; }
		talloc_set_name_const(object->kdf_parameters, "ARRAY: object->kdf_parameters");
		for (kdf_parameters_cntr_0 = 0; kdf_parameters_cntr_0 < PyList_GET_SIZE(value); kdf_parameters_cntr_0++) {
			if (PyList_GET_ITEM(value, kdf_parameters_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->kdf_parameters)[kdf_parameters_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->kdf_parameters)[kdf_parameters_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, kdf_parameters_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, kdf_parameters_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->kdf_parameters)[kdf_parameters_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_secret_agreement_algorithm(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_secret_agreement_algorithm;
	py_secret_agreement_algorithm = PyString_FromStringOrNULL(object->secret_agreement_algorithm);
	return py_secret_agreement_algorithm;
}

static int py_GroupKeyEnvelope_set_secret_agreement_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->secret_agreement_algorithm");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->secret_agreement_algorithm = talloc_str;
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_secret_agreement_parameters(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_secret_agreement_parameters;
	py_secret_agreement_parameters = PyList_New(object->secret_agreement_parameters_len);
	if (py_secret_agreement_parameters == NULL) {
		return NULL;
	}
	{
		int secret_agreement_parameters_cntr_0;
		for (secret_agreement_parameters_cntr_0 = 0; secret_agreement_parameters_cntr_0 < (object->secret_agreement_parameters_len); secret_agreement_parameters_cntr_0++) {
			PyObject *py_secret_agreement_parameters_0;
			py_secret_agreement_parameters_0 = PyLong_FromLong((uint16_t)((object->secret_agreement_parameters)[secret_agreement_parameters_cntr_0]));
			PyList_SetItem(py_secret_agreement_parameters, secret_agreement_parameters_cntr_0, py_secret_agreement_parameters_0);
		}
	}
	return py_secret_agreement_parameters;
}

static int py_GroupKeyEnvelope_set_secret_agreement_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->secret_agreement_parameters");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int secret_agreement_parameters_cntr_0;
		object->secret_agreement_parameters = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->secret_agreement_parameters, PyList_GET_SIZE(value));
		if (!object->secret_agreement_parameters) { return -1; }
		talloc_set_name_const(object->secret_agreement_parameters, "ARRAY: object->secret_agreement_parameters");
		for (secret_agreement_parameters_cntr_0 = 0; secret_agreement_parameters_cntr_0 < PyList_GET_SIZE(value); secret_agreement_parameters_cntr_0++) {
			if (PyList_GET_ITEM(value, secret_agreement_parameters_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->secret_agreement_parameters)[secret_agreement_parameters_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->secret_agreement_parameters)[secret_agreement_parameters_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, secret_agreement_parameters_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, secret_agreement_parameters_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->secret_agreement_parameters)[secret_agreement_parameters_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_domain_name(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_GroupKeyEnvelope_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->domain_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_forest_name(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_name;
	py_forest_name = PyString_FromStringOrNULL(object->forest_name);
	return py_forest_name;
}

static int py_GroupKeyEnvelope_set_forest_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->forest_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->forest_name = talloc_str;
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_l1_key(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l1_key;
	py_l1_key = PyList_New(object->l1_key_len);
	if (py_l1_key == NULL) {
		return NULL;
	}
	{
		int l1_key_cntr_0;
		for (l1_key_cntr_0 = 0; l1_key_cntr_0 < (object->l1_key_len); l1_key_cntr_0++) {
			PyObject *py_l1_key_0;
			py_l1_key_0 = PyLong_FromLong((uint16_t)((object->l1_key)[l1_key_cntr_0]));
			PyList_SetItem(py_l1_key, l1_key_cntr_0, py_l1_key_0);
		}
	}
	return py_l1_key;
}

static int py_GroupKeyEnvelope_set_l1_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l1_key");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int l1_key_cntr_0;
		object->l1_key = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->l1_key, PyList_GET_SIZE(value));
		if (!object->l1_key) { return -1; }
		talloc_set_name_const(object->l1_key, "ARRAY: object->l1_key");
		for (l1_key_cntr_0 = 0; l1_key_cntr_0 < PyList_GET_SIZE(value); l1_key_cntr_0++) {
			if (PyList_GET_ITEM(value, l1_key_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->l1_key)[l1_key_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->l1_key)[l1_key_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, l1_key_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, l1_key_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->l1_key)[l1_key_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_GroupKeyEnvelope_get_l2_key(PyObject *obj, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(obj);
	PyObject *py_l2_key;
	py_l2_key = PyList_New(object->l2_key_len);
	if (py_l2_key == NULL) {
		return NULL;
	}
	{
		int l2_key_cntr_0;
		for (l2_key_cntr_0 = 0; l2_key_cntr_0 < (object->l2_key_len); l2_key_cntr_0++) {
			PyObject *py_l2_key_0;
			py_l2_key_0 = PyLong_FromLong((uint16_t)((object->l2_key)[l2_key_cntr_0]));
			PyList_SetItem(py_l2_key, l2_key_cntr_0, py_l2_key_0);
		}
	}
	return py_l2_key;
}

static int py_GroupKeyEnvelope_set_l2_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l2_key");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int l2_key_cntr_0;
		object->l2_key = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->l2_key, PyList_GET_SIZE(value));
		if (!object->l2_key) { return -1; }
		talloc_set_name_const(object->l2_key, "ARRAY: object->l2_key");
		for (l2_key_cntr_0 = 0; l2_key_cntr_0 < PyList_GET_SIZE(value); l2_key_cntr_0++) {
			if (PyList_GET_ITEM(value, l2_key_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->l2_key)[l2_key_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->l2_key)[l2_key_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, l2_key_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, l2_key_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->l2_key)[l2_key_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_GroupKeyEnvelope_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_GroupKeyEnvelope_get_version,
		.set = py_GroupKeyEnvelope_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "magic"),
		.get = py_GroupKeyEnvelope_get_magic,
		.set = py_GroupKeyEnvelope_set_magic,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_GroupKeyEnvelope_get_flags,
		.set = py_GroupKeyEnvelope_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type EnvelopeFlags")
	},
	{
		.name = discard_const_p(char, "l0_index"),
		.get = py_GroupKeyEnvelope_get_l0_index,
		.set = py_GroupKeyEnvelope_set_l0_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "l1_index"),
		.get = py_GroupKeyEnvelope_get_l1_index,
		.set = py_GroupKeyEnvelope_set_l1_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "l2_index"),
		.get = py_GroupKeyEnvelope_get_l2_index,
		.set = py_GroupKeyEnvelope_set_l2_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "root_key_id"),
		.get = py_GroupKeyEnvelope_get_root_key_id,
		.set = py_GroupKeyEnvelope_set_root_key_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "kdf_algorithm_len"),
		.get = py_GroupKeyEnvelope_get_kdf_algorithm_len,
		.set = py_GroupKeyEnvelope_set_kdf_algorithm_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "kdf_parameters_len"),
		.get = py_GroupKeyEnvelope_get_kdf_parameters_len,
		.set = py_GroupKeyEnvelope_set_kdf_parameters_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "secret_agreement_algorithm_len"),
		.get = py_GroupKeyEnvelope_get_secret_agreement_algorithm_len,
		.set = py_GroupKeyEnvelope_set_secret_agreement_algorithm_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "secret_agreement_parameters_len"),
		.get = py_GroupKeyEnvelope_get_secret_agreement_parameters_len,
		.set = py_GroupKeyEnvelope_set_secret_agreement_parameters_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "private_key_len"),
		.get = py_GroupKeyEnvelope_get_private_key_len,
		.set = py_GroupKeyEnvelope_set_private_key_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "public_key_len"),
		.get = py_GroupKeyEnvelope_get_public_key_len,
		.set = py_GroupKeyEnvelope_set_public_key_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "l1_key_len"),
		.get = py_GroupKeyEnvelope_get_l1_key_len,
		.set = py_GroupKeyEnvelope_set_l1_key_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "l2_key_len"),
		.get = py_GroupKeyEnvelope_get_l2_key_len,
		.set = py_GroupKeyEnvelope_set_l2_key_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domain_name_len"),
		.get = py_GroupKeyEnvelope_get_domain_name_len,
		.set = py_GroupKeyEnvelope_set_domain_name_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "forest_name_len"),
		.get = py_GroupKeyEnvelope_get_forest_name_len,
		.set = py_GroupKeyEnvelope_set_forest_name_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "kdf_algorithm"),
		.get = py_GroupKeyEnvelope_get_kdf_algorithm,
		.set = py_GroupKeyEnvelope_set_kdf_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "kdf_parameters"),
		.get = py_GroupKeyEnvelope_get_kdf_parameters,
		.set = py_GroupKeyEnvelope_set_kdf_parameters,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "secret_agreement_algorithm"),
		.get = py_GroupKeyEnvelope_get_secret_agreement_algorithm,
		.set = py_GroupKeyEnvelope_set_secret_agreement_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "secret_agreement_parameters"),
		.get = py_GroupKeyEnvelope_get_secret_agreement_parameters,
		.set = py_GroupKeyEnvelope_set_secret_agreement_parameters,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_GroupKeyEnvelope_get_domain_name,
		.set = py_GroupKeyEnvelope_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "forest_name"),
		.get = py_GroupKeyEnvelope_get_forest_name,
		.set = py_GroupKeyEnvelope_set_forest_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "l1_key"),
		.get = py_GroupKeyEnvelope_get_l1_key,
		.set = py_GroupKeyEnvelope_set_l1_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "l2_key"),
		.get = py_GroupKeyEnvelope_get_l2_key,
		.set = py_GroupKeyEnvelope_set_l2_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_GroupKeyEnvelope_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct GroupKeyEnvelope, type);
}

static PyObject *py_GroupKeyEnvelope_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_GroupKeyEnvelope);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_GroupKeyEnvelope_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_GroupKeyEnvelope);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_GroupKeyEnvelope);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_GroupKeyEnvelope_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct GroupKeyEnvelope *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_GroupKeyEnvelope, "GroupKeyEnvelope", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_GroupKeyEnvelope_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_GroupKeyEnvelope_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_GroupKeyEnvelope_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_GroupKeyEnvelope_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject GroupKeyEnvelope_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.GroupKeyEnvelope",
	.tp_getset = py_GroupKeyEnvelope_getsetters,
	.tp_methods = py_GroupKeyEnvelope_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_GroupKeyEnvelope_new,
};


static PyObject *py_KdfParameters_get_padding_0(PyObject *obj, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_padding_0;
	py_padding_0 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding_0));
	return py_padding_0;
}

static int py_KdfParameters_set_padding_0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding_0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding_0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding_0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KdfParameters_get_padding_1(PyObject *obj, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_padding_1;
	py_padding_1 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding_1));
	return py_padding_1;
}

static int py_KdfParameters_set_padding_1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding_1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding_1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding_1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KdfParameters_get_hash_algorithm_len(PyObject *obj, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_hash_algorithm_len;
	py_hash_algorithm_len = PyLong_FromUnsignedLongLong((uint32_t)(object->hash_algorithm_len));
	return py_hash_algorithm_len;
}

static int py_KdfParameters_set_hash_algorithm_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->hash_algorithm_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->hash_algorithm_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->hash_algorithm_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KdfParameters_get_padding_2(PyObject *obj, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_padding_2;
	py_padding_2 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding_2));
	return py_padding_2;
}

static int py_KdfParameters_set_padding_2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding_2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding_2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding_2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KdfParameters_get_hash_algorithm(PyObject *obj, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_hash_algorithm;
	py_hash_algorithm = PyString_FromStringOrNULL(object->hash_algorithm);
	return py_hash_algorithm;
}

static int py_KdfParameters_set_hash_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->hash_algorithm");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->hash_algorithm = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_KdfParameters_getsetters[] = {
	{
		.name = discard_const_p(char, "padding_0"),
		.get = py_KdfParameters_get_padding_0,
		.set = py_KdfParameters_set_padding_0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "padding_1"),
		.get = py_KdfParameters_get_padding_1,
		.set = py_KdfParameters_set_padding_1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "hash_algorithm_len"),
		.get = py_KdfParameters_get_hash_algorithm_len,
		.set = py_KdfParameters_set_hash_algorithm_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "padding_2"),
		.get = py_KdfParameters_get_padding_2,
		.set = py_KdfParameters_set_padding_2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "hash_algorithm"),
		.get = py_KdfParameters_get_hash_algorithm,
		.set = py_KdfParameters_set_hash_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_KdfParameters_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KdfParameters, type);
}

static PyObject *py_KdfParameters_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_KdfParameters);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_KdfParameters_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KdfParameters);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KdfParameters);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_KdfParameters_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct KdfParameters *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KdfParameters, "KdfParameters", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_KdfParameters_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_KdfParameters_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KdfParameters_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_KdfParameters_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject KdfParameters_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.KdfParameters",
	.tp_getset = py_KdfParameters_getsetters,
	.tp_methods = py_KdfParameters_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KdfParameters_new,
};


static PyObject *py_FfcDhParameters_get_length(PyObject *obj, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_FfcDhParameters_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_FfcDhParameters_get_magic(PyObject *obj, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyLong_FromUnsignedLongLong((uint32_t)(object->magic));
	return py_magic;
}

static int py_FfcDhParameters_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->magic");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_FfcDhParameters_get_key_length(PyObject *obj, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_key_length;
	py_key_length = PyLong_FromUnsignedLongLong((uint32_t)(object->key_length));
	return py_key_length;
}

static int py_FfcDhParameters_set_key_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->key_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->key_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->key_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_FfcDhParameters_get_field_order(PyObject *obj, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_field_order;
	py_field_order = PyList_New(object->key_length);
	if (py_field_order == NULL) {
		return NULL;
	}
	{
		int field_order_cntr_0;
		for (field_order_cntr_0 = 0; field_order_cntr_0 < (object->key_length); field_order_cntr_0++) {
			PyObject *py_field_order_0;
			py_field_order_0 = PyLong_FromLong((uint16_t)((object->field_order)[field_order_cntr_0]));
			PyList_SetItem(py_field_order, field_order_cntr_0, py_field_order_0);
		}
	}
	return py_field_order;
}

static int py_FfcDhParameters_set_field_order(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->field_order");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int field_order_cntr_0;
		object->field_order = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->field_order, PyList_GET_SIZE(value));
		if (!object->field_order) { return -1; }
		talloc_set_name_const(object->field_order, "ARRAY: object->field_order");
		for (field_order_cntr_0 = 0; field_order_cntr_0 < PyList_GET_SIZE(value); field_order_cntr_0++) {
			if (PyList_GET_ITEM(value, field_order_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->field_order)[field_order_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->field_order)[field_order_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, field_order_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, field_order_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->field_order)[field_order_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_FfcDhParameters_get_generator(PyObject *obj, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(obj);
	PyObject *py_generator;
	py_generator = PyList_New(object->key_length);
	if (py_generator == NULL) {
		return NULL;
	}
	{
		int generator_cntr_0;
		for (generator_cntr_0 = 0; generator_cntr_0 < (object->key_length); generator_cntr_0++) {
			PyObject *py_generator_0;
			py_generator_0 = PyLong_FromLong((uint16_t)((object->generator)[generator_cntr_0]));
			PyList_SetItem(py_generator, generator_cntr_0, py_generator_0);
		}
	}
	return py_generator;
}

static int py_FfcDhParameters_set_generator(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->generator");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int generator_cntr_0;
		object->generator = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->generator, PyList_GET_SIZE(value));
		if (!object->generator) { return -1; }
		talloc_set_name_const(object->generator, "ARRAY: object->generator");
		for (generator_cntr_0 = 0; generator_cntr_0 < PyList_GET_SIZE(value); generator_cntr_0++) {
			if (PyList_GET_ITEM(value, generator_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->generator)[generator_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->generator)[generator_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, generator_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, generator_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->generator)[generator_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_FfcDhParameters_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_FfcDhParameters_get_length,
		.set = py_FfcDhParameters_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "magic"),
		.get = py_FfcDhParameters_get_magic,
		.set = py_FfcDhParameters_set_magic,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "key_length"),
		.get = py_FfcDhParameters_get_key_length,
		.set = py_FfcDhParameters_set_key_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "field_order"),
		.get = py_FfcDhParameters_get_field_order,
		.set = py_FfcDhParameters_set_field_order,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "generator"),
		.get = py_FfcDhParameters_get_generator,
		.set = py_FfcDhParameters_set_generator,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_FfcDhParameters_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct FfcDhParameters, type);
}

static PyObject *py_FfcDhParameters_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_FfcDhParameters);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_FfcDhParameters_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FfcDhParameters);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FfcDhParameters);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_FfcDhParameters_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct FfcDhParameters *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_FfcDhParameters, "FfcDhParameters", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_FfcDhParameters_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_FfcDhParameters_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_FfcDhParameters_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_FfcDhParameters_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject FfcDhParameters_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.FfcDhParameters",
	.tp_getset = py_FfcDhParameters_getsetters,
	.tp_methods = py_FfcDhParameters_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_FfcDhParameters_new,
};


static PyObject *py_GkdiDerivationCtx_get_guid(PyObject *obj, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_GkdiDerivationCtx_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_GkdiDerivationCtx_get_l0_idx(PyObject *obj, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(obj);
	PyObject *py_l0_idx;
	py_l0_idx = PyLong_FromLong(object->l0_idx);
	return py_l0_idx;
}

static int py_GkdiDerivationCtx_set_l0_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l0_idx");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->l0_idx));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->l0_idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GkdiDerivationCtx_get_l1_idx(PyObject *obj, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(obj);
	PyObject *py_l1_idx;
	py_l1_idx = PyLong_FromLong(object->l1_idx);
	return py_l1_idx;
}

static int py_GkdiDerivationCtx_set_l1_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l1_idx");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->l1_idx));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->l1_idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GkdiDerivationCtx_get_l2_idx(PyObject *obj, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(obj);
	PyObject *py_l2_idx;
	py_l2_idx = PyLong_FromLong(object->l2_idx);
	return py_l2_idx;
}

static int py_GkdiDerivationCtx_set_l2_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->l2_idx");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->l2_idx));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->l2_idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GkdiDerivationCtx_get_target_security_descriptor(PyObject *obj, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(obj);
	PyObject *py_target_security_descriptor;
	py_target_security_descriptor = PyBytes_FromStringAndSize((char *)(object->target_security_descriptor).data, (object->target_security_descriptor).length);
	return py_target_security_descriptor;
}

static int py_GkdiDerivationCtx_set_target_security_descriptor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->target_security_descriptor");
		return -1;
	}
	object->target_security_descriptor = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_GkdiDerivationCtx_getsetters[] = {
	{
		.name = discard_const_p(char, "guid"),
		.get = py_GkdiDerivationCtx_get_guid,
		.set = py_GkdiDerivationCtx_set_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "l0_idx"),
		.get = py_GkdiDerivationCtx_get_l0_idx,
		.set = py_GkdiDerivationCtx_set_l0_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "l1_idx"),
		.get = py_GkdiDerivationCtx_get_l1_idx,
		.set = py_GkdiDerivationCtx_set_l1_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "l2_idx"),
		.get = py_GkdiDerivationCtx_get_l2_idx,
		.set = py_GkdiDerivationCtx_set_l2_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "target_security_descriptor"),
		.get = py_GkdiDerivationCtx_get_target_security_descriptor,
		.set = py_GkdiDerivationCtx_set_target_security_descriptor,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_GkdiDerivationCtx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct GkdiDerivationCtx, type);
}

static PyObject *py_GkdiDerivationCtx_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_GkdiDerivationCtx);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_GkdiDerivationCtx_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_GkdiDerivationCtx);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_GkdiDerivationCtx);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_GkdiDerivationCtx_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct GkdiDerivationCtx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_GkdiDerivationCtx, "GkdiDerivationCtx", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_GkdiDerivationCtx_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_GkdiDerivationCtx_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_GkdiDerivationCtx_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_GkdiDerivationCtx_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject GkdiDerivationCtx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.GkdiDerivationCtx",
	.tp_getset = py_GkdiDerivationCtx_getsetters,
	.tp_methods = py_GkdiDerivationCtx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_GkdiDerivationCtx_new,
};



static PyObject *py_gkdi_GetKey_in_get_target_sd_len(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_target_sd_len;
	py_target_sd_len = PyLong_FromUnsignedLongLong((uint32_t)(object->in.target_sd_len));
	return py_target_sd_len;
}

static int py_gkdi_GetKey_in_set_target_sd_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.target_sd_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.target_sd_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.target_sd_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_in_get_target_sd(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_target_sd;
	if (object->in.target_sd == NULL) {
		Py_RETURN_NONE;
	}
	py_target_sd = PyList_New(object->in.target_sd_len);
	if (py_target_sd == NULL) {
		return NULL;
	}
	{
		int target_sd_cntr_1;
		for (target_sd_cntr_1 = 0; target_sd_cntr_1 < (object->in.target_sd_len); target_sd_cntr_1++) {
			PyObject *py_target_sd_1;
			py_target_sd_1 = PyLong_FromLong((uint16_t)((object->in.target_sd)[target_sd_cntr_1]));
			PyList_SetItem(py_target_sd, target_sd_cntr_1, py_target_sd_1);
		}
	}
	return py_target_sd;
}

static int py_gkdi_GetKey_in_set_target_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.target_sd));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.target_sd");
		return -1;
	}
	object->in.target_sd = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.target_sd);
	if (object->in.target_sd == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int target_sd_cntr_1;
		object->in.target_sd = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.target_sd, PyList_GET_SIZE(value));
		if (!object->in.target_sd) { return -1; }
		talloc_set_name_const(object->in.target_sd, "ARRAY: object->in.target_sd");
		for (target_sd_cntr_1 = 0; target_sd_cntr_1 < PyList_GET_SIZE(value); target_sd_cntr_1++) {
			if (PyList_GET_ITEM(value, target_sd_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.target_sd)[target_sd_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.target_sd)[target_sd_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, target_sd_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, target_sd_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.target_sd)[target_sd_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_in_get_root_key_id(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_root_key_id;
	if (object->in.root_key_id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.root_key_id == NULL) {
		py_root_key_id = Py_None;
		Py_INCREF(py_root_key_id);
	} else {
		py_root_key_id = pytalloc_reference_ex(GUID_Type, object->in.root_key_id, object->in.root_key_id);
	}
	return py_root_key_id;
}

static int py_gkdi_GetKey_in_set_root_key_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.root_key_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.root_key_id");
		return -1;
	}
	if (value == Py_None) {
		object->in.root_key_id = NULL;
	} else {
		object->in.root_key_id = NULL;
		PY_CHECK_TYPE(GUID_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.root_key_id = (struct GUID *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_in_get_l0_key_id(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_l0_key_id;
	py_l0_key_id = PyLong_FromLong(object->in.l0_key_id);
	return py_l0_key_id;
}

static int py_gkdi_GetKey_in_set_l0_key_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.l0_key_id");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->in.l0_key_id));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->in.l0_key_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_in_get_l1_key_id(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_l1_key_id;
	py_l1_key_id = PyLong_FromLong(object->in.l1_key_id);
	return py_l1_key_id;
}

static int py_gkdi_GetKey_in_set_l1_key_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.l1_key_id");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->in.l1_key_id));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->in.l1_key_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_in_get_l2_key_id(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_l2_key_id;
	py_l2_key_id = PyLong_FromLong(object->in.l2_key_id);
	return py_l2_key_id;
}

static int py_gkdi_GetKey_in_set_l2_key_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.l2_key_id");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->in.l2_key_id));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->in.l2_key_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_out_get_out_len(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_out_len;
	if (object->out.out_len == NULL) {
		Py_RETURN_NONE;
	}
	py_out_len = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.out_len));
	return py_out_len;
}

static int py_gkdi_GetKey_out_set_out_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.out_len));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.out_len");
		return -1;
	}
	object->out.out_len = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.out_len);
	if (object->out.out_len == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.out_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.out_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_out_get_out(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_out;
	if (object->out.out == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.out == NULL) {
		py_out = Py_None;
		Py_INCREF(py_out);
	} else {
		py_out = PyList_New(*object->out.out_len);
		if (py_out == NULL) {
			return NULL;
		}
		{
			int out_cntr_2;
			for (out_cntr_2 = 0; out_cntr_2 < (*object->out.out_len); out_cntr_2++) {
				PyObject *py_out_2;
				py_out_2 = PyLong_FromLong((uint16_t)((*object->out.out)[out_cntr_2]));
				PyList_SetItem(py_out, out_cntr_2, py_out_2);
			}
		}
	}
	return py_out;
}

static int py_gkdi_GetKey_out_set_out(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.out));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.out");
		return -1;
	}
	object->out.out = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.out);
	if (object->out.out == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.out = NULL;
	} else {
		*object->out.out = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int out_cntr_2;
			*object->out.out = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), *object->out.out, PyList_GET_SIZE(value));
			if (!*object->out.out) { return -1; }
			talloc_set_name_const(*object->out.out, "ARRAY: *object->out.out");
			for (out_cntr_2 = 0; out_cntr_2 < PyList_GET_SIZE(value); out_cntr_2++) {
				if (PyList_GET_ITEM(value, out_cntr_2) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (*object->out.out)[out_cntr_2]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((*object->out.out)[out_cntr_2]));
					if (PyLong_Check(PyList_GET_ITEM(value, out_cntr_2))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, out_cntr_2));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(*object->out.out)[out_cntr_2] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_gkdi_GetKey_get_result(PyObject *obj, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromHRESULT(object->out.result);
	return py_result;
}

static int py_gkdi_GetKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = HRES_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_gkdi_GetKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_target_sd_len"),
		.get = py_gkdi_GetKey_in_get_target_sd_len,
		.set = py_gkdi_GetKey_in_set_target_sd_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_target_sd"),
		.get = py_gkdi_GetKey_in_get_target_sd,
		.set = py_gkdi_GetKey_in_set_target_sd,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_root_key_id"),
		.get = py_gkdi_GetKey_in_get_root_key_id,
		.set = py_gkdi_GetKey_in_set_root_key_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "in_l0_key_id"),
		.get = py_gkdi_GetKey_in_get_l0_key_id,
		.set = py_gkdi_GetKey_in_set_l0_key_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "in_l1_key_id"),
		.get = py_gkdi_GetKey_in_get_l1_key_id,
		.set = py_gkdi_GetKey_in_set_l1_key_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "in_l2_key_id"),
		.get = py_gkdi_GetKey_in_get_l2_key_id,
		.set = py_gkdi_GetKey_in_set_l2_key_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "out_out_len"),
		.get = py_gkdi_GetKey_out_get_out_len,
		.set = py_gkdi_GetKey_out_set_out_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_out"),
		.get = py_gkdi_GetKey_out_get_out,
		.set = py_gkdi_GetKey_out_set_out,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_gkdi_GetKey_get_result,
		.set = py_gkdi_GetKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type HRESULT")
	},
	{ .name = NULL }
};

static PyObject *py_gkdi_GetKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct gkdi_GetKey, type);
	struct gkdi_GetKey *_self = (struct gkdi_GetKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.target_sd = talloc_zero(mem_ctx, uint8_t);
	_self->out.out_len = talloc_zero(mem_ctx, uint32_t);
	/* a pointer to a NULL pointer */
	_self->out.out = talloc_zero(mem_ctx, uint8_t *);
	return self;
}

static PyObject *py_gkdi_GetKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_gkdi_GetKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_gkdi.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_gkdi_GetKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_gkdi.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_gkdi_GetKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_gkdi_GetKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_gkdi_GetKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_gkdi_GetKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_gkdi_GetKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_gkdi.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_gkdi_GetKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_gkdi.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_gkdi_GetKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_gkdi_GetKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_gkdi_GetKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_gkdi_GetKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_gkdi_GetKey_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct gkdi_GetKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_gkdi.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_gkdi_GetKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_gkdi.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_gkdi_GetKey_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_gkdi_GetKey_ndr_print(py_obj, "gkdi_GetKey_in", NDR_IN);
}

static PyObject *py_gkdi_GetKey_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_gkdi_GetKey_ndr_print(py_obj, "gkdi_GetKey_out", NDR_OUT);
}

static PyMethodDef py_gkdi_GetKey_methods[] = {
	{ "opnum", (PyCFunction)py_gkdi_GetKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"gkdi.GetKey.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_gkdi_GetKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_gkdi_GetKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_gkdi_GetKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_gkdi_GetKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_gkdi_GetKey_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_gkdi_GetKey_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject gkdi_GetKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.GetKey",
	.tp_getset = py_gkdi_GetKey_getsetters,
	.tp_methods = py_gkdi_GetKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_gkdi_GetKey_new,
};

static bool pack_py_gkdi_GetKey_args_in(PyObject *args, PyObject *kwargs, struct gkdi_GetKey *r)
{
	PyObject *py_target_sd;
	PyObject *py_root_key_id;
	PyObject *py_l0_key_id;
	PyObject *py_l1_key_id;
	PyObject *py_l2_key_id;
	const char *kwnames[] = {
		"target_sd", "root_key_id", "l0_key_id", "l1_key_id", "l2_key_id", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:gkdi_GetKey", discard_const_p(char *, kwnames), &py_target_sd, &py_root_key_id, &py_l0_key_id, &py_l1_key_id, &py_l2_key_id)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_target_sd, return false;);
	r->in.target_sd_len = PyList_GET_SIZE(py_target_sd);
	if (py_target_sd == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.target_sd");
		return false;
	}
	r->in.target_sd = talloc_ptrtype(r, r->in.target_sd);
	if (r->in.target_sd == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_target_sd, return false;);
	{
		int target_sd_cntr_1;
		r->in.target_sd = talloc_array_ptrtype(r, r->in.target_sd, PyList_GET_SIZE(py_target_sd));
		if (!r->in.target_sd) { return false; }
		talloc_set_name_const(r->in.target_sd, "ARRAY: r->in.target_sd");
		for (target_sd_cntr_1 = 0; target_sd_cntr_1 < PyList_GET_SIZE(py_target_sd); target_sd_cntr_1++) {
			if (PyList_GET_ITEM(py_target_sd, target_sd_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.target_sd)[target_sd_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.target_sd)[target_sd_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_target_sd, target_sd_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_target_sd, target_sd_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.target_sd)[target_sd_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	if (py_root_key_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.root_key_id");
		return false;
	}
	if (py_root_key_id == Py_None) {
		r->in.root_key_id = NULL;
	} else {
		r->in.root_key_id = NULL;
		PY_CHECK_TYPE(GUID_Type, py_root_key_id, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_root_key_id)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.root_key_id = (struct GUID *)pytalloc_get_ptr(py_root_key_id);
	}
	if (py_l0_key_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.l0_key_id");
		return false;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(r->in.l0_key_id));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(py_l0_key_id)) {
			long long test_var;
			test_var = PyLong_AsLongLong(py_l0_key_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return false;
			}
			r->in.l0_key_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_l1_key_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.l1_key_id");
		return false;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(r->in.l1_key_id));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(py_l1_key_id)) {
			long long test_var;
			test_var = PyLong_AsLongLong(py_l1_key_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return false;
			}
			r->in.l1_key_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_l2_key_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.l2_key_id");
		return false;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(r->in.l2_key_id));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(py_l2_key_id)) {
			long long test_var;
			test_var = PyLong_AsLongLong(py_l2_key_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return false;
			}
			r->in.l2_key_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_gkdi_GetKey_args_out(struct gkdi_GetKey *r)
{
	PyObject *result;
	PyObject *py_out_len;
	PyObject *py_out;
	result = PyTuple_New(3);
	py_out_len = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.out_len));
	PyTuple_SetItem(result, 0, py_out_len);
	if (*r->out.out == NULL) {
		py_out = Py_None;
		Py_INCREF(py_out);
	} else {
		py_out = PyList_New(*r->out.out_len);
		if (py_out == NULL) {
			return NULL;
		}
		{
			int out_cntr_2;
			for (out_cntr_2 = 0; out_cntr_2 < (*r->out.out_len); out_cntr_2++) {
				PyObject *py_out_2;
				py_out_2 = PyLong_FromLong((uint16_t)((*r->out.out)[out_cntr_2]));
				PyList_SetItem(py_out, out_cntr_2, py_out_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_out);
	PyTuple_SetItem(result, 2, PyErr_FromHRESULT(r->out.result));
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_gkdi_methods[] = {
	{ "GetKey", "S.GetKey(target_sd, root_key_id, l0_key_id, l1_key_id, l2_key_id) -> (out_len, out, result)", (py_dcerpc_call_fn)dcerpc_gkdi_GetKey_r, (py_data_pack_fn)pack_py_gkdi_GetKey_args_in, (py_data_unpack_fn)unpack_py_gkdi_GetKey_args_out, 0, &ndr_table_gkdi },
	{0}
};

static PyObject *interface_gkdi_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_gkdi);
}

#define PY_DOC_GKDI "Active Directory Group Key Distribution Service"
static PyTypeObject gkdi_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.gkdi",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "gkdi(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_GKDI,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_gkdi_new,
};

static PyObject *syntax_gkdi_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_gkdi.syntax_id);
}

#define PY_DOC_GKDI_SYNTAX "Active Directory Group Key Distribution Service"
static PyTypeObject gkdi_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "gkdi.gkdi_abstract_syntax",
	.tp_doc = "gkdi_abstract_syntax()\n"PY_DOC_GKDI_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_gkdi_new,
};

static PyMethodDef gkdi_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "gkdi",
	.m_doc = "gkdi DCE/RPC",
	.m_size = -1,
	.m_methods = gkdi_methods,
};
MODULE_INIT_FUNC(gkdi)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	KeyEnvelope_Type.tp_base = BaseObject_Type;
	KeyEnvelope_Type.tp_basicsize = pytalloc_BaseObject_size();

	GroupKeyEnvelope_Type.tp_base = BaseObject_Type;
	GroupKeyEnvelope_Type.tp_basicsize = pytalloc_BaseObject_size();

	KdfParameters_Type.tp_base = BaseObject_Type;
	KdfParameters_Type.tp_basicsize = pytalloc_BaseObject_size();

	FfcDhParameters_Type.tp_base = BaseObject_Type;
	FfcDhParameters_Type.tp_basicsize = pytalloc_BaseObject_size();

	GkdiDerivationCtx_Type.tp_base = BaseObject_Type;
	GkdiDerivationCtx_Type.tp_basicsize = pytalloc_BaseObject_size();

	gkdi_GetKey_Type.tp_base = BaseObject_Type;
	gkdi_GetKey_Type.tp_basicsize = pytalloc_BaseObject_size();

	gkdi_InterfaceType.tp_base = ClientConnection_Type;

	gkdi_SyntaxType.tp_base = ndr_syntax_id_Type;
	gkdi_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&KeyEnvelope_Type) < 0)
		goto out;
	if (PyType_Ready(&GroupKeyEnvelope_Type) < 0)
		goto out;
	if (PyType_Ready(&KdfParameters_Type) < 0)
		goto out;
	if (PyType_Ready(&FfcDhParameters_Type) < 0)
		goto out;
	if (PyType_Ready(&GkdiDerivationCtx_Type) < 0)
		goto out;
	if (PyType_Ready(&gkdi_GetKey_Type) < 0)
		goto out;
	if (PyType_Ready(&gkdi_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&gkdi_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&gkdi_InterfaceType, py_ndr_gkdi_methods))
		return NULL;

#ifdef PY_KEYENVELOPE_PATCH
	PY_KEYENVELOPE_PATCH(&KeyEnvelope_Type);
#endif
#ifdef PY_GROUPKEYENVELOPE_PATCH
	PY_GROUPKEYENVELOPE_PATCH(&GroupKeyEnvelope_Type);
#endif
#ifdef PY_KDFPARAMETERS_PATCH
	PY_KDFPARAMETERS_PATCH(&KdfParameters_Type);
#endif
#ifdef PY_FFCDHPARAMETERS_PATCH
	PY_FFCDHPARAMETERS_PATCH(&FfcDhParameters_Type);
#endif
#ifdef PY_GKDIDERIVATIONCTX_PATCH
	PY_GKDIDERIVATIONCTX_PATCH(&GkdiDerivationCtx_Type);
#endif
#ifdef PY_GETKEY_PATCH
	PY_GETKEY_PATCH(&gkdi_GetKey_Type);
#endif
#ifdef PY_GKDI_PATCH
	PY_GKDI_PATCH(&gkdi_InterfaceType);
#endif
#ifdef PY_GKDI_ABSTRACT_SYNTAX_PATCH
	PY_GKDI_ABSTRACT_SYNTAX_PATCH(&gkdi_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&gkdi_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "ENVELOPE_FLAG_TRANSPORTING_PUBLIC_KEY", PyLong_FromUnsignedLongLong((uint32_t)(ENVELOPE_FLAG_TRANSPORTING_PUBLIC_KEY)));
	PyModule_AddObject(m, "ENVELOPE_FLAG_KEY_MAY_ENCRYPT_NEW_DATA", PyLong_FromUnsignedLongLong((uint32_t)(ENVELOPE_FLAG_KEY_MAY_ENCRYPT_NEW_DATA)));
	Py_INCREF((PyObject *)(void *)&KeyEnvelope_Type);
	PyModule_AddObject(m, "KeyEnvelope", (PyObject *)(void *)&KeyEnvelope_Type);
	Py_INCREF((PyObject *)(void *)&GroupKeyEnvelope_Type);
	PyModule_AddObject(m, "GroupKeyEnvelope", (PyObject *)(void *)&GroupKeyEnvelope_Type);
	Py_INCREF((PyObject *)(void *)&KdfParameters_Type);
	PyModule_AddObject(m, "KdfParameters", (PyObject *)(void *)&KdfParameters_Type);
	Py_INCREF((PyObject *)(void *)&FfcDhParameters_Type);
	PyModule_AddObject(m, "FfcDhParameters", (PyObject *)(void *)&FfcDhParameters_Type);
	Py_INCREF((PyObject *)(void *)&GkdiDerivationCtx_Type);
	PyModule_AddObject(m, "GkdiDerivationCtx", (PyObject *)(void *)&GkdiDerivationCtx_Type);
	Py_INCREF((PyObject *)(void *)&gkdi_GetKey_Type);
	PyModule_AddObject(m, "GetKey", (PyObject *)(void *)&gkdi_GetKey_Type);
	Py_INCREF((PyObject *)(void *)&gkdi_InterfaceType);
	PyModule_AddObject(m, "gkdi", (PyObject *)(void *)&gkdi_InterfaceType);
	Py_INCREF((PyObject *)(void *)&gkdi_SyntaxType);
	PyModule_AddObject(m, "gkdi_abstract_syntax", (PyObject *)(void *)&gkdi_SyntaxType);
	Py_INCREF((PyObject *)(void *)&gkdi_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&gkdi_SyntaxType);
#ifdef PY_MOD_GKDI_PATCH
	PY_MOD_GKDI_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
