
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_echo.h"
#include "bin/default/librpc/gen_ndr/ndr_echo_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject echo_info1_Type;
static PyTypeObject echo_info2_Type;
static PyTypeObject echo_info3_Type;
static PyTypeObject echo_info4_Type;
static PyTypeObject echo_info5_Type;
static PyTypeObject echo_info6_Type;
static PyTypeObject echo_info7_Type;
static PyTypeObject echo_Info_Type;
static PyTypeObject echo_Enum2_Type;
static PyTypeObject echo_Enum3_Type;
static PyTypeObject echo_Surrounding_Type;
static PyTypeObject rpcecho_InterfaceType;
static PyTypeObject echo_AddOne_Type;
static PyTypeObject echo_EchoData_Type;
static PyTypeObject echo_SinkData_Type;
static PyTypeObject echo_SourceData_Type;
static PyTypeObject echo_TestCall_Type;
static PyTypeObject echo_TestCall2_Type;
static PyTypeObject echo_TestSleep_Type;
static PyTypeObject echo_TestEnum_Type;
static PyTypeObject echo_TestSurrounding_Type;
static PyTypeObject echo_TestDoublePointer_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *ndr_pointer_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_echo_info1_get_v(PyObject *obj, void *closure)
{
	struct echo_info1 *object = pytalloc_get_ptr(obj);
	PyObject *py_v;
	py_v = PyLong_FromLong((uint16_t)(object->v));
	return py_v;
}

static int py_echo_info1_set_v(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_info1_getsetters[] = {
	{
		.name = discard_const_p(char, "v"),
		.get = py_echo_info1_get_v,
		.set = py_echo_info1_set_v,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_echo_info1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_info1, type);
}

static PyObject *py_echo_info1_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct echo_info1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_echo_info1);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_echo_info1_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct echo_info1 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_echo_info1);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_echo_info1);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_echo_info1_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct echo_info1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_echo_info1, "echo_info1", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_echo_info1_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_echo_info1_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_info1_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_echo_info1_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_info1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.info1",
	.tp_getset = py_echo_info1_getsetters,
	.tp_methods = py_echo_info1_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_info1_new,
};


static PyObject *py_echo_info2_get_v(PyObject *obj, void *closure)
{
	struct echo_info2 *object = pytalloc_get_ptr(obj);
	PyObject *py_v;
	py_v = PyLong_FromLong((uint16_t)(object->v));
	return py_v;
}

static int py_echo_info2_set_v(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_info2_getsetters[] = {
	{
		.name = discard_const_p(char, "v"),
		.get = py_echo_info2_get_v,
		.set = py_echo_info2_set_v,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_echo_info2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_info2, type);
}


static PyTypeObject echo_info2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.info2",
	.tp_getset = py_echo_info2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_info2_new,
};


static PyObject *py_echo_info3_get_v(PyObject *obj, void *closure)
{
	struct echo_info3 *object = pytalloc_get_ptr(obj);
	PyObject *py_v;
	py_v = PyLong_FromUnsignedLongLong((uint32_t)(object->v));
	return py_v;
}

static int py_echo_info3_set_v(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_info3_getsetters[] = {
	{
		.name = discard_const_p(char, "v"),
		.get = py_echo_info3_get_v,
		.set = py_echo_info3_set_v,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_echo_info3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_info3, type);
}


static PyTypeObject echo_info3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.info3",
	.tp_getset = py_echo_info3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_info3_new,
};


static PyObject *py_echo_info4_get_v(PyObject *obj, void *closure)
{
	struct echo_info4 *object = pytalloc_get_ptr(obj);
	PyObject *py_v;
	py_v = PyLong_FromUnsignedLongLong(object->v);
	return py_v;
}

static int py_echo_info4_set_v(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_info4_getsetters[] = {
	{
		.name = discard_const_p(char, "v"),
		.get = py_echo_info4_get_v,
		.set = py_echo_info4_set_v,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_echo_info4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_info4, type);
}


static PyTypeObject echo_info4_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.info4",
	.tp_getset = py_echo_info4_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_info4_new,
};


static PyObject *py_echo_info5_get_v1(PyObject *obj, void *closure)
{
	struct echo_info5 *object = pytalloc_get_ptr(obj);
	PyObject *py_v1;
	py_v1 = PyLong_FromLong((uint16_t)(object->v1));
	return py_v1;
}

static int py_echo_info5_set_v1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_info5_get_v2(PyObject *obj, void *closure)
{
	struct echo_info5 *object = pytalloc_get_ptr(obj);
	PyObject *py_v2;
	py_v2 = PyLong_FromUnsignedLongLong(object->v2);
	return py_v2;
}

static int py_echo_info5_set_v2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_info5_getsetters[] = {
	{
		.name = discard_const_p(char, "v1"),
		.get = py_echo_info5_get_v1,
		.set = py_echo_info5_set_v1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "v2"),
		.get = py_echo_info5_get_v2,
		.set = py_echo_info5_set_v2,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_echo_info5_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_info5, type);
}


static PyTypeObject echo_info5_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.info5",
	.tp_getset = py_echo_info5_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_info5_new,
};


static PyObject *py_echo_info6_get_v1(PyObject *obj, void *closure)
{
	struct echo_info6 *object = pytalloc_get_ptr(obj);
	PyObject *py_v1;
	py_v1 = PyLong_FromLong((uint16_t)(object->v1));
	return py_v1;
}

static int py_echo_info6_set_v1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_info6_get_info1(PyObject *obj, void *closure)
{
	struct echo_info6 *object = pytalloc_get_ptr(obj);
	PyObject *py_info1;
	py_info1 = pytalloc_reference_ex(&echo_info1_Type, pytalloc_get_mem_ctx(obj), &object->info1);
	return py_info1;
}

static int py_echo_info6_set_info1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info1");
		return -1;
	}
	PY_CHECK_TYPE(&echo_info1_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info1 = *(struct echo_info1 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_echo_info6_getsetters[] = {
	{
		.name = discard_const_p(char, "v1"),
		.get = py_echo_info6_get_v1,
		.set = py_echo_info6_set_v1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "info1"),
		.get = py_echo_info6_get_info1,
		.set = py_echo_info6_set_info1,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_info1")
	},
	{ .name = NULL }
};

static PyObject *py_echo_info6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_info6, type);
}


static PyTypeObject echo_info6_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.info6",
	.tp_getset = py_echo_info6_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_info6_new,
};


static PyObject *py_echo_info7_get_v1(PyObject *obj, void *closure)
{
	struct echo_info7 *object = pytalloc_get_ptr(obj);
	PyObject *py_v1;
	py_v1 = PyLong_FromLong((uint16_t)(object->v1));
	return py_v1;
}

static int py_echo_info7_set_v1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info7 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->v1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->v1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->v1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_info7_get_info4(PyObject *obj, void *closure)
{
	struct echo_info7 *object = pytalloc_get_ptr(obj);
	PyObject *py_info4;
	py_info4 = pytalloc_reference_ex(&echo_info4_Type, pytalloc_get_mem_ctx(obj), &object->info4);
	return py_info4;
}

static int py_echo_info7_set_info4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_info7 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info4");
		return -1;
	}
	PY_CHECK_TYPE(&echo_info4_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info4 = *(struct echo_info4 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_echo_info7_getsetters[] = {
	{
		.name = discard_const_p(char, "v1"),
		.get = py_echo_info7_get_v1,
		.set = py_echo_info7_set_v1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "info4"),
		.get = py_echo_info7_get_info4,
		.set = py_echo_info7_set_info4,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_info4")
	},
	{ .name = NULL }
};

static PyObject *py_echo_info7_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_info7, type);
}


static PyTypeObject echo_info7_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.info7",
	.tp_getset = py_echo_info7_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_info7_new,
};

static PyObject *py_import_echo_Info(TALLOC_CTX *mem_ctx, int level, union echo_Info *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&echo_info1_Type, mem_ctx, &in->info1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&echo_info2_Type, mem_ctx, &in->info2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&echo_info3_Type, mem_ctx, &in->info3);
			return ret;

		case 4:
			ret = pytalloc_reference_ex(&echo_info4_Type, mem_ctx, &in->info4);
			return ret;

		case 5:
			ret = pytalloc_reference_ex(&echo_info5_Type, mem_ctx, &in->info5);
			return ret;

		case 6:
			ret = pytalloc_reference_ex(&echo_info6_Type, mem_ctx, &in->info6);
			return ret;

		case 7:
			ret = pytalloc_reference_ex(&echo_info7_Type, mem_ctx, &in->info7);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union echo_Info *py_export_echo_Info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union echo_Info *ret = talloc_zero(mem_ctx, union echo_Info);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_info1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct echo_info1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_info2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info2 = *(struct echo_info2 *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_info3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info3 = *(struct echo_info3 *)pytalloc_get_ptr(in);
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info4");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_info4_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info4 = *(struct echo_info4 *)pytalloc_get_ptr(in);
			break;

		case 5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info5");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_info5_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info5 = *(struct echo_info5 *)pytalloc_get_ptr(in);
			break;

		case 6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info6");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_info6_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info6 = *(struct echo_info6 *)pytalloc_get_ptr(in);
			break;

		case 7:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info7");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_info7_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info7 = *(struct echo_info7 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_echo_Info_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union echo_Info *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union echo_Info *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union echo_Info!");
		return NULL;
	}

	return py_import_echo_Info(mem_ctx, level, in);
}

static PyObject *py_echo_Info_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union echo_Info *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_echo_Info(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_echo_Info_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_Info_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_Info_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_echo_Info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject echo_Info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.Info",
	.tp_getset = NULL,
	.tp_methods = py_echo_Info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_Info_new,
};


static PyObject *py_echo_Enum2_get_e1(PyObject *obj, void *closure)
{
	struct echo_Enum2 *object = pytalloc_get_ptr(obj);
	PyObject *py_e1;
	py_e1 = PyLong_FromLong((uint16_t)(object->e1));
	return py_e1;
}

static int py_echo_Enum2_set_e1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_Enum2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->e1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->e1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->e1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_Enum2_get_e2(PyObject *obj, void *closure)
{
	struct echo_Enum2 *object = pytalloc_get_ptr(obj);
	PyObject *py_e2;
	py_e2 = PyLong_FromUnsignedLongLong((uint32_t)(object->e2));
	return py_e2;
}

static int py_echo_Enum2_set_e2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_Enum2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->e2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->e2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->e2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_Enum2_getsetters[] = {
	{
		.name = discard_const_p(char, "e1"),
		.get = py_echo_Enum2_get_e1,
		.set = py_echo_Enum2_set_e1,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum1")
	},
	{
		.name = discard_const_p(char, "e2"),
		.get = py_echo_Enum2_get_e2,
		.set = py_echo_Enum2_set_e2,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum1_32")
	},
	{ .name = NULL }
};

static PyObject *py_echo_Enum2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_Enum2, type);
}


static PyTypeObject echo_Enum2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.Enum2",
	.tp_getset = py_echo_Enum2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_Enum2_new,
};

static PyObject *py_import_echo_Enum3(TALLOC_CTX *mem_ctx, int level, union echo_Enum3 *in)
{
	PyObject *ret;

	switch (level) {
		case ECHO_ENUM1:
			ret = PyLong_FromLong((uint16_t)(in->e1));
			return ret;

		case ECHO_ENUM2:
			ret = pytalloc_reference_ex(&echo_Enum2_Type, mem_ctx, &in->e2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union echo_Enum3 *py_export_echo_Enum3(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union echo_Enum3 *ret = talloc_zero(mem_ctx, union echo_Enum3);
	switch (level) {
		case ECHO_ENUM1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->e1");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->e1));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->e1 = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case ECHO_ENUM2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->e2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&echo_Enum2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->e2 = *(struct echo_Enum2 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_echo_Enum3_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union echo_Enum3 *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union echo_Enum3 *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union echo_Enum3!");
		return NULL;
	}

	return py_import_echo_Enum3(mem_ctx, level, in);
}

static PyObject *py_echo_Enum3_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union echo_Enum3 *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_echo_Enum3(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_echo_Enum3_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_Enum3_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_Enum3_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_echo_Enum3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject echo_Enum3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.Enum3",
	.tp_getset = NULL,
	.tp_methods = py_echo_Enum3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_Enum3_new,
};


static PyObject *py_echo_Surrounding_get_x(PyObject *obj, void *closure)
{
	struct echo_Surrounding *object = pytalloc_get_ptr(obj);
	PyObject *py_x;
	py_x = PyLong_FromUnsignedLongLong((uint32_t)(object->x));
	return py_x;
}

static int py_echo_Surrounding_set_x(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_Surrounding *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->x");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->x));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->x = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_Surrounding_get_surrounding(PyObject *obj, void *closure)
{
	struct echo_Surrounding *object = pytalloc_get_ptr(obj);
	PyObject *py_surrounding;
	py_surrounding = PyList_New(object->x);
	if (py_surrounding == NULL) {
		return NULL;
	}
	{
		int surrounding_cntr_0;
		for (surrounding_cntr_0 = 0; surrounding_cntr_0 < (object->x); surrounding_cntr_0++) {
			PyObject *py_surrounding_0;
			py_surrounding_0 = PyLong_FromLong((uint16_t)((object->surrounding)[surrounding_cntr_0]));
			PyList_SetItem(py_surrounding, surrounding_cntr_0, py_surrounding_0);
		}
	}
	return py_surrounding;
}

static int py_echo_Surrounding_set_surrounding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_Surrounding *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->surrounding");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int surrounding_cntr_0;
		object->surrounding = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->surrounding, PyList_GET_SIZE(value));
		if (!object->surrounding) { return -1; }
		talloc_set_name_const(object->surrounding, "ARRAY: object->surrounding");
		for (surrounding_cntr_0 = 0; surrounding_cntr_0 < PyList_GET_SIZE(value); surrounding_cntr_0++) {
			if (PyList_GET_ITEM(value, surrounding_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->surrounding)[surrounding_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->surrounding)[surrounding_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, surrounding_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, surrounding_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->surrounding)[surrounding_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_echo_Surrounding_getsetters[] = {
	{
		.name = discard_const_p(char, "x"),
		.get = py_echo_Surrounding_get_x,
		.set = py_echo_Surrounding_set_x,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "surrounding"),
		.get = py_echo_Surrounding_get_surrounding,
		.set = py_echo_Surrounding_set_surrounding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_echo_Surrounding_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct echo_Surrounding, type);
}


static PyTypeObject echo_Surrounding_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.Surrounding",
	.tp_getset = py_echo_Surrounding_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_Surrounding_new,
};



static PyObject *py_echo_AddOne_in_get_in_data(PyObject *obj, void *closure)
{
	struct echo_AddOne *object = pytalloc_get_ptr(obj);
	PyObject *py_in_data;
	py_in_data = PyLong_FromUnsignedLongLong((uint32_t)(object->in.in_data));
	return py_in_data;
}

static int py_echo_AddOne_in_set_in_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_AddOne *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.in_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.in_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.in_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_AddOne_out_get_out_data(PyObject *obj, void *closure)
{
	struct echo_AddOne *object = pytalloc_get_ptr(obj);
	PyObject *py_out_data;
	if (object->out.out_data == NULL) {
		Py_RETURN_NONE;
	}
	py_out_data = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.out_data));
	return py_out_data;
}

static int py_echo_AddOne_out_set_out_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_AddOne *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.out_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.out_data");
		return -1;
	}
	object->out.out_data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.out_data);
	if (object->out.out_data == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.out_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.out_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_AddOne_getsetters[] = {
	{
		.name = discard_const_p(char, "in_in_data"),
		.get = py_echo_AddOne_in_get_in_data,
		.set = py_echo_AddOne_in_set_in_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_out_data"),
		.get = py_echo_AddOne_out_get_out_data,
		.set = py_echo_AddOne_out_set_out_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_echo_AddOne_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_AddOne, type);
	struct echo_AddOne *_self = (struct echo_AddOne *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.out_data = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_echo_AddOne_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_echo_AddOne_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_AddOne *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_AddOne_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_AddOne_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_AddOne_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_AddOne_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_AddOne_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_AddOne_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_AddOne *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_AddOne_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_AddOne_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_AddOne_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_AddOne_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_AddOne_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_AddOne_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_AddOne *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_AddOne_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_AddOne_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_AddOne_ndr_print(py_obj, "echo_AddOne_in", NDR_IN);
}

static PyObject *py_echo_AddOne_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_AddOne_ndr_print(py_obj, "echo_AddOne_out", NDR_OUT);
}

static PyMethodDef py_echo_AddOne_methods[] = {
	{ "opnum", (PyCFunction)py_echo_AddOne_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.AddOne.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_AddOne_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_AddOne_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_AddOne_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_AddOne_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_AddOne_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_AddOne_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_AddOne_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.AddOne",
	.tp_getset = py_echo_AddOne_getsetters,
	.tp_methods = py_echo_AddOne_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_AddOne_new,
};

static bool pack_py_echo_AddOne_args_in(PyObject *args, PyObject *kwargs, struct echo_AddOne *r)
{
	PyObject *py_in_data;
	const char *kwnames[] = {
		"in_data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_AddOne", discard_const_p(char *, kwnames), &py_in_data)) {
		return false;
	}

	if (py_in_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.in_data");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.in_data));
		if (PyLong_Check(py_in_data)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_in_data);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.in_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_echo_AddOne_args_out(struct echo_AddOne *r)
{
	PyObject *result;
	PyObject *py_out_data;
	py_out_data = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.out_data));
	result = py_out_data;
	return result;
}


static PyObject *py_echo_EchoData_in_get_len(PyObject *obj, void *closure)
{
	struct echo_EchoData *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromUnsignedLongLong((uint32_t)(object->in.len));
	return py_len;
}

static int py_echo_EchoData_in_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_EchoData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_EchoData_in_get_in_data(PyObject *obj, void *closure)
{
	struct echo_EchoData *object = pytalloc_get_ptr(obj);
	PyObject *py_in_data;
	py_in_data = PyList_New(object->in.len);
	if (py_in_data == NULL) {
		return NULL;
	}
	{
		int in_data_cntr_0;
		for (in_data_cntr_0 = 0; in_data_cntr_0 < (object->in.len); in_data_cntr_0++) {
			PyObject *py_in_data_0;
			py_in_data_0 = PyLong_FromLong((uint16_t)((object->in.in_data)[in_data_cntr_0]));
			PyList_SetItem(py_in_data, in_data_cntr_0, py_in_data_0);
		}
	}
	return py_in_data;
}

static int py_echo_EchoData_in_set_in_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_EchoData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.in_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int in_data_cntr_0;
		object->in.in_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.in_data, PyList_GET_SIZE(value));
		if (!object->in.in_data) { return -1; }
		talloc_set_name_const(object->in.in_data, "ARRAY: object->in.in_data");
		for (in_data_cntr_0 = 0; in_data_cntr_0 < PyList_GET_SIZE(value); in_data_cntr_0++) {
			if (PyList_GET_ITEM(value, in_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.in_data)[in_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.in_data)[in_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, in_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, in_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.in_data)[in_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_echo_EchoData_out_get_out_data(PyObject *obj, void *closure)
{
	struct echo_EchoData *object = pytalloc_get_ptr(obj);
	PyObject *py_out_data;
	py_out_data = PyList_New(object->in.len);
	if (py_out_data == NULL) {
		return NULL;
	}
	{
		int out_data_cntr_0;
		for (out_data_cntr_0 = 0; out_data_cntr_0 < (object->in.len); out_data_cntr_0++) {
			PyObject *py_out_data_0;
			py_out_data_0 = PyLong_FromLong((uint16_t)((object->out.out_data)[out_data_cntr_0]));
			PyList_SetItem(py_out_data, out_data_cntr_0, py_out_data_0);
		}
	}
	return py_out_data;
}

static int py_echo_EchoData_out_set_out_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_EchoData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.out_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int out_data_cntr_0;
		object->out.out_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.out_data, PyList_GET_SIZE(value));
		if (!object->out.out_data) { return -1; }
		talloc_set_name_const(object->out.out_data, "ARRAY: object->out.out_data");
		for (out_data_cntr_0 = 0; out_data_cntr_0 < PyList_GET_SIZE(value); out_data_cntr_0++) {
			if (PyList_GET_ITEM(value, out_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->out.out_data)[out_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.out_data)[out_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, out_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, out_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.out_data)[out_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_echo_EchoData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_len"),
		.get = py_echo_EchoData_in_get_len,
		.set = py_echo_EchoData_in_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_in_data"),
		.get = py_echo_EchoData_in_get_in_data,
		.set = py_echo_EchoData_in_set_in_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_out_data"),
		.get = py_echo_EchoData_out_get_out_data,
		.set = py_echo_EchoData_out_set_out_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_echo_EchoData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_EchoData, type);
	return self;
}

static PyObject *py_echo_EchoData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_echo_EchoData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_EchoData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_EchoData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_EchoData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_EchoData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_EchoData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_EchoData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_EchoData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_EchoData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_EchoData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_EchoData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_EchoData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_EchoData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_EchoData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_EchoData_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_EchoData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_EchoData_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[1];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_EchoData_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_EchoData_ndr_print(py_obj, "echo_EchoData_in", NDR_IN);
}

static PyObject *py_echo_EchoData_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_EchoData_ndr_print(py_obj, "echo_EchoData_out", NDR_OUT);
}

static PyMethodDef py_echo_EchoData_methods[] = {
	{ "opnum", (PyCFunction)py_echo_EchoData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.EchoData.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_EchoData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_EchoData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_EchoData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_EchoData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_EchoData_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_EchoData_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_EchoData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.EchoData",
	.tp_getset = py_echo_EchoData_getsetters,
	.tp_methods = py_echo_EchoData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_EchoData_new,
};

static bool pack_py_echo_EchoData_args_in(PyObject *args, PyObject *kwargs, struct echo_EchoData *r)
{
	PyObject *py_in_data;
	const char *kwnames[] = {
		"in_data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_EchoData", discard_const_p(char *, kwnames), &py_in_data)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_in_data, return false;);
	r->in.len = PyList_GET_SIZE(py_in_data);
	if (py_in_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.in_data");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_in_data, return false;);
	{
		int in_data_cntr_0;
		r->in.in_data = talloc_array_ptrtype(r, r->in.in_data, PyList_GET_SIZE(py_in_data));
		if (!r->in.in_data) { return false; }
		talloc_set_name_const(r->in.in_data, "ARRAY: r->in.in_data");
		for (in_data_cntr_0 = 0; in_data_cntr_0 < PyList_GET_SIZE(py_in_data); in_data_cntr_0++) {
			if (PyList_GET_ITEM(py_in_data, in_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.in_data)[in_data_cntr_0]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.in_data)[in_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(py_in_data, in_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_in_data, in_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.in_data)[in_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	return true;
}

static PyObject *unpack_py_echo_EchoData_args_out(struct echo_EchoData *r)
{
	PyObject *result;
	PyObject *py_out_data;
	py_out_data = PyList_New(r->in.len);
	if (py_out_data == NULL) {
		return NULL;
	}
	{
		int out_data_cntr_0;
		for (out_data_cntr_0 = 0; out_data_cntr_0 < (r->in.len); out_data_cntr_0++) {
			PyObject *py_out_data_0;
			py_out_data_0 = PyLong_FromLong((uint16_t)((r->out.out_data)[out_data_cntr_0]));
			PyList_SetItem(py_out_data, out_data_cntr_0, py_out_data_0);
		}
	}
	result = py_out_data;
	return result;
}


static PyObject *py_echo_SinkData_in_get_len(PyObject *obj, void *closure)
{
	struct echo_SinkData *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromUnsignedLongLong((uint32_t)(object->in.len));
	return py_len;
}

static int py_echo_SinkData_in_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_SinkData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_SinkData_in_get_data(PyObject *obj, void *closure)
{
	struct echo_SinkData *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->in.len);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->in.len); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->in.data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_echo_SinkData_in_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_SinkData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->in.data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data, PyList_GET_SIZE(value));
		if (!object->in.data) { return -1; }
		talloc_set_name_const(object->in.data, "ARRAY: object->in.data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->in.data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_echo_SinkData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_len"),
		.get = py_echo_SinkData_in_get_len,
		.set = py_echo_SinkData_in_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_data"),
		.get = py_echo_SinkData_in_get_data,
		.set = py_echo_SinkData_in_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_echo_SinkData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_SinkData, type);
	return self;
}

static PyObject *py_echo_SinkData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_echo_SinkData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_SinkData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_SinkData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_SinkData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_SinkData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_SinkData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_SinkData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_SinkData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_SinkData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_SinkData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_SinkData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_SinkData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_SinkData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_SinkData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_SinkData_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_SinkData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_SinkData_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[2];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_SinkData_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_SinkData_ndr_print(py_obj, "echo_SinkData_in", NDR_IN);
}

static PyObject *py_echo_SinkData_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_SinkData_ndr_print(py_obj, "echo_SinkData_out", NDR_OUT);
}

static PyMethodDef py_echo_SinkData_methods[] = {
	{ "opnum", (PyCFunction)py_echo_SinkData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.SinkData.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SinkData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SinkData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SinkData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SinkData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_SinkData_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_SinkData_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_SinkData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.SinkData",
	.tp_getset = py_echo_SinkData_getsetters,
	.tp_methods = py_echo_SinkData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_SinkData_new,
};

static bool pack_py_echo_SinkData_args_in(PyObject *args, PyObject *kwargs, struct echo_SinkData *r)
{
	PyObject *py_data;
	const char *kwnames[] = {
		"data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_SinkData", discard_const_p(char *, kwnames), &py_data)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.len = PyList_GET_SIZE(py_data);
	if (py_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.data");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	{
		int data_cntr_0;
		r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
		if (!r->in.data) { return false; }
		talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(py_data); data_cntr_0++) {
			if (PyList_GET_ITEM(py_data, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (r->in.data)[data_cntr_0]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(py_data, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_data, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	return true;
}

static PyObject *unpack_py_echo_SinkData_args_out(struct echo_SinkData *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	return result;
}


static PyObject *py_echo_SourceData_in_get_len(PyObject *obj, void *closure)
{
	struct echo_SourceData *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromUnsignedLongLong((uint32_t)(object->in.len));
	return py_len;
}

static int py_echo_SourceData_in_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_SourceData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_SourceData_out_get_data(PyObject *obj, void *closure)
{
	struct echo_SourceData *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->in.len);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->in.len); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->out.data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_echo_SourceData_out_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_SourceData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->out.data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.data, PyList_GET_SIZE(value));
		if (!object->out.data) { return -1; }
		talloc_set_name_const(object->out.data, "ARRAY: object->out.data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->out.data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_echo_SourceData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_len"),
		.get = py_echo_SourceData_in_get_len,
		.set = py_echo_SourceData_in_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_data"),
		.get = py_echo_SourceData_out_get_data,
		.set = py_echo_SourceData_out_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_echo_SourceData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_SourceData, type);
	return self;
}

static PyObject *py_echo_SourceData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_echo_SourceData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_SourceData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_SourceData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_SourceData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_SourceData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_SourceData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_SourceData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_SourceData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_SourceData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_SourceData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_SourceData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_SourceData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_SourceData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_SourceData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_SourceData_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_SourceData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_SourceData_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[3];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_SourceData_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_SourceData_ndr_print(py_obj, "echo_SourceData_in", NDR_IN);
}

static PyObject *py_echo_SourceData_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_SourceData_ndr_print(py_obj, "echo_SourceData_out", NDR_OUT);
}

static PyMethodDef py_echo_SourceData_methods[] = {
	{ "opnum", (PyCFunction)py_echo_SourceData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.SourceData.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SourceData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SourceData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SourceData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_SourceData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_SourceData_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_SourceData_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_SourceData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.SourceData",
	.tp_getset = py_echo_SourceData_getsetters,
	.tp_methods = py_echo_SourceData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_SourceData_new,
};

static bool pack_py_echo_SourceData_args_in(PyObject *args, PyObject *kwargs, struct echo_SourceData *r)
{
	PyObject *py_len;
	const char *kwnames[] = {
		"len", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_SourceData", discard_const_p(char *, kwnames), &py_len)) {
		return false;
	}

	if (py_len == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.len");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.len));
		if (PyLong_Check(py_len)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_len);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_echo_SourceData_args_out(struct echo_SourceData *r)
{
	PyObject *result;
	PyObject *py_data;
	py_data = PyList_New(r->in.len);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (r->in.len); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((r->out.data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	result = py_data;
	return result;
}


static PyObject *py_echo_TestCall_in_get_s1(PyObject *obj, void *closure)
{
	struct echo_TestCall *object = pytalloc_get_ptr(obj);
	PyObject *py_s1;
	if (object->in.s1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.s1 == NULL) {
		py_s1 = Py_None;
		Py_INCREF(py_s1);
	} else {
		py_s1 = PyUnicode_Decode(object->in.s1, strlen(object->in.s1), "utf-8", "ignore");
	}
	return py_s1;
}

static int py_echo_TestCall_in_set_s1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestCall *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.s1");
		return -1;
	}
	object->in.s1 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.s1);
	if (object->in.s1 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.s1 = talloc_str;
	}
	return 0;
}

static PyObject *py_echo_TestCall_out_get_s2(PyObject *obj, void *closure)
{
	struct echo_TestCall *object = pytalloc_get_ptr(obj);
	PyObject *py_s2;
	if (object->out.s2 == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.s2 == NULL) {
		py_s2 = Py_None;
		Py_INCREF(py_s2);
	} else {
		if (*object->out.s2 == NULL) {
			py_s2 = Py_None;
			Py_INCREF(py_s2);
		} else {
			py_s2 = PyUnicode_Decode(*object->out.s2, strlen(*object->out.s2), "utf-8", "ignore");
		}
	}
	return py_s2;
}

static int py_echo_TestCall_out_set_s2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestCall *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.s2));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.s2");
		return -1;
	}
	object->out.s2 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.s2);
	if (object->out.s2 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.s2 = NULL;
	} else {
		*object->out.s2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.s2 = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_TestCall_getsetters[] = {
	{
		.name = discard_const_p(char, "in_s1"),
		.get = py_echo_TestCall_in_get_s1,
		.set = py_echo_TestCall_in_set_s1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_s2"),
		.get = py_echo_TestCall_out_get_s2,
		.set = py_echo_TestCall_out_set_s2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_echo_TestCall_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_TestCall, type);
	return self;
}

static PyObject *py_echo_TestCall_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_echo_TestCall_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestCall *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestCall_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_TestCall_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestCall_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_TestCall_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestCall_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_TestCall_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestCall *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestCall_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_TestCall_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestCall_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestCall_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestCall_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestCall_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestCall *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestCall_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[4];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_TestCall_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestCall_ndr_print(py_obj, "echo_TestCall_in", NDR_IN);
}

static PyObject *py_echo_TestCall_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestCall_ndr_print(py_obj, "echo_TestCall_out", NDR_OUT);
}

static PyMethodDef py_echo_TestCall_methods[] = {
	{ "opnum", (PyCFunction)py_echo_TestCall_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.TestCall.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_TestCall_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_TestCall_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_TestCall_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.TestCall",
	.tp_getset = py_echo_TestCall_getsetters,
	.tp_methods = py_echo_TestCall_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_TestCall_new,
};

static bool pack_py_echo_TestCall_args_in(PyObject *args, PyObject *kwargs, struct echo_TestCall *r)
{
	PyObject *py_s1;
	const char *kwnames[] = {
		"s1", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_TestCall", discard_const_p(char *, kwnames), &py_s1)) {
		return false;
	}

	if (py_s1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.s1");
		return false;
	}
	r->in.s1 = talloc_ptrtype(r, r->in.s1);
	if (r->in.s1 == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_s1)) {
			unicode = PyUnicode_AsEncodedString(py_s1, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_s1)) {
			test_str = PyBytes_AS_STRING(py_s1);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_s1)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.s1 = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_echo_TestCall_args_out(struct echo_TestCall *r)
{
	PyObject *result;
	PyObject *py_s2;
	if (*r->out.s2 == NULL) {
		py_s2 = Py_None;
		Py_INCREF(py_s2);
	} else {
		if (*r->out.s2 == NULL) {
			py_s2 = Py_None;
			Py_INCREF(py_s2);
		} else {
			py_s2 = PyUnicode_Decode(*r->out.s2, strlen(*r->out.s2), "utf-8", "ignore");
		}
	}
	result = py_s2;
	return result;
}


static PyObject *py_echo_TestCall2_in_get_level(PyObject *obj, void *closure)
{
	struct echo_TestCall2 *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_echo_TestCall2_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestCall2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_TestCall2_out_get_info(PyObject *obj, void *closure)
{
	struct echo_TestCall2 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&echo_Info_Type, object->out.info, object->in.level, object->out.info, "union echo_Info");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_echo_TestCall2_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestCall2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union echo_Info *info_switch_1;
		info_switch_1 = (union echo_Info *)pyrpc_export_union(&echo_Info_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union echo_Info");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->out.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_echo_TestCall2_get_result(PyObject *obj, void *closure)
{
	struct echo_TestCall2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_echo_TestCall2_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestCall2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_echo_TestCall2_getsetters[] = {
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_echo_TestCall2_in_get_level,
		.set = py_echo_TestCall2_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_echo_TestCall2_out_get_info,
		.set = py_echo_TestCall2_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Info")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_echo_TestCall2_get_result,
		.set = py_echo_TestCall2_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_echo_TestCall2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_TestCall2, type);
	struct echo_TestCall2 *_self = (struct echo_TestCall2 *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.info = talloc_zero(mem_ctx, union echo_Info);
	return self;
}

static PyObject *py_echo_TestCall2_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_echo_TestCall2_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestCall2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestCall2_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_TestCall2_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestCall2_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_TestCall2_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestCall2_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_TestCall2_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestCall2 *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestCall2_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_TestCall2_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestCall2_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestCall2_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestCall2_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestCall2_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestCall2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestCall2_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[5];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_TestCall2_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestCall2_ndr_print(py_obj, "echo_TestCall2_in", NDR_IN);
}

static PyObject *py_echo_TestCall2_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestCall2_ndr_print(py_obj, "echo_TestCall2_out", NDR_OUT);
}

static PyMethodDef py_echo_TestCall2_methods[] = {
	{ "opnum", (PyCFunction)py_echo_TestCall2_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.TestCall2.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall2_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall2_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall2_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestCall2_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_TestCall2_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_TestCall2_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_TestCall2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.TestCall2",
	.tp_getset = py_echo_TestCall2_getsetters,
	.tp_methods = py_echo_TestCall2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_TestCall2_new,
};

static bool pack_py_echo_TestCall2_args_in(PyObject *args, PyObject *kwargs, struct echo_TestCall2 *r)
{
	PyObject *py_level;
	const char *kwnames[] = {
		"level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_TestCall2", discard_const_p(char *, kwnames), &py_level)) {
		return false;
	}

	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_echo_TestCall2_args_out(struct echo_TestCall2 *r)
{
	PyObject *result;
	PyObject *py_info;
	py_info = pyrpc_import_union(&echo_Info_Type, r->out.info, r->in.level, r->out.info, "union echo_Info");
	if (py_info == NULL) {
		return NULL;
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_echo_TestSleep_in_get_seconds(PyObject *obj, void *closure)
{
	struct echo_TestSleep *object = pytalloc_get_ptr(obj);
	PyObject *py_seconds;
	py_seconds = PyLong_FromUnsignedLongLong((uint32_t)(object->in.seconds));
	return py_seconds;
}

static int py_echo_TestSleep_in_set_seconds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestSleep *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.seconds");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.seconds));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.seconds = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_TestSleep_get_result(PyObject *obj, void *closure)
{
	struct echo_TestSleep *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_echo_TestSleep_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestSleep *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_TestSleep_getsetters[] = {
	{
		.name = discard_const_p(char, "in_seconds"),
		.get = py_echo_TestSleep_in_get_seconds,
		.set = py_echo_TestSleep_in_set_seconds,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_echo_TestSleep_get_result,
		.set = py_echo_TestSleep_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_echo_TestSleep_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_TestSleep, type);
	return self;
}

static PyObject *py_echo_TestSleep_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_echo_TestSleep_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestSleep *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestSleep_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_TestSleep_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestSleep_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_TestSleep_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestSleep_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_TestSleep_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestSleep *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestSleep_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_TestSleep_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestSleep_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestSleep_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestSleep_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestSleep_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestSleep *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestSleep_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[6];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_TestSleep_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestSleep_ndr_print(py_obj, "echo_TestSleep_in", NDR_IN);
}

static PyObject *py_echo_TestSleep_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestSleep_ndr_print(py_obj, "echo_TestSleep_out", NDR_OUT);
}

static PyMethodDef py_echo_TestSleep_methods[] = {
	{ "opnum", (PyCFunction)py_echo_TestSleep_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.TestSleep.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSleep_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSleep_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSleep_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSleep_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_TestSleep_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_TestSleep_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_TestSleep_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.TestSleep",
	.tp_getset = py_echo_TestSleep_getsetters,
	.tp_methods = py_echo_TestSleep_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_TestSleep_new,
};

static bool pack_py_echo_TestSleep_args_in(PyObject *args, PyObject *kwargs, struct echo_TestSleep *r)
{
	PyObject *py_seconds;
	const char *kwnames[] = {
		"seconds", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_TestSleep", discard_const_p(char *, kwnames), &py_seconds)) {
		return false;
	}

	if (py_seconds == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.seconds");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.seconds));
		if (PyLong_Check(py_seconds)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_seconds);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.seconds = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_echo_TestSleep_args_out(struct echo_TestSleep *r)
{
	PyObject *result;
	result = PyLong_FromUnsignedLongLong((uint32_t)(r->out.result));
	return result;
}


static PyObject *py_echo_TestEnum_in_get_foo1(PyObject *obj, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_foo1;
	if (object->in.foo1 == NULL) {
		Py_RETURN_NONE;
	}
	py_foo1 = PyLong_FromLong((uint16_t)(*object->in.foo1));
	return py_foo1;
}

static int py_echo_TestEnum_in_set_foo1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.foo1));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.foo1");
		return -1;
	}
	object->in.foo1 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.foo1);
	if (object->in.foo1 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.foo1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.foo1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_TestEnum_out_get_foo1(PyObject *obj, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_foo1;
	if (object->out.foo1 == NULL) {
		Py_RETURN_NONE;
	}
	py_foo1 = PyLong_FromLong((uint16_t)(*object->out.foo1));
	return py_foo1;
}

static int py_echo_TestEnum_out_set_foo1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.foo1));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.foo1");
		return -1;
	}
	object->out.foo1 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.foo1);
	if (object->out.foo1 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.foo1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.foo1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_echo_TestEnum_in_get_foo2(PyObject *obj, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_foo2;
	if (object->in.foo2 == NULL) {
		Py_RETURN_NONE;
	}
	py_foo2 = pytalloc_reference_ex(&echo_Enum2_Type, object->in.foo2, object->in.foo2);
	return py_foo2;
}

static int py_echo_TestEnum_in_set_foo2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.foo2));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.foo2");
		return -1;
	}
	object->in.foo2 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.foo2);
	if (object->in.foo2 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&echo_Enum2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.foo2 = (struct echo_Enum2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_echo_TestEnum_out_get_foo2(PyObject *obj, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_foo2;
	if (object->out.foo2 == NULL) {
		Py_RETURN_NONE;
	}
	py_foo2 = pytalloc_reference_ex(&echo_Enum2_Type, object->out.foo2, object->out.foo2);
	return py_foo2;
}

static int py_echo_TestEnum_out_set_foo2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.foo2));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.foo2");
		return -1;
	}
	object->out.foo2 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.foo2);
	if (object->out.foo2 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&echo_Enum2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.foo2 = (struct echo_Enum2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_echo_TestEnum_in_get_foo3(PyObject *obj, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_foo3;
	if (object->in.foo3 == NULL) {
		Py_RETURN_NONE;
	}
	py_foo3 = pyrpc_import_union(&echo_Enum3_Type, object->in.foo3, *object->in.foo1, object->in.foo3, "union echo_Enum3");
	if (py_foo3 == NULL) {
		return NULL;
	}
	return py_foo3;
}

static int py_echo_TestEnum_in_set_foo3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.foo3));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.foo3");
		return -1;
	}
	object->in.foo3 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.foo3);
	if (object->in.foo3 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union echo_Enum3 *foo3_switch_1;
		foo3_switch_1 = (union echo_Enum3 *)pyrpc_export_union(&echo_Enum3_Type, pytalloc_get_mem_ctx(py_obj), *object->in.foo1, value, "union echo_Enum3");
		if (foo3_switch_1 == NULL) {
			return -1;
		}
		object->in.foo3 = foo3_switch_1;
	}
	return 0;
}

static PyObject *py_echo_TestEnum_out_get_foo3(PyObject *obj, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_foo3;
	if (object->out.foo3 == NULL) {
		Py_RETURN_NONE;
	}
	py_foo3 = pyrpc_import_union(&echo_Enum3_Type, object->out.foo3, *object->out.foo1, object->out.foo3, "union echo_Enum3");
	if (py_foo3 == NULL) {
		return NULL;
	}
	return py_foo3;
}

static int py_echo_TestEnum_out_set_foo3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.foo3));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.foo3");
		return -1;
	}
	object->out.foo3 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.foo3);
	if (object->out.foo3 == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union echo_Enum3 *foo3_switch_1;
		foo3_switch_1 = (union echo_Enum3 *)pyrpc_export_union(&echo_Enum3_Type, pytalloc_get_mem_ctx(py_obj), *object->out.foo1, value, "union echo_Enum3");
		if (foo3_switch_1 == NULL) {
			return -1;
		}
		object->out.foo3 = foo3_switch_1;
	}
	return 0;
}

static PyGetSetDef py_echo_TestEnum_getsetters[] = {
	{
		.name = discard_const_p(char, "in_foo1"),
		.get = py_echo_TestEnum_in_get_foo1,
		.set = py_echo_TestEnum_in_set_foo1,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum1")
	},
	{
		.name = discard_const_p(char, "out_foo1"),
		.get = py_echo_TestEnum_out_get_foo1,
		.set = py_echo_TestEnum_out_set_foo1,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum1")
	},
	{
		.name = discard_const_p(char, "in_foo2"),
		.get = py_echo_TestEnum_in_get_foo2,
		.set = py_echo_TestEnum_in_set_foo2,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum2")
	},
	{
		.name = discard_const_p(char, "out_foo2"),
		.get = py_echo_TestEnum_out_get_foo2,
		.set = py_echo_TestEnum_out_set_foo2,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum2")
	},
	{
		.name = discard_const_p(char, "in_foo3"),
		.get = py_echo_TestEnum_in_get_foo3,
		.set = py_echo_TestEnum_in_set_foo3,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum3")
	},
	{
		.name = discard_const_p(char, "out_foo3"),
		.get = py_echo_TestEnum_out_get_foo3,
		.set = py_echo_TestEnum_out_set_foo3,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Enum3")
	},
	{ .name = NULL }
};

static PyObject *py_echo_TestEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_TestEnum, type);
	struct echo_TestEnum *_self = (struct echo_TestEnum *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.foo1 = talloc_zero(mem_ctx, enum echo_Enum1);
	_self->out.foo1 = talloc_zero(mem_ctx, enum echo_Enum1);
	_self->in.foo2 = talloc_zero(mem_ctx, struct echo_Enum2);
	_self->out.foo2 = talloc_zero(mem_ctx, struct echo_Enum2);
	_self->in.foo3 = talloc_zero(mem_ctx, union echo_Enum3);
	_self->out.foo3 = talloc_zero(mem_ctx, union echo_Enum3);
	return self;
}

static PyObject *py_echo_TestEnum_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_echo_TestEnum_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestEnum_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_TestEnum_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestEnum_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_TestEnum_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestEnum_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_TestEnum_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestEnum_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_TestEnum_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestEnum_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestEnum_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestEnum_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestEnum_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestEnum_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[7];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_TestEnum_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestEnum_ndr_print(py_obj, "echo_TestEnum_in", NDR_IN);
}

static PyObject *py_echo_TestEnum_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestEnum_ndr_print(py_obj, "echo_TestEnum_out", NDR_OUT);
}

static PyMethodDef py_echo_TestEnum_methods[] = {
	{ "opnum", (PyCFunction)py_echo_TestEnum_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.TestEnum.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestEnum_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestEnum_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestEnum_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestEnum_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_TestEnum_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_TestEnum_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_TestEnum_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.TestEnum",
	.tp_getset = py_echo_TestEnum_getsetters,
	.tp_methods = py_echo_TestEnum_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_TestEnum_new,
};

static bool pack_py_echo_TestEnum_args_in(PyObject *args, PyObject *kwargs, struct echo_TestEnum *r)
{
	PyObject *py_foo1;
	PyObject *py_foo2;
	PyObject *py_foo3;
	const char *kwnames[] = {
		"foo1", "foo2", "foo3", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:echo_TestEnum", discard_const_p(char *, kwnames), &py_foo1, &py_foo2, &py_foo3)) {
		return false;
	}

	if (py_foo1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.foo1");
		return false;
	}
	r->in.foo1 = talloc_ptrtype(r, r->in.foo1);
	if (r->in.foo1 == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.foo1));
		if (PyLong_Check(py_foo1)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_foo1);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.foo1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_foo2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.foo2");
		return false;
	}
	r->in.foo2 = talloc_ptrtype(r, r->in.foo2);
	if (r->in.foo2 == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&echo_Enum2_Type, py_foo2, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_foo2)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.foo2 = (struct echo_Enum2 *)pytalloc_get_ptr(py_foo2);
	if (py_foo3 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.foo3");
		return false;
	}
	r->in.foo3 = talloc_ptrtype(r, r->in.foo3);
	if (r->in.foo3 == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union echo_Enum3 *foo3_switch_1;
		foo3_switch_1 = (union echo_Enum3 *)pyrpc_export_union(&echo_Enum3_Type, r, *r->in.foo1, py_foo3, "union echo_Enum3");
		if (foo3_switch_1 == NULL) {
			return false;
		}
		r->in.foo3 = foo3_switch_1;
	}
	return true;
}

static PyObject *unpack_py_echo_TestEnum_args_out(struct echo_TestEnum *r)
{
	PyObject *result;
	PyObject *py_foo1;
	PyObject *py_foo2;
	PyObject *py_foo3;
	result = PyTuple_New(3);
	py_foo1 = PyLong_FromLong((uint16_t)(*r->out.foo1));
	PyTuple_SetItem(result, 0, py_foo1);
	py_foo2 = pytalloc_reference_ex(&echo_Enum2_Type, r->out.foo2, r->out.foo2);
	PyTuple_SetItem(result, 1, py_foo2);
	py_foo3 = pyrpc_import_union(&echo_Enum3_Type, r->out.foo3, *r->out.foo1, r->out.foo3, "union echo_Enum3");
	if (py_foo3 == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 2, py_foo3);
	return result;
}


static PyObject *py_echo_TestSurrounding_in_get_data(PyObject *obj, void *closure)
{
	struct echo_TestSurrounding *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->in.data == NULL) {
		Py_RETURN_NONE;
	}
	py_data = pytalloc_reference_ex(&echo_Surrounding_Type, object->in.data, object->in.data);
	return py_data;
}

static int py_echo_TestSurrounding_in_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestSurrounding *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.data");
		return -1;
	}
	object->in.data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data);
	if (object->in.data == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&echo_Surrounding_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.data = (struct echo_Surrounding *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_echo_TestSurrounding_out_get_data(PyObject *obj, void *closure)
{
	struct echo_TestSurrounding *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->out.data == NULL) {
		Py_RETURN_NONE;
	}
	py_data = pytalloc_reference_ex(&echo_Surrounding_Type, object->out.data, object->out.data);
	return py_data;
}

static int py_echo_TestSurrounding_out_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestSurrounding *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.data");
		return -1;
	}
	object->out.data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.data);
	if (object->out.data == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&echo_Surrounding_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.data = (struct echo_Surrounding *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_echo_TestSurrounding_getsetters[] = {
	{
		.name = discard_const_p(char, "in_data"),
		.get = py_echo_TestSurrounding_in_get_data,
		.set = py_echo_TestSurrounding_in_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Surrounding")
	},
	{
		.name = discard_const_p(char, "out_data"),
		.get = py_echo_TestSurrounding_out_get_data,
		.set = py_echo_TestSurrounding_out_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type echo_Surrounding")
	},
	{ .name = NULL }
};

static PyObject *py_echo_TestSurrounding_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_TestSurrounding, type);
	struct echo_TestSurrounding *_self = (struct echo_TestSurrounding *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.data = talloc_zero(mem_ctx, struct echo_Surrounding);
	_self->out.data = talloc_zero(mem_ctx, struct echo_Surrounding);
	return self;
}

static PyObject *py_echo_TestSurrounding_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_echo_TestSurrounding_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestSurrounding *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestSurrounding_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_TestSurrounding_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestSurrounding_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_TestSurrounding_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestSurrounding_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_TestSurrounding_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestSurrounding *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestSurrounding_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_TestSurrounding_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestSurrounding_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestSurrounding_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestSurrounding_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestSurrounding_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestSurrounding *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestSurrounding_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[8];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_TestSurrounding_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestSurrounding_ndr_print(py_obj, "echo_TestSurrounding_in", NDR_IN);
}

static PyObject *py_echo_TestSurrounding_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestSurrounding_ndr_print(py_obj, "echo_TestSurrounding_out", NDR_OUT);
}

static PyMethodDef py_echo_TestSurrounding_methods[] = {
	{ "opnum", (PyCFunction)py_echo_TestSurrounding_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.TestSurrounding.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSurrounding_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSurrounding_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSurrounding_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestSurrounding_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_TestSurrounding_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_TestSurrounding_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_TestSurrounding_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.TestSurrounding",
	.tp_getset = py_echo_TestSurrounding_getsetters,
	.tp_methods = py_echo_TestSurrounding_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_TestSurrounding_new,
};

static bool pack_py_echo_TestSurrounding_args_in(PyObject *args, PyObject *kwargs, struct echo_TestSurrounding *r)
{
	PyObject *py_data;
	const char *kwnames[] = {
		"data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_TestSurrounding", discard_const_p(char *, kwnames), &py_data)) {
		return false;
	}

	if (py_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.data");
		return false;
	}
	r->in.data = talloc_ptrtype(r, r->in.data);
	if (r->in.data == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&echo_Surrounding_Type, py_data, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_data)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.data = (struct echo_Surrounding *)pytalloc_get_ptr(py_data);
	return true;
}

static PyObject *unpack_py_echo_TestSurrounding_args_out(struct echo_TestSurrounding *r)
{
	PyObject *result;
	PyObject *py_data;
	py_data = pytalloc_reference_ex(&echo_Surrounding_Type, r->out.data, r->out.data);
	result = py_data;
	return result;
}


static PyObject *py_echo_TestDoublePointer_in_get_data(PyObject *obj, void *closure)
{
	struct echo_TestDoublePointer *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->in.data == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->in.data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		if (**object->in.data == NULL) {
			py_data = Py_None;
			Py_INCREF(py_data);
		} else {
			py_data = PyLong_FromLong((uint16_t)(***object->in.data));
		}
	}
	{
		PyObject *py_data_level_1 = py_data;
		py_data = py_dcerpc_ndr_pointer_wrap(ndr_pointer_Type, py_data_level_1);
		Py_XDECREF(py_data_level_1);
	}
	return py_data;
}

static int py_echo_TestDoublePointer_in_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestDoublePointer *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.data");
		return -1;
	}
	object->in.data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data);
	if (object->in.data == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->in.data = NULL;
	} else {
		*object->in.data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), *object->in.data);
		if (*object->in.data == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		value = py_dcerpc_ndr_pointer_deref(ndr_pointer_Type, value);
		if (value == NULL) {
			return -1;
		}
		if (value == Py_None) {
			**object->in.data = NULL;
		} else {
			**object->in.data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), **object->in.data);
			if (**object->in.data == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(***object->in.data));
				if (PyLong_Check(value)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(value);
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					***object->in.data = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_echo_TestDoublePointer_get_result(PyObject *obj, void *closure)
{
	struct echo_TestDoublePointer *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromLong((uint16_t)(object->out.result));
	return py_result;
}

static int py_echo_TestDoublePointer_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct echo_TestDoublePointer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_echo_TestDoublePointer_getsetters[] = {
	{
		.name = discard_const_p(char, "in_data"),
		.get = py_echo_TestDoublePointer_in_get_data,
		.set = py_echo_TestDoublePointer_in_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_echo_TestDoublePointer_get_result,
		.set = py_echo_TestDoublePointer_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_echo_TestDoublePointer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct echo_TestDoublePointer, type);
	struct echo_TestDoublePointer *_self = (struct echo_TestDoublePointer *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->in.data = talloc_zero(mem_ctx, uint16_t **);
	return self;
}

static PyObject *py_echo_TestDoublePointer_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(9);
}

static PyObject *py_echo_TestDoublePointer_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestDoublePointer *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestDoublePointer_ndr_pack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[9];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_echo_TestDoublePointer_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestDoublePointer_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_echo_TestDoublePointer_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_echo_TestDoublePointer_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_echo_TestDoublePointer_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestDoublePointer *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_rpcecho.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestDoublePointer_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[9];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_echo_TestDoublePointer_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestDoublePointer_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestDoublePointer_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_echo_TestDoublePointer_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_echo_TestDoublePointer_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct echo_TestDoublePointer *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_rpcecho.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_echo_TestDoublePointer_ndr_print");
		return NULL;
	}
	call = &ndr_table_rpcecho.calls[9];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_echo_TestDoublePointer_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestDoublePointer_ndr_print(py_obj, "echo_TestDoublePointer_in", NDR_IN);
}

static PyObject *py_echo_TestDoublePointer_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_echo_TestDoublePointer_ndr_print(py_obj, "echo_TestDoublePointer_out", NDR_OUT);
}

static PyMethodDef py_echo_TestDoublePointer_methods[] = {
	{ "opnum", (PyCFunction)py_echo_TestDoublePointer_ndr_opnum, METH_NOARGS|METH_CLASS,
		"echo.TestDoublePointer.opnum() -> 9 (0x09) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestDoublePointer_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestDoublePointer_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestDoublePointer_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_echo_TestDoublePointer_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_echo_TestDoublePointer_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_echo_TestDoublePointer_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject echo_TestDoublePointer_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.TestDoublePointer",
	.tp_getset = py_echo_TestDoublePointer_getsetters,
	.tp_methods = py_echo_TestDoublePointer_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_echo_TestDoublePointer_new,
};

static bool pack_py_echo_TestDoublePointer_args_in(PyObject *args, PyObject *kwargs, struct echo_TestDoublePointer *r)
{
	PyObject *py_data;
	const char *kwnames[] = {
		"data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:echo_TestDoublePointer", discard_const_p(char *, kwnames), &py_data)) {
		return false;
	}

	if (py_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.data");
		return false;
	}
	r->in.data = talloc_ptrtype(r, r->in.data);
	if (r->in.data == NULL) {
		PyErr_NoMemory();
		return false;
	}
	if (py_data == Py_None) {
		*r->in.data = NULL;
	} else {
		*r->in.data = talloc_ptrtype(r, *r->in.data);
		if (*r->in.data == NULL) {
			PyErr_NoMemory();
			return false;
		}
		py_data = py_dcerpc_ndr_pointer_deref(ndr_pointer_Type, py_data);
		if (py_data == NULL) {
			return false;
		}
		if (py_data == Py_None) {
			**r->in.data = NULL;
		} else {
			**r->in.data = talloc_ptrtype(r, **r->in.data);
			if (**r->in.data == NULL) {
				PyErr_NoMemory();
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(***r->in.data));
				if (PyLong_Check(py_data)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(py_data);
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					***r->in.data = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	return true;
}

static PyObject *unpack_py_echo_TestDoublePointer_args_out(struct echo_TestDoublePointer *r)
{
	PyObject *result;
	result = PyLong_FromLong((uint16_t)(r->out.result));
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_rpcecho_methods[] = {
	{ "AddOne", "S.AddOne(in_data) -> out_data", (py_dcerpc_call_fn)dcerpc_echo_AddOne_r, (py_data_pack_fn)pack_py_echo_AddOne_args_in, (py_data_unpack_fn)unpack_py_echo_AddOne_args_out, 0, &ndr_table_rpcecho },
	{ "EchoData", "S.EchoData(in_data) -> out_data", (py_dcerpc_call_fn)dcerpc_echo_EchoData_r, (py_data_pack_fn)pack_py_echo_EchoData_args_in, (py_data_unpack_fn)unpack_py_echo_EchoData_args_out, 1, &ndr_table_rpcecho },
	{ "SinkData", "S.SinkData(data) -> None", (py_dcerpc_call_fn)dcerpc_echo_SinkData_r, (py_data_pack_fn)pack_py_echo_SinkData_args_in, (py_data_unpack_fn)unpack_py_echo_SinkData_args_out, 2, &ndr_table_rpcecho },
	{ "SourceData", "S.SourceData(len) -> data", (py_dcerpc_call_fn)dcerpc_echo_SourceData_r, (py_data_pack_fn)pack_py_echo_SourceData_args_in, (py_data_unpack_fn)unpack_py_echo_SourceData_args_out, 3, &ndr_table_rpcecho },
	{ "TestCall", "S.TestCall(s1) -> s2", (py_dcerpc_call_fn)dcerpc_echo_TestCall_r, (py_data_pack_fn)pack_py_echo_TestCall_args_in, (py_data_unpack_fn)unpack_py_echo_TestCall_args_out, 4, &ndr_table_rpcecho },
	{ "TestCall2", "S.TestCall2(level) -> info", (py_dcerpc_call_fn)dcerpc_echo_TestCall2_r, (py_data_pack_fn)pack_py_echo_TestCall2_args_in, (py_data_unpack_fn)unpack_py_echo_TestCall2_args_out, 5, &ndr_table_rpcecho },
	{ "TestSleep", "S.TestSleep(seconds) -> result", (py_dcerpc_call_fn)dcerpc_echo_TestSleep_r, (py_data_pack_fn)pack_py_echo_TestSleep_args_in, (py_data_unpack_fn)unpack_py_echo_TestSleep_args_out, 6, &ndr_table_rpcecho },
	{ "TestEnum", "S.TestEnum(foo1, foo2, foo3) -> (foo1, foo2, foo3)", (py_dcerpc_call_fn)dcerpc_echo_TestEnum_r, (py_data_pack_fn)pack_py_echo_TestEnum_args_in, (py_data_unpack_fn)unpack_py_echo_TestEnum_args_out, 7, &ndr_table_rpcecho },
	{ "TestSurrounding", "S.TestSurrounding(data) -> data", (py_dcerpc_call_fn)dcerpc_echo_TestSurrounding_r, (py_data_pack_fn)pack_py_echo_TestSurrounding_args_in, (py_data_unpack_fn)unpack_py_echo_TestSurrounding_args_out, 8, &ndr_table_rpcecho },
	{ "TestDoublePointer", "S.TestDoublePointer(data) -> result", (py_dcerpc_call_fn)dcerpc_echo_TestDoublePointer_r, (py_data_pack_fn)pack_py_echo_TestDoublePointer_args_in, (py_data_unpack_fn)unpack_py_echo_TestDoublePointer_args_out, 9, &ndr_table_rpcecho },
	{0}
};

static PyObject *interface_rpcecho_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_rpcecho);
}

#define PY_DOC_RPCECHO "Simple echo pipe"
static PyTypeObject rpcecho_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.rpcecho",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "rpcecho(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_RPCECHO,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_rpcecho_new,
};

static PyObject *syntax_rpcecho_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_rpcecho.syntax_id);
}

#define PY_DOC_RPCECHO_SYNTAX "Simple echo pipe"
static PyTypeObject rpcecho_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "echo.rpcecho_abstract_syntax",
	.tp_doc = "rpcecho_abstract_syntax()\n"PY_DOC_RPCECHO_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_rpcecho_new,
};

static PyMethodDef echo_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "echo",
	.m_doc = "echo DCE/RPC",
	.m_size = -1,
	.m_methods = echo_methods,
};
MODULE_INIT_FUNC(echo)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ndr_pointer_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ndr_pointer");
	if (ndr_pointer_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	echo_info1_Type.tp_base = BaseObject_Type;
	echo_info1_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_info2_Type.tp_base = BaseObject_Type;
	echo_info2_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_info3_Type.tp_base = BaseObject_Type;
	echo_info3_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_info4_Type.tp_base = BaseObject_Type;
	echo_info4_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_info5_Type.tp_base = BaseObject_Type;
	echo_info5_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_info6_Type.tp_base = BaseObject_Type;
	echo_info6_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_info7_Type.tp_base = BaseObject_Type;
	echo_info7_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_Info_Type.tp_base = BaseObject_Type;
	echo_Info_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_Enum2_Type.tp_base = BaseObject_Type;
	echo_Enum2_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_Enum3_Type.tp_base = BaseObject_Type;
	echo_Enum3_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_Surrounding_Type.tp_base = BaseObject_Type;
	echo_Surrounding_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_AddOne_Type.tp_base = BaseObject_Type;
	echo_AddOne_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_EchoData_Type.tp_base = BaseObject_Type;
	echo_EchoData_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_SinkData_Type.tp_base = BaseObject_Type;
	echo_SinkData_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_SourceData_Type.tp_base = BaseObject_Type;
	echo_SourceData_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_TestCall_Type.tp_base = BaseObject_Type;
	echo_TestCall_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_TestCall2_Type.tp_base = BaseObject_Type;
	echo_TestCall2_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_TestSleep_Type.tp_base = BaseObject_Type;
	echo_TestSleep_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_TestEnum_Type.tp_base = BaseObject_Type;
	echo_TestEnum_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_TestSurrounding_Type.tp_base = BaseObject_Type;
	echo_TestSurrounding_Type.tp_basicsize = pytalloc_BaseObject_size();

	echo_TestDoublePointer_Type.tp_base = BaseObject_Type;
	echo_TestDoublePointer_Type.tp_basicsize = pytalloc_BaseObject_size();

	rpcecho_InterfaceType.tp_base = ClientConnection_Type;

	rpcecho_SyntaxType.tp_base = ndr_syntax_id_Type;
	rpcecho_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&echo_info1_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_info2_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_info3_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_info4_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_info5_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_info6_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_info7_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_Info_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_Enum2_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_Enum3_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_Surrounding_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_AddOne_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_EchoData_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_SinkData_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_SourceData_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_TestCall_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_TestCall2_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_TestSleep_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_TestEnum_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_TestSurrounding_Type) < 0)
		goto out;
	if (PyType_Ready(&echo_TestDoublePointer_Type) < 0)
		goto out;
	if (PyType_Ready(&rpcecho_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&rpcecho_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&rpcecho_InterfaceType, py_ndr_rpcecho_methods))
		return NULL;

#ifdef PY_INFO1_PATCH
	PY_INFO1_PATCH(&echo_info1_Type);
#endif
#ifdef PY_INFO2_PATCH
	PY_INFO2_PATCH(&echo_info2_Type);
#endif
#ifdef PY_INFO3_PATCH
	PY_INFO3_PATCH(&echo_info3_Type);
#endif
#ifdef PY_INFO4_PATCH
	PY_INFO4_PATCH(&echo_info4_Type);
#endif
#ifdef PY_INFO5_PATCH
	PY_INFO5_PATCH(&echo_info5_Type);
#endif
#ifdef PY_INFO6_PATCH
	PY_INFO6_PATCH(&echo_info6_Type);
#endif
#ifdef PY_INFO7_PATCH
	PY_INFO7_PATCH(&echo_info7_Type);
#endif
#ifdef PY_INFO_PATCH
	PY_INFO_PATCH(&echo_Info_Type);
#endif
#ifdef PY_ENUM2_PATCH
	PY_ENUM2_PATCH(&echo_Enum2_Type);
#endif
#ifdef PY_ENUM3_PATCH
	PY_ENUM3_PATCH(&echo_Enum3_Type);
#endif
#ifdef PY_SURROUNDING_PATCH
	PY_SURROUNDING_PATCH(&echo_Surrounding_Type);
#endif
#ifdef PY_ADDONE_PATCH
	PY_ADDONE_PATCH(&echo_AddOne_Type);
#endif
#ifdef PY_ECHODATA_PATCH
	PY_ECHODATA_PATCH(&echo_EchoData_Type);
#endif
#ifdef PY_SINKDATA_PATCH
	PY_SINKDATA_PATCH(&echo_SinkData_Type);
#endif
#ifdef PY_SOURCEDATA_PATCH
	PY_SOURCEDATA_PATCH(&echo_SourceData_Type);
#endif
#ifdef PY_TESTCALL_PATCH
	PY_TESTCALL_PATCH(&echo_TestCall_Type);
#endif
#ifdef PY_TESTCALL2_PATCH
	PY_TESTCALL2_PATCH(&echo_TestCall2_Type);
#endif
#ifdef PY_TESTSLEEP_PATCH
	PY_TESTSLEEP_PATCH(&echo_TestSleep_Type);
#endif
#ifdef PY_TESTENUM_PATCH
	PY_TESTENUM_PATCH(&echo_TestEnum_Type);
#endif
#ifdef PY_TESTSURROUNDING_PATCH
	PY_TESTSURROUNDING_PATCH(&echo_TestSurrounding_Type);
#endif
#ifdef PY_TESTDOUBLEPOINTER_PATCH
	PY_TESTDOUBLEPOINTER_PATCH(&echo_TestDoublePointer_Type);
#endif
#ifdef PY_RPCECHO_PATCH
	PY_RPCECHO_PATCH(&rpcecho_InterfaceType);
#endif
#ifdef PY_RPCECHO_ABSTRACT_SYNTAX_PATCH
	PY_RPCECHO_ABSTRACT_SYNTAX_PATCH(&rpcecho_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&rpcecho_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "ECHO_ENUM1", PyLong_FromLong((uint16_t)(ECHO_ENUM1)));
	PyModule_AddObject(m, "ECHO_ENUM2", PyLong_FromLong((uint16_t)(ECHO_ENUM2)));
	PyModule_AddObject(m, "ECHO_ENUM1_32", PyLong_FromUnsignedLongLong((uint32_t)(ECHO_ENUM1_32)));
	PyModule_AddObject(m, "ECHO_ENUM2_32", PyLong_FromUnsignedLongLong((uint32_t)(ECHO_ENUM2_32)));
	Py_INCREF((PyObject *)(void *)&echo_info1_Type);
	PyModule_AddObject(m, "info1", (PyObject *)(void *)&echo_info1_Type);
	Py_INCREF((PyObject *)(void *)&echo_info2_Type);
	PyModule_AddObject(m, "info2", (PyObject *)(void *)&echo_info2_Type);
	Py_INCREF((PyObject *)(void *)&echo_info3_Type);
	PyModule_AddObject(m, "info3", (PyObject *)(void *)&echo_info3_Type);
	Py_INCREF((PyObject *)(void *)&echo_info4_Type);
	PyModule_AddObject(m, "info4", (PyObject *)(void *)&echo_info4_Type);
	Py_INCREF((PyObject *)(void *)&echo_info5_Type);
	PyModule_AddObject(m, "info5", (PyObject *)(void *)&echo_info5_Type);
	Py_INCREF((PyObject *)(void *)&echo_info6_Type);
	PyModule_AddObject(m, "info6", (PyObject *)(void *)&echo_info6_Type);
	Py_INCREF((PyObject *)(void *)&echo_info7_Type);
	PyModule_AddObject(m, "info7", (PyObject *)(void *)&echo_info7_Type);
	Py_INCREF((PyObject *)(void *)&echo_Info_Type);
	PyModule_AddObject(m, "Info", (PyObject *)(void *)&echo_Info_Type);
	Py_INCREF((PyObject *)(void *)&echo_Enum2_Type);
	PyModule_AddObject(m, "Enum2", (PyObject *)(void *)&echo_Enum2_Type);
	Py_INCREF((PyObject *)(void *)&echo_Enum3_Type);
	PyModule_AddObject(m, "Enum3", (PyObject *)(void *)&echo_Enum3_Type);
	Py_INCREF((PyObject *)(void *)&echo_Surrounding_Type);
	PyModule_AddObject(m, "Surrounding", (PyObject *)(void *)&echo_Surrounding_Type);
	Py_INCREF((PyObject *)(void *)&echo_AddOne_Type);
	PyModule_AddObject(m, "AddOne", (PyObject *)(void *)&echo_AddOne_Type);
	Py_INCREF((PyObject *)(void *)&echo_EchoData_Type);
	PyModule_AddObject(m, "EchoData", (PyObject *)(void *)&echo_EchoData_Type);
	Py_INCREF((PyObject *)(void *)&echo_SinkData_Type);
	PyModule_AddObject(m, "SinkData", (PyObject *)(void *)&echo_SinkData_Type);
	Py_INCREF((PyObject *)(void *)&echo_SourceData_Type);
	PyModule_AddObject(m, "SourceData", (PyObject *)(void *)&echo_SourceData_Type);
	Py_INCREF((PyObject *)(void *)&echo_TestCall_Type);
	PyModule_AddObject(m, "TestCall", (PyObject *)(void *)&echo_TestCall_Type);
	Py_INCREF((PyObject *)(void *)&echo_TestCall2_Type);
	PyModule_AddObject(m, "TestCall2", (PyObject *)(void *)&echo_TestCall2_Type);
	Py_INCREF((PyObject *)(void *)&echo_TestSleep_Type);
	PyModule_AddObject(m, "TestSleep", (PyObject *)(void *)&echo_TestSleep_Type);
	Py_INCREF((PyObject *)(void *)&echo_TestEnum_Type);
	PyModule_AddObject(m, "TestEnum", (PyObject *)(void *)&echo_TestEnum_Type);
	Py_INCREF((PyObject *)(void *)&echo_TestSurrounding_Type);
	PyModule_AddObject(m, "TestSurrounding", (PyObject *)(void *)&echo_TestSurrounding_Type);
	Py_INCREF((PyObject *)(void *)&echo_TestDoublePointer_Type);
	PyModule_AddObject(m, "TestDoublePointer", (PyObject *)(void *)&echo_TestDoublePointer_Type);
	Py_INCREF((PyObject *)(void *)&rpcecho_InterfaceType);
	PyModule_AddObject(m, "rpcecho", (PyObject *)(void *)&rpcecho_InterfaceType);
	Py_INCREF((PyObject *)(void *)&rpcecho_SyntaxType);
	PyModule_AddObject(m, "rpcecho_abstract_syntax", (PyObject *)(void *)&rpcecho_SyntaxType);
	Py_INCREF((PyObject *)(void *)&rpcecho_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&rpcecho_SyntaxType);
#ifdef PY_MOD_ECHO_PATCH
	PY_MOD_ECHO_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
