
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_drsblobs.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/drsuapi.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
static PyTypeObject replPropertyMetaData1_Type;
static PyTypeObject replPropertyMetaDataCtr1_Type;
static PyTypeObject replPropertyMetaDataCtr_Type;
static PyTypeObject replPropertyMetaDataBlob_Type;
static PyTypeObject replUpToDateVectorCtr1_Type;
static PyTypeObject replUpToDateVectorCtr2_Type;
static PyTypeObject replUpToDateVectorCtr_Type;
static PyTypeObject replUpToDateVectorBlob_Type;
static PyTypeObject repsFromTo1OtherInfo_Type;
static PyTypeObject repsFromTo1_Type;
static PyTypeObject repsFromTo2OtherInfo_Type;
static PyTypeObject repsFromTo2_Type;
static PyTypeObject repsFromTo_Type;
static PyTypeObject repsFromToBlob_Type;
static PyTypeObject scheduleHeader_Type;
static PyTypeObject scheduleSlots_Type;
static PyTypeObject schedule_Type;
static PyTypeObject partialAttributeSetCtr1_Type;
static PyTypeObject partialAttributeSetCtr_Type;
static PyTypeObject partialAttributeSetBlob_Type;
static PyTypeObject schemaInfoBlob_Type;
static PyTypeObject drsuapi_MSPrefixMap_Entry_Type;
static PyTypeObject drsuapi_MSPrefixMap_Ctr_Type;
static PyTypeObject prefixMapCtr_Type;
static PyTypeObject prefixMapBlob_Type;
static PyTypeObject ldapControlDirSyncExtra_Type;
static PyTypeObject ldapControlDirSyncBlob_Type;
static PyTypeObject ldapControlDirSyncCookie_Type;
static PyTypeObject supplementalCredentialsPackage_Type;
static PyTypeObject supplementalCredentialsSubBlob_Type;
static PyTypeObject supplementalCredentialsBlob_Type;
static PyTypeObject package_PackagesBlob_Type;
static PyTypeObject package_PrimaryKerberosString_Type;
static PyTypeObject package_PrimaryKerberosKey3_Type;
static PyTypeObject package_PrimaryKerberosCtr3_Type;
static PyTypeObject package_PrimaryKerberosKey4_Type;
static PyTypeObject package_PrimaryKerberosCtr4_Type;
static PyTypeObject package_PrimaryKerberosCtr_Type;
static PyTypeObject package_PrimaryKerberosBlob_Type;
static PyTypeObject package_PrimaryCLEARTEXTBlob_Type;
static PyTypeObject package_PrimaryWDigestHash_Type;
static PyTypeObject package_PrimaryWDigestBlob_Type;
static PyTypeObject package_PrimarySambaGPGBlob_Type;
static PyTypeObject package_PrimaryUserPasswordValue_Type;
static PyTypeObject package_PrimaryUserPasswordBlob_Type;
static PyTypeObject AuthInfoNone_Type;
static PyTypeObject AuthInfoNT4Owf_Type;
static PyTypeObject AuthInfoClear_Type;
static PyTypeObject AuthInfoVersion_Type;
static PyTypeObject AuthInfo_Type;
static PyTypeObject AuthenticationInformation_Type;
static PyTypeObject AuthenticationInformationArray_Type;
static PyTypeObject trustAuthInOutBlob_Type;
static PyTypeObject trustDomainPasswords_Type;
static PyTypeObject DsCompressedChunk_Type;
static PyTypeObject ExtendedErrorAString_Type;
static PyTypeObject ExtendedErrorUString_Type;
static PyTypeObject ExtendedErrorBlob_Type;
static PyTypeObject ExtendedErrorComputerNameU_Type;
static PyTypeObject ExtendedErrorComputerName_Type;
static PyTypeObject ExtendedErrorParamU_Type;
static PyTypeObject ExtendedErrorParam_Type;
static PyTypeObject ExtendedErrorInfo_Type;
static PyTypeObject ExtendedErrorInfoPtr_Type;
static PyTypeObject ForestTrustString_Type;
static PyTypeObject ForestTrustDataDomainInfo_Type;
static PyTypeObject ForestTrustDataBinaryData_Type;
static PyTypeObject ForestTrustData_Type;
static PyTypeObject ForestTrustInfoRecord_Type;
static PyTypeObject ForestTrustInfoRecordArmor_Type;
static PyTypeObject ForestTrustInfo_Type;
static PyTypeObject PlaintextSecret_Type;
static PyTypeObject EncryptedSecretHeader_Type;
static PyTypeObject EncryptedSecret_Type;
static PyTypeObject drsblobs_InterfaceType;

static PyTypeObject *GUID_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *drsuapi_DsReplicaCursor_Type;
static PyTypeObject *drsuapi_DsReplicaCursor2_Type;
static PyTypeObject *drsuapi_DsReplicaHighWaterMark_Type;
static PyTypeObject *drsuapi_DsReplicaOIDMapping_Ctr_Type;
static PyTypeObject *samr_Password_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_replPropertyMetaData1_get_attid(PyObject *obj, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(obj);
	PyObject *py_attid;
	py_attid = PyLong_FromUnsignedLongLong((uint32_t)(object->attid));
	return py_attid;
}

static int py_replPropertyMetaData1_set_attid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->attid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaData1_get_version(PyObject *obj, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_replPropertyMetaData1_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaData1_get_originating_change_time(PyObject *obj, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_change_time;
	py_originating_change_time = PyLong_FromUnsignedLongLong(object->originating_change_time);
	return py_originating_change_time;
}

static int py_replPropertyMetaData1_set_originating_change_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->originating_change_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_change_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_change_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaData1_get_originating_invocation_id(PyObject *obj, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_invocation_id;
	py_originating_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->originating_invocation_id);
	return py_originating_invocation_id;
}

static int py_replPropertyMetaData1_set_originating_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->originating_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->originating_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_replPropertyMetaData1_get_originating_usn(PyObject *obj, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(obj);
	PyObject *py_originating_usn;
	py_originating_usn = PyLong_FromUnsignedLongLong(object->originating_usn);
	return py_originating_usn;
}

static int py_replPropertyMetaData1_set_originating_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->originating_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->originating_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->originating_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaData1_get_local_usn(PyObject *obj, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(obj);
	PyObject *py_local_usn;
	py_local_usn = PyLong_FromUnsignedLongLong(object->local_usn);
	return py_local_usn;
}

static int py_replPropertyMetaData1_set_local_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->local_usn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->local_usn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->local_usn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_replPropertyMetaData1_getsetters[] = {
	{
		.name = discard_const_p(char, "attid"),
		.get = py_replPropertyMetaData1_get_attid,
		.set = py_replPropertyMetaData1_set_attid,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeId")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_replPropertyMetaData1_get_version,
		.set = py_replPropertyMetaData1_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "originating_change_time"),
		.get = py_replPropertyMetaData1_get_originating_change_time,
		.set = py_replPropertyMetaData1_set_originating_change_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_1sec")
	},
	{
		.name = discard_const_p(char, "originating_invocation_id"),
		.get = py_replPropertyMetaData1_get_originating_invocation_id,
		.set = py_replPropertyMetaData1_set_originating_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "originating_usn"),
		.get = py_replPropertyMetaData1_get_originating_usn,
		.set = py_replPropertyMetaData1_set_originating_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "local_usn"),
		.get = py_replPropertyMetaData1_get_local_usn,
		.set = py_replPropertyMetaData1_set_local_usn,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_replPropertyMetaData1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct replPropertyMetaData1, type);
}

static PyObject *py_replPropertyMetaData1_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_replPropertyMetaData1);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_replPropertyMetaData1_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_replPropertyMetaData1);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_replPropertyMetaData1);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_replPropertyMetaData1_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct replPropertyMetaData1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_replPropertyMetaData1, "replPropertyMetaData1", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_replPropertyMetaData1_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_replPropertyMetaData1_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_replPropertyMetaData1_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_replPropertyMetaData1_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject replPropertyMetaData1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replPropertyMetaData1",
	.tp_getset = py_replPropertyMetaData1_getsetters,
	.tp_methods = py_replPropertyMetaData1_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replPropertyMetaData1_new,
};


static PyObject *py_replPropertyMetaDataCtr1_get_count(PyObject *obj, void *closure)
{
	struct replPropertyMetaDataCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_replPropertyMetaDataCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaDataCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaDataCtr1_get_reserved(PyObject *obj, void *closure)
{
	struct replPropertyMetaDataCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_replPropertyMetaDataCtr1_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaDataCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaDataCtr1_get_array(PyObject *obj, void *closure)
{
	struct replPropertyMetaDataCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&replPropertyMetaData1_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_replPropertyMetaDataCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaDataCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&replPropertyMetaData1_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct replPropertyMetaData1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_replPropertyMetaDataCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_replPropertyMetaDataCtr1_get_count,
		.set = py_replPropertyMetaDataCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_replPropertyMetaDataCtr1_get_reserved,
		.set = py_replPropertyMetaDataCtr1_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_replPropertyMetaDataCtr1_get_array,
		.set = py_replPropertyMetaDataCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type replPropertyMetaData1")
	},
	{ .name = NULL }
};

static PyObject *py_replPropertyMetaDataCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct replPropertyMetaDataCtr1, type);
}


static PyTypeObject replPropertyMetaDataCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replPropertyMetaDataCtr1",
	.tp_getset = py_replPropertyMetaDataCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replPropertyMetaDataCtr1_new,
};

static PyObject *py_import_replPropertyMetaDataCtr(TALLOC_CTX *mem_ctx, int level, union replPropertyMetaDataCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&replPropertyMetaDataCtr1_Type, mem_ctx, &in->ctr1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union replPropertyMetaDataCtr *py_export_replPropertyMetaDataCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union replPropertyMetaDataCtr *ret = talloc_zero(mem_ctx, union replPropertyMetaDataCtr);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&replPropertyMetaDataCtr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct replPropertyMetaDataCtr1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_replPropertyMetaDataCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union replPropertyMetaDataCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union replPropertyMetaDataCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union replPropertyMetaDataCtr!");
		return NULL;
	}

	return py_import_replPropertyMetaDataCtr(mem_ctx, level, in);
}

static PyObject *py_replPropertyMetaDataCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union replPropertyMetaDataCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_replPropertyMetaDataCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_replPropertyMetaDataCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_replPropertyMetaDataCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_replPropertyMetaDataCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_replPropertyMetaDataCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject replPropertyMetaDataCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replPropertyMetaDataCtr",
	.tp_getset = NULL,
	.tp_methods = py_replPropertyMetaDataCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replPropertyMetaDataCtr_new,
};


static PyObject *py_replPropertyMetaDataBlob_get_version(PyObject *obj, void *closure)
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_replPropertyMetaDataBlob_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaDataBlob_get_reserved(PyObject *obj, void *closure)
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_replPropertyMetaDataBlob_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replPropertyMetaDataBlob_get_ctr(PyObject *obj, void *closure)
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&replPropertyMetaDataCtr_Type, pytalloc_get_mem_ctx(obj), object->version, &object->ctr, "union replPropertyMetaDataCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_replPropertyMetaDataBlob_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union replPropertyMetaDataCtr *ctr_switch_0;
		ctr_switch_0 = (union replPropertyMetaDataCtr *)pyrpc_export_union(&replPropertyMetaDataCtr_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union replPropertyMetaDataCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_replPropertyMetaDataBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_replPropertyMetaDataBlob_get_version,
		.set = py_replPropertyMetaDataBlob_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_replPropertyMetaDataBlob_get_reserved,
		.set = py_replPropertyMetaDataBlob_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_replPropertyMetaDataBlob_get_ctr,
		.set = py_replPropertyMetaDataBlob_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type replPropertyMetaDataCtr")
	},
	{ .name = NULL }
};

static PyObject *py_replPropertyMetaDataBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct replPropertyMetaDataBlob, type);
}

static PyObject *py_replPropertyMetaDataBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_replPropertyMetaDataBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_replPropertyMetaDataBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_replPropertyMetaDataBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_replPropertyMetaDataBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_replPropertyMetaDataBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct replPropertyMetaDataBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_replPropertyMetaDataBlob, "replPropertyMetaDataBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_replPropertyMetaDataBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_replPropertyMetaDataBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_replPropertyMetaDataBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_replPropertyMetaDataBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject replPropertyMetaDataBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replPropertyMetaDataBlob",
	.tp_getset = py_replPropertyMetaDataBlob_getsetters,
	.tp_methods = py_replPropertyMetaDataBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replPropertyMetaDataBlob_new,
};


static PyObject *py_replUpToDateVectorCtr1_get_count(PyObject *obj, void *closure)
{
	struct replUpToDateVectorCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_replUpToDateVectorCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replUpToDateVectorCtr1_get_reserved(PyObject *obj, void *closure)
{
	struct replUpToDateVectorCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_replUpToDateVectorCtr1_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replUpToDateVectorCtr1_get_cursors(PyObject *obj, void *closure)
{
	struct replUpToDateVectorCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_cursors;
	py_cursors = PyList_New(object->count);
	if (py_cursors == NULL) {
		return NULL;
	}
	{
		int cursors_cntr_0;
		for (cursors_cntr_0 = 0; cursors_cntr_0 < (object->count); cursors_cntr_0++) {
			PyObject *py_cursors_0;
			py_cursors_0 = pytalloc_reference_ex(drsuapi_DsReplicaCursor_Type, object->cursors, &(object->cursors)[cursors_cntr_0]);
			PyList_SetItem(py_cursors, cursors_cntr_0, py_cursors_0);
		}
	}
	return py_cursors;
}

static int py_replUpToDateVectorCtr1_set_cursors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cursors");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int cursors_cntr_0;
		object->cursors = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cursors, PyList_GET_SIZE(value));
		if (!object->cursors) { return -1; }
		talloc_set_name_const(object->cursors, "ARRAY: object->cursors");
		for (cursors_cntr_0 = 0; cursors_cntr_0 < PyList_GET_SIZE(value); cursors_cntr_0++) {
			if (PyList_GET_ITEM(value, cursors_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->cursors)[cursors_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(drsuapi_DsReplicaCursor_Type, PyList_GET_ITEM(value, cursors_cntr_0), return -1;);
			if (talloc_reference(object->cursors, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, cursors_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->cursors)[cursors_cntr_0] = *(struct drsuapi_DsReplicaCursor *)pytalloc_get_ptr(PyList_GET_ITEM(value, cursors_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_replUpToDateVectorCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_replUpToDateVectorCtr1_get_count,
		.set = py_replUpToDateVectorCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_replUpToDateVectorCtr1_get_reserved,
		.set = py_replUpToDateVectorCtr1_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cursors"),
		.get = py_replUpToDateVectorCtr1_get_cursors,
		.set = py_replUpToDateVectorCtr1_set_cursors,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursor")
	},
	{ .name = NULL }
};

static PyObject *py_replUpToDateVectorCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct replUpToDateVectorCtr1, type);
}


static PyTypeObject replUpToDateVectorCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replUpToDateVectorCtr1",
	.tp_getset = py_replUpToDateVectorCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replUpToDateVectorCtr1_new,
};


static PyObject *py_replUpToDateVectorCtr2_get_count(PyObject *obj, void *closure)
{
	struct replUpToDateVectorCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_replUpToDateVectorCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replUpToDateVectorCtr2_get_reserved(PyObject *obj, void *closure)
{
	struct replUpToDateVectorCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_replUpToDateVectorCtr2_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replUpToDateVectorCtr2_get_cursors(PyObject *obj, void *closure)
{
	struct replUpToDateVectorCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_cursors;
	py_cursors = PyList_New(object->count);
	if (py_cursors == NULL) {
		return NULL;
	}
	{
		int cursors_cntr_0;
		for (cursors_cntr_0 = 0; cursors_cntr_0 < (object->count); cursors_cntr_0++) {
			PyObject *py_cursors_0;
			py_cursors_0 = pytalloc_reference_ex(drsuapi_DsReplicaCursor2_Type, object->cursors, &(object->cursors)[cursors_cntr_0]);
			PyList_SetItem(py_cursors, cursors_cntr_0, py_cursors_0);
		}
	}
	return py_cursors;
}

static int py_replUpToDateVectorCtr2_set_cursors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cursors");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int cursors_cntr_0;
		object->cursors = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cursors, PyList_GET_SIZE(value));
		if (!object->cursors) { return -1; }
		talloc_set_name_const(object->cursors, "ARRAY: object->cursors");
		for (cursors_cntr_0 = 0; cursors_cntr_0 < PyList_GET_SIZE(value); cursors_cntr_0++) {
			if (PyList_GET_ITEM(value, cursors_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->cursors)[cursors_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(drsuapi_DsReplicaCursor2_Type, PyList_GET_ITEM(value, cursors_cntr_0), return -1;);
			if (talloc_reference(object->cursors, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, cursors_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->cursors)[cursors_cntr_0] = *(struct drsuapi_DsReplicaCursor2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, cursors_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_replUpToDateVectorCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_replUpToDateVectorCtr2_get_count,
		.set = py_replUpToDateVectorCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_replUpToDateVectorCtr2_get_reserved,
		.set = py_replUpToDateVectorCtr2_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cursors"),
		.get = py_replUpToDateVectorCtr2_get_cursors,
		.set = py_replUpToDateVectorCtr2_set_cursors,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaCursor2")
	},
	{ .name = NULL }
};

static PyObject *py_replUpToDateVectorCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct replUpToDateVectorCtr2, type);
}


static PyTypeObject replUpToDateVectorCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replUpToDateVectorCtr2",
	.tp_getset = py_replUpToDateVectorCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replUpToDateVectorCtr2_new,
};

static PyObject *py_import_replUpToDateVectorCtr(TALLOC_CTX *mem_ctx, int level, union replUpToDateVectorCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&replUpToDateVectorCtr1_Type, mem_ctx, &in->ctr1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&replUpToDateVectorCtr2_Type, mem_ctx, &in->ctr2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union replUpToDateVectorCtr *py_export_replUpToDateVectorCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union replUpToDateVectorCtr *ret = talloc_zero(mem_ctx, union replUpToDateVectorCtr);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&replUpToDateVectorCtr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct replUpToDateVectorCtr1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&replUpToDateVectorCtr2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr2 = *(struct replUpToDateVectorCtr2 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_replUpToDateVectorCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union replUpToDateVectorCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union replUpToDateVectorCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union replUpToDateVectorCtr!");
		return NULL;
	}

	return py_import_replUpToDateVectorCtr(mem_ctx, level, in);
}

static PyObject *py_replUpToDateVectorCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union replUpToDateVectorCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_replUpToDateVectorCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_replUpToDateVectorCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_replUpToDateVectorCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_replUpToDateVectorCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_replUpToDateVectorCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject replUpToDateVectorCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replUpToDateVectorCtr",
	.tp_getset = NULL,
	.tp_methods = py_replUpToDateVectorCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replUpToDateVectorCtr_new,
};


static PyObject *py_replUpToDateVectorBlob_get_version(PyObject *obj, void *closure)
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_replUpToDateVectorBlob_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replUpToDateVectorBlob_get_reserved(PyObject *obj, void *closure)
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_replUpToDateVectorBlob_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_replUpToDateVectorBlob_get_ctr(PyObject *obj, void *closure)
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&replUpToDateVectorCtr_Type, pytalloc_get_mem_ctx(obj), object->version, &object->ctr, "union replUpToDateVectorCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_replUpToDateVectorBlob_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union replUpToDateVectorCtr *ctr_switch_0;
		ctr_switch_0 = (union replUpToDateVectorCtr *)pyrpc_export_union(&replUpToDateVectorCtr_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union replUpToDateVectorCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_replUpToDateVectorBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_replUpToDateVectorBlob_get_version,
		.set = py_replUpToDateVectorBlob_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_replUpToDateVectorBlob_get_reserved,
		.set = py_replUpToDateVectorBlob_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_replUpToDateVectorBlob_get_ctr,
		.set = py_replUpToDateVectorBlob_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type replUpToDateVectorCtr")
	},
	{ .name = NULL }
};

static PyObject *py_replUpToDateVectorBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct replUpToDateVectorBlob, type);
}

static PyObject *py_replUpToDateVectorBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_replUpToDateVectorBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_replUpToDateVectorBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_replUpToDateVectorBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_replUpToDateVectorBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_replUpToDateVectorBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct replUpToDateVectorBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_replUpToDateVectorBlob, "replUpToDateVectorBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_replUpToDateVectorBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_replUpToDateVectorBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_replUpToDateVectorBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_replUpToDateVectorBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject replUpToDateVectorBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.replUpToDateVectorBlob",
	.tp_getset = py_replUpToDateVectorBlob_getsetters,
	.tp_methods = py_replUpToDateVectorBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_replUpToDateVectorBlob_new,
};


static PyObject *py_repsFromTo1OtherInfo_get___dns_name_size(PyObject *obj, void *closure)
{
	struct repsFromTo1OtherInfo *object = pytalloc_get_ptr(obj);
	PyObject *py___dns_name_size;
	py___dns_name_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__dns_name_size));
	return py___dns_name_size;
}

static int py_repsFromTo1OtherInfo_set___dns_name_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1OtherInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->__dns_name_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__dns_name_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__dns_name_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1OtherInfo_get_dns_name(PyObject *obj, void *closure)
{
	struct repsFromTo1OtherInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name;
	if (object->dns_name == NULL) {
		py_dns_name = Py_None;
		Py_INCREF(py_dns_name);
	} else {
		py_dns_name = PyUnicode_Decode(object->dns_name, strlen(object->dns_name), "utf-8", "ignore");
	}
	return py_dns_name;
}

static int py_repsFromTo1OtherInfo_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1OtherInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dns_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dns_name = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_repsFromTo1OtherInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "__dns_name_size"),
		.get = py_repsFromTo1OtherInfo_get___dns_name_size,
		.set = py_repsFromTo1OtherInfo_set___dns_name_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dns_name"),
		.get = py_repsFromTo1OtherInfo_get_dns_name,
		.set = py_repsFromTo1OtherInfo_set_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_repsFromTo1OtherInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct repsFromTo1OtherInfo, type);
}

static PyObject *py_repsFromTo1OtherInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo1OtherInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_repsFromTo1OtherInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_repsFromTo1OtherInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct repsFromTo1OtherInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo1OtherInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo1OtherInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_repsFromTo1OtherInfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo1OtherInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_repsFromTo1OtherInfo, "repsFromTo1OtherInfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_repsFromTo1OtherInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_repsFromTo1OtherInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_repsFromTo1OtherInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_repsFromTo1OtherInfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject repsFromTo1OtherInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.repsFromTo1OtherInfo",
	.tp_getset = py_repsFromTo1OtherInfo_getsetters,
	.tp_methods = py_repsFromTo1OtherInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_repsFromTo1OtherInfo_new,
};


static PyObject *py_repsFromTo1_get_blobsize(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_blobsize;
	py_blobsize = PyLong_FromUnsignedLongLong((uint32_t)(object->blobsize));
	return py_blobsize;
}

static int py_repsFromTo1_set_blobsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->blobsize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->blobsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->blobsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_consecutive_sync_failures(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_consecutive_sync_failures;
	py_consecutive_sync_failures = PyLong_FromUnsignedLongLong((uint32_t)(object->consecutive_sync_failures));
	return py_consecutive_sync_failures;
}

static int py_repsFromTo1_set_consecutive_sync_failures(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->consecutive_sync_failures");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->consecutive_sync_failures));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->consecutive_sync_failures = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_last_success(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_success;
	py_last_success = PyLong_FromUnsignedLongLong(object->last_success);
	return py_last_success;
}

static int py_repsFromTo1_set_last_success(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->last_success");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_success));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_success = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_last_attempt(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_attempt;
	py_last_attempt = PyLong_FromUnsignedLongLong(object->last_attempt);
	return py_last_attempt;
}

static int py_repsFromTo1_set_last_attempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->last_attempt");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_attempt));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_attempt = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_result_last_attempt(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_result_last_attempt;
	py_result_last_attempt = PyErr_FromWERROR(object->result_last_attempt);
	return py_result_last_attempt;
}

static int py_repsFromTo1_set_result_last_attempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->result_last_attempt");
		return -1;
	}
	object->result_last_attempt = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_repsFromTo1_get_other_info(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_other_info;
	if (object->other_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->other_info == NULL) {
		py_other_info = Py_None;
		Py_INCREF(py_other_info);
	} else {
		py_other_info = pytalloc_reference_ex(&repsFromTo1OtherInfo_Type, object->other_info, object->other_info);
	}
	return py_other_info;
}

static int py_repsFromTo1_set_other_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->other_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_info");
		return -1;
	}
	if (value == Py_None) {
		object->other_info = NULL;
	} else {
		object->other_info = NULL;
		PY_CHECK_TYPE(&repsFromTo1OtherInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->other_info = (struct repsFromTo1OtherInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_other_info_length(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_other_info_length;
	py_other_info_length = PyLong_FromUnsignedLongLong((uint32_t)(object->other_info_length));
	return py_other_info_length;
}

static int py_repsFromTo1_set_other_info_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_info_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->other_info_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->other_info_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_replica_flags(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_replica_flags;
	py_replica_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->replica_flags));
	return py_replica_flags;
}

static int py_repsFromTo1_set_replica_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->replica_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->replica_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->replica_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_schedule(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_schedule;
	py_schedule = PyList_New(84);
	if (py_schedule == NULL) {
		return NULL;
	}
	{
		int schedule_cntr_0;
		for (schedule_cntr_0 = 0; schedule_cntr_0 < (84); schedule_cntr_0++) {
			PyObject *py_schedule_0;
			py_schedule_0 = PyLong_FromLong((uint16_t)((object->schedule)[schedule_cntr_0]));
			PyList_SetItem(py_schedule, schedule_cntr_0, py_schedule_0);
		}
	}
	return py_schedule;
}

static int py_repsFromTo1_set_schedule(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->schedule");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int schedule_cntr_0;
		if (ARRAY_SIZE(object->schedule) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->schedule),  PyList_GET_SIZE(value));
			return -1;
		}
		for (schedule_cntr_0 = 0; schedule_cntr_0 < PyList_GET_SIZE(value); schedule_cntr_0++) {
			if (PyList_GET_ITEM(value, schedule_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->schedule)[schedule_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->schedule)[schedule_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, schedule_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, schedule_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->schedule)[schedule_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_reserved(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_repsFromTo1_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo1_get_highwatermark(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_highwatermark;
	py_highwatermark = pytalloc_reference_ex(drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->highwatermark);
	return py_highwatermark;
}

static int py_repsFromTo1_set_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_repsFromTo1_get_source_dsa_obj_guid(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_obj_guid;
	py_source_dsa_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_obj_guid);
	return py_source_dsa_obj_guid;
}

static int py_repsFromTo1_set_source_dsa_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->source_dsa_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_repsFromTo1_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_repsFromTo1_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_repsFromTo1_get_transport_guid(PyObject *obj, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_guid;
	py_transport_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->transport_guid);
	return py_transport_guid;
}

static int py_repsFromTo1_set_transport_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->transport_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->transport_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_repsFromTo1_getsetters[] = {
	{
		.name = discard_const_p(char, "blobsize"),
		.get = py_repsFromTo1_get_blobsize,
		.set = py_repsFromTo1_set_blobsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "consecutive_sync_failures"),
		.get = py_repsFromTo1_get_consecutive_sync_failures,
		.set = py_repsFromTo1_set_consecutive_sync_failures,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "last_success"),
		.get = py_repsFromTo1_get_last_success,
		.set = py_repsFromTo1_set_last_success,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_1sec")
	},
	{
		.name = discard_const_p(char, "last_attempt"),
		.get = py_repsFromTo1_get_last_attempt,
		.set = py_repsFromTo1_set_last_attempt,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_1sec")
	},
	{
		.name = discard_const_p(char, "result_last_attempt"),
		.get = py_repsFromTo1_get_result_last_attempt,
		.set = py_repsFromTo1_set_result_last_attempt,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "other_info"),
		.get = py_repsFromTo1_get_other_info,
		.set = py_repsFromTo1_set_other_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type repsFromTo1OtherInfo")
	},
	{
		.name = discard_const_p(char, "other_info_length"),
		.get = py_repsFromTo1_get_other_info_length,
		.set = py_repsFromTo1_set_other_info_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "replica_flags"),
		.get = py_repsFromTo1_get_replica_flags,
		.set = py_repsFromTo1_set_replica_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "schedule"),
		.get = py_repsFromTo1_get_schedule,
		.set = py_repsFromTo1_set_schedule,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_repsFromTo1_get_reserved,
		.set = py_repsFromTo1_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "highwatermark"),
		.get = py_repsFromTo1_get_highwatermark,
		.set = py_repsFromTo1_set_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "source_dsa_obj_guid"),
		.get = py_repsFromTo1_get_source_dsa_obj_guid,
		.set = py_repsFromTo1_set_source_dsa_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_repsFromTo1_get_source_dsa_invocation_id,
		.set = py_repsFromTo1_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "transport_guid"),
		.get = py_repsFromTo1_get_transport_guid,
		.set = py_repsFromTo1_set_transport_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_repsFromTo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct repsFromTo1, type);
}

static PyObject *py_repsFromTo1_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_repsFromTo1);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_repsFromTo1_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo1);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo1);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_repsFromTo1_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_repsFromTo1, "repsFromTo1", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_repsFromTo1_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_repsFromTo1_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_repsFromTo1_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_repsFromTo1_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject repsFromTo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.repsFromTo1",
	.tp_getset = py_repsFromTo1_getsetters,
	.tp_methods = py_repsFromTo1_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_repsFromTo1_new,
};


static PyObject *py_repsFromTo2OtherInfo_get___ndr_size(PyObject *obj, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_repsFromTo2OtherInfo_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2OtherInfo_get_dns_name1(PyObject *obj, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name1;
	if (object->dns_name1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_name1 == NULL) {
		py_dns_name1 = Py_None;
		Py_INCREF(py_dns_name1);
	} else {
		py_dns_name1 = PyString_FromStringOrNULL(object->dns_name1);
	}
	return py_dns_name1;
}

static int py_repsFromTo2OtherInfo_set_dns_name1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dns_name1");
		return -1;
	}
	if (value == Py_None) {
		object->dns_name1 = NULL;
	} else {
		object->dns_name1 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_name1 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2OtherInfo_get_unknown1(PyObject *obj, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown1));
	return py_unknown1;
}

static int py_repsFromTo2OtherInfo_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2OtherInfo_get_dns_name2(PyObject *obj, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name2;
	if (object->dns_name2 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_name2 == NULL) {
		py_dns_name2 = Py_None;
		Py_INCREF(py_dns_name2);
	} else {
		py_dns_name2 = PyString_FromStringOrNULL(object->dns_name2);
	}
	return py_dns_name2;
}

static int py_repsFromTo2OtherInfo_set_dns_name2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dns_name2");
		return -1;
	}
	if (value == Py_None) {
		object->dns_name2 = NULL;
	} else {
		object->dns_name2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_name2 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2OtherInfo_get_unknown2(PyObject *obj, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong(object->unknown2);
	return py_unknown2;
}

static int py_repsFromTo2OtherInfo_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_repsFromTo2OtherInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_repsFromTo2OtherInfo_get___ndr_size,
		.set = py_repsFromTo2OtherInfo_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dns_name1"),
		.get = py_repsFromTo2OtherInfo_get_dns_name1,
		.set = py_repsFromTo2OtherInfo_set_dns_name1,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_repsFromTo2OtherInfo_get_unknown1,
		.set = py_repsFromTo2OtherInfo_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dns_name2"),
		.get = py_repsFromTo2OtherInfo_get_dns_name2,
		.set = py_repsFromTo2OtherInfo_set_dns_name2,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_repsFromTo2OtherInfo_get_unknown2,
		.set = py_repsFromTo2OtherInfo_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_repsFromTo2OtherInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct repsFromTo2OtherInfo, type);
}

static PyObject *py_repsFromTo2OtherInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_repsFromTo2OtherInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_repsFromTo2OtherInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo2OtherInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo2OtherInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_repsFromTo2OtherInfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo2OtherInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_repsFromTo2OtherInfo, "repsFromTo2OtherInfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_repsFromTo2OtherInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_repsFromTo2OtherInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_repsFromTo2OtherInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_repsFromTo2OtherInfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject repsFromTo2OtherInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.repsFromTo2OtherInfo",
	.tp_getset = py_repsFromTo2OtherInfo_getsetters,
	.tp_methods = py_repsFromTo2OtherInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_repsFromTo2OtherInfo_new,
};


static PyObject *py_repsFromTo2_get_blobsize(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_blobsize;
	py_blobsize = PyLong_FromUnsignedLongLong((uint32_t)(object->blobsize));
	return py_blobsize;
}

static int py_repsFromTo2_set_blobsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->blobsize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->blobsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->blobsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_consecutive_sync_failures(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_consecutive_sync_failures;
	py_consecutive_sync_failures = PyLong_FromUnsignedLongLong((uint32_t)(object->consecutive_sync_failures));
	return py_consecutive_sync_failures;
}

static int py_repsFromTo2_set_consecutive_sync_failures(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->consecutive_sync_failures");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->consecutive_sync_failures));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->consecutive_sync_failures = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_last_success(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_success;
	py_last_success = PyLong_FromUnsignedLongLong(object->last_success);
	return py_last_success;
}

static int py_repsFromTo2_set_last_success(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->last_success");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_success));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_success = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_last_attempt(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_attempt;
	py_last_attempt = PyLong_FromUnsignedLongLong(object->last_attempt);
	return py_last_attempt;
}

static int py_repsFromTo2_set_last_attempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->last_attempt");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_attempt));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_attempt = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_result_last_attempt(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_result_last_attempt;
	py_result_last_attempt = PyErr_FromWERROR(object->result_last_attempt);
	return py_result_last_attempt;
}

static int py_repsFromTo2_set_result_last_attempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->result_last_attempt");
		return -1;
	}
	object->result_last_attempt = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_repsFromTo2_get_other_info(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_other_info;
	if (object->other_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->other_info == NULL) {
		py_other_info = Py_None;
		Py_INCREF(py_other_info);
	} else {
		py_other_info = pytalloc_reference_ex(&repsFromTo2OtherInfo_Type, object->other_info, object->other_info);
	}
	return py_other_info;
}

static int py_repsFromTo2_set_other_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->other_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_info");
		return -1;
	}
	if (value == Py_None) {
		object->other_info = NULL;
	} else {
		object->other_info = NULL;
		PY_CHECK_TYPE(&repsFromTo2OtherInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->other_info = (struct repsFromTo2OtherInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_other_info_length(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_other_info_length;
	py_other_info_length = PyLong_FromUnsignedLongLong((uint32_t)(object->other_info_length));
	return py_other_info_length;
}

static int py_repsFromTo2_set_other_info_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_info_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->other_info_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->other_info_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_replica_flags(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_replica_flags;
	py_replica_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->replica_flags));
	return py_replica_flags;
}

static int py_repsFromTo2_set_replica_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->replica_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->replica_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->replica_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_schedule(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_schedule;
	py_schedule = PyList_New(84);
	if (py_schedule == NULL) {
		return NULL;
	}
	{
		int schedule_cntr_0;
		for (schedule_cntr_0 = 0; schedule_cntr_0 < (84); schedule_cntr_0++) {
			PyObject *py_schedule_0;
			py_schedule_0 = PyLong_FromLong((uint16_t)((object->schedule)[schedule_cntr_0]));
			PyList_SetItem(py_schedule, schedule_cntr_0, py_schedule_0);
		}
	}
	return py_schedule;
}

static int py_repsFromTo2_set_schedule(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->schedule");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int schedule_cntr_0;
		if (ARRAY_SIZE(object->schedule) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->schedule),  PyList_GET_SIZE(value));
			return -1;
		}
		for (schedule_cntr_0 = 0; schedule_cntr_0 < PyList_GET_SIZE(value); schedule_cntr_0++) {
			if (PyList_GET_ITEM(value, schedule_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->schedule)[schedule_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->schedule)[schedule_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, schedule_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, schedule_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->schedule)[schedule_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_reserved(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_repsFromTo2_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromTo2_get_highwatermark(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_highwatermark;
	py_highwatermark = pytalloc_reference_ex(drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->highwatermark);
	return py_highwatermark;
}

static int py_repsFromTo2_set_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_repsFromTo2_get_source_dsa_obj_guid(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_obj_guid;
	py_source_dsa_obj_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_obj_guid);
	return py_source_dsa_obj_guid;
}

static int py_repsFromTo2_set_source_dsa_obj_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->source_dsa_obj_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_obj_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_repsFromTo2_get_source_dsa_invocation_id(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_source_dsa_invocation_id;
	py_source_dsa_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->source_dsa_invocation_id);
	return py_source_dsa_invocation_id;
}

static int py_repsFromTo2_set_source_dsa_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->source_dsa_invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_dsa_invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_repsFromTo2_get_transport_guid(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_guid;
	py_transport_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->transport_guid);
	return py_transport_guid;
}

static int py_repsFromTo2_set_transport_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->transport_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->transport_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_repsFromTo2_get_unknown1(PyObject *obj, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong(object->unknown1);
	return py_unknown1;
}

static int py_repsFromTo2_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_repsFromTo2_getsetters[] = {
	{
		.name = discard_const_p(char, "blobsize"),
		.get = py_repsFromTo2_get_blobsize,
		.set = py_repsFromTo2_set_blobsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "consecutive_sync_failures"),
		.get = py_repsFromTo2_get_consecutive_sync_failures,
		.set = py_repsFromTo2_set_consecutive_sync_failures,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "last_success"),
		.get = py_repsFromTo2_get_last_success,
		.set = py_repsFromTo2_set_last_success,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_1sec")
	},
	{
		.name = discard_const_p(char, "last_attempt"),
		.get = py_repsFromTo2_get_last_attempt,
		.set = py_repsFromTo2_set_last_attempt,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_1sec")
	},
	{
		.name = discard_const_p(char, "result_last_attempt"),
		.get = py_repsFromTo2_get_result_last_attempt,
		.set = py_repsFromTo2_set_result_last_attempt,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "other_info"),
		.get = py_repsFromTo2_get_other_info,
		.set = py_repsFromTo2_set_other_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type repsFromTo2OtherInfo")
	},
	{
		.name = discard_const_p(char, "other_info_length"),
		.get = py_repsFromTo2_get_other_info_length,
		.set = py_repsFromTo2_set_other_info_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "replica_flags"),
		.get = py_repsFromTo2_get_replica_flags,
		.set = py_repsFromTo2_set_replica_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DrsOptions")
	},
	{
		.name = discard_const_p(char, "schedule"),
		.get = py_repsFromTo2_get_schedule,
		.set = py_repsFromTo2_set_schedule,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_repsFromTo2_get_reserved,
		.set = py_repsFromTo2_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "highwatermark"),
		.get = py_repsFromTo2_get_highwatermark,
		.set = py_repsFromTo2_set_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "source_dsa_obj_guid"),
		.get = py_repsFromTo2_get_source_dsa_obj_guid,
		.set = py_repsFromTo2_set_source_dsa_obj_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "source_dsa_invocation_id"),
		.get = py_repsFromTo2_get_source_dsa_invocation_id,
		.set = py_repsFromTo2_set_source_dsa_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "transport_guid"),
		.get = py_repsFromTo2_get_transport_guid,
		.set = py_repsFromTo2_set_transport_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_repsFromTo2_get_unknown1,
		.set = py_repsFromTo2_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_repsFromTo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct repsFromTo2, type);
}

static PyObject *py_repsFromTo2_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_repsFromTo2);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_repsFromTo2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromTo2);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_repsFromTo2_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct repsFromTo2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_repsFromTo2, "repsFromTo2", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_repsFromTo2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_repsFromTo2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_repsFromTo2_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_repsFromTo2_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject repsFromTo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.repsFromTo2",
	.tp_getset = py_repsFromTo2_getsetters,
	.tp_methods = py_repsFromTo2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_repsFromTo2_new,
};

static PyObject *py_import_repsFromTo(TALLOC_CTX *mem_ctx, int level, union repsFromTo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&repsFromTo1_Type, mem_ctx, &in->ctr1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&repsFromTo2_Type, mem_ctx, &in->ctr2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union repsFromTo *py_export_repsFromTo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union repsFromTo *ret = talloc_zero(mem_ctx, union repsFromTo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&repsFromTo1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct repsFromTo1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&repsFromTo2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr2 = *(struct repsFromTo2 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_repsFromTo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union repsFromTo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union repsFromTo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union repsFromTo!");
		return NULL;
	}

	return py_import_repsFromTo(mem_ctx, level, in);
}

static PyObject *py_repsFromTo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union repsFromTo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_repsFromTo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_repsFromTo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_repsFromTo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_repsFromTo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_repsFromTo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject repsFromTo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.repsFromTo",
	.tp_getset = NULL,
	.tp_methods = py_repsFromTo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_repsFromTo_new,
};


static PyObject *py_repsFromToBlob_get_version(PyObject *obj, void *closure)
{
	struct repsFromToBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_repsFromToBlob_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromToBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromToBlob_get_reserved(PyObject *obj, void *closure)
{
	struct repsFromToBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_repsFromToBlob_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromToBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_repsFromToBlob_get_ctr(PyObject *obj, void *closure)
{
	struct repsFromToBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&repsFromTo_Type, pytalloc_get_mem_ctx(obj), object->version, &object->ctr, "union repsFromTo");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_repsFromToBlob_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct repsFromToBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union repsFromTo *ctr_switch_0;
		ctr_switch_0 = (union repsFromTo *)pyrpc_export_union(&repsFromTo_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union repsFromTo");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_repsFromToBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_repsFromToBlob_get_version,
		.set = py_repsFromToBlob_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_repsFromToBlob_get_reserved,
		.set = py_repsFromToBlob_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_repsFromToBlob_get_ctr,
		.set = py_repsFromToBlob_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type repsFromTo")
	},
	{ .name = NULL }
};

static PyObject *py_repsFromToBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct repsFromToBlob, type);
}

static PyObject *py_repsFromToBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct repsFromToBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_repsFromToBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_repsFromToBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct repsFromToBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromToBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_repsFromToBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_repsFromToBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct repsFromToBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_repsFromToBlob, "repsFromToBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_repsFromToBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_repsFromToBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_repsFromToBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_repsFromToBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject repsFromToBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.repsFromToBlob",
	.tp_getset = py_repsFromToBlob_getsetters,
	.tp_methods = py_repsFromToBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_repsFromToBlob_new,
};


static PyObject *py_scheduleHeader_get_type(PyObject *obj, void *closure)
{
	struct scheduleHeader *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_scheduleHeader_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct scheduleHeader *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_scheduleHeader_get_offset(PyObject *obj, void *closure)
{
	struct scheduleHeader *object = pytalloc_get_ptr(obj);
	PyObject *py_offset;
	py_offset = PyLong_FromUnsignedLongLong((uint32_t)(object->offset));
	return py_offset;
}

static int py_scheduleHeader_set_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct scheduleHeader *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_scheduleHeader_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_scheduleHeader_get_type,
		.set = py_scheduleHeader_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "offset"),
		.get = py_scheduleHeader_get_offset,
		.set = py_scheduleHeader_set_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_scheduleHeader_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct scheduleHeader, type);
}

static PyObject *py_scheduleHeader_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct scheduleHeader *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_scheduleHeader);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_scheduleHeader_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct scheduleHeader *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_scheduleHeader);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_scheduleHeader);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_scheduleHeader_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct scheduleHeader *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_scheduleHeader, "scheduleHeader", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_scheduleHeader_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_scheduleHeader_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_scheduleHeader_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_scheduleHeader_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject scheduleHeader_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.scheduleHeader",
	.tp_getset = py_scheduleHeader_getsetters,
	.tp_methods = py_scheduleHeader_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_scheduleHeader_new,
};


static PyObject *py_scheduleSlots_get_slots(PyObject *obj, void *closure)
{
	struct scheduleSlots *object = pytalloc_get_ptr(obj);
	PyObject *py_slots;
	py_slots = PyList_New(168);
	if (py_slots == NULL) {
		return NULL;
	}
	{
		int slots_cntr_0;
		for (slots_cntr_0 = 0; slots_cntr_0 < (168); slots_cntr_0++) {
			PyObject *py_slots_0;
			py_slots_0 = PyLong_FromLong((uint16_t)((object->slots)[slots_cntr_0]));
			PyList_SetItem(py_slots, slots_cntr_0, py_slots_0);
		}
	}
	return py_slots;
}

static int py_scheduleSlots_set_slots(PyObject *py_obj, PyObject *value, void *closure)
{
	struct scheduleSlots *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->slots");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int slots_cntr_0;
		if (ARRAY_SIZE(object->slots) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->slots),  PyList_GET_SIZE(value));
			return -1;
		}
		for (slots_cntr_0 = 0; slots_cntr_0 < PyList_GET_SIZE(value); slots_cntr_0++) {
			if (PyList_GET_ITEM(value, slots_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->slots)[slots_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->slots)[slots_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, slots_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, slots_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->slots)[slots_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_scheduleSlots_getsetters[] = {
	{
		.name = discard_const_p(char, "slots"),
		.get = py_scheduleSlots_get_slots,
		.set = py_scheduleSlots_set_slots,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_scheduleSlots_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct scheduleSlots, type);
}

static PyObject *py_scheduleSlots_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct scheduleSlots *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_scheduleSlots);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_scheduleSlots_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct scheduleSlots *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_scheduleSlots);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_scheduleSlots);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_scheduleSlots_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct scheduleSlots *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_scheduleSlots, "scheduleSlots", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_scheduleSlots_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_scheduleSlots_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_scheduleSlots_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_scheduleSlots_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject scheduleSlots_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.scheduleSlots",
	.tp_getset = py_scheduleSlots_getsetters,
	.tp_methods = py_scheduleSlots_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_scheduleSlots_new,
};


static PyObject *py_schedule_get_size(PyObject *obj, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_schedule_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_schedule_get_bandwidth(PyObject *obj, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(obj);
	PyObject *py_bandwidth;
	py_bandwidth = PyLong_FromUnsignedLongLong((uint32_t)(object->bandwidth));
	return py_bandwidth;
}

static int py_schedule_set_bandwidth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->bandwidth");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bandwidth));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bandwidth = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_schedule_get_numberOfSchedules(PyObject *obj, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(obj);
	PyObject *py_numberOfSchedules;
	py_numberOfSchedules = PyLong_FromUnsignedLongLong((uint32_t)(object->numberOfSchedules));
	return py_numberOfSchedules;
}

static int py_schedule_set_numberOfSchedules(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->numberOfSchedules");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numberOfSchedules));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numberOfSchedules = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_schedule_get_headerArray(PyObject *obj, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(obj);
	PyObject *py_headerArray;
	py_headerArray = PyList_New(object->numberOfSchedules);
	if (py_headerArray == NULL) {
		return NULL;
	}
	{
		int headerArray_cntr_0;
		for (headerArray_cntr_0 = 0; headerArray_cntr_0 < (object->numberOfSchedules); headerArray_cntr_0++) {
			PyObject *py_headerArray_0;
			py_headerArray_0 = pytalloc_reference_ex(&scheduleHeader_Type, object->headerArray, &(object->headerArray)[headerArray_cntr_0]);
			PyList_SetItem(py_headerArray, headerArray_cntr_0, py_headerArray_0);
		}
	}
	return py_headerArray;
}

static int py_schedule_set_headerArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->headerArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int headerArray_cntr_0;
		object->headerArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->headerArray, PyList_GET_SIZE(value));
		if (!object->headerArray) { return -1; }
		talloc_set_name_const(object->headerArray, "ARRAY: object->headerArray");
		for (headerArray_cntr_0 = 0; headerArray_cntr_0 < PyList_GET_SIZE(value); headerArray_cntr_0++) {
			if (PyList_GET_ITEM(value, headerArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->headerArray)[headerArray_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&scheduleHeader_Type, PyList_GET_ITEM(value, headerArray_cntr_0), return -1;);
			if (talloc_reference(object->headerArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, headerArray_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->headerArray)[headerArray_cntr_0] = *(struct scheduleHeader *)pytalloc_get_ptr(PyList_GET_ITEM(value, headerArray_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_schedule_get_dataArray(PyObject *obj, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(obj);
	PyObject *py_dataArray;
	py_dataArray = PyList_New(object->numberOfSchedules);
	if (py_dataArray == NULL) {
		return NULL;
	}
	{
		int dataArray_cntr_0;
		for (dataArray_cntr_0 = 0; dataArray_cntr_0 < (object->numberOfSchedules); dataArray_cntr_0++) {
			PyObject *py_dataArray_0;
			py_dataArray_0 = pytalloc_reference_ex(&scheduleSlots_Type, object->dataArray, &(object->dataArray)[dataArray_cntr_0]);
			PyList_SetItem(py_dataArray, dataArray_cntr_0, py_dataArray_0);
		}
	}
	return py_dataArray;
}

static int py_schedule_set_dataArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dataArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dataArray_cntr_0;
		object->dataArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->dataArray, PyList_GET_SIZE(value));
		if (!object->dataArray) { return -1; }
		talloc_set_name_const(object->dataArray, "ARRAY: object->dataArray");
		for (dataArray_cntr_0 = 0; dataArray_cntr_0 < PyList_GET_SIZE(value); dataArray_cntr_0++) {
			if (PyList_GET_ITEM(value, dataArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->dataArray)[dataArray_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&scheduleSlots_Type, PyList_GET_ITEM(value, dataArray_cntr_0), return -1;);
			if (talloc_reference(object->dataArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, dataArray_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->dataArray)[dataArray_cntr_0] = *(struct scheduleSlots *)pytalloc_get_ptr(PyList_GET_ITEM(value, dataArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_schedule_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_schedule_get_size,
		.set = py_schedule_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bandwidth"),
		.get = py_schedule_get_bandwidth,
		.set = py_schedule_set_bandwidth,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numberOfSchedules"),
		.get = py_schedule_get_numberOfSchedules,
		.set = py_schedule_set_numberOfSchedules,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "headerArray"),
		.get = py_schedule_get_headerArray,
		.set = py_schedule_set_headerArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type scheduleHeader")
	},
	{
		.name = discard_const_p(char, "dataArray"),
		.get = py_schedule_get_dataArray,
		.set = py_schedule_set_dataArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type scheduleSlots")
	},
	{ .name = NULL }
};

static PyObject *py_schedule_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct schedule, type);
}

static PyObject *py_schedule_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_schedule);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_schedule_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_schedule);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_schedule);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_schedule_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct schedule *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_schedule, "schedule", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_schedule_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_schedule_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_schedule_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_schedule_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject schedule_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.schedule",
	.tp_getset = py_schedule_getsetters,
	.tp_methods = py_schedule_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_schedule_new,
};


static PyObject *py_partialAttributeSetCtr1_get_count(PyObject *obj, void *closure)
{
	struct partialAttributeSetCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_partialAttributeSetCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct partialAttributeSetCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_partialAttributeSetCtr1_get_array(PyObject *obj, void *closure)
{
	struct partialAttributeSetCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->array)[array_cntr_0]));
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_partialAttributeSetCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct partialAttributeSetCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->array)[array_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, array_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, array_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->array)[array_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_partialAttributeSetCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_partialAttributeSetCtr1_get_count,
		.set = py_partialAttributeSetCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_partialAttributeSetCtr1_get_array,
		.set = py_partialAttributeSetCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsAttributeId")
	},
	{ .name = NULL }
};

static PyObject *py_partialAttributeSetCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct partialAttributeSetCtr1, type);
}


static PyTypeObject partialAttributeSetCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.partialAttributeSetCtr1",
	.tp_getset = py_partialAttributeSetCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_partialAttributeSetCtr1_new,
};

static PyObject *py_import_partialAttributeSetCtr(TALLOC_CTX *mem_ctx, int level, union partialAttributeSetCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&partialAttributeSetCtr1_Type, mem_ctx, &in->ctr1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union partialAttributeSetCtr *py_export_partialAttributeSetCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union partialAttributeSetCtr *ret = talloc_zero(mem_ctx, union partialAttributeSetCtr);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&partialAttributeSetCtr1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct partialAttributeSetCtr1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_partialAttributeSetCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union partialAttributeSetCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union partialAttributeSetCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union partialAttributeSetCtr!");
		return NULL;
	}

	return py_import_partialAttributeSetCtr(mem_ctx, level, in);
}

static PyObject *py_partialAttributeSetCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union partialAttributeSetCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_partialAttributeSetCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_partialAttributeSetCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_partialAttributeSetCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_partialAttributeSetCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_partialAttributeSetCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject partialAttributeSetCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.partialAttributeSetCtr",
	.tp_getset = NULL,
	.tp_methods = py_partialAttributeSetCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_partialAttributeSetCtr_new,
};


static PyObject *py_partialAttributeSetBlob_get_version(PyObject *obj, void *closure)
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_partialAttributeSetBlob_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_partialAttributeSetBlob_get_reserved(PyObject *obj, void *closure)
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_partialAttributeSetBlob_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_partialAttributeSetBlob_get_ctr(PyObject *obj, void *closure)
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&partialAttributeSetCtr_Type, pytalloc_get_mem_ctx(obj), object->version, &object->ctr, "union partialAttributeSetCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_partialAttributeSetBlob_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union partialAttributeSetCtr *ctr_switch_0;
		ctr_switch_0 = (union partialAttributeSetCtr *)pyrpc_export_union(&partialAttributeSetCtr_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union partialAttributeSetCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_partialAttributeSetBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_partialAttributeSetBlob_get_version,
		.set = py_partialAttributeSetBlob_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_partialAttributeSetBlob_get_reserved,
		.set = py_partialAttributeSetBlob_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_partialAttributeSetBlob_get_ctr,
		.set = py_partialAttributeSetBlob_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type partialAttributeSetCtr")
	},
	{ .name = NULL }
};

static PyObject *py_partialAttributeSetBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct partialAttributeSetBlob, type);
}

static PyObject *py_partialAttributeSetBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_partialAttributeSetBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_partialAttributeSetBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_partialAttributeSetBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_partialAttributeSetBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_partialAttributeSetBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct partialAttributeSetBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_partialAttributeSetBlob, "partialAttributeSetBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_partialAttributeSetBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_partialAttributeSetBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_partialAttributeSetBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_partialAttributeSetBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject partialAttributeSetBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.partialAttributeSetBlob",
	.tp_getset = py_partialAttributeSetBlob_getsetters,
	.tp_methods = py_partialAttributeSetBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_partialAttributeSetBlob_new,
};


static PyObject *py_schemaInfoBlob_get_marker(PyObject *obj, void *closure)
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_marker;
	py_marker = PyLong_FromLong((uint16_t)(object->marker));
	return py_marker;
}

static int py_schemaInfoBlob_set_marker(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->marker");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->marker));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->marker = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_schemaInfoBlob_get_revision(PyObject *obj, void *closure)
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_revision;
	py_revision = PyLong_FromUnsignedLongLong((uint32_t)(object->revision));
	return py_revision;
}

static int py_schemaInfoBlob_set_revision(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->revision");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->revision));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->revision = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_schemaInfoBlob_get_invocation_id(PyObject *obj, void *closure)
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_invocation_id;
	py_invocation_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->invocation_id);
	return py_invocation_id;
}

static int py_schemaInfoBlob_set_invocation_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->invocation_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->invocation_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_schemaInfoBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "marker"),
		.get = py_schemaInfoBlob_get_marker,
		.set = py_schemaInfoBlob_set_marker,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "revision"),
		.get = py_schemaInfoBlob_get_revision,
		.set = py_schemaInfoBlob_set_revision,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "invocation_id"),
		.get = py_schemaInfoBlob_get_invocation_id,
		.set = py_schemaInfoBlob_set_invocation_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_schemaInfoBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct schemaInfoBlob, type);
}

static PyObject *py_schemaInfoBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_schemaInfoBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_schemaInfoBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_schemaInfoBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_schemaInfoBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_schemaInfoBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct schemaInfoBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_schemaInfoBlob, "schemaInfoBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_schemaInfoBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_schemaInfoBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_schemaInfoBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_schemaInfoBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject schemaInfoBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.schemaInfoBlob",
	.tp_getset = py_schemaInfoBlob_getsetters,
	.tp_methods = py_schemaInfoBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_schemaInfoBlob_new,
};


static PyObject *py_drsuapi_MSPrefixMap_Entry_get_entryID(PyObject *obj, void *closure)
{
	struct drsuapi_MSPrefixMap_Entry *object = pytalloc_get_ptr(obj);
	PyObject *py_entryID;
	py_entryID = PyLong_FromLong((uint16_t)(object->entryID));
	return py_entryID;
}

static int py_drsuapi_MSPrefixMap_Entry_set_entryID(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_MSPrefixMap_Entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entryID");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->entryID));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->entryID = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_MSPrefixMap_Entry_get_length(PyObject *obj, void *closure)
{
	struct drsuapi_MSPrefixMap_Entry *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_drsuapi_MSPrefixMap_Entry_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_MSPrefixMap_Entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_MSPrefixMap_Entry_get_binary_oid(PyObject *obj, void *closure)
{
	struct drsuapi_MSPrefixMap_Entry *object = pytalloc_get_ptr(obj);
	PyObject *py_binary_oid;
	py_binary_oid = PyList_New(object->length);
	if (py_binary_oid == NULL) {
		return NULL;
	}
	{
		int binary_oid_cntr_0;
		for (binary_oid_cntr_0 = 0; binary_oid_cntr_0 < (object->length); binary_oid_cntr_0++) {
			PyObject *py_binary_oid_0;
			py_binary_oid_0 = PyLong_FromLong((uint16_t)((object->binary_oid)[binary_oid_cntr_0]));
			PyList_SetItem(py_binary_oid, binary_oid_cntr_0, py_binary_oid_0);
		}
	}
	return py_binary_oid;
}

static int py_drsuapi_MSPrefixMap_Entry_set_binary_oid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_MSPrefixMap_Entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->binary_oid");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int binary_oid_cntr_0;
		object->binary_oid = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->binary_oid, PyList_GET_SIZE(value));
		if (!object->binary_oid) { return -1; }
		talloc_set_name_const(object->binary_oid, "ARRAY: object->binary_oid");
		for (binary_oid_cntr_0 = 0; binary_oid_cntr_0 < PyList_GET_SIZE(value); binary_oid_cntr_0++) {
			if (PyList_GET_ITEM(value, binary_oid_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->binary_oid)[binary_oid_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->binary_oid)[binary_oid_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, binary_oid_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, binary_oid_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->binary_oid)[binary_oid_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_MSPrefixMap_Entry_getsetters[] = {
	{
		.name = discard_const_p(char, "entryID"),
		.get = py_drsuapi_MSPrefixMap_Entry_get_entryID,
		.set = py_drsuapi_MSPrefixMap_Entry_set_entryID,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "length"),
		.get = py_drsuapi_MSPrefixMap_Entry_get_length,
		.set = py_drsuapi_MSPrefixMap_Entry_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "binary_oid"),
		.get = py_drsuapi_MSPrefixMap_Entry_get_binary_oid,
		.set = py_drsuapi_MSPrefixMap_Entry_set_binary_oid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_MSPrefixMap_Entry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_MSPrefixMap_Entry, type);
}


static PyTypeObject drsuapi_MSPrefixMap_Entry_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.drsuapi_MSPrefixMap_Entry",
	.tp_getset = py_drsuapi_MSPrefixMap_Entry_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_MSPrefixMap_Entry_new,
};


static PyObject *py_drsuapi_MSPrefixMap_Ctr_get_num_entries(PyObject *obj, void *closure)
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(object->num_entries));
	return py_num_entries;
}

static int py_drsuapi_MSPrefixMap_Ctr_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_entries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_MSPrefixMap_Ctr_get___ndr_size(PyObject *obj, void *closure)
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_drsuapi_MSPrefixMap_Ctr_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drsuapi_MSPrefixMap_Ctr_get_entries(PyObject *obj, void *closure)
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyList_New(object->num_entries);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < (object->num_entries); entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&drsuapi_MSPrefixMap_Entry_Type, object->entries, &(object->entries)[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	return py_entries;
}

static int py_drsuapi_MSPrefixMap_Ctr_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int entries_cntr_0;
		object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
		if (!object->entries) { return -1; }
		talloc_set_name_const(object->entries, "ARRAY: object->entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(value); entries_cntr_0++) {
			if (PyList_GET_ITEM(value, entries_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->entries)[entries_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&drsuapi_MSPrefixMap_Entry_Type, PyList_GET_ITEM(value, entries_cntr_0), return -1;);
			if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->entries)[entries_cntr_0] = *(struct drsuapi_MSPrefixMap_Entry *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_drsuapi_MSPrefixMap_Ctr_getsetters[] = {
	{
		.name = discard_const_p(char, "num_entries"),
		.get = py_drsuapi_MSPrefixMap_Ctr_get_num_entries,
		.set = py_drsuapi_MSPrefixMap_Ctr_set_num_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_drsuapi_MSPrefixMap_Ctr_get___ndr_size,
		.set = py_drsuapi_MSPrefixMap_Ctr_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_drsuapi_MSPrefixMap_Ctr_get_entries,
		.set = py_drsuapi_MSPrefixMap_Ctr_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_MSPrefixMap_Entry")
	},
	{ .name = NULL }
};

static PyObject *py_drsuapi_MSPrefixMap_Ctr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct drsuapi_MSPrefixMap_Ctr, type);
}

static PyObject *py_drsuapi_MSPrefixMap_Ctr_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_drsuapi_MSPrefixMap_Ctr);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_drsuapi_MSPrefixMap_Ctr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_MSPrefixMap_Ctr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_drsuapi_MSPrefixMap_Ctr);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_drsuapi_MSPrefixMap_Ctr_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct drsuapi_MSPrefixMap_Ctr *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_drsuapi_MSPrefixMap_Ctr, "drsuapi_MSPrefixMap_Ctr", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_drsuapi_MSPrefixMap_Ctr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_drsuapi_MSPrefixMap_Ctr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drsuapi_MSPrefixMap_Ctr_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_drsuapi_MSPrefixMap_Ctr_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drsuapi_MSPrefixMap_Ctr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.drsuapi_MSPrefixMap_Ctr",
	.tp_getset = py_drsuapi_MSPrefixMap_Ctr_getsetters,
	.tp_methods = py_drsuapi_MSPrefixMap_Ctr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drsuapi_MSPrefixMap_Ctr_new,
};

static PyObject *py_import_prefixMapCtr(TALLOC_CTX *mem_ctx, int level, union prefixMapCtr *in)
{
	PyObject *ret;

	switch (level) {
		case PREFIX_MAP_VERSION_DSDB:
			ret = pytalloc_reference_ex(drsuapi_DsReplicaOIDMapping_Ctr_Type, mem_ctx, &in->dsdb);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union prefixMapCtr *py_export_prefixMapCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union prefixMapCtr *ret = talloc_zero(mem_ctx, union prefixMapCtr);
	switch (level) {
		case PREFIX_MAP_VERSION_DSDB:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->dsdb");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(drsuapi_DsReplicaOIDMapping_Ctr_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dsdb = *(struct drsuapi_DsReplicaOIDMapping_Ctr *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_prefixMapCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union prefixMapCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union prefixMapCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union prefixMapCtr!");
		return NULL;
	}

	return py_import_prefixMapCtr(mem_ctx, level, in);
}

static PyObject *py_prefixMapCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union prefixMapCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_prefixMapCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_prefixMapCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_prefixMapCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_prefixMapCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_prefixMapCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject prefixMapCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.prefixMapCtr",
	.tp_getset = NULL,
	.tp_methods = py_prefixMapCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_prefixMapCtr_new,
};


static PyObject *py_prefixMapBlob_get_version(PyObject *obj, void *closure)
{
	struct prefixMapBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_prefixMapBlob_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct prefixMapBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_prefixMapBlob_get_reserved(PyObject *obj, void *closure)
{
	struct prefixMapBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_prefixMapBlob_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct prefixMapBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_prefixMapBlob_get_ctr(PyObject *obj, void *closure)
{
	struct prefixMapBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&prefixMapCtr_Type, pytalloc_get_mem_ctx(obj), object->version, &object->ctr, "union prefixMapCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_prefixMapBlob_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct prefixMapBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union prefixMapCtr *ctr_switch_0;
		ctr_switch_0 = (union prefixMapCtr *)pyrpc_export_union(&prefixMapCtr_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union prefixMapCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_prefixMapBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_prefixMapBlob_get_version,
		.set = py_prefixMapBlob_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type prefixMapVersion")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_prefixMapBlob_get_reserved,
		.set = py_prefixMapBlob_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_prefixMapBlob_get_ctr,
		.set = py_prefixMapBlob_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type prefixMapCtr")
	},
	{ .name = NULL }
};

static PyObject *py_prefixMapBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct prefixMapBlob, type);
}

static PyObject *py_prefixMapBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct prefixMapBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_prefixMapBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_prefixMapBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct prefixMapBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_prefixMapBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_prefixMapBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_prefixMapBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct prefixMapBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_prefixMapBlob, "prefixMapBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_prefixMapBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_prefixMapBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_prefixMapBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_prefixMapBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject prefixMapBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.prefixMapBlob",
	.tp_getset = py_prefixMapBlob_getsetters,
	.tp_methods = py_prefixMapBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_prefixMapBlob_new,
};

static PyObject *py_import_ldapControlDirSyncExtra(TALLOC_CTX *mem_ctx, int level, union ldapControlDirSyncExtra *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		default:
			ret = pytalloc_reference_ex(&replUpToDateVectorBlob_Type, mem_ctx, &in->uptodateness_vector);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ldapControlDirSyncExtra *py_export_ldapControlDirSyncExtra(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ldapControlDirSyncExtra *ret = talloc_zero(mem_ctx, union ldapControlDirSyncExtra);
	switch (level) {
		case 0:
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->uptodateness_vector");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&replUpToDateVectorBlob_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->uptodateness_vector = *(struct replUpToDateVectorBlob *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_ldapControlDirSyncExtra_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ldapControlDirSyncExtra *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ldapControlDirSyncExtra *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ldapControlDirSyncExtra!");
		return NULL;
	}

	return py_import_ldapControlDirSyncExtra(mem_ctx, level, in);
}

static PyObject *py_ldapControlDirSyncExtra_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ldapControlDirSyncExtra *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ldapControlDirSyncExtra(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ldapControlDirSyncExtra_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ldapControlDirSyncExtra_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ldapControlDirSyncExtra_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ldapControlDirSyncExtra_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ldapControlDirSyncExtra_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ldapControlDirSyncExtra",
	.tp_getset = NULL,
	.tp_methods = py_ldapControlDirSyncExtra_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ldapControlDirSyncExtra_new,
};


static PyObject *py_ldapControlDirSyncBlob_get_u1(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_u1;
	py_u1 = PyLong_FromUnsignedLongLong((uint32_t)(object->u1));
	return py_u1;
}

static int py_ldapControlDirSyncBlob_set_u1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->u1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->u1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->u1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ldapControlDirSyncBlob_get_time(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong(object->time);
	return py_time;
}

static int py_ldapControlDirSyncBlob_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ldapControlDirSyncBlob_get_u2(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_u2;
	py_u2 = PyLong_FromUnsignedLongLong((uint32_t)(object->u2));
	return py_u2;
}

static int py_ldapControlDirSyncBlob_set_u2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->u2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->u2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->u2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ldapControlDirSyncBlob_get_u3(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_u3;
	py_u3 = PyLong_FromUnsignedLongLong((uint32_t)(object->u3));
	return py_u3;
}

static int py_ldapControlDirSyncBlob_set_u3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->u3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->u3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->u3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ldapControlDirSyncBlob_get_extra_length(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_extra_length;
	py_extra_length = PyLong_FromUnsignedLongLong((uint32_t)(object->extra_length));
	return py_extra_length;
}

static int py_ldapControlDirSyncBlob_set_extra_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->extra_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extra_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extra_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ldapControlDirSyncBlob_get_highwatermark(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_highwatermark;
	py_highwatermark = pytalloc_reference_ex(drsuapi_DsReplicaHighWaterMark_Type, pytalloc_get_mem_ctx(obj), &object->highwatermark);
	return py_highwatermark;
}

static int py_ldapControlDirSyncBlob_set_highwatermark(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->highwatermark");
		return -1;
	}
	PY_CHECK_TYPE(drsuapi_DsReplicaHighWaterMark_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->highwatermark = *(struct drsuapi_DsReplicaHighWaterMark *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ldapControlDirSyncBlob_get_guid1(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_guid1;
	py_guid1 = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid1);
	return py_guid1;
}

static int py_ldapControlDirSyncBlob_set_guid1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->guid1");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid1 = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ldapControlDirSyncBlob_get_extra(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_extra;
	py_extra = pyrpc_import_union(&ldapControlDirSyncExtra_Type, pytalloc_get_mem_ctx(obj), object->extra_length, &object->extra, "union ldapControlDirSyncExtra");
	if (py_extra == NULL) {
		return NULL;
	}
	return py_extra;
}

static int py_ldapControlDirSyncBlob_set_extra(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->extra");
		return -1;
	}
	{
		union ldapControlDirSyncExtra *extra_switch_0;
		extra_switch_0 = (union ldapControlDirSyncExtra *)pyrpc_export_union(&ldapControlDirSyncExtra_Type, pytalloc_get_mem_ctx(py_obj), object->extra_length, value, "union ldapControlDirSyncExtra");
		if (extra_switch_0 == NULL) {
			return -1;
		}
		object->extra = *extra_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ldapControlDirSyncBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "u1"),
		.get = py_ldapControlDirSyncBlob_get_u1,
		.set = py_ldapControlDirSyncBlob_set_u1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_ldapControlDirSyncBlob_get_time,
		.set = py_ldapControlDirSyncBlob_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "u2"),
		.get = py_ldapControlDirSyncBlob_get_u2,
		.set = py_ldapControlDirSyncBlob_set_u2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "u3"),
		.get = py_ldapControlDirSyncBlob_get_u3,
		.set = py_ldapControlDirSyncBlob_set_u3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "extra_length"),
		.get = py_ldapControlDirSyncBlob_get_extra_length,
		.set = py_ldapControlDirSyncBlob_set_extra_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "highwatermark"),
		.get = py_ldapControlDirSyncBlob_get_highwatermark,
		.set = py_ldapControlDirSyncBlob_set_highwatermark,
		.doc = discard_const_p(char, "PIDL-generated element of base type drsuapi_DsReplicaHighWaterMark")
	},
	{
		.name = discard_const_p(char, "guid1"),
		.get = py_ldapControlDirSyncBlob_get_guid1,
		.set = py_ldapControlDirSyncBlob_set_guid1,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "extra"),
		.get = py_ldapControlDirSyncBlob_get_extra,
		.set = py_ldapControlDirSyncBlob_set_extra,
		.doc = discard_const_p(char, "PIDL-generated element of base type ldapControlDirSyncExtra")
	},
	{ .name = NULL }
};

static PyObject *py_ldapControlDirSyncBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ldapControlDirSyncBlob, type);
}


static PyTypeObject ldapControlDirSyncBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ldapControlDirSyncBlob",
	.tp_getset = py_ldapControlDirSyncBlob_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ldapControlDirSyncBlob_new,
};


static PyObject *py_ldapControlDirSyncCookie_get_msds(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncCookie *object = pytalloc_get_ptr(obj);
	PyObject *py_msds;
	if (object->msds == NULL) {
		py_msds = Py_None;
		Py_INCREF(py_msds);
	} else {
		py_msds = PyUnicode_Decode(object->msds, strlen(object->msds), "utf-8", "ignore");
	}
	return py_msds;
}

static int py_ldapControlDirSyncCookie_set_msds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncCookie *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->msds");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->msds = talloc_str;
	}
	return 0;
}

static PyObject *py_ldapControlDirSyncCookie_get_blob(PyObject *obj, void *closure)
{
	struct ldapControlDirSyncCookie *object = pytalloc_get_ptr(obj);
	PyObject *py_blob;
	py_blob = pytalloc_reference_ex(&ldapControlDirSyncBlob_Type, pytalloc_get_mem_ctx(obj), &object->blob);
	return py_blob;
}

static int py_ldapControlDirSyncCookie_set_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ldapControlDirSyncCookie *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->blob");
		return -1;
	}
	PY_CHECK_TYPE(&ldapControlDirSyncBlob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->blob = *(struct ldapControlDirSyncBlob *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_ldapControlDirSyncCookie_getsetters[] = {
	{
		.name = discard_const_p(char, "msds"),
		.get = py_ldapControlDirSyncCookie_get_msds,
		.set = py_ldapControlDirSyncCookie_set_msds,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "blob"),
		.get = py_ldapControlDirSyncCookie_get_blob,
		.set = py_ldapControlDirSyncCookie_set_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type ldapControlDirSyncBlob")
	},
	{ .name = NULL }
};

static PyObject *py_ldapControlDirSyncCookie_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ldapControlDirSyncCookie, type);
}

static PyObject *py_ldapControlDirSyncCookie_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ldapControlDirSyncCookie *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ldapControlDirSyncCookie);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ldapControlDirSyncCookie_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ldapControlDirSyncCookie *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ldapControlDirSyncCookie);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ldapControlDirSyncCookie);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ldapControlDirSyncCookie_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct ldapControlDirSyncCookie *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ldapControlDirSyncCookie, "ldapControlDirSyncCookie", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ldapControlDirSyncCookie_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ldapControlDirSyncCookie_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ldapControlDirSyncCookie_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ldapControlDirSyncCookie_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ldapControlDirSyncCookie_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ldapControlDirSyncCookie",
	.tp_getset = py_ldapControlDirSyncCookie_getsetters,
	.tp_methods = py_ldapControlDirSyncCookie_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ldapControlDirSyncCookie_new,
};


static PyObject *py_supplementalCredentialsPackage_get_name_len(PyObject *obj, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(obj);
	PyObject *py_name_len;
	py_name_len = PyLong_FromLong((uint16_t)(object->name_len));
	return py_name_len;
}

static int py_supplementalCredentialsPackage_set_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsPackage_get_data_len(PyObject *obj, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(obj);
	PyObject *py_data_len;
	py_data_len = PyLong_FromLong((uint16_t)(object->data_len));
	return py_data_len;
}

static int py_supplementalCredentialsPackage_set_data_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->data_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->data_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsPackage_get_reserved(PyObject *obj, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromLong((uint16_t)(object->reserved));
	return py_reserved;
}

static int py_supplementalCredentialsPackage_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsPackage_get_name(PyObject *obj, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_supplementalCredentialsPackage_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyObject *py_supplementalCredentialsPackage_get_data(PyObject *obj, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyUnicode_Decode(object->data, strlen(object->data), "utf-8", "ignore");
	}
	return py_data;
}

static int py_supplementalCredentialsPackage_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->data = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_supplementalCredentialsPackage_getsetters[] = {
	{
		.name = discard_const_p(char, "name_len"),
		.get = py_supplementalCredentialsPackage_get_name_len,
		.set = py_supplementalCredentialsPackage_set_name_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data_len"),
		.get = py_supplementalCredentialsPackage_get_data_len,
		.set = py_supplementalCredentialsPackage_set_data_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_supplementalCredentialsPackage_get_reserved,
		.set = py_supplementalCredentialsPackage_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_supplementalCredentialsPackage_get_name,
		.set = py_supplementalCredentialsPackage_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_supplementalCredentialsPackage_get_data,
		.set = py_supplementalCredentialsPackage_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_supplementalCredentialsPackage_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct supplementalCredentialsPackage, type);
}

static PyObject *py_supplementalCredentialsPackage_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_supplementalCredentialsPackage);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_supplementalCredentialsPackage_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_supplementalCredentialsPackage);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_supplementalCredentialsPackage);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_supplementalCredentialsPackage_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct supplementalCredentialsPackage *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_supplementalCredentialsPackage, "supplementalCredentialsPackage", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_supplementalCredentialsPackage_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_supplementalCredentialsPackage_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_supplementalCredentialsPackage_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_supplementalCredentialsPackage_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject supplementalCredentialsPackage_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.supplementalCredentialsPackage",
	.tp_getset = py_supplementalCredentialsPackage_getsetters,
	.tp_methods = py_supplementalCredentialsPackage_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_supplementalCredentialsPackage_new,
};


static PyObject *py_supplementalCredentialsSubBlob_get_prefix(PyObject *obj, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_prefix;
	if (object->prefix == NULL) {
		py_prefix = Py_None;
		Py_INCREF(py_prefix);
	} else {
		py_prefix = PyUnicode_Decode(object->prefix, strlen(object->prefix), "utf-8", "ignore");
	}
	return py_prefix;
}

static int py_supplementalCredentialsSubBlob_set_prefix(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->prefix");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->prefix = talloc_str;
	}
	return 0;
}

static PyObject *py_supplementalCredentialsSubBlob_get_signature(PyObject *obj, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_signature;
	py_signature = PyLong_FromLong((uint16_t)(object->signature));
	return py_signature;
}

static int py_supplementalCredentialsSubBlob_set_signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->signature");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->signature));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->signature = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsSubBlob_get_num_packages(PyObject *obj, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_num_packages;
	py_num_packages = PyLong_FromLong((uint16_t)(object->num_packages));
	return py_num_packages;
}

static int py_supplementalCredentialsSubBlob_set_num_packages(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_packages");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_packages));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_packages = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsSubBlob_get_packages(PyObject *obj, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_packages;
	py_packages = PyList_New(object->num_packages);
	if (py_packages == NULL) {
		return NULL;
	}
	{
		int packages_cntr_0;
		for (packages_cntr_0 = 0; packages_cntr_0 < (object->num_packages); packages_cntr_0++) {
			PyObject *py_packages_0;
			py_packages_0 = pytalloc_reference_ex(&supplementalCredentialsPackage_Type, object->packages, &(object->packages)[packages_cntr_0]);
			PyList_SetItem(py_packages, packages_cntr_0, py_packages_0);
		}
	}
	return py_packages;
}

static int py_supplementalCredentialsSubBlob_set_packages(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsSubBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->packages");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int packages_cntr_0;
		object->packages = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->packages, PyList_GET_SIZE(value));
		if (!object->packages) { return -1; }
		talloc_set_name_const(object->packages, "ARRAY: object->packages");
		for (packages_cntr_0 = 0; packages_cntr_0 < PyList_GET_SIZE(value); packages_cntr_0++) {
			if (PyList_GET_ITEM(value, packages_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->packages)[packages_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&supplementalCredentialsPackage_Type, PyList_GET_ITEM(value, packages_cntr_0), return -1;);
			if (talloc_reference(object->packages, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, packages_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->packages)[packages_cntr_0] = *(struct supplementalCredentialsPackage *)pytalloc_get_ptr(PyList_GET_ITEM(value, packages_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_supplementalCredentialsSubBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "prefix"),
		.get = py_supplementalCredentialsSubBlob_get_prefix,
		.set = py_supplementalCredentialsSubBlob_set_prefix,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "signature"),
		.get = py_supplementalCredentialsSubBlob_get_signature,
		.set = py_supplementalCredentialsSubBlob_set_signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type supplementalCredentialsSignature")
	},
	{
		.name = discard_const_p(char, "num_packages"),
		.get = py_supplementalCredentialsSubBlob_get_num_packages,
		.set = py_supplementalCredentialsSubBlob_set_num_packages,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "packages"),
		.get = py_supplementalCredentialsSubBlob_get_packages,
		.set = py_supplementalCredentialsSubBlob_set_packages,
		.doc = discard_const_p(char, "PIDL-generated element of base type supplementalCredentialsPackage")
	},
	{ .name = NULL }
};

static PyObject *py_supplementalCredentialsSubBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct supplementalCredentialsSubBlob, type);
}


static PyTypeObject supplementalCredentialsSubBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.supplementalCredentialsSubBlob",
	.tp_getset = py_supplementalCredentialsSubBlob_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_supplementalCredentialsSubBlob_new,
};


static PyObject *py_supplementalCredentialsBlob_get_unknown1(PyObject *obj, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown1));
	return py_unknown1;
}

static int py_supplementalCredentialsBlob_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsBlob_get___ndr_size(PyObject *obj, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(obj);
	PyObject *py___ndr_size;
	py___ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->__ndr_size));
	return py___ndr_size;
}

static int py_supplementalCredentialsBlob_set___ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->__ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsBlob_get_unknown2(PyObject *obj, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown2));
	return py_unknown2;
}

static int py_supplementalCredentialsBlob_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_supplementalCredentialsBlob_get_sub(PyObject *obj, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_sub;
	py_sub = pytalloc_reference_ex(&supplementalCredentialsSubBlob_Type, pytalloc_get_mem_ctx(obj), &object->sub);
	return py_sub;
}

static int py_supplementalCredentialsBlob_set_sub(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sub");
		return -1;
	}
	PY_CHECK_TYPE(&supplementalCredentialsSubBlob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sub = *(struct supplementalCredentialsSubBlob *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_supplementalCredentialsBlob_get_unknown3(PyObject *obj, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromLong((uint16_t)(object->unknown3));
	return py_unknown3;
}

static int py_supplementalCredentialsBlob_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_supplementalCredentialsBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_supplementalCredentialsBlob_get_unknown1,
		.set = py_supplementalCredentialsBlob_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__ndr_size"),
		.get = py_supplementalCredentialsBlob_get___ndr_size,
		.set = py_supplementalCredentialsBlob_set___ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_supplementalCredentialsBlob_get_unknown2,
		.set = py_supplementalCredentialsBlob_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sub"),
		.get = py_supplementalCredentialsBlob_get_sub,
		.set = py_supplementalCredentialsBlob_set_sub,
		.doc = discard_const_p(char, "PIDL-generated element of base type supplementalCredentialsSubBlob")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_supplementalCredentialsBlob_get_unknown3,
		.set = py_supplementalCredentialsBlob_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_supplementalCredentialsBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct supplementalCredentialsBlob, type);
}

static PyObject *py_supplementalCredentialsBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_supplementalCredentialsBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_supplementalCredentialsBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_supplementalCredentialsBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_supplementalCredentialsBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_supplementalCredentialsBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct supplementalCredentialsBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_supplementalCredentialsBlob, "supplementalCredentialsBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_supplementalCredentialsBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_supplementalCredentialsBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_supplementalCredentialsBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_supplementalCredentialsBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject supplementalCredentialsBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.supplementalCredentialsBlob",
	.tp_getset = py_supplementalCredentialsBlob_getsetters,
	.tp_methods = py_supplementalCredentialsBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_supplementalCredentialsBlob_new,
};


static PyObject *py_package_PackagesBlob_get_names(PyObject *obj, void *closure)
{
	struct package_PackagesBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	py_names = pytalloc_GenericObject_reference_ex(pytalloc_get_mem_ctx(obj), object->names);
	return py_names;
}

static int py_package_PackagesBlob_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PackagesBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->names");
		return -1;
	}
	object->names = pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_package_PackagesBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "names"),
		.get = py_package_PackagesBlob_get_names,
		.set = py_package_PackagesBlob_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type string_array")
	},
	{ .name = NULL }
};

static PyObject *py_package_PackagesBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PackagesBlob, type);
}

static PyObject *py_package_PackagesBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct package_PackagesBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_package_PackagesBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_package_PackagesBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct package_PackagesBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PackagesBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PackagesBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_package_PackagesBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct package_PackagesBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_package_PackagesBlob, "package_PackagesBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_package_PackagesBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_package_PackagesBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PackagesBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_package_PackagesBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject package_PackagesBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PackagesBlob",
	.tp_getset = py_package_PackagesBlob_getsetters,
	.tp_methods = py_package_PackagesBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PackagesBlob_new,
};


static PyObject *py_package_PrimaryKerberosString_get_length(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosString *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_package_PrimaryKerberosString_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosString_get_size(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosString *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_package_PrimaryKerberosString_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosString_get_string(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosString *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		py_string = PyString_FromStringOrNULL(object->string);
	}
	return py_string;
}

static int py_package_PrimaryKerberosString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosString *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->string));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryKerberosString_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_package_PrimaryKerberosString_get_length,
		.set = py_package_PrimaryKerberosString_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_package_PrimaryKerberosString_get_size,
		.set = py_package_PrimaryKerberosString_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_package_PrimaryKerberosString_get_string,
		.set = py_package_PrimaryKerberosString_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryKerberosString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryKerberosString, type);
}


static PyTypeObject package_PrimaryKerberosString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryKerberosString",
	.tp_getset = py_package_PrimaryKerberosString_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryKerberosString_new,
};


static PyObject *py_package_PrimaryKerberosKey3_get_reserved1(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved1;
	py_reserved1 = PyLong_FromLong((uint16_t)(object->reserved1));
	return py_reserved1;
}

static int py_package_PrimaryKerberosKey3_set_reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey3_get_reserved2(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved2;
	py_reserved2 = PyLong_FromLong((uint16_t)(object->reserved2));
	return py_reserved2;
}

static int py_package_PrimaryKerberosKey3_set_reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey3_get_reserved3(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved3;
	py_reserved3 = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved3));
	return py_reserved3;
}

static int py_package_PrimaryKerberosKey3_set_reserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey3_get_keytype(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(obj);
	PyObject *py_keytype;
	py_keytype = PyLong_FromUnsignedLongLong((uint32_t)(object->keytype));
	return py_keytype;
}

static int py_package_PrimaryKerberosKey3_set_keytype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->keytype");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->keytype));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->keytype = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey3_get_value_len(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(obj);
	PyObject *py_value_len;
	py_value_len = PyLong_FromUnsignedLongLong((uint32_t)(object->value_len));
	return py_value_len;
}

static int py_package_PrimaryKerberosKey3_set_value_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey3_get_value(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	if (object->value == NULL) {
		Py_RETURN_NONE;
	}
	if (object->value == NULL) {
		py_value = Py_None;
		Py_INCREF(py_value);
	} else {
		py_value = PyBytes_FromStringAndSize((char *)(*object->value).data, (*object->value).length);
	}
	return py_value;
}

static int py_package_PrimaryKerberosKey3_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->value));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value");
		return -1;
	}
	if (value == Py_None) {
		object->value = NULL;
	} else {
		object->value = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->value);
		if (object->value == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->value = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryKerberosKey3_getsetters[] = {
	{
		.name = discard_const_p(char, "reserved1"),
		.get = py_package_PrimaryKerberosKey3_get_reserved1,
		.set = py_package_PrimaryKerberosKey3_set_reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved2"),
		.get = py_package_PrimaryKerberosKey3_get_reserved2,
		.set = py_package_PrimaryKerberosKey3_set_reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved3"),
		.get = py_package_PrimaryKerberosKey3_get_reserved3,
		.set = py_package_PrimaryKerberosKey3_set_reserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "keytype"),
		.get = py_package_PrimaryKerberosKey3_get_keytype,
		.set = py_package_PrimaryKerberosKey3_set_keytype,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "value_len"),
		.get = py_package_PrimaryKerberosKey3_get_value_len,
		.set = py_package_PrimaryKerberosKey3_set_value_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "value"),
		.get = py_package_PrimaryKerberosKey3_get_value,
		.set = py_package_PrimaryKerberosKey3_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryKerberosKey3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryKerberosKey3, type);
}


static PyTypeObject package_PrimaryKerberosKey3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryKerberosKey3",
	.tp_getset = py_package_PrimaryKerberosKey3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryKerberosKey3_new,
};


static PyObject *py_package_PrimaryKerberosCtr3_get_num_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_keys;
	py_num_keys = PyLong_FromLong((uint16_t)(object->num_keys));
	return py_num_keys;
}

static int py_package_PrimaryKerberosCtr3_set_num_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_keys");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_keys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_keys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_num_old_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_old_keys;
	py_num_old_keys = PyLong_FromLong((uint16_t)(object->num_old_keys));
	return py_num_old_keys;
}

static int py_package_PrimaryKerberosCtr3_set_num_old_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_old_keys");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_old_keys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_old_keys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_salt(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_salt;
	py_salt = pytalloc_reference_ex(&package_PrimaryKerberosString_Type, pytalloc_get_mem_ctx(obj), &object->salt);
	return py_salt;
}

static int py_package_PrimaryKerberosCtr3_set_salt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->salt");
		return -1;
	}
	PY_CHECK_TYPE(&package_PrimaryKerberosString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->salt = *(struct package_PrimaryKerberosString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_keys;
	py_keys = PyList_New(object->num_keys);
	if (py_keys == NULL) {
		return NULL;
	}
	{
		int keys_cntr_0;
		for (keys_cntr_0 = 0; keys_cntr_0 < (object->num_keys); keys_cntr_0++) {
			PyObject *py_keys_0;
			py_keys_0 = pytalloc_reference_ex(&package_PrimaryKerberosKey3_Type, object->keys, &(object->keys)[keys_cntr_0]);
			PyList_SetItem(py_keys, keys_cntr_0, py_keys_0);
		}
	}
	return py_keys;
}

static int py_package_PrimaryKerberosCtr3_set_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->keys");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int keys_cntr_0;
		object->keys = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->keys, PyList_GET_SIZE(value));
		if (!object->keys) { return -1; }
		talloc_set_name_const(object->keys, "ARRAY: object->keys");
		for (keys_cntr_0 = 0; keys_cntr_0 < PyList_GET_SIZE(value); keys_cntr_0++) {
			if (PyList_GET_ITEM(value, keys_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->keys)[keys_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosKey3_Type, PyList_GET_ITEM(value, keys_cntr_0), return -1;);
			if (talloc_reference(object->keys, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, keys_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->keys)[keys_cntr_0] = *(struct package_PrimaryKerberosKey3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, keys_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_old_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_old_keys;
	py_old_keys = PyList_New(object->num_old_keys);
	if (py_old_keys == NULL) {
		return NULL;
	}
	{
		int old_keys_cntr_0;
		for (old_keys_cntr_0 = 0; old_keys_cntr_0 < (object->num_old_keys); old_keys_cntr_0++) {
			PyObject *py_old_keys_0;
			py_old_keys_0 = pytalloc_reference_ex(&package_PrimaryKerberosKey3_Type, object->old_keys, &(object->old_keys)[old_keys_cntr_0]);
			PyList_SetItem(py_old_keys, old_keys_cntr_0, py_old_keys_0);
		}
	}
	return py_old_keys;
}

static int py_package_PrimaryKerberosCtr3_set_old_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->old_keys");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int old_keys_cntr_0;
		object->old_keys = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->old_keys, PyList_GET_SIZE(value));
		if (!object->old_keys) { return -1; }
		talloc_set_name_const(object->old_keys, "ARRAY: object->old_keys");
		for (old_keys_cntr_0 = 0; old_keys_cntr_0 < PyList_GET_SIZE(value); old_keys_cntr_0++) {
			if (PyList_GET_ITEM(value, old_keys_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->old_keys)[old_keys_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosKey3_Type, PyList_GET_ITEM(value, old_keys_cntr_0), return -1;);
			if (talloc_reference(object->old_keys, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, old_keys_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->old_keys)[old_keys_cntr_0] = *(struct package_PrimaryKerberosKey3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, old_keys_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_padding1(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_padding1;
	py_padding1 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding1));
	return py_padding1;
}

static int py_package_PrimaryKerberosCtr3_set_padding1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_padding2(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_padding2;
	py_padding2 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding2));
	return py_padding2;
}

static int py_package_PrimaryKerberosCtr3_set_padding2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_padding3(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_padding3;
	py_padding3 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding3));
	return py_padding3;
}

static int py_package_PrimaryKerberosCtr3_set_padding3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_padding4(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_padding4;
	py_padding4 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding4));
	return py_padding4;
}

static int py_package_PrimaryKerberosCtr3_set_padding4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr3_get_padding5(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_padding5;
	py_padding5 = PyLong_FromUnsignedLongLong((uint32_t)(object->padding5));
	return py_padding5;
}

static int py_package_PrimaryKerberosCtr3_set_padding5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->padding5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->padding5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->padding5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryKerberosCtr3_getsetters[] = {
	{
		.name = discard_const_p(char, "num_keys"),
		.get = py_package_PrimaryKerberosCtr3_get_num_keys,
		.set = py_package_PrimaryKerberosCtr3_set_num_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_old_keys"),
		.get = py_package_PrimaryKerberosCtr3_get_num_old_keys,
		.set = py_package_PrimaryKerberosCtr3_set_num_old_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "salt"),
		.get = py_package_PrimaryKerberosCtr3_get_salt,
		.set = py_package_PrimaryKerberosCtr3_set_salt,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosString")
	},
	{
		.name = discard_const_p(char, "keys"),
		.get = py_package_PrimaryKerberosCtr3_get_keys,
		.set = py_package_PrimaryKerberosCtr3_set_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosKey3")
	},
	{
		.name = discard_const_p(char, "old_keys"),
		.get = py_package_PrimaryKerberosCtr3_get_old_keys,
		.set = py_package_PrimaryKerberosCtr3_set_old_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosKey3")
	},
	{
		.name = discard_const_p(char, "padding1"),
		.get = py_package_PrimaryKerberosCtr3_get_padding1,
		.set = py_package_PrimaryKerberosCtr3_set_padding1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "padding2"),
		.get = py_package_PrimaryKerberosCtr3_get_padding2,
		.set = py_package_PrimaryKerberosCtr3_set_padding2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "padding3"),
		.get = py_package_PrimaryKerberosCtr3_get_padding3,
		.set = py_package_PrimaryKerberosCtr3_set_padding3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "padding4"),
		.get = py_package_PrimaryKerberosCtr3_get_padding4,
		.set = py_package_PrimaryKerberosCtr3_set_padding4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "padding5"),
		.get = py_package_PrimaryKerberosCtr3_get_padding5,
		.set = py_package_PrimaryKerberosCtr3_set_padding5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryKerberosCtr3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryKerberosCtr3, type);
}


static PyTypeObject package_PrimaryKerberosCtr3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryKerberosCtr3",
	.tp_getset = py_package_PrimaryKerberosCtr3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryKerberosCtr3_new,
};


static PyObject *py_package_PrimaryKerberosKey4_get_reserved1(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved1;
	py_reserved1 = PyLong_FromLong((uint16_t)(object->reserved1));
	return py_reserved1;
}

static int py_package_PrimaryKerberosKey4_set_reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey4_get_reserved2(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved2;
	py_reserved2 = PyLong_FromLong((uint16_t)(object->reserved2));
	return py_reserved2;
}

static int py_package_PrimaryKerberosKey4_set_reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey4_get_reserved3(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved3;
	py_reserved3 = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved3));
	return py_reserved3;
}

static int py_package_PrimaryKerberosKey4_set_reserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->reserved3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey4_get_iteration_count(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(obj);
	PyObject *py_iteration_count;
	py_iteration_count = PyLong_FromUnsignedLongLong((uint32_t)(object->iteration_count));
	return py_iteration_count;
}

static int py_package_PrimaryKerberosKey4_set_iteration_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->iteration_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->iteration_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->iteration_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey4_get_keytype(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(obj);
	PyObject *py_keytype;
	py_keytype = PyLong_FromUnsignedLongLong((uint32_t)(object->keytype));
	return py_keytype;
}

static int py_package_PrimaryKerberosKey4_set_keytype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->keytype");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->keytype));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->keytype = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey4_get_value_len(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(obj);
	PyObject *py_value_len;
	py_value_len = PyLong_FromUnsignedLongLong((uint32_t)(object->value_len));
	return py_value_len;
}

static int py_package_PrimaryKerberosKey4_set_value_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosKey4_get_value(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	if (object->value == NULL) {
		Py_RETURN_NONE;
	}
	if (object->value == NULL) {
		py_value = Py_None;
		Py_INCREF(py_value);
	} else {
		py_value = PyBytes_FromStringAndSize((char *)(*object->value).data, (*object->value).length);
	}
	return py_value;
}

static int py_package_PrimaryKerberosKey4_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosKey4 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->value));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value");
		return -1;
	}
	if (value == Py_None) {
		object->value = NULL;
	} else {
		object->value = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->value);
		if (object->value == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->value = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryKerberosKey4_getsetters[] = {
	{
		.name = discard_const_p(char, "reserved1"),
		.get = py_package_PrimaryKerberosKey4_get_reserved1,
		.set = py_package_PrimaryKerberosKey4_set_reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved2"),
		.get = py_package_PrimaryKerberosKey4_get_reserved2,
		.set = py_package_PrimaryKerberosKey4_set_reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved3"),
		.get = py_package_PrimaryKerberosKey4_get_reserved3,
		.set = py_package_PrimaryKerberosKey4_set_reserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "iteration_count"),
		.get = py_package_PrimaryKerberosKey4_get_iteration_count,
		.set = py_package_PrimaryKerberosKey4_set_iteration_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "keytype"),
		.get = py_package_PrimaryKerberosKey4_get_keytype,
		.set = py_package_PrimaryKerberosKey4_set_keytype,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "value_len"),
		.get = py_package_PrimaryKerberosKey4_get_value_len,
		.set = py_package_PrimaryKerberosKey4_set_value_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "value"),
		.get = py_package_PrimaryKerberosKey4_get_value,
		.set = py_package_PrimaryKerberosKey4_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryKerberosKey4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryKerberosKey4, type);
}


static PyTypeObject package_PrimaryKerberosKey4_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryKerberosKey4",
	.tp_getset = py_package_PrimaryKerberosKey4_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryKerberosKey4_new,
};


static PyObject *py_package_PrimaryKerberosCtr4_get_num_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_keys;
	py_num_keys = PyLong_FromLong((uint16_t)(object->num_keys));
	return py_num_keys;
}

static int py_package_PrimaryKerberosCtr4_set_num_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_keys");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_keys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_keys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_num_service_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_service_keys;
	py_num_service_keys = PyLong_FromLong((uint16_t)(object->num_service_keys));
	return py_num_service_keys;
}

static int py_package_PrimaryKerberosCtr4_set_num_service_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_service_keys");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_service_keys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_service_keys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_num_old_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_old_keys;
	py_num_old_keys = PyLong_FromLong((uint16_t)(object->num_old_keys));
	return py_num_old_keys;
}

static int py_package_PrimaryKerberosCtr4_set_num_old_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_old_keys");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_old_keys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_old_keys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_num_older_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_older_keys;
	py_num_older_keys = PyLong_FromLong((uint16_t)(object->num_older_keys));
	return py_num_older_keys;
}

static int py_package_PrimaryKerberosCtr4_set_num_older_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_older_keys");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_older_keys));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_older_keys = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_salt(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_salt;
	py_salt = pytalloc_reference_ex(&package_PrimaryKerberosString_Type, pytalloc_get_mem_ctx(obj), &object->salt);
	return py_salt;
}

static int py_package_PrimaryKerberosCtr4_set_salt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->salt");
		return -1;
	}
	PY_CHECK_TYPE(&package_PrimaryKerberosString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->salt = *(struct package_PrimaryKerberosString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_default_iteration_count(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_default_iteration_count;
	py_default_iteration_count = PyLong_FromUnsignedLongLong((uint32_t)(object->default_iteration_count));
	return py_default_iteration_count;
}

static int py_package_PrimaryKerberosCtr4_set_default_iteration_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->default_iteration_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->default_iteration_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->default_iteration_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_keys;
	py_keys = PyList_New(object->num_keys);
	if (py_keys == NULL) {
		return NULL;
	}
	{
		int keys_cntr_0;
		for (keys_cntr_0 = 0; keys_cntr_0 < (object->num_keys); keys_cntr_0++) {
			PyObject *py_keys_0;
			py_keys_0 = pytalloc_reference_ex(&package_PrimaryKerberosKey4_Type, object->keys, &(object->keys)[keys_cntr_0]);
			PyList_SetItem(py_keys, keys_cntr_0, py_keys_0);
		}
	}
	return py_keys;
}

static int py_package_PrimaryKerberosCtr4_set_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->keys");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int keys_cntr_0;
		object->keys = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->keys, PyList_GET_SIZE(value));
		if (!object->keys) { return -1; }
		talloc_set_name_const(object->keys, "ARRAY: object->keys");
		for (keys_cntr_0 = 0; keys_cntr_0 < PyList_GET_SIZE(value); keys_cntr_0++) {
			if (PyList_GET_ITEM(value, keys_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->keys)[keys_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosKey4_Type, PyList_GET_ITEM(value, keys_cntr_0), return -1;);
			if (talloc_reference(object->keys, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, keys_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->keys)[keys_cntr_0] = *(struct package_PrimaryKerberosKey4 *)pytalloc_get_ptr(PyList_GET_ITEM(value, keys_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_service_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_service_keys;
	py_service_keys = PyList_New(object->num_service_keys);
	if (py_service_keys == NULL) {
		return NULL;
	}
	{
		int service_keys_cntr_0;
		for (service_keys_cntr_0 = 0; service_keys_cntr_0 < (object->num_service_keys); service_keys_cntr_0++) {
			PyObject *py_service_keys_0;
			py_service_keys_0 = pytalloc_reference_ex(&package_PrimaryKerberosKey4_Type, object->service_keys, &(object->service_keys)[service_keys_cntr_0]);
			PyList_SetItem(py_service_keys, service_keys_cntr_0, py_service_keys_0);
		}
	}
	return py_service_keys;
}

static int py_package_PrimaryKerberosCtr4_set_service_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->service_keys");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int service_keys_cntr_0;
		object->service_keys = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->service_keys, PyList_GET_SIZE(value));
		if (!object->service_keys) { return -1; }
		talloc_set_name_const(object->service_keys, "ARRAY: object->service_keys");
		for (service_keys_cntr_0 = 0; service_keys_cntr_0 < PyList_GET_SIZE(value); service_keys_cntr_0++) {
			if (PyList_GET_ITEM(value, service_keys_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->service_keys)[service_keys_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosKey4_Type, PyList_GET_ITEM(value, service_keys_cntr_0), return -1;);
			if (talloc_reference(object->service_keys, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, service_keys_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->service_keys)[service_keys_cntr_0] = *(struct package_PrimaryKerberosKey4 *)pytalloc_get_ptr(PyList_GET_ITEM(value, service_keys_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_old_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_old_keys;
	py_old_keys = PyList_New(object->num_old_keys);
	if (py_old_keys == NULL) {
		return NULL;
	}
	{
		int old_keys_cntr_0;
		for (old_keys_cntr_0 = 0; old_keys_cntr_0 < (object->num_old_keys); old_keys_cntr_0++) {
			PyObject *py_old_keys_0;
			py_old_keys_0 = pytalloc_reference_ex(&package_PrimaryKerberosKey4_Type, object->old_keys, &(object->old_keys)[old_keys_cntr_0]);
			PyList_SetItem(py_old_keys, old_keys_cntr_0, py_old_keys_0);
		}
	}
	return py_old_keys;
}

static int py_package_PrimaryKerberosCtr4_set_old_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->old_keys");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int old_keys_cntr_0;
		object->old_keys = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->old_keys, PyList_GET_SIZE(value));
		if (!object->old_keys) { return -1; }
		talloc_set_name_const(object->old_keys, "ARRAY: object->old_keys");
		for (old_keys_cntr_0 = 0; old_keys_cntr_0 < PyList_GET_SIZE(value); old_keys_cntr_0++) {
			if (PyList_GET_ITEM(value, old_keys_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->old_keys)[old_keys_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosKey4_Type, PyList_GET_ITEM(value, old_keys_cntr_0), return -1;);
			if (talloc_reference(object->old_keys, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, old_keys_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->old_keys)[old_keys_cntr_0] = *(struct package_PrimaryKerberosKey4 *)pytalloc_get_ptr(PyList_GET_ITEM(value, old_keys_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosCtr4_get_older_keys(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(obj);
	PyObject *py_older_keys;
	py_older_keys = PyList_New(object->num_older_keys);
	if (py_older_keys == NULL) {
		return NULL;
	}
	{
		int older_keys_cntr_0;
		for (older_keys_cntr_0 = 0; older_keys_cntr_0 < (object->num_older_keys); older_keys_cntr_0++) {
			PyObject *py_older_keys_0;
			py_older_keys_0 = pytalloc_reference_ex(&package_PrimaryKerberosKey4_Type, object->older_keys, &(object->older_keys)[older_keys_cntr_0]);
			PyList_SetItem(py_older_keys, older_keys_cntr_0, py_older_keys_0);
		}
	}
	return py_older_keys;
}

static int py_package_PrimaryKerberosCtr4_set_older_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosCtr4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->older_keys");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int older_keys_cntr_0;
		object->older_keys = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->older_keys, PyList_GET_SIZE(value));
		if (!object->older_keys) { return -1; }
		talloc_set_name_const(object->older_keys, "ARRAY: object->older_keys");
		for (older_keys_cntr_0 = 0; older_keys_cntr_0 < PyList_GET_SIZE(value); older_keys_cntr_0++) {
			if (PyList_GET_ITEM(value, older_keys_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->older_keys)[older_keys_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosKey4_Type, PyList_GET_ITEM(value, older_keys_cntr_0), return -1;);
			if (talloc_reference(object->older_keys, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, older_keys_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->older_keys)[older_keys_cntr_0] = *(struct package_PrimaryKerberosKey4 *)pytalloc_get_ptr(PyList_GET_ITEM(value, older_keys_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryKerberosCtr4_getsetters[] = {
	{
		.name = discard_const_p(char, "num_keys"),
		.get = py_package_PrimaryKerberosCtr4_get_num_keys,
		.set = py_package_PrimaryKerberosCtr4_set_num_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_service_keys"),
		.get = py_package_PrimaryKerberosCtr4_get_num_service_keys,
		.set = py_package_PrimaryKerberosCtr4_set_num_service_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_old_keys"),
		.get = py_package_PrimaryKerberosCtr4_get_num_old_keys,
		.set = py_package_PrimaryKerberosCtr4_set_num_old_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_older_keys"),
		.get = py_package_PrimaryKerberosCtr4_get_num_older_keys,
		.set = py_package_PrimaryKerberosCtr4_set_num_older_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "salt"),
		.get = py_package_PrimaryKerberosCtr4_get_salt,
		.set = py_package_PrimaryKerberosCtr4_set_salt,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosString")
	},
	{
		.name = discard_const_p(char, "default_iteration_count"),
		.get = py_package_PrimaryKerberosCtr4_get_default_iteration_count,
		.set = py_package_PrimaryKerberosCtr4_set_default_iteration_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "keys"),
		.get = py_package_PrimaryKerberosCtr4_get_keys,
		.set = py_package_PrimaryKerberosCtr4_set_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosKey4")
	},
	{
		.name = discard_const_p(char, "service_keys"),
		.get = py_package_PrimaryKerberosCtr4_get_service_keys,
		.set = py_package_PrimaryKerberosCtr4_set_service_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosKey4")
	},
	{
		.name = discard_const_p(char, "old_keys"),
		.get = py_package_PrimaryKerberosCtr4_get_old_keys,
		.set = py_package_PrimaryKerberosCtr4_set_old_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosKey4")
	},
	{
		.name = discard_const_p(char, "older_keys"),
		.get = py_package_PrimaryKerberosCtr4_get_older_keys,
		.set = py_package_PrimaryKerberosCtr4_set_older_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosKey4")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryKerberosCtr4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryKerberosCtr4, type);
}


static PyTypeObject package_PrimaryKerberosCtr4_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryKerberosCtr4",
	.tp_getset = py_package_PrimaryKerberosCtr4_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryKerberosCtr4_new,
};

static PyObject *py_import_package_PrimaryKerberosCtr(TALLOC_CTX *mem_ctx, int level, union package_PrimaryKerberosCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 3:
			ret = pytalloc_reference_ex(&package_PrimaryKerberosCtr3_Type, mem_ctx, &in->ctr3);
			return ret;

		case 4:
			ret = pytalloc_reference_ex(&package_PrimaryKerberosCtr4_Type, mem_ctx, &in->ctr4);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union package_PrimaryKerberosCtr *py_export_package_PrimaryKerberosCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union package_PrimaryKerberosCtr *ret = talloc_zero(mem_ctx, union package_PrimaryKerberosCtr);
	switch (level) {
		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosCtr3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr3 = *(struct package_PrimaryKerberosCtr3 *)pytalloc_get_ptr(in);
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ctr4");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&package_PrimaryKerberosCtr4_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr4 = *(struct package_PrimaryKerberosCtr4 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_package_PrimaryKerberosCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union package_PrimaryKerberosCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union package_PrimaryKerberosCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union package_PrimaryKerberosCtr!");
		return NULL;
	}

	return py_import_package_PrimaryKerberosCtr(mem_ctx, level, in);
}

static PyObject *py_package_PrimaryKerberosCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union package_PrimaryKerberosCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_package_PrimaryKerberosCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_package_PrimaryKerberosCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PrimaryKerberosCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PrimaryKerberosCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_package_PrimaryKerberosCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject package_PrimaryKerberosCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryKerberosCtr",
	.tp_getset = NULL,
	.tp_methods = py_package_PrimaryKerberosCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryKerberosCtr_new,
};


static PyObject *py_package_PrimaryKerberosBlob_get_version(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromLong((uint16_t)(object->version));
	return py_version;
}

static int py_package_PrimaryKerberosBlob_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosBlob_get_flags(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_package_PrimaryKerberosBlob_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryKerberosBlob_get_ctr(PyObject *obj, void *closure)
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&package_PrimaryKerberosCtr_Type, pytalloc_get_mem_ctx(obj), object->version, &object->ctr, "union package_PrimaryKerberosCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_package_PrimaryKerberosBlob_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ctr");
		return -1;
	}
	{
		union package_PrimaryKerberosCtr *ctr_switch_0;
		ctr_switch_0 = (union package_PrimaryKerberosCtr *)pyrpc_export_union(&package_PrimaryKerberosCtr_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union package_PrimaryKerberosCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryKerberosBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_package_PrimaryKerberosBlob_get_version,
		.set = py_package_PrimaryKerberosBlob_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_package_PrimaryKerberosBlob_get_flags,
		.set = py_package_PrimaryKerberosBlob_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_package_PrimaryKerberosBlob_get_ctr,
		.set = py_package_PrimaryKerberosBlob_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryKerberosCtr")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryKerberosBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryKerberosBlob, type);
}

static PyObject *py_package_PrimaryKerberosBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_package_PrimaryKerberosBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_package_PrimaryKerberosBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryKerberosBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryKerberosBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_package_PrimaryKerberosBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryKerberosBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_package_PrimaryKerberosBlob, "package_PrimaryKerberosBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_package_PrimaryKerberosBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_package_PrimaryKerberosBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PrimaryKerberosBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_package_PrimaryKerberosBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject package_PrimaryKerberosBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryKerberosBlob",
	.tp_getset = py_package_PrimaryKerberosBlob_getsetters,
	.tp_methods = py_package_PrimaryKerberosBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryKerberosBlob_new,
};


static PyObject *py_package_PrimaryCLEARTEXTBlob_get_cleartext(PyObject *obj, void *closure)
{
	struct package_PrimaryCLEARTEXTBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_cleartext;
	py_cleartext = PyBytes_FromStringAndSize((char *)(object->cleartext).data, (object->cleartext).length);
	return py_cleartext;
}

static int py_package_PrimaryCLEARTEXTBlob_set_cleartext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryCLEARTEXTBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cleartext");
		return -1;
	}
	object->cleartext = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_package_PrimaryCLEARTEXTBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "cleartext"),
		.get = py_package_PrimaryCLEARTEXTBlob_get_cleartext,
		.set = py_package_PrimaryCLEARTEXTBlob_set_cleartext,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryCLEARTEXTBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryCLEARTEXTBlob, type);
}

static PyObject *py_package_PrimaryCLEARTEXTBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryCLEARTEXTBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_package_PrimaryCLEARTEXTBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_package_PrimaryCLEARTEXTBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct package_PrimaryCLEARTEXTBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryCLEARTEXTBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryCLEARTEXTBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_package_PrimaryCLEARTEXTBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryCLEARTEXTBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_package_PrimaryCLEARTEXTBlob, "package_PrimaryCLEARTEXTBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_package_PrimaryCLEARTEXTBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_package_PrimaryCLEARTEXTBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PrimaryCLEARTEXTBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_package_PrimaryCLEARTEXTBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject package_PrimaryCLEARTEXTBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryCLEARTEXTBlob",
	.tp_getset = py_package_PrimaryCLEARTEXTBlob_getsetters,
	.tp_methods = py_package_PrimaryCLEARTEXTBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryCLEARTEXTBlob_new,
};


static PyObject *py_package_PrimaryWDigestHash_get_hash(PyObject *obj, void *closure)
{
	struct package_PrimaryWDigestHash *object = pytalloc_get_ptr(obj);
	PyObject *py_hash;
	py_hash = PyList_New(16);
	if (py_hash == NULL) {
		return NULL;
	}
	{
		int hash_cntr_0;
		for (hash_cntr_0 = 0; hash_cntr_0 < (16); hash_cntr_0++) {
			PyObject *py_hash_0;
			py_hash_0 = PyLong_FromLong((uint16_t)((object->hash)[hash_cntr_0]));
			PyList_SetItem(py_hash, hash_cntr_0, py_hash_0);
		}
	}
	return py_hash;
}

static int py_package_PrimaryWDigestHash_set_hash(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryWDigestHash *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->hash");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int hash_cntr_0;
		if (ARRAY_SIZE(object->hash) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->hash),  PyList_GET_SIZE(value));
			return -1;
		}
		for (hash_cntr_0 = 0; hash_cntr_0 < PyList_GET_SIZE(value); hash_cntr_0++) {
			if (PyList_GET_ITEM(value, hash_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->hash)[hash_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->hash)[hash_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, hash_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, hash_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->hash)[hash_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryWDigestHash_getsetters[] = {
	{
		.name = discard_const_p(char, "hash"),
		.get = py_package_PrimaryWDigestHash_get_hash,
		.set = py_package_PrimaryWDigestHash_set_hash,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryWDigestHash_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryWDigestHash, type);
}


static PyTypeObject package_PrimaryWDigestHash_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryWDigestHash",
	.tp_getset = py_package_PrimaryWDigestHash_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryWDigestHash_new,
};


static PyObject *py_package_PrimaryWDigestBlob_get_unknown1(PyObject *obj, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromLong((uint16_t)(object->unknown1));
	return py_unknown1;
}

static int py_package_PrimaryWDigestBlob_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryWDigestBlob_get_unknown2(PyObject *obj, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromLong((uint16_t)(object->unknown2));
	return py_unknown2;
}

static int py_package_PrimaryWDigestBlob_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryWDigestBlob_get_num_hashes(PyObject *obj, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_num_hashes;
	py_num_hashes = PyLong_FromLong((uint16_t)(object->num_hashes));
	return py_num_hashes;
}

static int py_package_PrimaryWDigestBlob_set_num_hashes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_hashes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_hashes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_hashes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryWDigestBlob_get_unknown3(PyObject *obj, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown3));
	return py_unknown3;
}

static int py_package_PrimaryWDigestBlob_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryWDigestBlob_get_uuknown4(PyObject *obj, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_uuknown4;
	py_uuknown4 = PyLong_FromUnsignedLongLong(object->uuknown4);
	return py_uuknown4;
}

static int py_package_PrimaryWDigestBlob_set_uuknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->uuknown4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->uuknown4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->uuknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryWDigestBlob_get_hashes(PyObject *obj, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_hashes;
	py_hashes = PyList_New(object->num_hashes);
	if (py_hashes == NULL) {
		return NULL;
	}
	{
		int hashes_cntr_0;
		for (hashes_cntr_0 = 0; hashes_cntr_0 < (object->num_hashes); hashes_cntr_0++) {
			PyObject *py_hashes_0;
			py_hashes_0 = pytalloc_reference_ex(&package_PrimaryWDigestHash_Type, object->hashes, &(object->hashes)[hashes_cntr_0]);
			PyList_SetItem(py_hashes, hashes_cntr_0, py_hashes_0);
		}
	}
	return py_hashes;
}

static int py_package_PrimaryWDigestBlob_set_hashes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->hashes");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int hashes_cntr_0;
		object->hashes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->hashes, PyList_GET_SIZE(value));
		if (!object->hashes) { return -1; }
		talloc_set_name_const(object->hashes, "ARRAY: object->hashes");
		for (hashes_cntr_0 = 0; hashes_cntr_0 < PyList_GET_SIZE(value); hashes_cntr_0++) {
			if (PyList_GET_ITEM(value, hashes_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->hashes)[hashes_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryWDigestHash_Type, PyList_GET_ITEM(value, hashes_cntr_0), return -1;);
			if (talloc_reference(object->hashes, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, hashes_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->hashes)[hashes_cntr_0] = *(struct package_PrimaryWDigestHash *)pytalloc_get_ptr(PyList_GET_ITEM(value, hashes_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryWDigestBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_package_PrimaryWDigestBlob_get_unknown1,
		.set = py_package_PrimaryWDigestBlob_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_package_PrimaryWDigestBlob_get_unknown2,
		.set = py_package_PrimaryWDigestBlob_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "num_hashes"),
		.get = py_package_PrimaryWDigestBlob_get_num_hashes,
		.set = py_package_PrimaryWDigestBlob_set_num_hashes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_package_PrimaryWDigestBlob_get_unknown3,
		.set = py_package_PrimaryWDigestBlob_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "uuknown4"),
		.get = py_package_PrimaryWDigestBlob_get_uuknown4,
		.set = py_package_PrimaryWDigestBlob_set_uuknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type udlong")
	},
	{
		.name = discard_const_p(char, "hashes"),
		.get = py_package_PrimaryWDigestBlob_get_hashes,
		.set = py_package_PrimaryWDigestBlob_set_hashes,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryWDigestHash")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryWDigestBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryWDigestBlob, type);
}

static PyObject *py_package_PrimaryWDigestBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_package_PrimaryWDigestBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_package_PrimaryWDigestBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryWDigestBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryWDigestBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_package_PrimaryWDigestBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryWDigestBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_package_PrimaryWDigestBlob, "package_PrimaryWDigestBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_package_PrimaryWDigestBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_package_PrimaryWDigestBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PrimaryWDigestBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_package_PrimaryWDigestBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject package_PrimaryWDigestBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryWDigestBlob",
	.tp_getset = py_package_PrimaryWDigestBlob_getsetters,
	.tp_methods = py_package_PrimaryWDigestBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryWDigestBlob_new,
};


static PyObject *py_package_PrimarySambaGPGBlob_get_gpg_blob(PyObject *obj, void *closure)
{
	struct package_PrimarySambaGPGBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_gpg_blob;
	py_gpg_blob = PyBytes_FromStringAndSize((char *)(object->gpg_blob).data, (object->gpg_blob).length);
	return py_gpg_blob;
}

static int py_package_PrimarySambaGPGBlob_set_gpg_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimarySambaGPGBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->gpg_blob");
		return -1;
	}
	object->gpg_blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_package_PrimarySambaGPGBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "gpg_blob"),
		.get = py_package_PrimarySambaGPGBlob_get_gpg_blob,
		.set = py_package_PrimarySambaGPGBlob_set_gpg_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimarySambaGPGBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimarySambaGPGBlob, type);
}

static PyObject *py_package_PrimarySambaGPGBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct package_PrimarySambaGPGBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_package_PrimarySambaGPGBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_package_PrimarySambaGPGBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct package_PrimarySambaGPGBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimarySambaGPGBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimarySambaGPGBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_package_PrimarySambaGPGBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct package_PrimarySambaGPGBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_package_PrimarySambaGPGBlob, "package_PrimarySambaGPGBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_package_PrimarySambaGPGBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_package_PrimarySambaGPGBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PrimarySambaGPGBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_package_PrimarySambaGPGBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject package_PrimarySambaGPGBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimarySambaGPGBlob",
	.tp_getset = py_package_PrimarySambaGPGBlob_getsetters,
	.tp_methods = py_package_PrimarySambaGPGBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimarySambaGPGBlob_new,
};


static PyObject *py_package_PrimaryUserPasswordValue_get_scheme_len(PyObject *obj, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(obj);
	PyObject *py_scheme_len;
	py_scheme_len = PyLong_FromLong((uint16_t)(object->scheme_len));
	return py_scheme_len;
}

static int py_package_PrimaryUserPasswordValue_set_scheme_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->scheme_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->scheme_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->scheme_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryUserPasswordValue_get_scheme(PyObject *obj, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(obj);
	PyObject *py_scheme;
	if (object->scheme == NULL) {
		py_scheme = Py_None;
		Py_INCREF(py_scheme);
	} else {
		py_scheme = PyUnicode_Decode(object->scheme, strlen(object->scheme), "utf-8", "ignore");
	}
	return py_scheme;
}

static int py_package_PrimaryUserPasswordValue_set_scheme(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->scheme");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->scheme = talloc_str;
	}
	return 0;
}

static PyObject *py_package_PrimaryUserPasswordValue_get_value_len(PyObject *obj, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(obj);
	PyObject *py_value_len;
	py_value_len = PyLong_FromUnsignedLongLong((uint32_t)(object->value_len));
	return py_value_len;
}

static int py_package_PrimaryUserPasswordValue_set_value_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryUserPasswordValue_get_value(PyObject *obj, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	if (object->value == NULL) {
		Py_RETURN_NONE;
	}
	if (object->value == NULL) {
		py_value = Py_None;
		Py_INCREF(py_value);
	} else {
		py_value = PyBytes_FromStringAndSize((char *)(*object->value).data, (*object->value).length);
	}
	return py_value;
}

static int py_package_PrimaryUserPasswordValue_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryUserPasswordValue *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->value));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->value");
		return -1;
	}
	if (value == Py_None) {
		object->value = NULL;
	} else {
		object->value = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->value);
		if (object->value == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->value = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryUserPasswordValue_getsetters[] = {
	{
		.name = discard_const_p(char, "scheme_len"),
		.get = py_package_PrimaryUserPasswordValue_get_scheme_len,
		.set = py_package_PrimaryUserPasswordValue_set_scheme_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "scheme"),
		.get = py_package_PrimaryUserPasswordValue_get_scheme,
		.set = py_package_PrimaryUserPasswordValue_set_scheme,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "value_len"),
		.get = py_package_PrimaryUserPasswordValue_get_value_len,
		.set = py_package_PrimaryUserPasswordValue_set_value_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "value"),
		.get = py_package_PrimaryUserPasswordValue_get_value,
		.set = py_package_PrimaryUserPasswordValue_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryUserPasswordValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryUserPasswordValue, type);
}


static PyTypeObject package_PrimaryUserPasswordValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryUserPasswordValue",
	.tp_getset = py_package_PrimaryUserPasswordValue_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryUserPasswordValue_new,
};


static PyObject *py_package_PrimaryUserPasswordBlob_get_current_nt_hash(PyObject *obj, void *closure)
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_current_nt_hash;
	py_current_nt_hash = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->current_nt_hash);
	return py_current_nt_hash;
}

static int py_package_PrimaryUserPasswordBlob_set_current_nt_hash(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->current_nt_hash");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->current_nt_hash = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_package_PrimaryUserPasswordBlob_get_num_hashes(PyObject *obj, void *closure)
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_num_hashes;
	py_num_hashes = PyLong_FromLong((uint16_t)(object->num_hashes));
	return py_num_hashes;
}

static int py_package_PrimaryUserPasswordBlob_set_num_hashes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_hashes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_hashes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_hashes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_package_PrimaryUserPasswordBlob_get_hashes(PyObject *obj, void *closure)
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_hashes;
	py_hashes = PyList_New(object->num_hashes);
	if (py_hashes == NULL) {
		return NULL;
	}
	{
		int hashes_cntr_0;
		for (hashes_cntr_0 = 0; hashes_cntr_0 < (object->num_hashes); hashes_cntr_0++) {
			PyObject *py_hashes_0;
			py_hashes_0 = pytalloc_reference_ex(&package_PrimaryUserPasswordValue_Type, object->hashes, &(object->hashes)[hashes_cntr_0]);
			PyList_SetItem(py_hashes, hashes_cntr_0, py_hashes_0);
		}
	}
	return py_hashes;
}

static int py_package_PrimaryUserPasswordBlob_set_hashes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->hashes");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int hashes_cntr_0;
		object->hashes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->hashes, PyList_GET_SIZE(value));
		if (!object->hashes) { return -1; }
		talloc_set_name_const(object->hashes, "ARRAY: object->hashes");
		for (hashes_cntr_0 = 0; hashes_cntr_0 < PyList_GET_SIZE(value); hashes_cntr_0++) {
			if (PyList_GET_ITEM(value, hashes_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->hashes)[hashes_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&package_PrimaryUserPasswordValue_Type, PyList_GET_ITEM(value, hashes_cntr_0), return -1;);
			if (talloc_reference(object->hashes, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, hashes_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->hashes)[hashes_cntr_0] = *(struct package_PrimaryUserPasswordValue *)pytalloc_get_ptr(PyList_GET_ITEM(value, hashes_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_package_PrimaryUserPasswordBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "current_nt_hash"),
		.get = py_package_PrimaryUserPasswordBlob_get_current_nt_hash,
		.set = py_package_PrimaryUserPasswordBlob_set_current_nt_hash,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{
		.name = discard_const_p(char, "num_hashes"),
		.get = py_package_PrimaryUserPasswordBlob_get_num_hashes,
		.set = py_package_PrimaryUserPasswordBlob_set_num_hashes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "hashes"),
		.get = py_package_PrimaryUserPasswordBlob_get_hashes,
		.set = py_package_PrimaryUserPasswordBlob_set_hashes,
		.doc = discard_const_p(char, "PIDL-generated element of base type package_PrimaryUserPasswordValue")
	},
	{ .name = NULL }
};

static PyObject *py_package_PrimaryUserPasswordBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct package_PrimaryUserPasswordBlob, type);
}

static PyObject *py_package_PrimaryUserPasswordBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_package_PrimaryUserPasswordBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_package_PrimaryUserPasswordBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryUserPasswordBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_package_PrimaryUserPasswordBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_package_PrimaryUserPasswordBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct package_PrimaryUserPasswordBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_package_PrimaryUserPasswordBlob, "package_PrimaryUserPasswordBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_package_PrimaryUserPasswordBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_package_PrimaryUserPasswordBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_package_PrimaryUserPasswordBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_package_PrimaryUserPasswordBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject package_PrimaryUserPasswordBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.package_PrimaryUserPasswordBlob",
	.tp_getset = py_package_PrimaryUserPasswordBlob_getsetters,
	.tp_methods = py_package_PrimaryUserPasswordBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_package_PrimaryUserPasswordBlob_new,
};


static PyObject *py_AuthInfoNone_get_size(PyObject *obj, void *closure)
{
	struct AuthInfoNone *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_AuthInfoNone_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthInfoNone *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_AuthInfoNone_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_AuthInfoNone_get_size,
		.set = py_AuthInfoNone_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_AuthInfoNone_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AuthInfoNone, type);
}


static PyTypeObject AuthInfoNone_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.AuthInfoNone",
	.tp_getset = py_AuthInfoNone_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AuthInfoNone_new,
};


static PyObject *py_AuthInfoNT4Owf_get_size(PyObject *obj, void *closure)
{
	struct AuthInfoNT4Owf *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_AuthInfoNT4Owf_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthInfoNT4Owf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AuthInfoNT4Owf_get_password(PyObject *obj, void *closure)
{
	struct AuthInfoNT4Owf *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_AuthInfoNT4Owf_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthInfoNT4Owf *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->password");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_AuthInfoNT4Owf_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_AuthInfoNT4Owf_get_size,
		.set = py_AuthInfoNT4Owf_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_AuthInfoNT4Owf_get_password,
		.set = py_AuthInfoNT4Owf_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{ .name = NULL }
};

static PyObject *py_AuthInfoNT4Owf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AuthInfoNT4Owf, type);
}


static PyTypeObject AuthInfoNT4Owf_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.AuthInfoNT4Owf",
	.tp_getset = py_AuthInfoNT4Owf_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AuthInfoNT4Owf_new,
};


static PyObject *py_AuthInfoClear_get_size(PyObject *obj, void *closure)
{
	struct AuthInfoClear *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_AuthInfoClear_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthInfoClear *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AuthInfoClear_get_password(PyObject *obj, void *closure)
{
	struct AuthInfoClear *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = PyList_New(object->size);
	if (py_password == NULL) {
		return NULL;
	}
	{
		int password_cntr_0;
		for (password_cntr_0 = 0; password_cntr_0 < (object->size); password_cntr_0++) {
			PyObject *py_password_0;
			py_password_0 = PyLong_FromLong((uint16_t)((object->password)[password_cntr_0]));
			PyList_SetItem(py_password, password_cntr_0, py_password_0);
		}
	}
	return py_password;
}

static int py_AuthInfoClear_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthInfoClear *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->password");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int password_cntr_0;
		object->password = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->password, PyList_GET_SIZE(value));
		if (!object->password) { return -1; }
		talloc_set_name_const(object->password, "ARRAY: object->password");
		for (password_cntr_0 = 0; password_cntr_0 < PyList_GET_SIZE(value); password_cntr_0++) {
			if (PyList_GET_ITEM(value, password_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->password)[password_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->password)[password_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, password_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, password_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->password)[password_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_AuthInfoClear_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_AuthInfoClear_get_size,
		.set = py_AuthInfoClear_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_AuthInfoClear_get_password,
		.set = py_AuthInfoClear_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_AuthInfoClear_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AuthInfoClear, type);
}


static PyTypeObject AuthInfoClear_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.AuthInfoClear",
	.tp_getset = py_AuthInfoClear_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AuthInfoClear_new,
};


static PyObject *py_AuthInfoVersion_get_size(PyObject *obj, void *closure)
{
	struct AuthInfoVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_AuthInfoVersion_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthInfoVersion *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AuthInfoVersion_get_version(PyObject *obj, void *closure)
{
	struct AuthInfoVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_AuthInfoVersion_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthInfoVersion *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_AuthInfoVersion_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_AuthInfoVersion_get_size,
		.set = py_AuthInfoVersion_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_AuthInfoVersion_get_version,
		.set = py_AuthInfoVersion_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_AuthInfoVersion_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AuthInfoVersion, type);
}


static PyTypeObject AuthInfoVersion_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.AuthInfoVersion",
	.tp_getset = py_AuthInfoVersion_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AuthInfoVersion_new,
};

static PyObject *py_import_AuthInfo(TALLOC_CTX *mem_ctx, int level, union AuthInfo *in)
{
	PyObject *ret;

	switch (level) {
		case TRUST_AUTH_TYPE_NONE:
			ret = pytalloc_reference_ex(&AuthInfoNone_Type, mem_ctx, &in->none);
			return ret;

		case TRUST_AUTH_TYPE_NT4OWF:
			ret = pytalloc_reference_ex(&AuthInfoNT4Owf_Type, mem_ctx, &in->nt4owf);
			return ret;

		case TRUST_AUTH_TYPE_CLEAR:
			ret = pytalloc_reference_ex(&AuthInfoClear_Type, mem_ctx, &in->clear);
			return ret;

		case TRUST_AUTH_TYPE_VERSION:
			ret = pytalloc_reference_ex(&AuthInfoVersion_Type, mem_ctx, &in->version);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union AuthInfo *py_export_AuthInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union AuthInfo *ret = talloc_zero(mem_ctx, union AuthInfo);
	switch (level) {
		case TRUST_AUTH_TYPE_NONE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->none");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&AuthInfoNone_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->none = *(struct AuthInfoNone *)pytalloc_get_ptr(in);
			break;

		case TRUST_AUTH_TYPE_NT4OWF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->nt4owf");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&AuthInfoNT4Owf_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->nt4owf = *(struct AuthInfoNT4Owf *)pytalloc_get_ptr(in);
			break;

		case TRUST_AUTH_TYPE_CLEAR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->clear");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&AuthInfoClear_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->clear = *(struct AuthInfoClear *)pytalloc_get_ptr(in);
			break;

		case TRUST_AUTH_TYPE_VERSION:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->version");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&AuthInfoVersion_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->version = *(struct AuthInfoVersion *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_AuthInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union AuthInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union AuthInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union AuthInfo!");
		return NULL;
	}

	return py_import_AuthInfo(mem_ctx, level, in);
}

static PyObject *py_AuthInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union AuthInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_AuthInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_AuthInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AuthInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AuthInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_AuthInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject AuthInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.AuthInfo",
	.tp_getset = NULL,
	.tp_methods = py_AuthInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AuthInfo_new,
};


static PyObject *py_AuthenticationInformation_get_LastUpdateTime(PyObject *obj, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_LastUpdateTime;
	py_LastUpdateTime = PyLong_FromUnsignedLongLong(object->LastUpdateTime);
	return py_LastUpdateTime;
}

static int py_AuthenticationInformation_set_LastUpdateTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->LastUpdateTime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->LastUpdateTime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->LastUpdateTime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AuthenticationInformation_get_AuthType(PyObject *obj, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_AuthType;
	py_AuthType = PyLong_FromUnsignedLongLong((uint32_t)(object->AuthType));
	return py_AuthType;
}

static int py_AuthenticationInformation_set_AuthType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->AuthType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AuthType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AuthType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AuthenticationInformation_get_AuthInfo(PyObject *obj, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_AuthInfo;
	py_AuthInfo = pyrpc_import_union(&AuthInfo_Type, pytalloc_get_mem_ctx(obj), object->AuthType, &object->AuthInfo, "union AuthInfo");
	if (py_AuthInfo == NULL) {
		return NULL;
	}
	return py_AuthInfo;
}

static int py_AuthenticationInformation_set_AuthInfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->AuthInfo");
		return -1;
	}
	{
		union AuthInfo *AuthInfo_switch_0;
		AuthInfo_switch_0 = (union AuthInfo *)pyrpc_export_union(&AuthInfo_Type, pytalloc_get_mem_ctx(py_obj), object->AuthType, value, "union AuthInfo");
		if (AuthInfo_switch_0 == NULL) {
			return -1;
		}
		object->AuthInfo = *AuthInfo_switch_0;
	}
	return 0;
}

static PyObject *py_AuthenticationInformation_get__pad(PyObject *obj, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_AuthenticationInformation_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_AuthenticationInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "LastUpdateTime"),
		.get = py_AuthenticationInformation_get_LastUpdateTime,
		.set = py_AuthenticationInformation_set_LastUpdateTime,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "AuthType"),
		.get = py_AuthenticationInformation_get_AuthType,
		.set = py_AuthenticationInformation_set_AuthType,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustAuthType")
	},
	{
		.name = discard_const_p(char, "AuthInfo"),
		.get = py_AuthenticationInformation_get_AuthInfo,
		.set = py_AuthenticationInformation_set_AuthInfo,
		.doc = discard_const_p(char, "PIDL-generated element of base type AuthInfo")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_AuthenticationInformation_get__pad,
		.set = py_AuthenticationInformation_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_AuthenticationInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AuthenticationInformation, type);
}

static PyObject *py_AuthenticationInformation_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_AuthenticationInformation);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_AuthenticationInformation_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AuthenticationInformation);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AuthenticationInformation);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_AuthenticationInformation_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct AuthenticationInformation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AuthenticationInformation, "AuthenticationInformation", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_AuthenticationInformation_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_AuthenticationInformation_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AuthenticationInformation_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_AuthenticationInformation_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject AuthenticationInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.AuthenticationInformation",
	.tp_getset = py_AuthenticationInformation_getsetters,
	.tp_methods = py_AuthenticationInformation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AuthenticationInformation_new,
};


static PyObject *py_AuthenticationInformationArray_get_count(PyObject *obj, void *closure)
{
	struct AuthenticationInformationArray *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_AuthenticationInformationArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthenticationInformationArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AuthenticationInformationArray_get_array(PyObject *obj, void *closure)
{
	struct AuthenticationInformationArray *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	py_array = PyList_New(object->count);
	if (py_array == NULL) {
		return NULL;
	}
	{
		int array_cntr_0;
		for (array_cntr_0 = 0; array_cntr_0 < (object->count); array_cntr_0++) {
			PyObject *py_array_0;
			py_array_0 = pytalloc_reference_ex(&AuthenticationInformation_Type, object->array, &(object->array)[array_cntr_0]);
			PyList_SetItem(py_array, array_cntr_0, py_array_0);
		}
	}
	return py_array;
}

static int py_AuthenticationInformationArray_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AuthenticationInformationArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int array_cntr_0;
		object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
		if (!object->array) { return -1; }
		talloc_set_name_const(object->array, "ARRAY: object->array");
		for (array_cntr_0 = 0; array_cntr_0 < PyList_GET_SIZE(value); array_cntr_0++) {
			if (PyList_GET_ITEM(value, array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->array)[array_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&AuthenticationInformation_Type, PyList_GET_ITEM(value, array_cntr_0), return -1;);
			if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->array)[array_cntr_0] = *(struct AuthenticationInformation *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_AuthenticationInformationArray_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_AuthenticationInformationArray_get_count,
		.set = py_AuthenticationInformationArray_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_AuthenticationInformationArray_get_array,
		.set = py_AuthenticationInformationArray_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type AuthenticationInformation")
	},
	{ .name = NULL }
};

static PyObject *py_AuthenticationInformationArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AuthenticationInformationArray, type);
}

static PyObject *py_AuthenticationInformationArray_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct AuthenticationInformationArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_AuthenticationInformationArray);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_AuthenticationInformationArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AuthenticationInformationArray *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AuthenticationInformationArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AuthenticationInformationArray);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_AuthenticationInformationArray_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct AuthenticationInformationArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AuthenticationInformationArray, "AuthenticationInformationArray", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_AuthenticationInformationArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_AuthenticationInformationArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AuthenticationInformationArray_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_AuthenticationInformationArray_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject AuthenticationInformationArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.AuthenticationInformationArray",
	.tp_getset = py_AuthenticationInformationArray_getsetters,
	.tp_methods = py_AuthenticationInformationArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AuthenticationInformationArray_new,
};


static PyObject *py_trustAuthInOutBlob_get_count(PyObject *obj, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_trustAuthInOutBlob_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_trustAuthInOutBlob_get_current_offset(PyObject *obj, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_current_offset;
	py_current_offset = PyLong_FromUnsignedLongLong((uint32_t)(object->current_offset));
	return py_current_offset;
}

static int py_trustAuthInOutBlob_set_current_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->current_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->current_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->current_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_trustAuthInOutBlob_get_previous_offset(PyObject *obj, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_previous_offset;
	py_previous_offset = PyLong_FromUnsignedLongLong((uint32_t)(object->previous_offset));
	return py_previous_offset;
}

static int py_trustAuthInOutBlob_set_previous_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->previous_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->previous_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->previous_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_trustAuthInOutBlob_get_current(PyObject *obj, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_current;
	py_current = pytalloc_reference_ex(&AuthenticationInformationArray_Type, pytalloc_get_mem_ctx(obj), &object->current);
	return py_current;
}

static int py_trustAuthInOutBlob_set_current(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->current");
		return -1;
	}
	PY_CHECK_TYPE(&AuthenticationInformationArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->current = *(struct AuthenticationInformationArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_trustAuthInOutBlob_get_previous(PyObject *obj, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_previous;
	py_previous = pytalloc_reference_ex(&AuthenticationInformationArray_Type, pytalloc_get_mem_ctx(obj), &object->previous);
	return py_previous;
}

static int py_trustAuthInOutBlob_set_previous(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->previous");
		return -1;
	}
	PY_CHECK_TYPE(&AuthenticationInformationArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->previous = *(struct AuthenticationInformationArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_trustAuthInOutBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_trustAuthInOutBlob_get_count,
		.set = py_trustAuthInOutBlob_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "current_offset"),
		.get = py_trustAuthInOutBlob_get_current_offset,
		.set = py_trustAuthInOutBlob_set_current_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "previous_offset"),
		.get = py_trustAuthInOutBlob_get_previous_offset,
		.set = py_trustAuthInOutBlob_set_previous_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "current"),
		.get = py_trustAuthInOutBlob_get_current,
		.set = py_trustAuthInOutBlob_set_current,
		.doc = discard_const_p(char, "PIDL-generated element of base type AuthenticationInformationArray")
	},
	{
		.name = discard_const_p(char, "previous"),
		.get = py_trustAuthInOutBlob_get_previous,
		.set = py_trustAuthInOutBlob_set_previous,
		.doc = discard_const_p(char, "PIDL-generated element of base type AuthenticationInformationArray")
	},
	{ .name = NULL }
};

static PyObject *py_trustAuthInOutBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct trustAuthInOutBlob, type);
}

static PyObject *py_trustAuthInOutBlob_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_trustAuthInOutBlob);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_trustAuthInOutBlob_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_trustAuthInOutBlob);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_trustAuthInOutBlob);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_trustAuthInOutBlob_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct trustAuthInOutBlob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_trustAuthInOutBlob, "trustAuthInOutBlob", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_trustAuthInOutBlob_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_trustAuthInOutBlob_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_trustAuthInOutBlob_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_trustAuthInOutBlob_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject trustAuthInOutBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.trustAuthInOutBlob",
	.tp_getset = py_trustAuthInOutBlob_getsetters,
	.tp_methods = py_trustAuthInOutBlob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_trustAuthInOutBlob_new,
};


static PyObject *py_trustDomainPasswords_get_confounder(PyObject *obj, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(obj);
	PyObject *py_confounder;
	py_confounder = PyList_New(512);
	if (py_confounder == NULL) {
		return NULL;
	}
	{
		int confounder_cntr_0;
		for (confounder_cntr_0 = 0; confounder_cntr_0 < (512); confounder_cntr_0++) {
			PyObject *py_confounder_0;
			py_confounder_0 = PyLong_FromLong((uint16_t)((object->confounder)[confounder_cntr_0]));
			PyList_SetItem(py_confounder, confounder_cntr_0, py_confounder_0);
		}
	}
	return py_confounder;
}

static int py_trustDomainPasswords_set_confounder(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->confounder");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int confounder_cntr_0;
		if (ARRAY_SIZE(object->confounder) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->confounder),  PyList_GET_SIZE(value));
			return -1;
		}
		for (confounder_cntr_0 = 0; confounder_cntr_0 < PyList_GET_SIZE(value); confounder_cntr_0++) {
			if (PyList_GET_ITEM(value, confounder_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->confounder)[confounder_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->confounder)[confounder_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, confounder_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, confounder_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->confounder)[confounder_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_trustDomainPasswords_get_outgoing(PyObject *obj, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(obj);
	PyObject *py_outgoing;
	py_outgoing = pytalloc_reference_ex(&trustAuthInOutBlob_Type, pytalloc_get_mem_ctx(obj), &object->outgoing);
	return py_outgoing;
}

static int py_trustDomainPasswords_set_outgoing(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->outgoing");
		return -1;
	}
	PY_CHECK_TYPE(&trustAuthInOutBlob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->outgoing = *(struct trustAuthInOutBlob *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_trustDomainPasswords_get_incoming(PyObject *obj, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(obj);
	PyObject *py_incoming;
	py_incoming = pytalloc_reference_ex(&trustAuthInOutBlob_Type, pytalloc_get_mem_ctx(obj), &object->incoming);
	return py_incoming;
}

static int py_trustDomainPasswords_set_incoming(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->incoming");
		return -1;
	}
	PY_CHECK_TYPE(&trustAuthInOutBlob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->incoming = *(struct trustAuthInOutBlob *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_trustDomainPasswords_get_outgoing_size(PyObject *obj, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(obj);
	PyObject *py_outgoing_size;
	py_outgoing_size = PyLong_FromUnsignedLongLong((uint32_t)(object->outgoing_size));
	return py_outgoing_size;
}

static int py_trustDomainPasswords_set_outgoing_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->outgoing_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->outgoing_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->outgoing_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_trustDomainPasswords_get_incoming_size(PyObject *obj, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(obj);
	PyObject *py_incoming_size;
	py_incoming_size = PyLong_FromUnsignedLongLong((uint32_t)(object->incoming_size));
	return py_incoming_size;
}

static int py_trustDomainPasswords_set_incoming_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->incoming_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->incoming_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->incoming_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_trustDomainPasswords_getsetters[] = {
	{
		.name = discard_const_p(char, "confounder"),
		.get = py_trustDomainPasswords_get_confounder,
		.set = py_trustDomainPasswords_set_confounder,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "outgoing"),
		.get = py_trustDomainPasswords_get_outgoing,
		.set = py_trustDomainPasswords_set_outgoing,
		.doc = discard_const_p(char, "PIDL-generated element of base type trustAuthInOutBlob")
	},
	{
		.name = discard_const_p(char, "incoming"),
		.get = py_trustDomainPasswords_get_incoming,
		.set = py_trustDomainPasswords_set_incoming,
		.doc = discard_const_p(char, "PIDL-generated element of base type trustAuthInOutBlob")
	},
	{
		.name = discard_const_p(char, "outgoing_size"),
		.get = py_trustDomainPasswords_get_outgoing_size,
		.set = py_trustDomainPasswords_set_outgoing_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "incoming_size"),
		.get = py_trustDomainPasswords_get_incoming_size,
		.set = py_trustDomainPasswords_set_incoming_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_trustDomainPasswords_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct trustDomainPasswords, type);
}

static PyObject *py_trustDomainPasswords_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_trustDomainPasswords);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_trustDomainPasswords_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_trustDomainPasswords);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_trustDomainPasswords);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_trustDomainPasswords_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct trustDomainPasswords *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_trustDomainPasswords, "trustDomainPasswords", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_trustDomainPasswords_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_trustDomainPasswords_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_trustDomainPasswords_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_trustDomainPasswords_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject trustDomainPasswords_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.trustDomainPasswords",
	.tp_getset = py_trustDomainPasswords_getsetters,
	.tp_methods = py_trustDomainPasswords_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_trustDomainPasswords_new,
};


static PyObject *py_DsCompressedChunk_get_marker(PyObject *obj, void *closure)
{
	struct DsCompressedChunk *object = pytalloc_get_ptr(obj);
	PyObject *py_marker;
	py_marker = PyLong_FromUnsignedLongLong((uint32_t)(object->marker));
	return py_marker;
}

static int py_DsCompressedChunk_set_marker(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DsCompressedChunk *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->marker");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->marker));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->marker = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DsCompressedChunk_get_data(PyObject *obj, void *closure)
{
	struct DsCompressedChunk *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyBytes_FromStringAndSize((char *)(object->data).data, (object->data).length);
	return py_data;
}

static int py_DsCompressedChunk_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DsCompressedChunk *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	object->data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_DsCompressedChunk_getsetters[] = {
	{
		.name = discard_const_p(char, "marker"),
		.get = py_DsCompressedChunk_get_marker,
		.set = py_DsCompressedChunk_set_marker,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_DsCompressedChunk_get_data,
		.set = py_DsCompressedChunk_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_DsCompressedChunk_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DsCompressedChunk, type);
}

static PyObject *py_DsCompressedChunk_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct DsCompressedChunk *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_DsCompressedChunk);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_DsCompressedChunk_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DsCompressedChunk *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DsCompressedChunk);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DsCompressedChunk);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DsCompressedChunk_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct DsCompressedChunk *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DsCompressedChunk, "DsCompressedChunk", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DsCompressedChunk_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DsCompressedChunk_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DsCompressedChunk_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DsCompressedChunk_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DsCompressedChunk_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.DsCompressedChunk",
	.tp_getset = py_DsCompressedChunk_getsetters,
	.tp_methods = py_DsCompressedChunk_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DsCompressedChunk_new,
};


static PyObject *py_ExtendedErrorAString_get___size(PyObject *obj, void *closure)
{
	struct ExtendedErrorAString *object = pytalloc_get_ptr(obj);
	PyObject *py___size;
	py___size = PyLong_FromLong((uint16_t)(object->__size));
	return py___size;
}

static int py_ExtendedErrorAString_set___size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorAString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->__size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorAString_get_string(PyObject *obj, void *closure)
{
	struct ExtendedErrorAString *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_ExtendedErrorAString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorAString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_ExtendedErrorAString_getsetters[] = {
	{
		.name = discard_const_p(char, "__size"),
		.get = py_ExtendedErrorAString_get___size,
		.set = py_ExtendedErrorAString_set___size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_ExtendedErrorAString_get_string,
		.set = py_ExtendedErrorAString_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_ExtendedErrorAString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ExtendedErrorAString, type);
}


static PyTypeObject ExtendedErrorAString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorAString",
	.tp_getset = py_ExtendedErrorAString_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorAString_new,
};


static PyObject *py_ExtendedErrorUString_get___size(PyObject *obj, void *closure)
{
	struct ExtendedErrorUString *object = pytalloc_get_ptr(obj);
	PyObject *py___size;
	py___size = PyLong_FromLong((uint16_t)(object->__size));
	return py___size;
}

static int py_ExtendedErrorUString_set___size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorUString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->__size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorUString_get_string(PyObject *obj, void *closure)
{
	struct ExtendedErrorUString *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_ExtendedErrorUString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorUString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_ExtendedErrorUString_getsetters[] = {
	{
		.name = discard_const_p(char, "__size"),
		.get = py_ExtendedErrorUString_get___size,
		.set = py_ExtendedErrorUString_set___size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_ExtendedErrorUString_get_string,
		.set = py_ExtendedErrorUString_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_ExtendedErrorUString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ExtendedErrorUString, type);
}


static PyTypeObject ExtendedErrorUString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorUString",
	.tp_getset = py_ExtendedErrorUString_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorUString_new,
};


static PyObject *py_ExtendedErrorBlob_get_length(PyObject *obj, void *closure)
{
	struct ExtendedErrorBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_ExtendedErrorBlob_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorBlob_get_data(PyObject *obj, void *closure)
{
	struct ExtendedErrorBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_ExtendedErrorBlob_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorBlob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_ExtendedErrorBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_ExtendedErrorBlob_get_length,
		.set = py_ExtendedErrorBlob_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_ExtendedErrorBlob_get_data,
		.set = py_ExtendedErrorBlob_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_ExtendedErrorBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ExtendedErrorBlob, type);
}


static PyTypeObject ExtendedErrorBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorBlob",
	.tp_getset = py_ExtendedErrorBlob_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorBlob_new,
};

static PyObject *py_import_ExtendedErrorComputerNameU(TALLOC_CTX *mem_ctx, int level, union ExtendedErrorComputerNameU *in)
{
	PyObject *ret;

	switch (level) {
		case EXTENDED_ERROR_COMPUTER_NAME_PRESENT:
			ret = pytalloc_reference_ex(&ExtendedErrorUString_Type, mem_ctx, &in->name);
			return ret;

		case EXTENDED_ERROR_COMPUTER_NAME_NOT_PRESENT:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ExtendedErrorComputerNameU *py_export_ExtendedErrorComputerNameU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ExtendedErrorComputerNameU *ret = talloc_zero(mem_ctx, union ExtendedErrorComputerNameU);
	switch (level) {
		case EXTENDED_ERROR_COMPUTER_NAME_PRESENT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ExtendedErrorUString_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct ExtendedErrorUString *)pytalloc_get_ptr(in);
			break;

		case EXTENDED_ERROR_COMPUTER_NAME_NOT_PRESENT:
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_ExtendedErrorComputerNameU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ExtendedErrorComputerNameU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ExtendedErrorComputerNameU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ExtendedErrorComputerNameU!");
		return NULL;
	}

	return py_import_ExtendedErrorComputerNameU(mem_ctx, level, in);
}

static PyObject *py_ExtendedErrorComputerNameU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ExtendedErrorComputerNameU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ExtendedErrorComputerNameU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ExtendedErrorComputerNameU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ExtendedErrorComputerNameU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ExtendedErrorComputerNameU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ExtendedErrorComputerNameU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ExtendedErrorComputerNameU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorComputerNameU",
	.tp_getset = NULL,
	.tp_methods = py_ExtendedErrorComputerNameU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorComputerNameU_new,
};


static PyObject *py_ExtendedErrorComputerName_get_present(PyObject *obj, void *closure)
{
	struct ExtendedErrorComputerName *object = pytalloc_get_ptr(obj);
	PyObject *py_present;
	py_present = PyLong_FromLong((uint16_t)(object->present));
	return py_present;
}

static int py_ExtendedErrorComputerName_set_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorComputerName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->present");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->present));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->present = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorComputerName_get_n(PyObject *obj, void *closure)
{
	struct ExtendedErrorComputerName *object = pytalloc_get_ptr(obj);
	PyObject *py_n;
	py_n = pyrpc_import_union(&ExtendedErrorComputerNameU_Type, pytalloc_get_mem_ctx(obj), object->present, &object->n, "union ExtendedErrorComputerNameU");
	if (py_n == NULL) {
		return NULL;
	}
	return py_n;
}

static int py_ExtendedErrorComputerName_set_n(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorComputerName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->n");
		return -1;
	}
	{
		union ExtendedErrorComputerNameU *n_switch_0;
		n_switch_0 = (union ExtendedErrorComputerNameU *)pyrpc_export_union(&ExtendedErrorComputerNameU_Type, pytalloc_get_mem_ctx(py_obj), object->present, value, "union ExtendedErrorComputerNameU");
		if (n_switch_0 == NULL) {
			return -1;
		}
		object->n = *n_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ExtendedErrorComputerName_getsetters[] = {
	{
		.name = discard_const_p(char, "present"),
		.get = py_ExtendedErrorComputerName_get_present,
		.set = py_ExtendedErrorComputerName_set_present,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorComputerNamePresent")
	},
	{
		.name = discard_const_p(char, "n"),
		.get = py_ExtendedErrorComputerName_get_n,
		.set = py_ExtendedErrorComputerName_set_n,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorComputerNameU")
	},
	{ .name = NULL }
};

static PyObject *py_ExtendedErrorComputerName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ExtendedErrorComputerName, type);
}


static PyTypeObject ExtendedErrorComputerName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorComputerName",
	.tp_getset = py_ExtendedErrorComputerName_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorComputerName_new,
};

static PyObject *py_import_ExtendedErrorParamU(TALLOC_CTX *mem_ctx, int level, union ExtendedErrorParamU *in)
{
	PyObject *ret;

	switch (level) {
		case EXTENDED_ERROR_PARAM_TYPE_ASCII_STRING:
			ret = pytalloc_reference_ex(&ExtendedErrorAString_Type, mem_ctx, &in->a_string);
			return ret;

		case EXTENDED_ERROR_PARAM_TYPE_UNICODE_STRING:
			ret = pytalloc_reference_ex(&ExtendedErrorUString_Type, mem_ctx, &in->u_string);
			return ret;

		case EXTENDED_ERROR_PARAM_TYPE_UINT32:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->uint32));
			return ret;

		case EXTENDED_ERROR_PARAM_TYPE_UINT16:
			ret = PyLong_FromLong((uint16_t)(in->uint16));
			return ret;

		case EXTENDED_ERROR_PARAM_TYPE_UINT64:
			ret = PyLong_FromUnsignedLongLong(in->uint64);
			return ret;

		case EXTENDED_ERROR_PARAM_TYPE_NONE:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case EXTENDED_ERROR_PARAM_TYPE_BLOB:
			ret = pytalloc_reference_ex(&ExtendedErrorBlob_Type, mem_ctx, &in->blob);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ExtendedErrorParamU *py_export_ExtendedErrorParamU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ExtendedErrorParamU *ret = talloc_zero(mem_ctx, union ExtendedErrorParamU);
	switch (level) {
		case EXTENDED_ERROR_PARAM_TYPE_ASCII_STRING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->a_string");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ExtendedErrorAString_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->a_string = *(struct ExtendedErrorAString *)pytalloc_get_ptr(in);
			break;

		case EXTENDED_ERROR_PARAM_TYPE_UNICODE_STRING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->u_string");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ExtendedErrorUString_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->u_string = *(struct ExtendedErrorUString *)pytalloc_get_ptr(in);
			break;

		case EXTENDED_ERROR_PARAM_TYPE_UINT32:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->uint32");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->uint32));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->uint32 = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case EXTENDED_ERROR_PARAM_TYPE_UINT16:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->uint16");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->uint16));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->uint16 = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case EXTENDED_ERROR_PARAM_TYPE_UINT64:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->uint64");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->uint64));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->uint64 = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case EXTENDED_ERROR_PARAM_TYPE_NONE:
			break;

		case EXTENDED_ERROR_PARAM_TYPE_BLOB:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->blob");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ExtendedErrorBlob_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->blob = *(struct ExtendedErrorBlob *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_ExtendedErrorParamU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ExtendedErrorParamU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ExtendedErrorParamU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ExtendedErrorParamU!");
		return NULL;
	}

	return py_import_ExtendedErrorParamU(mem_ctx, level, in);
}

static PyObject *py_ExtendedErrorParamU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ExtendedErrorParamU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ExtendedErrorParamU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ExtendedErrorParamU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ExtendedErrorParamU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ExtendedErrorParamU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ExtendedErrorParamU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ExtendedErrorParamU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorParamU",
	.tp_getset = NULL,
	.tp_methods = py_ExtendedErrorParamU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorParamU_new,
};


static PyObject *py_ExtendedErrorParam_get_type(PyObject *obj, void *closure)
{
	struct ExtendedErrorParam *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_ExtendedErrorParam_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorParam *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorParam_get_p(PyObject *obj, void *closure)
{
	struct ExtendedErrorParam *object = pytalloc_get_ptr(obj);
	PyObject *py_p;
	py_p = pyrpc_import_union(&ExtendedErrorParamU_Type, pytalloc_get_mem_ctx(obj), object->type, &object->p, "union ExtendedErrorParamU");
	if (py_p == NULL) {
		return NULL;
	}
	return py_p;
}

static int py_ExtendedErrorParam_set_p(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorParam *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->p");
		return -1;
	}
	{
		union ExtendedErrorParamU *p_switch_0;
		p_switch_0 = (union ExtendedErrorParamU *)pyrpc_export_union(&ExtendedErrorParamU_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union ExtendedErrorParamU");
		if (p_switch_0 == NULL) {
			return -1;
		}
		object->p = *p_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ExtendedErrorParam_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_ExtendedErrorParam_get_type,
		.set = py_ExtendedErrorParam_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorParamType")
	},
	{
		.name = discard_const_p(char, "p"),
		.get = py_ExtendedErrorParam_get_p,
		.set = py_ExtendedErrorParam_set_p,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorParamU")
	},
	{ .name = NULL }
};

static PyObject *py_ExtendedErrorParam_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ExtendedErrorParam, type);
}


static PyTypeObject ExtendedErrorParam_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorParam",
	.tp_getset = py_ExtendedErrorParam_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorParam_new,
};


static PyObject *py_ExtendedErrorInfo_get_next(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_next;
	if (object->next == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next == NULL) {
		py_next = Py_None;
		Py_INCREF(py_next);
	} else {
		py_next = pytalloc_reference_ex(&ExtendedErrorInfo_Type, object->next, object->next);
	}
	return py_next;
}

static int py_ExtendedErrorInfo_set_next(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->next");
		return -1;
	}
	if (value == Py_None) {
		object->next = NULL;
	} else {
		object->next = NULL;
		PY_CHECK_TYPE(&ExtendedErrorInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next = (struct ExtendedErrorInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_computer_name(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = pytalloc_reference_ex(&ExtendedErrorComputerName_Type, pytalloc_get_mem_ctx(obj), &object->computer_name);
	return py_computer_name;
}

static int py_ExtendedErrorInfo_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->computer_name");
		return -1;
	}
	PY_CHECK_TYPE(&ExtendedErrorComputerName_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->computer_name = *(struct ExtendedErrorComputerName *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_pid(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyLong_FromUnsignedLongLong(object->pid);
	return py_pid;
}

static int py_ExtendedErrorInfo_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_time(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong(object->time);
	return py_time;
}

static int py_ExtendedErrorInfo_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_generating_component(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_generating_component;
	py_generating_component = PyLong_FromUnsignedLongLong((uint32_t)(object->generating_component));
	return py_generating_component;
}

static int py_ExtendedErrorInfo_set_generating_component(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->generating_component");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->generating_component));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->generating_component = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_status(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromWERROR(object->status);
	return py_status;
}

static int py_ExtendedErrorInfo_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->status");
		return -1;
	}
	object->status = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_detection_location(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_detection_location;
	py_detection_location = PyLong_FromLong((uint16_t)(object->detection_location));
	return py_detection_location;
}

static int py_ExtendedErrorInfo_set_detection_location(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->detection_location");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->detection_location));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->detection_location = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_flags(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_ExtendedErrorInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_num_params(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_num_params;
	py_num_params = PyLong_FromLong((uint16_t)(object->num_params));
	return py_num_params;
}

static int py_ExtendedErrorInfo_set_num_params(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->num_params");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_params));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_params = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ExtendedErrorInfo_get_params(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_params;
	py_params = PyList_New(object->num_params);
	if (py_params == NULL) {
		return NULL;
	}
	{
		int params_cntr_0;
		for (params_cntr_0 = 0; params_cntr_0 < (object->num_params); params_cntr_0++) {
			PyObject *py_params_0;
			py_params_0 = pytalloc_reference_ex(&ExtendedErrorParam_Type, object->params, &(object->params)[params_cntr_0]);
			PyList_SetItem(py_params, params_cntr_0, py_params_0);
		}
	}
	return py_params;
}

static int py_ExtendedErrorInfo_set_params(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->params");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int params_cntr_0;
		object->params = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->params, PyList_GET_SIZE(value));
		if (!object->params) { return -1; }
		talloc_set_name_const(object->params, "ARRAY: object->params");
		for (params_cntr_0 = 0; params_cntr_0 < PyList_GET_SIZE(value); params_cntr_0++) {
			if (PyList_GET_ITEM(value, params_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->params)[params_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&ExtendedErrorParam_Type, PyList_GET_ITEM(value, params_cntr_0), return -1;);
			if (talloc_reference(object->params, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, params_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->params)[params_cntr_0] = *(struct ExtendedErrorParam *)pytalloc_get_ptr(PyList_GET_ITEM(value, params_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_ExtendedErrorInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "next"),
		.get = py_ExtendedErrorInfo_get_next,
		.set = py_ExtendedErrorInfo_set_next,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorInfo")
	},
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_ExtendedErrorInfo_get_computer_name,
		.set = py_ExtendedErrorInfo_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorComputerName")
	},
	{
		.name = discard_const_p(char, "pid"),
		.get = py_ExtendedErrorInfo_get_pid,
		.set = py_ExtendedErrorInfo_set_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_ExtendedErrorInfo_get_time,
		.set = py_ExtendedErrorInfo_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "generating_component"),
		.get = py_ExtendedErrorInfo_get_generating_component,
		.set = py_ExtendedErrorInfo_set_generating_component,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_ExtendedErrorInfo_get_status,
		.set = py_ExtendedErrorInfo_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "detection_location"),
		.get = py_ExtendedErrorInfo_get_detection_location,
		.set = py_ExtendedErrorInfo_set_detection_location,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_ExtendedErrorInfo_get_flags,
		.set = py_ExtendedErrorInfo_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_params"),
		.get = py_ExtendedErrorInfo_get_num_params,
		.set = py_ExtendedErrorInfo_set_num_params,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "params"),
		.get = py_ExtendedErrorInfo_get_params,
		.set = py_ExtendedErrorInfo_set_params,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorParam")
	},
	{ .name = NULL }
};

static PyObject *py_ExtendedErrorInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ExtendedErrorInfo, type);
}

static PyObject *py_ExtendedErrorInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ExtendedErrorInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ExtendedErrorInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ExtendedErrorInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ExtendedErrorInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ExtendedErrorInfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct ExtendedErrorInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ExtendedErrorInfo, "ExtendedErrorInfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ExtendedErrorInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ExtendedErrorInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ExtendedErrorInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ExtendedErrorInfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ExtendedErrorInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorInfo",
	.tp_getset = py_ExtendedErrorInfo_getsetters,
	.tp_methods = py_ExtendedErrorInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorInfo_new,
};


static PyObject *py_ExtendedErrorInfoPtr_get_info(PyObject *obj, void *closure)
{
	struct ExtendedErrorInfoPtr *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&ExtendedErrorInfo_Type, object->info, object->info);
	}
	return py_info;
}

static int py_ExtendedErrorInfoPtr_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ExtendedErrorInfoPtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&ExtendedErrorInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct ExtendedErrorInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_ExtendedErrorInfoPtr_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_ExtendedErrorInfoPtr_get_info,
		.set = py_ExtendedErrorInfoPtr_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type ExtendedErrorInfo")
	},
	{ .name = NULL }
};

static PyObject *py_ExtendedErrorInfoPtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ExtendedErrorInfoPtr, type);
}


static PyTypeObject ExtendedErrorInfoPtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ExtendedErrorInfoPtr",
	.tp_getset = py_ExtendedErrorInfoPtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ExtendedErrorInfoPtr_new,
};


static PyObject *py_ForestTrustString_get_size(PyObject *obj, void *closure)
{
	struct ForestTrustString *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_ForestTrustString_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustString_get_string(PyObject *obj, void *closure)
{
	struct ForestTrustString *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
	}
	return py_string;
}

static int py_ForestTrustString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustString *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->string");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->string = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_ForestTrustString_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_ForestTrustString_get_size,
		.set = py_ForestTrustString_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_ForestTrustString_get_string,
		.set = py_ForestTrustString_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_ForestTrustString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ForestTrustString, type);
}


static PyTypeObject ForestTrustString_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ForestTrustString",
	.tp_getset = py_ForestTrustString_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ForestTrustString_new,
};


static PyObject *py_ForestTrustDataDomainInfo_get_sid_size(PyObject *obj, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_size;
	py_sid_size = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_size));
	return py_sid_size;
}

static int py_ForestTrustDataDomainInfo_set_sid_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustDataDomainInfo_get_sid(PyObject *obj, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_ForestTrustDataDomainInfo_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ForestTrustDataDomainInfo_get_dns_name(PyObject *obj, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name;
	py_dns_name = pytalloc_reference_ex(&ForestTrustString_Type, pytalloc_get_mem_ctx(obj), &object->dns_name);
	return py_dns_name;
}

static int py_ForestTrustDataDomainInfo_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dns_name");
		return -1;
	}
	PY_CHECK_TYPE(&ForestTrustString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_name = *(struct ForestTrustString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ForestTrustDataDomainInfo_get_netbios_name(PyObject *obj, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	py_netbios_name = pytalloc_reference_ex(&ForestTrustString_Type, pytalloc_get_mem_ctx(obj), &object->netbios_name);
	return py_netbios_name;
}

static int py_ForestTrustDataDomainInfo_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustDataDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->netbios_name");
		return -1;
	}
	PY_CHECK_TYPE(&ForestTrustString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_name = *(struct ForestTrustString *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_ForestTrustDataDomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "sid_size"),
		.get = py_ForestTrustDataDomainInfo_get_sid_size,
		.set = py_ForestTrustDataDomainInfo_set_sid_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_ForestTrustDataDomainInfo_get_sid,
		.set = py_ForestTrustDataDomainInfo_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "dns_name"),
		.get = py_ForestTrustDataDomainInfo_get_dns_name,
		.set = py_ForestTrustDataDomainInfo_set_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type ForestTrustString")
	},
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_ForestTrustDataDomainInfo_get_netbios_name,
		.set = py_ForestTrustDataDomainInfo_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type ForestTrustString")
	},
	{ .name = NULL }
};

static PyObject *py_ForestTrustDataDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ForestTrustDataDomainInfo, type);
}


static PyTypeObject ForestTrustDataDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ForestTrustDataDomainInfo",
	.tp_getset = py_ForestTrustDataDomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ForestTrustDataDomainInfo_new,
};


static PyObject *py_ForestTrustDataBinaryData_get_size(PyObject *obj, void *closure)
{
	struct ForestTrustDataBinaryData *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_ForestTrustDataBinaryData_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustDataBinaryData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustDataBinaryData_get_data(PyObject *obj, void *closure)
{
	struct ForestTrustDataBinaryData *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->size);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->size); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_ForestTrustDataBinaryData_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustDataBinaryData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_ForestTrustDataBinaryData_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_ForestTrustDataBinaryData_get_size,
		.set = py_ForestTrustDataBinaryData_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_ForestTrustDataBinaryData_get_data,
		.set = py_ForestTrustDataBinaryData_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_ForestTrustDataBinaryData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ForestTrustDataBinaryData, type);
}


static PyTypeObject ForestTrustDataBinaryData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ForestTrustDataBinaryData",
	.tp_getset = py_ForestTrustDataBinaryData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ForestTrustDataBinaryData_new,
};

static PyObject *py_import_ForestTrustData(TALLOC_CTX *mem_ctx, int level, union ForestTrustData *in)
{
	PyObject *ret;

	switch (level) {
		case FOREST_TRUST_TOP_LEVEL_NAME:
			ret = pytalloc_reference_ex(&ForestTrustString_Type, mem_ctx, &in->name);
			return ret;

		case FOREST_TRUST_TOP_LEVEL_NAME_EX:
			ret = pytalloc_reference_ex(&ForestTrustString_Type, mem_ctx, &in->name);
			return ret;

		case FOREST_TRUST_DOMAIN_INFO:
			ret = pytalloc_reference_ex(&ForestTrustDataDomainInfo_Type, mem_ctx, &in->info);
			return ret;

		default:
			ret = pytalloc_reference_ex(&ForestTrustDataBinaryData_Type, mem_ctx, &in->data);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ForestTrustData *py_export_ForestTrustData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ForestTrustData *ret = talloc_zero(mem_ctx, union ForestTrustData);
	switch (level) {
		case FOREST_TRUST_TOP_LEVEL_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ForestTrustString_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct ForestTrustString *)pytalloc_get_ptr(in);
			break;

		case FOREST_TRUST_TOP_LEVEL_NAME_EX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ForestTrustString_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct ForestTrustString *)pytalloc_get_ptr(in);
			break;

		case FOREST_TRUST_DOMAIN_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ForestTrustDataDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info = *(struct ForestTrustDataDomainInfo *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->data");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ForestTrustDataBinaryData_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->data = *(struct ForestTrustDataBinaryData *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_ForestTrustData_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ForestTrustData *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ForestTrustData *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ForestTrustData!");
		return NULL;
	}

	return py_import_ForestTrustData(mem_ctx, level, in);
}

static PyObject *py_ForestTrustData_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ForestTrustData *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ForestTrustData(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ForestTrustData_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ForestTrustData_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ForestTrustData_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ForestTrustData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ForestTrustData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ForestTrustData",
	.tp_getset = NULL,
	.tp_methods = py_ForestTrustData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ForestTrustData_new,
};


static PyObject *py_ForestTrustInfoRecord_get_flags(PyObject *obj, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_ForestTrustInfoRecord_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustInfoRecord_get_timestamp(PyObject *obj, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyLong_FromUnsignedLongLong(object->timestamp);
	return py_timestamp;
}

static int py_ForestTrustInfoRecord_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->timestamp");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timestamp));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timestamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustInfoRecord_get_type(PyObject *obj, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_ForestTrustInfoRecord_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustInfoRecord_get_data(PyObject *obj, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&ForestTrustData_Type, pytalloc_get_mem_ctx(obj), object->type, &object->data, "union ForestTrustData");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_ForestTrustInfoRecord_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	{
		union ForestTrustData *data_switch_0;
		data_switch_0 = (union ForestTrustData *)pyrpc_export_union(&ForestTrustData_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union ForestTrustData");
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ForestTrustInfoRecord_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_ForestTrustInfoRecord_get_flags,
		.set = py_ForestTrustInfoRecord_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustRecordFlags")
	},
	{
		.name = discard_const_p(char, "timestamp"),
		.get = py_ForestTrustInfoRecord_get_timestamp,
		.set = py_ForestTrustInfoRecord_set_timestamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_ForestTrustInfoRecord_get_type,
		.set = py_ForestTrustInfoRecord_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type ForestTrustInfoRecordType")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_ForestTrustInfoRecord_get_data,
		.set = py_ForestTrustInfoRecord_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type ForestTrustData")
	},
	{ .name = NULL }
};

static PyObject *py_ForestTrustInfoRecord_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ForestTrustInfoRecord, type);
}

static PyObject *py_ForestTrustInfoRecord_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ForestTrustInfoRecord);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ForestTrustInfoRecord_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ForestTrustInfoRecord);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ForestTrustInfoRecord);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ForestTrustInfoRecord_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct ForestTrustInfoRecord *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ForestTrustInfoRecord, "ForestTrustInfoRecord", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ForestTrustInfoRecord_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ForestTrustInfoRecord_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ForestTrustInfoRecord_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ForestTrustInfoRecord_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ForestTrustInfoRecord_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ForestTrustInfoRecord",
	.tp_getset = py_ForestTrustInfoRecord_getsetters,
	.tp_methods = py_ForestTrustInfoRecord_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ForestTrustInfoRecord_new,
};


static PyObject *py_ForestTrustInfoRecordArmor_get_record_size(PyObject *obj, void *closure)
{
	struct ForestTrustInfoRecordArmor *object = pytalloc_get_ptr(obj);
	PyObject *py_record_size;
	py_record_size = PyLong_FromUnsignedLongLong((uint32_t)(object->record_size));
	return py_record_size;
}

static int py_ForestTrustInfoRecordArmor_set_record_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfoRecordArmor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->record_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->record_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->record_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustInfoRecordArmor_get_record(PyObject *obj, void *closure)
{
	struct ForestTrustInfoRecordArmor *object = pytalloc_get_ptr(obj);
	PyObject *py_record;
	py_record = pytalloc_reference_ex(&ForestTrustInfoRecord_Type, pytalloc_get_mem_ctx(obj), &object->record);
	return py_record;
}

static int py_ForestTrustInfoRecordArmor_set_record(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfoRecordArmor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->record");
		return -1;
	}
	PY_CHECK_TYPE(&ForestTrustInfoRecord_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->record = *(struct ForestTrustInfoRecord *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_ForestTrustInfoRecordArmor_getsetters[] = {
	{
		.name = discard_const_p(char, "record_size"),
		.get = py_ForestTrustInfoRecordArmor_get_record_size,
		.set = py_ForestTrustInfoRecordArmor_set_record_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "record"),
		.get = py_ForestTrustInfoRecordArmor_get_record,
		.set = py_ForestTrustInfoRecordArmor_set_record,
		.doc = discard_const_p(char, "PIDL-generated element of base type ForestTrustInfoRecord")
	},
	{ .name = NULL }
};

static PyObject *py_ForestTrustInfoRecordArmor_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ForestTrustInfoRecordArmor, type);
}


static PyTypeObject ForestTrustInfoRecordArmor_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ForestTrustInfoRecordArmor",
	.tp_getset = py_ForestTrustInfoRecordArmor_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ForestTrustInfoRecordArmor_new,
};


static PyObject *py_ForestTrustInfo_get_version(PyObject *obj, void *closure)
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_ForestTrustInfo_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustInfo_get_count(PyObject *obj, void *closure)
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_ForestTrustInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ForestTrustInfo_get_records(PyObject *obj, void *closure)
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_records;
	py_records = PyList_New(object->count);
	if (py_records == NULL) {
		return NULL;
	}
	{
		int records_cntr_0;
		for (records_cntr_0 = 0; records_cntr_0 < (object->count); records_cntr_0++) {
			PyObject *py_records_0;
			py_records_0 = pytalloc_reference_ex(&ForestTrustInfoRecordArmor_Type, object->records, &(object->records)[records_cntr_0]);
			PyList_SetItem(py_records, records_cntr_0, py_records_0);
		}
	}
	return py_records;
}

static int py_ForestTrustInfo_set_records(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->records");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int records_cntr_0;
		object->records = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->records, PyList_GET_SIZE(value));
		if (!object->records) { return -1; }
		talloc_set_name_const(object->records, "ARRAY: object->records");
		for (records_cntr_0 = 0; records_cntr_0 < PyList_GET_SIZE(value); records_cntr_0++) {
			if (PyList_GET_ITEM(value, records_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->records)[records_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&ForestTrustInfoRecordArmor_Type, PyList_GET_ITEM(value, records_cntr_0), return -1;);
			if (talloc_reference(object->records, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, records_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->records)[records_cntr_0] = *(struct ForestTrustInfoRecordArmor *)pytalloc_get_ptr(PyList_GET_ITEM(value, records_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_ForestTrustInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_ForestTrustInfo_get_version,
		.set = py_ForestTrustInfo_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_ForestTrustInfo_get_count,
		.set = py_ForestTrustInfo_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "records"),
		.get = py_ForestTrustInfo_get_records,
		.set = py_ForestTrustInfo_set_records,
		.doc = discard_const_p(char, "PIDL-generated element of base type ForestTrustInfoRecordArmor")
	},
	{ .name = NULL }
};

static PyObject *py_ForestTrustInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ForestTrustInfo, type);
}

static PyObject *py_ForestTrustInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ForestTrustInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ForestTrustInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ForestTrustInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ForestTrustInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ForestTrustInfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct ForestTrustInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ForestTrustInfo, "ForestTrustInfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ForestTrustInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ForestTrustInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ForestTrustInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ForestTrustInfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ForestTrustInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.ForestTrustInfo",
	.tp_getset = py_ForestTrustInfo_getsetters,
	.tp_methods = py_ForestTrustInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ForestTrustInfo_new,
};


static PyObject *py_PlaintextSecret_get_cleartext(PyObject *obj, void *closure)
{
	struct PlaintextSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_cleartext;
	py_cleartext = PyBytes_FromStringAndSize((char *)(object->cleartext).data, (object->cleartext).length);
	return py_cleartext;
}

static int py_PlaintextSecret_set_cleartext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PlaintextSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cleartext");
		return -1;
	}
	object->cleartext = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_PlaintextSecret_getsetters[] = {
	{
		.name = discard_const_p(char, "cleartext"),
		.get = py_PlaintextSecret_get_cleartext,
		.set = py_PlaintextSecret_set_cleartext,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_PlaintextSecret_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PlaintextSecret, type);
}

static PyObject *py_PlaintextSecret_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PlaintextSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PlaintextSecret);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PlaintextSecret_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PlaintextSecret *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PlaintextSecret);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PlaintextSecret);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PlaintextSecret_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct PlaintextSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PlaintextSecret, "PlaintextSecret", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PlaintextSecret_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PlaintextSecret_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PlaintextSecret_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PlaintextSecret_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PlaintextSecret_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.PlaintextSecret",
	.tp_getset = py_PlaintextSecret_getsetters,
	.tp_methods = py_PlaintextSecret_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PlaintextSecret_new,
};


static PyObject *py_EncryptedSecretHeader_get_magic(PyObject *obj, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyLong_FromUnsignedLongLong((uint32_t)(object->magic));
	return py_magic;
}

static int py_EncryptedSecretHeader_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->magic");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_EncryptedSecretHeader_get_version(PyObject *obj, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_EncryptedSecretHeader_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_EncryptedSecretHeader_get_algorithm(PyObject *obj, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(obj);
	PyObject *py_algorithm;
	py_algorithm = PyLong_FromUnsignedLongLong((uint32_t)(object->algorithm));
	return py_algorithm;
}

static int py_EncryptedSecretHeader_set_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->algorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->algorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->algorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_EncryptedSecretHeader_get_flags(PyObject *obj, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_EncryptedSecretHeader_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_EncryptedSecretHeader_getsetters[] = {
	{
		.name = discard_const_p(char, "magic"),
		.get = py_EncryptedSecretHeader_get_magic,
		.set = py_EncryptedSecretHeader_set_magic,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_EncryptedSecretHeader_get_version,
		.set = py_EncryptedSecretHeader_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "algorithm"),
		.get = py_EncryptedSecretHeader_get_algorithm,
		.set = py_EncryptedSecretHeader_set_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_EncryptedSecretHeader_get_flags,
		.set = py_EncryptedSecretHeader_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_EncryptedSecretHeader_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EncryptedSecretHeader, type);
}

static PyObject *py_EncryptedSecretHeader_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_EncryptedSecretHeader);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_EncryptedSecretHeader_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EncryptedSecretHeader);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EncryptedSecretHeader);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EncryptedSecretHeader_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct EncryptedSecretHeader *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EncryptedSecretHeader, "EncryptedSecretHeader", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EncryptedSecretHeader_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EncryptedSecretHeader_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_EncryptedSecretHeader_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_EncryptedSecretHeader_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EncryptedSecretHeader_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.EncryptedSecretHeader",
	.tp_getset = py_EncryptedSecretHeader_getsetters,
	.tp_methods = py_EncryptedSecretHeader_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_EncryptedSecretHeader_new,
};


static PyObject *py_EncryptedSecret_get_iv(PyObject *obj, void *closure)
{
	struct EncryptedSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_iv;
	py_iv = PyBytes_FromStringAndSize((char *)(object->iv).data, (object->iv).length);
	return py_iv;
}

static int py_EncryptedSecret_set_iv(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncryptedSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->iv");
		return -1;
	}
	object->iv = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_EncryptedSecret_get_header(PyObject *obj, void *closure)
{
	struct EncryptedSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_header;
	py_header = pytalloc_reference_ex(&EncryptedSecretHeader_Type, pytalloc_get_mem_ctx(obj), &object->header);
	return py_header;
}

static int py_EncryptedSecret_set_header(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncryptedSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->header");
		return -1;
	}
	PY_CHECK_TYPE(&EncryptedSecretHeader_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->header = *(struct EncryptedSecretHeader *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_EncryptedSecret_get_encrypted(PyObject *obj, void *closure)
{
	struct EncryptedSecret *object = pytalloc_get_ptr(obj);
	PyObject *py_encrypted;
	py_encrypted = PyBytes_FromStringAndSize((char *)(object->encrypted).data, (object->encrypted).length);
	return py_encrypted;
}

static int py_EncryptedSecret_set_encrypted(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncryptedSecret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->encrypted");
		return -1;
	}
	object->encrypted = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_EncryptedSecret_getsetters[] = {
	{
		.name = discard_const_p(char, "iv"),
		.get = py_EncryptedSecret_get_iv,
		.set = py_EncryptedSecret_set_iv,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "header"),
		.get = py_EncryptedSecret_get_header,
		.set = py_EncryptedSecret_set_header,
		.doc = discard_const_p(char, "PIDL-generated element of base type EncryptedSecretHeader")
	},
	{
		.name = discard_const_p(char, "encrypted"),
		.get = py_EncryptedSecret_get_encrypted,
		.set = py_EncryptedSecret_set_encrypted,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_EncryptedSecret_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EncryptedSecret, type);
}

static PyObject *py_EncryptedSecret_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct EncryptedSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_EncryptedSecret);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_EncryptedSecret_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EncryptedSecret *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EncryptedSecret);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EncryptedSecret);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EncryptedSecret_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct EncryptedSecret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EncryptedSecret, "EncryptedSecret", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EncryptedSecret_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EncryptedSecret_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_EncryptedSecret_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_EncryptedSecret_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EncryptedSecret_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.EncryptedSecret",
	.tp_getset = py_EncryptedSecret_getsetters,
	.tp_methods = py_EncryptedSecret_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_EncryptedSecret_new,
};


const struct PyNdrRpcMethodDef py_ndr_drsblobs_methods[] = {
	{0}
};

static PyObject *interface_drsblobs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_drsblobs);
}

#define PY_DOC_DRSBLOBS "Active Directory Replication LDAP Blobs"
static PyTypeObject drsblobs_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.drsblobs",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "drsblobs(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_DRSBLOBS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_drsblobs_new,
};

static PyObject *syntax_drsblobs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_drsblobs.syntax_id);
}

#define PY_DOC_DRSBLOBS_SYNTAX "Active Directory Replication LDAP Blobs"
static PyTypeObject drsblobs_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "drsblobs.drsblobs_abstract_syntax",
	.tp_doc = "drsblobs_abstract_syntax()\n"PY_DOC_DRSBLOBS_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_drsblobs_new,
};

static PyMethodDef drsblobs_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "drsblobs",
	.m_doc = "drsblobs DCE/RPC",
	.m_size = -1,
	.m_methods = drsblobs_methods,
};
MODULE_INIT_FUNC(drsblobs)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_drsuapi = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_samr = NULL;
	PyObject *dep_samba_dcerpc_lsa = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_drsuapi = PyImport_ImportModule("samba.dcerpc.drsuapi");
	if (dep_samba_dcerpc_drsuapi == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_samr = PyImport_ImportModule("samba.dcerpc.samr");
	if (dep_samba_dcerpc_samr == NULL)
		goto out;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	drsuapi_DsReplicaCursor_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_drsuapi, "DsReplicaCursor");
	if (drsuapi_DsReplicaCursor_Type == NULL)
		goto out;

	drsuapi_DsReplicaCursor2_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_drsuapi, "DsReplicaCursor2");
	if (drsuapi_DsReplicaCursor2_Type == NULL)
		goto out;

	drsuapi_DsReplicaHighWaterMark_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_drsuapi, "DsReplicaHighWaterMark");
	if (drsuapi_DsReplicaHighWaterMark_Type == NULL)
		goto out;

	drsuapi_DsReplicaOIDMapping_Ctr_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_drsuapi, "DsReplicaOIDMapping_Ctr");
	if (drsuapi_DsReplicaOIDMapping_Ctr_Type == NULL)
		goto out;

	samr_Password_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "Password");
	if (samr_Password_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	replPropertyMetaData1_Type.tp_base = BaseObject_Type;
	replPropertyMetaData1_Type.tp_basicsize = pytalloc_BaseObject_size();

	replPropertyMetaDataCtr1_Type.tp_base = BaseObject_Type;
	replPropertyMetaDataCtr1_Type.tp_basicsize = pytalloc_BaseObject_size();

	replPropertyMetaDataCtr_Type.tp_base = BaseObject_Type;
	replPropertyMetaDataCtr_Type.tp_basicsize = pytalloc_BaseObject_size();

	replPropertyMetaDataBlob_Type.tp_base = BaseObject_Type;
	replPropertyMetaDataBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	replUpToDateVectorCtr1_Type.tp_base = BaseObject_Type;
	replUpToDateVectorCtr1_Type.tp_basicsize = pytalloc_BaseObject_size();

	replUpToDateVectorCtr2_Type.tp_base = BaseObject_Type;
	replUpToDateVectorCtr2_Type.tp_basicsize = pytalloc_BaseObject_size();

	replUpToDateVectorCtr_Type.tp_base = BaseObject_Type;
	replUpToDateVectorCtr_Type.tp_basicsize = pytalloc_BaseObject_size();

	replUpToDateVectorBlob_Type.tp_base = BaseObject_Type;
	replUpToDateVectorBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	repsFromTo1OtherInfo_Type.tp_base = BaseObject_Type;
	repsFromTo1OtherInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	repsFromTo1_Type.tp_base = BaseObject_Type;
	repsFromTo1_Type.tp_basicsize = pytalloc_BaseObject_size();

	repsFromTo2OtherInfo_Type.tp_base = BaseObject_Type;
	repsFromTo2OtherInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	repsFromTo2_Type.tp_base = BaseObject_Type;
	repsFromTo2_Type.tp_basicsize = pytalloc_BaseObject_size();

	repsFromTo_Type.tp_base = BaseObject_Type;
	repsFromTo_Type.tp_basicsize = pytalloc_BaseObject_size();

	repsFromToBlob_Type.tp_base = BaseObject_Type;
	repsFromToBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	scheduleHeader_Type.tp_base = BaseObject_Type;
	scheduleHeader_Type.tp_basicsize = pytalloc_BaseObject_size();

	scheduleSlots_Type.tp_base = BaseObject_Type;
	scheduleSlots_Type.tp_basicsize = pytalloc_BaseObject_size();

	schedule_Type.tp_base = BaseObject_Type;
	schedule_Type.tp_basicsize = pytalloc_BaseObject_size();

	partialAttributeSetCtr1_Type.tp_base = BaseObject_Type;
	partialAttributeSetCtr1_Type.tp_basicsize = pytalloc_BaseObject_size();

	partialAttributeSetCtr_Type.tp_base = BaseObject_Type;
	partialAttributeSetCtr_Type.tp_basicsize = pytalloc_BaseObject_size();

	partialAttributeSetBlob_Type.tp_base = BaseObject_Type;
	partialAttributeSetBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	schemaInfoBlob_Type.tp_base = BaseObject_Type;
	schemaInfoBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	drsuapi_MSPrefixMap_Entry_Type.tp_base = BaseObject_Type;
	drsuapi_MSPrefixMap_Entry_Type.tp_basicsize = pytalloc_BaseObject_size();

	drsuapi_MSPrefixMap_Ctr_Type.tp_base = BaseObject_Type;
	drsuapi_MSPrefixMap_Ctr_Type.tp_basicsize = pytalloc_BaseObject_size();

	prefixMapCtr_Type.tp_base = BaseObject_Type;
	prefixMapCtr_Type.tp_basicsize = pytalloc_BaseObject_size();

	prefixMapBlob_Type.tp_base = BaseObject_Type;
	prefixMapBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	ldapControlDirSyncExtra_Type.tp_base = BaseObject_Type;
	ldapControlDirSyncExtra_Type.tp_basicsize = pytalloc_BaseObject_size();

	ldapControlDirSyncBlob_Type.tp_base = BaseObject_Type;
	ldapControlDirSyncBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	ldapControlDirSyncCookie_Type.tp_base = BaseObject_Type;
	ldapControlDirSyncCookie_Type.tp_basicsize = pytalloc_BaseObject_size();

	supplementalCredentialsPackage_Type.tp_base = BaseObject_Type;
	supplementalCredentialsPackage_Type.tp_basicsize = pytalloc_BaseObject_size();

	supplementalCredentialsSubBlob_Type.tp_base = BaseObject_Type;
	supplementalCredentialsSubBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	supplementalCredentialsBlob_Type.tp_base = BaseObject_Type;
	supplementalCredentialsBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PackagesBlob_Type.tp_base = BaseObject_Type;
	package_PackagesBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryKerberosString_Type.tp_base = BaseObject_Type;
	package_PrimaryKerberosString_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryKerberosKey3_Type.tp_base = BaseObject_Type;
	package_PrimaryKerberosKey3_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryKerberosCtr3_Type.tp_base = BaseObject_Type;
	package_PrimaryKerberosCtr3_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryKerberosKey4_Type.tp_base = BaseObject_Type;
	package_PrimaryKerberosKey4_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryKerberosCtr4_Type.tp_base = BaseObject_Type;
	package_PrimaryKerberosCtr4_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryKerberosCtr_Type.tp_base = BaseObject_Type;
	package_PrimaryKerberosCtr_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryKerberosBlob_Type.tp_base = BaseObject_Type;
	package_PrimaryKerberosBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryCLEARTEXTBlob_Type.tp_base = BaseObject_Type;
	package_PrimaryCLEARTEXTBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryWDigestHash_Type.tp_base = BaseObject_Type;
	package_PrimaryWDigestHash_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryWDigestBlob_Type.tp_base = BaseObject_Type;
	package_PrimaryWDigestBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimarySambaGPGBlob_Type.tp_base = BaseObject_Type;
	package_PrimarySambaGPGBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryUserPasswordValue_Type.tp_base = BaseObject_Type;
	package_PrimaryUserPasswordValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	package_PrimaryUserPasswordBlob_Type.tp_base = BaseObject_Type;
	package_PrimaryUserPasswordBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	AuthInfoNone_Type.tp_base = BaseObject_Type;
	AuthInfoNone_Type.tp_basicsize = pytalloc_BaseObject_size();

	AuthInfoNT4Owf_Type.tp_base = BaseObject_Type;
	AuthInfoNT4Owf_Type.tp_basicsize = pytalloc_BaseObject_size();

	AuthInfoClear_Type.tp_base = BaseObject_Type;
	AuthInfoClear_Type.tp_basicsize = pytalloc_BaseObject_size();

	AuthInfoVersion_Type.tp_base = BaseObject_Type;
	AuthInfoVersion_Type.tp_basicsize = pytalloc_BaseObject_size();

	AuthInfo_Type.tp_base = BaseObject_Type;
	AuthInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	AuthenticationInformation_Type.tp_base = BaseObject_Type;
	AuthenticationInformation_Type.tp_basicsize = pytalloc_BaseObject_size();

	AuthenticationInformationArray_Type.tp_base = BaseObject_Type;
	AuthenticationInformationArray_Type.tp_basicsize = pytalloc_BaseObject_size();

	trustAuthInOutBlob_Type.tp_base = BaseObject_Type;
	trustAuthInOutBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	trustDomainPasswords_Type.tp_base = BaseObject_Type;
	trustDomainPasswords_Type.tp_basicsize = pytalloc_BaseObject_size();

	DsCompressedChunk_Type.tp_base = BaseObject_Type;
	DsCompressedChunk_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorAString_Type.tp_base = BaseObject_Type;
	ExtendedErrorAString_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorUString_Type.tp_base = BaseObject_Type;
	ExtendedErrorUString_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorBlob_Type.tp_base = BaseObject_Type;
	ExtendedErrorBlob_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorComputerNameU_Type.tp_base = BaseObject_Type;
	ExtendedErrorComputerNameU_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorComputerName_Type.tp_base = BaseObject_Type;
	ExtendedErrorComputerName_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorParamU_Type.tp_base = BaseObject_Type;
	ExtendedErrorParamU_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorParam_Type.tp_base = BaseObject_Type;
	ExtendedErrorParam_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorInfo_Type.tp_base = BaseObject_Type;
	ExtendedErrorInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	ExtendedErrorInfoPtr_Type.tp_base = BaseObject_Type;
	ExtendedErrorInfoPtr_Type.tp_basicsize = pytalloc_BaseObject_size();

	ForestTrustString_Type.tp_base = BaseObject_Type;
	ForestTrustString_Type.tp_basicsize = pytalloc_BaseObject_size();

	ForestTrustDataDomainInfo_Type.tp_base = BaseObject_Type;
	ForestTrustDataDomainInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	ForestTrustDataBinaryData_Type.tp_base = BaseObject_Type;
	ForestTrustDataBinaryData_Type.tp_basicsize = pytalloc_BaseObject_size();

	ForestTrustData_Type.tp_base = BaseObject_Type;
	ForestTrustData_Type.tp_basicsize = pytalloc_BaseObject_size();

	ForestTrustInfoRecord_Type.tp_base = BaseObject_Type;
	ForestTrustInfoRecord_Type.tp_basicsize = pytalloc_BaseObject_size();

	ForestTrustInfoRecordArmor_Type.tp_base = BaseObject_Type;
	ForestTrustInfoRecordArmor_Type.tp_basicsize = pytalloc_BaseObject_size();

	ForestTrustInfo_Type.tp_base = BaseObject_Type;
	ForestTrustInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	PlaintextSecret_Type.tp_base = BaseObject_Type;
	PlaintextSecret_Type.tp_basicsize = pytalloc_BaseObject_size();

	EncryptedSecretHeader_Type.tp_base = BaseObject_Type;
	EncryptedSecretHeader_Type.tp_basicsize = pytalloc_BaseObject_size();

	EncryptedSecret_Type.tp_base = BaseObject_Type;
	EncryptedSecret_Type.tp_basicsize = pytalloc_BaseObject_size();

	drsblobs_InterfaceType.tp_base = ClientConnection_Type;

	drsblobs_SyntaxType.tp_base = ndr_syntax_id_Type;
	drsblobs_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&replPropertyMetaData1_Type) < 0)
		goto out;
	if (PyType_Ready(&replPropertyMetaDataCtr1_Type) < 0)
		goto out;
	if (PyType_Ready(&replPropertyMetaDataCtr_Type) < 0)
		goto out;
	if (PyType_Ready(&replPropertyMetaDataBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&replUpToDateVectorCtr1_Type) < 0)
		goto out;
	if (PyType_Ready(&replUpToDateVectorCtr2_Type) < 0)
		goto out;
	if (PyType_Ready(&replUpToDateVectorCtr_Type) < 0)
		goto out;
	if (PyType_Ready(&replUpToDateVectorBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&repsFromTo1OtherInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&repsFromTo1_Type) < 0)
		goto out;
	if (PyType_Ready(&repsFromTo2OtherInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&repsFromTo2_Type) < 0)
		goto out;
	if (PyType_Ready(&repsFromTo_Type) < 0)
		goto out;
	if (PyType_Ready(&repsFromToBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&scheduleHeader_Type) < 0)
		goto out;
	if (PyType_Ready(&scheduleSlots_Type) < 0)
		goto out;
	if (PyType_Ready(&schedule_Type) < 0)
		goto out;
	if (PyType_Ready(&partialAttributeSetCtr1_Type) < 0)
		goto out;
	if (PyType_Ready(&partialAttributeSetCtr_Type) < 0)
		goto out;
	if (PyType_Ready(&partialAttributeSetBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&schemaInfoBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&drsuapi_MSPrefixMap_Entry_Type) < 0)
		goto out;
	if (PyType_Ready(&drsuapi_MSPrefixMap_Ctr_Type) < 0)
		goto out;
	if (PyType_Ready(&prefixMapCtr_Type) < 0)
		goto out;
	if (PyType_Ready(&prefixMapBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&ldapControlDirSyncExtra_Type) < 0)
		goto out;
	if (PyType_Ready(&ldapControlDirSyncBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&ldapControlDirSyncCookie_Type) < 0)
		goto out;
	if (PyType_Ready(&supplementalCredentialsPackage_Type) < 0)
		goto out;
	if (PyType_Ready(&supplementalCredentialsSubBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&supplementalCredentialsBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PackagesBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryKerberosString_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryKerberosKey3_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryKerberosCtr3_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryKerberosKey4_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryKerberosCtr4_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryKerberosCtr_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryKerberosBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryCLEARTEXTBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryWDigestHash_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryWDigestBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimarySambaGPGBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryUserPasswordValue_Type) < 0)
		goto out;
	if (PyType_Ready(&package_PrimaryUserPasswordBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&AuthInfoNone_Type) < 0)
		goto out;
	if (PyType_Ready(&AuthInfoNT4Owf_Type) < 0)
		goto out;
	if (PyType_Ready(&AuthInfoClear_Type) < 0)
		goto out;
	if (PyType_Ready(&AuthInfoVersion_Type) < 0)
		goto out;
	if (PyType_Ready(&AuthInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&AuthenticationInformation_Type) < 0)
		goto out;
	if (PyType_Ready(&AuthenticationInformationArray_Type) < 0)
		goto out;
	if (PyType_Ready(&trustAuthInOutBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&trustDomainPasswords_Type) < 0)
		goto out;
	if (PyType_Ready(&DsCompressedChunk_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorAString_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorUString_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorBlob_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorComputerNameU_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorComputerName_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorParamU_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorParam_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&ExtendedErrorInfoPtr_Type) < 0)
		goto out;
	if (PyType_Ready(&ForestTrustString_Type) < 0)
		goto out;
	if (PyType_Ready(&ForestTrustDataDomainInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&ForestTrustDataBinaryData_Type) < 0)
		goto out;
	if (PyType_Ready(&ForestTrustData_Type) < 0)
		goto out;
	if (PyType_Ready(&ForestTrustInfoRecord_Type) < 0)
		goto out;
	if (PyType_Ready(&ForestTrustInfoRecordArmor_Type) < 0)
		goto out;
	if (PyType_Ready(&ForestTrustInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&PlaintextSecret_Type) < 0)
		goto out;
	if (PyType_Ready(&EncryptedSecretHeader_Type) < 0)
		goto out;
	if (PyType_Ready(&EncryptedSecret_Type) < 0)
		goto out;
	if (PyType_Ready(&drsblobs_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&drsblobs_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&drsblobs_InterfaceType, py_ndr_drsblobs_methods))
		return NULL;

#ifdef PY_REPLPROPERTYMETADATA1_PATCH
	PY_REPLPROPERTYMETADATA1_PATCH(&replPropertyMetaData1_Type);
#endif
#ifdef PY_REPLPROPERTYMETADATACTR1_PATCH
	PY_REPLPROPERTYMETADATACTR1_PATCH(&replPropertyMetaDataCtr1_Type);
#endif
#ifdef PY_REPLPROPERTYMETADATACTR_PATCH
	PY_REPLPROPERTYMETADATACTR_PATCH(&replPropertyMetaDataCtr_Type);
#endif
#ifdef PY_REPLPROPERTYMETADATABLOB_PATCH
	PY_REPLPROPERTYMETADATABLOB_PATCH(&replPropertyMetaDataBlob_Type);
#endif
#ifdef PY_REPLUPTODATEVECTORCTR1_PATCH
	PY_REPLUPTODATEVECTORCTR1_PATCH(&replUpToDateVectorCtr1_Type);
#endif
#ifdef PY_REPLUPTODATEVECTORCTR2_PATCH
	PY_REPLUPTODATEVECTORCTR2_PATCH(&replUpToDateVectorCtr2_Type);
#endif
#ifdef PY_REPLUPTODATEVECTORCTR_PATCH
	PY_REPLUPTODATEVECTORCTR_PATCH(&replUpToDateVectorCtr_Type);
#endif
#ifdef PY_REPLUPTODATEVECTORBLOB_PATCH
	PY_REPLUPTODATEVECTORBLOB_PATCH(&replUpToDateVectorBlob_Type);
#endif
#ifdef PY_REPSFROMTO1OTHERINFO_PATCH
	PY_REPSFROMTO1OTHERINFO_PATCH(&repsFromTo1OtherInfo_Type);
#endif
#ifdef PY_REPSFROMTO1_PATCH
	PY_REPSFROMTO1_PATCH(&repsFromTo1_Type);
#endif
#ifdef PY_REPSFROMTO2OTHERINFO_PATCH
	PY_REPSFROMTO2OTHERINFO_PATCH(&repsFromTo2OtherInfo_Type);
#endif
#ifdef PY_REPSFROMTO2_PATCH
	PY_REPSFROMTO2_PATCH(&repsFromTo2_Type);
#endif
#ifdef PY_REPSFROMTO_PATCH
	PY_REPSFROMTO_PATCH(&repsFromTo_Type);
#endif
#ifdef PY_REPSFROMTOBLOB_PATCH
	PY_REPSFROMTOBLOB_PATCH(&repsFromToBlob_Type);
#endif
#ifdef PY_SCHEDULEHEADER_PATCH
	PY_SCHEDULEHEADER_PATCH(&scheduleHeader_Type);
#endif
#ifdef PY_SCHEDULESLOTS_PATCH
	PY_SCHEDULESLOTS_PATCH(&scheduleSlots_Type);
#endif
#ifdef PY_SCHEDULE_PATCH
	PY_SCHEDULE_PATCH(&schedule_Type);
#endif
#ifdef PY_PARTIALATTRIBUTESETCTR1_PATCH
	PY_PARTIALATTRIBUTESETCTR1_PATCH(&partialAttributeSetCtr1_Type);
#endif
#ifdef PY_PARTIALATTRIBUTESETCTR_PATCH
	PY_PARTIALATTRIBUTESETCTR_PATCH(&partialAttributeSetCtr_Type);
#endif
#ifdef PY_PARTIALATTRIBUTESETBLOB_PATCH
	PY_PARTIALATTRIBUTESETBLOB_PATCH(&partialAttributeSetBlob_Type);
#endif
#ifdef PY_SCHEMAINFOBLOB_PATCH
	PY_SCHEMAINFOBLOB_PATCH(&schemaInfoBlob_Type);
#endif
#ifdef PY_DRSUAPI_MSPREFIXMAP_ENTRY_PATCH
	PY_DRSUAPI_MSPREFIXMAP_ENTRY_PATCH(&drsuapi_MSPrefixMap_Entry_Type);
#endif
#ifdef PY_DRSUAPI_MSPREFIXMAP_CTR_PATCH
	PY_DRSUAPI_MSPREFIXMAP_CTR_PATCH(&drsuapi_MSPrefixMap_Ctr_Type);
#endif
#ifdef PY_PREFIXMAPCTR_PATCH
	PY_PREFIXMAPCTR_PATCH(&prefixMapCtr_Type);
#endif
#ifdef PY_PREFIXMAPBLOB_PATCH
	PY_PREFIXMAPBLOB_PATCH(&prefixMapBlob_Type);
#endif
#ifdef PY_LDAPCONTROLDIRSYNCEXTRA_PATCH
	PY_LDAPCONTROLDIRSYNCEXTRA_PATCH(&ldapControlDirSyncExtra_Type);
#endif
#ifdef PY_LDAPCONTROLDIRSYNCBLOB_PATCH
	PY_LDAPCONTROLDIRSYNCBLOB_PATCH(&ldapControlDirSyncBlob_Type);
#endif
#ifdef PY_LDAPCONTROLDIRSYNCCOOKIE_PATCH
	PY_LDAPCONTROLDIRSYNCCOOKIE_PATCH(&ldapControlDirSyncCookie_Type);
#endif
#ifdef PY_SUPPLEMENTALCREDENTIALSPACKAGE_PATCH
	PY_SUPPLEMENTALCREDENTIALSPACKAGE_PATCH(&supplementalCredentialsPackage_Type);
#endif
#ifdef PY_SUPPLEMENTALCREDENTIALSSUBBLOB_PATCH
	PY_SUPPLEMENTALCREDENTIALSSUBBLOB_PATCH(&supplementalCredentialsSubBlob_Type);
#endif
#ifdef PY_SUPPLEMENTALCREDENTIALSBLOB_PATCH
	PY_SUPPLEMENTALCREDENTIALSBLOB_PATCH(&supplementalCredentialsBlob_Type);
#endif
#ifdef PY_PACKAGE_PACKAGESBLOB_PATCH
	PY_PACKAGE_PACKAGESBLOB_PATCH(&package_PackagesBlob_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYKERBEROSSTRING_PATCH
	PY_PACKAGE_PRIMARYKERBEROSSTRING_PATCH(&package_PrimaryKerberosString_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYKERBEROSKEY3_PATCH
	PY_PACKAGE_PRIMARYKERBEROSKEY3_PATCH(&package_PrimaryKerberosKey3_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYKERBEROSCTR3_PATCH
	PY_PACKAGE_PRIMARYKERBEROSCTR3_PATCH(&package_PrimaryKerberosCtr3_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYKERBEROSKEY4_PATCH
	PY_PACKAGE_PRIMARYKERBEROSKEY4_PATCH(&package_PrimaryKerberosKey4_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYKERBEROSCTR4_PATCH
	PY_PACKAGE_PRIMARYKERBEROSCTR4_PATCH(&package_PrimaryKerberosCtr4_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYKERBEROSCTR_PATCH
	PY_PACKAGE_PRIMARYKERBEROSCTR_PATCH(&package_PrimaryKerberosCtr_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYKERBEROSBLOB_PATCH
	PY_PACKAGE_PRIMARYKERBEROSBLOB_PATCH(&package_PrimaryKerberosBlob_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYCLEARTEXTBLOB_PATCH
	PY_PACKAGE_PRIMARYCLEARTEXTBLOB_PATCH(&package_PrimaryCLEARTEXTBlob_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYWDIGESTHASH_PATCH
	PY_PACKAGE_PRIMARYWDIGESTHASH_PATCH(&package_PrimaryWDigestHash_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYWDIGESTBLOB_PATCH
	PY_PACKAGE_PRIMARYWDIGESTBLOB_PATCH(&package_PrimaryWDigestBlob_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYSAMBAGPGBLOB_PATCH
	PY_PACKAGE_PRIMARYSAMBAGPGBLOB_PATCH(&package_PrimarySambaGPGBlob_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYUSERPASSWORDVALUE_PATCH
	PY_PACKAGE_PRIMARYUSERPASSWORDVALUE_PATCH(&package_PrimaryUserPasswordValue_Type);
#endif
#ifdef PY_PACKAGE_PRIMARYUSERPASSWORDBLOB_PATCH
	PY_PACKAGE_PRIMARYUSERPASSWORDBLOB_PATCH(&package_PrimaryUserPasswordBlob_Type);
#endif
#ifdef PY_AUTHINFONONE_PATCH
	PY_AUTHINFONONE_PATCH(&AuthInfoNone_Type);
#endif
#ifdef PY_AUTHINFONT4OWF_PATCH
	PY_AUTHINFONT4OWF_PATCH(&AuthInfoNT4Owf_Type);
#endif
#ifdef PY_AUTHINFOCLEAR_PATCH
	PY_AUTHINFOCLEAR_PATCH(&AuthInfoClear_Type);
#endif
#ifdef PY_AUTHINFOVERSION_PATCH
	PY_AUTHINFOVERSION_PATCH(&AuthInfoVersion_Type);
#endif
#ifdef PY_AUTHINFO_PATCH
	PY_AUTHINFO_PATCH(&AuthInfo_Type);
#endif
#ifdef PY_AUTHENTICATIONINFORMATION_PATCH
	PY_AUTHENTICATIONINFORMATION_PATCH(&AuthenticationInformation_Type);
#endif
#ifdef PY_AUTHENTICATIONINFORMATIONARRAY_PATCH
	PY_AUTHENTICATIONINFORMATIONARRAY_PATCH(&AuthenticationInformationArray_Type);
#endif
#ifdef PY_TRUSTAUTHINOUTBLOB_PATCH
	PY_TRUSTAUTHINOUTBLOB_PATCH(&trustAuthInOutBlob_Type);
#endif
#ifdef PY_TRUSTDOMAINPASSWORDS_PATCH
	PY_TRUSTDOMAINPASSWORDS_PATCH(&trustDomainPasswords_Type);
#endif
#ifdef PY_DSCOMPRESSEDCHUNK_PATCH
	PY_DSCOMPRESSEDCHUNK_PATCH(&DsCompressedChunk_Type);
#endif
#ifdef PY_EXTENDEDERRORASTRING_PATCH
	PY_EXTENDEDERRORASTRING_PATCH(&ExtendedErrorAString_Type);
#endif
#ifdef PY_EXTENDEDERRORUSTRING_PATCH
	PY_EXTENDEDERRORUSTRING_PATCH(&ExtendedErrorUString_Type);
#endif
#ifdef PY_EXTENDEDERRORBLOB_PATCH
	PY_EXTENDEDERRORBLOB_PATCH(&ExtendedErrorBlob_Type);
#endif
#ifdef PY_EXTENDEDERRORCOMPUTERNAMEU_PATCH
	PY_EXTENDEDERRORCOMPUTERNAMEU_PATCH(&ExtendedErrorComputerNameU_Type);
#endif
#ifdef PY_EXTENDEDERRORCOMPUTERNAME_PATCH
	PY_EXTENDEDERRORCOMPUTERNAME_PATCH(&ExtendedErrorComputerName_Type);
#endif
#ifdef PY_EXTENDEDERRORPARAMU_PATCH
	PY_EXTENDEDERRORPARAMU_PATCH(&ExtendedErrorParamU_Type);
#endif
#ifdef PY_EXTENDEDERRORPARAM_PATCH
	PY_EXTENDEDERRORPARAM_PATCH(&ExtendedErrorParam_Type);
#endif
#ifdef PY_EXTENDEDERRORINFO_PATCH
	PY_EXTENDEDERRORINFO_PATCH(&ExtendedErrorInfo_Type);
#endif
#ifdef PY_EXTENDEDERRORINFOPTR_PATCH
	PY_EXTENDEDERRORINFOPTR_PATCH(&ExtendedErrorInfoPtr_Type);
#endif
#ifdef PY_FORESTTRUSTSTRING_PATCH
	PY_FORESTTRUSTSTRING_PATCH(&ForestTrustString_Type);
#endif
#ifdef PY_FORESTTRUSTDATADOMAININFO_PATCH
	PY_FORESTTRUSTDATADOMAININFO_PATCH(&ForestTrustDataDomainInfo_Type);
#endif
#ifdef PY_FORESTTRUSTDATABINARYDATA_PATCH
	PY_FORESTTRUSTDATABINARYDATA_PATCH(&ForestTrustDataBinaryData_Type);
#endif
#ifdef PY_FORESTTRUSTDATA_PATCH
	PY_FORESTTRUSTDATA_PATCH(&ForestTrustData_Type);
#endif
#ifdef PY_FORESTTRUSTINFORECORD_PATCH
	PY_FORESTTRUSTINFORECORD_PATCH(&ForestTrustInfoRecord_Type);
#endif
#ifdef PY_FORESTTRUSTINFORECORDARMOR_PATCH
	PY_FORESTTRUSTINFORECORDARMOR_PATCH(&ForestTrustInfoRecordArmor_Type);
#endif
#ifdef PY_FORESTTRUSTINFO_PATCH
	PY_FORESTTRUSTINFO_PATCH(&ForestTrustInfo_Type);
#endif
#ifdef PY_PLAINTEXTSECRET_PATCH
	PY_PLAINTEXTSECRET_PATCH(&PlaintextSecret_Type);
#endif
#ifdef PY_ENCRYPTEDSECRETHEADER_PATCH
	PY_ENCRYPTEDSECRETHEADER_PATCH(&EncryptedSecretHeader_Type);
#endif
#ifdef PY_ENCRYPTEDSECRET_PATCH
	PY_ENCRYPTEDSECRET_PATCH(&EncryptedSecret_Type);
#endif
#ifdef PY_DRSBLOBS_PATCH
	PY_DRSBLOBS_PATCH(&drsblobs_InterfaceType);
#endif
#ifdef PY_DRSBLOBS_ABSTRACT_SYNTAX_PATCH
	PY_DRSBLOBS_ABSTRACT_SYNTAX_PATCH(&drsblobs_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&drsblobs_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "SUPPLEMENTAL_CREDENTIALS_PREFIX", PyUnicode_FromString("                                                "));
	PyModule_AddObject(m, "ENCRYPTED_SECRET_MAGIC_VALUE", PyLong_FromUnsignedLongLong(0xCA5CADED));
	PyModule_AddObject(m, "PREFIX_MAP_VERSION_DSDB", PyLong_FromUnsignedLongLong((uint32_t)(PREFIX_MAP_VERSION_DSDB)));
	PyModule_AddObject(m, "SUPPLEMENTAL_CREDENTIALS_SIGNATURE", PyLong_FromLong((uint16_t)(SUPPLEMENTAL_CREDENTIALS_SIGNATURE)));
	PyModule_AddObject(m, "EXTENDED_ERROR_COMPUTER_NAME_PRESENT", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_COMPUTER_NAME_PRESENT)));
	PyModule_AddObject(m, "EXTENDED_ERROR_COMPUTER_NAME_NOT_PRESENT", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_COMPUTER_NAME_NOT_PRESENT)));
	PyModule_AddObject(m, "EXTENDED_ERROR_PARAM_TYPE_ASCII_STRING", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_PARAM_TYPE_ASCII_STRING)));
	PyModule_AddObject(m, "EXTENDED_ERROR_PARAM_TYPE_UNICODE_STRING", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_PARAM_TYPE_UNICODE_STRING)));
	PyModule_AddObject(m, "EXTENDED_ERROR_PARAM_TYPE_UINT32", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_PARAM_TYPE_UINT32)));
	PyModule_AddObject(m, "EXTENDED_ERROR_PARAM_TYPE_UINT16", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_PARAM_TYPE_UINT16)));
	PyModule_AddObject(m, "EXTENDED_ERROR_PARAM_TYPE_UINT64", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_PARAM_TYPE_UINT64)));
	PyModule_AddObject(m, "EXTENDED_ERROR_PARAM_TYPE_NONE", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_PARAM_TYPE_NONE)));
	PyModule_AddObject(m, "EXTENDED_ERROR_PARAM_TYPE_BLOB", PyLong_FromLong((uint16_t)(EXTENDED_ERROR_PARAM_TYPE_BLOB)));
	PyModule_AddObject(m, "FOREST_TRUST_TOP_LEVEL_NAME", PyLong_FromLong((uint16_t)(FOREST_TRUST_TOP_LEVEL_NAME)));
	PyModule_AddObject(m, "FOREST_TRUST_TOP_LEVEL_NAME_EX", PyLong_FromLong((uint16_t)(FOREST_TRUST_TOP_LEVEL_NAME_EX)));
	PyModule_AddObject(m, "FOREST_TRUST_DOMAIN_INFO", PyLong_FromLong((uint16_t)(FOREST_TRUST_DOMAIN_INFO)));
	PyModule_AddObject(m, "ENC_SECRET_AES_128_AEAD", PyLong_FromLong((uint16_t)(ENC_SECRET_AES_128_AEAD)));
	Py_INCREF((PyObject *)(void *)&replPropertyMetaData1_Type);
	PyModule_AddObject(m, "replPropertyMetaData1", (PyObject *)(void *)&replPropertyMetaData1_Type);
	Py_INCREF((PyObject *)(void *)&replPropertyMetaDataCtr1_Type);
	PyModule_AddObject(m, "replPropertyMetaDataCtr1", (PyObject *)(void *)&replPropertyMetaDataCtr1_Type);
	Py_INCREF((PyObject *)(void *)&replPropertyMetaDataCtr_Type);
	PyModule_AddObject(m, "replPropertyMetaDataCtr", (PyObject *)(void *)&replPropertyMetaDataCtr_Type);
	Py_INCREF((PyObject *)(void *)&replPropertyMetaDataBlob_Type);
	PyModule_AddObject(m, "replPropertyMetaDataBlob", (PyObject *)(void *)&replPropertyMetaDataBlob_Type);
	Py_INCREF((PyObject *)(void *)&replUpToDateVectorCtr1_Type);
	PyModule_AddObject(m, "replUpToDateVectorCtr1", (PyObject *)(void *)&replUpToDateVectorCtr1_Type);
	Py_INCREF((PyObject *)(void *)&replUpToDateVectorCtr2_Type);
	PyModule_AddObject(m, "replUpToDateVectorCtr2", (PyObject *)(void *)&replUpToDateVectorCtr2_Type);
	Py_INCREF((PyObject *)(void *)&replUpToDateVectorCtr_Type);
	PyModule_AddObject(m, "replUpToDateVectorCtr", (PyObject *)(void *)&replUpToDateVectorCtr_Type);
	Py_INCREF((PyObject *)(void *)&replUpToDateVectorBlob_Type);
	PyModule_AddObject(m, "replUpToDateVectorBlob", (PyObject *)(void *)&replUpToDateVectorBlob_Type);
	Py_INCREF((PyObject *)(void *)&repsFromTo1OtherInfo_Type);
	PyModule_AddObject(m, "repsFromTo1OtherInfo", (PyObject *)(void *)&repsFromTo1OtherInfo_Type);
	Py_INCREF((PyObject *)(void *)&repsFromTo1_Type);
	PyModule_AddObject(m, "repsFromTo1", (PyObject *)(void *)&repsFromTo1_Type);
	Py_INCREF((PyObject *)(void *)&repsFromTo2OtherInfo_Type);
	PyModule_AddObject(m, "repsFromTo2OtherInfo", (PyObject *)(void *)&repsFromTo2OtherInfo_Type);
	Py_INCREF((PyObject *)(void *)&repsFromTo2_Type);
	PyModule_AddObject(m, "repsFromTo2", (PyObject *)(void *)&repsFromTo2_Type);
	Py_INCREF((PyObject *)(void *)&repsFromTo_Type);
	PyModule_AddObject(m, "repsFromTo", (PyObject *)(void *)&repsFromTo_Type);
	Py_INCREF((PyObject *)(void *)&repsFromToBlob_Type);
	PyModule_AddObject(m, "repsFromToBlob", (PyObject *)(void *)&repsFromToBlob_Type);
	Py_INCREF((PyObject *)(void *)&scheduleHeader_Type);
	PyModule_AddObject(m, "scheduleHeader", (PyObject *)(void *)&scheduleHeader_Type);
	Py_INCREF((PyObject *)(void *)&scheduleSlots_Type);
	PyModule_AddObject(m, "scheduleSlots", (PyObject *)(void *)&scheduleSlots_Type);
	Py_INCREF((PyObject *)(void *)&schedule_Type);
	PyModule_AddObject(m, "schedule", (PyObject *)(void *)&schedule_Type);
	Py_INCREF((PyObject *)(void *)&partialAttributeSetCtr1_Type);
	PyModule_AddObject(m, "partialAttributeSetCtr1", (PyObject *)(void *)&partialAttributeSetCtr1_Type);
	Py_INCREF((PyObject *)(void *)&partialAttributeSetCtr_Type);
	PyModule_AddObject(m, "partialAttributeSetCtr", (PyObject *)(void *)&partialAttributeSetCtr_Type);
	Py_INCREF((PyObject *)(void *)&partialAttributeSetBlob_Type);
	PyModule_AddObject(m, "partialAttributeSetBlob", (PyObject *)(void *)&partialAttributeSetBlob_Type);
	Py_INCREF((PyObject *)(void *)&schemaInfoBlob_Type);
	PyModule_AddObject(m, "schemaInfoBlob", (PyObject *)(void *)&schemaInfoBlob_Type);
	Py_INCREF((PyObject *)(void *)&drsuapi_MSPrefixMap_Entry_Type);
	PyModule_AddObject(m, "drsuapi_MSPrefixMap_Entry", (PyObject *)(void *)&drsuapi_MSPrefixMap_Entry_Type);
	Py_INCREF((PyObject *)(void *)&drsuapi_MSPrefixMap_Ctr_Type);
	PyModule_AddObject(m, "drsuapi_MSPrefixMap_Ctr", (PyObject *)(void *)&drsuapi_MSPrefixMap_Ctr_Type);
	Py_INCREF((PyObject *)(void *)&prefixMapCtr_Type);
	PyModule_AddObject(m, "prefixMapCtr", (PyObject *)(void *)&prefixMapCtr_Type);
	Py_INCREF((PyObject *)(void *)&prefixMapBlob_Type);
	PyModule_AddObject(m, "prefixMapBlob", (PyObject *)(void *)&prefixMapBlob_Type);
	Py_INCREF((PyObject *)(void *)&ldapControlDirSyncExtra_Type);
	PyModule_AddObject(m, "ldapControlDirSyncExtra", (PyObject *)(void *)&ldapControlDirSyncExtra_Type);
	Py_INCREF((PyObject *)(void *)&ldapControlDirSyncBlob_Type);
	PyModule_AddObject(m, "ldapControlDirSyncBlob", (PyObject *)(void *)&ldapControlDirSyncBlob_Type);
	Py_INCREF((PyObject *)(void *)&ldapControlDirSyncCookie_Type);
	PyModule_AddObject(m, "ldapControlDirSyncCookie", (PyObject *)(void *)&ldapControlDirSyncCookie_Type);
	Py_INCREF((PyObject *)(void *)&supplementalCredentialsPackage_Type);
	PyModule_AddObject(m, "supplementalCredentialsPackage", (PyObject *)(void *)&supplementalCredentialsPackage_Type);
	Py_INCREF((PyObject *)(void *)&supplementalCredentialsSubBlob_Type);
	PyModule_AddObject(m, "supplementalCredentialsSubBlob", (PyObject *)(void *)&supplementalCredentialsSubBlob_Type);
	Py_INCREF((PyObject *)(void *)&supplementalCredentialsBlob_Type);
	PyModule_AddObject(m, "supplementalCredentialsBlob", (PyObject *)(void *)&supplementalCredentialsBlob_Type);
	Py_INCREF((PyObject *)(void *)&package_PackagesBlob_Type);
	PyModule_AddObject(m, "package_PackagesBlob", (PyObject *)(void *)&package_PackagesBlob_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryKerberosString_Type);
	PyModule_AddObject(m, "package_PrimaryKerberosString", (PyObject *)(void *)&package_PrimaryKerberosString_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryKerberosKey3_Type);
	PyModule_AddObject(m, "package_PrimaryKerberosKey3", (PyObject *)(void *)&package_PrimaryKerberosKey3_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryKerberosCtr3_Type);
	PyModule_AddObject(m, "package_PrimaryKerberosCtr3", (PyObject *)(void *)&package_PrimaryKerberosCtr3_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryKerberosKey4_Type);
	PyModule_AddObject(m, "package_PrimaryKerberosKey4", (PyObject *)(void *)&package_PrimaryKerberosKey4_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryKerberosCtr4_Type);
	PyModule_AddObject(m, "package_PrimaryKerberosCtr4", (PyObject *)(void *)&package_PrimaryKerberosCtr4_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryKerberosCtr_Type);
	PyModule_AddObject(m, "package_PrimaryKerberosCtr", (PyObject *)(void *)&package_PrimaryKerberosCtr_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryKerberosBlob_Type);
	PyModule_AddObject(m, "package_PrimaryKerberosBlob", (PyObject *)(void *)&package_PrimaryKerberosBlob_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryCLEARTEXTBlob_Type);
	PyModule_AddObject(m, "package_PrimaryCLEARTEXTBlob", (PyObject *)(void *)&package_PrimaryCLEARTEXTBlob_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryWDigestHash_Type);
	PyModule_AddObject(m, "package_PrimaryWDigestHash", (PyObject *)(void *)&package_PrimaryWDigestHash_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryWDigestBlob_Type);
	PyModule_AddObject(m, "package_PrimaryWDigestBlob", (PyObject *)(void *)&package_PrimaryWDigestBlob_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimarySambaGPGBlob_Type);
	PyModule_AddObject(m, "package_PrimarySambaGPGBlob", (PyObject *)(void *)&package_PrimarySambaGPGBlob_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryUserPasswordValue_Type);
	PyModule_AddObject(m, "package_PrimaryUserPasswordValue", (PyObject *)(void *)&package_PrimaryUserPasswordValue_Type);
	Py_INCREF((PyObject *)(void *)&package_PrimaryUserPasswordBlob_Type);
	PyModule_AddObject(m, "package_PrimaryUserPasswordBlob", (PyObject *)(void *)&package_PrimaryUserPasswordBlob_Type);
	Py_INCREF((PyObject *)(void *)&AuthInfoNone_Type);
	PyModule_AddObject(m, "AuthInfoNone", (PyObject *)(void *)&AuthInfoNone_Type);
	Py_INCREF((PyObject *)(void *)&AuthInfoNT4Owf_Type);
	PyModule_AddObject(m, "AuthInfoNT4Owf", (PyObject *)(void *)&AuthInfoNT4Owf_Type);
	Py_INCREF((PyObject *)(void *)&AuthInfoClear_Type);
	PyModule_AddObject(m, "AuthInfoClear", (PyObject *)(void *)&AuthInfoClear_Type);
	Py_INCREF((PyObject *)(void *)&AuthInfoVersion_Type);
	PyModule_AddObject(m, "AuthInfoVersion", (PyObject *)(void *)&AuthInfoVersion_Type);
	Py_INCREF((PyObject *)(void *)&AuthInfo_Type);
	PyModule_AddObject(m, "AuthInfo", (PyObject *)(void *)&AuthInfo_Type);
	Py_INCREF((PyObject *)(void *)&AuthenticationInformation_Type);
	PyModule_AddObject(m, "AuthenticationInformation", (PyObject *)(void *)&AuthenticationInformation_Type);
	Py_INCREF((PyObject *)(void *)&AuthenticationInformationArray_Type);
	PyModule_AddObject(m, "AuthenticationInformationArray", (PyObject *)(void *)&AuthenticationInformationArray_Type);
	Py_INCREF((PyObject *)(void *)&trustAuthInOutBlob_Type);
	PyModule_AddObject(m, "trustAuthInOutBlob", (PyObject *)(void *)&trustAuthInOutBlob_Type);
	Py_INCREF((PyObject *)(void *)&trustDomainPasswords_Type);
	PyModule_AddObject(m, "trustDomainPasswords", (PyObject *)(void *)&trustDomainPasswords_Type);
	Py_INCREF((PyObject *)(void *)&DsCompressedChunk_Type);
	PyModule_AddObject(m, "DsCompressedChunk", (PyObject *)(void *)&DsCompressedChunk_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorAString_Type);
	PyModule_AddObject(m, "ExtendedErrorAString", (PyObject *)(void *)&ExtendedErrorAString_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorUString_Type);
	PyModule_AddObject(m, "ExtendedErrorUString", (PyObject *)(void *)&ExtendedErrorUString_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorBlob_Type);
	PyModule_AddObject(m, "ExtendedErrorBlob", (PyObject *)(void *)&ExtendedErrorBlob_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorComputerNameU_Type);
	PyModule_AddObject(m, "ExtendedErrorComputerNameU", (PyObject *)(void *)&ExtendedErrorComputerNameU_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorComputerName_Type);
	PyModule_AddObject(m, "ExtendedErrorComputerName", (PyObject *)(void *)&ExtendedErrorComputerName_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorParamU_Type);
	PyModule_AddObject(m, "ExtendedErrorParamU", (PyObject *)(void *)&ExtendedErrorParamU_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorParam_Type);
	PyModule_AddObject(m, "ExtendedErrorParam", (PyObject *)(void *)&ExtendedErrorParam_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorInfo_Type);
	PyModule_AddObject(m, "ExtendedErrorInfo", (PyObject *)(void *)&ExtendedErrorInfo_Type);
	Py_INCREF((PyObject *)(void *)&ExtendedErrorInfoPtr_Type);
	PyModule_AddObject(m, "ExtendedErrorInfoPtr", (PyObject *)(void *)&ExtendedErrorInfoPtr_Type);
	Py_INCREF((PyObject *)(void *)&ForestTrustString_Type);
	PyModule_AddObject(m, "ForestTrustString", (PyObject *)(void *)&ForestTrustString_Type);
	Py_INCREF((PyObject *)(void *)&ForestTrustDataDomainInfo_Type);
	PyModule_AddObject(m, "ForestTrustDataDomainInfo", (PyObject *)(void *)&ForestTrustDataDomainInfo_Type);
	Py_INCREF((PyObject *)(void *)&ForestTrustDataBinaryData_Type);
	PyModule_AddObject(m, "ForestTrustDataBinaryData", (PyObject *)(void *)&ForestTrustDataBinaryData_Type);
	Py_INCREF((PyObject *)(void *)&ForestTrustData_Type);
	PyModule_AddObject(m, "ForestTrustData", (PyObject *)(void *)&ForestTrustData_Type);
	Py_INCREF((PyObject *)(void *)&ForestTrustInfoRecord_Type);
	PyModule_AddObject(m, "ForestTrustInfoRecord", (PyObject *)(void *)&ForestTrustInfoRecord_Type);
	Py_INCREF((PyObject *)(void *)&ForestTrustInfoRecordArmor_Type);
	PyModule_AddObject(m, "ForestTrustInfoRecordArmor", (PyObject *)(void *)&ForestTrustInfoRecordArmor_Type);
	Py_INCREF((PyObject *)(void *)&ForestTrustInfo_Type);
	PyModule_AddObject(m, "ForestTrustInfo", (PyObject *)(void *)&ForestTrustInfo_Type);
	Py_INCREF((PyObject *)(void *)&PlaintextSecret_Type);
	PyModule_AddObject(m, "PlaintextSecret", (PyObject *)(void *)&PlaintextSecret_Type);
	Py_INCREF((PyObject *)(void *)&EncryptedSecretHeader_Type);
	PyModule_AddObject(m, "EncryptedSecretHeader", (PyObject *)(void *)&EncryptedSecretHeader_Type);
	Py_INCREF((PyObject *)(void *)&EncryptedSecret_Type);
	PyModule_AddObject(m, "EncryptedSecret", (PyObject *)(void *)&EncryptedSecret_Type);
	Py_INCREF((PyObject *)(void *)&drsblobs_InterfaceType);
	PyModule_AddObject(m, "drsblobs", (PyObject *)(void *)&drsblobs_InterfaceType);
	Py_INCREF((PyObject *)(void *)&drsblobs_SyntaxType);
	PyModule_AddObject(m, "drsblobs_abstract_syntax", (PyObject *)(void *)&drsblobs_SyntaxType);
	Py_INCREF((PyObject *)(void *)&drsblobs_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&drsblobs_SyntaxType);
#ifdef PY_MOD_DRSBLOBS_PATCH
	PY_MOD_DRSBLOBS_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_drsuapi);
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_samr);
	Py_XDECREF(dep_samba_dcerpc_lsa);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
