
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_dnsp.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject dnsp_soa_Type;
static PyTypeObject dnsp_mx_Type;
static PyTypeObject dnsp_hinfo_Type;
static PyTypeObject dnsp_srv_Type;
static PyTypeObject dnsp_ip4_array_Type;
static PyTypeObject dnsp_dns_addr_Type;
static PyTypeObject dnsp_dns_addr_array_Type;
static PyTypeObject dnsp_string_list_Type;
static PyTypeObject dnsRecordData_Type;
static PyTypeObject dnsp_DnssrvRpcRecord_Type;
static PyTypeObject dnsPropertyData_Type;
static PyTypeObject dnsp_DnsProperty_Type;
static PyTypeObject dnsp_DnsProperty_short_Type;
static PyTypeObject dnsp_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_dnsp_soa_get_serial(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(obj);
	PyObject *py_serial;
	py_serial = PyLong_FromUnsignedLongLong((uint32_t)(object->serial));
	return py_serial;
}

static int py_dnsp_soa_set_serial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->serial");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_soa_get_refresh(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(obj);
	PyObject *py_refresh;
	py_refresh = PyLong_FromUnsignedLongLong((uint32_t)(object->refresh));
	return py_refresh;
}

static int py_dnsp_soa_set_refresh(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->refresh");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->refresh));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->refresh = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_soa_get_retry(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(obj);
	PyObject *py_retry;
	py_retry = PyLong_FromUnsignedLongLong((uint32_t)(object->retry));
	return py_retry;
}

static int py_dnsp_soa_set_retry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->retry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->retry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->retry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_soa_get_expire(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(obj);
	PyObject *py_expire;
	py_expire = PyLong_FromUnsignedLongLong((uint32_t)(object->expire));
	return py_expire;
}

static int py_dnsp_soa_set_expire(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->expire");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->expire));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->expire = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_soa_get_minimum(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(obj);
	PyObject *py_minimum;
	py_minimum = PyLong_FromUnsignedLongLong((uint32_t)(object->minimum));
	return py_minimum;
}

static int py_dnsp_soa_set_minimum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->minimum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minimum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minimum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_soa_get_mname(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(obj);
	PyObject *py_mname;
	py_mname = PyString_FromStringOrNULL(object->mname);
	return py_mname;
}

static int py_dnsp_soa_set_mname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->mname");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->mname = talloc_str;
	}
	return 0;
}

static PyObject *py_dnsp_soa_get_rname(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(obj);
	PyObject *py_rname;
	py_rname = PyString_FromStringOrNULL(object->rname);
	return py_rname;
}

static int py_dnsp_soa_set_rname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rname");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->rname = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_dnsp_soa_getsetters[] = {
	{
		.name = discard_const_p(char, "serial"),
		.get = py_dnsp_soa_get_serial,
		.set = py_dnsp_soa_set_serial,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "refresh"),
		.get = py_dnsp_soa_get_refresh,
		.set = py_dnsp_soa_set_refresh,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "retry"),
		.get = py_dnsp_soa_get_retry,
		.set = py_dnsp_soa_set_retry,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "expire"),
		.get = py_dnsp_soa_get_expire,
		.set = py_dnsp_soa_set_expire,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minimum"),
		.get = py_dnsp_soa_get_minimum,
		.set = py_dnsp_soa_set_minimum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "mname"),
		.get = py_dnsp_soa_get_mname,
		.set = py_dnsp_soa_set_mname,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_name")
	},
	{
		.name = discard_const_p(char, "rname"),
		.get = py_dnsp_soa_get_rname,
		.set = py_dnsp_soa_set_rname,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_name")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_soa_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_soa, type);
}

static PyObject *py_dnsp_soa_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_soa);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_soa_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_soa);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_soa);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_soa_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_soa *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_soa, "dnsp_soa", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_soa_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_soa_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_soa_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_soa_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_soa_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.soa",
	.tp_getset = py_dnsp_soa_getsetters,
	.tp_methods = py_dnsp_soa_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_soa_new,
};


static PyObject *py_dnsp_mx_get_wPriority(PyObject *obj, void *closure)
{
	struct dnsp_mx *object = pytalloc_get_ptr(obj);
	PyObject *py_wPriority;
	py_wPriority = PyLong_FromLong((uint16_t)(object->wPriority));
	return py_wPriority;
}

static int py_dnsp_mx_set_wPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_mx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wPriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wPriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wPriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_mx_get_nameTarget(PyObject *obj, void *closure)
{
	struct dnsp_mx *object = pytalloc_get_ptr(obj);
	PyObject *py_nameTarget;
	py_nameTarget = PyString_FromStringOrNULL(object->nameTarget);
	return py_nameTarget;
}

static int py_dnsp_mx_set_nameTarget(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_mx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->nameTarget");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->nameTarget = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_dnsp_mx_getsetters[] = {
	{
		.name = discard_const_p(char, "wPriority"),
		.get = py_dnsp_mx_get_wPriority,
		.set = py_dnsp_mx_set_wPriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nameTarget"),
		.get = py_dnsp_mx_get_nameTarget,
		.set = py_dnsp_mx_set_nameTarget,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_name")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_mx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_mx, type);
}

static PyObject *py_dnsp_mx_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_mx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_mx);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_mx_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_mx *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_mx);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_mx);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_mx_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_mx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_mx, "dnsp_mx", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_mx_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_mx_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_mx_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_mx_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_mx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.mx",
	.tp_getset = py_dnsp_mx_getsetters,
	.tp_methods = py_dnsp_mx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_mx_new,
};


static PyObject *py_dnsp_hinfo_get_cpu(PyObject *obj, void *closure)
{
	struct dnsp_hinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_cpu;
	py_cpu = PyString_FromStringOrNULL(object->cpu);
	return py_cpu;
}

static int py_dnsp_hinfo_set_cpu(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_hinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->cpu");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->cpu = talloc_str;
	}
	return 0;
}

static PyObject *py_dnsp_hinfo_get_os(PyObject *obj, void *closure)
{
	struct dnsp_hinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_os;
	py_os = PyString_FromStringOrNULL(object->os);
	return py_os;
}

static int py_dnsp_hinfo_set_os(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_hinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->os");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->os = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_dnsp_hinfo_getsetters[] = {
	{
		.name = discard_const_p(char, "cpu"),
		.get = py_dnsp_hinfo_get_cpu,
		.set = py_dnsp_hinfo_set_cpu,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_string")
	},
	{
		.name = discard_const_p(char, "os"),
		.get = py_dnsp_hinfo_get_os,
		.set = py_dnsp_hinfo_set_os,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_string")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_hinfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_hinfo, type);
}

static PyObject *py_dnsp_hinfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_hinfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_hinfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_hinfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_hinfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_hinfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_hinfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_hinfo_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_hinfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_hinfo, "dnsp_hinfo", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_hinfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_hinfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_hinfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_hinfo_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_hinfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.hinfo",
	.tp_getset = py_dnsp_hinfo_getsetters,
	.tp_methods = py_dnsp_hinfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_hinfo_new,
};


static PyObject *py_dnsp_srv_get_wPriority(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(obj);
	PyObject *py_wPriority;
	py_wPriority = PyLong_FromLong((uint16_t)(object->wPriority));
	return py_wPriority;
}

static int py_dnsp_srv_set_wPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wPriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wPriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wPriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_srv_get_wWeight(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(obj);
	PyObject *py_wWeight;
	py_wWeight = PyLong_FromLong((uint16_t)(object->wWeight));
	return py_wWeight;
}

static int py_dnsp_srv_set_wWeight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wWeight");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wWeight));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wWeight = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_srv_get_wPort(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(obj);
	PyObject *py_wPort;
	py_wPort = PyLong_FromLong((uint16_t)(object->wPort));
	return py_wPort;
}

static int py_dnsp_srv_set_wPort(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wPort");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wPort));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wPort = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_srv_get_nameTarget(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(obj);
	PyObject *py_nameTarget;
	py_nameTarget = PyString_FromStringOrNULL(object->nameTarget);
	return py_nameTarget;
}

static int py_dnsp_srv_set_nameTarget(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->nameTarget");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->nameTarget = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_dnsp_srv_getsetters[] = {
	{
		.name = discard_const_p(char, "wPriority"),
		.get = py_dnsp_srv_get_wPriority,
		.set = py_dnsp_srv_set_wPriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wWeight"),
		.get = py_dnsp_srv_get_wWeight,
		.set = py_dnsp_srv_set_wWeight,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wPort"),
		.get = py_dnsp_srv_get_wPort,
		.set = py_dnsp_srv_set_wPort,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nameTarget"),
		.get = py_dnsp_srv_get_nameTarget,
		.set = py_dnsp_srv_set_nameTarget,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_name")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_srv_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_srv, type);
}

static PyObject *py_dnsp_srv_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_srv *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_srv);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_srv_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_srv *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_srv);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_srv);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_srv_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_srv *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_srv, "dnsp_srv", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_srv_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_srv_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_srv_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_srv_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_srv_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.srv",
	.tp_getset = py_dnsp_srv_getsetters,
	.tp_methods = py_dnsp_srv_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_srv_new,
};


static PyObject *py_dnsp_ip4_array_get_addrCount(PyObject *obj, void *closure)
{
	struct dnsp_ip4_array *object = pytalloc_get_ptr(obj);
	PyObject *py_addrCount;
	py_addrCount = PyLong_FromUnsignedLongLong((uint32_t)(object->addrCount));
	return py_addrCount;
}

static int py_dnsp_ip4_array_set_addrCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_ip4_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->addrCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->addrCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->addrCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_ip4_array_get_addrArray(PyObject *obj, void *closure)
{
	struct dnsp_ip4_array *object = pytalloc_get_ptr(obj);
	PyObject *py_addrArray;
	py_addrArray = PyList_New(object->addrCount);
	if (py_addrArray == NULL) {
		return NULL;
	}
	{
		int addrArray_cntr_0;
		for (addrArray_cntr_0 = 0; addrArray_cntr_0 < (object->addrCount); addrArray_cntr_0++) {
			PyObject *py_addrArray_0;
			py_addrArray_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->addrArray)[addrArray_cntr_0]));
			PyList_SetItem(py_addrArray, addrArray_cntr_0, py_addrArray_0);
		}
	}
	return py_addrArray;
}

static int py_dnsp_ip4_array_set_addrArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_ip4_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->addrArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int addrArray_cntr_0;
		object->addrArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addrArray, PyList_GET_SIZE(value));
		if (!object->addrArray) { return -1; }
		talloc_set_name_const(object->addrArray, "ARRAY: object->addrArray");
		for (addrArray_cntr_0 = 0; addrArray_cntr_0 < PyList_GET_SIZE(value); addrArray_cntr_0++) {
			if (PyList_GET_ITEM(value, addrArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->addrArray)[addrArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->addrArray)[addrArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, addrArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, addrArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->addrArray)[addrArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dnsp_ip4_array_getsetters[] = {
	{
		.name = discard_const_p(char, "addrCount"),
		.get = py_dnsp_ip4_array_get_addrCount,
		.set = py_dnsp_ip4_array_set_addrCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "addrArray"),
		.get = py_dnsp_ip4_array_get_addrArray,
		.set = py_dnsp_ip4_array_set_addrArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_ip4_array_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_ip4_array, type);
}


static PyTypeObject dnsp_ip4_array_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.ip4_array",
	.tp_getset = py_dnsp_ip4_array_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_ip4_array_new,
};


static PyObject *py_dnsp_dns_addr_get_family(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(obj);
	PyObject *py_family;
	py_family = PyLong_FromLong((uint16_t)(object->family));
	return py_family;
}

static int py_dnsp_dns_addr_set_family(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->family");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->family));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->family = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_get_port(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromLong((uint16_t)(object->port));
	return py_port;
}

static int py_dnsp_dns_addr_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_get_ipv4(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(obj);
	PyObject *py_ipv4;
	py_ipv4 = PyString_FromStringOrNULL(object->ipv4);
	return py_ipv4;
}

static int py_dnsp_dns_addr_set_ipv4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ipv4");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipv4 = talloc_str;
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_get_ipv6(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(obj);
	PyObject *py_ipv6;
	py_ipv6 = PyString_FromStringOrNULL(object->ipv6);
	return py_ipv6;
}

static int py_dnsp_dns_addr_set_ipv6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ipv6");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipv6 = talloc_str;
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_get_pad(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(obj);
	PyObject *py_pad;
	py_pad = PyList_New(8);
	if (py_pad == NULL) {
		return NULL;
	}
	{
		int pad_cntr_0;
		for (pad_cntr_0 = 0; pad_cntr_0 < (8); pad_cntr_0++) {
			PyObject *py_pad_0;
			py_pad_0 = PyLong_FromLong((uint16_t)((object->pad)[pad_cntr_0]));
			PyList_SetItem(py_pad, pad_cntr_0, py_pad_0);
		}
	}
	return py_pad;
}

static int py_dnsp_dns_addr_set_pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->pad");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pad_cntr_0;
		if (ARRAY_SIZE(object->pad) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->pad),  PyList_GET_SIZE(value));
			return -1;
		}
		for (pad_cntr_0 = 0; pad_cntr_0 < PyList_GET_SIZE(value); pad_cntr_0++) {
			if (PyList_GET_ITEM(value, pad_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->pad)[pad_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->pad)[pad_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, pad_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pad_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->pad)[pad_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_get_unused(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(obj);
	PyObject *py_unused;
	py_unused = PyList_New(8);
	if (py_unused == NULL) {
		return NULL;
	}
	{
		int unused_cntr_0;
		for (unused_cntr_0 = 0; unused_cntr_0 < (8); unused_cntr_0++) {
			PyObject *py_unused_0;
			py_unused_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->unused)[unused_cntr_0]));
			PyList_SetItem(py_unused, unused_cntr_0, py_unused_0);
		}
	}
	return py_unused;
}

static int py_dnsp_dns_addr_set_unused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unused");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unused_cntr_0;
		if (ARRAY_SIZE(object->unused) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->unused),  PyList_GET_SIZE(value));
			return -1;
		}
		for (unused_cntr_0 = 0; unused_cntr_0 < PyList_GET_SIZE(value); unused_cntr_0++) {
			if (PyList_GET_ITEM(value, unused_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->unused)[unused_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->unused)[unused_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, unused_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, unused_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->unused)[unused_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dnsp_dns_addr_getsetters[] = {
	{
		.name = discard_const_p(char, "family"),
		.get = py_dnsp_dns_addr_get_family,
		.set = py_dnsp_dns_addr_set_family,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "port"),
		.get = py_dnsp_dns_addr_get_port,
		.set = py_dnsp_dns_addr_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ipv4"),
		.get = py_dnsp_dns_addr_get_ipv4,
		.set = py_dnsp_dns_addr_set_ipv4,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{
		.name = discard_const_p(char, "ipv6"),
		.get = py_dnsp_dns_addr_get_ipv6,
		.set = py_dnsp_dns_addr_set_ipv6,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv6address")
	},
	{
		.name = discard_const_p(char, "pad"),
		.get = py_dnsp_dns_addr_get_pad,
		.set = py_dnsp_dns_addr_set_pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "unused"),
		.get = py_dnsp_dns_addr_get_unused,
		.set = py_dnsp_dns_addr_set_unused,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_dns_addr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_dns_addr, type);
}


static PyTypeObject dnsp_dns_addr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.dns_addr",
	.tp_getset = py_dnsp_dns_addr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_dns_addr_new,
};


static PyObject *py_dnsp_dns_addr_array_get_MaxCount(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_MaxCount;
	py_MaxCount = PyLong_FromUnsignedLongLong((uint32_t)(object->MaxCount));
	return py_MaxCount;
}

static int py_dnsp_dns_addr_array_set_MaxCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->MaxCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MaxCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MaxCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_AddrCount(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_AddrCount;
	py_AddrCount = PyLong_FromUnsignedLongLong((uint32_t)(object->AddrCount));
	return py_AddrCount;
}

static int py_dnsp_dns_addr_array_set_AddrCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->AddrCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AddrCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AddrCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_Tag(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_Tag;
	py_Tag = PyLong_FromUnsignedLongLong((uint32_t)(object->Tag));
	return py_Tag;
}

static int py_dnsp_dns_addr_array_set_Tag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->Tag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Tag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Tag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_Family(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_Family;
	py_Family = PyLong_FromLong((uint16_t)(object->Family));
	return py_Family;
}

static int py_dnsp_dns_addr_array_set_Family(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->Family");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Family));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Family = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_Reserved0(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved0;
	py_Reserved0 = PyLong_FromLong((uint16_t)(object->Reserved0));
	return py_Reserved0;
}

static int py_dnsp_dns_addr_array_set_Reserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->Reserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_Flags(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromUnsignedLongLong((uint32_t)(object->Flags));
	return py_Flags;
}

static int py_dnsp_dns_addr_array_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_MatchFlag(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_MatchFlag;
	py_MatchFlag = PyLong_FromUnsignedLongLong((uint32_t)(object->MatchFlag));
	return py_MatchFlag;
}

static int py_dnsp_dns_addr_array_set_MatchFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->MatchFlag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MatchFlag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MatchFlag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_Reserved1(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved1;
	py_Reserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->Reserved1));
	return py_Reserved1;
}

static int py_dnsp_dns_addr_array_set_Reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->Reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_Reserved2(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved2;
	py_Reserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->Reserved2));
	return py_Reserved2;
}

static int py_dnsp_dns_addr_array_set_Reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->Reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_dns_addr_array_get_AddrArray(PyObject *obj, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(obj);
	PyObject *py_AddrArray;
	py_AddrArray = PyList_New(object->AddrCount);
	if (py_AddrArray == NULL) {
		return NULL;
	}
	{
		int AddrArray_cntr_0;
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < (object->AddrCount); AddrArray_cntr_0++) {
			PyObject *py_AddrArray_0;
			py_AddrArray_0 = pytalloc_reference_ex(&dnsp_dns_addr_Type, object->AddrArray, &(object->AddrArray)[AddrArray_cntr_0]);
			PyList_SetItem(py_AddrArray, AddrArray_cntr_0, py_AddrArray_0);
		}
	}
	return py_AddrArray;
}

static int py_dnsp_dns_addr_array_set_AddrArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->AddrArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int AddrArray_cntr_0;
		object->AddrArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->AddrArray, PyList_GET_SIZE(value));
		if (!object->AddrArray) { return -1; }
		talloc_set_name_const(object->AddrArray, "ARRAY: object->AddrArray");
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < PyList_GET_SIZE(value); AddrArray_cntr_0++) {
			if (PyList_GET_ITEM(value, AddrArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->AddrArray)[AddrArray_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dnsp_dns_addr_Type, PyList_GET_ITEM(value, AddrArray_cntr_0), return -1;);
			if (talloc_reference(object->AddrArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, AddrArray_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->AddrArray)[AddrArray_cntr_0] = *(struct dnsp_dns_addr *)pytalloc_get_ptr(PyList_GET_ITEM(value, AddrArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dnsp_dns_addr_array_getsetters[] = {
	{
		.name = discard_const_p(char, "MaxCount"),
		.get = py_dnsp_dns_addr_array_get_MaxCount,
		.set = py_dnsp_dns_addr_array_set_MaxCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "AddrCount"),
		.get = py_dnsp_dns_addr_array_get_AddrCount,
		.set = py_dnsp_dns_addr_array_set_AddrCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Tag"),
		.get = py_dnsp_dns_addr_array_get_Tag,
		.set = py_dnsp_dns_addr_array_set_Tag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Family"),
		.get = py_dnsp_dns_addr_array_get_Family,
		.set = py_dnsp_dns_addr_array_set_Family,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Reserved0"),
		.get = py_dnsp_dns_addr_array_get_Reserved0,
		.set = py_dnsp_dns_addr_array_set_Reserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_dnsp_dns_addr_array_get_Flags,
		.set = py_dnsp_dns_addr_array_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "MatchFlag"),
		.get = py_dnsp_dns_addr_array_get_MatchFlag,
		.set = py_dnsp_dns_addr_array_set_MatchFlag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Reserved1"),
		.get = py_dnsp_dns_addr_array_get_Reserved1,
		.set = py_dnsp_dns_addr_array_set_Reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Reserved2"),
		.get = py_dnsp_dns_addr_array_get_Reserved2,
		.set = py_dnsp_dns_addr_array_set_Reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "AddrArray"),
		.get = py_dnsp_dns_addr_array_get_AddrArray,
		.set = py_dnsp_dns_addr_array_set_AddrArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_dns_addr")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_dns_addr_array_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_dns_addr_array, type);
}

static PyObject *py_dnsp_dns_addr_array_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_dns_addr_array);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_dns_addr_array_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_dns_addr_array);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_dns_addr_array);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_dns_addr_array_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_dns_addr_array *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_dns_addr_array, "dnsp_dns_addr_array", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_dns_addr_array_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_dns_addr_array_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_dns_addr_array_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_dns_addr_array_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_dns_addr_array_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.dns_addr_array",
	.tp_getset = py_dnsp_dns_addr_array_getsetters,
	.tp_methods = py_dnsp_dns_addr_array_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_dns_addr_array_new,
};


static PyObject *py_dnsp_string_list_get_count(PyObject *obj, void *closure)
{
	struct dnsp_string_list *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromLong((uint16_t)(object->count));
	return py_count;
}

static int py_dnsp_string_list_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_string_list *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_string_list_get_str(PyObject *obj, void *closure)
{
	struct dnsp_string_list *object = pytalloc_get_ptr(obj);
	PyObject *py_str;
	py_str = PyList_New(object->count);
	if (py_str == NULL) {
		return NULL;
	}
	{
		int str_cntr_0;
		for (str_cntr_0 = 0; str_cntr_0 < (object->count); str_cntr_0++) {
			PyObject *py_str_0;
			py_str_0 = PyString_FromStringOrNULL((object->str)[str_cntr_0]);
			PyList_SetItem(py_str, str_cntr_0, py_str_0);
		}
	}
	return py_str;
}

static int py_dnsp_string_list_set_str(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_string_list *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->str");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int str_cntr_0;
		object->str = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->str, PyList_GET_SIZE(value));
		if (!object->str) { return -1; }
		talloc_set_name_const(object->str, "ARRAY: object->str");
		for (str_cntr_0 = 0; str_cntr_0 < PyList_GET_SIZE(value); str_cntr_0++) {
			if (PyList_GET_ITEM(value, str_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->str)[str_cntr_0]");
				return -1;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(PyList_GET_ITEM(value, str_cntr_0))) {
					unicode = PyUnicode_AsEncodedString(PyList_GET_ITEM(value, str_cntr_0), "utf-8", "ignore");
					if (unicode == NULL) {
						return -1;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(PyList_GET_ITEM(value, str_cntr_0))) {
					test_str = PyBytes_AS_STRING(PyList_GET_ITEM(value, str_cntr_0));
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(PyList_GET_ITEM(value, str_cntr_0))->tp_name);
					return -1;
				}
				talloc_str = talloc_strdup(object->str, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->str)[str_cntr_0] = talloc_str;
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dnsp_string_list_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_dnsp_string_list_get_count,
		.set = py_dnsp_string_list_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "str"),
		.get = py_dnsp_string_list_get_str,
		.set = py_dnsp_string_list_set_str,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_string")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_string_list_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_string_list, type);
}

static PyObject *py_dnsp_string_list_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_string_list *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_string_list);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_string_list_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_string_list *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_string_list);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_string_list);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_string_list_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_string_list *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_string_list, "dnsp_string_list", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_string_list_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_string_list_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_string_list_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_string_list_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_string_list_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.string_list",
	.tp_getset = py_dnsp_string_list_getsetters,
	.tp_methods = py_dnsp_string_list_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_string_list_new,
};

static PyObject *py_import_dnsRecordData(TALLOC_CTX *mem_ctx, int level, union dnsRecordData *in)
{
	PyObject *ret;

	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			ret = PyLong_FromUnsignedLongLong(in->EntombedTime);
			return ret;

		case DNS_TYPE_A:
			ret = PyString_FromStringOrNULL(in->ipv4);
			return ret;

		case DNS_TYPE_NS:
			ret = PyString_FromStringOrNULL(in->ns);
			return ret;

		case DNS_TYPE_CNAME:
			ret = PyString_FromStringOrNULL(in->cname);
			return ret;

		case DNS_TYPE_SOA:
			ret = pytalloc_reference_ex(&dnsp_soa_Type, mem_ctx, &in->soa);
			return ret;

		case DNS_TYPE_MX:
			ret = pytalloc_reference_ex(&dnsp_mx_Type, mem_ctx, &in->mx);
			return ret;

		case DNS_TYPE_TXT:
			ret = pytalloc_reference_ex(&dnsp_string_list_Type, mem_ctx, &in->txt);
			return ret;

		case DNS_TYPE_PTR:
			ret = PyString_FromStringOrNULL(in->ptr);
			return ret;

		case DNS_TYPE_HINFO:
			ret = pytalloc_reference_ex(&dnsp_hinfo_Type, mem_ctx, &in->hinfo);
			return ret;

		case DNS_TYPE_AAAA:
			ret = PyString_FromStringOrNULL(in->ipv6);
			return ret;

		case DNS_TYPE_SRV:
			ret = pytalloc_reference_ex(&dnsp_srv_Type, mem_ctx, &in->srv);
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->data).data, (in->data).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dnsRecordData *py_export_dnsRecordData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dnsRecordData *ret = talloc_zero(mem_ctx, union dnsRecordData);
	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->EntombedTime");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->EntombedTime));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->EntombedTime = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DNS_TYPE_A:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ipv4");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ipv4 = talloc_str;
			}
			break;

		case DNS_TYPE_NS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ns");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ns = talloc_str;
			}
			break;

		case DNS_TYPE_CNAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->cname");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->cname = talloc_str;
			}
			break;

		case DNS_TYPE_SOA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->soa");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_soa_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->soa = *(struct dnsp_soa *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->mx");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_mx_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mx = *(struct dnsp_mx *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_TXT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->txt");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_string_list_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->txt = *(struct dnsp_string_list *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_PTR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ptr");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ptr = talloc_str;
			}
			break;

		case DNS_TYPE_HINFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->hinfo");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_hinfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->hinfo = *(struct dnsp_hinfo *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_AAAA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ipv6");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ipv6 = talloc_str;
			}
			break;

		case DNS_TYPE_SRV:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->srv");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_srv_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv = *(struct dnsp_srv *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->data");
				talloc_free(ret); return NULL;
			}
			ret->data = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_dnsRecordData_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dnsRecordData *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dnsRecordData *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dnsRecordData!");
		return NULL;
	}

	return py_import_dnsRecordData(mem_ctx, level, in);
}

static PyObject *py_dnsRecordData_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dnsRecordData *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dnsRecordData(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dnsRecordData_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsRecordData_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsRecordData_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dnsRecordData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dnsRecordData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.dnsRecordData",
	.tp_getset = NULL,
	.tp_methods = py_dnsRecordData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsRecordData_new,
};


static PyObject *py_dnsp_DnssrvRpcRecord_get_wDataLength(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_wDataLength;
	py_wDataLength = PyLong_FromLong((uint16_t)(object->wDataLength));
	return py_wDataLength;
}

static int py_dnsp_DnssrvRpcRecord_set_wDataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wDataLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wDataLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wDataLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_wType(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_wType;
	py_wType = PyLong_FromLong((uint16_t)(object->wType));
	return py_wType;
}

static int py_dnsp_DnssrvRpcRecord_set_wType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_version(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromLong((uint16_t)(object->version));
	return py_version;
}

static int py_dnsp_DnssrvRpcRecord_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_rank(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_rank;
	py_rank = PyLong_FromLong((uint16_t)(object->rank));
	return py_rank;
}

static int py_dnsp_DnssrvRpcRecord_set_rank(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rank");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rank));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rank = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_flags(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_dnsp_DnssrvRpcRecord_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwSerial(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_dwSerial;
	py_dwSerial = PyLong_FromUnsignedLongLong((uint32_t)(object->dwSerial));
	return py_dwSerial;
}

static int py_dnsp_DnssrvRpcRecord_set_dwSerial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwSerial");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwSerial));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwSerial = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwTtlSeconds(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTtlSeconds;
	py_dwTtlSeconds = PyLong_FromUnsignedLongLong((uint32_t)(object->dwTtlSeconds));
	return py_dwTtlSeconds;
}

static int py_dnsp_DnssrvRpcRecord_set_dwTtlSeconds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwTtlSeconds");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwTtlSeconds));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwTtlSeconds = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwReserved(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved));
	return py_dwReserved;
}

static int py_dnsp_DnssrvRpcRecord_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwReserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwTimeStamp(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTimeStamp;
	py_dwTimeStamp = PyLong_FromUnsignedLongLong((uint32_t)(object->dwTimeStamp));
	return py_dwTimeStamp;
}

static int py_dnsp_DnssrvRpcRecord_set_dwTimeStamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->dwTimeStamp");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwTimeStamp));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwTimeStamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_data(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&dnsRecordData_Type, pytalloc_get_mem_ctx(obj), object->wType, &object->data, "union dnsRecordData");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_dnsp_DnssrvRpcRecord_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	{
		union dnsRecordData *data_switch_0;
		data_switch_0 = (union dnsRecordData *)pyrpc_export_union(&dnsRecordData_Type, pytalloc_get_mem_ctx(py_obj), object->wType, value, "union dnsRecordData");
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dnsp_DnssrvRpcRecord_getsetters[] = {
	{
		.name = discard_const_p(char, "wDataLength"),
		.get = py_dnsp_DnssrvRpcRecord_get_wDataLength,
		.set = py_dnsp_DnssrvRpcRecord_set_wDataLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wType"),
		.get = py_dnsp_DnssrvRpcRecord_get_wType,
		.set = py_dnsp_DnssrvRpcRecord_set_wType,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_record_type")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_dnsp_DnssrvRpcRecord_get_version,
		.set = py_dnsp_DnssrvRpcRecord_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "rank"),
		.get = py_dnsp_DnssrvRpcRecord_get_rank,
		.set = py_dnsp_DnssrvRpcRecord_set_rank,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_record_rank")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_dnsp_DnssrvRpcRecord_get_flags,
		.set = py_dnsp_DnssrvRpcRecord_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dwSerial"),
		.get = py_dnsp_DnssrvRpcRecord_get_dwSerial,
		.set = py_dnsp_DnssrvRpcRecord_set_dwSerial,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwTtlSeconds"),
		.get = py_dnsp_DnssrvRpcRecord_get_dwTtlSeconds,
		.set = py_dnsp_DnssrvRpcRecord_set_dwTtlSeconds,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved"),
		.get = py_dnsp_DnssrvRpcRecord_get_dwReserved,
		.set = py_dnsp_DnssrvRpcRecord_set_dwReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwTimeStamp"),
		.get = py_dnsp_DnssrvRpcRecord_get_dwTimeStamp,
		.set = py_dnsp_DnssrvRpcRecord_set_dwTimeStamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_dnsp_DnssrvRpcRecord_get_data,
		.set = py_dnsp_DnssrvRpcRecord_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsRecordData")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_DnssrvRpcRecord_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_DnssrvRpcRecord, type);
}

static PyObject *py_dnsp_DnssrvRpcRecord_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_DnssrvRpcRecord);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_DnssrvRpcRecord_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_DnssrvRpcRecord);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_DnssrvRpcRecord);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_DnssrvRpcRecord_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_DnssrvRpcRecord *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_DnssrvRpcRecord, "dnsp_DnssrvRpcRecord", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_DnssrvRpcRecord_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_DnssrvRpcRecord_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_DnssrvRpcRecord_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_DnssrvRpcRecord_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_DnssrvRpcRecord_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.DnssrvRpcRecord",
	.tp_getset = py_dnsp_DnssrvRpcRecord_getsetters,
	.tp_methods = py_dnsp_DnssrvRpcRecord_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_DnssrvRpcRecord_new,
};

static PyObject *py_import_dnsPropertyData(TALLOC_CTX *mem_ctx, int level, union dnsPropertyData *in)
{
	PyObject *ret;

	switch (level) {
		case DSPROPERTY_ZONE_EMPTY:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case DSPROPERTY_ZONE_TYPE:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->zone_type));
			return ret;

		case DSPROPERTY_ZONE_ALLOW_UPDATE:
			ret = PyLong_FromLong((uint16_t)(in->allow_update_flag));
			return ret;

		case DSPROPERTY_ZONE_SECURE_TIME:
			ret = PyLong_FromUnsignedLongLong(in->zone_secure_time);
			return ret;

		case DSPROPERTY_ZONE_NOREFRESH_INTERVAL:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->norefresh_hours));
			return ret;

		case DSPROPERTY_ZONE_REFRESH_INTERVAL:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->refresh_hours));
			return ret;

		case DSPROPERTY_ZONE_AGING_STATE:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->aging_enabled));
			return ret;

		case DSPROPERTY_ZONE_SCAVENGING_SERVERS:
			ret = pytalloc_reference_ex(&dnsp_ip4_array_Type, mem_ctx, &in->servers);
			return ret;

		case DSPROPERTY_ZONE_AGING_ENABLED_TIME:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->next_scavenging_cycle_hours));
			return ret;

		case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME:
			ret = PyString_FromStringOrNULL(in->deleted_by_hostname);
			return ret;

		case DSPROPERTY_ZONE_MASTER_SERVERS:
			ret = pytalloc_reference_ex(&dnsp_ip4_array_Type, mem_ctx, &in->master_servers);
			return ret;

		case DSPROPERTY_ZONE_AUTO_NS_SERVERS:
			ret = pytalloc_reference_ex(&dnsp_ip4_array_Type, mem_ctx, &in->ns_servers);
			return ret;

		case DSPROPERTY_ZONE_DCPROMO_CONVERT:
			ret = PyLong_FromLong((uint16_t)(in->dcpromo_flag));
			return ret;

		case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA:
			ret = pytalloc_reference_ex(&dnsp_dns_addr_array_Type, mem_ctx, &in->s_ns_servers);
			return ret;

		case DSPROPERTY_ZONE_MASTER_SERVERS_DA:
			ret = pytalloc_reference_ex(&dnsp_dns_addr_array_Type, mem_ctx, &in->z_master_servers);
			return ret;

		case DSPROPERTY_ZONE_NS_SERVERS_DA:
			ret = pytalloc_reference_ex(&dnsp_dns_addr_array_Type, mem_ctx, &in->d_ns_servers);
			return ret;

		case DSPROPERTY_ZONE_NODE_DBFLAGS:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->flags));
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dnsPropertyData *py_export_dnsPropertyData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dnsPropertyData *ret = talloc_zero(mem_ctx, union dnsPropertyData);
	switch (level) {
		case DSPROPERTY_ZONE_EMPTY:
			break;

		case DSPROPERTY_ZONE_TYPE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->zone_type");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->zone_type));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->zone_type = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_ALLOW_UPDATE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->allow_update_flag");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->allow_update_flag));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->allow_update_flag = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_SECURE_TIME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->zone_secure_time");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->zone_secure_time));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->zone_secure_time = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_NOREFRESH_INTERVAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->norefresh_hours");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->norefresh_hours));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->norefresh_hours = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_REFRESH_INTERVAL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->refresh_hours");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->refresh_hours));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->refresh_hours = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_AGING_STATE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->aging_enabled");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->aging_enabled));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->aging_enabled = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_SCAVENGING_SERVERS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->servers");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_ip4_array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->servers = *(struct dnsp_ip4_array *)pytalloc_get_ptr(in);
			break;

		case DSPROPERTY_ZONE_AGING_ENABLED_TIME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->next_scavenging_cycle_hours");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->next_scavenging_cycle_hours));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->next_scavenging_cycle_hours = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->deleted_by_hostname");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->deleted_by_hostname = talloc_str;
			}
			break;

		case DSPROPERTY_ZONE_MASTER_SERVERS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->master_servers");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_ip4_array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->master_servers = *(struct dnsp_ip4_array *)pytalloc_get_ptr(in);
			break;

		case DSPROPERTY_ZONE_AUTO_NS_SERVERS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ns_servers");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_ip4_array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ns_servers = *(struct dnsp_ip4_array *)pytalloc_get_ptr(in);
			break;

		case DSPROPERTY_ZONE_DCPROMO_CONVERT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->dcpromo_flag");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->dcpromo_flag));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->dcpromo_flag = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->s_ns_servers");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_dns_addr_array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->s_ns_servers = *(struct dnsp_dns_addr_array *)pytalloc_get_ptr(in);
			break;

		case DSPROPERTY_ZONE_MASTER_SERVERS_DA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->z_master_servers");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_dns_addr_array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->z_master_servers = *(struct dnsp_dns_addr_array *)pytalloc_get_ptr(in);
			break;

		case DSPROPERTY_ZONE_NS_SERVERS_DA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->d_ns_servers");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dnsp_dns_addr_array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->d_ns_servers = *(struct dnsp_dns_addr_array *)pytalloc_get_ptr(in);
			break;

		case DSPROPERTY_ZONE_NODE_DBFLAGS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->flags");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->flags));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->flags = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_dnsPropertyData_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dnsPropertyData *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dnsPropertyData *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dnsPropertyData!");
		return NULL;
	}

	return py_import_dnsPropertyData(mem_ctx, level, in);
}

static PyObject *py_dnsPropertyData_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dnsPropertyData *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dnsPropertyData(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dnsPropertyData_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsPropertyData_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsPropertyData_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dnsPropertyData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dnsPropertyData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.dnsPropertyData",
	.tp_getset = NULL,
	.tp_methods = py_dnsPropertyData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsPropertyData_new,
};


static PyObject *py_dnsp_DnsProperty_get_wDataLength(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_wDataLength;
	py_wDataLength = PyLong_FromUnsignedLongLong((uint32_t)(object->wDataLength));
	return py_wDataLength;
}

static int py_dnsp_DnsProperty_set_wDataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wDataLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wDataLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wDataLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_get_namelength(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_namelength;
	py_namelength = PyLong_FromUnsignedLongLong((uint32_t)(object->namelength));
	return py_namelength;
}

static int py_dnsp_DnsProperty_set_namelength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->namelength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->namelength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->namelength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_get_flag(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_flag;
	py_flag = PyLong_FromUnsignedLongLong((uint32_t)(object->flag));
	return py_flag;
}

static int py_dnsp_DnsProperty_set_flag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_get_version(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_dnsp_DnsProperty_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_get_id(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyLong_FromUnsignedLongLong((uint32_t)(object->id));
	return py_id;
}

static int py_dnsp_DnsProperty_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_get_data(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&dnsPropertyData_Type, pytalloc_get_mem_ctx(obj), object->id, &object->data, "union dnsPropertyData");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_dnsp_DnsProperty_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	{
		union dnsPropertyData *data_switch_0;
		data_switch_0 = (union dnsPropertyData *)pyrpc_export_union(&dnsPropertyData_Type, pytalloc_get_mem_ctx(py_obj), object->id, value, "union dnsPropertyData");
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_get_name(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyLong_FromUnsignedLongLong((uint32_t)(object->name));
	return py_name;
}

static int py_dnsp_DnsProperty_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dnsp_DnsProperty_getsetters[] = {
	{
		.name = discard_const_p(char, "wDataLength"),
		.get = py_dnsp_DnsProperty_get_wDataLength,
		.set = py_dnsp_DnsProperty_set_wDataLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "namelength"),
		.get = py_dnsp_DnsProperty_get_namelength,
		.set = py_dnsp_DnsProperty_set_namelength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flag"),
		.get = py_dnsp_DnsProperty_get_flag,
		.set = py_dnsp_DnsProperty_set_flag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_dnsp_DnsProperty_get_version,
		.set = py_dnsp_DnsProperty_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "id"),
		.get = py_dnsp_DnsProperty_get_id,
		.set = py_dnsp_DnsProperty_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_property_id")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_dnsp_DnsProperty_get_data,
		.set = py_dnsp_DnsProperty_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsPropertyData")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_dnsp_DnsProperty_get_name,
		.set = py_dnsp_DnsProperty_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_DnsProperty_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_DnsProperty, type);
}

static PyObject *py_dnsp_DnsProperty_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_DnsProperty);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_DnsProperty_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_DnsProperty);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_DnsProperty);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_DnsProperty_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_DnsProperty *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_DnsProperty, "dnsp_DnsProperty", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_DnsProperty_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_DnsProperty_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_DnsProperty_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_DnsProperty_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_DnsProperty_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.DnsProperty",
	.tp_getset = py_dnsp_DnsProperty_getsetters,
	.tp_methods = py_dnsp_DnsProperty_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_DnsProperty_new,
};


static PyObject *py_dnsp_DnsProperty_short_get_wDataLength(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(obj);
	PyObject *py_wDataLength;
	py_wDataLength = PyLong_FromUnsignedLongLong((uint32_t)(object->wDataLength));
	return py_wDataLength;
}

static int py_dnsp_DnsProperty_short_set_wDataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->wDataLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wDataLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wDataLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_short_get_namelength(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(obj);
	PyObject *py_namelength;
	py_namelength = PyLong_FromUnsignedLongLong((uint32_t)(object->namelength));
	return py_namelength;
}

static int py_dnsp_DnsProperty_short_set_namelength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->namelength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->namelength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->namelength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_short_get_flag(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(obj);
	PyObject *py_flag;
	py_flag = PyLong_FromUnsignedLongLong((uint32_t)(object->flag));
	return py_flag;
}

static int py_dnsp_DnsProperty_short_set_flag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_short_get_version(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_dnsp_DnsProperty_short_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_short_get_id(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyLong_FromUnsignedLongLong((uint32_t)(object->id));
	return py_id;
}

static int py_dnsp_DnsProperty_short_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_short_get_data(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&dnsPropertyData_Type, pytalloc_get_mem_ctx(obj), DSPROPERTY_ZONE_EMPTY, &object->data, "union dnsPropertyData");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_dnsp_DnsProperty_short_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	{
		union dnsPropertyData *data_switch_0;
		data_switch_0 = (union dnsPropertyData *)pyrpc_export_union(&dnsPropertyData_Type, pytalloc_get_mem_ctx(py_obj), DSPROPERTY_ZONE_EMPTY, value, "union dnsPropertyData");
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyObject *py_dnsp_DnsProperty_short_get_name(PyObject *obj, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyLong_FromUnsignedLongLong((uint32_t)(object->name));
	return py_name;
}

static int py_dnsp_DnsProperty_short_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dnsp_DnsProperty_short_getsetters[] = {
	{
		.name = discard_const_p(char, "wDataLength"),
		.get = py_dnsp_DnsProperty_short_get_wDataLength,
		.set = py_dnsp_DnsProperty_short_set_wDataLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "namelength"),
		.get = py_dnsp_DnsProperty_short_get_namelength,
		.set = py_dnsp_DnsProperty_short_set_namelength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flag"),
		.get = py_dnsp_DnsProperty_short_get_flag,
		.set = py_dnsp_DnsProperty_short_set_flag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_dnsp_DnsProperty_short_get_version,
		.set = py_dnsp_DnsProperty_short_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "id"),
		.get = py_dnsp_DnsProperty_short_get_id,
		.set = py_dnsp_DnsProperty_short_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_property_id")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_dnsp_DnsProperty_short_get_data,
		.set = py_dnsp_DnsProperty_short_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsPropertyData")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_dnsp_DnsProperty_short_get_name,
		.set = py_dnsp_DnsProperty_short_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dnsp_DnsProperty_short_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dnsp_DnsProperty_short, type);
}

static PyObject *py_dnsp_DnsProperty_short_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dnsp_DnsProperty_short);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dnsp_DnsProperty_short_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_DnsProperty_short);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_DnsProperty_short);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_DnsProperty_short_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dnsp_DnsProperty_short *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_DnsProperty_short, "dnsp_DnsProperty_short", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_DnsProperty_short_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_DnsProperty_short_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsp_DnsProperty_short_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_DnsProperty_short_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_DnsProperty_short_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.DnsProperty_short",
	.tp_getset = py_dnsp_DnsProperty_short_getsetters,
	.tp_methods = py_dnsp_DnsProperty_short_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsp_DnsProperty_short_new,
};


const struct PyNdrRpcMethodDef py_ndr_dnsp_methods[] = {
	{0}
};

static PyObject *interface_dnsp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_dnsp);
}

#define PY_DOC_DNSP "DNSP interfaces"
static PyTypeObject dnsp_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.dnsp",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "dnsp(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_DNSP,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_dnsp_new,
};

static PyObject *syntax_dnsp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_dnsp.syntax_id);
}

#define PY_DOC_DNSP_SYNTAX "DNSP interfaces"
static PyTypeObject dnsp_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsp.dnsp_abstract_syntax",
	.tp_doc = "dnsp_abstract_syntax()\n"PY_DOC_DNSP_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_dnsp_new,
};

static PyMethodDef dnsp_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "dnsp",
	.m_doc = "dnsp DCE/RPC",
	.m_size = -1,
	.m_methods = dnsp_methods,
};
MODULE_INIT_FUNC(dnsp)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	dnsp_soa_Type.tp_base = BaseObject_Type;
	dnsp_soa_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_mx_Type.tp_base = BaseObject_Type;
	dnsp_mx_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_hinfo_Type.tp_base = BaseObject_Type;
	dnsp_hinfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_srv_Type.tp_base = BaseObject_Type;
	dnsp_srv_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_ip4_array_Type.tp_base = BaseObject_Type;
	dnsp_ip4_array_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_dns_addr_Type.tp_base = BaseObject_Type;
	dnsp_dns_addr_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_dns_addr_array_Type.tp_base = BaseObject_Type;
	dnsp_dns_addr_array_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_string_list_Type.tp_base = BaseObject_Type;
	dnsp_string_list_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsRecordData_Type.tp_base = BaseObject_Type;
	dnsRecordData_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_DnssrvRpcRecord_Type.tp_base = BaseObject_Type;
	dnsp_DnssrvRpcRecord_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsPropertyData_Type.tp_base = BaseObject_Type;
	dnsPropertyData_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_DnsProperty_Type.tp_base = BaseObject_Type;
	dnsp_DnsProperty_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_DnsProperty_short_Type.tp_base = BaseObject_Type;
	dnsp_DnsProperty_short_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsp_InterfaceType.tp_base = ClientConnection_Type;

	dnsp_SyntaxType.tp_base = ndr_syntax_id_Type;
	dnsp_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&dnsp_soa_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_mx_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_hinfo_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_srv_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_ip4_array_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_dns_addr_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_dns_addr_array_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_string_list_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsRecordData_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_DnssrvRpcRecord_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsPropertyData_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_DnsProperty_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_DnsProperty_short_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsp_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&dnsp_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&dnsp_InterfaceType, py_ndr_dnsp_methods))
		return NULL;

#ifdef PY_SOA_PATCH
	PY_SOA_PATCH(&dnsp_soa_Type);
#endif
#ifdef PY_MX_PATCH
	PY_MX_PATCH(&dnsp_mx_Type);
#endif
#ifdef PY_HINFO_PATCH
	PY_HINFO_PATCH(&dnsp_hinfo_Type);
#endif
#ifdef PY_SRV_PATCH
	PY_SRV_PATCH(&dnsp_srv_Type);
#endif
#ifdef PY_IP4_ARRAY_PATCH
	PY_IP4_ARRAY_PATCH(&dnsp_ip4_array_Type);
#endif
#ifdef PY_DNS_ADDR_PATCH
	PY_DNS_ADDR_PATCH(&dnsp_dns_addr_Type);
#endif
#ifdef PY_DNS_ADDR_ARRAY_PATCH
	PY_DNS_ADDR_ARRAY_PATCH(&dnsp_dns_addr_array_Type);
#endif
#ifdef PY_STRING_LIST_PATCH
	PY_STRING_LIST_PATCH(&dnsp_string_list_Type);
#endif
#ifdef PY_DNSRECORDDATA_PATCH
	PY_DNSRECORDDATA_PATCH(&dnsRecordData_Type);
#endif
#ifdef PY_DNSSRVRPCRECORD_PATCH
	PY_DNSSRVRPCRECORD_PATCH(&dnsp_DnssrvRpcRecord_Type);
#endif
#ifdef PY_DNSPROPERTYDATA_PATCH
	PY_DNSPROPERTYDATA_PATCH(&dnsPropertyData_Type);
#endif
#ifdef PY_DNSPROPERTY_PATCH
	PY_DNSPROPERTY_PATCH(&dnsp_DnsProperty_Type);
#endif
#ifdef PY_DNSPROPERTY_SHORT_PATCH
	PY_DNSPROPERTY_SHORT_PATCH(&dnsp_DnsProperty_short_Type);
#endif
#ifdef PY_DNSP_PATCH
	PY_DNSP_PATCH(&dnsp_InterfaceType);
#endif
#ifdef PY_DNSP_ABSTRACT_SYNTAX_PATCH
	PY_DNSP_ABSTRACT_SYNTAX_PATCH(&dnsp_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&dnsp_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "DNS_TYPE_TOMBSTONE", PyLong_FromLong((uint16_t)(DNS_TYPE_TOMBSTONE)));
	PyModule_AddObject(m, "DNS_TYPE_A", PyLong_FromLong((uint16_t)(DNS_TYPE_A)));
	PyModule_AddObject(m, "DNS_TYPE_NS", PyLong_FromLong((uint16_t)(DNS_TYPE_NS)));
	PyModule_AddObject(m, "DNS_TYPE_MD", PyLong_FromLong((uint16_t)(DNS_TYPE_MD)));
	PyModule_AddObject(m, "DNS_TYPE_MF", PyLong_FromLong((uint16_t)(DNS_TYPE_MF)));
	PyModule_AddObject(m, "DNS_TYPE_CNAME", PyLong_FromLong((uint16_t)(DNS_TYPE_CNAME)));
	PyModule_AddObject(m, "DNS_TYPE_SOA", PyLong_FromLong((uint16_t)(DNS_TYPE_SOA)));
	PyModule_AddObject(m, "DNS_TYPE_MB", PyLong_FromLong((uint16_t)(DNS_TYPE_MB)));
	PyModule_AddObject(m, "DNS_TYPE_MG", PyLong_FromLong((uint16_t)(DNS_TYPE_MG)));
	PyModule_AddObject(m, "DNS_TYPE_MR", PyLong_FromLong((uint16_t)(DNS_TYPE_MR)));
	PyModule_AddObject(m, "DNS_TYPE_NULL", PyLong_FromLong((uint16_t)(DNS_TYPE_NULL)));
	PyModule_AddObject(m, "DNS_TYPE_WKS", PyLong_FromLong((uint16_t)(DNS_TYPE_WKS)));
	PyModule_AddObject(m, "DNS_TYPE_PTR", PyLong_FromLong((uint16_t)(DNS_TYPE_PTR)));
	PyModule_AddObject(m, "DNS_TYPE_HINFO", PyLong_FromLong((uint16_t)(DNS_TYPE_HINFO)));
	PyModule_AddObject(m, "DNS_TYPE_MINFO", PyLong_FromLong((uint16_t)(DNS_TYPE_MINFO)));
	PyModule_AddObject(m, "DNS_TYPE_MX", PyLong_FromLong((uint16_t)(DNS_TYPE_MX)));
	PyModule_AddObject(m, "DNS_TYPE_TXT", PyLong_FromLong((uint16_t)(DNS_TYPE_TXT)));
	PyModule_AddObject(m, "DNS_TYPE_RP", PyLong_FromLong((uint16_t)(DNS_TYPE_RP)));
	PyModule_AddObject(m, "DNS_TYPE_AFSDB", PyLong_FromLong((uint16_t)(DNS_TYPE_AFSDB)));
	PyModule_AddObject(m, "DNS_TYPE_X25", PyLong_FromLong((uint16_t)(DNS_TYPE_X25)));
	PyModule_AddObject(m, "DNS_TYPE_ISDN", PyLong_FromLong((uint16_t)(DNS_TYPE_ISDN)));
	PyModule_AddObject(m, "DNS_TYPE_RT", PyLong_FromLong((uint16_t)(DNS_TYPE_RT)));
	PyModule_AddObject(m, "DNS_TYPE_SIG", PyLong_FromLong((uint16_t)(DNS_TYPE_SIG)));
	PyModule_AddObject(m, "DNS_TYPE_KEY", PyLong_FromLong((uint16_t)(DNS_TYPE_KEY)));
	PyModule_AddObject(m, "DNS_TYPE_AAAA", PyLong_FromLong((uint16_t)(DNS_TYPE_AAAA)));
	PyModule_AddObject(m, "DNS_TYPE_LOC", PyLong_FromLong((uint16_t)(DNS_TYPE_LOC)));
	PyModule_AddObject(m, "DNS_TYPE_NXT", PyLong_FromLong((uint16_t)(DNS_TYPE_NXT)));
	PyModule_AddObject(m, "DNS_TYPE_SRV", PyLong_FromLong((uint16_t)(DNS_TYPE_SRV)));
	PyModule_AddObject(m, "DNS_TYPE_ATMA", PyLong_FromLong((uint16_t)(DNS_TYPE_ATMA)));
	PyModule_AddObject(m, "DNS_TYPE_NAPTR", PyLong_FromLong((uint16_t)(DNS_TYPE_NAPTR)));
	PyModule_AddObject(m, "DNS_TYPE_CERT", PyLong_FromLong((uint16_t)(DNS_TYPE_CERT)));
	PyModule_AddObject(m, "DNS_TYPE_DNAME", PyLong_FromLong((uint16_t)(DNS_TYPE_DNAME)));
	PyModule_AddObject(m, "DNS_TYPE_DS", PyLong_FromLong((uint16_t)(DNS_TYPE_DS)));
	PyModule_AddObject(m, "DNS_TYPE_SSHFP", PyLong_FromLong((uint16_t)(DNS_TYPE_SSHFP)));
	PyModule_AddObject(m, "DNS_TYPE_IPSECKEY", PyLong_FromLong((uint16_t)(DNS_TYPE_IPSECKEY)));
	PyModule_AddObject(m, "DNS_TYPE_RRSIG", PyLong_FromLong((uint16_t)(DNS_TYPE_RRSIG)));
	PyModule_AddObject(m, "DNS_TYPE_NSEC", PyLong_FromLong((uint16_t)(DNS_TYPE_NSEC)));
	PyModule_AddObject(m, "DNS_TYPE_DNSKEY", PyLong_FromLong((uint16_t)(DNS_TYPE_DNSKEY)));
	PyModule_AddObject(m, "DNS_TYPE_DHCID", PyLong_FromLong((uint16_t)(DNS_TYPE_DHCID)));
	PyModule_AddObject(m, "DNS_TYPE_NSEC3", PyLong_FromLong((uint16_t)(DNS_TYPE_NSEC3)));
	PyModule_AddObject(m, "DNS_TYPE_NSEC3PARAM", PyLong_FromLong((uint16_t)(DNS_TYPE_NSEC3PARAM)));
	PyModule_AddObject(m, "DNS_TYPE_TLSA", PyLong_FromLong((uint16_t)(DNS_TYPE_TLSA)));
	PyModule_AddObject(m, "DNS_TYPE_CDS", PyLong_FromLong((uint16_t)(DNS_TYPE_CDS)));
	PyModule_AddObject(m, "DNS_TYPE_CDNSKEY", PyLong_FromLong((uint16_t)(DNS_TYPE_CDNSKEY)));
	PyModule_AddObject(m, "DNS_TYPE_SVCB", PyLong_FromLong((uint16_t)(DNS_TYPE_SVCB)));
	PyModule_AddObject(m, "DNS_TYPE_HTTPS", PyLong_FromLong((uint16_t)(DNS_TYPE_HTTPS)));
	PyModule_AddObject(m, "DNS_TYPE_ALL", PyLong_FromLong((uint16_t)(DNS_TYPE_ALL)));
	PyModule_AddObject(m, "DNS_TYPE_URI", PyLong_FromLong((uint16_t)(DNS_TYPE_URI)));
	PyModule_AddObject(m, "DNS_TYPE_CAA", PyLong_FromLong((uint16_t)(DNS_TYPE_CAA)));
	PyModule_AddObject(m, "DNS_TYPE_WINS", PyLong_FromLong((uint16_t)(DNS_TYPE_WINS)));
	PyModule_AddObject(m, "DNS_TYPE_WINSR", PyLong_FromLong((uint16_t)(DNS_TYPE_WINSR)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_SUPPRESS_NOTIFY", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_SUPPRESS_NOTIFY)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_AGING_ON", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_AGING_ON)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_OPEN_ACL", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_OPEN_ACL)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_RECORD_WIRE_FORMAT", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_RECORD_WIRE_FORMAT)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_SUPPRESS_RECORD_UPDATE_PTR", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_SUPPRESS_RECORD_UPDATE_PTR)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_NODE_COMPLETE", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_NODE_COMPLETE)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_NODE_STICKY", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_NODE_STICKY)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_RECORD_CREATE_PTR", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_RECORD_CREATE_PTR)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_RECORD_TTL_CHANGE", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_RECORD_TTL_CHANGE)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_RECORD_DEFAULT_TTL", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_RECORD_DEFAULT_TTL)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_ZONE_DELEGATION", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_ZONE_DELEGATION)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_AUTH_ZONE_ROOT", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_AUTH_ZONE_ROOT)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_ZONE_ROOT", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_ZONE_ROOT)));
	PyModule_AddObject(m, "DNS_RPC_FLAG_CACHE_DATA", PyLong_FromUnsignedLongLong((uint32_t)(DNS_RPC_FLAG_CACHE_DATA)));
	PyModule_AddObject(m, "DNS_RANK_NONE", PyLong_FromLong((uint16_t)(DNS_RANK_NONE)));
	PyModule_AddObject(m, "DNS_RANK_CACHE_BIT", PyLong_FromLong((uint16_t)(DNS_RANK_CACHE_BIT)));
	PyModule_AddObject(m, "DNS_RANK_ROOT_HINT", PyLong_FromLong((uint16_t)(DNS_RANK_ROOT_HINT)));
	PyModule_AddObject(m, "DNS_RANK_OUTSIDE_GLUE", PyLong_FromLong((uint16_t)(DNS_RANK_OUTSIDE_GLUE)));
	PyModule_AddObject(m, "DNS_RANK_CACHE_NA_ADDITIONAL", PyLong_FromLong((uint16_t)(DNS_RANK_CACHE_NA_ADDITIONAL)));
	PyModule_AddObject(m, "DNS_RANK_CACHE_NA_AUTHORITY", PyLong_FromLong((uint16_t)(DNS_RANK_CACHE_NA_AUTHORITY)));
	PyModule_AddObject(m, "DNS_RANK_CACHE_A_ADDITIONAL", PyLong_FromLong((uint16_t)(DNS_RANK_CACHE_A_ADDITIONAL)));
	PyModule_AddObject(m, "DNS_RANK_CACHE_NA_ANSWER", PyLong_FromLong((uint16_t)(DNS_RANK_CACHE_NA_ANSWER)));
	PyModule_AddObject(m, "DNS_RANK_CACHE_A_AUTHORITY", PyLong_FromLong((uint16_t)(DNS_RANK_CACHE_A_AUTHORITY)));
	PyModule_AddObject(m, "DNS_RANK_GLUE", PyLong_FromLong((uint16_t)(DNS_RANK_GLUE)));
	PyModule_AddObject(m, "DNS_RANK_NS_GLUE", PyLong_FromLong((uint16_t)(DNS_RANK_NS_GLUE)));
	PyModule_AddObject(m, "DNS_RANK_CACHE_A_ANSWER", PyLong_FromLong((uint16_t)(DNS_RANK_CACHE_A_ANSWER)));
	PyModule_AddObject(m, "DNS_RANK_ZONE", PyLong_FromLong((uint16_t)(DNS_RANK_ZONE)));
	PyModule_AddObject(m, "DNS_ZONE_TYPE_CACHE", PyLong_FromUnsignedLongLong((uint32_t)(DNS_ZONE_TYPE_CACHE)));
	PyModule_AddObject(m, "DNS_ZONE_TYPE_PRIMARY", PyLong_FromUnsignedLongLong((uint32_t)(DNS_ZONE_TYPE_PRIMARY)));
	PyModule_AddObject(m, "DNS_ZONE_TYPE_SECONDARY", PyLong_FromUnsignedLongLong((uint32_t)(DNS_ZONE_TYPE_SECONDARY)));
	PyModule_AddObject(m, "DNS_ZONE_TYPE_STUB", PyLong_FromUnsignedLongLong((uint32_t)(DNS_ZONE_TYPE_STUB)));
	PyModule_AddObject(m, "DNS_ZONE_TYPE_FORWARDER", PyLong_FromUnsignedLongLong((uint32_t)(DNS_ZONE_TYPE_FORWARDER)));
	PyModule_AddObject(m, "DNS_ZONE_TYPE_SECONDARY_CACHE", PyLong_FromUnsignedLongLong((uint32_t)(DNS_ZONE_TYPE_SECONDARY_CACHE)));
	PyModule_AddObject(m, "DNS_ZONE_UPDATE_OFF", PyLong_FromLong((uint16_t)(DNS_ZONE_UPDATE_OFF)));
	PyModule_AddObject(m, "DNS_ZONE_UPDATE_UNSECURE", PyLong_FromLong((uint16_t)(DNS_ZONE_UPDATE_UNSECURE)));
	PyModule_AddObject(m, "DNS_ZONE_UPDATE_SECURE", PyLong_FromLong((uint16_t)(DNS_ZONE_UPDATE_SECURE)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_EMPTY", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_EMPTY)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_TYPE", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_TYPE)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_ALLOW_UPDATE", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_ALLOW_UPDATE)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_SECURE_TIME", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_SECURE_TIME)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_NOREFRESH_INTERVAL", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_NOREFRESH_INTERVAL)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_SCAVENGING_SERVERS", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_SCAVENGING_SERVERS)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_AGING_ENABLED_TIME", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_AGING_ENABLED_TIME)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_REFRESH_INTERVAL", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_REFRESH_INTERVAL)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_AGING_STATE", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_AGING_STATE)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_MASTER_SERVERS", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_MASTER_SERVERS)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_AUTO_NS_SERVERS", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_AUTO_NS_SERVERS)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_DCPROMO_CONVERT", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_DCPROMO_CONVERT)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_MASTER_SERVERS_DA", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_MASTER_SERVERS_DA)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_NS_SERVERS_DA", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_NS_SERVERS_DA)));
	PyModule_AddObject(m, "DSPROPERTY_ZONE_NODE_DBFLAGS", PyLong_FromUnsignedLongLong((uint32_t)(DSPROPERTY_ZONE_NODE_DBFLAGS)));
	PyModule_AddObject(m, "DCPROMO_CONVERT_NONE", PyLong_FromLong((uint16_t)(DCPROMO_CONVERT_NONE)));
	PyModule_AddObject(m, "DCPROMO_CONVERT_DOMAIN", PyLong_FromLong((uint16_t)(DCPROMO_CONVERT_DOMAIN)));
	PyModule_AddObject(m, "DCPROMO_CONVERT_FOREST", PyLong_FromLong((uint16_t)(DCPROMO_CONVERT_FOREST)));
	Py_INCREF((PyObject *)(void *)&dnsp_soa_Type);
	PyModule_AddObject(m, "soa", (PyObject *)(void *)&dnsp_soa_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_mx_Type);
	PyModule_AddObject(m, "mx", (PyObject *)(void *)&dnsp_mx_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_hinfo_Type);
	PyModule_AddObject(m, "hinfo", (PyObject *)(void *)&dnsp_hinfo_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_srv_Type);
	PyModule_AddObject(m, "srv", (PyObject *)(void *)&dnsp_srv_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_ip4_array_Type);
	PyModule_AddObject(m, "ip4_array", (PyObject *)(void *)&dnsp_ip4_array_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_dns_addr_Type);
	PyModule_AddObject(m, "dns_addr", (PyObject *)(void *)&dnsp_dns_addr_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_dns_addr_array_Type);
	PyModule_AddObject(m, "dns_addr_array", (PyObject *)(void *)&dnsp_dns_addr_array_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_string_list_Type);
	PyModule_AddObject(m, "string_list", (PyObject *)(void *)&dnsp_string_list_Type);
	Py_INCREF((PyObject *)(void *)&dnsRecordData_Type);
	PyModule_AddObject(m, "dnsRecordData", (PyObject *)(void *)&dnsRecordData_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_DnssrvRpcRecord_Type);
	PyModule_AddObject(m, "DnssrvRpcRecord", (PyObject *)(void *)&dnsp_DnssrvRpcRecord_Type);
	Py_INCREF((PyObject *)(void *)&dnsPropertyData_Type);
	PyModule_AddObject(m, "dnsPropertyData", (PyObject *)(void *)&dnsPropertyData_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_DnsProperty_Type);
	PyModule_AddObject(m, "DnsProperty", (PyObject *)(void *)&dnsp_DnsProperty_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_DnsProperty_short_Type);
	PyModule_AddObject(m, "DnsProperty_short", (PyObject *)(void *)&dnsp_DnsProperty_short_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_InterfaceType);
	PyModule_AddObject(m, "dnsp", (PyObject *)(void *)&dnsp_InterfaceType);
	Py_INCREF((PyObject *)(void *)&dnsp_SyntaxType);
	PyModule_AddObject(m, "dnsp_abstract_syntax", (PyObject *)(void *)&dnsp_SyntaxType);
	Py_INCREF((PyObject *)(void *)&dnsp_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&dnsp_SyntaxType);
#ifdef PY_MOD_DNSP_PATCH
	PY_MOD_DNSP_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
